#ifndef SFNTTYPES_H
#define SFNTTYPES_H

#ifndef CORESERVICES_H
#include <CoreServices/CoreServices.h>
#endif


#include <AvailabilityMacros.h>
#include <HYS/ATS/SFNTTypes.h>

#if PRAGMA_ONCE
#pragma once
#endif

/*ATSUGetIndFontTracking

Obtains the name code and tracking value for the font tracking that matches an ASTUI font ID, glyph orientation, and tracking table index.

OSStatus ATSUGetIndFontTracking (
   ATSUFontID iFont,
   ATSUVerticalCharacterType iCharacterOrientation,
   ItemCount iTrackIndex,
   Fixed *oFontTrackingValue,
   FontNameCode *oNameCode
);
Parameters
iFont

The ATSUFontID value of the font tracking for which to obtain a name code and tracking value. Note that because Apple Type Services assigns ATSUFontID values systemwide at runtime, font IDs can change across system restarts. 
iCharacterOrientation

An ATSUVerticalCharacterType constant identifying the glyph orientation of the font tracking value to obtain, for example kATSUStronglyHorizontal or kATSUStronglyVertical. See “Vertical Character Types” for a description of possible values.
iTrackIndex

An ItemCount value providing an index to the font tracking for which to obtain information. Because this index must be 0-based, you should pass a value between 0 and one less than the count produced by the function ATSUCountFontTracking.
oFontTrackingValue

A pointer to a Fixed value. On return, the value contains the font tracking value. 
oNameCode

A pointer to a FontNameCode value. On return, the value contains the name code for the font tracking. The FontNameCode is a UInt32 data type, and it is defined in the SFNTTypes.h header file.
Return Value

A result code. See “ATSUI Result Codes”.
Discussion

You can call the ATSUGetIndFontTracking function to obtain the name code and tracking value that matches the specified ATSUI font ID, glyph orientation, and tracking table index value.

You can use the function ATSUFindFontName to obtain the localized name string for the name code produced by ATSUGetIndFontTracking.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeFonts.h*/
typedef UInt32 FontNameCode;

#endif