@interface NSGraphicsContext (hys)

/*compositingOperation

Returns the receiver’s global compositing operation setting.

-(NSCompositingOperation)compositingOperation
Return Value

The receiver’s global compositing operation setting. See NSCompositingOperation for valid constants.
Discussion

The compositing operation is a global attribute of the graphics context and affects drawing operations that do not take an explicit compositing operation parameter. For methods that do take an explicit compositing operation parameter, the value of that parameter supersedes the global value.

The compositing operations are related to (but different from) the blend mode settings used in Quartz. Only the default compositing operation (NSCompositeCopy) is supported for PDF or PostScript content. 
Availability
Available in Mac OS X v10.4 and later.
See Also
– setCompositingOperation:*/
-(NSCompositingOperation)compositingOperation;

@end