#include <SystemConfiguration/SystemConfiguration.h>


/*SCDynamicStoreCopyProxies

CFDictionaryRef SCDynamicStoreCopyProxies ( 
    SCDynamicStoreRef store );  
Parameters
store
An SCDynamicStoreRef representing the dynamic store session that should be used for communication with the server. If NULL, a temporary session will be used.
Return Value

Returns a dictionary containing key-value pairs that represent the current internet proxy settings; NULL if no proxy settings have been defined or if an error was encountered. You must release the returned value. 
Discussion 

Gets the current internet proxy settings. The returned proxy settings dictionary includes: 
key 	type 	description 
kSCPropNetProxiesExceptionsList	CFArray[CFString]	Host name patterns which should bypass the proxy
kSCPropNetProxiesHTTPEnable	CFNumber (0 or 1)	Enables/disables the use of an HTTP proxy
kSCPropNetProxiesHTTPProxy	CFString	The proxy host
kSCPropNetProxiesHTTPPort	CFNumber	The proxy port number
kSCPropNetProxiesHTTPSEnable	CFNumber (0 or 1)	Enables/disables the use of an HTTPS proxy
kSCPropNetProxiesHTTPSProxy	CFString	The proxy host
kSCPropNetProxiesHTTPSPort	CFNumber	The proxy port number
kSCPropNetProxiesFTPEnable	CFNumber (0 or 1)	Enables/disables the use of an FTP proxy
kSCPropNetProxiesFTPProxy	CFString	The proxy host
kSCPropNetProxiesFTPPort	CFNumber	The proxy port number
kSCPropNetProxiesFTPPassive	CFNumber (0 or 1)	Enable passive mode operation for use behind connection filter-ing firewalls.



Other key-value pairs are defined in the SCSchemaDefinitions.h header file.*/
CFDictionaryRef SCDynamicStoreCopyProxies (
    SCDynamicStoreRef store ){};

/*kSCPropNetProxiesFTPPassive


"FTPPassive" 
extern const CFStringRef kSCPropNetProxiesFTPPassive;  
Availability
Introduced in Mac OS X 10.1.*/
 const CFStringRef kSCPropNetProxiesFTPPassive ;



/*SCNetworkReachabilityCreateWithName

SCNetworkReachabilityRef SCNetworkReachabilityCreateWithName ( 
    CFAllocatorRef allocator, 
    const char *nodename );  
Parameters
nodename
The node name of the desired host. This name would be the same as that passed to the gethostbyname(3) or getaddrinfo(3) functions.
Return Value

Returns a reference to the new immutable SCNetworkReachabilityRef. 

You must release the returned value. 
Discussion 

Creates a reference to the specified network host or node name. This reference can be used later to monitor the reachability of the target host. 
Availability
Introduced in Mac OS X v10.3.*/
SCNetworkReachabilityRef SCNetworkReachabilityCreateWithName ( 
    CFAllocatorRef allocator, 
    const char *nodename ){};



/*SCError

int SCError ();  
Return Value

Returns the last error encountered. 
Discussion 

Returns the most recent status or error code generated as the result of calling a System Configuration framework API.*/
int SCError (){};

/*SCNetworkReachabilitySetCallback

Boolean SCNetworkReachabilitySetCallback ( 
    SCNetworkReachabilityRef target, 
    SCNetworkReachabilityCallBack callout, 
    SCNetworkReachabilityContext *context );  
Parameters
target
The network reference associated with the address or name to be checked for reachability.
callout
The function to be called when the reachability of the target changes. If NULL, the current client for the target is removed.
context
The SCNetworkReachabilityContext associated with the callout. The value may be NULL.
Return Value

Returns TRUE if the notification client was successfully set. 
Discussion 

Assigns a client to a target, which receives callbacks when the reachability of the target changes. 
Availability
Introduced in Mac OS X v10.3.*/

Boolean SCNetworkReachabilitySetCallback ( 
    SCNetworkReachabilityRef target, 
    SCNetworkReachabilityCallBack callout, 
    SCNetworkReachabilityContext *context ){};


/*SCNetworkReachabilityUnscheduleFromRunLoop

Boolean SCNetworkReachabilityUnscheduleFromRunLoop ( 
    SCNetworkReachabilityRef target, 
    CFRunLoopRef runLoop, 
    CFStringRef runLoopMode );  
Parameters
target
The address or name that is set up for asynchronous notifications. Must be non-NULL.
runLoop
A reference to a run loop from which the target should be unscheduled. Must be non-NULL.
runLoopMode
The mode on which to unschedule the target. Must be non-NULL.
Return Value

Returns TRUE if the target is unscheduled successfully; FALSE otherwise. 
Discussion 

Unschedules the given target from the given run loop and mode. 
Availability
Introduced in Mac OS X v10.3.*/
Boolean SCNetworkReachabilityUnscheduleFromRunLoop ( 
    SCNetworkReachabilityRef target, 
    CFRunLoopRef runLoop, 
    CFStringRef runLoopMode ){};


/*SCNetworkReachabilityScheduleWithRunLoop

Boolean SCNetworkReachabilityScheduleWithRunLoop ( 
    SCNetworkReachabilityRef target, 
    CFRunLoopRef runLoop, 
    CFStringRef runLoopMode );  
Parameters
target
The address or name that is set up for asynchronous notifications. Must be non-NULL.
runLoop
A reference to a run loop on which the target should be scheduled. Must be non-NULL.
runLoopMode
The mode on which to schedule the target. Must be non-NULL.
Return Value

Returns TRUE if the target is scheduled successfully; FALSE otherwise. 
Discussion 

Schedules the given target with the given run loop and mode. 
Availability
Introduced in Mac OS X v10.3.*/
Boolean SCNetworkReachabilityScheduleWithRunLoop ( 
    SCNetworkReachabilityRef target,
    CFRunLoopRef runLoop,
    CFStringRef runLoopMode ){};


/*SCNetworkReachabilityGetFlags

Boolean SCNetworkReachabilityGetFlags ( 
    SCNetworkReachabilityRef target, 
    SCNetworkConnectionFlags *flags );  
Parameters
target
The network reference associated with the address or name to be checked for reachability.
flags
A pointer to memory that will be filled with the SCNetworkConnectionFlags detailing the reachability of the specified target.
Return Value

Returns TRUE if the network connection flags are valid; FALSE if the status could not be determined. 
Discussion 

Determines if the given target is reachable using the current network configuration. 
Availability
Introduced in Mac OS X v10.3.*/
Boolean SCNetworkReachabilityGetFlags ( 
    SCNetworkReachabilityRef target, 
    SCNetworkConnectionFlags *flags ){};






