#ifndef QUICKDRAW_H
#include <QD/QD.h>
#endif
int InitCursor(){};
int InitGraf(int a){};
int InitFonts(){};
int TextFont(int a){};
int TextSize(int a){};
int DrawString(int a){};



/*DisposeGWorld

Disposes of all the memory allocated for an offscreen graphics world. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void DisposeGWorld (
   GWorldPtr offscreenGWorld
);
Parameters
offscreenGWorld

A pointer to an offscreen graphics world. In this parameter, pass the pointer returned to your application by the NewGWorld function when you created the offscreen graphics world. 
Discussion

The DisposeGWorld function disposes of all the memory allocated for the specified offscreen graphics world, including the pixel map, color table, pixel image, and GDevice structure (if one was created).

Call DisposeGWorld only when your application no longer needs the pixel image associated with this offscreen graphics world. If this offscreen graphics world was the current device, the current device is reset to the device stored in the global variable MainDevice. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
QDOffscreen.h*/
void DisposeGWorld (GWorldPtr offscreenGWorld){
//TODO
};
/*FrameRoundRect

Draws an outline inside a rounded rectangle. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void FrameRoundRect (
   const Rect * r,
   short ovalWidth,
   short ovalHeight
);
Parameters
r

The rectangle that defines the rounded rectangle’s boundaries.
ovalWidth

The width of the oval defining the rounded corner.
ovalHeight

The height of the oval defining the rounded corner.
Discussion

Using the pattern, pattern mode, and size of the graphics pen for the current graphics port, the FrameRoundRect function draws an outline just inside the rounded rectangle bounded by the rectangle that you specify in the r parameter. The outline is as wide as the pen width and as tall as the pen height. The pen location does not change. 

Use the ovalWidth and ovalHeight parameters to specify the diameters of curvature for the corners of the rounded rectangle.

If a region is open and being formed, the outside outline of the new rounded rectangle is mathematically added to the region’s boundary. 
Special Considerations

The FrameRoundRect function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void FrameRoundRect (
   const Rect * r,
   short ovalWidth,
   short ovalHeight
){};





/*SetRect

Assigns coordinates to a rectangle. 

void SetRect (
   Rect * r,
   short left,
   short top,
   short right,
   short bottom
);
Parameters
r

A pointer to the rectangle to set.
left

The horizontal coordinate of the new upper-left corner of the rectangle.
top

The vertical coordinate of the new upper-left corner of the rectangle.
right

The horizontal coordinate of the new lower-right corner of the rectangle.
bottom

The vertical coordinate of the new lower-right corner of the rectangle.
Discussion

The SetRect function assigns the coordinates you specify in the left, top, right, and bottom parameters to the rectangle that you specify in the r parameter. This function is provided to help you shorten your program text. If you want a more readable text, at the expense of source text length, you can instead assign integers (or points) directly into the fields of a Rect structure.

You can use a rectangle to specify locations and sizes for various graphics operations.

If the points or rectangles supplied to this function are defined in a graphics port other than your current graphics port, you must convert them to the local coordinate system of your current graphics port. You can accomplish this by using the SetPort function to change to the graphics port containing the points or rectangles, using the LocalGlobal function to convert their locations to global coordinates, using SetPort to return to your starting graphics port, and then using the GlobalToLocal function to convert the locations of points or rectangles to the local coordinates of your current graphics port. 
Declared In
Quickdraw.h*/
void SetRect (
   Rect * r,
   short left,
   short top,
   short right,
   short bottom){
//TODO
};


/*LockPixels

Prevents the base address for an offscreen pixel image from being moved while you draw into or copy from its pixel map. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

Boolean LockPixels (
   PixMapHandle pm
);
Parameters
pm

A handle to an offscreen pixel map. To get a handle to an offscreen pixel map, use the GetGWorldPixMap function . 
Return Value

If the base address for an offscreen pixel image hasn’t been purged by the Memory Manager or is not purgeable, LockPixels returns TRUE as its function result, and your application can draw into or copy from the offscreen pixel map. However, if the base address for an offscreen pixel image has been purged, LockPixels returns FALSE to indicate that you can perform no drawing to or copying from the pixel map. At that point, your application should either call the UpdateGWorld function to reallocate the offscreen pixel image and then reconstruct it, or draw directly in a window instead of preparing the image in an offscreen graphics world. 
Discussion

You must call LockPixels before drawing to or copying from an offscreen graphics world. 

The baseAddr field of the PixMap structure for an offscreen graphics world contains a handle instead of a pointer (which is what the baseAddr field for an onscreen pixel map contains). The LockPixels function dereferences the PixMap handle into a pointer. When you use the UnlockPixels function the handle is recovered.

As soon as you are finished drawing into and copying from the offscreen pixel image, call the UnlockPixels function. 
Special Considerations

The LockPixels function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
QDOffscreen.h*/
Boolean LockPixels (
   PixMapHandle pm){
//TODO
};


/*GetGWorldPixMap

Obtains the pixel map created for an offscreen graphics world. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

PixMapHandle GetGWorldPixMap (
   GWorldPtr offscreenGWorld
);
Parameters
offscreenGWorld

A pointer to an offscreen graphics world. Pass the pointer returned to your application by the NewGWorld function when you created the offscreen graphics world. 
Return Value

A handle to the pixel map created for an offscreen graphics world. Your application can, in turn, pass the handle returned by GetGWorldPixMap as a parameter to other QuickDraw functions that accept a handle to a pixel map.

On a system running only basic QuickDraw, the GetGWorldPixMap function returns the handle to a 1-bit pixel map that your application can supply as a parameter to the other functions related to offscreen graphics worlds. However, your application should not supply this handle to color QuickDraw functions.

Special Considerations

To ensure compatibility on systems running basic QuickDraw instead of Color QuickDraw, use GetGWorldPixMap whenever you need to gain access to the bitmap created for a graphics world—that is, do not dereference the GWorldPtr structure for that graphics world.
Version Notes

The GetGWorldPixMap function is not available in systems preceding System 7. You can make sure that the GetGWorldPixMap function is available by using the Gestalt function with the gestaltSystemVersion selector. Test the low-order word in the response parameter; if the value is $0700 or greater, then GetGWorldPixMap is available.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
QDOffscreen.h*/
PixMapHandle GetGWorldPixMap (
   GWorldPtr offscreenGWorld){
//TODO
};


/*GetGWorldDevice

Obtains a handle to the GDevice structure associated with an offscreen graphics world. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

GDHandle GetGWorldDevice (
   GWorldPtr offscreenGWorld
);
Parameters
offscreenGWorld

A pointer to an offscreen graphics world. The pointer returned to your application by the NewGWorld function. 
Return Value

A handle to the GDevice structure associated with the offscreen graphics world specified by the offscreenGWorld parameter. 


If you created the offscreen world by specifying the noNewDevice flag, the GDevice structure is for one of the screen devices or is the GDevice structure that you specified to NewGWorld or UpdateGWorld.

If you point to a GrafPort or CGrafPort structure in the offscreenGWorld parameter, GetGWorldDevice returns the current device.

Special Considerations

The GetGWorldDevice function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
QDOffscreen.h*/
GDHandle GetGWorldDevice (
   GWorldPtr offscreenGWorld){
//TODO
};


/*GetGWorld

Saves the current graphics port (basic, color, or offscreen) and the current GDevice structure. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void GetGWorld (
   CGrafPtr * port,
   GDHandle * gdh
);
Parameters
port

On return, a pointer to the current graphics port in the port parameter. This parameter can return values of type GrafPtr, CGrafPtr, or GWorldPtr, depending on whether the current graphics port is a basic graphics port, color graphics port, or offscreen graphics world. 
gdh

On return, a pointer to a handle to the GDevice structure for the current device. 
Discussion

After using GetGWorld to save a graphics port and a GDevice structure, use the SetGWorld function to restore them. 
Special Considerations

The GetGWorld function may move or purge memory blocks in the application heap. Your application should not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
QDOffscreen.h*/
void GetGWorld (
   CGrafPtr * port,
   GDHandle * gdh){
//TODO
};


/*SetGWorld

Changes the current graphics port (basic, color, or offscreen). (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void SetGWorld (
   CGrafPtr port,
   GDHandle gdh
);
Parameters
port

A pointer to an offscreen graphics world, color graphics port, or basic graphics port. Specify values of type GrafPtr, CGrafPtr, or GWorldPtr, depending on whether you want to set the current graphics port to be a basic graphics port, color graphics port, or offscreen graphics world. Any drawing your application performs then occurs in this graphics port. 
gdh

A handle to a GDevice structure. If you pass a pointer to an offscreen graphics world in the port parameter, set this parameter to NULL, because SetGWorld ignores this parameter and sets the current device to the device attached to the offscreen graphics world. 
Discussion

The SetGWorld function sets the current graphics port to the one specified by the port parameter and—unless you set the current graphics port to be an offscreen graphics world—sets the current device to that specified by the gdh parameter. 
Special Considerations

The SetGWorld function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
QDOffscreen.h*/

void SetGWorld (
   CGrafPtr port,
   GDHandle gdh){
//TODO
};


/*GetPortBounds

(Deprecated. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

Rect * GetPortBounds (
   CGrafPtr port,
   Rect * rect
);
Carbon Porting Notes

Use this new accessor function in place of direct access to structs.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Quickdraw.h*/

Rect * GetPortBounds (
   CGrafPtr port,
   Rect * rect){
//TODO
};

/*EraseRect

Erases a rectangle. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void EraseRect (
   const Rect * r
);
Parameters
r

The rectangle to erase.
Discussion

Using the patCopy pattern mode, the EraseRect function draws the interior of the rectangle that you specify in the r parameter with the background pattern for the current graphics port. This effectively erases the rectangle, making the shape blend into the background pattern of the graphics port. For example, use EraseRect to erase the port rectangle for a window before redrawing into the window.

This function leaves the location of the graphics pen unchanged. 
Special Considerations

The EraseRect function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void EraseRect (
   const Rect * r){
//TODO
};

/*CopyBits

Copies a portion of a bitmap or a pixel map from one graphics port or offscreen graphics world into another graphics port. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void CopyBits (
   const BitMap * srcBits,
   const BitMap * dstBits,
   const Rect * srcRect,
   const Rect * dstRect,
   short mode,
   RgnHandle maskRgn
);
Parameters
srcBits

The source BitMap structure. 
dstBits

The destination BitMap structure.
srcRect

The source rectangle.
dstRect

The destination rectangle.
mode

One of the eight source modes in which the copy is to be performed. See Source, Pattern, and Arithmetic Transfer Mode Constants. The CopyBits function always dithers images when shrinking them between pixel maps on direct devices. 

When transferring pixels from a source pixel map to a destination pixel map, color QuickDraw interprets the source mode constants differently than basic QuickDraw does.

When you use CopyBits on a computer running color QuickDraw, you can also specify one of the transfer modes in the mode parameter.
maskRgn

A region to use as a clipping mask. You can pass a region handle to specify a mask region the resulting image is always clipped to this mask region and to the boundary rectangle of the destination bitmap. If the destination bitmap is the current graphics port’s bitmap, it is also clipped to the intersection of the graphics port’s clipping region and visible region. If you do not want to clip to a masking region, just pass NULL for this parameter. 
Discussion

The CopyBits function transfers any portion of a bitmap between two basic graphics ports, or any portion of a pixel map between two color graphics ports. Use CopyBits to move offscreen graphic images into an onscreen window, to blend colors for the image in a pixel map, and to shrink and expand images.

Specify a source bitmap in the srcBits parameter and a destination bitmap in the dstBits parameter. When copying images between color graphics ports, you must coerce each CGrafPort structure to a GrafPort structure, dereference the portBits fields of each, and then pass these “bitmaps” in the srcBits and dstBits parameters. If your application copies a pixel image from a color graphics port called MyColorPort, for example, you could specify (* GrafPtr(MyColorPort)).portBits in the srcBits parameter. In a CGrafPort structure, the high 2 bits of the portVersion field are set. This field, which shares the same position in a CGrafPort structure as the portBits.rowBytes field in a GrafPort structure, indicates to CopyBits that you have passed it a handle to a pixel map rather than a bitmap.

Using the srcRect and dstRect parameters, you can specify identically or differently sized source and destination rectangles; for differently sized rectangles, CopyBits scales the source image to fit the destination. If the bit image is a circle in a square source rectangle, and the destination rectangle is not square, the bit image appears as an oval in the destination. When you specify rectangles in the srcRect and dstRect parameters, use the local coordinate systems of, respectively, the source and destination graphics ports.

The CopyDeepMask function combines the functions of the CopyBits and CopyMask functions. 
Special Considerations

When you use the CopyBits function to transfer an image between pixel maps, the source and destination images may be of different pixel depths, of different sizes, and they may have different color tables. However, CopyBits assumes that the destination pixel map uses the same color table as the color table for the current GDevice structure. (This is because the Color Manager requires an inverse table for translating the color table from the source pixel map to the destination pixel map.) 

The CopyBits function applies the foreground and background colors of the current graphics port to the image in the destination pixel map (or bitmap), even if the source image is a bitmap. This causes the foreground color to replace all black pixels in the destination and the background color to replace all white pixels. To avoid unwanted coloring of the image, use the RGBForeColor function to set the foreground to black and use the RGBBackColor function to set the background to white before calling CopyBits.

The source bitmap or pixel map must not occupy more memory than half the available stack space. The stack space required by CopyBits is roughly five times the value of the rowBytes field of the source pixel map: one rowBytes value for the pixel map (or bitmap), an additional rowBytes value for dithering, another rowBytes value when stretching or shrinking the source pixel map into the destination, another rowBytes value for any color map changing, and a fifth additional rowBytes value for any color aliasing. If there is insufficient memory to complete a CopyBits operation in Color QuickDraw, the QDError function returns the result code –143.

If you use CopyBits to copy between two graphics ports that overlap, you must first use the LocalToGlobal function to convert to global coordinates, and then specify the global variable screenBits for both the srcBits and dstBits parameters.

The CopyBits function may move or purge memory blocks in the application heap; do not call this function at interrupt time.

If you are reading directly from a NuBus video card with a base address of Fs00000 and there is not a card in the slot (s–1) below it, CopyBits reads addresses less than the base address of the pixel map. This causes a bus error. To work around the problem, remap the baseAddr field of the pixel map in your video card to at least 20 bytes above the NuBus boundary; an address link of Fs000020 precludes the problem.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void CopyBits (
   const BitMap * srcBits,
   const BitMap * dstBits,
   const Rect * srcRect,
   const Rect * dstRect,
   short mode,
   RgnHandle maskRgn){
//TODO
};


/*QDFlushPortBuffer

Calls the Quartz compositor to flush all new drawing in a Carbon window to the display. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void QDFlushPortBuffer (
   CGrafPtr port,
   RgnHandle region
);
Parameters
port

A window port. If the port has no back buffer, or if the port is an offscreen or printing port, this function does nothing.
region

An update region. Under normal conditions, you should pass NULL to avoid the overhead of additional region operations.
Discussion

In Mac OS X, drawing in a window port updates a back buffer associated with the window. Updates to this buffer are accumulated in a list called the dirty region. 

The back buffer is automatically flushed to the display each time through the event loop. When the event loop does not get control soon enough—for example, during an animation sequence—you can call this function to flush the port buffer to the device immediately. 

When you call this function, there are several different execution paths:
If the region parameter is NULL, the dirty region is flushed—along with any Quartz 2D drawing operations marked for update by calls to CGContextSynchronize—and the dirty region is set to empty.
If the region parameter specifies an update region, the intersection of the dirty region and the update region is flushed—along with any Quartz 2D drawing operations marked for update by calls to CGContextSynchronize—and the flushed region is subtracted from the dirty region.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void QDFlushPortBuffer (
   CGrafPtr port,
   RgnHandle region){
//TODO
};

/*UnlockPixels

Allows the Memory Manager to move the base address for the offscreen pixel map that you specify in the pm parameter. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void UnlockPixels (
   PixMapHandle pm
);
Parameters
pm

A handle to an offscreen pixel map. Pass the same handle that you passed previously to the LockPixels function. 
Discussion

To ensure the integrity of the data in a pixel image, call LockPixels before drawing into or copying from a pixel map; then, to prevent heap fragmentation, call UnlockPixels as soon as your application finishes drawing to and copying from the offscreen pixel map. 

The baseAddr field of the PixMap structure for an offscreen graphics world contains a handle instead of a pointer (which is what the baseAddr field for an onscreen pixel map contains). The LockPixels function dereferences the PixMap handle into a pointer. When you use the UnlockPixels function, the handle is recovered.

You don’t need to call UnlockPixels if LockPixels returns FALSE, because LockPixels doesn’t lock the memory for a pixel image if that memory has been purged. However, calling UnlockPixels on purged memory does no harm. 
Special Considerations

The UnlockPixels function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
QDOffscreen.h*/
void UnlockPixels (
   PixMapHandle pm){
//TODO
};

/*SetPort

Changes the current graphics port (basic or color). (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void SetPort (
   GrafPtr port
);
Parameters
port

A pointer to a GrafPort structure. Typically, you pass a pointer to a GrafPort structure that you previously saved with the GetPort function. The SetPort function sets this structure to be the current graphics port. 
Discussion

All QuickDraw drawing functions affect the bitmap of, and use the local coordinate system of, the current graphics port. Each graphics port has its own graphics pen and text characteristics, which remain unchanged when the graphics port isn’t selected as the current graphics port.

When your application runs in Color QuickDraw or uses offscreen graphics worlds, it should use the SetGWorld function instead of SetPort. The SetGWorld function restores the current graphics port for basic and color graphics ports as well as offscreen graphics worlds. 
Availability
Deprecated in Mac OS X v10.4.
Available in Mac OS X v10.0 and later.
Declared In
Quickdraw.h*/
void SetPort (
   GrafPtr port){
//TODO
};

/*GetPixBaseAddr

Obtains a pointer to an offscreen pixel map. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

Ptr GetPixBaseAddr (
   PixMapHandle pm
);
Parameters
pm

A handle to an offscreen pixel map. To get a handle to an offscreen pixel map, use the GetGWorldPixMap function. 
Return Value

A 32-bit pointer to the beginning of a pixel image. If the offscreen buffer has been purged, GetPixBaseAddr returns NULL. 
Discussion

The baseAddr field of the PixMap structure for an offscreen graphics world contains a handle instead of a pointer, which is what the baseAddr field for an onscreen pixel map contains. You must use the GetPixBaseAddr function to obtain a pointer to the PixMap structure for an offscreen graphics world.

Your application should never directly access the baseAddr field of the PixMap structure for an offscreen graphics world; instead, always use GetPixBaseAddr. If your application is using 24-bit mode, use the PixMap32Bit function to determine whether a pixel map requires 32-bit addressing mode for access to its pixel image. 
Special Considerations

Any QuickDraw functions that your application uses after calling GetPixBaseAddr may change the base address for the offscreen pixel image.

The GetPixBaseAddr function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
QDOffscreen.h*/
Ptr GetPixBaseAddr (
   PixMapHandle pm
){};

/*GetPort

Saves the current graphics port (basic or color). (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void GetPort (
   GrafPtr * port
);
Parameters
port

On return, a pointer to a GrafPort structure for the current graphics port. If the current graphics port is a color graphics port, GetPort coerces its CGrafPort structure into a GrafPort structure. 
Discussion

When your application runs in Color QuickDraw or uses offscreen graphics worlds, it should use the GetGWorld function instead of GetPort. The GetGWorld function saves the current graphics port for basic and color graphics ports as well as offscreen graphics worlds. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void GetPort (
   GrafPtr * port
){};


/*GlobalToLocal

Converts the coordinates of a point from global coordinates to the local coordinates of the current graphics port (basic or color). (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void GlobalToLocal (
   Point * pt
);
Parameters
pt

A pointer to a point expressed in global coordinates (where the upper-left corner of the main screen has coordinates [0,0]). On return, this point is converted to local coordinates.
Discussion

The GlobalToLocal procedure takes a point expressed in global coordinates (where the upper-left corner of the main screen has coordinates [0,0]) and converts it into the local coordinates of the current graphics port. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void GlobalToLocal (
   Point * pt
){};


/*GetPenState

Determines the graphics pen’s location, size, pattern, and pattern mode. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void GetPenState (
   PenState * pnState
);
Parameters
pnState

On return, a pointer to a PenState structure holding information about the graphics pen. The GetPenState function saves the location, size, pattern, and pattern mode of the graphics pen for the current graphics port in this structure. 
Discussion

After changing the graphics pen as necessary, restore these pen states with the SetPenState function. 

This pen-manipulation function uses the local coordinate system of the current graphics port. Remember that each graphics port has its own pen, the state of which is stored in several fields of its GrafPort or CGrafPort structure. If you draw in one graphics port, change to another, and return to the first, the pen for the first graphics port has the same state as when you left it. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void GetPenState (
   PenState * pnState
){};

/*PenSize

Sets the dimensions of the graphics pen in the current graphics port. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void PenSize (
   short width,
   short height
);
Parameters
width

The pen width, as an integer from 0 to 32,767. If you set the value to 0, the pen does not draw. Values less than 0 are undefined.
height

The pen height, as an integer from 0 to 32,767. If you set the value to 0, the pen does not draw. Values less than 0 are undefined.
Discussion

The PenSize function sets the width that you specify in the width parameter and the height that you specify in the height parameter for the graphics pen in the current graphics port. All subsequent calls to the Line and LineTo functions and to the functions that draw framed shapes in the current graphics port use the new pen dimensions.

You can get the current pen dimensions from the pnSize field of the current graphics port, where the width and height are stored as a Point structure.

This pen-manipulation function uses the local coordinate system of the current graphics port. Remember that each graphics port has its own pen, the state of which is stored in several fields of its GrafPort or CGrafPort structure. If you draw in one graphics port, change to another, and return to the first, the pen for the first graphics port has the same state as when you left it. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void PenSize (
   short width,
   short height
){};


/*PenPat

Sets the bit pattern to be used by the graphics pen in the current graphics port. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void PenPat (
   const Pattern * pat
);
Parameters
pat

A bit pattern, as defined by a Pattern structure. 
Discussion

The PenPat function sets the graphics pen to use the bit pattern defined in the Pattern structure that you specify in the pat parameter. (The standard patterns white, black, gray, ltGray, and dkGray are predefined; the initial bit pattern for the pen is black.) This pattern is stored in the pnPat field of a GrafPort structure. The QuickDraw painting functions (such as PaintRect) also use the pen’s pattern when drawing a shape.

The PenPat function also sets a bit pattern for the graphics pen in a color graphics port. The PenPat function creates a handle, of type PixPatHandle, for the bit pattern and stores this handle in the pnPixPat field of the CGrafPort structure. This pattern always uses the graphics port’s current foreground and background colors.

To define your own patterns, you typically create pattern, ‘PAT’, or pattern list, ‘PAT#’, resources. 
Special Considerations

The PenPat function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void PenPat (
   const Pattern * pat
){};


/*SetPenState

Restores the state of the graphics pen that was saved with the GetPenState function. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void SetPenState (
   const PenState * pnState
);
Parameters
pnState

A PenState structure previously created with the GetPenState function. The SetPenState function sets the graphics pen’s location, size, pattern, and pattern mode in the current graphics port to the values stored in this structure. 
Discussion

This pen-manipulation function uses the local coordinate system of the current graphics port. Remember that each graphics port has its own pen, the state of which is stored in several fields of its GrafPort or CGrafPort structure. If you draw in one graphics port, change to another, and return to the first, the pen for the first graphics port has the same state as when you left it. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

void SetPenState (
   const PenState * pnState
){};


/*PtInRect

Determines whether a pixel below is enclosed in a rectangle. 

Boolean PtInRect (
   Point pt,
   const Rect * r
);
Parameters
pt

The point to test.
r

The rectangle to test.
Return Value

TRUE if the pixel below and to the right of the point specified in the pt parameter is enclosed in the rectangle specified in the r parameter. FALSE if it is not. 
Discussion

If the points or rectangles supplied to this function are defined in a graphics port other than your current graphics port, you must convert them to the local coordinate system of your current graphics port. You can accomplish this by using the SetPort function to change to the graphics port containing the points or rectangles, using the LocalGlobal function to convert their locations to global coordinates, using SetPort to return to your starting graphics port, and then using the GlobalToLocal function to convert the locations of points or rectangles to the local coordinates of your current graphics port. 
Declared In
Quickdraw.h*/

Boolean PtInRect (
   Point pt,
   const Rect * r
){};


/*GetQDGlobalsGray

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

Pattern * GetQDGlobalsGray (
   Pattern * gray
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
Pattern * GetQDGlobalsGray (
   Pattern * gray
){};



/*FrameRect

Draws an outline inside a rectangle. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void FrameRect (
   const Rect * r
);
Parameters
r

The rectangle to frame.
Discussion

Using the pattern, pattern mode, and size of the graphics pen for the current graphics port, the FrameRect function draws an outline just inside the rectangle that you specify in the r parameter. The outline is as wide as the pen width and as tall as the pen height. The pen location does not change.

If a region is open and being formed, the outside outline of the new rectangle is mathematically added to the region’s boundary. 
Special Considerations

The FrameRect function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Deprecated in Mac OS X v10.4.
Available in Mac OS X v10.0 and later.
Declared In
Quickdraw.h*/
void FrameRect (
   const Rect * r
){};

/*PaintRect

Paints a rectangle with the graphics pen’s pattern and pattern mode. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void PaintRect (
   const Rect * r
);
Parameters
r

The rectangle to paint.
Discussion

The PaintRect function draws the interior of the rectangle that you specify in the r parameter with the pen pattern for the current graphics port, according to the pattern mode for the current graphics port. The pen location does not change.

Use the FillRect to draw the interior of a rectangle with a pen pattern different from that for the current graphics port. 
Special Considerations

The PaintRect function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void PaintRect (
   const Rect * r
){};




/*RGBForeColor

Changes the color of the “ink” used for framing and painting. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void RGBForeColor (
   const RGBColor * color
);
Parameters
color

An RGBColor structure. 
Discussion

If the current port is defined by a CGrafPort structure, QuickDraw supplies its rgbFgColor field with the RGB value that you specify in the color parameter, and places the pixel value most closely matching that color in the fgColor field. For indexed devices, the pixel value is an index to the current device’s CLUT. For direct devices, the value is the 16-bit or 32-bit equivalent to the RGB value.

If the current port is defined by a GrafPort structure, basic QuickDraw supplies its fgColor field with a color value determined by taking the high bit of each of the red, green, and blue components of the color that you supply in the color parameter. Basic QuickDraw uses that 3-bit number to select a color from its eight-color system. 

You can also use Palette Manager functions to set the foreground color.

To determine the current foreground color, use the GetForeColor function.

QuickDraw ignores the foreground and background colors when your application draws with a pixel pattern. Assign a pixel pattern to the foreground pattern used by the graphics pen; by using the BackPixPat function to assign a pixel pattern as the background pattern for the current color graphics port; and by using the FillCRect, FillCOval, FillCRoundRect, FillCArc, FillCRgn, and FillCPoly functions to fill shapes with a pixel pattern. 
Special Considerations

The RGBForeColor function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Version Notes

The RGBForeColor function is available for basic QuickDraw only in System 7. To set the foreground color for basic graphics ports on older versions of system software, use the ForeColor function.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void RGBForeColor (
   const RGBColor * color
){};


/*NewRgn

Begins creating a new region. (Deprecated in Mac OS X v10.4.)

RgnHandle NewRgn ();
Return Value

A handle to the new region. 
Discussion

The NewRgn function allocates space for a new, variable-size region and initializes it to the empty region defined by the rectangle (0,0,0,0). This is the only function that creates a new region; other functions merely alter the size or shape of existing regions.

To begin defining a region, use the OpenRgn function.

If the points or rectangles supplied to this function are defined in a graphics port other than your current graphics port, you must convert them to the local coordinate system of your current graphics port. You can accomplish this by using the SetPort function to change to the graphics port containing the points or rectangles, using the LocalGlobal function to convert their locations to global coordinates, using SetPort to return to your starting graphics port, and then using the GlobalToLocal function to convert the locations of points or rectangles to the local coordinates of your current graphics port. 
Special Considerations

The NewRgn function may move or purge memory blocks in the application heap; do not call this function at interrupt time.

Use the Memory Manager function MaxMem to determine whether the memory for the region is valid before using NewRgn.

Ensure that the memory for a region is valid before calling this function to manipulate that region if there isn’t sufficient memory, the system may crash. Regions are limited to 32 KB in size in basic QuickDraw and 64 KB in color QuickDraw. Before defining a region, you can use the Memory Manager function MaxMem to determine whether the memory for the region is valid. You can determine the current size of an existing region by calling the Memory Manager function GetHandleSize. When you record drawing operations in an open region, the resulting region description may overflow the 32 KB or 64 KB limit. Should this happen in color QuickDraw, the QDError function returns the result code regionTooBigError.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
RgnHandle NewRgn (){};


/*OpenRgn

Begins defining a region. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void OpenRgn ();
Discussion

The OpenRgn function allocates temporary memory to start saving lines and framed shapes for processing as a region definition. Call OpenRgn only after initializing a region with the NewRgn function.

The NewRgn function stores the definition for a region in a Region structure.

While a region is open, all calls to Line, LineTo, and the functions that draw framed shapes (except arcs) affect the outline of the region. Only the line endpoints and shape boundaries affect the region definition—the pattern mode, pattern, and size do not affect it.

When you are finished defining the region, call the CloseRgn function.

The OpenRgn function calls HidePen, so no drawing occurs on the screen while the region is open (unless you call ShowPen just after OpenRgn, or you called ShowPen previously without balancing it by a call to HidePen). Since the pen hangs below and to the right of the pen location, drawing lines with even the smallest pen changes pixels that lie outside the region you define.

The outline of a region is mathematically defined and infinitely thin, and it separates the bit or pixel image into two groups of pixels: those within the region and those outside it. 

A region should consist of one or more closed loops. Each framed shape itself constitutes a loop. Any lines drawn with the Line or LineTo function should connect with each other or with a framed shape. Even if the onscreen presentation of a region is clipped, the definition of a region is not; you can define a region anywhere on the coordinate plane with complete disregard for the location of various graphics port entities on that plane.

When a region is open, the current graphics port’s rgnSave field contains a handle to information related to the region definition. If you want to temporarily disable the collection of lines and shapes, you can save the current value of this field, set the field to NULL, and later restore the saved value to resume the region definition. Also, calling SetPort while a region is being formed discontinues formation of the region until another call to SetPort resets the region’s original graphics port.

If the points or rectangles supplied to this function are defined in a graphics port other than your current graphics port, you must convert them to the local coordinate system of your current graphics port. You can accomplish this by using the SetPort function to change to the graphics port containing the points or rectangles, using the LocalGlobal function to convert their locations to global coordinates, using SetPort to return to your starting graphics port, and then using the GlobalToLocal function to convert the locations of points or rectangles to the local coordinates of your current graphics port. 
Special Considerations

Regions are limited to 32 KB in size in basic QuickDraw and 64 KB in Color QuickDraw. You can determine the current size of an existing region by calling the Memory Manager function GetHandleSize. When you structure drawing operations in an open region, the resulting region description may overflow the 32 KB or 64 KB limit. Should this happen in Color QuickDraw, the QDError function returns the result code regionTooBigError. 

Do not call OpenRgn while another region or a polygon is already open. When you are finished constructing the region, use the CloseRgn function, which is described next.

The OpenRgn function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void OpenRgn (){};


/*MoveTo

Moves the graphics pen to a particular location in the current graphics port. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void MoveTo (
   short h,
   short v
);
Parameters
h

The horizontal coordinate of the graphics pen’s new position.
v

The vertical coordinate of the graphics pen’s new position.
Discussion

The MoveTo function changes the graphics pen’s current location to the new horizontal coordinate you specify in the h parameter and the new vertical coordinate you specify in the v parameter. Specify the new location in the local coordinates of the current graphics port. The MoveTo function performs no drawing. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void MoveTo (
   short h,
   short v
){};
/*LineTo

Draws a line from the graphics pen’s current location to a new location. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void LineTo (
   short h,
   short v
);
Parameters
h

The horizontal coordinate of the graphics pen’s new location.
v

The vertical coordinate of the graphics pen’s new location.
Discussion

The LineTo function draws a line from the graphics pen’s current location in the current graphics port to the new location (h,v), which you specify in the local coordinates of the current graphics port. If you are using LineTo to draw a region or polygon, its outline is infinitely thin and is not affected by the values of the pnSize, pnMode, or pnPat field of the graphics port. 
Special Considerations

The LineTo function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Deprecated in Mac OS X v10.4.
Available in Mac OS X v10.0 and later.
Declared In
Quickdraw.h*/


void LineTo (
   short h,
   short v
){};


/*CloseRgn

Organizes a collection of lines and shapes into a region definition. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void CloseRgn (
   RgnHandle dstRgn
);
Parameters
dstRgn

The handle to the region to close. This handle should be a region handle returned by the NewRgn function. 
Discussion

The CloseRgn function stops the collection of lines and framed shapes, organizes them into a region definition, and saves the result in the region whose handle you pass in the dstRgn parameter. 

The CloseRgn function does not create the destination region; you must have already allocated space for it by using the OpenRgn function. The CloseRgn function calls the ShowPen function, balancing the call to the HidePen function made by OpenRgn. 

When you no longer need the memory occupied by the region, use the DisposeRgn function.

If the points or rectangles supplied to this function are defined in a graphics port other than your current graphics port, you must convert them to the local coordinate system of your current graphics port. You can accomplish this by using the SetPort function to change to the graphics port containing the points or rectangles, using the LocalGlobal function to convert their locations to global coordinates, using SetPort to return to your starting graphics port, and then using the GlobalToLocal function to convert the locations of points or rectangles to the local coordinates of your current graphics port. 
Special Considerations

Regions are limited to 32 KB in size in basic QuickDraw and 64 KB in Color QuickDraw. When you structure drawing operations in an open region, the resulting region description may overflow this limit. Should this happen in Color QuickDraw, the QDError function returns the result code regionTooBigError. Since the resulting region is potentially corrupt, the CloseRgn function returns an empty region if it detects QDError has returned regionTooBigError.

The CloseRgn function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

void CloseRgn (
   RgnHandle dstRgn
){};

/*DisposeRgn

Releases the memory occupied by a region. (Deprecated in Mac OS X v10.4.)

void DisposeRgn (
   RgnHandle rgn
);
Parameters
rgn

A handle to the region to dispose. This handle should be a region handle returned by the NewRgn function. 
Discussion

Use DisposeRgn only after you are completely through with a region. 
Special Considerations

The DisposeRgn function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

void DisposeRgn (
   RgnHandle rgn
){};

/*InsetRect

Shrinks or expands a rectangle. 

void InsetRect (
   Rect * r,
   short dh,
   short dv
);
Parameters
r

A pointer to the rectangle to alter.
dh

The horizontal distance to move the left and right sides in toward or outward from the center of the rectangle.
dv

The vertical distance to move the top and bottom sides in toward or outward from the center of the rectangle.
Discussion

The InsetRect function shrinks or expands the rectangle that you specify in the r parameter: the left and right sides are moved in by the amount you specify in the dh parameter; the top and bottom are moved toward the center by the amount you specify in the dv parameter. If the value you pass in dh or dv is negative, the appropriate pair of sides is moved outward instead of inward. The effect is to alter the size by 2*dh horizontally and 2*dv vertically, with the rectangle remaining centered in the same place on the coordinate plane.

If the resulting width or height becomes less than 1, the rectangle is set to the empty rectangle (0,0,0,0).

If the points or rectangles supplied to this function are defined in a graphics port other than your current graphics port, you must convert them to the local coordinate system of your current graphics port. You can accomplish this by using the SetPort function to change to the graphics port containing the points or rectangles, using the LocalGlobal function to convert their locations to global coordinates, using SetPort to return to your starting graphics port, and then using the GlobalToLocal function to convert the locations of points or rectangles to the local coordinates of your current graphics port. 
Declared In
Quickdraw.h*/

void InsetRect (
   Rect * r,
   short dh,
   short dv
){};


/*RectRgn

Changes the structure of an existing region to that of a rectangle. (Deprecated in Mac OS X v10.4.)

void RectRgn (
   RgnHandle rgn,
   const Rect * r
);
Parameters
rgn

A handle to the region to restructure as a rectangle. 
r

The rectangle structure to use.
Discussion

The RectRgn function destroys the previous structure of the SetRectRgn function, and it then sets the new structure to a rectangle that you specify in the r parameter.

As an alternative to the RectRgn function, use the SetRectRgn function, which accepts as parameters four coordinates instead of a rectangle. 

If the points or rectangles supplied to this function are defined in a graphics port other than your current graphics port, you must convert them to the local coordinate system of your current graphics port. You can accomplish this by using the SetPort function to change to the graphics port containing the points or rectangles, using the LocalGlobal function to convert their locations to global coordinates, using SetPort to return to your starting graphics port, and then using the GlobalToLocal function to convert the locations of points or rectangles to the local coordinates of your current graphics port. 
Special Considerations

The RectRgn function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

void RectRgn (
   RgnHandle rgn,
   const Rect * r
){};




/*GetPixBounds

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

Rect * GetPixBounds (
   PixMapHandle pixMap,
   Rect * bounds
);
Carbon Porting Notes

Use this new accessor function in place of direct access to structs.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

Rect * GetPixBounds (
   PixMapHandle pixMap,
   Rect * bounds
){};


/*OffsetRect

Moves a rectangle. 

void OffsetRect (
   Rect * r,
   short dh,
   short dv
);
Parameters
r

A pointer to the rectangle to move.
dh

The horizontal distance to move the rectangle.
dv

The vertical distance to move the rectangle.
Discussion

The OffsetRect function moves the rectangle that you specify in the r parameter by adding the value you specify in the dh parameter to each of its horizontal coordinates and the value you specify in the dv parameter to each of its vertical coordinates. If the dh and dv parameters are positive, the movement is to the right and down; if either is negative, the corresponding movement is in the opposite direction. The rectangle retains its shape and size; it is merely moved on the coordinate plane. The movement does not affect the screen unless you subsequently call a function to draw within the rectangle.

If the points or rectangles supplied to this function are defined in a graphics port other than your current graphics port, you must convert them to the local coordinate system of your current graphics port. You can accomplish this by using the SetPort function to change to the graphics port containing the points or rectangles, using the LocalGlobal function to convert their locations to global coordinates, using SetPort to return to your starting graphics port, and then using the GlobalToLocal function to convert the locations of points or rectangles to the local coordinates of your current graphics port. 
Declared In
Quickdraw.h*/

void OffsetRect (
   Rect * r,
   short dh,
   short dv
){};


/*ClipRect

Changes the clipping region of the current graphics port (basic or color). (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void ClipRect (
   const Rect * r
);
Parameters
r

A pointer to a rectangle for the boundary of the new clipping region. The ClipRect function changes the clipping region of the current graphics port to a region that’s equivalent to this rectangle. ClipRect doesn’t change the region handle, but it affects the clipping region itself.
Discussion

Since ClipRect makes a copy of the given rectangle, any subsequent changes you make to that rectangle do not affect the clipping region of the port.

The ClipRect function may move or purge memory blocks in the application heap. Your application should not call this function at interrupt time. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void ClipRect (
   const Rect * r
){};


/*KillPicture

Releases the memory occupied by a picture not stored in a 'PICT' resource. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void KillPicture (
   PicHandle myPicture
);
Parameters
myPicture

A handle to the picture whose memory can be released. 
Discussion

Use this function only when you are completely finished with a picture. 
Special Considerations

If you use the Window Manager function SetWindowPic to store a picture handle in the window structure, use the Window Manager function DisposeWindow or CloseWindow to release the memory allocated to the picture. These functions automatically call KillPicture for the picture.

If the picture is stored in a 'PICT' resource, use the Resource Manager function ReleaseResource instead of KillPicture. The Window Manager functions DisposeWindow and CloseWindow will not delete it. Instead, call ReleaseResource before calling DisposeWindow or CloseWindow.

The KillPicture function may move or purge memory.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void KillPicture (
   PicHandle myPicture
){};


/*OpenPicture

Creates a picture which allows you to specify resolutions for your pictures. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

PicHandle OpenPicture (
   const Rect * picFrame
);
Parameters
picFrame

The bounding rectangle for the picture. The DrawPicture function uses this rectangle to scale the picture if you draw it into a destination rectangle of a different size.
Return Value

A handle to a new Picture structure. OpenPicture collects your subsequent drawing commands in this structure. Use this handle when referring to the picture in subsequent functions, such as the DrawPicture function. 
Discussion

The OpenPicture function, which was created for earlier versions of system software, is described here for completeness. Use the OpenPicture function to begin defining a picture. 

The OpenPicture function calls the HidePen function, so no drawing occurs on the screen while the picture is open (unless you call the ShowPen function just after OpenPicture or you called ShowPen previously without balancing it by a call to HidePen).

The OpenPicture function creates pictures in the version 2 format on computers with Color QuickDraw when the current graphics port is a color graphics port. Pictures created in this format support color drawing operations at 72 dpi. On computers supporting only basic QuickDraw, or when the current graphics port is a basic graphics port, this function creates pictures in version 1 format. Pictures created in version 1 format support only black-and-white drawing operations at 72 dpi.

When defining a picture, you can use all other QuickDraw drawing functions, with the exception of CopyMask, CopyDeepMask, SeedFill, SeedCFill, CalcMask, and CalcCMask. You can also use the PicComment function to include picture comments in your picture definition.

After defining the picture, close it by using the ClosePicture function. To draw the picture, use the DrawPicture function. 
Special Considerations

The version 2 and version 1 picture formats support only 72-dpi resolution. The OpenCPicture function creates pictures in the extended version 2 format. The extended version 2 format, which is created by the OpenCPicture function on all Macintosh computers running System 7, permits your application to specify additional resolutions when creating images.

Version 1 pictures are limited to 32 KB. You can determine the picture size while it is being formed by calling the Memory Manager function GetHandleSize.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

PicHandle OpenPicture (
   const Rect * picFrame
){};

/*ClosePicture

Completes the collection of drawing commands and picture comments that define your picture. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void ClosePicture ();
Discussion

The ClosePicture function stops collecting drawing commands and picture comments for the currently open picture. You should perform one and only one call to ClosePicture for every call to the OpenCPicture (or OpenPicture) function.

The ClosePicture function calls the ShowPen function, balancing the call made by OpenCPicture (or OpenPicture) to the HidePen function. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void ClosePicture (){};



/*GetFNum

Obtains the font family ID for a specified font family name. (Deprecated in Mac OS X v10.4. Use FMGetFontFamilyFromName instead.)

Not recommended.

void GetFNum (
   ConstStr255Param name,
   SInt16 *familyID
);
Parameters
name

The font family name. 
familyID

On output, a pointer to the font family ID for the font family specified in name. If the font specified in the parameter name does not exist, the font family ID contains 0.
Special Considerations

There are several alternatives that provide better compatibility with the operating system than using QuickDraw font functions . You may want to consider the following:
For drawing and measuring text, you can use the Appearance Manager API or the ATSUI API to render text directly through a Quartz graphics context. See Appearance Manager Reference, Rendering Unicode Text With ATSUI, and ATSUI Reference.
For accessing information on fonts tracked by the operating system, use the ATS for Fonts API. See Managing Fonts: ATS and Apple Type Services for Fonts Reference.
For accessing and modifying information on fonts in a Quartz graphics context, use the Quartz API. See Quartz 2D Programming Guide and Quartz 2D Reference Collection.
Carbon Porting Notes

You should use the function FMGetFontFamilyFromName instead of the function GetFNum.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Fonts.h*/

void GetFNum (
   ConstStr255Param name,
   SInt16 *familyID
){};

/*GetQDGlobalsScreenBits

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

BitMap * GetQDGlobalsScreenBits (
   BitMap * screenBits
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
BitMap * GetQDGlobalsScreenBits (
   BitMap * screenBits
){};



/*ATSUDisposeStyle

Disposes of the memory associated with a style object.

OSStatus ATSUDisposeStyle (
   ATSUStyle iStyle
);
Parameters
iStyle

An ATSUStyle value specifying the style object to dispose of.
Return Value

A result code. See “ATSUI Result Codes”.
Discussion

The ATSUDisposeStyle function frees the memory associated with the specified style object and its internal structures, including style run attributes. It does not dispose of the memory pointed to by application-defined style run attributes or reference constants. You are responsible for doing so.

You should call this function after calling the function ATSUDisposeTextLayout to dispose of any text layout objects associated with the style object.

For best performance, once you create a style object, you should keep it and use it as often as needed. You should dispose of the style object only when it is no longer needed in your application.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeObjects.h*/
OSStatus ATSUDisposeStyle (
   ATSUStyle iStyle
){};

/*ATSUDisposeTextLayout

Disposes of the memory associated with a text layout object.

OSStatus ATSUDisposeTextLayout (
   ATSUTextLayout iTextLayout
);
Parameters
iTextLayout

An ATSUTextLayout value specifying the text layout object to dispose of. 
Return Value

A result code. See “ATSUI Result Codes”.
Discussion

The ATSUDisposeTextLayout function frees the memory associated with the specified text layout object and its internal structures, including line and layout control attributes, style runs, and soft line breaks. ATSUDisposeTextLayout does not dispose of any memory that may be allocated for reference constants or style objects associated with the text layout object. You are responsible for doing so.

For best performance, text layout objects are readily reusable and should be cached for later use, if possible. You can reuse a text layout object even if the text associated with it is altered. Call the functions ATSUSetTextPointerLocation, ATSUTextDeleted, or ATSUTextInserted to manage the altered text, rather than disposing of the text layout object and creating a new one.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeObjects.h*/
OSStatus ATSUDisposeTextLayout (
   ATSUTextLayout iTextLayout
){};
/*ATSUDirectReleaseLayoutDataArrayPtr

Releases a pointer to a direct-data array.

extern OSStatus ATSUDirectReleaseLayoutDataArrayPtr(
   ATSULineRef              iLineRef,
   ATSUDirectDataSelector   iDataSelector,
   void *                   iLayoutDataArrayPtr[]
);
Parameters
iLineRef

An ATSULineRef value that specifies the line of text whose data is pointed to by the iLayoutDataArrayPtr parameter. Pass NULL if you did not obtain the layout data array pointer using a lineRef.
iDataSelector

A direct-data selector constant that specifies the data pointed to by the iLayoutDataArrayPtr parameter. You can pass any of the constants described in “Direct Data Selectors”.
iLayoutDataArrayPtr[]

A pointer to the layout data array of which you want to dispose.
Return Value

A result code. See “ATSUI Result Codes”. 
Discussion

You must call the function ATSUDirectReleaseLayoutDataArrayPtr when you no longer need the direct-data pointer you obtained from the ATSUDirectGetLayoutDataArrayPtrFromLineRef or ATSUDirectGetLayoutDataArrayPtrFromTextLayout functions. You must dispose of the pointer to inform ATSUI you no longer need the data and to allow for ATSUI to make any internal adjustments prior to completing the layout process.
Availability
Available in Mac OS X v10.2 and later.
Declared In
ATSUnicodeDirectAccess.h*/
OSStatus ATSUDirectReleaseLayoutDataArrayPtr(
   ATSULineRef              iLineRef,
   ATSUDirectDataSelector   iDataSelector,
   void *                   iLayoutDataArrayPtr[]
){};

/*ATSUCreateAndCopyStyle

Creates a copy of a style object.

OSStatus ATSUCreateAndCopyStyle (
   ATSUStyle iStyle,
   ATSUStyle *oStyle
);
Parameters
iStyle

An ATSUStyle value specifying the style object to copy.
oStyle

A pointer to an ATSUStyle value. On return, the pointer refers to a newly created style object. This style object contains the same values for style attributes, font features, and font variations as those of the style object passed in the iStyle parameter.
Return Value

A result code. See “ATSUI Result Codes”.
Discussion

The ATSUCreateAndCopyStyle function creates a new style object with values obtained from the source style object’s style attributes, font features, and font variations. ATSUCreateAndCopyStyle does not copy reference constants.

To create a new style object without copying a source object, you can call the function ATSUCreateStyle. Alternately, to copy the contents of a source style object into an existing style object, call the function ATSUCopyAttributes.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeObjects.h*/
OSStatus ATSUCreateAndCopyStyle (
   ATSUStyle iStyle,
   ATSUStyle *oStyle
){};


/*ATSUCreateTextLayoutWithTextPtr

Creates an opaque text layout object containing default text layout attributes as well as associated text and text styles.

OSStatus ATSUCreateTextLayoutWithTextPtr (
   ConstUniCharArrayPtr iText,
   UniCharArrayOffset iTextOffset,
   UniCharCount iTextLength,
   UniCharCount iTextTotalLength,
   ItemCount iNumberOfRuns,
   const UniCharCount *iRunLengths,
   ATSUStyle *iStyles,
   ATSUTextLayout *oTextLayout
);
Parameters
iText

A pointer of type ConstUniCharArrayPtr, referring to a text buffer containing UTF-16–encoded text. ATSUI associates this buffer with the new text layout object and analyzes the complete text of the buffer when obtaining the layout context for the current text range. Thus, for paragraph-format text, if you specify a buffer containing less than a complete paragraph, some of ATSUI’s layout results are not guaranteed to be accurate. For example, with a buffer of less than a full paragraph, ATSUI can neither reliably obtain the context for bidirectional processing nor reliably generate accent attachments and ligature formations for Roman text. 
iTextOffset

A UniCharArrayOffset value specifying the offset from the beginning of the text buffer to the first character of the range to include in the layout. To indicate that the specified text range starts at the beginning of the text buffer, you can pass the constant kATSUFromTextBeginning. To specify the entire text buffer, pass kATSUFromTextBeginning in this parameter and kATSUToTextEnd in the iTextLength parameter. 
iTextLength

A UniCharCount value specifying the length of the text range. Note that iTextOffset + iTextLength must be less than or equal to the value of the iTextTotalLength parameter. If you want the range of text to extend to the end of the text buffer, you can pass the constant kATSUToTextEnd.
iTextTotalLength

A UniCharCount value specifying the length of the entire text buffer. This value should be greater than or equal to the range of text defined by the iTextLength parameter.
iNumberOfRuns

An ItemCount value specifying the number of text style runs you want to define within the overall text range. The number of style objects and style run lengths passed in the iStyles and iRunLengths parameters, respectively, should be equal to the number of runs specified here.
iRunLengths

A pointer to the first element in a UniCharCount array. This array provides ATSUI with the lengths of each of the text’s style runs. You can pass kATSUToTextEnd for the last style run length if you want the style run to extend to the end of the text range. If the sum of the style run lengths is less than the total length of the text range, the remaining characters are assigned to the last style run.
iStyles

A pointer to the first element in an ATSUStyle array. Each element in the array must contain a valid style object that corresponds to a style run defined by the iRunLengths array. 
oTextLayout

A valid pointer to an ATSUTextLayout value. On return, the value refers to the newly created text layout object. 
Return Value

A result code. See “ATSUI Result Codes”.
Discussion

The ATSUCreateTextLayoutWithTextPtr function creates a text layout object associated with style objects and text and containing the default text layout attributes described in “Attribute Tags”. To provide nondefault line or layout attributes for a text layout object, you can call the functions ATSUSetLineControls or ATSUSetLayoutControls. After setting text attributes, call ATSUDrawText to draw the text.

Because the only way that ATSUI interacts with text is via the memory references you associate with a text layout object, you are responsible for keeping these references updated, as in the following cases:
When the user deletes or inserts a subrange within a text buffer (but the buffer itself is not relocated), you should call the functions ATSUTextDeleted and ATSUTextInserted, respectively.
When you relocate the entire text buffer (but no other changes have occurred that would affect the buffer’s current subrange), you should call the function ATSUTextMoved.
When both the buffer itself is relocated and a subrange of the buffer’s text is deleted or inserted (that is, a combination of cases 1 and 2, above), you must use the function ATSUSetTextPointerLocation to inform ATSUI.
When you are associating an entirely different buffer with a text layout object, you must call the function ATSUSetTextPointerLocation.

Note that, because ATSUI objects retain state information, doing superfluous calling can degrade performance. For example, you could call ATSUSetTextPointerLocation rather than ATSUTextInserted when the user inserts text, but there would be a performance penalty, as all the layout caches are flushed when you call ATSUSetTextPointerLocation, rather than just the affected ones.

Text layout objects are readily reusable and should themselves be cached for later use, if possible. Text objects are thread-safe starting with ATSUI version 2.4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeObjects.h*/
OSStatus ATSUCreateTextLayoutWithTextPtr (
   ConstUniCharArrayPtr iText,
   UniCharArrayOffset iTextOffset,
   UniCharCount iTextLength,
   UniCharCount iTextTotalLength,
   ItemCount iNumberOfRuns,
   const UniCharCount *iRunLengths,
   ATSUStyle *iStyles,
   ATSUTextLayout *oTextLayout
){};


/*ATSUSetTransientFontMatching

Turns automatic font substitution on or off for a text layout object.

OSStatus ATSUSetTransientFontMatching (
   ATSUTextLayout iTextLayout,
   Boolean iTransientFontMatching
);
Parameters
iTextLayout

An ATSUTextLayout value specifying the text layout object for which to set automatic font substitution on or off. 
iTransientFontMatching

A Boolean value indicating whether ATSUI is to perform automatic font substitution for the text layout object. If you pass true, ATSUI performs automatic font substitution for the text range associated with the text layout object.
Return Value

A result code. See “ATSUI Result Codes”.
Discussion

Calling the ATSUSetTransientFontMatching function sets ATSUI’s automatic font substitution to on or off for a given text layout object. When automatic font substitution is on, ATSUI scans the text range associated with specified text layout object looking for undrawable characters whenever a layout is performed, for example, when text is measured or drawn. When ATSUI finds a character that cannot be drawn with the currently assigned font, it identifies a valid font for the character and draws the character. ATSUI continues scanning the text range for characters in need of substitute fonts, replacing the font and redrawing the characters as needed. ATSUI stops scanning when it reaches the end of the text range associated with the text layout object.

ATSUI’s default behavior for finding a substitute font is to use the first valid font that it finds when sequentially scanning the fonts in the user’s system. However, you can alter this behavior by calling the function ATSUCreateFontFallbacks and defining your own font fallback settings for the text layout object. If ATSUI cannot find any suitable replacement fonts, it substitutes the missing-character glyph—that is, a glyph representing an empty box—to indicate to the user that a valid font is not installed on their system.

Note that when ATSUSetTransientFontMatching performs font substitution, it does not change the font attribute in the associated style object. That is, the font attribute for the style object associated with the redrawn character(s) remains set to the invalid font—not the valid substitute font— just as it was prior to calling ATSUSetTransientFontMatching.

If you want ATSUI to identify a substitute font, but you do not want ATSUI to automatically perform the font substitution, you can call the function ATSUMatchFontsToText.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeObjects.h*/
OSStatus ATSUSetTransientFontMatching (
   ATSUTextLayout iTextLayout,
   Boolean iTransientFontMatching
){};

/*ATSUDirectGetLayoutDataArrayPtrFromTextLayout

Obtains a copy of the glyph data specified by a direct-data selector and for a specific line of text in a text layout object.

OSStatus ATSUDirectGetLayoutDataArrayPtrFromTextLayout(
   ATSUTextLayout           iTextLayout,
   UniCharArrayOffset       iLineOffset,
   ATSUDirectDataSelector   iDataSelector,
   void *                   oLayoutDataArrayPtr[],
   ItemCount *              oLayoutDataCount
);
Parameters
iTextLayout

An ATSUTextLayout value that specifies the text layout object whose data you want to obtain.
iLineOffset

The edge offset that corresponds to the beginning of the line of text whose data you want to obtain. 
iDataSelector

A direct-data selector constant that specifies the data you want to obtain. You can pass any of the constants described in “Direct Data Selectors”.
oLayoutDataArrayPtr[]

On return, points to an array that contains the data specified by the iDataSelector parameter. The data is for the line of text referenced by the iLineOffset parameter. If an array for the specified data does not exist, ATSUI returns NULL. You can pass NULL if you only want to obtain the number of entries in the array in the oLayoutDataArray array.
oLayoutDataCount

On return, the number of entries in the array oLayoutDataArray.
Return Value

A result code. See “ATSUI Result Codes”. 
Discussion

The function ATSUDirectGetLayoutDataArrayPtrFromTextLayout returns a pointer to the data specified by iDataSelector and referenced by iTextLayout for the line starting at iLineOffset. You must not call this function from within an ATSUDirectLayoutOperationOverrideProcPtrcallback function. 

You should only release the data pointer by calling the function ATSUDirectReleaseLayoutDataArrayPtr. When you call this function, it signals ATSUI that you are done with the data and that ATSUI can merge your modifications with the font’s data. If you do not properly free the data by calling the function ATSUDirectReleaseLayoutDataArrayPtr, a memory leak may result. 

The data you obtain is a copy of the data ATSUI uses for its layout processes. This means the following: 
Obtaining data through a copy operation takes more time than obtaining the actual data. This function returns in order-n time instead of in a constant time.
Changing any of the data values has no effect on the layout.

Before you use this function, you should consider using the functionATSUDirectGetLayoutDataArrayPtrFromLineRef with the kATSULayoutOperationPostLayoutAdjustment selector.

If you use the function ATSUDirectGetLayoutDataArrayPtrFromTextLayout to obtain the ATSUStyleSettingRef array, the structures referenced by each element of the array are invalid after you call the function ATSUDirectReleaseLayoutDataArrayPtr to release the array. If want to retain one or more of the elements in the ATSUStyleSettingRef array for later use, you must not call the function ATSUDirectReleaseLayoutDataArrayPtr until all operations that use the elements in the ATSUStyleSettingRef in the array are complete. The elements in the ATSUStyleSettingRef array are valid only within the context of the callback from which they were obtained

Many of the requested data arrays are created by ATSUI only when necessary. This means that it's possible for the function ATSUDirectGetLayoutDataArrayPtrFromTextLayout to return a NULL pointer and a count of 0. If this is case and if the function does not return an error, the array doesn't exist. You should interpret this result to mean that all values in the array are 0.
Availability
Available in Mac OS X v10.2 and later.
Declared In
ATSUnicodeDirectAccess.h*/
OSStatus ATSUDirectGetLayoutDataArrayPtrFromTextLayout(
   ATSUTextLayout           iTextLayout,
   UniCharArrayOffset       iLineOffset,
   ATSUDirectDataSelector   iDataSelector,
   void *                   oLayoutDataArrayPtr[],
   ItemCount *              oLayoutDataCount
){};


/*ATSUSetLayoutControls

Sets layout control attribute values in a text layout object.

OSStatus ATSUSetLayoutControls (
   ATSUTextLayout iTextLayout,
   ItemCount iAttributeCount,
   const ATSUAttributeTag *iTag,
   const ByteCount *iValueSize,
   const ATSUAttributeValuePtr *iValue
);
Parameters
iTextLayout

An ATSUTextLayout value specifying the text layout object for which to set layout control attributes. 
iAttributeCount

An ItemCount value specifying the number of attributes to set. This value should correspond to the number of elements in the iTag and iValueSize arrays.
iTag

A pointer to the initial ATSUAttributeTag value in an array of layout control attribute tags. Each element in the array must contain a valid tag that corresponds to the layout control attribute to set. See “Attribute Tags” for a description of the Apple-defined layout control attribute tag constants. 
iValueSize

A pointer to the initial ByteCount value in an array of attribute value sizes. Each element in the array must contain the size (in bytes) of the corresponding layout control attribute being set. ATSUSetLayoutControls sets layout attributes after confirming the sizes in the array.
iValue

A pointer to the initial ATSUAttributeValuePtr value in an array of attribute value pointers. Each value in the array must correspond to a tag in the iTag array and be a legal value for that tag. 
Return Value

A result code. See “ATSUI Result Codes”.
Discussion

When you use ATSUI to image your text, you can control the text’s display and formatting at a number of different levels.

One level is that of the entire text range associated with your text layout object, also known as the “layout level.” To affect display and formatting on this level, you can specify various layout control attributes using the ATSUSetLayoutControls function. These attributes affect the width of the text area from margin to margin, the alignment of the text, its justification, rotation, and direction, as well as other layout options.

Another level is that of a single line of text, that is, the “line level.” To affect display and formatting on this level, you specify various line control attributes via the function ATSUSetLineControls. These attributes are similar to those that you can apply on a full-layout basis, but each affects only an individual text line.

Given that ATSUI allows you to control similar aspects of the display and formatting of your text at either the line level or the layout level (or both, or neither), it is up to you to decide how much layout control to take. However, you should note the following:
Setting layout control attributes overrides the corresponding default layout-level settings for a text layout object. Any layout attributes that you do not set retain the default values described in “Attribute Tags”.
Setting line control attributes overrides the corresponding layout-level settings (whether set or at default values) for a text layout object. This is true even if you set the layout-level attributes subsequently to the line-level ones.
From a performance standpoint, it is preferable to work from the layout level and not specify layout line by line unless necessary.

Finally, it is also possible to control the display and formatting of your text at the level of an individual character or “run” of characters. At this level, you customize layout by manipulating style settings in a style object. Among the character-level aspects you can control are style attributes (such as font size and color), font features (such as ligatures), and font variations (such as continually varying font weights or widths). However, there are certain line control attributes (specified via the ATSLineLayoutOptions flags) that can override style attributes applied to the same text.

Similarly to style attributes, you use a “triple” to specify a line or layout control attribute. That is, an attribute tag, the value of the attribute it sets, and the size (in bytes) of the attribute value. Attribute tags are constants supplied by ATSUI. Attribute values may be a scalar, a structure, or a pointer. And as with style attributes, you can also create a custom attribute for a line or layout attribute for which ATSUI does not provide a tag.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeObjects.h*/
OSStatus ATSUSetLayoutControls (
   ATSUTextLayout iTextLayout,
   ItemCount iAttributeCount,
   const ATSUAttributeTag *iTag,
   const ByteCount *iValueSize,
   const ATSUAttributeValuePtr *iValue
){};


/*ATSUSetAttributes

Sets style attribute values in a style object.

OSStatus ATSUSetAttributes (
   ATSUStyle iStyle,
   ItemCount iAttributeCount,
   const ATSUAttributeTag *iTag,
   const ByteCount *iValueSize,
   const ATSUAttributeValuePtr *iValue
);
Parameters
iStyle

An ATSUStyle value specifying the style object for which to set attributes.
iAttributeCount

An ItemCount value specifying the number of attributes to set. This value should correspond to the number of elements in the iTag and iValueSize arrays.
iTag

A pointer to the initial ATSUAttributeTag value in an array of attribute tags. Each element in the array must contain a valid style attribute tag that corresponds to the style attribute value to set. Note that an attribute tag cannot be used in versions of the Mac OS that are earlier than the version in which the tag was introduced. For example, a tag available in Mac OS version 10.2 cannot be used in Mac OS version 10.1 or earlier. You can call the function Gestalt to check version information for ATSUI. See “Attribute Tags” for a description of the Apple-defined style attribute tag constants and for availability information.
iValueSize

A pointer to the initial ByteCount value in an array of attribute value sizes. Each element in the array must contain the size (in bytes) of the corresponding style run attribute value being set. ATSUSetAttributes sets style attributes after confirming the sizes in the array.
iValue

A pointer to the initial ATSUAttributeValuePtr value in an array of attribute value pointers. Each pointer in the array must reference an attribute value corresponding to a tag in the iTag array. The value referenced by the pointer must be legal for that tag.
Return Value

A result code. See “ATSUI Result Codes”. If there is a function error, ATSUSetAttributes does not set any attributes in the style object.
Discussion

Style attributes are a collection of values and settings that override the font-specified behavior for displaying and formatting text in a style run. To specify a style attribute, ATSUI uses a “triple” consisting of (1) an attribute tag, (2) a value for that tag, and (3) the size of the value.

The ATSUSetAttributes function enables you to set multiple style attribute values for a style object. When you call ATSUSetAttributes, any style attributes that you do not set retain their previous values. To set font features and font variations, call the functions ATSUSetFontFeatures and ATSUSetVariations, respectively.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeObjects.h*/

OSStatus ATSUSetAttributes (
   ATSUStyle iStyle,
   ItemCount iAttributeCount,
   const ATSUAttributeTag *iTag,
   const ByteCount *iValueSize,
   const ATSUAttributeValuePtr *iValue
){};

/*ATSUDirectGetLayoutDataArrayPtrFromLineRef

Obtains the glyph data specified by a direct-data selector and for a specific line of text. 

OSStatus ATSUDirectGetLayoutDataArrayPtrFromLineRef(
   ATSULineRef              iLineRef,
   ATSUDirectDataSelector   iDataSelector,
   Boolean                  iCreate,
   void *                   oLayoutDataArrayPtr[],
   ItemCount *              oLayoutDataCount
);
Parameters
iLineRef

An ATSULineRef value that specifies the line of text whose data you want to obtain. You should pass the same ATSULineRef value passed to the ATSUDirectLayoutOperationOverrideProcPtr callback function from which you are calling this function.
iDataSelector

A direct-data selector constant that specifies the data you want to obtain. You can pass any of the constants described in “Direct Data Selectors”.
iCreate

A Boolean value that specifies whether to create an array if one does not already exist. Pass true if you want an array created. If the line referenced by the iLineRef parameter does not already have an array created that contains the data specified by the iDataSelector parameter, then ATSUI creates a zero-filled array and returns the array in the oLayoutDataArray parameter. The iCreate parameter has no effect for some data specified by the direct-data selector. See “Direct Data Selectors” for details.
oLayoutDataArrayPtr[]

On return, points to an array that contains the data specified by the iDataSelector parameter. The data is for the line of text referenced by the iLineRef parameter. If an array for the specified data does not exist, and if the iCreate is set to false, ATSUI returns NULL. If an array for the specified data does not exist, and if the iCreate is set to true, ATSUI creates a zero-filled array. You can pass NULL if you only want to obtain the number of entries in the array returned in the oLayoutDataArray array.
oLayoutDataCount

On return, the number of entries in the array returned in the oLayoutDataArray array.
Return Value

A result code. See “ATSUI Result Codes”. 
Discussion

The function ATSUDirectGetLayoutDataArrayPtrFromLineRef returns the data pointer specified by the iDataSelector parameter and referenced by the iLineRef parameter. You must call this function from within an ATSUDirectLayoutOperationOverrideProcPtr callback function. You must only release the data pointer by calling the function ATSUDirectReleaseLayoutDataArrayPtr. When you call this function, it signals ATSUI that you are done with the data and that ATSUI can merge your modifications with the font’s data. If you do not properly free the data by calling the function ATSUDirectReleaseLayoutDataArrayPtr, a memory leak may result. 

The data you obtain is the actual data used by ATSUI in its layout process; it is not a copy. This function is very efficient because ATSUI does not need to allocate memory and copy data. Furthermore, because you obtain a pointer to the data that ATSUI uses for its layout, any modifications you make to the data effect the final layout. 

Many of the data arrays you can request are created by ATSUI only when necessary. If you plan to alter the data in an array, make sure you set the iCreate parameter to true. This ensures that the array is created. If an arrays are not created, ATSUI assumes all entries in the array are zero. 

The pointer returned by this function is only valid within the context of the ATSUDirectLayoutOperationOverrideProcPtr callback function. You must not retain it for later use.
Availability
Available in Mac OS X v10.2 and later.
Declared In
ATSUnicodeDirectAccess.h*/

OSStatus ATSUDirectGetLayoutDataArrayPtrFromLineRef(
   ATSULineRef              iLineRef,
   ATSUDirectDataSelector   iDataSelector,
   Boolean                  iCreate,
   void *                   oLayoutDataArrayPtr[],
   ItemCount *              oLayoutDataCount
){};



/*ATSUDirectAddStyleSettingRef

Looks up, and if necessary, adds a style setting to a line of text.

extern OSStatus ATSUDirectAddStyleSettingRef(
   ATSULineRef           iLineRef,
   ATSUStyleSettingRef   iStyleSettingRef,
   UInt16 *              oStyleIndex
);
Parameters
iLineRef

An ATSULineRef value that specifies the line of text to which you want to add a style setting. You should pass the same reference provided as a parameter to your ATSUDirectLayoutOperationOverrideProcPtr callback function.
iStyleSettingRef

An ATSUStyleSettingRef value that specifies the style setting you want ATSUI to look up or add to the text layout object referenced by the line starting at the offset iLineOffset.
oStyleIndex

On return, points to the index of the ATSUStyleSettingRef passed in iStyleSettingRef for the line referenced by iLineRef. If the ATSUStyleSettingRef does not exist in that context, ATSUI adds it and returns the index value.
Return Value

A result code. See “ATSUI Result Codes”. 
Discussion

The function ATSUDirectAddStyleSettingRef checks to see if a line of text has a specified style setting reference associated with it. If the style setting reference is not associated with the line of text, ATSUI adds the style setting reference.

You must call this function from within an ATSUDirectLayoutOperationOverrideProcPtr callback function. You can use the function ATSUDirectAddStyleSettingRef to replace or substitute glyphs. For example, you can check a line of text for a specific character, such as a whitespace character. When your application finds a whitespace character, it can call the function ATSUDirectAddStyleSettingRef to set style attributes that achieve the desired effect. 

Do not call this function if you obtained an ATSUStyleSettingRef array for the line specified by iLineRef and have not yet disposed of the pointer to this array by calling the function ATSUDirectReleaseLayoutDataArrayPtr, as the pointer is not guaranteed to be valid after you call the function ATSUDirectAddStyleSettingRef.
Availability
Available in Mac OS X v10.2 and later.
Declared In
ATSUnicodeDirectAccess.h*/
OSStatus ATSUDirectAddStyleSettingRef(
   ATSULineRef           iLineRef,
   ATSUStyleSettingRef   iStyleSettingRef,
   UInt16 *              oStyleIndex
){};


/*ATSUCreateStyle

Creates an opaque style object containing only default style attributes, font features, and font variations.

OSStatus ATSUCreateStyle (
   ATSUStyle *oStyle
);
Parameters
oStyle

A pointer to an ATSUStyle value. On return, the pointer refers to an empty style object.
Return Value

A result code. See “ATSUI Result Codes”.
Discussion

The ATSUCreateStyle function creates a style object containing only default values for style attributes, font features, and font variations. The default values for the font features and variations are assigned by the font. The default style attribute values are described in “Attribute Tags”.

To make changes to the default style attribute values, you can call the function ATSUSetAttributes. To set font features and font variations, call the functions ATSUSetFontFeatures and ATSUSetVariations, respectively. You can also use the function ATSUCreateAndCopyStyle to create a new style object by copying all the settings from an existing one.

For ATSUI to apply your selected character-style information, you must associate the style object with a text run in a text layout object. A text run consists of one or more characters that are contiguous in memory. If you associate these characters with a distinct style, you define a style run. You can use the function ATSUSetRunStyle to define a style run by associating a style object with a run of text in a text layout object. Or, to create a text layout object and associate style objects with it at the same time, you can call the function ATSUCreateTextLayoutWithTextPtr. In either case, each text run in a text layout object must be assigned a style object, which may or may not differ from other style objects assigned to other text runs in the text layout object.

Style objects are readily reusable and should be cached for later use, if possible. You can create a style object once and then use it for as many text layout objects as appropriate. Style objects are thread-safe starting with ATSUI version 2.3.

Note that you are responsible for disposing of the memory allocated for the style object. However, you should dispose of any text layout objects with which the style object is associated prior to disposing of the style object itself. To dispose of a style object, call the function ATSUDisposeStyle.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeObjects.h*/
OSStatus ATSUCreateStyle (
   ATSUStyle *oStyle
){};

/*ATSUFONDtoFontID

Finds the ATSUI font ID that corresponds to a font family number, if one exists. (Deprecated. There is no replacement because FONDs are a QuickDraw concept and QuickDraw is deprecated.)

Not recommended.

OSStatus ATSUFONDtoFontID (
   SInt16 iFONDNumber,
   Style iFONDStyle,
   ATSUFontID *oFontID
);
Parameters
iFONDNumber

The font family number of the ATSUI-compatible font for which to obtain an ATSUI font ID.
iFONDStyle

The font family style of the font, if any. Style identifiers exist only for fonts that split a font family into subgroups.
oFontID

A pointer to a ATSUFontID value. On return, the value provides a unique identifier for the specified font family number and style. 
Return Value

A result code. See “ATSUI Result Codes”.
Discussion

The function ATSUFONDtoFontID is not recommended for use. Instead, use the Font Manager functions that translate font family numbers to FMFont values, which are equivalent to ATSUFontID values. Font family numbers were used by QuickDraw to represent fonts to the Font Manager. Some of these fonts, even if compatible with ATSUI, may not have font IDs.

Note that Apple Type Services assigns ATSUFontID values systemwide at runtime. As a result, these font IDs can change when the system is restarted.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeFonts.h*/

OSStatus ATSUFONDtoFontID (
   SInt16 iFONDNumber,
   Style iFONDStyle,
   ATSUFontID *oFontID
){};



/*QDEndCGContext

Terminates a Quartz 2D drawing environment associated with a graphics port.

OSStatus QDEndCGContext (
   CGrafPtr port,
   CGContextRef * contextPtr
);
Parameters
port

A graphics port specified in a preceding call to QDBeginCGContext.
contextPtr

A pointer to the context obtained in the preceding call to QDBeginCGContext for the port. Upon completion, the storage pointed to by contextPtr is set to NULL.
Return Value

A result code. If noErr, the context is terminated.
Discussion

After you finish using Quartz 2D to draw in a graphics port, you should call this function to terminate the context. For more information, see QDBeginCGContext.

Before calling this function, you should do one of the following:
Call CGContextSynchronize to mark the affected areas of the port for update.
Call CGContextFlush to immediately update the destination device.
Availability
Available in Mac OS X v10.1 and later.
Declared In
Quickdraw.h*/
OSStatus QDEndCGContext (
   CGrafPtr port,
   CGContextRef * contextPtr
){};


/*QDBeginCGContext

Returns a Quartz 2D drawing environment associated with a graphics port.

OSStatus QDBeginCGContext (
   CGrafPtr port,
   CGContextRef * contextPtr
);
Parameters
port

A color graphics port in which to draw. Offscreen graphics worlds with pixel depths of 1, 2, 4, and 8 are not supported. When using Quartz 2D to draw in a offscreen graphics world, alpha information is always ignored.
contextPtr

A pointer to your storage for a Quartz context. Upon completion, contextPtr points to a context associated with the port. The context matches the port’s pixel depth, width, and height. Otherwise the context is in a default state and does not necessarily match other port attributes such as foreground color, background color, or clip region.

You should not retain or release the context. When you are finished using the context, you should call QDEndCGContext.
Return Value

A result code. If noErr, the context was successfully initiated.
Discussion

Applications running in Mac OS X can use Quartz 2D to draw in a QuickDraw graphics port. When you call this function, you obtain a Quartz context that’s associated with the specified port. To improve performance, contexts returned by this function are cached and reused during subsequent calls whenever possible. 

Each block of Quartz 2D drawing code in your application should be surrounded by calls to this function and QDEndCGContext. Nested calls to this function for the same graphics port are not permitted—that is, for a given port you should not call this function more than once without an intervening call to QDEndCGContext.

While the Quartz context is in use, all Quickdraw imaging operations in the associated graphics port are disabled. This is done because the operations would fail during printing.

For information about how to use a Quartz context, see Quartz 2D Programming Guide. 
Availability
Available in Mac OS X v10.1 and later.
Declared In
Quickdraw.h*/

OSStatus QDBeginCGContext (
   CGrafPtr port,
   CGContextRef * contextPtr
){};


/*ATSUSetTextPointerLocation

Associates text with a text layout object or updates previously associated text.

OSStatus ATSUSetTextPointerLocation (
   ATSUTextLayout iTextLayout,
   ConstUniCharArrayPtr iText,
   UniCharArrayOffset iTextOffset,
   UniCharCount iTextLength,
   UniCharCount iTextTotalLength
);
Parameters
iTextLayout

An ATSUTextLayout value specifying the text layout object for which to set text. 
iText

A pointer of type ConstUniCharArrayPtr, referring to a text buffer containing UTF-16–encoded text. ATSUI associates this buffer with the text layout object and analyzes the complete text of the buffer when obtaining the layout context for the current text range. Thus, for paragraph-format text, if you specify a buffer containing less than a complete paragraph, some of ATSUI’s layout results are not guaranteed to be accurate. For example, with a buffer of less than a full paragraph, ATSUI can neither reliably obtain the context for bidirectional processing nor reliably generate accent attachments and ligature formations. 
iTextOffset

A UniCharArrayOffset value specifying the offset from the beginning of the text buffer to the first character of the range to include in the layout. To indicate that the specified text range starts at the beginning of the text buffer, you can pass the constant kATSUFromTextBeginning. To specify the entire text buffer, pass kATSUFromTextBeginning in this parameter and kATSUToTextEnd in the iTextLength parameter. 
iTextLength

A UniCharCount value specifying the length of the text range. Note that iTextOffset + iTextLength must be less than or equal to the value of the iTextTotalLength parameter. If you want the range of text to extend to the end of the text buffer, you can pass the constant kATSUToTextEnd.
iTextTotalLength

A UniCharCount value specifying the length of the entire text buffer. This value should be greater than or equal to the range of text defined by the iTextLength parameter.
Return Value

A result code. See “ATSUI Result Codes”.
Discussion

For ATSUI to render your text, you must associate the text with both a text layout object and style information. Some functions, such as ATSUCreateTextLayoutWithTextPtr, create a text layout object and associate text with it concurrently. However, if you use the function ATSUCreateTextLayout to create a text layout object, you must assign text to the object prior to attempting most ATSUI operations.

You can use the function ATSUSetTextPointerLocation or to associate text with a text layout object. When you call this function, you are both assigning a text buffer to a text layout object and specifying the current text subrange within the buffer to include in the layout.

If there is already text associated with a text layout object, calling ATSUSetTextPointerLocation overrides the previously associated text, as well as clearing the object’s layout caches. You would typically only call this function for a text layout object with existing associated text if either (a) both the buffer itself is relocated and a subrange of the buffer’s text is deleted or inserted or (b) when associating an entirely different buffer with a text layout object.

Note that, because ATSUI objects retain state, doing superfluous calling can degrade performance. For example, you could call ATSUSetTextPointerLocation rather than ATSUTextInserted when the user simply inserts a subrange of text within a text buffer, but there would be a performance penalty, as all the layout caches are flushed by ATSUSetTextPointerLocation, rather than just the affected ones.

Similarly, you should not call ATSUSetTextPointerLocation, when an entire text buffer associated with a text layout object is relocated, but no other changes have occurred that would affect the buffer’s current subrange. Instead, you should call ATSUTextMoved, which is a more focused function and therefore more efficient.

After associating text with a text layout object, use ATSUSetRunStyle to associate style information with the text. You can then call the function ATSUDrawText to display the text or a subrange of the text.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeObjects.h*/
OSStatus ATSUSetTextPointerLocation (
   ATSUTextLayout iTextLayout,
   ConstUniCharArrayPtr iText,
   UniCharArrayOffset iTextOffset,
   UniCharCount iTextLength,
   UniCharCount iTextTotalLength
){};


/*ATSUTextInserted

Informs ATSUI of the location and length of a text insertion.

OSStatus ATSUTextInserted (
   ATSUTextLayout iTextLayout,
   UniCharArrayOffset iInsertionLocation,
   UniCharCount iInsertionLength
);
Parameters
iTextLayout

An ATSUTextLayout value specifying the text layout object containing the inserted text. 
iInsertionLocation

A UniCharArrayOffset value specifying the offset from the beginning of the text buffer to the memory location of the inserted text. To specify an insertion point at the beginning of the text buffer, you can pass the constant kATSUFromTextBeginning. 
iInsertionLength

A UniCharCount value specifying the length of the inserted text.
Return Value

A result code. See “ATSUI Result Codes”.
Discussion

When you call the ATSUTextInserted function to inform ATSUI of a text insertion, it extends the style run containing the insertion point by the amount of the inserted text. If the insertion point is between two style runs, the first style run is extended to include the new text.

The ATSUTextInserted function also extends the total length of the text buffer containing the inserted text by the amount of the inserted text. That is, it shifts the memory location of the text following the inserted text by iInsertionLength. ATSUTextInserted then updates drawing caches.

Note that the ATSUTextInserted function does not change the actual memory location of the inserted text. You are responsible for placing the inserted text into the text buffer at the appropriate location.

The ATSUTextInserted function does not insert style runs or line breaks; to do so, call the functions ATSUSetRunStyle and ATSUSetSoftLineBreak, respectively. Break line operations should be redone after you call ATSUTextInserted.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeObjects.h*/

OSStatus ATSUTextInserted (
   ATSUTextLayout iTextLayout,
   UniCharArrayOffset iInsertionLocation,
   UniCharCount iInsertionLength
){};


/*ATSUGetGlyphBounds

Obtains the typographic bounds of a line of glyphs after final layout. 

OSStatus ATSUGetGlyphBounds (
   ATSUTextLayout iTextLayout,
   ATSUTextMeasurement iTextBasePointX,
   ATSUTextMeasurement iTextBasePointY,
   UniCharArrayOffset iBoundsCharStart,
   UniCharCount iBoundsCharLength,
   UInt16 iTypeOfBounds,
   ItemCount iMaxNumberOfBounds,
   ATSTrapezoid *oGlyphBounds,
   ItemCount *oActualNumberOfBounds
);
Parameters
iTextLayout

An ATSUTextLayout value specifying the text layout object to examine. 
iTextBasePointX

An ATSUTextMeasurement value specifying the x-coordinate of the origin of the line containing the glyphs in the current graphics port or Quartz graphics context. Pass the constant kATSUUseGrafPortPenLoc, described in “Convenience Constants”, to obtain the glyph bounds relative to the current pen location in the current graphics port or graphics context. You can pass 0 to obtain only the dimensions of the bounds relative to one another, not their actual onscreen position. 
iTextBasePointY

An ATSUTextMeasurement value specifying the y-coordinate of the origin of the line containing the glyphs in the current graphics port or Quartz graphics context. Pass the constant kATSUUseGrafPortPenLoc, described in “Convenience Constants”, to obtain the glyph bounds relative to the current pen location in the current graphics port or graphics context. You can pass 0 to obtain only the dimensions of the bounds relative to one another, not their actual onscreen position. 
iBoundsCharStart

A UniCharArrayOffset value specifying the offset from the beginning of the text buffer to the character corresponding to the first glyph to measure. To indicate that the text range starts at the beginning of the text buffer, you can pass the constant kATSUFromTextBeginning. 
iBoundsCharLength

A UniCharCount value specifying the length of the text range to measure. If you want the range to extend to the end of the text buffer, you can pass the constant kATSUToTextEnd.
iTypeOfBounds

A glyph bounds constant indicating whether the width of the resulting typographic glyph bounds is determined using the caret origin (midway between two characters), the glyph origin in device space, or the glyph origin in fractional absolute positions (uncorrected for device display). See “Glyph Origin Selectors” for a description of possible values.
iMaxNumberOfBounds

An ItemCount value specifying the maximum number of bounding trapezoids to obtain. Typically, this is equivalent to the number of bounds in the oGlyphBounds array. To determine this value, see the Discussion. 
oGlyphBounds

A pointer to memory you have allocated for an array of ATSTrapezoid values. On return, the array contains a trapezoid representing the typographic bounds for glyphs in the text range. If the specified range of text encloses nested bidirectional text, ATSUGetGlyphBounds produces multiple trapezoids defining these regions.In ATSUI 1.1, the maximum number of enclosing trapezoids that can be returned is 31; in ATSUI 1.2, the maximum number is 127. If you pass a range that covers an entire line, ATSUGetGlyphBounds returns 1 trapezoid. If you are uncertain of how much memory to allocate for this array, see the Discussion. 
oActualNumberOfBounds

A pointer to an ItemCount value. On return, the value specifies the actual number of enclosing trapezoids bounding the specified characters. This may be greater than the value you provide in the iMaxNumberOfBounds parameter.
Return Value

A result code. See “ATSUI Result Codes”.
Discussion

There are two kinds of bounds that your application may typically want to obtain for a block of text: typographic bounds and image bounds. The image bounds define the smallest rectangle that completely encloses the filled or framed parts of a block of text—that is, the text’s “inked” glyphs. Because of the potential differences in glyph height in a text block, your application may instead need to determine the typographic bounds. The typographic bounding rectangle contains the extra space above and below the image bounding rectangle where characters with ascenders or descenders would be drawn (even if none currently are).

The ATSUGetGlyphBounds function produces the enclosing trapezoid(s) that represent the typographic bounds for glyphs in a final, laid-out range of text. You typically call this function when you need to obtain an enclosing trapezoid for a line, taking rotation and all other layout attributes into account.

ATSUI determines the height of each trapezoid by examining any line ascent and descent attribute values you may have set for the line. If you have not set these attributes for the line, the ATSUGetGlyphBounds function uses any line ascent and descent values you may have set for the text layout object containing the line. If these are not set, ATSUGetGlyphBounds uses the font’s natural line ascent and descent values for the line. If these are previously set, ATSUGetGlyphBounds uses the ATSUStyle ascent and or descent/leading values.

Depending on the value you pass in the iTypeOfBounds parameter, the width of the resulting trapezoid(s) is determined using one of the following values:
the caret origin, located halfway between two characters, which should be used when performing your own highlighting
the glyph origin in device space, which is useful for obtaining bounds adjusted for specific rendering and device constraints
the glyph origin in fractional (or “ideal”) absolute positions, uncorrected for device display

Note that the coordinates produced for the trapezoid(s) are offset by the amount specified in the iTextBasePointX and iTextBasePointY parameters. If your goal in calling the ATSUGetGlyphBounds function is to obtain metrics for drawing the typographic bounds on the screen, pass the position of the origin of the line in the current graphics port or graphics context in these parameters. This enables ATSUGetGlyphBounds to match the trapezoids to their onscreen image. 

Before calculating the typographic glyph bounds for the given text range, the ATSUGetGlyphBounds function examines the text layout object to make sure that the style runs cover the entire range of text. If there are gaps between style runs, ATSUGetGlyphBounds assigns the characters in the gap to the style run following the gap. If there is no style run at the beginning of the range of text, ATSUGetGlyphBounds assigns these characters to the first style run it can find. If there is no style run at the end of the range of text, ATSUGetGlyphBounds assigns the remaining characters to the last style run it can find.

Typically you use the ATSUGetGlyphBounds function by calling it twice, as follows:
Pass NULL for the oGlyphBounds parameter, 0 for the iMaxNumberOfBounds parameter, and valid values for the other parameters. The ATSUGetGlyphBounds function returns the actual number of trapezoids needed to enclose the glyphs in the oActualNumberOfBounds parameter.
Allocate enough space for a buffer of the returned size, then call the function again, passing a valid pointer to the buffer in the oGlyphBounds parameter. On return, the buffer contains the trapezoids for the glyphs’ typographic bounds. 

To obtain the typographic bounds of a line of text prior to line layout, call the function ATSUGetUnjustifiedBounds. To calculate the image bounding rectangle for a final laid-out line, call the function ATSUMeasureTextImage. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeDrawing.h*/

OSStatus ATSUGetGlyphBounds (
   ATSUTextLayout iTextLayout,
   ATSUTextMeasurement iTextBasePointX,
   ATSUTextMeasurement iTextBasePointY,
   UniCharArrayOffset iBoundsCharStart,
   UniCharCount iBoundsCharLength,
   UInt16 iTypeOfBounds,
   ItemCount iMaxNumberOfBounds,
   ATSTrapezoid *oGlyphBounds,
   ItemCount *oActualNumberOfBounds
){};


/*SyncCGContextOriginWithPort

Synchronizes the origin in a Quartz context with the lower-left corner of the associated graphics port. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

OSStatus SyncCGContextOriginWithPort (
   CGContextRef context,
   CGrafPtr port
);
Parameters
context

A Quartz context associated with a graphics port. You can obtain such a context by calling QDBeginCGContext.
port

The graphics port associated with the context.
Return Value

A result code. If noErr, the context’s origin was successfully changed.
Discussion

If you’re using Quartz 2D to draw in a graphics port and SetOrigin is called to change the port’s origin, you can call this function to maintain the correspondence between the context’s origin and the lower-left corner of the portBounds rectangle.

When you call this function:
The current transformation matrix (CTM) is reset to its default values. Any changes you made to the CTM prior to calling this function are lost.
The CTM is translated to establish the new origin, taking the port’s current origin into account.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
OSStatus SyncCGContextOriginWithPort (
   CGContextRef context,
   CGrafPtr port
){};


/*ATSUDrawText

Renders a range of text at a specified location in a QuickDraw graphics port or Quartz graphics context.

OSStatus ATSUDrawText (
   ATSUTextLayout iTextLayout,
   UniCharArrayOffset iLineOffset,
   UniCharCount iLineLength,
   ATSUTextMeasurement iLocationX,
   ATSUTextMeasurement iLocationY
);
Parameters
iTextLayout

An ATSUTextLayout value identifying the text layout object for which to render text. 
iLineOffset

A UniCharArrayOffset value specifying the offset from the beginning of the text buffer to the first character of the range to render. The function ATSUDrawText renders text to the first soft line break it encounters. If the range of text spans multiple lines, you should call ATSUDrawText for each line, passing the offset corresponding to the beginning of the new line to draw with each call. To indicate that the specified text range starts at the beginning of the text buffer, you can pass the constant kATSUFromTextBeginning. To specify the entire text buffer, pass kATSUFromTextBeginning in this parameter and kATSUToTextEnd in the iLineLength parameter. 
iLineLength

A UniCharCount value specifying the length of the text range to render. If you want the range of text to extend to the end of the text buffer, you can pass the constant kATSUToTextEnd. Keep in mind that the function ATSUDrawText renders text one line at a time. If the range of text spans multiple lines, you must call ATSUDrawText for each line.
iLocationX

An ATSUTextMeasurement value specifying the x-coordinate of the origin (in either the current QuickDraw graphics port or in a Quartz graphics context) of the line containing the text range to render. Note that the ATSUTextMeasurement type is defined as a Fixed value, so you must ensure that your coordinates are converted to Fixed values before passing them to this function. Pass the constant kATSUUseGrafPortPenLoc, described in “Convenience Constants”, to draw relative to the current pen location in the current graphics port. 
iLocationY

An ATSUTextMeasurement value specifying the y-coordinate of the origin (in either the current graphics port or Quartz graphics context) of the line containing the text range to render. Note that the ATSUTextMeasurement type is defined as a Fixed value, so you must ensure that your coordinates are converted to Fixed values before passing them to this function. Pass the constant kATSUUseGrafPortPenLoc, described in “Convenience Constants”, to draw relative to the current pen location in the current graphics port. 
Return Value

A result code. See “ATSUI Result Codes”.
Discussion

The ATSUDrawText function renders a range of text at a specified location in a QuickDraw graphics port or Quartz graphics context. This function renders text to the first soft line break it encounters. If you draw into a QuickDraw graphics port you get the best performance by using a bit depth of 16 bits. If you use bit depths of 1, 4, or 8, your application incurs a performance penalty.

You typically call the ATSUDrawText function every time you need to draw or redraw unhighlighted text. To draw highlighted text, call the function ATSUHighlightText.

ATSUDrawText uses the transfer mode and resolution that are set in the graphics port or graphics context. If you explicitly set in the style object, then text color is taken from the style object, and the value in the graphics port/context is ignored. If the text color was not explicitly set in the style object, ATSUDrawText uses the graphics port/context setting.

ATSUDrawText examines the text layout object to ensure that each of the characters in the range is assigned to a style run. If there are gaps between style runs, ATSUI assigns the characters in the gap to the style run that precedes (in storage order) the gap. If there is no style run at the beginning of the text range, ATSUI assigns these characters to the first style run it finds. If there is no style run at the end of the text range, ATSUI assigns the remaining characters to the last style run it finds.

If you want to draw a range of text that spans multiple lines, you should call ATSUDrawText for each line of text to draw, even if all the lines are in the same text layout object. You should adjust the iLineOffset parameter to reflect the beginning of each line to be drawn.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeDrawing.h*/

OSStatus ATSUDrawText (
   ATSUTextLayout iTextLayout,
   UniCharArrayOffset iLineOffset,
   UniCharCount iLineLength,
   ATSUTextMeasurement iLocationX,
   ATSUTextMeasurement iLocationY
){};



/*SetCursor

Sets the current cursor. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void SetCursor (
   const Cursor * crsr
);
Parameters
crsr

A Cursor structure for the cursor to be displayed. 
Discussion

If the cursor is hidden, it remains hidden and attains its new appearance only when it’s uncovered. If the cursor is already visible, it changes to the new appearance immediately.

You need to use the InitCursor function to initialize the standard arrow cursor and make it visible on the screen before you call SetCursor to change the cursor’s appearance. 

To display a color cursor, use the SetCCursor function. 
Availability
Deprecated in Mac OS X v10.4.
Available in Mac OS X v10.0 and later.
Declared In
Quickdraw.h*/

void SetCursor (
   const Cursor * crsr
){};


/*GetCursor

Loads a cursor resource into memory. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

CursHandle GetCursor (
   short cursorID
);
Parameters
cursorID

The resource ID for the cursor you want to display. You can supply one of the Cursor ID Constants to get a handle to one of the standard cursors.
Return Value

A handle to a Cursor structure for the cursor with the resource ID that you specify in the cursorID parameter. If the resource cannot be read into memory, GetCursor returns NULL. 
Discussion

To get a handle to a color cursor, use the GetCCursor function. 
Availability
Deprecated in Mac OS X v10.4.
Available in Mac OS X v10.0 and later.
Declared In
Quickdraw.h*/
CursHandle GetCursor (
   short cursorID
){};


/*PtInRgn

Determines whether a pixel is within a region. (Deprecated in Mac OS X v10.4.)

Boolean PtInRgn (
   Point pt,
   RgnHandle rgn
);
Parameters
pt

The point whose pixel is to be checked.
rgn

A handle to the region to test. 
Return Value

TRUE if the pixel below and to the right of the point specified in the pt parameter is within the region whose handle is specified in the rgn parameter. FALSE if it is not. 
Discussion

If the points or rectangles supplied to this function are defined in a graphics port other than your current graphics port, you must convert them to the local coordinate system of your current graphics port. You can accomplish this by using the SetPort function to change to the graphics port containing the points or rectangles, using the LocalGlobal function to convert their locations to global coordinates, using SetPort to return to your starting graphics port, and then using the GlobalToLocal function to convert the locations of points or rectangles to the local coordinates of your current graphics port. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

Boolean PtInRgn (
   Point pt,
   RgnHandle rgn
){};


/*GetPortVisibleRegion

(Deprecated. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

RgnHandle GetPortVisibleRegion (
   CGrafPtr port,
   RgnHandle visRgn
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Declared In
Quickdraw.h*/

RgnHandle GetPortVisibleRegion (
   CGrafPtr port,
   RgnHandle visRgn
){};


/*GetQDGlobalsArrow

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

Cursor * GetQDGlobalsArrow (
   Cursor * arrow
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

Cursor * GetQDGlobalsArrow (
   Cursor * arrow
){};


/*PaintOval

Paints an oval with the graphics pen’s pattern and pattern mode. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void PaintOval (
   const Rect * r
);
Parameters
r

The rectangle that defines the oval’s boundary.
Discussion

Using the pen pattern and pattern mode for the current graphics port, the PaintOval function draws the interior of an oval just inside the bounding rectangle that you specify in the r parameter. The pen location does not change.

Use FillOval to draw the interior of an oval with a pen pattern different from that for the current graphics port. 
Special Considerations

The PaintOval function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

void PaintOval (
   const Rect * r
){};



/*InvertColor

Finds the complement of an RGBColor data structure. This function is used only by system software. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void InvertColor (
   RGBColor * myColor
);
Parameters
myColor

A pointer to the RGBColor data structure for which the complement is to be found.The InvertColor function returns the complement of an absolute color, using the list of complement functions in the current device data structure. The default complement function uses the one’s complement of each component of the given color. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

void InvertColor (
   RGBColor * myColor
){};


/*QDIsPortBuffered

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

Boolean QDIsPortBuffered (
   CGrafPtr port
);
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

Boolean QDIsPortBuffered (
   CGrafPtr port
){};




/*CreateNewPortForCGDisplayID

Creates a graphics port associated with a display. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

CGrafPtr CreateNewPortForCGDisplayID (
   UInt32 displayID
);
Parameters
displayID

A display identifier. If the identifier is not valid, the main display is used instead. For information about finding displays, see Quartz Display Services Reference.
Return Value

A new display port. The portBounds rectangle is the same size as the display. When you are finished using the port, you should call DisposePort to release it.
Discussion

This function returns a graphics port used to draw directly to a display. The pixel map for the new port is taken from the GDevice record corresponding to the display. There is no back buffer associated with the port.

Before calling this function, you should capture the display. For information about capturing displays, see Quartz Display Services Reference.

You should not call this function and then attempt to create a Quartz drawing environment inside the port. Instead, applications using Quartz 2D can call CGDisplayGetDrawingContext to obtain a context suitable for drawing directly to a captured display.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

CGrafPtr CreateNewPortForCGDisplayID (
   UInt32 displayID
){};

/*NewGWorld

Creates an offscreen graphics world. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

QDErr NewGWorld (
   GWorldPtr * offscreenGWorld,
   short PixelDepth,
   const Rect * boundsRect,
   CTabHandle cTable,
   GDHandle aGDevice,
   GWorldFlags flags
);
Parameters
offscreenGWorld

On return, a pointer to the offscreen graphics world created by this function. You use this pointer when referring to this new offscreen world in other QuickDraw functions. 
PixelDepth

The pixel depth of the offscreen world; possible depths are 1, 2, 4, 8, 16, and 32 bits per pixel. The default parameter (0) uses the pixel depth of the screen with the greatest pixel depth from among all screens whose boundary rectangles intersect the rectangle that you specify in the boundsRect parameter. If you specify 0 in this parameter, NewGWorld also uses the GDevice structure from this device instead of creating a new GDevice structure for the offscreen world. If you use NewGWorld on a computer that supports only basic QuickDraw, you may specify only 0 or 1 in this parameter.
boundsRect

The boundary rectangle and port rectangle for the offscreen pixel map. This becomes the boundary rectangle for the GDevice structure, if NewGWorld creates one. If you specify 0 in the pixelDepth parameter, NewGWorld interprets the boundaries in global coordinates that it uses to determine which screens intersect the rectangle. NewGWorld then uses the pixel depth, color table, and GDevice structure from the screen with the greatest pixel depth from among all screens whose boundary rectangles intersect this rectangle. Typically, your application supplies this parameter with the port rectangle for the onscreen window into which your application will copy the pixel image from this offscreen world.
cTable

A handle to a ColorTable structure. If you pass NULL in this parameter, NewGWorld uses the default color table for the pixel depth that you specify in the pixelDepth parameter. If you set the pixelDepth parameter to 0, NewGWorld ignores the cTable parameter and instead copies and uses the color table of the graphics device with the greatest pixel depth among all graphics devices whose boundary rectangles intersect the rectangle that you specify in the boundsRect parameter. If you use NewGWorld on a computer that supports only basic QuickDraw, you may specify only NULL in this parameter. 
aGDevice

A handle to a GDevice structure that is used only when you specify the noNewDevice flag in the flags parameter, in which case NewGWorld attaches this GDevice structure to the new offscreen graphics world. If you set the pixelDepth parameter to 0, or if you do not set the noNewDevice flag, NewGWorld ignores the aGDevice parameter, so set it to NULL. If you set the pixelDepth parameter to 0, NewGWorld uses the GDevice structure for the graphics device with the greatest pixel depth among all graphics devices whose boundary rectangles intersect the rectangle that you specify in the boundsRect parameter. You should pass NULL in this parameter if the computer supports only basic QuickDraw. Generally, your application should never create GDevice structures for offscreen graphics worlds. 
flags

Options available to your application. You can set a combination of the flags pixPurge, noNewDevice, useTempMem, and keepLocal. If you don’t wish to use any of these flags, specify 0 in this parameter to accept the default behavior for NewGWorld. The default behavior creates an offscreen graphics world where the base address for the offscreen pixel image is unpurgeable, it uses an existing GDevice structure (if you pass 0 in the depth parameter) or creates a new GDevice structure, it uses memory in your application heap, and it allows graphics accelerators to cache the offscreen pixel image. See Graphics World Flags for a description of the values you can use here. 
Return Value

A result code.
Discussion

Typically, you pass 0 in the pixelDepth parameter, a window’s port rectangle in the boundsRect parameter, NULL in the cTable and aGDevice parameters, and in the flags parameter a 0. This provides your application with the default behavior of NewGWorld, and it supports computers running basic QuickDraw. This also allows QuickDraw to optimize the CopyBits, CopyMask, and CopyDeepMask functions when your application copies the image in an offscreen graphics world into an onscreen graphics port.

The NewGWorld function allocates memory for an offscreen graphics port and its pixel map. On computers that support only basic QuickDraw, NewGWorld creates a 1-bit pixel map that your application can manipulate using other relevant functions described in this chapter. Your application can copy this 1-bit pixel map into basic graphics ports.

Unless you specify 0 in the pixelDepth parameter–or pass the noNewDevice flag in the flags parameter and supply a GDevice structure in the aGDevice parameter– NewGWorld also allocates a new offscreen GDevice structure.

When creating an image, use the NewGWorld function to create an offscreen graphics world that is optimized for an image’s characteristics—for example, its best pixel depth. After creating the image, use the CopyBits, CopyMask, or CopyDeepMask function to copy that image to an onscreen graphics port. Color QuickDraw automatically renders the image at the best available pixel depth for the screen. Creating an image in an offscreen graphics port and then copying it to the screen in this way prevents the visual choppiness that would otherwise occur if your application were to build a complex image directly onscreen.

The NewGWorld function initializes the offscreen graphics port by calling the OpenCPort function. The NewGWorld function sets the offscreen graphics port’s visible region to a rectangular region coincident with its boundary rectangle. The NewGWorld function generates an inverse table with the Color Manager function MakeITable, unless one of the GDevice structures for the screens has the same color table as the GDevice structure for the offscreen world, in which case NewGWorld uses the inverse table from that GDevice structure.

The address of the offscreen pixel image is not directly accessible from the PixMap structure for the offscreen graphics world. However, you can use the GetPixBaseAddr function to get a pointer to the beginning of the offscreen pixel image. 

For purposes of estimating memory use, you can compute the size of the offscreen pixel image by using this formula:

rowBytes * (boundsRect.bottom – boundsRect.top)

In the flags parameter, you can specify several options. If you don’t want to use any of these options, pass 0 in the flags parameter:
If you specify the pixPurge flag, NewGWorld stores the offscreen pixel image in a purgeable block of memory. In this case, before drawing to or from the offscreen pixel image, your application should call the LockPixels function and ensure that it returns TRUE. If LockPixels returns FALSE, the memory for the pixel image has been purged, and your application should either call UpdateGWorld to reallocate it and then reconstruct the pixel image, or draw directly in a window instead of preparing the image in an offscreen graphics world. Never draw to or copy from an offscreen pixel image that has been purged without reallocating its memory and then reconstructing it. 
If you specify the noNewDevice flag, NewGWorld does not create a new offscreen GDevice structure. Instead, it uses the GDevice structure that you specify in the aGDevice parameter–and its associated pixel depth and color table–to create the offscreen graphics world. (If you set the pixelDepth parameter to 0, NewGWorld uses the GDevice structure for the screen with the greatest pixel depth among all the screens whose boundary rectangles intersect the rectangle that you specify in the boundsRect parameter–even if you specify the noNewDevice flag.) The NewGWorld function keeps a reference to the GDevice structure for the offscreen graphics world, and the SetGWorld function uses that structure to set the current graphics device. 
If you set the useTempMem flag, NewGWorld creates the base address for an offscreen pixel image in temporary memory. You generally would not use this flag, because you should use temporary memory only for fleeting purposes and only with the AllowPurgePixels function. 
If you specify the keepLocal flag, your offscreen pixel image is kept in Macintosh main memory and is not cached to a graphics accelerator card. use this flag carefully, as it negates the advantages provided by any graphics acceleration card that might be present. 

If your application needs to change the pixel depth, boundary rectangle, or color table for an offscreen graphics world, use the UpdateGWorld function. 
Special Considerations

If you supply a handle to a ColorTable structure in the cTable parameter, NewGWorld makes a copy of the structure and stores its handle in the offscreen PixMap structure. It is your application’s responsibility to make sure that the ColorTable structure you specify in the cTable parameter is valid for the offscreen graphics port’s pixel depth. 

If when using NewGWorld you specify a pixel depth, color table, or GDevice structure that differs from those used by the window into which you copy your offscreen image, the CopyBits, CopyMask, and CopyDeepMask functions require extra time to complete.

To use a custom color table in an offscreen graphics world, you need to create the associated offscreen GDevice structure, because Color QuickDraw needs its inverse table. 

The NewGWorld function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
QDOffscreen.h*/
QDErr NewGWorld (
   GWorldPtr * offscreenGWorld,
   short PixelDepth,
   const Rect * boundsRect,
   CTabHandle cTable,
   GDHandle aGDevice,
   GWorldFlags flags
){};


/*DisposePort

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void DisposePort (
   CGrafPtr port
);
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void DisposePort (
   CGrafPtr port
){};

/*GetRegionBounds

(Deprecated in Mac OS X v10.4.)

Rect * GetRegionBounds (
   RgnHandle region,
   Rect * bounds
);
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
Rect * GetRegionBounds (
   RgnHandle region,
   Rect * bounds
){};


/*GetPortBitMapForCopyBits

(Deprecated. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

const BitMap * GetPortBitMapForCopyBits (
   CGrafPtr port
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Declared In
Quickdraw.h*/
const BitMap * GetPortBitMapForCopyBits (
   CGrafPtr port
){};


/*HideCursor

Hides the cursor if it is visible on the screen. (Deprecated in Mac OS X v10.4.)

void HideCursor ();
Discussion

The HideCursor function removes the cursor from the screen, restores the bits under the cursor image, and decrements the cursor level (which InitCursor initialized to 0). You might want to use HideCursor when the user is using the keyboard to create content in one of your application’s windows. Every call to HideCursor should be balanced by a subsequent call to the ShowCursor function. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void HideCursor (){};


/*ShowCursor

Displays a cursor hidden by the HideCursor or ShieldCursor functions. 

void ShowCursor ();
Discussion

ShowCursor increments the cursor level, which has been decremented by the HideCursor or ShieldCursor function and displays the cursor on the screen when the level is 0. A call to the ShowCursor function balances each previous call to the HideCursor or ShieldCursor function. The level is not incremented beyond 0, so extra calls to ShowCursor have no effect.

Low-level interrupt-driven functions link the cursor with the mouse position, so that if the cursor level is 0 and visible, the cursor automatically follows the mouse. 

If the cursor has been changed with the SetCursor function while hidden, ShowCursor displays the new cursor. 
Declared In
Quickdraw.h*/
void ShowCursor (){};

/*GetMainDevice

Obtains a handle to the GDevice structure for the main screen. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

GDHandle GetMainDevice ();
Return Value

A handle to the device for the main screen, which is the device containing the menu bar. 
Discussion

A handle to the main device is kept in the global variable MainDevice.

All existing GDevice structures are linked together in the device list. After using this function to obtain a handle to the current GDevice structure, your application can use the GetNextDevice function to obtain a handle to the next GDevice structure in the list. 
Special Considerations

The GetMainDevice function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
GDHandle GetMainDevice (){};


/*RGBBackColor

Changes the background color. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void RGBBackColor (
   const RGBColor * color
);
Parameters
color

An RGBColor structure. 
Discussion

If the current port is defined by a CGrafPort structure, QuickDraw supplies its rgbBkColor field with the RGB value that you specify in the color parameter, and places the pixel value most closely matching that color in the bkColor field. For indexed devices, the pixel value is an index to the current device’s CLUT. F or direct devices, the value is the 16-bit or 32-bit equivalent to the RGB value.

If the current port is defined by a GrafPort structure, basic QuickDraw supplies its fgColor field with a color value determined by taking the high bit of each of the red, green, and blue components of the color that you supply in the color parameter. Basic QuickDraw uses that 3-bit number to select a color from its eight-color system.

You can also use Palette Manager functions to set the background color.

To determine the current background color, use the GetBackColor function.

Because a pixel pattern already contains color, QuickDraw ignores the background color and foreground colors when your application draws with a pixel pattern. Use the PenPixPat function to assign a pixel pattern to the foreground pattern used by the graphics pen. Use the BackPixPat function to assign a pixel pattern as the background pattern for the current color graphics port. Use the FillCRect, FillCOval, FillCRoundRect, FillCArc, FillCRgn, and FillCPoly functions to fill shapes with a pixel pattern. 
Special Considerations

The RGBBackColor function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Version Notes

This function is available for basic QuickDraw only in System 7. To set the background color for basic graphics ports on older versions of system software, use the BackColor function.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void RGBBackColor (
   const RGBColor * color
){};

/*UnionRect

Calculates the smallest rectangle that encloses two rectangles. 

void UnionRect (
   const Rect * src1,
   const Rect * src2,
   Rect * dstRect
);
Parameters
src1

The first of two rectangles to enclose.
src2

The second of two rectangles to enclose.
dstRect

On return, a pointer to the smallest rectangle that encloses both of the rectangles you specify in the src1 and src2 parameters. One of the source rectangles may also be the destination.
Discussion

If the points or rectangles supplied to this function are defined in a graphics port other than your current graphics port, you must convert them to the local coordinate system of your current graphics port. You can accomplish this by using the SetPort function to change to the graphics port containing the points or rectangles, using the LocalGlobal function to convert their locations to global coordinates, using SetPort to return to your starting graphics port, and then using the GlobalToLocal function to convert the locations of points or rectangles to the local coordinates of your current graphics port. 
Declared In
Quickdraw.h*/
void UnionRect (
   const Rect * src1,
   const Rect * src2,
   Rect * dstRect
){};



/*CreateCGContextForPort

Creates a Quartz 2D drawing environment associated with a graphics port. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

Not Recommended

OSStatus CreateCGContextForPort (
   CGrafPtr port,
   CGContextRef * contextPtr
);
Parameters
port

A color graphics port in which to draw. Offscreen graphics worlds with pixel depths of 1, 2, 4, and 8 are not supported. When using Quartz 2D to draw in a offscreen graphics world, alpha information is always ignored. Printing ports are not supported—if you specify a printing port, this function does nothing and returns a non-zero result code. 
contextPtr

A pointer to your storage for a Quartz context. Upon completion, contextPtr points to a context associated with the port. The context matches the port’s pixel depth, width, and height. Otherwise the context is in a default state and does not necessarily match other port attributes such as foreground color, background color, or clip region.

You should release this context when you no longer need it.
Return Value

A result code. If noErr, the context was successfully created.
Discussion

This function is not recommended in Mac OS X version 10.1 and later. For information about its replacement, see QDBeginCGContext.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
OSStatus CreateCGContextForPort (
   CGrafPtr port,
   CGContextRef * contextPtr
){};


/*EmptyRgn

Determines whether a region is empty. (Deprecated in Mac OS X v10.4.)

Boolean EmptyRgn (
   RgnHandle rgn
);
Parameters
rgn

A handle to the region to test for emptiness. 
Return Value

TRUE if the region whose handle you pass in the rgn parameter is an empty region or FALSE if it is not. 
Discussion

The EmptyRgn function does not create an empty region. To create an empty region, you can perform any of the following operations:
Use NewRgn. 
Pass the handle to an empty region to CopyRgn. 
Pass an empty rectangle to either SetRectRgn or RectRgn. 
Call CloseRgn without a previous call to OpenRgn. 
Call CloseRgn without performing any drawing after calling OpenRgn. 
Pass an empty region to OffsetRgn. 
Pass an empty region or too large an inset to InsetRgn
Pass two nonintersecting regions to SectRgn. 
Pass two empty regions to UnionRgn. 
Pass two identical or nonintersecting regions to DiffRgn or XorRgn. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
Boolean EmptyRgn (
   RgnHandle rgn
){};


/*ForeColor

Changes the color of the “ink” used for framing, painting, and filling on computers that support only basic QuickDraw. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void ForeColor (
   long color
);
Parameters
color

One of eight color values. See Color Constants.
Discussion

By default, the foreground color of a GrafPort is black.

The ForeColor function sets the foreground color for the current graphics port to the color that you specify in the color parameter. When you draw with the patCopy and srcCopy transfer modes, for example, black pixels are drawn in the color you specify with ForeColor.

When printing, use the ColorBit function to set the foreground color.

All nonwhite colors appear as black on black-and-white screens. Before you use ForeColor, use the DeviceLoop function to determine the color characteristics of the current screen. 
Special Considerations

The ForeColor function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Version Notes

In System 7, you may instead use the color QuickDraw function RGBForeColor.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

void ForeColor (
   long color
){};



/*BackColor

Changes a basic graphics port’s background color. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void BackColor (
   long color
);
Parameters
color

One of eight color values. See Color Constants.
Discussion

The background color is the color of the pixels in the bitmap wherever no drawing has taken place. By default the background color of a GrafPort is white.

The BackColor function sets the background color for the current graphics port to the color that you specify in the color parameter. When you draw with the patCopy and srcCopy transfer modes, for example, white pixels are drawn in the color you specify with BackColor.

All nonwhite colors appear as black on black-and-white screens. Before you use BackColor, use the DeviceLoop function to determine the color characteristics of the current screen. 
Special Considerations

The BackColor function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Version Notes

In System 7, use the Color QuickDraw function RGBBackColor.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void BackColor (
   long color
){};


/*GetFontName

Obtains the name of a font family that has a specified family ID number. (Deprecated in Mac OS X v10.4. Use FMGetFontFamilyName instead.)

Not recommended.

void GetFontName (
   SInt16 familyID,
   Str255 name
);
Parameters
familyID

The font family ID.
name

On output, this parameter contains the font family name for the font family specified in familyID. If the font specified in the familyID parameter does not exist, name contains an empty string. 
Special Considerations

There are several alternatives that provide better compatibility with the operating system than using QuickDraw font functions . You may want to consider the following:
For drawing and measuring text, you can use the Appearance Manager API or the ATSUI API to render text directly through a Quartz graphics context. See Appearance Manager Reference, Rendering Unicode Text With ATSUI, and ATSUI Reference.
For accessing information on fonts tracked by the operating system, use the ATS for Fonts API. See Managing Fonts: ATS and Apple Type Services for Fonts Reference.
For accessing and modifying information on fonts in a Quartz graphics context, use the Quartz API. See Quartz 2D Programming Guide and Quartz 2D Reference Collection.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Fonts.h*/
void GetFontName (
   SInt16 familyID,
   Str255 name
){};



/*QDPictRelease

Releases a QDPict picture.

void QDPictRelease (
   QDPictRef picture
);
Parameters
picture

A QDPict picture which you created or retained.
Discussion

After you finish using a QDPict picture that you created or retained, you should call this function to release the picture. If the picture’s retain count becomes 0, this function frees the picture and any associated resources such as the picture’s data provider.
Availability
Available in Mac OS X v10.1 and later.
Declared In
QDPictToCGContext.h*/

void QDPictRelease (
   QDPictRef picture
){};

/*QDPictCreateWithURL

Creates a QDPict picture, using QuickDraw picture data specified with a Core Foundation URL.

QDPictRef QDPictCreateWithURL (
   CFURLRef url
);
Parameters
url

A Core Foundation URL that specifies a PICT file containing the QuickDraw picture data. The picture header data must begin at either the first byte or the 513th byte in the PICT file. The picture bounds must not be an empty rectangle.
Return Value

A new QDPict picture, or NULL if the picture data is not valid. The initial retain count is 1. After you finish using the picture, you should release it by calling QDPictRelease.
Discussion

This function creates a QDPict picture that you can draw in a Quartz context. For general information about QDPict pictures, see QDPictRef.
Availability
Available in Mac OS X v10.1 and later.
Declared In
QDPictToCGContext.h*/

QDPictRef QDPictCreateWithURL (
   CFURLRef url
){};


/*QDPictGetBounds

Returns the intended location and size of a QDPict picture.

CGRect QDPictGetBounds (
   QDPictRef picture
);
Parameters
picture

A QDPict picture.
Return Value

A Quartz rectangle that represents the intended location and size of the picture. The rectangle is in default user space with one unit = 1/72 inch, and the origin is the lower-left corner of the picture. 
Discussion

If the native resolution in the picture data is not 72 pixels per inch, the bounding rectangle returned by this function is scaled as follows:    width = width in pixels * 72 / horizontal resolution
    height = height in pixels * 72 / vertical resolution

Availability
Available in Mac OS X v10.1 and later.
Declared In
QDPictToCGContext.h*/
CGRect QDPictGetBounds (
   QDPictRef picture
){};

/*QDPictDrawToCGContext

Draws a QuickDraw picture in a Quartz context.

OSStatus QDPictDrawToCGContext (
   CGContextRef context,
   CGRect rect,
   QDPictRef picture
);
Parameters
context

The Quartz context in which to draw.
rect

The rectangular area in which to draw the picture. You should specify the origin and size of this rectangle in user space units. The origin is the lower left corner of the picture when drawn. If necessary, the picture is scaled to fit inside this rectangle. To get unscaled results, you should pass the rectangle returned by QDPictGetBounds. For additional information about scaling, see the discussion below.
picture

A QDPict picture.
Return Value

A result code. A non-zero result indicates that the picture was not successfully drawn.
Discussion

This function converts the picture data in a QDPict picture into an equivalent sequence of Quartz 2D graphics operations. Conceptually this is the same processing path taken when an application running in Mac OS X draws into a QuickDraw printing port. 

When drawing a QDPict picture in a Quartz context, there are two ways to change the horizontal or vertical scale of the picture:
Construct the drawing rectangle (see the rect parameter) by applying the change of scale to the bounds rectangle returned by QDPictGetBounds. In this case, QuickDraw scales all the graphic elements in the picture except for patterns—the same behavior as DrawPicture.
Prior to calling QDPictDrawToCGContext, apply the change of scale to the current transformation matrix in the Quartz context—for example, by calling CGContextScaleCTM. In this case, QuickDraw scales the entire picture including patterns.

In a bitmap-based context, the picture is rendered into the bitmap. In a PDF-based context, the picture is converted into a PDF content stream. If the picture uses transfer modes such as srcXor that do not have an analog in Quartz 2D, the PDF representation may not match the original exactly.
Availability
Available in Mac OS X v10.1 and later.
Declared In
QDPictToCGContext.h*/
OSStatus QDPictDrawToCGContext (
   CGContextRef context,
   CGRect rect,
   QDPictRef picture
){};


/*SetPortClipRegion

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void SetPortClipRegion (
   CGrafPtr port,
   RgnHandle clipRgn
);
Carbon Porting Notes

Use this new accessor function in place of direct access to structs.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

void SetPortClipRegion (
   CGrafPtr port,
   RgnHandle clipRgn
){};


/*GetClip

Saves the clipping region of the current graphics port (basic or color). (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void GetClip (
   RgnHandle rgn
);
Parameters
rgn

A handle to the region to be clipped. The GetClip function changes this region to one that’s equivalent to the clipping region of the current graphics port. The GetClip function doesn’t change the region handle. 
Discussion

You can use the GetClip and SetClip functions to preserve the current clipping region: use GetClip to save the current port’s clipping region, and use SetClip to restore it. If, for example, you want to draw a half-circle on the screen, you can set the clipping region to half of the square that would enclose the whole circle, and then draw the whole circle. Only the half within the clipping region is actually drawn in the graphics port.

The GetClip function may move or purge memory blocks in the application heap. Your application should not call this function at interrupt time. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void GetClip (
   RgnHandle rgn
){};


/*DrawPicture

Draws a picture on any type of output device. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void DrawPicture (
   PicHandle myPicture,
   const Rect * dstRect
);
Parameters
myPicture

A handle to the picture to be drawn. You must access a picture through its handle. 

When creating pictures, the OpenCPicture and OpenPicture functions return their handles. You can use the GetPicture function to get a handle to a QuickDraw picture stored in a 'PICT' resource. To get a handle to a QuickDraw picture stored in a 'PICT' file, you must use File Manager functions. To get a picture stored in the scrap, use the Scrap Manager function GetScrap to get a handle to its data and then coerce this handle to one of type PicHandle.

dstRect

A destination rectangle, specified in coordinates local to the current graphics port, in which to draw the picture. The DrawPicture function shrinks or expands the picture as necessary to align the borders of its bounding rectangle with the rectangle you specify in this parameter. To display a picture at a resolution other than that at which it was created, your application should compute an appropriate destination rectangle by scaling its width and height by the following factor:

scale factor = destination resolution / source resolution

For example, if a picture was created at 300 dpi and you want to display it at 75 dpi, then your application should compute the destination rectangle width and height as 1/4 of those of the picture’s bounding rectangle. Use the GetPictInfo function to gather information about a picture. The PictInfo structure returned by GetPictInfo returns the picture’s resolution in its hRes and vRes fields. The sourceRect field contains the bounding rectangle for displaying the image at its optimal resolution.
Discussion

Within the rectangle that you specify in the dstRect parameter, the DrawPicture function draws the picture that you specify in the myPicture parameter. 

The DrawPicture function passes any picture comments to the StdComment function pointed to by the commentProc field of the CQDProcs or QDProcs structure, which in turn is pointed to by the grafProcs field of a CGrafPort or GrafPort structure. The default StdComment function provided by QuickDraw does no comment processing whatsoever. If you want to process picture comments when drawing a picture, use the SetStdCProcs function to assist you in changing the CQDProcs structure and use the SetStdProcs function to assist you in changing the QDProcs structure. 
Special Considerations

Always use the ClipRect function to specify a clipping region appropriate for your picture before defining it with the OpenCPicture (or OpenPicture) function. If you do not use ClipRect to specify a clipping region, OpenCPicture uses the clipping region specified in the current graphics port. If the clipping region is very large (as it is when a graphics port is initialized) and you want to scale the picture, the clipping region can become invalid when DrawPicture scales the clipping region—in which case, your picture will not be drawn. On the other hand, if the graphics port specifies a small clipping region, part of your drawing may be clipped when DrawPicture draws it. Setting a clipping region equal to the port rectangle of the current graphics port always sets a valid clipping region.

When it scales, DrawPicture changes the size of the font instead of scaling the bits. However, the widths used by bitmap fonts are not always linear. For example, the 12-point width isn’t exactly 1/2 of the 24-point width. This can cause lines of text to become slightly longer or shorter as the picture is scaled. The difference is often insignificant, but if you are trying to draw a line of text that fits exactly into a box (a spreadsheet cell, for example), the difference can become noticeable to the user—most typically, at print time. The easiest way to avoid such problems is to specify a destination rectangle that is the same size as the bounding rectangle for the picture. Otherwise, your application may need to directly process the opcodes in the picture instead of using DrawPicture.

You may also have disappointing results if the fonts contained in an image are not available on the user’s system. Before displaying a picture, your application may want to use the Picture Utilities to determine what fonts are contained in the picture, and then use Font Manager functions to determine whether the fonts are available on the user’s system. If they are not, you can use Dialog Manager functions to display an alert box warning the user of display problems.

If there is insufficient memory to draw a picture in Color QuickDraw, the QDError function returns the result code noMemForPictPlaybackErr.

The DrawPicture function may move or purge memory.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void DrawPicture (
   PicHandle myPicture,
   const Rect * dstRect
){};

/*SetClip

Changes the clipping region of the current graphics port (basic or color) to a region you specify. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void SetClip (
   RgnHandle rgn
);
Parameters
rgn

A handle to a region. The SetClip function makes this region the clipping region of the current graphics port. The SetClip function doesn’t change the region handle, but instead affects the clipping region itself. 
Discussion

Since SetClip copies the specified region into the current graphics port’s clipping region, any subsequent changes you make to the region specified in the rgn parameter do not affect the clipping region of the graphics port.

The initial clipping region of a graphics port is an arbitrarily large rectangle. You can set the clipping region to any arbitrary region, to aid you in drawing inside the graphics port—for example, to avoid drawing over scroll bars when drawing into a window, you could define a clipping region that excludes the scroll bars. 

You can use the GetClip and SetClip functions to preserve the current clipping region: use GetClip to save the current port’s clipping region, and use SetClip to restore it.

All other system software functions preserve the current clipping region.

The SetClip function may move or purge memory blocks in the application heap. Your application should not call this function at interrupt time. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void SetClip (
   RgnHandle rgn
){};





/*ClipCGContextToRegion

Sets the clipping path in a Quartz 2D graphics context, using a clipping region. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

OSStatus ClipCGContextToRegion (
   CGContextRef context,
   const Rect * portRect,
   RgnHandle region
);
Parameters
context

A Quartz context associated with a graphics port. You can obtain such a context by calling QDBeginCGContext.
portRect

The portRect for the graphics port associated with the context.
region

A region that represents the desired clipping path.
Return Value

A result code. If noErr, the clipping path is now the region-based path.
Discussion

This function sets the clipping path in the specified context to closely approximate the geometry of the specified region. 

Unlike clipping in Quartz 2D, this function does not intersect the new region-based path with the current clipping path—the new path simply replaces the current clipping path.

You should use this function only when absolutely necessary—it’s relatively inefficient when compared to Quartz 2D clipping functions such as CGContextClipToRect.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

OSStatus ClipCGContextToRegion (
   CGContextRef context,
   const Rect * portRect,
   RgnHandle region
){};


/*GetPortClipRegion

(Deprecated. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

RgnHandle GetPortClipRegion (
   CGrafPtr port,
   RgnHandle clipRgn
);
Return Value
Carbon Porting Notes

Use this new accessor function in place of direct access to structs.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Quickdraw.h*/

RgnHandle GetPortClipRegion (
   CGrafPtr port,
   RgnHandle clipRgn
){};

/*FrameOval

Draws an outline inside an oval. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void FrameOval (
   const Rect * r
);
Parameters
r

The rectangle that defines the oval’s boundary.
Discussion

Using the pattern, pattern mode, and size of the graphics pen for the current graphics port, the FrameOval function draws an outline just inside the oval with the bounding rectangle that you specify in the r parameter. The outline is as wide as the pen width and as tall as the pen height. The pen location does not change.

If a region is open and being formed, the outside outline of the new oval is mathematically added to the region’s boundary. 
Special Considerations

The FrameOval function may move or purge memory blocks in the application; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

void FrameOval (
   const Rect * r
){};




/*GetPixRowBytes

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

long GetPixRowBytes (
   PixMapHandle pm
);
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
QDOffscreen.h*/

long GetPixRowBytes (
   PixMapHandle pm
){};


/*GetPortPixMap

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

PixMapHandle GetPortPixMap (
   CGrafPtr port
);
Return Value
Carbon Porting Notes

Use this new accessor function in place of direct access to structs.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

PixMapHandle GetPortPixMap (
   CGrafPtr port
){};



/*QDGlobalToLocalPoint

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

Point * QDGlobalToLocalPoint (
   CGrafPtr port,
   Point * point
);
Availability
Available in Mac OS X v10.2 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

Point * QDGlobalToLocalPoint (
   CGrafPtr port,
   Point * point
){};



/*NewGWorldFromPtr

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

QDErr NewGWorldFromPtr (
   GWorldPtr * offscreenGWorld,
   unsigned long PixelFormat,
   const Rect * boundsRect,
   CTabHandle cTable,
   GDHandle aGDevice,
   GWorldFlags flags,
   Ptr newBuffer,
   long rowBytes
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
QDOffscreen.h*/
QDErr NewGWorldFromPtr (
   GWorldPtr * offscreenGWorld,
   unsigned long PixelFormat,
   const Rect * boundsRect,
   CTabHandle cTable,
   GDHandle aGDevice,
   GWorldFlags flags,
   Ptr newBuffer,
   long rowBytes
){};



/*SetPt

Assigns two coordinates to a point. (Deprecated in Mac OS X v10.4.)

void SetPt (
   Point * pt,
   short h,
   short v
);
Parameters
pt

A pointer to the point to be given new coordinates. On return, this point is assigned the horizontal coordinate you specify in the h parameter and the vertical coordinate you specify in the v parameter.
h

The horizontal value of the new coordinates.
v

The vertical value of the new coordinates.
Discussion

The SetPt procedure assigns the horizontal coordinate specified in the h parameter and the vertical coordinate specified in the v parameter to the point returned in the pt parameter. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

void SetPt (
   Point * pt,
   short h,
   short v
){};


/*GetFontInfo

Returns information about the current graphics port’s font, taking into account the style and size in which the glyphs are to be drawn. (Deprecated in Mac OS X v10.4. Use ATSUI instead.)

void GetFontInfo (
   FontInfo * info
);
Parameters
info

Pointer to a font information structure that contains the font measurement information, in integer values. 
Discussion

The GetFontInfo function returns the ascent, descent, leading, and width of the largest glyph of the font in the text font, size, and style specified in the current graphics port. If the script system specified by the current graphics port txFont field has an associated font, as do Hebrew and Arabic, GetFontInfo returns combined information based on both fonts. This is to accommodate text written in the Roman script when the primary script system is non-Roman. However, even if all of the text is written in a non-Roman script, if there is an associated font, GetFontInfo always bases its information on the combined fonts. You can determine the line height, in pixels, by adding the values of the ascent, descent, and leading fields.

The GetFontInfo function is similar to the Font Manager’s FontMetrics function, except that the GetFontInfo function returns integer values. See FontInfo for a description of the structure and its fields. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
QuickdrawText.h*/

void GetFontInfo (
   FontInfo * info
){};

/*StringWidth

Returns the length, in pixels, of the specified text string. (Deprecated in Mac OS X v10.4. Use ATSUI instead.)

short StringWidth (
   ConstStr255Param s
);
Parameters
s

A Pascal string containing the text to be measured.
Return Value

The length, in pixels, of the specified text string. 
Discussion

You should not call StringWidth to measure scaled text. Although StringWidth takes into account the graphics port structure settings, it does not accept scaling parameters, and therefore cannot determine the correct text width result for text to be drawn using scaling factor parameters.

If you specify values in the graphics port spExtra or chExtra fields to change the width of space or nonspace characters, StringWidth takes these values into account.

Because this function measures text in the font, style, and size of the current graphics port, you need to call it once for each individual style run in any line of text that contains multiple style runs.

The StringWidth function works with all script systems. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
QuickdrawText.h*/
short StringWidth (
   ConstStr255Param s
){};

/*GetPortPenMode

(Deprecated. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

SInt32 GetPortPenMode (
   CGrafPtr port
);
Carbon Porting Notes

Use this new accessor function in place of direct access to structs.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Quickdraw.h*/
SInt32 GetPortPenMode (
   CGrafPtr port
){};


/*SetPortPenMode

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void SetPortPenMode (
   CGrafPtr port,
   SInt32 penMode
);
Carbon Porting Notes

Use this new accessor function in place of direct access to structs.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

void SetPortPenMode (
   CGrafPtr port,
   SInt32 penMode
){};



/*CharWidth

Returns the width (horizontel extension), in pixels, of the specified character. (Deprecated in Mac OS X v10.4. Use ATSUI instead.)

short CharWidth (
   CharParameter ch
);
Parameters
ch

The character whose width is to be measured. 
Return Value

The width (horizontel extension), in pixels, of the specified character. 
Discussion

The CharWidth function includes the effects of the stylistic variations for the text set in the current graphics port. If you change any of these attributes after determining the glyph width but before actually drawing it, the predetermined width may not be correct. For a space character, CharWidth also includes the effect of SpaceExtra. For a nonspace character, CharWidth includes the effect of CharExtra.

Because it takes a single-byte value as the ch parameter, CharWidth works only for 1-byte simple script systems.

A series of calls to CharWidth in a contextual 1-byte font may give incorrect results, because the width of a text segment may be different from the sum of its individual character widths. In that case, to measure a line of text you should call TextWidth.

Do not use the CharWidth function for 2-byte script systems. If you want to measure the width of a single glyph in a 2-byte font, you should use TextWidth. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
QuickdrawText.h*/
short CharWidth (
   CharParameter ch
){};


/*GetQDGlobalsThePort

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

CGrafPtr GetQDGlobalsThePort ();
Return Value
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
CGrafPtr GetQDGlobalsThePort (){};





/*LocalToGlobal

Converts a point’s coordinates from the local coordinates of the current graphics port (basic or color) to global coordinates. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void LocalToGlobal (
   Point * pt
);
Parameters
pt

A pointer to a point in local coordinates. On return, this point is converted to global coordinates.
Discussion

The LocalToGlobal function converts the given point from the current graphics port’s local coordinate system into the global coordinate system (where the upper-left corner of the main screen has coordinates [0,0]). This global point can then be compared to other global points, or it can be changed into the local coordinates of another graphics port.

Because a rectangle is defined by two points, you can convert a rectangle into global coordinates with two calls to LocalToGlobal. In conjunction with LocalToGlobal, you can use the OffsetRect, OffsetRgn, or OffsetPoly functions to convert a rectangle, region, or polygon into global coordinates. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

void LocalToGlobal (
   Point * pt
){};





/*GetMaxDevice

Obtains a handle to the GDevice structure for the video device with the greatest pixel depth. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

GDHandle GetMaxDevice (
   const Rect * globalRect
);
Parameters
globalRect

A rectangle, in global coordinates, that intersects the graphics devices that you are searching to find the one with the greatest pixel depth.
Return Value

A handle to the device with the greatest pixel depth. 
Discussion

All existing GDevice structures are linked together in the device list. After using this function to obtain a handle to the current GDevice structure, your application can use the GetNextDevice function to obtain a handle to the next GDevice structure in the list. 
Special Considerations

The GetMaxDevice function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
GDHandle GetMaxDevice (
   const Rect * globalRect
){};


/*ObscureCursor

Hides the cursor until the next time the user moves the mouse. (Deprecated in Mac OS X v10.4.)

void ObscureCursor ();
Discussion

Your application normally calls ObscureCursor when the user begins to type. Unlike HideCursor , ObscureCursor has no effect on the cursor level and must not be balanced by a call to ShowCursor. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void ObscureCursor (){};


/*SectRect

Determines whether two rectangles intersect. (Deprecated in Mac OS X v10.4.)

Boolean SectRect (
   const Rect * src1,
   const Rect * src2,
   Rect * dstRect
);
Parameters
src1

The first of two rectangles to test for intersection.
src2

The second of two rectangles to test for intersection.
dstRect

On return, a pointer to the rectangle marking the intersection of the first two rectangles.
Return Value

TRUE if the specified rectangles intersect or FALSE if they do not. 
Discussion

The SectRect function calculates the rectangle that delineates the intersection of the two rectangles you specify in the src1 and src2 parameters. Rectangles that touch at a line or a point are not considered intersecting, because their intersection rectangle (actually, in this case, an intersection line or point) does not enclose any pixels in the bit image.

If the rectangles do not intersect, the destination rectangle is set to (0,0,0,0). The SectRect function works correctly even if one of the source rectangles is also the destination.

If the points or rectangles supplied to this function are defined in a graphics port other than your current graphics port, you must convert them to the local coordinate system of your current graphics port. You can accomplish this by using the SetPort function to change to the graphics port containing the points or rectangles, using the LocalGlobal function to convert their locations to global coordinates, using SetPort to return to your starting graphics port, and then using the GlobalToLocal function to convert the locations of points or rectangles to the local coordinates of your current graphics port. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
Boolean SectRect (
   const Rect * src1,
   const Rect * src2,
   Rect * dstRect
){};

/*EraseRgn

Erases a region. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void EraseRgn (
   RgnHandle rgn
);
Parameters
rgn

The region to erase. 
Discussion

Using the patCopy pattern mode, the EraseRgn function draws the interior of the region whose handle you pass in the rgn parameter with the background pattern for the current graphics port. 

This function leaves the location of the graphics pen unchanged.

This function depends on the local coordinate system of the current graphics port. If you draw a region in a graphics port different from the one in which you defined the region, it may not appear in the proper position in the graphics port.

If any horizontal or vertical line drawn through the region would intersect the region’s outline more than 50 times, the results of this graphics operation are undefined. 
Special Considerations

The EraseRgn function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

void EraseRgn (
   RgnHandle rgn
){};


/*DiffRgn

Subtracts one region from another. (Deprecated in Mac OS X v10.4.)

void DiffRgn (
   RgnHandle srcRgnA,
   RgnHandle srcRgnB,
   RgnHandle dstRgn
);
Parameters
srcRgnA

A handle to the region to subtract from. 
srcRgnB

A handle to the region to subtract.
dstRgn

On return, a handle to the region holding the resulting area. If the first source region is empty, DiffRgn sets the destination to the empty region defined by the rectangle (0,0,0,0).

The DiffRgn function does not create the destination region; you must have already allocated memory for it by using the NewRgn function. 

The destination region may be one of the source regions, if desired.
Discussion

The DiffRgn procedure subtracts the region whose handle you pass in the srcRgnB parameter from the region whose handle you pass in the srcRgnA parameter and places the difference in the region whose handle you pass in the dstRgn parameter. If the first source region is empty, DiffRgn sets the destination to the empty region defined by the rectangle (0,0,0,0).

The DiffRgn procedure does not create the destination region; you must have already allocated memory for it by using the NewRgn function. The destination region may be one of the source regions, if desired. 
Special Considerations

The DiffRgn function may temporarily use heap space that’s twice the size of the two input regions.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void DiffRgn (
   RgnHandle srcRgnA,
   RgnHandle srcRgnB,
   RgnHandle dstRgn
){};


/*InsetRgn

Shrinks or expands a region. (Deprecated in Mac OS X v10.4.)

void InsetRgn (
   RgnHandle rgn,
   short dh,
   short dv
);
Parameters
rgn

A handle to the region to alter. 
dh

The horizontal distance to move points on the left and right boundaries in toward or outward from the center.
dv

The vertical distance to move points on the top and bottom boundaries in toward or outward from the center.
Discussion

The InsetRgn function moves all points on the region boundary of the region whose handle you pass in the rgn parameter inward by the vertical distance that you specify in the dv parameter and by the horizontal distance that you specify in the dh parameter. If you specify negative values for dh or dv, the InsetRgn function moves the points outward in that direction. 

The InsetRgn function leaves the region’s center at the same position, but moves the outline in (for positive values of dh and dv) or out (for negative values of dh and dv). Using InsetRgn on a rectangular region has the same effect as using the InsetRect function. 
Special Considerations

The InsetRgn function temporarily uses heap space that’s twice the size of the original region.

The InsetRgn function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

void InsetRgn (
   RgnHandle rgn,
   short dh,
   short dv
){};

/*SetPalette

Associates a palette with a window. (Deprecated in Mac OS X v10.4. There is no replacement; 8-bit graphics mode is not supported by the Mac OS X GUI.)

Not recommended.

void SetPalette (
   WindowRef dstWindow,
   PaletteHandle srcPalette,
   Boolean cUpdates
);
Parameters
dstWindow

A pointer to the window to which you want to assign a new palette. 
srcPalette

A handle to the palette you want to assign. 
cUpdates

A Boolean value in which your application specifies whether the window is to receive updates as a result of changes to the color environment. Specify TRUE if you want the window to be updated, even if the window is not the frontmost window. When a window is the frontmost window, changes to its palette cause it to get an update event regardless of how the cUpdates parameter is set. 
Discussion

You can use the NSetPalette function, which does the same thing as SetPalette, when you need greater flexibility in setting criteria for updates. The nCUpdates parameter for the NSetPalette function includes the option of turning off updates when the window is the frontmost window.

Use the NSetPalette function to associate a palette with a window but with additional options as to when an update event is triggered by changes to the color environment. 

Use the GetNewPalette function or the NewPalette function to create a new palette. To dispose of a palette, use the DisposePalette function. 
Special Considerations

For applications running in Mac OS X, the Palette Manager is no longer relevant because display devices always support direct color (pixel depth of 16 or 32 bits). The palette-based graphics model only works in 256-color (8-bit pseudocolor) modes of operation, which are not supported for the Mac OS X GUI.

There is some support for palettes in Quartz Services; see Quartz Display Services Reference.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Palettes.h*/
void SetPalette (
   WindowRef dstWindow,
   PaletteHandle srcPalette,
   Boolean cUpdates
){};

/*AddPt

Adds the coordinates of two points. (Deprecated in Mac OS X v10.4.)

void AddPt (
   Point src,
   Point * dst
);
Parameters
src

A point, the coordinates of which are to be added to the point in the dstPt parameter.
dst

A pointer to a point, the coordinates of which are to be added to the point in the srcPt parameter. On return, this value contains the result of adding the coordinates of the points you supplied in the srcPt and dstPt parameters.
Discussion

The AddPt function adds the coordinates of the point specified in the srcPt parameter to the coordinates of the point specified in the dstPt parameter, and returns the result in the dstPt parameter. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void AddPt (
   Point src,
   Point * dst
){};


/*QDLocalToGlobalRect

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

Rect * QDLocalToGlobalRect (
   CGrafPtr port,
   Rect * bounds
);
Availability
Available in Mac OS X v10.2 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

Rect * QDLocalToGlobalRect (
   CGrafPtr port,
   Rect * bounds
){};


/*TextMode

Sets the transfer mode for drawing text in the current graphics port. (Deprecated in Mac OS X v10.4. Use ATSUI or Quartz instead.)

void TextMode (
   short mode
);
Parameters
mode

The transfer mode to be used to draw the text. 
Discussion

The TextMode function sets the transfer mode in the graphics port txMode field. The transfer mode determines the interplay between what an application is drawing (the source) and what already exists on the display device (the destination), resulting in the text display.

There are two basic kinds of modes: pattern (pat) and source (src). Source is the kind that you use for drawing text. There are four basic Boolean operations: Copy, Or, Xor, and Bic (bit clear), each of which has an inverse variant in which the source is inverted before the transfer, yielding eight operations in all. Original QuickDraw supports these eight transfer modes. Color QuickDraw enables your application to achieve color effects within those basic transfer modes, and offers an additional set of transfer modes that perform arithmetic operations on the RGB values of the source and destination pixels. Other transfer modes are grayishTextOr, transparent mode, and text mask mode.

To ensure future compatibility and benefit from any enhancements, always use this function to modify the txMode field, rather than directly change the field value. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
QuickdrawText.h*/

void TextMode (
   short mode
){};



/*GetQDGlobalsLightGray

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

Pattern * GetQDGlobalsLightGray (
   Pattern * ltGray
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

Pattern * GetQDGlobalsLightGray (
   Pattern * ltGray
){};


/*GetCTSeed

Obtains a unique seed value for a color table created by your application. This function is used by system software and your application should not need to call it. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

long GetCTSeed ();
Return Value

A unique seed value that you can use in the ctSeed field of a color table created by your application. It is greater than the value stored in the constant minSeed. 
Discussion

The seed value guarantees that the color table is recognized as distinct from the destination, and that color table translation is performed properly. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
long GetCTSeed (){};





/*NewQDBitsUPP

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

QDBitsUPP NewQDBitsUPP (
   QDBitsProcPtr userRoutine
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

QDBitsUPP NewQDBitsUPP (
   QDBitsProcPtr userRoutine
){};


/*NewQDRgnUPP

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

QDRgnUPP NewQDRgnUPP (
   QDRgnProcPtr userRoutine
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

QDRgnUPP NewQDRgnUPP (
   QDRgnProcPtr userRoutine
){};



/*NewQDPolyUPP

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

QDPolyUPP NewQDPolyUPP (
   QDPolyProcPtr userRoutine
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

QDPolyUPP NewQDPolyUPP (
   QDPolyProcPtr userRoutine
){};


/*NewQDArcUPP

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

QDArcUPP NewQDArcUPP (
   QDArcProcPtr userRoutine
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/


QDArcUPP NewQDArcUPP (
   QDArcProcPtr userRoutine
){};


/*NewQDTextUPP

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

QDTextUPP NewQDTextUPP (
   QDTextProcPtr userRoutine
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h */

QDTextUPP NewQDTextUPP (
   QDTextProcPtr userRoutine
){};

/*NewQDRectUPP

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

QDRectUPP NewQDRectUPP (
   QDRectProcPtr userRoutine
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
QDRectUPP NewQDRectUPP (
   QDRectProcPtr userRoutine
){};


/*NewQDLineUPP

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

QDLineUPP NewQDLineUPP (
   QDLineProcPtr userRoutine
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

QDLineUPP NewQDLineUPP (
   QDLineProcPtr userRoutine
){};

/*NewQDOvalUPP

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

QDOvalUPP NewQDOvalUPP (
   QDOvalProcPtr userRoutine
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
QDOvalUPP NewQDOvalUPP (
   QDOvalProcPtr userRoutine
){};

/*NewQDRRectUPP

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

QDRRectUPP NewQDRRectUPP (
   QDRRectProcPtr userRoutine
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

QDRRectUPP NewQDRRectUPP (
   QDRRectProcPtr userRoutine
){};
/*SetStdCProcs

Obtains a CQDProcs structure with fields that point to QuickDraw’s standard low-level functions, which you can modify to change QuickDraw’s standard low-level behavior. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void SetStdCProcs (
   CQDProcs * procs
);
Parameters
procs

Upon completion, a CQDProcs structure with fields that point to QuickDraw’s standard low-level functions. You can change one or more fields to point to your own functions and then set the color graphics port to use this modified CQDProcs structure. 
Discussion

For each shape that QuickDraw can draw, certain functions perform basic graphics operations on the shape: framing, painting, erasing, inverting, and filling. These functions, in turn, call a low-level drawing function for the shape.

The grafProcs field determines which low-level functions are called. If that field contains a value of NULL, the standard functions are called. You can set the grafProcs field to point to a structure of pointers to your own functions, and either completely override the standard ones or call them after your functions have modified their parameters as necessary.

The SetStdCProcs function sets all the fields of the CQDProcs structure to point to the standard functions. You can then reset the ones with which you are concerned.

The functions you install in the CDQProcs structure must have the same calling sequences as the standard basic QuickDraw functions.

When drawing in a color graphics port, your application must always use SetStdCProcs instead of SetStdProcs. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

void SetStdCProcs (
   CQDProcs * procs
){};



/*GetPixDepth

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

short GetPixDepth (
   PixMapHandle pixMap
);
Carbon Porting Notes

Use this new accessor function in place of direct access to structs.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

short GetPixDepth (
   PixMapHandle pixMap
){};

/*BackPat

Changes the bit pattern used as the background pattern by the current graphics port. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void BackPat (
   const Pattern * pat
);
Parameters
pat

A bit pattern, as defined by a Pattern structure. 
Discussion

The BackPat function sets the bit pattern defined in the Pattern structure, which you specify in the pat parameter, to be the background pattern. (The standard bit patterns white, black, gray, ltGray, and dkGray are predefined; the initial background pattern for the graphics port is white.) This pattern is stored in the bkPat field of a GrafPort structure.

The BackPat function also sets a bit pattern for the background color in a color graphics port. The BackPat function creates a handle, of type PixPatHandle, for the bit pattern and stores this handle in the bkPixPat field of the CGrafPort structure. As in basic graphics ports, Color QuickDraw draws patterns in color graphics ports at the time of drawing, not at the time you use PenPat to set the pattern.

To define your own patterns, you typically create pattern, ‘PAT’, or pattern list, ‘PAT#’, resources. 
Special Considerations

The BackPat function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/


void BackPat (
   const Pattern * pat
){};

/*CTabChanged

Signals QuickDraw that the content of a ColorTable structure has been modified. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void CTabChanged (
   CTabHandle ctab
);
Parameters
ctab

A handle to the ColorTable structure changed by your application. 
Discussion

The CTabChanged function calls the function GetCTSeed and gets a new, unique identifier in the ctSeed field of the ColorTable structure, and notifies QuickDraw of the change.

Your application should never need to directly modify a ColorTable structure and use the CTabChanged function; instead, your application should use the QuickDraw functions provided for manipulating the values in a ColorTable structure. 
Special Considerations

The CTabChanged function may move or purge memory in the application heap; do not call the CTabChanged function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
QDOffscreen.h*/
void CTabChanged (
   CTabHandle ctab
){};


/*GetPicture

Obtains a handle to a picture stored in a 'PICT' resource. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

PicHandle GetPicture (
   short pictureID
);
Parameters
pictureID

The resource ID for a 'PICT' resource.
Return Value

A handle to the picture in the specified ‘PICT’ resource. To draw the picture stored in the resource, pass this handle to the DrawPicture function. If the resource cannot be read, GetPicture returns NULL. 
Discussion

The GetPicture function calls the Resource Manager function GetResource as follows:

GetResource(‘PICT’, picID) 
Special Considerations

To release the memory occupied by a picture stored in a 'PICT' resource, use the Resource Manager function ReleaseResource.

The GetPicture function may move or purge memory.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

PicHandle GetPicture (
   short pictureID
){};


/*GetCTable

Obtains a color table stored in a 'clut' resource. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

CTabHandle GetCTable (
   short ctID
);
Parameters
ctID

The resource ID of a 'clut' resource.
Return Value

A handle to the color table. If the 'clut' resource with that ID is not found, GetCTable returns NULL.Before you place this handle in the pmTable field of a PixMap structure, first use the DisposeCTable function to dispose of the handle already there. 
Discussion

Before you modify a ColorTable structure, change its ctSeed field to invalidate it. To do this, use the CTabChanged function.

The GetCTable function recognizes a number of standard 'clut' resource IDs. You can obtain the default grayscale color table for a given pixel depth by calling GetCTable, adding 32 (decimal) to the pixel depth, and passing these values in the ctID parameter:
A pixel depth of 1Pass a resource ID of 33. Color table composition: black, white. 
A pixel depth of 2Pass a resource ID of 34. Color table composition: black, 33% gray, 66% gray, white. 
A pixel depth of 4Pass a resource ID of 36. Color table composition: black, 14 shades of gray, white. 
A pixel depth of 8Pass a resource ID of 40. Color table composition: black, 254 shades of gray, white. 

For full color, obtain the default color tables by adding 64 to the pixel depth and passing these values in the ctID parameter:
A pixel depth of 2Pass a resource ID of 66. Color table composition: black, 50% gray, highlight color, white. 
A pixel depth of 4Pass a resource ID of 68. Color table composition: black, 14 colors including the highlight color, white. 
A pixel depth of 8Pass a resource ID of 72. Color table composition: black, 254 colors including the highlight color, white. 
Special Considerations

The GetCTable function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

CTabHandle GetCTable (
   short ctID
){};



/*EmptyRect

Determines whether a rectangle is an empty rectangle. (Deprecated in Mac OS X v10.4.)

Boolean EmptyRect (
   const Rect * r
);
Parameters
r

The rectangle to examine.
Return Value

TRUE if the rectangle that you specify in the r parameter is an empty rectangle, FALSE if it is not. A rectangle is considered empty if the bottom coordinate is less than or equal to the top coordinate or if the right coordinate is less than or equal to the left. 
Discussion

If the points or rectangles supplied to this function are defined in a graphics port other than your current graphics port, you must convert them to the local coordinate system of your current graphics port. You can accomplish this by using the SetPort function to change to the graphics port containing the points or rectangles, using the LocalGlobal function to convert their locations to global coordinates, using SetPort to return to your starting graphics port, and then using the GlobalToLocal function to convert the locations of points or rectangles to the local coordinates of your current graphics port. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

Boolean EmptyRect (
   const Rect * r
){};


/*EqualRect

Determines whether two rectangles are equal. 

Boolean EqualRect (
   const Rect * rect1,
   const Rect * rect2
);
Parameters
rect1

The first of two rectangles to compare.
rect2

The second of two rectangles to compare.
Return Value

TRUE if the rectangles are equal, FALSE if they are not. 
Discussion

If the points or rectangles supplied to this function are defined in a graphics port other than your current graphics port, you must convert them to the local coordinate system of your current graphics port. You can accomplish this by using the SetPort function to change to the graphics port containing the points or rectangles, using the LocalGlobal function to convert their locations to global coordinates, using SetPort to return to your starting graphics port, and then using the GlobalToLocal function to convert the locations of points or rectangles to the local coordinates of your current graphics port. 
Declared In
Quickdraw.h*/
Boolean EqualRect (
   const Rect * rect1,
   const Rect * rect2
){};

/*GetForeColor

Obtains the color of the foreground color for the current graphics port. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void GetForeColor (
   RGBColor * color
);
Parameters
color

On return, the RGBColor structure for the current foreground color. 
Discussion

This function operates for graphics ports defined by both the GrafPort and CGrafPort structures. If the current graphics port is defined by a CGrafPort structure, the returned value is taken directly from the rgbFgColor field. 

If the current graphics port is defined by a GrafPort structure, then only eight possible RGB values can be returned. These eight values are determined by the values in a global variable named QDColors, which is a handle to a color table containing the current QuickDraw colors.

Use the RGBForeColor function to change the foreground color. 
Version Notes

This function is available for basic QuickDraw only in System 7.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void GetForeColor (
   RGBColor * color
){};


/*PaintRgn

Paints a region with the graphics pen’s pattern and pattern mode. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void PaintRgn (
   RgnHandle rgn
);
Parameters
rgn

A handle to the region to paint. 
Discussion

Using the pen pattern and pattern mode for the current graphics port, the PaintRgn function draws the interior of the region whose handle you pass in the rgn parameter. The pen location does not change.

This function depends on the local coordinate system of the current graphics port. If you draw a region in a graphics port different from the one in which you defined the region, it may not appear in the proper position in the graphics port.

If any horizontal or vertical line drawn through the region would intersect the region’s outline more than 50 times, the results of this graphics operation are undefined. 

Use FillRgn to draw the interior of a region with a pen pattern different from that for the current graphics port. 
Special Considerations

The PaintRgn function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Deprecated in Mac OS X v10.4.
Available in Mac OS X v10.0 and later.
Declared In
Quickdraw.h*/

void PaintRgn (
   RgnHandle rgn
){};


























































































