#include <CoreGraphics/CoreGraphics.h>

void CPSEnableForegroundOperation( void* psn ){
//TODO
}; 

/*CGPostKeyboardEvent

Synthesizes a low-level keyboard event on the local machine.

CGError CGPostKeyboardEvent (
   CGCharCode keyChar,
   CGKeyCode virtualKey,
   boolean_t keyDown
);
Parameters
keyChar

The value of the character to generate, or 0 to specify that the system should guess an appropriate value based on the default key mapping.
virtualKey

The virtual key code for the event. See CGKeyCode.
keyDown

Pass true to specify that the key position is down; otherwise, pass false.
Return Value

A result code. See Quartz Display Services Result Codes. 
Discussion

This function is not recommended for general use because of undocumented special cases and undesirable side effects. The recommended replacement for this function is CGEventCreateKeyboardEvent, which allows you to create a keyboard event and customize the event before posting it to the event system. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CGRemoteOperation.h*/
CGError CGPostKeyboardEvent (
   CGCharCode keyChar,
   CGKeyCode virtualKey,
   boolean_t keyDown){
//TODO
};


/*CGRectIntegral

Returns a rectangle with integer values for its origin and size.

CGRect CGRectIntegral (
   CGRect rect
);
Parameters
rect

The source rectangle. 
Return Value

The rectangle with smallest integer values for its origin and size that contains the source rectangle. That is, given a rectangle with fractional origin or size values, CGRectIntegral rounds the rectangle’s origin downward and its size upward to the nearest whole integers, such that the result contains the original rectangle. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGGeometry.h*/
CGRect CGRectIntegral (
   CGRect rect){
//TODO
};


/*CGRectIntersection

Returns the intersection of two rectangles.

CGRect CGRectIntersection (
   CGRect rect1,
   CGRect rect2
);
Parameters
rect1

The first source rectangle.
rect2

The second source rectangle.
Return Value

A rectangle that is the intersection of the two specified rectangles. If the two rectangles do not intersect, returns the null rectangle. To check for this condition, use CGRectIsNull. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGGeometry.h*/

CGRect CGRectIntersection (
   CGRect rect1,
   CGRect rect2){
//TODO
};


/*CGRectInset

Returns a rectangle that is smaller or larger than the source rectangle, with the same center point.

CGRect CGRectInset (
   CGRect rect,
   float dx,
   float dy
);
Parameters
rect

The source rectangle. 
dx

The value by which to adjust the x-coordinates of the source rectangle. To create an inset rectangle, specify a positive value. To create a larger, encompassing rectangle, specify a negative value.
dy

The value by which to adjust the y-coordinates of the source rectangle. To create an inset rectangle, specify a positive value. To create a larger, encompassing rectangle, specify a negative value.
Return Value

A rectangle with its origin offset in the x-axis by the distance specified by the dx parameter and in the y-axis by the distance specified by the dy parameter, and its size adjusted by (2*dx,2*dy), relative to the source rectangle. If dx and dy are positive values, then the rectangle’s size is decreased. If dx and dy are negative values, the rectangle’s size is increased.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGGeometry.h*/
CGRect CGRectInset (
   CGRect rect,
   float dx,
   float dy){
//TODO
};


/*CGRectGetHeight

Returns the height of a rectangle.

float CGRectGetHeight (
   CGRect rect
);
Parameters
rect

The rectangle to examine. 
Return Value

The height of the specified rectangle. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGGeometry.h*/

float CGRectGetHeight (
   CGRect rect){
//TODO
};


/*CGRectGetWidth

Returns the width of a rectangle.

float CGRectGetWidth (
   CGRect rect
);
Parameters
rect

The rectangle to examine. 
Return Value

The width of the specified rectangle. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGGeometry.h*/

float CGRectGetWidth (
   CGRect rect){
//TODO
};


/*CGContextDrawImage

Draws an image into a graphics context.

void CGContextDrawImage (
   CGContextRef context,
   CGRect rect,
   CGImageRef image
);
Parameters
context

The graphics context in which to draw the image. 
rect

The location and dimensions in user space of the bounding box in which to draw the image. 
image

The image to draw. 
Discussion

Quartz scales the image—disproportionately, if necessary—to fit the bounds specified by the rect parameter.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/void CGContextDrawImage (
   CGContextRef context,
   CGRect rect,
   CGImageRef image){
//TODO
};


/*CGImageRelease

Decrements the retain count of a Quartz image.

void CGImageRelease (
   CGImageRef image
);
Parameters
image

The image to release. 
Discussion

This function is equivalent to CFRelease, except that it does not cause an error if the image parameter is NULL.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGImage.h*/
void CGImageRelease (
   CGImageRef image){
//TODO
};



/*CGColorSpaceCreateWithPlatformColorSpace

Creates a platform-specific color space.

CGColorSpaceRef CGColorSpaceCreateWithPlatformColorSpace(
   void *platformColorSpace
);
Parameters
platformColorSpace

A generic pointer to a platform-specific color space. In Mac OS X, pass a CMProfileRef—a ColorSync profile. Quartz uses this pointer (and the underlying information) only during the function call.
Return Value

A new color space. You are responsible for releasing this object by calling CGColorSpaceRelease. If unsuccessful, returns NULL.
Discussion

Colors in a device-dependent color space are not transformed or otherwise modified when displayed on an output device—that is, there is no attempt to maintain the visual appearance of a color. As a consequence, colors in a device color space often appear different when displayed on different output devices. For this reason, device color spaces are not recommended when color preservation is important.
Availability
Available in Mac OS X version 10.1 and later.
Declared In
CGColorSpace.h*/
CGColorSpaceRef CGColorSpaceCreateWithPlatformColorSpace(
   void *platformColorSpace){
//TODO
};


/*CGColorSpaceRelease

Decrements the retain count of a color space.

void CGColorSpaceRelease (
   CGColorSpaceRef cs
);
Parameters
cs

The Quartz color space to release. 
Discussion

This function is equivalent to CFRelease, except that it does not cause an error if the cs parameter is NULL.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGColorSpace.h*/
void CGColorSpaceRelease (
   CGColorSpaceRef cs){
//TODO
};

/*CGRectMake

Returns a rectangle structure constructed from coordinate and dimension values you provide.

CGRect CGRectMake (
   float x,
   float y,
   float width,
   float height
);
Parameters
x

The x-coordinate of the rectangle’s origin point.
y

The y-coordinate of the rectangle’s origin point.
width

The width of the rectangle.
height

The height of the rectangle.
Return Value

Returns a rectangle with the specified location and dimensions. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGGeometry.h*/
CGRect CGRectMake (
   float x,
   float y,
   float width,
   float height){
//TODO
};


/*CGRectIsInfinite

Checks whether a rectangle is infinite.

bool CGRectIsInfinite (
   CGRect rect
);
Parameters
rect

The rectangle to examine.
Return Value

Returns true if the specified rectangle is infinite, false otherwise.
Discussion

An infinite rectangle is one that has no defined bounds. Infinite rectangles can be created as output from a tiling filter. For example, the Core Image framework perspective tile filter creates an image whose extent is described by an infinite rectangle.
Availability
Available in Mac OS X v10.4 and later.
Declared In
CGGeometry.h*/
bool CGRectIsInfinite (
   CGRect rect){
//TODO
};


/*CGMainDisplayID

Returns the display ID of the main display. 

CGDirectDisplayID CGMainDisplayID (void);
Return Value

The display ID assigned to the main display. For more information about this data type, see CGDirectDisplayID.
Discussion

The main display is the display with its screen location at (0,0) in global coordinates. In a system without display mirroring, the display with the menu bar is typically the main display.

If mirroring is enabled, and the menu bar appears on more than one display, this function provides a reliable way to find the main display. 

In case of hardware mirroring, the drawable display becomes the main display. In case of software mirroring, the display with the highest resolution and deepest pixel depth typically becomes the main display.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CGDirectDisplay.h*/
CGDirectDisplayID CGMainDisplayID (void){
//TODO
};


/*CGRectGetMinY

Returns the y-axis coordinate that establishes the bottom edge of a rectangle.

float CGRectGetMinY (
   CGRect rect
);
Parameters
rect

The rectangle to examine. 
Return Value

The y-coordinate of the bottom-left corner of the specified rectangle.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGGeometry.h*/
float CGRectGetMinY (
   CGRect rect){
//TODO
};

/*CGRectGetMaxY

Returns the y-axis coordinate that establishes the top edge of a rectangle.

float CGRectGetMaxY (
   CGRect rect
);
Parameters
rect

The rectangle to examine. 
Return Value

The y-coordinate of the top-right corner of the specified rectangle.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGGeometry.h*/
float CGRectGetMaxY (
   CGRect rect){
//TODO
};

/*CGContextAddRect

Adds a new subpath, consisting of a single rectangle, to a graphics context.

void CGContextAddRect (
   CGContextRef context,
   CGRect rect
);
Parameters
context

The graphics context to which to add the rectangular subpath. 
rect

A CGRect value that specifies, in the user space, the dimensions and location of the rectangle to create. 
Discussion

This function adds a subpath consisting of a single rectangle to the specified context’s path. You can add multiple rectangular subpaths at the same time using the function CGContextAddRects. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextAddRect (
   CGContextRef context,
   CGRect rect){};


/*CGContextSetGrayFillColor

Sets the current fill color to a value in the DeviceGray color space.

void CGContextSetGrayFillColor (
   CGContextRef context,
   float gray,
   float alpha
);
Parameters
context

The graphics context for which to set the current fill color. 
gray

A value that specifies the desired gray level. The DeviceGray color space permits the specification of a value ranging from 0.0 (absolute black) to 1.0 (absolute white). Values outside this range are clamped to 0.0 or 1.0.
alpha

A value that specifies the opacity level. Values can range from 0.0 (transparent) to 1.0 (opaque). Values outside this range are clipped to 0.0 or 1.0.
Discussion

When you call this function, two things happen:
Quartz sets the current fill color space to DeviceGray.
Quartz sets the current fill color to the value you specify in the gray and alpha parameters.

See also CGContextSetGrayStrokeColor. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextSetGrayFillColor (
   CGContextRef context,
   float gray,
   float alpha
){}

;/*CGColorSpaceCreateDeviceGray

Creates a device-dependent grayscale color space.

CGColorSpaceRef CGColorSpaceCreateDeviceGray (void);
Return Value

A device-dependent gray color space. You are responsible for releasing this object by calling CGColorSpaceRelease. If unsuccessful, returns NULL.
Discussion

In Mac OS X v10.4 and later, this color space is no longer device-dependent and is replaced by the generic counterpart—kCGColorSpaceGenericGray—described in “Generic Color Spaces”. If you use this function in Mac OS X v10.4 and later, colors are mapped to the generic color spaces. If you want to bypass color matching, use the colorspace of the destination context.

Colors in a device-dependent color space are not transformed or otherwise modified when displayed on an output device—that is, there is no attempt to maintain the visual appearance of a color. As a consequence, colors in a device color space often appear different when displayed on different output devices. For this reason, device color spaces are not recommended when color preservation is important.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGColorSpace.h*/
CGColorSpaceRef CGColorSpaceCreateDeviceGray (void){};

/*CGContextRestoreGState

Sets the current graphics state to the state most recently saved.

void CGContextRestoreGState (
   CGContextRef context
);
Parameters
context

The graphics context to modify.
Discussion

When you call CGContextRestoreGState, Quartz removes the most recently saved graphics state from the top of the stack and uses that state’s saved settings for the current graphics state. See CGContextSaveGState.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextRestoreGState (
   CGContextRef context
){}

;
/*CGContextStrokePath

Paints a line along the current path.

void CGContextStrokePath (
   CGContextRef context
);
Parameters
context

The graphics context containing the path to stroke.
Discussion

This function strokes the current path. See also CGContextDrawPath, CGContextEOFillPath, and CGContextFillPath.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextStrokePath (
   CGContextRef context
){}

;
/*CGContextFillPath

Paints the area within the current path, using the nonzero winding number rule.

void CGContextFillPath (
   CGContextRef context
);
Parameters
context

The graphics context containing the path to fill. 
Discussion

When you fill the current path, Quartz fills each subpath independently. Any subpath that has not been explicitly closed is closed implicitly by the fill routines. 

There are two different methods of filling paths. The CGContextFillPath function uses the nonzero winding number rule. The function CGContextEOFillPath uses the even-odd rule to fill a path.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextFillPath (
   CGContextRef context
){}
/*CGContextAddArc

Adds an arc of a circle to the current path, using a center point, radius, and end point.

void CGContextAddArc (
   CGContextRef context,
   float x,
   float y,
   float radius,
   float startAngle,
   float endAngle,
   int clockwise
);
Parameters
context

The graphics context to which to add the arc.
x

The x-coordinate of the user space for the center of the arc.
y

The y-coordinate of the user space for the center of the arc.
radius

The radius of the arc, in user space coordinates.
startAngle

The angle to the starting point of the arc, measured in radians from the positive x-axis.
endAngle

The angle to the end point of the arc, measured in radians from the positive x-axis.
clockwise

Pass 1 if the arc is to be drawn clockwise; 0 otherwise.
Discussion

When you call this function, Quartz builds an arc of a circle centered on the point you provide. The arc is of the specified radius and extends between the start and end point. (You can also use CGContextAddArc as a convenient way to draw a circle, by setting the start point to 0 and the end point to 2*Pi.)

If the current path already contains a subpath, Quartz additionally appends a straight line segment from the current point to the starting point of the arc. If the current path is empty, Quartz creates a new subpath for the arc and does not add the initial straight line segment.

After adding the arc, the current point is reset to the end point of arc (the second tangent point).

See also CGContextAddArcToPoint. 
Availability
Available in Mac OS X version 10.0 and later.*/
void CGContextAddArc (
   CGContextRef context,
   float x,
   float y,
   float radius,
   float startAngle,
   float endAngle,
   int clockwise
){};


/*CGContextBeginPath

Creates a new empty path in a graphics context.

void CGContextBeginPath (
   CGContextRef context
);
Parameters
context

The graphics context in which to begin a new path.
Discussion

A graphics context can have only a single path in use at any time. Therefore, if the specified context already contains a current path when you call this function, Quartz replaces the previous current path with the new path. In this case, Quartz discards the old path and any data associated with it.

The current path is not part of the graphics state. Consequently, saving and restoring the graphics state has no effect on the current path.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextBeginPath (
   CGContextRef context
){};





/*CGContextSetRGBStrokeColor

Sets the current stroke color to a value in the DeviceRGB color space.

void CGContextSetRGBStrokeColor (
   CGContextRef context,
   float red,
   float green,
   float blue,
   float alpha
);
Parameters
context

The graphics context for which to set the current stroke color. 
red

The red intensity value for the color to set. The DeviceRGB colorspace permits the specification of a value ranging from 0.0 (zero intensity) to 1.0 (full intensity).
green

The green intensity value for the color to set. The DeviceRGB colorspace permits the specification of a value ranging from 0.0 (zero intensity) to 1.0 (full intensity).
blue

The blue intensity value for the color to set. The DeviceRGB colorspace permits the specification of a value ranging from 0.0 (zero intensity) to 1.0 (full intensity).
alpha

A value that specifies the opacity level. Values can range from 0.0 (transparent) to 1.0 (opaque). Values outside this range are clipped to 0.0 or 1.0.
Discussion

When you call this function, two things happen:
Quartz sets the current stroke color space to DeviceRGB.
Quartz sets the current stroke color to the value specified by the red, green, blue, and alpha parameters.

See also CGContextSetRGBFillColor.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextSetRGBStrokeColor (CGContextRef context,float red,float green,float blue,float alpha){
//TODO
};


/*CGContextSetLineWidth

Sets the line width for a graphics context.

void CGContextSetLineWidth (
   CGContextRef context,
   float width
);
Parameters
context

The graphics context for which to set the line width parameter of the current graphics state. 
width

The new line width to be used, in user space units. The value must be greater than 0.
Discussion

The line width is the total width of the line, expressed in units of the user space. The line surrounds the center of the path, with half of the total width on either side. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/

void CGContextSetLineWidth (
   CGContextRef context,
   float width){};


/*CGContextSaveGState

Pushes a copy of the current graphics state on the top of a context’s graphics state stack.

void CGContextSaveGState (
   CGContextRef context
);
Parameters
context

The graphics context for which to save the current graphics state. 
Discussion

Each graphics context maintains a stack of graphics states. When you call CGContextSaveGState, Quartz saves the current graphics state to the top of the context’s graphics state stack.

Note that not all aspects of the current drawing environment are elements of the graphics state. For example, the current path is not considered part of the graphics state and is therefore not saved when you call the CGContextSaveGState function. The graphics state parameters that are saved are:
CTM (current transformation matrix) 
clip region
image interpolation quality 
line width 
line join 
miter limit 
line cap 
line dash 
flatness 
should anti-alias 
rendering intent 
fill color space 
stroke color space 
fill color 
stroke color 
alpha value 
font 
font size 
character spacing 
text drawing mode
shadow parameters
the pattern phase
the font smoothing parameter
blend mode

To restore your drawing environment to a previously saved state, you can use the function CGContextRestoreGState. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextSaveGState (
   CGContextRef context){};



/*CGImageRetain

Increments the retain count of a Quartz image.

CGImageRef CGImageRetain (
   CGImageRef image
);
Parameters
image

The image to retain. 
Return Value

The same image you passed in as the image parameter.
Discussion

This function is equivalent to CFRetain, except that it does not cause an error if the image parameter is NULL.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGImage.h*/
CGImageRef CGImageRetain (
   CGImageRef image){
//TODO
};

/*CGImageCreate

Creates a Quartz bitmap image.

CGImageRef CGImageCreate (
   size_t width,
   size_t height,
   size_t bitsPerComponent,
   size_t bitsPerPixel,
   size_t bytesPerRow,
   CGColorSpaceRef colorspace,
   CGBitmapInfo bitmapInfo,
   CGDataProviderRef provider,
   const float decode[],
   int shouldInterpolate,
   CGColorRenderingIntent intent
);
Parameters
width

The width, in pixels, of the required image.
height

The height, in pixels, of the required image
bitsPerComponent

The number of bits for each component in a source pixel. For example, if the source image uses the RGBA-32 format, you would specify 8 bits per component.
bitsPerPixel

The total number of bits in a source pixel. This value must be at least bitsPerComponent times the number of components per pixel.
bytesPerRow

The number of bytes of memory for each horizontal row of the bitmap.
colorspace

The color space for the image. Quartz retains the color space you pass in; on return, you may safely release it.
bitmapInfo

A CGBitmapInfo constant that specifies whether the bitmap should contain an alpha channel and its relative location in a pixel, along with whether the components are floating-point or integer values. 
provider

The source of data for the bitmap. For information about supported data formats, see the discussion below. Quartz retains this object; on return, you may safely release it.
decode

The decode array for the image. If you do not want to allow remapping of the image’s color values, pass NULL for the decode array.
shouldInterpolate

A Boolean value that specifies whether interpolation should occur. The interpolation setting specifies whether Quartz should apply a pixel-smoothing algorithm to the image.
intent

A CGColorRenderingIntent constant that specifies how Quartz should handle colors that are not located within the gamut of the destination color space of a graphics context.
Return Value

A new Quartz bitmap image. You are responsible for releasing this object by calling CGImageRelease.
Discussion

The data provider should provide raw data that matches the format specified by the other input parameters. To use encoded data (for example, from a file specified by a URL-based data provider), see CGImageCreateWithJPEGDataProvider and CGImageCreateWithPNGDataProvider. In Mac OS X version 10.3 and later, you can also use the QuickTime function GraphicsImportCreateCGImage to decode an image file in any supported format and create a CGImage, in a single operation.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGImage.h*/
CGImageRef CGImageCreate (
   size_t width,
   size_t height,
   size_t bitsPerComponent,
   size_t bitsPerPixel,
   size_t bytesPerRow,
   CGColorSpaceRef colorspace,
   CGBitmapInfo bitmapInfo,
   CGDataProviderRef provider,
   const float decode[],
   int shouldInterpolate,
   CGColorRenderingIntent intent){};



/*CGDataProviderRelease

Decrements the retain count of a data provider.

void CGDataProviderRelease (
   CGDataProviderRef provider
);
Parameters
provider

The data provider to release. 
Discussion

This function is equivalent to CFRelease, except that it does not cause an error if the provider parameter is NULL.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGDataProvider.h*/
void CGDataProviderRelease (
   CGDataProviderRef provider){
//TODO
};


/*CGColorSpaceCreateDeviceRGB

Creates a device-dependent RGB color space.

CGColorSpaceRef CGColorSpaceCreateDeviceRGB (void);
Return Value

A device-dependent RGB color space. You are responsible for releasing this object by calling CGColorSpaceRelease. If unsuccessful, returns NULL.
Discussion

In Mac OS X v10.4 and later, this color space is no longer device-dependent and is replaced by the generic counterpart—kCGColorSpaceGenericRGB—described in “Generic Color Spaces”. If you use this function in Mac OS X v10.4 and later, colors are mapped to the generic color spaces. If you want to bypass color matching, use the colorspace of the destination context.

Colors in a device-dependent color space are not transformed or otherwise modified when displayed on an output device—that is, there is no attempt to maintain the visual appearance of a color. As a consequence, colors in a device color space often appear different when displayed on different output devices. For this reason, device color spaces are not recommended when color preservation is important.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGColorSpace.h*/
CGColorSpaceRef CGColorSpaceCreateDeviceRGB (void){
//TODO
};


/*CGBitmapContextCreate

Creates a bitmap graphics context.

CGContextRef CGBitmapContextCreate (
   void * data,
   size_t width,
   size_t height,
   size_t bitsPerComponent,
   size_t bytesPerRow,
   CGColorSpaceRef colorspace,
   CGBitmapInfo bitmapInfo
);
Parameters
data

A pointer to the destination in memory where the drawing is to be rendered. The size of this memory block should be at least (bytesPerRow*height) bytes.
width

The width, in pixels, of the required bitmap.
height

The height, in pixels, of the required bitmap.
bitsPerComponent

The number of bits to use for each component of a pixel in memory. For example, for a 32-bit pixel format and an RGB color space, you would specify a value of 8 bits per component. For more information about supported pixel formats, see Quartz 2D Programming Guide.
bytesPerRow

The number of bytes of memory to use per row of the bitmap.
colorspace

The color space to use for the bitmap context. Note that indexed color spaces are not supported for bitmap graphics contexts.
bitmapInfo

A CGBitmapInfo constant that specifies whether the bitmap should contain an alpha channel and its relative location in a pixel, along with whether the components are floating-point or integer values. See CGImage Reference for a description of CGBitmapInfo constants. 
Return Value

A new bitmap context, or NULL if a context could not be created. You are responsible for releasing this object using CGContextRelease.
Discussion

When you call this function, Quartz creates a bitmap drawing environment—that is, a bitmap context—to your specifications. When you draw into this context, Quartz renders your drawing as bitmapped data in the specified block of memory.

The pixel format for a new bitmap context is determined by three parameters—the number of bits per component, the color space, and an alpha option (expressed as a CGBitmapInfo constant). The alpha value determines the opacity of a pixel when it is drawn.

For more information see, Creating a Bitmap Graphics Context.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGBitmapContext.h*/

CGContextRef CGBitmapContextCreate (
   void * data,
   size_t width,
   size_t height,
   size_t bitsPerComponent,
   size_t bytesPerRow,
   CGColorSpaceRef colorspace,
   CGBitmapInfo bitmapInfo){
//TODO
};



/*CGContextSetRGBFillColor

Sets the current fill color to a value in the DeviceRGB color space.

void CGContextSetRGBFillColor (
   CGContextRef context,
   float red,
   float green,
   float blue,
   float alpha
);
Parameters
context

The graphics context for which to set the current fill color. 
red

The red intensity value for the color to set. The DeviceRGB colorspace permits the specification of a value ranging from 0.0 (zero intensity) to 1.0 (full intensity).
green

The green intensity value for the color to set. The DeviceRGB colorspace permits the specification of a value ranging from 0.0 (zero intensity) to 1.0 (full intensity).
blue

The blue intensity value for the color to set. The DeviceRGB colorspace permits the specification of a value ranging from 0.0 (zero intensity) to 1.0 (full intensity).
alpha

A value that specifies the opacity level. Values can range from 0.0 (transparent) to 1.0 (opaque). Values outside this range are clipped to 0.0 or 1.0.
Discussion

When you call this function, two things happen:
Quartz sets the current fill color space to DeviceRGB. 
Quartz sets the current fill color to the value specified by the red, green, blue, and alpha parameters.

See also CGContextSetRGBStrokeColor.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextSetRGBFillColor (
   CGContextRef context,
   float red,
   float green,
   float blue,
   float alpha){
//TODO
};

/*CGContextFillRect

Paints the area contained within a rectangle.

void CGContextFillRect (
   CGContextRef context,
   CGRect rect
);
Parameters
context

The graphics context in which to paint the rectangle.
rect

A CGRect value that specifies the dimensions and location in the user space of the rectangle to paint. 
Discussion

This function paints the area contained within the specified rectangle, using the fill color specified in the current graphics state. As a side effect when you call this function, Quartz clears the current path.

See also CGContextFillRects.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/

void CGContextFillRect (
   CGContextRef context,
   CGRect rect){};


/*CGBitmapContextCreateImage

Creates an image that is a copy of a bitmap graphics context.

CGImageRef CGBitmapContextCreateImage(
   CGContextRef c
);
Parameters
c

A bitmap graphics context.
Return Value

A CGImage object that contains a snapshot of the bitmap graphics context or NULL if the image is not created.
Discussion

The CGImage object returned by this function is created by a copy operation. Subsequent changes to the bitmap graphics context do not affect the contents of the returned image. In some cases the copy operation actually follows copy-on-write semantics, so that the actual physical copy of the bits occur only if the underlying data in the bitmap graphics context is modified. As a consequence, you may want to use the resulting image and release it before you perform additional drawing into the bitmap graphics context. In this way, you can avoid the actual physical copy of the data.
Availability
Available in Mac OS X v10.4 and later.
Declared In
CGBitmapContext.h*/
CGImageRef CGBitmapContextCreateImage(
   CGContextRef c){};


/*CGContextRelease

Decrements the retain count of a graphics context.

void CGContextRelease (
   CGContextRef context
);
Parameters
context

The graphics context to release.
Discussion

This function is equivalent to CFRelease, except that it does not cause an error if the context parameter is NULL.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextRelease (
   CGContextRef context
){}

;/*CGDataProviderCreateWithData

Creates a Quartz direct-access data provider that uses data your program supplies.

CGDataProviderRef CGDataProviderCreateWithData (
   void *info,
   const void *data,
   size_t size,
   void (*releaseData)(void *info, const void *data, size_t size)
);
Parameters
info

A pointer to data of any type, or NULL. When Quartz calls the function specified in the releaseData parameter, Quartz sends it this pointer as its first argument.
data

A pointer to the array of data that the provider contains.
size

A value that specifies the number of bytes that the data provider contains.
releaseData

A pointer to a release callback for the data provider, or NULL. Your release function is called when Quartz frees the data provider. For more information, see CGDataProviderReleaseDataCallback.
Return Value

A new data provider. You are responsible for releasing this object using CGDataProviderRelease.
Discussion

You use this function to create a direct-access data provider that uses callback functions to read data from your program an entire block at one time. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGDataProvider.h*/
CGDataProviderRef CGDataProviderCreateWithData (
   void *info,
   const void *data,
   size_t size,
   void (*releaseData)(void *info, const void *data, size_t size)
){};

/*CGContextMoveToPoint

Begins a new subpath at the point you specify.

void CGContextMoveToPoint (
   CGContextRef context,
   float x,
   float y
);
Parameters
context

A graphics context. 
x

A value for the x-coordinate of the user space at which to begin the subpath.
y

A value for the y-coordinate of the user space at which to begin the subpath.
Discussion

The CGContextMoveToPoint function begins a new subpath starting at the point you specify. This point is defined to be the “current” point, and it defines the starting point of the next line segment.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextMoveToPoint (
   CGContextRef context,
   float x,
   float y
){};


/*CGContextAddCurveToPoint

Appends a cubic Bézier curve from the current point, using control points and an end point you specify.

void CGContextAddCurveToPoint (
   CGContextRef context,
   float cp1x,
   float cp1y,
   float cp2x,
   float cp2y,
   float x,
   float y
);
Parameters
context

The graphics context to which to add the curve. The context’s path must not be empty.
cp1x

The x-coordinate of the user space for the first control point of the curve.
cp1y

The y-coordinate of the user space for the first control point of the curve.
cp2x

The x-coordinate of the user space for the second control point of the curve.
cp2y

The y-coordinate of the user space for the second control point of the curve.
x

The x-coordinate of the user space at which to end the curve.
y

The y-coordinate of the user space at which to end the curve.
Discussion

This function appends a cubic curve to the current path. After adding the segment, the current point is reset from the beginning of the new segment to the end point of that segment.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextAddCurveToPoint (
   CGContextRef context,
   float cp1x,
   float cp1y,
   float cp2x,
   float cp2y,
   float x,
   float y
){}

;/*CGContextAddLineToPoint

Appends a straight line segment from the current point to the point you specify.

void CGContextAddLineToPoint (
   CGContextRef context,
   float x,
   float y
);
Parameters
context

The graphics context to which to add a line segment. The context’s path must not be empty.
x

A value for the x-coordinate of the user space at which to end the line segment.
y

A value for the y-coordinate of the user space at which to end the line segment.
Discussion

This function appends a single straight line segment to the current subpath. After adding the line segment, the current point is reset from the beginning of the new line segment to the endpoint of that line segment. You can add a subpath consisting of multiple straight line segments using the function CGContextAddLines.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextAddLineToPoint (
   CGContextRef context,
   float x,
   float y
){};


/*CGRectGetMidY

Returns the y-axis coordinate that establishes the center of a rectangle.

float CGRectGetMidY (
   CGRect rect
);
Parameters
rect

The rectangle to examine. 
Return Value

The y-coordinate of the center of the specified rectangle.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGGeometry.h*/
float CGRectGetMidY (
   CGRect rect){};



/*CGContextSetLineCap

Sets the style for the endpoints of lines in a graphics context.

void CGContextSetLineCap (
   CGContextRef context,
   CGLineCap cap
);
Parameters
context

The graphics context for which to set the line cap parameter of the current graphics state. 
cap

A CGLineCap value that specifies the line cap style to be used. For a discussion of the available line cap styles, see Line Cap Styles.
Discussion

The line cap style specifies how Quartz draws the endpoint of a line. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextSetLineCap (
   CGContextRef context,
   CGLineCap cap){};



/*CGRectUnion

Returns the smallest rectangle that contains two other specified rectangles.

CGRect CGRectUnion (
   CGRect r1,
   CGRect r2
);
Parameters
r1

The first source rectangle. 
r2

The second source rectangle.
Return Value

The smallest rectangle that completely contains both of the source rectangles. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGGeometry.h*/
CGRect CGRectUnion (
   CGRect r1,
   CGRect r2){};


/*CGContextClipToMask

Maps a mask into the specified rectangle and intersects it with the current clipping area of the graphics context.

void CGContextClipToMask(
CGContextRef c,
CGRect rect,
CGImageRef mask
);
Parameters
c

A graphics context. 
rect

The rectangle to map the mask parameter to.
mask

An image or an image mask. If mask is an image, then it must be in the DeviceGray color space, may not have an alpha component, and may not be masked by an image mask or masking color.
Discussion

If the mask parameter is an image mask, then Quartz clips in a manner identical to the behavior seen with the function CGContextDrawImage—the mask indicates an area to be left unchanged when drawing. The source samples of the image mask determine which points of the clipping area are changed, acting as an "inverse alpha" value. If the value of a source sample in the image mask is S, then the corresponding point in the current clipping area is multiplied by an alpha value of (1–S). For example, if S is 1 then the point in the clipping area becomes transparent. If S is 0, the point in the clipping area is unchanged.

If the mask parameter is an image, then mask acts like an alpha mask and is blended with the current clipping area. The source samples of mask determine which points of the clipping area are changed. If the value of the source sample in mask is S, then the corresponding point in the current clipping area is multiplied by an alpha of S. For example, if S is 0, then the point in the clipping area becomes transparent. If S is 1, the point in the clipping area is unchanged.
Availability
Available in Mac OS X v10.4 and later.
Declared In
CGContext.h*/
void CGContextClipToMask(
CGContextRef c,
CGRect rect,
CGImageRef mask
){};



/*CGImageGetWidth

Returns the width of a bitmap image.

size_t CGImageGetWidth (
   CGImageRef image
);
Parameters
image

The image to examine. 
Return Value

The width, in pixels, of the specified bitmap image (or image mask).
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGImage.h*/
size_t CGImageGetWidth (
   CGImageRef image
){};



/*CGImageGetHeight

Returns the height of a bitmap image.

size_t CGImageGetHeight (
   CGImageRef image
);
Parameters
image

The image to examine. 
Return Value

The height in pixels of the bitmap image (or image mask).
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGImage.h*/
size_t CGImageGetHeight (
   CGImageRef image
){};


/*CGAffineTransformMake

Returns an affine transformation matrix constructed from values you provide. 

CGAffineTransform CGAffineTransformMake (
   float a,
   float b,
   float c,
   float d,
   float tx,
   float ty
);
Parameters
a

The value at position [1,1] in the matrix.
b

The value at position [1,2] in the matrix.
c

The value at position [2,1] in the matrix.
d

The value at position [2,2] in the matrix.
tx

The value at position [3,1] in the matrix.
ty

The value at position [3,2] in the matrix.
Return Value

A new affine transform matrix constructed from the values you specify.
Discussion

This function creates a CGAffineTransform structure that represents a new affine transformation matrix, which you can use (and reuse, if you want) to transform a coordinate system. The matrix takes the following form:




If you want only to transform an object to be drawn, it is not necessary to construct an affine transform to do so. The most direct way to transform your drawing is by calling the appropriate CGContext function to adjust the current transformation matrix.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGAffineTransform.h*/
CGAffineTransform CGAffineTransformMake (
   float a,
   float b,
   float c,
   float d,
   float tx,
   float ty
){};
/*CGImageGetColorSpace

Return the color space for a bitmap image.

CGColorSpaceRef CGImageGetColorSpace (
   CGImageRef image
);
Parameters
image

The image to examine. 
Return Value

The source color space for the specified bitmap image, or NULL if the image is an image mask. You are responsible for retaining and releasing the color space as necessary.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGImage.h*/
CGColorSpaceRef CGImageGetColorSpace (
   CGImageRef image
){};


/*CGContextConcatCTM

Transforms the user coordinate system in a context using a specified matrix.

void CGContextConcatCTM (
   CGContextRef context,
   CGAffineTransform transform
);
Parameters
context

A graphics context. 
transform

The transformation matrix to apply to the specified context’s current transformation matrix. 
Discussion

When you call the function CGContextConcatCTM, it concatenates (that is, it combines) two matrices, by multiplying them together. The order in which matrices are concatenated is important, as the operations are not commutative. When you call CGContextConcatCTM, the resulting CTM in the context is: CTMnew = transform * CTMcontext.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextConcatCTM (
   CGContextRef context,
   CGAffineTransform transform
){};


/*CGContextRotateCTM

Rotates the user coordinate system in a context.

void CGContextRotateCTM (
   CGContextRef context,
   float angle
);
Parameters
context

A graphics context. 
angle

The angle, in radians, by which to rotate the coordinate space of the specified context.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextRotateCTM (
   CGContextRef context,
   float angle
){};

/*CGContextScaleCTM

Changes the scale of the user coordinate system in a context.

void CGContextScaleCTM (
   CGContextRef context,
   float sx,
   float sy
);
Parameters
context

A graphics context. 
sx

The factor by which to scale the x-axis of the coordinate space of the specified context.
sy

The factor by which to scale the y-axis of the coordinate space of the specified context.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextScaleCTM (
   CGContextRef context,
   float sx,
   float sy
){};






/*CGContextTranslateCTM

Changes the origin of the user coordinate system in a context.

void CGContextTranslateCTM (
   CGContextRef context,
   float tx,
   float ty
);
Parameters
context

A graphics context. 
tx

The amount to displace the x-axis of the coordinate space, in units of the user space, of the specified context.
ty

The amount to displace the y-axis of the coordinate space, in units of the user space, of the specified context.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextTranslateCTM (
   CGContextRef context,
   float tx,
   float ty
){};

/*CGLayerGetContext

Gets the graphics context associated with a CGLayer object.

CGContextRef CGLayerGetContext(
   CGLayerRef layer
);
Parameters
layer

The layer whose graphics context you want to obtain.
Return Value

The graphics context associated with the layer.
Discussion

The context that’s returned is the context for the layer itself, not the context that you specified when you created the layer.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CGLayer.h*/
CGContextRef CGLayerGetContext(
   CGLayerRef layer
){};


/*CGLayerRelease

Decrements the retain count of a CGLayer object.

void CGLayerRelease(CGLayerRef layer);
Parameters
layer

The layer to release.
Discussion

This function is equivalent to calling CFRelease (layer) except that it does not crash (as CFRetain does) if the layer parameter is null.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CGLayer.h*/
void CGLayerRelease(CGLayerRef layer){};

/*CGContextClearRect

Paints a transparent rectangle.

void CGContextClearRect (
   CGContextRef context,
   CGRect rect
);
Parameters
context

The graphics context in which to paint the rectangle. 
rect

A CGRect value that specifies the dimensions and location in the user space of the rectangle to paint transparently. 
Discussion

If the specified context is a window or bitmap context, Quartz effectively “clears” the rectangle. For other types of context, Quartz fills the rectangle in a device-dependent manner.
Special Considerations

The use of this function is not recommended in contexts other than window or bitmap contexts.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextClearRect (
   CGContextRef context,
   CGRect rect
){};


/*CGColorSpaceCreateWithName

Creates a specified type of Quartz color space.

CGColorSpaceRef CGColorSpaceCreateWithName (
CFStringRef name
);
Parameters
name

A color space name. See “Generic Color Spaces” for a list of the valid Quartz-defined names.
Return Value

A new generic color space. You are responsible for releasing this object by calling CGColorSpaceRelease. If unsuccessful, returns NULL.
Discussion

You can use this function to create a generic color space. For more information, see “Generic Color Spaces”.

Prior to Mac OS X v10.4, you could pass this function one of the constants defined in “Named Color Spaces (Deprecated)”. As of Mac OS X v10.4, this function returns a generic color space even if you pass is one of the deprecated named color spaces. 
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CGColorSpace.h*/
CGColorSpaceRef CGColorSpaceCreateWithName (
CFStringRef name
){};

/*CGPointMake

Returns a point structure constructed from coordinate values you provide.

CGPoint CGPointMake (
   float x,
   float y
);
Parameters
x

The x-coordinate of the point to construct.
y

The y-coordinate of the point to construct.
Return Value

Returns a CGPoint structure, representing a single (x,y) coordinate pair. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGGeometry.h*/
CGPoint CGPointMake (
   float x,
   float y
){};




/*CGRectGetMidX

Returns the x-axis coordinate that establishes the center of a rectangle.

float CGRectGetMidX (
   CGRect rect
);
Parameters
rect

The rectangle to examine. 
Return Value

The x-coordinate of the center of the specified rectangle.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGGeometry.h*/

float CGRectGetMidX (
   CGRect rect
){};


;/*CGRectGetMinX

Returns the x-axis coordinate that establishes the left edge of a rectangle.

float CGRectGetMinX (
   CGRect rect
);
Parameters
rect

The rectangle to examine. 
Return Value

The x-coordinate of the bottom-left corner of the specified rectangle.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGGeometry.h*/
float CGRectGetMinX (
   CGRect rect
){};



/*CGContextSetGrayStrokeColor

Sets the current stroke color to a value in the DeviceGray color space.

void CGContextSetGrayStrokeColor (
   CGContextRef context,
   float gray,
   float alpha
);
Parameters
context

The graphics context for which to set the current stroke color. 
gray

A value that specifies the desired gray level. The DeviceGray color space permits the specification of a value ranging from 0.0 (absolute black) to 1.0 (absolute white). Values outside this range are clamped to 0.0 or 1.0.
alpha

A value that specifies the opacity level. Values can range from 0.0 (transparent) to 1.0 (opaque). Values outside this range are clipped to 0.0 or 1.0.
Discussion

When you call this function, two things happen:
Quartz sets the current stroke color space to DeviceGray. The DeviceGray color space is a single-dimension space in which color values are specified solely by the intensity of a gray value (from absolute black to absolute white). 
Quartz sets the current stroke color to the value you specify in the gray and alpha parameters.

See also CGContextSetGrayFillColor.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextSetGrayStrokeColor (
   CGContextRef context,
   float gray,
   float alpha
){};


/*CGContextStrokeRect

Paints an outline of a rectangle.

void CGContextStrokeRect (
   CGContextRef context,
   CGRect rect
);
Parameters
context

The graphics context in which to paint the rectangle.
rect

A CGRect value that specifies the dimensions and location in the user space of the rectangle to paint. 
Discussion

This function paints a line along the path of the specified rectangle, using the current attributes of the graphics state. As a side effect when you call this function, Quartz clears the current path.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/

void CGContextStrokeRect (
   CGContextRef context,
   CGRect rect
){};


/*CGRectContainsPoint

Indicates whether a rectangle contains a specified point.

int CGRectContainsPoint (
   CGRect rect,
   CGPoint point
);
Parameters
rect

The rectangle to examine. 
point

The point to examine. 
Return Value

Returns 1 if the specified point is located within the specified rectangle; otherwise, 0. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGGeometry.h*/
int CGRectContainsPoint (
   CGRect rect,
   CGPoint point
){};



/*CGDataProviderCreateWithURL

Creates a Quartz direct-access data provider that uses a URL to supply data.

CGDataProviderRef CGDataProviderCreateWithURL (
   CFURLRef url
);
Parameters
url

A CFURL object to use for the data provider. When you supply Quartz data via the provider, it reads the data from the URL address. 
Return Value

A new data provider. You are responsible for releasing this object using CGDataProviderRelease.
Discussion

You use this function to create a direct-access data provider that supplies data from a URL. When you supply Quartz with a direct-access data provider, Quartz obtains data from your program in a single entire block.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGDataProvider.h*/

CGDataProviderRef CGDataProviderCreateWithURL (
   CFURLRef url
){};
/*CGImageCreateWithPNGDataProvider

Creates a Quartz bitmap image using PNG-encoded data.

CGImageRef CGImageCreateWithPNGDataProvider (
   CGDataProviderRef source,
   const float decode[],
   bool shouldInterpolate,
   CGColorRenderingIntent intent
);
Parameters
source

A data provider supplying PNG-encoded data.
decode

The decode array for the image. Typically a decode array is unnecessary, and you should pass NULL.
shouldInterpolate

A Boolean value that specifies whether interpolation should occur. The interpolation setting specifies whether Quartz should apply a pixel-smoothing algorithm to the image.
intent

A CGColorRenderingIntent constant that specifies how Quartz should handle colors that are not located within the gamut of the destination color space of a graphics context.
Return Value

A new Quartz bitmap image. You are responsible for releasing this object by calling CGImageRelease.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CGImage.h*/

CGImageRef CGImageCreateWithPNGDataProvider (
   CGDataProviderRef source,
   const float decode[],
   bool shouldInterpolate,
   CGColorRenderingIntent intent
){};

/*CGContextGetTextPosition

Returns the location at which text is drawn.

CGPoint CGContextGetTextPosition (
   CGContextRef context
);
Parameters
context

The graphics context from which to obtain the current text position. 
Return Value

Returns a CGPoint value that specifies the x and y values at which text is to be drawn, in user space coordinates. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/

CGPoint CGContextGetTextPosition (
   CGContextRef context
){};


/*CGContextSetTextDrawingMode

Sets the current text drawing mode.

void CGContextSetTextDrawingMode (
   CGContextRef context,
   CGTextDrawingMode mode
);
Parameters
context

The graphics context for which to set the text drawing mode. 
mode

A CGTextDrawingMode value that specifies the text drawing mode to use. For possible values, see Text Drawing Modes.
Discussion

Text drawing modes determine how Quartz renders individual glyphs in a graphics context. For more information, see Text Drawing Modes.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextSetTextDrawingMode (
   CGContextRef context,
   CGTextDrawingMode mode
){};

/*CGContextSelectFont

Sets the font and font size in a graphics context.

void CGContextSelectFont (
   CGContextRef context,
   const char * name,
   float size,
   CGTextEncoding textEncoding
);
Parameters
context

The graphics context for which to set the font and font size. 
name

A null-terminated string that contains the PostScript name of the font to set.
size

A value that specifies the font size to set, in text space units.
textEncoding

A CGTextEncoding value that specifies the encoding used for the font. For a description of the available values, see Text Encodings.
Discussion

For information about when to use this function, see CGFontCreateWithPlatformFont.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextSelectFont (
   CGContextRef context,
   const char * name,
   float size,
   CGTextEncoding textEncoding
){};


/*CGContextShowTextAtPoint

Displays a character string at a position you specify.

void CGContextShowTextAtPoint (
   CGContextRef context,
   float x,
   float y,
   const char * bytes,
   size_t length
);
Parameters
context

The graphics context in which to display the text. 
x

A value for the x-coordinate of the text space at which to display the text.
y

A value for the y-coordinate of the text space at which to display the text.
bytes

An array of characters to draw.
length

The length of the array specified in the bytes parameter.
Discussion

This function displays a character array at the position in the text space that you specify. Quartz use font data provided by ATS (Apple Type Services) to map each byte of the array through the encoding vector of the current font to obtain the glyph to display. Note that the font must have been set using CGContextSelectFont; CGContextShowTextAtPoint should not be used in conjunction with CGContextSetFont.

See also CGContextShowText, CGContextShowGlyphs, CGContextShowGlyphsAtPoint, and CGContextShowGlyphsWithAdvances.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextShowTextAtPoint (
   CGContextRef context,
   float x,
   float y,
   const char * bytes,
   size_t length
){};

/*CGContextFlush

Forces all pending drawing operations in a window context to be rendered immediately to the destination device.

void CGContextFlush (
   CGContextRef context
);
Parameters
context

The window context to flush. If you pass a PDF context or a bitmap context, this function does nothing.
Discussion

When you call this function, Quartz immediately flushes the current drawing to the destination device (for example, a screen). Because the system software flushes a context automatically at the appropriate times, calling this function could have an adverse effect on performance. Under normal conditions, you do not need to call this function.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/

void CGContextFlush (
   CGContextRef context
){};



/*CGAffineTransformScale

Returns an affine transformation matrix constructed by scaling an existing affine transform.

CGAffineTransform CGAffineTransformScale (
   CGAffineTransform t,
   float sx,
   float sy
);
Parameters
t

An existing affine transform. 
sx

The value by which to scale x values of the affine transform.
sy

The value by which to scale y values of the affine transform.
Return Value

A new affine transformation matrix.
Discussion

You use this function to create a new affine transformation matrix by adding scaling values to an existing affine transform. The resulting structure represents a new affine transform, which you can use (and reuse, if you want) to scale a coordinate system. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGAffineTransform.h*/
CGAffineTransform CGAffineTransformScale (
   CGAffineTransform t,
   float sx,
   float sy
){};



/*CGContextAddRects

Adds a set of new rectangular subpaths to a graphics context.

void CGContextAddRects (
   CGContextRef context,
   const CGRect rects[],
   size_t count
);
Parameters
context

The graphics context to which to add the rectangular subpaths.
rects

An array of CGRect values that specify, in the user space, the dimensions and locations of the rectangles to create. 
count

The number of members in the array that you are passing in the rects parameter.
Discussion

This function adds multiple rectangular subpaths to a path at the same time. You can add a subpath consisting of a single rectangle using the function CGContextAddRect. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/

void CGContextAddRects (
   CGContextRef context,
   const CGRect rects[],
   size_t count
){};


/*CGContextSetTextMatrix

Sets the current text matrix.

void CGContextSetTextMatrix (
   CGContextRef context,
   CGAffineTransform transform
);
Parameters
context

The graphics context for which to set the text matrix. 
transform

A text matrix to set. 
Discussion

The text matrix specifies the transform from text space to user space. To produce the final text rendering matrix that is used to actually draw the text on the page, Quartz concatenates the text matrix with the current transformation matrix and other parameters from the graphics state.

Note that the text matrix is not a part of the graphics state—saving or restoring the graphics state has no effect on the text matrix. The text matrix is an attribute of the graphics context, not of the current font.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextSetTextMatrix (
   CGContextRef context,
   CGAffineTransform transform
){};



/*CGContextSetShadow

Enables shadowing in a graphics context. 

void CGContextSetShadow (
   CGContextRef context,
   CGSize offset,
   float blur
);
Parameters
context

A graphics context.
offset

Specifies a translation of the context’s coordinate system, to establish an offset for the shadow ({0,0} specifies a light source immediately above the screen).
blur

A non-negative number specifying the amount of blur.
Discussion

Shadow parameters are part of the graphics state in a context. After shadowing is set, all objects drawn are shadowed using a black color with 1/3 alpha (i.e., RGBA = {0, 0, 0, 1.0/3.0}) in the DeviceRGB color space.

To turn off shadowing:
Use the standard save/restore mechanism for the graphics state.
Use CGContextSetShadowWithColor to set the shadow color to a fully transparent color (or pass NULL as the color).
Availability
Available in Mac OS X version 10.3 and later.
Declared In
CGContext.h*/
void CGContextSetShadow (
   CGContextRef context,
   CGSize offset,
   float blur
){};


/*CGContextSetShouldSmoothFonts

Enables or disables font smoothing in a graphics context.

void CGContextSetShouldSmoothFonts (
CGContextRef context,
bool shouldSmoothFonts
);
Parameters
context

The graphics context to modify.
shouldSmoothFonts

A Boolean value that specifies whether font smoothing should be enabled.
Discussion

There are cases, such as rendering to a bitmap, when font smoothing is not appropriate and should be disabled. Note that some contexts (such as PostScript contexts) do not support font smoothing.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CGContext.h*/
void CGContextSetShouldSmoothFonts (
CGContextRef context,
bool shouldSmoothFonts
){};


/*CGRectIntersectsRect

Indicates whether two rectangles intersect.

int CGRectIntersectsRect (
   CGRect rect1,
   CGRect rect2
);
Parameters
rect1

The first rectangle to examine. 
rect2

The second rectangle to examine.
Return Value

Returns 1 if the two specified rectangles intersect; otherwise, 0. The first rectangle intersects the second if the intersection of the rectangles is not equal to the null rectangle. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGGeometry.h*/
int CGRectIntersectsRect (
   CGRect rect1,
   CGRect rect2
){};


/*CGContextClipToRect

Sets the clipping path to the intersection of the current clipping path with the area defined by the specified rectangle.

void CGContextClipToRect (
   CGContextRef context,
   CGRect rect
);
Parameters
context

The graphics context for which to set the clipping path. 
rect

A CGRect value that specifies, in the user space, the location and dimensions of the rectangle to be used in determining the new clipping path. 
Discussion

This function sets the specified graphics context’s clipping region to the area which intersects both the current clipping path and the specified rectangle.

After determining the new clipping path, the CGContextClipToRect function resets the context’s current path to an empty path.

See also CGContextClipToRects. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/

void CGContextClipToRect (
   CGContextRef context,
   CGRect rect
){};



/*CGDisplayCapture

Captures a display for exclusive use by an application. 

CGDisplayErr CGDisplayCapture (
   CGDirectDisplayID display
);
Parameters
display

The display to capture.
Return Value

A result code. See “Quartz Display Services Result Codes”.
Discussion

When an application captures a display, Quartz does not allow other applications and system services to use the display or change its configuration. 
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
CGDirectDisplay.h*/

CGDisplayErr CGDisplayCapture (
   CGDirectDisplayID display
){};


/*CGDisplayRelease

Releases a captured display.

CGDisplayErr CGDisplayRelease (
   CGDirectDisplayID display
);
Parameters
display

The display to release.
Return Value

A result code. See “Quartz Display Services Result Codes”. 
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
CGDirectDisplay.h*/

CGDisplayErr CGDisplayRelease (
   CGDirectDisplayID display
){};


/*CGContextGetPathBoundingBox

Returns the smallest rectangle that contains the current path.

CGRect CGContextGetPathBoundingBox (
   CGContextRef context
);
Parameters
context

The graphics context, containing a path, to examine. 
Return Value

A CGRect value that specifies the dimensions and location, in user space, of the bounding box of the path. If there is no path, the function returns CGRectNull.
Discussion

The bounding box is the smallest rectangle completely enclosing all points in a path, including control points for Bézier cubic and quadratic curves.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/

CGRect CGContextGetPathBoundingBox (
   CGContextRef context
){};



/*CGContextClosePath

Closes and terminates an open subpath.

void CGContextClosePath (
   CGContextRef context
);
Parameters
context

The graphics context containing the subpath to close.
Discussion

If a subpath is open, this function closes the subpath (draws a straight line that connects the current point to the starting point), and terminates the subpath (the current point is no longer defined).

If no subpath is open, this function does nothing.

NOTE: You can stroke along an open subpath. When a subpath is open and you fill or clip, however, Quartz implicitly closes the subpath for you.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextClosePath (
   CGContextRef context
){};



/*CGContextSynchronize

Marks a window context for update.

void CGContextSynchronize (
   CGContextRef context
);
Parameters
context

The window context to synchronize. If you pass a PDF context or a bitmap context, this function does nothing. 
Discussion

When you call this function, all drawing operations since the last update will be flushed at the next regular opportunity. Under normal conditions, you do not need to call this function.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/

void CGContextSynchronize (
   CGContextRef context
){};


/*CGContextGetCTM

Returns the current transformation matrix.

CGAffineTransform CGContextGetCTM (
   CGContextRef context
);
Parameters
context

A graphics context.
Return Value

The transformation matrix for the current graphics state of the specified context.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
CGAffineTransform CGContextGetCTM (
   CGContextRef context
){};

/*CGDisplayUsesOpenGLAcceleration

Returns a Boolean value indicating whether Quartz is using OpenGL-based window acceleration (Quartz Extreme) to render in a display.

boolean_t CGDisplayUsesOpenGLAcceleration (
   CGDirectDisplayID display
);
Parameters
display

The display to access.
Return Value

If true, Quartz Extreme is used to render in the specified display; otherwise, false.
Discussion

Quartz Extreme is an OpenGL-based, hardware-accelerated window compositor available in Mac OS X version 10.2 and later. Quartz Extreme requires a minimum hardware configuration to operate.

The information this function provides is typically used to adjust the demands of drawing operations to the capabilities of the display hardware. For example, an application running on an unaccelerated system could disable live window-resizing.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CGDisplayConfiguration.h*/
boolean_t CGDisplayUsesOpenGLAcceleration (
   CGDirectDisplayID display
){};



/*CGRectOffset

Returns a rectangle with an origin offset from that of the source rectangle.

CGRect CGRectOffset (
   CGRect rect,
   float dx,
   float dy
);
Parameters
rect

The source rectangle. 
dx

The value by which to move the x-coordinate of the source rectangle’s origin.
dy

The value by which to move the y-coordinate of the source rectangle’s origin.
Return Value

A rectangle with the same size as the source, but with its origin offset by dx units along the x-axis and dy units along the y-axis with respect to the source.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGGeometry.h*/

CGRect CGRectOffset (
   CGRect rect,
   float dx,
   float dy
){};



/*CGContextStrokeRectWithWidth

Paints an outline of a rectangle, using the specified line width.

void CGContextStrokeRectWithWidth (
   CGContextRef context,
   CGRect rect,
   float width
);
Parameters
context

The graphics context in which to paint the rectangle.
rect

A CGRect value that specifies the dimensions and location in the user space of the rectangle to paint. 
width

The line width to use for stroking the rectangle, expressed in user space units. The value must be greater than zero.
Discussion

This function paints a line of the specified width along the path of a rectangle. The line surrounds the center of the path, with half of the total width on either side. As a side effect when you call this function, Quartz clears the current path.

Aside from the line width value, which is taken from the function’s width parameter, CGContextStrokeRectWithWidth uses the current attributes of the graphics state to paint the line. 

On return, the line width in the context’s graphics state is unaffected.

See also CGContextStrokeRect.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextStrokeRectWithWidth (
   CGContextRef context,
   CGRect rect,
   float width
){};


/*CGContextBeginPage

Starts a new page in a page-based graphics context.

void CGContextBeginPage (
   CGContextRef context,
   const CGRect * mediaBox
);
Parameters
context

A page-based graphics context such as a PDF context. If you specify a context that does not support multiple pages, this function does nothing.
mediaBox

A Quartz rectangle defining the bounds of the new page, expressed in units of the default user space, or NULL. These bounds supersede any supplied for the media box when you created the context. If you pass NULL, Quartz uses the rectangle you supplied for the media box when the graphics context was created. 
Discussion

When using a graphics context that supports multiple pages, you should call this function together with CGContextEndPage to delineate the page boundaries in the output. In other words, each page should be bracketed by calls to CGContextBeginPage and CGContextEndPage. Quartz ignores all drawing operations performed outside a page boundary in a page-based context.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/

void CGContextBeginPage (
   CGContextRef context,
   const CGRect * mediaBox
){};

/*CGContextEndPage

Ends the current page in a page-based graphics context.

void CGContextEndPage (
   CGContextRef context
);
Parameters
context

A page-based graphics context.
Discussion

When using a graphics context that supports multiple pages, you should call this function to terminate drawing in the current page. 

For more information, see CGContextBeginPage.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextEndPage (
   CGContextRef context
){};
/*CGPDFContextCreateWithURL

Creates a URL-based PDF graphics context.

CGContextRef CGPDFContextCreateWithURL (
   CFURLRef url,
   const CGRect * mediaBox,
   CFDictionaryRef auxiliaryInfo
);
Parameters
url

A Core Foundation URL that specifies where you want to place the resulting PDF file.
mediaBox

A rectangle that specifies the bounds of the PDF. The origin of the rectangle should typically be (0,0). The CGPDFContextCreateWithURL function uses this rectangle as the default page media bounding box. If you pass NULL, CGPDFContextCreateWithURL uses a default page size of 8.5 by 11 inches (612 by 792 points). 
auxiliaryInfo

A dictionary that specifies any additional information to be used by the PDF context when generating the PDF file, or NULL. The dictionary is retained by the new context, so on return you may safely release it.
Return Value

A new PDF context, or NULL if a context could not be created. You are responsible for releasing this object using CGContextRelease.
Discussion

When you call this function, Quartz creates a PDF drawing environment—that is, a graphics context—to your specifications. When you draw into the resulting context, Quartz renders your drawing as a series of PDF drawing commands stored in the specified location.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGPDFContext.h*/
CGContextRef CGPDFContextCreateWithURL (
   CFURLRef url,
   const CGRect * mediaBox,
   CFDictionaryRef auxiliaryInfo
){};



/*CGSetDisplayTransferByTable

Sets the color gamma function for a display, by specifying the values in the RGB gamma tables. 

CGDisplayErr CGSetDisplayTransferByTable (
   CGDirectDisplayID display,
   CGTableCount tableSize,
   const CGGammaValue * redTable,
   const CGGammaValue * greenTable,
   const CGGammaValue * blueTable
);
Parameters
display

The display to access.
tableSize

The number of entries in each table.
redTable

An array of size tableSize containing the values of the red channel in the display’s gamma table. The values should be in the range 0.0 to 1.0.
greenTable

An array of size tableSize containing the values of the green channel in the display’s gamma table. The values should be in the range 0.0 to 1.0.
blueTable

An array of size tableSize containing the values of the blue channel in the display’s gamma table. The values should be in the range 0.0 to 1.0.
Return Value

A result code. See “Quartz Display Services Result Codes”.
Discussion

The same table may be passed in for the red, green, and blue channels. The tables are interpolated as needed to generate the number of samples required by the graphics hardware.
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
CGDirectDisplay.h*/
CGDisplayErr CGSetDisplayTransferByTable (
   CGDirectDisplayID display,
   CGTableCount tableSize,
   const CGGammaValue * redTable,
   const CGGammaValue * greenTable,
   const CGGammaValue * blueTable
){};


/*CGGetDisplayTransferByTable

Gets the values in the RGB gamma tables for a display.

CGDisplayErr CGGetDisplayTransferByTable (
   CGDirectDisplayID display,
   CGTableCount capacity,
   CGGammaValue * redTable,
   CGGammaValue * greenTable,
   CGGammaValue * blueTable,
   CGTableCount * sampleCount
);
Parameters
display

The display to access.
capacity

The number of entries each table can hold.
redTable

A pointer to an array of type CGGammaValue with size capacity. On return, the array contains the values of the red channel in the display’s gamma table.
greenTable

A pointer to an array of type CGGammaValue with size capacity. On return, the array contains the values of the green channel in the display’s gamma table.
blueTable

A pointer to an array of type CGGammaValue with size capacity. On return, the array contains the values of the blue channel in the display’s gamma table.
sampleCount

The number of samples actually copied into each array.
Return Value

A result code. See “Quartz Display Services Result Codes”.
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
CGDirectDisplay.h*/

CGDisplayErr CGGetDisplayTransferByTable (
   CGDirectDisplayID display,
   CGTableCount capacity,
   CGGammaValue * redTable,
   CGGammaValue * greenTable,
   CGGammaValue * blueTable,
   CGTableCount * sampleCount
){};

/*CGContextSetLineJoin

Sets the style for the joins of connected lines in a graphics context.

void CGContextSetLineJoin (
   CGContextRef context,
   CGLineJoin join
);
Parameters
context

The graphics context for which to set the line join parameter of the current graphics state. 
join

A CGLineJoin value that specifies the new line join style to be used. For an discussion of the available line join styles, see Line Joins. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/

void CGContextSetLineJoin (
   CGContextRef context,
   CGLineJoin join
){};

/*CGContextSetMiterLimit

Sets the miter limit for the joins of connected lines in a graphics context.

void CGContextSetMiterLimit (
   CGContextRef context,
   float limit
);
Parameters
context

The graphics context for which to set the miter limit parameter of the current graphics state. 
limit

The new miter limit to be used.
Discussion

If the current line join style is set to kCGLineJoinMiter (see CGContextSetLineJoin), Quartz uses the miter limit to determine whether the lines should be joined with a bevel instead of a miter. Quartz divides the length of the miter by the line width. If the result is greater than the miter limit, the style is converted to a bevel. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextSetMiterLimit (
   CGContextRef context,
   float limit
){};



/*CGRectGetMaxX

Returns the x-axis coordinate that establishes the right edge of a rectangle.

float CGRectGetMaxX (
   CGRect rect
);
Parameters
rect

The rectangle to examine. 
Return Value

The x-coordinate of the top-right corner of the specified rectangle.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGGeometry.h*/


float CGRectGetMaxX (
   CGRect rect
){};


/*CGFunctionCreate

Creates a Quartz function.

CGFunctionRef CGFunctionCreate (
   void *info,
   size_t domainDimension,
   const float *domain,
   size_t rangeDimension,
   const float *range,
   const CGFunctionCallbacks *callbacks
);
Parameters
info

A pointer to user-defined storage for data that you want to pass to your callbacks. You need to make sure that the data persists for as long as it’s needed, which can be beyond the scope in which the Quartz function is used. 
domainDimension

The number of inputs.
domain

An array of (2*domainDimension) floats used to specify the valid intervals of input values. For each k from 0 to (domainDimension - 1), domain[2*k] must be less than or equal to domain[2*k+1], and the kth input value will be clipped to lie in the interval domain[2*k] ≤ input[k] ≤ domain[2*k+1]. If this parameter is NULL, then the input values are not clipped.
rangeDimension

The number of outputs.
range

An array of (2*rangeDimension) floats that specifies the valid intervals of output values. For each k from 0 to (rangeDimension - 1), range[2*k] must be less than or equal to range[2*k+1], and the kth output value will be clipped to lie in the interval range[2*k] ≤ output[k] ≤ range[2*k+1]. If this parameter is NULL, then the output values are not clipped.
callbacks

A pointer to a callback function table. This table should contain pointers to the callbacks you provide to implement the semantics of this Quartz function. Quartz makes a copy of your table, so, for example, you could safely pass in a pointer to a structure on the stack.
Return Value

The new Quartz function. You are responsible for releasing this object using CGFunctionRelease.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CGFunction.h*/

CGFunctionRef CGFunctionCreate (
   void *info,
   size_t domainDimension,
   const float *domain,
   size_t rangeDimension,
   const float *range,
   const CGFunctionCallbacks *callbacks
){};
/*CGShadingRelease

Decrements the retain count of a Quartz shading.

void CGShadingRelease (
   CGShadingRef shading
);
Parameters
shading

The shading to release.
Discussion

This function is equivalent to CFRelease, except that it does not cause an error if the shading parameter is NULL.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CGShading.h*/
void CGShadingRelease (
   CGShadingRef shading
){};

/*CGShadingCreateAxial

Creates a Quartz axial shading.

CGShadingRef CGShadingCreateAxial (
   CGColorSpaceRef colorspace,
   CGPoint start,
   CGPoint end,
   CGFunctionRef function,
   bool extendStart,
   bool extendEnd
);
Parameters
colorspace

The color space in which color values are expressed. Quartz retains this object; upon return, you may safely release it.
start

The starting point of the axis, in the shading's target coordinate space.
end

The ending point of the axis, in the shading's target coordinate space.
function

A CGFunction object created by the function CGFunctionCreate. This object refers to your function for creating an axial shading. Quartz retains this object; upon return, you may safely release it.
extendStart

A Boolean value that specifies whether to extend the shading beyond the starting point of the axis.
extendEnd

A Boolean value that specifies whether to extend the shading beyond the ending point of the axis.
Return Value

A new Quartz axial shading. You are responsible for releasing this object using CGShadingRelease.
Discussion

An axial shading is a color blend that varies along a linear axis between two endpoints and extends indefinitely perpendicular to that axis. When you are ready to draw the shading, call the function CGContextDrawShading.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CGShading.h*/

CGShadingRef CGShadingCreateAxial (
   CGColorSpaceRef colorspace,
   CGPoint start,
   CGPoint end,
   CGFunctionRef function,
   bool extendStart,
   bool extendEnd
){};


/*CGContextDrawShading

Fills the clipping path of a context with the specified shading.

void CGContextDrawShading (
CGContextRef context,
CGShadingRef shading
);
Parameters
context

The graphics context in which to draw the shading. 
shading

A Quartz shading. Quartz retains this object; upon return, you may safely release it.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CGContext.h*/

void CGContextDrawShading (
CGContextRef context,
CGShadingRef shading
){};



/*CGContextSetTextPosition

Sets the location at which text is drawn.

void CGContextSetTextPosition (
   CGContextRef context,
   float x,
   float y
);
Parameters
context

The graphics context for which to set the current text position. 
x

A value for the x-coordinate at which to draw the text, in user space coordinates.
y

A value for the y-coordinate at which to draw the text.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/

void CGContextSetTextPosition (
   CGContextRef context,
   float x,
   float y
){};


/*CGContextShowText

Displays a character string at the current text position.

void CGContextShowText (
   CGContextRef context,
   const char * bytes,
   size_t length
);
Parameters
context

The graphics context in which the text is drawn. 
bytes

An array of characters to draw.
length

The length of the array specified in the bytes parameter.
Discussion

This function displays a character array at the current text position, a point specified by the current text matrix. Quartz use font data provided by ATS (Apple Type Services) to map each byte of the array through the encoding vector of the current font to obtain the glyph to display. Note that the font must have been set using CGContextSelectFont; CGContextShowText should not be used in conjunction with CGContextSetFont.

See also CGContextShowTextAtPoint, CGContextShowGlyphs, CGContextShowGlyphsAtPoint, and CGContextShowGlyphsWithAdvances.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextShowText (
   CGContextRef context,
   const char * bytes,
   size_t length
){};


/*CGContextSetFillColor

Sets the current fill color.

void CGContextSetFillColor(
   CGContextRef context,
   const float components[]
);
Parameters
context

The graphics context for which to set the current fill color.
components 

An array of intensity values describing the color to set. The number of array elements must equal the number of components in the current fill color space, plus an additional component for the alpha value.
Discussion

The current fill color space must not be a pattern colorspace. For information on setting the fill color when using a pattern colorspace, see CGContextSetFillPattern. Note that the preferred API to use is now CGContextSetFillColorWithColor.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/

void CGContextSetFillColor(
   CGContextRef context,
   const float components[]
){};

/*CGContextSetStrokeColor

Sets the current stroke color.

void CGContextSetStrokeColor(
   CGContextRef context,
   const float components[]
);
Parameters
context

The graphics context for which to set the current stroke color.
components

An array of intensity values describing the color to set. The number of array elements must equal the number of components in the current stroke color space, plus an additional component for the alpha value.
Discussion

The current stroke color space must not be a pattern color space. For information on setting the stroke color when using a pattern colorspace, see CGContextSetStrokePattern. Note that the preferred API is now CGContextSetStrokeColorWithColor.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextSetStrokeColor(
   CGContextRef context,
   const float components[]
){};


/*CGContextSetLineDash

Sets the pattern for dashed lines in a graphics context.

void CGContextSetLineDash (
   CGContextRef context,
   float phase,
   const float lengths[],
   size_t count
);
Parameters
context

The graphics context for which to set the line dash parameter of the current graphics state. 
phase

A value that specifies how far into the dash pattern the line starts, in units of the user space. For example, passing a value of 3 means the line is drawn with the dash pattern starting at 3 units in from its beginning. Passing a value of 0 draws a line starting with the beginning of a dash pattern.
lengths

An array of values that specify the lengths of the painted segments and unpainted segments, respectively, of the dash pattern—or NULL for no dash pattern.

For example, passing an array with the values [2,3] sets a dash pattern that alternates between a 2-user-space-unit-long painted segment and a 3-user-space-unit-long unpainted segment. Passing the values [1,3,4,2] sets the pattern to a 1-unit painted segment, a 3-unit unpainted segment, a 4-unit painted segment, and a 2-unit unpainted segment.
count

If the lengths parameter specifies an array, pass the number of elements in the array. Otherwise, pass 0.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextSetLineDash (
   CGContextRef context,
   float phase,
   const float lengths[],
   size_t count
){};


/*CGContextAddArcToPoint

Adds an arc of a circle to the current subpath, using a radius and tangent points.

void CGContextAddArcToPoint (
   CGContextRef context,
   float x1,
   float y1,
   float x2,
   float y2,
   float radius
);
Parameters
context

The graphics context to which to add the arc. The context’s path must not be empty.
x1

The x-coordinate of the user space for the end point of the first tangent line. The first tangent line is drawn from the current point to (x1,y1).
y1

The y-coordinate of the user space for the end point of the first tangent line. The first tangent line is drawn from the current point to (x1,y1).
x2

The x-coordinate of the user space for the end point of the second tangent line. The second tangent line is drawn from (x1,y1) to (x2,y2).
y2

The y-coordinate of the user space for the end point of the second tangent line. The second tangent line is drawn from (x1,y1) to (x2,y2).
radius

The radius of the arc, in user space coordinates.
Discussion

This function draws an arc that is tangent to the line from the current point to (x1,y1) and to the line from (x1,y1) to (x2,y2). The start and end points of the arc are located on the first and second tangent lines, respectively. The start and end points of the arc are also the “tangent points” of the lines.

If the current point and the first tangent point of the arc (the starting point) are not equal, Quartz appends a straight line segment from the current point to the first tangent point. After adding the arc, the current point is reset to the end point of arc (the second tangent point).

See also CGContextAddArc.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/

void CGContextAddArcToPoint (
   CGContextRef context,
   float x1,
   float y1,
   float x2,
   float y2,
   float radius
){};


/*CGContextDrawPath

Draws the current path using a specified drawing mode.

void CGContextDrawPath (
   CGContextRef context,
   CGPathDrawingMode mode
);
Parameters
context

The graphics context containing the path to paint.
mode

A CGPathDrawingMode value that specifies how to paint the path. See CGPathDrawingMode for possible values.
Discussion

This function draws the current path using the specified drawing mode. When you fill the current path, Quartz fills each subpath independently. Any subpath that has not been explicitly closed is closed implicitly by the fill routines.

See also CGContextFillPath, CGContextEOFillPath, and CGContextStrokePath.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/

void CGContextDrawPath (
   CGContextRef context,
   CGPathDrawingMode mode
){};


/*CGBitmapContextGetData

Returns a pointer to the image data associated with a bitmap context.

void *CGBitmapContextGetData (
CGContextRef context
);
Parameters
context

The bitmap context to examine.
Return Value

A pointer to the specified bitmap context’s image data, or NULL if the context is not a bitmap context.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CGBitmapContext.h*/
void *CGBitmapContextGetData (
CGContextRef context
){};


/*CGRectContainsRect

Indicates whether the first rectangle contains the second rectangle.

int CGRectContainsRect (
   CGRect rect1,
   CGRect rect2
);
Parameters
rect1

The rectangle to examine for containment of the rectangle passed in rect2. 
rect2

The rectangle to examine for being contained in the rectangle passed in rect1.
Return Value

Returns 1 if the rectangle specified by rect2 is contained in the rectangle passed in rect1; otherwise, 0. The first rectangle contains the second if the union of the two rectangles is equal to the first rectangle. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGGeometry.h*/

int CGRectContainsRect (
   CGRect rect1,
   CGRect rect2
){};

/*CGRectStandardize

Returns a rectangle with a positive width and height.

CGRect CGRectStandardize (
   CGRect rect
);
Parameters
rect

The source rectangle. 
Return Value

Returns a rectangle, equivalent to the source rectangle, with a positive width and height. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGGeometry.h*/
CGRect CGRectStandardize (
   CGRect rect
){};

/*CGSizeMake

Returns a size structure constructed from dimension values you provide.

CGSize CGSizeMake (
   float width,
   float height
);
Parameters
width

A width value.
height

A height value.
Return Value

Returns a CGSize structure with the specified width and height. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGGeometry.h*/

CGSize CGSizeMake (
   float width,
   float height
){};


/*CGContextSetFillColorSpace

Sets the fill color space in a graphics context.

void CGContextSetFillColorSpace (
   CGContextRef context,
   CGColorSpaceRef colorspace
);
Parameters
context

The graphics context for which to set the fill color space.
colorspace

The new fill color space. Quartz retains this object; upon return, you may safely release it.
Discussion

As a side effect of this function, Quartz assigns an appropriate initial value to the fill color, based on the specified color space. To change this value, call CGContextSetFillColor. Note that the preferred API to use is now CGContextSetFillColorWithColor.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextSetFillColorSpace (
   CGContextRef context,
   CGColorSpaceRef colorspace
){};

/*CGContextSetStrokeColorSpace

Sets the stroke color space in a graphics context.

void CGContextSetStrokeColorSpace (
   CGContextRef context,
   CGColorSpaceRef colorspace
);
Parameters
context

The graphics context for the new stroke color space.
colorspace

The new stroke color space. Quartz retains this object; upon return, you may safely release it.
Discussion

As a side effect when you call this function, Quartz assigns an appropriate initial value to the stroke color, based on the color space you specify. To change this value, call CGContextSetStrokeColor. Note that the preferred API is now CGContextSetStrokeColorWithColor.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextSetStrokeColorSpace (
   CGContextRef context,
   CGColorSpaceRef colorspace
){};

/*CGContextDrawPDFPage

Draws a page in the current user space of a PDF context.

void CGContextDrawPDFPage (
   CGContextRef context,
   CGPDFPageRef page
);
Parameters
context

The graphics context in which to draw the PDF page. 
page

A Quartz PDF page.
Discussion

This function works in conjunction with the opaque type CGPDFPageRef to draw individual pages into a PDF context.

For applications running in Mac OS X version 10.3 and later, this function is recommended as a replacement for the older function CGContextDrawPDFDocument.
Availability
Available in Mac OS X version 10.3 and later.
Declared In
CGContext.h*/
void CGContextDrawPDFPage (
   CGContextRef context,
   CGPDFPageRef page
){};

/*CGContextEOClip

Modifies the current clipping path, using the even-odd rule.

void CGContextEOClip (
   CGContextRef context
);
Parameters
context

A graphics context containing a path. If the context does not have a current path, the function does nothing.
Discussion

The function uses the even-odd rule to calculate the intersection of the current path with the current clipping path. Quartz then uses the path resulting from the intersection as the new current clipping path for subsequent painting operations.

Unlike the current path, the current clipping path is part of the graphics state. Therefore, to re-enlarge the paintable area by restoring the clipping path to a prior state, you must save the graphics state before you clip and restore the graphics state after you’ve completed any clipped drawing.

After determining the new clipping path, the function resets the context’s current path to an empty path.

See also CGContextClip.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextEOClip (
   CGContextRef context
){};




/*CGPDFDocumentCreateWithProvider

Creates a Quartz PDF document using a data provider.

CGPDFDocumentRef CGPDFDocumentCreateWithProvider (
CGDataProviderRef provider
);
Parameters
provider

A data provider that supplies the PDF document data. 
Return Value

A new Quartz PDF document, or NULL if a document could not be created. You are responsible for releasing the object using CGPDFDocumentRelease. 
Discussion

For information about drawing a PDF document in a graphics context, see CGContextDrawPDFDocument.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGPDFDocument.h*/

CGPDFDocumentRef CGPDFDocumentCreateWithProvider (
CGDataProviderRef provider)
{};

/*CGPDFDocumentGetPage

Returns a page from a Quartz PDF document.

CGPDFPageRef CGPDFDocumentGetPage (
   CGPDFDocumentRef document,
   size_t pageNumber
);
Parameters
document

A PDF document.
pageNumber

The number of the page requested.
Return Value

Return the PDF page corresponding to the specified page number, or NULL if no such page exists in the document. Pages are numbered starting at 1.
Availability
Available in Mac OS X version 10.3 and later.
Declared In
CGPDFDocument.h*/

CGPDFPageRef CGPDFDocumentGetPage (
   CGPDFDocumentRef document,
   size_t pageNumber
){};


/*CGPDFContextCreate

Creates a PDF graphics context.

CGContextRef CGPDFContextCreate (
   CGDataConsumerRef consumer,
   const CGRect * mediaBox,
   CFDictionaryRef auxiliaryInfo
);
Parameters
consumer

A data consumer to receive the PDF output data. 
mediaBox

A pointer to a rectangle that defines the size and location of the PDF page, or NULL. The origin of the rectangle should typically be (0,0). Quartz uses this rectangle as the default bounds of the page’s media box. If you pass NULL, Quartz uses a default page size of 8.5 by 11 inches (612 by 792 points). 
auxiliaryInfo

A dictionary that specifies any additional information to be used by the PDF context when generating the PDF file, or NULL. The dictionary is retained by the new context, so on return you may safely release it. See Auxiliary Dictionary Keys for keys you can include in the dictionary.
Return Value

A new PDF context, or NULL if the context could not be created. You are responsible for releasing this object using CGContextRelease.
Discussion

This function creates a PDF drawing environment to your specifications. When you draw into the new context, Quartz renders your drawing as a sequence of PDF drawing commands that are passed to the data consumer object.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGPDFContext.h*/

CGContextRef CGPDFContextCreate (
   CGDataConsumerRef consumer,
   const CGRect * mediaBox,
   CFDictionaryRef auxiliaryInfo
){};


/*CGDataConsumerRelease

Decrements the retain count of a data consumer.

void CGDataConsumerRelease (
   CGDataConsumerRef consumer
);
Parameters
consumer

The data consumer to release. 
Discussion

This function is equivalent to CFRelease, except that it does not cause an error if the consumer parameter is NULL.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGDataConsumer.h*/
void CGDataConsumerRelease (
   CGDataConsumerRef consumer
){};

/*CGDataConsumerCreate

Creates a Quartz data consumer.

CGDataConsumerRef CGDataConsumerCreate (
   void *info,
   const CGDataConsumerCallbacks * callbacks
);
Parameters
info

A pointer to data of any type or NULL. When Quartz calls the functions specified in the callbacks parameter, it passes this pointer as the info parameter.
callbacks

A pointer to a CGDataConsumerCallbacks structure that specifies the callback functions you implement to copy data sent to the consumer and to handle the consumer’s basic memory management. For a complete description, see CGDataConsumerCallbacks. 
Return Value

A new data consumer object. You are responsible for releasing this object using CGDataConsumerRelease.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGDataConsumer.h*/
CGDataConsumerRef CGDataConsumerCreate (
   void *info,
   const CGDataConsumerCallbacks * callbacks
){};

/*CGContextGetPathCurrentPoint

Returns the current point in a non-empty path.

CGPoint CGContextGetPathCurrentPoint (
   CGContextRef context
);
Parameters
context

The graphics context containing the path to examine. 
Return Value

A CGPoint value that specifies the location, in user space, of current point in the context’s path. If there is no path, the function returns CGPointZero.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
CGPoint CGContextGetPathCurrentPoint (
   CGContextRef context
){};



/*CGContextIsPathEmpty

Indicates whether the current path contains any subpaths.

int CGContextIsPathEmpty (
   CGContextRef context
);
Parameters
context

The graphics context containing the path to examine. 
Return Value

Returns 1 if the context’s path contains no subpaths, otherwise returns 0. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/

int CGContextIsPathEmpty (
   CGContextRef context
){};

/*CGContextSetShouldAntialias

Sets anti-aliasing on or off for a graphics context.

void CGContextSetShouldAntialias (
   CGContextRef context,
   bool shouldAntialias
);
Parameters
context

The graphics context to modify.
shouldAntialias

A Boolean value that specifies whether anti-aliasing should be turned on.
Discussion

Anti-aliasing is a graphics state parameter. When a window or bitmap context is created, anti-aliasing is turned on by default. For other types of context, anti-aliasing is turned off.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextSetShouldAntialias (
   CGContextRef context,
   bool shouldAntialias
){};


/*CGColorSpaceGetNumberOfComponents

Returns the number of color components in a color space.

size_t CGColorSpaceGetNumberOfComponents (
   CGColorSpaceRef cs
);
Parameters
cs

The Quartz color space to examine. 
Return Value

The number of color components in the specified color space, not including the alpha value. For example, for an RGB color space, CGColorSpaceGetNumberOfComponents returns a value of 3.
Discussion

A color space defines an n-dimensional space whose dimensions (or components) represent intensity values. For example, you specify colors in RGB space as three intensity values: red, green, and blue. You can use the CGColorSpaceGetNumberOfComponents function to obtain the number of components in a given color space. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGColorSpace.h*/

size_t CGColorSpaceGetNumberOfComponents (
   CGColorSpaceRef cs
){};


/*CGShadingCreateRadial

Creates a Quartz radial shading.

CGShadingRef CGShadingCreateRadial (
   CGColorSpaceRef colorspace,
   CGPoint start,
   float startRadius,
   CGPoint end,
   float endRadius,
   CGFunctionRef function,
   bool extendStart,
   bool extendEnd
);
Parameters
colorspace

The color space in which color values are expressed. Quartz retains this object; upon return, you may safely release it.
start

The center of the starting circle, in the shading's target coordinate space.
startRadius

The radius of the starting circle, in the shading's target coordinate space.
end

The center of the ending circle, in the shading's target coordinate space.
endRadius

The radius of the ending circle, in the shading's target coordinate space.
function

A CGFunction object created by the function CGFunctionCreate. This object refers to your function for creating a radial shading. Quartz retains this object; upon return, you may safely release it.
extendStart

A Boolean value that specifies whether to extend the shading beyond the starting circle.
extendEnd

A Boolean value that specifies whether to extend the shading beyond the ending circle.
Return Value

A new Quartz radial shading. You are responsible for releasing this object using CGShadingRelease.
Discussion

A radial shading is a color blend that varies between two circles. To draw the shading, call the function CGContextDrawShading.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CGShading.h*/
CGShadingRef CGShadingCreateRadial (
   CGColorSpaceRef colorspace,
   CGPoint start,
   float startRadius,
   CGPoint end,
   float endRadius,
   CGFunctionRef function,
   bool extendStart,
   bool extendEnd
){};




/*CGFunctionRelease

Decrements the retain count of a Quartz function.

void CGFunctionRelease (
   CGFunctionRef function
);
Parameters
function

The Quartz function to release.
Discussion

This function is equivalent to CFRelease, except that it does not cause an error if the function parameter is NULL.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CGFunction.h*/
void CGFunctionRelease (
   CGFunctionRef function
){};


/*CGAffineTransformRotate

Returns an affine transformation matrix constructed by rotating an existing affine transform.

CGAffineTransform CGAffineTransformRotate (
   CGAffineTransform t,
   float angle
);
Parameters
t

An existing affine transform. 
angle

The angle, in radians, by which to rotate the affine transform.
Return Value

A new affine transformation matrix.
Discussion

You use this function to create a new affine transformation matrix by adding a rotation value to an existing affine transform. The resulting structure represents a new affine transform, which you can use (and reuse, if you want) to rotate a coordinate system. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGAffineTransform.h*/

CGAffineTransform CGAffineTransformRotate (
   CGAffineTransform t,
   float angle
){};


/*CGAffineTransformInvert

Returns an affine transformation matrix constructed by inverting an existing affine transform.

CGAffineTransform CGAffineTransformInvert (
   CGAffineTransform t
);
Parameters
t

An existing affine transform. 
Return Value

A new affine transformation matrix. If the affine transform passed in parameter t cannot be inverted, Quartz returns the affine transform unchanged.
Discussion

You can invert a matrix to produce an inverse matrix. Inversion is generally used to provide reverse transformation of points within transformed objects. Given the coordinates (x,y), which have been transformed by a given matrix to new coordinates (x’,y’), transforming the coordinates (x’,y’) by the inverse matrix produces the original coordinates (x,y).
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGAffineTransform.h*/
CGAffineTransform CGAffineTransformInvert (
   CGAffineTransform t
){};


/*CGContextAddLines

Creates a new subpath that consists of a sequence of connected straight-line segments.

void CGContextAddLines (
   CGContextRef context,
   const CGPoint points[],
   size_t count
);
Parameters
context

The graphics context to which to add a subpath of line segments. 
points

An array of CGPoint values specifying the start and end points of the line segments to be drawn. Each point in the array specifies a position in user space. 
count

The number of elements in the array specified in the points parameter.
Discussion

This is a convenience function that adds a sequence of connected line segments to a graphics path. The first point in your CGPoint array specifies the initial starting point for the subpath. Quartz builds the subpath by connecting each point in the array with the subsequent point in the array, using straight line segments.

Upon return, the current point is the last point in the array. This function does not automatically close the subpath for you.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextAddLines (
   CGContextRef context,
   const CGPoint points[],
   size_t count
){};


/*CGContextEOFillPath

Paints the area within the current path, using the even-odd fill rule.

void CGContextEOFillPath (
   CGContextRef context
);
Parameters
context

The graphics context containing the path to fill.
Discussion

When you fill the current path, Quartz fills each subpath independently. Any subpath that has not been explicitly closed is closed implicitly by the fill routines. 

There are two different methods of filling paths. The CGContextEOFillPath function uses the even-odd rule to fill a path. The function CGContextFillPath uses the nonzero winding number rule to fill a path. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextEOFillPath (
   CGContextRef context
){};



/*CGDisplayBaseAddress

Returns the base address in frame buffer memory of an online display.

void * CGDisplayBaseAddress (
   CGDirectDisplayID display
);
Parameters
display

The display to access.
Return Value

The base address in frame buffer memory of the specified display. If the display ID is invalid, the return value is NULL.
Discussion

If the display has not been captured, the returned address may refer to read-only memory.
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
CGDirectDisplay.h*/

void * CGDisplayBaseAddress (
   CGDirectDisplayID display
){};


/*CGDisplayBytesPerRow

Returns the number of bytes per row in a display.

size_t CGDisplayBytesPerRow (
   CGDirectDisplayID display
);
Parameters
display

The display to access.
Return Value

The number of bytes per row in the display. This number also represents the stride between pixels in the same column of the display. 
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
CGDirectDisplay.h*/

size_t CGDisplayBytesPerRow (
   CGDirectDisplayID display
){};
/*CGDisplayPixelsHigh

Returns the display height in pixel units.

size_t CGDisplayPixelsHigh (
   CGDirectDisplayID display
);
Parameters
display

The display to access.
Return Value

The display height in pixel units.
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
CGDirectDisplay.h*/

size_t CGDisplayPixelsHigh (
   CGDirectDisplayID display
){};


/*CGDisplayPixelsWide

Returns the display width in pixel units.

size_t CGDisplayPixelsWide (
   CGDirectDisplayID display
);
Parameters
display

The display to access.
Return Value

The display width in pixel units.
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
CGDirectDisplay.h*/
size_t CGDisplayPixelsWide (
   CGDirectDisplayID display
){};



/*CGDisplayShowCursor

Decrements the hide cursor count, and shows the mouse cursor if the count is zero.

CGDisplayErr CGDisplayShowCursor (
   CGDirectDisplayID display
);
Parameters
display

This parameter is not used. By default, you may pass kCGDirectMainDisplay. 
Return Value

A result code. See “Quartz Display Services Result Codes”. 
Discussion

If the hide cursor count is zero, this function shows the cursor regardless of its current location; the display parameter is ignored. In most cases, the caller must be the foreground application to affect the cursor.
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
CGDirectDisplay.h*/
CGDisplayErr CGDisplayShowCursor (
   CGDirectDisplayID display
){};

/*CGDisplayHideCursor

Hides the mouse cursor, and increments the hide cursor count.

CGDisplayErr CGDisplayHideCursor (
   CGDirectDisplayID display
);
Parameters
display

This parameter is not used. By default, you may pass kCGDirectMainDisplay. 
Return Value

A result code. See “Quartz Display Services Result Codes”. 
Discussion

This function hides the cursor regardless of its current location; the display parameter is ignored. In most cases, the caller must be the foreground application to affect the cursor.
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
CGDirectDisplay.h*/

CGDisplayErr CGDisplayHideCursor (
   CGDirectDisplayID display
){};


/*CGDisplaySwitchToMode

Switches a display to a different mode.

CGDisplayErr CGDisplaySwitchToMode (
   CGDirectDisplayID display,
   CFDictionaryRef mode
);
Parameters
display

The display to access.
mode

A display mode dictionary that contains information about the display mode to set. The dictionary passed in must be a dictionary returned by another Quartz display function such as CGDisplayAvailableModes or CGDisplayBestModeForParameters. For a list of the properties in a display mode dictionary, see “Display Mode Standard Properties” and “Display Mode Optional Properties”. For general information about using dictionaries, see CFDictionary Reference. 
Return Value

A result code. See “Quartz Display Services Result Codes”. 
Discussion

This function switches the display mode of the specified display. The operation is always synchronous; the function does not return until the mode switch is complete. Note that after switching, display parameters and addresses may change. 

The selected display mode persists for the life of the calling program. When the program terminates, the display mode automatically reverts to the permanent setting in the Displays panel of System Preferences.

When changing the display mode of a display in a mirroring set, other displays in the mirroring set will be assigned a mode that's capable of mirroring the bounds of the display being adjusted. To avoid this automatic behavior, you can use the following procedure: call CGBeginDisplayConfiguration, call CGConfigureDisplayMode for each display to explicitly set the mode, and finally call CGCompleteDisplayConfiguration.
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
CGDirectDisplay.h*/

CGDisplayErr CGDisplaySwitchToMode (
   CGDirectDisplayID display,
   CFDictionaryRef mode
){};

/*CGDisplayBestModeForParameters

Returns information about the display mode closest to a specified depth and screen size.

CFDictionaryRef CGDisplayBestModeForParameters (
   CGDirectDisplayID display,
   size_t bitsPerPixel,
   size_t width,
   size_t height,
   boolean_t * exactMatch
);
Parameters
display

The display to optimize.
bitsPerPixel

Optimal display depth in bits per pixel. Note that this value is not the same as pixel depth, which is the number of bits per channel or component. 
width

Optimal display width in pixel units.
height

Optimal display height in pixel units.
exactMatch

A pointer to a Boolean variable. On return, its value is true if an exact match in display depth, width, and height is found; otherwise, false. If this information is not needed, pass NULL.
Return Value

A display mode dictionary, or NULL if the display is invalid. The dictionary is owned by the system and you should not release it. The dictionary contains information about the display mode closest to the specified depth and screen size. For a list of the properties in a display mode dictionary, see “Display Mode Standard Properties” and “Display Mode Optional Properties”. For general information about using dictionaries, see CFDictionary Reference. 
Discussion

This function tries to find an optimal display mode for the specified display. The function first tries to find a mode with the specified pixel depth and dimensions equal to or greater than the specified width and height. If no depth match is found, it tries to find a mode with greater depth and the same or greater dimensions. If a suitable display mode is not found, this function simply returns the current display mode.
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
CGDirectDisplay.h*/

CFDictionaryRef CGDisplayBestModeForParameters (
   CGDirectDisplayID display,
   size_t bitsPerPixel,
   size_t width,
   size_t height,
   boolean_t * exactMatch
){};

/*CGDisplayCurrentMode

Returns information about the current display mode.

CFDictionaryRef CGDisplayCurrentMode (
   CGDirectDisplayID display
);
Parameters
display

The display to access.
Return Value

A display mode dictionary, or NULL if the display is invalid. The dictionary is owned by the system and you should not release it. The dictionary contains information about the current display mode. For a list of the properties in a display mode dictionary, see “Display Mode Standard Properties” and “Display Mode Optional Properties”. For general information about using dictionaries, see CFDictionary Reference. 
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
CGDirectDisplay.h*/
CFDictionaryRef CGDisplayCurrentMode (
   CGDirectDisplayID display
){};


/*CGGetActiveDisplayList

Provides a list of displays that are active (or drawable).

CGDisplayErr CGGetActiveDisplayList (
   CGDisplayCount maxDisplays,
   CGDirectDisplayID * displays,
   CGDisplayCount * displayCount
);
Parameters
maxDisplays

The size of the displays array. This value determines the maximum number of displays that can be returned.
displays

A pointer to storage provided by the caller for an array of display IDs. On return, this storage contains a list of active displays.
displayCount

A pointer to a CGDisplayCount variable provided by the caller. On return, the variable contains the actual number of displays returned in the displays array. If displays is NULL, this variable contains the total number of active displays.
Return Value

A result code. See “Quartz Display Services Result Codes”. 
Discussion

The first entry in the list of active displays is the main display. In case of mirroring, the first entry is the largest drawable display or, if all are the same size, the display with the greatest pixel depth.
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
CGDirectDisplay.h*/
CGDisplayErr CGGetActiveDisplayList (
   CGDisplayCount maxDisplays,
   CGDirectDisplayID * displays,
   CGDisplayCount * displayCount
){};

/*CGContextAddEllipseInRect

Adds an ellipse that fits inside the specified rectangle.

void CGContextAddEllipseInRect(
   CGContextRef context,
   CGRect rect
);
Parameters
context

A graphics context. 
rect

A rectangle that defines the area for the ellipse to fit in. 
Discussion

The ellipse is approximated by a sequence of Bézier curves. Its center is the midpoint of the rectangle defined by the rect parameter. If the rectangle is square, then the ellipse is circular with a radius equal to one-half the width (or height) of the rectangle. If the rect parameter specifies a rectangular shape, then the major and minor axes of the ellipse are defined by the width and height of the rectangle.
Availability
Available in Mac OS X v10.4 and later.
Declared In
CGContext.h*/

void CGContextAddEllipseInRect(
   CGContextRef context,
   CGRect rect
){};






























































