#ifndef CARBONCORE_H
#include <CarbonCore/CarbonCore.h>
#endif



int UnsignedWideToUInt64(int a){};
int SInt64ToWide(int a){};
int  FSCopyURLForVolume(int a, int b){};
int WideToSInt64(int a){};
int UnsignedFixedMulDiv(int a, int b,int c){};
int OpenDeskAcc(int a){};
int PBOpenSync(int a){};
int PBStatusSync(int a){};
int LMGetUTableBase(){};
int DebugStr (int a){};
int c2pstr(int a){};
int CloseDeskAcc(int a){};
int NGetTrapAddress(int a, int b){};


/*BlockZero


void BlockZero (
   void * destPtr,
   Size byteCount
);
Parameters
destPtr
byteCount
Special Considerations

Beginning in Mac OS X v10.4, the BlockZero function is inlined to a direct call to the POSIX bzero function. For more information, see the header file MacMemory.h.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/
void BlockZero (
   void * destPtr,
   Size byteCount){
//TODO
};


/*DisposeHandle

Releases memory occupied by a relocatable block.

void DisposeHandle (
   Handle h
);
Parameters
h

A handle to a relocatable block. 
Discussion

The DisposeHandle function releases the memory occupied by the relocatable block whose handle is h. It also frees the handles master pointer for other uses.

Do not use DisposeHandle to dispose of a handle obtained from the Resource Manager (for example, by a previous call to GetResource), use ReleaseResource instead. If, however, you have called DetachResource on a resource handle, you should dispose of the storage by calling DisposeHandle.

Call the function MemError to get the result code. See Memory Manager Result Codes.
Special Considerations

After a call to DisposeHandle, all handles to the released block become invalid and should not be used again. Any subsequent calls to DisposeHandle using an invalid handle might crash your application.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/
void DisposeHandle (
   Handle h){
//TODO
};


/*GetHandleSize

Returns the logical size of the relocatable block corresponding to a handle.

Size GetHandleSize (
   Handle h
);
Parameters
h

A handle to a relocatable block. 
Return Value

The logical size, in bytes, of the relocatable block whose handle is h. In case of error, the function return 0. 
Discussion

Call the function MemError to get the result code. See “Memory Manager Result Codes”.

You should not call GetHandleSize at interrupt time because the heap might be in an inconsistent state. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/
Size GetHandleSize (
   Handle h){
//TODO
};


/*FSCloseFork

Closes an open fork.

OSErr FSCloseFork (
   SInt16 forkRefNum
);
Parameters
forkRefNum

The reference number of the fork to close. After the call to this function, the reference number in this parameter is invalid. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The FSCloseFork function causes all data written to the fork to be written to disk, in the same manner as the FSFlushFork function, before it closes the fork. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSCloseFork (
   SInt16 forkRefNum){
//TODO
};

/*FSReadFork

Reads data from an open fork.

OSErr FSReadFork (
   SInt16 forkRefNum,
   UInt16 positionMode,
   SInt64 positionOffset,
   ByteCount requestCount,
   void * buffer,
   ByteCount * actualCount
);
Parameters
forkRefNum

The reference number of the fork to read from. You should have previously opened this fork using the FSOpenFork call, or one of the corresponding parameter block calls, PBOpenForkSync and PBOpenForkAsync. 
positionMode

A constant specifying the base location within the fork for the start of the read. See Position Mode Constants for a description of the constants which you can use to specify the base location.

The caller can also use this parameter to hint to the File Manager whether the data being read should or should not be cached. Caching reads appropriately can be important in ensuring that your program access files efficiently. 

If you add the forceReadMask constant to the value you pass in this parameter, this tells the File Manager to force the data to be read directly from the disk. This is different from adding the noCacheMask constant since forceReadMask tells the File Manager to flush the appropriate part of the cache first, then ignore any data already in the cache. However, data that is read may be placed in the cache for future reads. The forceReadMask constant is also passed to the device driver, indicating that the driver should avoid reading from any device caches.

See Cache Constants for further description of the constants that you can use to indicate your preference for caching the read.

positionOffset

The offset from the base location for the start of the read. 
requestCount

The number of bytes to read. 
buffer

A pointer to the buffer where the data will be returned. 
actualCount

On return, a pointer to the number of bytes actually read. The value pointed to by the actualCount parameter should be equal to the value in the requestCount parameter unless there was an error during the read operation.

This parameter is optional; if you don’t want this information returned, set actualCount to NULL.
Return Value

A result code. See “File Manager Result Codes”. If there are fewer than requestCount bytes from the specified position to the logical end-of-file, then all of those bytes are read, and eofErr is returned.
Discussion

FSReadFork reads data starting at the position specified by the positionMode and positionOffset parameters. The function reads up to requestCount bytes into the buffer pointed to by the buffer parameter and sets the fork’s current position to the byte immediately after the last byte read (that is, the initial position plus actualCount).

To verify that data previously written has been correctly transferred to disk, read it back in using the forceReadMask constant in the positionMode parameter and compare it with the data you previously wrote.

When reading data from a fork, it is important to pay attention to that way that your program accesses the fork, because this can have a significant performance impact. For best results, you should use an I/O size of at least 4KB and block align your read requests. On Mac OS X, you should align your requests to 4KB boundaries; on the traditional Mac OS, byte-alignments beyond 512-bytes are irrelevant, but 4KB aligned requests will perform well on current and future versions. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSReadFork (
   SInt16 forkRefNum,
   UInt16 positionMode,
   SInt64 positionOffset,
   ByteCount requestCount,
   void * buffer,
   ByteCount * actualCount){
//TODO
};

/*FSOpenFork

Opens any fork of a file or directory for streaming access.

OSErr FSOpenFork (
   const FSRef * ref,
   UniCharCount forkNameLength,
   const UniChar * forkName,
   SInt8 permissions,
   SInt16 * forkRefNum
);
Parameters
ref

A pointer to an FSRef specifying the file or directory owning the fork to open. See FSRef for a description of the FSRef data type.
forkNameLength

The length of the fork name in Unicode characters. 
forkName

A pointer to the Unicode name of the fork to open. You can obtain the string constants for the data fork and resource fork names using the FSGetDataForkName and FSGetResourceForkName functions. All volume formats should support data and resource forks; other named forks may be supported by some volume formats. 
permissions

A constant indicating the type of access which you wish to have to the fork via the returned fork reference. This parameter is the same as the permission parameter passed to the FSpOpenDF and FSpOpenRF functions. For a description of the types of access which you can request, see File Access Permission Constants. 
forkRefNum

On return, a pointer to the fork reference number for accessing the open fork. 
Return Value

A result code. See “File Manager Result Codes”. On some file systems, FSOpenFork will return the error eofErr if you try to open the resource fork of a file for which no resource fork exists with read-only access.
Discussion

When you use this function to open a file on a local volume and pass in a permissions value of fsCurPerm, fsWrPerm, or fsRdWrPerm , Mac OS X does not guarantee exclusive file access. Before making any assumptions about the underlying file access, you should always check to see whether the Supports Exclusive Locks feature is available. If this feature is not available, your application cannot know whether another application has access to the same file. For more information, see ADC Technical Note TN2037. 

To access named forks or forks larger than 2GB, you must use the FSOpenFork function or one of the corresponding parameter block calls: PBOpenForkSync and PBOpenForkAsync. To determine if the FSOpenFork function is present, call the Gestalt function. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSOpenFork (
   const FSRef * ref,
   UniCharCount forkNameLength,
   const UniChar * forkName,
   SInt8 permissions,
   SInt16 * forkRefNum){
//TODO
};

/*FSGetCatalogInfo

Returns catalog information about a file or directory. You can use this function to map an FSRef to an FSSpec.

OSErr FSGetCatalogInfo (
   const FSRef * ref,
   FSCatalogInfoBitmap whichInfo,
   FSCatalogInfo * catalogInfo,
   HFSUniStr255 * outName,
   FSSpec * fsSpec,
   FSRef * parentRef
);
Parameters
ref

A pointer to an FSRef specifying the file or directory for which to retrieve information. See FSRef for a description of the FSRef data type. 
whichInfo

A bitmap specifying the catalog information fields to return. If you don’t want any catalog information, set whichInfo to the constant kFSCatInfoNone. See Catalog Information Bitmap Constants for a description of the bits in this parameter.
catalogInfo

On return, a pointer to a catalog information structure containing the information about the file or directory. Only the information specified in the whichInfo parameter is returned. If you don’t want any catalog information, pass NULL here. See FSCatalogInfo for a description of the FSCatalogInfo data type.
outName

On return, a pointer to the Unicode name of the file or directory is returned here. This parameter is optional; if you do not wish the name returned, pass NULL here. See HFSUniStr255 for a description of the HFSUniStr255 data type.
fsSpec

On return, a pointer to the FSSpec for the file or directory. This parameter is optional; if you do not wish the FSSpec returned, pass NULL here. See FSSpec for a description of the FSSpec data type.
parentRef

On return, a pointer to the FSRef for the object's parent directory. This parameter is optional; if you do not wish the parent directory returned, pass NULL here.

If the object specified in the ref parameter is a volume’s root directory, then the FSRef returned here will not be a valid FSRef, since the root directory has no parent object.
Return Value

A result code. See “File Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSGetCatalogInfo (
   const FSRef * ref,
   FSCatalogInfoBitmap whichInfo,
   FSCatalogInfo * catalogInfo,
   HFSUniStr255 * outName,
   FSSpec * fsSpec,
   FSRef * parentRef){
//TODO
};


/*NewHandle

Allocates a new relocatable memory block of a specified size in the current heap zone.

Handle NewHandle (
   Size byteCount
);
Parameters
byteCount

The requested size, in bytes, of the relocatable block. Maximum size is 2 GB, the maximum size for variables of type Size.
Return Value

A handle to the new block. If NewHandle cannot allocate a block of the requested size, it returns NULL. 
Discussion

The NewHandle function pursues all available avenues to create a block of the requested size, including compacting the heap zone, increasing its size, and purging blocks from it. If all of these techniques fail and the heap zone has a grow-zone function installed, NewHandle calls the function. Then NewHandle tries again to free the necessary amount of memory, once more compacting and purging the heap zone if necessary. If NewHandle still cannot allocate memory, NewHandle calls the grow-zone function again, unless that function had returned 0, in which case NewHandle gives up and returns NULL.

If the NewHandle function succeeds in creating the requested block, this new block is unlocked and unpurgeable.

If you allocate a relocatable block that you plan to lock for long periods of time, you can prevent heap fragmentation by allocating the block as low as possible in the heap zone. To do this, see the description of the function ReserveMem.

If you plan to lock a relocatable block for short periods of time, you might want to move it to the top of the heap zone to prevent heap fragmentation. For more information, see the description of the function MoveHHi.

Call the function MemError to get the result code. See “Memory Manager Result Codes”.

Because NewHandle allocates memory, you should not call it at interrupt time.

Do not try to manufacture your own handles without this function by simply assigning the address of a variable of type Ptr to a variable of type Handle. The resulting “fake handle” would not reference a relocatable block and could cause a system crash. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/
Handle NewHandle (
   Size byteCount){
//TODO
};

/*FSOpenResFile

Opens a resource file using a file system reference (FSRef).

short FSOpenResFile (
   const FSRef * ref,
   SInt8 permission
);
Availability
Available in CarbonLib 1.1 and later when running Mac OS 9.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/
short FSOpenResFile (
   const FSRef * ref,
   SInt8 permission){
//TODO
};

/*CloseResFile

Closes a resource fork before your application terminates.

void CloseResFile (
   short refNum
);
Parameters
refNum

The file reference number for the resource fork to close. If this parameter does not contain a file reference number for a file whose resource fork is open, the function does nothing, and the ResError function returns the result code resFNotFound. If the value of this parameter is 0, it represents the System file and is ignored. You cannot close the System file’s resource fork. 
Discussion

This function performs four tasks. First, it updates the file by calling the UpdateResFile function. Second, it releases the memory occupied by each resource in the resource fork by calling the DisposeHandle function. Third, it releases the memory occupied by the resource map. The fourth task is to close the resource fork.

When your application terminates, the Resource Manager automatically closes every resource fork open to your application except the System file’s resource fork. You need to call this function only if you want to close a resource fork before your application terminates.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/
void CloseResFile (
   short refNum){
//TODO
};

/*Get1IndResource

Returns a handle to a resource of a given type in the current resource file.

Handle Get1IndResource (
   ResType theType,
   short index
);
Parameters
theType

A resource type.
index

An integer ranging from 1 to the number of resources of a given type returned by the Count1Resources function, which is the number of resources of that type in the current resource file.
Return Value

A handle to a resource of the given type. If you call Get1IndResource repeatedly over the entire range of the index, it returns handles to all resources of the given type in the current resource file. If you provide an index that is either 0 or negative, the function returns NULL, and the ResError function returns the result code resNotFound. If the given index is larger than the value returned by Count1Resources, Get1IndResource returns NULL, and ResError returns the result code resNotFound. If the resource to be read won’t fit into memory, the function returns NULL, and ResError returns the appropriate result code.
Discussion

The function reads the resource data into memory if it’s not already there, unless you’ve called the SetResLoad function with the load parameter set to FALSE. If you’ve called SetResLoad with the load parameter set to FALSE and the data isn’t already in memory, Get1IndResource returns an empty handle (that is, a handle whose master pointer is set to NULL). This can also happen if you read resource data for a purgeable resource into memory and then call SetResLoad with the load parameter set to FALSE. If the resource data is later purged and you call the Get1IndResource function, the function returns an empty handle. You should test for an empty handle in these situations. To make the handle a valid handle to resource data in memory, you can call the MacLoadResource function.
Special Considerations

This function may move or purge memory blocks in the application heap. Your application should not call this function at interrupt time.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/
Handle Get1IndResource (
   ResType theType,
   short index){
//TODO
};

/*DetachResource

Sets the value of a resource’s handle in the resource map in memory to NULL while keeping the resource data in memory.

void DetachResource (
   Handle theResource
);
Parameters
theResource

A handle to the resource which you wish to detach. If this parameter doesn’t contain a handle to a resource or if the resource’s resChanged attribute is set, the function does nothing. To determine whether either of these errors occurred, call the ResError function. 
Discussion

After this call, the Resource Manager no longer recognizes the handle as a handle to a resource. However, this function does not release the memory used for the resource data, and the master pointer is still valid. Thus, you can access the resource data directly by using the handle.

If your application subsequently calls a Resource Manager function to get the released resource, the Resource Manager assigns a new handle.You can use DetachResource if you want to access the resource data directly without using Resource Manager functions. You can also use the DetachResource function to keep resource data in memory after closing a resource fork.

To copy a resource and install an entry for the duplicate in the resource map, call DetachResource, then call the AddResource function using a different resource ID. 
Special Considerations

Do not use this function to detach a System resource that might be shared by several applications.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/
void DetachResource (
   Handle theResource){
//TODO
};


/*CloseComponent

Terminates your applications connection to a component. 

OSErr CloseComponent (
   ComponentInstance aComponentInstance
);
Parameters
aComponentInstance

The connection you wish to close. Your application obtains the component instance from the OpenComponent function or the OpenDefaultComponent function. You can use a component identifier here, but you must coerce the data type appropriately. 
Return Value

A result code. See Component Manager Result Codes.
Discussion

This function closes only a single connection. If your application has several connections to a single component, you must call it once for each connection. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/


OSErr CloseComponent (
   ComponentInstance aComponentInstance){
//TODO
};


/*OpenDefaultComponent

Opens a connection to a registered component of the component type and subtype specified by your application. 

ComponentInstance OpenDefaultComponent (
   OSType componentType,
   OSType componentSubType
);
Parameters
componentType

The type of the component. All components of a particular type support a common set of interface functions. Use this parameter to search for components of a given type. 
componentSubType

The subtype of the component. Different subtypes of a component type may support additional features or provide interfaces that extend beyond the standard functions for a given component type. For example, the subtype of an image compressor component indicates the compression algorithm employed by the compressor.

Your application can use the componentSubType parameter to perform a more specific lookup operation than is possible using only the componentType parameter. For example, you may want your application to use only components of a certain component type ('draw') that also have a specific subtype ('oval'). Set this parameter to 0 to select a component with any subtype value.
Return Value

A component instance that identifies the connection opened to the component which matches your search criteria. You must supply this component instance whenever you call the functions provided by the component. When you close the component, you must also supply this component instance to the CloseComponent function.

If more than one component in the list of registered components meets the search criteria, the function opens the first one that it finds in its list. If it cannot open the specified component, it returns NULL.

See the description of the ComponentInstance data type.
Discussion

Your application must open a component before it can call any component functions. This function searches for a component by type and subtype. You do not have to supply a component description structure or call the FindNextComponent function to use this function. If you want to exert more control over the selection process, you can use the FindNextComponent and OpenComponent functions. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/
ComponentInstance OpenDefaultComponent (
   OSType componentType,
   OSType componentSubType){
//TODO
};


/*Gestalt

Obtains information about the operating environment.

OSErr Gestalt (
   OSType selector,
   long * response
);
Parameters
selector

The selector code for the information you need. You can provide any of the four-character sequences defined in Gestalt Manager Constants.
response

On input, Gestalt interprets this parameter as an address at which it is to place the result returned by the selector function. Gestalt ignores any information already at this address. 

On return, a pointer to the requested information whose format depends on the selector code specified in the selector parameter. Note that the Gestalt function returns the response from all selectors in a long word, which occupies 4 bytes. When not all 4 bytes are needed, the significant information appears in the low-order byte or bytes.
Return Value

A result code. See Gestalt Manager Result Codes.
Discussion

The Apple-defined selector codes fall into two categories: environmental selectors, which supply specific environmental information you can use to control the behavior of your application, and informational selectors, which cant supply information you can use to determine what hardware or software features are available. You can use one of the selector codes defined by Apple or a selector code defined by a third-party product.

Selectors with the suffix Attr return a 32-bit response value in which the individual bits represent specific attributes. The constants listed for these response values represent bit numbers. 
Special Considerations

When passed one of the Apple-defined selector codes, the Gestalt function does not move or purge memory and therefore may be called even at interrupt time. However, selector functions associated with non-Apple selector codes might move or purge memory, and third-party software can alter the Apple-defined selector functions. Therefore, it is safest always to assume that Gestalt could move or purge memory.
Version Notes

The ROMVersion and machineType selectors are not supported in Carbon.

In general, the Gestalt function returns a different result when called from a Carbon application running in Mac OS X than it returns when called from a Classic application in Mac OS X, because these are different environments. For example, Carbon does not use a ROM, so calling Gestalt from a Carbon application on a beige G3 Macintosh computer and passing the ROMVersion selector returns a different result than Gestalt returns for a Classic application on the same computer.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Gestalt.h*/
OSErr Gestalt (
   OSType selector,
   long * response){
//TODO
};

/*FSOpenIterator

Creates a catalog iterator that can be used to iterate over the contents of a directory or volume.

OSErr FSOpenIterator (
   const FSRef * container,
   FSIteratorFlags iteratorFlags,
   FSIterator * iterator
);
Parameters
container

A pointer to an FSRef for the directory to iterate. The set of items to iterate over can either be the objects directly contained in the directory, or all items directly or indirectly contained in the directory (in which case, the specified directory is the root of the subtree to iterate). See FSRef for a description of the FSRef data type.
iteratorFlags

A set of flags which controls whether the iterator iterates over subtrees or just the immediate children of the container. See Iterator Flags for a description of the flags defined for this parameter.

Iteration over subtrees which do not originate at the root directory of a volume are not currently supported, and passing the kFSIterateSubtree flag in this parameter returns errFSBadIteratorFlags. To determine whether subtree iterators are supported, check that the bSupportsSubtreeIterators bit returned by PBHGetVolParmsSync or PBHGetVolParmsAsync is set.
iterator

On return, a pointer to the new FSIterator. You can pass this iterator to the FSGetCatalogInfoBulk or FSCatalogSearch functions and their parameter block-based counterparts.

The iterator is automatically initialized so that the next use of the iterator returns the first item. The order that items are returned in is volume format dependent and may be different for two different iterators created with the same container and flags.

See FSIterator for a description of the FSIterator data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

Catalog iterators must be closed when you are done using them, whether or not you have iterated over all the items. Iterators are automatically closed upon process termination, just like open files. However, you should use the FSCloseIterator function, or one of the related parameter block functions, PBCloseIteratorSync and PBCloseIteratorAsync , to close an iterator to free up any system resources allocated to the iterator.

Before calling this function, you should check that it is present, by calling the Gestalt function. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSOpenIterator (
   const FSRef * container,
   FSIteratorFlags iteratorFlags,
   FSIterator * iterator){
//TODO
};

/*FSGetCatalogInfoBulk

Returns information about one or more objects from a catalog iterator. This function can return information about multiple objects in a single call.

OSErr FSGetCatalogInfoBulk (
   FSIterator iterator,
   ItemCount maximumObjects,
   ItemCount * actualObjects,
   Boolean * containerChanged,
   FSCatalogInfoBitmap whichInfo,
   FSCatalogInfo * catalogInfos,
   FSRef * refs,
   FSSpec * specs,
   HFSUniStr255 * names
);
Parameters
iterator

The iterator to use. You can obtain a catalog iterator with the function FSOpenIterator, or with one of the related parameter block calls, PBOpenIteratorSync and PBOpenIteratorAsync. Currently, the iterator must be created with the kFSIterateFlat option. See FSIterator for a description of the FSIterator data type.
maximumObjects

The maximum number of items to return for this call. 
actualObjects

On return, a pointer to the actual number of items found for this call.
containerChanged

On return, a pointer to a value indicating whether or not the container’s contents have changed since the previous FSGetCatalogInfoBulk call. If true, the contents have changed. Objects may still be returned, even though the container has changed. If so, note that if the container has changed, then the total set of items returned may be incorrect: some items may be returned multiple times, and some items may not be returned at all.

This parameter is optional if you don’t want this information returned, pass a NULL pointer. 

On versions of Mac OS X prior to 10.2, this parameter is unset. On Mac OS X version 10.2, this parameter is always set to false. To find out whether the container has changed since the last call to FSGetCatalogInfoBulk, check the modification date of the container.
whichInfo

A bitmap specifying the catalog information fields to return for each item. If you don’t wish any catalog information returned, pass the constant kFSCatInfoNone in this parameter. For a description of the bits in this parameter, see Catalog Information Bitmap Constants.
catalogInfos

A pointer to an array of catalog information structures; one for each returned item. On input, the catalogInfos parameter should point to an array of maximumObjects catalog information structures.

This parameter is optional; if you do not wish any catalog information returned, pass NULL here.

refs

A pointer to an array of FSRef structures; one for each returned item. On input, this parameter should to point to an array of maximumObjectsFSRef structures. 

This parameter is optional; if you do not wish any FSRef structures returned, pass NULL here.
specs

A pointer to an array of FSSpec structures; one for each returned item. On input, this parameter should to point to an array of maximumObjectsFSSpec structures. 

This parameter is optional; if you do not wish any FSSpec structures returned, pass NULL here.
names

A pointer to an array of names; one for each returned item. If you want the Unicode name for each item found, set this parameter to point to an array of maximumObjectsHFSUniStr255 structures. Otherwise, set it to NULL. 
Return Value

A result code. See “File Manager Result Codes”. When all of the iterator’s objects have been returned, the call will return errFSNoMoreItems.
Discussion

The FSGetCatalogInfoBulk call may complete and return noErr with fewer than maximumObjects items returned. This may be due to various reasons related to the internal implementation. In this case, you may continue to make FSGetCatalogInfoBulk calls using the same iterator.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSGetCatalogInfoBulk (
   FSIterator iterator,
   ItemCount maximumObjects,
   ItemCount * actualObjects,
   Boolean * containerChanged,
   FSCatalogInfoBitmap whichInfo,
   FSCatalogInfo * catalogInfos,
   FSRef * refs,
   FSSpec * specs,
   HFSUniStr255 * names){
//TODO
};

/*FSMakeFSRefUnicode

Constructs an FSRef for a file or directory, given a parent directory and a Unicode name. 

OSErr FSMakeFSRefUnicode (
   const FSRef * parentRef,
   UniCharCount nameLength,
   const UniChar * name,
   TextEncoding textEncodingHint,
   FSRef * newRef
);
Parameters
parentRef

A pointer to the FSRef of the parent directory of the file or directory for which to create a new FSRef. See FSRef for a description of the FSRef data type.
nameLength

The length of the file or directory name. 
name

A pointer to the Unicode name for the file or directory. The name must be a leaf name; partial or full pathnames are not allowed. If you have a partial or full pathname in Unicode, you will have to parse it yourself and make multiple calls to FSMakeFSRefUnicode. 
textEncodingHint

The suggested text encoding to use when converting the Unicode name of the file or directory to some other encoding. If you pass the constant kTextEncodingUnknown, the File Manager will use a default value. 
newRef

On return, if the function returns a result of noErr, a pointer to the new FSRef.
Return Value

A result code. See “File Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSMakeFSRefUnicode (
   const FSRef * parentRef,
   UniCharCount nameLength,
   const UniChar * name,
   TextEncoding textEncodingHint,
   FSRef * newRef){
//TODO
};

/*FSCloseIterator

Closes a catalog iterator. 

OSErr FSCloseIterator (
   FSIterator iterator
);
Parameters
iterator

The catalog iterator to be closed. FSCloseIterator releases memory and other system resources used by the iterator, making the iterator invalid. See FSIterator for a description of the FSIterator data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

This function releases memory and other system resources used by the iterator. The iterator becomes invalid. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSCloseIterator (
   FSIterator iterator){
//TODO
};

/*GetDateTime

Obtains the current date-time information, expressed as the number of seconds elapsed since midnight, January 1, 1904. (Deprecated in Mac OS X v10.4. Use CFAbsoluteTimeGetCurrent instead.)

void GetDateTime (
   unsigned long * secs
);
Parameters
secs

On return, the number of seconds elapsed since midnight, January 1, 1904. 
Discussion

The low-memory copy of the date and time information is also accessible through the global variable Time.

If an application disables interrupts for longer than a second, the date-time information returned by the GetDateTime function might not be exact. The GetDateTime function is intended to provide fairly accurate time information, but not scientifically precise data. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
DateTimeUtils.h*/
void GetDateTime (
   unsigned long * secs){
//TODO
};

/*SecondsToDate

Converts a number of seconds elapsed since midnight, January 1, 1904 to a date and time. (Deprecated in Mac OS X v10.4. Use the CFCalendarRef data type and the functions that operate on it instead.)

void SecondsToDate (
   unsigned long secs,
   DateTimeRec * d
);
Parameters
secs

The number of seconds elapsed since midnight, January 1, 1904. 
d

On return, the fields of the date-time structure that contain the date and time corresponding to the value indicated in the s parameter. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
DateTimeUtils.h*/
void SecondsToDate (
   unsigned long secs,
   DateTimeRec * d){
//TODO
};


/*OpenADefaultComponent


OSErr OpenADefaultComponent (
   OSType componentType,
   OSType componentSubType,
   ComponentInstance * ci
);
Parameters
componentType
componentSubType
ci
Return Value

A result code. See “Component Manager Result Codes”.
Availability
Available in CarbonLib 1.0 and later when QuickTime 2.5 or later is present. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/
OSErr OpenADefaultComponent (
   OSType componentType,
   OSType componentSubType,
   ComponentInstance * ci){
//TODO
};

/*FSPathMakeRef

Converts a path into an FSRef structure.

OSStatus FSPathMakeRef (
   const UInt8 * path,
   FSRef * ref,
   Boolean * isDirectory
);
Parameters
path

The path for which to return an FSRef. This path can be used by POSIX-style calls. 
ref

On return, a pointer to the FSRef. 
isDirectory

A Boolean value indicating whether the object at specified by the given path is a directory. This parameter is optional and can be NULL. 
Return Value

A result code. See “File Manager Result Codes”.
Special Considerations

This function, though available through Carbon on Mac OS 8 and 9, is only implemented on Mac OS X.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/

OSStatus FSPathMakeRef (
   const UInt8 * path,
   FSRef * ref,
   Boolean * isDirectory){
//TODO
};

/*FSGetVolumeInfo

Returns information about a volume.

OSErr FSGetVolumeInfo (
   FSVolumeRefNum volume,
   ItemCount volumeIndex,
   FSVolumeRefNum * actualVolume,
   FSVolumeInfoBitmap whichInfo,
   FSVolumeInfo * info,
   HFSUniStr255 * volumeName,
   FSRef * rootDirectory
);
Parameters
volume

If you wish to obtain information on a particular volume, pass that volume’s reference number here. If you wish to index through the list of mounted volumes, pass the constant kFSInvalidVolumeRefNum in this parameter. See FSVolumeRefNum for a description of the FSVolumeRefNum data type.
volumeIndex

The index of the desired volume, or 0 to use the volume reference number in the volume parameter. 
actualVolume

On return, a pointer to the volume reference number of the volume. This is useful when indexing over all mounted volumes. If you don’t want this information (if, for instance, you supplied a particular volume reference number in the volume) parameter, set actualVolume to NULL.
whichInfo

A bitmap specifying which volume information fields to get and return in the info parameter. If you don’t want information about the volume returned in the info parameter, set whichInfo to kFSVolInfoNone. See Volume Information Bitmap Constants for a description of the bits in this parameter.
info

On return, a pointer to the volume information. If you don’t want this output, set this parameter to NULL. See FSVolumeInfo for a description of the FSVolumeInfo data type.
volumeName

On return, a pointer to the Unicode name of the volume. If you do not wish the name returned, pass NULL. See HFSUniStr255 for a description of the HFSUniStr255 data type.
rootDirectory

On return, a pointer to the FSRef for the volume’s root directory. If you do not wish the root directory returned, pass NULL. See FSRef for a description of the FSRef data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

You can specify a particular volume or index through the list of mounted volumes. To get information on a particular volume, pass the volume reference number of the desired volume in the volume parameter and set the volumeIndex parameter to zero. To index through the list of mounted volumes, pass kFSInvalidVolumeRefNum in the volume parameter and set volumeIndex to the index, starting at 1 with the first call to FSGetVolumeInfo.

When indexing through the list of mounted volumes, you may encounter an error with a particular volume. The terminating error code for full traversal of this list is nsvErr. In order to completely traverse the entire list, you may have to bump the index count when encountering other errors (for example, ioErr).

To get information about the root directory of a volume, use the FSGetCatalogInfo function, or one of the corresponding parameter block calls, PBGetCatalogInfoSync and PBGetCatalogInfoAsync. 
Special Considerations

After an operation that changes the amount of free space on the volume—such as deleting a file—there may be a delay before a call to FSGetVolumeInfo returns the updated amount. This is because the File Manager caches and periodically updates file system information, to reduce the number of calls made to retrieve the information from the file system. Currently, the File Manager updates its information every 15 seconds. This primarily affects NFS volumes. DOS, SMB, UFS and WebDAV volumes were also affected by this in previous versions of Mac OS X, but behave correctly in Mac OS X version 10.3 and later.
Availability
Available in Mac OS X v10.0 and later.*/
OSErr FSGetVolumeInfo (
   FSVolumeRefNum volume,
   ItemCount volumeIndex,
   FSVolumeRefNum * actualVolume,
   FSVolumeInfoBitmap whichInfo,
   FSVolumeInfo * info,
   HFSUniStr255 * volumeName,
   FSRef * rootDirectory){
//TODO
};


/*PBHGetVolParmsSync

Returns information about the characteristics of a volume.

OSErr PBHGetVolParmsSync (
   HParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the HIOParam variant of the basic HFS parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to the volume’s name. You can use a either a name or a volume specification to specify the volume. If you use a volume specification to specify the volume, you should set the ioNamePtr field to NULL. 
ioVRefNum 

On input, a volume specification. You can use a either a name or a volume specification to specify the volume. A volume specification can be a volume reference number, drive number, or 0 for the default volume. 
ioBuffer 

On input, a pointer to a GetVolParmsInfoBuffer record; you must allocate this memory to hold the returned attributes. On return, the PBHGetVolParmsSync function places the attributes information in the bufferVolumes that implement the HFS Plus APIs must use version 3 (or newer) of the GetVolParmsInfoBuffer structure. If the version of the GetVolParmsInfoBuffer is 2 or less, or the bSupportsHFSPlusAPIs bit is clear, then the volume does not implement the HFS Plus APIs and they are being emulated for that volume by the File Manager. 
ioReqCount 

On input, the size, in bytes, of the buffer area pointed to in the ioBuffer field. 
ioActCount 

On output, the size of the data actually returned. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr PBHGetVolParmsSync (
   HParmBlkPtr paramBlock){
//TODO
};

/*OpenComponent

Opens a connection to the component with the component identifier specified by your application.

ComponentInstance OpenComponent (
   Component aComponent
);
Parameters
aComponent

The component you wish to open. Your application obtains this identifier from the FindNextComponent function. If your application registers a component, it can also obtain a component identifier from the RegisterComponent function or the RegisterComponentResource function. 
Return Value

A component instance which identifies your application’s connection to the component. You must supply this component instance whenever you call the functions provided by the component. When you close the component, you must also supply this component instance to the CloseComponent function.

If it cannot open the specified component, the function returns NULL.

See the description of the ComponentInstance data type.
Discussion

Your application must open a component before it can call any component functions. To use this function, you must already have obtained a component identifier. Alternatively, you can use the OpenDefaultComponent function to open a component without calling FindNextComponent. 

Note that your application may maintain several connections to a single component, or it may have connections to several components at the same time. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/

ComponentInstance OpenComponent (
   Component aComponent){
//TODO
};


/*FindNextComponent

Returns the component identifier for the next registered component that meets the selection criteria specified by your application. 

Component FindNextComponent (
   Component aComponent,
   ComponentDescription * looking
);
Parameters
aComponent

The starting point for the search. Set this field to 0 to start the search at the beginning of the component list. If you are continuing a search, you can specify a component identifier previously returned by this function. The function then searches the remaining components. 
looking

A pointer to a ComponentDescription structure. Your application specifies the criteria for the component search in the fields of this structure.

The Component Manager ignores fields in the component description structure that are set to 0. For example, if you set all the fields to 0, all components meet the search criteria. In this case, your application can retrieve information about all of the components that are registered in the system by repeatedly calling FindNextComponent and GetComponentInfo until the search is complete. Similarly, if you set all fields to 0 except for the componentManufacturer field, the Component Manager searches all registered components for a component supplied by the manufacturer you specify. Note that this function does not modify the contents of the component description structure you supply. To retrieve detailed information about a component, you need to use the GetComponentInfo function to get the component description structure for each returned component.

Return Value

The component identifier of a component that meets the search criteria or 0 when there are no more matching components. Your application can use the component identifier returned by this function to get more information about the component, using GetComponentInfo, or to open the component, using either the OpenDefaultComponent function or the OpenComponent function. See the description of the Component data type.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/
Component FindNextComponent (
   Component aComponent,
   ComponentDescription * looking){
//TODO
};
/*GetComponentInfo

Returns to your application the registration information for a component. 

OSErr GetComponentInfo (
   Component aComponent,
   ComponentDescription * cd,
   Handle componentName,
   Handle componentInfo,
   Handle componentIcon
);
Parameters
aComponent

The component about which you wish to obtain information. Your application obtains a component identifier from the FindNextComponent function. If your application registers a component, it can also obtain a component identifier from the RegisterComponent or RegisterComponentResource function.

You may supply a component instance rather than a component identifier to this function, but you must coerce the data type appropriately. Your application can obtain a component instance from the OpenComponent or OpenDefaultComponent functions.

cd

A pointer to a ComponentDescription structure. The function returns information about the specified component in this structure. 
componentName

On return, a handle to the component’s name. If the component does not have a name, an empty handle. Set this field to NULL if you do not want to receive the component’s name. 
componentInfo

On return, a handle to the component’s information string. If the component does not have an information string, an empty handle. Set this field to NULL if you do not want to receive the component’s information string.
componentIcon

On return, a handle to the component’s icon. If the component does not have an icon, an empty handle. Set this field to NULL if you do not want to receive the component’s icon. To get a handle to the component’s icon suite, if it provides one, use the GetComponentIconSuite function.
Return Value

A result code. See “Component Manager Result Codes”.
Discussion

For information on registering components, see “Registering Components”. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/
OSErr GetComponentInfo (
   Component aComponent,
   ComponentDescription * cd,
   Handle componentName,
   Handle componentInfo,
   Handle componentIcon){
//TODO
};


/*FSMakeFSSpec

Creates an FSSpec structure describing a file or directory. (Deprecated in Mac OS X v10.4. Use FSMakeFSRefUnicode instead.)

OSErr FSMakeFSSpec (
   short vRefNum,
   long dirID,
   ConstStr255Param fileName,
   FSSpec * spec
);
Parameters
vRefNum

A volume specification for the volume containing the file or directory. This parameter can contain a volume reference number, a drive number, or 0 to specify the default volume. 
dirID

The parent directory ID of the target object. If the directory is sufficiently specified in the fileName parameter, the dirID parameter can be set to 0. If the fileName parameter contains an empty string, FSMakeFSSpec creates an FSSpec structure for the directory specified by the dirID parameter. 
fileName

A full or partial pathname. If the fileName parameter specifies a full pathname, FSMakeFSSpec ignores both the vRefNum and dirID parameters. A partial pathname might identify only the final target, or it might include one or more parent directory names. If fileName specifies a partial pathname, then vRefNum, dirID, or both must be valid. 
spec

A pointer to a file system specification to be filled in by FSMakeFSSpec. The FSMakeFSSpec function fills in the fields of the file system specification using the information contained in the other three parameters. If your application receives any result code other than noErr or fnfErr, all fields of the resulting FSSpec structure are set to 0. 

The file system specification structure that you pass in this parameter should not share storage space with the input pathname; the name field may be initialized to the empty string before the pathname has been processed. For example, fileName should not refer to the name field of the output file system specification.

Return Value

A result code. See “File Manager Result Codes”.
Discussion

You should call FSMakeFSSpec, or one of the corresponding parameter block functions, PBMakeFSSpecSync and PBMakeFSSpecAsync , whenever you want to create an FSSpec structure. You should not create an FSSpec by filling in the fields of the structure yourself.

If the specified volume is mounted and the specified parent directory exists, but the target file or directory doesn’t exist in that location, FSMakeFSSpec fills in the structure and then returns fnfErr instead of noErr. The structure is valid, but it describes a target that doesn’t exist. You can use the structure for other operations, such as creating a file with the FSpCreate function. 
Carbon Porting Notes

Non-Carbon applications can also specify a working directory reference number in the vRefNum parameter. However, because working directories are not supported in Carbon, you cannot specify a working directory reference number if you wish your application to be Carbon-compatible.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr FSMakeFSSpec (
   short vRefNum,
   long dirID,
   ConstStr255Param fileName,
   FSSpec * spec){
//TODO
};

/*BlockMove

Copies a sequence of bytes from one location in memory to another.

void BlockMove (
   const void * srcPtr,
   void * destPtr,
   Size byteCount
);
Parameters
srcPtr

The address of the first byte to copy. 
destPtr

The destination address.
byteCount

The number of bytes to copy. If the value of byteCount is 0, BlockMove does nothing. 
Discussion

The BlockMove function copies the specified number of bytes from the address designated by srcPtr to that designated by destPtr. It updates no pointers.

The BlockMove function works correctly even if the source and destination blocks overlap.

You can safely call BlockMove at interrupt time. Even though it moves memory, BlockMove does not move relocatable blocks, but simply copies bytes.

Call the function MemError to get the result code. See “Memory Manager Result Codes”.

The BlockMove function currently flushes the processor caches whenever it moves more than 12 bytes. This behavior can adversely affect your application’s performance. You might want to avoid calling BlockMove to move small amounts of data in memory if there is no possibility of moving stale data or instructions. For more information about stale data and instructions, see the discussion of the processor caches in the chapter “Memory Management Utilities” in Inside Macintosh: Memory. 
Special Considerations

Beginning in Mac OS X v10.4, the BlockMove function is inlined to a direct call to the POSIX memmove function. For more information, see the header file MacMemory.h.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/
void BlockMove (
   const void * srcPtr,
   void * destPtr,
   Size byteCount){
//TODO
};


/*BlockMoveData


void BlockMoveData (
   const void * srcPtr,
   void * destPtr,
   Size byteCount
);
Parameters
srcPtr
destPtr
byteCount
Discussion

You should not make any assumptions about the state of the destination memory while BlockMoveData is executing. In the intermediate state, values may be present that are neither the original nor the final ones. For example, this function may use the 'dcbz' instruction. If the underlying memory is not cacheable, if the memory is write-through instead of copy-back, or if the cache block is flushed for some reason, the 'dcbz' instruction will write zeros to the destination. You can avoid the use of the 'dcbz' instruction by calling BlockMoveDataUncached, but even that function makes no other guarantees about the memory block's intermediate state. 
Special Considerations

Beginning in Mac OS X v10.4, the BlockMoveData function is inlined to a direct call to the POSIX memmove function. For more information, see the header file MacMemory.h.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/
void BlockMoveData (
   const void * srcPtr,
   void * destPtr,
   Size byteCount){
//TODO
};


/*PBGetCatInfoSync

Returns catalog information about a file or directory. (Deprecated in Mac OS X v10.4. Use PBGetCatalogInfoSync instead.)

OSErr PBGetCatInfoSync (
   CInfoPBPtr paramBlock
);
Parameters
paramBlock

A pointer to an HFS catalog information parameter block. See CInfoPBRec for a description of the CInfoPBRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The PBGetCatInfoSync function returns information about a file or directory, depending on the values you specify in the ioFDirIndex, ioNamePtr, ioVRefNum, and ioDirID or ioDrDirID fields. If you need to determine whether the information returned is for a file or a directory, you can test bit 4 of the ioFlAttrib field; if that bit is set, the information returned describes a directory.

The PBGetCatInfoSync function selects a file or directory according to these rules:
If the value of ioFDirIndex is positive, ioNamePtr is not used as an input parameter and PBGetCatInfoSync returns information about the file or directory whose directory index is ioFDirIndex in the directory specified by ioDirID (or ioDrDirID) on the volume specified by ioVRefNum (this will be the root directory if ioVRefNum is a volume reference number or a drive number and ioDirID is 0). If ioNamePtr is not NULL, then it must point to a Str31 buffer where the file or directory name will be returned. 
If the value of ioFDirIndex is 0, PBGetCatInfoSync returns information about the file or directory specified by ioNamePtr in the directory specified by ioDirID (or ioDrDirID) on the volume specified by ioVRefNum (again, this will be the root directory if ioVRefNum is a volume reference number or a drive number and ioDirID is 0). 
If the value of ioFDirIndex is negative, PBGetCatInfoSync ignores the ioNamePtr field and returns information about the directory specified in the ioDrDirID field. If ioNamePtr is not NULL, then it must point to a Str31 buffer where the directory name will be returned. 

With files, PBGetCatInfoSync is similar to PBHGetFInfoSync but returns some additional information. If the object is a file, the relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to a pathname. On output, the name of the file is returned in this field, if the file is open. If you do not want the name of the file returned, pass NULL in this field. 
ioVRefNum 

On input, a volume reference number, drive number, or 0 for the default volume. 
ioFRefNum 

On output, a file reference number. If the file is open, the reference number of the first access path found is returned here. 
ioFDirIndex 

On input, a directory index. 
ioFlAttrib 

On output, the file attributes. See File Attribute Constants for the meaning of the file attributes. 
ioFlFndrInfo 

On output, information used by the Finder. 
ioDirID 

On input, a directory ID. On output, the file ID. You might need to save the value of ioDirID before calling PBGetCatInfoSync if you make subsequent calls with the same parameter block. 
ioFlStBlk 

On output, the first allocation block of the data fork. 
ioFlLgLen 

On output, the logical size (the logical end-of-file) of the data fork, in bytes. 
ioFlPyLen 

On output, the physical size (the physical end-of-file) of the data fork, in bytes. 
ioFlRStBlk 

On output, the first allocation block of the resource fork. 
ioFlRLgLen 

On output, the logical size of the resource fork, in bytes. 
ioFlRPyLen 

On output, the physical size of the resource fork, in bytes. 
ioFlCrDat 

On output, the date and time of the file’s creation. Note that file systems other than AFP, HFS and HFS Plus do not generally support creation dates. For file systems which do not support creation dates, the File Manager sets the ioFlCrDat field to 0. 
ioFlMdDat 

On output, the date and time of the file’s last modification. 
ioFlBkDat 

On output, the date and time of the file’s last backup. Note that file systems other than AFP, HFS and HFS Plus do not generally support backup dates. For file systems which do not support backup dates, the File Manager sets the ioFlBkDat field to 0. 
ioFlXFndrInfo 

On output, additional information used by the Finder. 
ioFlParID 

On output, the directory ID of the file’s parent directory. 
ioFlClpSiz 

On output, the file’s clump size. 

You can also use PBGetCatInfoSync to determine whether a file has a file ID reference. The value of the file ID is returned in the ioDirID field. Because that parameter could also represent a directory ID, call PBResolveFileIDRefSync to see if the value is a real file ID. If you want to determine whether a file ID reference exists for a file and create one if it doesn’t, use PBCreateFileIDRefSync , which will either create a file ID or return fidExists.

If the object is a directory, the relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to a pathname. On output, a pointer to the directory’s name. 
ioVRefNum 

On input, a volume reference number, drive number, or 0 for the default volume. 
ioFDirIndex 

On input, a directory index. 
ioFlAttrib 

On output, the directory attributes. See File Attribute Constants for the meaning of the bits in this field.The bits in this field for directories are read-only. You cannot alter directory attributes by setting these bits using the functions PBSetCatInfoSync or PBSetCatInfoAsync. Instead, you can call the PBHSetFLockSync and PBHRstFLockSync functions to lock and unlock a directory, and the PBShareSync and PBUnshareSync functions to enable and disable file sharing on local directories. 
ioACUser 

On output, the directory access rights. The PBGetCatInfoSync function returns the information in this field only for shared volumes. As a result, you should set this field to 0 before calling PBGetCatInfoSync. PBGetCatInfoSync does not return the blank access privileges bit in this field; to determine whether a directory has blank access privileges, use the PBHGetDirAccessSync function. See User Privileges Constants for a description of the constants that may be returned here. 
ioDrUsrWds 

On output, information used by the Finder. 
ioDrDirID 

On input, if you wish to obtain information about a specific directory, that directory’s ID. Otherwise, if the object returned is a directory, this field contains the directory ID on output. 
ioDrNmFls 

On output, the number of files in the directory. 
ioDrCrDat 

On output, the date and time of the directory’s creation. Note that file systems other than AFP, HFS and HFS Plus do not generally support creation dates. For file systems which do not support creation dates, the File Manager sets the ioDrCrDat field to 0.
ioDrMdDat 

On output, the date and time of the directory’s last modification. 
ioDrBkDat 

On output, the date and time of the directory’s last backup. Note that file systems other than AFP, HFS and HFS Plus do not generally support backup dates. For file systems which do not support backup dates, the File Manager sets the ioDrBkDat field to 0.
ioDrFndrInfo 

On output, additional information used by the Finder. 
ioDrParID 

On output, the directory ID of the directory’s parent directory. 

To get information on a file or directory with named forks, or on a file larger than 2GB, use one of the FSGetCatalogInfo , PBGetCatalogInfoSync , or PBGetCatalogInfoAsync functions. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBGetCatInfoSync (
   CInfoPBPtr paramBlock){
//TODO
};


/*Munger

Searches text for a specified string pattern and replaces it with another string.

long Munger (
   Handle h,
   long offset,
   const void * ptr1,
   long len1,
   const void * ptr2,
   long len2
);
Parameters
h

A handle to the text string that is being manipulated. 
offset

The byte offset in the destination string at which Munger begins its operation. 
ptr1

A pointer to the first character in the string for which Munger is searching. 
len1

The number of bytes in the string for which Munger is searching.
ptr2

A pointer to the first character in the substitution string.
len2

The number of bytes in the substitution string.
Return Value

A negative value if Munger cannot find the designated string. 
Discussion

Munger manipulates bytes in a string to which you specify a handle in the h parameter. The manipulation begins at a byte offset, specified in offset, in the string. Munger searches for the string specified by ptr1 and len1; when it finds an instance of that string, it replaces it with the substitution string, which is specified by ptr2 and len2.

Munger operates on a byte-by-byte basis, which can produce inappropriate results for 2-byte script systems. The ReplaceText function works properly for all languages. You are encouraged to use ReplaceText instead of Munger whenever possible.

Munger takes special action if either of the specified pointer values is NULL or if either of the length values is 0.
If ptr1 is NULL, Munger replaces characters without searching. It replaces len1 characters starting at the offset location with the substitution string. 
If ptr1 is NULL and len1 is negative, Munger replaces all of the characters from the offset location to the end of the string with the substitution string. 
If len1 is 0, Munger inserts the substitution string without replacing anything. Munger inserts the string at the offset location and returns the offset of the first byte past where the insertion occurred. 
If ptr2 is NULL, Munger searches but does not replace. In this case, Munger returns the offset at which the string was found. 
If len2 is 0 and ptr2 is not NULL, Munger searches and deletes. In this case, Munger returns the offset at which it deleted. 
If the portion of the string from the offset location to its end matches the beginning of the string that Munger is searching for, Munger replaces that portion with the substitution string. 

Be careful not to specify an offset with a value that is greater than the length of the destination string. Unpredictable results may occur.

Munger calls the GetHandleSize and SetHandleSize functions to access or modify the length of the string it is manipulating. 
Special Considerations

Munger may move memory; your application should not call this function at interrupt time.

The destination string must be in a relocatable block that was allocated by the Memory Manager.
Availability
Available in Mac OS X v10.0 and later.
Declared In
TextUtils.h*/
long Munger (
   Handle h,
   long offset,
   const void * ptr1,
   long len1,
   const void * ptr2,
   long len2){
//TODO
};


/*MemError

Determines if an application’s last direct call to a Memory Manager function executed successfully.

OSErr MemError (void);
Return Value

A result code. See “Memory Manager Result Codes”.
Discussion

For each thread, MemError yields the result code produced by the last Memory Manager function your application called directly.

MemError is useful during application debugging. You might also use MemError as one part of a memory-management scheme to identify instances in which the Memory Manager rejects overly large memory requests by returning the error code memFullErr.

To view the result codes that MemError can produce, see “Memory Manager Result Codes”.

Do not rely on MemError as the only component of a memory-management scheme. For example, suppose you call NewHandle or NewPtr and receive the result code noErr, indicating that the Memory Manager was able to allocate sufficient memory. In this case, you have no guarantee that the allocation did not deplete your application’s memory reserves to levels so low that simple operations might cause your application to crash. Instead of relying on MemError, check before making a memory request that there is enough memory both to fulfill the request and to support essential operations. 
Version Notes

Starting with Mac OS X v10.3, the MemError function provides error codes on a per-thread basis.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/
OSErr MemError (void){
//TODO
};


/*NewAliasMinimalFromFullPath

Creates an alias record that contains only the full pathname of the target. (Deprecated in Mac OS X v10.4. Use FSNewAliasMinimal or FSNewAliasMinimalUnicode instead.)

Not recommended

OSErr NewAliasMinimalFromFullPath (
   short fullPathLength,
   const void * fullPath,
   ConstStr32Param zoneName,
   ConstStr31Param serverName,
   AliasHandle * alias
);
Parameters
fullPathLength

The number of characters in the full pathname of the target.
fullPath

A pointer to a buffer that contains the full pathname of the target. The full pathname starts with the name of the volume, includes all of the directory names in the path to the target, and ends with the target name. (For a description of pathnames, see the documentation for the File Manager.)
zoneName

The AppleTalk zone name of the AppleShare volume on which the target resides. Set this parameter to a null string if you do not need it.
serverName

The AppleTalk server name of the AppleShare volume on which the target resides. Set this parameter to a null string if you do not need it.
alias

A pointer to an alias handle. On return, this handle refers to the newly created alias record. If the function fails to create an alias record, it sets alias to NULL.
Return Value

A result code. For more information, see the Carbon Result Code Index. 
Discussion

The NewAliasMinimalFromFullPath function creates an alias record that identifies the target by full pathname. You can call NewAliasMinimalFromFullPath to create an alias record for a file that doesn’t exist or that resides on an unmounted volume.

The NewAliasMinimalFromFullPath function uses the standard alias record data structure, but it fills in only the information provided in the input parameters. You can therefore use NewAliasMinimalFromFullPath to create alias records for targets on unmounted volumes. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X version 10.0 and later but deprecated in Mac OS X v10.4.
Deprecated in Mac OS X v10.4.
Carbon Porting Notes

Use FSNewAliasMinimal or FSNewAliasMinimalUnicode instead.
Declared In
Aliases.h*/
OSErr NewAliasMinimalFromFullPath (
   short fullPathLength,
   const void * fullPath,
   ConstStr32Param zoneName,
   ConstStr31Param serverName,
   AliasHandle * alias){
//TODO
};

/*ResolveAlias

Identifies the single most likely target of an alias record. (Deprecated in Mac OS X v10.4. Use FSResolveAlias instead.)

Not recommended

OSErr ResolveAlias (
   const FSSpec * fromFile,
   AliasHandle alias,
   FSSpec * target,
   Boolean * wasChanged
);
Parameters
fromFile

A pointer to the starting point for a relative search. If you pass a fromFile parameter of NULL, ResolveAlias performs only an absolute search. If you pass a pointer to a valid FSSpec structure in the fromFile parameter, ResolveAlias performs a relative search for the target, followed by an absolute search only if the relative search fails. If you want to perform an absolute search followed by a relative search, you must use the MatchAlias function.
alias

A handle to the alias record to be resolved and, if necessary, updated.
target

A pointer to the target of the alias record. This parameter must be a valid FSSpec structure.
wasChanged

A pointer to a Boolean value indicating whether the alias record to be resolved was updated because it contained some outdated information about the target. If it updates the alias record, ResolveAlias sets the wasChanged parameter to true. Otherwise, it sets it to false. (ResolveAlias never updates a minimal alias, so it never sets wasChanged to true when resolving a minimal alias.
Return Value

A result code. For more information, see the Carbon Result Code Index. 
Discussion

The ResolveAlias function performs a fast search for the target of the alias. If the resolution is successful, ResolveAlias returns (in the target parameter) the FSSpec structure for the target file system object, updates the alias record if necessary, and reports (through the wasChanged parameter) whether the record was updated. If the target is on an unmounted AppleShare volume, ResolveAlias automatically mounts the volume. If the target is on an unmounted ejectable volume, ResolveAlias asks the user to insert the volume. The ResolveAlias function exits after it finds one acceptable target.

After it identifies a target, ResolveAlias compares some key information about the target with the information in the alias record. (The description of the MatchAlias function lists the key information.) If the information differs, ResolveAlias updates the record to match the target.

When it finds the specified volume and parent directory but fails to find the target file or directory in that location, ResolveAlias returns a result code of fnfErr and fills in the target parameter with a complete FSSpec structure describing the target (that is, the volume reference number, parent directory ID, and filename or folder name). The FSSpec structure is valid, although the object it describes does not exist. This information is intended as a "hint" that lets you explore possible solutions to the resolution failure. You can, for example, pass the FSSpec structure to the File Manager function FSpCreate to create a replacement for a missing file.

The ResolveAlias function displays the standard dialog boxes when it needs input from the user, such as a name and password for mounting a remote volume. The user can cancel the resolution through these dialog boxes. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X version 10.0 and later but deprecated in Mac OS X v10.4.
Deprecated in Mac OS X v10.4.
Carbon Porting Notes

Use FSResolveAlias instead.
Declared In
Aliases.h*/
OSErr ResolveAlias (
   const FSSpec * fromFile,
   AliasHandle alias,
   FSSpec * target,
   Boolean * wasChanged){
//TODO
};



/*NewHandleClear

Allocates a relocatable block of memory of a specified size with all its bytes set to 0.

Handle NewHandleClear (
   Size byteCount
);
Parameters
byteCount

The requested size (in bytes) of the relocatable block. The NewHandleClear function sets each of these bytes to 0. 
Return Value

A handle to the new block. If NewHandleClear cannot allocate a block of the requested size, it returns NULL. 
Discussion

The NewHandleClear function works like the NewHandle function, but sets all bytes in the new block to 0 instead of leaving the contents of the block undefined.

Call the function MemError to get the result code. See “Memory Manager Result Codes”.

Because NewHandleClear allocates memory, you should not call it at interrupt time. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/
Handle NewHandleClear (
   Size byteCount){
//TODO
};


/*PtrToHand

Copies data referenced by a pointer to a new relocatable block.

OSErr PtrToHand (
   const void * srcPtr,
   Handle * dstHndl,
   long size
);
Parameters
srcPtr

The address of the first byte to copy. 
dstHndl

A handle for which you have not yet allocated any memory. The PtrToHand function allocates memory for the handle and copies the specified number of bytes beginning at srcPtr into it. The dstHndl parameter is an output parameter that will hold the result. Its value on entry is ignored. If no error occurs, on exit it points to an unlocked, non-purgeable Handle of the requested size. 
size

The number of bytes to copy. 
Return Value

A result code. See “Memory Manager Result Codes”.
Discussion

If you dereference and lock a handle, the PtrToHand function can copy its data to a new handle. However, for copying data from one handle to another, the HandToHand function is more efficient.

Because PtrToHand allocates memory, you should not call it at interrupt time. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/
OSErr PtrToHand (
   const void * srcPtr,
   Handle * dstHndl,
   long size){
//TODO
};


/*MPCreateSemaphore

Creates a semaphore.

OSStatus MPCreateSemaphore (
   MPSemaphoreCount maximumValue,
   MPSemaphoreCount initialValue,
   MPSemaphoreID * semaphore
);
Parameters
maximumValue

The maximum allowed value of the semaphore. 
initialValue

The initial value of the semaphore.
semaphore

On return, semaphore contains the ID of the newly–created semaphore. 
Return Value

A result code. See "Multiprocessing Services Result Codes".
Discussion

If you want to create a binary semaphore, you can call the macro MPCreateBinarySemaphore (MPSemaphoreID *semaphore) instead, which simply calls MPCreateSemaphore with both maximumValue and initialValue set to 1.

Also see the function MPDeleteSemaphore. 
Version Notes

Introduced with Multiprocessing Services 1.0. 
Availability
Available in CarbonLib 1.0 and later when MultiprocessingLib 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Multiprocessing.h*/
OSStatus MPCreateSemaphore (
   MPSemaphoreCount maximumValue,
   MPSemaphoreCount initialValue,
   MPSemaphoreID * semaphore){
//TODO
};


/*Byte Operations

The Driver Services Library provides several 32-, 16-, and 8-bit atomic memory operations for use by device drivers. These routines take logical address pointers and ensure that the operations are atomic with respect to all devices (for example, other processors and DMA engines) that participate in the coherency architecture of the Power Macintosh system.

IMPORTANT

Memory locations used by these operations must be long word aligned; if they are stored in a structure, you should use the compiler directive #pragma options align=power. 
Boolean
CompareAndSwap (long oldValue, long newValue, long *Value); 

SInt32      IncrementAtomic     (SInt32 *value);
SInt32      DecrementAtomic     (SInt32 *value); 

SInt32      AddAtomic           (SInt32 amount,         SInt32 *value); 

UInt32      BitAndAtomic        (UInt32 mask,           UInt32 *value);
UInt32      BitOrAtomic         (UInt32 mask,           UInt32 *value);
UInt32      BitXorAtomic        (UInt32 mask,           UInt32 *value); 

SInt16      IncrementAtomic16   (SInt16 *value);
SInt16      DecrementAtomic16   (SInt16 *value);
SInt16      AddAtomic16         (SInt32 amount,         SInt16 *value);
UInt16      BitAndAtomic16      (UInt32 mask,           UInt16 *value);
UInt16      BitOrAtomic16       (UInt32 mask,           UInt16 *value);
UInt16      BitXorAtomic16      (UInt32 mask,           UInt16 *value); 

SInt8       IncrementAtomic8    (SInt8 *value);
SInt8       DecrementAtomic8    (SInt8 *value);
SInt8       AddAtomic8          (SInt32 amount,         SInt8 *value);
UInt8       BitAndAtomic8       (UInt32 mask,           UInt8 *value);
UInt8       BitOrAtomic8        (UInt32 mask,           UInt8 *value);
UInt8       BitXorAtomic8       (UInt32 mask,           UInt8 *value); 
DESCRIPTION

The atomic routines perform various operations on the memory address specified by value : 
The CompareAndSwap routine compares the value at the specified address with oldValue. The value of newValue is written to the specified address only if oldValue and the value at the specified address are equal. CompareAndSwap returns true if newValue is written to the specified address; otherwise, it returns false. A false return value does not imply that oldValue and the value at the specified address are not equal; it only implies that CompareAndSwap did not write newValue to the specified address.
IncrementAtomic increments the value by 1 and DecrementAtomic decrements it by 1. These functions return the value as it was before the change.
AddAtomic adds the specified amount to the value at the specified address and returns the result. 
BitAndAtomic performs a logical and operation between the bits of the specified mask and the value at the specified address, returning the result. Similarly, BitOrAtomic performs a logical OR operation and BitXorAtomic performs a logical XOR operation.
EXECUTION CONTEXT

The atomic operation routines may be called from task level, secondary interrupt level, or hardware interrupt level.*/
Boolean CompareAndSwap (long oldValue, long newValue, long *Value){};

SInt32      IncrementAtomic     (SInt32 *value){};
SInt32      DecrementAtomic     (SInt32 *value){}; 

SInt32      AddAtomic           (SInt32 amount,         SInt32 *value){};

UInt32      BitAndAtomic        (UInt32 mask,           UInt32 *value){};
UInt32      BitOrAtomic         (UInt32 mask,           UInt32 *value){};
UInt32      BitXorAtomic        (UInt32 mask,           UInt32 *value){};
SInt16      IncrementAtomic16   (SInt16 *value){};
SInt16      DecrementAtomic16   (SInt16 *value){};
SInt16      AddAtomic16         (SInt32 amount,         SInt16 *value){};
UInt16      BitAndAtomic16      (UInt32 mask,           UInt16 *value){};
UInt16      BitOrAtomic16       (UInt32 mask,           UInt16 *value){};
UInt16      BitXorAtomic16      (UInt32 mask,           UInt16 *value){};
SInt8       IncrementAtomic8    (SInt8 *value){};
SInt8       DecrementAtomic8    (SInt8 *value){};
SInt8       AddAtomic8          (SInt32 amount,         SInt8 *value){};
UInt8       BitAndAtomic8       (UInt32 mask,           UInt8 *value){};
UInt8       BitOrAtomic8        (UInt32 mask,           UInt8 *value){};
UInt8       BitXorAtomic8       (UInt32 mask,           UInt8 *value){};


/*MPSignalSemaphore

Signals a semaphore. 

OSStatus MPSignalSemaphore (
   MPSemaphoreID semaphore
);
Parameters
semaphore

The ID of the semaphore you want to signal. 
Return Value

A result code. See "Multiprocessing Services Result Codes". If the value of the semaphore was already at the maximum, MPSignalSemaphore returns kInsufficientResourcesErr.
Discussion

If tasks are waiting on the semaphore, the oldest (first queued) task is unblocked so that the corresponding MPWaitOnSemaphore call for that task completes. Otherwise, if the value of the semaphore is not already equal to its maximum value, it is incremented by one.

Note that you can call this function from an interrupt handler. 
Version Notes

Introduced with Multiprocessing Services 1.0. 
Availability
Available in CarbonLib 1.0 and later when MultiprocessingLib 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Multiprocessing.h*/
OSStatus MPSignalSemaphore (
   MPSemaphoreID semaphore){
//TODO
};


/*Dequeue

Removes a queue element directly from an operating-system queue or from a queue that you have created.

OSErr Dequeue (
   QElemPtr qElement,
   QHdrPtr qHeader
);
Parameters
qElement

A pointer to a queue element to remove from a queue. 
qHeader

A pointer to a queue header. 
Return Value

A result code. See “Memory Management Utilities Result Codes”.
Discussion

The Dequeue function attempts to find the queue element specified by the qElement parameter in the queue specified by the qHeader parameter. If Dequeue finds the element, it removes the element from the queue, adjusts the other elements in the queue accordingly, and returns noErr. Otherwise, it returns qErr, indicating that it could not find the element in the queue. The Dequeue function does not deallocate the memory occupied by the queue element.

For a description of the QElem record, see QElem; for a description of the QHdr record, see QHdr.

The Dequeue function disables interrupts as it searches through the queue for the element to be removed. The time during which interrupts are disabled depends on the length of the queue and the position of the entry in the queue. The Dequeue function can be called at interrupt time. However, the Dequeue function is ordinarily used only by system software and, whenever possible, you should manipulate an operating-system queue indirectly, by calling special-purpose removal functions. You can use the Queue Utilities functions for directly manipulating queues that you create. Use the following functions instead of Dequeue:
SlotVRemove

Removes a slot-based VBL task. This function is available with the Vertical Retrace Manager.
VRemove

Removes a system-based VBL task. This function is available with the Vertical Retrace Manager.
WaitNextEvent

Removes an Event. This function is available with the Event manager.
SIntRemove

Removes a slot interrupt task. This function is available with the Slot Manager.
NMRemove

Removes a Notification request. This function is available with the Notification Manager.
SleepQRemove

Removes a Sleep task. This function is available with the Power Manager.
Availability
Available in Mac OS X v10.0 and later.
Declared In
OSUtils.h*/
OSErr Dequeue (
   QElemPtr qElement,
   QHdrPtr qHeader){
//TODO
};


/*Enqueue

Adds elements directly to an operating-system queue or a queue that you create.

void Enqueue (
   QElemPtr qElement,
   QHdrPtr qHeader
);
Parameters
qElement

A pointer to the queue element to add to a queue. 
qHeader

A pointer to a queue header. 
Discussion

The Enqueue function adds the queue element specified by the qElement parameter to the end of the queue specified by the qHeader parameter. The specified queue header is updated to reflect the new queue element.

For a description of the QElem record, see QElem; for a description of the QHdr record, see QHdr.

Because interrupt functions are likely to manipulate operating-system queues, interrupts are disabled for a short time while the specified queue is updated. You can call the Enqueue function at interrupt time. However, the Enqueue function is ordinarily used only by system software. Whenever possible, you should manipulate an operating-system queue indirectly, by calling special-purpose functions whenever possible, instead of the Enqueue function. You can use the Queue Utilities functions for directly manipulating queues that you create. Use the following functions instead of Enqueue:
SlotVInstall

Installs a slot-based VBL task. This function is available with the Vertical Retrace Manager.
VInstall

Installs a system-based VBL task. This function is available with the Vertical Retrace Manager.
AddDrive

Adds a disk drive. This function is available with the Device Manager.
PPostEvent and PostEvent

Installs an Event. This function is available with the Event manager.
DTInstall

Installs a deferred task. This function is available with the Memory Management Utilities.
SIntInstall

Installs a slot interrupt task. This function is available with the Slot Manager.
NMInstall

Installs a Notification request. This function is available with the Notification Manager.
SleepQInstall

Installs a Sleep task. This function is available with the Power Manager.
Availability
Available in Mac OS X v10.0 and later.
Declared In
OSUtils.h*/
void Enqueue (
   QElemPtr qElement,
   QHdrPtr qHeader){
//TODO
};


/*Bit Operations
Boolean TestAndSet(
                     UInt32 bit
                     UInt8 *startAddress); Boolean TestAndClear(
                     UInt32 bit
                     UInt8 *startAddress); 
--> bit 
The bit number in the range 0 through 7.
--> startAddress 
The address of the byte in which the bit is located.
DESCRIPTION

TestAndSet sets and TestAndClear clears a single bit in a byte at a specified address. They return true if the bit was already set or cleared respectively and false otherwise.
EXECUTION CONTEXT

TestAndSet and TestAndClear may be called from task level, secondary interrupt level, or hardware interrupt level.*/
Boolean TestAndSet(
                     UInt32 bit,
                     UInt8 *startAddress){}; 
Boolean TestAndClear(
                     UInt32 bit,
                     UInt8 *startAddress){}; 
/*MPWaitOnSemaphore

Waits on a semaphore

OSStatus MPWaitOnSemaphore (
   MPSemaphoreID semaphore,
   Duration timeout
);
Parameters
semaphore

The ID of the semaphore you want to wait on. 
timeout

The maximum time the function should wait before timing out. See Timer Duration Constants for a list of constants you can use to specify the wait interval. 
Return Value

A result code. See "Multiprocessing Services Result Codes".
Discussion

If the value of the semaphore is greater than zero, the value is decremented and the function returns with noErr. Otherwise, the task is blocked awaiting a signal until the specified timeout is exceeded.

If you call this function from a cooperative task, you should specify only kDurationImmediate for the timeout length; other waits will cause the task to block. 

Also see the function MPSignalSemaphore. 
Version Notes

Introduced with Multiprocessing Services 1.0. 
Availability
Available in CarbonLib 1.0 and later when MultiprocessingLib 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Multiprocessing.h*/
OSStatus MPWaitOnSemaphore (
   MPSemaphoreID semaphore,
   Duration timeout){
//TODO
};


/*MPDeleteSemaphore

Removes a semaphore. 

OSStatus MPDeleteSemaphore (
   MPSemaphoreID semaphore
);
Parameters
semaphore

The ID of the semaphore you want to remove. 
Return Value

A result code. See "Multiprocessing Services Result Codes".
Discussion

Calling this function unblocks all tasks waiting on the semaphore and the tasks’ respective MPWaitOnSemaphore calls will return with the result code kMPDeletedErr.

Also see the function MPCreateSemaphore. 
Version Notes

Introduced with Multiprocessing Services 1.0. 
Availability
Available in CarbonLib 1.0 and later when MultiprocessingLib 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Multiprocessing.h*/

OSStatus MPDeleteSemaphore (
   MPSemaphoreID semaphore){
//TODO
};

/*Microseconds

Determines the number of microseconds that have elapsed since system startup time.

void Microseconds (
   UnsignedWide * microTickCount
);
Parameters
microTickCount

The number of microseconds elapsed since system startup.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Timer.h*/
void Microseconds (
   UnsignedWide * microTickCount){
//TODO
};

int CSSetComponentsThreadMode(int a){
//TODO
};


/*FSpOpenDF

Opens the data fork of a file. (Deprecated in Mac OS X v10.4. Use FSOpenFork instead.)

OSErr FSpOpenDF (
   const FSSpec * spec,
   SInt8 permission,
   short * refNum
);
Parameters
spec

A pointer to an FSSpec structure specifying the file whose data fork is to be opened. See FSSpec for a description of the FSSpec data type.
permission

A constant indicating the type of access with which to open the file’s data fork. In most cases, you can simply set the permission parameter to fsCurPerm. Some applications request fsRdWrPerm, to ensure that they can both read from and write to a file. For a description of the types of access that you can request, see File Access Permission Constants. 
refNum

On return, a pointer to the file reference number for accessing the open data fork. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

Before calling this function, you should call the Gestalt function to check that the function is available. If FSpOpenDF is not available, you can use the function HOpenDF instead.

Note that if you wish to access named forks other than the data and resource forks, or forks larger than 2GB, you will need to use the FSOpenFork function, or one of its corresponding parameter block calls, PBOpenForkSync and PBOpenForkAsync. If you try to open a fork larger than 2GB with the FSpOpenDF function, you will receive an error message. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr FSpOpenDF (
   const FSSpec * spec,
   SInt8 permission,
   short * refNum){
//TODO
};

/*GetEOF

Determines the current logical size of an open file. (Deprecated in Mac OS X v10.4. Use FSGetForkSize instead.)

OSErr GetEOF (
   short refNum,
   long * logEOF
);
Parameters
refNum

The file reference number of an open file. 
logEOF

On return, a pointer to the logical size (the logical end-of-file) of the given file. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

To determine the size of a named fork other than the data or resource forks, or of a fork larger than 2 GB, use the FSGetForkSize function, or one of the corresponding parameter block functions, PBGetForkSizeSync and PBGetForkSizeAsync. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr GetEOF (
   short refNum,
   long * logEOF){
//TODO
};

/*FSRead

Reads any number of bytes from an open file. (Deprecated in Mac OS X v10.4. Use FSReadFork instead.)

OSErr FSRead (
   short refNum,
   long * count,
   void * buffPtr
);
Parameters
refNum

The file reference number of the open file from which to read. 
count

On input, a pointer to the number of bytes to read; on output, a pointer to the number of bytes actually read. 
buffPtr

A pointer to the data buffer into which the data will be read. This buffer is allocated by your application and must be at least as large as the count parameter. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

Because the read operation begins at the current mark, you might want to set the mark first by calling the SetFPos function. If you try to read past the logical end-of-file, FSRead reads in all the data up to the end-of-file, moves the mark to the end-of-file, and returns eofErr as its function result. Otherwise, FSRead moves the file mark to the byte following the last byte read and returns noErr.

The low-level functions PBReadSync and PBReadAsync let you set the mark without having to call SetFPos. Furthermore, if you want to read data in newline mode, you must use PBReadSync or PBReadAsync instead of FSRead. For a description of the PBReadSync and PBReadAsync functions, see the Device Manager Reference .

If you wish to read from named forks other than the data or resource forks, or from files larger than 2GB, you must use the FSReadFork function, or one of its corresponding parameter block calls, PBReadForkSync and PBReadForkAsync. If you attempt to use FSRead to read from a file larger than 2GB, you will receive an error message. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr FSRead (
   short refNum,
   long * count,
   void * buffPtr){
//TODO
};

/*FSClose

Closes an open file. (Deprecated in Mac OS X v10.4. Use FSCloseFork instead.)

OSErr FSClose (
   short refNum
);
Parameters
refNum

The file reference number of the open file. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The FSClose function removes the access path for the specified file and writes the contents of the volume buffer to the volume.

The FSClose function calls the PBFlushFileSync function internally to write the file’s bytes onto the volume. To ensure that the file’s catalog entry is updated, you should call FlushVol after you call FSClose. 
Special Considerations

Make sure that you do not call FSClose with a file reference number of a file that has already been closed. Attempting to close the same file twice may result in loss of data on a volume.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr FSClose (
   short refNum){
//TODO
};

/*PtrAndHand

Concatenates part or all of a memory block to the end of a relocatable block.

OSErr PtrAndHand (
   const void * ptr1,
   Handle hand2,
   long size
);
Parameters
ptr1

A pointer to the beginning of the data that the Memory Manager is to concatenate onto the end of the relocatable block. 
hand2

A handle to the relocatable block, whose size the Memory Manager expands so that it can concatenate the information from ptr1 onto the end of this block. 
size

The number of bytes of the block referenced by ptr1 to copy. 
Return Value

A result code. See “Memory Manager Result Codes”.
Discussion

The PtrAndHand function takes the number of bytes specified by the size parameter, beginning at the location specified by ptr1, and concatenates them onto the end of the relocatable block to which hand2 is a handle. The contents of the source block remain unchanged.

Because PtrAndHand allocates memory, you should not call it at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/
OSErr PtrAndHand (
   const void * ptr1,
   Handle hand2,
   long size){
//TODO
};

/*HLock

Prevents a relocatable block from moving within its heap zone.

void HLock (
   Handle h
);
Parameters
h

A handle to a relocatable block. 
Discussion

If you plan to dereference a handle and then allocate, move, or purge memory (or call a function that does so), then you should lock the handle before using the dereferenced handle.

If the block is already locked, HLock does nothing.

If you plan to lock a relocatable block for long periods of time, you can prevent fragmentation by ensuring that the block is as low as possible in the heap zone. To do this, see the description of the ReserveMem function.

If you plan to lock a relocatable block for short periods of time, you can prevent heap fragmentation by moving the block to the top of the heap zone before locking. For more information, see the description of the MoveHHi function.

Call the function MemError to get the result code. See “Memory Manager Result Codes”. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/
void HLock (Handle h){
//TODO
};

/*OpenAComponent


OSErr OpenAComponent (
   Component aComponent,
   ComponentInstance * ci
);
Parameters
aComponent
ci
Return Value

A result code. See “Component Manager Result Codes”.
Availability
Available in CarbonLib 1.0 and later when QuickTime 2.5 or later is present. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/
OSErr OpenAComponent (
   Component aComponent,
   ComponentInstance * ci){
//TODO
};

/*NumToString

Converts a long integer value into a Pascal string. (Deprecated in Mac OS X v10.4. Use CFStringCreateWithFormat instead.)

void NumToString (
   long theNum,
   Str255 theString
);
Parameters
theNum

A long integer value. If the value of the number in the parameter theNum is negative, the string begins with a minus sign; otherwise, the sign is omitted. 
theString

On output, contains the Pascal string representation of the number. Leading zeros are suppressed, except that a value of 0 produces the string “0”. NumToString does not include thousand separators or decimal points in its formatted output. 
Discussion

NumToString creates a string representation of theNum as a base-10 value and returns the result in theString.

Unless patched by a script system with different rules, this function assumes that you are using standard numeric token processing, meaning that the Roman script system number processing rules are used.

For functions that make use of the token-processing information that is found in the tokens ('itl4') resource of script systems for converting numbers, see the sections “Using Number Format Specification Strings for International Number Formatting” and “Converting Between Strings and Floating-Point Numbers”. 
Special Considerations

NumToString may move memory; your application should not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
NumberFormatting.h*/
void NumToString (
   long theNum,
   Str255 theString){
//TODO
};


/*FSFindFolder

Obtains location information for system-related directories.

OSErr FSFindFolder (
   short vRefNum,
   OSType folderType,
   Boolean createFolder,
   FSRef * foundRef
);
Parameters
vRefNum

Pass the volume reference number of the volume on which you want to locate a directory, or a constant specifying a disk or domain. The constants which you can use in this parameter are described in Disk and Domain Constants.

Note that, on Mac OS X, passing a volume reference number in this parameter does not make sense for most of the folder type selectors which you can specify in the folderType parameter. On Mac OS X, folders are "domain-oriented"; because there may be more than one domain on any given physical volume, asking for these folders on a per-volume basis yields undefined results. For example, if you were to request the Fonts folder (represented by the selector kFontsFolderType)on volume -100, are you requesting the folder /System/Library/Fonts, /Library/Fonts, or ~/Fonts? On Mac OS X you should pass a disk or domain constant in this parameter.
folderType

Pass a four-character folder type, or a constant that represents the type, for the folder you want to find; see Folder Type Constants.
createFolder

A value of type Boolean, as defined in Create Folder Flags. Pass the constant kCreateFolder to create a directory if it does not already exist; otherwise, pass the constant kDontCreateFolder. Passing kCreateFolder will not create a parent folder; if the parent of the target folder does not already exist, attempting to create the target will fail.
foundRef

A pointer to a file system reference. On return, the FSRef refers to the directory specified by the vRefNum and folderType parameters.
Return Value

A result code. See "Folder Manager Result Codes".
Availability
Available in Mac OS X v10.0 and later.
Declared In
Folders.h*/
OSErr FSFindFolder (
   short vRefNum,
   OSType folderType,
   Boolean createFolder,
   FSRef * foundRef){
//TODO
};

/*X2Fix

Converts an Extended number to a Fixed number.

Fixed X2Fix (
   double x
);
Parameters
x

The Extended number to be converted to a Fixed number. 
Return Value

The best Fixed approximation of the Extended number x. If x is greater than the maximum representable Fixed number, the X2Fix function returns $7FFFFFFF. If x is less than the negative number with the highest absolute value, X2Fix returns $80000000. 
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
FixMath.h*/
Fixed X2Fix (
   double x){
//TODO
};

/*FSRefMakePath

Converts an FSRef into a path.

OSStatus FSRefMakePath (
   const FSRef * ref,
   UInt8 * path,
   UInt32 maxPathSize
);
Parameters
ref

The FSRef to convert into a path. 
path

On return, a pointer to the path. This path can be used by POSIX-style calls. 
pathSize

The size of the path. 
Return Value

A result code. See “File Manager Result Codes”.
Special Considerations

This function, though available through Carbon on Mac OS 8 and 9, is only implemented on Mac OS X.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSStatus FSRefMakePath (
   const FSRef * ref,
   UInt8 * path,
   UInt32 maxPathSize){
//TODO
};

/*FSGetDataForkName

Returns a Unicode string constant for the name of the data fork.

OSErr FSGetDataForkName (
   HFSUniStr255 * dataForkName
);
Parameters
dataForkName

On input, a pointer to an HFSUniStr255 structure. On return, this structure contains the Unicode name of the data fork. Currently, this is the empty string. See HFSUniStr255 for a description of the HFSUniStr255 data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

There is no parameter block-based form of this call since it is not dispatched to individual volume formats, and does not require any I/O. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSGetDataForkName (
   HFSUniStr255 * dataForkName){
//TODO
};


/*FSGetForkSize

Returns the size of an open fork. 

OSErr FSGetForkSize (
   SInt16 forkRefNum,
   SInt64 * forkSize
);
Parameters
forkRefNum

The reference number of the open fork. You can obtain this fork reference number with the FSOpenFork function, or one of the corresponding parameter block calls, PBOpenForkSync and PBOpenForkAsync. 
forkSize

On return, a pointer to the logical size (the logical end-of-file) of the fork, in bytes. The size returned is the total number of bytes that can be read from the fork; the amount of space actually allocated on the volume (the physical size) will probably be larger. 
Return Value

A result code. See “File Manager Result Codes”.
Special Considerations

To determine whether the FSGetForkSize function is present, call the Gestalt function. If FSGetForkSize is present, but is not directly supported by a volume, the File Manager will call PBGetEOFSync; however, you will not be able to determine the size of a fork other than the data or resource fork, or of a fork larger than 2 GB. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSGetForkSize (
   SInt16 forkRefNum,
   SInt64 * forkSize){
//TODO
};

/*FSEjectVolumeSync

Ejects a volume.

OSStatus FSEjectVolumeSync (
   FSVolumeRefNum vRefNum,
   OptionBits flags,
   pid_t * dissenter
);
Parameters
vRefNum

The volume reference number of the volume to eject. 
flags

Options for future use.
dissenter

On return, a pointer to the pid of the process which denied the unmount if the eject is denied.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

This function ejects the volume specified by the vRefNum parameter. If the volume cannot be ejected the pid of the process which denied the unmount will be returned in the dissenter parameter. This function returns after the eject is complete. Ejecting a volume will result in the unmounting of other volumes on the same device.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Files.h*/
OSStatus FSEjectVolumeSync (
   FSVolumeRefNum vRefNum,
   OptionBits flags,
   pid_t * dissenter){
//TODO
};

/*PBMakeFSRefSync

Creates an FSRef for a file or directory, given an FSSpec.

OSErr PBMakeFSRefSync (
   FSRefParam * paramBlock
);
Parameters
paramBlock

A pointer to a file system reference parameter block. See FSRefParam for a description of the FSRefParam data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

For the parameter block based calls, the fields of the source FSSpec are passed as separate parameters (in the ioNamePtr, ioVRefNum, and ioDirID fields). This allows the call to be dispatched to external file systems the same way as other FSp calls are. 

The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to the name of the file or directory for which you wish to create an FSRef. 
ioVRefNum 

On input, a volume specification for the volume containing the file or directory. This can be a volume reference number, a drive number, or 0 for the default volume. 
ioDirID 

On input, the directory ID of the file or directory’s parent directory. 
newRef 

On input, a pointer to an FSRef structure. On output, this FSRef refers to the specified file or directory. 

To obtain an FSSpec from an FSRef, use the PBGetCatalogInfoSync function. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr PBMakeFSRefSync (
   FSRefParam * paramBlock){
//TODO
};


/*Fix2X

Converts a Fixed number to an Extended number.

double Fix2X (
   Fixed x
);
Parameters
x

The Fixed number to be converted to an Extended number. 
Return Value

The Extended equivalent of the Fixed number x. 
Special Considerations

Fix2X does not move memory; you can call it at interrupt time.
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
FixMath.h*/
double Fix2X (
   Fixed x){};


/*DisposePtr

Releases memory occupied by a nonrelocatable block.

void DisposePtr (
   Ptr p
);
Parameters
p

A pointer to the nonrelocatable block you want to dispose of. 
Discussion

When you no longer need a nonrelocatable block, call the DisposePtr function to free it for other uses.

Call the function MemError to get the result code. See “Memory Manager Result Codes”.

After a call to DisposePtr, all pointers to the released block become invalid and should not be used again. Any subsequent use of a pointer to the released block might cause a system error.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/
void DisposePtr (
   Ptr p
){};


/*NewPtrClear

Allocates a nonrelocatable block of memory of a specified size with all its bytes set to 0.

Ptr NewPtrClear (
   Size byteCount
);
Parameters
byteCount

The requested size (in bytes) of the nonrelocatable block. 
Return Value

A pointer to the new block. If NewPtrClear fails to allocate a block of the requested size, it returns NULL. 
Discussion

The NewPtrClear function works much as the NewPtr function does, but sets all bytes in the new block to 0 instead of leaving the contents of the block undefined.

Call the function MemError to get the result code. See “Memory Manager Result Codes”.

Because NewPtrClear allocates memory, you should not call it at interrupt time. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/

Ptr NewPtrClear (
   Size byteCount
){};


/*FSResolveAlias

Returns an FSRef to the single most likely target of an alias record.

OSErr FSResolveAlias (
   const FSRef * fromFile,
   AliasHandle alias,
   FSRef * target,
   Boolean * wasChanged
);
Parameters
fromFile

A pointer to an FSRef specifying the starting point for a relative search. If you pass NULL in this parameter, FSResolveAlias performs only an absolute search. If you pass a pointer to a valid FSRef in the fromFile parameter, FSResolveAlias performs a relative search for the target, followed by an absolute search only if the relative search fails. If you want to perform an absolute search followed by a relative search, you must use the FSMatchAlias function.
alias

A handle to the alias record to be resolved and, if necessary, updated.
target

A pointer to an FSRef. On successful return, this FSRef describes the target of the alias record. This parameter must point to a valid FSRef structure.
wasChanged

A pointer to a Boolean value indicating, on return, whether the alias record in the alias parameter was updated because it contained some outdated information about the target. If it updates the alias record, FSResolveAlias sets the wasChanged parameter to true. Otherwise, it sets it to false. (FSResolveAlias never updates a minimal alias, so it never sets wasChanged to true when resolving a minimal alias.
Return Value

A result code. When it finds the specified volume and parent directory but fails to find the target file or directory in that location, FSResolveAlias returns fnfErr. Note that the FSRef in the alias parameter is not valid in this case.
Discussion

The FSResolveAlias function performs a fast search for the target of the alias. If the resolution is successful, FSResolveAlias returns (in the target parameter) the FSRef for the target file system object, updates the alias record if necessary, and reports (through the wasChanged parameter) whether the record was updated. If the target is on an unmounted AppleShare volume, FSResolveAlias automatically mounts the volume. If the target is on an unmounted ejectable volume, FSResolveAlias asks the user to insert the volume. The FSResolveAlias function exits after it finds one acceptable target.

After it identifies a target, FSResolveAlias compares some key information about the target with the information in the alias record. If the information differs, FSResolveAlias updates the record to match the target.

The FSResolveAlias function displays the standard dialogs when it needs input from the user, such as a name and password for mounting a remote volume. The user can cancel the resolution through these dialogs. 
Availability
Available in CarbonLib 1.1 and later when running Mac OS 9.1 or later.
Available in Mac OS X version 10.0 and later.
Declared In
Aliases.h*/

OSErr FSResolveAlias (
   const FSRef * fromFile,
   AliasHandle alias,
   FSRef * target,
   Boolean * wasChanged
){};


/*FSNewAlias

Creates a new alias record, given a file system reference (FSRef) to the target file or directory.

OSErr FSNewAlias (
   const FSRef * fromFile,
   const FSRef * target,
   AliasHandle * inAlias
);
Parameters
fromFile

A pointer to a file system reference specifying the starting point for a relative path, to be used later in a relative search. If you do not need relative path information in the structure, pass a fromFile value of NULL. If you want FSNewAlias to record relative path information, pass a pointer to a valid FSRef in this parameter. The two files or directories, specified in the fromFile and target parameters, must reside on the same volume.
target

A pointer to an FSRef for the target of the alias record.
inAlias

A pointer to an alias handle. On return, this handle refers to the newly created alias record. If the function fails to create an alias record, it sets inAlias to NULL.
Return Value

A result code. For more information, see the Carbon Result Code Index. 
Discussion

The FSNewAlias function creates an alias record that describes the specified target. It allocates the storage, fills in the record, and puts a record handle to that storage in the inAlias parameter. FSNewAlias records the full pathname of the target and a collection of other information relevant to locating the target, verifying the target, and mounting the target’s volume, if necessary. You can have FSNewAlias store relative path information as well by supplying a starting point for a relative path. 
Availability
Available in CarbonLib 1.1 and later when running Mac OS 9.1 or later.
Available in Mac OS X version 10.0 and later.
Declared In
Aliases.h*/OSErr FSNewAlias (
   const FSRef * fromFile,
   const FSRef * target,
   AliasHandle * inAlias
){};

/*FSIsAliasFile

Determines whether a file system object is an alias file, a data file, or a folder.

OSErr FSIsAliasFile (
   const FSRef * fileRef,
   Boolean * aliasFileFlag,
   Boolean * folderFlag
);
Parameters
fileRef

A pointer to a file system object. 
aliasFileFlag

A pointer to a Boolean variable. On return, a value of TRUE indicates that the object specified in the fileRef parameter is an alias file. A value of FALSE indicates that the object is not an alias file. 
folderFlag

A pointer to a Boolean variable. On return, a value of TRUE indicates that the object specified in the fileRef parameter is a folder. A value of FALSE indicates that the object is a file. 
Return Value

A result code. For more information, see the Carbon Result Code Index. 
Discussion

Table 1 summarizes the information that this function provides about the object specified in the fileRef parameter: 
Table 1  Information about a file system object
Alias flag	
Folder flag	
Object kind 

T	
F	
Alias file

F	
F	
Data file

F	
T	
Folder


Note that if fileRef is an alias file, this function does not provide any information about the object to which the alias refers. To find out whether this object is a file or a folder, you can use FSResolveAliasFile.
Availability
Available in CarbonLib 1.1 and later when running Mac OS 9.1 or later.
Available in Mac OS X version 10.0 and later.
Declared In
Aliases.h*/

OSErr FSIsAliasFile (
   const FSRef * fileRef,
   Boolean * aliasFileFlag,
   Boolean * folderFlag
){};


/*Creates a new file with a Unicode name. 

OSErr FSCreateFileUnicode (
   const FSRef * parentRef,
   UniCharCount nameLength,
   const UniChar * name,
   FSCatalogInfoBitmap whichInfo,
   const FSCatalogInfo * catalogInfo,
   FSRef * newRef,
   FSSpec * newSpec
);
Parameters
parentRef

A pointer to an FSRef for the directory where the file is to be created. See FSRef for a description of the FSRef data type.
nameLength

The length of the file's name. 
name

A pointer to the Unicode name for the new file. 
whichInfo

A bitmap specifying which catalog information fields to set for the new file. You specify the values for these fields in the catalogInfo parameter. If you do not wish to set catalog information for the new file, pass the constant kFSCatInfoNone. See Catalog Information Bitmap Constants for a description of the bits defined for this parameter.
catalogInfo

A pointer to the FSCatalogInfo structure which specifies the values of the new file’s catalog information. Specify which fields to set in the whichInfo parameter.

This parameter is optional; specify NULL if you do not wish to set catalog information for the new file.

newRef

On return, a pointer to the FSRef for the new file. If you do not want the FSRef returned, specify NULL.
newSpec

On return, a pointer to the FSSpec for the new file. If you do not want the FSSpec returned, specify NULL. See FSSpec for a description of the FSSpec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

You may optionally set catalog information for the new file using the whichInfo and catalogInfo parameters; this is equivalent to calling FSSetCatalogInfo , or one of the corresponding parameter block functions, PBSetCatalogInfoSync and PBSetCatalogInfoAsync , after creating the file. 

If possible, you should set the textEncodingHint field of the catalog information structure specified in the catalogInfo parameter. This will be used by the volume format when converting the Unicode filename to other encodings. 
Special Considerations

If the FSCreateFileUnicode function is present, but is not implemented by a particular volume, the File Manager will emulate this function by making the appropriate call to PBHCreateSync. However, if the function is not directly supported by the volume, you will not be able to use the long Unicode filenames, or other features added with HFS Plus. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSCreateFileUnicode (
   const FSRef * parentRef,
   UniCharCount nameLength,
   const UniChar * name,
   FSCatalogInfoBitmap whichInfo,
   const FSCatalogInfo * catalogInfo,
   FSRef * newRef,
   FSSpec * newSpec
){};

/*FSSetCatalogInfo

Sets catalog information about a file or directory.

OSErr FSSetCatalogInfo (
   const FSRef * ref,
   FSCatalogInfoBitmap whichInfo,
   const FSCatalogInfo * catalogInfo
);
Parameters
ref

A pointer to an FSRef specifying the file or directory whose information is to be changed. See FSRef for a description of the FSRef data type.
whichInfo

A bitmap specifying which catalog information fields to set. Only some of the catalog information fields may be set. These fields are given by the constant kFSCatInfoSettableInfo; no other bits may be set in the whichInfo parameter. See Catalog Information Bitmap Constants for a description of the bits in this parameter.

To set the user ID (UID) and group ID (GID) on Mac OS X, specify the kFSCatInfoSetOwnership flag in this parameter. The File Manager attempts to set the user and group ID to the values specified in the permissions field of the catalog information structure. If FSSetCatalogInfo cannot set the user and group IDs, it returns an error.
catalogInfo

A pointer to the structure containing the new catalog information. Only some of the catalog information fields may be set. The fields which may be set are:
createDate
contentModDate
attributeModDate
accessDate
backupDate
permissions
finderInfo
extFinderInfo
textEncodingHint

On Mac OS 9, you may also set the kFSNodeLockedBit bit in the nodeFlags field if you are changing catalog information for a file.

Return Value

A result code. See “File Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSSetCatalogInfo (
   const FSRef * ref,
   FSCatalogInfoBitmap whichInfo,
   const FSCatalogInfo * catalogInfo
){};

/*FSDeleteObject

Deletes a file or an empty directory. 

OSErr FSDeleteObject (
   const FSRef * ref
);
Parameters
ref

A pointer to an FSRef specifying the file or directory to be deleted. If the object to be deleted is a directory, it must be empty (it must contain no files or folders). See FSRef for a description of the FSRef data type.
Return Value

A result code. See “File Manager Result Codes”. On Mac OS 8 and 9, if you attempt to delete a folder for which there is an open catalog iterator, FSDeleteObject returns the error fBsyErr. On Mac OS X, a similar attempt to delete a folder while another process has an open iterator will succeed and FSDeleteObject returns noErr. Iteration, however, will continue to work until the iterator is closed.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSDeleteObject (
   const FSRef * ref
){};


/*Get1Resource

Gets resource data for a resource in the current resource file.

Handle Get1Resource (
   ResType theType,
   short theID
);
Parameters
theType

The resource type of the resource about which you wish to retrieve data.
theID

An integer that uniquely identifies the resource about which you wish to retrieve data.
Return Value

If the function finds an entry for the resource in the current resource file’s resource map and the entry contains a valid handle, it returns that handle. If the entry contains a handle whose value is NULL, and if you haven’t called the SetResLoad function with the load parameter set to FALSE, Get1Resource attempts to read the resource into memory.

If the function can’t find the resource data, it returns NULL, and ResError returns the result code resNotFound. The Get1Resource function also returns NULL if the resource data to be read into memory won’t fit, in which case ResError returns an appropriate Memory Manager result code.

If you call this function with a resource type that can’t be found in the resource map of the current resource file, the function returns NULL, but ResError returns the result code noErr. You should always check that the value of the returned handle is not NULL.
Discussion

The function searches the current resource file’s resource map in memory for the specified resource.

You can change the resource map search order by calling the UseResFile function before Get1Resource.

To include ROM-resident system resources in the Resource Manager’s search of the resource maps for open resource forks, use the RGetResource function. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/
Handle Get1Resource (
   ResType theType,
   short theID
){};


/*ResError

Determines what error occurred, if any, after calling a Resource Manager function. 

OSErr ResError ();
Return Value

A result code. See “Resource Manager Result Codes”. If no error occurred, the function returns noErr. If an error occurs at the Resource Manager level, the function returns one of the result codes specific to the Resource Manager. If an error occurs at the Operating System level, the function returns an Operating System result code. In certain cases, the ResError function returns noErr even though a Resource Manager function was unable to perform the requested operation. See the individual function descriptions for details about the circumstances under which this happens.
Discussion

Resource Manager functions do not report error information directly. Instead, after calling a Resource Manager function, your application should call this function to determine whether an error occurred. You also can use this function to check for an error after application startup (system software opens the resource fork of your application during application startup).

Resource Manager functions usually return NULL or –1 as the function result when there’s an error. For Resource Manager functions that return –1, your application can call the ResError function to determine the specific error that occurred. For Resource Manager functions that return handles, your application should always check whether the value of the returned handle is NULL. If it is, your application can use this function to obtain specific information about the nature of the error. Note, however, that in some cases ResError returns noErr even though the value of the returned handle is NULL.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/
OSErr ResError (){};

/*HUnlock

Allows a relocatable block to move in its heap zone.

void HUnlock (
   Handle h
);
Parameters
h

A handle to a relocatable block. 
Discussion

The HUnlock function unlocks the relocatable block to which h is a handle, allowing the block to move within its heap zone. If the block is already unlocked, HUnlock does nothing.

Call the function MemError to get the result code. See “Memory Manager Result Codes”. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/

void HUnlock (
   Handle h
){};


/*SetComponentInstanceStorage

Allows your component to associate memory with a connection. 

void SetComponentInstanceStorage (
   ComponentInstance aComponentInstance,
   Handle theStorage
);
Parameters
aComponentInstance

The connection to associate with the allocated memory. The Component Manager provides a component instance to your component when the connection is opened. You can use a component identifier here, but you must coerce the data type appropriately. 
theStorage

A handle to the memory that your component has allocated for the connection. Your component must allocate this memory in the current heap. The Component Manager saves this handle and provides it to your component, along with other parameters, in subsequent requests to this connection. 
Discussion

When an application or component opens a connection to your component, the Component Manager sends your component an open request. In response to this open request, your component should set up an environment to service the connection. Typically, your component should allocate some memory for the connection. Your component can then use that memory to maintain state information appropriate to the connection.

Your component should dispose of any allocated memory for the connection only in response to the close request. Note that whenever an open request fails, the Component Manager always issues the close request. Furthermore, the value stored with this function is always passed to the close request, so it must be valid or NULL. If the open request tries to dispose of its allocated memory before returning, it should call this function again with a NULL handle to keep the Component Manager from passing an invalid handle to the close request. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/
void SetComponentInstanceStorage (
   ComponentInstance aComponentInstance,
   Handle theStorage
){};





/*ComponentSetTarget

Calls a component’s target request function and informs a component that it has been targeted by another component. 

long ComponentSetTarget (
   ComponentInstance ci,
   ComponentInstance target
);
Parameters
ci

The component instance to which to send a target request (the component that has been targeted). You can use a component identifier here, but you must coerce the data type appropriately. 
target

The component instance issuing the target request.
Return Value

The value that the targeted component instance returns in response to the target request, or badComponentSelector if the targeted component does not support the target request. 
Discussion

Your component can target a component instance without capturing the component or your component can first capture the component and then target a specific instance of the component. 

You should not target a component instance if the component does not support the target request. Before calling this function, you should issue a can do request to the component instance you want to target to verify that the component supports the target request. After receiving a target request, the targeted component instance should call the component instance that targeted it whenever the targeted component instance would normally call one of its defined functions. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/
long ComponentSetTarget (
   ComponentInstance ci,
   ComponentInstance target
){};


/*RegisterComponent

Registers a component stored in memory.

Component RegisterComponent (
   ComponentDescription * cd,
   ComponentRoutineUPP componentEntryPoint,
   short global,
   Handle componentName,
   Handle componentInfo,
   Handle componentIcon
);
Parameters
cd

A pointer to a ComponentDescription structure that describes the component to be registered. You must correctly fill in the fields of this structure before calling this function. When applications search for components using the FindNextComponent function, the Component Manager compares the attributes you specify here with those specified by the application. If the attributes match, the Component Manager returns the component identifier to the application. 
componentEntryPoint

A universal procedure pointer (UPP) to your component’s main entry point. The function referred to by this parameter receives all requests for the component. See the ComponentRoutineProcPtr callback for more information on creating a component function. 
global

A set of flags that control the scope of component registration. See “Register Component Resource flags” for a description of the flags. 
componentName

A handle to the component’s name. Set this parameter to NULL if you do not want to assign a name to the component. 
componentInfo

A handle to the component’s information string. Set this parameter to NULL if you do not want to assign an information string to the component.
componentIcon

A handle to the component’s icon (a 32-by-32 pixel black-and-white icon). Set this parameter to NULL if you do not want to supply an icon for this component. Note that this icon is not used by the Finder you supply an icon only so that other components or applications can display your component’s icon if needed.
Return Value

The unique component identifier assigned to the component by the Component Manager or, if it cannot register the component, NULL. See the description of the Component data type.
Discussion

Before a component can be used by an application, the component must be registered with the Component Manager. Applications can then find and open the component using the standard Component Manager functions. 

Components you register with the RegisterComponent function must be in memory when you call this function. If you want to register a component that is stored in the resource fork of a file, use the RegisterComponentResource function. Use the RegisterComponentResourceFile function to register all components in the resource fork of a file. The Component Manager automatically registers component resources stored in files with file types of 'thng' that are stored in the Extensions folder. See “Resources” for more information on component resource files.

Note that a component residing in your application heap remains registered until your application unregisters it or quits. When an application quits, the Component Manager automatically closes any component connections to that application. In addition, if the application has registered components that reside in its heap space, the Component Manager automatically unregisters those components. A component residing in the system heap and registered by your application remains registered until your application unregisters it or until the computer is shut down. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/
Component RegisterComponent (
   ComponentDescription * cd,
   ComponentRoutineUPP componentEntryPoint,
   short global,
   Handle componentName,
   Handle componentInfo,
   Handle componentIcon
){};


/*NewComponentRoutineUPP

Creates a new universal procedure pointer (UPP) to a component routine callback function.

ComponentRoutineUPP NewComponentRoutineUPP (
   ComponentRoutineProcPtr userRoutine
);
Parameters
userRoutine
Return Value

See the description of the ComponentRoutineUPP data type.
Discussion

See the ComponentRoutineProcPtr callback for more information. 
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes
Declared In
Components.h*/

ComponentRoutineUPP NewComponentRoutineUPP (
   ComponentRoutineProcPtr userRoutine
){};



/*FSDisposeVolumeOperation

Releases the memory associated with a volume operation. 

OSStatus FSDisposeVolumeOperation (
   FSVolumeOperation volumeOp
);
Parameters
volumeOp

The FSVolumeOperation to release. 
Return Value

A result code. See “File Manager Result Codes”. This function will return paramErr if the FSVolumeOperation is in use.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Files.h*/
OSStatus FSDisposeVolumeOperation (
   FSVolumeOperation volumeOp
){};


/*FSMountServerVolumeAsync

Mounts a server volume asynchronously.

OSStatus FSMountServerVolumeAsync (
   CFURLRef url,
   CFURLRef mountDir,
   CFStringRef user,
   CFStringRef password,
   FSVolumeOperation volumeOp,
   void * clientData,
   OptionBits flags,
   FSVolumeMountUPP callback,
   CFRunLoopRef runloop,
   CFStringRef runloopMode
);
Parameters
url

The server to mount. 
mountDir

The directory to mount the server to. If this parameter is NULL, the default location is used. 
user

A string to pass as the user for authentication. This parameter can be NULL. 
password

A string to pass as the password for authenticated log in. This parameter can be NULL. 
volumeOp

An FSVolumeOperation returned by the FSCreateVolumeOperation function. 
clientData

A pointer to client data associated with the operation. This parameter can be NULL.
flags

Options for future use.
callback

A function to call when the mount is complete. This parameter can be NULL. 
runloop

The runloop to run on. 
runloopMode

The mode for the runloop. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

This function will start the process to mount the server specified by the url parameter at the location specified by the mountDir parameter. If mountDir is NULL, the default location is used. An optional user and password can be passed in for authentication. If no user or password is provided then the underlying file system will handle authentication if required. If a callback function is provided, that function will be called when the mount operation is complete. Once this function returns noErr the status of the operation can be found using the FSGetAsyncMountStatus function.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Files.h*/
OSStatus FSMountServerVolumeAsync (
   CFURLRef url,
   CFURLRef mountDir,
   CFStringRef user,
   CFStringRef password,
   FSVolumeOperation volumeOp,
   void * clientData,
   OptionBits flags,
   FSVolumeMountUPP callback,
   CFRunLoopRef runloop,
   CFStringRef runloopMode
){};



/*NewFSVolumeMountUPP


FSVolumeMountUPP NewFSVolumeMountUPP (
   FSVolumeMountProcPtr userRoutine
);
Parameters
userRoutine
Return Value

See the description of the FSVolumeMountUPP data type.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Files.h*/
FSVolumeMountUPP NewFSVolumeMountUPP (
   FSVolumeMountProcPtr userRoutine
){};

/*FSCreateVolumeOperation

Returns an FSVolumeOperation which can be used for an asynchronous volume operation. 

OSStatus FSCreateVolumeOperation (
   FSVolumeOperation * volumeOp
);
Parameters
volumeOp

The new FSVolumeOperation. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

When the operation is completed the FSVolumeOperation should be disposed of to free the memory associated with the operation using FSDisposeVolumeOperation.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Files.h*/
OSStatus FSCreateVolumeOperation (
   FSVolumeOperation * volumeOp
){};


/*FSpMakeFSRef

Creates an FSRef for a file or directory, given an FSSpec.

OSErr FSpMakeFSRef (
   const FSSpec * source,
   FSRef * newRef
);
Parameters
source

A pointer to the FSSpec for the file or directory. This parameter must point to a valid FSSpec for an existing file or directory; if it does not, the call will return fnfErr. See FSSpec for a description of the FSSpec data type.
newRef

On input, a pointer to an FSRef structure. On return, a pointer to the FSRef for the file or directory specified in the FSSpec pointed to in the source parameter. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

To obtain an FSSpec from an FSRef, use the FSGetCatalogInfo function. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSpMakeFSRef (
   const FSSpec * source,
   FSRef * newRef
){};

/*GetComponentResource


OSErr GetComponentResource (
   Component aComponent,
   OSType resType,
   short resID,
   Handle * theResource
);
Parameters
aComponent
resType
theResource
Return Value

A result code. See “Component Manager Result Codes”.
Availability
Available in CarbonLib 1.0 and later when QuickTime 3.0 or later is present. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/

OSErr GetComponentResource (
   Component aComponent,
   OSType resType,
   short resID,
   Handle * theResource
){};


//FUNC
/*EndianU32_NtoB

Converts an unsigned 32-bit value in the computer’s native format to the equivalent big-endian value.

UInt32 EndianU32_NtoB (
   UInt32    value
);
Parameters
value

An unsigned 32-bit value in the computer’s native format.
Return Value

The equivalent big-endian value.
Availability
Available in Mac OS X v10.0 and later.
Available in QuickTime 4 and later for Windows.*/

UInt32 EndianU32_NtoB (
   UInt32    value
){};


/*CountComponents

Returns the number of registered components that meet the selection criteria specified by your application. 

long CountComponents (
   ComponentDescription * looking
);
Parameters
looking

A pointer to a ComponentDescription structure. Your application specifies the criteria for the component search in the fields of this structure.

The Component Manager ignores fields in the component description structure that are set to 0. For example, if you set all the fields to 0, the Component Manager returns the number of components registered in the system. Similarly, if you set all fields to 0 except for the componentManufacturer field, the Component Manager returns the number of registered components supplied by the manufacturer you specify.

Return Value

The number of components that meet the specified search criteria. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/
long CountComponents (
   ComponentDescription * looking
){};


/*GetComponentVersion

Returns the version number of a component to your application. 

long GetComponentVersion (
   ComponentInstance ci
);
Parameters
ci

The component instance from which you want to retrieve version information. Your application obtains the component instance from the OpenDefaultComponent function or the OpenComponent function. 
Return Value

The version number of the component you specify. The high-order 16 bits represent the major version, and the low-order 16 bits represent the minor version. The major version specifies the component specification level the minor version specifies a particular implementation’s version number. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/

long GetComponentVersion (
   ComponentInstance ci
){};



/*NewPtr

Allocates a nonrelocatable block of memory of a specified size.

Ptr NewPtr (
   Size byteCount
);
Parameters
byteCount

The requested size (in bytes) of the nonrelocatable block. In Mac OS X, if you pass a value of zero, this function returns NULL, and MemError is set to paramErr. In Mac OS 9 and earlier, if you pass a value of zero, this function returns a valid zero length pointer. 
Return Value

A pointer to the new block. If NewPtr fails to allocate a block of the requested size, it returns NULL. 
Discussion

The NewPtr function attempts to reserve space as low in the heap zone as possible for the new block. If it is able to reserve the requested amount of space, NewPtr allocates the nonrelocatable block in the gap ReserveMem creates. Otherwise, NewPtr returns NULL and generates a memFullErr error.

Call the function MemError to get the result code. See “Memory Manager Result Codes”.

Because NewPtr allocates memory, you should not call it at interrupt time. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/

Ptr NewPtr (
   Size byteCount
){};


/*TickCount

Obtains the current number of ticks (a tick is approximately 1/60 of a second) since the system last started up.

UInt32 TickCount ();
Discussion

The TickCount function returns an unsigned 32-bit integer that indicates the current number of ticks since the system last started up. You can use this value to compare the number of ticks that have elapsed since a given event or other action occurred. For example, you could compare the current value returned by TickCount with the value of the when field of an event structure.

The tick count is incremented during the vertical retrace interrupt, but this interrupt can be disabled. Your application should not rely on the tick count to increment with absolute precision. Your application also should not assume that the tick count always increments by 1 an interrupt task might keep control for more than one tick. If your application keeps track of the previous tick count and then compares this value with the current tick count, your application should compare the two values by checking for a “greater than or equal” condition rather than “equal to previous tick count plus 1.”

Do not rely on the tick count being exact; it is usually accurate to within one tick, but this level of accuracy is not guaranteed. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
OSUtils.h*/
UInt32 TickCount (){};


/*_MPIsFullyInitialized

Indicates whether Multiprocessing Services is available for use.

Boolean _MPIsFullyInitialized ();
Parameters
Return Value
Discussion

Checking for the availability of the MP API is rather ugly. This is a historical problem, caused by the original implementation letting itself get prepared when it really wasn't usable and complicated by some important clients then depending on weak linking to "work". (And further complicated by CFM not supporting "deferred" imports, which is how many programmers think weak imports work.)

The end result is that the MP API library may get prepared by CFM but be totally unusable. This means that if you import from the MP API library, you cannot simply check for a resolved import to decide if MP services are available. Worse, if you explicitly prepare the MP API library you cannot assume that a noErr result from GetSharedLibrary means that MP services are available.
If you import from the MP API library you must do the following:

Use the MPLibraryIsLoaded macro (or equivalent code in languages other than C) to tell if the MP API services are available. It is not sufficient to simply check that an imported symbol is resolved as is commonly done for other libraries. The macro expands to the expression: ( ( (UInt32)_MPIsFullyInitialized != (UInt32)kUnresolvedCFragSymbolAddress  )  &&
              ( _MPIsFullyInitialized () ) )

This code checks if the imported symbol _MPIsFullyInitialized is resolved and, if resolved, calls it. Both parts must succeed for the MP API services to be available.
If you explicitly prepare the MP API library you must use code similar to the following example to tell if the MP API services are available. It is not sufficient to depend on just a noErr result from GetSharedLibrary. OSErr err;
Boolean mpIsAvailable = false;
CFragConnectionID connID = kInvalidID;
MPIsFullyInitializedProc    mpIsFullyInitialized    = NULL;
 
err = GetSharedLibrary  ( "\pMPLibrary", kCompiledCFragArch,                             kReferenceCFrag, &connID, NULL,  NULL );
 
if ( err == noErr ) {
err = FindSymbol ( connID, "\p_MPIsFullyInitialized",
                    (Ptr *) &mpIsFullyInitialized, NULL );
}
 
if ( err == noErr ) {mpIsAvailable = (* mpIsFullyInitialized) ();
    }

Availability
Available in CarbonLib 1.0 and later when MultiprocessingLib 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Multiprocessing.h*/
Boolean _MPIsFullyInitialized (){};

/*MPCreateTask

Creates a preemptive task.

Modified

OSStatus MPCreateTask (
   TaskProc entryPoint,
   void * parameter,
   ByteCount stackSize,
   MPQueueID notifyQueue,
   void * terminationParameter1,
   void * terminationParameter2,
   MPTaskOptions options,
   MPTaskID * task
);
Parameters
entryPoint

A pointer to the task function. The task function should take a single 32-bit parameter and return a value of type OSStatus. 
parameter

The parameter to pass to the task function. 
stackSize

The size of the stack assigned to the task. Note that you should be careful not to exceed the bounds of the stack, since stack overflows may not be detected. Specifying zero for the size will result in a default stack size of 4KB. 

Note that in Mac OS X prior to version 10.1, this parameter is ignored, and all stacks have the default size of 512 KB. Versions 10.1 and later do not have this limitation.

notifyQueue

The ID of the message queue to which the system will send a message when the task terminates. You specify the first 64-bits of the message in the parameters terminationParameter1 and terminationParameter2 respectively. The last 32-bits contain the result code of the task function. 
terminationParameter1

A 32-bit value that is sent to the message queue specified by the parameter notifyQueue when the task terminates.
terminationParameter2

A 32-bit value that is sent to the message queue specified by the parameter notifyQueue when the task terminates.
options

Optional attributes of the preemptive task. See Task Creation Options for a list of possible values. 
task

On return, task points to the ID of the newly created task. 
Return Value

A result code. See "Multiprocessing Services Result Codes". If MPCreateTask could not create the task because some critical resource was not available, the function returns kMPInsufficientResourcesErr. Usually this is due to lack of memory to allocate the internal data structures associated with the task or the stack. The function also returns kMPInsufficientResourcesErr if any reserved option bits are set.
Discussion

Tasks are created in the unblocked state, ready for execution. A task can terminate in the following ways:
By returning from its entry point 
By calling MPExit
When specified as the target of an MPTerminateTask call 
If a hardware-detected exception or programming exception occurs and no exception handler is installed 
If the application calls ExitToShell 

Task resources (its stack, active timers, internal structures related to the task, and so on) are reclaimed by the system when the task terminates. The task's address space is inherited from the process address space. All existing tasks are terminated when the owning process terminates.

To set the relative processor weight to be assigned to a task, use the function MPSetTaskWeight.

See also the function MPTerminateTask. 
Version Notes

Introduced with Multiprocessing Services 1.0. 
Availability
Modified in Carbon. Available in CarbonLib 1.0 and later when MultiprocessingLib 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes

In Mac OS X prior to version 10.1, the stackSize parameter is ignored, and all stacks have the default size of 512 KB. Versions 10.1 and later do not have this limitation. 
Declared In
Multiprocessing.h*/
OSStatus MPCreateTask (
   TaskProc entryPoint,
   void * parameter,
   ByteCount stackSize,
   MPQueueID notifyQueue,
   void * terminationParameter1,
   void * terminationParameter2,
   MPTaskOptions options,
   MPTaskID * task
){};


/*LongSecondsToDate

Converts the number of seconds elapsed since midnight, January 1, 1904 to a date and time. (Deprecated in Mac OS X v10.4. Use the CFCalendarRef data type and the functions that operate on it instead.)

void LongSecondsToDate (
   const LongDateTime * lSecs,
   LongDateRec * lDate
);
Parameters
lSecs

The number of seconds elapsed since midnight, January 1, 1904. 
lDate

On return, the fields of the long date-time structure that contain the date and time corresponding to the value indicated in the lSecs parameter. For example, specifying the number of seconds 41580 results in the date and time 11:33 A.M. on January 1, 1904 being returned in this parameter. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
DateTimeUtils.h*/
void LongSecondsToDate (
   const LongDateTime * lSecs,
   LongDateRec * lDate
){};




/*UpTime
AbsoluteTime UpTime (void); 
DESCRIPTION

UpTime returns the time since OS initialization in AbsoluteTime units.
EXECUTION CONTEXT

UpTime may be called from task level, secondary interrupt level, or hardware interrupt level.*/
AbsoluteTime UpTime (void){}; 





/*MPTerminateTask

Terminates an existing task.

OSStatus MPTerminateTask (
   MPTaskID task,
   OSStatus terminationStatus
);
Parameters
task

The ID of the task you wish to terminate. 
terminationStatus

A 32-bit value of type OSStatus indicating termination status. This value is sent to the termination status message queue you specified in MPCreateTask in place of the task function’s result code. 
Return Value

A result code. See "Multiprocessing Services Result Codes". If the task to be terminated is already in the process of termination, MPTerminateTask returns kMPInsufficientResourcesErr. You do not need to take any additional action if this occurs.
Discussion

You should be very careful when calling MPTerminateTask. As defined, this call will asynchronously and abruptly terminate a task, potentially leaving whatever structures or resources it was operating upon in an indeterminate state. Mac OS X exacerbates this problem, as MP tasks can use many more system services that are not expecting client threads to asynchronously terminate, and these services do not take the rather complicated steps necessary to protect against, or recover from, such a situation.

However, there are situations in which calling MPTerminateTask is useful and relatively safe. One such situation is when your application or service is quitting and you know that the task you wish to terminate is waiting on an MP synchonization construct (queue, event, semaphore or critical region). While you could do this more cleanly by waking the task and causing it to exit on its own, doing so may not always be practical.

For example, suppose you have several service tasks performing background processing for your application. These service tasks wait on a queue, onto which the applicaton places requests for processing. When the task is done with a request, it notifies another queue, which the application polls. Since the main application task is placing items on the shared queue, and receiving notifications when the requests are done, it can track whether or not there are outstanding requests being processed. If all outstanding requests have, in fact, been processed, it is relatively safe to terminate a task (or all tasks) waiting on the request queue.

You should not assume that the task has completed termination when this call returns; the proper way to synchronize with task termination is to wait on the termination queue (specified in MPCreateTask ) until a message appears. Because task termination is a multistage activity, it is possible for a preemptive task to attempt to terminate a task that is already undergoing termination. In such cases, MPTerminateTask returns kMPInsufficientResourcesErr.

Note that Multiprocessing Services resources (event groups, queues, semaphores, and critical regions) owned by a preemptive task are not released when that task terminates. If a task has a critical region locked when it terminates, the critical region remains in the locked state. Multiprocessing Services resources no longer needed should be explicitly deleted by the task that handles the termination message. All Multiprocessing Services resources created by tasks are released when their owning process (that is, the host application) terminates. 
Version Notes

Introduced with Multiprocessing Services 1.0. 
Availability
Available in CarbonLib 1.0 and later when MultiprocessingLib 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Multiprocessing.h*/
OSStatus MPTerminateTask (
   MPTaskID task,
   OSStatus terminationStatus
){};


/*S64Compare


SInt32 S64Compare (
   SInt64 left,
   SInt64 right
);
Parameters
left
right
Return Value
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
Math64.h*/
SInt32 S64Compare (
   SInt64 left,
   SInt64 right
){};


/*Time Conversion Routines

The Driver Services Library provides the following conversion routines to convert between Nanoseconds, Duration, and AbsoluteTime units:
Nanoseconds AbsoluteToNanoseconds (AbsoluteTime absoluteTime); 

Nanoseconds DurationToNanoseconds (Duration duration); 

Duration AbsoluteToDuration (AbsoluteTime absoluteTime); 

AbsoluteTime NanosecondsToAbsolute (Nanoseconds nanoseconds); 

AbsoluteTime DurationToAbsolute (Duration duration); 

Duration NanosecondsToDuration (Nanoseconds nanoseconds); 

AbsoluteTime AddAbsoluteToAbsolute(
                     AbsoluteTime absoluteTime1,
                     AbsoluteTime absoluteTime2); 

AbsoluteTime SubAbsoluteFromAbsolute(
                     AbsoluteTime leftAbsoluteTime,
                     AbsoluteTime rightAbsoluteTime); 

AbsoluteTime AddNanosecondsToAbsolute(
                     Nanoseconds nanoseconds,
                     AbsoluteTime absoluteTime); 

AbsoluteTime AddDurationToAbsolute(
                     Duration duration,
                     AbsoluteTime absoluteTime); 

AbsoluteTime SubNanosecondsFromAbsolute(
                     Nanoseconds nanoseconds,
                     AbsoluteTime absoluteTime); 

AbsoluteTime SubDurationFromAbsolute(
                     Duration duration,
                     AbsoluteTime absoluteTime); 

Nanoseconds AbsoluteDeltaToNanoseconds(
                     AbsoluteTime leftAbsoluteTime,
                     AbsoluteTime rightAbsoluteTime); 

Duration AbsoluteDeltaToDuration(
                     AbsoluteTime leftAbsoluteTime,
                     AbsoluteTime rightAbsoluteTime); 

Note

The value of rightAbsoluteTime is usually larger than that of leftAbsoluteTime. However, if you subtract a rightAbsoluteTime value from a leftAbsoluteTime value, the result is 0, not a negative number. 
EXECUTION CONTEXT

The time conversion routines may be called from task level, secondary interrupt level, or hardware interrupt level.*/

Nanoseconds AbsoluteToNanoseconds (AbsoluteTime absoluteTime){}; 

Nanoseconds DurationToNanoseconds (Duration duration){}; 

Duration AbsoluteToDuration (AbsoluteTime absoluteTime){}; 

AbsoluteTime NanosecondsToAbsolute (Nanoseconds nanoseconds){}; 

AbsoluteTime DurationToAbsolute (Duration duration){}; 

Duration NanosecondsToDuration (Nanoseconds nanoseconds){}; 

AbsoluteTime AddAbsoluteToAbsolute(
                     AbsoluteTime absoluteTime1,
                     AbsoluteTime absoluteTime2){}; 

AbsoluteTime SubAbsoluteFromAbsolute(
                     AbsoluteTime leftAbsoluteTime,
                     AbsoluteTime rightAbsoluteTime){}; 

AbsoluteTime AddNanosecondsToAbsolute(
                     Nanoseconds nanoseconds,
                     AbsoluteTime absoluteTime){}; 

AbsoluteTime AddDurationToAbsolute(
                     Duration duration,
                     AbsoluteTime absoluteTime){}; 

AbsoluteTime SubNanosecondsFromAbsolute(
                     Nanoseconds nanoseconds,
                     AbsoluteTime absoluteTime){}; 

AbsoluteTime SubDurationFromAbsolute(
                     Duration duration,
                     AbsoluteTime absoluteTime){}; 

Nanoseconds AbsoluteDeltaToNanoseconds(
                     AbsoluteTime leftAbsoluteTime,
                     AbsoluteTime rightAbsoluteTime){}; 

Duration AbsoluteDeltaToDuration(
                     AbsoluteTime leftAbsoluteTime,
                     AbsoluteTime rightAbsoluteTime){}; 

/*Long2Fix

Converts a LongInt number to a Fixed number.

Fixed Long2Fix (
   long x
);
Parameters
x

The long integer to be converted to a Fixed number. 
Return Value

The Fixed number equivalent to the long integer x. If x is greater than the maximum representable fixed-point number, the Long2Fix function returns $7FFFFFFF. If x is less than the negative number with the highest absolute value, Long2Fix returns $80000000. 
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
FixMath.h*/

Fixed Long2Fix (
   long x
){};

/*FSResolveAliasFileWithMountFlags

Resolves an alias contained in an alias file.

OSErr FSResolveAliasFileWithMountFlags (
   FSRef * theRef,
   Boolean resolveAliasChains,
   Boolean * targetIsFolder,
   Boolean * wasAliased,
   unsigned long mountFlags
);
Parameters
theRef

A pointer to a file system reference (FSRef) for the alias file you plan to open. If the function completes successfully, this FSRef describes the file or the directory referred to by the alias file.
resolveAliasChains

A Boolean value. Set this parameter to TRUE if you want FSResolveAliasFileWithMountFlags to resolve all aliases in a chain (for example, an alias file that refers to an alias file and so on), stopping only when it reaches the target file. Set this parameter to FALSE if you want to resolve only one alias file, even if the target is another alias file. 
targetIsFolder

A pointer to a Boolean value. The FSResolveAliasFileWithMountFlags function returns TRUE in this parameter if the FSRef in the parameter theRef points to a directory or a volume; otherwise, FSResolveAliasFileWithMountFlags returns FALSE in this parameter. 
wasAliased

A pointer to a Boolean value. The FSResolveAliasFileWithMountFlags function returns TRUE in this parameter if the FSRef in the parameter theRef points to an alias; otherwise, FSResolveAliasFileWithMountFlags returns FALSE in this parameter. 
mountFlags

Options controlling how the alias file is resolved. See “Volume Mount Options” for a description of the values you can use here. Set this parameter to kResolveAliasFileNoUI to prevent any user interaction, including disk switch alerts, while the alias is being resolved.
Return Value

A result code. For more information, see the Carbon Result Code Index. 
Discussion

The function FSResolveAliasFileWithMountFlags is identical to FSResolveAliasFile with the exception that it provides the mountFlags parameter, allowing callers additional control over how the alias file is resolved.
Availability
Available in CarbonLib 1.1 and later when running Mac OS 9.1 or later.
Available in Mac OS X version 10.0 and later.
Declared In
Aliases.h*/
OSErr FSResolveAliasFileWithMountFlags (
   FSRef * theRef,
   Boolean resolveAliasChains,
   Boolean * targetIsFolder,
   Boolean * wasAliased,
   unsigned long mountFlags
){};





/*FSCompareFSRefs

Determines whether two FSRef structures refer to the same file or directory.

OSErr FSCompareFSRefs (
   const FSRef * ref1,
   const FSRef * ref2
);
Parameters
ref1

A pointer to the first FSRef to compare. For a description of the FSRef data type, see FSRef.
ref2

A pointer to the second FSRef to compare.
Return Value

A result code. See “File Manager Result Codes”. If the two FSRef structures refer to the same file or directory, then noErr is returned. If they refer to objects on different volumes, then diffVolErr is returned. If they refer to different files or directories on the same volume, then errFSRefsDifferent is returned. This function may return other errors, including nsvErr, fnfErr, dirNFErr, and volOffLinErr.
Discussion

You must use FSCompareFSRefs, or one of the corresponding parameter block functions, PBCompareFSRefsSync and PBCompareFSRefsAsync , to compare FSRef structures. It is not possible to compare the FSRef structures directly since some bytes may be uninitialized, case-insensitive text, or contain hint information.

Some volume formats may be able to tell that two FSRef structures would refer to two different files or directories, without having to actually find those objects. In this case, the volume format may return errFSRefsDifferent even if one or both objects no longer exist. Similarly, if the FSRef structures are for objects on different volumes, the File Manager will return diffVolErr even if one or both volumes are no longer mounted. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/

OSErr FSCompareFSRefs (
   const FSRef * ref1,
   const FSRef * ref2
){};


/*FSCreateDirectoryUnicode

Creates a new directory (folder) with a Unicode name. 

OSErr FSCreateDirectoryUnicode (
   const FSRef * parentRef,
   UniCharCount nameLength,
   const UniChar * name,
   FSCatalogInfoBitmap whichInfo,
   const FSCatalogInfo * catalogInfo,
   FSRef * newRef,
   FSSpec * newSpec,
   UInt32 * newDirID
);
Parameters
parentRef

A pointer to an FSRef specifying the parent directory where the new directory is to be created. See FSRef for a description of the FSRef data type.
nameLength

The length of the new directory's Unicode name. 
name

A pointer to the Unicode name of the new directory. 
whichInfo

A bitmap specifying which catalog information fields to set for the new directory. Specify the values for these fields in the catalogInfo parameter. 

If you do not wish to set catalog information for the new directory, specify the constant kFSCatInfoNone. See Catalog Information Bitmap Constants for a description of the bits defined for this parameter.
catalogInfo

A pointer to the FSCatalogInfo structure which specifies the values for the catalog information fields for the new directory. Specify which fields to set in the whichInfo parameter.

This parameter is optional; specify NULL if you do not wish to set catalog information for the new directory.

See FSCatalogInfo for a description of the FSCatalogInfo data type.
newRef

On return, a pointer to the FSRef for the new directory. This parameter is optional; specify NULL if you do not want the FSRef returned.
newSpec

On return, a pointer to the FSSpec for the new directory. This parameter is optional; specify NULL if you do not want the FSSpec returned. See FSSpec for a description of the FSSpec data type.
newDirID

On return, a pointer to the directory ID of the directory. This parameter is optional; specify NULL if you do not want the directory ID returned. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

You may optionally set catalog information for the new directory using the whichInfo and catalogInfo parameters; this is equivalent to calling FSSetCatalogInfo , or one of the corresponding parameter block functions, PBSetCatalogInfoSync and PBSetCatalogInfoAsync , after creating the directory. 

If possible, you should set the textEncodingHint field of the catalog information structure specified in the catalogInfo parameter. This will be used by the volume format when converting the Unicode filename to other encodings. 
Special Considerations

If the FSCreateDirectoryUnicode function is present, but is not implemented by a particular volume, the File Manager will emulate this function by making the appropriate call to PBDirCreateSync. However, if the function is not directly supported by the volume, you will not be able to use the long Unicode directory names, or other features added with HFS Plus. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSCreateDirectoryUnicode (
   const FSRef * parentRef,
   UniCharCount nameLength,
   const UniChar * name,
   FSCatalogInfoBitmap whichInfo,
   const FSCatalogInfo * catalogInfo,
   FSRef * newRef,
   FSSpec * newSpec,
   UInt32 * newDirID
){};



/*FSWrite

Writes any number of bytes to an open file. (Deprecated in Mac OS X v10.4. Use FSWriteFork instead.)

OSErr FSWrite (
   short refNum,
   long * count,
   const void * buffPtr
);
Parameters
refNum

The file reference number of the open file to which to write. 
count

On input, a pointer to the number of bytes to write to the file. In Carbon on Mac OS 9 and X, passing 0 in this parameter will return a paramErr error.

On output, a pointer to the number of bytes actually written.

buffPtr

A pointer to the data buffer containing the data to write. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The FSWrite function takes the specified number of bytes from the data buffer and attempts to write them to the file. Because the write operation begins at the current mark, you might want to set the mark first by calling the SetFPos function.

If the write operation completes successfully, FSWrite moves the file mark to the byte following the last byte written and returns noErr. If you try to write past the logical end-of-file, FSWrite moves the logical end-of-file. If you try to write past the physical end-of-file, FSWrite adds one or more clumps to the file and moves the physical end-of-file accordingly.

The low-level functions PBWriteSync and PBWriteAsync let you set the mark without having to call SetFPos. For a description of the PBWriteSync and PBWriteAsync functions, see the Device Manager Reference .

If you wish to write to named forks other than the data or resource forks, or grow files larger than 2GB, you must use the FSWriteFork function, or one of its corresponding parameter block calls, PBWriteForkSync and PBWriteForkAsync. If you attempt to use FSWrite to write to a file larger than 2GB, you will receive an error message. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr FSWrite (
   short refNum,
   long * count,
   const void * buffPtr
){};


/*FSpCreate

Creates a new file. (Deprecated in Mac OS X v10.4. Use FSCreateFileUnicode instead.)

OSErr FSpCreate (
   const FSSpec * spec,
   OSType creator,
   OSType fileType,
   ScriptCode scriptTag
);
Parameters
spec

A pointer to an FSSpec structure specifying the file to be created. See FSSpec for a description of the FSSpec data type.
creator

The creator of the new file. See the documentation for the Finder Interface for more information on file creators. 
fileType

The file type of the new file. See the documentation for the Finder Interface for more information on file types.
scriptTag

The code of the script system in which the filename is to be displayed. If you have established the name and location of the new file using either the NavAskSaveChanges or NavCustomAskSaveChanges function, specify the script code returned in the reply structure. Otherwise, specify the system script by setting the scriptTag parameter to the value smSystemScript.

For more information about the functions NavAskSaveChanges and NavCustomAskSaveChanges, see Programming With Navigation Services. See the Script Manager Reference for a description of the smSystemScript constant.

Return Value

A result code. See “File Manager Result Codes”.
Discussion

The FSpCreate function creates a new file (both data and resource forks) with the specified type, creator, and script code. The new file is unlocked and empty. The date and time of creation and last modification are set to the current date and time.

Files created using FSpCreate are not automatically opened. If you want to write data to the new file, you must first open the file using one of the file access functions, FSpOpenDF , HOpenDF , PBHOpenDFSync or PBHOpenDFAsync.

The resource fork of the new file exists but is empty. You’ll need to call one of the Resource Manager functions HCreateResFile or FSpCreateResFile to create a resource map in the file before you can open it by calling one of the Resource Manager functions HOpenResFile or FSpOpenResFile).

Before calling this function, you should call the Gestalt function to check that the function is available. If FSpCreate is not available, you can use the function HCreate instead. To create a file with a Unicode filename, use the function FSCreateFileUnicode , or one of the corresponding parameter block calls, PBCreateFileUnicodeSync and PBCreateFileUnicodeAsync. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr FSpCreate (
   const FSSpec * spec,
   OSType creator,
   OSType fileType,
   ScriptCode scriptTag
){};


/*FSpDelete

Deletes a file or directory. (Deprecated in Mac OS X v10.4. Use FSDeleteObject instead.)

OSErr FSpDelete (
   const FSSpec * spec
);
Parameters
spec

A pointer to an FSSpec structure specifying the file or directory to delete. See FSSpec for a description of the FSSpec data type.
Return Value

A result code. See “File Manager Result Codes”. If you attempt to delete an open file or a non-empty directory, FSpDelete returns the result code fBsyErr. FSpDelete also returns the result code fBsyErr if the directory has an open working directory associated with it.
Discussion

If the specified target is a file, both forks of the file are deleted. The file ID reference, if any, is removed. A file must be closed before you can delete it. Similarly, a directory must be empty before you can delete it. 

Before calling this function, you should call the Gestalt function to check that the function is available. If FSpDelete is not available, you can use the function HDelete instead. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr FSpDelete (
   const FSSpec * spec
){};


/*NewAliasMinimal

Creates a short alias record quickly. (Deprecated in Mac OS X v10.4. Use FSNewAliasMinimal instead.)

Not recommended

OSErr NewAliasMinimal (
   const FSSpec * target,
   AliasHandle * alias
);
Parameters
target

A pointer to an FSSpec structure for the target of the alias record.
alias

A pointer to an alias handle. On return, this handle refers to the newly created alias record. If the function fails to create an alias record, it sets alias to NULL.
Return Value

A result code. For more information, see the Carbon Result Code Index. 
Discussion

The NewAliasMinimal function creates an alias record that contains only the minimum information necessary to describe the target: the target name, the parent directory ID, the volume name and creation date, and the volume mounting information. The NewAliasMinimal function uses the standard alias record data structure, but it fills in only parts of the record.

The ResolveAlias function never updates a minimal alias record. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X version 10.0 and later but deprecated in Mac OS X v10.4.
Deprecated in Mac OS X v10.4.
Carbon Porting Notes

Use FSNewAliasMinimal instead.
Declared In
Aliases.h*/

OSErr NewAliasMinimal (
   const FSSpec * target,
   AliasHandle * alias
){};


/*AddResource

Adds a resource to the current resource file’s resource map in memory.

void AddResource (
   Handle theData,
   ResType theType,
   short theID,
   ConstStr255Param name
);
Parameters
theData

A handle to data in memory to be added as a resource to the current resource file (not a handle to an existing resource). If the value of this parameter is an empty handle (that is, a handle whose master pointer is set to NULL), the Resource Manager writes zero-length resource data to disk when it updates the resource. If its value is either NULL or a handle to an existing resource, the function does nothing, and the ResError function returns the result code addResFailed. If the resource map becomes too large to fit in memory, the function does nothing, and ResError returns an appropriate result code. The same is true if the resource data in memory can’t be written to the resource fork (for example, because the disk is full).
theType

The resource type of the resource to be added.
theID

The resource ID of the resource to be added.
name

The name of the resource to be added.
Discussion

This function sets the resChanged attribute to 1 it does not set any of the resource’s other attributes—that is, all other attributes are set to 0. If the resChanged attribute of a resource has been set and your application calls the UpdateResFile function or quits, the Resource Manager writes both the resource map and the resource data for that resource to the resource fork of the corresponding file on disk. If the resChanged attribute for a resource has been set and your application calls the WriteResource function, the Resource Manager writes only the resource data for that resource to disk.

If you add a resource to the current resource file, the Resource Manager writes the entire resource map to disk when it updates the file. If you want any of your changes to the resource map or resource data to be temporary, you must restore the original information before the Resource Manager updates the file on disk.

The function doesn’t verify whether the resource ID you pass in the parameter theID is already assigned to another resource of the same type. You should call the UniqueID or Unique1ID function to get a unique resource ID before adding a resource with this function.

When your application calls this function, the Resource Manager attempts to reserve disk space for the new resource. If the new resource data can’t be written to the resource fork (for example, if there’s not enough room on disk), the resChanged attribute is not set to 1. If this is the case and you call UpdateResFile or WriteResource, the Resource Manager won’t know that resource data has been added. Thus, the function won’t write the new resource data to the resource fork and won’t return an error. For this reason, always make sure that the ResError function returns the result code noErr after a call to AddResource. 

To copy an existing resource, get a handle to the resource you want to copy, call the DetachResource function, then call AddResource. To add the same resource data to several different resource forks, call the Memory Manager function HandToHand to duplicate the handle for each resource. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/
void AddResource (
   Handle theData,
   ResType theType,
   short theID,
   ConstStr255Param name
){};


/*RemoveResource

Removes a resource’s entry from the current resource file’s resource map in memory. 

void RemoveResource (
   Handle theResource
);
Parameters
theResource

A handle to the resource which you wish to detach. If the resProtected attribute for the resource is set or if this parameter doesn’t contain a handle to a resource, the function does nothing, and the ResError function returns the result code rmvResFailed. 
Discussion

The RemoveResource function does not dispose of the handle you pass into it; to do so you must call the Memory Manager function DisposeHandle after calling RemoveResource. You should dispose the handle if you want to release the memory before updating or closing the resource fork.

If you’ve removed a resource, the Resource Manager writes the entire resource map when it updates the resource fork, and all changes made to the resource map become permanent. If you want any of the changes to be temporary, you should restore the original information before the Resource Manager updates the resource fork.

The RemoveResource function is also available as the RmveResource function.
Special Considerations

This function may move or purge memory blocks in the application heap. Your application should not call this function at interrupt time.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/

void RemoveResource (
   Handle theResource
){};

/*UseResFile

Sets the current resource file.

void UseResFile (
   short refNum
);
Parameters
refNum

The file reference number for the resource fork which you wish to set as the current resource fork.
Return Value

The function searches the list of files whose resource forks have been opened for the file specified here. If the specified file is found, the Resource Manager sets the current resource file to the specified file. If there’s no resource fork open for a file with that reference number, the function does nothing. To set the current resource file to the System file, use 0 here.
Discussion

Open resource forks are arranged as a linked list with the most recently opened resource fork at the beginning. When searching open resource forks, the Resource Manager starts with the most recently opened file. You can call this function to set the current resource file to a file opened earlier, and thereby start subsequent searches with the specified file. In this way, you can cause any files higher in the resource chain to be left out of subsequent searches.

When a new resource fork is opened, this action overrides previous calls to this function and the entire list is searched. For example, if five resource forks are opened in the order R0, R1, R2, R3, and R4, the search order is R4-R3-R2-R1-R0. Calling UseResFile(R2) changes the search order to R2-R1-R0; R4 and R3 are not searched. When the resource fork of a new file (R5) is opened, the search order becomes R5-R4-R3-R2-R1-R0.

You typically call the CurResFile function to get and save the current resource file, UseResFile to set the current resource file to the desired file, then (after you are finished using the resource) UseResFile to restore the current resource file to its previous value. Calling UseResFile(0) causes the Resource Manager to search only the System file’s resource map. This is useful if you no longer wish to override a system resource with one by the same name in your application’s resource fork.

Most of the Resource Manager functions assume that the current resource file is the file on whose resource fork they should operate or, in the case of a search, the file where they should begin. In general, the current resource file is the last one whose resource fork your application opened unless you specify otherwise.

The FSpOpenResFile, HOpenResFile, and OpenResFile functions, which also set the current resource file, override previous calls to UseResFile.

To check for errors, call the ResError function.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/

void UseResFile (
   short refNum
){};



/*PBSetCatInfoSync

Modifies catalog information for a file or directory. (Deprecated in Mac OS X v10.4. Use PBSetCatalogInfoSync instead.)

OSErr PBSetCatInfoSync (
   CInfoPBPtr paramBlock
);
Parameters
paramBlock

A pointer to an HFS catalog information parameter block. See CInfoPBRec for a description of the CInfoPBRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The PBSetCatInfoSync function sets information about a file or directory. When used to set information about a file, it works much as PBHSetFInfoSync does, but lets you set some additional information.

If the object is a file, the relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to a pathname. 
ioVRefNum 

On input, a volume reference number, drive number, or 0 for the default volume. 
ioFlFndrInfo 

On input, Finder information for the file. 
ioDirID 

On input, the parent directory ID of the file. 
ioFlCrDat 

On input, the date and time of the file’s creation. 
ioFlMdDat 

On input, the date and time of the file’s last modification. 
ioFlBkDat 

On input, the date and time of the file’s last backup. 
ioFlXFndrInfo 

On input, extended Finder information. 

If the object is a directory, the relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to a pathname. 
ioVRefNum 

On input, a volume reference number, drive number, or 0 for the default volume. 
ioDrUsrWds 

On input, information used by the Finder. 
ioDrDirID 

On input, the directory ID. 
ioDrCrDat 

On input, the date and time of the directory’s creation. 
ioDrMdDat 

On input, the date and time of the directory’s last modification. 
ioDrBkDat 

On input, the date and time of the directory’s last backup. 
ioDrFndrInfo 

On input, additional information used by the Finder. 

To modify the catalog information for a named fork other than the data and resource fork, or to modify other catalog information maintained on HFS Plus volumes that is not modifiable through PBSetCatInfoSync, use one of the functions, FSSetCatalogInfo , PBSetCatalogInfoSync , or PBSetCatalogInfoAsync. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr PBSetCatInfoSync (
   CInfoPBPtr paramBlock
){};


/*FSpOpenResFile

Opens a file’s resource fork using a file system specification (FSSpec) record.

short FSpOpenResFile (
   const FSSpec * spec,
   SignedByte permission
);
Parameters
spec

A pointer to a file system specification record specifying the name and location of the file whose resource fork is to be opened. The file system specification record for files and directories is defined by the FSSpec data type and is a standard format in System 7 and later versions for identifying a file or directory.

This function also makes this file the current resource file.

See the File Manager documentation for a description of the FSSpec data type.
permission

A constant indicating the type of access with which to open the resource fork. For a description of the types of access you can request, see the section File Access Permission Constants in File Manager Reference.
Return Value

The file reference number for the resource fork. If the file reference number returned is greater than 0, you can use this number to refer to the resource fork in some other Resource Manager functions.

If you attempt to use this function to open a resource fork that is already open, it returns the existing file reference number or a new one, depending on the access permission for the existing access path. For example, your application receives a new file reference number after a successful request for read-only access to a file previously opened with write access, whereas it receives the same file reference number in response to a second request for write access to the same file. In this case, the function doesn’t make that file the current resource file.

If the function fails to open the specified file’s resource fork (for instance, because there’s no file with the given file system specification record or because there are permission problems), it returns –1 as the file reference number. Use the ResError function to determine what kind of error occurred. 

If an application attempts to open a second access path with write access and the application is different from the one that originally opened the resource fork, FSpOpenResFile returns –1, and the ResError function returns the result code opWrErr.
Discussion

This function is available only in System 7 and later versions of system software. You can determine whether FSpOpenResFile is available by calling the Gestalt function with the gestaltFSAttr selector code. If this function is not available to your application, you can use HOpenResFile, OpenRFPerm, or OpenResFile instead. The HOpenResFile function is preferred if FSpOpenResFile is not available. The OpenRFPerm and OpenResFile functions are earlier versions of HOpenResFile that are still supported but are more restricted in their capabilities.

The Resource Manager reads the resource map from the specified file’s resource fork into memory. It also reads into memory every resource in the resource fork whose resPreload attribute is set.

You don’t have to call this function to open the System file’s resource fork or an application file’s resource fork. These resource forks are opened automatically when the system and the application start up, respectively. To get the file reference number for your application, call the CurResFile function after your application starts up and before you open any other resource forks.

The FSpOpenResFile function checks that the information in the resource map is internally consistent. If it isn’t, ResError returns the result code mapReadErr.

It’s possible to create multiple, unique, read-only access paths to a resource fork using this function however, you should avoid doing so. If a resource fork is opened twice—once with read/write permission and once with read-only permission—two copies of the resource map exist in memory. If you change one of the resources in memory using one of the resource maps, the two resource maps become inconsistent and the file will appear damaged to the second resource map. 

If you must use this technique for read-only access, call this function immediately before your application reads information from the file and close the file immediately afterward. Otherwise, your application may get unexpected results.

If you want to open the resource fork for another application (or any resource fork other than your application’s that includes 'CODE' resources), you must bracket your calls to this function with calls to the SetResLoad function with the load parameter set to FALSE and then to TRUE. You must also avoid making intersegment calls while the other application’s resource fork is open. If you don’t do this, the Segment Loader Manager treats any preloaded 'CODE' resources as your code resources when you make an intersegment call that triggers a call to the LoadSeg function while the other application is first in the resource chain. In this case, your application can begin executing the other application’s code, and severe problems will ensue. If you need to get 'CODE' resources from the other application’s resource fork, you can still prevent the Segment Loader Manager problem by calling the UseResFile function with your application’s file reference number to make your application the current resource file.

To open a resource fork just for block-level operations, such as copying files without reading the resource map into memory, use the File Manager function OpenRF. 
Special Considerations

This function may move or purge memory blocks in the application heap. Your application should not call this function at interrupt time.

Because there is no support for locking and unlocking file ranges on local disks with Carbon on Mac OS X, regardless of whether File Sharing is enabled, you cannot open more than one path to a resource fork with read/ write permission. If you try to open a more than one path to a file's resource fork with fsRdWrShPerm permission, only the first attempt will succeed. Subsequent attempts will return an invalid reference number and the ResError function will return the error opWrErr.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/
short FSpOpenResFile (
   const FSSpec * spec,
   SignedByte permission
){};


/*HCreateResFile

Creates an empty resource fork, when the FSpCreateResFile function is not available.

void HCreateResFile (
   short vRefNum,
   long dirID,
   ConstStr255Param fileName
);
Parameters
vRefNum

The volume reference number of the volume on which the file is located.
dirID

The directory ID of the directory where the file is located.
fileName

The name of the file whose resource fork is to be created. If no other file with the given name exists in the specified directory, the function creates a resource file—that is, a resource fork, including a resource map. In this case the file has a zero-length data fork. 

If a file with the specified name already exists and includes a resource fork with a resource map, the function does nothing. If the data fork of the specified file already exists but the file has a zero-length resource fork, the function creates an empty resource fork and resource map for the file.
Discussion

Don’t use the resource fork of a file for data that is not in resource format. The Resource Manager assumes that any information in a resource fork can be interpreted according to the standard resource format described in this chapter.

The File Manager assumes that the first block of a file’s resource fork is part of the resource header and puts information there that it uses during scavenging—for example, after the user presses the Reset switch. For this reason, if you copy a resource file, the duplicate may not be exactly like the original.

Before you can work with the newly created file’s resource fork, you must first use the HOpenResFile function or a related function to open it.

To check for errors, call the ResError function. 
Special Considerations

This function may move or purge memory blocks in the application heap. Your application should not call this function at interrupt time.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/

void HCreateResFile (
   short vRefNum,
   long dirID,
   ConstStr255Param fileName
){};

/*WriteResource

Writes resource data in memory immediately to a file’s resource fork. 

void WriteResource (
   Handle theResource
);
Parameters
theResource

A handle to a resource. The function checks the resChanged attribute of this resource. If the resChanged attribute is set to 1, such as after a successful call to the ChangedResource or AddResource function, WriteResource writes the resource data in memory to the resource fork, then clears the resChanged attribute in the resource’s resource map in memory.

If the resource is purgeable and has been purged, the function writes zero-length resource data to the resource fork. If the resource’s resProtected attribute is set to 1, the function does nothing, and the ResError function returns the result code noErr. The same is true if the resChanged attribute is not set (that is, set to 0). If the given handle isn’t a handle to a resource, WriteResource does nothing, and ResError returns the result code resNotFound.
Discussion

Note that this function does not write the resource’s resource map entry to disk.

When your application calls ChangedResource or AddResource, the Resource Manager attempts to reserve disk space for the changed resource. If the modified resource data can’t be written to the resource fork (for example, if there’s not enough room on disk), the resChanged attribute is not set to 1. If this is the case and you call WriteResource, the Resource Manager won’t know that the resource data has been changed. Thus, the function won’t write the modified resource data to the resource fork and won’t return an error. For this reason, always make sure that the ResError function returns the result code noErr after a call to ChangedResource or AddResource.

The resource fork is updated automatically when your application quits, when you call the UpdateResFile function, or when you call the CloseResFile function. Thus, you should call WriteResource only if you want to write just one or a few resources immediately. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/
void WriteResource (
   Handle theResource
){};

/*HiWord

Obtains the high-order word of a long word. 

SInt16 HiWord (
   SInt32 x
);
Parameters
x

The long word whose high word is to be returned. 
Return Value

The high-order word of the long word specified by the x parameter. 
Discussion

One use of this function is to obtain the integral part of a fixed-point number.

To copy a range of bytes from one memory location to another, you should ordinarily use the Memory Manager function, BlockMove. 
Availability
Declared In
ToolUtils.h*/

SInt16 HiWord (
   SInt32 x
){};






/*LoWord

Obtains the low-order word of a long word. 

SInt16 LoWord (
   SInt32 x
);
Parameters
x

The long word whose low word is to be returned. 
Return Value

The low-order word of the long word specified by the x parameter. 
Discussion

One use of this function is to obtain the fractional part of a fixed-point number.

To copy a range of bytes from one memory location to another, you should ordinarily use the Memory Manager function, BlockMove. 
Availability
Declared In
ToolUtils.h*/

SInt16 LoWord (
   SInt32 x
){};



/*PBWriteSync

Writes any number of bytes to an open file.

OSErr PBWriteSync (
   ParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to a basic File Manager parameter block. 
Return Value

A result code. See “Device Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ioCompletion On input, a pointer to a completion routine. 
ioResult On output, the result code of the function. 
ioRefNum On input, a file reference number for the open file to which to write. 
ioBuffer On input, a pointer to a data buffer containing the bytes to write. 
ioReqCount On input, the number of bytes requested. 
ioActCount On output, the number of bytes actually written. 
ioPosMode On input, the positioning mode. 
ioPosOffset On input, the positioning offset. On output, the new position of the mark. 

The PBWriteSync function takes ioReqCount bytes from the buffer pointed to by ioBuffer and attempts to write them to the open file whose access path is specified by ioRefNum. The position of the mark is specified by ioPosMode and ioPosOffset. If the write operation completes successfully, PBWriteSync moves the file mark to the byte following the last byte written and returns noErr.

If you try to write past the logical end-of-file, PBWriteSync moves the logical end-of-file. If you try to write past the physical end-of-file, PBWriteSync adds one or more clumps to the file and moves the physical end-of-file accordingly. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes

This function is only supported for writing to open files.
Declared In
Devices.h*/

OSErr PBWriteSync (
   ParmBlkPtr paramBlock
){};


/*SetFPos

Sets the position of the file mark. (Deprecated in Mac OS X v10.4. Use FSSetForkPosition instead.)

OSErr SetFPos (
   short refNum,
   short posMode,
   long posOff
);
Parameters
refNum

The file reference number of an open file. 
posMode

A constant specifying how to position the file mark; this parameter must contain one of the values described in Position Mode Constants.
posOff

The offset from the base location specified by the posMode parameter for the new file mark position. If you specify fsFromLEOF in the posMode parameter, the value in the posOff parameter must be less than or equal to 0. If you specify fsAtMark, the value in the posOff parameter is ignored. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

Because the read and write operations performed by the functions FSRead and FSWrite begin at the current mark, you may want to call SetFPos to reposition the file mark before reading from or writing to the file.

To set the file mark position for a named fork other than the data and resource forks, or to position the file mark at a point more than 2GB into the file, use the FSSetForkPosition function, or one of the corresponding parameter block calls, PBSetForkPositionSync and PBSetForkPositionAsync. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr SetFPos (
   short refNum,
   short posMode,
   long posOff
){};


/*SetEOF

Sets the logical size of an open file. (Deprecated in Mac OS X v10.4. Use FSSetForkSize instead.)

OSErr SetEOF (
   short refNum,
   long logEOF
);
Parameters
refNum

The file reference number of an open file. 
logEOF

The new logical size (the logical end-of-file) of the given file. If you set the logEOF parameter to 0, all space occupied by the file on the volume is released. The file still exists, but it contains 0 bytes. Setting a file fork’s end-of-file to 0 is therefore not the same as deleting the file, which removes both file forks at once. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

If you attempt to set the logical end-of-file beyond the physical end-of-file, the physical end-of-file is set 1 byte beyond the end of the next free allocation block if there isn’t enough space on the volume, no change is made, and SetEOF returns dskFulErr as its function result.

To ensure that your changes to the file are written to disk, call one of the functions, FlushVol , PBFlushVolSync , or PBFlushVolAsync. To set the size of a named fork other than the data and resource forks, or to grow the size of a file beyond 2GB, you must use the FSSetForkSize function, or one of the corresponding parameter block calls, PBSetForkSizeSync and PBSetForkSizeAsync. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr SetEOF (
   short refNum,
   long logEOF
){};

/*GetFPos

Returns the current position of the file mark. (Deprecated in Mac OS X v10.4. Use FSGetForkPosition instead.)

OSErr GetFPos (
   short refNum,
   long * filePos
);
Parameters
refNum

The file reference number of an open file. 
filePos

On return, a pointer to the current position of the mark. The position value is zero-based; that is, the value of filePos is 0 if the file mark is positioned at the beginning of the file. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

Because the read and write operations performed by the functions FSRead and FSWrite begin at the current mark, you should call GetFPos, or one of the parameter block functions, PBGetFPosSync and PBGetFPosAsync , to determine the current position of the file mark before reading from or writing to the file.

To determine the current position of a named fork, or of a fork larger than 2GB, use the FSGetForkPosition function, or one of the corresponding parameter block calls, PBGetForkPositionSync and PBGetForkPositionAsync. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr GetFPos (
   short refNum,
   long * filePos
){};


/*GetComponentRefcon

Retrieves the value of the reference constant for your component. 

long GetComponentRefcon (
   Component aComponent
);
Parameters
aComponent

The component whose reference constant you wish to get. You can use a component instance here, but you must coerce the data type appropriately. 
Return Value

The reference constant for the specified component. 
Discussion

There is one reference constant for each component, regardless of the number of connections to that component. When your component is registered, the Component Manager sets this reference constant to 0.

The reference constant is a 4-byte value that your component can use in any way you decide. For example, you might use the reference constant to store the address of a data structure that is shared by all connections maintained by your component. You should allocate shared structures in the system heap. Your component should deallocate the structure when its last connection is closed or when it is unregistered. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/

long GetComponentRefcon (
   Component aComponent
){};


/*SetComponentRefcon

Sets the reference constant for your component.

void SetComponentRefcon (
   Component aComponent,
   long theRefcon
);
Parameters
aComponent

The component whose reference constant you wish to set. You can use a component instance here, but you must coerce the data type appropriately. 
theRefcon

The reference constant value that you want to set for your component. Your component can retrieve the reference constant using the GetComponentRefcon function. 
Discussion

There is one reference constant for each component, regardless of the number of connections to that component. When your component is registered, the Component Manager sets this reference constant to 0.

The reference constant is a 4-byte value that your component can use in any way you decide. For example, you might use the reference constant to store the address of a data structure that is shared by all connections maintained by your component. You should allocate shared structures in the system heap. Your component should deallocate the structure when its last connection is closed or when it is unregistered. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/
void SetComponentRefcon (
   Component aComponent,
   long theRefcon
){};


/*GetComponentInstanceA5

Retrieves the value of the A5 register for a specified connection.

Unsupported

SInt32 GetComponentInstanceA5 (
   ComponentInstance aComponentInstance
);
Parameters
aComponentInstance

The connection for which to retrieve the A5 value. The Component Manager provides a component instance to your component when the connection is opened. You can use a component identifier here, but you must coerce the data type appropriately. 
Return Value

The value of the A5 register for the connection. 
Discussion

Your component sets the A5 register by calling the SetComponentInstanceA5 function. 
Carbon Porting Notes

Because there is no A5 world in Carbon, you cannot use the functions GetComponentInstanceA5 and SetComponentInstanceA5 to access A5 information.
Declared In
Components.h*/
SInt32 GetComponentInstanceA5 (
   ComponentInstance aComponentInstance
){};


/*FSpSetFInfo

Sets the Finder information about a file. (Deprecated in Mac OS X v10.4. Use FSSetCatalogInfo instead.)

OSErr FSpSetFInfo (
   const FSSpec * spec,
   const FInfo * fndrInfo
);
Parameters
spec

A pointer to an FSSpec structure specifying the file for which to set the Finder information. See FSSpec for a description of the FSSpec data type.
fndrInfo

A pointer to the new Finder information. For a description of the FInfo data type, see the Finder Interface Reference.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The FSpSetFInfo function changes the Finder information in the volume catalog entry for the specified file. FSpSetFInfo allows you to set only the original Finder information—the information in the FInfo or DInfo structures, not the information in the FXInfo or DXInfo structures. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr FSpSetFInfo (
   const FSSpec * spec,
   const FInfo * fndrInfo
){};


/*PrimeTime

Activates a task in the Time Manager queue. (Deprecated in Mac OS X v10.4. Use Carbon Event Loop timers or Cocoa NSTImers instead.)

Not Recommended

void PrimeTime (
QElemPtr tmTaskPtr,
long count
);
Discussion

This function is deprecated. You should use the function PrimeTimeTask instead.
Special Considerations

Carbon Event timers and Cocoa NSTimers provide a simpler and more efficient way to handle timed or periodic tasks. For more information about using Carbon Event timers, see the timers section in Carbon Event Manager Programming Guide. For information about NSTimers, see Timers. Both Carbon event timers and NSTimers are built on top of the lower-level Core Foundation CFRunLoop timers. For CFRunLoop information, see Run Loops.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Timer.h*/

void PrimeTime (
QElemPtr tmTaskPtr,
long count
){};


/*PBWriteAsync

Writes any number of bytes to an open file.

OSErr PBWriteAsync (
   ParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to a basic File Manager parameter block. 
Return Value

A result code. See “Device Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ioCompletion On input, a pointer to a completion routine. 
ioResult On output, the result code of the function. 
ioRefNum On input, a file reference number for the open file to which to write. 
ioBuffer On input, a pointer to a data buffer containing the bytes to write. 
ioReqCount On input, the number of bytes requested. 
ioActCount On output, the number of bytes actually written. 
ioPosMode On input, the positioning mode. 
ioPosOffset On input, the positioning offset. On output, the new position of the mark. 

The PBWriteAsync function takes ioReqCount bytes from the buffer pointed to by ioBuffer and attempts to write them to the open file whose access path is specified by ioRefNum. The position of the mark is specified by ioPosMode and ioPosOffset. If the write operation completes successfully, PBWriteAsync moves the file mark to the byte following the last byte written and returns noErr.

If you try to write past the logical end-of-file, PBWriteAsync moves the logical end-of-file. If you try to write past the physical end-of-file, PBWriteAsync adds one or more clumps to the file and moves the physical end-of-file accordingly. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes

This function is only supported for writing to open files.
Declared In
Devices.h*/
OSErr PBWriteAsync (
   ParmBlkPtr paramBlock
){};


/*PBReadAsync

Reads any number of bytes from an open file.

OSErr PBReadAsync (
   ParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to a basic File Manager parameter block. 
Return Value

A result code. See “Device Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ioCompletion On input, a pointer to a completion routine. 
ioResult On output, the result code of the function. 
ioRefNum On input, a file reference number for an open file to be read. 
ioBuffer On input, a pointer to a data buffer into which the bytes are read. 
ioReqCount On input, the number of bytes requested. The value that you pass in this field should be greater than zero. 
ioActCount On output, the number of bytes actually read. 
ioPosMode On input, the positioning mode. 
ioPosOffset On input, the positioning offset. On output, the new position of the mark. 

This function attempts to read ioReqCount bytes from the open file whose access path is specified in the ioRefNum field and transfer them to the data buffer pointed to by the ioBuffer field. The position of the mark is specified by ioPosMode and ioPosOffset. If your application tries to read past the logical end-of-file, PBReadAsync reads the data, moves the mark to the end-of-file, and returns eofErr as its function result. Otherwise, PBReadAsync moves the file mark to the byte following the last byte read and returns noErr.

You can specify that PBReadAsync read the file data 1 byte at a time until the requested number of bytes have been read or until the end-of-file is reached. To do so, set bit 7 of the ioPosMode field. Similarly, you can specify that PBReadAsync should stop reading data when it reaches an application-defined newline character. To do so, place the ASCII code of that character into the high-order byte of the ioPosMode field; you must also set bit 7 of that field to enable newline mode.

When reading data in newline mode, PBReadAsync returns the newline character as part of the data read and sets ioActCount to the actual number of bytes placed into the buffer (which includes the newline character). 
Version Notes

Note that on Mac OS 8 and 9, it is possible to call PBReadAsync with a value of 0 in the ioReqCount field; however, this behavior is not supported on Mac OS X. On OS X, PBReadAsync returns a paramErr error if the value in the ioReqCount field is 0.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Devices.h*/

OSErr PBReadAsync (
   ParmBlkPtr paramBlock
){};


/*PBSetFPosAsync

Sets the position of the file mark. (Deprecated in Mac OS X v10.4. Use PBSetForkPositionAsync instead.)

OSErr PBSetFPosAsync (
   ParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the IOParam variant of the basic File Manager parameter block. See ParamBlockRec for a description of the ParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ioCompletion 

On input, a pointer to a completion routine. For more information on completion routines, see IOCompletionProcPtr. 
ioResult 

On output, the result code of the function. 
ioRefNum 

On input, the file reference number for an open file. 
ioPosMode 

On input, a constant indicating how to position the mark; this field must contain one of the values described in Position Mode Constants. 
ioPosOffset 

On input, the offset from the base location specified by the ioPosMode field for the file mark. If you specify fsAtMark in the ioPosMode field, the mark is left wherever it’s currently positioned and the value in the ioPosOffset field is ignored. If you specify fsFromLEOF, the value in ioPosOffset must be less than or equal to 0. On output, the position at which the mark was actually set. 

The PBSetFPosAsync function sets the mark of the specified file to the position specified by the ioPosMode and ioPosOffset fields. If you try to set the mark past the logical end-of-file, PBSetFPosAsync moves the mark to the end-of-file and returns eofErr as its function result.

To set the file mark position for a named fork other than the data and resource forks, or to position the file mark at a point more than 2GB into the file, use the FSSetForkPosition function, or one of the corresponding parameter block calls, PBSetForkPositionSync and PBSetForkPositionAsync. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr PBSetFPosAsync (
   ParmBlkPtr paramBlock
){};


/*RmvTime

Remove a task from the Time Manager queue. (Deprecated in Mac OS X v10.4. Use Carbon Event Loop timers or Cocoa NSTImers instead.)

Not Recommended

void RmvTime (
QElemPtr tmTaskPtr
);
Special Considerations

Carbon Event timers and Cocoa NSTimers provide a simpler and more efficient way to handle timed or periodic tasks. For more information about using Carbon Event timers, see the timers section in Carbon Event Manager Programming Guide. For information about NSTimers, see Timers. Both Carbon event timers and NSTimers are built on top of the lower-level Core Foundation CFRunLoop timers. For CFRunLoop information, see Run Loops.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Timer.h*/
void RmvTime (
QElemPtr tmTaskPtr
){};


/*InsTime

Installs a task record into the Time Manager task queue. (Deprecated in Mac OS X v10.4. Use Carbon Event Loop timers or Cocoa NSTImers instead.)

Not Recommended

void InsTime (
QElemPrt tmTaskPtr
);
Special Considerations

Carbon Event timers and Cocoa NSTimers provide a simpler and more efficient way to handle timed or periodic tasks. For more information about using Carbon Event timers, see the timers section in Carbon Event Manager Programming Guide. For information about NSTimers, see Timers. Both Carbon event timers and NSTimers are built on top of the lower-level Core Foundation CFRunLoop timers. For CFRunLoop information, see Run Loops.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Timer.h*/
void InsTime (
QElemPrt tmTaskPtr
){};



/*PBWriteForkAsync

Writes data to an open fork.

void PBWriteForkAsync (
   FSForkIOParam * paramBlock
);
Parameters
paramBlock

A pointer to a fork I/O parameter block. See FSForkIOParam for a description of the FSForkIOParam.
Discussion

The relevant fields of the parameter block are:
ioCompletion 

On input, a pointer to a completion routine. For more information on completion routines, see IOCompletionProcPtr. 
ioResult 

On output, the result code of the function. If there is not enough space on the volume to write requestCount bytes, then dskFulErr is returned. 
forkRefNum 

On input, the reference number of the fork to which to write. You should have previously opened the fork using the FSOpenFork function, or one of the corresponding parameter block calls, PBOpenForkSync and PBOpenForkAsync. 
positionMode 

On input, a constant specifying the base location within the fork for the start of the write. See Position Mode Constants for a description of the constants which you can use to specify the base location.The caller can also use this parameter to hint to the File Manager whether the data being written should or should not be cached. See Cache Constants for further description of the constants that you can use to indicate your preference for caching. 
positionOffset 

On input, the offset from the base location for the start of the write. 
requestCount 

On input, the number of bytes to write. 
buffer 

A pointer to a buffer containing the data to write. 
actualCount 

On output, the number of bytes actually written. The value in the actualCount field will be equal to the value in the requestCount field unless there was an error during the write operation. 

PBWriteForkAsync writes data starting at the position specified by the positionMode and positionOffset fields. The function attempts to write requestCount bytes from the buffer pointed to by the buffer field and sets the fork’s current position to the byte immediately after the last byte written (that is, the initial position plus actualCount).

When writing data to a fork, it is important to pay attention to that way that your program accesses the fork, because this can have a significant performance impact. For best results, you should use an I/O size of at least 4KB and block align your write requests. On Mac OS X, you should align your requests to 4KB boundaries; on the traditional Mac OS, byte-alignments beyond 512-bytes are irrelevant, but 4KB aligned requests will perform well on current and future versions. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/

void PBWriteForkAsync (
   FSForkIOParam * paramBlock
){};


/*PBReadForkAsync

Reads data from an open fork.

void PBReadForkAsync (
   FSForkIOParam * paramBlock
);
Parameters
paramBlock

A pointer to a fork I/O parameter block. See FSForkIOParam for a description of the FSForkIOParam data type.
Discussion

The relevant fields of the parameter block are:
ioCompletion 

On input, a pointer to a completion routine. For more information on completion routines, see IOCompletionProcPtr. 
ioResult 

On output, the result code of the function. If there are fewer than requestCount bytes from the specified position to the logical end-of-file, then all of those bytes are read, and eofErr is returned. 
forkRefNum 

On input, the reference number of the fork to read from. You should have previously opened this fork using the FSOpenFork call, or one of the corresponding parameter block calls, PBOpenForkSync and PBOpenForkAsync. 
positionMode 

On input, a constant specifying the base location within the fork for the start of the read. See Position Mode Constants for a description of the constants which you can use to specify the base location.The caller can also use this parameter to hint to the File Manager whether the data being read should or should not be cached. Caching reads appropriately can be important in ensuring that your program access files efficiently. If you add the forceReadMask constant to the value you pass in this parameter, this tells the File Manager to force the data to be read directly from the disk. This is different from adding the noCacheMask constant since forceReadMask tells the File Manager to flush the appropriate part of the cache first, then ignore any data already in the cache. However, data that is read may be placed in the cache for future reads. The forceReadMask constant is also passed to the device driver, indicating that the driver should avoid reading from any device caches.See Cache Constants for further description of the constants that you can use to indicate your preference for caching the read. 
positionOffset 

On input, the offset from the base location for the start of the read. 
requestCount 

On input, the number of bytes to read. The value that you pass in this field should be greater than zero. 
buffer 

A pointer to the buffer where the data will be returned. 
actualCount 

On output, the number of bytes actually read. The value in this field should be equal to the value in the requestCount field unless there was an error during the read operation. 

PBReadForkAsync reads data starting at the position specified by the positionMode and positionOffset fields. The function reads up to requestCount bytes into the buffer pointed to by the buffer field and sets the fork’s current position to the byte immediately after the last byte read (that is, the initial position plus actualCount).

To verify that data previously written has been correctly transferred to disk, read it back in using the forceReadMask constant in the positionMode field and compare it with the data you previously wrote.

When reading data from a fork, it is important to pay attention to that way that your program accesses the fork, because this can have a significant performance impact. For best results, you should use an I/O size of at least 4KB and block align your read requests. On Mac OS X, you should align your requests to 4KB boundaries; on the traditional Mac OS, byte-alignments beyond 512-bytes are irrelevant, but 4KB aligned requests will perform well on current and future versions. 
Version Notes

Note that on Mac OS 8 and 9, it is possible to call PBReadForkAsync with a value of 0 in the requestCount field; however, this behavior is not supported on Mac OS X. On OS X, PBReadForkAsync returns a paramErr error if the value in the requestCount field is 0.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/

void PBReadForkAsync (
   FSForkIOParam * paramBlock){};


/*NewIOCompletionUPP

Creates a new universal procedure pointer (UPP) to your completion function.

IOCompletionUPP NewIOCompletionUPP (
   IOCompletionProcPtr userRoutine
);
Parameters
userRoutine

A pointer to a completion callback function. See IOCompletionProcPtr for a description of the IOCompletionProcPtr data type.
Return Value

A universal procedure pointer to your completion function. See IOCompletionUPP for a description of the IOCompletionUPP data type.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
IOCompletionUPP NewIOCompletionUPP (
   IOCompletionProcPtr userRoutine
){};



/*FixRatio

Obtains the Fixed equivalent of a fraction.

Fixed FixRatio (
   short numer,
   short denom
);
Parameters
numer

The numerator of the fraction. 
denom

The denominator of the fraction.
Return Value

The Fixed equivalent of the fraction numer/denom. 
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
FixMath.h*/
Fixed FixRatio (
   short numer,
   short denom
){};


/*OpenComponentResFile

Allows your component to gain access to its resource file. 

short OpenComponentResFile (
   Component aComponent
);
Parameters
aComponent

The component whose resource file you wish to open. Applications that register components may obtain this identifier from the RegisterComponentResource function. You can use a component instance here, but you must coerce the data type appropriately. 
Return Value

A reference number that your component can use to read data from the appropriate resource file. If the specified component does not have an associated resource file or if the Component Manager cannot open the resource file, the function returns 0 or a negative number. 
Discussion

This function opens the resource file with read-only permission. The Component Manager adds the resource file to the current resource chain. Your component must close the resource file with the CloseComponentResFile function before returning to the calling application. Note that there is only one resource file associated with a component.

Your component can use FSpOpenResFile or equivalent Resource Manager functions to open other resource files, but you must use this function to open your component’s resource file.

If you store your component in a component resource but register the component with the RegisterComponent function, rather than with the RegisterComponentResource or RegisterComponentResourceFile function, your component cannot access its resource file with this function.

Note that when working with resources, your component should always first save the current resource file, perform any resource operations, then restore the current resource file to its previous value before returning. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/
short OpenComponentResFile (
   Component aComponent
){};


/*GetResource

Gets resource data for a resource specified by resource type and resource ID.

Handle GetResource (
   ResType theType,
   short theID
);
Parameters
theType

The resource type of the resource about which you wish to retrieve data. 
theID

An integer that uniquely identifies the resource about which you wish to retrieve data.
Return Value

If the function finds the specified resource entry in one of the resource maps and the entry contains a valid handle, it returns that handle. If the entry contains a a handle whose value is NULL, and if you haven’t called the SetResLoad function with the load parameter set to FALSE, GetResource attempts to read the resource into memory.

If the function can’t find the resource data, it returns NULL, and the ResError function returns the result code resNotFound. The GetResource function also returns NULL if the resource data to be read into memory won’t fit, in which case ResError returns an appropriate Memory Manager result code. If you call GetResource with a resource type that can’t be found in any of the resource maps of the open resource forks, the function returns NULL, but ResError returns the result code noErr. You should always check that the value of the returned handle is not NULL.
Discussion

The function searches the resource maps in memory for the specified resource. The resource maps in memory, which represent all the open resource forks, are arranged as a linked list. When searching this list, the function starts with the current resource file and progresses through the list (that is, searching the resource maps in reverse order of opening) until it finds the resource’s entry in one of the resource maps. 

Before reading the resource data into memory, the Resource Manager calls the Memory Manager to allocate a relocatable block for the resource data. The Memory Manager allocates the block, assigns a master pointer to the block, and returns to the Resource Manager a pointer to the master pointer. The Resource Manager then installs this handle in the resource map. 

You can change the resource map search order by calling the UseResFile function before calling GetResource.

To include ROM-resident system resources in the Resource Manager’s search of the resource maps of open resource forks, use the RGetResource function. 
Special Considerations

This function may move or purge memory blocks in the application heap. Your application should not call this function at interrupt time.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/


Handle GetResource (
   ResType theType,
   short theID
){};

/*CloseComponentResFile

Closes the resource file that your component opened previously with the OpenComponentResFile function. 

OSErr CloseComponentResFile (
   short refnum
);
Parameters
refnum

The reference number that identifies the resource file to be closed. Your component obtains this value from the OpenComponentResFile function. Your component must close any open resource files before returning to the calling application. 
Return Value

A result code. See “Component Manager Result Codes”.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/

OSErr CloseComponentResFile (
   short refnum
){};

/*GetIndString

Loads a string from a string list ('STR#') resource into memory, given the resource ID of the string list and the index of the individual string. (Deprecated in Mac OS X v10.4. Use CFBundleCopyLocalizedString instead.)

void GetIndString (
   Str255 theString,
   short strListID,
   short index
);
Parameters
theString

On output, the Pascal string result; specifically, a copy of the string from a string list that has the resource ID provided in the strListID parameter. If the resource that you specify cannot be read or the index that you specify is out of range for the string list, GetIndString sets theString to an empty string. 
strListID

The resource ID of the 'STR#' resource that contains the string list. 
index

The index of the string in the list. This is a value from 1 to the number of strings in the list that is referenced by the strListID parameter.
Discussion

If necessary, GetIndString reads the string list from the resource file by calling the Resource Manager function GetResource. GetIndString accesses the string specified by the index parameter and copies it into theString. 
Special Considerations

GetIndString may move memory; your application should not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
TextUtils.h*/
void GetIndString (
   Str255 theString,
   short strListID,
   short index
){};


/*GetComponentInstanceStorage

Allows your component to retrieve a handle to the memory associated with a connection. 

Handle GetComponentInstanceStorage (
   ComponentInstance aComponentInstance
);
Parameters
aComponentInstance

The connection for which to retrieve the associated memory. The Component Manager provides a component instance to your component when the connection is opened. You can use a component identifier here, but you must coerce the data type appropriately. 
Return Value

A handle to the memory associated with the specified connection. 
Discussion

Typically, your component does not need to use this function, because the Component Manager provides this handle to your component each time the client application requests service from this connection.

Your component tells the Component Manager about the memory associated with a connection by calling the SetComponentInstanceStorage function. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/

Handle GetComponentInstanceStorage (
   ComponentInstance aComponentInstance
){};

/*SetHandleSize

Changes the logical size of the relocatable block corresponding to the specified handle.

void SetHandleSize (
   Handle h,
   Size newSize
);
Parameters
h

A handle to a relocatable block. 
newSize

The desired new logical size, in bytes, of the relocatable block. 
Discussion

SetHandleSize might need to move the relocatable block to obtain enough space for the resized block. Thus, for best results you should unlock a block before resizing it.

An attempt to increase the size of a locked block might fail, because of blocks above and below it that are either nonrelocatable or locked. You should be prepared for this possibility.

Instead of using the SetHandleSize function to set the size of a handle to 0, you can use the EmptyHandle function.

Call the function MemError to get the result code. See “Memory Manager Result Codes”.

Because SetHandleSize allocates memory, you should not call it at interrupt time. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/

void SetHandleSize (
   Handle h,
   Size newSize
){};



/*NewComponentFunctionUPP


ComponentFunctionUPP NewComponentFunctionUPP (
   ProcPtr userRoutine,
   ProcInfoType procInfo
);
Parameters
procInfo
Return Value

See the description of the ComponentFunctionUPP data type.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes
Declared In
Components.h*/

ComponentFunctionUPP NewComponentFunctionUPP (
   ProcPtr userRoutine,
   ProcInfoType procInfo
){};


/*CallComponentFunction

Invokes the specified function of your component.

long CallComponentFunction (
   ComponentParameters * params,
   ComponentFunctionUPP func
);
Parameters
params

A pointer to the ComponentDescription structure that your component received from the Component Manager. These are the parameters originally provided by the application that called your component. 
func

A universal procedure pointer to the component function that is to handle the request. The Component Manager calls the function referred to by the func parameter, using Pascal calling conventions, with the parameters that were originally provided by the application that called your component. The function referred to by this parameter must return a function result of type ComponentResult indicating the success or failure of the operation. See the ComponentRoutineProcPtr callback for more information on component functions. 
Return Value

The value that is returned by the function referred to by the func parameter. Your component should use this value to set the current error for this connection. You can use the SetComponentInstanceError function to set the current error. 
Discussion

When an application requests service from your component, your component receives a component parameters structure containing the parameters that the application provided when it called your component. Your component can use this structure to access the parameters directly. Alternatively, you can use either this function or CallComponentFunctionWithStorage to extract those parameters and pass them to a subroutine of your component. By taking advantage of these functions, you can simplify the structure of your component code. 

If your component subroutine does not need global data, your component should use this function. If your component subroutine requires memory in which to store global data for the component, your component must use CallComponentFunctionWithStorage. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes
Declared In
Components.h*/

long CallComponentFunction (
   ComponentParameters * params,
   ComponentFunctionUPP func
){};

/*DisposeComponentFunctionUPP


void DisposeComponentFunctionUPP (
   ComponentFunctionUPP userUPP
);
Parameters
userUPP
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes
Declared In
Components.h*/

void DisposeComponentFunctionUPP (
   ComponentFunctionUPP userUPP
){};


/*CallComponentFunctionWithStorage

Invokes the specified function of your component. 

long CallComponentFunctionWithStorage (
   Handle storage,
   ComponentParameters * params,
   ComponentFunctionUPP func
);
Parameters
storage

A handle to the memory associated with the current connection. The Component Manager provides this handle to your component along with the request. 
params

A pointer to the ComponentParameters structure that your component received from the Component Manager. These are the parameters originally provided by the application that called your component. 
func

A universal procedure pointer to the component function that is to handle the request. The Component Manager calls the function referred to by the func parameter, using Pascal calling conventions, with the parameters that were originally provided by the application that called your component. These parameters are preceded by a handle to the memory associated with the current connection. The function referred to by the func parameter must return a function result of type ComponentResult indicating the success or failure of the operation. See the ComponentRoutineProcPtr callback for more information on component functions. 
Return Value

The value that is returned by the function referred to by the func parameter. Your component should use this value to set the current error for this connection. Use the SetComponentInstanceError function to set the current error for a connection. 
Discussion

When an application requests service from your component, your component receives a component parameters structure containing the parameters that the application provided when it called your component. Your component can use this structure to access the parameters directly. Alternatively, you can use either the CallComponentFunction function or this function to extract those parameters and pass them to a subroutine of your component. By taking advantage of these functions, you can simplify the structure of your component code. 

If your component subroutine requires a handle to the memory associated with the connection, you must use this function. You allocate the memory for a given connection each time your component is opened. You inform the Component Manager that a connection has memory associated with it by calling the SetComponentInstanceError function.

Subroutines of a component that don’t need global data should use CallComponentFunction instead. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/

long CallComponentFunctionWithStorage (
   Handle storage,
   ComponentParameters * params,
   ComponentFunctionUPP func
){};


/*FSpGetFInfo

Obtains the Finder information for a file. (Deprecated in Mac OS X v10.4. Use FSGetCatalogInfo instead.)

OSErr FSpGetFInfo (
   const FSSpec * spec,
   FInfo * fndrInfo
);
Parameters
spec

A pointer to an FSSpec structure specifying the file. See FSSpec for a description of the FSSpec data type.
fndrInfo

On return, a pointer to information used by the Finder. The FSpGetFInfo function returns the Finder information from the volume catalog entry for the specified file. The function provides only the original Finder information—the information in the FInfo or DInfo structures, not the information in the FXInfo or DXInfo structures. For a description of the FInfo structure, see the Finder Interface Reference.
Return Value

A result code. If the specified object is a folder, this function returns fnfErr. For other possible return values, see “File Manager Result Codes”. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr FSpGetFInfo (
   const FSSpec * spec,
   FInfo * fndrInfo
){};

/*CopyCStringToPascal

Converts a C string to a Pascal string. (Deprecated in Mac OS X v10.4. You should store strings as Core Foundation CFStrings instead. See CFString Reference.)

void CopyCStringToPascal (
   const char * src,
   Str255 dst
);
Parameters
src

The C string you want to convert.
dst

On output, the Pascal string.
Discussion

This function allows in-place conversion. That is, the src and dst parameters can point to the memory location.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
TextUtils.h*/

void CopyCStringToPascal (
   const char * src,
   Str255 dst
){};



/*EqualString

Compares two Pascal strings for equality, using the comparison rules of the Macintosh file system. (Deprecated in Mac OS X v10.4. Use CFStringCompare instead.)

Boolean EqualString (
   ConstStr255Param str1,
   ConstStr255Param str2,
   Boolean caseSensitive,
   Boolean diacSensitive
);
Parameters
str1

One of the Pascal strings to be compared. 
str2

The other Pascal string to be compared.
caseSensitive

A flag that indicates how to handle case-sensitive information during the comparison. If the value of caseSens is TRUE, uppercase characters are distinguished from the corresponding lowercase characters. If it is FALSE, case information is ignored. 
diacSensitive

A flag that indicates how to handle information about diacritical marks during the string comparison. If the value of diacSens is TRUE, characters with diacritical marks are distinguished from the corresponding characters without diacritical marks during the comparison. If it is FALSE, diacritical marks are ignored.
Return Value

TRUE if the two strings are equal and FALSE if they are not equal. If its value is TRUE, EqualString distinguishes uppercase characters from the corresponding lowercase characters. If its value is FALSE, EqualString ignores diacritical marks during the comparison. 
Discussion

The comparison is a simple, character-by-character value comparison. This function does not make use of any script or language information (i.e., is not localizable); it assumes the use of a Roman script system. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
StringCompare.h*/

Boolean EqualString (
   ConstStr255Param str1,
   ConstStr255Param str2,
   Boolean caseSensitive,
   Boolean diacSensitive
){};

/*MakeDataExecutable

Notifies the system that the specified data is subject to execution.

void MakeDataExecutable (
   void * baseAddress,
   unsigned long length
);
Parameters
baseAddress

The starting address of the data to be flushed.
length

The length of the data pointed to by the baseAddress parameter.
Availability
Available in Mac OS X v10.0 and later.
Declared In
OSUtils.h*/
void MakeDataExecutable (
   void * baseAddress,
   unsigned long length
){};

/*PBReadSync

Reads any number of bytes from an open file.

OSErr PBReadSync (
   ParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to a basic File Manager parameter block. 
Return Value

A result code. See “Device Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ioCompletion On input, a pointer to a completion routine. 
ioResult On output, the result code of the function. 
ioRefNum On input, a file reference number for an open file to be read. 
ioBuffer On input, a pointer to a data buffer into which the bytes are read. 
ioReqCount On input, the number of bytes requested. The value that you pass in this field should be greater than zero. 
ioActCount On output, the number of bytes actually read. 
ioPosMode On input, the positioning mode. 
ioPosOffset On input, the positioning offset. On output, the new position of the mark. 

This function attempts to read ioReqCount bytes from the open file whose access path is specified in the ioRefNum field and transfer them to the data buffer pointed to by the ioBuffer field. The position of the mark is specified by ioPosMode and ioPosOffset. If your application tries to read past the logical end-of-file, PBReadSync reads the data, moves the mark to the end-of-file, and returns eofErr as its function result. Otherwise, PBReadSync moves the file mark to the byte following the last byte read and returns noErr.

You can specify that PBReadSync read the file data 1 byte at a time until the requested number of bytes have been read or until the end-of-file is reached. To do so, set bit 7 of the ioPosMode field. Similarly, you can specify that PBReadSync should stop reading data when it reaches an application-defined newline character. To do so, place the ASCII code of that character into the high-order byte of the ioPosMode field; you must also set bit 7 of that field to enable newline mode.

When reading data in newline mode, PBReadSync returns the newline character as part of the data read and sets ioActCount to the actual number of bytes placed into the buffer (which includes the newline character). 
Version Notes

Note that on Mac OS 8 and 9, it is possible to call PBReadSync with a value of 0 in the ioReqCount field; however, this behavior is not supported on Mac OS X. On OS X, PBReadSync returns a paramErr error if the value in the ioReqCount field is 0.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes

This function is only supported for reading from open files.
Declared In
Devices.h*/

OSErr PBReadSync (
   ParmBlkPtr paramBlock
){};


/*GetPtrSize

Returns the logical size of the nonrelocatable block corresponding to a pointer.

Size GetPtrSize (
   Ptr p
);
Parameters
p

A pointer to a nonrelocatable block. 
Return Value

The logical size, in bytes, of the nonrelocatable block pointed to by p. In case of error, the function returns 0. 
Discussion

Call the function MemError to get the result code. See “Memory Manager Result Codes”. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/

Size GetPtrSize (
   Ptr p
){};


/*FindSymbol

Searches for a specific exported symbol.

OSErr FindSymbol (
   CFragConnectionID connID,
   ConstStr255Param symName,
   Ptr * symAddr,
   CFragSymbolClass * symClass
);
Parameters
connID

A connection ID. 
symName

A symbol name. 
symAddr

On return, a pointer to the address of the symbol whose name is symName. 
symClass

On return, a pointer to the class of the symbol whose name is symName. The currently recognized symbol classes are defined by the “Load Flag, Symbol Class, and Fragment Locator Constants”. 
Return Value

A result code. See “Code Fragment Manager Result Codes”.
Discussion

The FindSymbol function searches the code fragment identified by the connID parameter for the symbol whose name is specified by the symName parameter. If that symbol is found, FindSymbol returns the address of the symbol in the symAddr parameter and the class of the symbol in the symClass parameter.

Because a fragment’s code is normally exported through transition vectors to that code, the value kCodeSymbol is not returned in the PowerPC environment. You can use the other two constants to distinguish exports that represent code (of class kTVectSymbol) from those that represent general data (of class kDataSymbol). 
Availability
Available in CarbonLib 1.0 and later when Code Fragment Manager 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
CodeFragments.h*/
OSErr FindSymbol (
   CFragConnectionID connID,
   ConstStr255Param symName,
   Ptr * symAddr,
   CFragSymbolClass * symClass
){};



/*MPTaskIsPreemptive

Determines whether a task is preemptively scheduled. 

Boolean MPTaskIsPreemptive (
   MPTaskID taskID
);
Parameters
taskID

The task you want to check. Pass kMPNoID or kInvalidID if you want to specify the current task. 
Return Value

If true, the task is preemptively scheduled. If false, the task is cooperatively scheduled. 
Discussion

If you have code that may be called from either cooperative or preemptive tasks, that code can call MPTaskIsPreemptive if its actions should differ depending on its execution environment. 

Note that you can call this function from an interrupt handler. 
Version Notes

Introduced with Multiprocessing Services 2.0. 
Availability
Available in CarbonLib 1.0 and later when MultiprocessingLib 2.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Multiprocessing.h*/

Boolean MPTaskIsPreemptive (
   MPTaskID taskID
){};




/*MPCurrentTaskID

Obtains the task ID of the currently-executing preemptive task

MPTaskID MPCurrentTaskID ();
Parameters
Return Value

The task ID of the current preemptive task. See the description of the MPTaskID data type.
Discussion

Returns the ID of the current preemptive task. If called from a cooperative task, this function returns an ID which is different than the ID of any preemptive task. Nonpreemptive processes may or may not have different task IDs for each application; future implementations of this API may behave differently in this regard.

Note that you can call this function from an interrupt handler. 
Version Notes

Introduced with Multiprocessing Services 1.0. 
Availability
Available in CarbonLib 1.0 and later when MultiprocessingLib 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Multiprocessing.h*/
MPTaskID MPCurrentTaskID (){};


/*Delay

Delays execture for the specified amount of time.

void Delay (
   unsigned long numTicks,
   unsigned long * finalTicks
);
Parameters
numTicks
finalTicks
Availability
Available in Mac OS X v10.0 and later.
Declared In
OSUtils.h*/

void Delay (
   unsigned long numTicks,
   unsigned long * finalTicks
){};

/*NewCollection

Creates a new, empty collection object.

Collection NewCollection ();
Return Value

A reference to the newly created collection object. The new collection contains no items and has an owner count of 1. The NewCollection function does not return an error code; it returns NULL if it cannot create a new collection object. See the description of the Collection data type.
Discussion

The NewCollection function allocates memory for a new collection object, initializes it, and returns a reference to it. 

To create a copy of an existing collection object, use the CopyCollection function. 
Special Considerations

You are responsible for disposing of collection objects that you create with this function when you no longer need them. To dispose of a collection object, use the DisposeCollection function.
Availability
Available in CarbonLib 1.0 and later when Collections 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Collections.h*/
Collection NewCollection (){};


/*GetCollectionItem

Obtains a copy of the variable-length data associated with a collection item given the item’s collection tag and collection ID.

OSErr GetCollectionItem (
   Collection c,
   CollectionTag tag,
   SInt32 id,
   SInt32 * itemSize,
   void * itemData
);
Parameters
c

A reference to the collection object containing the item whose data you want to retrieve. The behavior of this function is undefined if you do not provide a reference to a valid collection object. 
tag

The collection tag associated with the item whose data you want to retrieve. 
id

The collection ID associated with the item whose data you want to retrieve. 
itemSize

A pointer to an SInt32 value indicating the number of bytes of data you want returned in the itemData parameter. On return, this value indicates the size in bytes of the variable-length data associated with the specified item. You may specify the constant dontWantSize for this parameter to indicate that you want to copy all the specified item’s variable-length data and you do not want to determine the size of this data. You may specify a value for the itemSize parameter that is greater than the actual number of bytes in the specified item’s variable-length data however, this function never returns in the itemData parameter more data than contained in the specified item’s variable-length data.
itemData

A pointer to a block of memory to contain the item’s data. On return, this memory contains a copy of the data associated with the specified item. You may specify the constant dontWantData for this parameter if you do not want a copy of the item’s data. 
Return Value

A result code. See “Result Codes”.
Discussion

If you do not know the size of the item you want to retrieve, you typically call this function twice. The first time you provide a pointer in the itemSize parameter to determine the size of the specified item’s data and you specify dontWantData for the itemData parameter. Then you allocate a memory block large enough to hold a copy of the item’s data. Then you call the function a second time. This time you specify the constant dontWantSize for the itemSize parameter and provide a pointer to the allocated memory block for the itemData parameter. The function then copies the data into the allocated block of memory.

To retrieve the data associated with a collection item given its collection index (rather than its collection tag and ID), use the GetIndexedCollectionItem function. 
Availability
Available in CarbonLib 1.0 and later when Collections 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Collections.h*/
OSErr GetCollectionItem (
   Collection c,
   CollectionTag tag,
   SInt32 id,
   SInt32 * itemSize,
   void * itemData
){};

/*DisposeCollection

Disposes of a collection object.

void DisposeCollection (
   Collection c
);
Parameters
c

A reference to the collection object you want to dispose of. The behavior of this function is undefined if you do not provide a reference to a valid collection object. 
Discussion

The DisposeCollection function decrements the owner count of the collection object referenced by the c parameter. If the resulting owner count is 0, this function releases the memory occupied by the collection object, and the collection object reference contained in the c parameter becomes invalid.

To create a new collection object, use the NewCollection function.

To increment the owner count of a collection object, use the CloneCollection function. To determine the owner count of an existing collection object, use the CountCollectionOwners function 
Availability
Available in CarbonLib 1.0 and later when Collections 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Collections.h*/
void DisposeCollection (
   Collection c
){};


/*PBHGetFInfoSync

Obtains information about a file. (Deprecated in Mac OS X v10.4. Use PBGetCatalogInfoSync instead.)

OSErr PBHGetFInfoSync (
   HParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the HFileParam variant of the basic HFS parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block are: 
ioNamePtr 

On input, a pointer to a pathname. If the value of the ioFDirIndex field is negative or 0, PBHGetFInfoSync returns information about the file in the volume specified by the reference number in the ioVRefNum field and having the name given here.On output, a pointer to the name of the file, if the file is open. If you do not wish the name returned, pass NULL here. 
ioVRefNum 

On input, a volume reference number or drive number for the volume containing the file, or 0 for the default volume. 
ioFRefNum 

On output, the reference number of the first access path found, if the file is open and if the ioFDirIndex field is negative or 0; if the ioFDirIndex field is positive... 
ioFDirIndex 

On input, a directory index. If this value is positive, the function returns information about the file having the directory index specified here, on the volume specified in the ioVRefNum field and in the directory specified in the ioDirID field.If this value is negative or 0, the function returns information about the file on the specified volume, having the name pointed to in the ioNamePtr field. 
ioFlAttrib 

On output, the file attributes. See File Attribute Constants for a description of the file attributes. 
ioFlFndrInfo 

On output, Finder information about the file. For a description of the FInfo data type, see the Finder Interface Reference . 
ioDirID 

On input, the parent directory ID of the file. On output, the file’s file ID. 
ioFVersNum 

On input, this field should be initialized to zero; if this field is not zero, the call will fall through to the now-obsolete Macintosh File System (MFS) code if the volume accessed is an MFS volume. 
ioFlStBlk 

On ouput, the first allocation block of the data fork. 
ioFlLgLen 

On output, the logical size (the logical end-of-file) of the file’s data fork, in bytes. 
ioFlPyLen 

On output, the physical size (the physical end-of-file) of the file’s data fork, in bytes. 
ioFlRStBlk 

On output, the first allocation block of the resource fork. 
ioFlRLgLen 

On output, the logical size of the resource fork, in bytes. 
ioFlRPyLen 

On output, the physical size of the resource fork, in bytes. 
ioFlCrDat 

On output, the date and time of the file’s creation. 
ioFlMdDat 

On output, the date and time of the file’s last modification. 

You should call PBHGetFInfoSync just before PBHSetFInfoSync , so that the current information is present in the parameter block. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBHGetFInfoSync (
   HParmBlkPtr paramBlock
){};


/*HGetState

Returns a signed byte representing the current properties of a relocatable block.

SInt8 HGetState (
   Handle h
);
Parameters
h

A handle to a relocatable block. 
Return Value

A signed byte (char) containing the flags of the master pointer for the given handle. In case of error, the value returned is meaningless. 
Discussion

The HGetState function returns a signed byte (char) containing the flags of the master pointer for the given handle. You can save this byte, change the state of any of the flags using the functions described in this section, and then restore their original states by passing the byte to the HSetState function.

You can use bit-manipulation functions on the returned signed byte to determine the value of a given attribute. Currently the following bits are used:

If an error occurs during an attempt to get the state flags of the specified relocatable block, HGetState returns the low-order byte of the result code as its function result. For example, if the handle h points to a master pointer whose value is NULL, then the signed byte returned by HGetState will contain the value –109.

You may also call the function MemError to get the result code. See “Memory Manager Result Codes”. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/

SInt8 HGetState (
   Handle h
){};



/*HSetState

Restores the properties of a relocatable block.

void HSetState (
   Handle h,
   SInt8 flags
);
Parameters
h

A handle to a relocatable block. 
flags

A signed byte (char) specifying the properties to which you want to set the relocatable block. 
Discussion

You can use HSetState to restore properties of a block after a call to HGetState. See the description of the HGetState function for a list of the currently used bits in the flags byte. Because additional bits of the flags byte could become significant in future versions of system software, use HSetState only with a byte returned by HGetState. If you need to set two or three properties of a relocatable block at once, it is better to use the functions that set individual properties than to manipulate the bits returned by HGetState and then call HSetState.

Call the function MemError to get the result code. See “Memory Manager Result Codes”. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/

void HSetState (
   Handle h,
   SInt8 flags
){};


/*FindFolder

Obtains location information for system-related directories.

OSErr FindFolder (
   short vRefNum,
   OSType folderType,
   Boolean createFolder,
   short * foundVRefNum,
   long * foundDirID
);
Parameters
vRefNum

Pass the volume reference number of the volume on which you want to locate a directory, or a constant specifying a disk or domain. The constants which you can use in this parameter are described in Disk and Domain Constants.

Note that, on Mac OS X, passing a volume reference number in this parameter does not make sense for most of the folder type selectors which you can specify in the folderType parameter. On Mac OS X, folders are "domain-oriented"; because there may be more than one domain on any given physical volume, asking for these folders on a per-volume basis yields undefined results. For example, if you were to request the Fonts folder (represented by the selector kFontsFolderType) on volume -100, are you requesting the folder /System/Library/Fonts, /Library/Fonts, or ~/Fonts? On Mac OS X you should pass a disk or domain constant in this parameter.
folderType

Pass a four-character folder type, or a constant that represents the type, for the folder you want to find; see Folder Type Constants.
createFolder

A value of type Boolean, as defined in Create Folder Flags. Pass the constant kCreateFolder to create a directory if it does not already exist; otherwise, pass the constant kDontCreateFolder. Directories inside the System Folder are created only if the System Folder directory exists. The FindFolder function will not create a System Folder directory even if you specify the kCreateFolder constant in the createFolder parameter. Passing kCreateFolder will also not create a parent folder; if the parent of the target folder does not already exist, attempting to create the target will fail.
foundVRefNum

A pointer to a value of type short. On return, the value specifies the volume reference number for the volume containing the directory specified in the folderType parameter.
foundDirID

A pointer to a value of type long. On return, the value specifies the directory ID number for the directory specified in the folderType parameter. 
Return Value

A result code. See "Folder Manager Result Codes". The result code fnfErr indicates that the type has not been found in the 'fld#' resource, or the disk doesn’t have System Folder support, or the disk does not have desktop database support for Desktop Folder—in all cases, the folder has not been found. The result code dupFNErr indicates that a file has been found instead of a folder.
Discussion

As of Mac OS 8 and later, your application can add folders to the System Folder—or nest folders within other folders—and locate the folders via the FindFolder function. Prior to Mac OS 8, your application could only use FindFolder to find folders that were immediately inside of the System Folder, and a few other special folders such as the Trash folder and the System Folder itself. Now, once a folder (and any folders that it is nested within) is described in a folder descriptor—that is, registered using the function AddFolderDescriptor —your application can use FindFolder to find the folder no matter where it is located.

Those folders you’re most likely to want to access are Preferences and Trash. For example, you might wish to check for the existence of a user’s configuration file in Preferences or, if your application runs out of disk storage when trying to save a file, check how much disk storage is taken by items in the Trash directory and report this to the user.

The specified folder used for a given volume might be located on a different volume; therefore, do not assume the volume that you specify in vRefNum and the volume returned through foundVRefNum will be the same. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Folders.h*/
OSErr FindFolder (
   short vRefNum,
   OSType folderType,
   Boolean createFolder,
   short * foundVRefNum,
   long * foundDirID
){};


/*MoreMasters

Allocates a block of master pointers in the current heap zone. (Deprecated in Mac OS X v10.4. There is no replacement function; master pointers do not need to be pre-allocated in Mac OS X.)

void MoreMasters ();
Discussion

In the application heap, a block of master pointers consists of 64 master pointers, and in the system heap, a block consists of 32 master pointers. (These values are likely to increase in future versions of system software.) When you initialize additional heap zones, you can specify the number of master pointers you want to have in a block of master pointers.

The Memory Manager automatically calls the MoreMasters function once for every new heap zone, including the application heap zone.

Call MoreMasters several times at the beginning of your program to prevent the Memory Manager from running out of master pointers in the middle of application execution. If it does run out, it allocates more, possibly causing heap fragmentation.

You should call MoreMasters at the beginning of your program enough times to ensure that the Memory Manager never needs to call it for you. For example, if your application never allocates more than 300 relocatable blocks in its heap zone, then five calls to the MoreMasters should be enough. It’s better to call MoreMasters too many times than too few. For instance, if your application usually allocates about 100 relocatable blocks but might allocate 1000 in a particularly busy session, call MoreMasters enough times to accommodate the largest amount.

If you initialize a new zone, you can specify the number of master pointers that a master pointer block should contain.

Call the MemError function to get the result code. See “Memory Manager Result Codes”.

Because MoreMasters allocates memory, you should not call it at interrupt time.

The calls to MoreMasters at the beginning of your application should be in the main code segment of your application or in a segment that the main segment never unloads. 
Carbon Porting Notes

You should instead use MoreMasterPointers.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
MacMemory.h*/
void MoreMasters (){};


/*TempNewHandle

Allocates a new relocatable block of temporary memory.

Handle TempNewHandle (
   Size logicalSize,
   OSErr * resultCode
);
Parameters
logicalSize

The requested logical size, in bytes, of the new temporary block of memory. 
resultCode

On return, the result code from the function call. See “Memory Manager Result Codes”. 
Return Value

A handle to a block of size logicalSize. If it cannot allocate a block of that size, the function returns NULL. 
Discussion

Before calling TempNewHandle, you should call TempFreeMem or TempMaxMem to make sure that there is enough free space to satisfy the request.

Because TempNewHandle might allocate memory, you should not call it at interrupt time. 
Carbon Porting Notes

Temporary memory allocations will actually come from the applications’s address space in Mac OS X. However, Carbon applications running under Mac OS 8.x will be able to get true temporary memory.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/
Handle TempNewHandle (
   Size logicalSize,
   OSErr * resultCode
){};


/*StringToFormatRec

Creates a number format specification string structure from a number format specification string that you supply in a Pascal string. (Deprecated in Mac OS X v10.4. Use CFNumberFormatterSetFormat instead.)

FormatStatus StringToFormatRec (
   ConstStr255Param inString,
   const NumberParts * partsTable,
   NumFormatString * outString
);
Parameters
inString

A Pascal string that contains the number formatting specification.

The inString parameter contains a number format specification string that specifies how numbers appear. This string contains up to three specifications, separated by semicolons. The positive number format is specified first, the negative number format is second, and the zero number format is last. If the string contains only one part, that is the format of all three types of numbers. If the string contains two parts, the first part is the format for positive and zero number values, and the second part is the format for negative numbers.

partsTable

A pointer to a structure, usually obtained from the tokens ('itl4') resource, that shows the correspondence between generic number part separators (tokens) and their localized version (for example, a thousand separator is a comma in the United States and a decimal point in France). 
outString

On output, a pointer to a NumFormatStringRec structure that contains the values that form the internal representation of the format specification. The format of the data in this structure is private. 
Return Value

A value that denotes the confidence level for the conversion that was performed. The low byte of the value is of type FormatResultType. Be sure to cast the result of StringToFormatRec to a type FormatResultType before working with it. See the description of the FormatStatus data type.
Discussion

StringToFormatRec converts a number format specification string into the internal representation contained in a number format string structure. It uses information in the current script’s tokens resource to determine the components of the number. StringToFormatRec checks the validity both of the input format string and of the number parts table (since this table can be programmed by the application). StringToFormatRec ignores spurious characters.

To obtain a handle to the number parts table from a tokens resource, use the GetIntlResourceTable function. 
Special Considerations

StringToFormatRec may move memory; your application should not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
NumberFormatting.h*/

FormatStatus StringToFormatRec (
   ConstStr255Param inString,
   const NumberParts * partsTable,
   NumFormatString * outString
){};

/*x80tod


double x80tod (
   const extended80 * x80
);
Parameters
x80
Return Value
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
fp.h*/
double x80tod (
   const extended80 * x80
){};

/*ReleaseResource

Releases the memory a resource occupies when you have finished using it.

void ReleaseResource (
   Handle theResource
);
Parameters
theResource

A handle to the resource which you wish to release.The function sets the master pointer of the resource’s handle in the resource map in memory to NULL. If your application previously obtained a handle to that resource, the handle is no longer valid. If your application subsequently calls the Resource Manager to get the released resource, the Resource Manager assigns a new handle. 

If the given resource isn’t a handle to a resource, the function does nothing, and the ResError function returns the result code resNotFound. Be aware that ReleaseResource won’t release a resource whose resChanged attribute has been set, but ResError still returns the result code noErr.
Special Considerations

This function may move or purge memory blocks in the application heap. Your application should not call this function at interrupt time.

Do not use this function to release a System resource that might be shared by several applications.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/

void ReleaseResource (
   Handle theResource
){};

/*GetIntlResourceTable

Obtains a specific word-selection, line-break, number-parts, untoken, or whitespace table from the appropriate international resource. (Deprecated in Mac OS X v10.4. There is no replacement because this function is no longer needed in Mac OS X.)

void GetIntlResourceTable (
   ScriptCode script,
   short tableCode,
   Handle * itlHandle,
   long * offset,
   long * length
);
Parameters
script

A script code, the value that specifies a particular script system. Constants for all defined script codes are listed in “Meta Script Codes”. 
tableCode

A number that specifies which table is requested. The constants for tableCode are detailed in “Table Selectors”. 
itlHandle

On return, a handle to the string-manipulation ('itl2') or tokens ('itl4') resource containing the table specified in the tableCode parameter. If the script system whose table is requested is not available, GetIntlResourceTable returns a NULL handle. 
offset

On return, a pointer to the offset (in bytes) to the specified table from the beginning of the resource. 
length

On return, a pointer to the size of the table (in bytes).
Discussion

When you provide a script code in the script parameter, and a table code in the tableCode parameter, GetIntlResourceTable returns a handle to the string-manipulation resource or tokens resource containing that table, the offset of the specified table from the beginning of the resource, and the length of the table. 

If you wish to manipulate the contents of the table you have requested, use the size returned in the length parameter to allocate a buffer, and perform a block move of the table’s contents into that buffer. 
Special Considerations

GetIntlResourceTable may move memory; your application should not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Script.h*/
void GetIntlResourceTable (
   ScriptCode script,
   short tableCode,
   Handle * itlHandle,
   long * offset,
   long * length
){};


/*StringToExtended

Converts a string representation of a number into a floating-point number, using a NumFormatStringRec structure to specify how the input number string is formatted. (Deprecated in Mac OS X v10.4. Use CFNumberFormatterCreateStringWithNumber instead.)

FormatStatus StringToExtended (
   ConstStr255Param source,
   const NumFormatString * myCanonical,
   const NumberParts * partsTable,
   extended80 * x
);
Parameters
source

A Pascal string that contains the string representation of a number. 
myCanonical

A pointer to the internal representation of the formatting information for numbers, as produced by the StringToFormatRec function. 
partsTable

A pointer to a structure, obtained from the tokens ('itl4') resource, that shows the correspondence between generic number part separators (tokens) and their localized version (for example, a thousand separator is a comma in the United States and a decimal point in France). 
x

On output, contains a pointer to the 80-bit SANE representation of the floating-point number. 
Return Value

A value that denotes the confidence level for the conversion that it performed. The low byte of the FormatStatus value is of type FormatResultType. Be sure to cast the result of StringToExtended to a type FormatResultType before working with it. StringToExtended returns an 80-bit, not a 96-bit, representation. See the description of the FormatStatus data type.
Discussion

StringToExtended uses the internal representation of number formatting information that was created by a prior call to StringToFormatRec to parse the input number string. It uses the number parts table to determine the components of the number string that is being converted. StringToExtended parses the string and then converts the string to a simple form, stripping nondigits and replacing the decimal point before converting it into a floating-point number. If the input string does not match any of the patterns, then StringToExtended parses the string as well as it can and returns a confidence level result that indicates the parsing difficulties.

To obtain a handle to the number parts table from a tokens resource, use the GetIntlResourceTable function. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
NumberFormatting.h*/

FormatStatus StringToExtended (
   ConstStr255Param source,
   const NumFormatString * myCanonical,
   const NumberParts * partsTable,
   extended80 * x
){};


/*ExtendedToString

Converts an internal floating-point representation of a number into a string that can be presented to the user, using a NumFormatStringRec structure to specify how the output number string is formatted (Deprecated in Mac OS X v10.4. Use CFNumberFormatterCreateNumberFromString instead.)

FormatStatus ExtendedToString (
   const extended80 * x,
   const NumFormatString * myCanonical,
   const NumberParts * partsTable,
   Str255 outString
);
Parameters
x

A pointer to a floating-point value in 80-bit SANE representation. 
myCanonical

A pointer to the internal representation of the formatting information for numbers, as produced by the StringToFormatRec function. 
partsTable

A pointer to a structure, obtained from the tokens ('itl4') resource, that shows the correspondence between generic number part separators (tokens) and their localized version (for example, a thousand separator is a comma in the United States and a decimal point in France). 
outString

On output, contains the number formatted according to the information in myFormatRec. 
Return Value

A value that denotes the confidence level for the conversion that it performed. The low byte of the FormatStatus value is of type FormatResultType. Be sure to cast the result of ExtendedToString to a type FormatResultType before working with it. See the description of the FormatStatus data type.
Discussion

ExtendedToString creates a string representation of a floating-point number, using the formatting information in the myFormatRec parameter (which was created by a previous call to StringToFormatRec) to determine how the number should be formatted for output. It uses the number parts table to determine the component parts of the number string.

To obtain a handle to the number parts table from a tokens resource, use the GetIntlResourceTable function. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
NumberFormatting.h*/
FormatStatus ExtendedToString (
   const extended80 * x,
   const NumFormatString * myCanonical,
   const NumberParts * partsTable,
   Str255 outString
){};

/*dtox80


void dtox80 (
   const double * x,
   extended80 * x80
);
Parameters
x
x80
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
fp.h*/
void dtox80 (
   const double * x,
   extended80 * x80
){};


/*FSpCreateResFile

Creates an empty resource fork using a file system specification (FSSpec) record. 

void FSpCreateResFile (
   const FSSpec * spec,
   OSType creator,
   OSType fileType,
   ScriptCode scriptTag
);
Parameters
spec

A pointer to a file system specification structure that indicates the name and location of the file whose resource fork is to be created. The file system specification record for files and directories is defined by the FSSpec data type.

Certain File Manager functions—those that open a file’s data fork—also take a file system specification record as a parameter. You can use the same FSSpec record in Resource Manager functions that create or open the file’s resource fork. 

If the file specified by the file system specification record doesn’t already exist (that is, if it has neither a data fork nor a resource fork), the function creates a resource file—that is, a resource fork, including a resource map. In this case the file has a zero-length data fork. The function also sets the creator, type, and script code fields of the file’s catalog information record to the specified values. 

If the file specified by the file system specification record already exists and includes a resource fork with a resource map, the function does nothing. If the data fork of the file specified by the file system specification record already exists but the file has a zero-length resource fork, the function creates an empty resource fork and resource map for the file; it also changes the creator, type, and script code fields of the catalog information record of the file to the specified values.

If your application uses Standard File Package functions, note that the StandardPutFile function returns a standard file reply record that contains a file system specification record in the sfFile field.

See the File Manager documentation for a description of the FSSpec data type.
creator

The signature of the application creating the file. Whenever your application creates a document, it assigns a creator and a file type to that document. Typically your application sets its signature as the document’s creator. 
fileType

The file type of the new file. You can set the file type to a type especially defined for your application or one of the existing general types, such as 'TEXT' for text (a stream of ASCII characters), or 'pref' for a preferences file.

The file type should be as descriptive of the file’s data format as possible. You should not use 'TEXT' as a file type unless the document contains plain ASCII characters.
scriptTag

The script code of the script system in which the Finder and standard file dialog boxes display the file’s name. For example, to specify the Roman script system, specify the constant smRoman in the scriptTag parameter. 
Discussion

Don’t use the resource fork of a file for data that is not in resource format. The Resource Manager assumes that any information in a resource fork can be interpreted according to the standard resource format described in this chapter. 

The File Manager assumes that the first block of a file’s resource fork is part of the resource header and puts information there that it uses during scavenging—for example, after the user presses the Reset switch. For this reason, if you copy a resource file, the duplicate may not be exactly like the original. 

This function is available only in System 7 and later versions of system software. If FSpCreateResFile is not available to your application, you can use the CreateResFile function or the HCreateResFile function. The HCreateResFile function is preferred over CreateResFile, which is an earlier version of HCreateResFile that is still supported but has more restricted capabilities.

Before you can work with the newly created file’s resource fork, you must use the FSpOpenResFile function to open it.

To check for errors, call the ResError function. 
Special Considerations

This function may move or purge memory blocks in the application heap. Your application should not call this function at interrupt time.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/
void FSpCreateResFile (
   const FSSpec * spec,
   OSType creator,
   OSType fileType,
   ScriptCode scriptTag
){};

/*GetScriptManagerVariable

Retrieves the value of the specified Script Manager variable.

long GetScriptManagerVariable (
   short selector
);
Parameters
selector

A value that specifies a particular Script Manager variable. To specify the Script Manager variable whose value you need, use one of the selector constants listed in “Script Manager Selectors”. 
Return Value

The current value of the specified Script Manager variable or 0 if the selector is invalid. For some valid selectors, 0 may also be a valid return value. For example, when you call GetScriptManagerVariable with a selector value of smRegionCode on a version of Macintosh system software that has been localized for the United States, it returns 0. Although GetScriptManagerVariable always returns a long integer, the actual value may be a long integer, standard integer, or signed byte. If the value is not a long integer, it is stored in the low-order word or byte of the long integer returned by GetScriptManagerVariable; the remaining bytes are set to 0.
Discussion

The Script Manager maintains a set of variables that control general settings of the text environment, including the identity of the system script and the keyboard script, and the settings of the font force flag and the international resources selection flag.

You may want access to the Script Manager variables in order to understand the current environment or to modify it. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Script.h*/


long GetScriptManagerVariable (
   short selector
){};



/*PBCreateFileIDRefSync

Establishes a file ID reference for a file.

OSErr PBCreateFileIDRefSync (
   HParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the FIDParam variant of the HFS parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.PBCreateFileIDRefSync returns the result code fidExists if a file ID reference already exists for the file.
Discussion

Most applications do not need to use this function. In general, you should track files using alias records, as described in the Alias Manager documentation. The Alias Manager uses file IDs internally as part of its search algorithms for finding the target of an alias record.

Given a volume reference number, filename, and parent directory ID, the PBCreateFileIDRefSync function creates a structure to hold the name and parent directory ID of the specified file. The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to the file’s name. 
ioVRefNum 

On input, a volume reference number for the volume containing the file. 
ioSrcDirID 

On input, the file’s parent directory ID. 
ioFileID 

On output, a file ID. If a file ID reference already exists for the file, PBCreateFileIDRefSync supplies the file ID but returns the result code fidExists. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr PBCreateFileIDRefSync (
   HParmBlkPtr paramBlock
){};

/*MoveHHi

Moves a relocatable block as high in memory as possible. (Deprecated in Mac OS X v10.4. There is no replacement function; there is no benefit to moving handles high in memory in Mac OS X.)

void MoveHHi (
   Handle h
);
Parameters
h

A handle to a relocatable block. 
Discussion

This function moves a relocatable block as high in memory as possible to help prevent heap fragmentation. The MoveHHi function attempts to move the relocatable block referenced by the handle h upward until it reaches a nonrelocatable block, a locked relocatable block, or the top of the heap.

If you plan to lock a relocatable block for a short period of time, use the MoveHHi function, which moves the block to the top of the heap and thus helps prevent heap fragmentation.

If you call MoveHHi to move a handle to a resource that has its resChanged bit set, the Resource Manager updates the resource by using the WriteResource function to write the contents of the block to disk. If you want to avoid this behavior, call the Resource Manager function SetResPurge(FALSE) before you call MoveHHi, and then call SetResPurge(TRUE) to restore the default setting.

By using the MoveHHi function on relocatable blocks you plan to allocate for short periods of time, you help prevent islands of immovable memory from accumulating in (and thus fragmenting) the heap.

Do not use the MoveHHi function to move blocks you plan to lock for long periods of time. The MoveHHi function moves such blocks to the top of the heap, perhaps preventing other blocks already at the top of the heap from moving down once they are unlocked. Instead, use the ReserveMem function before allocating such blocks, thus keeping them in the bottom partition of the heap, where they do not prevent relocatable blocks from moving.

If you frequently lock a block for short periods of time and find that calling MoveHHi each time slows down your application, you might consider leaving the block always locked and calling the ReserveMem function before allocating it.

Once you move a block to the top of the heap, be sure to lock it if you do not want the Memory Manager to move it back to the middle partition as soon as it can. (The MoveHHi function cannot move locked blocks; be sure to lock blocks after, not before, calling MoveHHi.)

Using the MoveHHi function without taking other precautionary measures to prevent heap fragmentation is useless, because even one small nonrelocatable or locked relocatable block in the middle of the heap might prevent MoveHHi from moving blocks to the top of the heap.

Call the function MemError to get the result code. See “Memory Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
MacMemory.h*/

void MoveHHi (
   Handle h
){};


/*Fix2Long

Converts a Fixed number to a LongInt number.

long Fix2Long (
   Fixed x
);
Parameters
x

The Fixed number to be converted to a long integer. 
Return Value

The long integer nearest to the Fixed number x. If x is halfway between two integers (0.5), it is rounded to the integer with the higher absolute value. 
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
FixMath.h*/

long Fix2Long (
   Fixed x
){};


/*FSpRename

Renames a file or directory. (Deprecated in Mac OS X v10.4. Use FSRenameUnicode instead.)

OSErr FSpRename (
   const FSSpec * spec,
   ConstStr255Param newName
);
Parameters
spec

A pointer to an FSSpec structure specifying the file or directory to rename. See FSSpec for a description of the FSSpec data type.
newName

The new name of the file or directory. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

If a file ID reference for the specified file exists, it remains with the renamed file.

If you want to change the name of a new copy of an existing file, you should use the FSpExchangeFiles function instead. To rename a file or directory using a long Unicode name, use the FSRenameUnicode function or one of the corresponding parameter block calls, PBRenameUnicodeSync and PBRenameUnicodeAsync. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr FSpRename (
   const FSSpec * spec,
   ConstStr255Param newName
){};


/*HLockHi

Sets the lock bit on the block.

void HLockHi (
   Handle h
);
Parameters
h

A handle to a relocatable block. 
Discussion

The HLockHi function is an alternative to using the two functions MoveHHi (deprecated in Mac OS X) and HLock. Because the MoveHHi function does not move memory in Mac OS X, there is no benefit to using this function.

This function will not return a meaningful error code. If you call HLockHi on a locked handle, it will return noErr (not memLockedErr) because it is not an error to call HLock on a locked handle. 

Do not call HLockHi on blocks in the system heap. Do not call HLockHi from a desk accessory. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/

void HLockHi (
   Handle h
){};



/*EndianU32_BtoN

Converts an unsigned 32-bit big-endian value to the equivalent value in the computer’s native format.

UInt32 EndianU32_BtoN (
   UInt32    value
);
Parameters
value

An unsigned 32-bit big-endian value.
Return Value

The equivalent value in the computer’s native format.
Availability
Available in Mac OS X v10.0 and later.
Available in QuickTime 4 and later for Windows.*/

UInt32 EndianU32_BtoN (
   UInt32    value
){};



/*EndianS16_BtoN

Converts a signed 16-bit big-endian value to the equivalent value in the computer’s native format.

SInt16 EndianS16_BtoN (
   SInt16    value
);
Parameters
value

A signed 16-bit big-endian value.
Return Value

The equivalent value in the computer’s native format.
Availability
Available in Mac OS X v10.0 and later.
Available in QuickTime 4 and later for Windows.*/
SInt16 EndianS16_BtoN (
   SInt16    value
){};

/*EndianS32_BtoN

Converts a signed 32-bit big-endian value to the equivalent value in the computer’s native format.

SInt32 EndianS32_BtoN (
   SInt32    value
);
Parameters
value

A signed 32-bit big-endian value.
Return Value

The equivalent value in the computer’s native format.
Availability
Available in Mac OS X v10.0 and later.
Available in QuickTime 4 and later for Windows.*/

SInt32 EndianS32_BtoN (
   SInt32    value
){};


/*SetPtrSize

Changes the logical size of the nonrelocatable block corresponding to a pointer.

void SetPtrSize (
   Ptr p,
   Size newSize
);
Parameters
p

A pointer to a nonrelocatable block. 
newSize

The desired new logical size, in bytes, of the nonrelocatable block. 
Discussion

An attempt to increase the size of a nonrelocatable block might fail because of a block above it that is either nonrelocatable or locked. You should be prepared for this possibility.

Call the function MemError to get the result code. See “Memory Manager Result Codes”.

Because SetPtrSize allocates memory, you should not call it at interrupt time. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/

void SetPtrSize (
   Ptr p,
   Size newSize
){};

/*CurResFile

Gets the file reference number of the current resource file.

short CurResFile ();
Return Value

The file reference number associated with the current resource file. You can call this function when your application starts up (before opening the resource fork of any other file) to get the file reference number of your application’s resource fork. If the current resource file is the System file, the function returns the actual file reference number. You can use this number or 0 with functions that take a file reference number for the System file. All Resource Manager functions recognize both 0 and the actual file reference number as referring to the System file.
Discussion

Most of the Resource Manager functions assume that the current resource file is the file on whose resource fork they should operate or, in the case of a search, the file where they should begin. In general, the current resource file is the last one whose resource fork your application opened unless you specify otherwise.

To check for errors, call the ResError function.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/
short CurResFile (){};


/*HGetVol

Determines the current default volume and default directory. (Deprecated in Mac OS X v10.4. There is no replacement function.)

OSErr HGetVol (
   StringPtr volName,
   short * vRefNum,
   long * dirID
);
Parameters
volName

On return, a pointer to the name of the default volume. If you do not want the name of the default volume returned, set this parameter to NULL. 
vRefNum

On return, a pointer to the volume reference number of the default volume. 
dirID

On return, a pointer to the directory ID of the default directory. 
Return Value

A result code. See “File Manager Result Codes”.
Version Notes

When CarbonLib is not present, the HGetVol function returns a working directory reference number in the vRefNum parameter if the previous call to HSetVol (or one of the corresponding parameter block calls) passed in a working directory reference number.
Carbon Porting Notes

Carbon applications should use HGetVol and HSetVol to get and set the default directory. the functions GetVol and SetVol, as well as working directories, are no longer supported. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr HGetVol (
   StringPtr volName,
   short * vRefNum,
   long * dirID
){};



/*SetCurrentA5

Sets the value in register A5 to the value of the low-memory global variable CurrentA5. (Deprecated in Mac OS X v10.4. There is no replacement because Mac OS X doesn’t use the A5 variable.)

long SetCurrentA5 ();
Return Value

The value in the A5 register before SetCurrentA5 changes it to the value of the low-memory global variable CurrentA5. 
Discussion

The CurrentA5 variable points to the boundary between the parameters and global variables of the current application.

You cannot reliably call SetCurrentA5 in code that executes at interrupt time unless you first guarantee that your application is the current process (for example, by calling the Process Manager function GetCurrentProcess). In general, you should call SetCurrentA5 at noninterrupt time and then pass the returned value to the interrupt code. 
Carbon Porting Notes

68K-specific. Does nothing in PowerPC native code. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OSUtils.h*/
long SetCurrentA5 (){};


/*GZSaveHnd

Returns a relocatable block to be protected during grow-zone operations. (Deprecated in Mac OS X v10.4. There is no replacement; this function does nothing in Mac OS X.)

Handle GZSaveHnd ();
Return Value

A handle to a block of memory that the Memory Manager reserves during grow-zone operations. Your grow-zone function must not move, purge, or delete this block. This function returns NULL if there is no such block. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
MacMemory.h*/
Handle GZSaveHnd (){};


/*EmptyHandle

Purges a relocatable block and sets the corresponding handle’s master pointer to NULL.

void EmptyHandle (
   Handle h
);
Parameters
h

A handle to a relocatable block. 
Discussion

The EmptyHandle function purges the relocatable block whose handle is h and sets the handle’s master pointer to NULL. The EmptyHandle function allows you to free memory taken by a relocatable block without freeing the relocatable block’s master pointer for other uses. The block whose handle is h must be unlocked but need not be purgeable.

Note that if there are multiple handles to the relocatable block, then calling the EmptyHandle function empties them all, because all of the handles share a common master pointer. When you later use ReallocateHandle to reallocate space for the block, the master pointer is updated, and all of the handles reference the new block correctly.

To purge all of the blocks in a heap zone that are marked purgeable, use the PurgeMem function.

To free the memory taken up by a relocatable block and release the block’s master pointer for other uses, use the DisposeHandle function.

Call the function MemError to get the result code. See “Memory Manager Result Codes”. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/

void EmptyHandle (
   Handle h
){};


/*SetA5

Sets the A5 register to the address specified. (Deprecated in Mac OS X v10.4. There is no replacement because Mac OS X doesn’t use the A5 variable.)

long SetA5 (
   long newA5
);
Parameters
newA5

The value to which the A5 register is to be changed. 
Return Value

The value in the A5 register before SetA5 changes it to newA5. 
Discussion

In interrupt code that accesses application global variables, use the SetA5 function first to restore a value previously saved using SetCurrentA5, and then, at the end of the code, to restore the A5 register to the value it had before the first call to SetA5. 
Carbon Porting Notes

68K-specific. Does nothing in PowerPC native code. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OSUtils.h*/

long SetA5 (
   long newA5
){};



/*DisposeGrowZoneUPP

(Deprecated in Mac OS X v10.4. There is no replacement function; heaps never grow in Mac OS X, so the grow-zone function is never called.)

void DisposeGrowZoneUPP (
   GrowZoneUPP userUPP
);
Parameters
userUPP
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
MacMemory.h*/

void DisposeGrowZoneUPP (
   GrowZoneUPP userUPP
){};


/*FixMul

Multiplies a variable of type Fixed with another variable of type Fixed or with a variable of type Fract or LongInt.

Fixed FixMul (
   Fixed a,
   Fixed b
);
Parameters
a

The first operand, which can be a variable of type Fixed or a variable of type Fract or LongInt. 
b

The second operand, which can be a variable of type Fixed or a variable of type Fract or LongInt.
Return Value

The product of the numbers in a and b. At least one of a and b should be a variable of type Fixed. 

The returned value is in the format of a LongInt if one of a or b is a LongInt. It is a Fract number if one of a or b is Fract. It is a Fixed number if both a and b are Fixed numbers.

Overflows are set to the maximum representable value with the correct sign ($80000000 for negative results and $7FFFFFFF for positive results).

Availability
Available in Mac OS X version 10.0 and later. 
Declared In
FixMath.h*/

Fixed FixMul (
   Fixed a,
   Fixed b
){};



/*EndianU16_BtoN

Converts an unsigned 16-bit big-endian value to the equivalent value in the computer’s native format.

UInt16 EndianU16_BtoN (
   UInt16    value
);
Parameters
value

An unsigned 16-bit big-endian value.
Return Value

The equivalent value in the computer’s native format.
Availability
Available in Mac OS X v10.0 and later.
Available in QuickTime 4 and later for Windows.*/

UInt16 EndianU16_BtoN (
   UInt16    value
){};


/*EndianU16_NtoB

Converts an unsigned 16-bit value in the computer’s native format to the equivalent big-endian value.

UInt16 EndianU16_NtoB (
   UInt16    value
);
Parameters
value

An unsigned 16-bit value in the computer’s native format.
Return Value

The equivalent big-endian value.
Availability
Available in Mac OS X v10.0 and later.
Available in QuickTime 4 and later for Windows.*/

UInt16 EndianU16_NtoB (
   UInt16    value
){};



/*FSpOpenRF

Opens the resource fork of a file. (Deprecated in Mac OS X v10.4. Use FSOpenFork instead.)

OSErr FSpOpenRF (
   const FSSpec * spec,
   SInt8 permission,
   short * refNum
);
Parameters
spec

A pointer to an FSSpec structure specifying the file whose resource fork is to be opened. See FSSpec for a description of the FSSpec data type.
permission

A constant indicating the type of access with which to open the file’s resource fork. For a description of the types of access you can request, see File Access Permission Constants. 
refNum

On return, a pointer to the file reference number for accessing the open resource fork. 
Return Value

A result code. See “File Manager Result Codes”. On some file systems, FSpOpenRF will return the error eofErr if you try to open the resource fork of a file for which no resource fork exists with read-only access.
Discussion

Before calling this function, you should call the Gestalt function to check that the function is available. If FSpOpenRF is not available, you can use the function HOpenRF instead. 

Note that if you wish to access named forks other than the data and resource forks, or forks larger than 2GB, you will need to use the FSOpenFork function, or one of its corresponding parameter block calls, PBOpenForkSync or PBOpenForkAsync. If you try to open a fork larger than 2GB with the FSpOpenRF function, you will receive an error message. 
Special Considerations

Generally, your application should use Resource Manager functions rather than File Manager functions to access a file’s resource fork. The FSpOpenRF function does not read the resource map into memory and is generally useful only for applications (such as utilities that copy files) that need block-level access to a resource fork. 

You should not use the resource fork of a file to hold non-resource data. Many parts of the system software assume that a resource fork always contains resource data.

Because there is no support for locking and unlocking file ranges on local disks with Carbon on Mac OS X, regardless of whether File Sharing is enabled, you cannot open more than one path to a resource fork with read/ write permission. If you try to open a more than one path to a file's resource fork with fsRdWrShPerm permission, only the first attempt will succeed. Subsequent attempts will return an invalid reference number and the ResError function will return the error opWrErr.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr FSpOpenRF (
   const FSSpec * spec,
   SInt8 permission,
   short * refNum
){};



































