#ifndef VBIGNUM_H
#define VBIGNUM_H

#include <stdint.h>
#include <vecLib/vecLibTypes.h>
#include <libkern/OSTypes.h>//hys
#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif


/*vU512

A union containing an array or structure of four vUInt32 vectors or sixteen 32-bit integers, representing a 256-bit unsigned integer. Conditional definitions provide compatibility with both PowerPC and Intel architectures; see the header file for details.

union vU512 {
   vUInt32    v[4];
   struct {
         vUInt32  v1;
         vUInt32  v2;
         vUInt32  v3;
         vUInt32  v4;
   }        vs;
   struct {
         UInt32   MSW;
         UInt32   d2;
         UInt32   d3;
         UInt32   d4;
         UInt32   d5;
         UInt32   d6;
         UInt32   d7;
         UInt32   d8;
         UInt32   d9;
         UInt32   d10;
         UInt32   d11;
         UInt32   d12;
         UInt32   d13;
         UInt32   d14;
         UInt32   d15;
         UInt32   LSW;
   }        s;
};
typedef union vU512 vU512;
Availability
Available in Mac OS X v10.0 and later.
Declared In*/
union vU512 {
   vUInt32    v[4];
   struct {
         vUInt32  v1;
         vUInt32  v2;
         vUInt32  v3;
         vUInt32  v4;
   }        vs;
   struct {
         UInt32   MSW;
         UInt32   d2;
         UInt32   d3;
         UInt32   d4;
         UInt32   d5;
         UInt32   d6;
         UInt32   d7;
         UInt32   d8;
         UInt32   d9;
         UInt32   d10;
         UInt32   d11;
         UInt32   d12;
         UInt32   d13;
         UInt32   d14;
         UInt32   d15;
         UInt32   LSW;
   }        s;
};
typedef union vU512 vU512;

/*vU1024

A union containing an array or structure of eight vUInt32 vectors or thirty-two 32-bit integers, representing a 1024-bit unsigned integer. Conditional definitions provide compatibility with both PowerPC and Intel architectures; see the header file for details.

union vU1024 {
   vUInt32    v[8];
   struct {
         vUInt32  v1;
         vUInt32  v2;
         vUInt32  v3;
         vUInt32  v4;
         vUInt32  v5;
         vUInt32  v6;
         vUInt32  v7;
         vUInt32  v8;
   }        vs;
   struct {
         UInt32   MSW;
         UInt32   d2;
         UInt32   d3;
         UInt32   d4;
         UInt32   d5;
         UInt32   d6;
         UInt32   d7;
         UInt32   d8;
         UInt32   d9;
         UInt32   d10;
         UInt32   d11;
         UInt32   d12;
         UInt32   d13;
         UInt32   d14;
         UInt32   d15;
         UInt32   d16;
         UInt32   d17;
         UInt32   d18;
         UInt32   d19;
         UInt32   d20;
         UInt32   d21;
         UInt32   d22;
         UInt32   d23;
         UInt32   d24;
         UInt32   d25;
         UInt32   d26;
         UInt32   d27;
         UInt32   d28;
         UInt32   d29;
         UInt32   d30;
         UInt32   d31;
         UInt32   LSW;
   }        s;
};
typedef union vU1024 vU1024;
Availability
Available in Mac OS X v10.0 and later.
Declared In*/
union vU1024 {
   vUInt32    v[8];
   struct {
         vUInt32  v1;
         vUInt32  v2;
         vUInt32  v3;
         vUInt32  v4;
         vUInt32  v5;
         vUInt32  v6;
         vUInt32  v7;
         vUInt32  v8;
   }        vs;
   struct {
         UInt32   MSW;
         UInt32   d2;
         UInt32   d3;
         UInt32   d4;
         UInt32   d5;
         UInt32   d6;
         UInt32   d7;
         UInt32   d8;
         UInt32   d9;
         UInt32   d10;
         UInt32   d11;
         UInt32   d12;
         UInt32   d13;
         UInt32   d14;
         UInt32   d15;
         UInt32   d16;
         UInt32   d17;
         UInt32   d18;
         UInt32   d19;
         UInt32   d20;
         UInt32   d21;
         UInt32   d22;
         UInt32   d23;
         UInt32   d24;
         UInt32   d25;
         UInt32   d26;
         UInt32   d27;
         UInt32   d28;
         UInt32   d29;
         UInt32   d30;
         UInt32   d31;
         UInt32   LSW;
   }        s;
};
typedef union vU1024 vU1024;

/*vS512

A union containing an array or structure of four vUInt32 vectors or sixteen 32-bit integers, representing a 256-bit signed integer. Conditional definitions provide compatibility with both PowerPC and Intel architectures; see the header file for details.

union vS512 {
   vUInt32    v[4];
   struct {
         vUInt32  v1;
         vUInt32  v2;
         vUInt32  v3;
         vUInt32  v4;
   }        vs;
   struct {
         SInt32   MSW;
         UInt32   d2;
         UInt32   d3;
         UInt32   d4;
         UInt32   d5;
         UInt32   d6;
         UInt32   d7;
         UInt32   d8;
         UInt32   d9;
         UInt32   d10;
         UInt32   d11;
         UInt32   d12;
         UInt32   d13;
         UInt32   d14;
         UInt32   d15;
         UInt32   LSW;
   }        s;
};
typedef union vS512 vS512;
Availability
Available in Mac OS X v10.0 and later.
Declared In*/
union vS512 {
   vUInt32    v[4];
   struct {
         vUInt32  v1;
         vUInt32  v2;
         vUInt32  v3;
         vUInt32  v4;
   }        vs;
   struct {
         SInt32   MSW;
         UInt32   d2;
         UInt32   d3;
         UInt32   d4;
         UInt32   d5;
         UInt32   d6;
         UInt32   d7;
         UInt32   d8;
         UInt32   d9;
         UInt32   d10;
         UInt32   d11;
         UInt32   d12;
         UInt32   d13;
         UInt32   d14;
         UInt32   d15;
         UInt32   LSW;
   }        s;
};
typedef union vS512 vS512;

/*vU512FullMultiply

Unsigned 512-bit multiplication; result is twice as wide as multiplicands.

extern void vU512FullMultiply(
   const vU512 * a,
   const vU512 * b,
   vU1024 * result);
Availability
Mac OS X version 10.0 and later.
Declared In*/
extern void vU512FullMultiply(
   const vU512 * a,
   const vU512 * b,
   vU1024 * result);


#ifdef __cplusplus
}
#endif

#endif 
