
#ifndef AUTHORIZATIONDB_H
#define AUTHORIZATIONDB_H

#include <Security/Authorization.h>
#include <CoreFoundation/CoreFoundation.h>

#if defined(__cplusplus)
extern "C" {
#endif

/*Policy Database Constants

Defines constants for use in settting rights and rules in the policy database.

#define kAuthorizationRightRule ";rule"
#define kAuthorizationRuleIsAdmin ";is-admin"
#define kAuthorizationRuleAuthenticateAsAdmin ";authenticate-admin"
#define kAuthorizationRuleAuthenticateAsSessionUser ";authenticate-session-user"
#define kAuthorizationRuleClassAllow "allow"
#define kAuthorizationRuleClassDeny "deny"
#define kAuthorizationComment ";comment"
Constants
kAuthorizationRightRule

Indicates a rule delegation key. Instead of specifying exact behavior, some rules are shipped with the system and may be used as delegate rules. Use this with any of the delegate rule definition constants.

Available in Mac OS X v10.3 and later.
kAuthorizationRuleIsAdmin

Indicates a delegate rule definition constant specifying that the user must be an administrator.

Available in Mac OS X v10.3 and later.
kAuthorizationRuleAuthenticateAsAdmin

Indicates a delegate rule definition constant specifying that the user must authenticate as an administrator.

Available in Mac OS X v10.3 and later.
kAuthorizationRuleAuthenticateAsSessionUser

Indicates a delegate rule definition constant specifying that the user must authenticate as the session owner (logged-in user).

Available in Mac OS X v10.3 and later.
kAuthorizationRuleClassAllow

Indicates a delegate rule definition constant that always allows the specified right.

Available in Mac OS X v10.3 and later.
kAuthorizationRuleClassDeny

Indicates a deleage rule definition constant that always denies the specified right.

Available in Mac OS X v10.3 and later.
kAuthorizationComment

Indicates comments for a rule. The comments appear in the policy database for the administrator to understand what the rule is for. Rule comments are not the same as localized descriptions which are presented to the user.

Available in Mac OS X v10.3 and later.
Discussion

You can use these constants when creating or modifying a rule in the policy database using the AuthorizationRightSet function.*/
#define kAuthorizationRightRule ";rule"
#define kAuthorizationRuleIsAdmin ";is-admin"
#define kAuthorizationRuleAuthenticateAsAdmin ";authenticate-admin"
#define kAuthorizationRuleAuthenticateAsSessionUser ";authenticate-session-user"
#define kAuthorizationRuleClassAllow "allow"
#define kAuthorizationRuleClassDeny "deny"
#define kAuthorizationComment ";comment"

/*AuthorizationRightSet

Creates or updates a right entry in the policy database.

OSStatus AuthorizationRightSet(
   AuthorizationRef authRef,
   const char *rightName,
   CFTypeRef rightDefinition,
   CFStringRef descriptionKey,
   CFBundleRef bundle,
   CFStringRef localeTableName);
Parameters
authRef

A valid authorization reference used to authorize modifications.
rightName

An ASCII character string representing the right name. The policy database does not accept wildcard right names.
rightDefinition

Either a CFDictionary containing keys defining the rules or a CFString representing the name of another right whose rules you wish to duplicate. See Policy Database Constants for some possible values.
descriptionKey

A CFString reference used as a key for looking up localized descriptions. If no localization is found, this is the description itself. This parameter is optional; pass NULL if you do not require it.
bundle

A bundle to get localizations from if not the main bundle. This parameter is optional; pass NULL if you do not require it.
localeTableName

A CFString representing a table name from which to get localizations. This parameter is optional; pass NULL if you have no localizations or you wish to use the localizations available in Localizable.strings.
Return Value

A result code. See “Authorization Services Result Codes”.
Discussion

The right you create must be an explicit right with no wildcards. Wildcard rights are for use by system administrators for site configuration.

You can use this function to create a new right or modify an existing right. For example,AuthorizationRightSet(NULL, "com.ifoo.ifax.send",
CFSTR(kAuthorizationRuleIsAdmin), CFSTR("Authorize sending  of a fax"), NULL, NULL);


adds a rule for letting administrators send faxes. This example creates a right named “com.ifoo.ifax.send” and sets the rules to require the user to be an administrator by using the kAuthorizationRuleIsAdmin constant. This example also sets a comment to let the system administrator know that the right authorizes administrators to send a fax.

To specify additional attributes for the right, you can pass an CFDictionary type in the rightDefinition parameter as shown in the following example.CFStringRef keys[2] = {CFSTR(kRightRule), CFSTR(kRightComment)};
CFStringRef values[2] = {CFSTR(kAuthorizationRuleIsAdmin), CFSTR("authorizes  sending of 1 fax message")};
CFDictionaryRef aDict;
aDict = CFDictionaryCreate(NULL, (void *)keys, (void *)values, 2,  &kCFCopyStringDictionaryKeyCallBacks, &kCFTypeDictionaryValueCallBacks);
AuthorizationRightSet(NULL, "com.ifoo.ifax.send", aDict,  CFSTR("Authorize sending  of a fax"), NULL, NULL);
CFRelease(aDict);


This call creates the same right as before, but adds a specific right comment to the rules definition.

When you specify comments, you should be specific about what you need to authorize. For example, the means of proof required for kAuthorizationRuleAuthenticateAsAdmin (a username and password) should not be included here since that rule might be configured differently.
Availability
Available in Mac OS X v10.3 and later.*/
OSStatus AuthorizationRightSet(
   AuthorizationRef authRef,
   const char *rightName,
   CFTypeRef rightDefinition,
   CFStringRef descriptionKey,
   CFBundleRef bundle,
   CFStringRef localeTableName);

/*AuthorizationRightGet

Retrieves a right definition as a dictionary.

OSStatus AuthorizationRightGet(
const char *rightName,
CFDictionaryRef *rightDefinition);
Parameters
rightName

An ASCII character string representing the rightname. Wildcard right names are valid.
rightDefinition

A reference to a dictionary. On return, this points to a dictionary of keys that define the right. Passing NULL checks if the right is defined. You should release the memory used by the returned dictionary.
Return Value

A result code. See “Authorization Services Result Codes”.
Discussion

You do not need an authorization reference to use this function because the policy database is world readable.
Availability
Available in Mac OS X v10.3 and later.*/
OSStatus AuthorizationRightGet(
const char *rightName,
CFDictionaryRef *rightDefinition);

#if defined(__cplusplus)
}
#endif

#endif 

