#ifndef MOVIES_H
#define MOVIES_H

#ifndef CARBON_H
#include <Carbon/Carbon.h>
#endif

#ifndef COREAUDIO_H
#include <CoreAudio/CoreAudio.h>
#endif

#ifndef IMAGECOMPRESSION_H
#include <QuickTime/ImageCompression.h>
#endif

#ifndef  QUICKTIMEERRORS_H
#include <QuickTime/QuickTimeErrors.h>
#endif


#include <HYS/QuickTime/Movies.h>
#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Tween Type and Tween Component Subtype Constants

The following constants specify tween types. If a tween type is identified by a four-character code, the four-character code is also the component subtype of the tween component that is invoked for the tween. If a tween type is identified by a numeric constant, such as kTweenTypeShort, tweens of that type are processed by QuickTime rather than by a tween component.
enum {
    kTweenTypeShort = 1,
    kTweenTypeLong = 2,
    kTweenTypeFixed = 3,
    kTweenTypePoint = 4,
    kTweenTypeQDRect = 5,
    kTweenTypeQDRegion = 6,
    kTweenTypeMatrix = 7,
    kTweenTypeRGBColor = 8,
    kTweenTypeGraphicsModeWithRGBColor = 9,
    kTweenTypeQTFloatSingle = 10,
    kTweenTypeQTFloatDouble = 11,
    kTweenTypeFixedPoint = 12,
    kTweenType3dScale = FOUR_CHAR_CODE('3sca'),
    kTweenType3dTranslate = FOUR_CHAR_CODE('3tra'),
    kTweenType3dRotate = FOUR_CHAR_CODE('3rot'),
    kTweenType3dRotateAboutPoint = FOUR_CHAR_CODE('3rap'),
    kTweenType3dRotateAboutAxis = FOUR_CHAR_CODE('3rax'),
    kTweenType3dRotateAboutVector = FOUR_CHAR_CODE('3rvc'),
    kTweenType3dQuaternion = FOUR_CHAR_CODE('3qua'),
    kTweenType3dMatrix = FOUR_CHAR_CODE('3mat'),
    kTweenType3dCameraData = FOUR_CHAR_CODE('3cam'),
    kTweenType3dSoundLocalizationData = FOUR_CHAR_CODE('3slc'),
    kTweenTypePathToMatrixTranslation = FOUR_CHAR_CODE('gxmt'),
    kTweenTypePathToMatrixTranslationAndRotation =FOUR_CHAR_CODE('gxmr'),
    kTweenTypePathToFixedPoint = FOUR_CHAR_CODE('gxfp'),
    kTweenTypePathXtoY = FOUR_CHAR_CODE('gxxy'),
    kTweenTypePathYtoX = FOUR_CHAR_CODE('gxyx'),
    kTweenTypeAtomList = FOUR_CHAR_CODE('atom'),
    kTweenTypePolygon = FOUR_CHAR_CODE('poly')
    kTweenTypePathToMatrixRotation = FOUR_CHAR_CODE('gxpr'),
    kTweenTypeMultiMatrix = FOUR_CHAR_CODE('mulm'),
    kTweenTypeSpin = FOUR_CHAR_CODE('spin'),
    kTweenType3dMatrixNonLinear = FOUR_CHAR_CODE('3nlr'),
    kTweenType3dVRObject = FOUR_CHAR_CODE('3vro')
    };*/

enum {
    kTweenTypeShort = 1,
    kTweenTypeLong = 2,
    kTweenTypeFixed = 3,
    kTweenTypePoint = 4,
    kTweenTypeQDRect = 5,
    kTweenTypeQDRegion = 6,
    kTweenTypeMatrix = 7,
    kTweenTypeRGBColor = 8,
    kTweenTypeGraphicsModeWithRGBColor = 9,
    kTweenTypeQTFloatSingle = 10,
    kTweenTypeQTFloatDouble = 11,
    kTweenTypeFixedPoint = 12,
    kTweenType3dScale = FOUR_CHAR_CODE('3sca'),
    kTweenType3dTranslate = FOUR_CHAR_CODE('3tra'),
    kTweenType3dRotate = FOUR_CHAR_CODE('3rot'),
    kTweenType3dRotateAboutPoint = FOUR_CHAR_CODE('3rap'),
    kTweenType3dRotateAboutAxis = FOUR_CHAR_CODE('3rax'),
    kTweenType3dRotateAboutVector = FOUR_CHAR_CODE('3rvc'),
    kTweenType3dQuaternion = FOUR_CHAR_CODE('3qua'),
    kTweenType3dMatrix = FOUR_CHAR_CODE('3mat'),
    kTweenType3dCameraData = FOUR_CHAR_CODE('3cam'),
    kTweenType3dSoundLocalizationData = FOUR_CHAR_CODE('3slc'),
    kTweenTypePathToMatrixTranslation = FOUR_CHAR_CODE('gxmt'),
    kTweenTypePathToMatrixTranslationAndRotation =FOUR_CHAR_CODE('gxmr'),
    kTweenTypePathToFixedPoint = FOUR_CHAR_CODE('gxfp'),
    kTweenTypePathXtoY = FOUR_CHAR_CODE('gxxy'),
    kTweenTypePathYtoX = FOUR_CHAR_CODE('gxyx'),
    kTweenTypeAtomList = FOUR_CHAR_CODE('atom'),
    kTweenTypePolygon = FOUR_CHAR_CODE('poly'),
    kTweenTypePathToMatrixRotation = FOUR_CHAR_CODE('gxpr'),
    kTweenTypeMultiMatrix = FOUR_CHAR_CODE('mulm'),
    kTweenTypeSpin = FOUR_CHAR_CODE('spin'),
    kTweenType3dMatrixNonLinear = FOUR_CHAR_CODE('3nlr'),
    kTweenType3dVRObject = FOUR_CHAR_CODE('3vro')
    };


/*QTParameterDialogOptions

Abst_QTParameterDialogOptions

typedef long QTParameterDialogOptions;
Availability
Available in Mac OS X v10.0 and later.*/
typedef long QTParameterDialogOptions;

/*QTParameterDialog

Abst_QTParameterDialog

typedef long QTParameterDialog;
Availability
Available in Mac OS X v10.0 and later.*/
typedef long QTParameterDialog;


/*Discussion

The following sample code shows how to retrieve the connection speed setting from the QuickTime preferences:
struct ConnectionSpeedPrefsRecord {
   long connectionSpeed;
};
typedef struct ConnectionSpeedPrefsRecord ConnectionSpeedPrefsRecord;
. . .
OSErr                       err;
QTAtomContainer             prefs;
QTAtom                      prefsAtom;
long                        dataSize;
Ptr                         atomData;
ConnectionSpeedPrefsRecord  prefrec;
err =GetQuickTimePreference(ConnectionSpeedPrefsType, &amp;prefs);
if (err ==noErr) {
    prefsAtom =QTFindChildByID(prefs, kParentAtomIsContainer,
                                  ConnectionSpeedPrefsType, 1, nil);
    if (!prefsAtom) {
        // set the default setting to 28.8kpbs
        prefrec.connectionSpeed =kDataRate288ModemRate;
    } else {
        err =QTGetAtomDataPtr(prefs, prefsAtom, &dataSize,
                                                         &atomData);
        if (dataSize !=sizeof(ConnectionSpeedPrefsRecord)) {
            // the prefs record wasn't the right size,
            // so it must be corrupt -- set to the default
            prefrec.connectionSpeed =kDataRate288ModemRate;
        } else {
            // everything was fine -- read the connection speed
            prefrec =*(ConnectionSpeedPrefsRecord *)atomData;
        }
    }
    QTDisposeAtomContainer(prefs);
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
struct ConnectionSpeedPrefsRecord {
   long connectionSpeed;
};
typedef struct ConnectionSpeedPrefsRecord ConnectionSpeedPrefsRecord;


/*Interesting Times Flags

The interestingTimeFlags parameter for the interesting time functions (GetMovieNextInterestingTime, GetTrackNexttInterestingTime, and GetMediaNextInterestingTime ) specifies a set of bit flags that specify search criteria. Normally, you use one of the interesting time functions to step forward to the next frame.

These functions work well for most media types, including video and text. However, because QuickTime stores an entire MPEG stream as a single sample, stepping to the next sample skips to the end of the sequence. To solve this problem, QuickTime introduced a new flag for the interesting time calls: nextTimeStep. This flag returns the time of the next frame, even if there are multiple frames per sample, for all media types including video, text, and MPEG. Applications that implement single stepping capabilities should always use this flag instead of nextTimeMediaSample.
enum {
    nextTimeStep    = 1 << 4
};

Term	
Definition

nextTimeStep	
Searches for the next frame in the movie's media. Set this flag to 1 to step to the next frame.*/

enum {
    nextTimeStep    = 1 << 4
};



 

/*GetMovieImporter Flags

Constants that represent <codeVoice>GetMovieImporter</codeVoice> flags.

enum {
   kGetMovieImporterValidateToFind = 1L << 0,
   kGetMovieImporterAllowNewFile = 1L << 1,
   kGetMovieImporterDontConsiderGraphicsImporters = 1L << 2,
   kGetMovieImporterDontConsiderFileOnlyImporters = 1L << 6,
   kGetMovieImporterAutoImportOnly = 1L << 10 /*reject aggressive movie importers which have dontAutoFileMovieImport set*
};
Declared In
Movies.h*/
enum {
   kGetMovieImporterValidateToFind = 1L << 0,
   kGetMovieImporterAllowNewFile = 1L << 1,
   kGetMovieImporterDontConsiderGraphicsImporters = 1L << 2,
   kGetMovieImporterDontConsiderFileOnlyImporters = 1L << 6,
   kGetMovieImporterAutoImportOnly = 1L << 10 /* reject aggressive movie importers which have dontAutoFileMovieImport set*/
};

/*GetMovieIndTrackType Values

Constants passed to GetMovieIndTrackType.

enum {
   movieTrackMediaType           = 1 << 0,
   movieTrackCharacteristic      = 1 << 1,
   movieTrackEnabledOnly         = 1 << 2
};
Declared In
Movies.h*/
enum {
   movieTrackMediaType           = 1 << 0,
   movieTrackCharacteristic      = 1 << 1,
   movieTrackEnabledOnly         = 1 << 2
};

/*FlattenMovieData Values

Constants passed to FlattenMovieData.

enum {
   flattenAddMovieToDataFork     = 1L << 0,
   flattenActiveTracksOnly       = 1L << 2,
   flattenDontInterleaveFlatten  = 1L << 3,
   flattenFSSpecPtrIsDataRefRecordPtr = 1L << 4,
   flattenCompressMovieResource  = 1L << 5,
   flattenForceMovieResourceBeforeMovieData = 1L << 6
};*/

enum {
   flattenAddMovieToDataFork     = 1L << 0,
   flattenActiveTracksOnly       = 1L << 2,
   flattenDontInterleaveFlatten  = 1L << 3,
   flattenFSSpecPtrIsDataRefRecordPtr = 1L << 4,
   flattenCompressMovieResource  = 1L << 5,
   flattenForceMovieResourceBeforeMovieData = 1L << 6
};



/*CreateMovieFile Values

Constants passed to CreateMovieFile.

enum {
   createMovieFileDeleteCurFile  = 1L << 31,
   createMovieFileDontCreateMovie = 1L << 30,
   createMovieFileDontOpenFile   = 1L << 29,
   createMovieFileDontCreateResFile = 1L << 28
};
Constants
createMovieFileDontOpenFile

Controls whether the function opens the new movie file. If you set this flag to 1, the Movie Toolbox does not open the new movie file. In this case, the function ignores the outDataHandler parameter. If you set this flag to 0, the Movie Toolbox opens the new movie file and returns its reference number into the field referenced by outDataHandler. 

Available in Mac OS X v10.0 and later.*/
enum {
   createMovieFileDeleteCurFile  = 1L << 31,
   createMovieFileDontCreateMovie = 1L << 30,
   createMovieFileDontOpenFile   = 1L << 29,
   createMovieFileDontCreateResFile = 1L << 28
};



/*Movie Controller Options

Constants that represent options for movie controllers.

enum {
   kMCIEEnabledButtonPicture     = 1,
   kMCIEDisabledButtonPicture    = 2,
   kMCIEDepressedButtonPicture   = 3,
   kMCIEEnabledSizeBoxPicture    = 4,
   kMCIEDisabledSizeBoxPicture   = 5,
   kMCIEEnabledUnavailableButtonPicture = 6,
   kMCIEDisabledUnavailableButtonPicture = 7,
   kMCIESoundSlider              = 128,
   kMCIESoundThumb               = 129,
   kMCIEColorTable               = 256,
   kMCIEIsFlatAppearance         = 257,
   kMCIEDoButtonIconsDropOnDepress = 258
};
enum {
   mcFlagSuppressMovieFrame      = 1 << 0,
   mcFlagSuppressStepButtons     = 1 << 1,
   mcFlagSuppressSpeakerButton   = 1 << 2,
   mcFlagsUseWindowPalette       = 1 << 3,
   mcFlagsDontInvalidate         = 1 << 4,
   mcFlagsUseCustomButton        = 1 << 5
};
enum {
   mcInfoUndoAvailable           = 1 << 0,
   mcInfoCutAvailable            = 1 << 1,
   mcInfoCopyAvailable           = 1 << 2,
   mcInfoPasteAvailable          = 1 << 3,
   mcInfoClearAvailable          = 1 << 4,
   mcInfoHasSound                = 1 << 5,
   mcInfoIsPlaying               = 1 << 6,
   mcInfoIsLooping               = 1 << 7,
   mcInfoIsInPalindrome          = 1 << 8,
   mcInfoEditingEnabled          = 1 << 9,
   mcInfoMovieIsInteractive      = 1 << 10
};
Constants
kMCIESoundThumb

The indicator on the sound slider. 

Available in Mac OS X v10.0 and later.
mcFlagSuppressMovieFrame

If this flag is set to 1, the controller does not display a frame around the movie. By default, this flag is set to 0. 

Available in Mac OS X v10.0 and later.
mcFlagSuppressStepButtons

If this flag is set to 1, the controller does not display the step buttons. By default, this flag is set to 0. 

Available in Mac OS X v10.0 and later.
mcFlagSuppressSpeakerButton

If this flag is set to 1, the controller does not display the speaker button. By default, this flag is set to 0. 

Available in Mac OS X v10.0 and later.
mcFlagsUseWindowPalette

If this flag is set to 1, the movie controller does not manage the window palette. This ensures that a movie's colors are reproduced as accurately as possible. This flag is particularly useful for movies with custom color tables. By default, this flag is set to 0. 

Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/
enum {
   kMCIEEnabledButtonPicture     = 1,
   kMCIEDisabledButtonPicture    = 2,
   kMCIEDepressedButtonPicture   = 3,
   kMCIEEnabledSizeBoxPicture    = 4,
   kMCIEDisabledSizeBoxPicture   = 5,
   kMCIEEnabledUnavailableButtonPicture = 6,
   kMCIEDisabledUnavailableButtonPicture = 7,
   kMCIESoundSlider              = 128,
   kMCIESoundThumb               = 129,
   kMCIEColorTable               = 256,
   kMCIEIsFlatAppearance         = 257,
   kMCIEDoButtonIconsDropOnDepress = 258
};//movies.h
enum {
   mcFlagSuppressMovieFrame      = 1 << 0,
   mcFlagSuppressStepButtons     = 1 << 1,
   mcFlagSuppressSpeakerButton   = 1 << 2,
   mcFlagsUseWindowPalette       = 1 << 3,
   mcFlagsDontInvalidate         = 1 << 4,
   mcFlagsUseCustomButton        = 1 << 5
};
enum {
   mcInfoUndoAvailable           = 1 << 0,
   mcInfoCutAvailable            = 1 << 1,
   mcInfoCopyAvailable           = 1 << 2,
   mcInfoPasteAvailable          = 1 << 3,
   mcInfoClearAvailable          = 1 << 4,
   mcInfoHasSound                = 1 << 5,
   mcInfoIsPlaying               = 1 << 6,
   mcInfoIsLooping               = 1 << 7,
   mcInfoIsInPalindrome          = 1 << 8,
   mcInfoEditingEnabled          = 1 << 9,
   mcInfoMovieIsInteractive      = 1 << 10
};

/*Text Properties

Constants that represent the properties of text.

enum {
   / set property parameter / get property parameter
   kTextTextHandle               = 1,
   / Handle / preallocated Handle
   kTextTextPtr                  = 2,
   / Pointer
   kTextTEStyle                  = 3,
   / TextStyle  / TextStyle 
   kTextSelection                = 4,
   / long [2] / long [2]
   kTextBackColor                = 5,
   / RGBColor  / RGBColor /
   kTextForeColor                = 6,
   / RGBColor  / RGBColor /
   kTextFace                     = 7,
   / long / long /
   kTextFont                     = 8,
   / long / long /
   kTextSize                     = 9,
   / long / long /
   kTextAlignment                = 10,
   / short  / short /
   kTextHilite                   = 11,
   / hiliteRecord  / hiliteRecord /
   kTextDropShadow               = 12,
   / dropShadowRecord  / dropShadowRecord /
   kTextDisplayFlags             = 13,
   / long / long /
   kTextScroll                   = 14,
   / TimeValue  / TimeValue /
   kTextRelativeScroll           = 15,
   / Point /
   kTextHyperTextFace            = 16,
   / hyperTextSetFace  / hyperTextSetFace /
   kTextHyperTextColor           = 17,
   / hyperTextSetColor  / hyperTextSetColor /
   kTextKeyEntry                 = 18,
   / short/
   kTextMouseDown                = 19,
   / Point /
   kTextTextBox                  = 20,
   / Rect  / Rect /
   kTextEditState                = 21,
   / short / short /
   kTextLength                   = 22    /       / long /
};
enum {
   dfDontDisplay                 = 1 << 0,
   / Don't display the text/
   dfDontAutoScale               = 1 << 1,
   / Don't scale text as track bounds grows or shrinks/
   dfClipToTextBox               = 1 << 2,
   / Clip update to the textbox/
   dfUseMovieBGColor             = 1 << 3,
   / Set text background to movie's background color/
   dfShrinkTextBoxToFit          = 1 << 4,
   / Compute minimum box to fit the sample/
   dfScrollIn                    = 1 << 5,
   / Scroll text in until last of text is in view /
   dfScrollOut                   = 1 << 6,
   / Scroll text out until last of text is gone (if both set,
   scroll in then out)/
   dfHorizScroll                 = 1 << 7,
   / Scroll text horizontally (otherwise it's vertical)/
   dfReverseScroll               = 1 << 8,
   / vert: scroll down rather than up; horiz: scroll backwards (justfication dependent)/
   dfContinuousScroll            = 1 << 9,
   / new samples cause previous samples to scroll out /
   dfFlowHoriz                   = 1 << 10,
   / horiz scroll text flows in textbox rather than extend to right /
   dfContinuousKaraoke           = 1 << 11,
   / ignore begin offset,
   hilite everything up to the end offset(karaoke)/
   dfDropShadow                  = 1 << 12,
   / display text with a drop shadow /
   dfAntiAlias                   = 1 << 13,
   / attempt to display text anti aliased/
   dfKeyedText                   = 1 << 14,
   / key the text over background/
   dfInverseHilite               = 1 << 15,
   / Use inverse hiliting rather than using hilite color/
   dfTextColorHilite             = 1 << 16 / changes text color in place of hiliting. /
};
Constants
kTextSelection

Long [2] long [2]. 

Available in Mac OS X v10.0 and later.
kTextScroll

The text scroll position. 

Available in Mac OS X v10.0 and later.
kTextRelativeScroll

Point. 

Available in Mac OS X v10.0 and later.
kTextHyperTextFace

HyperTextSetFace hyperTextSetFace. 

Available in Mac OS X v10.0 and later.
kTextHyperTextColor

HyperTextSetColor hyperTextSetColor. 

Available in Mac OS X v10.0 and later.
kTextKeyEntry

Short. 

Available in Mac OS X v10.0 and later.
kTextMouseDown

Point. 

Available in Mac OS X v10.0 and later.
kTextTextBox

Rect Rect. 

Available in Mac OS X v10.0 and later.
kTextEditState

Short short. 

Available in Mac OS X v10.0 and later.
kTextLength

Long. 

Available in Mac OS X v10.0 and later.
dfDontDisplay

Does not display the specified sample. 

Available in Mac OS X v10.0 and later.
dfDontAutoScale

Does not scale the text if the track bounds increase. 

Available in Mac OS X v10.0 and later.
dfClipToTextBox

Clips to just the text box. This is useful if the text overlays the video. 

Available in Mac OS X v10.0 and later.
dfUseMovieBGColor

Set text background to movie’s background color. 

Available in Mac OS X v10.0 and later.
dfShrinkTextBoxToFit

Recalculates size of the textBox parameter to just fit the given text and stores this rectangle with the text data. 

Available in Mac OS X v10.0 and later.
dfScrollIn

Scrolls the text in until the last of the text is in view. This flag is associated with the scrollDelay parameter. 

Available in Mac OS X v10.0 and later.
dfScrollOut

Scrolls text out until the last of the text is out of view. This flag is associated with the scrollDelay parameter. If both dfScrollIn and dfScrollOut are set, the text is scrolled in, then out. 

Available in Mac OS X v10.0 and later.
dfHorizScroll

Scrolls a single line of text horizontally. If the dfHorizScroll flag is not set, then the scrolling is vertical. 

Available in Mac OS X v10.0 and later.
dfReverseScroll

If set, scrolls vertically down, rather than up. If not set, horizontal scrolling proceeds toward the left rather than toward the right. 

Available in Mac OS X v10.0 and later.*/
enum {
   /* set property parameter / get property parameter*/
   kTextTextHandle               = 1,
   /* Handle / preallocated Handle*/
   kTextTextPtr                  = 2,
   /* Pointer*/
   kTextTEStyle                  = 3,
   /* TextStyle * / TextStyle **/
   kTextSelection                = 4,
   /* long [2] / long [2]*/
   kTextBackColor                = 5,
   /* RGBColor * / RGBColor **/
   kTextForeColor                = 6,
   /* RGBColor * / RGBColor **/
   kTextFace                     = 7,
   /* long / long **/
   kTextFont                     = 8,
   /* long / long **/
   kTextSize                     = 9,
   /* long / long **/
   kTextAlignment                = 10,
   /* short * / short **/
   kTextHilite                   = 11,
   /* hiliteRecord * / hiliteRecord **/
   kTextDropShadow               = 12,
   /* dropShadowRecord * / dropShadowRecord **/
   kTextDisplayFlags             = 13,
   /* long / long **/
   kTextScroll                   = 14,
   /* TimeValue * / TimeValue **/
   kTextRelativeScroll           = 15,
   /* Point **/
   kTextHyperTextFace            = 16,
   /* hyperTextSetFace * / hyperTextSetFace **/
   kTextHyperTextColor           = 17,
   /* hyperTextSetColor * / hyperTextSetColor **/
   kTextKeyEntry                 = 18,
   /* short*/
   kTextMouseDown                = 19,
   /* Point **/
   kTextTextBox                  = 20,
   /* Rect * / Rect **/
   kTextEditState                = 21,
   /* short / short **/
   kTextLength                   = 22    /*       / long **/
};
enum {
   dfDontDisplay                 = 1 << 0,
   /* Don't display the text*/
   dfDontAutoScale               = 1 << 1,
   /* Don't scale text as track bounds grows or shrinks*/
   dfClipToTextBox               = 1 << 2,
   /* Clip update to the textbox*/
   dfUseMovieBGColor             = 1 << 3,
   /* Set text background to movie's background color*/
   dfShrinkTextBoxToFit          = 1 << 4,
   /* Compute minimum box to fit the sample*/
   dfScrollIn                    = 1 << 5,
   /* Scroll text in until last of text is in view */
   dfScrollOut                   = 1 << 6,
   /* Scroll text out until last of text is gone (if both set,
   scroll in then out)*/
   dfHorizScroll                 = 1 << 7,
   /* Scroll text horizontally (otherwise it's vertical)*/
   dfReverseScroll               = 1 << 8,
   /* vert: scroll down rather than up; horiz: scroll backwards (justfication dependent)*/
   dfContinuousScroll            = 1 << 9,
   /* new samples cause previous samples to scroll out */
   dfFlowHoriz                   = 1 << 10,
   /* horiz scroll text flows in textbox rather than extend to right */
   dfContinuousKaraoke           = 1 << 11,
   /* ignore begin offset,
   hilite everything up to the end offset(karaoke)*/
   dfDropShadow                  = 1 << 12,
   /* display text with a drop shadow */
   dfAntiAlias                   = 1 << 13,
   /* attempt to display text anti aliased*/
   dfKeyedText                   = 1 << 14,
   /* key the text over background*/
   dfInverseHilite               = 1 << 15,
   /* Use inverse hiliting rather than using hilite color*/
   dfTextColorHilite             = 1 << 16 /* changes text color in place of hiliting. */
};



/*Audio Property IDs

The following constants identify audio properties.
enum {
    kQTAudioPropertyID_Gain = 'gain',
    kQTAudioPropertyID_Mute = 'mute',
    kQTAudioPropertyID_Balance = 'bala',
    kQTAudioPropertyID_Fade = 'fade',
    kQTAudioPropertyID_SummaryChannelLayout = 'clay',
    kQTAudioPropertyID_DeviceChannelLayout = 'dcly',
    kQTAudioPropertyID_FormatString = 'fstr',
    kQTAudioPropertyID_ChannelLayoutString = 'lstr',
    kQTAudioPropertyID_SampleRateString = 'rstr',
    kQTAudioPropertyID_SampleSizeString = 'sstr',
    kQTAudioPropertyID_BitRateString = 'bstr',
    kQTAudioPropertyID_SummaryString = 'asum'
};

kQTAudioPropertyID_Gain = 'gain'

Used to get and set a Float32 value that represents the audio gain of a movie or track. The gain level is multiplicative; eg. 0.0 is silent, 0.5 is –6dB, 1.0 is 0dB (ie. the audio from the movie is not modified), 2.0 is +6dB, etc. The gain level can be set higher than 1.0 in order to allow quiet movies and tracks to be boosted in volume. Settings higher than 1.0 may result in audio clipping, of course. The setting is not stored in the movie or track; it is used only until the movie or track is disposed. 
kQTAudioPropertyID_Mute = 'mute'

Used to get and set a Boolean value that indicates the audio mute state of a movie or track. If TRUE, the movie or track is muted. The setting is not stored in the movie or track; it is used only until the movie or track is disposed.
kQTAudioPropertyID_Balance = 'bala'

Used to get and set a Float32 value that represents the audio balance of a movie. It is supported only for movies, not tracks. –1.0 means full left, 0.0 means centered, and 1.0 means full right. The setting is not stored in the movie; it is used only until the movie is disposed.
kQTAudioPropertyID_Fade = 'fade'

Used to get and set a Float32 value that represents the audio fade of a movie. It is supported only for movies, not tracks. 1.0 means full forward, 0.0 means centered, and –1.0 means full rearward. The setting is not stored in the movie; it is used only until the movie is disposed.
kQTAudioPropertyID_SummaryChannelLayout = 'clay'

Used to get an AudioChannelLayout value that represents the summary audio channel layout of a movie or other grouping of audio streams. All like-labelled channels are combined, so there are no duplicates. For example, if there is a stereo (L/R) track, 5 single-channel tracks marked Left, Right, Left Surround, Right Surround and Center, and a 4 channel track marked L/R/Ls/Rs, then the summary AudioChannelLayout will be L/R/Ls/Rs/C—It will _not_ be L/R/L/R/Ls/Rs/C/L/R/Ls/Rs. This is a variable-size property, because it it may contain an array of channel descriptions. You must get the size by calling a function such as QTGetMoviePropertyInfo, allocate a structure of that size, and then get the property.
kQTAudioPropertyID_DeviceChannelLayout = 'dcly'

Used to get an AudioChannelLayout value that represents the audio channel layout of the device a movie is playing to. This is a variable-size property, because it it may contain an array of channel descriptions. You must get the size by calling a function such as QTGetMoviePropertyInfo, allocate a structure of that size, and then get the property.
kQTAudioPropertyID_FormatString = 'fstr'

Used with kQTPropertyClass_Audio to get a CFStringRef value containing a localized, human readable string that describes an audio format; for example, “MPEG Layer 3.” You may get this property from a SoundDescription handle by calling QTSoundDescriptionGetProperty or from a StandardAudioCompression (scdi or audi) component instance by calling QTGetComponentProperty.
kQTAudioPropertyID_ChannelLayoutString = 'lstr'

Used with kQTPropertyClass_Audio to get a CFStringRef value containing a localized, human readable string that describes an audio channel layout; for example, “5.0 (L R C Ls Rs).” You may get this property from a SoundDescription handle by calling QTSoundDescriptionGetProperty or from a StandardAudioCompression (scdi or audi) component instance by calling QTGetComponentProperty.
kQTAudioPropertyID_SampleRateString = 'rstr'

Used to get a CFStringRef value containing a localized, human readable string that describes an audio sample rate; for example, “44.100 kHz.” You may get this property from a SoundDescription handle by calling QTSoundDescriptionGetProperty or from a StandardAudioCompression (scdi or audi) component instance by calling QTGetComponentProperty.
kQTAudioPropertyID_SampleSizeString = 'sstr'

Used to get a CFStringRef value containing a localized, human readable string that describes an audio sample size; for example, “24-bit.” This property will return a valid string only if the audio format is uncompressed (LPCM). You may get this property from a SoundDescription handle by calling QTSoundDescriptionGetProperty or from a StandardAudioCompression (scdi or audi) component instance by calling QTGetComponentProperty.
kQTAudioPropertyID_BitRateString = 'bstr'

Used to get a CFStringRef value containing a localized, human readable string that describes an audio bit rate; for example, “12 kbps.” You may get this property from a StandardAudioCompression (scdi or audi) component instance by calling QTGetComponentProperty.
kQTAudioPropertyID_SummaryString = 'asum'

Used to get a CFStringRef value containing a localized, human readable string that summarizes an audio format; for example, “16-bit Integer (Big Endian), Stereo (L R), 48.000 kHz.” You may get this property from a SoundDescription handle by calling QTSoundDescriptionGetProperty or from a StandardAudioCompression (scdi or audi) component instance by calling QTGetComponentProperty.
The following constants identify audio properties.*/
enum {
    kQTAudioPropertyID_Gain = 'gain',
    kQTAudioPropertyID_Mute = 'mute',
    kQTAudioPropertyID_Balance = 'bala',
    kQTAudioPropertyID_Fade = 'fade',
    kQTAudioPropertyID_SummaryChannelLayout = 'clay',
    kQTAudioPropertyID_DeviceChannelLayout = 'dcly',
    kQTAudioPropertyID_FormatString = 'fstr',
    kQTAudioPropertyID_ChannelLayoutString = 'lstr',
    kQTAudioPropertyID_SampleRateString = 'rstr',
    kQTAudioPropertyID_SampleSizeString = 'sstr',
    kQTAudioPropertyID_BitRateString = 'bstr',
    kQTAudioPropertyID_SummaryString = 'asum'
};



/*Movie Audio Mixes

Three new four-character constants define the mix of audio channels for several functions:
kQTAudioMeter_StereoMix = 'stmx'
kQTAudioMeter_DeviceMix = kQTAudioPropertyID_DeviceChannelLayout = 'dcly'
kQTAudioMeter_MonoMix = 'momx'

kQTAudioMeter_StereoMix

Meter a stereo (two-channel) mix of the enabled sound tracks in the movie. This option is offered only for MovieAudioFrequencyMetering.
kQTAudioMeter_DeviceMix

Meter the movie’s mix to the AudioChannelLayout of the device the movie is playing to. To determine the channel layout of this mix, you call the kAudioPropertyID_DeviceChannelLayout movie property.
kQTAudioMeter_MonoMix

Meter the movie as if it had been mixed to monaural. This option is offered only for MovieAudioFrequencyMetering.

The constants listed above are passed by the following QuickTime 7 functions:
GetMovieAudioFrequencyLevels
GetMovieAudioFrequencyMeteringBandFrequencies
GetMovieAudioFrequencyMeteringNumBands
GetMovieAudioVolumeLevels
GetMovieAudioVolumeMeteringEnabled
SetMovieAudioFrequencyMeteringNumBands
SetMovieAudioVolumeMeteringEnabled*/
enum {
kQTAudioMeter_StereoMix = 'stmx',
kQTAudioMeter_DeviceMix = kQTAudioPropertyID_DeviceChannelLayout ,
kQTAudioMeter_MonoMix = 'momx'
};

/*Audio Properties

The following is a list of the new audio properties available in QuickTime 7.1.

enum {
   kQTAudioRenderQuality_PlaybackDefault = 0x8000,
   kQTAudioPropertyID_RenderQuality = 'qual',
   kQTMovieAudioExtractionAudioPropertyID_RenderQuality = 'qual',
   kQTAudioPropertyID_DeviceASBD = 'dasd',
   kQTAudioPropertyID_SummaryASBD = 'sasd',
   kQTAudioPropertyID_RateChangesPreservePitch = 'aucp',
   kQTAudioPropertyID_Pitch  = 'pitc',
   kQTSCAudioPropertyID_RenderQuality = 'qlty',
};
Constants
kQTAudioPropertyID_DeviceASBD

This is a get-only property and returns the AudioStreamBasicDescription of the device the movie is playing to. The interesting fields are the sample rate, which reflects device’s current state, and the number of channels, which matches what is reported by kQTAudioPropertyID_DeviceChannelLayout.
kQTAudioPropertyID_SummaryASBD

Get-only. Returns the AudioStreamBasicDescription corresponding to the Summary Mix of a movie. This describes non-interleaved, Float32 linear PCM data, with a sample rate equal to the highest audio sample rate found among the sound tracks contributing to the AudioContext mix, and a number of channels that matches what is reported by kQTAudioPropertyID_SummaryChannelLayout.
kQTAudioPropertyID_RateChangesPreservePitch

This property was introduced in QuickTime 7 and must be set in order for pitch changes to take effect. When the playback rate is not unity, audio must be resampled in order to play at the new rate. The default resampling affects the pitch of the audio (for example, playing at 2x speed raises the pitch by an octave, 1/2x lowers an octave). If this property is set on the Movie, an alternative algorithm may be used, which alters the speed without changing the pitch. Because this is more computationally expensive, this property may be silently ignored on some slow CPUs. Media handlers may query this movie property and honor it when performing Scaled Edits. This property can be specified as a property to the NewMovieFromProperties API. Currently, it has no effect when set on an open movie.
kQTAudioPropertyID_Pitch

The movie pitch adjustment. This adjusts the pitch of all audio tracks that contribute to the AudioContext mix. Pitch control takes effect only if kQTAudioPropertyID_RateChangesPreservePitch is in effect; otherwise, returns kQTMessageNotHandledErr. The Float32 value is specified in cents: 0.0 == no change, 1.0 == one cent up, 100.0 == one semi-tone up, -1.0 == one cent down. The most useful ranges for pitch are +/- 1200, that is, one octave.
kQTAudioPropertyID_RenderQuality

Movie audio render quality takes effect for movie playback. UInt32 values are as defined in AudioUnit/AudioUnitProperties.h and vary from 0x00 (kRenderQuality_Min) to 0x7F (kRenderQuality_Max). A special value kQTAudioRenderQuality_PlaybackDefault) is also defined which resets the quality settings of the playback processing chain to values that are chosen to be an optimal balance of performance and quality.
kQTMovieAudioExtractionAudioPropertyID_RenderQuality

Sets the render quality to be used for this audio extraction session. UInt32 values are as defined in AudioUnit/AudioUnitProperties.h and vary from 0x00(kRenderQuality_Min) to 0x7F (kRenderQuality_Max). A special value (kQTAudioRenderQuality_PlaybackDefault) is also defined which resets the quality settings to the same values that were chosen by default for playback.
kQTSCAudioPropertyID_RenderQuality

Specifies the quality with which QuickTime should render the audio stream during the compression/decompression/transcode operation. Accepted constants are those used by AudioUnits (defined in AudioUnitProperties.h): kRenderQuality_Max, kRenderQuality_High, kRenderQuality_Medium, kRenderQuality_Low, kRenderQuality_Min. Available in QuickTimeComponents.h.
Declared In
Movies.h*/
enum {
   kQTAudioRenderQuality_PlaybackDefault = 0x8000,
   kQTAudioPropertyID_RenderQuality = 'qual',
   kQTMovieAudioExtractionAudioPropertyID_RenderQuality = 'qual',
   kQTAudioPropertyID_DeviceASBD = 'dasd',
   kQTAudioPropertyID_SummaryASBD = 'sasd',
   kQTAudioPropertyID_RateChangesPreservePitch = 'aucp',
   kQTAudioPropertyID_Pitch  = 'pitc',
   kQTSCAudioPropertyID_RenderQuality = 'qlty',
};


/*QuickTime 5 includes the addition of two new functions –– CanQuickTimeOpenFile and CanQuickTimeOpenDataRef, discussed in this section. The CanQuickTimeOpenFile call determines whether QuickTime can open a given file or, in general, files of a given type. The CanQuickTimeOpenDataRef call is similar to CanQuickTimeOpenFile except that it uses a data reference instead of a file.

The input flags for CanQuickTimeOpenFile and CanQuickTimeOpenFileDataRef are defined as follows:
enum {
    kQTDontUseDataToFindImporter = 1L << 0,
    kQTDontLookForMovieImporterIfGraphicsImporterFound = 1L << 1,
    kQTAllowOpeningStillImagesAsMovies = 1L << 2,
    kQTAllowImportersThatWouldCreateNewFile = 1L << 3,
    kQTAllowAggressiveImporters = 1L << 4
};*/
enum {
    kQTDontUseDataToFindImporter = 1L << 0,
    kQTDontLookForMovieImporterIfGraphicsImporterFound = 1L << 1,
    kQTAllowOpeningStillImagesAsMovies = 1L << 2,
    kQTAllowImportersThatWouldCreateNewFile = 1L << 3,
    kQTAllowAggressiveImporters = 1L << 4
};


/*SetMovieDrawingCompleteProc Values

Constants passed to SetMovieDrawingCompleteProc.

enum {
   movieDrawingCallWhenChanged   = 0,
   movieDrawingCallAlways        = 1
};
Declared In
Movies.h*/
enum {
   movieDrawingCallWhenChanged   = 0,
   movieDrawingCallAlways        = 1
};

/*NewMovieController Values

Constants passed to NewMovieController.

enum {
   mcTopLeftMovie                = 1 << 0,
   / usually centered *
   mcScaleMovieToFit             = 1 << 1,
   / usually only scales down *
   mcWithBadge                   = 1 << 2,
   / give me a badge *
   mcNotVisible                  = 1 << 3,
   / don't show controller *
   mcWithFrame                   = 1 << 4 / gimme a frame *
};*/
enum {
   mcTopLeftMovie                = 1 << 0,
   /* usually centered */
   mcScaleMovieToFit             = 1 << 1,
   /* usually only scales down */
   mcWithBadge                   = 1 << 2,
   /* give me a badge */
   mcNotVisible                  = 1 << 3,
   /* don't show controller */
   mcWithFrame                   = 1 << 4 /* gimme a frame */
};



/*Constants

This section lists the constants that were added to QuickTime after an early release. Most of the constants are used as flags for QuickTime functions; they allow the programmer to pass numeric data as a meaningful name.#define kFix1 = (0x00010000);             /* fixed point value equal to 1.0 *
#define gestaltQuickTime 'qtim'           / Movie Toolbox availability *
#define MovieFileType 'MooV'              / movie file type *
#define VideoMediaType 'vide'             / video media type *
#define SoundMediaType 'soun'             / sound media type *
#define MediaHandlerType 'mhlr'           / media handler type *
#define DataHandlerType 'dhlr'            / data handler type *
#define TextMediaType 'text'              / text media type *
#define GenericMediaType 'gnrc'           / base media handler type *
#define DoTheRightThing = 0L              /*indicates default flag settings
                                                 for Movie Toolbox functions *
/ sound volume values in trackVolume parameter of NewMovieTrack function *
#define kFullVolume         = 0x100       / full, natural volume
                                                 (8.8 format) *
#define kNoVolume           =   0         * no volume *
/ constants for whichMediaTypes parameter of GetMovieNextInterestingTime
    function *
#define VisualMediaCharacteristic 'eyes'  / visual media *
#define AudioMediaCharacteristic 'ears'   / audio media 
 
enum
{
/ media quality settings in quality parameter of SetMediaQuality function *
    mediaQualityDraft           = 0x0000,    / lowest quality level *
    mediaQualityNormal          = 0x0040,    * acceptable quality level *
    mediaQualityBetter          = 0x0080,    / better quality level *
    mediaQualityBest            = 0x00C0     / best quality level *
};
 
*values for callBackFlags field of QuickTime callback header structure used
    by clock components to communicate scheduling information about a
    callback event to the Movie Toolbox *
enum
{
    qtcbNeedsRateChanges           = 1,    / rate changes *
    qtcbNeedsTimeChanges           = 2,    / time changes *
    qtcbNeedsStartStopChanges      = 4     * time base changes at start &
                                                stop times *
};
 
/* dialog items to include in dialog box definition for use with
    SFPGetFilePreview function *
enum
{
    sfpItemPreviewAreaUser         = 11,       /* user preview area *
    sfpItemPreviewStaticText       = 12,       /* static text preview *
    sfpItemPreviewDividerUser      = 13,       /* user divider preview *
    sfpItemCreatePreviewButton     = 14,       /* create preview button *
    sfpItemShowPreviewButton       = 15        /* show preview button *
};
 
enum
{                       
    movieInDataForkResID           = -1        /* magic resource ID *
};
 
/* flags for LoadIntoRAM functions *
enum
{
    keepInRam                  = 1<<0,     / load and make so data  
                                                 cannot be purged *
    unkeepInRam                = 1<<1,     /mark data so it can be purged *
    flushFromRam               = 1<<2,     / empty handles and purge data
                                                 from memory *
    loadForwardTrackEdits      = 1<<3,     /* load only data around track edits;
                                                 play movie forward *
    loadBackwardTrackEdits     = 1<<4      /* load only data around edits;
                                                 play movie in reverse *
};
 
/* flag for PasteHandleIntoMovie function *
enum
{
    pasteInParallel = 1         /* changes function to take contents and type of
                                     handle and add to movie *
};
 
/* text description display flags used in TextMediaAddTextSample and
      TextMediaAddTESample *
enum
{
    dfDontDisplay           = 1<<0,   /* don't display the text *
    dfDontAutoScale         = 1<<1,   /* don't scale text as track
                                           bounds grows or shrinks *
    dfClipToTextBox         = 1<<2,   /* clip update to the text box *
    dfUseMovieBGColor       = 1<<3,   /* set text background to movie's
                                           background color *
    dfShrinkTextBoxToFit    = 1<<4,   /* compute minimum box to fit the
                                           sample *
    dfScrollIn              = 1<<5,   /* scroll text in until last of
                                           text is in view *
    dfScrollOut             = 1<<6    /* scroll text out until last of text is
                                           gone (if dfScrollIn is also set, 
                                           scroll in then out) *
    dfHorizScroll           = 1<<7,   /* scroll text horizontally; otherwise,
                                           it's vertical *
    dfReverseScroll         = 1<<8    /* vertically scroll down and horizontally
                                         scroll up; justification-dependent *
};
 
/* find flags for TextMediaFindNextText function *
    findTextEdgeOK           = 1<<0,     /* OK to find text at specified
                                              sample time *
    findTextCaseSensitive    = 1<<1,     / case-sensitive search *
    findTextReverseSearch    = 1<<2,     /* search from sampleTime backward *
    findTextWraparound       = 1<<3,     /* wrap search when beginning or end
                                              of movie is reached */  
 
/* return display flags for application-defined text function *
enum
{
    txtProcDefaultDisplay    = 0,        /* use the media's default settings *
    txtProcDontDisplay       = 1,        /* don't display the text *
    txtProcDoDisplay         = 2         /* display the text *
};
 
enum
{
hintsScrubMode               = 1<<0,    /* toolbox can display key frames when
                                              movie is repositioned *
hintsAllowInterlace          = 1<<6,    /* use interlace option for compressor
                                              components *
hintsUseSoundInterp          = 1<<7     /* turn on sound interpolation *
};
typedef unsigned long playHintsEnum;*/

#define kFix1 = (0x00010000);             /* fixed point value equal to 1.0 */
#define gestaltQuickTime 'qtim'           /* Movie Toolbox availability */
#define MovieFileType 'MooV'              /* movie file type */
//#define VideoMediaType 'vide'             /* video media type */
//#define SoundMediaType 'soun'             /* sound media type */
//#define MediaHandlerType 'mhlr'           /* media handler type */
//#define DataHandlerType 'dhlr'            /* data handler type */
//#define TextMediaType 'text'              /* text media type */
#define GenericMediaType 'gnrc'           /* base media handler type */
#define DoTheRightThing  0L              /* indicates default flag settings
                                                 //for Movie Toolbox functions */  

/* sound volume values in trackVolume parameter of NewMovieTrack function */
#define kFullVolume         = 0x100       /* full, natural volume
                                                 (8.8 format) */ 
#define kNoVolume           =   0         /* no volume */
/* constants for whichMediaTypes parameter of GetMovieNextInterestingTime
    function */
#define VisualMediaCharacteristic 'eyes'  /* visual media */
#define AudioMediaCharacteristic 'ears'   /* audio media */
 
enum
{
/* media quality settings in quality parameter of SetMediaQuality function */
    mediaQualityDraft           = 0x0000,    /* lowest quality level */
    mediaQualityNormal          = 0x0040,    /* acceptable quality level */
    mediaQualityBetter          = 0x0080,    /* better quality level */
    mediaQualityBest            = 0x00C0     /* best quality level */
};
 
/*values for callBackFlags field of QuickTime callback header structure used
    by clock components to communicate scheduling information about a
    callback event to the Movie Toolbox */
enum
{
    qtcbNeedsRateChanges           = 1,    /* rate changes */
    qtcbNeedsTimeChanges           = 2,    /* time changes */
    qtcbNeedsStartStopChanges      = 4     /* time base changes at start &
                                                stop times */ 
};
 
/* dialog items to include in dialog box definition for use with
    SFPGetFilePreview function */
enum
{
    sfpItemPreviewAreaUser         = 11,       /* user preview area */
    sfpItemPreviewStaticText       = 12,       /* static text preview */
    sfpItemPreviewDividerUser      = 13,       /* user divider preview */
    sfpItemCreatePreviewButton     = 14,       /* create preview button */
    sfpItemShowPreviewButton       = 15        /* show preview button */
};
 
enum
{                       
    movieInDataForkResID           = -1        /* magic resource ID */
};
 
/* flags for LoadIntoRAM functions */
enum
{
    keepInRam                  = 1<<0,     /* load and make so data  
                                                 cannot be purged */ 
    unkeepInRam                = 1<<1,     /* mark data so it can be purged */ 
    flushFromRam               = 1<<2,     /* empty handles and purge data
                                                 from memory */ 
    loadForwardTrackEdits      = 1<<3,     /* load only data around track edits;
                                                 play movie forward */ 
    loadBackwardTrackEdits     = 1<<4      /* load only data around edits;
                                                 play movie in reverse */ 
};
 
/* flag for PasteHandleIntoMovie function */
enum
{
    pasteInParallel = 1         /* changes function to take contents and type of
                                     handle and add to movie */ 
};
 
/* text description display flags used in TextMediaAddTextSample and
      TextMediaAddTESample */
 
enum {
/* find flags for TextMediaFindNextText function */
    findTextEdgeOK           = 1<<0,     /* OK to find text at specified
                                              sample time */ 
    findTextCaseSensitive    = 1<<1,     /* case-sensitive search */
    findTextReverseSearch    = 1<<2,     /* search from sampleTime backward */
    findTextWraparound       = 1<<3,     /* wrap search when beginning or end
                                              of movie is reached */  
 };
/* return display flags for application-defined text function */
enum
{
    txtProcDefaultDisplay    = 0,        /* use the media's default settings */
    txtProcDontDisplay       = 1,        /* don't display the text */
    txtProcDoDisplay         = 2         /* display the text */
};
 
typedef unsigned long playHintsEnum;

/*Using pdActionCustomDoEditCommand to Handle Edit Commands

pdActionCustomDoEditCommand tells your control to handle edit commands if it allow focus and type in boxes.

All custom controls must implement this call if they support edit boxes. 
struct QTCustomControlDoEditCommandRecord {
    void * storage; / storage for the control*
    long command; /*command to execute, return 0 here if processed*
};
typedef struct QTCustomControlDoEditCommandRecord QTCustomControlDoEditCommandRecord;
 
typedef QTCustomControlDoEditCommandRecord * QTCustomControlDoEditCommandPtr;
typedef long QTParameterDialog;a
enum {
    elOptionsIncludeNoneInList  = 0x00000001 / "None" effect is included
                                                in list *
};
typedef long QTEffectListOptions;
enum {
    pdOptionsCollectOneValue = 0x00000001, / should collect a single
                                            value only*
pdOptionsAllowOptionalInterpolations = 0x00000002, / non-novice
                                    interpolation options are shown *
pdOptionsModalDialogBox = 0x00000004, /dialog box should be modal *
pdOptionsEditCurrentEffectOnly = 0x00000008, / List of effects will not
                                                be shown /
pdOptionsHidePreview = 0x00000010 / Preview item will not be shown *
enum {
    effectIsRealtime = 0 / effect can be rendered in real time *
};*/

struct QTCustomControlDoEditCommandRecord {
    void * storage; /* storage for the control*/
    long command; /* command to execute, return 0 here if processed*/
};
typedef struct QTCustomControlDoEditCommandRecord QTCustomControlDoEditCommandRecord;
 
typedef QTCustomControlDoEditCommandRecord * QTCustomControlDoEditCommandPtr;
typedef long QTParameterDialog;
enum {
    elOptionsIncludeNoneInList  = 0x00000001 /* "None" effect is included
                                                in list */
};
typedef long QTEffectListOptions;
enum {
    pdOptionsCollectOneValue = 0x00000001, /* should collect a single
                                            value only*/
pdOptionsAllowOptionalInterpolations = 0x00000002, /* non-novice
                                    interpolation options are shown */
pdOptionsModalDialogBox = 0x00000004, /* dialog box should be modal */
pdOptionsEditCurrentEffectOnly = 0x00000008, /* List of effects will not
                                                be shown */
pdOptionsHidePreview = 0x00000010 /* Preview item will not be shown */
};
enum {
    effectIsRealtime = 0 /* effect can be rendered in real time */
};
/*Properties of the movie that is extracted from kQTPropertyClass_MovieAudioExtraction_Movie include the following movie class IDs: 
kQTMovieAudioExtractionMoviePropertyID_CurrentTime. The value is a TimeRecord, which you can set and get. When setting, you set the timescale to anything you want (for example, the output audio sample rate or the movie timescale). When getting, the timescale will be output audio sample rate for best accuracy.
kQTMovieAudioExtractionMoviePropertyID_AllChannelsDiscrete. The value is Boolean (which is settable and gettable). Set to implement export of all audio channels without mixing. When this is set and the extraction audio stream basic description (ASBD) or channel layout are read back, you get information relating to the re-mapped movie.
kQTMovieAudioExtractionMoviePropertyID_CurrentTime = ‘time’. The value is a TimeRecord , which is gettable and settable.*/

enum{
kQTMovieAudioExtractionMoviePropertyID_CurrentTime = 'time'
};


/*Returns the load state of the target movie. <0 indicates an error.   
  kMovieLoadStateLoading      = 1000,    
 kMovieLoadStatePlayable     = 10000,    
 kMovieLoadStatePlaythroughOK = 20000,  
   kMovieLoadStateComplete     = 100000L
kOperandMovieTrackCount = 1034,*/
enum{
kMovieLoadStateLoading      = 1000,
 kMovieLoadStatePlayable     = 10000,
 kMovieLoadStatePlaythroughOK = 20000,
 kMovieLoadStateComplete     = 100000L,
kOperandMovieTrackCount = 1034,
};
/*QTPropertyClass_SampleTable

Constants grouped with kQTPropertyClass_SampleTable.

enum {
   /*
   * Property class for sample tables.
   */
//   kQTPropertyClass_SampleTable  = 'qtst',
   /*
   * The total decode duration of all samples in the sample table.
   * Read-only.
   */
//   kQTSampleTablePropertyID_TotalDecodeDuration = 'tded',
   /* TimeValue64,
   Read */
   /*
   * The least display offset in the table. (-50 is a lesser offset
   * than 20.)  Read-only.
   */
//   kQTSampleTablePropertyID_MinDisplayOffset = '<ddd',
   /* TimeValue64,
   Read */
   /*
   * The greatest display offset in the table. (20 is a greater offset
   * than -50.)  Read-only.
   */
//   kQTSampleTablePropertyID_MaxDisplayOffset = '>ddd',
   /* TimeValue64,
   Read */
   /*
   * The least display time of all samples in the table,
   relative to
   * the decode time of the first sample in the table.  Read-only.
   */
//   kQTSampleTablePropertyID_MinRelativeDisplayTime = '<dis',
   /* TimeValue64,
   Read */
   /*
   * The greatest display time of all samples in the table,
   relative to
   * the decode time of the first sample in the table.  Read-only.
   */
  // kQTSampleTablePropertyID_MaxRelativeDisplayTime = '>dis' /* TimeValue64,
//   Read */
//};
//Declared In
//Movies.h*/

enum {
   /*
   * Property class for sample tables.
   */
   kQTPropertyClass_SampleTable  = 'qtst',
   /*
   * The total decode duration of all samples in the sample table.
   * Read-only.
   */
   kQTSampleTablePropertyID_TotalDecodeDuration = 'tded',
   /* TimeValue64,
   Read */
   /*
   * The least display offset in the table. (-50 is a lesser offset
   * than 20.)  Read-only.
   */
   kQTSampleTablePropertyID_MinDisplayOffset = '<ddd',
   /* TimeValue64,
   Read */
   /*
   * The greatest display offset in the table. (20 is a greater offset
   * than -50.)  Read-only.
   */
   kQTSampleTablePropertyID_MaxDisplayOffset = '>ddd',
   /* TimeValue64,
   Read */
   /*
   * The least display time of all samples in the table,
   relative to
   * the decode time of the first sample in the table.  Read-only.
   */
   kQTSampleTablePropertyID_MinRelativeDisplayTime = '<dis',
   /* TimeValue64,
   Read */
   /*
   * The greatest display time of all samples in the table,
   relative to
   * the decode time of the first sample in the table.  Read-only.
   */
   kQTSampleTablePropertyID_MaxRelativeDisplayTime = '>dis' /* TimeValue64,
   Read */
};



/*QTSampleTableGetSampleFlags Values

Constants passed to QTSampleTableGetSampleFlags.

enum {
   mediaSampleNotSync            = 1 << 0,
   // sample is not a sync sample (eg. is frame differenced 
   mediaSampleShadowSync         = 1 << 1,
   // sample is a shadow sync 
   mediaSampleDroppable          = 1 << 27,
   // sample is not required to be decoded for later samples to be decoded properly
   mediaSamplePartialSync        = 1 << 16,
   //sample is a partial sync (e.g
   //I frame after open GOP)
   mediaSampleHasRedundantCoding = 1 << 24,
   // sample is known to contain redundant coding 
   mediaSampleHasNoRedundantCoding = 1 << 25,
   / sample is known not to contain redundant coding 
   mediaSampleIsDependedOnByOthers = 1 << 26,
   // one or more other samples depend upon the decode of this sample 
   mediaSampleIsNotDependedOnByOthers = 1 << 27,
   // synonym for mediaSampleDroppable 
   mediaSampleDependsOnOthers    = 1 << 28,
   // sample's decode depends upon decode of other samples 
   mediaSampleDoesNotDependOnOthers = 1 << 29,
   // sample's decode does not depend upon decode of other samples 
   mediaSampleEarlierDisplayTimesAllowed = 1 << 30 / samples later in decode order may have earlier display times 
};
Constants
mediaSampleNotSync

Returned for frame-differenced video sample data. 

Available in Mac OS X v10.0 and later.*/

enum {
   mediaSampleNotSync            = 1 << 0,
   /* sample is not a sync sample (eg. is frame differenced */
   mediaSampleShadowSync         = 1 << 1,
   /* sample is a shadow sync */
   mediaSampleDroppable          = 1 << 27,
   /* sample is not required to be decoded for later samples to be decoded properly */
   mediaSamplePartialSync        = 1 << 16,
   /* sample is a partial sync (e.g.,
   I frame after open GOP) */
   mediaSampleHasRedundantCoding = 1 << 24,
   /* sample is known to contain redundant coding */
   mediaSampleHasNoRedundantCoding = 1 << 25,
   /* sample is known not to contain redundant coding */
   mediaSampleIsDependedOnByOthers = 1 << 26,
   /* one or more other samples depend upon the decode of this sample */
   mediaSampleIsNotDependedOnByOthers = 1 << 27,
   /* synonym for mediaSampleDroppable */
   mediaSampleDependsOnOthers    = 1 << 28,
   /* sample's decode depends upon decode of other samples */
   mediaSampleDoesNotDependOnOthers = 1 << 29,
   /* sample's decode does not depend upon decode of other samples */
   mediaSampleEarlierDisplayTimesAllowed = 1 << 30 /* samples later in decode order may have earlier display times */
};
/*Metadata Property IDs

The property IDs in this section are used with functions of the form QTMetaData...

Following are constants for the QTMetaDataRef type:
kPropertyClass_QTMetaData = 'meta'

The QuickTime metadata property class.
kQTMetaDataPropertyID_StorageFormats = 'fmts'

The list of storage formats of type QTMetaDataStorageFormat associated with a QTMetaDataRef object. The read-only return value is a C-style array of OSType values.
kQTMetaDataPropertyID_OwnerType = 'ownt'

The owner type associated with a QTMetaDataRef object. The read-only return value is an OSType (QT_MOVIE_TYPE, QT_TRACK_TYPE, or QT_MEDIA_TYPE).
kQTMetaDataPropertyID_Owner = 'ownr'

The owner associated with a QTMetaDataRef object, which does not necessarily need an owner. The read-only return value is type Movie, Track, or Media.

Following are constants for the QTMetaDataItem type:
kPropertyClass_QTMetaDataItem = 'mdit'

The metadata item property class ID
kQTMetaDataItemPropertyID_Value = 'valu'

The value of the metadata item. The read-only return value is a C-style array of values of type UInt8.
kQTMetaDataItemPropertyID_DataType = 'dtyp'

The value type of the metadata item. The read/write return value is type UInt32.
kQTMetaDataItemPropertyID_StorageFormat = 'sfmt'

The storage format of the metadata item. The read-only return value is type QTMetaDataStorageFormat.
kQTMetaDataItemPropertyID_Key = 'key ' [last char is space]

The key associated with the metadata item. The read/write return value is a C-style array of values of type UInt8.
kQTMetaDataItemPropertyID_KeyFormat = 'keyf'

The format of the metadata item key. The read/write return value is type OSType.
kQTMetaDataItemPropertyID_Locale = 'loc '

The locale identifier based on the naming convention defined by the International Components for Unicode (ICU). The identifier consists of two pieces of ordered information: a language code and a region code. The language code is based on the ISO 639-1 standard, which defines two-character codes, such as en and fr, for the world’s most commonly used languages. If a two-letter code is not available, then ISO 639-2 three-letter identifiers are accepted as well; for example, haw for Hawaiian. The region code is defined by ISO 3166-1. It is all uppercase and is appended, with an underscore, after the language code; for example en_US, en_GB, and fr_FR. The read/write return value is a C string of type UInt32.*/
enum {
kPropertyClass_QTMetaData = 'meta' ,
kQTMetaDataPropertyID_StorageFormats = 'fmts',
kQTMetaDataPropertyID_OwnerType = 'ownt',
kQTMetaDataPropertyID_Owner = 'ownr'
};

enum {
kPropertyClass_QTMetaDataItem = 'mdit',
kQTMetaDataItemPropertyID_Value = 'valu',
kQTMetaDataItemPropertyID_DataType = 'dtyp',
kQTMetaDataItemPropertyID_StorageFormat = 'sfmt',
kQTMetaDataItemPropertyID_Key = 'key ' ,
kQTMetaDataItemPropertyID_KeyFormat = 'keyf',
kQTMetaDataItemPropertyID_Locale = 'loc '
};


/*inDataType

A data type from the following list: kQTMetaDataTypeBinary = 0, kQTMetaDataTypeUTF8 = 1, kQTMetaDataTypeUTF16BE = 2, kQTMetaDataTypeMacEncodedText = 3, kQTMetaDataTypeSignedIntegerBE = 21, kQTMetaDataTypeUnsignedIntegerBE = 22, kQTMetaDataTypeFloat32BE = 23, kQTMetaDataTypeFloat64BE = 24With kQTMetaDataTypeSignedIntegerBE and kQTMetaDataTypeUnsignedIntegerBE, the size of the integer is determined by the value size.*/
enum {
 kQTMetaDataTypeBinary = 0, 
kQTMetaDataTypeUTF8 = 1,
 kQTMetaDataTypeUTF16BE = 2,
 kQTMetaDataTypeMacEncodedText = 3, 
kQTMetaDataTypeSignedIntegerBE = 21, 
kQTMetaDataTypeUnsignedIntegerBE = 22,
 kQTMetaDataTypeFloat32BE = 23,
kQTMetaDataTypeFloat64BE = 24
};

/*Metadata Format Constants

The format constants in this section are used with functions of the form QTMetaData...

Following are constants for the QTMetaDataStorageFormat type:
kQTMetaDataStorageFormatQuickTime = 'mdta'

The QuickTime metadata storage format
kQTMetaDataKeyFormatQuickTime = 'mdta'

Reverse DNS format
kQTMetaDataStorageFormatiTunes = 'itms'

The iTunes metadata storage format

Following are constants for the QTMetaDataKeyFormat type:
kQTMetaDataKeyFormatiTunesShortForm = 'itsk'

A four-character code
kQTMetaDataKeyFormatiTunesLongForm = 'itlk'

Reverse DNS format

Following are constants for user data formats:
kQTMetaDataStorageFormatUserData = 'udta'

User data storage format
kQTMetaDataKeyFormatUserData = 'udta',

User data key storage format*/
enum {
kQTMetaDataStorageFormatQuickTime = 'mdta' ,
kQTMetaDataKeyFormatQuickTime = 'mdta',
kQTMetaDataStorageFormatiTunes = 'itms',
kQTMetaDataKeyFormatiTunesShortForm = 'itsk',
kQTMetaDataKeyFormatiTunesLongForm = 'itlk',
kQTMetaDataStorageFormatUserData = 'udta',
kQTMetaDataKeyFormatUserData = 'udta',
};

/*Hint Flags

Constants that represent hint flags.

enum {
   hintsScrubMode                = 1 << 0,
   // mask == && (if flags == scrub on,
   f//lags != scrub off) 
   hintsLoop                     = 1 << 1,
   hintsDontPurge                = 1 << 2,
   hintsUseScreenBuffer          = 1 << 5,
   hintsAllowInterlace           = 1 << 6,
   hintsUseSoundInterp           = 1 << 7,
   hintsHighQuality              = 1 << 8,
   // slooooow 
   hintsPalindrome               = 1 << 9,
   hintsInactive                 = 1 << 11,
   hintsOffscreen                = 1 << 12,
   hintsDontDraw                 = 1 << 13,
   hintsAllowBlacklining         = 1 << 14,
   hintsDontUseVideoOverlaySurface = 1 << 16,
   hintsIgnoreBandwidthRestrictions = 1 << 17,
   hintsPlayingEveryFrame        = 1 << 18,
   hintsAllowDynamicResize       = 1 << 19,
   hintsSingleField              = 1 << 20,
   hintsNoRenderingTimeOut       = 1 << 21,
   hintsFlushVideoInsteadOfDirtying = 1 << 22,
   hintsEnableSubPixelPositioning = 1L << 23,
   hintsRenderingMode            = 1L << 24,
   hintsAllowIdleSleep           = 1L << 25,
   // asks media handlers not to call UpdateSystemActivity etc 
   hintsDeinterlaceFields        = 1L << 26
};
Constants
hintsAllowIdleSleep

Asks media handlers not to call UpdateSystemActivity etc. 

Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
enum {
   hintsScrubMode                = 1 << 0,
   /* mask == && (if flags == scrub on,
   flags != scrub off) */
   hintsLoop                     = 1 << 1,
   hintsDontPurge                = 1 << 2,
   hintsUseScreenBuffer          = 1 << 5,
   hintsAllowInterlace           = 1 << 6,
   hintsUseSoundInterp           = 1 << 7,
   hintsHighQuality              = 1 << 8,
   /* slooooow */
   hintsPalindrome               = 1 << 9,
   hintsInactive                 = 1 << 11,
   hintsOffscreen                = 1 << 12,
   hintsDontDraw                 = 1 << 13,
   hintsAllowBlacklining         = 1 << 14,
   hintsDontUseVideoOverlaySurface = 1 << 16,
   hintsIgnoreBandwidthRestrictions = 1 << 17,
   hintsPlayingEveryFrame        = 1 << 18,
   hintsAllowDynamicResize       = 1 << 19,
   hintsSingleField              = 1 << 20,
   hintsNoRenderingTimeOut       = 1 << 21,
   hintsFlushVideoInsteadOfDirtying = 1 << 22,
   hintsEnableSubPixelPositioning = 1L << 23,
   hintsRenderingMode            = 1L << 24,
   hintsAllowIdleSleep           = 1L << 25,
   /* asks media handlers not to call UpdateSystemActivity etc */
   hintsDeinterlaceFields        = 1L << 26
};
/*loopTimeBase

Constants grouped with loopTimeBase.

enum {
   loopTimeBase                  = 1,
   palindromeLoopTimeBase        = 2,
   maintainTimeBaseZero          = 4
};
Declared In
Movies.h*/
enum {
   loopTimeBase                  = 1,
   palindromeLoopTimeBase        = 2,
   maintainTimeBaseZero          = 4
};


/*New Movie Property Codes

The following codes are stored in the propClass fields of QTNewMoviePropertyElement data structures, which pass them to NewMovieFromProperties.kQTPropertyClass_DataLocation = 'dloc',
        kQTDataLocationPropertyID_DataReference             = 'dref',
           // DataReferenceRecord *
        kQTDataLocationPropertyID_CFStringNativePath        = 'cfnp',
           // CFStringRef *
        kQTDataLocationPropertyID_CFStringPosixPath         = 'cfpp',
           // CFStringRef *
        kQTDataLocationPropertyID_CFStringHFSPath           = 'cfhp',
           // CFStringRef *
        kQTDataLocationPropertyID_CFStringWindowsPath       = 'cfwp',
           // CFStringRef *
        kQTDataLocationPropertyID_CFURL                     = 'cfur',
           // CFURLRef *
        kQTDataLocationPropertyID_QTDataHandler             = 'qtdh',
           // DataHandler *
        kQTDataLocationPropertyID_Scrap                     = 'scrp',
           // NULL
        kQTDataLocationPropertyID_LegacyMovieResourceHandle = 'rezh',
           // Handle *
        kQTDataLocationPropertyID_MovieUserProc             = 'uspr',
           // QTNewMovieUserProcRecord *
        kQTDataLocationPropertyID_ResourceFork              = 'rfrk',
           // SInt16 *
        kQTDataLocationPropertyID_DataFork                  = 'dfrk',
           // SInt16 *
 
kQTPropertyClass_Audio = 'audi',
        kQTAudioPropertyID_RateChangesPreservePitch         = 'aucp', // Boolean *
 
 kQTPropertyClass_Context = 'ctxt',
        kQTContextPropertyID_AudioContext       = 'audi',
           // QTAudioContextRef *
        kQTContextPropertyID_VisualContext      = 'visu',
           // QTVisualContextRef *
 
 kQTPropertyClass_MovieResourceLocator = 'rloc',
        kQTMovieResourceLocatorPropertyID_LegacyResID   = 'rezi',
           // SInt16 * (input/output property)
        kQTMovieResourceLocatorPropertyID_LegacyResName = 'rezn',
           // Str255   (output property)
        kQTMovieResourceLocatorPropertyID_FileOffset    = 'foff',
           // UInt64 *
        kQTMovieResourceLocatorPropertyID_Callback      = 'calb',
           // User-defined
 
 kQTPropertyClass_MovieInstantiation = 'mins',
        kQTMovieInstantiationPropertyID_DontResolveDataRefs         = 'rdrn',
           // Boolean *
        kQTMovieInstantiationPropertyID_DontAskUnresolvedDataRefs   = 'aurn',
           // Boolean *
        kQTMovieInstantiationPropertyID_DontAutoAlternates          = 'aaln',
           // Boolean *
        kQTMovieInstantiationPropertyID_DontUpdateForeBackPointers  = 'fbpn',
           // Boolean *
        kQTMovieInstantiationPropertyID_AsyncOK                     = 'asok',
           // Boolean *
        kQTMovieInstantiationPropertyID_IdleImportOK                = 'imok',
           // Boolean *
        kQTMovieInstantiationPropertyID_DontAutoUpdateClock         = 'aucl',
           // Boolean *
        kQTMovieInstantiationPropertyID_ResultDataLocationChanged   = 'dlch',
           // Boolean * (output property)
 
 kQTPropertyClass_NewMovieProperty = 'mprp',
        kQTNewMoviePropertyID_DefaultDataRef        = 'ddrf',
           // DataReferenceRecord *
        kQTNewMoviePropertyID_Active                = 'actv',
           // Boolean *
        kQTNewMoviePropertyID_DontInteractWithUser  = 'intn',
           // Boolean **/
enum {
kQTPropertyClass_DataLocation = 'dloc',
        kQTDataLocationPropertyID_DataReference             = 'dref',
           // DataReferenceRecord *
        kQTDataLocationPropertyID_CFStringNativePath        = 'cfnp',
           // CFStringRef *
        kQTDataLocationPropertyID_CFStringPosixPath         = 'cfpp',
           // CFStringRef *
        kQTDataLocationPropertyID_CFStringHFSPath           = 'cfhp',
           // CFStringRef *
        kQTDataLocationPropertyID_CFStringWindowsPath       = 'cfwp',
           // CFStringRef *
        kQTDataLocationPropertyID_CFURL                     = 'cfur',
           // CFURLRef *
        kQTDataLocationPropertyID_QTDataHandler             = 'qtdh',
           // DataHandler *
        kQTDataLocationPropertyID_Scrap                     = 'scrp',
           // NULL
        kQTDataLocationPropertyID_LegacyMovieResourceHandle = 'rezh',
           // Handle *
        kQTDataLocationPropertyID_MovieUserProc             = 'uspr',
           // QTNewMovieUserProcRecord *
        kQTDataLocationPropertyID_ResourceFork              = 'rfrk',
           // SInt16 *
        kQTDataLocationPropertyID_DataFork                  = 'dfrk',
           // SInt16 *
 
kQTPropertyClass_Audio = 'audi',
       // kQTAudioPropertyID_RateChangesPreservePitch         = 'aucp', // Boolean *
 
 kQTPropertyClass_Context = 'ctxt',
        kQTContextPropertyID_AudioContext       = 'audi',
           // QTAudioContextRef *
        kQTContextPropertyID_VisualContext      = 'visu',
           // QTVisualContextRef *
 
 kQTPropertyClass_MovieResourceLocator = 'rloc',
        kQTMovieResourceLocatorPropertyID_LegacyResID   = 'rezi',
           // SInt16 * (input/output property)
        kQTMovieResourceLocatorPropertyID_LegacyResName = 'rezn',
           // Str255   (output property)
        kQTMovieResourceLocatorPropertyID_FileOffset    = 'foff',
           // UInt64 *
        kQTMovieResourceLocatorPropertyID_Callback      = 'calb',
           // User-defined
 
 kQTPropertyClass_MovieInstantiation = 'mins',
        kQTMovieInstantiationPropertyID_DontResolveDataRefs         = 'rdrn',
           // Boolean *
        kQTMovieInstantiationPropertyID_DontAskUnresolvedDataRefs   = 'aurn',
           // Boolean *
        kQTMovieInstantiationPropertyID_DontAutoAlternates          = 'aaln',
           // Boolean *
        kQTMovieInstantiationPropertyID_DontUpdateForeBackPointers  = 'fbpn',
           // Boolean *
        kQTMovieInstantiationPropertyID_AsyncOK                     = 'asok',
           // Boolean *
        kQTMovieInstantiationPropertyID_IdleImportOK                = 'imok',
           // Boolean *
        kQTMovieInstantiationPropertyID_DontAutoUpdateClock         = 'aucl',
           // Boolean *
        kQTMovieInstantiationPropertyID_ResultDataLocationChanged   = 'dlch',
           // Boolean * (output property)
 
 kQTPropertyClass_NewMovieProperty = 'mprp',
        kQTNewMoviePropertyID_DefaultDataRef        = 'ddrf',
           // DataReferenceRecord *
        kQTNewMoviePropertyID_Active                = 'actv',
           // Boolean *
        kQTNewMoviePropertyID_DontInteractWithUser  = 'intn',
           // Boolean *
};

/*QTNewMoviePropertyElement

Stores a movie property for NewMovieFromProperties.

struct QTNewMoviePropertyElement {
   QTPropertyClass       propClass;
   QTPropertyID          propID;
   ByteCount             propValueSize;
   QTPropertyValuePtr    propValueAddress;
   OSStatus              propStatus;
};
Fields
propClass
Discussion

A four-character code designating the class of a movie property. See New Movie Property Codes.
propID
Discussion

The ID of the property.
propValueSize
Discussion

The size in bytes of the property passed in propValueAddress.
propValueAddress
Discussion

A pointer to a movie property. Since the data type is fixed for each element's property class and ID, these is no ambiguity about the data type for its property value.
propStatus
Discussion

Indicates any problems with the property. For example, if a property is not understood by the function it is passed to, this field is set appropriately. See the discussion in NewMovieFromProperties.
Discussion

When you call NewMovieFromProperties, you allocate and own arrays of these elements to pass to it, as well as the property values that each element points to. You are responsible for disposing of all of these memory allocations.
Related Functions
Associated function: NewMovieFromProperties 
Declared In
Movies.h*/
struct QTNewMoviePropertyElement {
   QTPropertyClass       propClass;
   QTPropertyID          propID;
   ByteCount             propValueSize;
   QTPropertyValuePtr    propValueAddress;
   OSStatus              propStatus;
};
typedef struct QTNewMoviePropertyElement QTNewMoviePropertyElement;

/*/*Atom ID Codes

Identify the four-character type codes of atoms.

enum {
   ConnectionSpeedPrefsType      = 'cspd',
   ConnectionSpeedIsValidPrefsType = 'vspd'
};
enum {
   kEffectNameAtom               = 'name',
   // name of effect 
   kEffectTypeAtom               = 'type',
   //codec sub-type for effect 
   kEffectManufacturerAtom       = 'manu' // codec manufacturer for effect 
};
enum {
   kGraphicsExportGroup          = 'expo',
   kGraphicsExportFileType       = 'ftyp',
   kGraphicsExportMIMEType       = 'mime',
   kGraphicsExportExtension      = 'ext ',
   kGraphicsExportDescription    = 'desc'
};
enum {
   kInputMapSubInputID           = 'subi'
};
enum {
   kMovieMediaDataReference      = 'mmdr',
   // data reference
   kMovieMediaDefaultDataReferenceID = 'ddri',
   //atom id
   kMovieMediaSlaveTime          = 'slti',
   // boolean
   kMovieMediaSlaveAudio         = 'slau',
   // boolean
   kMovieMediaSlaveGraphicsMode  = 'slgr',
   // boolean
   kMovieMediaAutoPlay           = 'play',
   // boolean
   kMovieMediaLoop               = 'loop',
   / /UInt8 (0=no loop,
   1=loop,
   2=palindrome loop)
   kMovieMediaUseMIMEType        = 'mime',
   / string indicating the MIME type to use for the dataref (usually not required)
   kMovieMediaTitle              = 'titl',
   // string of the media's title (tooltips)
   kMovieMediaAltText            = 'altt',
   / string of alternate text if media isn't loaded
   kMovieMediaClipBegin          = 'clpb',
   / MovieMediaTimeRecord of start time of embedded media/
   kMovieMediaClipDuration       = 'clpd',
   /MovieMediaTimeRecord of duration of embedded media/
   kMovieMediaRegionAtom         = 'regi',
   / contains subatoms that describe layout/
   kMovieMediaSlaveTrackDuration = 'sltr',
   / Boolean indicating that media handler should adjust track and media based on actual embedded movie duration/
   kMovieMediaEnableFrameStepping = 'enfs',
   / boolean. if true stepping on external movie steps frames within embedded movie./
   kMovieMediaBackgroundColor    = 'bkcl',
   / RGBColor./
   kMovieMediaPrerollTime        = 'prer' / SInt32 indicating preroll time/
};
enum {
   kMovieMediaSpatialAdjustment  = 'fit ',
   / OSType from kMovieMediaFit/
   kMovieMediaRectangleAtom      = 'rect',
   kMovieMediaTop                = 'top ',
   kMovieMediaLeft               = 'left',
   kMovieMediaWidth              = 'wd  ',
   kMovieMediaHeight             = 'ht  '
};
enum {
   kQTEventType                  = 'evnt',
   kAction                       = 'actn',
   kWhichAction                  = 'whic',
   kActionParameter              = 'parm',
   kActionTarget                 = 'targ',
   kActionFlags                  = 'flag',
   kActionParameterMinValue      = 'minv',
   kActionParameterMaxValue      = 'maxv',
   kActionListAtomType           = 'list',
   kExpressionContainerAtomType  = 'expr',
   kConditionalAtomType          = 'test',
   kOperatorAtomType             = 'oper',
   kOperandAtomType              = 'oprn',
   kCommentAtomType              = 'why ',
   kCustomActionHandler          = 'cust',
   kCustomHandlerID              = 'id  ',
   kCustomHandlerDesc            = 'desc',
   kQTEventRecordAtomType        = 'erec'
};
enum {
   kQTParseTextHREFText          = 'text',
   / string/
   kQTParseTextHREFBaseURL       = 'burl',
   / string/
   kQTParseTextHREFClickPoint    = 'clik',
   / Point; if present,
   QTParseTextHREF will expand URLs to support server-side image maps/
   kQTParseTextHREFUseAltDelim   = 'altd',
   / boolean; if no kQTParseTextHREFDelimiter,
   delim is ':'/
   kQTParseTextHREFDelimiter     = 'delm',
   /character/
   kQTParseTextHREFRecomposeHREF = 'rhrf' / Boolean; if true,
   QTParseTextHREF returns recomposed HREF with URL expanded as appropriate/
};
enum {
   kQTResolutionSettings         = 'reso',
   kQTTargetDataSize             = 'dasz',
   kQTDontRecompress             = 'dntr',
   kQTInterlaceStyle             = 'ilac',
   kQTColorSyncProfile           = 'iccp',
   kQTThumbnailSettings          = 'thum',
   kQTEnableExif                 = 'exif',
   / UInt8 (boolean)/
   kQTMetaData                   = 'meta'
};
enum {
   kQTSConnectionPrefsType       = 'stcm',
   / root atom that all other atoms are contained in/
   /    kQTSNotUsedForProxyPrefsType = 'nopr',
   //        comma-delimited list of URLs that are never used for proxies/
   kQTSConnectionMethodPrefsType = 'mthd',
   /      connection method (OSType that matches one of the following three)/
   kQTSDirectConnectPrefsType    = 'drct',
   /       used if direct connect (QTSDirectConnectPrefsRecord)/
   /    kQTSRTSPProxyPrefsType =     'rtsp',
   //   used if RTSP Proxy (QTSProxyPrefsRecord)/
   kQTSSOCKSPrefsType            = 'sock' /      used if SOCKS Proxy (QTSProxyPrefsRecord)/
};
enum {
   kQTSNullNotification          = 'null',
   / NULL /
   kQTSErrorNotification         = 'err ',
   / QTSErrorParams,
   optional /
   kQTSNewPresDetectedNotification = 'newp',
   / QTSNewPresDetectedParams* /
   kQTSPresBeginChangingNotification = 'prcb',
   / NULL /
   kQTSPresDoneChangingNotification = 'prcd',
   / NULL /
   kQTSPresentationChangedNotification = 'prch',
   / NULL /
   kQTSNewStreamNotification     = 'stnw',
   / QTSNewStreamParams* /
   kQTSStreamBeginChangingNotification = 'stcb',
   / QTSStream /
   kQTSStreamDoneChangingNotification = 'stcd',
   / QTSStream /
   kQTSStreamChangedNotification = 'stch',
   / QTSStreamChangedParams/
   kQTSStreamGoneNotification    = 'stgn',
   / QTSStreamGoneParams/
   kQTSPreviewAckNotification    = 'pvak',
   / QTSStream /
   kQTSPrerollAckNotification    = 'pack',
   / QTSStream /
   kQTSStartAckNotification      = 'sack',
   / QTSStream /
   kQTSStopAckNotification       = 'xack',
   / QTSStream /
   kQTSStatusNotification        = 'stat',
   / QTSStatusParams/
   kQTSURLNotification           = 'url ',
   / QTSURLParams/
   kQTSDurationNotification      = 'dura',
   / QTSDurationAtom/
   kQTSNewPresentationNotification = 'nprs',
   / QTSPresentation /
   kQTSPresentationGoneNotification = 'xprs',
   / QTSPresentation /
   kQTSPresentationDoneNotification = 'pdon',
   / NULL /
   kQTSBandwidthAlertNotification = 'bwal',
   / QTSBandwidthAlertParams/
   kQTSAnnotationsChangedNotification = 'meta' / NULL /
};
enum {
   kQTSStatisticsInfo            = 'stat',
   / QTSStatisticsParams* /  
   kQTSMinStatusDimensionsInfo   = 'mstd',
   / QTSDimensionParams/
   kQTSNormalStatusDimensionsInfo = 'nstd',
   /QTSDimensionParams* /
   kQTSTotalDataRateInfo         = 'drtt',
   / UInt32,
   add to what's there /
   kQTSTotalDataRateInInfo       = 'drti',
   / UInt32,
   add to what's there /
   kQTSTotalDataRateOutInfo      = 'drto',
   / UInt32*,
   add to what's there * /
   kQTSLostPercentInfo           = 'lpct',
   / * QTSLostPercentParams*,
   add to what's there * /
   kQTSNumViewersInfo            = 'nviw',
   / *  UInt32* *  /
   kQTSMediaTypeInfo             = 'mtyp',
   / *  OSType* * /
   kQTSNameInfo                  = 'name',
   / * QTSNameParams* * /
   kQTSCanHandleSendDataType     = 'chsd',
   /* QTSCanHandleSendDataTypeParams* * /   
   kQTSAnnotationsInfo           = 'meta',
   / * QTAtomContainer * /
   kQTSRemainingBufferTimeInfo   = 'btms',
   / * UInt32* remaining buffer time before playback,
   in microseconds * /
   kQTSInfo_SettingsText         = 'sttx',
   / * QTSSettingsTextParams* * /
   kQTSInfo_AverageFrameRate     = 'fps ' / *   UnsignedFixed* * /
};
enum {
   kQTSStreamMediaType           = 'strm'
};
enum {
   kQTSTargetBufferDurationInfo  = 'bufr',
   / * Fixed* in seconds; expected,
   not actual * /
   kQTSDurationInfo              = 'dura',
   / * QTSDurationAtom* * /
   kQTSSoundLevelMeteringEnabledInfo = 'mtrn',
   /* Boolean* * /
   kQTSSoundLevelMeterInfo       = 'levm',
   /* LevelMeterInfoPtr * /
   kQTSSourceTrackIDInfo         = 'otid',
   / * UInt32* * /
   kQTSSourceLayerInfo           = 'olyr',
   / * UInt16* * /
   kQTSSourceLanguageInfo        = 'olng',
   / * UInt16* * /
   kQTSSourceTrackFlagsInfo      = 'otfl',
   / * SInt32* * /
   kQTSSourceDimensionsInfo      = 'odim',
   / * QTSDimensionParams* * /
   kQTSSourceVolumesInfo         = 'ovol',
   /* QTSVolumesParams* * /
   kQTSSourceMatrixInfo          = 'omat',
   / * MatrixRecord* * /
   kQTSSourceClipRectInfo        = 'oclp',
   / * Rect* * /
   kQTSSourceGraphicsModeInfo    = 'ogrm',
   /* QTSGraphicsModeParams* * /  
   kQTSSourceScaleInfo           = 'oscl',
   / * Point* * /
   kQTSSourceBoundingRectInfo    = 'orct',
   / * Rect* * /
   kQTSSourceUserDataInfo        = 'oudt',
   /* UserData * / 
   kQTSSourceInputMapInfo        = 'oimp',
   / * QTAtomContainer * /
   kQTSInfo_DataProc             = 'datp',
   /* QTSDataProcParams* * /
   kQTSInfo_SendDataExtras       = 'dext',
   / * QTSSendDataExtrasParams* * /
   kQTSInfo_HintTrackID          = 'htid',
   / * long* * /
   kQTSInfo_URL                  = 'url ',
   / * Handle*,
   cstring in handle * /
   kQTSInfo_Authentication       = 'auup',
   /* QTSAuthenticationParams * /
   kQTSInfo_MediaPacketizer      = 'rmpk' / * ComponentInstance * /
};
enum {
   kQTVRNodeHeaderAtomType       = 'ndhd',
   kQTVRHotSpotParentAtomType    = 'hspa',
   kQTVRHotSpotAtomType          = 'hots',
   kQTVRHotSpotInfoAtomType      = 'hsin',
   kQTVRLinkInfoAtomType         = 'link'
};
enum {
   kQTVRObjectInfoAtomID         = 1,
   kQTVRObjectImageTrackRefAtomID = 1,
   /* New with 2.1,
   it adds a track reference to select between multiple image tracks* /
   kQTVRObjectHotSpotTrackRefAtomID = 1  /* New with 2.1,
   it adds a track reference to select between multiple hotspot tracks* /
};
enum {
   kQTVRStringAtomType           = 'vrsg',
   kQTVRStringEncodingAtomType   = 'vrse',
   /* New with 2.1* /
   kQTVRPanoSampleDataAtomType   = 'pdat',
   kQTVRObjectInfoAtomType       = 'obji',
   kQTVRImageTrackRefAtomType    = 'imtr',
   /* Parent is kQTVRObjectInfoAtomType. Required if track ref is not 1 as required by 2.0 format.* /
   kQTVRHotSpotTrackRefAtomType  = 'hstr',
   / * Parent is kQTVRObjectInfoAtomType. Required if track ref is not 1 as required by 2.0 format.* /
   kQTVRAngleRangeAtomType       = 'arng',
   kQTVRTrackRefArrayAtomType    = 'tref',
   kQTVRPanConstraintAtomType    = 'pcon',
   kQTVRTiltConstraintAtomType   = 'tcon',
   kQTVRFOVConstraintAtomType    = 'fcon',
   kQTVRCubicViewAtomType        = 'cuvw',
   /* New with 5.0* /
   kQTVRCubicFaceDataAtomType    = 'cufa' / * New with 5.0* /
};
enum {
   kQTVRWorldHeaderAtomType      = 'vrsc',
   kQTVRImagingParentAtomType    = 'imgp',
   kQTVRPanoImagingAtomType      = 'impn',
   kQTVRObjectImagingAtomType    = 'imob',
   kQTVRNodeParentAtomType       = 'vrnp',
   kQTVRNodeIDAtomType           = 'vrni',
   kQTVRNodeLocationAtomType     = 'nloc',
   kQTVRCursorParentAtomType     = 'vrcp',
   /* New with 2.1* /
   kQTVRCursorAtomType           = 'CURS',
   /* New with 2.1* /
   kQTVRColorCursorAtomType      = 'crsr' /* New with 2.1* /
};
enum {
   kSpriteAtomType               = 'sprt',
   kSpriteImagesContainerAtomType = 'imct',
   kSpriteImageAtomType          = 'imag',
   kSpriteImageDataAtomType      = 'imda',
   kSpriteImageDataRefAtomType   = 'imre',
   kSpriteImageDataRefTypeAtomType = 'imrt',
   kSpriteImageGroupIDAtomType   = 'imgr',
   kSpriteImageRegistrationAtomType = 'imrg',
   kSpriteImageDefaultImageIndexAtomType = 'defi',
   kSpriteSharedDataAtomType     = 'dflt',
   kSpriteNameAtomType           = 'name',
   kSpriteImageNameAtomType      = 'name',
   kSpriteUsesImageIDsAtomType   = 'uses',
   /* leaf data is an array of QTAtomID's,
   one per image used* /
   kSpriteBehaviorsAtomType      = 'beha',
   kSpriteImageBehaviorAtomType  = 'imag',
   kSpriteCursorBehaviorAtomType = 'crsr',
   kSpriteStatusStringsBehaviorAtomType = 'sstr',
   kSpriteVariablesContainerAtomType = 'vars',
   kSpriteStringVariableAtomType = 'strv',
   kSpriteFloatingPointVariableAtomType = 'flov'
};
enum {
   kTargetMovie                  = 'moov',
   /* no data * /
   kTargetMovieName              = 'mona',
   / * (PString movieName) * /
   kTargetMovieID                = 'moid',
   /* (long movieID) * /
   kTargetRootMovie              = 'moro',
   /* no data * /
   kTargetParentMovie            = 'mopa',
   / * no data * /
   kTargetChildMovieTrackName    = 'motn',
   / * (PString childMovieTrackName) * /
   kTargetChildMovieTrackID      = 'moti',
   /* (long childMovieTrackID) *  /
   kTargetChildMovieTrackIndex   = 'motx',
   /* (long childMovieTrackIndex) * /
   kTargetChildMovieMovieName    = 'momn',
   /* (PString childMovieName) * /
   kTargetChildMovieMovieID      = 'momi',
   /* (long childMovieID) * /
   kTargetTrackName              = 'trna',
   /* (PString trackName) * /
   kTargetTrackID                = 'trid',
   / * (long trackID) * /
   kTargetTrackType              = 'trty',
   / * (OSType trackType) * /
   kTargetTrackIndex             = 'trin',
   /* (long trackIndex) * /
   kTargetSpriteName             = 'spna',
   / * (PString spriteName) * /
   kTargetSpriteID               = 'spid',
   /* (QTAtomID spriteID) * /
   kTargetSpriteIndex            = 'spin',
   / * (short spriteIndex) * /
   kTargetQD3DNamedObjectName    = 'nana',
   / * (CString objectName) * /
   kTargetCurrentQTEventParams   = 'evpa' / * no data * /
};
enum {
   kTrackModifierInput           = 0x696E,
   /* is really 'in'* /
   kTrackModifierType            = 0x7479,
   /* is really 'ty'* /
   kTrackModifierReference       = 'ssrc',
   kTrackModifierObjectID        = 'obid',
   kTrackModifierInputName       = 'name'
};
enum {
   kTrackPropertyMediaType       = 'mtyp',
   /* OSType* /
   kTrackPropertyInstantiation   = 'inst' /* MovieMediaInstantiationInfoRecord* /
};
enum {
   kTrackReferenceChapterList    = 'chap',
   kTrackReferenceTimeCode       = 'tmcd',
   kTrackReferenceModifier       = 'ssrc'
};
enum {
   kTweenEntry                   = 'twen',
   kTweenData                    = 'data',
   kTweenType                    = 'twnt',
   kTweenStartOffset             = 'twst',
   kTweenDuration                = 'twdu',
   kTweenFlags                   = 'flag',
   kTweenOutputMin               = 'omin',
   kTweenOutputMax               = 'omax',
   kTweenSequenceElement         = 'seqe',
   kTween3dInitialCondition      = 'icnd',
   kTweenInterpolationID         = 'intr',
   kTweenRegionData              = 'qdrg',
   kTweenPictureData             = 'PICT',
   kListElementType              = 'type',
   kListElementDataType          = 'daty',
   kNameAtom                     = 'name',
   kInitialRotationAtom          = 'inro',
   kNonLinearTweenHeader         = 'nlth'
};
enum {
   MovieAID                      = 'moov',
   MovieHeaderAID                = 'mvhd',
   ClipAID                       = 'clip',
   RgnClipAID                    = 'crgn',
   MatteAID                      = 'matt',
   MatteCompAID                  = 'kmat',
   TrackAID                      = 'trak',
   UserDataAID                   = 'udta',
   TrackHeaderAID                = 'tkhd',
   EditsAID                      = 'edts',
   EditListAID                   = 'elst',
   MediaAID                      = 'mdia',
   MediaHeaderAID                = 'mdhd',
   MediaInfoAID                  = 'minf',
   VideoMediaInfoHeaderAID       = 'vmhd',
   SoundMediaInfoHeaderAID       = 'smhd',
   GenericMediaInfoHeaderAID     = 'gmhd',
   GenericMediaInfoAID           = 'gmin',
   DataInfoAID                   = 'dinf',
   DataRefAID                    = 'dref',
   SampleTableAID                = 'stbl',
   STSampleDescAID               = 'stsd',
   STTimeToSampAID               = 'stts',
   STSyncSampleAID               = 'stss',
   STSampleToChunkAID            = 'stsc',
   STShadowSyncAID               = 'stsh',
   HandlerAID                    = 'hdlr',
   STSampleSizeAID               = 'stsz',
   STChunkOffsetAID              = 'stco',
   STChunkOffset64AID            = 'co64',
   STSampleIDAID                 = 'stid',
   STCompositionOffsetAID        = 'ctts',
   STSampleDependencyAID         = 'sdtp',
   STCompositionShiftLeastGreatestAID = 'cslg',
   STPartialSyncSampleAID        = 'stps',
   DataRefContainerAID           = 'drfc',
   TrackReferenceAID             = 'tref',
   ColorTableAID                 = 'ctab',
   LoadSettingsAID               = 'load',
   PropertyAtomAID               = 'code',
   InputMapAID                   = 'imap',
   MovieBufferHintsAID           = 'mbfh',
   MovieDataRefAliasAID          = 'mdra',
   SoundLocalizationAID          = 'sloc',
   CompressedMovieAID            = 'cmov',
   CompressedMovieDataAID        = 'cmvd',
   DataCompressionAtomAID        = 'dcom',
   ReferenceMovieRecordAID       = 'rmra',
   ReferenceMovieDescriptorAID   = 'rmda',
   ReferenceMovieDataRefAID      = 'rdrf',
   ReferenceMovieVersionCheckAID = 'rmvc',
   ReferenceMovieDataRateAID     = 'rmdr',
   ReferenceMovieComponentCheckAID = 'rmcd',
   ReferenceMovieQualityAID      = 'rmqu',
   ReferenceMovieLanguageAID     = 'rmla',
   ReferenceMovieCPURatingAID    = 'rmcs',
   ReferenceMovieAlternateGroupAID = 'rmag',
   ReferenceMovieNetworkStatusAID = 'rnet',
   CloneMediaAID                 = 'clon',
   FileTypeAID                   = 'ftyp',
   SecureContentInfoAID          = 'sinf',
   SecureContentSchemeTypeAID    = 'schm',
   SecureContentSchemeInfoAID    = 'schi'
};
enum {
   MovieResourceAtomType         = 'moov',
   MovieDataAtomType             = 'mdat',
   FreeAtomType                  = 'free',
   SkipAtomType                  = 'skip',
   WideAtomPlaceholderType       = 'wide'
};
enum {
   quickTimeImageFileImageDescriptionAtom = 'idsc',
   quickTimeImageFileImageDataAtom = 'idat',
   quickTimeImageFileMetaDataAtom = 'meta',
   quickTimeImageFileColorSyncProfileAtom = 'iicc'
};
Constants
kMovieMediaDefaultDataReferenceID

Atom id. 

Available in Mac OS X v10.0 and later.
kMovieMediaSlaveTime

Boolean. 

Available in Mac OS X v10.0 and later.
kMovieMediaSlaveGraphicsMode

Boolean. 

Available in Mac OS X v10.0 and later.
kMovieMediaBackgroundColor

RGBColor.. 

Available in Mac OS X v10.0 and later.
kMovieMediaPrerollTime

SInt32 indicating preroll time. 

Available in Mac OS X v10.0 and later.
kQTParseTextHREFText

String. 

Available in Mac OS X v10.0 and later.
kQTEnableExif

UInt8 (Boolean). 

Available in Mac OS X v10.1 and later.
kTargetChildMovieTrackIndex

(long childMovieTrackIndex). 

Available in Mac OS X v10.0 and later.
kTargetChildMovieMovieName

(PString childMovieName). 

Available in Mac OS X v10.0 and later.
kTargetTrackType

(OSType trackType). 

Available in Mac OS X v10.0 and later.
kTargetTrackIndex

(long trackIndex). 

Available in Mac OS X v10.0 and later.
kTargetSpriteName

(PString spriteName). 

Available in Mac OS X v10.0 and later.
kTargetSpriteID

(QTAtomID spriteID). 

Available in Mac OS X v10.0 and later.
kTargetQD3DNamedObjectName

(CString objectName). 

Available in Mac OS X v10.0 and later.
kTargetCurrentQTEventParams

No data. 

Available in Mac OS X v10.0 and later.*/
enum {
   ConnectionSpeedPrefsType      = 'cspd',
   ConnectionSpeedIsValidPrefsType = 'vspd'
};
enum {
   kEffectNameAtom               = 'name',
   /* name of effect */
   kEffectTypeAtom               = 'type',
   /* codec sub-type for effect */
   kEffectManufacturerAtom       = 'manu' /* codec manufacturer for effect */
};
enum {
   kGraphicsExportGroup          = 'expo',
   kGraphicsExportFileType       = 'ftyp',
   kGraphicsExportMIMEType       = 'mime',
   kGraphicsExportExtension      = 'ext ',
   kGraphicsExportDescription    = 'desc'
};
enum {
   kInputMapSubInputID           = 'subi'
};
enum {
   kMovieMediaDataReference      = 'mmdr',
   /* data reference*/
   kMovieMediaDefaultDataReferenceID = 'ddri',
   /* atom id*/
   kMovieMediaSlaveTime          = 'slti',
   /* boolean*/
   kMovieMediaSlaveAudio         = 'slau',
   /* boolean*/
   kMovieMediaSlaveGraphicsMode  = 'slgr',
   /* boolean*/
   kMovieMediaAutoPlay           = 'play',
   /* boolean*/
   kMovieMediaLoop               = 'loop',
   /* UInt8 (0=no loop,
   1=loop,
   2=palindrome loop)*/
   kMovieMediaUseMIMEType        = 'mime',
   /* string indicating the MIME type to use for the dataref (usually not required)*/
   kMovieMediaTitle              = 'titl',
   /* string of the media's title (tooltips)*/
   kMovieMediaAltText            = 'altt',
   /* string of alternate text if media isn't loaded*/
   kMovieMediaClipBegin          = 'clpb',
   /* MovieMediaTimeRecord of start time of embedded media*/
   kMovieMediaClipDuration       = 'clpd',
   /* MovieMediaTimeRecord of duration of embedded media*/
   kMovieMediaRegionAtom         = 'regi',
   /* contains subatoms that describe layout*/
   kMovieMediaSlaveTrackDuration = 'sltr',
   /* Boolean indicating that media handler should adjust track and media based on actual embedded movie duration*/
   kMovieMediaEnableFrameStepping = 'enfs',
   /* boolean. if true stepping on external movie steps frames within embedded movie.*/
   kMovieMediaBackgroundColor    = 'bkcl',
   /* RGBColor.*/
   kMovieMediaPrerollTime        = 'prer' /* SInt32 indicating preroll time*/
};
enum {
   kMovieMediaSpatialAdjustment  = 'fit ',
   /* OSType from kMovieMediaFit**/
   kMovieMediaRectangleAtom      = 'rect',
   kMovieMediaTop                = 'top ',
   kMovieMediaLeft               = 'left',
   kMovieMediaWidth              = 'wd  ',
   kMovieMediaHeight             = 'ht  '
};
enum {
   kQTEventType                  = 'evnt',
   kAction                       = 'actn',
   kWhichAction                  = 'whic',
   kActionParameter              = 'parm',
   kActionTarget                 = 'targ',
   kActionFlags                  = 'flag',
   kActionParameterMinValue      = 'minv',
   kActionParameterMaxValue      = 'maxv',
   kActionListAtomType           = 'list',
   kExpressionContainerAtomType  = 'expr',
   kConditionalAtomType          = 'test',
   kOperatorAtomType             = 'oper',
   kOperandAtomType              = 'oprn',
   kCommentAtomType              = 'why ',
   kCustomActionHandler          = 'cust',
   kCustomHandlerID              = 'id  ',
   kCustomHandlerDesc            = 'desc',
   kQTEventRecordAtomType        = 'erec'
};
enum {
   kQTParseTextHREFText          = 'text',
   /* string*/
   kQTParseTextHREFBaseURL       = 'burl',
   /* string*/
   kQTParseTextHREFClickPoint    = 'clik',
   /* Point; if present,
   QTParseTextHREF will expand URLs to support server-side image maps*/
   kQTParseTextHREFUseAltDelim   = 'altd',
   /* boolean; if no kQTParseTextHREFDelimiter,
   delim is ':'*/
   kQTParseTextHREFDelimiter     = 'delm',
   /* character*/
   kQTParseTextHREFRecomposeHREF = 'rhrf' /* Boolean; if true,
   QTParseTextHREF returns recomposed HREF with URL expanded as appropriate*/
};
enum {
   kQTResolutionSettings         = 'reso',
   kQTTargetDataSize             = 'dasz',
   kQTDontRecompress             = 'dntr',
   kQTInterlaceStyle             = 'ilac',
   kQTColorSyncProfile           = 'iccp',
   kQTThumbnailSettings          = 'thum',
   kQTEnableExif                 = 'exif',
   /* UInt8 (boolean)*/
   kQTMetaData                   = 'meta'
};
enum {
   kQTSConnectionPrefsType       = 'stcm',
   /* root atom that all other atoms are contained in*/
   /*    kQTSNotUsedForProxyPrefsType = 'nopr',
   //        comma-delimited list of URLs that are never used for proxies*/
   kQTSConnectionMethodPrefsType = 'mthd',
   /*      connection method (OSType that matches one of the following three)*/
   kQTSDirectConnectPrefsType    = 'drct',
   /*       used if direct connect (QTSDirectConnectPrefsRecord)*/
   /*    kQTSRTSPProxyPrefsType =     'rtsp',
   //   used if RTSP Proxy (QTSProxyPrefsRecord)*/
   kQTSSOCKSPrefsType            = 'sock' /*       used if SOCKS Proxy (QTSProxyPrefsRecord)*/
};
enum {
   kQTSNullNotification          = 'null',
   /* NULL */
   kQTSErrorNotification         = 'err ',
   /* QTSErrorParams*,
   optional */
   kQTSNewPresDetectedNotification = 'newp',
   /* QTSNewPresDetectedParams* */
   kQTSPresBeginChangingNotification = 'prcb',
   /* NULL */
   kQTSPresDoneChangingNotification = 'prcd',
   /* NULL */
   kQTSPresentationChangedNotification = 'prch',
   /* NULL */
   kQTSNewStreamNotification     = 'stnw',
   /* QTSNewStreamParams* */
   kQTSStreamBeginChangingNotification = 'stcb',
   /* QTSStream */
   kQTSStreamDoneChangingNotification = 'stcd',
   /* QTSStream */
   kQTSStreamChangedNotification = 'stch',
   /* QTSStreamChangedParams* */
   kQTSStreamGoneNotification    = 'stgn',
   /* QTSStreamGoneParams* */
   kQTSPreviewAckNotification    = 'pvak',
   /* QTSStream */
   kQTSPrerollAckNotification    = 'pack',
   /* QTSStream */
   kQTSStartAckNotification      = 'sack',
   /* QTSStream */
   kQTSStopAckNotification       = 'xack',
   /* QTSStream */
   kQTSStatusNotification        = 'stat',
   /* QTSStatusParams* */
   kQTSURLNotification           = 'url ',
   /* QTSURLParams* */
   kQTSDurationNotification      = 'dura',
   /* QTSDurationAtom* */
   kQTSNewPresentationNotification = 'nprs',
   /* QTSPresentation */
   kQTSPresentationGoneNotification = 'xprs',
   /* QTSPresentation */
   kQTSPresentationDoneNotification = 'pdon',
   /* NULL */
   kQTSBandwidthAlertNotification = 'bwal',
   /* QTSBandwidthAlertParams* */
   kQTSAnnotationsChangedNotification = 'meta' /* NULL */
};
enum {
   kQTSStatisticsInfo            = 'stat',
   /* QTSStatisticsParams* */
   kQTSMinStatusDimensionsInfo   = 'mstd',
   /* QTSDimensionParams* */
   kQTSNormalStatusDimensionsInfo = 'nstd',
   /* QTSDimensionParams* */
   kQTSTotalDataRateInfo         = 'drtt',
   /* UInt32*,
   add to what's there */
   kQTSTotalDataRateInInfo       = 'drti',
   /* UInt32*,
   add to what's there */
   kQTSTotalDataRateOutInfo      = 'drto',
   /* UInt32*,
   add to what's there */
   kQTSLostPercentInfo           = 'lpct',
   /* QTSLostPercentParams*,
   add to what's there */
   kQTSNumViewersInfo            = 'nviw',
   /* UInt32* */
   kQTSMediaTypeInfo             = 'mtyp',
   /* OSType* */
   kQTSNameInfo                  = 'name',
   /* QTSNameParams* */
   kQTSCanHandleSendDataType     = 'chsd',
   /* QTSCanHandleSendDataTypeParams* */
   kQTSAnnotationsInfo           = 'meta',
   /* QTAtomContainer */
   kQTSRemainingBufferTimeInfo   = 'btms',
   /* UInt32* remaining buffer time before playback,
   in microseconds */
   kQTSInfo_SettingsText         = 'sttx',
   /* QTSSettingsTextParams* */
   kQTSInfo_AverageFrameRate     = 'fps ' /* UnsignedFixed* */
};
enum {
   kQTSStreamMediaType           = 'strm'
};
enum {
   kQTSTargetBufferDurationInfo  = 'bufr',
   /* Fixed* in seconds; expected,
   not actual */
   kQTSDurationInfo              = 'dura',
   /* QTSDurationAtom* */
   kQTSSoundLevelMeteringEnabledInfo = 'mtrn',
   /* Boolean* */
   kQTSSoundLevelMeterInfo       = 'levm',
   /* LevelMeterInfoPtr */
   kQTSSourceTrackIDInfo         = 'otid',
   /* UInt32* */
   kQTSSourceLayerInfo           = 'olyr',
   /* UInt16* */
   kQTSSourceLanguageInfo        = 'olng',
   /* UInt16* */
   kQTSSourceTrackFlagsInfo      = 'otfl',
   /* SInt32* */
   kQTSSourceDimensionsInfo      = 'odim',
   /* QTSDimensionParams* */
   kQTSSourceVolumesInfo         = 'ovol',
   /* QTSVolumesParams* */
   kQTSSourceMatrixInfo          = 'omat',
   /* MatrixRecord* */
   kQTSSourceClipRectInfo        = 'oclp',
   /* Rect* */
   kQTSSourceGraphicsModeInfo    = 'ogrm',
   /* QTSGraphicsModeParams* */
   kQTSSourceScaleInfo           = 'oscl',
   /* Point* */
   kQTSSourceBoundingRectInfo    = 'orct',
   /* Rect* */
   kQTSSourceUserDataInfo        = 'oudt',
   /* UserData */
   kQTSSourceInputMapInfo        = 'oimp',
   /* QTAtomContainer */
   kQTSInfo_DataProc             = 'datp',
   /* QTSDataProcParams* */
   kQTSInfo_SendDataExtras       = 'dext',
   /* QTSSendDataExtrasParams* */
   kQTSInfo_HintTrackID          = 'htid',
   /* long* */
   kQTSInfo_URL                  = 'url ',
   /* Handle*,
   cstring in handle */
   kQTSInfo_Authentication       = 'auup',
   /* QTSAuthenticationParams */
   kQTSInfo_MediaPacketizer      = 'rmpk' /* ComponentInstance */
};
enum {
   kQTVRNodeHeaderAtomType       = 'ndhd',
   kQTVRHotSpotParentAtomType    = 'hspa',
   kQTVRHotSpotAtomType          = 'hots',
   kQTVRHotSpotInfoAtomType      = 'hsin',
   kQTVRLinkInfoAtomType         = 'link'
};
enum {
   kQTVRObjectInfoAtomID         = 1,
   kQTVRObjectImageTrackRefAtomID = 1,
   /* New with 2.1,
   it adds a track reference to select between multiple image tracks*/
   kQTVRObjectHotSpotTrackRefAtomID = 1  /* New with 2.1,
   it adds a track reference to select between multiple hotspot tracks*/
};
enum {
   kQTVRStringAtomType           = 'vrsg',
   kQTVRStringEncodingAtomType   = 'vrse',
   /* New with 2.1*/
   kQTVRPanoSampleDataAtomType   = 'pdat',
   kQTVRObjectInfoAtomType       = 'obji',
   kQTVRImageTrackRefAtomType    = 'imtr',
   /* Parent is kQTVRObjectInfoAtomType. Required if track ref is not 1 as required by 2.0 format.*/
   kQTVRHotSpotTrackRefAtomType  = 'hstr',
   /* Parent is kQTVRObjectInfoAtomType. Required if track ref is not 1 as required by 2.0 format.*/
   kQTVRAngleRangeAtomType       = 'arng',
   kQTVRTrackRefArrayAtomType    = 'tref',
   kQTVRPanConstraintAtomType    = 'pcon',
   kQTVRTiltConstraintAtomType   = 'tcon',
   kQTVRFOVConstraintAtomType    = 'fcon',
   kQTVRCubicViewAtomType        = 'cuvw',
   /* New with 5.0*/
   kQTVRCubicFaceDataAtomType    = 'cufa' /* New with 5.0*/
};
enum {
//   kQTVRWorldHeaderAtomType      = 'vrsc',
   //kQTVRImagingParentAtomType    = 'imgp',
   //kQTVRPanoImagingAtomType      = 'impn',
   //kQTVRObjectImagingAtomType    = 'imob',
   //kQTVRNodeParentAtomType       = 'vrnp',
   //kQTVRNodeIDAtomType           = 'vrni',
   //kQTVRNodeLocationAtomType     = 'nloc',
   kQTVRCursorParentAtomType     = 'vrcp',
   /* New with 2.1*/
   kQTVRCursorAtomType           = 'CURS',
   /* New with 2.1*/
   kQTVRColorCursorAtomType      = 'crsr' /* New with 2.1*/
};
enum {
   kSpriteAtomType               = 'sprt',
   kSpriteImagesContainerAtomType = 'imct',
   kSpriteImageAtomType          = 'imag',
   kSpriteImageDataAtomType      = 'imda',
   kSpriteImageDataRefAtomType   = 'imre',
   kSpriteImageDataRefTypeAtomType = 'imrt',
   kSpriteImageGroupIDAtomType   = 'imgr',
   kSpriteImageRegistrationAtomType = 'imrg',
   kSpriteImageDefaultImageIndexAtomType = 'defi',
   kSpriteSharedDataAtomType     = 'dflt',
   kSpriteNameAtomType           = 'name',
   kSpriteImageNameAtomType      = 'name',
   kSpriteUsesImageIDsAtomType   = 'uses',
   /* leaf data is an array of QTAtomID's,
   one per image used*/
   kSpriteBehaviorsAtomType      = 'beha',
   kSpriteImageBehaviorAtomType  = 'imag',
   kSpriteCursorBehaviorAtomType = 'crsr',
   kSpriteStatusStringsBehaviorAtomType = 'sstr',
   kSpriteVariablesContainerAtomType = 'vars',
   kSpriteStringVariableAtomType = 'strv',
   kSpriteFloatingPointVariableAtomType = 'flov'
};
enum {
   kTargetMovie                  = 'moov',
   /* no data */
   kTargetMovieName              = 'mona',
   /* (PString movieName) */
   kTargetMovieID                = 'moid',
   /* (long movieID) */
   kTargetRootMovie              = 'moro',
   /* no data */
   kTargetParentMovie            = 'mopa',
   /* no data */
   kTargetChildMovieTrackName    = 'motn',
   /* (PString childMovieTrackName) */
   kTargetChildMovieTrackID      = 'moti',
   /* (long childMovieTrackID) */
   kTargetChildMovieTrackIndex   = 'motx',
   /* (long childMovieTrackIndex) */
   kTargetChildMovieMovieName    = 'momn',
   /* (PString childMovieName) */
   kTargetChildMovieMovieID      = 'momi',
   /* (long childMovieID) */
   kTargetTrackName              = 'trna',
   /* (PString trackName) */
   kTargetTrackID                = 'trid',
   /* (long trackID) */
   kTargetTrackType              = 'trty',
   /* (OSType trackType) */
   kTargetTrackIndex             = 'trin',
   /* (long trackIndex) */
   kTargetSpriteName             = 'spna',
   /* (PString spriteName) */
   kTargetSpriteID               = 'spid',
   /* (QTAtomID spriteID) */
   kTargetSpriteIndex            = 'spin',
   /* (short spriteIndex) */
   kTargetQD3DNamedObjectName    = 'nana',
   /* (CString objectName) */
   kTargetCurrentQTEventParams   = 'evpa' /* no data */
};
enum {
   kTrackModifierInput           = 0x696E,
   /* is really 'in'*/
   kTrackModifierType            = 0x7479,
   /* is really 'ty'*/
   kTrackModifierReference       = 'ssrc',
   kTrackModifierObjectID        = 'obid',
   kTrackModifierInputName       = 'name'
};
enum {
   kTrackPropertyMediaType       = 'mtyp',
   /* OSType*/
   kTrackPropertyInstantiation   = 'inst' /* MovieMediaInstantiationInfoRecord*/
};
enum {
   kTrackReferenceChapterList    = 'chap',
   kTrackReferenceTimeCode       = 'tmcd',
   kTrackReferenceModifier       = 'ssrc'
};
enum {
   kTweenEntry                   = 'twen',
   kTweenData                    = 'data',
   kTweenType                    = 'twnt',
   kTweenStartOffset             = 'twst',
   kTweenDuration                = 'twdu',
   kTweenFlags                   = 'flag',
   kTweenOutputMin               = 'omin',
   kTweenOutputMax               = 'omax',
   kTweenSequenceElement         = 'seqe',
   kTween3dInitialCondition      = 'icnd',
   kTweenInterpolationID         = 'intr',
   kTweenRegionData              = 'qdrg',
   kTweenPictureData             = 'PICT',
   kListElementType              = 'type',
   kListElementDataType          = 'daty',
   kNameAtom                     = 'name',
   kInitialRotationAtom          = 'inro',
   kNonLinearTweenHeader         = 'nlth'
};
enum {
   MovieAID                      = 'moov',
   MovieHeaderAID                = 'mvhd',
   ClipAID                       = 'clip',
   RgnClipAID                    = 'crgn',
   MatteAID                      = 'matt',
   MatteCompAID                  = 'kmat',
   TrackAID                      = 'trak',
   UserDataAID                   = 'udta',
   TrackHeaderAID                = 'tkhd',
   EditsAID                      = 'edts',
   EditListAID                   = 'elst',
   MediaAID                      = 'mdia',
   MediaHeaderAID                = 'mdhd',
   MediaInfoAID                  = 'minf',
   VideoMediaInfoHeaderAID       = 'vmhd',
   SoundMediaInfoHeaderAID       = 'smhd',
   GenericMediaInfoHeaderAID     = 'gmhd',
   GenericMediaInfoAID           = 'gmin',
   DataInfoAID                   = 'dinf',
   DataRefAID                    = 'dref',
   SampleTableAID                = 'stbl',
   STSampleDescAID               = 'stsd',
   STTimeToSampAID               = 'stts',
   STSyncSampleAID               = 'stss',
   STSampleToChunkAID            = 'stsc',
   STShadowSyncAID               = 'stsh',
   HandlerAID                    = 'hdlr',
   STSampleSizeAID               = 'stsz',
   STChunkOffsetAID              = 'stco',
   STChunkOffset64AID            = 'co64',
   STSampleIDAID                 = 'stid',
   STCompositionOffsetAID        = 'ctts',
   STSampleDependencyAID         = 'sdtp',
   STCompositionShiftLeastGreatestAID = 'cslg',
   STPartialSyncSampleAID        = 'stps',
   DataRefContainerAID           = 'drfc',
   TrackReferenceAID             = 'tref',
   ColorTableAID                 = 'ctab',
   LoadSettingsAID               = 'load',
   PropertyAtomAID               = 'code',
   InputMapAID                   = 'imap',
   MovieBufferHintsAID           = 'mbfh',
   MovieDataRefAliasAID          = 'mdra',
   SoundLocalizationAID          = 'sloc',
   CompressedMovieAID            = 'cmov',
   CompressedMovieDataAID        = 'cmvd',
   DataCompressionAtomAID        = 'dcom',
   ReferenceMovieRecordAID       = 'rmra',
   ReferenceMovieDescriptorAID   = 'rmda',
   ReferenceMovieDataRefAID      = 'rdrf',
   ReferenceMovieVersionCheckAID = 'rmvc',
   ReferenceMovieDataRateAID     = 'rmdr',
   ReferenceMovieComponentCheckAID = 'rmcd',
   ReferenceMovieQualityAID      = 'rmqu',
   ReferenceMovieLanguageAID     = 'rmla',
   ReferenceMovieCPURatingAID    = 'rmcs',
   ReferenceMovieAlternateGroupAID = 'rmag',
   ReferenceMovieNetworkStatusAID = 'rnet',
   CloneMediaAID                 = 'clon',
   FileTypeAID                   = 'ftyp',
   SecureContentInfoAID          = 'sinf',
   SecureContentSchemeTypeAID    = 'schm',
   SecureContentSchemeInfoAID    = 'schi'
};
enum {
   MovieResourceAtomType         = 'moov',
   MovieDataAtomType             = 'mdat',
   FreeAtomType                  = 'free',
   SkipAtomType                  = 'skip',
   WideAtomPlaceholderType       = 'wide'
};
enum {
   quickTimeImageFileImageDescriptionAtom = 'idsc',
   quickTimeImageFileImageDataAtom = 'idat',
   quickTimeImageFileMetaDataAtom = 'meta',
   quickTimeImageFileColorSyncProfileAtom = 'iicc'
};

/*QTAtomID

Abst_QTAtomID

typedef long QTAtomID;
Availability
Available in Mac OS X v10.0 and later.*/
typedef long QTAtomID;

/*QTAtomType

Represents a type used by the Movie Toolkit API.

typedef long QTAtomType;
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
typedef long QTAtomType;


/*QTAtom

Abst_QTAtom

typedef long QTAtom;
Availability
Available in Mac OS X v10.0 and later.*/
typedef long QTAtom;

/*QTAtomContainer

Abst_QTAtomContainer

typedef Handle QTAtomContainer;
Availability
Available in Mac OS X v10.0 and later.*/
typedef Handle QTAtomContainer;

/*MovieController

Abst_MovieController

typedef ComponentInstance MovieController;
Availability
Available in Mac OS X v10.0 and later.*/
typedef ComponentInstance MovieController;

/*Discussion

The following constants identify sound description properties.
enum {
    kQTSoundDescriptionPropertyID_AudioChannelLayout = 'clay',
    kQTSoundDescriptionPropertyID_MagicCookie = 'kuki',
    kQTSoundDescriptionPropertyID_AudioStreamBasicDescription = 'asbd',
    kQTSoundDescriptionPropertyID_UserReadableText = 'text'
};

Special Considerations
kQTSoundDescriptionPropertyID_AudioChannelLayout = 'clay'

Used to get or set an AudioChannelLayout value. This is a variable-size property because it may contain an array of Channel Descriptions. You must get the size by calling QTSoundDescriptionGetPropertyInfo, allocate a structure of that size, and then get the property.
kQTSoundDescriptionPropertyID_MagicCookie = 'kuki'

Used to get or set opaque bytes. This is a variable-size property, because it is completely defined by the codec that uses the cookie. You must get the size by calling QTSoundDescriptionGetPropertyInfo, allocate a structure of that size, and then get the property.
kQTSoundDescriptionPropertyID_AudioStreamBasicDescription = 'asbd'

Used to get an AudioStreamBasicDescription value.
kQTSoundDescriptionPropertyID_UserReadableText = 'text'

Used to get a CFStringRef value. QTSoundDescriptionGetProperty does a CFRetain of the returned CFString on behalf of the caller, so the caller is responsible for calling CFRelease on the returned CFString.
Version Notes

Introduced in QuickTime 7.
Availability
Carbon status: Supported C interface file: Movies.h*/
enum {
    kQTSoundDescriptionPropertyID_AudioChannelLayout = 'clay',
    kQTSoundDescriptionPropertyID_MagicCookie = 'kuki',
    kQTSoundDescriptionPropertyID_AudioStreamBasicDescription = 'asbd',
    kQTSoundDescriptionPropertyID_UserReadableText = 'text'
};



/*Media Identifiers

Identify media types in QuickTime.

enum {
   VideoMediaType                = 'vide',
   SoundMediaType                = 'soun',
   TextMediaType                 = 'text',
   BaseMediaType                 = 'gnrc',
   MPEGMediaType                 = 'MPEG',
   MusicMediaType                = 'musi',
   TimeCodeMediaType             = 'tmcd',
   SpriteMediaType               = 'sprt',
   FlashMediaType                = 'flsh',
   MovieMediaType                = 'moov',
   TweenMediaType                = 'twen',
   ThreeDeeMediaType             = 'qd3d',
   SkinMediaType                 = 'skin',
   HandleDataHandlerSubType      = 'hndl',
   PointerDataHandlerSubType     = 'ptr ',
   NullDataHandlerSubType        = 'null',
   ResourceDataHandlerSubType    = 'rsrc',
   URLDataHandlerSubType         = 'url ',
   AliasDataHandlerSubType       = 'alis',
   WiredActionHandlerType        = 'wire'
};
Constants
SoundMediaType

Sound channel. 

Available in Mac OS X v10.0 and later.
TextMediaType

Text media. 

Available in Mac OS X v10.0 and later.*/
enum {
   VideoMediaType                = 'vide',
   SoundMediaType                = 'soun',
   TextMediaType                 = 'text',
   BaseMediaType                 = 'gnrc',
   MPEGMediaType                 = 'MPEG',
   MusicMediaType                = 'musi',
   TimeCodeMediaType             = 'tmcd',
   SpriteMediaType               = 'sprt',
   FlashMediaType                = 'flsh',
   MovieMediaType                = 'moov',
   TweenMediaType                = 'twen',
   ThreeDeeMediaType             = 'qd3d',
   SkinMediaType                 = 'skin',
   HandleDataHandlerSubType      = 'hndl',
   PointerDataHandlerSubType     = 'ptr ',
   NullDataHandlerSubType        = 'null',
   ResourceDataHandlerSubType    = 'rsrc',
   URLDataHandlerSubType         = 'url ',
   AliasDataHandlerSubType       = 'alis',
   WiredActionHandlerType        = 'wire'
};

/*New Movie Properties

Constants that represent the properties of new movies.

enum {
   newMovieActive                = 1 << 0,
   newMovieDontResolveDataRefs   = 1 << 1,
   newMovieDontAskUnresolvedDataRefs = 1 << 2,
   newMovieDontAutoAlternates    = 1 << 3,
   newMovieDontUpdateForeBackPointers = 1 << 4,
   newMovieDontAutoUpdateClock   = 1 << 5,
   newMovieAsyncOK               = 1 << 8,
   newMovieIdleImportOK          = 1 << 10,
   newMovieDontInteractWithUser  = 1 << 11
};*/
enum {
   newMovieActive                = 1 << 0,
   newMovieDontResolveDataRefs   = 1 << 1,
   newMovieDontAskUnresolvedDataRefs = 1 << 2,
   newMovieDontAutoAlternates    = 1 << 3,
   newMovieDontUpdateForeBackPointers = 1 << 4,
   newMovieDontAutoUpdateClock   = 1 << 5,
   newMovieAsyncOK               = 1 << 8,
   newMovieIdleImportOK          = 1 << 10,
   newMovieDontInteractWithUser  = 1 << 11
};

/*SampleDescriptionPtr

Abst_SampleDescriptionPtr

typedef SampleDescription * SampleDescriptionPtr;
Availability
Available in Mac OS X v10.0 and later.*/
typedef SampleDescription * SampleDescriptionPtr;

/*SoundDescriptionPtr

Abst_SoundDescriptionPtr

typedef SoundDescription * SoundDescriptionPtr;
Availability
Available in Mac OS X v10.0 and later.*/
typedef SoundDescription * SoundDescriptionPtr;


/*SampleDescriptionHandle

Abst_SampleDescriptionHandle

typedef SampleDescriptionPtr * SampleDescriptionHandle;
Availability
Available in Mac OS X v10.0 and later.*/
typedef SampleDescriptionPtr * SampleDescriptionHandle;


/*SoundDescriptionHandle

Abst_SoundDescriptionHandle

typedef SoundDescriptionPtr * SoundDescriptionHandle;
Availability
Available in Mac OS X v10.0 and later.*/
typedef SoundDescriptionPtr * SoundDescriptionHandle;

/*TrackRecord

Contains a track.

struct TrackRecord {
   long    data[1];
};
Fields
data
Discussion

An array of track data.
Programming Info
C interface file: Movies.h*/
struct TrackRecord {
   long    data[1];
};
typedef struct TrackRecord  TrackRecord  ;
/*Track

Abst_Track

typedef TrackRecord * Track;
Availability
Available in Mac OS X v10.0 and later.*/
typedef TrackRecord * Track;

/*MediaRecord

Undocumented

struct MediaRecord {
   long    data[1];
};
Fields
data
Discussion

Undocumented
Programming Info
C interface file: Movies.h*/
struct MediaRecord {
   long    data[1];
};
typedef struct MediaRecord  MediaRecord;
/*Media

Abst_Media

typedef MediaRecord * Media;
Availability
Available in Mac OS X v10.0 and later.*/
typedef MediaRecord * Media;

/*MovieRecord

Undocumented

struct MovieRecord {
   long    data[1];
};
Fields
data
Discussion

Undocumented
Programming Info
C interface file: Movies.h*/
struct MovieRecord {
   long    data[1];
};
typedef  struct MovieRecord MovieRecord;
/*Abst_Movie

typedef MovieRecord * Movie;
Availability
Available in Mac OS X v10.0 and later.*/
typedef MovieRecord * Movie;


/*DataHandler

Abst_DataHandler

typedef ComponentInstance DataHandler;
Availability
Available in Mac OS X v10.0 and later.
Movies.h*/
typedef ComponentInstance DataHandler;


/*QTAtomContainer

Abst_QTAtomContainer

typedef Handle QTAtomContainer;
Availability
Available in Mac OS X v10.0 and later.*/
typedef Handle QTAtomContainer;

/*ivate:
    /*
        typedef OSErr (*MovieDrawingCompleteProcPtr) (Movie theMovie, long refCon);
     *
    static pascal OSErr MyClassMovieDrawingCompleteProc(Movie theMovie, long refCon);
    static MovieDrawingCompleteUPP sMovieDrawingCompleteUPP;
           Movie                   mMovie;*/
typedef OSErr (*MovieDrawingCompleteProcPtr) (Movie theMovie, long refCon);

/*MovieDrawingCompleteUPP

Abst_MovieDrawingCompleteUPP

typedef STACK_UPP_TYPE(MovieDrawingCompleteProcPtr) MovieDrawingCompleteUPP;*/
typedef STACK_UPP_TYPE(MovieDrawingCompleteProcPtr) MovieDrawingCompleteUPP;

/*Data References

The Movie Toolbox fully supports a media that refers to data in more than one file. By allowing a single media to refer to more than one file, the toolbox allows better playback performance and easier editing, primarily by reducing the number of tracks in a movie. Use the SetMediaDefaultDataRefIndex function to control which of a media’s files you access when you add new sample data.

To fully specify a data reference, it is necessary to provide the data reference itself, along with its type; the data reference handle does not contain the type of the data reference. The DataReferenceRecord data structure contains both of these pieces of information, making it possible to pass them to functions as a single parameter. The FlattenMovieData function uses the information in the data reference structure to flatten a movie to a data reference instead of to a file.
struct DataReferenceRecord {
    OSType  dataRefType;
    Handle  dataRef;
};
typedef struct DataReferenceRecord DataReferenceRecord;
typedef DataReferenceRecord *DataReferencePtr;

Field	
Definition

dataRefType	
Specifies the type of data reference. For an alias data reference, you set the parameter to rAliasType, indicating that the reference is an alias. For a handle data reference, set the parameter to HandleDataHandlerSubTypeMovie Data Types.

dataRef	
Specifies the actual data reference. This parameter contains a handle to the information that identifies the file to be used. The type of information stored in the handle depends on the value of the dataRefType parameter. For example, if your application is loading the movie from a file, this parameter would contain an alias to the movie file.*/
struct DataReferenceRecord {
    OSType  dataRefType;
    Handle  dataRef;
};
typedef struct DataReferenceRecord DataReferenceRecord;
typedef DataReferenceRecord *DataReferencePtr;

/*QTNextTaskNeededSoonerCallbackProc

Called when QuickTime decides that the next task is needed sooner than previously reported by QTGetTimeUntilNextTask.

typedef void (*QTNextTaskNeededSoonerCallbackProcPtr) (TimeValue duration, unsigned long flags, void *refcon);

If you name your function MyQTNextTaskNeededSoonerCallbackProc, you would declare it this way:

void MyQTNextTaskNeededSoonerCallbackProc (
   TimeValue        duration,
   unsigned long    flags,
   void             *refcon );
Parameters
duration

The new duration to the next task, expressed in the time scale set by a previous call to QTInstallNextTaskNeededSoonerCallback.
flags

Undocumented
refcon

A pointer to a reference constant. You can use this parameter to point to a data structure containing any information your callback may need.
Return Value

See Error Codes. Your callback should return noErr if there is no error.
Discussion

You can use this callback to reschedule the Carbon event loop timer if the next QuickTime task is needed sooner than projected by QTGetTimeUntilNextTask. This callback may be called at interrupt time or from another thread on Mac OS X.
See Also

This callback is installed by QTInstallNextTaskNeededSoonerCallback. See also NewQTNextTaskNeededSoonerCallbackUPP.*/
typedef void (*QTNextTaskNeededSoonerCallbackProcPtr) (TimeValue duration, unsigned long flags, void *refcon);

/*QTNextTaskNeededSoonerCallbackUPP

Abst_QTNextTaskNeededSoonerCallbackUPP

typedef STACK_UPP_TYPE(QTNextTaskNeededSoonerCallbackProcPtr) QTNextTaskNeededSoonerCallbackUPP;*/
typedef STACK_UPP_TYPE(QTNextTaskNeededSoonerCallbackProcPtr) QTNextTaskNeededSoonerCallbackUPP;


/*MCActionFilterWithRefConProc

Responds to movie controller actions with a reference constant.

typedef Boolean (*MCActionFilterWithRefConProcPtr) (MovieController mc, short action, void *params, long refCon);

If you name your function MyMCActionFilterWithRefConProc, you would declare it this way:

Boolean MyMCActionFilterWithRefConProc (
   MovieController    mc,
   short              action,
   void               *params,
   long               refCon );
Parameters
mc

Specifies the movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
action

A movie controller action. For a list of actions, see Chapter 2 of Inside Macintosh: QuickTime Components.
params

A pointer to a structure, such as QTStatusStringRecord, that passes information to the callback. See Movies.h.
refCon

A reference constant that the client code supplies to your callback. You can use this reference to point to a data structure containing any information your callback needs.
Return Value

Undocumented
Declared In
Movies.h, HIMovieView.h*/
typedef Boolean (*MCActionFilterWithRefConProcPtr) (MovieController mc, short action, void *params, long refCon);

/*MCActionFilterWithRefConUPP

Represents a type used by the Movie Controller API.

typedef STACK_UPP_TYPE(MCActionFilterWithRefConProcPtr) MCActionFilterWithRefConUPP;
Declared In
Movies.h, HIMovieView.h*/

typedef STACK_UPP_TYPE(MCActionFilterWithRefConProcPtr) MCActionFilterWithRefConUPP;

/*CallBackRecord

Stores data for a QTCallBackProc.

struct CallBackRecord {
   long    data[1];
};
Fields
data
Discussion

Callback data.
Programming Info
C interface file: Movies.h*/
struct CallBackRecord {
   long    data[1];
};
typedef struct CallBackRecord CallBackRecord;

/*QTCallBack

Abst_QTCallBack

typedef CallBackRecord * QTCallBack;
Availability
Available in Mac OS X v10.0 and later.*/
typedef CallBackRecord * QTCallBack;

/*QTCallBackProc

A generic callback function, installed by CallMeWhen.

typedef void (*QTCallBackProcPtr) (QTCallBack cb, long refCon);

If you name your function MyQTCallBackProc, you would declare it this way:

void MyQTCallBackProc (
   QTCallBack    cb,
   long          refCon );
Parameters
cb

A pointer to a CallBackRecord structure containing the callback's data.
refCon

A reference constant that the client code supplies to your callback. You can use this reference to point to a data structure containing any information your callback needs.
See Also

See the CallMeWhen and NewQTCallBackUPP functions.*/
typedef void (*QTCallBackProcPtr) (QTCallBack cb, long refCon);

/*QTCallBackUPP

Abst_QTCallBackUPP

typedef STACK_UPP_TYPE(QTCallBackProcPtr) QTCallBackUPP;*/
typedef STACK_UPP_TYPE(QTCallBackProcPtr) QTCallBackUPP;

/*QTAudioFrequencyLevels

Stores the frequency meter level settings for the audio channels in a movie mix.

struct QTAudioFrequencyLevels {
   UInt32     numChannels;
   UInt32     numFrequencyBands;
   Float32    level[1];
};
Fields
numChannels
Discussion

The number of audio channels.
numFrequencyBands
Discussion

The number of frequency bands for each channel.
level
Discussion

A 32-bit floating-point value for each frequency band. The frequency bands for each channel are stored contiguously, with all the band levels for the first channel first, all the band levels for the second channel next, etc. The total number of 32-bit values in this field equals numFrequencyBands times numChannels.
Related Functions
Associated function: GetMovieAudioFrequencyLevels 
Declared In
Movies.h*/

typedef struct QTAudioFrequencyLevels {
   UInt32     numChannels;
   UInt32     numFrequencyBands;
   Float32    level[1];
} QTAudioFrequencyLevels;

/*MediaHandler

Abst_MediaHandler

typedef ComponentInstance MediaHandler;
Availability
Available in Mac OS X v10.0 and later.*/
typedef ComponentInstance MediaHandler;

/*TextDescriptionPtr

Represents a type used by the Movie Manager API.

typedef TextDescription * TextDescriptionPtr;
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
typedef TextDescription * TextDescriptionPtr;

/*TextDescriptionHandle

Represents a type used by the Movie Manager API.

typedef TextDescriptionPtr * TextDescriptionHandle;
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
typedef TextDescriptionPtr * TextDescriptionHandle;

/*MovieProgressUPP

Abst_MovieProgressUPP

typedef STACK_UPP_TYPE(MovieProgressProcPtr) MovieProgressUPP;*/
typedef STACK_UPP_TYPE(MovieProgressProcPtr) MovieProgressUPP;

/*QTTweenerRecord

Stores a tween for the QTNewTween function.

struct QTTweenerRecord {
   long    data[1];
};
Fields
data
Discussion

An array of data that constitutes a tween.
Declared In
Movies.h*/

struct QTTweenerRecord {
   long    data[1];
};
typedef struct QTTweenerRecord QTTweenerRecord;

/*QTTweener

Represents a type used by the Movie Toolkit API.

typedef QTTweenerRecord * QTTweener;
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
typedef QTTweenerRecord * QTTweener;


/*TweenerDataProc

A callback the tween component calls with the value generated by a tween operation.

typedef ComponentResult (*TweenerDataProcPtr) (TweenRecord *tr, void *tweenData, long tweenDataSize, long dataDescriptionSeed, Handle dataDescription,
ICMCompletionProcRecordPtr asyncCompletionProc, UniversalProcPtr transferProc, void *refCon);

If you name your function MyTweenerDataProc, you would declare it this way:

ComponentResult MyTweenerDataProc (
   TweenRecord                   *tr,
   void                          *tweenData,
   long                          tweenDataSize,
   long                          dataDescriptionSeed,
   Handle                        dataDescription,
   ICMCompletionProcRecordPtr    asyncCompletionProc,
   UniversalProcPtr              transferProc,
   void                          *refCon );
Parameters
tr

A pointer to the tween record for the tween operation.
tweenData

A pointer to the generated tween value.
tweenDataSize

The size, in bytes, of the tween value.
dataDescriptionSeed

The starting value for the calculation. Every time the content of the dataDescription handle changes, this value should be incremented.
dataDescription

Specifies a handle containing a description of the tween value passed. For basic types such as integers, the calling tween component should set this parameter to NIL. For more complex types such as compressed image data, the calling tween component should set this handle to contain a description of the tween value, such as an image description.
asyncCompletionProc

A pointer to a completion procedure for asynchronous operations. The calling tween component should set the value of this parameter to NIL.
transferProc

A pointer to a procedure to transfer the data. The calling tween component should set the value of this parameter to NIL.
refCon

A pointer to a reference constant. The calling tween component should set the value of this parameter to NIL.
Return Value

See Error Codes. Your callback should return noErr if there is no error.
Declared In
Movies.h*/
typedef struct TweenRecord TweenRecord;

typedef ComponentResult (*TweenerDataProcPtr)(
TweenRecord *tr,
void *tweenData,
long tweenDataSize,
long dataDescriptionSeed,
Handle dataDescription,
ICMCompletionProcRecordPtr asyncCompletionProc,
UniversalProcPtr transferProc,
void *refCon);

/*TweenerDataUPP

Represents a type used by the Movie Toolkit API.

typedef STACK_UPP_TYPE(TweenerDataProcPtr) TweenerDataUPP;
Declared In
Movies.h*/
typedef STACK_UPP_TYPE(TweenerDataProcPtr) TweenerDataUPP;


/*TweenRecord

Passes information to your tween component's TweenDoTween method.

struct TweenRecord {
   long               version;
   QTAtomContainer    container;
   QTAtom             tweenAtom;
   QTAtom             dataAtom;
   Fixed              percent;
   TweenerDataUPP     dataProc;
   void *             private1;
   void *             private2;
};
Fields
version
Discussion

The version number of this structure. This field is initialized to 0.
container
Discussion

The atom container that contains the tween data.
tweenAtom
Discussion

The atom for this tween entry's data in the container.
percent
Discussion

The percentage by which to change the data.
dataProc
Discussion

The procedure the tween component calls to send the tweened value to the receiving track.
private1
Discussion

Reserved.
private2
Discussion

Reserved.
Related Functions
TweenerDataProc
TweenerDoTween 
Declared In
QuickTimeComponents.h*/

struct TweenRecord {
   long               version;
   QTAtomContainer    container;
   QTAtom             tweenAtom;
   QTAtom             dataAtom;
   Fixed              percent;
   TweenerDataUPP     dataProc;
   void *             private1;
   void *             private2;
};

/*MovieRgnCoverProc

Undocumented

typedef OSErr (*MovieRgnCoverProcPtr) (Movie theMovie, RgnHandle changedRgn, long refcon);

If you name your function MyMovieRgnCoverProc, you would declare it this way:

OSErr MyMovieRgnCoverProc (
   Movie        theMovie,
   RgnHandle    changedRgn,
   long         refcon );
Parameters
theMovie

Specifies the movie for this operation.
changedRgn

Undocumented
refcon

A reference constant that the client code supplies to your callback. You can use this reference to point to a data structure containing any information your callback needs.
Return Value

See Error Codes. Your callback should return noErr if there is no error.
Declared In
Movies.h*/
typedef OSErr (*MovieRgnCoverProcPtr) (Movie theMovie, RgnHandle changedRgn, long refcon);

/*MovieRgnCoverUPP

Represents a type used by the Movie Toolkit API.

typedef STACK_UPP_TYPE(MovieRgnCoverProcPtr) MovieRgnCoverUPP;
Declared In
Movies.h*/
typedef STACK_UPP_TYPE(MovieRgnCoverProcPtr) MovieRgnCoverUPP;


//Functions

/*MovieAudioExtractionFillBuffer

Extracts audio from a movie.

OSStatus MovieAudioExtractionFillBuffer (
   MovieAudioExtractionRef    session,
   UInt32                     *ioNumFrames,
   AudioBufferList            *ioData,
   UInt32                     *outFlags );
Parameters
session

The session object returned by MovieAudioExtractionBegin.
ioNumFrames

A pointer to the number of PCM frames to be extracted.
ioData

A pointer to an AudioBufferList allocated by the caller to hold the extracted audio data.
outFlags

A bit flag that indicates when extraction is complete: kMovieAudioExtractionComplete The extraction process is complete. Value is (1L << 0). See these constants: 
Return Value

An error code. Returns noErr if there is no error.
Discussion

You call this function repeatedly; each call continues extracting audio where the last call left off. The function will extract as many of the requested PCM frames as it can, given the limits of the buffer supplied and the limits of the input movie. ioNumFrames will be updated with the exact number of valid frames being returned. When there is no more audio to extract from the movie, the function will continue to return noErr but will return no further audio data. In this case, the outFlags parameter will have its kMovieAudioExtractionComplete bit set. It is possible that the kMovieAudioExtractionComplete bit will accompany the last buffer of valid data.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/



OSStatus MovieAudioExtractionFillBuffer (
   MovieAudioExtractionRef    session,
   UInt32                     *ioNumFrames,
   AudioBufferList           *ioData,
   UInt32                     *outFlags );

/*EnterMovies

Initializes the Movie Toolbox and creates a private storage area for your application.

OSErr EnterMovies ( void );
Return Value

Be sure to check the value returned by this function before using any other facilities of the Movie Toolbox. See Error Codes. Returns noErr if there is no error.
Discussion

Before calling any Movie Toolbox functions, you must use EnterMovies to initialize the toolbox. Your application may call EnterMovies multiple times. The following code sample demonstrates how your application can call the Gestalt Manager to determine whether the Movie Toolbox is installed, using the selector gestaltQuickTime ('qtim'), before calling EnterMovies://Using the Gestalt Manager with the Movie Toolbox
#include <GestaltEqu.h>
#include <Movies.h>
Boolean IsQuickTimeInstalled (void)
{
    short   error;
    long    result;
 
    error =Gestalt (gestaltQuickTime, &result);
    return (error ==noErr);
}
void main (void)
{
    Boolean qtInstalled;
    .
    .
    .
    qtInstalled =IsQuickTimeInstalled ();
}
// EnterMovies coding example
// See "Discovering QuickTime," page 242
void MyInitMovieToolbox (void)
{
    InitGraf(&qd.thePort);
    InitFonts();
    InitWindows();
    InitMenus();
    TEInit();
    InitDialogs(NIL);
    EnterMovies();
}
void main (void)
{
    MyInitMovieToolbox();
    CreateMyCoolMovie();
}

Special Considerations

You should initialize any other Macintosh managers your application uses before calling EnterMovies. You do not need to balance calls to EnterMovies with calls to ExitMovies; you need to call ExitMovies only if you finish with the Movie Toolbox long before your application is ready to quit.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In\
Movies.h*/
OSErr EnterMovies ( void );

/*MovieAudioExtractionSetProperty

Sets a property of a movie audio extraction session.

OSStatus MovieAudioExtractionSetProperty (
   MovieAudioExtractionRef    session,
   QTPropertyClass            inPropClass,
   QTPropertyID               inPropID,
   ByteCount                  inPropValueSize,
   ConstQTPropertyValuePtr    inPropValueAddress );
Parameters
session

The session object returned by MovieAudioExtractionBegin.
inPropClass

Pass the following constant to define the property class: Property of an audio presentation; value is 'audi'.
inPropID

Pass one of these constants to define the property ID: kAudioPropertyID_SummaryChannelLayout The summary audio channel layout of a movie, or any other grouping of audio streams. All like-labeled channels are combined, without duplicates. For example, if there is a stereo (L/R) track, 5 single-channel tracks marked Left, Right, Left Surround, Right Surround and Center, and a 4-channel track marked L/R/Ls/Rs, then the summary AudioChannelLayout will be L/R/Ls/Rs/C, not L/R/L/R/Ls/Rs/C/L/R/Ls/Rs. The value of this constant is 'clay'. See these constants: 
inPropValueSize

The size of the property value.
inPropValueAddress

A const void pointer that points to the property value.
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/OSStatus MovieAudioExtractionSetProperty (
   MovieAudioExtractionRef    session,
   QTPropertyClass            inPropClass,
   QTPropertyID               inPropID,
   ByteCount                  inPropValueSize,
   ConstQTPropertyValuePtr    inPropValueAddress );

/*MovieAudioExtractionBegin

Begins a movie audio extraction session.

OSStatus MovieAudioExtractionBegin (
   Movie                      m,
   UInt32                     flags,
   MovieAudioExtractionRef    *outSession );
Parameters
m

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromProperties, NewMovieFromFile, and NewMovieFromHandle.
flags

Reserved; must be 0.
outSession

A pointer to an opaque session object.
Return Value

An error code. Returns noErr if there is no error.
Discussion

You must call this function before doing any movie audio extraction, because you will pass the object returned by outSession to the other movie audio extraction functions. The format of the extracted audio defaults to the summary channel layout of the movie (all right channels mixed together, all left surround channels mixed together, and so on.), 32-bit float, de-interleaved, with the sample rate set to the highest sample rate found in the movie. You can set the audio format to be something else, as long as it is uncompressed and you do it before your first call to MovieAudioExtractionFillBuffer.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus MovieAudioExtractionBegin (
   Movie                      m,
   UInt32                     flags,
   MovieAudioExtractionRef    *outSession );

/*BeginMediaEdits

Starts a media-editing session.

OSErr BeginMediaEdits (
   Media    theMedia );
Parameters
theMedia

The media for this operation. Your application obtains this media identifier from such functions as NewTrackMedia and GetTrackMedia. See Media Identifiers.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

Use EndMediaEdits to end a media-editing session. You must call BeginMediaEdits before you add samples to a media with the AddMediaSample function. You must also call BeginMediaEdits before calling InsertTrackSegment if you wish InsertTrackSegment to copy media samples instead of copying the segment by reference.// BeginMediaEdits coding example
// See "Discovering QuickTime," page 89
void CreateMyVideoTrack (Movie movie)
{
    Track   track;
    Media   media;
    Rect    rect ={0, 0, 100, 320};
    track =NewMovieTrack(movie,
                FixRatio(rect.right, 1),
                FixRatio(rect.bottom, 1),
                kNoVolume);
    media =NewTrackMedia(track,
                VideoMediaType,
                600,                            // video time scale
                NIL, NIL);
    BeginMediaEdits(media);
    MyAddVideoSamplesToMedia(media, &rect);     // assemble data
    EndMediaEdits(media);
    InsertMediaIntoTrack(track,
                0,                              // track start time
                0,                              // media start time
                GetMediaDuration(media),
                kFix1);                         // normal speed
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr BeginMediaEdits (
   Media    theMedia );

/*NewTrackMedia

Creates a media for a new track.

Media NewTrackMedia (
   Track        theTrack,
   OSType       mediaType,
   TimeScale    timeScale,
   Handle       dataRef,
   OSType       dataRefType );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack.
mediaType

The type of media to create; see Media Identifiers. The Movie Toolbox uses this value to find the correct media handler for the new media. If the Movie Toolbox cannot locate an appropriate media handler, it returns an error.
timeScale

Defines the media's time coordinate system.
dataRef

The data reference. This parameter contains a handle to the information that identifies the file that contains this media's data. The type of information stored in that handle depends upon the value of the dataRefType parameter. If you are creating a new media that refers to existing media data, you can use the GetMediaDataRef function to obtain information about the existing data reference. You can then supply information about that reference to this function. Set this parameter to NIL to use the file that is associated with the movie or if the movie does not have a movie file. For example, if you have created the movie using CreateMovieFile or NewMovieFromFile, the Movie Toolbox assumes that the movie's data resides in the file specified at that time. If you have created the movie using the NewMovieFromScrap or NewMovie functions, the movie does not have a movie file.
dataRefType

The type of data reference; see Data References. If the data reference is an alias, you must set this parameter to rAliasType. See Inside Macintosh: Files for more information about aliases and the Alias Manager.
Return Value

A media identifier, referring to the actual data samples used by the track. If the function cannot create a new media, it sets the returned value to NIL.
Discussion

The following code sample creates a new sprite track and media, then calls BeginMediaEdits to prepare to add samples to the media:// NewTrackMedia coding example
// See "Discovering QuickTime," page 349
#define kSpriteMediaTimeScale           600
track =NewMovieTrack(movie, ((long)lTrackWidth << 16),
                            ((long)lTrackHeight << 16), 0);
media =NewTrackMedia(track, SpriteMediaType,
                            kSpriteMediaTimeScale, NIL, 0);
FailOSErr(BeginMediaEdits(media));

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
Media NewTrackMedia (
   Track        theTrack,
   OSType       mediaType,
   TimeScale    timeScale,
   Handle       dataRef,
   OSType       dataRefType );

/*MovieAudioExtractionGetProperty

Gets a property of a movie audio extraction session.

OSStatus MovieAudioExtractionGetProperty (
   MovieAudioExtractionRef    session,
   QTPropertyClass            inPropClass,
   QTPropertyID               inPropID,
   ByteCount                  inPropValueSize,
   QTPropertyValuePtr         outPropValueAddress,
   ByteCount                  *outPropValueSizeUsed);
Parameters
session

The session object returned by MovieAudioExtractionBegin.
inPropClass

Pass the following constant to define the property class: Property of an audio presentation; value is 'audi'.
inPropID

Pass one of these constants to define the property ID: kAudioPropertyID_ChannelLayout The summary audio channel layout of a movie, or any other grouping of audio streams. All like-labeled channels are combined, without duplicates. For example, if there is a stereo (L/R) track, 5 single-channel tracks marked Left, Right, Left Surround, Right Surround and Center, and a 4-channel track marked L/R/Ls/Rs, then the summary AudioChannelLayout will be L/R/Ls/Rs/C, not L/R/L/R/Ls/Rs/C/L/R/Ls/Rs. The value of this constant is 'clay'. See these constants: 
inPropValueSize

The size of the buffer allocated to receive the property value.
outPropValueAddress

A pointer to the buffer allocated to receive the property value.
outPropValueSizeUsed

The actual size of the property value.
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus MovieAudioExtractionGetProperty (
   MovieAudioExtractionRef    session,
   QTPropertyClass            inPropClass,
   QTPropertyID               inPropID,
   ByteCount                  inPropValueSize,
   QTPropertyValuePtr         outPropValueAddress,
   ByteCount                  *outPropValueSizeUsed);

/*MovieAudioExtractionGetPropertyInfo

Gets information about a property of a movie audio extraction session.

OSStatus MovieAudioExtractionGetPropertyInfo (
   MovieAudioExtractionRef    session,
   QTPropertyClass            inPropClass,
   QTPropertyID               inPropID,
   QTPropertyValueType        *outPropType,
   ByteCount                  *outPropValueSize,
   UInt32                     *outPropertyFlags );
Parameters
session

The session object returned by MovieAudioExtractionBegin.
inPropClass

Pass the following constant to define the property class: Property of an audio presentation; value is 'audi'
inPropID

Pass one of these constants to define the property ID: kAudioPropertyID_ChannelLayout The summary audio channel layout of a movie, or any other grouping of audio streams. All like-labeled channels are combined, without duplicates. For example, if there is a stereo (L/R) track, 5 single-channel tracks marked Left, Right, Left Surround, Right Surround and Center, and a 4-channel track marked L/R/Ls/Rs, then the summary AudioChannelLayout will be L/R/Ls/Rs/C, not L/R/L/R/Ls/Rs/C/L/R/Ls/Rs. The value of this constant is 'clay'. See these constants: 
outPropType

A pointer to the type of the returned property's value.
outPropValueSize

A pointer to the size of the returned property's value.
outPropFlags

On return, a pointer to flags representing the requested information about the item's property.
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus MovieAudioExtractionGetPropertyInfo (
   MovieAudioExtractionRef    session,   QTPropertyClass            inPropClass,
   QTPropertyID               inPropID,
   QTPropertyValueType        *outPropType,
   ByteCount                  *outPropValueSize,
   UInt32                     *outPropertyFlags );

/*MovieAudioExtractionGetProperty

Gets a property of a movie audio extraction session.

OSStatus MovieAudioExtractionGetProperty (
   MovieAudioExtractionRef    session,
   QTPropertyClass            inPropClass,
   QTPropertyID               inPropID,
   ByteCount                  inPropValueSize,
   QTPropertyValuePtr         outPropValueAddress,
   ByteCount                  *outPropValueSizeUsed);
Parameters
session

The session object returned by MovieAudioExtractionBegin.
inPropClass

Pass the following constant to define the property class: Property of an audio presentation; value is 'audi'.
inPropID

Pass one of these constants to define the property ID: kAudioPropertyID_ChannelLayout The summary audio channel layout of a movie, or any other grouping of audio streams. All like-labeled channels are combined, without duplicates. For example, if there is a stereo (L/R) track, 5 single-channel tracks marked Left, Right, Left Surround, Right Surround and Center, and a 4-channel track marked L/R/Ls/Rs, then the summary AudioChannelLayout will be L/R/Ls/Rs/C, not L/R/L/R/Ls/Rs/C/L/R/Ls/Rs. The value of this constant is 'clay'. See these constants: 
inPropValueSize

The size of the buffer allocated to receive the property value.
outPropValueAddress

A pointer to the buffer allocated to receive the property value.
outPropValueSizeUsed

The actual size of the property value.
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus MovieAudioExtractionGetProperty (
   MovieAudioExtractionRef    session,
   QTPropertyClass            inPropClass,
   QTPropertyID               inPropID,
   ByteCount                  inPropValueSize,
   QTPropertyValuePtr         outPropValueAddress,
   ByteCount                  *outPropValueSizeUsed);

/*sertMediaIntoTrack

Inserts a reference to a media segment into a track.

OSErr InsertMediaIntoTrack (
   Track        theTrack,
   TimeValue    trackStart,
   TimeValue    mediaTime,
   TimeValue    mediaDuration,
   Fixed        mediaRate );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack or GetMovieTrack.
trackStart

A time value specifying where the segment is to be inserted. This time value must be expressed in the movie's time scale. If you set this parameter to -1, the media data is added to the end of the track.
mediaTime

A time value specifying the starting point of the segment in the media. This time value must be expressed in the media's time scale.
mediaDuration

A time value specifying the duration of the media's segment. This time value must be expressed in the media's time scale.
mediaRate

The media's rate. A value of 1.0 indicates the media's natural playback rate. This value should be positive and not 0.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You specify the segment in the media by providing a starting time and duration. You specify the point in the destination track by providing a time in the track. InsertMediaIntoTrack then inserts the media segment into the track at the specified location. The Movie Toolbox determines the duration of the segment in the track based on the media rate and duration information you provide.

Use this function after you have added samples to a media. If you play the track before you call this function, the track does not contain the new media data.

Here's an example of using this function to add atom containers to a track://InsertMediaIntoTrack coding example
long descSize;
QTVRSampleDescriptionHandle qtvrSampleDesc;
 
// Create a QTVR sample description handle
descSize =sizeof(QTVRSampleDescription) + GetHandleSize((Handle) vrWorld)
                            - sizeof(UInt32);
qtvrSampleDesc =(QTVRSampleDescriptionHandle) NewHandleClear (descSize);
(*qtvrSampleDesc)->
size =descSize;
(*qtvrSampleDesc)->
type =kQTVRQTVRType;
 
// Copy the VR world atom container data into the QTVR sample description
BlockMove (*((Handle) vrWorld), &((*qtvrSampleDesc)->
data),
                            GetHandleSize((Handle) vrWorld));
// Now add it to the QTVR track's media
err =BeginMediaEdits (qtvrMedia);
err =AddMediaSample (qtvrMedia, (Handle) nodeInfo, 0,
    GetHandleSize((Handle) nodeInfo), duration,
    (SampleDescriptionHandle) qtvrSampleDesc, 1, 0, &sampleTime);
err =EndMediaEdits (qtvrMedia);
InsertMediaIntoTrack (qtvrTrack, trackTime, sampleTime, duration, 1L<<16);

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr InsertMediaIntoTrack (
   Track        theTrack,
   TimeValue    trackStart,
   TimeValue    mediaTime,
   TimeValue    mediaDuration,
   Fixed        mediaRate );

/*GetMediaDuration

Returns the duration of a media.

TimeValue GetMediaDuration (
   Media    theMedia );
Parameters
theMedia

The media for this operation. Your application obtains this media identifier from such functions as NewTrackMedia and GetTrackMedia. See Media Identifiers.
Return Value

The media's duration.
Discussion

The following code sample illustrates the use of GetMediaDuration:// GetMediaDuration coding example
// See "Discovering QuickTime," page 89
void CreateMyVideoTrack (Movie movie)
{
    Track   track;
    Media   media;
    Rect    rect ={0, 0, 100, 320};
    track =NewMovieTrack(movie,
                FixRatio(rect.right, 1),
                FixRatio(rect.bottom, 1),
                kNoVolume);
    media =NewTrackMedia(track,
                VideoMediaType,
                600,                            // video time scale
                NIL, NIL);
    BeginMediaEdits(media);
    MyAddVideoSamplesToMedia(media, &rect);     // assemble data
    EndMediaEdits(media);
    InsertMediaIntoTrack(track,
                0,                              // track start time
                0,                              // media start time
                GetMediaDuration(media),
                kFix1);                         // normal speed
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
TimeValue GetMediaDuration (
   Media    theMedia );

/*EndMediaEdits

Ends a media-editing session.

OSErr EndMediaEdits (
   Media    theMedia );
Parameters
theMedia

The media for this operation. Your application obtains this media identifier from such functions as NewTrackMedia and GetTrackMedia. See Media Identifiers.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

The following code sample illustrates the use of EndMediaEdits:// EndMediaEdits coding example
// See "Discovering QuickTime," page 89
void CreateMyVideoTrack (Movie movie)
{
    Track   track;
    Media   media;
    Rect    rect ={0, 0, 100, 320};
    track =NewMovieTrack(movie,
                FixRatio(rect.right, 1),
                FixRatio(rect.bottom, 1),
                kNoVolume);
    media =NewTrackMedia(track,
                VideoMediaType,
                600,                            // video time scale
                NIL, NIL);
    BeginMediaEdits(media);
    MyAddVideoSamplesToMedia(media, &rect);     // assemble data
    EndMediaEdits(media);
    InsertMediaIntoTrack(track,
                0,                              // track start time
                0,                              // media start time
                GetMediaDuration(media),
                kFix1);                         // normal speed
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr EndMediaEdits (
   Media    theMedia );

/*GetMediaTrack

Determines the track that uses a specified media.

Track GetMediaTrack (
   Media    theMedia );
Parameters
theMedia

The media for this operation. Your application obtains this media identifier from such functions as NewTrackMedia and GetTrackMedia. See Media Identifiers.
Return Value

The track identifier of the track that uses the specified media.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

Track GetMediaTrack (
   Media    theMedia );

/*CloseMovieStorage

Closes an open movie storage container.

OSErr CloseMovieStorage (
   DataHandler    dh );
Parameters
dh

The data handler component that was returned by a previous call to CreateMovieStorage.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 6. Supersedes CloseMovieFile.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Movies.h*/
OSErr CloseMovieStorage (
   DataHandler    dh );

/*AddMovieToStorage

Adds a movie to a storage container that was created by CreateMovieStorage.

OSErr AddMovieToStorage (
   Movie          theMovie,
   DataHandler    dh );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
dh

The data handler component that was returned by CreateMovieStorage.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

This function calls PutMovieIntoStorage internally. If you are writing a custom data handler, make sure it implements DataHGetDataRef. Also implement DataHScheduleData64 and DataHGetFileSize64, or DataHScheduleData and DataHGetFileSize if the data handler does not support 64-bit file offsets, plus DataHWrite64, or DataHWrite if it does not support 64-bit offsets.
Version Notes

Introduced in QuickTime 6. Supersedes AddMovieResource.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Movies.h*/
OSErr AddMovieToStorage (
   Movie          theMovie,
   DataHandler    dh );

/*MovieAudioExtractionEnd

Ends a movie audio extraction session.

OSStatus MovieAudioExtractionEnd (
   MovieAudioExtractionRef    session );
Parameters
session

The session object returned by MovieAudioExtractionBegin.
Return Value

An error code. Returns noErr if there is no error.
Discussion

You must call this function when movie audio extraction is complete.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus MovieAudioExtractionEnd (
   MovieAudioExtractionRef    session );

/*NewMovieFromDataRef

Creates a movie from any device with a corresponding data handler.

OSErr NewMovieFromDataRef (
   Movie     *m,
   short     flags,
   short     *id,
   Handle    dataRef,
   OSType    dataRefType );
Parameters
m

A pointer to a field that is to receive the new movie's identifier. If the function cannot load the movie, the returned identifier is set to NIL.
flags

Flags (see below) that control the operation of this function. Be sure to set unused flags to 0. See these constants: 
newMovieActive
newMovieDontResolveDataRefs
newMovieDontAskUnresolvedDataRefs
id

A pointer to the field that specifies the resource containing the movie data that is to be loaded. If the field referred to by the id parameter is set to 0, the Movie Toolbox loads the first movie resource it finds in the specified file. The toolbox then returns the movie's resource ID number in the field referred to by the id parameter. An enumerated constant (see below) is available. See these constants: 
movieInDataForkResID
dataRef

The default data reference. This parameter contains a handle to the information that identifies the file to be used to resolve any data references and as a starting point for any Alias Manager searches. The type of information stored in the handle depends upon the value of the dataRefType parameter. For example, if your application is loading the movie from a file, you would refer to the file's alias in this parameter and set the dataRefType parameter to rAliasType. If you do not want to identify a default data reference, set the parameter to NIL.
dataRefType

The type of data reference. If the data reference is an alias, you must set the parameter to rAliasType, indicating that the reference is an alias.
Return Value

If the Movie Toolbox cannot completely resolve all data references, it sets the current error value to couldNotResolveDataRef. You can access error returns such as this through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

This function is intended for use by specialized applications that need to instantiate movies from devices not visible to the file system. Most applications should continue to use NewMovieFromFile. You are not restricted to instantiating a movie from a file stored on a Macintosh HFS volume. With this function, you can instantiate a movie from any device.
Special Considerations

The Movie Toolbox automatically sets the movie's graphics world based on the current graphics port. Be sure that your application's graphics port is valid before you call this function, even if the movie is sound-only; you can use GetGWorld to check for a valid port, or you can use NewGWorld to create a port. The graphics port must remain valid for the life of the movie or until you set another valid graphics port for the movie using SetMovieGWorld.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr NewMovieFromDataRef (
   Movie     *m,
   short     flags,
   short     *id,
   Handle    dataRef,
   OSType    dataRefType );

/*CreateMovieStorage

Creates an empty storage location to hold a movie and opens a data handler to the stored movie with write permission.

OSErr CreateMovieStorage (
   Handle         dataRef,
   OSType         dataRefType,
   OSType         creator,
   ScriptCode     scriptTag,
   long           createMovieFileFlags,
   DataHandler    *outDataHandler,
   Movie          *newmovie );
Parameters
dataRef

A handle to a QuickTime data reference.
dataRefType

The data reference type. See Data References.
creator

The creator type of the new container (for example, 'TV0D', the creator type for Apple's movie player).
scriptTag

Constants (see below) that specify the script for the new container. See these constants: 
createMovieFileFlags

Constants (see below) that control file creation options. See these constants: 
createMovieFileDeleteCurFile
createMovieFileDontCreateMovie
createMovieFileDontOpenFile
newMovieActive
outDataHandler

A pointer to a field that is to receive the data handler for the opened movie container. Your application must use this value when calling other Movie Toolbox functions. If you pass NIL, the Movie Toolbox creates the movie container but does not open it.
newmovie

A pointer to a field that is to receive the returned identifier of the new movie. If the function could not create a new movie, it sets this returned value to NIL. If you pass NIL, the Movie Toolbox does not create a movie.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

If you are writing a custom data handler, make sure it supports DataHGetDataRef. It must also support DataHWrite64, or DataHWrite if 64-bit offsets are not supported.
Version Notes

Introduced in QuickTime 6. Supersedes CreateMovieFile.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Movies.h*/
OSErr CreateMovieStorage (
   Handle         dataRef,
   OSType         dataRefType,
   OSType         creator,
   ScriptCode     scriptTag,
   long           createMovieFileFlags,
   DataHandler    *outDataHandler,
   Movie          *newmovie );

/*AddMediaSample2

Adds sample data and a description to a media.

OSErr AddMediaSample2 (
   Media                      theMedia,
   const UInt8                *dataIn,
   ByteCount                  size,
   TimeValue64                decodeDurationPerSample,
   TimeValue64                displayOffset,
   SampleDescriptionHandle    sampleDescriptionH,
   ItemCount                  numberOfSamples,
   MediaSampleFlags           sampleFlags,
   TimeValue64                *sampleDecodeTimeOut );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
dataIn

A handle to the sample data. The function adds this data to the media specified by theMedia. You specify the number of bytes of sample data with the size parameter.
size

The number of bytes of sample data to be added to the media. This parameter indicates the total number of bytes in the sample data to be added to the media, not the number of bytes per sample. Use the numberOfSamples parameter to indicate the number of samples that are contained in the sample data.
decodeDurationPerSample

The duration of each sample to be added, representing the amount of time that passes while the sample data is being displayed. You must specify this parameter in the media's time scale. For example, if you are adding sound that was sampled at 22 kHz to a media that contains a sound track with the same time scale, you would set durationPerSample to 1. Similarly, if you are adding video that was recorded at 10 frames per second to a video media that has a time scale of 600, you would set this parameter to 60. Note that this is the duration per sample, regardless of the number of samples being added.
displayOffset

A 64-bit time value that specifies the offset between the decode time (the start time of the track plus the duration of all previous samples) and the display time. This value is normally zero unless the sample is frame reordering compressed video.
sampleDescriptionH

A handle to a SampleDescription structure. Some media structures may require sample descriptions. There are different descriptions for different types of samples. For example, a media that contains compressed video requires that you supply an ImageDescription structure. A media that contains sound requires that you supply a SoundDescription structure. If the media does not require a SampleDescription structure, set this parameter to NIL.
numberOfSamples

The number of samples contained in the sample data to be added to the media. The Movie Toolbox considers the value of this parameter as well as the value of the size parameter when it determines the size of each sample that it adds to the media. You should set the value of this parameter so that the resulting sample size represents a reasonable compromise between total data retrieval time and the overhead associated with input and output. You should also consider the speed of the data storage device; CD-ROM devices are much slower than hard disks, for example, and should therefore have a smaller sample size. For a video media, set a sample size that corresponds to the size of a frame. For a sound media, choose a number of samples that corresponds to between 0.5 and 1.0 seconds of sound. In general, you should not create groups of sound samples that are less than 2 KB in size or greater than 15 KB. Typically, a sample size of about 8 KB is reasonable for most storage devices.
sampleFlags

Flags that control the add operation; set unused flags to 0: mediaSampleNotSync Indicates that the sample to be added is not a sync sample. Set this flag to 1 if the sample is not a sync sample; set it to 0 if the sample is a sync sample. See these constants: 
mediaSampleNotSync
sampleDecodeTimeOut

A pointer to a time value that represents the sample decode time. After adding the sample data to the media, the function returns in this parameter the time where the sample was inserted. If you don't want to receive this information, set this parameter to NIL.
Return Value

An error code. Returns noErr if there is no error. You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result.
Discussion

Your application specifies the sample and the media for the operation. This function updates the media so that it contains the sample data. One call to this function can add several samples to a media. This function replaces AddMediaSample; it adds 64-bit support and support for frame reordering video compression (display offset).
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSErr AddMediaSample2 (
   Media                      theMedia,
   const UInt8                *dataIn,
   ByteCount                  size,
   TimeValue64                decodeDurationPerSample,
   TimeValue64                displayOffset,
   SampleDescriptionHandle    sampleDescriptionH,
   ItemCount                  numberOfSamples,
   MediaSampleFlags           sampleFlags,
   TimeValue64                *sampleDecodeTimeOut );

/*QTNewDataReferenceFromFullPathCFString

Creates an alias data reference from a CFString that represents the full pathname of a file.

OSErr QTNewDataReferenceFromFullPathCFString (
   CFStringRef    filePath,
   QTPathStyle    pathStyle,
   UInt32         flags,
   Handle         *outDataRef,
   OSType         *outDataRefType );
Parameters
filePath

A CFString that represents the full pathname of a file.
pathStyle

A constant (see below) that identifies the syntax of the pathname. See these constants: 
kQTNativeDefaultPathStyle
kQTPOSIXPathStyle
kQTHFSPathStyle
kQTWindowsPathStyle
flags

Currently not used; pass 0.
outDataRef

A pointer to a handle in which the newly created alias data reference is returned.
outDataRefType

A pointer to memory in which the OSType of the newly created data reference is returned.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error. Returns paramErr if either of the output parameters is NIL
Discussion

You need to specify the syntax of the pathname as one of the QTPathStyle constants. The new alias data reference created can be passed to other Movie Toolbox calls that take a data reference.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSErr QTNewDataReferenceFromFullPathCFString (
   CFStringRef    filePath,
   QTPathStyle    pathStyle,
   UInt32         flags,
   Handle         *outDataRef,
   OSType         *outDataRefType );

/*QTSoundDescriptionCreate

Creates a sound description structure of the requested kind from an AudioStreamBasicDescription, optional audio channel layout, and optional magic cookie.

OSStatus QTSoundDescriptionCreate (
AudioStreamBasicDescription    *inASBD,
AudioChannelLayout             *inLayout,
ByteCount                      inLayoutSize,
void                           *inMagicCookie
ByteCount                      inMagicCookieSize
QTSoundDescriptionKind         inRequestedKind
SoundDescriptionHandle         *outSoundDesc );
Parameters
inASBD

A description of the format.
inLayout

The audio channel layout (can be NULL if there isn't one).
inLayoutSize

The size of the audio channel layout (should be 0 if inLayout is NULL).
inMagicCookie

The magic cookie for the decompressor (can be NULL if the decompressor doesn't require one).
inMagicCookieSize

The size of the magic cookie (should be 0 if the inMagicCookie parameter is NULL).
inRequestedKind

The kind of sound description to create. 
outSoundDesc

The resulting sound description. The caller must dispose of it with DisposeHandle.
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus QTSoundDescriptionCreate (
AudioStreamBasicDescription    *inASBD,
AudioChannelLayout             *inLayout,
ByteCount                      inLayoutSize,
void                           *inMagicCookie,
ByteCount                      inMagicCookieSize,
QTSoundDescriptionKind         inRequestedKind,
SoundDescriptionHandle         *outSoundDesc );

/*DisposeMovie

Frees any memory being used by a movie, including the memory used by the movie's tracks and media structures.

void DisposeMovie (
   Movie    theMovie );
Parameters
theMovie

Identifies the movie to be freed. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, or NewMovieFromHandle.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Discussion

Your application should call this function when it is done working with a movie, as shown in the following example:// DisposeMovie coding example
// See "Discovering QuickTime," page 85
void CreateMyCoolMovie (void)
{
    StandardFileReply   sfr;
    Movie               movie =NIL;
    FSSpec              fss;
    short               nFileRefNum =0;
    short               nResID =movieInDataForkResID;
    StandardPutFile("\pEnter movie file name:", "\puntitled.mov", &sfr);
    if (!sfr.sfGood)
        return;
    CreateMovieFile(&sfr.sfFile,
                    FOUR_CHAR_CODE('TVOD'),
                    smCurrentScript,
                    createMovieFileDeleteCurFile | createMovieFileDontCreateResFile,
                    &nFileRefNum,
                    &movie);
    CreateMyVideoTrack(movie);      // See "Creating a Track," below
    AddMovieResource(movie, nFileRefNum, &nResID, NIL);
    if (nFileRefNum !=0)
        CloseMovieFile(nFileRefNum);
    DisposeMovie(movie);
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

void DisposeMovie (
   Movie    theMovie );

/*NewMovieTrack

Creates a new movie track, without a media.

Track NewMovieTrack (
   Movie    theMovie,
   Fixed    width,
   Fixed    height,
   short    trackVolume );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
width

A fixed number denoting the display width of the track, in pixels.
height

A fixed number denoting the display height of the track, in pixels. Together, the height and width parameters define the track's display rectangle. The upper-left corner of this rectangle lies at (0,0) in the movie's rectangle. The height and width parameters therefore establish the lower-right corner of the track's display rectangle. If you are creating a track that is not displayed, such as a sound track, set the height and width parameters to 0.
trackVolume

The volume setting of the track as a 16-bit, fixed-point number. The high-order 8 bits specify the integer portion; the low-order 8 bits specify the fractional part. Volume values range from -1.0 to 1.0. Negative values play no sound but preserve the absolute value of the volume setting. Set this parameter to kFullVolume to play the track at its full, natural volume. Set this parameter to kNoVolume to set the volume to 0. See these constants: 
Return Value

The identifier of the new track.
Discussion

Immediately after creating a new track, you should call NewTrackMedia to create a media for the track; a track without a media is of no use. The following code sample creates a new sprite track and media, then calls BeginMediaEdits to prepare to add samples to the media:// NewMovieTrack coding example
// See "Discovering QuickTime," page 349
#define kSpriteMediaTimeScale           600
track =NewMovieTrack(movie, ((long)lTrackWidth << 16),
                            ((long)lTrackHeight << 16), 0);
media =NewTrackMedia(track, SpriteMediaType,
                            kSpriteMediaTimeScale, NIL, 0);
FailOSErr(BeginMediaEdits(media));

Special Considerations

When you add a track to a movie, the Movie Toolbox automatically adjusts the display Rect structure of the movie. You may want to detect these changes by calling GetMovieBox so that you can adjust the size of the movie's display window.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

Track NewMovieTrack (
   Movie    theMovie,
   Fixed    width,
   Fixed    height,
   short    trackVolume );

/*GetMoviesError

Returns the contents of the current error value and resets the current error value to 0.

OSErr GetMoviesError ( void );
Return Value

See Error Codes. Returns noErr if there is no error in the current error value.
Discussion

The Movie Toolbox provides two error values to your application: the current error and the sticky error. The current error is the result code from the last Movie Toolbox function; it is updated each time your application calls a Movie Toolbox function. The following code sample shows a typical use:// GetMoviesError coding example
// See "Discovering QuickTime," page 256
OSErr QTUtils_SaveMovie (Movie theMovie)
{
    StandardFileReply   mySFReply;
    StringPtr   myPrompt =QTUtils_ConvertCToPascalString(kSavePrompt);
    StringPtr   myFileName =
                    QTUtils_ConvertCToPascalString(kSaveMovieFileName);
    OSErr       myErr =noErr;
    if (theMovie ==NIL)
        return(invalidMovie);
    StandardPutFile(myPrompt, myFileName, &mySFReply);
    if (mySFReply.sfGood) {
        FlattenMovieData(   theMovie,
                            flattenAddMovieToDataFork,
                            &mySFReply.sfFile,
                            FOUR_CHAR_CODE('TVOD'),
                            smSystemScript,
                            createMovieFileDeleteCurFile);
        myErr =GetMoviesError();
    }
    free(myPrompt);
    free(myFileName);
    return(myErr);
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr GetMoviesError ( void );

/*QTSoundDescriptionSetProperty

Sets a particular property of a sound description.

OSStatus QTSoundDescriptionSetProperty (
SoundDescriptionHandle     inDesc,
QTPropertyClass            inPropClass,
QTPropertyID               inPropID,
ByteCount                  inPropValueSize,
ConstQTPropertyValuePtr   inPropValueAddress );
Parameters
inDesc

The sound description being modified.
inPropClass

The class of the property being set. 
inPropID

The ID of the property being set.
inPropValueSize

The size of the property value buffer.
inPropValueAddress

A pointer to the property value buffer. 
Return Value

An error code. Returns noErr if there is no error.
Discussion

The following constants identify sound description properties.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus QTSoundDescriptionSetProperty (
SoundDescriptionHandle     inDesc,
QTPropertyClass            inPropClass,
QTPropertyID               inPropID,
ByteCount                  inPropValueSize,
ConstQTPropertyValuePtr   inPropValueAddress );

/*SetMovieGWorld

Establishes a movie's display coordinate system by setting the graphics world for displaying the movie.

void SetMovieGWorld (
   Movie       theMovie,
   CGrafPtr    port,
   GDHandle    gdh );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
port

Points to the movie's CGrafPort structure or graphics world. Set this parameter to NIL to use the current graphics port.
gdh

A handle to the movie's GDevice structure. Set this parameter to NIL to use the current device. If the port parameter specifies a graphics world, set this parameter to NIL to use that graphics world's graphics device.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Special Considerations

When you use this function, the Movie Toolbox remembers the current background color and background pattern. These are used for erasing in the default movie uncover function; see SetMovieCoverProcs.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void SetMovieGWorld (
   Movie       theMovie,
   CGrafPtr    port,
   GDHandle    gdh );

/*SetMovieVisualContext

Targets a movie to render into a visual context.

OSStatus SetMovieVisualContext (
   Movie      movie,
   QTVisualContextRef    visualContext;
Parameters
movie

The movie.
visualContext

The visual context that the movie will render into. May be NULL..
Return Value

An error code. Returns noErr if there is no error. Returns memFullErr if memory cannot be allocated. Returns kQTVisualContextNotAllowed if the movie is not able to render using a visual context. Returns paramErr if the movie is NULL.
Discussion

When SetMovieVisualContext succeeds, it will retain the QTVisualContext object for its own use. If visualContext is NULL, the movie will not render any visual media. SetMovieVisualContext will fail if a different movie is already using the visual context, so you should first disassociate the other movie by calling SetMovieVisualContext with a NULL visualContext. 
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus SetMovieVisualContext (
   Movie      movie,
   QTVisualContextRef    visualContext);

/*PrerollMovie

Prepares a portion of a movie for playback.

OSErr PrerollMovie (
   Movie        theMovie,
   TimeValue    time,
   Fixed        Rate );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
time

The starting time of the movie segment to play.
Rate

The rate at which you anticipate playing the movie. You specify the movie rate as a 32-bit, fixed-point number. Positive integers indicate forward rates and negative integers indicate reverse rates.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

When your application calls PrerollMovie, the Movie Toolbox tells the appropriate media handlers to prepare to play the movie. The media handlers may then load the movie data and perform any other necessary preparations to play the movie, such as allocating sound channels and starting up image-decompression sequences. In this manner, you can eliminate playback stutter when the movie starts playing.

If your application uses QuickTime's Movie Toolbox to play back movies, there are two choices for how to preroll the movie. Like the movie controller, the Movie Toolbox provides a single function call, StartMovie, which will both preroll the movie and start it playing. Unlike the movie controller, the Movie Toolbox function doesn't allow you to specific the rate to play the movie at, but instead assumes the movie's preferred rate.

Calling StartMovie, just like the movie controller's preroll and play action, first prerolls the movie and then sets it playing. If your application requires more control, the Movie Toolbox provides lower level functions that give you more control:// PrerollMovie coding example
StartMovie(theMovie);
TimeValue timeNow;
Fixed playRate;
timeNow =GetMovieTime(theMovie, NIL);
playRate =GetMoviePreferredRate(theMovie);
PrePrerollMovie(theMovie, timeNow, playRate, NIL, NIL);
PrerollMovie(theMovie, timeNow, playRate);
SetMovieRate(theMovie, playRate);

Special Considerations

You should always call PrePrerollMovie before calling this function.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr PrerollMovie (
   Movie        theMovie,
   TimeValue    time,
   Fixed        Rate );

/*GetMovieTime

Returns a movie's current time both as a time value and in a time structure.

TimeValue GetMovieTime (
   Movie         theMovie,
   TimeRecord    *currentTime );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
currentTime

A pointer to a TimeRecord structure. The function updates this time structure to contain the movie's current time. If you don't want this information, set this parameter to NIL.
Return Value

The time value of the current time.
Discussion

This function returns the movie's current time value in two formats: as a time value and in a time structure.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

TimeValue GetMovieTime (
   Movie         theMovie,
   TimeRecord    *currentTime );

/*MoviesTask

Services active movies.

void MoviesTask (
   Movie    theMovie,
   long     maxMilliSecToUse );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle. If you set this parameter to NIL, the Movie Toolbox services all of your active movies.
maxMilliSecToUse

Determines the maximum number of milliseconds that MoviesTask can work before returning. If this parameter is 0, MoviesTask services every active movie exactly once and then returns. If the parameter is nonzero, MoviesTask services as many movies as it can in the allotted time before returning. Once the MoviesTask function starts servicing a movie, it cannot stop until it has completely met the requirements of the movie. Consequently, the MoviesTask function may execute for a longer time than that specified in maxMilliSecToUse. However, the function does not start servicing a new movie if the time specified by maxMilliSecToUse has elapsed. The preferred way to use MoviesTask is to set the maxMilliSecToUse parameter to 0; however, if you just want to play one movie, you can call MoviesTask on that one. If your rate is 0, MoviesTask draws that frame and no other.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

You should call MoviesTask as often as possible from your application's main event loop. Note that you should call this function after you have performed your own event processing. MoviesTask services only active movies, and only enabled tracks within those active movies.
Special Considerations

Note that the MoviesTask function services only your movies. Your application must give other applications the opportunity to call MoviesTask for their movies.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void MoviesTask (
   Movie    theMovie,
   long     maxMilliSecToUse );

/*UpdateMovie

Ensures that the Movie Toolbox properly displays your movie after it has been uncovered.

OSErr UpdateMovie (
   Movie    theMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

Your application should call this function during window updating. Don't call MoviesTask at this time; you will observe better display behavior if you call it at the end of your update processing.

This function does not actually update the movie's graphics world. Rather, it invalidates the movie's display state so that the Movie Toolbox redraws the movie the next time you call MoviesTask. If you need to force a movie to be redrawn outside of a window update sequence, your application can call this function and then call MoviesTask to service the movie. The Movie Toolbox determines the portion of the screen to update by examining the graphics port's visible region.

The following code snippet uses this function in a Macintosh Window Manager update sequence:// UpdateMovie coding example
#include <Events.h>
#include <ToolUtils.h>
#include "Movies.h"
void DoUpdate (WindowRef theWindow, Movie theMovie)
{
    BeginUpdate (theWindow);
    UpdateMovie (theMovie);
    EndUpdate (theWindow);
} // DoUpdate 

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/


OSErr UpdateMovie (
   Movie    theMovie );

/*PutUserDataIntoHandle

Returns a handle to a user data structure.

OSErr PutUserDataIntoHandle (
   UserData    theUserData,
   Handle      h );
Parameters
theUserData

The user data structure.
h

A handle to the UserDataRecord structure pointed to by the theUserData parameter.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr PutUserDataIntoHandle (
   UserData    theUserData,
   Handle      h );

/*NewUserDataFromHandle

Creates a new user data structure from a handle.

OSErr NewUserDataFromHandle (
   Handle      h,
   UserData    *theUserData );
Parameters
h

A handle to the data structure specified in theUserData.
theUserData

A pointer to a pointer to a new UserDataRecord structure.
Return Value

See Error Codes. Returns noErr if there is no error. If the function fails, theUserData is set to NIL.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr NewUserDataFromHandle (
   Handle      h,
   UserData    *theUserData );

/*DisposeUserData

Disposes of a user data structure created by NewUserData.

OSErr DisposeUserData (
   UserData    theUserData );
Parameters
theUserData

The user data structure that is to be disposed of. It is acceptable but unnecessary to pass NIL in this parameter.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr DisposeUserData (
   UserData    theUserData );

/*QTSoundDescriptionGetProperty

Gets a particular property of a sound description.

OSStatus QTSoundDescriptionGetProperty (
SoundDescriptionHandle     inDesc,
QTPropertyClass            inPropClass,
QTPropertyID               inPropID,
ByteCount                  inPropValueSize,
QTPropertyValuePtr         outPropValueAddress,
ByteCount                  *outPropValueSizeUsed);
Parameters
inDesc

The sound description being interrogated.
inPropClass

The class of the property being requested. 
inPropID

The ID of the property being requested.
inPropValueSize

The size of the property value buffer.
outPropValueAddress

A pointer to the property value buffer.
outPropValueSizeUsed

The actual size of the returned property value (can be NULL). 
Return Value

An error code. Returns noErr if there is no error.
Discussion

The following constants identify sound description properties.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus QTSoundDescriptionGetProperty (
SoundDescriptionHandle     inDesc,
QTPropertyClass            inPropClass,
QTPropertyID               inPropID,
ByteCount                  inPropValueSize,
QTPropertyValuePtr         outPropValueAddress,
ByteCount                  *outPropValueSizeUsed);

/*MCDoAction

Invokes a movie controller component and makes it perform a specified action.

ComponentResult MCDoAction (
   MovieController    mc,
   short              action,
   void               *params );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
action

The action to be taken. See Movie Controller Actions.
params

A pointer to the parameter data appropriate to the action. See Movie Controller Actions for information about the parameters required for each supported action.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/
ComponentResult MCDoAction (
   MovieController    mc,
   short              action,
   void               *params );

/*ExitMoviesOnThread

Indicates to QuickTime that the client will no longer be using QuickTime on the current thread.

OSErr ExitMoviesOnThread (void);
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error. Returns an appropriate operating system or QuickTime error if the operation couldn't be completed. This might occur because a previous call to EnterMoviesOnThread was not made.
Discussion

This function should be called before exiting from a spawned thread that uses QuickTime. It undoes the setup performed by EnterMoviesOnThread. Each call to EnterMoviesOnThread should be matched with a call to this function. This function should not be called on a thread without a previous call to EnterMoviesOnThread.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSErr ExitMoviesOnThread (void);

/*EnterMoviesOnThread

Indicates that the client will be using QuickTime on the current thread.

OSErr EnterMoviesOnThread (UInt32 inFlags);
Parameters
inFlags

Flag (see below) indicating how the executing thread will use QuickTime. Setting the thread mode is a convenience provided by this function. Pass 0 for the default options. See these constants: 
kQTEnterMoviesFlagDontSetComponentsThreadMode
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error. This function returns an appropriate operating system or QuickTime error if the operation couldn't be completed. This might occur because a second call on the thread was made that used incompatible flags (for example, the first call required a shared state but a subsequent call required a private state).
Discussion

This function is analogous to EnterMovies. It initializes QuickTime and prepares QuickTime for calls from its thread. Unlike EnterMovies, this function allows the client to indicate if its access to QuickTime requires sharing of QuickTime state with the main thread. The default is to maintain a private state. 
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSErr EnterMoviesOnThread (UInt32 inFlags);

/*QTNewAlias

Creates a Mac OS alias to a file.

OSErr QTNewAlias (
   const FSSpec    *fss,
   AliasHandle     *alias,
   Boolean         minimal );
Parameters
fss

A pointer to an FSSpec structure that specifies a file.
alias

On return, a pointer to a handle to a new AliasRecord structure that defines an alias to the file. If the function was unable to create an alias, the handle is set to NIL. This function does not create relative aliases. For further information about Mac OS file aliases, see Chapter 4 of Inside Macintosh: Files.
minimal

If you pass TRUE, the function writes in the AliasRecord structure only the target name, parent directory ID, volume name and creation date, and volume mounting information. If you pass FALSE, it fills out the structure fully.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSErr QTNewAlias (
   const FSSpec    *fss,
   AliasHandle     *alias,
   Boolean         minimal );

/*QTLockContainer

Locks an atom container in memory.

OSErr QTLockContainer (
   QTAtomContainer    container );
Parameters
container

The atom container to be locked.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You should call this function to lock an atom container before calling QTGetAtomDataPtr to directly access a leaf atom's data. When you have finished accessing a leaf atom's data, you should call QTUnlockContainer. You may make nested pairs of calls to QTLockContainer and QTUnlockContainer; you don't need to check the current state of the container first.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTLockContainer (
   QTAtomContainer    container );

/*QTFindChildByIndex

Retrieves an atom by index from the child list of the specified parent atom.

QTAtom QTFindChildByIndex (
   QTAtomContainer    container,
   QTAtom             parentAtom,
   QTAtomType         atomType,
   short              index,
   QTAtomID           *id );
Parameters
container

The atom container that contains the parent atom.
parentAtom

The parent atom for this operation.
atomType

The type of the atom to be retrieved.
index

The index of the atom to be retrieved.
id

A pointer to an uninitialized QTAtomID data structure. On return, if the atom specified by index was found, the QTAtomID data structure contains the atom's ID. If you don't want this function to return the atom's ID, set the value of the id parameter to NIL.
Return Value

The found atom.
Discussion

You call this function to search for and retrieve an atom by its type and index within that type from a parent atom's child list. The following code illustrates one way to use it:// QTFindChildByIndex coding example
if ((propertyAtom =QTFindChildByIndex (sprite, kParentAtomIsContainer,
    kSpritePropertyImageIndex, 1, NIL)) ==0)
    FailOSErr (QTInsertChild (sprite, kParentAtomIsContainer,
        kSpritePropertyImageIndex, 1, 1, sizeof(short),&imageIndex,
        NIL));

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
QTAtom QTFindChildByIndex (
   QTAtomContainer    container,
   QTAtom             parentAtom,
   QTAtomType         atomType,
   short              index,
   QTAtomID           *id );

/*QTGetAtomDataPtr

Retrieves a pointer to the atom data for a specified leaf atom.

OSErr QTGetAtomDataPtr (
   QTAtomContainer    container,
   QTAtom             atom,
   long               *dataSize,
   Ptr                *atomData );
Parameters
container

The atom container that contains the leaf atom.
atom

The leaf atom whose data should be retrieved.
dataSize

On return, contains a pointer to the length, in bytes, of the leaf atom's data.
atomData

On return, contains a pointer to the leaf atom's data.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You call this function in retrieve a pointer to a leaf atom's data so that you can access the data directly.
Special Considerations

To ensure that the pointer returned in the atomData parameter will remain valid if memory is moved, you should call QTLockContainer before you call this function. If you call QTLockContainer, you should call QTUnlockContainer when you have finished using the atomData pointer. If you pass a locked atom container to a function that resizes atom containers, the function returns an error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTGetAtomDataPtr (
   QTAtomContainer    container,
   QTAtom             atom,
   long               *dataSize,
   Ptr                *atomData );

/*QTUnlockContainer

Unlocks an atom container in memory.

OSErr QTUnlockContainer (
   QTAtomContainer    container );
Parameters
container

The atom container to be unlocked.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You should call this function to unlock an atom container when you have finished accessing a leaf atom's data. You may make nested pairs of calls to QTLockContainer and this function; you don't need to check the current state of the container first.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTUnlockContainer (
   QTAtomContainer    container );

/*QTDisposeAtomContainer

Disposes of an atom container.

OSErr QTDisposeAtomContainer (
   QTAtomContainer    atomData );
Parameters
atomData

The atom container to be disposed of.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You can call this function to dispose of an atom container data structure that was created by QTNewAtomContainer or QTCopyAtom.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTDisposeAtomContainer (
   QTAtomContainer    atomData );

/*NewMovieFromProperties

Creates a new movie using movie properties.

OSStatus NewMovieFromProperties (
ItemCount                    inputPropertyCount,
QTNewMoviePropertyElement    *inputProperties,
ItemCount                    outputPropertyCount,
QTNewMoviePropertyElement    *outputProperties,
Movie                        *theMovie );
Parameters
inputPropertyCount

The number of properties in the array passed in inputProperties.
inputProperties

A pointer to a property array describing how to instantiate the movie. See QTNewMoviePropertyElement.
outputPropertyCount

The number of properties in the array passed in outputProperties.
outputProperties

A pointer to a property array to receive output parameters. See QTNewMoviePropertyElement. You may pass NULL if you don't want this information. The caller is responsible for calling the appropriate routines to dispose of any property values returned here. Since callers specify the property classes and IDs, they know who to call to dispose of the property values.
theMovie

A pointer to a variable that receives the new movie.
Return Value

An error code. Returns memFullErr if the function could not allocate memory, paramErr if inputProperties or theMovie is NULL, or noErr if there is no error.
Discussion

This function can be used in all the cases where an existing NewMovieFrom... call is used. When calling this function, you supply a set of input properties that describe the information required to instantiate the movie (its data reference, audio context, visual context, and so on). You can also supply a set of output properties that you may be interested in; for example, information about whether the data reference was changed. See New Movie Property Codes.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus NewMovieFromProperties (
ItemCount                    inputPropertyCount,
QTNewMoviePropertyElement    *inputProperties,
ItemCount                    outputPropertyCount,
QTNewMoviePropertyElement    *outputProperties,
Movie                        *theMovie );

/*GoToBeginningOfMovie

Repositions a movie to play from its start.

void GoToBeginningOfMovie (
   Movie    theMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Discussion

If the movie is in preview mode, the function goes to the start of the preview segment of the movie. In all other cases, this function goes to the start of the movie, where the movie time value is 0. You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void GoToBeginningOfMovie (
   Movie    theMovie );

/*GetMovieTimeBase

Returns a movie's time base.

TimeBase GetMovieTimeBase (
   Movie    theMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

The movie's TimeBaseRecord structure.
Special Considerations

The Movie Toolbox disposes of a movie's time base when you dispose of the movie.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
TimeBase GetMovieTimeBase (
   Movie    theMovie );

/*StopMovie

Stops the playback of a movie.

void StopMovie (
   Movie    theMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void StopMovie (
   Movie    theMovie );

/*GetTrackMedia

Determines the media that contains a track's sample data.

Media GetTrackMedia (
   Track    theTrack );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
Return Value

The media identifier for the media that contains the track's sample data. If the function could not locate the media, it sets this returned value to NIL.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

Media GetTrackMedia (
   Track    theTrack );

/*SetTimeBaseFlags

Sets the contents of the control flags of a time base.

void SetTimeBaseFlags (
   TimeBase    tb,
   long        timeBaseFlags );
Parameters
tb

The time base for this operation. Your application obtains this time base identifier from NewTimeBase.
timeBaseFlags

The control flags for this time base (see below). You may set only one flag to 1. Be sure to set unused flags to 0. See these constants: 
loopTimeBase
palindromeLoopTimeBase
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

void SetTimeBaseFlags (
   TimeBase    tb,
   long        timeBaseFlags );

/*SetMoviePlayHints

Provides information to the Movie Toolbox that can influence movie playback.

void SetMoviePlayHints (
   Movie    theMovie,
   long     flags,
   long     flagsMask );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
flags

The optimizations that can be used with this movie. Each bit in the flags parameter corresponds to a specific optimization (see below). Be sure to set unused flags to 0. See these constants: 

hintsScrubMode

hintsUseSoundInterp

hintsAllowInterlace

hintsAllowBlacklining

hintsDontPurge

hintsInactive

hintsHighQuality
flagsMask

Indicates which flags in the flags parameter are to be considered in this operation. For each bit in the flags parameter that you want the Movie Toolbox to consider, you must set the corresponding bit in the flagsMask parameter to 1. Set unused flags to 0. This allows you to work with a single optimization without altering the settings of other flags.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

This function accepts a flag in which you specify optimizations that the Movie Toolbox can use during movie playback. These optimizations apply to all of the media structures used by the movie.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void SetMoviePlayHints (
   Movie    theMovie,
   long     flags,
   long     flagsMask );


/*SetTimeBaseMasterTimeBase

Assigns a master time base to a time base.

void SetTimeBaseMasterTimeBase (
   TimeBase            slave,
   TimeBase            master,
   const TimeRecord    *slaveZero );
Parameters
slave

The time base for this operation. Your application obtains this time base identifier from NewTimeBase.
master

The master time base to be assigned to this time base. Your application obtains this time base identifier from NewTimeBase.
slaveZero

A pointer to the time, in the time scale of the master time base, that corresponds to a 0 time value for the slave time scale. This parameter allows you to set an offset between the time base and the master time base. Set this parameter to NIL if there is no offset.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

A time base derives its time from either a clock component or another time base. Don't use this function to assign a master time base to a movie's time base.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void SetTimeBaseMasterTimeBase (
   TimeBase            slave,
   TimeBase            master,
   const TimeRecord    *slaveZero );

/*SetTrackEnabled

Enables or disables a track.

void SetTrackEnabled (
   Track      theTrack,
   Boolean    isEnabled );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
isEnabled

Enables or disables the track. Set this parameter to TRUE to enable the track. Set this parameter to FALSE to disable the track.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

The Movie Toolbox services only enabled tracks.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

void SetTrackEnabled (
   Track      theTrack,
   Boolean    isEnabled );

/*SetMovieRate

Sets a movie's playback rate.

void SetMovieRate (
   Movie    theMovie,
   Fixed    rate );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
rate

The new movie rate as a 32-bit, fixed-point number. Positive integers indicate forward rates and negative integers indicate reverse rates. This value immediately changes the rate at which the movie is playing. A value of 1 starts the movie playing at normal speed, a value of 2 causes the movie to play at double speed, -2 starts the movie playing backward at double speed, and so on. A value of 0 stops the movie.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

Use this function to change the speed at which a movie is playing. You do not normally use this function to start and stop movies; use the higher level functions StartMovie and StopMovie instead. If you start a movie using this function, you should call PrePrerollMovie and PrerollMovie first, to set up any network connections, buffers, and data structures necessary to play the movie.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

void SetMovieRate (
   Movie    theMovie,
   Fixed    rate );

/*QTMetaDataRelease

Decrements the retain count of a metadata object.

void QTMetaDataRelease ( QTMetaDataRef inMetaData );
Discussion

This function releases a metadata object by decrementing its reference count. When the count becomes 0 the memory allocated to the object is freed and the object is destroyed. If you retain a metadata object you are responsible for releasing it when you no longer need it.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
void QTMetaDataRelease ( QTMetaDataRef inMetaData );

/*QTMetaDataGetItemProperty

Returns a property of a metadata item.

OSStatus QTMetaDataGetItemProperty (
QTMetaDataRef         inMetaData,
QTMetaDataItem        inItem,
QTPropertyClass       inPropClass,
QTPropertyID          inPropID,
ByteCount             inPropValueSize,
QTPropertyValuePtr    outPropValueAddress,
ByteCount             *outPropValueSizeUsed );
Parameters
inMetaData

The metadata object for this operation.
inItem

The opaque, unique UInt64 identifier of the metadata item for this operation. Your application obtains this item identifier from such functions as QTMetaDataAddItem and QTMetaDataGetNextItem.
inPropClass

The class of the property being asked about.
inPropID

The ID of the property being asked about.
inPropValueSize

Size of the buffer allocated to receive the property value.
outPropValueAddress

A pointer to the buffer allocated to receive the item's property value.
outPropValueSizeUsed

On return, the actual size of buffer space used.
Return Value

Returns kQTMetaDataInvalidMetaDataErr if the metadata object or its reference is invalid, kQTMetaDataInvalidItemErr if the metatada item ID is invalid, errPropNotSupported if the metatada object does not support the property being asked about, buffersTooSmall if the allocated buffer is too small to hold the property, or noErr if there is no error. See Metadata Error Codes.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus QTMetaDataGetItemProperty (
QTMetaDataRef         inMetaData,
QTMetaDataItem        inItem,
QTPropertyClass       inPropClass,
QTPropertyID          inPropID,
ByteCount             inPropValueSize,
QTPropertyValuePtr    outPropValueAddress,
ByteCount             *outPropValueSizeUsed );

/*QTMetaDataGetItemPropertyInfo

Returns information about a property of a metadata item.

OSStatus QTMetaDataGetItemPropertyInfo (
QTMetaDataRef          inMetaData,
QTMetaDataItem         inItem,
QTPropertyClass        inPropClass,
QTPropertyID           inPropID,
QTPropertyValueType    *outPropType,
ByteCount              *outPropValueSize,
UInt32                 *outPropFlags );
Parameters
inMetaData

The metadata object for this operation.
inItem

The opaque, unique UInt64 identifier of the metadata item for this operation. Your application obtains this item identifier from such functions as QTMetaDataAddItem and QTMetaDataGetNextItem.
inPropClass

The class of the property being asked about.
inPropID

The ID of the property being asked about.
outPropType

A pointer to the type of the returned property's value.
outPropValueSize

A pointer to the size of the returned property's value.
outPropFlags

On return, a pointer to flags representing the requested information about the item's property.
Return Value

Returns kQTMetaDataInvalidMetaDataErr if the metadata object or its reference is invalid, kQTMetaDataInvalidItemErr if the metatada item ID is invalid, errPropNotSupported if the metatada object does not support the item property being asked about, or noErr if there is no error. See Metadata Error Codes.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus QTMetaDataGetItemPropertyInfo (
QTMetaDataRef          inMetaData,
QTMetaDataItem         inItem,
QTPropertyClass        inPropClass,
QTPropertyID           inPropID,
QTPropertyValueType    *outPropType,
ByteCount              *outPropValueSize,
UInt32                 *outPropFlags );

/*QTMetaDataGetNextItem

Returns the next metadata item corresponding to a specified key.

OSStatus QTMetaDataGetNextItem (
QTMetaDataRef              inMetaData,
QTMetaDataStorageFormat    inMetaDataFormat,
QTMetaDataItem             inCurrentItem,
QTMetaDataKeyFormat        inKeyFormat,
const UInt8                *inKeyPtr,
ByteCount                  inKeySize,
QTMetaDataItem             *outNextItem );
Parameters
inMetaData

The metadata object for this operation.
inMetaDataFormat

The metadata storage format used by the object passed in inMetaData. The format may be UserData storage, iTunes metadata storage, or QuickTime metadata storage. Not all objects will include all forms of storage, and other storage formats may appear in the future. Pass kQTMetaDataStorageFormatWildcard to target all storage formats.
inCurrentItem

The opaque, unique UInt64 identifier of the current metadata item to start the search. Your application obtains this item identifier from such functions as QTMetaDataAddItem.
inKeyFormat

The format of the key.
inKeyPtr

A pointer to the key of the item to be fetched next. You may pass NULL in this parameter if you are not interested in any specific key.
inKeySize

The size of the key in bytes.
outNextItem

The ID of the next metadata item after the item specified by inCurrentItem that has the specified key.
Return Value

Returns kQTMetaDataInvalidMetaDataErr if the metadata object or its reference is invalid, kQTMetaDataInvalidItemErr if the metatada item ID is invalid, kQTMetaDataInvalidStorageFormatErr if the metatada storage format is invalid, kQTMetaDataInvalidKeyErr if the key or its format is invalid, kQTMetaDataNoMoreItemErr if the last item has been fetched, or noErr if there is no error. See Metadata Error Codes.
Discussion

If the item designated by inCurrentItem is kQTMetaDataItemUninitialized, the function returns the first item with the specified key in the storage format. If it refers to a valid item in the storage format, the function will return the next item with the key after the item designated by inCurrentItem.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus QTMetaDataGetNextItem (
QTMetaDataRef              inMetaData,
QTMetaDataStorageFormat    inMetaDataFormat,
QTMetaDataItem             inCurrentItem,
QTMetaDataKeyFormat        inKeyFormat,
const UInt8                *inKeyPtr,
ByteCount                  inKeySize,
QTMetaDataItem             *outNextItem );

/*QTCopyMovieMetaData

Retains a movie's metadata object and returns it.

OSStatus QTCopyMovieMetaData (
Movie            inMovie,
QTMetaDataRef    *outMetaData );
Parameters
inMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromProperties, NewMovieFromFile, and NewMovieFromHandle.
outMetaData

A pointer to an opaque metadata object wrapper associated with the movie passed in inMovie.
Return Value

Returns invalidMovie if the movie passed in inMovie is invalid, or noErr if there is no error. 
Discussion

This function returns the metadata object associated with a movie. The object has retain/release semantics. It has already been retained before returning, but you should call QTMetaDataRelease when you are done. Because the movie can be disposed of at any time, the QTMetaDataRef may be valid when the movie no longer exists. In this case, the function will fail with a kQTMetaDataInvalidMetaDataErr error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus QTCopyMovieMetaData (
Movie            inMovie,
QTMetaDataRef    *outMetaData );

/*GetMovieTimeScale

Returns the time scale of a movie.

TimeScale GetMovieTimeScale (
   Movie    theMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

A long integer that contains the movie's time scale.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
TimeScale GetMovieTimeScale (
   Movie    theMovie );

/*GetMovieIndTrackType

Searches for all of a movie's tracks that share a given media type or media characteristic.

Track GetMovieIndTrackType (
   Movie     theMovie,
   long      index,
   OSType    trackType,
   long      flags );
Parameters
theMovie

The movie for this operation. Your application obtains this identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
index

The index value of the track for this operation. This is not that same as the track's index value in the movie. Rather, this parameter is an index into the set of tracks that meet your other selection criteria.
trackType

Contains either a media type or a media characteristic value. The toolbox applies this value to the search, and returns information about tracks that meet this criterion. You indicate whether you have specified a media type or characteristic value by setting the flags parameter appropriately.
flags

Contains flags (see below) that control the search operation. Note that you may not set both movieTrackMediaType and movieTrackCharacteristic to 1. See these constants: 
movieTrackMediaType
movieTrackCharacteristic
movieTrackEnabledOnly
Return Value

A track identifier.
Discussion

The toolbox returns the track identifier that corresponds to the track that meets your selection criteria. If the toolbox cannot find a matching track, in returns a value of NIL. Note that the index parameter does not work the same way that is does in GetMovieIndTrack. With GetMovieIndTrackType, the index parameter specifies an index into the set of tracks that meet your other selection criteria. For example, in order to find the third track that supports the sound characteristic, you would call the function in the following manner:theTrack =GetMovieIndTrackType (theMovie, 3, AudioMediaCharacteristic, movieTrackCharacteristic);

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

Track GetMovieIndTrackType (
   Movie     theMovie,
   long      index,
   OSType    trackType,
   long      flags );

/*GetMediaDecodeDuration

Returns the decode duration of a media.

TimeValue64 GetMediaDecodeDuration (
   Media    theMedia );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
Return Value

A 64-bit time value that represents the media's decode duration. A media's decode duration is the sum of the decode durations of its samples.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
TimeValue64 GetMediaDecodeDuration (
   Media    theMedia );

/*GetMediaDisplayDuration

Returns the display duration of a media.

TimeValue64 GetMediaDisplayDuration (
   Media    theMedia );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
Return Value

A 64-bit time value that represents the media's display duration. A media's display duration is its display end time minus its display start time. For media without nonzero display offsets, the decode duration and display duration are the same.
Discussion

When inserting media with display offsets into a track, use display time:
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
TimeValue64 GetMediaDisplayDuration (
   Media    theMedia );

/*GetMediaSampleCount

Determines the number of samples in a media.

long GetMediaSampleCount (
   Media    theMedia );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
Return Value

The number of samples in the media.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
long GetMediaSampleCount (
   Media    theMedia );

/*GetMediaTimeScale

Determines a media's time scale.

TimeScale GetMediaTimeScale (
   Media    theMedia );
Parameters
theMedia

The media for this operation. Your application obtains this media identifier from such functions as NewTrackMedia and GetTrackMedia. See Media Identifiers.
Return Value

The media's time scale.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
TimeScale GetMediaTimeScale (
   Media    theMedia );

/*GetTrackDuration

Returns the duration of a track.

TimeValue GetTrackDuration (
   Track    theTrack );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
Return Value

The duration of the specified track, expressed in the time scale of the movie that contains the track.
Discussion

The duration corresponds to the ending time of the track in the movie's time coordinate system (remember that all tracks start at movie time 0).
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
TimeValue GetTrackDuration (
   Track    theTrack );

/*GetMediaSampleDescription

Retrieves a SampleDescription structure from a media.

void GetMediaSampleDescription (
   Media                      theMedia,
   long                       index,
   SampleDescriptionHandle    descH );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
index

The index of the SampleDescription structure to retrieve. This index corresponds to the structure itself, not to the samples in the media. Index numbers start with 1.
descH

Specifies a handle that is to receive the SampleDescription structure. The Movie Toolbox correctly resizes this handle for the returned structure. If there is no description for the specified index, the function returns this handle unchanged. Your application must allocate and dispose of this handle.
Discussion

The Movie Toolbox identifies a media's sample descriptions with an index value, ranging from 1 to the number of sample descriptions in the media. Sample description indexes provide a convenient way to access each sample description in a media. You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Special Considerations

The format of sample descriptions differs by media type. Sample descriptions for image data are defined by ImageDescription structures. Sample descriptions for sound are defined by SoundDescription structures. Sample descriptions for text are defined by TextDescription structures.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void GetMediaSampleDescription (
   Media                      theMedia,
   long                       index,
   SampleDescriptionHandle    descH );

/*SampleNumToMediaDecodeTime

Finds the decode time for a specified sample.

void SampleNumToMediaDecodeTime (
   Media          theMedia,
   SInt64         logicalSampleNum,
   TimeValue64    *sampleDecodeTime,
   TimeValue64    *sampleDecodeDuration );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
logicalSampleNum

A 64-bit signed integer that contains the sample number.
sampleDecodeTime

A pointer to a time value. The function updates this time value to indicate the decode time of the sample specified by the logicalSampleNum parameter. This time value is expressed in the media's time scale. Set this parameter to NULL if you do not want this information.
sampleDecodeDuration

A pointer to a time value. The function updates this time value to indicate the decode duration of the sample specified by the logicalSampleNum parameter. This time value is expressed in the media's time scale. Set this parameter to NULL if you do not want this information.
Discussion

You can access this function's error returns through GetMoviesError and GetMoviesStickyError. It returns paramErr if there is a bad parameter value, or noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
void SampleNumToMediaDecodeTime (
   Media          theMedia,
   SInt64         logicalSampleNum,
   TimeValue64    *sampleDecodeTime,
   TimeValue64    *sampleDecodeDuration );

/*MediaDecodeTimeToSampleNum

Finds the sample for a specified decode time.

void MediaDecodeTimeToSampleNum (
   Media          theMedia,
   TimeValue64    decodeTime,
   SInt64         *sampleNum,
   TimeValue64    *sampleDecodeTime,
   TimeValue64    *sampleDecodeDuration );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
decodeTime

A 64-bit time value that represents the decode time for which you are retrieving sample information. You must specify this value in the media's time scale.
sampleNum

A pointer to a variable that is to receive the sample number. The function returns the sample number that identifies the sample that contains data for the specified decode time, or 0 if it is not found.
sampleDecodeTime

A pointer to a time value. The function updates this time value to indicate the decode time of the sample specified by the logicalSampleNum parameter. This time value is expressed in the media's time scale. Set this parameter to NULL if you do not want this information.
sampleDecodeDuration

A pointer to a time value. The function updates this time value to indicate the decode duration of the sample specified by the logicalSampleNum parameter. This time value is expressed in the media's time scale. Set this parameter to NULL if you do not want this information.
Discussion

You can access this function's error returns through GetMoviesError and GetMoviesStickyError. It returns paramErr if there is a bad parameter value, invalidTime if sampleDecodeTime is out of the decode time range, or noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
void MediaDecodeTimeToSampleNum (
   Media          theMedia,
   TimeValue64    decodeTime,
   SInt64         *sampleNum,
   TimeValue64    *sampleDecodeTime,
   TimeValue64    *sampleDecodeDuration );

/*GetMediaSample2

Retrieves sample data from a media file.

OSErr GetMediaSample2 (
   Media                      theMedia,
   UInt8                      *dataOut,
   ByteCount                  maxDataSize,
   ByteCount                  *size,
   TimeValue64                decodeTime,
   TimeValue64                *sampleDecodeTime,
   TimeValue64                *decodeDurationPerSample,
   TimeValue64                *displayOffset,
   SampleDescriptionHandle    sampleDescriptionH,
   ItemCount                  *sampleDescriptionIndex,
   ItemCount                  maxNumberOfSamples,
   ItemCount                  *numberOfSamples,
   MediaSampleFlags           *sampleFlags );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
dataOut

A pointer to a buffer to receive sample data. The buffer must be large enough to contain at least maxDataSize bytes. If you do not want to receive sample data, pass NULL.
maxDataSize

The maximum number of bytes allocated to hold the sample data.
size

A pointer to memory where the function returns the number of bytes of sample data returned in the memory area specified by dataOut. Set this parameter to NULL if you are not interested in this information.
decodeTime

The starting time of the sample to be retrieved in decode time. You must specify this value in the media's time scale.
sampleDecodeTime

A pointer to a time value in decode time. The function updates this time value to indicate the actual time of the returned sample data. (The returned time may differ from the time you specified with the time parameter. This will occur if the time you specified falls in the middle of a sample.) If you are not interested in this information, set this parameter to NULL.
decodeDurationPerSample

A pointer to a time value in decode time. The Movie Toolbox returns the duration of each sample in the media. Set this parameter to NULL if you don't want this information.
displayOffset

A pointer to a time value. The function updates this time value to indicate the display offset of the returned sample. This time value is expressed in the media's time scale. Set this parameter to NULL if you don't want this information.
sampleDescriptionH

A handle to a SampleDescription structure. The function returns the sample description corresponding to the returned sample data. The function resizes this handle as appropriate. If you don't want a SampleDescription structure, set this parameter to NIL.
sampleDescriptionIndex

A pointer to a long integer. The function returns an index value to the SampleDescription structure that corresponds to the returned sample data. You can retrieve the structure by calling GetMediaSampleDescription and passing this index in the descH parameter. If you don't want this information, set this parameter to NIL.
maxNumberOfSamples

The maximum number of samples to be returned. The Movie Toolbox does not return more samples than you specify with this parameter. If you set this parameter to 0, the Movie Toolbox uses a value that is appropriate for the media, and returns that value in the field referenced by the numberOfSamples parameter.
numberOfSamples

A pointer to a long integer. The function updates the field referred to by this parameter with the number of samples it actually returns. If you don't want this information, set this parameter to NULL.
sampleFlags

A pointer to a short integer in which the function returns flags that describe the sample. Unused flags are set to 0. If you don't want this information, set this parameter to NULL: mediaSampleNotSync This flag is set to 1 if the sample is not a sync sample and to 0 if the sample is a sync sample. See these constants: 
mediaSampleNotSync
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError. It returns paramErr if there is a bad parameter value, maxSizeToGrowTooSmall if the sample data is larger than maxDataSize, or noErr if there is no error.
Discussion

Whereas GetMediaSample takes a resizable Handle and a maxSizeToGrow parameter, GetMediaSample2 takes a pointer and a maxDataSize parameter. If you want to read a sample into a Handle, you can use the following code:
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSErr GetMediaSample2 (
   Media                      theMedia,
   UInt8                      *dataOut,
   ByteCount                  maxDataSize,
   ByteCount                  *size,
   TimeValue64                decodeTime,
   TimeValue64                *sampleDecodeTime,
   TimeValue64                *decodeDurationPerSample,
   TimeValue64                *displayOffset,
   SampleDescriptionHandle    sampleDescriptionH,
   ItemCount                  *sampleDescriptionIndex,
   ItemCount                  maxNumberOfSamples,
   ItemCount                  *numberOfSamples,
   MediaSampleFlags           *sampleFlags );

/*GetMediaNextInterestingDecodeTime

Searches for decode times of interest in a media.

void GetMediaNextInterestingDecodeTime (
   Media          theMedia,
   short          interestingTimeFlags,
   TimeValue64    decodeTime,
   Fixed          rate,
   TimeValue64    *interestingDecodeTime,
   TimeValue64    *interestingDecodeDuration );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
interestingTimeFlags

Flags that determine the search criteria. Note that you may set only one of the nextTimeMediaSample, nextTimeMediaEdit, or nextTimeSyncSample flags to 1. Set unused flags to 0: nextTimeMediaSample Set this flag to 1 to search for the next sample. nextTimeMediaEdit Set this flag to 1 to search for the next group of samples. nextTimeSyncSample Set this flag to 1 to search for the next sync sample. nextTimeEdgeOK Set this flag to 1 to accept information about elements that begin or end at the time specified by the decodeTime parameter. When this flag is set the function returns valid information about the beginning and end of a media. See these constants: 
nextTimeMediaSample
nextTimeMediaEdit
nextTimeSyncSample
nextTimeEdgeOK
decodeTime

Specifies the starting point for the search in decode time. This time value must be expressed in the media's time scale.
rate

The search direction. Negative values cause the Movie Toolbox to search backward from the starting point specified in the time parameter. Other values cause a forward search.
interestingDecodeTime

On return, a pointer to a 64-bit time value in decode time. The Movie Toolbox returns the first time value it finds that meets the search criteria specified in the flags parameter. This time value is in the media's time scale. If there are no times that meet the search criteria you specify, the Movie Toolbox sets this value to -1. Set this parameter to NULL if you are not interested in this information.
interestingDecodeDuration

On return, a pointer to a 64-bit time value in decode time. The Movie Toolbox returns the duration of the interesting time in the media's time coordinate system. Set this parameter to NULL if you don't want this information; this lets the function works faster.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
void GetMediaNextInterestingDecodeTime (
   Media          theMedia,
   short          interestingTimeFlags,
   TimeValue64    decodeTime,
   Fixed          rate,
   TimeValue64    *interestingDecodeTime,
   TimeValue64    *interestingDecodeDuration );

/*GetTrackMovie

Determines the movie that contains a specified track.

Movie GetTrackMovie (
   Track    theTrack );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
Return Value

The identifier of the movie that contains the track.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
Movie GetTrackMovie (
   Track    theTrack );

/*GetTrackNextInterestingTime

Searches for times of interest in a track.

void GetTrackNextInterestingTime (
   Track        theTrack,
   short        interestingTimeFlags,
   TimeValue    time,
   Fixed        rate,
   TimeValue    *interestingTime,
   TimeValue    *interestingDuration );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
interestingTimeFlags

Contains flags (see below) that determine the search criteria. Note that you may set only one of the nextTimeMediaSample, nextTimeMediaEdit, nextTimeTrackEdit and nextTimeSyncSample flags to 1. Set unused flags to 0. See these constants: 
nextTimeMediaSample
nextTimeMediaEdit
nextTimeTrackEdit
nextTimeSyncSample
nextTimeEdgeOK
nextTimeIgnoreActiveSegment
time

Specifies a time value that establishes the starting point for the search. This time value must be expressed in the movie's time scale.
rate

The search direction. Negative values cause the Movie Toolbox to search backward from the starting point specified in the time parameter. Other values cause a forward search.
interestingTime

A pointer to a time value. The Movie Toolbox returns the first time value it finds that meets the search criteria specified in the flags parameter. This time value is in the movie's time scale. If there are no times that meet the search criteria you specify, the Movie Toolbox sets this value to -1. Set this parameter to NIL if you are not interested in this information.
interestingDuration

A pointer to a time value. The Movie Toolbox returns the duration of the interesting time. This time value is in the movie's time coordinate system. Set this parameter to NIL if you don't want this information; in this case, the function works more quickly.
Discussion

Some compression algorithms conserve space by eliminating duplication between consecutive frames in a sample. In this case, sync samples don't rely on preceding frames for content. You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void GetTrackNextInterestingTime (
   Track        theTrack,
   short        interestingTimeFlags,
   TimeValue    time,
   Fixed        rate,
   TimeValue    *interestingTime,
   TimeValue    *interestingDuration );


/*TrackTimeToMediaDisplayTime

Converts a track's time value to a display time value that is appropriate to the track's media, using the track's edit list.

TimeValue64 TrackTimeToMediaDisplayTime (
   TimeValue64    value,
   Track          theTrack );
Parameters
value

A 64-bit time value that represents the track's time value; it must be expressed in the time scale of the movie that contains the track.
theTrack

A track identifier, which your application obtains from such functions as NewMovieTrack and GetMovieTrack.
Return Value

A 64-bit time value that represents the corresponding time in media display time, in the media's time coordinate system. If the track time corresponds to empty space, this function returns a value of -1.
Discussion

This function maps the track time through the track's edit list to come up with the media time. This time value contains the track's time value according to the media's time coordinate system. If the time you specified lies outside of the movie's active segment or corresponds to empty space in the track, this function returns a value of -1. Hence you can use it to determine whether a specified track edit is empty.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
TimeValue64 TrackTimeToMediaDisplayTime (
   TimeValue64    value,
   Track          theTrack );


/*GetTrackEditRate

Returns the rate of the track edit of a specified track at an indicated time.

Fixed GetTrackEditRate (
   Track        theTrack,
   TimeValue    atTime );
Parameters
theTrack

The track identifier for which the rate of a track edit (at the time given in the atTime parameter) is to be determined.
atTime

Indicates a time value at which the rate of a track edit (of a track identified in the parameter theTrack) is to be determined.
Return Value

The rate of the track edit of the specified track at the specified time.
Discussion

This function is useful if you are stepping through track edits directly in your application or if you are a client of QuickTime's base media handler.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

Fixed GetTrackEditRate (
   Track        theTrack,
   TimeValue    atTime );

/*CopyMediaMutableSampleTable

Obtains information about sample references in a media in the form of a sample table.

OSErr CopyMediaMutableSampleTable (
   Media                      theMedia,
   TimeValue64                startDecodeTime,
   TimeValue64                *sampleStartDecodeTime,
   SInt64                     maxNumberOfSamples,
   TimeValue64                maxDecodeDuration,
   QTMutableSampleTableRef    *sampleTableOut );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
startDecodeTime

A 64-bit time value that represents the starting decode time of the sample references to be retrieved. You must specify this value in the media's time scale.
sampleStartDecodeTime

A pointer to a time value. The function updates this time value to indicate the actual decode time of the first returned sample reference. If you are not interested in this information, set this parameter to NULL. The returned time may differ from the time you specified with the startDecodeTime parameter. This will occur if the time you specified falls in the middle of a sample.
maxNumberOfSamples

A 64-bit signed integer that contains the maximum number of sample references to be returned. If you set this parameter to 0, the Movie Toolbox uses a value that is appropriate to the media.
maxDecodeDuration

A 64-bit time value that represents the maximum decode duration to be returned. The function does not return samples with greater decode duration than you specify with this parameter. If you set this parameter to 0, the Movie Toolbox uses a value that is appropriate for the media.
sampleTableOut

A reference to an opaque sample table object. When you are done with the returned sample table, release it with QTSampleTableRelease.
Return Value

An error code. Returns memFullErr if it could not allocate memory, paramErr if there was an invalid parameter, or noErr if there is no error. You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result.
Discussion

To find out how many samples were returned in the sample table, call QTSampleTableGetNumberOfSamples.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSErr CopyMediaMutableSampleTable (
   Media                      theMedia,
   TimeValue64                startDecodeTime,
   TimeValue64                *sampleStartDecodeTime,
   SInt64                     maxNumberOfSamples,
   TimeValue64                maxDecodeDuration,
   QTMutableSampleTableRef    *sampleTableOut );

/*QTSampleTableGetNumberOfSamples

Returns the number of samples in a sample table.

SInt64 QTSampleTableGetNumberOfSamples (
   QTSampleTableRef    sampleTable );
Parameters
sampleTable

A reference to an opaque sample table object.
Return Value

A 64-bit signed integer that contains the number of samples, or 0 if sampleTable is NULL.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
SInt64 QTSampleTableGetNumberOfSamples (
   QTSampleTableRef    sampleTable );

/*QTSampleTableGetDecodeDuration

Returns the decode duration of a sample.

TimeValue64 QTSampleTableGetDecodeDuration (
   QTSampleTableRef    sampleTable,
   SInt64              sampleNum );
Parameters
sampleTable

A reference to an opaque sample table object.
sampleNum

A 64-bit signed integer that represents the sample number. The first sample's number is 1.
Return Value

A 64-bit time value that represents the decode duration of the sample. Returns 0 if sampleTable is NULL or if the sample number is out of range.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/

TimeValue64 QTSampleTableGetDecodeDuration (
   QTSampleTableRef    sampleTable,
   SInt64              sampleNum );


/*QTSampleTableGetDataSizePerSample

Returns the data size of a sample.

ByteCount QTSampleTableGetDataSizePerSample (
   QTSampleTableRef    sampleTable,
   SInt64              sampleNum );
Parameters
sampleTable

A reference to an opaque sample table object.
sampleNum

A 64-bit signed integer that represents the sample number. The first sample's number is 1.
Return Value

The size of the sample in bytes. Returns 0 if sampleTable is NULL or if the sample number is out of range.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
ByteCount QTSampleTableGetDataSizePerSample (
   QTSampleTableRef    sampleTable,
   SInt64              sampleNum );

/*QTSampleTableGetSampleFlags

Returns the media sample flags of a sample.

MediaSampleFlags QTSampleTableGetSampleFlags (
   QTSampleTableRef    sampleTable,
   SInt64              sampleNum );
Parameters
sampleTable

A reference to an opaque sample table object.
sampleNum

A 64-bit signed integer that represents the sample number. The first sample's number is 1.
Return Value

A constant that describes characteristics of the sample (see below). Returns 0 if sampleTable is NULL or if the sample number is out of range.
Discussion

This function can return one or more of the following constants:
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/

MediaSampleFlags QTSampleTableGetSampleFlags (
   QTSampleTableRef    sampleTable,
   SInt64              sampleNum );

/*QTSampleTableCopySampleDescription

Retrieves a sample description from a sample table.

OSStatus QTSampleTableCopySampleDescription (
   QTSampleTableRef           sampleTable,
   QTSampleDescriptionID      sampleDescriptionID,
   long                       *mediaSampleDescriptionIndexOut,
   SampleDescriptionHandle    *sampleDescriptionHOut );
Parameters
sampleTable

A reference to an opaque sample table object.
sampleDescriptionID

The sample description ID.
mediaSampleDescriptionIndexOut

A pointer to a variable to receive a media sample description index. If the sample description came from a media, this is the index that could be passed to GetMediaSampleDescription to retrieve the same sample description handle. The index will be 0 if the sample description did not come directly from a media. Pass NULL if you do not want to receive this information.
sampleDescriptionHOut

A pointer to a variable to receive a newly allocated sample description handle. Pass NULL if you do not want one. The caller is responsible for disposing the returned sample description handle using DisposeHandle.
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus QTSampleTableCopySampleDescription (
   QTSampleTableRef           sampleTable,
   QTSampleDescriptionID      sampleDescriptionID,
   long                       *mediaSampleDescriptionIndexOut,
   SampleDescriptionHandle    *sampleDescriptionHOut );

/*SampleNumToMediaDisplayTime

Finds the display time for a specified sample.

void SampleNumToMediaDisplayTime (
   Media          theMedia,
   SInt64         logicalSampleNum,
   TimeValue64    *sampleDisplayTime,
   TimeValue64    *sampleDisplayDuration );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
logicalSampleNum

A 64-bit signed integer that contains the sample number.
sampleDisplayTime

A pointer to a time value. The function updates this time value to indicate the display time of the sample specified by the logicalSampleNum parameter. This time value is expressed in the media's time scale. Set this parameter to NULL if you do not want this information.
sampleDisplayDuration

A pointer to a time value. The function updates this time value to indicate the display duration of the sample specified by the logicalSampleNum parameter. This time value is expressed in the media's time scale. Set this parameter to NULL if you do not want this information.
Discussion

You can access this function's error returns through GetMoviesError and GetMoviesStickyError. It returns paramErr if there is a bad parameter value, or noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/

void SampleNumToMediaDisplayTime (
   Media          theMedia,
   SInt64         logicalSampleNum,
   TimeValue64    *sampleDisplayTime,
   TimeValue64    *sampleDisplayDuration );

/*QTSampleTableGetProperty

Returns the value of a specific sample table property.

OSStatus QTSampleTableGetProperty (
   QTSampleTableRef      sampleTable,
   QTPropertyClass       inPropClass,
   QTPropertyID          inPropID,
   ByteCount             inPropValueSize,
   QTPropertyValuePtr    outPropValueAddress,
   ByteCount             *outPropValueSizeUsed );
Parameters
sampleTable

A reference to an opaque sample table object.
inPropClass

Pass the following constant to define the property class: kQTPropertyClass_SampleTable = 'qtst' Property of a sample table. See these constants: 
kQTPropertyClass_SampleTable
inPropID

Pass one of these constants to define the property ID: kQTSampleTablePropertyID_TotalDecodeDuration = 'tded' The total decode duration of all samples in the sample table. Read-only. kQTSampleTablePropertyID_MinDisplayOffset = '<ddd' The least display offset in the table. Negative offsets are less than positive offsets. Read-only. kQTSampleTablePropertyID_MaxDisplayOffset = '>ddd' The greatest display offset in the table. Positive offsets are greater than negative offsets. Read-only. kQTSampleTablePropertyID_MinRelativeDisplayTime = '<dis' The least display time of all samples in the table, relative to the decode time of the first sample in the table. Read-only. kQTSampleTablePropertyID_MaxRelativeDisplayTime = '>dis' The greatest display time of all samples in the table, relative to the decode time of the first sample in the table. Read-only. See these constants: 
kQTSampleTablePropertyID_TotalDecodeDuration
kQTSampleTablePropertyID_MinDisplayOffset
kQTSampleTablePropertyID_MaxDisplayOffset
kQTSampleTablePropertyID_MinRelativeDisplayTime
kQTSampleTablePropertyID_MaxRelativeDisplayTime
inPropValueSize

The size of the buffer allocated to receive the property value.
outPropValueAddress

A pointer to the buffer allocated to receive the property value.
outPropValueSizeUsed

On return, the actual size of the property value written to the buffer.
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus QTSampleTableGetProperty (
   QTSampleTableRef      sampleTable,
   QTPropertyClass       inPropClass,
   QTPropertyID          inPropID,
   ByteCount             inPropValueSize,
   QTPropertyValuePtr    outPropValueAddress,
   ByteCount             *outPropValueSizeUsed );

/*QTSampleTableRelease

Decrements the retain count of a sample table.

void QTSampleTableRelease (
   QTSampleTableRef    sampleTable );
Parameters
sampleTable

A reference to an opaque sample table object. If you pass NULL in this parameter, nothing happens.
Discussion

If the retain count decreases to zero, the sample table is disposed.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
void QTSampleTableRelease (
   QTSampleTableRef    sampleTable );

/*MediaDisplayTimeToSampleNum

Finds the sample number for a specified display time.

void MediaDisplayTimeToSampleNum (
   Media          theMedia,
   TimeValue64    displayTime,
   SInt64         *sampleNum,
   TimeValue64    *sampleDisplayTime,
   TimeValue64    *sampleDisplayDuration );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
displayTime

A 64-bit time value that represents the display time for which you are retrieving sample information. You must specify this value in the media's time scale.
sampleNum

A pointer to a long integer that is to receive the sample number. The function returns the sample number that identifies the sample for the specified display time, or 0 if it is not found.
sampleDisplayTime

A pointer to a time value. The function updates this time value to indicate the display time of the sample specified by the logicalSampleNum parameter. This time value is expressed in the media's time scale. Set this parameter to NULL if you do not want this information.
sampleDisplayDuration

A pointer to a time value. The function updates this time value to indicate the display duration of the sample specified by the logicalSampleNum parameter. This time value is expressed in the media's time scale. Set this parameter to NULL if you do not want this information.
Discussion

You can access this function's error returns through GetMoviesError and GetMoviesStickyError. It returns paramErr if there is a bad parameter value, invalidTime if sampleDisplayTime is out of the display time range, or noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
void MediaDisplayTimeToSampleNum (
   Media          theMedia,
   TimeValue64    displayTime,
   SInt64         *sampleNum,
   TimeValue64    *sampleDisplayTime,
   TimeValue64    *sampleDisplayDuration );

/*GetMediaAdvanceDecodeTime

Returns the advance decode time of a media.

TimeValue64 GetMediaAdvanceDecodeTime (
   Media    theMedia );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
Return Value

A 64-bit time value that represents the media's advance decode time. A media's advance decode time is the absolute value of the greatest-magnitude negative display offset of its samples, or 0 if there are no samples with negative display offsets. This is the amount that the decode time axis must be adjusted ahead of the display time axis to ensure that no sample's adjusted decode time is later than its display time. For media without nonzero display offsets, the advance decode time is 0.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/

TimeValue64 GetMediaAdvanceDecodeTime (
   Media    theMedia );

/*GetTrackDimensions

Determines a track's source rectangle.

void GetTrackDimensions (
   Track    theTrack,
   Fixed    *width,
   Fixed    *height );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
width

A pointer to a fixed-point number. The Movie Toolbox returns the width, in pixels, of the track's rectangle. This value corresponds to the x coordinate of the lower-right corner of the track's rectangle.
height

A pointer to a fixed-point number. The Movie Toolbox returns the height, in pixels, of the track's rectangle. This value corresponds to the y coordinate of the lower-right corner of the track's rectangle.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void GetTrackDimensions (
   Track    theTrack,
   Fixed    *width,
   Fixed    *height );

/*QTSampleTableGetDisplayOffset

Returns the offset from decode time to display time of a sample.

TimeValue64 QTSampleTableGetDisplayOffset (
   QTSampleTableRef    sampleTable,
   SInt64              sampleNum );
Parameters
sampleTable

A reference to an opaque sample table object.
sampleNum

A 64-bit signed integer that represents the sample number. The first sample's number is 1.
Return Value

A 64-bit time value that represents the offset from decode time to display time of the sample. Returns 0 if sampleTable is NULL or if the sample number is out of range.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
TimeValue64 QTSampleTableGetDisplayOffset (
   QTSampleTableRef    sampleTable,
   SInt64              sampleNum );

/*QTSampleTableGetSampleDescriptionID

Returns the sample description ID of a sample.

QTSampleDescriptionID QTSampleTableGetSampleDescriptionID (
   QTSampleTableRef    sampleTable,
   SInt64              sampleNum );
Parameters
sampleTable

A reference to an opaque sample table object.
sampleNum

A 64-bit signed integer that represents the sample number. The first sample's number is 1.
Return Value

The sample's sample description ID. Returns 0 if sampleTable is NULL or if the sample number is out of range.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
QTSampleDescriptionID QTSampleTableGetSampleDescriptionID (
   QTSampleTableRef    sampleTable,
   SInt64              sampleNum );

/*QTNewDataReferenceFromCFURL

Creates a URL data reference from a CFURL.

OSErr QTNewDataReferenceFromCFURL (
   CFURLRef    url,
   UInt32      flags,
   Handle      *outDataRef,
   OSType      *outDataRefType );
Parameters
url

A reference to a Core Foundation struct that represents the URL to which you want a URL data reference. These structs contain two parts: the string and a base URL, which may be empty. With a relative URL, the string alone does not fully specify the address; with an absolute URL it does.
flags

Currently not used; pass 0.
outDataRef

A pointer to a handle in which the newly created alias data reference is returned.
outDataRefType

A pointer to memory in which the OSType of the newly created data reference is returned.
Return Value

See “Error Codes” in the QuickTime API Reference. Returns noErr if there is no error. Returns paramErr if either of the output parameters is NIL
Discussion

The new URL data reference returned can be passed to other Movie Toolbox calls that take a data reference.
Version Notes

Introduced in QuickTime 6.4.
Availability
Carbon status: Supported; C interface file: Movies.h*/
OSErr QTNewDataReferenceFromCFURL (
   CFURLRef    url,
   UInt32      flags,
   Handle      *outDataRef,
   OSType      *outDataRefType );

/*PutMovieIntoHandle

Creates a new movie resource.

OSErr PutMovieIntoHandle (
   Movie     theMovie,
   Handle    publicMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
publicMovie

The handle that is to receive the new movie resource. The function resizes the handle if necessary.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

Use this handle to store a QuickTime movie in a specialized storage format.
Special Considerations

Note that you cannot use this new movie with other Movie Toolbox functions, except for NewMovieFromHandle.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr PutMovieIntoHandle (
   Movie     theMovie,
   Handle    publicMovie );


/*NewMovieFromHandle

Creates a movie in memory from a movie resource or a handle you obtained from PutMovieIntoHandle.

OSErr NewMovieFromHandle (
   Movie      *theMovie,
   Handle     h,
   short      newMovieFlags,
   Boolean    *dataRefWasChanged );
Parameters
theMovie

A pointer to a field that is to receive the new movie's identifier. If the function cannot load the movie, the returned identifier is set to NIL.
h

A handle to the movie resource from which the movie is to be loaded.
newMovieFlags

Flags (see below) that control the operation of NewMovieFromHandle. Be sure to set unused flags to 0. See these constants: 
newMovieActive
newMovieDontResolveDataRefs
newMovieDontAskUnresolvedDataRefs
dataRefWasChanged

A pointer to a Boolean value. The toolbox sets the value to TRUE if any references were changed. Set the dataRefWasChanged parameter to NIL if you don't want to receive this information.
Return Value

If the Movie Toolbox cannot completely resolve all data references, it sets the current error value to couldNotResolveDataRef. You can access error returns such as this through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

The Movie Toolbox sets many movie characteristics to default values. If you want to change these defaults, your application must call other Movie Toolbox functions. For example, the Movie Toolbox sets the movie's graphics world to the one that is active when you call NewMovieFromHandle. To change the graphics world for the new movie, your application should use SetMovieGWorld.
Special Considerations

The Movie Toolbox automatically sets the movie's graphics world based on the current graphics port. Be sure that your application's graphics port is valid before you call this function, even if the movie is sound-only; you can use GetGWorld to check for a valid port, or you can use NewGWorld to create a port. The graphics port must remain valid for the life of the movie or until you set another valid graphics port for the movie using SetMovieGWorld.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSErr NewMovieFromHandle (
   Movie      *theMovie,
   Handle     h,
   short      newMovieFlags,
   Boolean    *dataRefWasChanged );

/*DetachMovieFromCurrentThread

Detaches a movie from the current thread.

OSErr DetachMovieFromCurrentThread (Movie m);
Parameters
m

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/

OSErr DetachMovieFromCurrentThread (Movie m);


/*AttachMovieToCurrentThread

Attaches a movie to the current thread.

OSErr AttachMovieToCurrentThread (Movie m);
Parameters
m

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSErr AttachMovieToCurrentThread (Movie m);

/*QTGetEffectSpeed

Returns the speed of the effect, expressed in frames per second.

OSErr QTGetEffectSpeed (
   QTAtomContainer    parameters,
   Fixed              *pFPS );
Parameters
parameters

Contains parameter values for the effect.
pFPS

The speed of the effect is returned in this parameter, expressed in frames per second. Effects can also return the pre-defined constant effectIsRealtime (see below) as their speed. See these constants: 
effectIsRealtime
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

The value returned should not be treated as an absolute measurement of effect performance. In particular, most effects only return one value, regardless of parameter settings and hardware. This value is an estimate of execution speed on a reference hardware platform. Actual performance will vary depending on hardware, configuration and parameter options.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTGetEffectSpeed (
   QTAtomContainer    parameters,
   Fixed              *pFPS );


/*QTCountChildrenOfType

Returns the number of atoms of a given type in the child list of the specified parent atom.

short QTCountChildrenOfType (
   QTAtomContainer    container,
   QTAtom             parentAtom,
   QTAtomType         childType );
Parameters
container

The atom container that contains the parent atom.
parentAtom

The parent atom for this operation.
childType

The atom type for this operation. To retrieve the total number of atoms in the child list, set this parameter to 0. 
Return Value

The number of atoms of a given type in the child list of the specified parent atom.
Discussion

You can call this function to determine the number of atoms of a specified type in a parent atom's child list. If the total number of atoms in the parent atom's child list is 0, the parent atom is a leaf atom.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

short QTCountChildrenOfType (
   QTAtomContainer    container,
   QTAtom             parentAtom,
   QTAtomType         childType );

/*QTNextChildAnyType

Returns the next atom in the child list of the specified parent atom.

OSErr QTNextChildAnyType (
   QTAtomContainer    container,
   QTAtom             parentAtom,
   QTAtom             currentChild,
   QTAtom             *nextChild );
Parameters
container

The atom container that contains the parent atom.
parentAtom

The parent atom for this operation.
currentChild

The last atom retrieved by this function. To retrieve the first atom in the child list, set the value of currentChild to 0.
nextChild

A pointer to an uninitialized QT atom data structure. On return, the data structure contains the offset of the next atom in the child list after the atom specified by currentChild, or 0 if the atom specified by currentChild was the last atom in the list.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You can call this function to iterate through all the atoms in a parent atom's child list, regardless of their types and IDs.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTNextChildAnyType (
   QTAtomContainer    container,
   QTAtom             parentAtom,
   QTAtom             currentChild,
   QTAtom             *nextChild );

/*QTGetAtomTypeAndID

Retrieves an atom's type and ID.

OSErr QTGetAtomTypeAndID (
   QTAtomContainer    container,
   QTAtom             atom,
   QTAtomType         *atomType,
   QTAtomID           *id );
Parameters
container

The atom container that contains the atom.
atom

The atom whose type and ID should be retrieved.
atomType

A pointer to an atom type. On return, this parameter points to the type of the specified atom. You can pass NIL for this parameter if you don't need this information.
id

A pointer to an atom ID. On return, this parameter points to the ID of the specified atom. You can pass NIL for this parameter if you don't need this information.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTGetAtomTypeAndID (
   QTAtomContainer    container,
   QTAtom             atom,
   QTAtomType         *atomType,
   QTAtomID           *id );

/*SetMovieActive

Activates or deactivates a movie.

void SetMovieActive (
   Movie      theMovie,
   Boolean    active );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
active

Activates or deactivates the movie. Set this parameter to TRUE to activate the movie; set this parameter to FALSE to deactivate the movie.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void SetMovieActive (
   Movie      theMovie,
   Boolean    active );


/*IsMovieDone

Determines if a particular movie has completely finished playing.

Boolean IsMovieDone (
   Movie    theMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

Returns TRUE if the specified movie has finished playing, otherwise returns FALSE.
Discussion

A movie with a positive rate (playing forward) is considered done when its movie time reaches the movie end time. Conversely, a movie with a negative rate (playing backward) is considered done when its movie time reaches the movie start time. If your application has changed the movie's active segment, the status returned by this function is relative to the active segment, rather than to the entire movie. You can use SetMovieActiveSegment to change a movie's active segment.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
Boolean IsMovieDone (
   Movie    theMovie );


/*GetMovieBox

Returns a movie's boundary rectangle, which is a rectangle that encompasses all of the movie's enabled tracks.

void GetMovieBox (
   Movie    theMovie,
   Rect     *boxRect );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
boxRect

A pointer to a rectangle. GetMovieBox returns the coordinates of the movie's boundary rectangle into the structure referred to by this parameter.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Discussion

The movie box is in the coordinate system of the movie's graphics world and defines the movie's boundaries over the entire duration of the movie. The movie's boundary rectangle defines the size and shape of the movie before the Movie Toolbox applies the display clipping region. The following code sample illustrates the use of GetMovieBox:// GetMovieBox coding example
// See "Discovering QuickTime," page 218
void main (void)
{
    WindowRef       pMacWnd;
    Rect            rectWnd;
    Rect            rectMovie;
    Movie           movie;
    Boolean         bDone =FALSE;
    OSErr           nErr;
    EventRecord     er;
    WindowRef       pWhichWnd;
    short           nPart;
    InitGraf(&qd.thePort);
    InitFonts();
    InitWindows();
    InitMenus();
    TEInit();
    InitDialogs(NIL);
    nErr =EnterMovies();
    if (nErr !=noErr)
        return;
 
    SetRect(&rectWnd, 100, 100, 200, 200);
    pMacWnd =NewCWindow(NIL, &rectWnd, "\pMovie", FALSE,
                            noGrowDocProc, (WindowRef)-1, TRUE, 0);
    SetPort(pMacWnd);
    movie =GetMovie();
    if (movie ==NIL)
        return;
 
    GetMovieBox(movie, &rectMovie);
    OffsetRect(&rectMovie, -rectMovie.left, -rectMovie.top);
    SetMovieBox(movie, &rectMovie);
 
    SizeWindow(pMacWnd, rectMovie.right, rectMovie.bottom, TRUE);
    ShowWindow(pMacWnd);
    SetMovieGWorld(movie, (CGrafPtr)pMacWnd, NIL);
 
    StartMovie(movie);
 
    . . .
 
    DisposeMovie(movie);
    DisposeWindow(pMacWnd);
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void GetMovieBox (
   Movie    theMovie,
   Rect     *boxRect );

/*NewMovieController

Locates a movie controller component and assigns a movie to that controller.

ComponentInstance NewMovieController (
   Movie         theMovie,
   const Rect    *movieRect,
   long          someFlags );
Parameters
theMovie

The movie to be associated with the movie controller.
movieRect

A pointer to the Rect structure that is to define the display boundaries of the movie and its controller.
someFlags

Contains flags (see below) that control the operation. If you set these flags to 0, the movie controller component centers the movie in the rectangle specified by the movieRect parameter and scales the movie to fit in that rectangle. The control portion of the controller is also placed within that rectangle. You may control how the movie and the control are drawn by setting one or more flags to 1. See these constants: 
mcTopLeftMovie
mcScaleMovieToFit
mcWithBadge
mcNotVisible
mcWithFrame
Return Value

The ID of the new controller.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
ComponentInstance NewMovieController (
   Movie         theMovie,
   const Rect    *movieRect,
   long          someFlags );


/*DisposeMovieDrawingCompleteUPP

Disposes of a MovieDrawingCompleteUPP pointer.

void DisposeMovieDrawingCompleteUPP (
   MovieDrawingCompleteUPP    userUPP );
Parameters
userUPP

A MovieDrawingCompleteUPP pointer. See Universal Procedure Pointers.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 4.1.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void DisposeMovieDrawingCompleteUPP (
   MovieDrawingCompleteUPP    userUPP );

/*DisposeMovieController

Disposes of a movie controller.

void DisposeMovieController (
   ComponentInstance    mc );
Parameters
mc

The movie controller for the operation. You obtain this identifier from the Component Manager's OpenComponent or OpenDefaultComponent function, or from the NewMovieController function.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Discussion

This function is implemented by the Movie Toolbox, not by movie controller components. If you are creating your own movie controller component, you do not have to support this function. The following code snippet illustrates its use:// DisposeMovieController coding example
// See "Discovering QuickTime," page 221
// Resource identifiers
#define IDM_OPEN         101
char            szMovieFile[MAX_PATH];              // Name of movie file
Movie           movie;                              // Movie object
MovieController mc;                                 // Movie controller
int WINAPI WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance,
                      LPSTR lpCmdLine, int nCmdShow)
{
    ...
    ...
    InitializeQTML(0);                          // Initialize QuickTime
    EnterMovies();                              // Initialize Toolbox
    ...
    //  Main message loop
    ...
    ExitMovies();                               // Terminate Toolbox
    TerminateQTML();                            // Terminate QuickTime
}  // end WinMain
//
LRESULT CALLBACK WndProc (HWND hwnd, UINT iMsg, WPARAM wParam, LPARAM lParam)
{
    MSG             msg;
    EventRecord     er;
 
    . . .                                       // Fill in contents of MSG structure
 
    WinEventToMacEvent(&msg, &er);                  // Convert message to a QT event
    MCIsPlayerEvent(mc, (const EventRecord *)&er);  // Pass event to movie controller
 
    switch (iMsg) {
        case WM_CREATE:
            CreatePortAssociation(hwnd, NIL, 0L);  // Register window with QT
            break;
        case WM_COMMAND:
            switch (LOWORD(wParam)) {
                case IDM_OPEN:
                    MyCloseMovie();                 // Close previous movie, if any
 
                    if (MyGetFile(szMovieFile))         // Get file name from user
                        MyOpenMovie(hwnd, szMovieFile); // Open the movie
                    break;
                    . . .
                default:
                    return DefWindowProc(hwnd, iMsg, wParam, lParam);
            }  // end switch (LOWORD(wParam))
            break;
        case WM_CLOSE:
            DestroyPortAssociation(GetNativeWindowPort(hwnd));  // Unregister window
            break;
        . . .
        default:
            return DefWindowProc(hwnd, iMsg, wParam, lParam);
 
    }  // end switch (iMsg)
 
    return 0;
}  // end WndProc
//
BOOL MyGetFile (char *lpszMovieFile)
{
    OPENFILENAME         ofn;
 
    // Fill in contents of OPENFILENAME structure
                ...
                ...
 
     if (GetOpenFileName(&ofn))                     // Let user select file
        return TRUE;
    else
        return FALSE;
}  // end MyGetFile
//
void MyOpenMovie (HWND hwnd, char szFileName[255])
{
    short   nFileRefNum =0;
    FSSpec  fss;
    SetGWorld((CGrafPtr)GetNativeWindowPort(hwnd), NIL);   // Set graphics port
    NativePathNameToFSSpec(szFileName, &fss, 0);    // Convert pathname and make FSSpec
    OpenMovieFile(&fss, &nFileRefNum, fsRdPerm);    // Open movie file
    NewMovieFromFile(&movie, nFileRefNum, NIL,     // Get movie from file
                    NIL, newMovieActive, NIL);
    CloseMovieFile(nFileRefNum);                    // Close movie file
 
    mc =NewMovieController(movie, ...);            // Make movie controller
        ...
        ...
 
}  // end MyOpenMovie
//
void MyCloseMovie (void)
{
    if (mc)                                     // Destroy movie controller, if any
        DisposeMovieController(mc);
 
    if (movie)                                  // Destroy movie object, if any
        DisposeMovie(movie);
}  // end MyCloseMovie

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void DisposeMovieController (
   ComponentInstance    mc );


/*NewMovieDrawingCompleteUPP

Allocates a Universal Procedure Pointer for the MovieDrawingCompleteProc callback.

MovieDrawingCompleteUPP NewMovieDrawingCompleteUPP (
   MovieDrawingCompleteProcPtr    userRoutine );
Parameters
userRoutine

A pointer to your application-defined function.
Return Value

A new UPP; see Universal Procedure Pointers.
Discussion

This function is used with Macintosh PowerPC systems. See Inside Macintosh: PowerPC System Software.
Version Notes

Introduced in QuickTime 4.1. Replaces NewMovieDrawingCompleteProc.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
MovieDrawingCompleteUPP NewMovieDrawingCompleteUPP (
   MovieDrawingCompleteProcPtr    userRoutine );

/*SetMovieDrawingCompleteProc

Assigns a drawing-complete function to a movie.

void SetMovieDrawingCompleteProc (
   Movie                      theMovie,
   long                       flags,
   MovieDrawingCompleteUPP    proc,
   long                       refCon );
Parameters
theMovie

The movie for this operation.
flags

Contains flags (see below) that control when your drawing complete function is called. See these constants: 
movieDrawingCallWhenChanged
movieDrawingCallAlways
proc

A pointer to your MovieDrawingCompleteProc callback. Set this parameter to NIL if you want to remove your callback.
refCon

The reference constant you supplied when your application called your callback. Use this parameter to point to a data structure containing any information your callback needs.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

The Movie Toolbox calls this function based upon guidelines you establish when you assign the function to the movie. 
Special Considerations

Some media handlers may take less efficient playback paths when a drawing-complete function is used, so it should be used only when absolutely necessary.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void SetMovieDrawingCompleteProc (
   Movie                      theMovie,
   long                       flags,
   MovieDrawingCompleteUPP    proc,
   long                       refCon );

/*MCIdle

Performs idle processing for a movie controller.

ComponentResult MCIdle (
   MovieController    mc );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/
ComponentResult MCIdle (
   MovieController    mc );

/*QTNewDataReferenceFromFSRef

Creates an alias data reference from a file specification.

OSErr QTNewDataReferenceFromFSRef (
   const FSRef    *fileRef,
   UInt32          flags,
   Handle          *outDataRef,
   OSType          *outDataRefType );
Parameters
fileRef

A pointer to an opaque file system reference.
flags

Currently not used; pass 0.
outDataRef

A pointer to a handle in which the newly created alias data reference is returned.
outDataRefType

A pointer to memory in which the OSType of the newly created data reference is returned.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error. Returns paramErr if either of the output parameters is NIL
Discussion

You can use File Manager functions to construct a file specification for a file to which you want the new alias data reference to point. Then you can pass the reference to other Movie Toolbox functions that take a data reference. To construct a file specification, the file must already exist. To create an alias data reference for a file that does not exist yet, such as a new file to be created by a Movie Toolbox function, call QTNewDataReferenceFromFSRefCFString.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/

OSErr QTNewDataReferenceFromFSRef (
   const FSRef    *fileRef,
   UInt32          flags,
   Handle          *outDataRef,
   OSType          *outDataRefType );

/*CanQuickTimeOpenDataRef

Determines whether referenced data can be opened using a graphics importer or opened in place as a movie.

OSErr CanQuickTimeOpenDataRef (
   Handle     dataRef,
   OSType     dataRefType,
   Boolean    *outCanOpenWithGraphicsImporter,
   Boolean    *outCanOpenAsMovie,
   Boolean    *outPreferGraphicsImporter,
   UInt32     inFlags );
Parameters
dataRef

A handle to the referenced data.
dataRefType

The type of data reference pointed to by dataRef; see Data References.
outCanOpenWithGraphicsImporter

Points to a Boolean that will be set to TRUE if the file can be opened using a graphics importer and FALSE otherwise. If you do not want this information, pass NIL.
outCanOpenAsMovie

Points to a Boolean that will be set to TRUE if the file can be opened as a movie and FALSE otherwise. If you do not want this information, pass NIL.
outPreferGraphicsImporter

Points to a boolean which will be set to true if the file can be opened using a graphics importer and opened as a movie, but, other factors being equal, QuickTime prefers a graphics importer. For example, QuickTime recommends using a graphics importer for single-frame GIF files and opening as a movie for multiple-frame GIF files. If you do not want this information, pass NIL. Passing a valid pointer disables the kQTDontUseDataToFindImporter and kQTDontLookForMovieImporterIfGraphicsImporterFound flags, if set.
inFlags

Flags (see below) that modify search behavior. Pass 0 for default behavior. See these constants: 
kQTDontUseDataToFindImporter
kQTDontLookForMovieImporterIfGraphicsImporterFound
kQTAllowOpeningStillImagesAsMovies
kQTAllowImportersThatWouldCreateNewFile
kQTAllowAggressiveImporters
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

This function determines whether QuickTime can open a given area of data. You should pass NIL in parameters that do not interest you, since that will allow QuickTime to perform a faster determination.
Version Notes

Introduced in QuickTime 5.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr CanQuickTimeOpenDataRef (
   Handle     dataRef,
   OSType     dataRefType,
   Boolean    *outCanOpenWithGraphicsImporter,
   Boolean    *outCanOpenAsMovie,
   Boolean    *outPreferGraphicsImporter,
   UInt32     inFlags );


/*QTInstallNextTaskNeededSoonerCallback

Installs a QTNextTaskNeededSoonerCallbackProc callback.

OSErr QTInstallNextTaskNeededSoonerCallback (
   QTNextTaskNeededSoonerCallbackUPP    callbackProc,
   TimeScale                            scale,
   unsigned long                        flags,
   void                                *refcon );
Parameters
callbackProc

A Universal Procedure Pointer to a QTNextTaskNeededSoonerCallbackProc callback.
scale

The time scale that QuickTime will use when reporting the duration until the next time QuickTime needs to be called, via QTGetTimeUntilNextTask.
flags

Unused; set to 0.
refcon

A reference constant to be passed to your callback. Use this parameter to point to a data structure containing any information your callback needs.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

This routine installs a callback procedure that specifies when QuickTime next needs to be tasked. The callback procedure may be called at interrupt time or from another Mac OS X thread, so you must be careful not to cause race conditions. You can install or uninstall multiple callback procedures if necessary; they will be called in sequence. You can also install the same callback multiple times with different refcon values, in which case it will be called once with each refcon value.
Version Notes

Introduced in QuickTime 6.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Movies.h*/

OSErr QTInstallNextTaskNeededSoonerCallback (
   QTNextTaskNeededSoonerCallbackUPP    callbackProc,
   TimeScale                            scale,
   unsigned long                        flags,
   void                                *refcon );

/*QTGetTimeUntilNextTask

Reports the duration until the next time QuickTime needs to run a task.

OSErr QTGetTimeUntilNextTask (
   long    *duration,
   long    scale );
Parameters
duration

A pointer to the duration until the next time QuickTime needs access to the processor. If the returned duration is 0, QuickTime needs to run a task immediately.
scale

The time scale in which to express the returned duration. For example, pass 60 if you want the duration value expressed in ticks (60ths of a second).
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

Periodically, applications have to give processing time to QuickTime by calling a function such as MCIsPlayerEvent. Instead of routinely calling MCIsPlayerEvent 10 to 20 times per second, you can call QTGetTimeUntilNextTask to determine when QuickTime next needs access to the processor. The result is a more efficent use of processor resources. To handle cases when QuickTime may need to run a task earlier than projected by this function, you can install a QTNextTaskNeededSoonerCallbackProc callback.
Version Notes

Introduced in QuickTime 6.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Movies.h*/

OSErr QTGetTimeUntilNextTask (
   long    *duration,
   long    scale );

/*QTUninstallNextTaskNeededSoonerCallback

Removes a QTNextTaskNeededSoonerCallbackProc callback.

OSErr QTUninstallNextTaskNeededSoonerCallback (
   QTNextTaskNeededSoonerCallbackUPP    callbackProc,
   void                                *refcon );
Parameters
callbackProc

A Universal Procedure Pointer to a QTNextTaskNeededSoonerCallbackProc callback that you installed by a previous call to QTInstallNextTaskNeededSoonerCallback.
refcon

A pointer to the reference constant that you passed when the callback was installed.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You pass this routine both a pointer to a callback procedure and a pointer to its reference constant, so you can uninstall one instance of a callback that you installed more than once with different refcon values.
Version Notes

Introduced in QuickTime 6.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Movies.h*/
OSErr QTUninstallNextTaskNeededSoonerCallback (
   QTNextTaskNeededSoonerCallbackUPP    callbackProc,
   void                                *refcon );

/*QTGetMovieProperty

Returns the value of a specific movie property.

OSErr QTGetMovieProperty (
   Movie                 inMovie,
   QTPropertyClass       inPropClass,
   QTPropertyID          inPropID,
   ByteCount             inPropValueSize,
   QTPropertyValuePtr    outPropValueAddress,
   ByteCount             *outPropValueSizeUsed );
Parameters
inMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
inPropClass

A property class.
inPropID

A property ID.
inPropValueSize

The size of the buffer allocated to hold the property value.
outPropValueAddress

A pointer to the buffer allocated to hold the property value.
outPropValueSizeUsed

On return, the actual size of the value written to the buffer.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSErr QTGetMovieProperty (
   Movie                 inMovie,
   QTPropertyClass       inPropClass,
   QTPropertyID          inPropID,
   ByteCount             inPropValueSize,
   QTPropertyValuePtr    outPropValueAddress,
   ByteCount             *outPropValueSizeUsed );

/*QTGetMoviePropertyInfo

Returns information about the properties of a movie.

OSErr QTGetMoviePropertyInfo (
   Movie                  inMovie,
   QTPropertyClass        inPropClass,
   QTPropertyID           inPropID,
   QTPropertyValueType    *outPropType,
   ByteCount              *outPropValueSize,
   UInt32                 *outPropertyFlags );
Parameters
inMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
inPropClass

A property class.
inPropID

A property ID.
outPropType

A pointer to memory allocated to hold the property type on return.
outPropValueSize

A pointer to memory allocated to hold the size of the property value on return.
outPropertyFlags

A pointer to memory allocated to hold property flags on return.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/

OSErr QTGetMoviePropertyInfo (
   Movie                  inMovie,
   QTPropertyClass        inPropClass,
   QTPropertyID           inPropID,
   QTPropertyValueType    *outPropType,
   ByteCount              *outPropValueSize,
   UInt32                 *outPropertyFlags );

/*CanQuickTimeOpenFile

Determines whether a file can be opened using a graphics importer or opened in place as a movie.

OSErr CanQuickTimeOpenFile (
   FSSpecPtr    fileSpec,
   OSType       fileType,
   OSType       fileNameExtension,
   Boolean      *outCanOpenWithGraphicsImporter,
   Boolean      *outCanOpenAsMovie,
   Boolean      *outPreferGraphicsImporter,
   UInt32       inFlags );
Parameters
fileSpec

Points to an FSSpec structure that identifies a file. To ask about a particular file type or file name suffix in general, pass NIL.
fileType

Contains the file type if already known, or 0 if not known. If fileSpec is provided and fileType is 0, QuickTime will determine the file type. If you pass NIL in fileSpec and 0 in fileNameExtension, you must pass a file type here.
fileNameExtension

Contains the file name suffix if already known, or 0 if not known. The file name suffix should be encoded as an uppercase four character code with trailing spaces; for instance, the suffix ".png" should be encoded as 'PNG ', or 0x504E4720. If fileSpec is provided and fileNameExtension is 0, QuickTime will examine fileSpec to determine the file name suffix. If you pass NIL in fileSpec and 0 in fileType, you must pass a file name suffix here.
outCanOpenWithGraphicsImporter

Points to a Boolean that will be set to TRUE if the file can be opened using a graphics importer and FALSE otherwise. If you do not want this information, pass NIL.
outCanOpenAsMovie

Points to a Boolean that will be set to TRUE if the file can be opened as a movie and FALSE otherwise. If you do not want this information, pass NIL.
outPreferGraphicsImporter

Points to a boolean which will be set to true if the file can be opened using a graphics importer and opened as a movie, but, other factors being equal, QuickTime prefers a graphics importer. For example, QuickTime recommends using a graphics importer for single-frame GIF files and opening as a movie for multiple-frame GIF files. If you do not want this information, pass NIL. Passing a valid pointer disables the kQTDontUseDataToFindImporter and kQTDontLookForMovieImporterIfGraphicsImporterFound flags, if set.
inFlags

Flags (see below) that modify search behavior. Pass 0 for default behavior. See these constants: 
kQTDontUseDataToFindImporter
kQTDontLookForMovieImporterIfGraphicsImporterFound
kQTAllowOpeningStillImagesAsMovies
kQTAllowImportersThatWouldCreateNewFile
kQTAllowAggressiveImporters
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

This function determines whether QuickTime can open a given file or, in general, files of a given type. You should pass NIL in parameters that do not interest you, since that will allow QuickTime to perform a faster determination.
Version Notes

Introduced in QuickTime 5.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr CanQuickTimeOpenFile (
   FSSpecPtr    fileSpec,
   OSType       fileType,
   OSType       fileNameExtension,
   Boolean      *outCanOpenWithGraphicsImporter,
   Boolean      *outCanOpenAsMovie,
   Boolean      *outPreferGraphicsImporter,
   UInt32       inFlags );

/*QTNewDataReferenceFromURLCFString

Creates a URL data reference from a CFString that represents a URL string.

OSErr QTNewDataReferenceFromURLCFString (
   CFStringRef    urlString,
   UInt32         flags,
   Handle         *outDataRef,
   OSType         *outDataRefType );
Parameters
urlString

A CFString that represents a URL string.
flags

Currently not used; pass 0.
outDataRef

A pointer to a handle in which the newly created alias data reference is returned.
outDataRefType

A pointer to memory in which the OSType of the newly created data reference is returned.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error. Returns paramErr if either of the output parameters is NIL
Discussion

The new URL data reference returned can be passed to other Movie Toolbox calls that take a data reference.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/

OSErr QTNewDataReferenceFromURLCFString (
   CFStringRef    urlString,
   UInt32         flags,
   Handle         *outDataRef,
   OSType         *outDataRefType );

/*CreateMovieControl

Creates a movie control object to pass to the Mac OS Control Manager.

OSErr CreateMovieControl (
   WindowRef     theWindow,
   Rect          *localRect,
   Movie         theMovie,
   UInt32        options,
   ControlRef    *returnedControl );
Parameters
theWindow

The window in which the control is placed.
localRect

A pointer to a Rect structure that describes in local coordinates the window in which the movie control is placed. If NIL is passed, the movie control is positioned at 0,0 within the window; it will have the natural dimensions of the movie plus the height of the movie controls if they are visible. If 0 height and width is passed, this parameter is interpreted as an anchor point and the top left point of the movie control will be located at this position with height and width as in the NIL case. For all other cases of rectangles, the movie control is centered within the rectangle by default and is sized to fit within it while maintaining the movie's aspect ratio.
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
options

Constants (see below) that determine parts of the movie control's appearance. See these constants: 
kMovieControlOptionHideController
kMovieControlOptionLocateTopLeft
kMovieControlOptionEnableEditing
kMovieControlOptionHandleEditingHI
kMovieControlOptionSetKeysEnabled
kMovieControlOptionManuallyIdled
returnedControl

A handle to a ControlRecord struct. This defines a movie control, suitable for passing to Mac OS Control Manager functions.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes. This routine returns an error if there is a problem with one of the parameters or if an error occurred while creating the underlying movie controller or the custom control itself. If an error is returned, the value of returnedControl is undefined.
Discussion

The Carbon Movie Control is implemented as a custom control, which installs an event handler to handle the Carbon Events sent to controls. When a Carbon Movie Control is created for a movie, a movie controller is also created. The movie control then directs user interface events to the controller. The application can install event handlers on the Carbon Movie Control to handle such things as contextual menu clicks or to intercept events to do special processing. Control Manager calls can be made as well.
Special Considerations

The control can be deleted by calling the Mac OS function DisposeControl. Note that the control is automatically disposed of if the enclosing window is destroyed. Note, too, that the underlying movie controller is disposed of when the control is deleted.
Version Notes

Introduced in QuickTime 6.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Movies.h*/

OSErr CreateMovieControl (
   WindowRef     theWindow,
   Rect          *localRect,
   Movie         theMovie,
   UInt32        options,
   ControlRef    *returnedControl );

/*GetMovieAudioFrequencyLevels

Returns the current frequency meter levels of a movie mix.

OSStatus GetMovieAudioFrequencyLevels (
   Movie                     m,
   FourCharCode              whatMixToMeter,
   QTAudioFrequencyLevels    *pAveragePowerLevels );
Parameters
m

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromProperties, NewMovieFromFile, and NewMovieFromHandle.
whatMixToMeter

The applicable mix of audio channels in the movie; see Movie Audio Mixes.
pAveragePowerLevels

A pointer to a QTAudioFrequencyLevels structure (page 325).
Return Value

An error code. Returns noErr if there is no error.
Discussion

In the structure pointed to by pAveragePowerLevels, the numChannels field must be set to the number of channels in the movie mix being metered and the numBands field must be set to the number of bands being metered (as previously configured). Enough memory for the structure must be allocated to hold 32-bit values for all bands in all channels. This function returns the current frequency meter levels in the level field of the structure, with all the band levels for the first channel first, all the band levels for the second channel next and so on.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus GetMovieAudioFrequencyLevels (
   Movie                     m,
   FourCharCode              whatMixToMeter,
   QTAudioFrequencyLevels    *pAveragePowerLevels );

/*SetMovieAudioFrequencyMeteringNumBands

Configures frequency metering for a particular audio mix in a movie.

OSStatus SetMovieAudioFrequencyMeteringNumBands (
   Movie           m,
   FourCharCode    whatMixToMeter,
   UInt32          *ioNumBands );
Parameters
m

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromProperties, NewMovieFromFile, and NewMovieFromHandle.
whatMixToMeter

The applicable mix of audio channels in the movie; see Movie Audio Mixes.
ioNumBands

A pointer to memory that stores the number of bands being metered. On calling this function, you specify the number of frequency bands you want to meter. If that number is higher than is possible (determined by factors such as the sample rate of the audio being metered), the function will return the number of bands it is actually going to meter. You can pass NIL or a pointer to 0 to disable metering.
Return Value

An error code. Returns noErr if there is no error.
Discussion

See GetMovieAudioFrequencyMeteringNumBands.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus SetMovieAudioFrequencyMeteringNumBands (
   Movie           m,
   FourCharCode    whatMixToMeter,
   UInt32          *ioNumBands );

/*GetMovieUserData

Obtains access to a movie's user data list.

UserData GetMovieUserData (
   Movie    theMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

The UserDataRecord structure for the movie. If the function could not locate the movie's user data, it sets this return value to NIL.
Discussion

This function returns a reference to the movie's user data list, which is valid until you dispose of the movie. When you save the movie, the Movie Toolbox saves the user data as well.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
UserData GetMovieUserData (
   Movie    theMovie );


/*GetMovieDuration

Returns the duration of a movie.

TimeValue GetMovieDuration (
   Movie    theMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

The duration of the designated movie.
Discussion

This function returns a time value, expressed in the movie's time scale, that is calculated to be the maximum durations of all the tracks in the movie. The following code sample illustrates its use:// GetMovieDuration coding example
// See "Discovering QuickTime," page 363
Movie           movie1;
TimeValue       lOldDuration;
Movie           movie2;
long            lIndex, lOrigTrackCount, lReferenceIndex;
Track           track, trackSprite;
// get the first track in original movie and position at the start
trackSprite =GetMovieIndTrack(movie1, 1);
SetMovieSelection(movie1, 0, 0);
// remove all tracks except video in modifier movie
for (lIndex =1; lIndex <=GetMovieTrackCount(movie2); lIndex++) {
    Track       track =GetMovieIndTrack(movie2, lIndex);
    OSType      dwType;
    GetMediaHandlerDescription(GetTrackMedia(track),
                                &dwType, NIL, NIL);
    if (dwType !=VideoMediaType) {
        DisposeMovieTrack(track);
        lIndex--;
    }
}
// add the modifier track to original movie
lOldDuration =GetMovieDuration(movie1);
AddMovieSelection(movie1, movie2);
DisposeMovie(movie2);
// truncate the movie to the length of the original track
DeleteMovieSegment(movie1, lOldDuration,
                    GetMovieDuration(movie1) - lOldDuration);
// associate the modifier track with the original sprite track
track =GetMovieIndTrack(movie1, lOrigTrackCount + 1);
AddTrackReference(trackSprite, track, kTrackModifierReference,
                    &lReferenceIndex);

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

TimeValue GetMovieDuration (
   Movie    theMovie );

/*NewMovie

Creates a new movie in memory.

Movie NewMovie (
   long    flags );
Parameters
flags

Flags (see below) that specify control information for the new movie. Be sure to set unused flags to 0.
Return Value

The identifier for the new movie. If NewMovie fails, the returned identifier is set to NIL. You can use GetMoviesError to obtain the error result, or noErr if there was no error. See Error Codes.
Discussion

You can use NewMovie to create a new empty movie, which contains no tracks. The Movie Toolbox initializes the data structures for the new movie. Your application assigns the data to the movie by calling the functions that are described in NewMovieTrack.

The Movie Toolbox sets many movie characteristics to default values. If you want to change these defaults, your application must call other Movie Toolbox functions. For example, the Movie Toolbox sets the movie's graphics world to the one that is active when you call NewMovie. To change the graphics world for the new movie, your application should use SetMovieGWorld. The default QuickTime movie time scale is 600 units per second; however, this number may change in the future. The default time scale was chosen because it is convenient for working with common video frame rates of 30, 25, 24, 15, 12, 10, and 8.
Special Considerations

The Movie Toolbox automatically sets the movie's graphics world based on the current graphics port. Be sure that your application's graphics port is valid before you call this function, even if the movie is sound-only; you can use GetGWorld to check for a valid port, or you can use NewGWorld to create a port. The graphics port must remain valid for the life of the movie or until you set another valid graphics port for the movie using SetMovieGWorld.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

Movie NewMovie (
   long    flags );

/*GetUserDataText

Retrieves language-tagged text from an item in a user data list.

OSErr GetUserDataText (
   UserData    theUserData,
   Handle      data,
   OSType      udType,
   long        index,
   short       itlRegionTag );
Parameters
theUserData

The user data list for this operation. You obtain this list reference by calling the GetMovieUserData, GetTrackUserData, or GetMediaUserData function.
data

A handle that is to receive the data. The GetUserDataText function resizes this handle as appropriate. Your application must dispose of the handle when you are done with it.
udType

The item's type value; see User Data Identifiers.
index

The item's index value. This parameter must specify an item in the user data list identified by the parameter theUserData.
itlRegionTag

The language code of the text to be retrieved. See Localization Codes.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You specify the user data list and item, and the item's type value and language code. The Movie Toolbox retrieves the specified text from the user data item.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr GetUserDataText (
   UserData    theUserData,
   Handle      data,
   OSType      udType,
   long        index,
   short       itlRegionTag );

/*QTFindChildByID

Retrieves an atom by ID from the child list of the specified parent atom.

QTAtom QTFindChildByID (
   QTAtomContainer    container,
   QTAtom             parentAtom,
   QTAtomType         atomType,
   QTAtomID           id,
   short              *index );
Parameters
container

The atom container that contains the parent atom.
parentAtom

The parent atom for this operation.
atomType

The type of the atom to be retrieved.
id

The ID of the atom to be retrieved.
index

A pointer to an uninitialized short integer. On return, if the atom specified by the id parameter was found, the integer contains the atom's index. If you don't want this function to return the atom's index, set the value of the index parameter to NIL.
Return Value

The found atom.
Discussion

You call this function to search for and retrieve an atom by its type and ID from a parent atom's child list. The following code shows how you can use this function to insert a copy of container B's atoms as children of the 'abcd' atom in container A:// QTFindChildByID coding example
QTAtom targetAtom;
targetAtom =QTFindChildByID (containerA, kParentAtomIsContainer, 'abcd',
    1000, NIL);
FailOSErr (QTInsertChildren (containerA, targetAtom, containerB));

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

QTAtom QTFindChildByID (
   QTAtomContainer    container,
   QTAtom             parentAtom,
   QTAtomType         atomType,
   QTAtomID           id,
   short              *index );


/*QTSetAtomData

Changes the data of a leaf atom.

OSErr QTSetAtomData (
   QTAtomContainer    container,
   QTAtom             atom,
   long               dataSize,
   void               *atomData );
Parameters
container

The atom container that contains the atom to be modified.
atom

The atom to be modified.
dataSize

The length, in bytes, of the data pointed to by the atomData parameter.
atomData

A pointer to the new data for the atom.
Return Value

Only leaf atoms contain data; this function returns an error if you pass it to a nonleaf atom. You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You call this function to replace a leaf atom's data with new data. The atom container specified by the container parameter should not be locked. The following code illustrates using this function to update an atom container that describes a sprite:// QTSetAtomData coding example
OSErr SetSpriteData (QTAtomContainer sprite, Point *location,
    short *visible, short *layer, short *imageIndex)
{
    OSErr err =noErr;
    QTAtom propertyAtom;
 
    // if the sprite's visible property has a new value
    if (visible)
    {
        // retrieve the atom for the visible property
        // -- if none exists, insert one
        if ((propertyAtom =QTFindChildByIndex (sprite,
            kParentAtomIsContainer, kSpritePropertyVisible, 1,
            NIL)) ==0)
            FailOSErr (QTInsertChild (sprite, kParentAtomIsContainer,
                kSpritePropertyVisible, 1, 1, sizeof(short), visible,
                NIL))
 
        // if an atom does exist, update its data
        else
            FailOSErr (QTSetAtomData (sprite, propertyAtom,
                sizeof(short), visible));
    }

Special Considerations

This function may move memory; if the pointer specified by the atomData parameter is a dereferenced handle, you should lock the handle.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTSetAtomData (
   QTAtomContainer    container,
   QTAtom             atom,
   long               dataSize,
   void               *atomData );

/*GetMediaHandler

Obtains a reference to a media handler component.

MediaHandler GetMediaHandler (
   Media    theMedia );
Parameters
theMedia

The media for this operation. Your application obtains this media identifier from such functions as NewTrackMedia and GetTrackMedia. See Media Identifiers.
Return Value

A media handler component instance.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

MediaHandler GetMediaHandler (
   Media    theMedia );

/*TextMediaAddTextSample

Adds a single block of styled text to an existing media.

ComponentResult TextMediaAddTextSample (
   MediaHandler     mh,
   Ptr              text,
   unsigned long    size,
   short            fontNumber,
   short            fontSize,
   Style            textFace,
   RGBColor         *textColor,
   RGBColor         *backColor,
   short            textJustification,
   Rect             *textBox,
   long             displayFlags,
   TimeValue        scrollDelay,
   short            hiliteStart,
   short            hiliteEnd,
   RGBColor         *rgbHiliteColor,
   TimeValue        duration,
   TimeValue        *sampleTime );
Parameters
mh

The media handler for the text media obtained by GetMediaHandler.
text

A pointer to a block of text.
size

Indicates the size of the text block, in bytes.
fontNumber

The number for the font in which to display the text.
fontSize

Indicates the size of the font.
textFace

Indicates the typeface or style of the text (that is, bold, italic, and so on).
textColor

A pointer to an RGBColor structure specifying the color of the text. Passing NIL for this parameter in defaults to black.
backColor

A pointer to an RGBColor structure specifying the text background color. Passing NIL for this parameter in defaults to white.
textJustification

Indicates the justification of the text (see below). See these constants: 
textBox

A pointer to a Rect structure that defines the box within which the text is to be displayed. The box is relative to the track bounds.
displayFlags

Contains the text display flags (see below). See these constants: 
dfDontDisplay
dfDontAutoScale
dfClipToTextBox
dfShrinkTextBoxToFit
dfScrollIn
dfScrollOut
dfHorizScroll
dfReverseScroll
dfContinuousScroll
dfFlowHoriz
dfContinuousKaraoke
dfDropShadow
dfAntiAlias
dfKeyedText
dfInverseHilite
dfTextColorHilite
scrollDelay

Indicates the delay in scrolling associated with the setting of the dfScrollIn and dfScrollOut display flags. If the value of the scrollDelay parameter is greater than 0 and the dfScrollIn flag is set, the text pauses when it has scrolled all the way in for the amount of time specified by scrollDelay. If the dfScrollOut flag is set, the pause occurs first before the text scrolls out. If both these flags are set, the pause occurs at the midpoint between scrolling in and scrolling out.
hiliteStart

The beginning of the text to be highlighted.
hiliteEnd

The end of the text to be highlighted. If the hiliteEnd parameter is greater than the hiliteStart parameter, then the text is highlighted from the selection specified by hiliteStart to hiliteEnd. To specify additional highlighting, you can use TextMediaAddHiliteSample.
rgbHiliteColor

Contains a pointer to an RGBColor structure that defines the color for highlighting. If this parameter is not NIL, then the specified color is used when highlighting the text indicated by the hiliteStart and hiliteEnd parameters. Otherwise, the default system highlight color is used.
duration

A time value that specifies how long the text sample should last. This duration is expressed in the media's time base.
sampleTime

Contains a pointer to a time value. The actual media time at which the sample was added is returned here.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Special Considerations

Be sure to turn on the dfDropShadow display flag after you call this function.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
ComponentResult TextMediaAddTextSample (
   MediaHandler     mh,
   Ptr              text,
   unsigned long    size,
   short            fontNumber,
   short            fontSize,
   Style            textFace,
   RGBColor         *textColor,
   RGBColor         *backColor,
   short            textJustification,
   Rect             *textBox,
   long             displayFlags,
   TimeValue        scrollDelay,
   short            hiliteStart,
   short            hiliteEnd,
   RGBColor         *rgbHiliteColor,
   TimeValue        duration,
   TimeValue        *sampleTime );

/*MCSetVisible

Lets your application control the visibility of a movie controller.

ComponentResult MCSetVisible (
   MovieController    mc,
   Boolean            visible );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
visible

Set to TRUE to cause the controller to be visible, or FALSE to make the controller invisible.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/

ComponentResult MCSetVisible (
   MovieController    mc,
   Boolean            visible );


/*MCIsControllerAttached

Returns a value that indicates whether a movie controller is attached to its movie.

ComponentResult MCIsControllerAttached (
   MovieController    mc );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
Return Value

If the controller is attached, the returned value is set to 1. If the controller is not attached, the returned value is set to 0. You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/

ComponentResult MCIsControllerAttached (
   MovieController    mc );

/*GetTimeBaseTime

Obtains the current time value from a time base.

TimeValue GetTimeBaseTime (
   TimeBase      tb,
   TimeScale     s,
   TimeRecord    *tr );
Parameters
tb

The time base for this operation. Your application obtains this time base identifier from the NewTimeBase function.
s

The time scale in which to return the current time value. Set this parameter to 0 to retrieve the time in the preferred time scale of the time base.
tr

A pointer to a time structure that is to receive the current time value. This is an optional parameter. If you don't want the time value represented in a time structure, set this parameter to NIL.
Return Value

The time base's current time.
Discussion

This function returns a time value that contains the current time from the specified time base in the specified time scale. The function returns this value even if you specify a time structure with the tr parameter.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

TimeValue GetTimeBaseTime (
   TimeBase      tb,
   TimeScale     s,
   TimeRecord    *tr );


/*SetTimeBaseMasterClock

Assigns a clock component to a time base.

void SetTimeBaseMasterClock (
   TimeBase            slave,
   Component           clockMeister,
   const TimeRecord    *slaveZero );
Parameters
slave

The time base for this operation. Your application obtains this time base identifier from NewTimeBase.
clockMeister

The clock component to be assigned to this time base. Your application can obtain this component identifier from FindNextComponent.
slaveZero

A pointer to the time, in the clock's time scale, that corresponds to a 0 time value for the slave time base. This parameter allows you to set an offset between the time base and the clock component. Set this parameter to NIL if there is no offset.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

A time base derives its time from either a clock component or from another time base. Don't use this function to assign a clock to a movie's time base.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void SetTimeBaseMasterClock (
   TimeBase            slave,
   Component           clockMeister,
   const TimeRecord    *slaveZero );


/*GetTimeBaseMasterClock

Determines the clock component that is assigned to a time base.

ComponentInstance GetTimeBaseMasterClock (
   TimeBase    tb );
Parameters
tb

The time base for this operation. Your application obtains this time base identifier from the NewTimeBase function.
Return Value

A reference to a component instance. If a clock component is not assigned to the time base, the returned reference is NIL. In this case, the time base relies on another time base for its time source. Use GetTimeBaseMasterTimeBase to obtain the time base reference to that master time base.
Discussion

This function returns a reference to a component instance of the clock component that provides a time source to the specified time base. Every time base derives its time from either a clock component or from another time base. If a time base derives its time from a clock component, use this function to obtain the component instance of the clock component.
Special Considerations

The Component Manager allows a single component to serve multiple client applications at the same time. Each client application has a unique connection to the component, identified by a component instance. Don't close this connection; the time base is using it to maintain its time source.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
ComponentInstance GetTimeBaseMasterClock (
   TimeBase    tb );

/*OpenMovieFile

Opens a specified movie file.

OSErr OpenMovieFile (
   const FSSpec    *fileSpec,
   short           *resRefNum,
   SInt8           permission );
Parameters
fileSpec

A pointer to the FSSpec structure for the movie file to be opened.
resRefNum

A pointer to a field that is to receive the file reference number for the opened movie file. Your application must use this value when calling other Movie Toolbox functions that work with movie files. This reference number refers to the file fork that contains the movie resource. If the movie is stored in the data fork of the file, the returned reference number corresponds to the data fork.
permission

The permission level for the file (see below). If your application is only going to play the movie that is stored in the file, you can open the file with read permission. If you plan to add data to the file or change data in the file, you should open the file with write permission. See these constants: 
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

Your application must open a movie file before reading movie data from it or writing movie data to it. You can open a movie file more than once; be sure to call CloseMovieFile once for each time you call this function. Note that opening the movie file with write permission does not prevent other applications from reading data from the movie file.

If the specified file has a resource fork, this function opens the resource fork and returns a file reference number to the resource fork. If the movie file does not have a resource fork (that is, it is a single-fork movie file), this function opens the data fork instead. In this case, your application cannot use AddMovieResource with the movie file.

The following is an example of using OpenMovieFile:// OpenMovieFile coding example
// See "Discovering QuickTime," page 385
Movie MyGetMovie (void)
{
    OSErr                   nErr;
    SFTypeList              types ={MovieFileType, 0, 0, 0};
    StandardFileReply       sfr;
    Movie                   movie =NIL;
    short                   nFileRefNum;
    StandardGetFilePreview(NIL, 1, types, &sfr);
    if (sfr.sfGood) {
        nErr =OpenMovieFile(&sfr.sfFile, &nFileRefNum, fsRdPerm);
        if (nErr ==noErr) {
            short           nResID =0;         //We want the first movie.
            Str255          strName;
            Boolean         bWasChanged;
 
            nErr =NewMovieFromFile(&movie, nFileRefNum, &nResID, strName,
                                    newMovieActive, &bWasChanged);
            CloseMovieFile(nFileRefNum);
        }
    }
    return movie;
}

Version Notes

Introduced in QuickTime 3 or earlier. Superseded in QuickTime 6 by OpenMovieStorage.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr OpenMovieFile (
   const FSSpec    *fileSpec,
   short           *resRefNum,
   SInt8           permission );

/*NewMovieFromFile

Creates a new movie in memory from a movie file or from any type of file for which QuickTime provides an import component (AIFF, JPEG, MPEG-4, etc).

OSErr NewMovieFromFile (
   Movie        *theMovie,
   short        resRefNum,
   short        *resId,
   StringPtr    resName,
   short        newMovieFlags,
   Boolean      *dataRefWasChanged );
Parameters
theMovie

A pointer to a field that is to receive the new movie's identifier. If the function cannot load the movie, the returned identifier is set to NIL.
resRefNum

The movie file from which the movie is to be loaded. Your application obtains this value from the OpenMovieFile function.
resId

A pointer to a field that specifies the resource containing the movie data that is to be loaded. If the field referred to by the resId parameter is set to 0, the Movie Toolbox loads the first movie resource it finds in the specified file. The Movie Toolbox then returns the movie's resource ID number in the field referred to by the resId parameter. An enumerated constant (see below) is available. See these constants: 
movieInDataForkResID
resName

A pointer to a character string that is to receive the name of the movie resource that is loaded. If you set the resName parameter to NIL, the Movie Toolbox does not return the resource name.
newMovieFlags

Flags (see below) that control the operation of NewMovieFromFile. Be sure to set unused flags to 0. See these constants: 
newMovieActive
newMovieDontResolveDataRefs
newMovieDontAskUnresolvedDataRefs
dataRefWasChanged

A pointer to a Boolean value. The Movie Toolbox sets the value to TRUE if any references were changed. Use UpdateMovieResource to preserve these changes. Set this parameter to NIL if you don't want to receive this information. See NewMovieTrack for more information about data references.
Return Value

If the Movie Toolbox cannot completely resolve all data references, it sets the current error value to couldNotResolveDataRef. You can access error returns such as this through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

The Movie Toolbox sets many movie characteristics to default values. If you want to change these defaults, your application must call other Movie Toolbox functions. For example, the Movie Toolbox sets the movie's graphics world to the one that is active when you call NewMovieFromFile. To change the graphics world for the new movie, your application should use SetMovieGWorld.

The following is an example of using this function:// NewMovieFromFile coding example
// See "Discovering QuickTime," page 385
Movie MyGetMovie (void)
{
    OSErr                   nErr;
    SFTypeList              types ={MovieFileType, 0, 0, 0};
    StandardFileReply       sfr;
    Movie                   movie =NIL;
    short                   nFileRefNum;
    StandardGetFilePreview(NIL, 1, types, &sfr);
    if (sfr.sfGood) {
        nErr =OpenMovieFile(&sfr.sfFile, &nFileRefNum, fsRdPerm);
        if (nErr ==noErr) {
            short           nResID =0;         //We want the first movie.
            Str255          strName;
            Boolean         bWasChanged;
 
            nErr =NewMovieFromFile(&movie, nFileRefNum, &nResID, strName,
                                    newMovieActive, &bWasChanged);
            CloseMovieFile(nFileRefNum);
        }
    }
    return movie;
}

Special Considerations

The Movie Toolbox automatically sets the movie's graphics world based on the current graphics port. Be sure that your application's graphics port is valid before you call this function, even if the movie is sound-only; you can use GetGWorld to check for a valid port, or you can use NewGWorld to create a port. The graphics port must remain valid for the life of the movie or until you set another valid graphics port for the movie using SetMovieGWorld.
Special Considerations

This function works with some files that don't contain movie resources. When it encounters a file that does not contain a movie resource, it tries to find a movie import component that can understand the data and create a movie. It also works for MPEG, uLaw (.AU), and Wave (.WAV) file types. In some cases, the data in a file is already sufficiently well formatted for QuickTime or its components to understand. For example, the AIFF movie data import component can understand AIFF sound files and import the sound data into a QuickTime movie.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr NewMovieFromFile (
   Movie        *theMovie,
   short        resRefNum,
   short        *resId,
   StringPtr    resName,
   short        newMovieFlags,
   Boolean      *dataRefWasChanged );

/*CloseMovieFile

Closes an open movie file.

OSErr CloseMovieFile (
   short    resRefNum );
Parameters
resRefNum

The movie file to close. Your application obtains this reference number from OpenMovieFile.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

The following code shows a typical use of CloseMovieFile.// CloseMovieFile coding example
// See "Discovering QuickTime," page 50
void OpenMovie (HWND hwnd, char *szFileName)
{
    short   nFileRefNum =0;
    FSSpec  fss;
    // Convert path to FSSpec
    NativePathNameToFSSpec(szFileName, &fss, 0);
    // Set graphics port
    SetGWorld((CGrafPtr)GetNativeWindowPort(hwnd), NIL);
    OpenMovieFile(&fss, &nFileRefNum, fsRdPerm);   // Open movie file
    NewMovieFromFile(&movie, nFileRefNum, NIL,    // Get movie from file
                        NIL, newMovieActive, NIL);
    CloseMovieFile(nFileRefNum);                   // Close movie file
}

Version Notes

Introduced in QuickTime 3 or earlier. Superseded in QuickTime 6 by CloseMovieStorage.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSErr CloseMovieFile (
   short    resRefNum );

/*CreateMovieFile

Creates a movie file, creates an empty movie which references the file, and opens the movie file with write permission.

OSErr CreateMovieFile (
   const FSSpec    *fileSpec,
   OSType          creator,
   ScriptCode      scriptTag,
   long            createMovieFileFlags,
   short           *resRefNum,
   Movie           *newmovie );
Parameters
fileSpec

A pointer to the file system specification for the movie file to be created.
creator

The creator value for the new file.
scriptTag

The script in which the movie file should be created. Use the Script Manager constant smSystemScript to use the system script; use the smCurrentScript constant to use the current script. See Inside Macintosh: Text for more information about scripts and script tags.
createMovieFileFlags

Controls movie file creation flags (see below). See these constants: 
createMovieFileDontCreateResFile
createMovieFileDeleteCurFile
createMovieFileDontCreateMovie
createMovieFileDontOpenFile
newMovieActive
resRefNum

A pointer to a field that is to receive the file reference number for the opened movie file. Your application must use this value when calling other Movie Toolbox functions that work with movie files. If you set this parameter to NIL, the Movie Toolbox creates the movie file but does not open the file.
newmovie

A pointer to a field that is to receive the identifier of the new movie. CreateMovieFile returns the identifier of the new movie. If the function could not create a new movie, it sets this returned value to NIL. If you set this parameter to NIL, the Movie Toolbox does not create a movie.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

The following code snippet shows how CreateMovieFile may be used to create and open a QuickTime movie file.// CreateMovieFile coding example
// See "Discovering QuickTime," page 243
void CreateMyCoolMovie (void)
{
    StandardFileReply   sfr;
    Movie               movie =NIL;
    FSSpec              fss;
    short               nFileRefNum =0;
    short               nResID =movieInDataForkResID;
    StandardPutFile("\pEnter movie file name:", "\puntitled.mov", &sfr);
    if (!sfr.sfGood)
        return;
    CreateMovieFile(&sfr.sfFile,
                    FOUR_CHAR_CODE('TVOD'),
                    smCurrentScript,
                    createMovieFileDeleteCurFile |
                     createMovieFileDontCreateResFile,
                    &nFileRefNum,
                    &movie);
    CreateMyVideoTrack(movie);   // See "Discovering QuickTime," page 244
    CreateMySoundTrack(movie);   // See "Discovering QuickTime," page 250
    AddMovieResource(movie, nFileRefNum, &nResID, NIL);
    if (nFileRefNum !=0)
        CloseMovieFile(nFileRefNum);
    DisposeMovie(movie);
}

Version Notes

Introduced in QuickTime 3 or earlier. Superseded in QuickTime 6 by CreateMovieStorage.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr CreateMovieFile (
   const FSSpec    *fileSpec,
   OSType          creator,
   ScriptCode      scriptTag,
   long            createMovieFileFlags,
   short           *resRefNum,
   Movie           *newmovie );

/*AddMovieResource

Adds a movie resource to a specified resource file.

OSErr AddMovieResource (
   Movie               theMovie,
   short               resRefNum,
   short               *resId,
   ConstStr255Param    resName );
Parameters
theMovie

The movie you wish to add to the movie file. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
resRefNum

Identifies the movie file to which the resource is to be added. Your application obtains this value from the OpenMovieFile function.
resId

A pointer to a field that contains the resource ID number for the new resource. If the field referred to by resId is set to 0, the Movie Toolbox assigns a unique resource ID number to the new resource. The toolbox then returns the movie's resource ID number in the field referred to by the resId parameter. AddMovieResource assigns resource ID numbers sequentially, starting at 128. If resId is set to NIL, the Movie Toolbox assigns a unique resource ID number to the new resource and does not return that resource's ID value. Set resId to movieInDataForkResID to add the new resource to the movie file's data fork (see below). See these constants: 
movieInDataForkResID
resName

Points to a character string that contains the name of the movie resource. If you set resName to NIL, the toolbox creates an unnamed resource.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

This function adds the movie to the file, effectively saving any changes you have made to the movie. To use this function with single-fork movie files, pass movieInDataForkResID as the resId parameter. After updating the movie file, AddMovieResource clears the movie changed flag, indicating that the movie has not been changed.// AddMovieResource coding example
// See "Discovering QuickTime," page 243
void CreateMyCoolMovie (void)
{
    StandardFileReply   sfr;
    Movie               movie =NIL;
    FSSpec              fss;
    short               nFileRefNum =0;
    short               nResID =movieInDataForkResID;
    StandardPutFile("\pEnter movie file name:", "\puntitled.mov", &sfr);
    if (!sfr.sfGood)
        return;
    CreateMovieFile(&sfr.sfFile,
                    FOUR_CHAR_CODE('TVOD'),
                    smCurrentScript,
                    createMovieFileDeleteCurFile |
                     createMovieFileDontCreateResFile,
                    &nFileRefNum,
                    &movie);
    CreateMyVideoTrack(movie);      // See next section
    CreateMySoundTrack(movie);      // See next section
    AddMovieResource(movie, nFileRefNum, &nResID, NIL);
    if (nFileRefNum !=0)
        CloseMovieFile(nFileRefNum);
    DisposeMovie(movie);
}

Version Notes

Introduced in QuickTime 3 or earlier. Superseded in QuickTime 6 by AddMovieToStorage.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSErr AddMovieResource (
   Movie               theMovie,
   short               resRefNum,
   short               *resId,
   ConstStr255Param    resName );

/*SetMovieBox

Sets a movie's boundary rectangle.

void SetMovieBox (
   Movie         theMovie,
   const Rect    *boxRect );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
boxRect

A pointer to a rectangle that contains the coordinates of the new boundary rectangle.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

The Movie Toolbox changes the rectangle by modifying the translation and scale values of the movie's matrix to accommodate the new boundary rectangle.

The movie box might not have its upper-left corner set at (0,0) in its display window when the movie is first loaded. Consequently, your application may need to adjust the position of the movie box so that it appears in the appropriate location within your application's document window. If you don't reset the movie position, the movie might not be visible when it starts playing. The following sample code demonstrates how to do this://Zeroing the boundary rectangle with SetMovieBox
GetMovieBox (movie, &movieBox);
OffsetRect (&movieBox, -movieBox.left, -movieBox.top);
SetMovieBox (movie, &movieBox);

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

void SetMovieBox (
   Movie         theMovie,
   const Rect    *boxRect );

/*ClearMoviesStickyError

Clears the sticky error value.

void ClearMoviesStickyError ( void );
Discussion

The Movie Toolbox provides two error values to your application: the current error and the sticky error. The current error is the result code from the last Movie Toolbox function; it is updated each time your application calls a Movie Toolbox function. The Movie Toolbox saves the same result code in the sticky error value. Your application clears the sticky error value by calling ClearMoviesStickyError. The Movie Toolbox then places the first nonzero result code from any toolbox function used by your application into the sticky error value. The Movie Toolbox does not update the sticky error value until your application clears it again.
Special Considerations

Many Movie Toolbox functions don't return an error as a function result; you must use GetMoviesError to obtain the result code. Even if a function explicitly returns an error as a function result, that result is also available using GetMoviesError. The Movie Toolbox does not place a result code into the sticky error value until the field has been cleared. Your application is responsible for clearing the sticky error value to ensure that it does not contain a stale result code.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void ClearMoviesStickyError ( void );

/*GetTrackVolume

Returns a track's current volume setting.

short GetTrackVolume (
   Track    theTrack );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
Return Value

The specified track's current volume setting. The values returned in the high and low words range from 0x0000 (silence) to 0x0100 (full volume). You can use constants (see below) to test for full volume and no volume.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

short GetTrackVolume (
   Track    theTrack );


/*GetMediaDataRef

Returns a copy of a specified data reference.

OSErr GetMediaDataRef (
   Media     theMedia,
   short     index,
   Handle    *dataRef,
   OSType    *dataRefType,
   long      *dataRefAttributes );
Parameters
theMedia

The media for this operation. Your application obtains this media identifier from such functions as NewTrackMedia and GetTrackMedia. See Media Identifiers.
index

The index value that corresponds to the data reference. It must be less than or equal to the value that is returned by GetMediaDataRefCount.
dataRef

A pointer to a field that is to receive a handle to the data reference. The media handler returns a handle to information that identifies the file that contains this media's data. The type of information stored in that handle depends upon the value of the dataRefType parameter. If the function cannot locate the specified data reference, the handler sets this returned value to NIL. Set the dataRef parameter to NIL if you are not interested in this information.
dataRefType

A pointer to a field that is to receive the type of data reference. If the data reference is an alias, the media handler sets this value to 'alis'. Set the dataRefType parameter to NIL if you are not interested in this information.
dataRefAttributes

A pointer to a field that is to receive the reference's attribute flags (see below). Unused flags are set to 0. See these constants: 
dataRefSelfReference
dataRefWasNotResolved
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

Use this function to retrieve information about a data reference. For example, you might want to verify the condition of a movie's data references after loading the movie from its movie file. You could use this function to check each data reference.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr GetMediaDataRef (
   Media     theMedia,
   short     index,
   Handle    *dataRef,
   OSType    *dataRefType,
   long      *dataRefAttributes );

/*InsertTrackSegment

Copies data into a track.

OSErr InsertTrackSegment (
   Track        srcTrack,
   Track        dstTrack,
   TimeValue    srcIn,
   TimeValue    srcDuration,
   TimeValue    dstIn );
Parameters
srcTrack

The source track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
dstTrack

The destination track for this operation. This function places a copy of the segment, which is obtained from the source track, into this destination track. The media for the destination track must be opened for writing by calling BeginMediaEdits in order for the data to be copied. If the media is not opened for writing, the segment will be copied by reference. At the end of the editing session, your application must call EndMediaEdits if it has called BeginMediaEdits.
srcIn

The start of the segment in the source track. This time value must be expressed in the time scale of the movie that contains the source track.
srcDuration

The duration of the segment in the source track. This time value must be expressed in the time scale of the movie that contains the source track.
dstIn

A time value specifying where the segment is to be inserted. This time value must be expressed in the time scale of the movie that contains the destination track.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

If you are copying data between tracks, make sure that the two tracks are of the same type. For example, you cannot copy a segment from a sound track into a video track. If you have assigned a progress function to the movie that contains the destination track, the Movie Toolbox calls that progress function during long copy operations.
Special Considerations

If you copy a segment without calling BeginMediaEdits on the destination track's media, the data can be copied later by flattening the movie.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSErr InsertTrackSegment (
   Track        srcTrack,
   Track        dstTrack,
   TimeValue    srcIn,
   TimeValue    srcDuration,
   TimeValue    dstIn );


/*CopyTrackSettings

Copies many settings from one track to another, overwriting the destination settings.

OSErr CopyTrackSettings (
   Track    srcTrack,
   Track    dstTrack );
Parameters
srcTrack

The source track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
dstTrack

The destination track for this operation. The CopyTrackSettings function uses the settings from the source track, which you specify with the srcTrack parameter, to replace the current settings of this track.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

This function copies matrix information, track volume, the clipping region, user data, matte information, media language, quality, user data, and other media-specific settings (such as sound balance and video graphics mode). It does not copy any alternate group information pertaining to the track. This function does not copy the track's contents. To work with track contents, you should use segment-editing functions.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr CopyTrackSettings (
   Track    srcTrack,
   Track    dstTrack );

/*GetMoviesStickyError

Returns the contents of the sticky error value.

OSErr GetMoviesStickyError ( void );
Return Value

See Error Codes. Returns noErr if there is no error in the sticky error value.
Discussion

The sticky error value contains the first nonzero result code from any Movie Toolbox function that you called after having cleared the sticky error with ClearMoviesStickyError.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr GetMoviesStickyError ( void );

/*UpdateMovieResource

Replaces the contents of a movie resource in a specified movie file.

OSErr UpdateMovieResource (
   Movie               theMovie,
   short               resRefNum,
   short               resId,
   ConstStr255Param    resName );
Parameters
theMovie

The movie you wish to place in the movie file. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
resRefNum

Identifies the movie file that contains the resource to be changed. Your application obtains this value from OpenMovieFile.
resId

The resource to be changed. This value is obtained from a previous call to NewMovieFromFile, NewMovieFromDataRef, or AddMovieResource. If you specify a single-fork movie file by passing the movieInDataForkResID constant, the Movie Toolbox places the movie resource into the file's data fork.
resName

Points to a new name for the resource. If you don't want to change the resource's name, set this parameter to NIL.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You specify the movie that is to be placed into the resource. This function can accommodate single-fork movie files. After updating the movie file, this function clears the movie changed flag.
Version Notes

Introduced in QuickTime 3 or earlier. Superseded in QuickTime 6 by UpdateMovieInStorage.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr UpdateMovieResource (
   Movie               theMovie,
   short               resRefNum,
   short               resId,
   ConstStr255Param    resName );

/*SetTrackLayer

Sets a track's layer.

void SetTrackLayer (
   Track    theTrack,
   short    layer );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
layer

The track's layer number. Layers are numbered from -32,768 through 32,767. When you create a new track, the Movie Toolbox sets its track number to 0.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void SetTrackLayer (
   Track    theTrack,
   short    layer );

/*GetTrackLayer

Retrieves a track's layer.

short GetTrackLayer (
   Track    theTrack );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
Return Value

The specified track's layer number.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

short GetTrackLayer (
   Track    theTrack );


/*GetTrackOffset

Determines the time difference between the start of a track and the start of the movie that contains the track.

TimeValue GetTrackOffset (
   Track    theTrack );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
Return Value

The time difference between the start of the specified track and the start of the movie that contains the track.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
TimeValue GetTrackOffset (
   Track    theTrack );

/*SetMovieTimeValue

Sets a movie's time value.

void SetMovieTimeValue (
   Movie        theMovie,
   TimeValue    newtime );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
newtime

The new time value. You must ensure that the time value is in the movie's time scale.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

void SetMovieTimeValue (
   Movie        theMovie,
   TimeValue    newtime );

/*GetTrackSegmentDisplayBoundsRgn

Determines the region a track occupies in a movie's graphics world during a specified segment.

RgnHandle GetTrackSegmentDisplayBoundsRgn (
   Track        theTrack,
   TimeValue    time,
   TimeValue    duration );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
time

The starting time of the track segment to consider. This time value must be expressed in the movie's time coordinate system. The duration parameter specifies the length of the segment.
duration

The length of the segment to consider. Set this parameter to 0 to consider an instant in time.
Return Value

A handle to the region the specified track occupies in its movie's graphics world during a specified segment. If the track does not have a spatial representation during the specified segment, the function returns an empty region. If the function could not satisfy your request, it sets the returned handle to NIL.
Discussion

This function allocates the region and returns a handle to it. This region is valid for the specified segment.
Special Considerations

Your application must dispose of the returned region when you are done with it.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

RgnHandle GetTrackSegmentDisplayBoundsRgn (
   Track        theTrack,
   TimeValue    time,
   TimeValue    duration );


/*GetMovieGWorld

Returns a movie's graphics world.

void GetMovieGWorld (
   Movie       theMovie,
   CGrafPtr    *port,
   GDHandle    *gdh );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
port

A pointer to a field that is to receive a pointer to a CGrafPort structure. Set this parameter to NIL if you don't want this information.
gdh

A pointer to a field that is to receive a handle to a GDevice structure. Set this parameter to NIL if you don't want this information.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

void GetMovieGWorld (
   Movie       theMovie,
   CGrafPtr    *port,
   GDHandle    *gdh );


/*GetMovieMatrix

Retrieves a movie's transformation matrix.

void GetMovieMatrix (
   Movie           theMovie,
   MatrixRecord    *matrix );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
matrix

A pointer to a MatrixRecord structure, where GetMovieMatrix returns the movie's matrix.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void GetMovieMatrix (
   Movie           theMovie,
   MatrixRecord    *matrix );

/*GetTrackMatrix

Retrieves a track's transformation matrix.

void GetTrackMatrix (
   Track           theTrack,
   MatrixRecord    *matrix );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
matrix

A pointer to a MatrixRecord structure. The GetTrackMatrix function returns the track's matrix into the structure referred to by this parameter.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void GetTrackMatrix (
   Track           theTrack,
   MatrixRecord    *matrix );

/*TrackTimeToMediaTime

Converts a track's time value to a time value that is appropriate to the track's media, using the track's edit list.

TimeValue TrackTimeToMediaTime (
   TimeValue    value,
   Track        theTrack );
Parameters
value

The track's time value; must be expressed in the time scale of the movie that contains the track.
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
Return Value

The track's time value, but in the media's time coordinate system. If the track time corresponds to empty space, this function returns a value of -1.
Discussion

This function maps the track time through the track's edit list to come up with the media time. This time value contains the track's time value according to the media's time coordinate system. If the time you specified lies outside of the movie's active segment or corresponds to empty space in the track, this function returns a value of -1. Hence you can use it to determine whether a specified track edit is empty.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

TimeValue TrackTimeToMediaTime (
   TimeValue    value,
   Track        theTrack );

/*GetMediaSample

Returns a sample from a movie data file.

OSErr GetMediaSample (
   Media                      theMedia,
   Handle                     dataOut,
   long                       maxSizeToGrow,
   long                       *size,
   TimeValue                  time,
   TimeValue                  *sampleTime,
   TimeValue                  *durationPerSample,
   SampleDescriptionHandle    sampleDescriptionH,
   long                       *sampleDescriptionIndex,
   long                       maxNumberOfSamples,
   long                       *numberOfSamples,
   short                      *sampleFlags );
Parameters
theMedia

The media for this operation. Your application obtains this media identifier from such functions as NewTrackMedia and GetTrackMedia. See Media Identifiers.
dataOut

A handle. The GetMediaSample function returns the sample data into this handle. The function increases the size of this handle, if necessary. You can specify the handle's maximum size with the maxSizeToGrow parameter.
maxSizeToGrow

The maximum number of bytes of sample data to be returned. The GetMediaSample function does not increase the handle specified by the dataOut parameter to a size greater than you specify with this parameter. Set this value to 0 to enforce no limit on the number of bytes to be returned.
size

A pointer to a long integer. The GetMediaSample function updates the field referred to by the size parameter with the number of bytes of sample data returned in the handle specified by the dataOut parameter. Set this parameter to NIL if you are not interested in this information.
time

The starting time of the sample to be retrieved. You must specify this value in the media's time scale.
sampleTime

A pointer to a time value. The GetMediaSample function updates this time value to indicate the actual time of the returned sample data. (The returned time may differ from the time you specified with the time parameter. This will occur if the time you specified falls in the middle of a sample.) If you are not interested in this information, set this parameter to NIL.
durationPerSample

A pointer to a time value. The Movie Toolbox returns the duration of each sample in the media. This time value is expressed in the media's time scale. Set this parameter to 0 if you don't want this information.
sampleDescriptionH

A handle to a SampleDescription structure. The GetMediaSample function returns the sample description corresponding to the returned sample data. The function resizes this handle as appropriate. If you don't want a SampleDescription structure, set this parameter to NIL.
sampleDescriptionIndex

A pointer to a long integer. The GetMediaSample function returns an index value to the SampleDescription structure that corresponds to the returned sample data. You can retrieve the structure by calling GetMediaSampleDescription and passing this index in the descH parameter. If you don't want this information, set this parameter to NIL.
maxNumberOfSamples

The maximum number of samples to be returned. The Movie Toolbox does not return more samples than you specify with this parameter. If you set this parameter to 0, the Movie Toolbox uses a value that is appropriate for the media, and returns that value in the field referenced by the numberOfSamples parameter.
numberOfSamples

A pointer to a long integer. The GetMediaSample function updates the field referred to by this parameter with the number of samples it actually returns. If you don't want this information, set this parameter to NIL.
sampleFlags

A pointer to a short integer in which GetMediaSample returns flags (see below) that describe the sample. Unused flags are set to 0. If you don't want this information, set this parameter to NIL. See these constants: 
mediaSampleNotSync
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr GetMediaSample (
   Media                      theMedia,
   Handle                     dataOut,
   long                       maxSizeToGrow,
   long                       *size,
   TimeValue                  time,
   TimeValue                  *sampleTime,
   TimeValue                  *durationPerSample,
   SampleDescriptionHandle    sampleDescriptionH,
   long                       *sampleDescriptionIndex,
   long                       maxNumberOfSamples,
   long                       *numberOfSamples,
   short                      *sampleFlags );

/*SetMediaSampleDescription

Changes the contents of a particular SampleDescription structure of a specified media.

OSErr SetMediaSampleDescription (
   Media                      theMedia,
   long                       index,
   SampleDescriptionHandle    descH );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
index

The index of the SampleDescription structure to be changed. This index corresponds to the SampleDescription structure itself, not the samples in the media. This long integer must be between 1 and the largest SampleDescription index.
descH

The handle to the SampleDescription structure. If there is no description for the specified index, the function returns this handle unchanged.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr SetMediaSampleDescription (
   Media                      theMedia,
   long                       index,
   SampleDescriptionHandle    descH );

/*GetTrackDisplayBoundsRgn

Determines the region a track occupies in a movie's graphics world.

RgnHandle GetTrackDisplayBoundsRgn (
   Track    theTrack );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
Return Value

A handle to the region the specified track occupies in a movie's graphics world.
Discussion

This function allocates the region and returns a handle to the region. If the track does not have a spatial representation at the current movie time, the function returns an empty region. If the function could not satisfy your request, it sets the returned handle to NIL.
Special Considerations

Your application must dispose of the returned region when you are done with it. 
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
RgnHandle GetTrackDisplayBoundsRgn (
   Track    theTrack );

/*AddMediaSample

Adds sample data and a description to a media.

OSErr AddMediaSample (
   Media                      theMedia,
   Handle                     dataIn,
   long                       inOffset,
   unsigned long              size,
   TimeValue                  durationPerSample,
   SampleDescriptionHandle    sampleDescriptionH,
   long                       numberOfSamples,
   short                      sampleFlags,
   TimeValue                  *sampleTime );
Parameters
theMedia

The media for this operation. Your application obtains this media identifier from such functions as NewTrackMedia and GetTrackMedia. See Media Identifiers.
dataIn

A handle to the sample data. The AddMediaSample function adds this data to the media specified by the parameter theMedia. You specify the number of bytes of sample data with the size parameter. You can use the inOffset parameter to specify a byte offset into the data referred to by this handle.
inOffset

Specifies an offset into the data referred to by the handle contained in the dataIn parameter. Set this parameter to 0 if there is no offset.
size

The number of bytes of sample data to be added to the media. This parameter indicates the total number of bytes in the sample data to be added to the media, not the number of bytes per sample. Use the numberOfSamples parameter to indicate the number of samples that are contained in the sample data.
durationPerSample

The duration of each sample to be added. You must specify this parameter in the media's time scale. For example, if you are adding sound that was sampled at 22 kHz to a media that contains a sound track with the same time scale, you would set durationPerSample to 1. Similarly, if you are adding video that was recorded at 10 frames per second to a video media that has a time scale of 600, you would set this parameter to 60 to add a single sample.
sampleDescriptionH

A handle to a SampleDescription structure. Some media structures may require sample descriptions. There are different descriptions for different types of samples. For example, a media that contains compressed video requires that you supply an ImageDescription structure. A media that contains sound requires that you supply a SoundDescription structure. If the media does not require a SampleDescription structure, set this parameter to NIL.
numberOfSamples

The number of samples contained in the sample data to be added to the media. The Movie Toolbox considers the value of this parameter as well as the value of the size parameter when it determines the size of each sample that it adds to the media. You should set the value of this parameter so that the resulting sample size represents a reasonable compromise between total data retrieval time and the overhead associated with input and output (I/O). You should also consider the speed of the data storage device; CD-ROM devices are much slower than hard disks, for example, and should therefore have a smaller sample size. For a video media, set a sample size that corresponds to the size of a frame. For a sound media, choose a number of samples that corresponds to between 0.5 and 1.0 seconds of sound. In general, you should not create groups of sound samples that are less than 2 KB in size or greater than 15 KB. Typically, a sample size of about 8 KB is reasonable for most storage devices.
sampleFlags

Contains flags (see below) that control the add operation. Set unused flags to 0. See these constants: 
mediaSampleNotSync
sampleTime

A pointer to a time value. After adding the sample data to the media, the AddMediaSample function returns the time where the sample was inserted in the time value referred to by this parameter. If you don't want to receive this information, set this parameter to NIL.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

Your application specifies the sample and the media for the operation. AddMediaSample updates the media so that it contains the sample data. One call to this function can add several samples to a media; however, all the samples must be the same size. Samples are always appended to the end of the media. Furthermore, the media duration is extended each time a sample is added.// AddMediaSample coding example
// See "Discovering QuickTime," page 250
#define kSoundSampleDuration    1
#define kSyncSample             0
#define kTrackStart             0
#define kMediaStart             0
#define kFix1                   0x00010000
void CreateMySoundTrack (Movie movie)
{
    Track                       track;
    Media                       media;
    Handle                      hSound =NIL;
    SoundDescriptionHandle      hSoundDesc =NIL;
    long                        lDataOffset;
    long                        lDataSize;
    long                        lNumSamples;
    hSound =GetResource(soundListRsrc, 128);
    if (hSound ==NIL)
        return;
    hSoundDesc =(SoundDescriptionHandle)NewHandle(4);
 
    CreateMySoundDescription(hSound,
                            hSoundDesc,
                            &lDataOffset,
                            &lNumSamples,
                            &lDataSize);
 
    track =NewMovieTrack(movie, 0, 0, kFullVolume);
    media =NewTrackMedia(track, SoundMediaType,
                                FixRound((**hSoundDesc).sampleRate),
                                NIL, 0);
    BeginMediaEdits(media);
    AddMediaSample(media,
                    hSound,
                    lDataOffset,        // offset in data
                    lDataSize,
                    kSoundSampleDuration,   // duration of each sound
                                            //  sample
                    (SampleDescriptionHandle)hSoundDesc,
                    lNumSamples,
                    kSyncSample,        // self-contained samples
                    NIL);
    EndMediaEdits(media);
    InsertMediaIntoTrack(track,
                            kTrackStart,    // track start time
                            kMediaStart,    // media start time
                            GetMediaDuration(media),
                            kFix1);
    if (hSoundDesc !=NIL)
        DisposeHandle((Handle)hSoundDesc);
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSErr AddMediaSample (
   Media                      theMedia,
   Handle                     dataIn,
   long                       inOffset,
   unsigned long              size,
   TimeValue                  durationPerSample,
   SampleDescriptionHandle    sampleDescriptionH,
   long                       numberOfSamples,
   short                      sampleFlags,
   TimeValue                  *sampleTime );


/*DeleteTrackSegment

Removes a specified segment from a track.

OSErr DeleteTrackSegment (
   Track        theTrack,
   TimeValue    startTime,
   TimeValue    duration );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
startTime

A time value specifying the starting point of the segment to be deleted. This time value must be expressed in the time scale of the movie that contains the source track.
duration

A time value that specifies the duration of the segment to be deleted. This time value must be expressed in the time scale of the movie that contains the source track.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You identify the segment to remove by specifying its starting time and duration.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr DeleteTrackSegment (
   Track        theTrack,
   TimeValue    startTime,
   TimeValue    duration );

/*ExtendMediaDecodeDurationToDisplayEndTime

Prepares a media for the addition of a completely new sequence of samples by ensuring that the media display end time is not later than the media decode end time.

OSErr ExtendMediaDecodeDurationToDisplayEndTime (
   Media      theMedia,
   Boolean    *mediaChanged );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
mediaChanged

A pointer to a Boolean that returns TRUE if any samples in the media were adjusted, FALSE otherwise. If you don't want to receive this information, set this parameter to NULL.
Return Value

An error code. Returns memFullErr if it could not allocate memory, paramErr if there was an invalid parameter, or noErr if there is no error. You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result.
Discussion

After adding a complete, well-formed set of samples to a media, the media's display end time should be the same as the media's decode end time (also called the media decode duration). However, this is not necessarily the case after individual sample-adding operations, and hence it is possible for a media to be left with a display end time later than its decode end time (if adding a sequence of frames is aborted halfway, for example).
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSErr ExtendMediaDecodeDurationToDisplayEndTime (
   Media      theMedia,
   Boolean    *mediaChanged );

/*QTGetDataReferenceFullPathCFString

Returns the full pathname of the target of the data reference as a CFString.

OSErr QTGetDataReferenceFullPathCFString (
   Handle         dataRef,
   OSType         dataRefType,
   QTPathStyle    pathStyle,
   CFStringRef    *outPath );
Parameters
dataRef

An alias data reference to which you want a new data reference that points to the directory.
dataRefType

The type the input data reference; must be AliasDataHandlerSubType.
pathStyle

A constant (see below) that identifies the syntax of the pathname. See these constants: 
kQTNativeDefaultPathStyle
kQTPOSIXPathStyle
kQTHFSPathStyle
kQTWindowsPathStyle
outPath

A pointer to a CFStringRef entity where a reference to the newly created CFString will be returned.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error. Returns paramErr if either of the output parameters was NIL or the value of dataRefType is not AliasDataHandlerSubType.
Discussion

This function creates a new CFString that represents the full pathname of the target pointed to by the input data reference, which must be an alias data reference.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/

OSErr QTGetDataReferenceFullPathCFString (
   Handle         dataRef,
   OSType         dataRefType,
   QTPathStyle    pathStyle,
   CFStringRef    *outPath );


/*QTNewDataReferenceFromFSRefCFString

Creates an alias data reference from a file reference pointing to a directory and a file name.

OSErr QTNewDataReferenceFromFSRefCFString (
   const FSRef    *directoryRef,
   CFStringRef    fileName,
   UInt32         flags,
   Handle         *outDataRef,
   OSType         *outDataRefType );
Parameters
directoryRef

A pointer to an opaque file specification that specifies the directory of the newly created alias data reference.
fileName

A reference to a CFString that specifies the name of the file.
flags

Currently not used; pass 0.
outDataRef

A pointer to a handle in which the newly created alias data reference is returned.
outDataRefType

A pointer to memory in which the OSType of the newly created data reference is returned.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error. Returns paramErr if either of the output parameters is NIL
Discussion

This function is useful for creating an alias data reference to a file that does not exist yet. Note that you cannot construct an FSRef for a nonexistent file. You can use File Manager functions to construct an FSRef for the directory. Depending on where your file name comes from, you may already have it in a form of CFString, or you may have to call CFString functions to create a new CFString for the file name. Then you can pass the new alias data reference to other Movie Toolbox functions that take a data reference. If you already have an FSRef for the file you want, you can call QTNewDataReferenceFromFSRef instead.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSErr QTNewDataReferenceFromFSRefCFString (
   const FSRef    *directoryRef,
   CFStringRef    fileName,
   UInt32         flags,
   Handle         *outDataRef,
   OSType         *outDataRefType );


/*MCActivate

Lets a controller respond to activate, deactivate, suspend, and resume events.

ComponentResult MCActivate (
   MovieController    mc,
   WindowRef          w,
   Boolean            activate );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
w

A pointer to the window in which the event has occurred.
activate

The nature of the event. Set this parameter to TRUE for activate and resume events. Set it to FALSE for deactivate and suspend events.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/
ComponentResult MCActivate (
   MovieController    mc,
   WindowRef          w,
   Boolean            activate );




/*MCDraw

Responds to an update event.

ComponentResult MCDraw (
   MovieController    mc,
   WindowRef          w );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
w

A pointer to the window in which the update event has occurred.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/

ComponentResult MCDraw (
   MovieController    mc,
   WindowRef          w );


/*MCGetControllerBoundsRect

Returns a movie controller's boundary rectangle.

ComponentResult MCGetControllerBoundsRect (
   MovieController    mc,
   Rect               *bounds );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
bounds

A pointer to a Rect structure that is to receive the coordinates of the movie controller's boundary rectangle. If there is insufficient screen space to display the controller, the function may return an empty structure.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/

ComponentResult MCGetControllerBoundsRect (
   MovieController    mc,
   Rect               *bounds );

/*StartMovie

Starts the movie playing from the current movie time.

void StartMovie (
   Movie    theMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

You are not required to call this function to start a movie. It is included in the QuickTime API for convenience. Before playing the movie, the Movie Toolbox makes the movie active, prerolls the movie, and sets the movie to its preferred playback rate. You can use SetMoviePreferredRate to change this setting. 
Special Considerations

A movie's current time is saved when a movie is stored in a movie file. Therefore, your application should appropriately position a movie before playing the movie. Use GoToBeginningOfMovie to set a movie to play from its start.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

void StartMovie (
   Movie    theMovie );

/*GetMovieRate

Returns a movie's playback rate.

Fixed GetMovieRate (
   Movie    theMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

The rate at which the movie is currently playing, expressed as a 32-bit fixed-point number. Positive integers indicate forward rates and negative integers indicate reverse rates. A value of 1 indicates normal speed, a value of 2 indicates double speed, -2 means the movie is playing backward at double speed, and so on. A value of 0 means the movie is paused or stopped.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/


Fixed GetMovieRate (
   Movie    theMovie );


/*InstallReceiveHandler

Installs a receive handler function for one or all of your application’s windows.

OSErr InstallReceiveHandler (
   DragReceiveHandlerUPP receiveHandler,
   WindowRef theWindow,
   void * handlerRefCon
);
Parameters
receiveHandler

A pointer to a receive handler function. Installing a receive handler function allows your application to accept a drag by getting drag item flavor data from the Drag Manager when the user releases the mouse button while dragging over one of your application’s windows. 
theWindow

A reference to the window for which to install the receive handler. When a drop occurs over this window, the Drag Manager calls your receive handler function to allow your application to accept the drag. If you pass NULL, the receive handler function is installed in the default handler space for your application. Receive handler functions installed in this way are called when a drop occurs over any window that belongs to your application. You may install more than one receive handler function on a single window.
handlerRefCon

A pointer to a reference constant that will be forwarded to your receive handler function when it is called by the Drag Manager. Use this constant to pass any data you wish to forward to your drag receive handler. 
Return Value

A result code. See “Drag Manager Result Codes”.
Discussion

The Drag Manager sequentially calls all of the receive handler functions installed on a window when a drop occurs in that window. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Drag.h*/

OSErr InstallReceiveHandler (
   DragReceiveHandlerUPP receiveHandler,
   WindowRef theWindow,
   void * handlerRefCon
);

/*GetMovieNaturalBoundsRect

Gets a movie's natural boundary rectangle.

void GetMovieNaturalBoundsRect (
   Movie    theMovie,
   Rect     *naturalBounds );
Parameters
theMovie

A movie identifier. Your application obtains this identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
naturalBounds

A pointer to a Rect structure that represents the movie's bounding rectangle.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void GetMovieNaturalBoundsRect (
   Movie    theMovie,
   Rect     *naturalBounds );

/*MCClick

Lets a controller respond when the user clicks in a movie controller window.

ComponentResult MCClick (
   MovieController    mc,
   WindowRef          w,
   Point              where,
   long               when,
   long               modifiers );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
w

A pointer to the window in which the event has occurred.
where

The location of the click. This value is expressed in the local coordinates of the window specified by the w parameter. Your application must convert this value from the global coordinates returned in the EventRecord structure.
when

Indicates when the user pressed the mouse button. You obtain this value from the EventRecord structure.
modifiers

Specifies modifier flags for the event. You obtain this value from the EventRecord structure.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/
ComponentResult MCClick (
   MovieController    mc,
   WindowRef          w,
   Point              where,
   long               when,
   long               modifiers );

/*MCIsPlayerEvent

Handles all events for a movie controller.

ComponentResult MCIsPlayerEvent (
   MovieController      mc,
   const EventRecord    *e );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
e

A pointer to the current EventRecord structure.
Return Value

A long integer indicating whether the movie controller component handled the event. The component sets this long integer to 1 if it handled the event. Your application should then skip the rest of its event loop and wait for the next event. The return value is 0 otherwise. Your application must then handle the event as part of its normal event processing.
Discussion

The movie controller component does everything necessary to support the movie controller and its associated movie. For example, the component calls MoviesTask for each movie. The movie controller component also handles suspend and resume events. It treats suspend events as deactivate requests and resume events as activate requests.

The following sample code shows how to convert Windows messages to Macintosh events and then pass those events to the QuickTime movie controller, using this function:// MCIsPlayerEvent coding example
// See "Discovering QuickTime," page 240
MovieController   mc;                   // Movie controller for movie
LRESULT CALLBACK WndProc
        (HWND       hwnd,               // Handle to window
         UINT       iMsg,               // Message type
         WPARAM     wParam,             // Message-dependent parameter
         LPARAM     lParam)             // Message-dependent parameter
{
    MSG             msg;                // Windows message structure
    EventRecord     er;                 // Macintosh event record
    DWORD           dwPos;              // Mouse coordinates of message
    msg.hwnd        =hwnd;             // Window handle
    msg.message     =iMsg;             // Message type
    msg.wParam      =wParam;           // Word-length parameter
    msg.lParam      =lParam;           // Long-word parameter
 
    msg.time =GetMessageTime();        // Get time of message
    dwPos  =GetMessagePos();           // Get mouse position
    msg.pt.x =LOWORD(dwPos);           // Extract x coordinate
    msg.pt.y =HIWORD(dwPos);           // Extract y coordinate
 
    WinEventToMacEvent(&msg, &er);      // Convert to event
    MCIsPlayerEvent(mc, &er);           // Pass event to QuickTime
 
    switch (iMsg) {                     // Dispatch on message type
 
        . . .       // Handle message according to type
 
    }  // end switch (iMsg)
 
}  // end WndProc

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/

ComponentResult MCIsPlayerEvent (
   MovieController      mc,
   const EventRecord    *e );

/*GetMovieNextInterestingTime

Searches for times of interest in a movie's enabled tracks.

void GetMovieNextInterestingTime (
   Movie           theMovie,
   short           interestingTimeFlags,
   short           numMediaTypes,
   const OSType    *whichMediaTypes,
   TimeValue       time,
   Fixed           rate,
   TimeValue       *interestingTime,
   TimeValue       *interestingDuration );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
interestingTimeFlags

Contains flags (see below) that determine the search criteria. Note that you may set only one of the nextTimeMediaSample, nextTimeMediaEdit, nextTimeTrackEdit and nextTimeSyncSample flags to 1. Set unused flags to 0. See these constants: 
nextTimeMediaSample
nextTimeMediaEdit
nextTimeTrackEdit
nextTimeSyncSample
nextTimeStep
nextTimeEdgeOK
nextTimeIgnoreActiveSegment
numMediaTypes

The number of media types in the table referred to by the whichMediaType parameter. Set this parameter to 0 to search all media types.
whichMediaTypes

A pointer to an array of media type constants (see below). You can use this parameter to limit the search to a specified set of media types. Each entry in the table referred to by this parameter identifies a media type to be included in the search. You use the numMediaTypes parameter to indicate the number of entries in the table. Set this parameter to NIL to search all media types. See these constants: 
VisualMediaCharacteristic
AudioMediaCharacteristic
time

Specifies a time value that establishes the starting point for the search. This time value must be expressed in the movie's time scale.
rate

The search direction. Negative values cause the Movie Toolbox to search backward from the starting point specified in the time parameter. Other values cause a forward search.
interestingTime

A pointer to a time value. The Movie Toolbox returns the first time value it finds that meets the search criteria specified in the flags parameter. This time value is in the movie's time scale. If there are no times that meet the search criteria you specify, the Movie Toolbox sets this value to -1. If you are not interested in this information, set this parameter to NIL.
interestingDuration

A pointer to a time value. The Movie Toolbox returns the duration of the interesting time. This time value is in the movie's time coordinate system. Set this parameter to NIL if you don't want this information; in this case, the function works faster.
Discussion

The following code sample shows the use of GetMovieNextInterestingTime to return, through the time parameter, the starting time of the first video sample of the specified QuickTime movie. The trick here is to set the nextTimeEdgeOK flag, to indicate that you want to get the starting time of the beginning of the movie. If this function encounters an error, it returns a (bogus) starting time of -1, as shown below:static OSErr QTStep_GetStartTimeOfFirstVideoSample (Movie theMovie,
                                                    TimeValue *theTime)
{
    short           myFlags;
    OSType          myTypes[1];
 
    *theTime =kBogusStartingTime;               // a bogus starting time
    if (theMovie ==NIL)
        return(invalidMovie);
 
    myFlags =nextTimeMediaSample + nextTimeEdgeOK;
                                 // we want the first sample in the movie
    myTypes[0] =VisualMediaCharacteristic;      // we want video samples
    GetMovieNextInterestingTime(theMovie, myFlags, 1, myTypes,
                                      (TimeValue)0, fixed1, theTime, NIL);
    return(GetMoviesError());
}

Special Considerations

This function examines only the movie's enabled tracks.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

void GetMovieNextInterestingTime (
   Movie           theMovie,
   short           interestingTimeFlags,
   short           numMediaTypes,
   const OSType    *whichMediaTypes,
   TimeValue       time,
   Fixed           rate,
   TimeValue       *interestingTime,
   TimeValue       *interestingDuration );

/*FlattenMovie

Creates a new movie file containing a specified movie.

void FlattenMovie (
   Movie               theMovie,
   long                movieFlattenFlags,
   const FSSpec        *theFile,
   OSType              creator,
   ScriptCode          scriptTag,
   long                createMovieFileFlags,
   short               *resId,
   ConstStr255Param    resName );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
movieFlattenFlags

Contains flags (see below) that control the process of adding movie data to the new movie file. Set unused flags to 0. See these constants: 
flattenAddMovieToDataFork
flattenDontInterleaveFlatten
flattenActiveTracksOnly
flattenCompressMovieResource
flattenFSSpecPtrIsDataRefRecordPtr
flattenForceMovieResourceBeforeMovieData
theFile

A pointer to the file system specification for the movie file to be created.
creator

The creator value for the new file.
scriptTag

The script in which the movie file should be created. Set this parameter to the Script Manager constant smSystemScript to use the system script; set it to smCurrentScript to use the current script. See Inside Macintosh: Text for more information about scripts and script tags.
createMovieFileFlags

Contains flags (see below) that control file creation options. See these constants: 
createMovieFileDeleteCurFile
resId

A pointer to a field that contains the resource ID number for the new resource. If the field referred to by the resId parameter is set to 0, the Movie Toolbox assigns a unique resource ID number to the new resource. The toolbox then returns the movie's resource ID number in the field referred to by the resId parameter. The Movie Toolbox assigns resource ID numbers sequentially, starting at 128. If the resId parameter is set to NIL, the Movie Toolbox assigns a unique resource ID number to the new resource and does not return that resource's ID value.
resName

Points to a character string with the name of the movie resource. If you set the resName parameter to NIL, the toolbox creates an unnamed resource.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Discussion

The file created by FlattenMovie also contains all the data for the movie; that is, the Movie Toolbox resolves any data references and includes the corresponding movie data in the new movie file.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void FlattenMovie (
   Movie               theMovie,
   long                movieFlattenFlags,
   const FSSpec        *theFile,
   OSType              creator,
   ScriptCode          scriptTag,
   long                createMovieFileFlags,
   short               *resId,
   ConstStr255Param    resName );


/*MCSetControllerBoundsRect

Lets you change the position and size of a movie controller.

ComponentResult MCSetControllerBoundsRect (
   MovieController    mc,
   const Rect         *bounds );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
bounds

A pointer to a Rect structure that contains the new boundary Rect structure for the movie controller.
Return Value

See Error Codes. Returns a value of controllerBoundsNotExact if the boundary rectangle has been changed but does not correspond to the rectangle you specified. In this case, the new boundary rectangle is always smaller than the requested rectangle. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/

ComponentResult MCSetControllerBoundsRect (
   MovieController    mc,
   const Rect         *bounds );

/*MCSetControllerPort

Lets your application set the graphics port for a movie controller.

ComponentResult MCSetControllerPort (
   MovieController    mc,
   CGrafPtr           gp );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
gp

A pointer to the new graphics port for the movie controller. Set this parameter to NIL to use the current graphics port.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

Movie controller components use MCSetControllerPort each time you create a new movie controller. Hence, your component must be set to a valid port before creating a new movie controller. You can use this function to place a movie and its associated movie controller in different graphics ports. If you are using an attached controller, both the controller and the movie's graphics ports are changed. If you are using a detached controller, this function changes only the graphics port of the control portion of the controller. You must use SetMovieGWorld followed by MCMovieChanged to change other portions.pascal ComponentResult MCSetControllerPort (MovieController mc,
                                            CGrafPtr gp);

Special Considerations

The movie controller component may use the foreground and background colors from the graphics port at the time this function is called to colorize the movie controller.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/

ComponentResult MCSetControllerPort (
   MovieController    mc,
   CGrafPtr           gp );

/*MCGetIndMovie

Lets your application to retrieve the movie reference for a movie that is associated with a movie controller.

Movie MCGetIndMovie (
   MovieController    mc,
   short              index );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
index

Index for the movie. When set to 0, this call duplicates the action of the previous call to this function.
Return Value

The movie identifier for the movie that is assigned to the specified controller, or NIL if there is no movie assigned to the controller.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/

Movie MCGetIndMovie (
   MovieController    mc,
   short              index );

/*MCGetControllerPort

Returns a movie controller's color graphics port.

CGrafPtr MCGetControllerPort (
   MovieController    mc );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
Return Value

A pointer to the movie controller's CGrafPort structure.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/
CGrafPtr MCGetControllerPort (
   MovieController    mc );

/*MCGetWindowRgn

Determines the window region that is actually in use by a controller and its movie.

RgnHandle MCGetWindowRgn (
   MovieController    mc,
   WindowRef          w );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
w

A pointer to the window in which the movie controller and its movie are displayed, if the control portion of the controller is attached to the movie. If the controller is detached and in a separate window from the movie, specify one of the windows.
Return Value

A handle to the MacRegion structure for the window that is actually in use. Your application must dispose of this structure.
Discussion

The region returned by this function contains only the visible portions of the controller and its movie.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/

RgnHandle MCGetWindowRgn (
   MovieController    mc,
   WindowRef          w );

/*GetMoviePosterPict

Creates a QuickDraw picture that contains a movie's poster.

PicHandle GetMoviePosterPict (
   Movie    theMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

A handle to a Picture structure. If the function could not create the picture, the returned handle is set to NIL.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

PicHandle GetMoviePosterPict (
   Movie    theMovie );

/*&GetMoviePreferredRate

Returns a movie's default playback rate.

Fixed GetMoviePreferredRate (
   Movie    theMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

The movie's default playback rate.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
Fixed GetMoviePreferredRate (
   Movie    theMovie );

/*CopyMovieSettings

Copies many settings from one movie to another, overwriting the destination settings in the process.

OSErr CopyMovieSettings (
   Movie    srcMovie,
   Movie    dstMovie );
Parameters
srcMovie

The source movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
dstMovie

The destination movie for this operation. The CopyMovieSettings function uses the settings from the source movie, which is specified by the srcMovie parameter, to replace the current settings of this movie.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

Use this function to copy certain important settings from one movie to another. It copies the preferred rate and volume, source clipping region, matrix information, and user data; it does not copy the movie's contents. To work with movie contents, you should use segment editing functions.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSErr CopyMovieSettings (
   Movie    srcMovie,
   Movie    dstMovie );

/*SetMovieMatrix

Sets a movie's transformation matrix.

void SetMovieMatrix (
   Movie                 theMovie,
   const MatrixRecord    *matrix );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
matrix

A pointer to the MatrixRecord structure for the movie. If you set this parameter to NIL, the Movie Toolbox uses the identity matrix.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

The Movie Toolbox uses a movie's matrix to map a movie from its display coordinate system to its graphics world.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

void SetMovieMatrix (
   Movie                 theMovie,
   const MatrixRecord    *matrix );

/*SetMovieClipRgn

Establishes a movie's clipping region.

void SetMovieClipRgn (
   Movie        theMovie,
   RgnHandle    theClip );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
theClip

A handle to the movie's clipping region. The Movie Toolbox makes a copy of this region. Your application must dispose of the region referred to by this parameter when you are done with it. Set this parameter to NIL to disable clipping for the movie.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

The clipping region is saved with the movie.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

void SetMovieClipRgn (
   Movie        theMovie,
   RgnHandle    theClip );

/*PutMovieIntoTypedHandle

Takes a movie, or a single track from within that movie, and converts it into a handle of a specified type.

OSErr PutMovieIntoTypedHandle (
   Movie                theMovie,
   Track                targetTrack,
   OSType               handleType,
   Handle               publicMovie,
   TimeValue            start,
   TimeValue            dur,
   long                 flags,
   ComponentInstance    userComp );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
targetTrack

The track to convert.
handleType

The type of the new data.
publicMovie

The actual handle in which to place the new data.
start

The start time of the segment of the movie or track to be converted.
dur

The duration of the segment of the movie or track to be converted.
flags

Condition of the conversion. Set this parameter to 0.
userComp

Indicates a component or component instance of the movie export component you want to perform the conversion. Otherwise, set this parameter to 0 for the Movie Toolbox to choose the appropriate component. If you pass in a component instance, this function will use it. This allows you to communicate directly with the component before using this function to establish any conversion parameters. If you pass in a component ID, an instance is created and closed within this function.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr PutMovieIntoTypedHandle (
   Movie                theMovie,
   Track                targetTrack,
   OSType               handleType,
   Handle               publicMovie,
   TimeValue            start,
   TimeValue            dur,
   long                 flags,
   ComponentInstance    userComp );

/*LoadMovieIntoRam

Loads a movie's data into memory.

OSErr LoadMovieIntoRam (
   Movie        theMovie,
   TimeValue    time,
   TimeValue    duration,
   long         flags );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
time

The starting time of the movie segment to load.
duration

The length of the segment to load. Use GetMovieDuration to determine the length of the entire movie. Note that the Movie Toolbox may load more data than you specify due to the way the data is loaded.
flags

Flags (see below) that give you explicit control over what is loaded into memory and how long to keep it around. You can set these flags in any combination.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSErr LoadMovieIntoRam (
   Movie        theMovie,
   TimeValue    time,
   TimeValue    duration,
   long         flags );

/*SetMovieDefaultDataRef

Sets a movie's default data reference and type.

OSErr SetMovieDefaultDataRef (
   Movie     theMovie,
   Handle    dataRef,
   OSType    dataRefType );
Parameters
theMovie

A movie identifier. Your application obtains this identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
dataRef

A handle to the data reference. The type of information to be placed in the handle depends upon the data reference type specified by dataRefType.
dataRefType

The type of data reference; see Data References.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSErr SetMovieDefaultDataRef (
   Movie     theMovie,
   Handle    dataRef,
   OSType    dataRefType );

/*GetSoundDescriptionExtension

Gets the current extension to a SoundDescription structure.

OSErr GetSoundDescriptionExtension (
   SoundDescriptionHandle    desc,
   Handle                    *extension,
   OSType                    idType );
Parameters
desc

A handle to a SoundDescription structure.
extension

A pointer to a handle that, on return, contains the extension.
idType

A four-byte signature that identifies the type of data in the extension.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/


OSErr GetSoundDescriptionExtension (
   SoundDescriptionHandle    desc,
   Handle                    *extension,
   OSType                    idType );

/*AddSoundDescriptionExtension

Adds an extension to a SoundDescription structure.

OSErr AddSoundDescriptionExtension (
   SoundDescriptionHandle    desc,
   Handle                    extension,
   OSType                    idType );
Parameters
desc

A handle to the SoundDescription structure to add the extension to.
extension

The handle containing the extension data.
idType

A four-byte signature identifying the type of data being added to the SoundDescription.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

Two extensions are defined to the SoundDescription record. The first is the slope, intercept, minClip, and maxClip parameters for audio, represented as an atom of type 'flap'. The second extension is the ability to store data specific to a given audio codec, using a SoundDescriptionV1 structure.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr AddSoundDescriptionExtension (
   SoundDescriptionHandle    desc,
   Handle                    extension,
   OSType                    idType );


/*AddUserDataText

Places language-tagged text into an item in a user data list.

OSErr AddUserDataText (
   UserData    theUserData,
   Handle      data,
   OSType      udType,
   long        index,
   short       itlRegionTag );
Parameters
theUserData

The user data list for this operation. You obtain this list reference by calling GetMovieUserData, GetTrackUserData, or GetMediaUserData.
data

A handle to the data to be added to the user data list.
udType

The type that is to be assigned to the new item.
index

The item to which the text is to be added. This parameter must specify an item in the user data list identified by theUserData.
itlRegionTag

The region code of the text to be added. If there is already text with this region code in the item, the function replaces the existing text with the data specified by the data parameter. See Inside Macintosh: Text for more information about language and region codes.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You specify the user data list and item, the data to be added, the data's type value, and the language code of the data.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr AddUserDataText (
   UserData    theUserData,
   Handle      data,
   OSType      udType,
   long        index,
   short       itlRegionTag );


/*SetQuickTimePreference

Sets a particular preference in the QuickTime preferences.

OSErr SetQuickTimePreference (
   OSType             preferenceType,
   QTAtomContainer    preferenceAtom );
Parameters
preferenceType

The type of preference to set (see below); also see Atom ID Codes. See these constants: 
ConnectionSpeedPrefsType
BandwidthManagementPrefsType
preferenceAtom

A QT atom containing the preference information.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSErr SetQuickTimePreference (
   OSType             preferenceType,
   QTAtomContainer    preferenceAtom );

/*QTInsertChild

Creates a new child atom of the specified parent atom.

OSErr QTInsertChild (
   QTAtomContainer    container,
   QTAtom             parentAtom,
   QTAtomType         atomType,
   QTAtomID           id,
   short              index,
   long               dataSize,
   void               *data,
   QTAtom             *newAtom );
Parameters
container

The atom container that contains the parent atom. The atom container must not be locked.
parentAtom

The parent atom within the atom container.
atomType

The type of the new atom to be inserted.
id

The ID of the new atom to be inserted. This ID must be unique among atoms of the same type for the specified parent. If you set this parameter to 0, the function assigns a unique ID to the atom.
index

The index of the new atom among atoms with the same parent. To insert the first atom for the specified parent, you should set this parameter to 1. To insert an atom as the last atom in the child list, you should set this parameter to 0. Index values greater than the index of the last atom in the child list plus 1 are invalid.
dataSize

The size of the data for the new atom. If the new atom is to be a parent atom or if you want to add the atom's data later, you should pass 0 for this parameter. To create the new atom as a leaf atom that contains data, you should specify the data using the data parameter and and its size using the dataSize parameter.
data

A pointer to a buffer containing the data for the new atom. If you set the value of the dataSize parameter to 0, you should pass NIL for this parameter.
newAtom

A pointer to data of type QTAtom. On return, this parameter points to the newly created atom. You can pass NIL for this parameter if you don't need a reference to the newly created atom.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You call this function to create a new child atom. The new child atom has the specified atom type and atom ID, and is inserted into its parent atom's child list at the specified index. Any existing atoms at the same index or greater are moved toward the end of the child list.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTInsertChild (
   QTAtomContainer    container,
   QTAtom             parentAtom,
   QTAtomType         atomType,
   QTAtomID           id,
   short              index,
   long               dataSize,
   void               *data,
   QTAtom             *newAtom );

/*QTNewAtomContainer

Creates a new atom container.

OSErr QTNewAtomContainer (
   QTAtomContainer    *atomData );
Parameters
atomData

A pointer to an unallocated atom container data structure. On return, this parameter points to an allocated atom container.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

This function creates a new, empty atom container structure. Once you have created an atom container, you can manipulate it using the atom container functions. The following example illustrates using this function to create a new QT atom container and add an atom:// QTNewAtomContainer coding example
QTAtom firstAtom;
QTAtomContainer container;
OSErr err
err =QTNewAtomContainer (&container);
if (!err)
    err =QTInsertChild (container, kParentAtomIsContainer, 'abcd',
        1000, 1, 0, NIL, &firstAtom);

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTNewAtomContainer (
   QTAtomContainer    *atomData );

/*GetQuickTimePreference

Retrieves a particular preference from the QuickTime preferences.

OSErr GetQuickTimePreference (
   OSType             preferenceType,
   QTAtomContainer    *preferenceAtom );
Parameters
preferenceType

A preference type to be retrieved (see below); see Atom ID Codes. See these constants: 
ConnectionSpeedPrefsType
BandwidthManagementPrefsType
preferenceAtom

A pointer to the returned preference atom.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

The following sample code shows how to retrieve the connection speed setting from the QuickTime preferences:struct ConnectionSpeedPrefsRecord {
   long connectionSpeed;
};
typedef struct ConnectionSpeedPrefsRecord ConnectionSpeedPrefsRecord;
. . .
OSErr                       err;
QTAtomContainer             prefs;
QTAtom                      prefsAtom;
long                        dataSize;
Ptr                         atomData;
ConnectionSpeedPrefsRecord  prefrec;
err =GetQuickTimePreference(ConnectionSpeedPrefsType, &amp;prefs);
if (err ==noErr) {
    prefsAtom =QTFindChildByID(prefs, kParentAtomIsContainer,
                                  ConnectionSpeedPrefsType, 1, nil);
    if (!prefsAtom) {
        // set the default setting to 28.8kpbs
        prefrec.connectionSpeed =kDataRate288ModemRate;
    } else {
        err =QTGetAtomDataPtr(prefs, prefsAtom, &dataSize,
                                                         &atomData);
        if (dataSize !=sizeof(ConnectionSpeedPrefsRecord)) {
            // the prefs record wasn't the right size,
            // so it must be corrupt -- set to the default
            prefrec.connectionSpeed =kDataRate288ModemRate;
        } else {
            // everything was fine -- read the connection speed
            prefrec =*(ConnectionSpeedPrefsRecord *)atomData;
        }
    }
    QTDisposeAtomContainer(prefs);
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr GetQuickTimePreference (
   OSType             preferenceType,
   QTAtomContainer    *preferenceAtom );

/*DeleteTrackReference

Removes a track reference from a track.

OSErr DeleteTrackReference (
   Track     theTrack,
   OSType    refType,
   long      index );
Parameters
theTrack

Identifies the track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
refType

The type of reference.
index

The index value of the reference to be deleted. You obtain this index value when you create the track reference.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

This function deletes a track reference from a track. If there are additional track references with higher index values, the toolbox automatically renumbers those references, decrementing their index values by 1.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr DeleteTrackReference (
   Track     theTrack,
   OSType    refType,
   long      index );

/*GetTrackReference

Retrieves the track identifier contained in an existing track reference.

Track GetTrackReference (
   Track     theTrack,
   OSType    refType,
   long      index );
Parameters
theTrack

Identifies the track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
refType

The type of reference; see Data References.
index

The index value of the reference found. You obtain this index value when you create the track reference.
Return Value

The track identifier for the specified track. If the toolbox cannot locate the track reference corresponding to your specifications, it returns a value of NIL.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
Track GetTrackReference (
   Track     theTrack,
   OSType    refType,
   long      index );

/*GetTrackReferenceCount

Determines how many track references of a given type exist for a track.

long GetTrackReferenceCount (
   Track     theTrack,
   OSType    refType );
Parameters
theTrack

Identifies the track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
refType

The type of reference; see Data References. The toolbox determines the number of track references of this type.
Return Value

A long integer that specifies the number of track references of the specified type in the track. If there are no references of the type you have specified, the function returns a value of 0.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
long GetTrackReferenceCount (
   Track     theTrack,
   OSType    refType );

/*GetNextTrackReferenceType

Determines all of the track reference types that are defined for a given track.

OSType GetNextTrackReferenceType (
   Track     theTrack,
   OSType    refType );
Parameters
theTrack

Identifies the track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
refType

The type of reference. Set this parameter to 0 to retrieve the first track reference type. On subsequent requests, use the previous value returned by this function.
Return Value

An OSType containing the next track reference type value defined for the track; see Data References.
Discussion

There is no implied ordering of the values returned by this function . When you reach the end of the track's reference types, this function sets the returned value to 0.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSType GetNextTrackReferenceType (
   Track     theTrack,
   OSType    refType );

/*GetMovieImporterForDataRef

Gets the movie importer component for a movie.

OSErr GetMovieImporterForDataRef (
   OSType       dataRefType,
   Handle       dataRef,
   long         flags,
   Component    *importer );
Parameters
dataRefType

The type of data reference; see Data References.
dataRef

A handle to the data reference. The type of information stored in the handle depends upon the data reference type specified by dataRefType.
flags

Flags (see below) that modify this function's behavior. See these constants: 
kGetMovieImporterDontConsiderGraphicsImporters
importer

A pointer to an importer component that can import the movie. Returns NIL if no importer can be found.
Return Value

If this function is allowed to use async calls (by being passed kGetMovieImporterUseAsyncCalls in the flags parameter), it returns notEnoughDataErr if it would block. You can access this error return through GetMoviesError and GetMoviesStickyError, as well as in the function result. For other errors, see Error Codes.
Discussion

You can use GetMovieImporterForDataRef to determine if a file can be opened by QuickTime as a movie (for example, in a drag-and-drop operation) as illustrated below:AliasHandle            alias;
MovieImportComponent   mi;
NewAliasMinimal(&reply.sfFile, &alias);
GetMovieImporterForDataRef(rAliasType, (Handle)alias,
kGetMovieImporterDontConsiderGraphicsImporters, &mi);
DisposeHandle((Handle)alias);
if (mi !=NIL) {
    // this file can be opened as a movie
    . . .
    }

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSErr GetMovieImporterForDataRef (
   OSType       dataRefType,
   Handle       dataRef,
   long         flags,
   Component    *importer );

/*GetUserData

Returns a specified user data item.

OSErr GetUserData (
   UserData    theUserData,
   Handle      data,
   OSType      udType,
   long        index );
Parameters
theUserData

The user data list for this operation. You obtain this list reference by calling the GetMovieUserData, GetTrackUserData, or GetMediaUserData function.
data

A handle that is to receive the data from the specified item. GetUserData resizes this handle as appropriate to accommodate the item. Your application is responsible for releasing this handle when you are done with it. Set this parameter to NIL if you don't want to retrieve the user data item. This can be useful if you want to verify that a user data item exists, but you don't need to work with the item's contents.
udType

The item's type value; see User Data Identifiers.
index

The item's index value. This parameter must specify an item in the user data list identified by the parameter theUserData.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSErr GetUserData (
   UserData    theUserData,
   Handle      data,
   OSType      udType,
   long        index );

/*GetTrackUserData

Obtains access to a track's user data list.

UserData GetTrackUserData (
   Track    theTrack );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
Return Value

A reference to the specified track's user data. If the function could not locate the track's user data, it sets this returned value to NIL.
Discussion

This function returns a reference to the track's user data list, which is valid until you dispose of the track. When you save the track, the Movie Toolbox saves the user data as well.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
UserData GetTrackUserData (
   Track    theTrack );

/*GetTimeBaseFlags

Obtains the control flags of a time base.

long GetTimeBaseFlags (
   TimeBase    tb );
Parameters
tb

The time base for this operation. Your application obtains this time base identifier from NewTimeBase.
Return Value

Control flags (see below). Unused flags are set to 0.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

long GetTimeBaseFlags (
   TimeBase    tb );

/*SetUserDataItem

Sets an item in a user data list.

OSErr SetUserDataItem (
   UserData    theUserData,
   void        *data,
   long        size,
   OSType      udType,
   long        index );
Parameters
theUserData

The user data list for this operation. You obtain this item reference by calling GetMovieUserData, GetTrackUserData, or GetMediaUserData.
data

A pointer to the data item to be set in a user data list.
size

The size of the information pointed to by the data parameter.
udType

The type value assigned to the new item.
index

The item's index value. This parameter must specify an item in the user data list identified by theUserData. An index value of 0 or 1 implies the first item, which is created if it doesn't already exist.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr SetUserDataItem (
   UserData    theUserData,
   void        *data,
   long        size,
   OSType      udType,
   long        index );

/*RemoveUserData

Removes an item from a user data list.

OSErr RemoveUserData (
   UserData    theUserData,
   OSType      udType,
   long        index );
Parameters
theUserData

The user data list for this operation. You obtain this list reference by calling GetMovieUserData, GetTrackUserData, or GetMediaUserData.
udType

The item's type value.
index

The item's index value. This parameter must specify an item in the user data list identified by the theUserData parameter.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

After the Movie Toolbox removes the item, it renumbers the remaining items of that type so that their index values are sequential and start at 1.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr RemoveUserData (
   UserData    theUserData,
   OSType      udType,
   long        index );

/*CountUserDataType

Determines the number of items of a given type in a user data list.

short CountUserDataType (
   UserData    theUserData,
   OSType      udType );
Parameters
theUserData

The user data list for this operation. You obtain this list reference by calling the GetMovieUserData, GetTrackUserData, or GetMediaUserData functions.
udType

The type. The Movie Toolbox determines the number of items of this type in the user data list.
Return Value

The number of items of the given type in the user data list.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

short CountUserDataType (
   UserData    theUserData,
   OSType      udType );

/*GetUserDataItem

Returns a specified user data item.

OSErr GetUserDataItem (
   UserData    theUserData,
   void        *data,
   long        size,
   OSType      udType,
   long        index );
Parameters
theUserData

The user data list for this operation. You obtain this list reference by calling the GetMovieUserData, GetTrackUserData, or GetMediaUserData.
data

A pointer that is to receive the data from the specified item.
size

The size of the item.
udType

The item's type value; see User Data Identifiers.
index

The item's index value. This parameter must specify an item in the user data list identified by the parameter theUserData.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSErr GetUserDataItem (
   UserData    theUserData,
   void        *data,
   long        size,
   OSType      udType,
   long        index );

/*SetMoviePreferredVolume

Sets a movie's preferred volume setting.

void SetMoviePreferredVolume (
   Movie    theMovie,
   short    volume );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
volume

The preferred volume setting of the movie. The volume parameter must contain a 16-bit, fixed-point number that contains the movie's default volume. The high-order 8 bits contain the integer part of the value; the low-order 8 bits contain the fractional part. Volume values range from -1.0 to 1.0. Negative values play no sound but preserve the absolute value of the volume setting. You may find the constants shown below useful. See these constants: 
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

A movie's tracks may have their own volume settings. Use SetTrackVolume to set the volume of an individual track. A track's volume is scaled by the movie's volume to produce the track's final volume.
Special Considerations

After calling this function you must save the changes it has made, for example by updating or flattening the movie.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

void SetMoviePreferredVolume (
   Movie    theMovie,
   short    volume );

/*GetMovieVolume

Returns a movie's current volume setting.

short GetMovieVolume (
   Movie    theMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

The current volume setting for the movie.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

short GetMovieVolume (
   Movie    theMovie );

/*GetMoviePreferredVolume

Returns a movie's preferred volume setting.

short GetMoviePreferredVolume (
   Movie    theMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

The movie's preferred volume setting.
Discussion

A movie's tracks have their own volume settings. A track's volume is scaled by the movie's volume to produce the track's final volume. On Macintosh computers, the movie's volume is further scaled by the sound volume that the user controls from the Sound control panel.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

short GetMoviePreferredVolume (
   Movie    theMovie );

/*MCPositionController

Controls the position of a movie and its controller on the computer display.

ComponentResult MCPositionController (
   MovieController    mc,
   const Rect         *movieRect,
   const Rect         *controllerRect,
   long               someFlags );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
movieRect

A pointer to a Rect structure that specifies the coordinates of the movie's boundary Rect structure.
controllerRect

A pointer to a Rect structure that specifies the coordinates of the controller's boundary Rect structure. The movie controller component always centers the control portion of the controller inside this rectangle. The movie controller component only uses this parameter when the control portion of the controller is detached from the movie. If you are working with an attached controller, you can set this parameter to NIL.
someFlags

Flags (see below) that control how the movie is drawn. If you set these flags to 0, the movie controller component centers the movie in the rectangle specified by movieRect and scales the movie to fit in that rectangle. See these constants: 
mcTopLeftMovie
mcScaleMovieToFit
mcPositionDontInvalidate
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/

ComponentResult MCPositionController (
   MovieController    mc,
   const Rect         *movieRect,
   const Rect         *controllerRect,
   long               someFlags );

/*MCSetControllerAttached

Lets your application control whether a movie controller is attached to its movie or detached from it.

ComponentResult MCSetControllerAttached (
   MovieController    mc,
   Boolean            attach );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
attach

The action for this function. Set the attach parameter to TRUE to cause the controller to be attached to its movie. Set this parameter to FALSE to detach the controller from its movie.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/

ComponentResult MCSetControllerAttached (
   MovieController    mc,
   Boolean            attach );

/*MCGetVisible

Returns a value that indicates whether or not a movie controller is visible.

ComponentResult MCGetVisible (
   MovieController    mc );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
Return Value

If the controller is visible, the function result is set to 1. If the controller is not showing, the function result is set to 0. You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/

ComponentResult MCGetVisible (
   MovieController    mc );

/*MCUndo

Lets your application discard the effects of the most recent edit operation.

ComponentResult MCUndo (
   MovieController    mc );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/
ComponentResult MCUndo (
   MovieController    mc );

/*MCCut

Returns a copy of the current movie selection from the movie associated with a specified controller and then removes the current movie selection from the source movie.

Movie MCCut (
   MovieController    mc );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
Return Value

A copy of the current movie selection.
Discussion

Your application is responsible for the returned movie. MCCut returns a movie containing the current selection from the movie associated with the specified controller. If the user has not made a selection, the returned movie reference is set to NIL.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/

Movie MCCut (
   MovieController    mc );

/*(MCCopy

Returns a copy of the current movie selection from the movie associated with a specified controller.

Movie MCCopy (
   MovieController    mc );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
Return Value

A copy of the movie.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/
Movie MCCopy (
   MovieController    mc );

/*MCPaste

Inserts a specified movie at the current movie time in the movie associated with a specified controller.

ComponentResult MCPaste (
   MovieController    mc,
   Movie              srcMovie );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
srcMovie

The movie to be inserted into the current selection in the movie associated with the movie controller specified by the mc parameter. If you set this parameter to NIL, the movie controller component retrieves the source movie from the scrap.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/

ComponentResult MCPaste (
   MovieController    mc,
   Movie              srcMovie );

/*MCClear

Removes the current movie selection from the movie associated with a specified controller.

ComponentResult MCClear (
   MovieController    mc );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/
ComponentResult MCClear (
   MovieController    mc );

/*PutMovieOnScrap

Places a movie into the Macintosh scrap.

OSErr PutMovieOnScrap (
   Movie    theMovie,
   long     movieScrapFlags );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
movieScrapFlags

Flags (see below) that control the operation. Be sure to set unused flags to 0. See these constants: 
movieScrapDontZeroScrap
movieScrapOnlyPutMovie
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr PutMovieOnScrap (
   Movie    theMovie,
   long     movieScrapFlags );

/*MCGetControllerInfo

Determines the current status of a movie controller and its associated movie, for menu highlighting.

ComponentResult MCGetControllerInfo (
   MovieController    mc,
   long               *someFlags );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
someFlags

A pointer to flags (see below) that specify the current status and capabilities of the controller. More than one flag may be set to 1. See these constants: 
mcInfoUndoAvailable
mcInfoCutAvailable
mcInfoCopyAvailable
mcInfoPasteAvailable
mcInfoClearAvailable
mcInfoHasSound
mcInfoIsPlaying
mcInfoIsLooping
mcInfoIsInPalindrome
mcInfoEditingEnabled
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You can use the information returned by this function to control your application's menu highlighting.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/
ComponentResult MCGetControllerInfo (
   MovieController    mc,
   long               *someFlags );

/*MCEnableEditing

Enables and disables editing for a movie controller.

ComponentResult MCEnableEditing (
   MovieController    mc,
   Boolean            enabled );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
enabled

Specifies whether to enable or disable editing for the controller. Set this parameter to TRUE to enable editing; set it to FALSE to disable editing.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

Once editing is enabled for a controller, the user may edit the movie associated with the controller.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/
ComponentResult MCEnableEditing (
   MovieController    mc,
   Boolean            enabled );


/*MCSetActionFilterWithRefCon

Establishes an action filter function for a movie controller.

ComponentResult MCSetActionFilterWithRefCon (
   MovieController                mc,
   MCActionFilterWithRefConUPP    blob,
   long                           refCon );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
blob

A pointer to your MCActionFilterWithRefConProc callback. Set this parameter to NIL to remove an existing callback.
refCon

A reference constant value. The movie controller component passes this reference constant to your action filter callback each time it calls it. Use this parameter to point to a data structure containing any information your callback needs.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

The movie controller component calls your action filter function each time the component receives an action for its movie controller. Your filter function is then free to handle the action or to refer it back to the movie controller component. If you refer it back to the movie controller component, the component handles the action.

If your filter function handles an action, you can handle the action in any way you desire. For example, your filter function could change the operation of movie controller buttons. More commonly, applications use the action filter function to monitor actions of the controller. For instance, your filter function might enable you to find out when the user clicks the play button, so that your application can enable appropriate menu selections. Alternatively, you can use the filter function to detect when the user resizes the movie.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/
ComponentResult MCSetActionFilterWithRefCon (
   MovieController                mc,
   MCActionFilterWithRefConUPP    blob,
   long                           refCon );

/*NewMCActionFilterWithRefConUPP

Allocates a Universal Procedure Pointer for the MCActionFilterWithRefConProc callback.

MCActionFilterWithRefConUPP NewMCActionFilterWithRefConUPP (
   MCActionFilterWithRefConProcPtr    userRoutine );
Parameters
userRoutine

A pointer to your application-defined function.
Return Value

A new UPP; see Universal Procedure Pointers.
Discussion

This function is used with Macintosh PowerPC systems. See Inside Macintosh: PowerPC System Software.
Version Notes

Introduced in QuickTime 4.1. Replaces NewMCActionFilterWithRefConProc.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/
MCActionFilterWithRefConUPP NewMCActionFilterWithRefConUPP (
   MCActionFilterWithRefConProcPtr    userRoutine );

/*SetMovieProgressProc

Attaches a progress function to a movie.

void SetMovieProgressProc (
   Movie               theMovie,
   MovieProgressUPP    p,
   long                refcon );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
p

Points to your MovieProgressProc callback. To remove a movie's progress function, set this parameter to NIL. Set this parameter to -1 for the Movie Toolbox to provide a default progress function.
refcon

Specifies a reference constant. Use this parameter to point to a data structure containing any information your callback needs.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

The Movie Toolbox calls your function only during long operations. It ensures that your progress function is called regularly, but not too often.

The following Movie Toolbox functions use progress functions: ConvertFileToMovieFile, CutMovieSelection, CopyMovieSelection, AddMovieSelection, and InsertMovieSegment.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void SetMovieProgressProc (
   Movie               theMovie,
   MovieProgressUPP    p,
   long                refcon );

/*ExitMovies

Automatically called when an application quits.

void ExitMovies ( void );
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Discussion

You only need to call this function if you finish with the Movie Toolbox long before your application is ready to quit. When you call ExitMovies, the Movie Toolbox releases the private storage (which may be significant) that was allocated when you called EnterMovies. As a general rule, your application seldom uses this function; the following code illustrates an exception:// ExitMovies coding example
// See "Discovering QuickTime," page 225
int WINAPI WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance,
                      LPSTR lpCmdLine, int nCmdShow)
{
    MSG         msg;
    HANDLE      hAccelTable;
 
    if  (!hPrevInstance)                   // Is there a previous instance?
        if (!(InitApplication(hInstance)))      // Register window class
            return FALSE;                       // Report failure
 
    if (InitializeQTML(0) !=0) {                       // Initialize QTML
        MessageBox(hwnd, "QuickTime not available",     // Notify user
                            "", MB_OK);
        return FALSE;                                   // Report failure
    }  // end if (InitializeQTML(0) !=0)
 
    if (EnterMovies() !=0) {                       // Initialize QuickTime
        MessageBox(hwnd, "QuickTime not available",     // Notify user
                            "", MB_OK);
        return FALSE;                                   // Report failure
    }  // end if (EnterMovies() !=0)
 
    if (!(InitInstance(hInstance, nCmdShow)))         // Create main window
        return FALSE;                                 // Report failure
 
    hAccelTable =LoadAccelerators(hInstance,     // Load accelerator table
                    MAKEINTRESOURCE(IDR_ACCELSIMPLESDI));
 
    //  Main message loop
 
    while (GetMessage(&msg, NIL, 0, 0))        // Retrieve next message
        if (!TranslateAccelerator(msg.hwnd,    // Check for kbd accelerator
                        hAccelTable, &msg)) {
            TranslateMessage(&msg);     // Convert virtual key to character
            DispatchMessage(&msg);      // Send message to window procedure
        }  // end if (!TranslateAccelerator(msg.hwnd, hAccelTable, &msg))
 
    ExitMovies();                                   // Terminate Toolbox
    TerminateQTML();                                // Terminate QuickTime
 
    return msg.wParam;
}  // end WinMain

Special Considerations

Before calling ExitMovies, be sure that you have closed your connections to any components that use the Movie Toolbox, such as movie controllers, sequence grabbers, and so on.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void ExitMovies ( void );

/*QTDoTween

Runs a tween component.

OSErr QTDoTween (
   QTTweener         tween,
   TimeValue         atTime,
   Handle            result,
   long              *resultSize,
   TweenerDataUPP    tweenDataProc,
   void              *tweenDataRefCon );
Parameters
tween

The tween to be run.
atTime

A value that defines the time to run the tween.
result

A handle to the result of the tweening operation.
resultSize

A pointer to the size of the result.
tweenDataProc

A Universal Procedure Pointer that accesses a TweenerDataProc callback.
tweenDataRefCon

A pointer to a reference constant to be passed to your callback. Use this constant to point to a data structure containing any information your function needs.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTDoTween (
   QTTweener         tween,
   TimeValue         atTime,
   Handle            result,
   long              *resultSize,
   TweenerDataUPP    tweenDataProc,
   void              *tweenDataRefCon );

/*QTCopyAtomDataToPtr

Copies the specified leaf atom's data to a buffer.

OSErr QTCopyAtomDataToPtr (
   QTAtomContainer    container,
   QTAtom             atom,
   Boolean            sizeOrLessOK,
   long               size,
   void               *targetPtr,
   long               *actualSize );
Parameters
container

The atom container that contains the leaf atom.
atom

The leaf atom whose data should be copied.
sizeOrLessOK

Specifies whether the function may copy fewer bytes than the number of bytes specified by the size parameter. The buffer may be larger than the amount of atom data if you set the value of this parameter to TRUE. You can determine the size of an atom's data by calling QTGetAtomDataPtr.
size

The length, in bytes, of the buffer pointed to by the targetPtr parameter.
targetPtr

A pointer to a buffer. On return, the buffer contains the atom data.
actualSize

A pointer to a long integer which, on return, contains the number of bytes copied to the buffer.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You call this function, passing a data buffer, to retrieve a copy of a leaf atom's data. The buffer must be large enough to contain the atom's data.
Special Considerations

This function may move memory.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSErr QTCopyAtomDataToPtr (
   QTAtomContainer    container,
   QTAtom             atom,
   Boolean            sizeOrLessOK,
   long               size,
   void               *targetPtr,
   long               *actualSize );

/*MCSetUpEditMenu

Correctly highlights and names the items in your application's Edit menu.

ComponentResult MCSetUpEditMenu (
   MovieController    mc,
   long               modifiers,
   MenuRef            mh );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
modifiers

The current modifiers from the mouse-down or key-down event to which you are responding.
mh

A menu handler for your current Edit menu. The first six items in your Edit menu should be the standard editing commands: Undo, a blank line, Cut, Copy, Paste, and Clear.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/
ComponentResult MCSetUpEditMenu (
   MovieController    mc,
   long               modifiers,
   MenuRef            mh );

/*DeleteMovieFile

Deletes a movie file.

OSErr DeleteMovieFile (
   const FSSpec    *fileSpec );
Parameters
fileSpec

A pointer to the file system specification for the movie file to be deleted.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier. Superseded in QuickTime 6 by DeleteMovieStorage.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSErr DeleteMovieFile (
   const FSSpec    *fileSpec );

/*FlattenMovieData

Creates a new movie and a file that contains all the movie data.

Movie FlattenMovieData (
   Movie           theMovie,
   long            movieFlattenFlags,
   const FSSpec    *theFile,
   OSType          creator,
   ScriptCode      scriptTag,
   long            createMovieFileFlags );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
movieFlattenFlags

Contains flags (see below) that control the process of adding movie data to the new movie file. These flags affect how the toolbox adds movies to the new movie file later. Set unused flags to 0. See these constants: 
flattenAddMovieToDataFork
flattenDontInterleaveFlatten
flattenActiveTracksOnly
flattenCompressMovieResource
flattenFSSpecPtrIsDataRefRecordPtr
flattenForceMovieResourceBeforeMovieData
theFile

This parameter usually contains a pointer to the file system specification for the movie file to be created. In place of a FSSpec pointer, QuickTime lets you pass a pointer to a data reference structure to receive the flattened movie data.
creator

The creator value for the new file.
scriptTag

Contains constants (see below) that specify the script in which the movie file should be created. See Inside Macintosh: Text for more information about scripts and script tags. See these constants: 
createMovieFileFlags

Contains flags (see below) that control file creation options. See these constants: 
createMovieFileDeleteCurFile
Return Value

The identifier of the new movie. If the function could not create the movie, it sets this returned identifier to NIL.
Discussion

This function will take any movie and optionally make it self-contained, interleaved, and Fast Start. Unlike FlattenMovie, this function does not add the new movie resource to the new movie file; instead, FlattenMovieData returns the new movie to your application. Your application must dispose of the returned movie. You can use this function to create a single-fork movie file, by setting the flattenAddMovieToDataFork flag in the movieFlattenFlags parameter to 1. The Movie Toolbox then places the movie into the data fork of the movie file. Instead of flattening to a file, you can specify a data reference to flatten a movie to. The following two code samples show flattening a movie to a data location and to a file:// FlattenMovieData used to flatten a movie to a data location
// create a 0-length handle
    myHandle =NewHandleClear(mySize);
    if (myHandle ==NIL)
        goto bail;
 
// fill in the data reference record
    myDataRefRec.dataRefType =HandleDataHandlerSubType;
    myDataRefRec.dataRef =NewHandle(sizeof(Handle));
    if (myDataRefRec.dataRef ==NIL)
        goto bail;
    *((Handle *)*(myDataRefRec.dataRef)) =myHandle;
    myFlags =flattenFSSpecPtrIsDataRefRecordPtr;
    myFile =(FSSpec *)&myDataRefRec;
    // flatten the source movie into the handle
    myMemMovie =FlattenMovieData(mySrcMovie, myFlags, myFile, 0L,
                                  smSystemScript, 0L);
    Movie aMovie;
    aMovie =FlattenMovieData(theMovie,
        flattenAddMovieToDataFork |
        flattenForceMovieResourceBeforeMovieData,
        &theOutputFile, OSTypeConst('TVOD'), smSystemScript,
        createMovieFileDeleteCurFile | createMovieFileDontCreateResFile);
 
    DisposeMovie(aMovie);
    Movie aMovie;
    aMovie =FlattenMovieData(theMovie,
        flattenAddMovieToDataFork,
        &theOutputFile, OSTypeConst('TVOD'), smSystemScript,
        createMovieFileDeleteCurFile | createMovieFileDontCreateResFile);
 
    DisposeMovie(aMovie);
// FlattenMovieData used to flatten a movie to a Fast Start file
// See "Discovering QuickTime," page 257
myErr =OpenMovieFile(&myTempSpec, &myTempResRefNum, fsRdPerm);
if (myErr !=noErr)
    goto bail;
myErr =NewMovieFromFile(&myTempMovie, myTempResRefNum, NIL, 0, 0, 0);
if (myErr !=noErr)
    goto bail;
SetMovieProgressProc(myTempMovie, (MovieProgressUPP)-1, 0L);
// flatten the temporary file into a new movie file; put the movie
// resource first so that progressive downloading is possible
myPanoMovie =FlattenMovieData(
                        myTempMovie,
                        flattenDontInterleaveFlatten
                        | flattenAddMovieToDataFork
                        | flattenForceMovieResourceBeforeMovieData,
                        &myDestSpec,
                        FOUR_CHAR_CODE('TVOD'),
                        smSystemScript,
                        createMovieFileDeleteCurFile
                        | createMovieFileDontCreateResFile);

Special Considerations

Through the SetTrackLoadSettings function, the Movie Toolbox allows you to set a movie's preloading guidelines when you create the movie. The preload information is preserved when you save or flatten the movie (using either FlattenMovie or FlattenMovieData). In flattened movies, the tracks that are to be preloaded are stored at the start of the movie, rather than being interleaved with the rest of the movie data. This greatly improves preload performance because it is not necessary for the device storing the movie data to seek during retrieval of the data to be preloaded. 
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

Movie FlattenMovieData (
   Movie           theMovie,
   long            movieFlattenFlags,
   const FSSpec    *theFile,
   OSType          creator,
   ScriptCode      scriptTag,
   long            createMovieFileFlags );

/*SetMovieCoverProcs

Sets the callbacks invoked when a movie is covered or uncovered.

void SetMovieCoverProcs (
   Movie               theMovie,
   MovieRgnCoverUPP    uncoverProc,
   MovieRgnCoverUPP    coverProc,
   long                refcon );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
uncoverProc

Points to a MovieRgnCoverProc callback. This function is called whenever one of your movie's tracks is removed from the screen or resized, revealing a previously hidden screen region. If you want to remove this uncover function, set this parameter to NIL. When the uncoverProc parameter is NIL the function uses the default uncover function, which erases the uncovered area.
coverProc

Points to a MovieRgnCoverProc callback. The Movie Toolbox calls this function whenever one of your movies covers a portion of the screen. If you want to remove the cover function, set this parameter to NIL. When the coverProc parameter is NIL the function uses the default cover function, which does nothing.
refcon

Specifies a reference constant. Use this parameter to point to a data structure containing any information your callbacks need.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

If a movie with semi-transparent tracks has a movie uncover procedure, set with this function, the uncover procedure is called before each frame to fill or erase the background.
Version Notes

Before QuickTime 1.6.1, the Movie Toolbox performed the erase, which limited a cover procedure-aware application's options.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

void SetMovieCoverProcs (
   Movie               theMovie,
   MovieRgnCoverUPP    uncoverProc,
   MovieRgnCoverUPP    coverProc,
   long                refcon );

/*NewMovieRgnCoverUPP

Allocates a Universal Procedure Pointer for the MovieRgnCoverProc callback.

MovieRgnCoverUPP NewMovieRgnCoverUPP (
   MovieRgnCoverProcPtr    userRoutine );
Parameters
userRoutine

A pointer to your application-defined function.
Return Value

A new UPP; see Universal Procedure Pointers.
Discussion

This function is used with Macintosh PowerPC systems. See Inside Macintosh: PowerPC System Software.
Version Notes

Introduced in QuickTime 4.1. Replaces NewMovieRgnCoverProc.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

MovieRgnCoverUPP NewMovieRgnCoverUPP (
   MovieRgnCoverProcPtr    userRoutine );

/*GetMediaQuality

Returns a media's quality level value.

short GetMediaQuality (
   Media    theMedia );
Parameters
theMedia

The media for this operation. Your application obtains this media identifier from such functions as NewTrackMedia and GetTrackMedia. See Media Identifiers.
Return Value

A short integer whose bits indicate quality constants (see below). More than one of these bits may be set to 1.
Discussion

The Movie Toolbox uses this quality value to influence which track of a movie it selects to play on a given computer. This even applies to sound media. The low-order 6 bits specify pixel depths and the upper 2 bits specify quality levels. If a bit is set to 1, the media can be played at the corresponding depth and quality level.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
short GetMediaQuality (
   Media    theMedia );

/*SetSpriteProperty

Sets the specified property of a sprite.

OSErr SetSpriteProperty (
   Sprite    theSprite,
   long      propertyType,
   void      *propertyValue );
Parameters
theSprite

The sprite for this operation.
propertyType

The property you want to modify (see below). See these constants: 
kSpritePropertyMatrix
kSpritePropertyImageDescription
kSpritePropertyImageDataPtr
kSpritePropertyVisible
kSpritePropertyLayer
kSpritePropertyGraphicsMode
kSpritePropertyCanBeHitTested
propertyValue

The new value of the property. Depending on the property type, you set the propertyValue parameter to either a pointer to the property value or the property value itself, cast as a void pointer.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You animate a sprite by modifying its properties, using this function. It invalidates the sprite's sprite world as needed. Here is sample code that uses this function to modify a sprite's properties:// SetSpriteProperty coding example
// See "Discovering QuickTime," page 345
#define kNumSprites             4
#define kNumSpaceShipImages     24
Rect            gBounceBox;
Sprite          gSprites[kNumSprites];
Rect            gDestRects[kNumSprites];
Point           gDeltas[kNumSprites];
short           gCurrentImages[kNumSprites];
Handle          gCompressedPictures[kNumSpaceShipImages];
void MyMoveSprites (void)
{
    short           nIndex;
    MatrixRecord    matrix;
 
    SetIdentityMatrix(&matrix);
    // for each sprite
    for (nIndex =0; nIndex < kNumSprites; nIndex++) {
        // modify the sprite's matrix
        OffsetRect(&gDestRects[nIndex], gDeltas[nIndex].h,
                    gDeltas[nIndex].v);
 
        if ((gDestRects[nIndex].right >
=gBounceBox.right) ||
            (gDestRects[nIndex].left <=gBounceBox.left))
            gDeltas[nIndex].h =-gDeltas[nIndex].h;
 
        if ((gDestRects[nIndex].bottom >
=gBounceBox.bottom) ||
            (gDestRects[nIndex].top <=gBounceBox.top))
            gDeltas[nIndex].v =-gDeltas[nIndex].v;
 
        matrix.matrix[2][0] =((long)gDestRects[nIndex].left << 16);
        matrix.matrix[2][1] =((long)gDestRects[nIndex].top << 16);
 
        SetSpriteProperty(gSprites[nIndex], kSpritePropertyMatrix,
                            &matrix);
 
        // change the sprite's image
        gCurrentImages[nIndex]++;
        if (gCurrentImages[nIndex] >
=(kNumSpaceShipImages *
                                        (nIndex+1)))
            gCurrentImages[nIndex] =0;
        SetSpriteProperty(gSprites[nIndex], kSpritePropertyImageDataPtr,
            *gCompressedPictures[gCurrentImages[nIndex] / (nIndex+1)]);
    }
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr SetSpriteProperty (
   Sprite    theSprite,
   long      propertyType,
   void      *propertyValue );

#ifdef __cplusplus
}
#endif
#endif