#ifndef MEDIAHANDLERS_H
#define MEDIAHANDLERS_H

#ifndef CARBON_H
#include <Carbon/Carbon.h>
#endif

#ifndef MOVIES_H
#include <QuickTime/Movies.h>
#endif




#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif


/*MediaGetName

Returns the name of the media type.

ComponentResult MediaGetName (
   MediaHandler    mh,
   Str255          name,
   long            requestedLanguage,
   long            *actualLanguage );
Parameters
mh

The Toolbox's connection to your derived media handler. You can obtain this reference from GetMediaHandler.
name

The name of the media type; for example, the video media handler returns the string 'video'.
requestedLanguage

The language in which you want the name returned; see Localization Codes.
actualLanguage

A pointer to the actual language in which the name is returned; see Localization Codes
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MediaHandlers.h*/
ComponentResult MediaGetName (
   MediaHandler    mh,
   Str255          name,
   long            requestedLanguage,
   long            *actualLanguage );

/*GetMovieCompleteParams

Defines the layout of the complete movie parameter structure used by MediaInitialize.

struct GetMovieCompleteParams {
   short              version;
   Movie              theMovie;
   Track              theTrack;
   Media              theMedia;
   TimeScale          movieScale;
   TimeScale          mediaScale;
   TimeValue          movieDuration;
   TimeValue          trackDuration;
   TimeValue          mediaDuration;
   Fixed              effectiveRate;
   TimeBase           timeBase;
   short              volume;
   Fixed              width;
   Fixed              height;
   MatrixRecord       trackMovieMatrix;
   CGrafPtr           moviePort;
   GDHandle           movieGD;
   PixMapHandle       trackMatte;
   QTAtomContainer    inputMap;
};
Fields
version
Discussion

Specifies the version of this structure. This field is always set to 1.
theMovie
Discussion

Identifies the movie that contains the current media's track. This movie identifier is supplied by the Movie Toolbox. Your component may use this identifier to obtain information about the movie that is using your media.
theTrack
Discussion

Identifies the track that contains the current media. This track identifier is supplied by the Movie Toolbox. Your component may use this identifier to obtain information about the track that contains your media. For example, you might call GetTrackNextInterestingTime to examine the track's edit list.
theMedia
Discussion

Identifies the current media. This media identifier is supplied by the Movie Toolbox. Your derived media handler can use this identifier to read samples or sample descriptions from the current media, using GetMediaSample and GetMediaSampleDescription. 
movieScale
Discussion

Specifies the time scale of the movie that contains the current media's track. If the Movie Toolbox changes the movie's time scale, the toolbox calls your derived media handler's MediaSetMovieTimeScale function.
mediaScale
Discussion

Specifies the time scale of the current media. If the Movie Toolbox changes your media's time scale, the toolbox calls your derived media handler's MediaSetMediaTimeScale function.
movieDuration
Discussion

Contains the movie's duration. This value is expressed in the movie's time scale.
trackDuration
Discussion

Contains the track's duration. This value is expressed in the movie's time scale.
mediaDuration
Discussion

Contains the media's duration. This value is expressed in the media's time scale.
effectiveRate
Discussion

Contains the media's effective rate. This rate ties the media's time scale to the passage of absolute time, and does not necessarily correspond to the movie's rate. This value takes into account any master time bases that may be serving the media's time base. The value of this field indicates the number of time units (in the media's time scale) that pass each second. This rate is represented as a 32-bit, fixed-point number. The high-order 16 bits contain the integer portion, and the low-order 16 bits contain the fractional portion. The rate is negative when time is moving backward for the media. Whenever the Movie Toolbox changes your media's effective rate, it calls your derived media handler's MediaSetRate function.
timeBase
Discussion

Identifies the media's time base.
volume
Discussion

Contains the media's current volume setting. This value is represented as a 16-bit, fixed-point number. The high-order 8 bits contain the integer portion; the low-order 8 bits contain the fractional part. Volume values range from -1.0 to 1.0. Negative values play no sound but preserve the absolute value of the volume setting. If QuickTime changes your media's volume, it calls your derived media handler's MediaGSetVolume function.
width
Discussion

Indicates the width, in pixels, of the track rectangle. This field, along with the height field, specifies a rectangle that surrounds the image that is displayed when the current media is played. This value corresponds to the x coordinate of the lower-right corner of the rectangle and is expressed as a fixed-point number. If the Movie Toolbox modifies this rectangle, the toolbox calls your derived media handler's MediaSetDimensions function. Note that your media need not present only a rectangular image. The Movie Toolbox can use a clipping region to cause your media's image to be displayed in a region of arbitrary shape, and it can use a matte to control the image's transparency. The toolbox calls your derived media handler's MediaSetClip function whenever it changes your media's clipping region. The trackMatte field in this structure specifies a matte region.
height
Discussion

Indicates the height, in pixels, of the track rectangle. This value corresponds to the y coordinate of the lower-right corner of the rectangle and is expressed as a fixed-point number.
trackMovieMatrix
Discussion

Specifies the matrix that transforms your media's pixels into the movie's coordinate system. The Movie Toolbox obtains this matrix by concatenating the track matrix and the movie matrix. You should use this matrix whenever you are displaying graphical data from your media. Whenever the Movie Toolbox modifies this matrix, it calls your derived media handler's MediaSetMatrix function.
moviePort
Discussion

Indicates the movie's graphics port. Whenever the Movie Toolbox changes the movie's graphics world, it calls your derived media handler's MediaSetGWorld function.
movieGD
Discussion

Specifies the movie's graphics device. Whenever the Movie Toolbox changes the movie's graphics world, it calls your derived media handler's MediaSetGWorld function.
trackMatte
Discussion

Identifies the matte region assigned to the track that uses your media. This field contains a handle to a pixel map that contains a blend matte. Your component is not responsible for disposing of this matte. If there is no matte, this field is set to NIL.
inputMap
Discussion

A reference to the media's input map. The media input map should not be modified or disposed.
Related Functions
MediaInitialize 
Declared In
MediaHandlers.h*/

struct GetMovieCompleteParams {
   short              version;
   Movie              theMovie;
   Track              theTrack;
   Media              theMedia;
   TimeScale          movieScale;
   TimeScale          mediaScale;
   TimeValue          movieDuration;
   TimeValue          trackDuration;
   TimeValue          mediaDuration;
   Fixed              effectiveRate;
   TimeBase           timeBase;
   short              volume;
   Fixed              width;
   Fixed              height;
   MatrixRecord       trackMovieMatrix;
   CGrafPtr           moviePort;
   GDHandle           movieGD;
   PixMapHandle       trackMatte;
   QTAtomContainer    inputMap;
};
typedef struct GetMovieCompleteParams GetMovieCompleteParams;

//function

/*MediaSetGraphicsMode

Sets the graphics mode and blend color of any media handler.

ComponentResult MediaSetGraphicsMode (
   MediaHandler      mh,
   long              mode,
   const RGBColor    *opColor );
Parameters
mh

The Toolbox's connection to your derived media handler. You can obtain this reference from GetMediaHandler.
mode

The graphics mode of the media handler; see Graphics Transfer Modes.
opColor

A pointer to the color for use in blending and transparent operations. The media handler passes this color to QuickDraw as appropriate when you draw in addPin, subPin, blend, transparent, or graphicsModeStraightAlphaBlend mode.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MediaHandlers.h*/
ComponentResult MediaSetGraphicsMode (
   MediaHandler      mh,
   long              mode,
   const RGBColor    *opColor );


#ifdef __cplusplus
}
#endif
#endif