#ifndef QUICKDRAWTEXT_H
#define QUICKDRAWTEXT_H

#ifndef CORESERVICES_H
#include <CoreServices/CoreServices.h>
#endif

#include <HYS/QD/QuickdrawText.h>
#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*FontInfo

Contains font metric information.

struct FontInfo {
   short ascent;
   short descent;
   short widMax;
   short leading;
};
typedef struct FontInfo FontInfo;
Fields
ascent

The measurement, in pixels, from the baseline to the ascent line of the font.
descent

The measurement, in pixels, from the baseline to the descent line of the font.
widMax

The width, in pixels, of the largest glyph in the font.
leading

The measurement, in pixels, from the descent line to the ascent line below it.
Discussion

The FontInfo data type defines a font information structure. The GetFontInfo function uses the font information structure to return measurement information based on the font of the current graphics port. If the current font has an associated font, as do Arabic and Hebrew, GetFontInfo returns information based on both fonts. The font information structure contains the ascent, the descent, the width of the largest glyph, and the leading for a given font. The StdTxMeas function also uses a structure of type FontInfo to return information about the current font. 
Availability
Available in Mac OS X v10.0 and later.*/
struct FontInfo {
   short ascent;
   short descent;
   short widMax;
   short leading;
};
typedef struct FontInfo FontInfo;


/*GetFontInfo

Returns information about the current graphics port’s font, taking into account the style and size in which the glyphs are to be drawn. (Deprecated in Mac OS X v10.4. Use ATSUI instead.)

void GetFontInfo (
   FontInfo * info
);
Parameters
info

Pointer to a font information structure that contains the font measurement information, in integer values. 
Discussion

The GetFontInfo function returns the ascent, descent, leading, and width of the largest glyph of the font in the text font, size, and style specified in the current graphics port. If the script system specified by the current graphics port txFont field has an associated font, as do Hebrew and Arabic, GetFontInfo returns combined information based on both fonts. This is to accommodate text written in the Roman script when the primary script system is non-Roman. However, even if all of the text is written in a non-Roman script, if there is an associated font, GetFontInfo always bases its information on the combined fonts. You can determine the line height, in pixels, by adding the values of the ascent, descent, and leading fields.

The GetFontInfo function is similar to the Font Manager’s FontMetrics function, except that the GetFontInfo function returns integer values. See FontInfo for a description of the structure and its fields. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
QuickdrawText.h*/

void GetFontInfo (
   FontInfo * info
);

/*StringWidth

Returns the length, in pixels, of the specified text string. (Deprecated in Mac OS X v10.4. Use ATSUI instead.)

short StringWidth (
   ConstStr255Param s
);
Parameters
s

A Pascal string containing the text to be measured.
Return Value

The length, in pixels, of the specified text string. 
Discussion

You should not call StringWidth to measure scaled text. Although StringWidth takes into account the graphics port structure settings, it does not accept scaling parameters, and therefore cannot determine the correct text width result for text to be drawn using scaling factor parameters.

If you specify values in the graphics port spExtra or chExtra fields to change the width of space or nonspace characters, StringWidth takes these values into account.

Because this function measures text in the font, style, and size of the current graphics port, you need to call it once for each individual style run in any line of text that contains multiple style runs.

The StringWidth function works with all script systems. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
QuickdrawText.h*/
short StringWidth (
   ConstStr255Param s
);

/*CharWidth

Returns the width (horizontel extension), in pixels, of the specified character. (Deprecated in Mac OS X v10.4. Use ATSUI instead.)

short CharWidth (
   CharParameter ch
);
Parameters
ch

The character whose width is to be measured. 
Return Value

The width (horizontel extension), in pixels, of the specified character. 
Discussion

The CharWidth function includes the effects of the stylistic variations for the text set in the current graphics port. If you change any of these attributes after determining the glyph width but before actually drawing it, the predetermined width may not be correct. For a space character, CharWidth also includes the effect of SpaceExtra. For a nonspace character, CharWidth includes the effect of CharExtra.

Because it takes a single-byte value as the ch parameter, CharWidth works only for 1-byte simple script systems.

A series of calls to CharWidth in a contextual 1-byte font may give incorrect results, because the width of a text segment may be different from the sum of its individual character widths. In that case, to measure a line of text you should call TextWidth.

Do not use the CharWidth function for 2-byte script systems. If you want to measure the width of a single glyph in a 2-byte font, you should use TextWidth. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
QuickdrawText.h*/
short CharWidth (
   CharParameter ch
);

/*TextMode

Sets the transfer mode for drawing text in the current graphics port. (Deprecated in Mac OS X v10.4. Use ATSUI or Quartz instead.)

void TextMode (
   short mode
);
Parameters
mode

The transfer mode to be used to draw the text. 
Discussion

The TextMode function sets the transfer mode in the graphics port txMode field. The transfer mode determines the interplay between what an application is drawing (the source) and what already exists on the display device (the destination), resulting in the text display.

There are two basic kinds of modes: pattern (pat) and source (src). Source is the kind that you use for drawing text. There are four basic Boolean operations: Copy, Or, Xor, and Bic (bit clear), each of which has an inverse variant in which the source is inverted before the transfer, yielding eight operations in all. Original QuickDraw supports these eight transfer modes. Color QuickDraw enables your application to achieve color effects within those basic transfer modes, and offers an additional set of transfer modes that perform arithmetic operations on the RGB values of the source and destination pixels. Other transfer modes are grayishTextOr, transparent mode, and text mask mode.

To ensure future compatibility and benefit from any enhancements, always use this function to modify the txMode field, rather than directly change the field value. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
QuickdrawText.h*/

void TextMode (
   short mode
);


#ifdef __cplusplus
}
#endif

#endif