#ifndef HISHAPE_H
#define HISHAPE_H

#ifndef APPLICATIONSERVICES_H
#include <ApplicationServices/ApplicationServices.h>
#endif

#ifndef CARBONEVENTS_H
#include <HIToolbox/CarbonEvents.h>
#endif



#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*HIShapeRef

Defines a shape object.

typedef const struct __HIShape *HIShapeRef;
Discussion

The structure pointed to by this reference is opaque.
Availability
Available in Mac OS X v10.2 and later.*/
typedef const struct __HIShape *HIShapeRef;

/*HIMutableShapeRef

Defines a mutable shape object.

typedef struct __HIShape *HIMutableShapeRef;
Discussion

The structure pointed to by this reference is opaque. 
Availability
Available in Mac OS X v10.2 and later.*/
typedef struct __HIShape *HIMutableShapeRef;


//function


/*HIShapeCreateMutable

Creates an empty mutable shape.

HIMutableShapeRef HIShapeCreateMutable (void);
Return Value

An empty, mutable shape. 
Availability
Available in Mac OS X v10.2 and later. 
Declared In
HIShape.h*/
HIMutableShapeRef HIShapeCreateMutable (void);

/*HIShapeCreateWithRect

Creates an immutable shape from a Quartz rectangle.

HIShapeRef HIShapeCreateWithRect (
   const HIRect * inRect
);
Parameters
inRect

The Quartz-based rectangle to convert. 
Return Value

The newly-created shape.
Discussion

This function is comparable to the old QuickDraw function RectRgn.
Availability
Available in Mac OS X v10.2 and later. 
Declared In
HIShape.h*/

HIShapeRef HIShapeCreateWithRect (
   const HIRect * inRect
);

/*HIShapeUnion

Sets a shape to be the union of two other shapes.

OSStatus HIShapeUnion(
   HIShapeRef inShape1,
   HIShapeRef inShape2,
   HIMutableShapeRef outResult
);
Parameters
inShape1

An existing shape.
inShape2

Another existing shape. 
outResult

The shape to hold the union of the two shapes. This parameter can be one of the source shapes. 
Return Value

A result code. 
Discussion

This function is comparable to the old QuickDraw function UnionRgn.
Availability
Available in Mac OS X v10.2 and later. 
Declared In
HIShape.h*/
OSStatus HIShapeUnion(
   HIShapeRef inShape1,
   HIShapeRef inShape2,
   HIMutableShapeRef outResult
);

/*HIShapeIsEmpty

Determines whether a given shape is empty.

Boolean HIShapeIsEmpty (
   HIShapeRef inShape
);
Parameters
inShape

The shape to test. 
Return Value

True if the shape’s area is empty, False otherwise. 
Discussion

This function is comparable to the old QuickDraw function EmptyRgn.
Availability
Available in Mac OS X v10.2 and later. 
Declared In
HIShape.h*/
Boolean HIShapeIsEmpty (
   HIShapeRef inShape
);

/*HIShapeCreateDifference

Creates an immutable shape that is the difference of two shapes. 

HIShapeRef HIShapeCreateDifference (
   HIShapeRef inShape1,
   HIShapeRef inShape2
);
Parameters
inShape1

The first shape. 
inShape2

The shape to subtract from the first shape. 
Return Value

The newly-created difference shape.
Availability
Available in Mac OS X v10.2 and later. 
Declared In
HIShape.h*/

HIShapeRef HIShapeCreateDifference (
   HIShapeRef inShape1,
   HIShapeRef inShape2
);

#ifdef __cplusplus
}
#endif

#endif