#ifndef CARBONEVENTS_H
#define CARBONEVENTS_H

#ifndef APPLICATIONSERVICES_H
#include <ApplicationServices/ApplicationServices.h>
#endif

#ifndef CARBONEVENTSCORE_H
#include <HIToolbox/CarbonEventsCore.h>
#endif

#ifndef EVENTS_H
#include <HIToolbox/Events.h>
#endif

#ifndef MENUS_H
#include <HIToolbox/Menus.h>
#endif

#ifndef CONTROLS_H
#include <HIToolbox/Controls.h>
#endif

#ifndef MACWINDOWS_H
#include <HIToolbox/MacWindows.h>
#endif

#include <HYS/HIToolbox/CarbonEvents.h>
#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Key Modifier Event Bits

Define key modifier change event bits.

enum {
   kEventKeyModifierNumLockBit = 16,
   kEventKeyModifierFnBit = 17
};
Constants
kEventKeyModifierNumLockBit

This keyboard event was generated either on the numeric keypad or in the numeric section of an iBook or PowerBook keyboard with the Num Lock key pressed. This state bit does not provide an indication of the Num Lock key on non-portable keyboards. This bit is set on Mac OS X only.

Available in Mac OS X v10.0 and later.
kEventKeyModifierFnBit

The Fn key was pressed when this keyboard event was generated. This bit is set on Mac OS X only.

Available in Mac OS X v10.0 and later.
Discussion

Note that bits 8 through 15 (cmdKeyBit to rightControlKeyBit) are compatible with the Classic Event Manager modifiers.*/
enum {
   kEventKeyModifierNumLockBit = 16,
   kEventKeyModifierFnBit = 17
};



/*Window Bounds Attributes

Define constants that describe how a window’s bounds are changing.

enum {
   kWindowBoundsChangeUserDrag = (1 << 0),
   kWindowBoundsChangeUserResize = (1 << 1),
   kWindowBoundsChangeSizeChanged = (1 << 2),
   kWindowBoundsChangeOriginChanged = (1 << 3),
   kWindowBoundsChangeZoom = (1 << 4)
};
Constants
kWindowBoundsChangeUserDrag

The bounds are changing because the user is dragging the window around. 

Available in Mac OS X v10.0 and later.
kWindowBoundsChangeUserResize

The bounds are changing because the user is resizing the window. 

Available in Mac OS X v10.0 and later.
kWindowBoundsChangeSizeChanged

The dimensions of the window (width and height) are changing. 

Available in Mac OS X v10.0 and later.
kWindowBoundsChangeOriginChanged

The origin of the window is changing. 

Available in Mac OS X v10.0 and later.
kWindowBoundsChangeZoom

The bounds are changing as a result of the user clicking the zoom button. 

Available in Mac OS X v10.2 and later.
Discussion

When the toolbox sends out a kEventWindowBoundsChanging or kEventWindowBoundsChanged event, it also sends along a parameter containing attributes of the event (kEventParamAttributes). You can use these attributes to determine what aspect of the window changed (origin, size, or both), and whether or not some user action is driving the change (drag, resize, or zoom).*/
enum {
   kWindowBoundsChangeUserDrag = (1 << 0),
   kWindowBoundsChangeUserResize = (1 << 1),
   kWindowBoundsChangeSizeChanged = (1 << 2),
   kWindowBoundsChangeOriginChanged = (1 << 3),
   kWindowBoundsChangeZoom = (1 << 4)
};



/*Window Click Event Constants

Define constants related to events from kEventClassWindow occurring in the standard window controls or regions (close, resize, drag, and so on).

enum {
   kEventWindowClickDragRgn = 32,
   kEventWindowClickResizeRgn = 33,
   kEventWindowClickCollapseRgn = 34,
   kEventWindowClickCloseRgn = 35,
   kEventWindowClickZoomRgn = 36,
   kEventWindowClickContentRgn = 37,
   kEventWindowClickProxyIconRgn = 38,
   kEventWindowClickToolbarButtonRgn = 41,
   kEventWindowClickStructureRgn = 42
};
Constants
kEventWindowClickDragRgn

Sent when the mouse is down in the drag region. The standard window handler calls DragWindow.

Available in Mac OS X v10.0 and later.
kEventWindowClickResizeRgn

Sent when the mouse is down in the resize area. The standard window handler calls ResizeWindow.

Available in Mac OS X v10.0 and later.
kEventWindowClickCollapseRgn

Sent when the mouse is down in the collapse widget. The default behavior is to call CollapseWindow, and then generate kEventWindowExpand or kEventWindowCollapse (whichever is the opposite of the window’s original collapse state).

Available in Mac OS X v10.0 and later.
kEventWindowClickCloseRgn

Sent when the mouse is down in the close widget. The standard window handler calls TrackGoAway, and then generates kEventWindowClose.

Available in Mac OS X v10.0 and later.
kEventWindowClickZoomRgn

Sent when the mouse is down in the zoom widget. The standard window handler calls TrackBox, and then generates kEventWindowZoom.

Available in Mac OS X v10.0 and later.
kEventWindowClickContentRgn

Sent when the mouse is down in the content region. The standard window handler checks for contextual menu clicks and clicks on controls, and sends kEventWindowContextualMenuSelect, kEventControlClick, and kEventWindowHandleContentClick events as appropriate.

Available in Mac OS X v10.0 and later.
kEventWindowClickProxyIconRgn

Sent when the mouse is down in the proxy icon. The standard window handler handles proxy icon dragging, and generates proxy icon events.

Available in Mac OS X v10.0 and later.
kEventWindowClickToolbarButtonRgn

Sent when the mouse is down in the toolbar button. The default behavior is to call TrackBox and then generate a kEventWindowToolbarSwitchMode event.

Available in Mac OS X v10.1 and later.
Discussion

Low-level events which generate higher-level “action” events described in “Window Action Event Constants”. These events are generated only for windows with the standard window handler installed. Most clients should allow the standard window handler to implement these events.*/
enum {
   kEventWindowClickDragRgn = 32,
   kEventWindowClickResizeRgn = 33,
   kEventWindowClickCollapseRgn = 34,
   kEventWindowClickCloseRgn = 35,
   kEventWindowClickZoomRgn = 36,
   kEventWindowClickContentRgn = 37,
   kEventWindowClickProxyIconRgn = 38,
   kEventWindowClickToolbarButtonRgn = 41,
   kEventWindowClickStructureRgn = 42
};


/*Window Activation Event Constants

Define constants related to events from kEventClassWindow that specify whether a window is activated or deactivated.

enum {
   kEventWindowActivated = 5,
   kEventWindowDeactivated = 6,
   kEventWindowHandleActivate = 91,
   kEventWindowHandleDeactivate = 92
   kEventWindowGetClickActivation = 7,
   kEventWindowGetClickModality = 8
};
Constants
kEventWindowActivated

The window is active now. Sent to any window that is activated, regardless of whether the window has the standard window handler installed. 

In Mac OS X v10.3 and later, the standard window handler responds to this event by sending a kEventWindowHandleActivate event to the window. On earlier releases of Mac OS X and CarbonLib, the standard window handler calls ActivateControl on the window’s root control. 

Note that this event is sent directly to the window target. If no handler takes the event (that is, they all return eventNotHandledErr), then the Window Manager posts this event to the event queue. Doing so allows the Carbon Event Manager to convert the event into an old-style event record (EventRecord), to be returned from WaitNextEvent.

Available in Mac OS X v10.0 and later.
kEventWindowDeactivated

The window is inactive now. Sent to any window that is deactivated, regardless of whether the window has the standard window handler installed.

In Mac OS X v10.3 and later, the standard window handler responds to this event by sending a kEventWindowHandleDeactivate event to the window. On earlier releases of Mac OS X and CarbonLib, the standard window handler calls DeactivateControl on the window’s root control.

Note that this event is sent directly to the window target. If no handler takes the event (that is, they all return eventNotHandledErr), then the Window Manager posts this event to the event queue. Doing so allows the Carbon Event Manager to convert the event into an old-style event record (EventRecord), to be returned from WaitNextEvent.

Available in Mac OS X v10.0 and later.
kEventWindowHandleActivate

The window has received a kEventWindowActivated event, and its contents should become active. This event is generated by the standard window handler in response to a kEventWindowActivated event. You can handle this event by activating the window’s content appropriately. The standard window handler responds to this event by calling ActivateControl on the window’s root control.

(Available in Mac OS X v10.3 and later.)

Available in Mac OS X v10.4 and later.
kEventWindowHandleDeactivate

The window has received a kEventWindowDeactivated event, and its contents should become inactive. This event is generated by the standard window handler in response to a kEventWindowDeactivated event. You can handle this event by deactivating the window’s content appropriately. The standard window handler responds to this event by calling DeactivateControl on the window’s root control.

(Available in Mac OS X v10.3 and later.)

Available in Mac OS X v10.4 and later.
kEventWindowGetClickActivation

Sent when a click occurs in a background window that has the standard window handler installed.

The default behavior is to bring the window forward and absorb the click (that is, the mouse click is not passed on to the window). In addition, the appropriate click activation part code is returned in the kEventParamClickActivationResult parameter. You can use this event to override this behavior and implement click-through.

Available in Mac OS X v10.0 and later.
kEventWindowGetClickModality

Sent to a window by the event dispatcher target before dispatching a mouse-down or mouse-up event to the clicked window. A handler for this event may examine application state to determine whether this click should be allowed. This event may also be sent in circumstances other than a mouse event:
In SelectWindow
When handling the cmd-~ key sequence
When restoring a collapsed window from the Dock
When handling the kHICommandSelectWindow command
When activating a clicked window during application activation, 

In each case, the result of this event is used to determine whether z-ordering, activation, and highlighting of the window should be allowed.

This event contains an optional EventRef parameter that is the original mouse event. If the parameter is not present, the handler should generally assume that the click was a single click.

A default handler for this event is installed on the application target. The default handler determines whether this is a modal click by examining the modality of the visible, uncollapsed windows in front of the clicked window, the location of the click, and the keyboard modifiers. A custom handler may, of course, entirely ignore window z-order or modality, and determine modality in any way it deems necessary.

(Available in Mac OS X v10.4 and later.) 

Available in Mac OS X v10.4 and later.
Discussion

Events related to activating and deactivating a window.*/
enum {
   kEventWindowActivated = 5,
   kEventWindowDeactivated = 6,
   kEventWindowHandleActivate = 91,
   kEventWindowHandleDeactivate = 92,
   kEventWindowGetClickActivation = 7,
   kEventWindowGetClickModality = 8
};



/*Text Input Event Parameters

Define constants for parameters to text input events.

enum {
   kEventParamTextInputSendRefCon = 'tsrc',
   kEventParamTextInputSendComponentInstance = 'tsci',
   kEventParamTextInputSendSLRec = 'tssl',
   kEventParamTextInputReplySLRec = 'trsl',
   kEventParamTextInputSendText = 'tstx',
   kEventParamTextInputReplyText = 'trtx',
   kEventParamTextInputSendUpdateRng = 'tsup',
   kEventParamTextInputSendHiliteRng = 'tshi',
   kEventParamTextInputSendClauseRng = 'tscl',
   kEventParamTextInputSendPinRng = 'tspn',
   kEventParamTextInputSendFixLen = 'tsfx',
   kEventParamTextInputSendLeadingEdge = 'tsle',
   kEventParamTextInputReplyLeadingEdge = 'trle',
   kEventParamTextInputSendTextOffset = 'tsto',
   kEventParamTextInputReplyTextOffset = 'trto',
   kEventParamTextInputReplyRegionClass = 'trrg',
   kEventParamTextInputSendCurrentPoint = 'tscp',
   kEventParamTextInputSendDraggingMode = 'tsdm',
   kEventParamTextInputReplyPoint = 'trpt',
   kEventParamTextInputReplyFont = 'trft',
   kEventParamTextInputReplyFMFont = 'trfm',
   kEventParamTextInputReplyPointSize = 'trpz',
   kEventParamTextInputReplyLineHeight = 'trlh',
   kEventParamTextInputReplyLineAscent = 'trla',
   kEventParamTextInputReplyTextAngle = 'trta',
   kEventParamTextInputSendShowHide = 'tssh',
   kEventParamTextInputReplyShowHide = 'trsh',
   kEventParamTextInputSendKeyboardEvent = 'tske',
   kEventParamTextInputSendTextServiceEncoding = 'tsse',
   kEventParamTextInputSendTextServiceMacEncoding = 'tssm',
   kEventParamTextInputGlyphInfoArray = 'glph',
   kEventParamTextInputSendGlyphInfoArray =  kEventParamTextInputGlyphInfoArray,
   kEventParamTextInputReplyGlyphInfoArray = 'rgph',
   kEventParamTextInputSendReplaceRange = 'tsrp'
};
Constants
kEventParamTextInputSendRefCon

typeLongInteger

Available in Mac OS X v10.0 and later.
kEventParamTextInputSendComponentInstance

typeComponentInstance

Available in Mac OS X v10.0 and later.
kEventParamTextInputSendSLRec

typeIntlWritingCode

Available in Mac OS X v10.0 and later.
kEventParamTextInputReplySLRec

typeIntlWritingCode

Available in Mac OS X v10.0 and later.
kEventParamTextInputSendText

typeUnicodeText (if TSMDocument is Unicode), otherwise typeChar

Available in Mac OS X v10.0 and later.
kEventParamTextInputReplyText

typeUnicodeText (if TSMDocument is Unicode), otherwise typeChar

Available in Mac OS X v10.0 and later.
kEventParamTextInputSendUpdateRng

typeTextRangeArray

Available in Mac OS X v10.0 and later.
kEventParamTextInputSendHiliteRng

typeTextRangeArray

Available in Mac OS X v10.0 and later.
kEventParamTextInputSendClauseRng

typeOffsetArray

Available in Mac OS X v10.0 and later.
kEventParamTextInputSendPinRng

typeTextRange

Available in Mac OS X v10.0 and later.
kEventParamTextInputSendFixLen

typeLongInteger

Available in Mac OS X v10.0 and later.
kEventParamTextInputSendLeadingEdge

typeBoolean

Available in Mac OS X v10.0 and later.
kEventParamTextInputReplyLeadingEdge

typeBoolean

Available in Mac OS X v10.0 and later.
kEventParamTextInputSendTextOffset

typeLongInteger

Available in Mac OS X v10.0 and later.
kEventParamTextInputReplyTextOffset

typeLongInteger

Available in Mac OS X v10.0 and later.
kEventParamTextInputReplyRegionClass

typeLongInteger

Available in Mac OS X v10.0 and later.
kEventParamTextInputSendCurrentPoint

typeQDPoint

Available in Mac OS X v10.0 and later.
kEventParamTextInputSendDraggingMode

typeBoolean

Available in Mac OS X v10.0 and later.
kEventParamTextInputReplyPoint

typeQDPoint

Available in Mac OS X v10.0 and later.
kEventParamTextInputReplyFont

typeLongInteger

Available in Mac OS X v10.0 and later.
kEventParamTextInputReplyFMFont

typeUInt32

Available in Mac OS X v10.1 and later.
kEventParamTextInputReplyPointSize

typeFixed

Available in Mac OS X v10.0 and later.
kEventParamTextInputReplyLineHeight

typeShortInteger

Available in Mac OS X v10.0 and later.
kEventParamTextInputReplyLineAscent

typeShortInteger

Available in Mac OS X v10.0 and later.
kEventParamTextInputReplyTextAngle

typeFixed

Available in Mac OS X v10.0 and later.
kEventParamTextInputSendShowHide

typeBoolean

Available in Mac OS X v10.0 and later.
kEventParamTextInputReplyShowHide

typeBoolean

Available in Mac OS X v10.0 and later.
kEventParamTextInputSendKeyboardEvent

typeEventRef

Available in Mac OS X v10.0 and later.
kEventParamTextInputSendTextServiceEncoding

typeUInt32

Available in Mac OS X v10.0 and later.
kEventParamTextInputSendTextServiceMacEncoding

typeUInt32

Available in Mac OS X v10.0 and later.
kEventParamTextInputReplyGlyphInfoArray

typeGlyphInfoArray

Available in Mac OS X v10.3 and later.
kEventParamTextInputSendReplaceRange

typeCFRange

Available in Mac OS X v10.3 and later.*/

enum {
   kEventParamTextInputSendRefCon = 'tsrc',
   kEventParamTextInputSendComponentInstance = 'tsci',
   kEventParamTextInputSendSLRec = 'tssl',
   kEventParamTextInputReplySLRec = 'trsl',
   kEventParamTextInputSendText = 'tstx',
   kEventParamTextInputReplyText = 'trtx',
   kEventParamTextInputSendUpdateRng = 'tsup',
   kEventParamTextInputSendHiliteRng = 'tshi',
   kEventParamTextInputSendClauseRng = 'tscl',
   kEventParamTextInputSendPinRng = 'tspn',
   kEventParamTextInputSendFixLen = 'tsfx',
   kEventParamTextInputSendLeadingEdge = 'tsle',
   kEventParamTextInputReplyLeadingEdge = 'trle',
   kEventParamTextInputSendTextOffset = 'tsto',
   kEventParamTextInputReplyTextOffset = 'trto',
   kEventParamTextInputReplyRegionClass = 'trrg',
   kEventParamTextInputSendCurrentPoint = 'tscp',
   kEventParamTextInputSendDraggingMode = 'tsdm',
   kEventParamTextInputReplyPoint = 'trpt',
   kEventParamTextInputReplyFont = 'trft',
   kEventParamTextInputReplyFMFont = 'trfm',
   kEventParamTextInputReplyPointSize = 'trpz',
   kEventParamTextInputReplyLineHeight = 'trlh',
   kEventParamTextInputReplyLineAscent = 'trla',
   kEventParamTextInputReplyTextAngle = 'trta',
   kEventParamTextInputSendShowHide = 'tssh',
   kEventParamTextInputReplyShowHide = 'trsh',
   kEventParamTextInputSendKeyboardEvent = 'tske',
   kEventParamTextInputSendTextServiceEncoding = 'tsse',
   kEventParamTextInputSendTextServiceMacEncoding = 'tssm',
   kEventParamTextInputGlyphInfoArray = 'glph',
   kEventParamTextInputSendGlyphInfoArray =  kEventParamTextInputGlyphInfoArray,
   kEventParamTextInputReplyGlyphInfoArray = 'rgph',
   kEventParamTextInputSendReplaceRange = 'tsrp'
};


/*Text Input Event Constants

Define constants related to events from kEventClassTextInput.

enum {
   kEventTextInputUpdateActiveInputArea = 1,
   kEventTextInputUnicodeForKeyEvent = 2,
   kEventTextInputOffsetToPos = 3,
   kEventTextInputPosToOffset = 4,
   kEventTextInputShowHideBottomWindow = 5,
   kEventTextInputGetSelectedText = 6,
   kEventTextInputUnicodeText = 7,
   kEventTextInputFilterText = 14
};
Constants
kEventTextInputUpdateActiveInputArea

Tells the application text engine to initiate or terminate or manage the content of inline input session. 

Available in Mac OS X v10.0 and later.
kEventTextInputUnicodeForKeyEvent

Provides Unicode text resulting from a key event (in which TSM originates the event) or from a kEventTextInputUnicodeText event produced by an input method, such as the Character Palette class input method, or a Handwriting input method. A client need not be fully TSM-aware to process or receive this event, which has become the standard way of getting Unicode text from key events. You can also get Mac encoding characters from the raw keyboard event contained in this event. If no UnicodeForKeyEvent handler is installed, and no kUnicodeNotFromInputMethod AppleEvent handler is installed (or the application has not created a Unicode TSMDocument), the Mac encoding charCodes (if these can be converted from the Unicodes) are provided to WaitNextEvent. This event is generated automatically by TSM when a kEventRawKeyDown event is sent to the application event target. The typical keyboard event flow begins with a kEventRawKeyDown event posted to the event queue. This event is dequeued during WaitNextEvent or RunApplicationEventLoop, and sent to the event dispatcher target. If the key down event reaches the application target, it is handled by TSM, which generates a kEventTextInputUnicodeForKeyEvent event and sends it to the event dispatcher target. The event dispatcher resends the event to the user focus target, which sends it to the focused window.

Available in Mac OS X v10.0 and later.
kEventTextInputOffsetToPos

Convert from inline session text offset to global QD Point. This event is typically produced by an input method so that it can best position a palette “near” the text being operated on by the user.

Available in Mac OS X v10.0 and later.
kEventTextInputPosToOffset

Convert from global QD point to inline session text offset. This event is typically produced by an input method to perform proper cursor management as the cursor moves over various subranges, or clauses of text (or the boundaries between these) in the inline input session. 

Available in Mac OS X v10.0 and later.
kEventTextInputShowHideBottomWindow

Show/Hide the bottom line input window. This event is produced by Input Methods to control the Text Services Manager bottom-line input window, and is not normally handled by an application. 

Available in Mac OS X v10.0 and later.
kEventTextInputGetSelectedText

Get the selected text (or the character before or after the insertion point, based on the value of the leadingEdge parameter) from the application’s text engine.)

Available in Mac OS X v10.0 and later.
kEventTextInputUnicodeText

Produced only by input methods or other text services and is delivered to the Text Services Manager by SendTextInputEvent. The Text Services Manager does not dispatch this event to the user focus, so application handlers should not install handlers for this event. Instead, the Text Services Manager chains this event into any active keyboard input method in order to prevent interference with existing inline input sessions. The keyboard input method can either insert the text into the inline session or confirm its session and return the UnicodeText event to the Text Services Manager unhandled, in which case the Text Services Manager converts the event into a UnicodeForKey event (converting the Unicodes to Mac character codes and synthesizing information where needed) and finally dispatch the resulting event to the user focus as usual. (Available in Mac OS X v10.2 and later.)

Available in Mac OS X v10.2 and later.
kEventTextInputFilterText

Sent before any final-form text is sent to the user focus. Final form text includes text produced by a keyboard layout, Ink input method, Character palette or any other Text Services Manager text service, and any text being “confirmed” (or committed) from an inline input session. In the case of text confirmed from an inline input session, the Text Services Manager takes the resulting text buffer filtered by the event handler and adjusts all parameters in the UpdateActiveInputArea event produced by the input method. The text filtering action is thus transparent to both the application’s UpdateActiveInputArea handler and the input method confirming the text.

Available in Mac OS X v10.4 and later.
Discussion

The following text input events reimplement the Apple events defined in the Text Services Manager Reference, and provide the benefits of Carbon event targeting, dispatching and propagation to applications that have formerly handled the Text Services Manager suite of Apple events. You can install text input handlers on controls, windows, or the application event target (which is equivalent to Apple-event-based handling). In all cases, if a given text input handler is not installed, the Text Services Manager converts the event into an AppleEvent and redispatches it via AESend to the current process, making adoption as gradual as is desired.

Table 10 shows the parameters related to text input events.
Table 10  Required parameter names and types for text input event kinds 
Event kind	
Parameter name	
Parameter type

kEventTextInputUpdateActive InputArea	
kEventParamTextInputSendComponent Instance	
typeComponentInstance

	
kEventParamTextInputSendRefCon	
typeLongInteger

	
kEventParamTextInputSendSLRec	
typeIntlWritingCode

	
kEventParamTextInputSendFixLen	
typeLongInteger

	
kEventParamTextInputSendText	
typeUnicodeText for a Unicode document; typeChar otherwise

kEventTextInputUnicodeFor KeyEvent	
kEventParamTextInputSendComponent Instance	
typeComponentInstance

	
kEventParamTextInputSendRefCon	
typeLongInteger

	
kEventParamTextInputSendSLRec	
typeIntlWritingCode

	
kEventParamTextInputSendText	
typeUnicodeText

	
kEventParamTextInputSendKeyboard Event	
typeEventRef

kEventTextInputOffsetToPos	
kEventParamTextInputSendComponent Instance	
typeComponentInstance

	
kEventParamTextInputSendRefCon	
typeLongInteger

	
kEventParamTextInputSendText Offset	
typeLongInteger

	
kEventParamTextInputReplyPoint	
typeQDPoint

	
kEventParamTextInputSendSLRec (Optional)	
typeIntlWritingCode

	
kEventParamTextInputSendLeading Edge (Optional)	
typeBoolean

	
kEventParamTextInputSendReplySL Rec (Optional)	
typeIntlWritingCode

	
kEventParamTextInputSendReplyFont (Optional)	
typeLongInteger

	
kEventParamTextInputSendReplyFM Font (Optional)	
typeUInt32

	
kEventParamTextInputSendReply PointSize (Optional)	
typeFixed

	
kEventParamTextInputSendReplyLine Height (Optional)	
typeShortInteger

	
kEventParamTextInputSendReplyLine Ascent (Optional)	
typeShortInteger

	
kEventParamTextInputSendReplyText Angle (Optional)	
typeFixed

kEventTextInputPosToOffset	
kEventParamTextInputSendComponent Instance	
typeComponentInstance

	
kEventParamTextInputSendRefCon	
typeLongInteger

	
kEventParamTextInputSendCurrent Point	
typeQDPoint

	
kEventParamTextInputReplyRegion Class	
typeLongInteger

	
kEventParamTextInputReplyText Offset	
typeLongInteger

	
kEventParamTextInputSendDragging Mode (Optional)	
typeBoolean

	
kEventParamTextInputReplyLeading Edge (Optional)	
typeBoolean

	
kEventParamTextInputSendReplySL Rec (Optional)	
typeIntlWritingCode

kEventTextInputShowHide BottomWindow	
kEventParamTextInputSendComponent Instance	
typeComponentInstance

	
kEventParamTextInputSendRefCon	
typeLongInteger

	
kEventParamTextInputSendShowHide (Optional)	
typeBoolean

	
kEventParamTextInputReplyShowHide (Optional)	
typeBoolean

kEventTextInputGetSelected Text	
kEventParamTextInputSendComponent Instance	
typeComponentInstance

	
kEventParamTextInputSendRefCon	
typeLongInteger

	
kEventParamTextInputSendLeading Edge (Optional)	
typeBoolean

	
kEventParamTextInputSendText ServiceEncoding (Optional)	
TypeUInt32

	
kEventParamTextInputSendText ServiceMacEncoding (Optional)	
TypeUInt32

	
kEventParamTextInputReplyText (Optional)	
typeUnicodeText or typeChar depending on the TSMDocument type.

	
kEventParamTextInputSendReplySL Rec (Optional)	
typeIntlWritingCode

	
kEventParamTextInputGlyphInfo Array (Optional)	
TypeGlyphInfoArray

kEventTextInputUnicodeText	
kEventParamTextInputSendComponent Instance	
typeComponentInstance

	
kEventParamTextInputSendSLRec	
typeIntlWritingCode

	
kEventParamTextInputSendText	
typeUnicodeText

	
kEventParamTextInputSendText ServiceEncoding (Optional)	
TypeUInt32

	
kEventParamTextInputSendText ServiceMacEncoding (Optional)	
TypeUInt32

	
kEventParamTextInputGlyphInfo Array (Optional)	
TypeGlyphInfoArray

kEventTextInputFilterText	
kEventParamTextInputSendRefCon	
typeLongInteger

	
kEventParamTextInputSendText	
typeUnicodeText

	
kEventParamTextInputReplyText	
typeUnicodeText*/

enum {
   kEventTextInputUpdateActiveInputArea = 1,
   kEventTextInputUnicodeForKeyEvent = 2,
   kEventTextInputOffsetToPos = 3,
   kEventTextInputPosToOffset = 4,
   kEventTextInputShowHideBottomWindow = 5,
   kEventTextInputGetSelectedText = 6,
   kEventTextInputUnicodeText = 7,
   kEventTextInputFilterText = 14
};




/*Window Refresh Event Constants

Define constants related to window refresh events from kEventClassWindow.

enum {
   kEventWindowUpdate = 1,
   kEventWindowDrawContent = 2
};
Constants
kEventWindowUpdate

Low-level update event. Sent to any window that needs updating regardless of whether the window has the standard window handler installed. You must call the Window Manager function BeginUpdate, and the QuickDraw function SetPort before drawing your window content, then call EndUpdate when you are finished.

The standard window handler for this event calls BeginUpdate and SetPort, sends a kEventWindowDrawContent event to the window, and then calls EndUpdate. 

Note that this event is sent directly to the window target. If no handler takes the event (that is, they all return eventNotHandledErr), then the Window Manager posts this event to the event queue. Doing so allows the Carbon Event Manager to convert the event into an old-style event record (EventRecord), to be returned from WaitNextEvent.

Available in Mac OS X v10.0 and later.
kEventWindowDrawContent

Higher-level update event sent only if you have the standard window handler installed. Functions exactly as kEventWindowUpdate, except that the Carbon Event Manager calls Begin/EndUpdate and SetPort for you. All you need to do is draw the window content.

The standard window handler calls DrawControls for this window. 

Available in Mac OS X v10.0 and later.
Discussion

Events related to drawing a window’s content.

Table 14 shows the parameters related to window refresh events.
Table 14  Parameter names and types for window refresh event kinds
Event kind	
Parameter name	
Parameter type

kEventWindowUpdate	
kEventParamDirectObject	
typeWindowRef

kEventWindowDrawContent	
kEventParamDirectObject	
typeWindowRef*/
enum {
   kEventWindowUpdate = 1,
   kEventWindowDrawContent = 2
};

/*Window Event Parameters and Types

Define constants for parameters and attributes related to window events. 

enum {
   kEventParamWindowFeatures = 'wftr',
   kEventParamWindowDefPart = 'wdpc',
   kEventParamWindowPartCode = wpar',
   kEventParamCurrentBounds = 'crct',
   kEventParamOriginalBounds = 'orct',
   kEventParamPreviousBounds = 'prct',
   kEventParamClickActivation = 'clac',
   kEventParamWindowRegionCode = 'wshp',
   kEventParamWindowDragHiliteFlag = 'wdhf',
   kEventParamWindowModifiedFlag = 'wmff',
   kEventParamWindowProxyGWorldPtr = 'wpgw',
   kEventParamWindowProxyImageRgn = 'wpir',
   kEventParamWindowProxyOutlineRgn = 'wpor',
   kEventParamWindowStateChangedFlags = 'wscf',
   kEventParamWindowTitleFullWidth = 'wtfw',
   kEventParamWindowTitleTextWidth = 'wttw',
   kEventParamWindowGrowRect = 'grct',
   kEventParamPreviousDockRect = 'pdrc',
   kEventParamPreviousDockDevice = 'pdgd',
   kEventParamCurrentDockRect = 'cdrc',
   kEventParamCurrentDockDevice = 'cdgd',
   kEventParamWindowTransitionAction = 'wtac',
   kEventParamWindowTransitionEffect = 'wtef',
   typeWindowRegionCode = 'wshp',
   typeWindowDefPartCode = 'wdpt',
   typeClickActivationResult = 'clac',
   typeWindowTransitionAction = 'wtac',
   typeWindowTransitionEffect = 'wtef'
};
Constants
kEventParamWindowFeatures

typeUInt32

Available in Mac OS X v10.0 and later.
kEventParamWindowDefPart

typeWindowDefPartCode

Available in Mac OS X v10.0 and later.
kEventParamWindowPartCode

typeWindowPartCode

Available in Mac OS X v10.3 and later.
kEventParamCurrentBounds

typeQDRectangle

Available in Mac OS X v10.0 and later.
kEventParamOriginalBounds

typeQDRectangle

Available in Mac OS X v10.0 and later.
kEventParamPreviousBounds

typeQDRectangle

Available in Mac OS X v10.0 and later.
kEventParamClickActivation

typeClickActivationResult

Available in Mac OS X v10.0 and later.
kEventParamWindowRegionCode

typeWindowRegionCode

Available in Mac OS X v10.0 and later.
kEventParamWindowDragHiliteFlag

typeBoolean

Available in Mac OS X v10.0 and later.
kEventParamWindowModifiedFlag

typeBoolean

Available in Mac OS X v10.0 and later.
kEventParamWindowProxyGWorldPtr

typeGWorldPtr

Available in Mac OS X v10.0 and later.
kEventParamWindowProxyImageRgn

typeQDRgnHandle

Available in Mac OS X v10.0 and later.
kEventParamWindowProxyOutlineRgn

typeQDRgnHandle

Available in Mac OS X v10.0 and later.
kEventParamWindowStateChangedFlags

typeUInt32 

Available in Mac OS X v10.0 and later.
kEventParamWindowTitleFullWidth

typeSInt16

Available in Mac OS X v10.0 and later.
kEventParamWindowTitleTextWidth

typeSInt16

Available in Mac OS X v10.0 and later.
kEventParamWindowGrowRect

typeQDRectangle

Available in Mac OS X v10.0 and later.
kEventParamPreviousDockRect

typeHIRect

Available in Mac OS X v10.2 and later.
kEventParamPreviousDockDevice

typeGDHandle

Available in Mac OS X v10.3 and later.
kEventParamCurrentDockRect

typeHIRect

Available in Mac OS X v10.2 and later.
kEventParamCurrentDockDevice

typeGDHandle

Available in Mac OS X v10.3 and later.
kEventParamWindowTransitionAction

typeWindowTransitionAction

Available in Mac OS X v10.3 and later.
kEventParamWindowTransitionEffect

typeWindowTransitionEffect

Available in Mac OS X v10.3 and later.
typeWindowRegionCode

WindowRegionCode

Available in Mac OS X v10.0 and later.
typeWindowDefPartCode

WindowDefPartCode

Available in Mac OS X v10.0 and later.
typeWindowPartCode

WindowPartCode

Available in Mac OS X v10.3 and later.
typeClickActivationResult

ClickActivationResult

Available in Mac OS X v10.0 and later.
typeWindowTransitionAction

WindowTransitionAction

Available in Mac OS X v10.3 and later.
typeWindowTransitionEffect

WindowTransitionEffect

Available in Mac OS X v10.3 and later.*/

enum {
   kEventParamWindowFeatures = 'wftr',
   kEventParamWindowDefPart = 'wdpc',
   kEventParamWindowPartCode = 'wpar',
   kEventParamCurrentBounds = 'crct',
   kEventParamOriginalBounds = 'orct',
   kEventParamPreviousBounds = 'prct',
   kEventParamClickActivation = 'clac',
   kEventParamWindowRegionCode = 'wshp',
   kEventParamWindowDragHiliteFlag = 'wdhf',
   kEventParamWindowModifiedFlag = 'wmff',
   kEventParamWindowProxyGWorldPtr = 'wpgw',
   kEventParamWindowProxyImageRgn = 'wpir',
   kEventParamWindowProxyOutlineRgn = 'wpor',
   kEventParamWindowStateChangedFlags = 'wscf',
   kEventParamWindowTitleFullWidth = 'wtfw',
   kEventParamWindowTitleTextWidth = 'wttw',
   kEventParamWindowGrowRect = 'grct',
   kEventParamPreviousDockRect = 'pdrc',
   kEventParamPreviousDockDevice = 'pdgd',
   kEventParamCurrentDockRect = 'cdrc',
   kEventParamCurrentDockDevice = 'cdgd',
   kEventParamWindowTransitionAction = 'wtac',
   kEventParamWindowTransitionEffect = 'wtef',
   typeWindowRegionCode = 'wshp',
   typeWindowDefPartCode = 'wdpt',
   typeClickActivationResult = 'clac',
   typeWindowTransitionAction = 'wtac',
   typeWindowTransitionEffect = 'wtef'
};



/*Menu Event Constants

Define constants related to events from kEventClassMenu.

enum {
   kEventMenuBeginTracking = 1,
   kEventMenuEndTracking = 2,
   kEventMenuChangeTrackingMode = 3,
   kEventMenuOpening = 4,
   kEventMenuClosed = 5,
   kEventMenuTargetItem = 6,
   kEventMenuMatchKey = 7,
   kEventMenuEnableItems = 8,
   kEventMenuPopulate = 9,
   kEventMenuMeasureItemWidth = 100,
   kEventMenuMeasureItemHeight = 101,
   kEventMenuDrawItem = 102,
   kEventMenuDrawItemContent = 103,
   kEventMenuDispose = 1001,
   kEventMenuCalculateSize = 1004,
   kEventMenuCreateFrameView = 1005,
   kEventMenuGetFrameBounds = 1006,
   kEventMenuBecomeScrollable = 1007,
   kEventMenuCeaseToBeScrollable = 1008,
   kEventMenuBarShown = 2000,
   kEventMenuBarHidden = 2001
};
Constants
kEventMenuBeginTracking

The user has begun tracking the menubar or a pop-up menu. The direct object parameter is a valid menu reference if tracking a pop-up menu, or NULL if tracking the menubar. The kEventParamCurrentMenuTrackingMode parameter indicates whether the user is tracking the menus using the mouse or the keyboard. The handler may return userCanceledErr to stop menu tracking. (Available in CarbonLib 1.1 and Mac OS X v10.0 and later.)

Available in Mac OS X v10.0 and later.
kEventMenuEndTracking

The user has finished tracking the menubar or a pop-up menu. In Mac OS X v10.3 and later, when a menu tracking session ends, the Menu Manager sends kEventMenuEndTracking to every menu that was opened during the session, in addition to the root menu. This is done to allow menus with dynamic content to remove that content at the end of menu tracking; for example, a menu containing many IconRefs might want to load the IconRefs dynamically in response to the kEventMenuMenuPopulate event and remove them in response to the kEventMenuEndTracking event to avoid the memory overhead of keeping the IconRef data in memory while the menu is not being displayed. (Available in CarbonLib 1.1 and Mac OS X v10.0 and later.)

Available in Mac OS X v10.0 and later.
kEventMenuChangeTrackingMode

The user has switched from selecting a menu with the mouse to selecting with the keyboard, or from selecting with the keyboard to selecting with the mouse. (Available in Mac OS X v10.1 and later.)

Available in Mac OS X v10.0 and later.
kEventMenuOpening

A menu is opening. This event is sent each time that the menu is opened (that is, more than once during a given tracking session if the user opens the menu multiple times). It is sent before the menu is actually drawn, so you can update the menu contents (including making changes that will alter the menu size) and the new contents will be drawn correctly. The kEventParamMenuFirstOpen parameter indicates whether this is the first time this menu has been opened during this menu tracking session. The handler may return userCanceledErr to prevent this menu from opening. Note that for most applications, you should handle the kEventMenuPopulate event instead. (Available in CarbonLib 1.1 and Mac OS X v10.0 and later.)

Available in Mac OS X v10.0 and later.
kEventMenuClosed

A menu has been closed. Sent after the menu is hidden. (Available in CarbonLib 1.1 and later and Mac OS X v10.0 and later.)

Available in Mac OS X v10.0 and later.
kEventMenuTargetItem

The mouse is moving over a particular menu item. This event is sent for both enabled and disabled items. (Available in CarbonLib 1.1 and later and Mac OS X v10.0 and later.)

Available in Mac OS X v10.0 and later.
kEventMenuMatchKey

A menu is about to be examined for items that match a command key event. A handler for this event may perform its own command key matching and override the Menu Manager’s default matching algorithms. Returning noErr from your handler indicates that you have found a match. The handler for this event should not examine submenus of this menu for a match; a separate event will be sent for each submenu. 

When called from IsMenuKeyEvent, the kEventParamEventRef parameter contains the event reference that was passed to IsMenuKeyEvent, for your handler to examine; when called from MenuKey or MenuEvent, the EventRef parameter contains an event created from the information passed to MenuKey or MenuEvent. Note that in the MenuKey case, no virtual key code (kEventParamKeyCode) or key modifiers (kEventParamKeyModifiers) will be available.

The kEventParamMenuEventOptions parameter contains a copy of the options that were passed to IsMenuKeyEvent, or 0 if called from MenuKey or MenuEvent. The only option that your handler will need to obey is kMenuEventIncludeDisabledItems. 

If your handler finds a match, it should set the kEventParamMenuItemIndex parameter to contain the item index of the matching item, and return noErr. If it does not find a match, it should return menuItemNotFoundErr. Any other return value will cause the Menu Manager to use its default command key matching algorithm for this menu.

This event is sent after kEventMenuEnableItems.

In CarbonLib and Mac OS X through version 10.3, the Menu Manager sends a kEventMenuEnableItems event to the menu before sending kEventMenuMatchKey. In Mac OS X 10.4 and later, the Menu Manager no longer sends kEventMenuEnableItems (or the resulting kEventCommandUpdateStatus events) to the menu; a handler for kEventMenuMatchKey is expected to determine on its own whether a matching menu item is enabled.

Available in Mac OS X v10.0 and later.
kEventMenuEnableItems

A request that the items in the menu be properly enabled or disabled according to the current state of the application. This event is sent from inside MenuKey, MenuEvent, and IsMenuKeyEvent before those functions examine the menu for an item that matches a keyboard event. It is also sent during menu tracking before a menu is first made visible; it is sent right after kEventMenuOpening, once per menu per menu tracking session.

If you install an event handler for kEventProcessCommand, you should also install a handler for kEventMenuEnableItems. This is necessary because the Carbon event system will attempt to match command keys against the available menus before returning the keyboard event to your application via WaitNextEvent. If you have menu command event handlers installed for your menu items, your handlers will be called without you ever receiving the keyboard event or calling MenuKey/MenuEvent/IsMenuKeyEvent yourself. Therefore, you have no opportunity to enable your menu items properly other than from a kEventMenuEnableItems handler.

It is not necessary to handle this event if you do not install kEventProcessCommand handlers for your menu items; in that case, the command key event will be returned from WaitNextEvent or ReceiveNextEvent as normal, and you can set up your menus before calling MenuKey/MenuEvent/IsMenuKeyEvent. 

The kEventParamEnableMenuForKeyEvent parameter indicates whether this menu should be enabled for key event matching (true) or because the menu itself is about to become visible (false). If true, only the item enable state, command key, command key modifiers, and (optionally) the command key glyph need to be correct. If false, the entire menu item contents must be correct. This may be useful if you have custom menu content that is expensive to prepare.

Note that the standard application handler for kEventMenuEnableItems automatically sends kEventCommandUpdateStatus to your menu commands. As this can cause a performance hit if you have many menu items, you can choose to bypass these updates by installing a no-op handler for kEventMenuEnableItems that simply returns noErr.

(Available in CarbonLib 1.1 and later, and Mac OS X v10.0 and later.) 

Available in Mac OS X v10.0 and later.
kEventMenuPopulate

Sent when an application should dynamically create a menu. You should use this event instead of kEventMenuOpening as the Menu Manager sends it before it searches a menu for a matching command key sequence; therefore you can use this event to dynamically add menu items that have command-key equivalents, making them selectable even if the menu itself is never displayed. The kEventMenuPopulate event is sent just once during a menu tracking session, even if the menu is opened and closed multiple times; the kEventWindowOpening event is sent each time the menu opens.

To determine whether this event was triggered by a command-key sequence, you should examine the kEventParamMenuContext parameter for the kMenuContextKeyMatching flag. If the event corresponds to the actual display of a menu, the kEventContextMenuBarTracking or kEventContextPopUpTracking flags are set.

(Available in CarbonLib 1.5 and later, and Mac OS X v10.1 and later. Note that in CarbonLib 1.6 and Mac OS X v10.2 and later, the Menu Manager sends this event before it searches a menu for a matching command ID. To determine if this event was triggered by a command ID, check for the kMenuContextCommandIDSearch flag in the kEventParamMenuContext parameter. If that flag is set, the command ID that triggered this event is contained in the kEventParamMenuCommand parameter.)

Available in Mac OS X v10.1 and later.
kEventMenuMeasureItemWidth

Sent by the standard window definition if a menu item has the kMenuItemAttrCustomDraw attribute set. You should install your handler directly on the menu. Your handler should return a customized width for the menu item in the kEventParamMenuItemWidth parameter. 

The default behavior (if you are using the standard menu definition) is to return the standard width for the item. 

(Available in CarbonLib 1.5 and later, and Mac OS X v10.1 and later.) 

Available in Mac OS X v10.1 and later.
kEventMenuMeasureItemHeight

Sent by the standard window definition if a menu item has the kMenuItemAttrCustomDraw attribute set. You should install your handler directly on the menu. Your handler should return a customized height for the menu item in the kEventParamMenuItemHeight parameter. 

The default behavior (if you are using the standard menu definition) is to return the standard height for the item. 

(Available in CarbonLib 1.5 and later, and Mac OS X v10.1 and later.) 

Available in Mac OS X v10.1 and later.
kEventMenuDrawItem

Sent by the standard window definition if a menu item has the kMenuItemAttrCustomDraw attribute set. You should install your handler directly on the menu. Use your handler to override the drawing of the menu item and background. 

The default behavior (if you are using the standard menu definition) is to call the Appearance Manager function DrawThemeMenuItem to draw the menu item’s background and content.

If you have the standard event handler installed, the event also contains additional parameters indicating the bounds of the various portions of the menu item content, as well as the baseline of the menu item text. Using these parameters, you can call CallNextEventHandler to let the system handlers draw the standard menu content and then your handler can draw custom content on top.

(Available in CarbonLib 1.5 and later, and Mac OS X v10.1 and later.) 

Available in Mac OS X v10.1 and later.
kEventMenuDrawItemContent

Sent by the standard window definition if a menu item has the kMenuItemAttrCustomDraw attribute set. You should install your handler directly on the menu. You use your handler to override the drawing of one or more parts of the menu item’s content (that is the mark character, icon, text, and command key information).

When you receive this event, the background and highlighting (if applicable) has already been drawn using the standard system appearance. 

The default behavior (if you are using the standard menu definition) is to draw the standard menu item content.

If you have the standard event handler installed, the event also contains additional parameters indicating the bounds of the various portions of the menu item content, as well as the baseline of the menu item text. Using these parameters, you can call CallNextEventHandler to let the system handlers draw the standard menu content and then your handler can draw custom content on top. 

(Available in CarbonLib 1.5 and later, and Mac OS X v10.1 and later.) 

Available in Mac OS X v10.1 and later.
kEventMenuDispose

Sent when a menu is being disposed. (Available in CarbonLib 1.1 and later and Mac OS X v10.0 and later.)

Available in Mac OS X v10.0 and later.
kEventMenuCalculateSize

Sent by CalcMenuSize to request that the menu calculate its size. The Menu Manager provides a default handler for all menus that calls the menu’s MDEF or menu content view to determine the menu size. Applications typically do not need to handle this event. A custom menu definition or menu content view should use kMenuSizeMsg or kEventControlGetOptimalBounds to calculate its size. Note that if the menu uses an MDEF, the MDEF sets the menu’s width and height in response to kMenuSizeMsg. The default handler for this event saves the old width and height before calling the MDEF and restores them afterward. CalcMenuSize sets the final menu width and height based on the dimensions returned from this event; applications may override this event to customize the width or height of a menu by modifying the kEventParamDimensions parameter. This event is sent only to the menu and is not propagated past the menu. (Available in Mac OS X v10.3 and later.)

Available in Mac OS X v10.3 and later.
kEventMenuCreateFrameView

Requests that a menu content view create the HIView that will be used to draw the menu window frame. The HIMenuView class provides a default handler for this event that creates an instance of the standard menu window frame view. This event is sent only to the menu content view and is not propagated past the view. (Available in Mac OS X v10.3 and later.)

Available in Mac OS X v10.3 and later.
kEventMenuGetFrameBounds

Requests that a menu content view calculate the bounding rect, in global coordinates, of the menu window frame that should contain the menu. This event is sent by the Menu Manager before displaying pull-down, popup, and hierarchical menus. It provides an opportunity for the menu content view to determine the position of the menu frame based on the position of the menu title, parent menu item, or popup menu location. The HIMenuView class provides a default handler for this event that calculates an appropriate location based on the bounds of the menu, the available screen space, and the frame metrics of the menu window content view. This event is sent only to the menu content view and is not propagated past the view. (Available in Mac OS X v10.3 and later.)

Available in Mac OS X v10.3 and later.
kEventMenuBecomeScrollable

Requests that a menu content view prepare to be scrollable, which it does by installing the appropriate event handlers, timers, and the like. This event is sent by the Menu Manager when a menu becomes the most recently opened menu in the menu hierarchy. It is an indication that this menu content view is now a candidate for scrolling. The Menu Manager provides a default handler for this event that installs event handlers to provide automatic scrolling behavior for HIView-based menus. If a menu content view does not wish to use the Menu Manager’s default scrolling support, it can override this event and return noErr to prevent the event from being propagated to the Menu Manager’s default handler. This event is sent only to the menu content view and is not propagated past the view. (Available in Mac OS X v10.3 and later.)

Available in Mac OS X v10.3 and later.
kEventMenuCeaseToBeScrollable

Requests that a menu content view cease to be scrollable. This event is sent by the Menu Manager when a menu ceases to be the most recently opened menu. This occurs when the menu is closed, or when a submenu of the most recently opened menu is opened. It is an indication that this menu content view is no longer a candidate for scrolling. The Menu Manager provides a default handler for this event that removes event handlers installed in response to kEventMenuBecomeScrollable. This event is sent only to the menu content view and is not propagated past the view. (Available in Mac OS X v10.3 and later.)

Available in Mac OS X v10.3 and later.
kEventMenuBarShown

Sent to all handlers registered for this event when the front process shows its menubar. This event is sent only to the application target. (Available in Mac OS X v10.3 and later.)

Available in Mac OS X v10.3 and later.
kEventMenuBarHidden

Sent to all handlers registered for this event when the front process hides its menubar. This event is sent only to the application target.(Available in Mac OS X v10.3 and later.)

Available in Mac OS X v10.3 and later.
Discussion

Some menu events are sent or handled by the standard menu definition, which is a collection of handlers that define the default menu behavior. If you have specified a custom menu definition, you will not get the behavior provided by the standard definition.*/
enum {
   kEventMenuBeginTracking = 1,
   kEventMenuEndTracking = 2,
   kEventMenuChangeTrackingMode = 3,
   kEventMenuOpening = 4,
   kEventMenuClosed = 5,
   kEventMenuTargetItem = 6,
   kEventMenuMatchKey = 7,
   kEventMenuEnableItems = 8,
   kEventMenuPopulate = 9,
   kEventMenuMeasureItemWidth = 100,
   kEventMenuMeasureItemHeight = 101,
   kEventMenuDrawItem = 102,
   kEventMenuDrawItemContent = 103,
   kEventMenuDispose = 1001,
   kEventMenuCalculateSize = 1004,
   kEventMenuCreateFrameView = 1005,
   kEventMenuGetFrameBounds = 1006,
   kEventMenuBecomeScrollable = 1007,
   kEventMenuCeaseToBeScrollable = 1008,
   kEventMenuBarShown = 2000,
   kEventMenuBarHidden = 2001
};

/*Menu Event Parameters

Define constants for parameters to menu events.

enum {
   kEventParamCurrentMenuTrackingMode = 'cmtm',
   kEventParamNewMenuTrackingMode = 'nmtm',
   kEventParamMenuFirstOpen = '1sto',
   kEventParamMenuItemIndex = 'item',
   kEventParamMenuCommand = 'mcmd',
   kEventParamEnableMenuForKeyEvent = 'fork',
   kEventParamMenuEventOptions = 'meop',
   kEventParamMenuContext = 'mctx',
   kEventParamMenuItemBounds = 'mitb',
   kEventParamMenuMarkBounds = 'mmkb',
   kEventParamMenuIconBounds = 'micb',
   kEventParamMenuTextBounds = 'mtxb',
   kEventParamMenuTextBaseline = 'mtbl',
   kEventParamMenuCommandKeyBounds = 'mcmb',
   kEventParamMenuVirtualTop = 'mvrt',
   kEventParamMenuVirtualBottom = 'mvrb',
   kEventParamMenuDrawState = 'mdrs',
   kEventParamMenuItemType = 'mitp',
   kEventParamMenuItemWidth = 'mitw',
   kEventParamMenuItemHeight = 'mith',
   typeMenuItemIndex = 'midx',
   typeMenuCommand = 'mcmd',
   typeMenuTrackingMode = 'mtmd',
   typeMenuEventOptions = 'meop',
   typeThemeMenuState = 'tmns',
   typeThemeMenuItemType = 'tmit'
};
Constants
kEventParamCurrentMenuTrackingMode

typeMenuTrackingMode

Available in Mac OS X v10.0 and later.
kEventParamNewMenuTrackingMode

typeMenuTrackingMode

Available in Mac OS X v10.0 and later.
kEventParamMenuFirstOpen

typeBoolean

Available in Mac OS X v10.0 and later.
kEventParamMenuItemIndex

typeMenuItemIndex

Available in Mac OS X v10.0 and later.
kEventParamMenuCommand

typeMenuCommand

Available in Mac OS X v10.0 and later.
kEventParamEnableMenuForKeyEvent

typeBoolean

Available in Mac OS X v10.0 and later.
kEventParamMenuEventOptions

typeMenuEventOptions

Available in Mac OS X v10.0 and later.
typeMenuItemIndex

MenuItemIndex

Available in Mac OS X v10.0 and later.
typeMenuCommand

MenuCommand

Available in Mac OS X v10.0 and later.
typeMenuTrackingMode

MenuTrackingMode

Available in Mac OS X v10.0 and later.
typeMenuEventOptions

MenuEventOptions

Available in Mac OS X v10.0 and later.*/
enum {
   kEventParamCurrentMenuTrackingMode = 'cmtm',
   kEventParamNewMenuTrackingMode = 'nmtm',
   kEventParamMenuFirstOpen = '1sto',
   kEventParamMenuItemIndex = 'item',
   kEventParamMenuCommand = 'mcmd',
   kEventParamEnableMenuForKeyEvent = 'fork',
   kEventParamMenuEventOptions = 'meop',
   kEventParamMenuContext = 'mctx',
   kEventParamMenuItemBounds = 'mitb',
   kEventParamMenuMarkBounds = 'mmkb',
   kEventParamMenuIconBounds = 'micb',
   kEventParamMenuTextBounds = 'mtxb',
   kEventParamMenuTextBaseline = 'mtbl',
   kEventParamMenuCommandKeyBounds = 'mcmb',
   kEventParamMenuVirtualTop = 'mvrt',
   kEventParamMenuVirtualBottom = 'mvrb',
   kEventParamMenuDrawState = 'mdrs',
   kEventParamMenuItemType = 'mitp',
   kEventParamMenuItemWidth = 'mitw',
   kEventParamMenuItemHeight = 'mith',
   typeMenuItemIndex = 'midx',
   typeMenuCommand = 'mcmd',
   typeMenuTrackingMode = 'mtmd',
   typeMenuEventOptions = 'meop',
   typeThemeMenuState = 'tmns',
   typeThemeMenuItemType = 'tmit'
};


/*Mouse Tracking Option Constant

Define options for the TrackMouseLocationWithOptions function.

enum {
   kTrackMouseLocationOptionDontConsumeMouseUp = (1 << 0)
};
Constants
kTrackMouseLocationOptionDontConsumeMouseUp

Leave mouse-up events in the event queue (the default is to pull them.)

Available in Mac OS X v10.0 and later.
Discussion

This constant can be passed to TrackMouseLocationWithOptions in the inOptions parameter.*/
enum {
   kTrackMouseLocationOptionDontConsumeMouseUp = (1 << 0)
};


/*Event Target Parameter

Define constants for a special event target parameter and its type, that you can set for any created event.

enum {
   kEventParamPostTarget = 'ptrg',
   typeEventTargetRef = 'etrg'
};
Constants
kEventParamPostTarget

Specifies the target the event should be sent to. Instead of sending an event directly to a given target, you can set this parameter and post the event onto the event queue. 

Available in Mac OS X v10.2 and later.
typeEventTargetRef

The parameter type for kEventParamPostTarget.

Available in Mac OS X v10.2 and later.*/

enum {
   kEventParamPostTarget = 'ptrg',
   typeEventTargetRef = 'etrg'
};


/*Mouse Events

Define constants related to events from kEventClassMouse.

enum {
   kEventMouseDown = 1,
   kEventMouseUp = 2,
   kEventMouseMoved = 5,
   kEventMouseDragged = 6,
   kEventMouseEntered = 8,
   kEventMouseExited = 9,
   kEventMouseWheelMoved = 10
};
Constants
kEventMouseDown

A mouse button was pressed. Note that if you install a handler for this event on a window, you must allow the event to propagate (either by calling CallNextEventHandler or returning eventNotHandledErr) so that the window can be activated.

Available in Mac OS X v10.0 and later.
kEventMouseUp

A mouse button was released. 

Available in Mac OS X v10.0 and later.
kEventMouseMoved

The mouse moved. 

Available in Mac OS X v10.0 and later.
kEventMouseDragged

The mouse moved, and a button was down. 

Available in Mac OS X v10.0 and later.
kEventMouseEntered

The mouse entered a tracking region. Used with mouse tracking regions. See CreateMouseTrackingRegion for more information.

Available in Mac OS X v10.2 and later.
kEventMouseExited

The mouse left a tracking region. Used with mouse tracking regions. See CreateMouseTrackingRegion for more information.

Available in Mac OS X v10.2 and later.
kEventMouseWheelMoved

The mouse wheel moved. (Mac OS X only)

Available in Mac OS X v10.0 and later.*/
enum {
   kEventMouseDown = 1,
   kEventMouseUp = 2,
   kEventMouseMoved = 5,
   kEventMouseDragged = 6,
   kEventMouseEntered = 8,
   kEventMouseExited = 9,
   kEventMouseWheelMoved = 10
};

/*Tablet Events

Define constants for events related to drawing tablets.

enum {
   kEventTabletPoint = 1,
   kEventTabletProximity = 2,
   kEventTabletPointer = 1
};
Constants
kEventTabletPoint

Indicates that the pen has moved on a tablet. (Mac OS X only) 

Available in Mac OS X v10.1 and later.
kEventTabletProximity

Indicates that the pen has entered the proximity region of the tablet. (Mac OS X only)

Available in Mac OS X v10.0 and later.
kEventTabletPointer

Same as kEventTabletPoint. This deprecated constant is here for compatibility only.

Available in Mac OS X v10.0 and later.*/
enum {
   kEventTabletPoint = 1,
   kEventTabletProximity = 2,
   kEventTabletPointer = 1
};

/*Mouse Event Parameters

Define constants for parameters to mouse events. 

enum {
   kEventParamMouseLocation = 'mloc',
   kEventParamWindowMouseLocation = 'wmou',
   kEventParamMouseButton = 'mbtn',
   kEventParamClickCount = 'ccnt',
   kEventParamMouseWheelAxis = 'mwax',
   kEventParamMouseWheelDelta = 'mwdl',
   kEventParamMouseDelta = 'mdta',
   kEventParamMouseChord = 'chor',
   kEventParamTabletEventType = 'tblt',
   kEventParamMouseTrackingRef = 'mtrf',
   typeMouseButton = 'mbtn',
   typeMouseWheelAxis = 'mwax',
   typeMouseTrackingRef = 'mtrf'
};
Constants
kEventParamMouseLocation

typeQDPoint

Available in Mac OS X v10.0 and later.
kEventParamMouseButton

typeMouseButton

Available in Mac OS X v10.0 and later.
kEventParamClickCount

typeUInt32

Available in Mac OS X v10.0 and later.
kEventParamMouseWheelAxis

typeMouseWheelAxis

Available in Mac OS X v10.0 and later.
kEventParamMouseWheelDelta

typeSInt32

Available in Mac OS X v10.0 and later.
kEventParamMouseDelta

typeQDPoint

Available in Mac OS X v10.0 and later.
kEventParamMouseChord

typeUInt32

Available in Mac OS X v10.1 and later.
typeMouseButton

EventMouseButton

Available in Mac OS X v10.0 and later.
typeMouseWheelAxis

EventMouseWheelAxis

Available in Mac OS X v10.0 and later.*/

enum {
   kEventParamMouseLocation = 'mloc',
   kEventParamWindowMouseLocation = 'wmou',
   kEventParamMouseButton = 'mbtn',
   kEventParamClickCount = 'ccnt',
   kEventParamMouseWheelAxis = 'mwax',
   kEventParamMouseWheelDelta = 'mwdl',
   kEventParamMouseDelta = 'mdta',
   kEventParamMouseChord = 'chor',
   kEventParamTabletEventType = 'tblt',
   kEventParamMouseTrackingRef = 'mtrf',
   typeMouseButton = 'mbtn',
   typeMouseWheelAxis = 'mwax',
   typeMouseTrackingRef = 'mtrf'
};

/*Mouse Tracking Constants

Define constants for mouse tracking.

typedef UInt16 MouseTrackingResult;
enum {
   kMouseTrackingMouseDown = 1,
   kMouseTrackingMouseUp = 2,
   kMouseTrackingMouseExited = 3,
   kMouseTrackingMouseEntered = 4,
   kMouseTrackingMouseDragged = 5,
   kMouseTrackingKeyModifiersChanged = 6,
   kMouseTrackingUserCancelled = 7,
   kMouseTrackingTimedOut = 8,
   kMouseTrackingMouseMoved = 9
};
Constants
kMouseTrackingMouseDown

The user pressed any mouse button.

Available in Mac OS X v10.1 and later.
kMouseTrackingMouseUp

The user released the mouse button.

Available in Mac OS X v10.1 and later.
kMouseTrackingMouseExited

The mouse exited the specified region. 

Available in Mac OS X v10.0 and later.
kMouseTrackingMouseEntered

The mouse entered the specified region. 

Available in Mac OS X v10.0 and later.
kMouseTrackingMouseDragged

The mouse moved while the mouse button was down. 

Available in Mac OS X v10.1 and later.
kMouseTrackingKeyModifiersChanged

One or more keyboard modifiers (option, control, and so on) for the mouse changed. 

Available in Mac OS X v10.0 and later.
kMouseTrackingMouseMoved

Prior to Mac OS X v10.2, this constant was equivalent to kMouseTrackingMouseDragged. In Mac OS X v10.2 and later, kMouseTrackingMouseMoved indicates that the mouse moved while the mouse button was up. 

Available in Mac OS X v10.0 and later.
Discussion

These constants are returned by TrackMouseLocation and TrackMouseRegion, which are designed as replacements to calls such as StillDown and WaitMouseUp. The advantage over those routines is that TrackMouseLocation and TrackMouseRegion block if the user is not moving the mouse, whereas mouse tracking loops based on StillDown and WaitMouseUp spin, chewing up valuable CPU time that could be better spent elsewhere. It is highly recommended that any tracking loops in your application stop using StillDown and WaitMouseUp and start using TrackMouseLocation or TrackMouseRegion. See the notes on those functions for more information.*/

typedef UInt16 MouseTrackingResult;
enum {
   kMouseTrackingMouseDown = 1,
   kMouseTrackingMouseUp = 2,
   kMouseTrackingMouseExited = 3,
   kMouseTrackingMouseEntered = 4,
   kMouseTrackingMouseDragged = 5,
   kMouseTrackingKeyModifiersChanged = 6,
   kMouseTrackingUserCancelled = 7,
   kMouseTrackingTimedOut = 8,
   kMouseTrackingMouseMoved = 9
};


/*Control Event Parameters

Define parameters related to control events. 

enum {
   kEventParamControlPart = 'cprt',
   kEventParamInitCollection = 'icol',
   kEventParamControlMessage = 'cmsg',
   kEventParamControlParam = 'cprm',
   kEventParamControlResult = 'crsl',
   kEventParamControlRegion = 'crgn',
   kEventParamControlAction = 'caup',
   kEventParamControlIndicatorDragConstraint = 'cidc',
   kEventParamControlIndicatorRegion = 'cirn',
   kEventParamControlIsGhosting = 'cgst',
   kEventParamControlIndicatorOffset = 'ciof',
   kEventParamControlClickActivationResult = 'ccar',
   kEventParamControlSubControl = 'csub',
   kEventParamControlOptimalBounds = 'cobn',
   kEventParamControlOptimalBaselineOffset = 'cobo',
   kEventParamControlDataTag = 'cdtg',
   kEventParamControlDataBuffer = 'cdbf',
   kEventParamControlDataBufferSize = 'cdbs',
   kEventParamControlDrawDepth = 'cddp',
   kEventParamControlDrawInColor = 'cdic',
   kEventParamControlFeatures = 'cftr',
   kEventParamControlPartBounds = 'cpbd',
   kEventParamControlOriginalOwningWindow = 'coow',
   kEventParamControlCurrentOwningWindow = 'ccow',
   kEventParamControlFocusEverything = 'cfev',
   kEventParamNextControl = 'cnxc',
   kEventParamStartControl = 'cstc',
   kEventParamControlSubview = 'csvw',
   kEventParamControlPreviousPart = 'copc',
   kEventParamControlCurrentPart = 'cnpc',
   kEventParamControlInvalRgn = 'civr',
   kEventParamControlValue = 'cval',
   kEventParamControlHit = 'chit',
   kEventParamControlPartAutoRepeats = 'caur',
   kEventParamControlFrameMetrics = 'cfmt',
   kEventParamControlWouldAcceptDrop = 'cldg',
   kEventParamControlPrefersShape = 'cpsh',
   typeControlActionUPP = 'caup',
   typeIndicatorDragConstraint = 'cidc',
   typeControlPartCode = 'cprt',
   typeControlFrameMetrics = 'cins'
};
Constants
kEventParamControlPart

typeControlPartCode

Available in Mac OS X v10.0 and later.
kEventParamInitCollection

typeCollection

Available in Mac OS X v10.0 and later.
kEventParamControlMessage

typeShortInteger

Available in Mac OS X v10.0 and later.
kEventParamControlParam

typeLongInteger

Available in Mac OS X v10.0 and later.
kEventParamControlResult

typeLongInteger

Available in Mac OS X v10.0 and later.
kEventParamControlRegion

typeQDRgnHandle

Available in Mac OS X v10.0 and later.
kEventParamControlAction

typeControlActionUPP

Available in Mac OS X v10.0 and later.
kEventParamControlIndicatorDragConstraint

typeIndicatorDragConstraint

Available in Mac OS X v10.0 and later.
kEventParamControlIndicatorRegion

typeQDRgnHandle

Available in Mac OS X v10.0 and later.
kEventParamControlIsGhosting

typeBoolean

Available in Mac OS X v10.0 and later.
kEventParamControlIndicatorOffset

typeQDPoint

Available in Mac OS X v10.0 and later.
kEventParamControlClickActivationResult

typeClickActivationResult

Available in Mac OS X v10.0 and later.
kEventParamControlSubControl

typeControlRef

Available in Mac OS X v10.0 and later.
kEventParamControlOptimalBounds

typeQDRectangle

Available in Mac OS X v10.0 and later.
kEventParamControlOptimalBaselineOffset

typeShortInteger

Available in Mac OS X v10.0 and later.
kEventParamControlDataTag

typeEnumeration

Available in Mac OS X v10.0 and later.
kEventParamControlDataBuffer

typePtr

Available in Mac OS X v10.0 and later.
kEventParamControlDataBufferSize

typeLongInteger

Available in Mac OS X v10.0 and later.
kEventParamControlDrawDepth

typeShortInteger

Available in Mac OS X v10.0 and later.
kEventParamControlDrawInColor

typeBoolean

Available in Mac OS X v10.0 and later.
kEventParamControlFeatures

typeUInt32

Available in Mac OS X v10.0 and later.
kEventParamControlPartBounds

typeQDRectangle

Available in Mac OS X v10.0 and later.
kEventParamControlOriginalOwningWindow

typeWindowRef

Available in Mac OS X v10.0 and later.
kEventParamControlCurrentOwningWindow

typeWindowRef

Available in Mac OS X v10.0 and later.
kEventParamControlFocusEverything

typeBoolean

Available in Mac OS X v10.2 and later.
kEventParamNextControl

typeControlRef

Available in Mac OS X v10.2 and later.
kEventParamStartControl

typeControlRef

Available in Mac OS X v10.2 and later.
kEventParamControlSubview

typeControlRef

Available in Mac OS X v10.2 and later.
kEventParamControlPreviousPart

typeControlPartCode

Available in Mac OS X v10.2 and later.
kEventParamControlCurrentPart

typeControlPartCode

Available in Mac OS X v10.2 and later.
kEventParamControlInvalRgn

typeQDRgnHandle

Available in Mac OS X v10.2 and later.
kEventParamControlValue

typeLongInteger

Available in Mac OS X v10.2 and later.
kEventParamControlHit

typeBoolean

Available in Mac OS X v10.3 and later.
kEventParamControlPartAutoRepeats

typeBoolean

Available in Mac OS X v10.3 and later.
kEventParamControlFrameMetrics

typeControlFrameMetrics

Available in Mac OS X v10.3 and later.
kEventParamControlWouldAcceptDrop

typeBoolean

Available in Mac OS X v10.3 and later.
kEventParamControlPrefersShape

typeBoolean

Available in Mac OS X v10.4 and later.
typeControlActionUPP

ControlActionUPP

Available in Mac OS X v10.0 and later.
typeIndicatorDragConstraint

IndicatorDragConstraint

Available in Mac OS X v10.0 and later.
typeControlPartCode

ControlPartCode

Available in Mac OS X v10.0 and later.
typeControlFrameMetrics

HIViewFrameMetrics

Available in Mac OS X v10.3 and later.*/
enum {
   kEventParamControlPart = 'cprt',
   kEventParamInitCollection = 'icol',
   kEventParamControlMessage = 'cmsg',
   kEventParamControlParam = 'cprm',
   kEventParamControlResult = 'crsl',
   kEventParamControlRegion = 'crgn',
   kEventParamControlAction = 'caup',
   kEventParamControlIndicatorDragConstraint = 'cidc',
   kEventParamControlIndicatorRegion = 'cirn',
   kEventParamControlIsGhosting = 'cgst',
   kEventParamControlIndicatorOffset = 'ciof',
   kEventParamControlClickActivationResult = 'ccar',
   kEventParamControlSubControl = 'csub',
   kEventParamControlOptimalBounds = 'cobn',
   kEventParamControlOptimalBaselineOffset = 'cobo',
   kEventParamControlDataTag = 'cdtg',
   kEventParamControlDataBuffer = 'cdbf',
   kEventParamControlDataBufferSize = 'cdbs',
   kEventParamControlDrawDepth = 'cddp',
   kEventParamControlDrawInColor = 'cdic',
   kEventParamControlFeatures = 'cftr',
   kEventParamControlPartBounds = 'cpbd',
   kEventParamControlOriginalOwningWindow = 'coow',
   kEventParamControlCurrentOwningWindow = 'ccow',
   kEventParamControlFocusEverything = 'cfev',
   kEventParamNextControl = 'cnxc',
   kEventParamStartControl = 'cstc',
   kEventParamControlSubview = 'csvw',
   kEventParamControlPreviousPart = 'copc',
   kEventParamControlCurrentPart = 'cnpc',
   kEventParamControlInvalRgn = 'civr',
   kEventParamControlValue = 'cval',
   kEventParamControlHit = 'chit',
   kEventParamControlPartAutoRepeats = 'caur',
   kEventParamControlFrameMetrics = 'cfmt',
   kEventParamControlWouldAcceptDrop = 'cldg',
   kEventParamControlPrefersShape = 'cpsh',
   typeControlActionUPP = 'caup',
   typeIndicatorDragConstraint = 'cidc',
   typeControlPartCode = 'cprt',
   typeControlFrameMetrics = 'cins'
};

/*Window State Event Constants

Define constants related to events from kEventClassWindow that notify of a change in the window’s state.

enum {
   kEventWindowShowing = 22,
   kEventWindowHiding = 23,
   kEventWindowShown = 24,
   kEventWindowHidden = 25,
   kEventWindowCollapsing = 86,
   kEventWindowCollapsed = 67,
   kEventWindowExpanding = 87,
   kEventWindowExpanded = 70,
   kEventWindowZoomed = 76,
   kEventWindowBoundsChanging = 26,
   kEventWindowBoundsChanged = 27,
   kEventWindowResizeStarted = 28,
   kEventWindowResizeCompleted = 29,
   kEventWindowDragStarted = 30,
   kEventWindowDragCompleted = 31,
   kEventWindowClosed = 73
};
Constants
kEventWindowShowing

A window is being shown. This is sent inside ShowHide. This event is propagated to all handlers that registered for the event in the event target’s handler chain, regardless of return value. 

The standard window handler ignores this event.

Available in Mac OS X v10.0 and later.
kEventWindowHiding

A window is being hidden. This is sent inside ShowHide. This event is propagated to all handlers that registered for the event in the event target’s handler chain, regardless of return value. 

The standard window handler ignores this event.

Available in Mac OS X v10.0 and later.
kEventWindowShown

The window has been shown. This event is propagated to all handlers that registered for the event in the event target’s handler chain, regardless of return value. 

The standard window handler ignores this event.

Available in Mac OS X v10.0 and later.
kEventWindowHidden

The window has been hidden. This event is propagated to all handlers that registered for the event in the event target’s handler chain, regardless of return value. 

The standard window handler ignores this event.

Available in Mac OS X v10.0 and later.
kEventWindowCollapsing

The window is collapsing. This event is propagated to all handlers that registered for the event in the event target’s handler chain, regardless of return value. 

The standard window handler ignores this event. 

(Available in Mac OS X v10.1 and later.) 

Available in Mac OS X v10.2 and later.
kEventWindowCollapsed

The object has successfully collapsed. This event is propagated to all handlers that registered for the event in the event target’s handler chain, regardless of return value. 

The standard window handler ignores this event. 

Available in Mac OS X v10.0 and later.
kEventWindowExpanding

The window is expanding. This event is propagated to all handlers that registered for the event in the event target’s handler chain, regardless of return value. 

The standard window handler ignores this event. 

(Available in Mac OS X v10.1 and later.) 

Available in Mac OS X v10.2 and later.
kEventWindowExpanded

The window has successfully expanded. This event is propagated to all handlers that registered for the event in the event target’s handler chain, regardless of return value. 

The standard window handler ignores this event.

Available in Mac OS X v10.0 and later.
kEventWindowZoomed

The window has been successfully zoomed. This event is propagated to all handlers that registered for the event in the event target’s handler chain, regardless of return value. 

In CarbonLib 1.1 through 1.4 and Mac OS X prior to v10.2, this event is sent only by the standard window handler after handling kEventWindowZoom. In CarbonLib 1.5 and later and Mac OS X v10.2 and later, this event is sent by the Window Manager functions ZoomWindow and ZoomWindowIdeal.

The standard window handler ignores this event.

Available in Mac OS X v10.0 and later.
kEventWindowBoundsChanging

Sent during DragWindow or ResizeWindow, before the window is actually moved or resized. You can alter the current bounds in the event (the kEventParamCurrentBounds parameter) to change the eventual size and location of the window. Do not call the Window Manager functions SizeWindow or SetWindowBounds from inside a handler for this event. 

In Mac OS X v10.1 and later, this event is sent before all changes to a window’s bounds, whether initiated by a user or by a Window Manager call. If the event was sent in response to a user action, the kWindowBoundsChangeUserDrag or kWindowBoundsChangeUserResize attribute will be set in the kEventParamAttributes parameter. 

The standard window handler ignores this event.

Available in Mac OS X v10.0 and later.
kEventWindowBoundsChanged

The window has been moved or resized (or both). Do not call the Window Manager functions SizeWindow or SetWindowBounds from inside a handler for this event. If you want to enforce certain window bounds, you should do so from a kEventWindowBoundsChanging event handler. 

This event is propagated to all handlers that registered for the event in the event target’s handler chain, regardless of return value. 

In Mac OS X v10.2 and later, the standard window handler can take this event under the following conditions:
the window uses live resizing (the kWindowLiveResizeAttribute attribute is set.
the user is the one resizing the window
an update event for the window exists in the event queue

If these conditions are met, the standard window handler removes the update event from the event queue and sends it to the event dispatcher target. Doing so simplifies redrawing window content during live resizing. 

Available in Mac OS X v10.0 and later.
kEventWindowResizeStarted

The user has just started to resize a window. This event is propagated to all handlers that registered for the event in the event target’s handler chain, regardless of return value. 

The standard window handler ignores this event.

Available in Mac OS X v10.0 and later.
kEventWindowResizeCompleted

The user has just finished resizing a window. This event is propagated to all handlers that registered for the event in the event target’s handler chain, regardless of return value. 

The standard window handler ignores this event.

Available in Mac OS X v10.0 and later.
kEventWindowDragStarted

The user has just started to drag a window. This event is propagated to all handlers that registered for the event in the event target’s handler chain, regardless of return value. 

The standard window handler ignores this event.

Available in Mac OS X v10.0 and later.
kEventWindowDragCompleted

The user has completed a window drag. This event is propagated to all handlers that registered for the event in the event target’s handler chain, regardless of return value. 

The standard window handler ignores this event.

Available in Mac OS X v10.0 and later.
kEventWindowClosed

Dispatched by DisposeWindow before the window is disposed. This event is propagated to all handlers that registered for the event in the event target’s handler chain, regardless of return value. 

In CarbonLib 1.5 and earlier and Mac OS X prior to v10.2, if a visible window is destroyed, kEventWindowClosedEvent is sent before the kEventWindowHidden event. In CarbonLib 1.6 and Mac OS X v10.2 and later, the kEventWindowClosed event is sent after kEventWindowHidden. 

The standard window handler ignores this event.

Available in Mac OS X v10.0 and later.
Discussion

Table 13 shows the parameters related to window state change events.*/
enum {
   kEventWindowShowing = 22,
   kEventWindowHiding = 23,
   kEventWindowShown = 24,
   kEventWindowHidden = 25,
   kEventWindowCollapsing = 86,
   kEventWindowCollapsed = 67,
   kEventWindowExpanding = 87,
   kEventWindowExpanded = 70,
   kEventWindowZoomed = 76,
   kEventWindowBoundsChanging = 26,
   kEventWindowBoundsChanged = 27,
   kEventWindowResizeStarted = 28,
   kEventWindowResizeCompleted = 29,
   kEventWindowDragStarted = 30,
   kEventWindowDragCompleted = 31,
   kEventWindowClosed = 73
};

/*Command Event Source Constants

Define constants for the user interface element that produced an HICommand event.

enum {
   kHICommandFromMenu = (1L << 0),
   kHICommandFromControl = (1L << 1),
   kHICommandFromWindow = (1L << 2)
};
Constants
kHICommandFromMenu

This bit is set for commands generated from menu items in all versions of CarbonLib and Mac OS X.

Available in Mac OS X v10.0 and later.
kHICommandFromControl

The command event originated from a control. This bit was introduced in Mac OS X v10.2 and CarbonLib 1.6; it is never set in earlier versions of Mac OS X or CarbonLib.

Available in Mac OS X v10.2 and later.
kHICommandFromWindow

The command event originated from a window. This bit was introduced in Mac OS X v10.2 and CarbonLib 1.6; it is never set in earlier versions of Mac OS X or CarbonLib.

Available in Mac OS X v10.2 and later.*/
enum {
   kHICommandFromMenu = (1L << 0),
   kHICommandFromControl = (1L << 1),
   kHICommandFromWindow = (1L << 2)
};

/*HICommandExtended

Represents an extended command event.

struct HICommandExtended {
   UInt32 attributes;
   UInt32 commandID;
   union {
      controlRef control;
      windowRef window;
      struct {
         MenuRef menuRef;
         MenuItemIndex menuItemIndex;
      } menu;
   } source;
};
typedef struct HICommandExtended HICommandExtended;
Fields
attributes

Attributes of the command event. The value of this field (indicating whether the source of the command event is a control, window, or menu) determines what reference is stored in the union. See “Command Event Source Constants” for a list of possible values. 
commandID

The command ID of the command event.
controlRef

The control that produced the command event.
windowRef

The window that produced the command event. 
menuRef

A reference to the menu containing the command event.
menuItemIndex

The index number of the menu item containing the command event.
Discussion

The HICommandExtended structure was introduced in Mac OS X v10.2 and CarbonLib 1.6. Because the HICommand and HICommandExtended structures are exactly the same size and have the same fields at the same offsets, you can use an HICommandExtended structure at runtime while running on any version of CarbonLib or Mac OS X. The only difference is that the HICommandExtended structure has a union that allows you to get type-safe access to the source object. The originator of the command determines whether the structure actually contains a ControlRef, WindowRef, MenuRef, or nothing at all. You can determine what is in the command by checking the attributes field.

For example, in Mac OS X v10.2 and later, when a push button is clicked, the Control Manager sends a command event containing the push button’s command ID, sets the kHICommandFromControl bit in the attributes field, and stores the button’s ControlRef in the source.control field. In Mac OS X v10.0 and v10.1, the same command event is sent, but the kHICommandFromControl, kHICommandFromMenu, and kHICommandFromWindow attributes are not set, and the source.controlRef, source.menu.menuRef and source.windowRef fields are not initialized, respectively. Your code can use an HICommandExtended structure when running on Mac OS X v10.0 and v10.1 as long as it first checks the kHICommandFromControl, kHICommandFromMenu, and kHICommandFromWindow attributes before accessing the source.control, menu.control, and window.control fields.
Availability
Available in Mac OS X v10.2 and later.*/
struct HICommandExtended {
   UInt32 attributes;
   UInt32 commandID;
   union {
      ControlRef control;
      WindowRef window;
      struct {
         MenuRef menuRef;
         MenuItemIndex menuItemIndex;
      } menu;
   } source;
};
typedef struct HICommandExtended HICommandExtended;

/*Object Reference Parameters and Types

Define constants for parameters that specify various objects and their types.

enum {
   kEventParamWindowRef = 'wind',
   kEventParamGrafPort = 'graf',
   kEventParamDragRef = 'drag',
   kEventParamMenuRef = 'menu',
   kEventParamEventRef = 'evnt',
   kEventParamControlRef = 'ctrl',
   kEventParamRgnHandle = 'rgnh',
   kEventParamEnabled = 'enab',
   kEventParamDimensions = 'dims',
   kEventParamBounds = 'boun',
   kEventParamAvailableBounds = 'avlb',
   kEventParamAEEventID = keyAEEventID,
   kEventParamAEEventClass = keyAEEventClass,
   kEventParamCGContextRef = 'cntx',
   kEventParamDeviceDepth = 'devd',
   kEventParamDeviceColor = 'devc',
   kEventParamMutableArray = 'marr',
   kEventParamResult = 'ansr',
   kEventParamMinimumSize = 'mnsz',
   kEventParamMaximumSize = 'mxsz',
   kEventParamAttributes = 'attr',
   kEventParamReason = 'why?',
   kEventParamTransactionID = 'trns',
   kEventGDevice = 'gdev',
   kEventParamIndex = 'indx',
   kEventParamUserData = 'usrd',
   kEventParamShape = 'shap',
   typeWindowRef = 'wind',
   typeGrafPtr = 'graf',
   typeGWorldPtr = 'gwld',
   typeDragRef = 'drag',
   typeMenuRef = 'menu',
   typeControlRef = 'ctrl',
   typeCollection = 'cltn',
   typeQDRgnHandle = 'rgnh',
   typeOSStatus = 'osst',
   typeCFIndex = 'cfix',
   typeCFStringRef = 'cfst',
   typeCFMutableStringRef = 'cfms',
   typeCFTypeRef = 'cfty',
   typeCGContextRef = 'cntx',
   typeHIPoint = 'hipt',
   typeHISize = 'hisz',
   typeHIRect = 'hirc',
   typeHIShapeRef = 'shap',
   typeVoidPtr = 'void',
   typeGDHandle = 'gdev'
};
Constants
kEventParamWindowRef

A window reference. (typeWindowRef)

Available in Mac OS X v10.0 and later.
kEventParamGrafPort

typeGrafPtr

Available in Mac OS X v10.0 and later.
kEventParamDragRef

typeDragRef

Available in Mac OS X v10.0 and later.
kEventParamMenuRef

typeMenuRef

Available in Mac OS X v10.0 and later.
kEventParamEventRef

typeEventRef

Available in Mac OS X v10.0 and later.
kEventParamControlRef

typeControlRef

Available in Mac OS X v10.0 and later.
kEventParamRgnHandle

typeQDRgnHandle

Available in Mac OS X v10.0 and later.
kEventParamEnabled

typeBoolean

Available in Mac OS X v10.0 and later.
kEventParamDimensions

typeQDPoint

Available in Mac OS X v10.0 and later.
kEventParamBounds

typeQDRectangle

Available in Mac OS X v10.3 and later.
kEventParamAvailableBounds

typeQDRectangle

Available in Mac OS X v10.0 and later.
kEventParamAEEventID

typeType

Available in Mac OS X v10.0 and later.
kEventParamAEEventClass

typeType

Available in Mac OS X v10.0 and later.
kEventParamCGContextRef

typeCGContextRef

Available in Mac OS X v10.0 and later.
kEventParamDeviceDepth

typeShortInteger

Available in Mac OS X v10.1 and later.
kEventParamDeviceColor

typeBoolean

Available in Mac OS X v10.1 and later.
kEventParamMutableArray

typeCFMutableArrayRef

Available in Mac OS X v10.2 and later.
kEventParamResult

Any type, depending on the event

Available in Mac OS X v10.2 and later.
kEventParamMinimumSize

typeHISize

Available in Mac OS X v10.2 and later.
kEventParamMaximumSize

typeHISize

Available in Mac OS X v10.2 and later.
kEventParamAttributes

typeUInt32

Available in Mac OS X v10.0 and later.
kEventParamReason

typeUInt32

Available in Mac OS X v10.3 and later.
kEventParamTransactionID

typeUInt32

Available in Mac OS X v10.3 and later.
kEventParamGDevice

typeGDHandle

Available in Mac OS X v10.3 and later.
kEventParamIndex

typeCFIndex

Available in Mac OS X v10.3 and later.
kEventParamUserData

typeVoidPtr

Available in Mac OS X v10.3 and later.
kEventParamShape

typeHIShapeRef

Available in Mac OS X v10.4 and later.
typeWindowRef

WindowRef

Available in Mac OS X v10.0 and later.
typeGrafPtr

CGrafPtr

Available in Mac OS X v10.0 and later.
typeGWorldPtr

GWorldPtr

Available in Mac OS X v10.0 and later.
typeDragRef

DragRef

Available in Mac OS X v10.0 and later.
typeMenuRef

MenuRef

Available in Mac OS X v10.0 and later.
typeControlRef

ControlRef

Available in Mac OS X v10.0 and later.
typeCollection

Collection

Available in Mac OS X v10.0 and later.
typeQDRgnHandle

RgnHandle

Available in Mac OS X v10.0 and later.
typeOSStatus

OSStatus

Available in Mac OS X v10.0 and later.
typeCFIndex

CFIndex

Available in Mac OS X v10.2 and later.
typeCFStringRef

CFStringRef

Available in Mac OS X v10.1 and later.
typeCFMutableStringRef

CFMutableStringRef

Available in Mac OS X v10.2 and later.
typeCFTypeRef

CFTypeRef

Available in Mac OS X v10.2 and later.
typeCGContextRef

CGContextRef

Available in Mac OS X v10.0 and later.
typeHIPoint

HIPoint

Available in Mac OS X v10.1 and later.
typeHISize

HISize

Available in Mac OS X v10.2 and later.
typeHIRect

HIRect

Available in Mac OS X v10.2 and later.
typeHIShapeRef

HIShapeRef

Available in Mac OS X v10.4 and later.
typeVoidPtr

Void

Available in Mac OS X v10.2 and later.
typeGDHandle

GDHandle

Available in Mac OS X v10.3 and later.
Discussion

You specify these parameters to obtain references to various objects such as windows, controls, graphics ports, and so on. See the various event kinds to determine the parameters available for each event. For example, Table 8 in “Mouse Events” lists the various parameters used in mouse events.*/
enum {
   kEventParamWindowRef = 'wind',
   kEventParamGrafPort = 'graf',
   kEventParamDragRef = 'drag',
   kEventParamMenuRef = 'menu',
   kEventParamEventRef = 'evnt',
   kEventParamControlRef = 'ctrl',
   kEventParamRgnHandle = 'rgnh',
   kEventParamEnabled = 'enab',
   kEventParamDimensions = 'dims',
   kEventParamBounds = 'boun',
   kEventParamAvailableBounds = 'avlb',
   kEventParamAEEventID = keyAEEventID,
   kEventParamAEEventClass = keyAEEventClass,
   kEventParamCGContextRef = 'cntx',
   kEventParamDeviceDepth = 'devd',
   kEventParamDeviceColor = 'devc',
   kEventParamMutableArray = 'marr',
   kEventParamResult = 'ansr',
   kEventParamMinimumSize = 'mnsz',
   kEventParamMaximumSize = 'mxsz',
   kEventParamAttributes = 'attr',
   kEventParamReason = 'why?',
   kEventParamTransactionID = 'trns',
   kEventGDevice = 'gdev',
   kEventParamIndex = 'indx',
   kEventParamUserData = 'usrd',
   kEventParamShape = 'shap',
   typeWindowRef = 'wind',
   typeGrafPtr = 'graf',
   typeGWorldPtr = 'gwld',
   typeDragRef = 'drag',
   typeMenuRef = 'menu',
   typeControlRef = 'ctrl',
   typeCollection = 'cltn',
   typeQDRgnHandle = 'rgnh',
   typeOSStatus = 'osst',
   typeCFIndex = 'cfix',
   typeCFStringRef = 'cfst',
   typeCFMutableStringRef = 'cfms',
   typeCFTypeRef = 'cfty',
   typeCGContextRef = 'cntx',
   typeHIPoint = 'hipt',
   typeHISize = 'hisz',
   typeHIRect = 'hirc',
   typeHIShapeRef = 'shap',
   typeVoidPtr = 'void',
   typeGDHandle = 'gdev'
};

/*Keyboard Event Parameters and Types

Define constants for parameters to raw keyboard events.

enum {
   kEventParamKeyCode = 'kcod',
   kEventParamKeyMacCharCodes = 'kchr',
   kEventParamKeyModifiers = 'kmod',
   kEventParamKeyUnicodes = 'kuni',
   kEventParamKeyboardType = 'kbdt',
   typeEventHotKeyID = 'hkid'
};
Constants
kEventParamKeyCode

typeUInt32

Available in Mac OS X v10.0 and later.
kEventParamKeyMacCharCodes

typeChar

Available in Mac OS X v10.0 and later.
kEventParamKeyModifiers

typeUInt32

Available in Mac OS X v10.0 and later.
kEventParamKeyUnicodes

typeUnicodeText

Available in Mac OS X v10.0 and later.
typeEventHotKeyID

EventHotKeyID

Available in Mac OS X v10.0 and later.*/
enum {
   kEventParamKeyCode = 'kcod',
   kEventParamKeyMacCharCodes = 'kchr',
   kEventParamKeyModifiers = 'kmod',
   kEventParamKeyUnicodes = 'kuni',
   kEventParamKeyboardType = 'kbdt',
   typeEventHotKeyID = 'hkid'
};


/*Control Event Constants

Define constants related to events from kEventClassControl.

enum {
   kEventControlInitialize = 1000,
   kEventControlDispose = 1001,
   kEventControlGetOptimalBounds = 1003,
   kEventControlDefInitialize = kEventControlInitialize,
   kEventControlDefDispose = kEventControlDispose,
   kEventControlHit = 1,
   kEventControlSimulateHit = 2,
   kEventControlHitTest = 3,
   kEventControlDraw = 4,
   kEventControlApplyBackground = 5,
   kEventControlApplyTextColor = 6,
   kEventControlSetFocusPart = 7,
   kEventControlGetFocusPart = 8,
   kEventControlActivate = 9,
   kEventControlDeactivate = 10,
   kEventControlSetCursor = 11,
   kEventControlContextualMenuClick = 12,
   kEventControlClick = 13,
   kEventControlGetNextFocusCandidate = 14,
   kEventControlGetAutoToggleValue = 15,
   kEventControlInterceptSubviewClick = 16,
   kEventControlGetClickActivation = 17,
   kEventControlDragEnter = 18,
   kEventControlDragWithin = 19,
   kEventControlDragLeave = 20,
   kEventControlDragReceive = 21,
   kEventControlTrack = 51,
   kEventControlGetScrollToHereStartPoint = 52,
   kEventControlGetIndicatorDragConstraint = 53,
   kEventControlIndicatorMoved = 54,
   kEventControlGhostingFinished = 55,
   kEventControlGetActionProcPart = 56,
   kEventControlGetPartRegion = 101,
   kEventControlGetPartBounds = 102,
   kEventControlSetData = 103,
   kEventControlGetData = 104,
   kEventControlGetSizeConstraints = 105,
   kEventControlValueFieldChanged = 151,
   kEventControlAddedSubControl = 152,
   kEventControlRemovingSubControl = 153,
   kEventControlBoundsChanged = 154,
   kEventControlTitleChanged = 158,
   kEventControlOwningWindowChanged = 159,
   kEventControlHiliteChanged = 160,
   kEventControlEnabledStateChanged = 161,
   kEventControlArbitraryMessage = 201
};
Constants
kEventControlInitialize

Sent when a control is created. Allows the control to initialize private data. 

Available in Mac OS X v10.0 and later.
kEventControlDispose

Sent when a control is disposed. Allows the control to dispose of private data. 

Available in Mac OS X v10.0 and later.
kEventControlGetOptimalBounds

Allows the control to report its best size and its text baseline based on its current settings. You should set the kEventParamControlOptimalBounds parameter to an appropriate rectangle. You should also set the kEventParamControlOptimalBaselineOffset parameter to be the offset from the top of your optimal bounds of a text baseline, if any. (Mac OS X only) 

Available in Mac OS X v10.0 and later.
kEventControlDefInitialize

Same as kEventControlInitialize. You can use this event when creating custom control definitions. 

Available in Mac OS X v10.0 and later.
kEventControlDefDispose

Same as kEventControlDispose. You can use this event when creating custom control definitions.

Available in Mac OS X v10.0 and later.
kEventControlHit

Sent by the Control Manager functions TrackControl and HandleControlClick after handling a click in a control. If you do not handle this event, and the control has a command ID associated with it, then the Control Manager sends a kEventCommandProcess event to the control. 

Available in Mac OS X v10.0 and later.
kEventControlSimulateHit

Sent when your control should simulate a click in response to some other action, such as a return key for a default button. The default behavior is to use the Control Manager function HiliteControl to highlight and unhighlight the part specified in the kEventParamControlPart parameter (simulating the hit) and then call the control’s action callback function. (Mac OS X only) 

Available in Mac OS X v10.0 and later.
kEventControlHitTest

Sent when someone wants to find out what part of your control is at a given point in local coordinates. You should set the kEventParamControlPart parameter to the appropriate part. (Mac OS X only) 

Available in Mac OS X v10.0 and later.
kEventControlDraw

Sent when your control should draw itself. The event can optionally contain parameters indicating which port to draw into and which part to constrain drawing to. (Mac OS X only) 

Available in Mac OS X v10.0 and later.
kEventControlApplyBackground

Sent when your control should apply its background color/pattern to the port specified so the subcontrol can properly erase. The port is optional; if it does not exist you should apply the background to the current port. Note that if you don’t handle this event, the event is propagated to the control’s parent. (Mac OS X only) 

Available in Mac OS X v10.0 and later.
kEventControlApplyTextColor

Sent when your control should apply a color/pattern to the specified port and context so a subcontrol can draw text which looks appropriate for your control’s background. The port is optional; if it does not exist, you should apply the text color to the current port. The context is also optional. (Mac OS X only) 

Available in Mac OS X v10.0 and later.
kEventControlSetFocusPart

Sent when your control is gaining, losing, or changing the focus. Set the focus to the part indicated by the kEventParamControlPart parameter. (Mac OS X only) 

Available in Mac OS X v10.0 and later.
kEventControlGetFocusPart

Sent when your the Control Manager wants to know what part of your control is currently focused. Set the kEventParamControlPart parameter to your currently focused part. If you don’t handle this event, the Control Manager sets the part parameter to the last part that was focused (or no part if the control lost focus). (Mac OS X only) 

Available in Mac OS X v10.0 and later.
kEventControlActivate

Sent when your control becomes active as a result of a call to ActivateControl. (Mac OS X only) 

Available in Mac OS X v10.0 and later.
kEventControlDeactivate

Sent when your control becomes inactive as a result of a call to DeactivateControl. (Mac OS X only) 

Available in Mac OS X v10.0 and later.
kEventControlSetCursor

Sent when your control is asked to change the cursor as a result of a call to the Control Manager function HandleControlSetCursor. (Mac OS X only) 

Available in Mac OS X v10.0 and later.
kEventControlContextualMenuClick

Sent when your control is asked to display a contextual menu as a result of a call to the Control Manager function HandleControlContextualMenuClick. (Mac OS X only) 

Available in Mac OS X v10.0 and later.
kEventControlClick

A mouse down occurred in a control. The standard window handler sets the keyboard focus to the control if it takes focus on clicks, and calls the Control Manager function HandleControlClick.

Available in Mac OS X and CarbonLib 1.3.1 and later.
kEventControlGetNextFocusCandidate

Sent to allow a control to customize the focus order of its subcontrols. The current subcontrol with focus is stored in the kEventParamStartControl parameter. The desired focus direction is indicated by the kControlFocusNextPart or kControlFocusPrevPart constants, passed to you in the kEventParamControlPart parameter. The handler should return the next subcontrol in the kEventParamNextControl parameter. If the kEventParamStartControl parameter is NULL, return the first subcontrol in the specified focus direction. If no next subcontrol exists in the desired focus direction, return NULL or omit the kEventParamNextControl parameter. 

The default behavior is to return the “most appropriate” peer control, which currently means the previous control in the ordering scheme. 

(Available in Mac OS X v10.2 and later.)

Available in Mac OS X v10.2 and later.
kEventControlGetAutoToggleValue

Sent when the system wants to auto-toggle a control. You can specify the value to use based on the current value of your control. 

If the control has the kControlAutoToggles feature bit set, then the default behavior is as follows:
If the control does not behave like a radio button (the kControlHasRadioBehavior feature bit is not set), and its value is 1, then the kEventParamControlValue parameter is set to 0. 
If the control’s value is anything other than 1, the kEventParamControlValue parameter is set to 0. 

Otherwise, there is no default behavior. 

(Available in Mac OS X v10.2 and later.)

Available in Mac OS X v10.2 and later.
kEventControlInterceptSubviewClick

Sent when the HIViewGetViewForMouseClick function is called (typically by the Control Manager before it descends into subviews). A view can use this event to intercept mouse clicks that would normally be destined for one of its subviews. For example, the Toolbar control uses this event to intercept command-clicks so that it can handle dragging of its children. If the command key is down, the user wants to drag, so the handler returns noErr to indicate that this view (the Toolbar) should receive the click, not the child that was actually under the mouse. 

(Available in Mac OS X v10.2 and later.)

Available in Mac OS X v10.2 and later.
kEventControlGetClickActivation

Sent when a mouse click occurs in a background (inactive) control. This event is essentially the control version of kEventWindowGetClickActivation. The only differences are that the mouse location is view-relative and no window part parameter is passed to you. 

This event is sent only when the standard window handler is installed. The default behavior is to activate the view and absorb the mouse click (that is, the click is not passed on to the view).

(Available in Mac OS X v10.2 and later.)

Available in Mac OS X v10.2 and later.
kEventControlDragEnter

Sent when a drag item enters a view’s bounds. If you want to respond to the drag, your drag entered handler must return noErr If you return eventNotHandledErr then you will not receive further drag events, nor will you be able to receive the drag item. 

(Available in Mac OS X v10.2 and later.)

Available in Mac OS X v10.2 and later.
kEventControlDragWithin

Sent when a drag item has moved while in the view’s bounds (but not within any of its subviews). If the drag subsequently enters a subview, all additional drag events are directed to that subview. 

(Available in Mac OS X v10.2 and later.)

Available in Mac OS X v10.2 and later.
kEventControlDragLeave

Sent when a drag item leaves your view. You can use this event to unhighlight your view, and so on. (Available in Mac OS X v10.2 and later.)

Available in Mac OS X v10.2 and later.
kEventControlDragReceive

Sent when a drag item is dropped within your view. (Available in Mac OS X v10.2 and later.)

Available in Mac OS X v10.2 and later.
kEventControlTrack

Sent to allow your control to completely replace the normal tracking that is part of a call to the Control Manager functions TrackControl or HandleControlClick. Set the kEventParamControlPart to the part hit during tracking.

This event is sent only to controls that return a non-zero control part code from kEventControlHitTest. If you are implementing a custom HIView and you need to receive this event, you must also handle kEventControlHitTest. The hit-test handler must place a valid control part code into the kEventParamControlPart parameter and return noErr. 

The default behavior is to implement indicator tracking (if the mouse is down in an indicator part, such as for a scroll bar) or one-part tracking (if the mouse is down in a button or similar part). If the tracking is successful, the Control Manager passes back the part that was hit. 

(Available in Mac OS X only)

Available in Mac OS X v10.0 and later.
kEventControlGetScrollToHereStartPoint

Sent so your control can support “Scroll To Here” behavior during tracking. Set the kEventParamMouseLocation parameter to the mouse location in local coordinates which represents where a click would have needed to be to cause your indicator to be dragged to the incoming mouse location. (Mac OS X only) 

Available in Mac OS X v10.0 and later.
kEventControlGetIndicatorDragConstraint

Sent so your control can constrain the movement of its indicator during tracking. Set the kEventParamControlIndicatorDragConstraint parameter to the appropriate constraint. (Mac OS X only) 

Available in Mac OS X v10.0 and later.
kEventControlIndicatorMoved

Sent during live-tracking of the indicator so your control can update its value based on the new indicator position. During non-live tracking, this event lets you redraw the indicator ghost at the appropriate place. (Mac OS X only) 

Available in Mac OS X v10.0 and later.
kEventControlGhostingFinished

Sent at the end of non-live indicator tracking so your control can update its value based on the final ghost location. (Mac OS X only) 

Available in Mac OS X v10.0 and later.
kEventControlGetActionProcPart

Sent during tracking so your control can alter the part that is passed to its action callback based on modifier keys, etc. Set the kEventParamControlPart to the part you want to have sent. (Mac OS X only) 

Available in Mac OS X v10.0 and later.
kEventControlGetPartRegion

Sent when a client wants to get a particular region of your control. See the GetControlRegion function in the Control Manager. The kEventParamControlRegion contains a region for you to modify. 

If the requested part is kControlStructureMetaPart, the default behavior is to pass back a region equal to the control’s bounds. Otherwise, there is no default behavior. 

(Mac OS X only) 

Available in Mac OS X v10.0 and later.
kEventControlGetPartBounds

Sent when a client wants to get a particular rectangle of your control when it may be more efficient than asking for a region. Set the kEventParamControlPartBounds parameter to the appropriate rectangle. (Mac OS X only) 

Available in Mac OS X v10.0 and later.
kEventControlSetData

Sent when a client wants to change an arbitrary setting of your control. See the SetControlData function in the Control Manager. (Mac OS X only) 

Available in Mac OS X v10.0 and later.
kEventControlGetData

Sent when a client wants to get an arbitrary setting of your control. See the Control Manager function GetControlData. (Mac OS X only) 

Available in Mac OS X v10.0 and later.
kEventControlGetSizeConstraints

Sent when the HIViewGetSizeContraints function is called. You use this to let your custom view indicate its maximum and minimum size. A parent view can use this information to help it lay out subviews. (Available in Mac OS X v10.2 and later.)

Available in Mac OS X v10.2 and later.
kEventControlValueFieldChanged

Sent when your control’s value, minimum, maximum, or view size has changed. Useful so other entities can watch for your control’s value to change. If the window does not have compositing enabled, the default behavior is to redraw the control (but not its subcontrols). (Mac OS X only) 

Available in Mac OS X v10.0 and later.
kEventControlAddedSubControl

Sent when a control is embedded within your control. (Mac OS X only) 

Available in Mac OS X v10.0 and later.
kEventControlRemovingSubControl

Sent when one of your child controls will be removed from your control. (Mac OS X only) 

Available in Mac OS X v10.0 and later.
kEventControlBoundsChanged

Sent when your control’s bounding rectangle has changed. Note that the kEventParamOriginalBounds and kEventParamPreviousBounds parameters for this event contain the same value. (Mac OS X only) 

Available in Mac OS X v10.0 and later.
kEventControlTitleChanged

Sent when your control’s title changes. (Available in Mac OS X v10.2 and later.)

Available in Mac OS X v10.2 and later.
kEventControlOwningWindowChanged

Sent when one your control’s owning window has changed. Useful to update any dependencies that your control has on its owning window. (Mac OS X only) 

Available in Mac OS X v10.0 and later.
kEventControlHiliteChanged

Sent when a control’s highlight state changes. (Available in Mac OS X v10.2 and later.)

Available in Mac OS X v10.2 and later.
kEventControlEnabledStateChanged

Sent when a control’s enabled state changes (that is, when a control is enabled or disabled). (Available in Mac OS X v10.2 and later.)

Available in Mac OS X v10.2 and later.
kEventControlArbitraryMessage

Sent when someone tries to send an old-style CDEF message to your control. In most cases, you should implement Carbon event replacements for CDEF messages instead. If you do handle this event, but do not explicitly handle a particular CDEF message, you should propagate this event up the handler chain (either explicitly by calling CallNextEventHandler or implicitly by returning eventNotHandledErr), as some default behavior may be implemented for compatibility purposes. (Mac OS X only)

Available in Mac OS X v10.0 and later.
Discussion

You can specify any of these events when installing an event handler. You can also pass these constants to the CreateControlEvent function to specify the type of control event you want to create. 

Note that many control events are not sent as a request for you to take action; rather they provide a way for the application to override default behavior. Because this is the case, most control events do not have a standard handler associated with them. Their default behavior occurs whether or not you have the standard window handler installed*/
enum {
   kEventControlInitialize = 1000,
   kEventControlDispose = 1001,
   kEventControlGetOptimalBounds = 1003,
   kEventControlDefInitialize = kEventControlInitialize,
   kEventControlDefDispose = kEventControlDispose,
   kEventControlHit = 1,
   kEventControlSimulateHit = 2,
   kEventControlHitTest = 3,
   kEventControlDraw = 4,
   kEventControlApplyBackground = 5,
   kEventControlApplyTextColor = 6,
   kEventControlSetFocusPart = 7,
   kEventControlGetFocusPart = 8,
   kEventControlActivate = 9,
   kEventControlDeactivate = 10,
   kEventControlSetCursor = 11,
   kEventControlContextualMenuClick = 12,
   kEventControlClick = 13,
   kEventControlGetNextFocusCandidate = 14,
   kEventControlGetAutoToggleValue = 15,
   kEventControlInterceptSubviewClick = 16,
   kEventControlGetClickActivation = 17,
   kEventControlDragEnter = 18,
   kEventControlDragWithin = 19,
   kEventControlDragLeave = 20,
   kEventControlDragReceive = 21,
   kEventControlTrack = 51,
   kEventControlGetScrollToHereStartPoint = 52,
   kEventControlGetIndicatorDragConstraint = 53,
   kEventControlIndicatorMoved = 54,
   kEventControlGhostingFinished = 55,
   kEventControlGetActionProcPart = 56,
   kEventControlGetPartRegion = 101,
   kEventControlGetPartBounds = 102,
   kEventControlSetData = 103,
   kEventControlGetData = 104,
   kEventControlGetSizeConstraints = 105,
   kEventControlValueFieldChanged = 151,
   kEventControlAddedSubControl = 152,
   kEventControlRemovingSubControl = 153,
   kEventControlBoundsChanged = 154,
   kEventControlTitleChanged = 158,
   kEventControlOwningWindowChanged = 159,
   kEventControlHiliteChanged = 160,
   kEventControlEnabledStateChanged = 161,
   kEventControlArbitraryMessage = 201
};

/*Keyboard Events
Keyboard Event Constants

Define constants related to events from kEventClassKeyboard.

enum {
   kEventRawKeyDown = 1,
   kEventRawKeyRepeat = 2,
   kEventRawKeyUp = 3,
   kEventRawKeyModifiersChanged = 4,
   kEventHotKeyPressed = 5,
   kEventHotKeyReleased = 6
};
Constants
kEventRawKeyDown

A key was pressed.

Available in Mac OS X v10.0 and later.
kEventRawKeyRepeat

Sent periodically as a key is held down by the user. 

Available in Mac OS X v10.0 and later.
kEventRawKeyUp

A key was released. 

Available in Mac OS X v10.0 and later.
kEventRawKeyModifiersChanged

The keyboard modifiers have changed. 

Available in Mac OS X v10.0 and later.
kEventHotKeyPressed

A registered hot key was pressed. 

Available in Mac OS X v10.0 and later.
kEventHotKeyReleased

A registered hot key was released.

Available in Mac OS X v10.0 and later.
Discussion

These events are the lowest-level keyboard events.*/
enum {
   kEventRawKeyDown = 1,
   kEventRawKeyRepeat = 2,
   kEventRawKeyUp = 3,
   kEventRawKeyModifiersChanged = 4,
   kEventHotKeyPressed = 5,
   kEventHotKeyReleased = 6
};

/*EventHotKeyRef

Represents a registered global hot key. 

typedef struct OpaqueEventHotKeyRef * EventHotKeyRef;
Discussion

You register a hot key using the RegisterEventHotKey function. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaqueEventHotKeyRef * EventHotKeyRef;

/*EventHotKeyID

Represents the ID of a global hot key. 

struct EventHotKeyID {
   OSType signature;
   UInt32 id;
};
typedef struct EventHotKeyID EventHotKeyID;
Discussion

You register a hot key using the RegisterEventHotKey function. 
Availability
Available in Mac OS X v10.0 and later.*/
struct EventHotKeyID {
   OSType signature;
   UInt32 id;
};
typedef struct EventHotKeyID EventHotKeyID;

/*Application Event Constants

Define constants related to events from kEventClassApplication.

enum {
   kEventAppActivated = 1,
   kEventAppDeactivated = 2,
   kEventAppQuit = 3,
   kEventAppLaunchNotification = 4,
   kEventAppLaunched = 5,
   kEventAppTerminated = 6,
   kEventAppFrontSwitched = 7,
   kEventAppFocusMenuBar = 8,
   kEventAppFocusNextDocumentWindow = 9,
   kEventAppFocusNextFloatingWindow = 10,
   kEventAppFocusToolbar = 11,
   kEventAppFocusDrawer = 12,
   kEventAppGetDockTileMenu = 20,
   kEventAppIsEventInInstantMouser = 104,
   kEventAppHidden = 107,
   kEventAppShown = 108,
   kEventAppSystemUIModeChanged = 109,
   kEventAppAvailableWindowBoundsChanged = 110,
   kEventAppActiveWindowChanged = 111
};
Constants
kEventAppActivated

The application was activated (resumed, in old parlance).

Available in Mac OS X v10.0 and later.
kEventAppDeactivated

The application was deactivated (suspended, in old parlance).

Available in Mac OS X v10.0 and later.
kEventAppQuit

The application is quitting.

Available in Mac OS X v10.0 and later.
kEventAppLaunchNotification

Response to asynchronous application launch.

Available in Mac OS X v10.0 and later.
kEventAppLaunched

Some other application was launched. (CarbonLib 1.3 or later) 

Available in Mac OS X v10.0 and later.
kEventAppTerminated

Some other application was terminated. (CarbonLib 1.3 or later) 

Available in Mac OS X v10.0 and later.
kEventAppFrontSwitched

The frontmost application has changed. (CarbonLib 1.3 or later) 

Available in Mac OS X v10.0 and later.
kEventAppFocusMenuBar

Request to switch the keyboard focus to the menu bar. The Carbon Event Manager handles this event by default. 

Available in Mac OS X v10.2 and later.
kEventAppFocusNextDocumentWindow

Request to shift keyboard focus to the next or previous document window (depending on the state of the Shift key). If there are no more document windows in the current process, focus should shift to the document window in the next (or previous) process. 

If something other than a document window currently has keyboard focus, you should shift focus to the frontmost document window without changing the ordering of the windows. 

If the document window does not have a focused area, you should set the focus to the main control within the window. 

The Carbon Event Manager handles this event by default; if you handle this event, you should only check if the user focus is somewhere other than a document window, and if so, set the focus on the active document window. If the focus is already on a document window, your handler should always return eventNotHandledErr so that the default handler can rotate to the next window across all processes.

Available in Mac OS X v10.2 and later.
kEventAppFocusNextFloatingWindow

Request to shift keyboard focus to the next or previous floating window (depending on the state of the Shift key).

If something other than a floating window currently has keyboard focus, you should shift focus to the frontmost floating window without changing the ordering of the windows. 

If the floating window does not have a focused area, you should set the focus to the main control within the window. 

The default behavior for this event is to send a kEventCommandProcess event containing kHICommandRotateFloatingWindowsForward or kHICommandRotateFloatingWindowsBackward.

Available in Mac OS X v10.2 and later.
kEventAppFocusToolbar

Request to shift keyboard focus to the toolbar.

The default behavior for this event is to move the keyboard focus to the first item in the toolbar (assuming you are using the standard toolbar). 

Available in Mac OS X v10.2 and later.
kEventAppFocusDrawer

Request to shift keyboard focus to the drawer in the focused window.

The default behavior for this event is to move the focus to the first control in the drawer in the focused window if a drawer is present. If multiple drawers are present, focus is moved in clockwise order from one drawer to the next, starting with the top drawer, if any. If the modifiers parameter contains the shift key, focus is moved in reverse (counterclockwise) order. 

(Available in Mac OS X v10.4 and later.)

Available in Mac OS X v10.4 and later.
kEventAppGetDockTileMenu

Request to display a pop-up menu by the application’s dock tile. You should return the menu reference of the menu to display in the kEventParamMenuRef parameter. The sender of this event releases this menu after the Dock displays it, so if you supply a permanently allocated menu reference, you should call the Menu Manager function RetainMenu on it before returning from your handler. 

The default behavior for this event is to return the menu (if any) supplied by the SetApplicationDockTileMenu function (described in the Dock Manager Reference). Note that for most functions, it’s easier to set a menu using SetApplicationDockTileMenu rather than installing a handler for this event.

(Available in Mac OS X v10.1 and later.)

Available in Mac OS X v10.1 and later.
kEventAppIsEventInInstantMouser

The given event’s global mouse location is over an “instant mousing” area. An instant mousing area is an area where a mouse down should not generate ink but should be interpreted as a click.

(Available in Mac OS X v10.2 and later.)

Available in Mac OS X v10.3 and later.
kEventAppHidden

The application was hidden. (Available in Mac OS X v10.2 and later.)

Available in Mac OS X v10.2 and later.
kEventAppShown

The application was shown. (Available in Mac OS X v10.2 and later.)

Available in Mac OS X v10.2 and later.
kEventAppSystemUIModeChanged

The system user interface mode of the frontmost application has changed. (Available in Mac OS X v10.2 and later.)

Available in Mac OS X v10.2 and later.
kEventAppAvailableWindowBoundsChanged

The available window positioning bounds have changed. This event is currently sent when the Dock has changed position or size and when the display configuration has changed. A separate copy of this event is sent to each affected GDevice. (Available in Mac OS X v10.3 and later.)

Available in Mac OS X v10.3 and later.
kEventAppActiveWindowChanged

The active window in the current process has changed.The Window Manager uses ActiveNonFloatingWindow to track the active window. When SelectWindow is called on a window, that window is made the new active window. At that time, the Window Manager also posts a kEventAppActiveWindowChanged event to the main event queue.

If more than one window is activated sequentially before the event loop is run, a single kEventAppActiveWindowChanged event is left in the event queue. Its PreviousActiveWindow parameter will be the window that was originally active, and its CurrentActiveWindow parameter will be the window that was finally active.

(Available in Mac OS X v10.3 and later.)

Available in Mac OS X v10.3 and later.
Discussion

You can pass any of these constants when registering an event handler. You can also pass these constants to the CreateEvent function to specify the type of application event you want to create.*/

enum {
   kEventAppActivated = 1,
   kEventAppDeactivated = 2,
   kEventAppQuit = 3,
   kEventAppLaunchNotification = 4,
   kEventAppLaunched = 5,
   kEventAppTerminated = 6,
   kEventAppFrontSwitched = 7,
   kEventAppFocusMenuBar = 8,
   kEventAppFocusNextDocumentWindow = 9,
   kEventAppFocusNextFloatingWindow = 10,
   kEventAppFocusToolbar = 11,
   kEventAppFocusDrawer = 12,
   kEventAppGetDockTileMenu = 20,
   kEventAppIsEventInInstantMouser = 104,
   kEventAppHidden = 107,
   kEventAppShown = 108,
   kEventAppSystemUIModeChanged = 109,
   kEventAppAvailableWindowBoundsChanged = 110,
   kEventAppActiveWindowChanged = 111
};

/*Window Action Event Constants

Define constants related to events from kEventClassWindow.

enum {
   kEventWindowCollapse = 66,
   kEventWindowCollapseAll = 68,
   kEventWindowExpand = 69,
   kEventWindowExpandAll = 71,
   kEventWindowClose = 72,
   kEventWindowCloseAll = 74,
   kEventWindowZoom = 75,
   kEventWindowZoomAll = 77,
   kEventWindowContextualMenuSelect = 78,
   kEventWindowPathSelect = 79,
   kEventWindowGetIdealSize = 80,
   kEventWindowGetMinimumSize = 81,
   kEventWindowGetMaximumSize = 82,
   kEventWindowConstrain = 83,
   kEventWindowHandleContentClick = 85,
   kEventWindowTransitionStarted = 88,
   kEventWindowTransitionCompleted = 89,
   kEventWindowGetDockTileMenu = 90,
   kEventWindowGetDockTileMenu = 90,
   kEventWindowProxyBeginDrag = 128,
   kEventWindowProxyEndDrag = 129,
   kEventWindowToolbarSwitchMode = 150
};
Constants
kEventWindowCollapse

If the window is not collapsed, this event is sent by the standard window handler after it has received kEventWindowClickCollapseRgn and received true from a call to TrackBox. The default behavior is to call CollapseWindow and then send kEventWindowCollapsed if no error is received from CollapseWindow. (Available in Mac OS X and CarbonLib 1.1 and later.)

Available in Mac OS X v10.0 and later.
kEventWindowCollapseAll

Sent by the standard window handler (when the option key is down) after it has received kEventWindowClickCollapseRgn and then received true from a call to TrackBox. The default response is to send each window of the same class as the clicked window a kEventWindowCollapse event. (Available in Mac OS X and CarbonLib 1.1 and later.)

Available in Mac OS X v10.0 and later.
kEventWindowExpand

If the window is collapsed, this event is sent by the standard window handler after it has received kEventWindowClickCollapseRgn and received true from a call to TrackBox. The default response is to call CollapseWindow, then send kEventWindowExpanded. Note that you will not receive this event before a window is expanded from the dock, since minimized windows in the dock don’t uses collapse boxes to unminimize. (Available in Mac OS X and CarbonLib 1.1 and later.)

Available in Mac OS X v10.0 and later.
kEventWindowExpandAll

Sent by the standard window handler (when the option key is down) after it has received kEventWindowClickCollapseRgn and then received true from a call to TrackBox. The default response is to send each window of the same class as the clicked window a kEventWindowExpand event. (Available in Mac OS X and CarbonLib 1.1 and later.)

Available in Mac OS X v10.0 and later.
kEventWindowClose

Sent by the standard window handler after it has received kEventWindowClickCloseRgn and successfully called TrackBox. Your application might intercept this event to check if the document is dirty, and display a Save/Don’tSave/Cancel alert. 

The default response is to call the Window Manager function DisposeWindow. (Available in Mac OS X and CarbonLib 1.1 and later.)

Available in Mac OS X v10.0 and later.
kEventWindowCloseAll

Sent by the standard window handler (when the option key is down) after it has received kEventWindowClickCloseRgn and received true from a call to TrackGoAway. The standard window handler’s response is to send each window with the same class as the clicked window a kEventWindowClose event. (Available in Mac OS X and CarbonLib 1.1 and later.)

Available in Mac OS X v10.0 and later.
kEventWindowZoom

Sent by the standard window handler upon receiving kEventWindowClickZoomRgn and then receiving true from a call to TrackBox. The default behavior is to zoom the window using ZoomWindowIdeal then, if successful, send a kEventWindowZoomed event. (Available in Mac OS X and CarbonLib 1.1 and later.)

Available in Mac OS X v10.0 and later.
kEventWindowZoomAll

Sent by the standard window handler (when the option key is down) after it has received kEventObjectClickZoomRgn and received true from a call to TrackBox. The standard window handler’s response is to send each window with the same class as the clicked window a kEventObjectZoom event and then to reposition all zoomed windows using the kWindowCascadeOnParentWindowScreen positioning method. For more details, see the Window Manager Reference for more details. (Available in Mac OS X and CarbonLib 1.1 and later.)

Available in Mac OS X v10.0 and later.
kEventWindowContextualMenuSelect

Sent when either the right mouse button is pressed, or the control key is held down and the left mouse button is pressed, or the left mouse button is held down for more than 1/4th of a second (and nothing else is handling the generated mouse tracking events). The standard window handler ignores this event. Note that this event supports kEventParamMouseLocation and other parameters associated with the kEventMouseDown event. (Available in Mac OS X and CarbonLib 1.1 and later.)

Available in Mac OS X v10.0 and later.
kEventWindowPathSelect

Sent when the Window Manager function IsWindowPathSelectClick would return true. The standard window handler sends this event while handling kEventWindowClickDragRgn if the click occurs in the proxy icon. Set the menu reference parameter (kEventParamMenuRef) in the event if you wish to customize the menu passed to the Window Manager function WindowPathSelect. (Available in Mac OS X and CarbonLib 1.1 and later.)

Available in Mac OS X v10.0 and later.
kEventWindowGetIdealSize

Sent by the standard window handler to determine the standard state for zooming. The standard window handler ignores this event. (Available in Mac OS X and CarbonLib 1.1 and later.)

Available in Mac OS X v10.0 and later.
kEventWindowGetMinimumSize

Sent by the standard window handler to determine the minimum size of the window (used during window resizing). (Available in Mac OS X and CarbonLib 1.1 and later.)

In Mac OS X v10.2 and later, the default behavior is to call the Window Manager function GetWindowResizeLimits and return the size obtained in the kEventParamDimensions parameter. There is no default behavior before Mac OS X v10.2.

Available in Mac OS X v10.0 and later.
kEventWindowGetMaximumSize

Sent by the standard window handler to determine the maximum size of the window (used during window resizing). (Available in Mac OS X and CarbonLib 1.1 and later.) On CarbonLib 1.6 and Mac OS X v10.2 and later, this event is also sent by the Window Manager functions ResizeWindow and GrowWindow if the sizeContraints parameter was set to NULL. 

In Mac OS X v10.2 and later, the default behavior is to call the Window Manager function GetWindowResizeLimits and return the size obtained in the kEventParamDimensions parameter. There is no default behavior before Mac OS X v10.2.

Available in Mac OS X v10.0 and later.
kEventWindowConstrain

Sent by the standard window handler to warn of a change in the available window positioning bounds on the window (for example, due to a change in screen resolution or Dock size). (Available in Mac OS X and CarbonLib 1.5 and later.)

In Mac OS v10.0.x the default behavior is to call the Window Manager function ConstrainWindowToScreen on the window with the kWindowConstrainMoveRegardlessOfFit attribute set and a window region code of kWindowDragRgn. The window is constrained to the bounds returned by the Window Manager function GetAvailableWindowPositioningBounds for that display device. 

In Mac OS X v10.1 and later the default behavior is to call ConstrainWindowToScreen on the window with the kWindowConstrainMoveRegardlessOfFit and kWindowConstrainAllowPartial attributes set, and a window region code of kWindowDragRgn. Instead of accepting the normal device bounds, you can also modify the kEventParamAvailableBounds for this event, and the default handler constrains the window to those bounds.

In Mac OS X v10.2 and later, you can set the following optional parameters:
kEventParamAttributes: You can set the constraint attributes to pass to ConstrainWindowToScreen by specifying them in this parameter. 
kEventParamWindowRegionCode: If you set this parameter (which must be of type WindowRegionCode), the standard window handler passes this value to ConstrainWindowToScreen instead of kWindowDragRgn.

In addition, the following optional parameters may exist in Mac OS X v10.2 and later:
kEventParamRgnHandle: Contains the gray region before a configuration change in the available graphics devices (screens). This parameter exists only if the constrain event occurred because the user changed the screen configuration. You can call the Window Manager function GetGrayRgn to obtain the current gray region. 
kEventParamCurrentDockRect: Holds the current bounds of the dock. This parameter and kEventParamPreviousDockRect exist only if the constrain event resulted from a change in the Dock size or position. 
kEventParamPreviousDockRect: Holds the previous bounds of the dock.

Available in Mac OS X v10.0 and later.
kEventWindowHandleContentClick

Sent by the standard window handler in response to kEventWindowClickContentRgn when a mouse click is in the content region but is not a contextual menu invocation or a click on a control. Note that this event supports kEventParamMouseLocation and other parameters associated with the kEventMouseDown event.

The standard handler ignores this event. 

(Available in Mac OS X and CarbonLib 1.3.1 and later.)

Available in Mac OS X v10.0 and later.
kEventWindowTransitionStarted

Sent to all handlers registered for it. It is sent by the TransitionWindow, TransitionWindowAndParent, and TransitionWindowWithOptions APIs just before the first frame of the transition animation.

(Available in Mac OS X v10.3 and later.)

Available in Mac OS X v10.3 and later.
kEventWindowTransitionCompleted

Sent to all handlers registered for it. It is sent by the TransitionWindow, TransitionWindowAndParent, and TransitionWindowWithOptions APIs just after the last frame of the transition animation.

(Available in Mac OS X v10.3 and later.) 

Available in Mac OS X v10.3 and later.
kEventWindowGetDockTileMenu

Sent when a dock tile wants to display a menu. The sender of this event releases the menu after the Dock has displayed it, so if you want to keep the menu, you must call RetainMenu on it before returning from the event handler. 

If you do not handle this event, the default behavior is to call the Window Manager function GetWindowDockTileMenu and return the menu obtained in the kEventParamMenuRef parameter. If no menu is specified, the default handler returns eventNotHandledErr. 

Note that in most cases it is simpler to call the SetWindowDockTileMenu function directly rather than register for this event. 

(Available in Mac OS X v10.2 and later.)

Available in Mac OS X v10.2 and later.
kEventWindowProxyBeginDrag

Sent before a proxy icon drag; you can attach data to the DragRef in the event. The standard handler ignores this event. (Available in Mac OS X v10.0 and later, and CarbonLib 1.1 and later.)

Available in Mac OS X v10.0 and later.
kEventWindowProxyEndDrag

Sent after the proxy icon drag is complete, whether successful or not. The standard handler ignores this event. (Available in Mac OS X v10.0 and later, and CarbonLib 1.1 and later.)

Available in Mac OS X v10.0 and later.
kEventWindowToolbarSwitchMode

The toolbar button (that is, the oblong button used to show and hide the toolbar) was successfully clicked. The standard window handler sends this event when receiving a true return value from TrackBox during the handling of the kEventWindowClickToobarButtonRgn event. Note, however, that you do not have to have the standard window handler installed to receive this event; any window that has a toolbar receives this event when its toolbar button is successfully clicked. Note that if you handle this event, your application is responsible for keeping track of the toolbar’s mode (visible or hidden). 

The default response is to toggle the toolbar (that is, show it if it is hidden, and vice-versa) when the toolbar button is clicked. If the option key is held down during the click, all toolbars in the windows of the current process are toggled. If the command key is down during the click, the toolbar mode is cycled between icons and text, icons alone, and text alone. If both the command and option keys are held during the click, the system displays the toolbar configuration sheet. 

(

Available in Mac OS X only.) 
Discussion

These events indicate that certain changes have been made to a window. These events have greater semantic meaning than the low-level window click events and are usually preferred for overriding.*/
enum {
   kEventWindowCollapse = 66,
   kEventWindowCollapseAll = 68,
   kEventWindowExpand = 69,
   kEventWindowExpandAll = 71,
   kEventWindowClose = 72,
   kEventWindowCloseAll = 74,
   kEventWindowZoom = 75,
   kEventWindowZoomAll = 77,
   kEventWindowContextualMenuSelect = 78,
   kEventWindowPathSelect = 79,
   kEventWindowGetIdealSize = 80,
   kEventWindowGetMinimumSize = 81,
   kEventWindowGetMaximumSize = 82,
   kEventWindowConstrain = 83,
   kEventWindowHandleContentClick = 85,
   kEventWindowTransitionStarted = 88,
   kEventWindowTransitionCompleted = 89,
   kEventWindowGetDockTileMenu = 90,
   kEventWindowProxyBeginDrag = 128,
   kEventWindowProxyEndDrag = 129,
   kEventWindowToolbarSwitchMode = 150
};

/*HICommand

Represents a command event; this structure has been superseded by the HICommandExtended structure.

struct HICommand {
   UInt32 attributes
   UInt32 commandID
   struct {
      MenuRef menuRef;
      MenuItemIndex menuItemIndex;
   } menu;
};
typedef struct HICommand HICommand;
Fields
attributes

Attributes of the command event. 
commandID

The command ID of the command event.
menuRef

A reference to the menu containing the HICommand.
menuItemIndex

The index number of the menu item containing the HICommand.
Availability
Available in Mac OS X v10.0 and later.*/
struct HICommand {
   UInt32 attributes;
   UInt32 commandID;
   struct {
      MenuRef menuRef;
      MenuItemIndex menuItemIndex;
   } menu;
};
typedef struct HICommand HICommand;

/*Event Class Constants

Define constants for specifying event classes.

typedef UInt32 EventClass;
enum {
   kEventClassMouse = 'mous',
   kEventClassKeyboard = 'keyb',
   kEventClassTextInput = 'text',
   kEventClassApplication = 'appl',
   kEventClassAppleEvent = 'eppc',
   kEventClassMenu = 'menu',
   kEventClassWindow = 'wind',
   kEventClassControl = 'cntl',
   kEventClassCommand = 'cmds',
   kEventClassTablet = 'tblt',
   kEventClassVolume = 'vol ',
   kEventClassAppearance = 'appm',
   kEventClassService = 'serv',
   kEventClassToolbar = 'tbar',
   kEventClassToolbarItem = 'tbit',
   kEventClassToolbarItemView = 'tbiv',
   kEventClassAccessibility = 'acce'.
   kEventClassSystem = 'macs',
   kEventClassInk = 'ink ',
   kEventClassTSMDocumentAccess = 'tdac'
};
Constants
kEventClassMouse

Events related to the mouse (mouse down/up/moved).

Available in Mac OS X v10.0 and later.
kEventClassKeyboard

Events related to the keyboard. 

Available in Mac OS X v10.0 and later.
kEventClassTextInput

Events related to text input (by keyboard or by input method). 

Available in Mac OS X v10.0 and later.
kEventClassApplication

Application-level events (launch, quit, and so on). 

Available in Mac OS X v10.0 and later.
kEventClassAppleEvent

Apple Events. 

Available in Mac OS X v10.0 and later.
kEventClassMenu

Menu-related events. 

Available in Mac OS X v10.0 and later.
kEventClassWindow

Window-related events. 

Available in Mac OS X v10.0 and later.
kEventClassControl

Control-related events. 

Available in Mac OS X v10.0 and later.
kEventClassCommand

Command events (HICommands). 

Available in Mac OS X v10.0 and later.
kEventClassTablet

Events related to tablet input. 

Available in Mac OS X v10.0 and later.
kEventClassVolume

Events related to File Manager volumes.

Available in Mac OS X v10.0 and later.
kEventClassAppearance

Events related to the Appearance Manager. 

Available in Mac OS X v10.1 and later.
kEventClassService

Events related to the Services Manager.

Available in Mac OS X v10.1 and later.
kEventClassToolbar

Events related to the toolbar (not the toolbar window class).

Available in Mac OS X v10.2 and later.
kEventClassToolbarItem

Events related to toolbar items. 

Available in Mac OS X v10.2 and later.
kEventClassToolbarItemView

Events related to toolbar item views.

Available in Mac OS X v10.3 and later.
kEventClassAccessibility

Events related to application accessibility features. 

Available in Mac OS X v10.2 and later.
kEventClassSystem

Events related to the system. 

Available in Mac OS X v10.3 and later.
kEventClassInk

Events related to ink. 

Available in Mac OS X v10.3 and later.
kEventClassTSMDocumentAccess

Events related to Text Services Manager document access.

Available in Mac OS X v10.3 and later.
Discussion

Event classes specify broad categories of events, grouped according to the object they are associated with. Within an event class are specific event types.*/
typedef UInt32 EventClass;
enum {
   kEventClassMouse = 'mous',
   kEventClassKeyboard = 'keyb',
   kEventClassTextInput = 'text',
   kEventClassApplication = 'appl',
   kEventClassAppleEvent = 'eppc',
   kEventClassMenu = 'menu',
   kEventClassWindow = 'wind',
   kEventClassControl = 'cntl',
   kEventClassCommand = 'cmds',
   kEventClassTablet = 'tblt',
   kEventClassVolume = 'vol ',
   kEventClassAppearance = 'appm',
   kEventClassService = 'serv',
   kEventClassToolbar = 'tbar',
   kEventClassToolbarItem = 'tbit',
   kEventClassToolbarItemView = 'tbiv',
   kEventClassAccessibility = 'acce',
   kEventClassSystem = 'macs',
   kEventClassInk = 'ink ',
   kEventClassTSMDocumentAccess = 'tdac'
};

/*Standard Command ID Constants

Define command IDs for common menu commands and controls.

enum {
   kHICommandOK = 'ok  ',
   kHICommandCancel = 'not!',
   kHICommandQuit = 'quit',
   kHICommandUndo = 'undo',
   kHICommandRedo = 'redo',
   kHICommandCut = 'cut ',
   kHICommandCopy = 'copy',
   kHICommandPaste = 'past',
   kHICommandClear = 'clea',
   kHICommandSelectAll = 'sall',
   kHICommandHide = 'hide',
   kHICommandHideOthers = 'hido',
   kHICommandShowAll = 'shal',
   kHICommandPreferences = 'pref',
   kHICommandZoomWindow = 'zoom',
   kHICommandMinimizeWindow = 'mini',
   kHICommandMinimizeAll = 'mina',
   kHICommandMaximizeWindow = 'maxi',
   kHICommandMaximizeAll = 'maxa',
   kHICommandArrangeInFront = 'frnt',
   kHICommandBringAllToFront = 'bfrt',
   kHICommandWindowListSeparator = 'wldv',
   kHICommandWindowListTerminator = 'wlst',
   kHICommandSelectWindow = 'swin',
   kHICommandRotateWindowsForward = 'rotw',
   kHICommandRotateWindowsBackward = 'rotb',
   kHICommandRotateFloatingWindowsForward = 'rtfw',
   kHICommandRotateFloatingWindowsBackward = 'rtfb',
   kHICommandAbout = 'abou',
   kHICommandNew = 'new ',
   kHICommandOpen = 'open',
   kHICommandClose = 'clos',
   kHICommandSave = 'save',
   kHICommandSaveAs = 'svas',
   kHICommandRevert = 'rvrt',
   kHICommandPrint = 'prnt',
   kHICommandPageSetup = 'page',
   kHICommandAppHelp = 'ahlp',
   kHICommandShowCharacterPalette = 'chrp',
   kHICommandShowSpellingPanel = 'shsp',
   kHICommandCheckSpelling = 'cksp',
   kHICommandChangeSpelling = 'chsp',
   kHICommandCheckSpellingAsYouType = 'chsp',
   kHICommandIgnoreSpelling = 'igsp',
   kHICommandLearnWord = 'lrwd'
};
Constants
kHICommandOK

The OK button in a dialog or alert.

Available in Mac OS X v10.0 and later.
kHICommandCancel

The Cancel button in a dialog or alert. 

Available in Mac OS X v10.0 and later.
kHICommandQuit

The application should quit. 

Available in Mac OS X v10.0 and later.
kHICommandUndo

The last editing operation should be undone. 

Available in Mac OS X v10.0 and later.
kHICommandRedo

The last editing operation should be redone. 

Available in Mac OS X v10.0 and later.
kHICommandCut

The selected items should be cut. 

Available in Mac OS X v10.0 and later.
kHICommandCopy

The selected items should be copied. 

Available in Mac OS X v10.0 and later.
kHICommandPaste

The contents of the clipboard should be pasted. 

Available in Mac OS X v10.0 and later.
kHICommandClear

The selected items should be deleted. 

Available in Mac OS X v10.0 and later.
kHICommandSelectAll

All items in the active window should be selected. 

Available in Mac OS X v10.0 and later.
kHICommandHide

The application should be hidden. The Menu Manager responds to this command automatically; your application does not need to handle it. 

Available in Mac OS X v10.0 and later.
kHICommandHideOthers

Other applications should be hidden. The Menu Manager responds to this command automatically; your application does not need to handle it. 

Available in Mac OS X v10.1 and later.
kHICommandShowAll

All applications should become visible. The Menu Manager responds to this command automatically; your application does not need to handle it. 

Available in Mac OS X v10.1 and later.
kHICommandPreferences

The Preferences menu item has been selected.

Available in Mac OS X v10.0 and later.
kHICommandZoom

The active window should be zoomed in or out. The default application handler responds to this event automatically. Your application does not need to handle this event, but you may want to install a Carbon event handler for kEventWindowGetIdealSize to return the ideal size for your document windows.
kHICommandMinimizeWindow

The active window should be minimized. The default application handler will respond to this event automatically; your application does not need to handle it. 

Available in Mac OS X v10.0 and later.
kHICommandMinimizeAll

All collapsable windows should be minimized. The default application handler responds to this event automatically; your application does not need to handle it.

Available in Mac OS X v10.1 and later.
kHICommandMaximizeWindow

The active window should be maximized. Sent only on Mac OS 9. The default application handler will respond to this event automatically; your application does not need to handle it.

Available in Mac OS X v10.1 and later.
kHICommandMaximizeAll

All collapsible windows should be maximized. This event is not sent or handled on Mac OS X.

Available in Mac OS X v10.1 and later.
kHICommandArrangeInFront

All document-class windows should be arranged in a stack. The default application handler responds to this event automatically; your application does not need to handle it.

Available in Mac OS X v10.0 and later.
kHICommandBringAllToFront

All windows of this application should be brought in front of windows from other applications. Sent only on Mac OS X. The default application handler responds to this event automatically; your application does not need to handle it.

Available in Mac OS X v10.1 and later.
kHICommandWindowListSeparator

A placeholder to mark the separator item dividing the Zoom/Minimize/Maximize/Arrange menu items in the standard Window menu from the menu items listing the visible windows. If you need to add your own menu items to the standard Window menu before the window list section, you can use GetIndMenuItemWithCommandID (described in the Menu Manager Reference in the User Experience section of the Carbon documentation) to look for the menu item with this command ID and insert your menu items before the item with this ID.

Available in Mac OS X v10.1 and later.
kHICommandWindowListTerminator

Used as a placeholder to mark the end of the window list section of the standard Window menu. If you need to add your own menu items to the standard Window menu after the window list section, you can use GetIndMenuItemWithCommandID (described in the Menu Manager Reference in the User Experience section of the Carbon documentation) to look for the menu item with this command ID and insert your items after the item with this ID.

Available in Mac OS X v10.1 and later.
kHICommandSelectWindow

A window in the standard Window menu has been selected and should be activated. In Mac OS X v10.3, this command is also sent by the toolbox whenever it needs to activate a window in your application. For example, it is used when a window is selected from the application’s Dock menu, and when a window that uses the standard window event handler is clicked. The default application handler responds to this event automatically; your application does not need to handle it.

Available in Mac OS X v10.1 and later.
kHICommandRotateWindowsForward

The Rotate Windows hot key (cmd-~ by default) has been pressed. Non-floating windows should be rotated so that the window after the active window is activated. The default application handler responds to this event automatically; your application does not need to handle it.

Available in Mac OS X v10.2 and later.
kHICommandRotateWindowsBackward

The Rotate Windows hot key (cmd-~ by default) has been pressed. Non-floating windows should be rotated so that the window before the active window is activated. The default application handler responds to this event automatically; your application does not need to handle it.

Available in Mac OS X v10.2 and later.
kHICommandRotateFloatingWindowsForward

The floating window focus hot key (ctl-F6 by default) has been pressed, and floating windows should be rotated so that the window after the focused window is activated. The default application handler responds to this event automatically; your application does not need to handle it.

Available in Mac OS X v10.2 and later.
kHICommandRotateFloatingWindowsBackward

The floating window focus hot key (ctl-F6 by default) has been pressed, and floating windows should be rotated so that the window before the focused window is activated. The default application handler responds to this event automatically; your application does not need to handle it.

Available in Mac OS X v10.2 and later.
kHICommandAbout

The About menu item has been selected. In Mac OS X v10.3 and later, RunApplicationEventLoop installs a handler for this command ID on the application target that handles this event automatically by calling HIAboutBox. Your application can install its own handler if you want to display a customized about box.

Available in Mac OS X v10.0 and later.
kHICommandNew

A new document or item should be created.

Available in Mac OS X v10.1 and later.
kHICommandOpen

The user wants to open an existing document.

Available in Mac OS X v10.1 and later.
kHICommandClose

The active window should be closed. This command is typically be generated by a Close menu item. In Mac OS X v10.3 and later, the default application handler responds to this command by sending a kEventWindowClose event; on earlier systems, only the standard window event handler responded to this event.

Available in Mac OS X v10.1 and later.
kHICommandSave

The active document should be saved.

Available in Mac OS X v10.1 and later.
kHICommandSaveAs

The user wants to save the active document under a new name.

Available in Mac OS X v10.1 and later.
kHICommandRevert

The contents of the active document should be reverted to the last saved version.

Available in Mac OS X v10.1 and later.
kHICommandPrint

The active window should be printed.

Available in Mac OS X v10.1 and later.
kHICommandPageSetup

The user wants to configure the current page margins, formatting, and print options.

Available in Mac OS X v10.1 and later.
kHICommandAppHelp

The application’s help book should be displayed. The Help Manager installs a handler for this command ID on the Help menu returned by HMGetHelpMenu and responds to this event automatically. Your application does not need to handle it. In Mac OS X v10.4, the Help Manager installs a handler for this event on the application event target rather than on the Help menu.

Available in Mac OS X v10.1 and later.
kHICommandShowCharacterPalette

The character palette needs to be shown. Events with this command ID are only generated in Mac OS X v10.3 and later. The toolbox will respond to this event automatically; your application does not need to handle it.

Available in Mac OS X v10.3 and later.
kHICommandShowSpellingPanel

Display the spelling panel if it is not already visible. Events with this command ID are only generated in Mac OS X v10.4 and later. If spell checking has been enabled in the Multilingual Text Engine (MLTE) or an HITextView, this command is handled automatically.

Available in Mac OS X v10.4 and later.
kHICommandCheckSpelling

Spell check the document now. Events with this command ID are only generated in Mac OS X v10.4 and later. If spell checking has been enabled in MLTE or an HITextView, this command is handled automatically.

Available in Mac OS X v10.4 and later.
kHICommandChangeSpelling

Change the spelling. Events with this command ID are only generated in Mac OS X v10.4 and later. If spell checking has been enabled in MLTE or an HITextView, this command is handled automatically.

Available in Mac OS X v10.4 and later.
kHICommandCheckSpellingAsYouType

Begin interactive spell checking. Events with this command ID are only generated in Mac OS X v10.4 and later. If spell checking has been enabled in MLTE or an HITextView, this command is handled automatically.

Available in Mac OS X v10.4 and later.
kHICommandIgnoreSpelling

Ignore this word while spell checking this text view. Events with this command ID are only generated in Mac OS X v10.4 and later. If spell checking has been enabled in MLTE or an HITextView, this command is handled automatically.

Available in Mac OS X v10.4 and later.
kHICommandLearnWord

Learn this spelling for all documents. Events with this command ID are generated only in Mac OS X v10.4 and later. If spell checking has been enabled in MLTE or an HITextView, this command is handled automatically.

Available in Mac OS X v10.4 and later.
Discussion

You should use these values for standard menu and control commands rather than defining your own.*/
enum {
   kHICommandOK = 'ok  ',
   kHICommandCancel = 'not!',
   kHICommandQuit = 'quit',
   kHICommandUndo = 'undo',
   kHICommandRedo = 'redo',
   kHICommandCut = 'cut ',
   kHICommandCopy = 'copy',
   kHICommandPaste = 'past',
   kHICommandClear = 'clea',
   kHICommandSelectAll = 'sall',
   kHICommandHide = 'hide',
   kHICommandHideOthers = 'hido',
   kHICommandShowAll = 'shal',
   kHICommandPreferences = 'pref',
   kHICommandZoomWindow = 'zoom',
   kHICommandMinimizeWindow = 'mini',
   kHICommandMinimizeAll = 'mina',
   kHICommandMaximizeWindow = 'maxi',
   kHICommandMaximizeAll = 'maxa',
   kHICommandArrangeInFront = 'frnt',
   kHICommandBringAllToFront = 'bfrt',
   kHICommandWindowListSeparator = 'wldv',
   kHICommandWindowListTerminator = 'wlst',
   kHICommandSelectWindow = 'swin',
   kHICommandRotateWindowsForward = 'rotw',
   kHICommandRotateWindowsBackward = 'rotb',
   kHICommandRotateFloatingWindowsForward = 'rtfw',
   kHICommandRotateFloatingWindowsBackward = 'rtfb',
   kHICommandAbout = 'abou',
   kHICommandNew = 'new ',
   kHICommandOpen = 'open',
   kHICommandClose = 'clos',
   kHICommandSave = 'save',
   kHICommandSaveAs = 'svas',
   kHICommandRevert = 'rvrt',
   kHICommandPrint = 'prnt',
   kHICommandPageSetup = 'page',
   kHICommandAppHelp = 'ahlp',
   kHICommandShowCharacterPalette = 'chrp',
   kHICommandShowSpellingPanel = 'shsp',
   kHICommandCheckSpelling = 'cksp',
   kHICommandChangeSpelling = 'chsp',
   kHICommandCheckSpellingAsYouType = 'chsp',
   kHICommandIgnoreSpelling = 'igsp',
   kHICommandLearnWord = 'lrwd'
};


/*Command Event Constants

Define constants related to events from kEventClassCommand.

enum {
   kEventProcessCommand = 1,
   kEventCommandProcess = 1,
   kEventCommandUpdateStatus = 2
};
Constants
kEventProcessCommand

A command has been invoked and the application should handle it. This event is sent when the user chooses a menu item or when a control with a command is pressed. Some senders of this event will also include the modifier keys that were pressed by the user when the command was invoked, but this parameter is optional. 

Available in Mac OS X v10.0 and later.
kEventCommandProcess

Same as kEventProcessCommand. 

Available in Mac OS X v10.0 and later.
kEventCommandUpdateStatus

Sent when updates related to the command event may be required. When you receive this event, you should update the necessary user interface elements in your application to reflect the current status of the command. For example, if the command has the kHICommandFromMenu bit set, you should update the menu item state, text, and so on, to reflect the current state of your application.

Note that the standard handler for kEventMenuEnableItems automatically sends this event to your menu commands. As this can cause a performance hit if you have many menu items, you can choose to bypass these updates by installing a no-op handler for kEventMenuEnableItems that simply returns noErr. 

Available in Mac OS X v10.0 and later.
Discussion

You pass this constant to the CreateEvent function to indicate the type of command event you want to create. Future releases of the Carbon Event Manager will provide additional command event types.*/
enum {
   kEventProcessCommand = 1,
   kEventCommandProcess = 1,
   kEventCommandUpdateStatus = 2
};


/*Alternate Mouse Tracking Result Constants

Define constants for alternate mouse tracking results.

enum {
   kMouseTrackingMousePressed = kMouseTrackingMouseDown,
   kMouseTrackingMouseReleased = kMouseTrackingMouseUp
};
Constants
kMouseTrackingMousePressed

The user pressed any mouse button.

Available in Mac OS X v10.0 and later.
kMouseTrackingMouseReleased

The user released the mouse button.

Available in Mac OS X v10.0 and later.*/

enum {
   kMouseTrackingMousePressed = kMouseTrackingMouseDown,
   kMouseTrackingMouseReleased = kMouseTrackingMouseUp
};


//function


/*RunApplicationEventLoop

Runs the application event loop.

void RunApplicationEventLoop ();
Discussion

This function is used as the main event loop for a Carbon Event-based application. Once entered, this function waits for events to arrive and dispatches them to your event handlers automatically. 

Note that calling RunApplicationEventLoop also installs the standard application handler, which provides standard handler responses for menu and application events. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/
void RunApplicationEventLoop ();

/*GetApplicationEventTarget

Obtains the event target reference for the application.

EventTargetRef GetApplicationEventTarget ();
Return Value

An event target reference. 
Discussion

Once you obtain this reference, you can send events to the target and install event handlers on it. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/
EventTargetRef GetApplicationEventTarget ();

/*GetApplicationEventTarget

Obtains the event target reference for the application.

EventTargetRef GetApplicationEventTarget ();
Return Value

An event target reference. 
Discussion

Once you obtain this reference, you can send events to the target and install event handlers on it. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/
EventTargetRef GetApplicationEventTarget ();

/*GetWindowEventTarget

Obtains the event target reference for a specified window. 

EventTargetRef GetWindowEventTarget (
   WindowRef inWindow
);
Parameters
inWindow

The window to return the event target for. See the QuickDraw Manager documentation for a description of the WindowRef data type.
Return Value

An event target reference. 
Discussion

Once you obtain this reference, you can send events to the target and install an event handler on it. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/
EventTargetRef GetWindowEventTarget (
   WindowRef inWindow
);

/*RegisterEventHotKey

Registers a global hot key.

OSStatus RegisterEventHotKey (
   UInt32 inHotKeyCode,
   UInt32 inHotKeyModifiers,
   EventHotKeyID inHotKeyID,
   EventTargetRef inTarget,
   OptionBits inOptions,
   EventHotKeyRef * outRef
);
Parameters
inHotKeyCode

The virtual key code of the hot key you want to register. 
inHotKeyModifiers

The keyboard modifiers to look for. In Mac OS X v10.2 and earlier, if you do not specify a modifier key, this function returns paramErr. In Mac OS X v10.3 and later, passing 0 does not cause an error.
inHotKeyID

The application-specified hot key ID. You will receive this ID in the kEventHotKeyPressed event as the direct object parameter. 
inTarget

The target to notify when the hot key is pressed. 
inOptions

Currently unused. You must pass 0.
outRef

On return, a reference to the new hot key. You need this reference if you later wish to unregister it. 
Return Value

A result code. See “Carbon Event Manager Result Codes”.
Discussion

This function registers a global hot key based on the virtual key code and modifiers you pass in. When the user enters the hot-key combination, a kEventHotKeyPressed event is sent to the target you specified. Only one such combination can exist for the current application (that is, multiple entities in the same application cannot register for the same hot key combination). The same hot key can, however, be registered by multiple applications. This means that multiple applications can potentially be notified when a particular hot key is requested. This might not necessarily be desirable, but it is how it works at present. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/
OSStatus RegisterEventHotKey (
   UInt32 inHotKeyCode,
   UInt32 inHotKeyModifiers,
   EventHotKeyID inHotKeyID,
   EventTargetRef inTarget,
   OptionBits inOptions,
   EventHotKeyRef * outRef
);

/*GetControlEventTarget

Obtains the event target reference for the specified control.

EventTargetRef GetControlEventTarget (
   ControlRef inControl
);
Parameters
inControl

The control to return the target for. See the Control Manager documentation for a description of the ControlRef data type.
Return Value

An event target reference. 
Discussion

Once you obtain this reference, you can send events to the target and install event handlers on it. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/
EventTargetRef GetControlEventTarget (
   ControlRef inControl
);

/*UnregisterEventHotKey

Unregisters a global hot key. 

OSStatus UnregisterEventHotKey (
   EventHotKeyRef inHotKey
);
Parameters
inHotKey

The event hot key reference of the hot key you want to unregister. 
Return Value

A result code. See “Carbon Event Manager Result Codes”.
Discussion

Unregisters a global hot key that was previously registered with the function RegisterEventHotKey. You do not need to unregister a hot key when your application terminates; the system takes care of that for you. You can use this function if the user changes a hot key for something in your application—you would unregister the previous key and register your new key. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/
OSStatus UnregisterEventHotKey (
   EventHotKeyRef inHotKey
);

/*SetWindowDefaultButton

Specifies a default button for a window.

OSStatus SetWindowDefaultButton (
   WindowRef inWindow,
   ControlRef inControl
);
Parameters
inWindow

The window whose default button you want to set. See the Window Manager documentation for a description of the WindowRef data type.
inControl

The control to designate as the default. See the Control Manager documentation for a description of the ControlRef data type.
Return Value

A result code. See “Carbon Event Manager Result Codes”.
Discussion

You can use this function to specify a control (normally a button) to be the default for a given window. This button would be considered to have been clicked if the user instead presses the Return or Enter keys on the keyboard. 

The standard window event handler looks for keystrokes that correspond to the default button and generates events of type kEventControlHit when it detects the correct key being pressed. This is similar to the way the Dialog Manager responds to default buttons, except that instead of returning an item index for which button is pressed, the Carbon Event Manager generates a control hit event. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/
OSStatus SetWindowDefaultButton (
   WindowRef inWindow,
   ControlRef inControl
);

/*QuitApplicationEventLoop

Terminates the application event loop.

void QuitApplicationEventLoop ();
Discussion

This function is used to quit the RunApplicationEventLoop function. Typically, your application doesn’t need to call this. If your application has the Quit menu item tagged with the kHICommandQuit menu command ID, the toolbox will automatically call this for your application, automatically terminating your event loop. If your application wants to do pre-processing before the event loop exits, it should intercept either the kHICommandQuit menu command, or the kEventAppQuit event. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/
void QuitApplicationEventLoop ();

/*RunAppModalLoopForWindow

Puts the window in an application-modal state. 

OSStatus RunAppModalLoopForWindow (
   WindowRef inWindow
);
Parameters
inWindow

The window you wish to behave modally. See the Window Manager documentation for a description of the WindowRef data type.
Return Value

A result code. See “Carbon Event Manager Result Codes”.
Discussion

This function is used as a replacement for the Dialog Manager function ModalDialog to drive a Carbon Event-based modal dialog. Once called, this function will not exit until QuitAppModalLoopForWindow is called. 

While in the modal state, the standard toolbox dispatcher processes events only for the modal window and any that are above it (that is, closer to the front). This feature allows you to create stacked modal dialogs, if desired. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/
OSStatus RunAppModalLoopForWindow (
   WindowRef inWindow
);

/*QuitAppModalLoopForWindow

Quits the application-modal state for a window. 

OSStatus QuitAppModalLoopForWindow (
   WindowRef inWindow
);
Parameters
inWindow

The window that is leaving the modal state. See the Window Manager documentation for a description of the WindowRef data type.
Return Value

A result code. See “Carbon Event Manager Result Codes”.
Discussion

This function is used to quit a currently running call to RunAppModalLoopForWindow (that is, it terminates a modal loop). Typically you call this from a handler you have installed on the modal window in question when the user clicks the appropriate button (Ok, Cancel, and so on). 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/
OSStatus QuitAppModalLoopForWindow (
   WindowRef inWindow
);

/*TrackMouseLocation

Tracks the mouse, blocking your application when there is no activity.

OSStatus TrackMouseLocation (
   GrafPtr inPort,
   Point * outPt,
   MouseTrackingResult * outResult
);
Parameters
inPort

The grafport to consider for mouse coordinates. You can pass NULL for this parameter to indicate the current port. The mouse location is returned in terms of local coordinates of this port. See the QuickDraw Manager documentation for a description of the GrafPtr data type.
outPt

On exit, a pointer to the mouse location from the last mouse event that caused this function to exit. 
outResult

On exit, a pointer to a value representing what kind of event was received that cause the function to exit, such as kMouseTrackingMouseReleased. 
Return Value

A result code. See “Carbon Event Manager Result Codes”.
Discussion

Once entered, this function waits for certain mouse events (move, mouse down, mouse up). When one of these events occurs, the function returns and tells the caller what happened and where the mouse is currently located. While there is no activity, the current event loop is run, effectively blocking the current thread (save for any timers that fire). This helps to minimize CPU usage when there is nothing going on. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/
OSStatus TrackMouseLocation (
   GrafPtr inPort,
   Point * outPt,
   MouseTrackingResult * outResult
);

/*GetEventMonitorTarget

Obtains an event monitor target.

EventTargetRef GetEventMonitorTarget (
   void
);
Return Value

An event monitor target. 
Discussion

The event monitor target is a special event target used to monitor user input events across all processes. When an event handler is installed on the event monitor target, the Carbon Event Manager examines the EventTypeSpec for user input event types, such as mouse-down, mouse-up, and key-down. It then requests that the WindowServer make copies of any of these events that are sent to any process, and delivers them to the current process. These events are queued into the main thread’s event queue and are sent directly to the event handlers installed on the event monitor target during normal event dispatching. Monitored events are not sent through the normal event dispatching path for the current process. Instead, they pass through the event dispatcher target and are sent directly to the event monitor target.Handlers installed on the event monitor target receive events only when the current application is inactive. When the current application is active, all events flow through the event dispatcher target, and no events are sent to the event monitor target.Currently, the event monitor supports the following event kinds: kEventRawKeyDown, kEventRawKeyUp, kEventRawKeyRepeat, kEventRawKeyModifiersChange, kEventMouseDown, kEventMouseUp, kEventMouseMoved, kEventMouseDragged, kEventMouseWheelMoved, kEventTabletPoint, and kEventTabletProximity.To prevent keyboard events from being passed to other applications, Carbon and Cocoa password-edit-text controls enable a secure input mode while the focus is on the control. Their password-edit-text controls prevent the monitoring event target from being used to capture password keystrokes.For added security, GetEventMonitorTarget requires that “Enable access for assistive devices” be checked in the Universal Access preference pane in order to monitor kEventRawKeyDown, kEventRawKeyUp, and kEventRawKeyRepeat events. If this control is not checked, you can still install handlers for these events on the event monitor target, but no events of these types will be sent to your handler. Administrator privileges are required to enable this feature. You can determine whether this control is checked using the AXAPIEnabled function in AXUIElement.h.
Availability
Available in Mac OS X v10.3 and later.
Declared In
CarbonEvents.h*/
EventTargetRef GetEventMonitorTarget (
   void
);

/*TrackMouseLocationWithOptions

Tracks the mouse with additional options. 

OSStatus TrackMouseLocationWithOptions (
   GrafPtr inPort,
   OptionBits inOptions,
   EventTimeout inTimeout,
   Point * outPt,
   UInt32 * outModifiers,
   MouseTrackingResult * outResult
);
Parameters
inPort

The graphics port (GrafPort) to consider for mouse coordinates. You can pass NULL for this parameter to indicate the current port. The mouse location is returned in global coordinates. See the QuickDraw Manager documentation for a description of the GrafPtr data type.
inOptions

The only option supported by this function at present is the option to have the toolbox leave mouse up events in the queue, rather than pulling them (which is the default). See “Mouse Tracking Option Constant” for more information. 
inTimeout

The amount of time to wait for an event. If no events arrive within this time, kMouseTrackingTimedOut is returned in outResult. 
outPt

On return, a pointer to the mouse location from the last mouse event that caused this function to exit. If a timeout or key modifiers changed event caused this function to exit, the current mouse position at the time is returned.
outModifiers

On return, a pointer to the most recent state of the keyboard modifiers.
outResult

On return, a pointer to a value indicating the kind of event that caused the function to exit, such as kMouseTrackingMouseReleased. 
Return Value

A result code. See “Carbon Event Manager Result Codes”. 
Discussion

Once entered, this function waits for certain mouse events (move, mouse down, mouse up). When one of these events occurs, the function returns and tells the caller what happened and where the mouse is currently located. While there is no activity, the current event loop is run, effectively blocking the current thread (save for any timers that fire). This helps to minimize CPU usage when there is nothing going on. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/
OSStatus TrackMouseLocationWithOptions (
   GrafPtr inPort,
   OptionBits inOptions,
   EventTimeout inTimeout,
   Point * outPt,
   UInt32 * outModifiers,
   MouseTrackingResult * outResult
);

/*CreateTypeStringWithOSType

Converts an OSType string to a Core Foundation string. 

CFStringRef CreateTypeStringWithOSType (
   OSType inType
);
Return Value

The Core Foundation string version of the OSType string. A return value of NULL indicates that an error occurred. See the Base Services documentation for a description of the CFStringRef data type.
Discussion

You can use this function to create CFString versions of OSType data types to pass to the Services Manager. As this is a creation function, you must call CFRelease on your Core Foundation string when you no longer need it. 
Availability
Available in Mac OS X v10.1 and later.
Declared In
CarbonEvents.h*/

CFStringRef CreateTypeStringWithOSType (
   OSType inType
);

/*GetMenuEventTarget

Obtains an event target reference for the specified menu. 

EventTargetRef GetMenuEventTarget (
   MenuRef inMenu
);
Parameters
inMenu

The menu to return the target for. See the Menu Manager documentation for a description of the MenuRef data type.
Return Value

An event target reference. 
Discussion

Once you obtain this reference, you can send events to the target and install event handlers on it. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/
EventTargetRef GetMenuEventTarget (
   MenuRef inMenu
);

/*GetUserFocusWindow

Returns the current user focus window.

WindowRef GetUserFocusWindow ();
Return Value

A reference to the window receiving user focus. See the QuickDraw Manager documentation for a description of the WindowRef data type.
Discussion

This function returns a reference to the current user focus window. This window receives menu commands and keyboard input as part of the standard event dispatching. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/
WindowRef GetUserFocusWindow ();

#ifdef __cplusplus
}
#endif

#endif
