#import <Foundation/NSObject.h>
#import <Foundation/NSAppleEventDescriptor.h>
#import <Foundation/NSURL.h>
#import <Foundation/NSString.h>
#include <AppKit/NSResponder.h>
#include <AppKit/NSEvent.h>

@class NSAppleEventDescriptor, NSDictionary, NSString, NSURL;

@interface NSAppleScript : NSObject<NSCopying>

/*executeAppleEvent:error:

Executes an Apple event in the context of the receiver, as a means of allowing the application to invoke a handler in the script.

- (NSAppleEventDescriptor *)executeAppleEvent:(NSAppleEventDescriptor *)event error:(NSDictionary **)errorInfo
Parameters
event

The Apple event to execute.
errorInfo

On return, if an error occurs, a pointer to an error information dictionary.
Return Value

The result of executing the event, or nil if an error occurs.
Discussion

Compiles the receiver before executing it if it is not already compiled.

Important: You cannot use this method to send Apple events to other applications.

Availability
Available in Mac OS X v10.2 and later.*/
- (NSAppleEventDescriptor *)executeAppleEvent:(NSAppleEventDescriptor *)event error:(NSDictionary **)errorInfo;

/*initWithContentsOfURL:error:

Initializes a script instance from the source identified by the passed URL.

- (id)initWithContentsOfURL:(NSURL *)url error:(NSDictionary **)errorInfo
Parameters
url

An URL that locates a script, in either text or compiled form.
errorInfo

On return, if an error occurs, a pointer to an error information dictionary.
Return Value

The initialized script object, nil if an error occurs.
Discussion

This method is a designated initializer for NSAppleScript.
Availability
Available in Mac OS X v10.2 and later.*/
- (id)initWithContentsOfURL:(NSURL *)url error:(NSDictionary **)errorInfo;

APPKIT_EXPORT NSString  *NSAppleScriptErrorNumber;
APPKIT_EXPORT NSString  *NSAppleScriptErrorBriefMessage;
@end

