#import <Foundation/Foundation.h>
#import <DiscRecordingContent/DRFSObject.h>

@interface DRFolder : DRFSObject

/*folderWithPath:


Creates a real folder object 
private

+ (DRFolder*) folderWithPath:(NSString*)path;
Parameters
path
The path to an existing file.
Return Value

An autoreleased DRFolder object. 
Discussion 

Creates and initializes a DRFolder object that will use the folder contents of the folder located at path as a source.*/
+ (DRFolder*) folderWithPath:(NSString*)path;

@end

@interface DRFolder (VirtualFolders)

/*virtualFolderWithName:


Creates a virtual folder object 
private

+ (DRFolder*) virtualFolderWithName:(NSString*)name;
Parameters
name
The name of the folder on the output disc.
Return Value

An autoreleased DRFolder object. 
Discussion 

Creates and initializes a DRFolder object that will be populated with specified DRFile and DRFolder objects at runtime.*/
+ (DRFolder*) virtualFolderWithName:(NSString*)name;

/*addChild:


Adds an object reference (either a file or folder) as a child of a virtual folder object. 
private

- (void) addChild:(DRFSObject*)child; 
Parameters
child
The child to add to the folder
Discussion 

This method only applies to virtual folders. Real folders are considered leaf nodes and cannot have children.*/
- (void) addChild:(DRFSObject*)child; 

@end
