#ifndef CGERROR_H
#define CGERROR_H

#include <CoreGraphics/CGBase.h>
#include <stdint.h>


/*Result Codes

This table lists the result codes returned by functions in Quartz Display Services.
Result Code	Value	Description
kCGErrorSuccess	0	
The requested operation was completed successfully.
kCGErrorFailure	1000	
A general failure occurred.
kCGErrorIllegalArgument	1001	
One or more of the parameters passed to a function are invalid. Check for NULL pointers.
kCGErrorInvalidConnection	1002	
The parameter representing a connection to the window server is invalid.
kCGErrorInvalidContext	1003	
The CPSProcessSerNum or context identifier parameter is not valid.
kCGErrorCannotComplete	1004	
The requested operation is inappropriate for the parameters passed in, or the current system state.
kCGErrorNameTooLong	1005	
A parameter, typically a C string, is too long to be used without truncation.
kCGErrorNotImplemented	1006	
Return value from obsolete function stubs present for binary compatability, but not normally called.
kCGErrorRangeCheck	1007	
A parameter passed in has a value that is inappropriate, or which does not map to a useful operation or value.
kCGErrorTypeCheck	1008	
A data type or token was encountered that did not match the expected type or token.
kCGErrorNoCurrentPoint	1009	
An operation relative to a known point or coordinate could not be done, as there is no known point.
kCGErrorInvalidOperation	1010	
The requested operation is not valid for the parameters passed in, or the current system state.
kCGErrorNoneAvailable	1011	
The requested operation could not be completed as the indicated resources were not found.*/
enum {
kCGErrorSuccess	=0,
kCGErrorFailure	=1000	,
kCGErrorIllegalArgument	=1001,	
kCGErrorInvalidConnection	=1002	,
kCGErrorInvalidContext	=1003	,
kCGErrorCannotComplete	=1004	,
kCGErrorNameTooLong	=1005	,
kCGErrorNotImplemented	=1006	,
kCGErrorRangeCheck	=1007	,
kCGErrorTypeCheck=	1008	,
kCGErrorNoCurrentPoint	=1009,	
kCGErrorInvalidOperation	=1010,	
kCGErrorNoneAvailable	=1011	
};

/*CGError

Defines a uniform type for result codes returned by functions in Quartz Services.

typedef int32_t CGError;
Availability
Available in Mac OS X v10.0 and later.*/
typedef int32_t CGError;

#endif