#ifndef CFDATA_H
#define CFDATA_H

#include <CoreFoundation/CFBase.h>

// #include <ETC/CoreFoundation/CFData.h>
#if defined(__cplusplus)
extern "C" {
#endif

/*CFMutableDataRef

A reference to a CFMutableData object.

typedef struct __CFData *CFMutableDataRef;
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct __CFData *CFMutableDataRef;

/*CFDataRef

A reference to an immutable CFData object.

typedef const struct __CFData *CFDataRef;
Availability
Available in Mac OS X v10.0 and later.*/
typedef const struct __CFData *CFDataRef;


/*CFDataGetBytes

Copies the byte contents of a CFData object to an external buffer.

void CFDataGetBytes (
   CFDataRef theData,
   CFRange range,
   UInt8 *buffer
);
Parameters
theData

The CFData object to examine. 
range

The range of bytes in theData to get. To get all of the contents, pass CFRangeMake(0,CFDataGetLength(theData)). 
buffer

A pointer to the byte buffer of length range.length that is allocated on the stack or heap. On return, the buffer contains the requested range of bytes. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
void CFDataGetBytes (
   CFDataRef theData,
   CFRange range,
   UInt8 *buffer
);

/*CFDataGetLength

Returns the number of bytes contained by a CFData object.

CFIndex CFDataGetLength (
   CFDataRef theData
);
Parameters
theData

The CFData object to examine. 
Return Value

An index that specifies the number of bytes in theData. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFIndex CFDataGetLength (
   CFDataRef theData
);

/*CFDataCreate

Creates an immutable CFData object using data copied from a specified byte buffer.

CFDataRef CFDataCreate (
   CFAllocatorRef allocator,
   const UInt8 *bytes,
   CFIndex length
);
Parameters
allocator

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator.
bytes

A pointer to the byte buffer that contains the raw data to be copied into theData. 
length

The number of bytes in the buffer (bytes). 
Return Value

A new CFData object, or NULL if there was a problem creating the object. Ownership follows the Create Rule.
Discussion

You must supply a count of the bytes in the buffer. This function always copies the bytes in the provided buffer into internal storage. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFDataRef CFDataCreate (
   CFAllocatorRef allocator,
   const UInt8 *bytes,
   CFIndex length
);

/*CFDataCreateMutable

Creates an empty CFMutableData object.

CFMutableDataRef CFDataCreateMutable (
   CFAllocatorRef allocator,
   CFIndex capacity
);
Parameters
allocator

The CFAllocator object to be used to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator.
capacity

The maximum number of bytes that the CFData object can contain. If 0, the object can grow to a size only limited by the constraints of available memory and address space. 
Return Value

A CFMutableData object or NULL if there was a problem creating the object. Ownership follows the Create Rule.
Discussion

This function creates an empty (that is, content-less) CFMutableData object. You can add raw data to this object with the CFDataAppendBytes function, and thereafter you can replace and delete characters with the appropriate CFMutableData functions. If the capacity parameter is greater than 0, any attempt to add characters beyond this limit can result in undefined behavior. 
Availability
Available in Mac OS X v10.0 and later.*/
CFMutableDataRef CFDataCreateMutable (
   CFAllocatorRef allocator,
   CFIndex capacity
);

/*CFDataGetTypeID

Returns the type identifier for the CFData opaque type.

CFTypeID CFDataGetTypeID ();
Return Value

The type identifier for the CFData opaque type. 
Discussion

CFMutableData objects have the same type identifier as CFData objects.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFTypeID CFDataGetTypeID ();

/*CFDataAppendBytes

Appends the bytes from a byte buffer to the contents of a CFData object.

void CFDataAppendBytes (
   CFMutableDataRef theData,
   const UInt8 *bytes,
   CFIndex length
);
Parameters
theData

A CFMutableData object. If you pass an immutable CFData object, the behavior is not defined. 
bytes

A pointer to the buffer of bytes to be added to theData. 
length

The number of bytes in the byte buffer bytes. 
Availability
Available in Mac OS X v10.0 and later.*/
void CFDataAppendBytes (
   CFMutableDataRef theData,
   const UInt8 *bytes,
   CFIndex length
);

/*CFDataGetBytePtr

Returns a read-only pointer to the bytes of a CFData object.

const UInt8 *CFDataGetBytePtr (
   CFDataRef theData
);
Parameters
theData

The CFData object to examine. 
Return Value

A read-only pointer to the bytes associated with theData.
Discussion

This function is guaranteed to return a pointer to a CFData object's internal bytes. CFData, unlike CFString, does not hide its internal storage.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
const UInt8 *CFDataGetBytePtr (
   CFDataRef theData
);

/*CFDataDeleteBytes

Deletes the bytes in a CFMutableData object within a specified range.

void CFDataDeleteBytes (
   CFMutableDataRef theData,
   CFRange range
);
Parameters
theData

A CFMutableData object. If you pass an immutable CFData object, the behavior is not defined. 
range

The range of bytes (that is, the starting byte and the number of bytes from that point) to delete from theData's byte buffer. 
Availability
Available in Mac OS X v10.0 and later.*/
void CFDataDeleteBytes (
   CFMutableDataRef theData,
   CFRange range
);

#ifdef __cplusplus
}
#endif
#endif