#ifndef SCRIPT_H
#define SCRIPT_H

#ifndef MACTYPES_H
#include <CarbonCore/MacTypes.h>
#endif

#ifndef INTLRESOURCES_H
#include <CarbonCore/IntlResources.h>
#endif


#include <HYS/CarbonCore/Script.h>
#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Table Selectors

Specify selectors for the international table

enum {
   smWordSelectTable = 0,
   smWordWrapTable = 1,
   smNumberPartsTable = 2,
   smUnTokenTable = 3,
   smWhiteSpaceList = 4,
   iuWordSelectTable = 0,
   iuWordWrapTable = 1,
   iuNumberPartsTable = 2,
   iuUnTokenTable = 3,
   iuWhiteSpaceList = 4
};
Constants
smWordSelectTable

Specifies to get the word select break table from 'itl2'.

Available in Mac OS X v10.0 and later.
smWordWrapTable

Specifies to get the word wrap break table from 'itl2' .

Available in Mac OS X v10.0 and later.
smNumberPartsTable

Specifies to get the default number parts table from 'itl4'.

Available in Mac OS X v10.0 and later.
smUnTokenTable

Specifies to get the unToken table from 'itl4' .

Available in Mac OS X v10.0 and later.
smWhiteSpaceList

Specifies to get the white space list from 'itl4' .

Available in Mac OS X v10.0 and later.
iuWordSelectTable

Obsolete; specifies to get the word select break table from 'itl2' .

Available in Mac OS X v10.0 and later.
iuWordWrapTable

Obsolete; specifies to get the word wrap break table from 'itl2' .

Available in Mac OS X v10.0 and later.
iuNumberPartsTable

Obsolete; specifies to get the default number parts table from ''itl4'.

Available in Mac OS X v10.0 and later.
iuUnTokenTable

Obsolete; specifies to get the unToken table from 'itl4'.

Available in Mac OS X v10.0 and later.
iuWhiteSpaceList

Obsolete; specifies to get the white space list from 'itl4'.

Available in Mac OS X v10.0 and later.
Discussion

These constants can be used as the value of the tableCode variable, passed as a parameter to the GetIntlResourceTable function.*/

enum {
   smWordSelectTable = 0,
   smWordWrapTable = 1,
   smNumberPartsTable = 2,
   smUnTokenTable = 3,
   smWhiteSpaceList = 4,
   iuWordSelectTable = 0,
   iuWordWrapTable = 1,
   iuNumberPartsTable = 2,
   iuUnTokenTable = 3,
   iuWhiteSpaceList = 4
};

/*Meta Script Codes

Specify implicit script codes.

enum {
   smSystemScript = -1,
   smCurrentScript = -2,
   smAllScripts = -3
};
Constants
smSystemScript

Specifies the system script.

Available in Mac OS X v10.0 and later.
smCurrentScript

Specifies the font script.

Available in Mac OS X v10.0 and later.
smAllScripts

Specfies any script.

Available in Mac OS X v10.0 and later.
Discussion

You can specify script systems with implicit and explicit script code constants in the script parameter of the GetScriptVariable and SetScriptVariable functions. The implicit script codes smSystemScript and smCurrentScript are special negative values for the system script and the font script, respectively.*/
enum {
   smSystemScript = -1,
   smCurrentScript = -2,
   smAllScripts = -3
};


/*Script Manager Selectors

Specify selectors you can use with the functions GetScriptManagerVariable and SetScriptManagerVariable.

enum {
   smVersion = 0,
   smMunged = 2,
   smEnabled = 4,
   smBidirect = 6,
   smFontForce = 8,
   smIntlForce = 10,
   smForced = 12,
   smDefault = 14,
   smPrint = 16,
   smSysScript = 18,
   smLastScript = 20,
   smKeyScript = 22,
   smSysRef = 24,
   smKeyCache = 26,
   smKeySwap = 28,
   smGenFlags = 30,
   smOverride = 32,
   smCharPortion = 34,
   smDoubleByte = 36,
   smKCHRCache = 38,
   smRegionCode = 40,
   smKeyDisableState = 42
};
Constants
smVersion

The Script Manager version number (2 bytes) . This variable has the same format as the version number obtained from calling the Gestalt function with the Gestalt selector gestaltScriptMgrVersion. The high-order byte contains the major version number, and the low-order byte contains the minor version number.

Available in Mac OS X v10.0 and later.
smMunged

The modification count for Script Manager variables (2 bytes) . At startup, smMunged is initialized to 0, and it is incremented when the KeyScript function changes the current keyboard script and updates the variables accessed via smKeyScript and smLastScript. The smMunged selector is also incremented when the SetScriptManagerVariable function is used to change a Script Manager variable. You can check this variable at any time to see whether any of your own data structures that may depend on Script Manager variables need to be updated.

Available in Mac OS X v10.0 and later.
smEnabled

The script count (1 byte) ; the number of currently enabled script systems. At startup time, the Script Manager initializes the script count to 0, then increments it for each installed and enabled script system (including Roman). You can use smEnabled to determine whether more than one script system is installed—that is, whether your application needs to handle non-Roman text.

Never call SetScriptManagerVariable with the smEnabled selector. It could result in inconsistency with other script system values.

Available in Mac OS X v10.0 and later.
smBidirect

The bidirectional flag, which indicates when at least one bidirectional script system is enabled. This flag is set to TRUE ($FF) if the Arabic or Hebrew script system is enabled.

Available in Mac OS X v10.0 and later.
smFontForce

The font force flag (1 byte). At startup, the Script Manager sets its value from the system script’s international configuration ('itlc') resource. The flag returns 0 for FALSE and $FF for TRUE. If the system script is non-Roman, the font force flag controls whether a font with ID in the Roman script range is interpreted as belonging to the Roman script or to the system script.

When you call SetScriptManagerVariable with the smFontForce selector, be sure to pass only the value 0 or $FF, or a later call to GetScriptManagerVariable may return an unrecognized value. 

Available in Mac OS X v10.0 and later.
smIntlForce

The international resources selection flag (1 byte). At startup, the Script Manager sets its value from the system script’s international configuration ('itlc') resource. The flag returns 0 for FALSE and $FF for TRUE. This flag controls whether international resources of the font script or the system script are used for string manipulation.

When you call SetScriptManagerVariable with the smIntlForce selector, be sure to pass only the value 0 or $FF, or a later call to GetScriptManagerVariable may return an unrecognized value.

Available in Mac OS X v10.0 and later.
smForced

The script-forced result flag (1 byte). If the current script has been forced to the system script, this flag is set to TRUE. Use the smForced selector to obtain reports of the actions of the FontScript, FontToScript, and IntlScript functions. This variable is for information only; never set its value with SetScriptManagerVariable.

Available in Mac OS X v10.0 and later.
smDefault

The script-defaulted result flag (1 byte). If the script system corresponding to a specified font is not available, this flag is set to TRUE. Use this selector to obtain reports of the actions of the FontScript, FontToScript, and IntlScript functions. This variable is for information only; never set its value with SetScriptManagerVariable.

Available in Mac OS X v10.0 and later.
smPrint

The print action function vector, set up by the Script Manager at startup (4 bytes).

Available in Mac OS X v10.0 and later.
smSysScript

The system script code (2 bytes) . At startup, the Script Manager initializes this variable from the system script’s international configuration ('itlc') resource. This variable is for information only; never set its value with SetScriptManagerVariable. Constants for all defined script codes are listed in “Region Codes A”.

Available in Mac OS X v10.0 and later.
smLastScript

The previously used keyboard script (2 bytes). When you change keyboard scripts with the KeyScript function, the Script Manager moves the old value of smKeyScript into smLastScript. KeyScript can also swap the current keyboard script with the previous keyboard script, in which case the contents of smLastScript and smKeyScript are swapped. Constants for all defined script codes are listed in “Region Codes A”. Never set the value of this variable with SetScriptManagerVariable.

Available in Mac OS X v10.0 and later.
smKeyScript

The current keyboard script (2 bytes) . The KeyScript function tests and updates this variable. When you change keyboard scripts with the KeyScript function, the Script Manager moves the old value of smKeyScript into smLastScript. KeyScript can also swap the current keyboard script with the previous keyboard script, in which case the contents of smLastScript and smKeyScript are swapped. The Script Manager also uses this variable to get the proper keyboard icon and to retrieve the proper keyboard-layout ('KCHR') resource. Constants for all defined script codes are listed in “Region Codes A”. Never set the value of this variable directly with SetScriptManagerVariable; call KeyScript to change keyboard scripts.

Available in Mac OS X v10.0 and later.
smSysRef

The System Folder volume reference number (2 bytes) . Its value is initialized from the system global variable BootDrive at startup.

Available in Mac OS X v10.0 and later.
smKeyCache

An obsolete variable (4 bytes). This variable at one time held a pointer to the keyboard cache. The value it provided was not correct and should not be used.

Available in Mac OS X v10.0 and later.
smKeySwap

A handle to the keyboard-swap ('KSWP') resource (4 bytes). The Script Manager initializes the handle at startup. The keyboard-swap resource controls the key combinations with which the user can invoke various actions with the KeyScript function, such as switching among script systems.

Available in Mac OS X v10.0 and later.
smGenFlags

The general flags used by the Script Manager (4 bytes). The Script Manager general flags is a long word value its high-order byte is set from the flags byte in the system script’s international configuration ('itlc') resource. These constants are available to designate bits in the variable accessed through smGenFlags:
smfNameTagEnab (a value of 29)Reserved for internal use.
smfDualCaret (a value of 30)Use a dual caret for mixed-directional text.
smfShowIcon (a value of 31)Show the keyboard menu even if only one keyboard layout or one script (Roman) is available. (This bit is checked only at system startup.)

Available in Mac OS X v10.0 and later.
smOverride

The script override flags (4 bytes). At present, these flags are not set or used by the Script Manager. They are, however, reserved for future use.

Available in Mac OS X v10.0 and later.
smCharPortion

A value used by script systems to allocate intercharacter and interword spacing when justifying text (2 bytes). It denotes the weight allocated to intercharacter space versus interword space. The value of this variable is initialized to 10 percent by the Script Manager, although it currently has no effect on text of the Roman script system. The variable is in 4.12 fixed-point format, which is a 16-bit signed number with 4 bits of integer and 12 bits of fraction. (In that format, 10 percent has the hexadecimal value $0199.)

Available in Mac OS X v10.0 and later.
smDoubleByte

The double-byte flag, a Boolean value that is TRUE if at least one double-byte script system is enabled. (1 byte) 

Available in Mac OS X v10.0 and later.
smKCHRCache

(A pointer to the cache that stores a copy of the current keyboard-layout ('KCHR') resource 4 bytes).

Available in Mac OS X v10.0 and later.
smRegionCode

The region code for this localized version of system software, obtained from the system script’s international configuration ('itlc') resource. This variable identifies the localized version of the system script. Constants for all defined region codes are listed in “Region Codes A” (2 bytes).

Available in Mac OS X v10.0 and later.
smKeyDisableState

The current disable state for keyboards (1 byte). The Script Manager disables some keyboard scripts or keyboard switching when text input must be restricted to certain script systems or when script systems are being moved into or out of the System file. These are the possible values for the variable accessed through smKeyDisableState:
0All keyboards are enabled; switching is enabled.
1Keyboard switching is disabled.
$FFKeyboards for all non-Roman secondary scripts are disabled 

The script management system maintains the keyboard disable state separately for each application. Never set the value of this variable directly with SetScriptManagerVariable; call KeyScript to change the keyboard disable state for your application.

Available in Mac OS X v10.0 and later.
Discussion

This section lists and describes the selector constants for accessing the Script Manager variables through calls to the GetScriptManagerVariable and SetScriptManagerVariable functions. In every case the variable parameter passed to or from the function is a long integer (4 bytes); the number in parentheses indicates how many of the 4 bytes are necessary to hold the input or return value for that variable. If fewer than 4 bytes are needed, the low byte or low word contains the information.*/

enum {
   smVersion = 0,
   smMunged = 2,
   smEnabled = 4,
   smBidirect = 6,
   smFontForce = 8,
   smIntlForce = 10,
   smForced = 12,
   smDefault = 14,
   smPrint = 16,
   smSysScript = 18,
   smLastScript = 20,
   smKeyScript = 22,
   smSysRef = 24,
   smKeyCache = 26,
   smKeySwap = 28,
   smGenFlags = 30,
   smOverride = 32,
   smCharPortion = 34,
   smDoubleByte = 36,
   smKCHRCache = 38,
   smRegionCode = 40,
   smKeyDisableState = 42
};


/*Script Codes

Specify Mac OS encodings that are related to a FOND ID range.

enum {
   smRoman = 0,
   smJapanese = 1,
   smTradChinese = 2,
   smKorean = 3,
   smArabic = 4,
   smHebrew = 5,
   smGreek = 6,
   smCyrillic = 7,
   smRSymbol = 8,
   smDevanagari = 9,
   smGurmukhi = 10,
   smGujarati = 11,
   smOriya = 12,
   smBengali = 13,
   smTamil = 14,
   smTelugu = 15,
   smKannada = 16,
   smMalayalam = 17,
   smSinhalese = 18,
   smBurmese = 19,
   smKhmer = 20,
   smThai = 21,
   smLao = 22,
   smGeorgian = 23,
   smArmenian = 24,
   smSimpChinese = 25,
   smTibetan = 26,
   smMongolian = 27,
   smEthiopic = 28,
   smGeez = 28,
   smCentralEuroRoman = 29,
   smVietnamese = 30,
   smExtArabic = 31,
   smUninterp = 32
};
Constants
smRoman

Specifies the Roman script system.

Available in Mac OS X v10.0 and later.
smJapanese

Specifies the Japanese script system.

Available in Mac OS X v10.0 and later.
smTradChinese

Specifies the traditional Chinese script system.

Available in Mac OS X v10.0 and later.
smKorean

Specifies the Korean script system.

Available in Mac OS X v10.0 and later.
smArabic

Specifies the Arabic script system.

Available in Mac OS X v10.0 and later.
smHebrew

Specifies the Hebrew script system.

Available in Mac OS X v10.0 and later.
smGreek

Specifies the Greek script system.

Available in Mac OS X v10.0 and later.
smCyrillic

Specifies the Cyrillic script system.

Available in Mac OS X v10.0 and later.
smRSymbol

Specifies right-to-left symbols. The script code represented by the constant smRSymbol is available as an alternative to smUninterp, for representation of special symbols that have a right-to-left line direction. Note, however, that the script management system provides no direct support for representation of text with this script code.

Available in Mac OS X v10.0 and later.
smDevanagari

Specifies the Devanagari script system.
Script Codes

Specify Mac OS encodings that are related to a FOND ID range.

enum {
   smRoman = 0,
   smJapanese = 1,
   smTradChinese = 2,
   smKorean = 3,
   smArabic = 4,
   smHebrew = 5,
   smGreek = 6,
   smCyrillic = 7,
   smRSymbol = 8,
   smDevanagari = 9,
   smGurmukhi = 10,
   smGujarati = 11,
   smOriya = 12,
   smBengali = 13,
   smTamil = 14,
   smTelugu = 15,
   smKannada = 16,
   smMalayalam = 17,
   smSinhalese = 18,
   smBurmese = 19,
   smKhmer = 20,
   smThai = 21,
   smLao = 22,
   smGeorgian = 23,
   smArmenian = 24,
   smSimpChinese = 25,
   smTibetan = 26,
   smMongolian = 27,
   smEthiopic = 28,
   smGeez = 28,
   smCentralEuroRoman = 29,
   smVietnamese = 30,
   smExtArabic = 31,
   smUninterp = 32
};
Constants
smRoman

Specifies the Roman script system.

Available in Mac OS X v10.0 and later.
smJapanese

Specifies the Japanese script system.

Available in Mac OS X v10.0 and later.
smTradChinese

Specifies the traditional Chinese script system.

Available in Mac OS X v10.0 and later.
smKorean

Specifies the Korean script system.

Available in Mac OS X v10.0 and later.
smArabic

Specifies the Arabic script system.

Available in Mac OS X v10.0 and later.
smHebrew

Specifies the Hebrew script system.

Available in Mac OS X v10.0 and later.
smGreek

Specifies the Greek script system.

Available in Mac OS X v10.0 and later.
smCyrillic

Specifies the Cyrillic script system.

Available in Mac OS X v10.0 and later.
smRSymbol

Specifies right-to-left symbols. The script code represented by the constant smRSymbol is available as an alternative to smUninterp, for representation of special symbols that have a right-to-left line direction. Note, however, that the script management system provides no direct support for representation of text with this script code.

Available in Mac OS X v10.0 and later.
smDevanagari

Specifies the Devanagari script system.

Available in Mac OS X v10.0 and later.
smGurmukhi

Specifies the Gurmukhi script system.

Available in Mac OS X v10.0 and later.
smGujarati

Specifies the Gujarati script system.

Available in Mac OS X v10.0 and later.
smOriya

Specifies the Oriya script system.

Available in Mac OS X v10.0 and later.
smBengali

Specifies the Bengali script system.

Available in Mac OS X v10.0 and later.
smTamil

Specifies the Tamil script system.

Available in Mac OS X v10.0 and later.
smTelugu

Specifies the Telugu script system.

Available in Mac OS X v10.0 and later.
smKannada

Specifies the Kannada/Kanarese script system.

Available in Mac OS X v10.0 and later.
smMalayalam

Specifies the Malayalam script system.

Available in Mac OS X v10.0 and later.
smSinhalese

Specifies the Sinhalese script system.

Available in Mac OS X v10.0 and later.
smBurmese

Specifies the Burmese script system.

Available in Mac OS X v10.0 and later.
smKhmer

Specifies the Khmer script system.

Available in Mac OS X v10.0 and later.
smThai

Specifies the Thai script system.

Available in Mac OS X v10.0 and later.
smLao

Specifies the Laotian script system.

Available in Mac OS X v10.0 and later.
smGeorgian

Specifies the Georgian script system.

Available in Mac OS X v10.0 and later.
smArmenian

Specifies the Armenian script system.

Available in Mac OS X v10.0 and later.
smSimpChinese

Specifies the simplified Chinese script system.

Available in Mac OS X v10.0 and later.
smTibetan

Specifies the Tibetan script system.

Available in Mac OS X v10.0 and later.
smMongolian

Specifies the Mongolian script system.

Available in Mac OS X v10.0 and later.
smEthiopic

Specifies the Geez/Ethiopic script system. This constant is the same as smGeez.

Available in Mac OS X v10.0 and later.
smGeez

Specifies the Geez/Ethiopic script system.

Available in Mac OS X v10.0 and later.
smCentralEuroRoman

Used for Czech, Slovak, Polish, Hungarian, Baltic languages.

Available in Mac OS X v10.0 and later.
smVietnamese

Specifies the Extended Roman script system for Vietnamese.

Available in Mac OS X v10.0 and later.
smExtArabic

Specifies the extended Arabic for Sindhi script system. 

Available in Mac OS X v10.0 and later.
smUninterp

Uninterpreted symbols. The script code represented by the constant smUninterp is available for representation of special symbols, such as items in a tool palette, that must not be considered as part of any actual script system. For manipulating and drawing such symbols, the smUninterp constant should be treated as if it indicated the Roman script system rather than the system script; that is, the default behavior of uninterpreted symbols should be Roman.

Available in Mac OS X v10.0 and later.
Available in Mac OS X v10.0 and later.
smGurmukhi

Specifies the Gurmukhi script system.

Available in Mac OS X v10.0 and later.
smGujarati

Specifies the Gujarati script system.

Available in Mac OS X v10.0 and later.
smOriya

Specifies the Oriya script system.

Available in Mac OS X v10.0 and later.
smBengali

Specifies the Bengali script system.

Available in Mac OS X v10.0 and later.
smTamil

Specifies the Tamil script system.

Available in Mac OS X v10.0 and later.
smTelugu

Specifies the Telugu script system.

Available in Mac OS X v10.0 and later.
smKannada

Specifies the Kannada/Kanarese script system.

Available in Mac OS X v10.0 and later.
smMalayalam

Specifies the Malayalam script system.

Available in Mac OS X v10.0 and later.
smSinhalese

Specifies the Sinhalese script system.

Available in Mac OS X v10.0 and later.
smBurmese

Specifies the Burmese script system.

Available in Mac OS X v10.0 and later.
smKhmer

Specifies the Khmer script system.

Available in Mac OS X v10.0 and later.
smThai

Specifies the Thai script system.

Available in Mac OS X v10.0 and later.
smLao

Specifies the Laotian script system.

Available in Mac OS X v10.0 and later.
smGeorgian

Specifies the Georgian script system.

Available in Mac OS X v10.0 and later.
smArmenian

Specifies the Armenian script system.

Available in Mac OS X v10.0 and later.
smSimpChinese

Specifies the simplified Chinese script system.

Available in Mac OS X v10.0 and later.
smTibetan

Specifies the Tibetan script system.

Available in Mac OS X v10.0 and later.
smMongolian

Specifies the Mongolian script system.

Available in Mac OS X v10.0 and later.
smEthiopic

Specifies the Geez/Ethiopic script system. This constant is the same as smGeez.

Available in Mac OS X v10.0 and later.
smGeez

Specifies the Geez/Ethiopic script system.

Available in Mac OS X v10.0 and later.
smCentralEuroRoman

Used for Czech, Slovak, Polish, Hungarian, Baltic languages.

Available in Mac OS X v10.0 and later.
smVietnamese

Specifies the Extended Roman script system for Vietnamese.

Available in Mac OS X v10.0 and later.
smExtArabic

Specifies the extended Arabic for Sindhi script system. 

Available in Mac OS X v10.0 and later.
smUninterp

Uninterpreted symbols. The script code represented by the constant smUninterp is available for representation of special symbols, such as items in a tool palette, that must not be considered as part of any actual script system. For manipulating and drawing such symbols, the smUninterp constant should be treated as if it indicated the Roman script system rather than the system script; that is, the default behavior of uninterpreted symbols should be Roman.

Available in Mac OS X v10.0 and later.*/

enum {
   smRoman = 0,
   smJapanese = 1,
   smTradChinese = 2,
   smKorean = 3,
   smArabic = 4,
   smHebrew = 5,
   smGreek = 6,
   smCyrillic = 7,
   smRSymbol = 8,
   smDevanagari = 9,
   smGurmukhi = 10,
   smGujarati = 11,
   smOriya = 12,
   smBengali = 13,
   smTamil = 14,
   smTelugu = 15,
   smKannada = 16,
   smMalayalam = 17,
   smSinhalese = 18,
   smBurmese = 19,
   smKhmer = 20,
   smThai = 21,
   smLao = 22,
   smGeorgian = 23,
   smArmenian = 24,
   smSimpChinese = 25,
   smTibetan = 26,
   smMongolian = 27,
   smEthiopic = 28,
   smGeez = 28,
   smCentralEuroRoman = 29,
   smVietnamese = 30,
   smExtArabic = 31,
   smUninterp = 32
};



/*language Codes A

Specify language codes (values 0 though 23).

enum {
   langEnglish = 0,
   langFrench = 1,
   langGerman = 2,
   langItalian = 3,
   langDutch = 4,
   langSwedish = 5,
   langSpanish = 6,
   langDanish = 7,
   langPortuguese = 8,
   langNorwegian = 9,
   langHebrew = 10,
   langJapanese = 11,
   langArabic = 12,
   langFinnish = 13,
   langGreek = 14,
   langIcelandic = 15,
   langMaltese = 16,
   langTurkish = 17,
   langCroatian = 18,
   langTradChinese = 19,
   langUrdu = 20,
   langHindi = 21,
   langThai = 22,
   langKorean = 23
};
Constants
langEnglish

Represents the English language. The associated script code is smRoman.

Available in Mac OS X v10.0 and later.
langFrench

Represents the French language. The associated script code is smRoman. 

Available in Mac OS X v10.0 and later.
langGerman

Represents the German language. The associated script code is smRoman. 

Available in Mac OS X v10.0 and later.
langItalian

Represents the Italian language. The associated script code is smRoman. 

Available in Mac OS X v10.0 and later.
langDutch

Represents the Dutch language. The associated script code is smRoman. 

Available in Mac OS X v10.0 and later.
langSwedish

Represents the Swedish language. The associated script code is smRoman. 

Available in Mac OS X v10.0 and later.
langSpanish

Represents the Spanish language. The associated script code is smRoman. 

Available in Mac OS X v10.0 and later.
langDanish

Represents the Danish language. The associated script code is smRoman. 

Available in Mac OS X v10.0 and later.
langPortuguese

Represents the Portuguese language. The associated script code is smRoman. 

Available in Mac OS X v10.0 and later.
langNorwegian

Represents the Norwegian language. The associated script code is smRoman. 

Available in Mac OS X v10.0 and later.
langHebrew

Represents the Hebrew language. The associated script code is smHebrew. 

Available in Mac OS X v10.0 and later.
langJapanese

Represents the Japanese language. The associated script code is smJapanese. 

Available in Mac OS X v10.0 and later.
langArabic

Represents the Arabic language. The associated script code is smArabic. 

Available in Mac OS X v10.0 and later.
langFinnish

Represents the Finnish language. The associated script code is smRoman. 

Available in Mac OS X v10.0 and later.
langGreek

Represents the Greek language. The associated script code is smGreek. 

Available in Mac OS X v10.0 and later.
langIcelandic

Represents the Icelandic language. The associated script code is smRoman. 

Available in Mac OS X v10.0 and later.
langMaltese

Represents the Maltese language. The associated script code is smRoman. 

Available in Mac OS X v10.0 and later.
langTurkish

Represents the Turkish language. The associated script code is smRoman. 

Available in Mac OS X v10.0 and later.
langCroatian

Represents the Croatian language. The associated script code is smRoman. 

Available in Mac OS X v10.0 and later.
langTradChinese

Represents the Chinese (traditional chararacters) language. The associated script code is smTradChinese.

Available in Mac OS X v10.0 and later.
langUrdu

Represents the Urdu language. The associated script code is smArabic. 

Available in Mac OS X v10.0 and later.
langHindi

Represents the Hindi language. The associated script code is smDevanagari. 

Available in Mac OS X v10.0 and later.
langThai

Represents the Thai language. The associated script code is smThai. 

Available in Mac OS X v10.0 and later.
langKorean

Represents the Korean language. The associated script code is smKorean. 

Available in Mac OS X v10.0 and later.*/
enum {
   langEnglish = 0,
   langFrench = 1,
   langGerman = 2,
   langItalian = 3,
   langDutch = 4,
   langSwedish = 5,
   langSpanish = 6,
   langDanish = 7,
   langPortuguese = 8,
   langNorwegian = 9,
   langHebrew = 10,
   langJapanese = 11,
   langArabic = 12,
   langFinnish = 13,
   langGreek = 14,
   langIcelandic = 15,
   langMaltese = 16,
   langTurkish = 17,
   langCroatian = 18,
   langTradChinese = 19,
   langUrdu = 20,
   langHindi = 21,
   langThai = 22,
   langKorean = 23
};

/*GetIntlResourceTable

Obtains a specific word-selection, line-break, number-parts, untoken, or whitespace table from the appropriate international resource. (Deprecated in Mac OS X v10.4. There is no replacement because this function is no longer needed in Mac OS X.)

void GetIntlResourceTable (
   ScriptCode script,
   short tableCode,
   Handle * itlHandle,
   long * offset,
   long * length
);
Parameters
script

A script code, the value that specifies a particular script system. Constants for all defined script codes are listed in “Meta Script Codes”. 
tableCode

A number that specifies which table is requested. The constants for tableCode are detailed in “Table Selectors”. 
itlHandle

On return, a handle to the string-manipulation ('itl2') or tokens ('itl4') resource containing the table specified in the tableCode parameter. If the script system whose table is requested is not available, GetIntlResourceTable returns a NULL handle. 
offset

On return, a pointer to the offset (in bytes) to the specified table from the beginning of the resource. 
length

On return, a pointer to the size of the table (in bytes).
Discussion

When you provide a script code in the script parameter, and a table code in the tableCode parameter, GetIntlResourceTable returns a handle to the string-manipulation resource or tokens resource containing that table, the offset of the specified table from the beginning of the resource, and the length of the table. 

If you wish to manipulate the contents of the table you have requested, use the size returned in the length parameter to allocate a buffer, and perform a block move of the table’s contents into that buffer. 
Special Considerations

GetIntlResourceTable may move memory; your application should not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Script.h*/
void GetIntlResourceTable (
   ScriptCode script,
   short tableCode,
   Handle * itlHandle,
   long * offset,
   long * length
);

/*GetScriptManagerVariable

Retrieves the value of the specified Script Manager variable.

long GetScriptManagerVariable (
   short selector
);
Parameters
selector

A value that specifies a particular Script Manager variable. To specify the Script Manager variable whose value you need, use one of the selector constants listed in “Script Manager Selectors”. 
Return Value

The current value of the specified Script Manager variable or 0 if the selector is invalid. For some valid selectors, 0 may also be a valid return value. For example, when you call GetScriptManagerVariable with a selector value of smRegionCode on a version of Macintosh system software that has been localized for the United States, it returns 0. Although GetScriptManagerVariable always returns a long integer, the actual value may be a long integer, standard integer, or signed byte. If the value is not a long integer, it is stored in the low-order word or byte of the long integer returned by GetScriptManagerVariable; the remaining bytes are set to 0.
Discussion

The Script Manager maintains a set of variables that control general settings of the text environment, including the identity of the system script and the keyboard script, and the settings of the font force flag and the international resources selection flag.

You may want access to the Script Manager variables in order to understand the current environment or to modify it. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Script.h*/


long GetScriptManagerVariable (
   short selector
);

#ifdef __cplusplus
}
#endif

#endif