#ifndef DEVICES_H
#define DEVICES_H

#ifndef OSUTILS_H
#include <CarbonCore/OSUtils.h>
#endif

#ifndef FILES_H
#include <CarbonCore/Files.h>
#endif

#ifndef NAMEREGISTRY_H
#include <CarbonCore/NameRegistry.h>
#endif

#ifndef CODEFRAGMENTS_H
#include <CarbonCore/CodeFragments.h>
#endif

#ifndef MULTIPROCESSING_H
#include <CarbonCore/Multiprocessing.h>
#endif

#include <HYS/CarbonCore/Devices.h>

#ifndef QUICKDRAW_H
//#include <QD/Quickdraw.h>//hys
#endif

#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif


/*dVMImmuneMask

enum {
   dVMImmuneMask = 0x0001,
   dOpenedMask = 0x0020,
   dRAMBasedMask = 0x0040,
   drvrActiveMask = 0x0080
};
Constants
dVMImmuneMask

Driver does not need VM protection.

Available in Mac OS X v10.0 and later.
dOpenedMask

Driver is open.

Available in Mac OS X v10.0 and later.
dRAMBasedMask

dCtlDriver is a handle (1) or pointer (0).

Available in Mac OS X v10.0 and later.
drvrActiveMask

Driver is currently processing a request.

Available in Mac OS X v10.0 and later.*/

enum {
   dVMImmuneMask = 0x0001,
   dOpenedMask = 0x0020,
   dRAMBasedMask = 0x0040,
   drvrActiveMask = 0x0080
};



//function


/*PBWriteSync

Writes any number of bytes to an open file.

OSErr PBWriteSync (
   ParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to a basic File Manager parameter block. 
Return Value

A result code. See “Device Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ioCompletion On input, a pointer to a completion routine. 
ioResult On output, the result code of the function. 
ioRefNum On input, a file reference number for the open file to which to write. 
ioBuffer On input, a pointer to a data buffer containing the bytes to write. 
ioReqCount On input, the number of bytes requested. 
ioActCount On output, the number of bytes actually written. 
ioPosMode On input, the positioning mode. 
ioPosOffset On input, the positioning offset. On output, the new position of the mark. 

The PBWriteSync function takes ioReqCount bytes from the buffer pointed to by ioBuffer and attempts to write them to the open file whose access path is specified by ioRefNum. The position of the mark is specified by ioPosMode and ioPosOffset. If the write operation completes successfully, PBWriteSync moves the file mark to the byte following the last byte written and returns noErr.

If you try to write past the logical end-of-file, PBWriteSync moves the logical end-of-file. If you try to write past the physical end-of-file, PBWriteSync adds one or more clumps to the file and moves the physical end-of-file accordingly. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes

This function is only supported for writing to open files.
Declared In
Devices.h*/

OSErr PBWriteSync (
   ParmBlkPtr paramBlock
);

/*PBWriteAsync

Writes any number of bytes to an open file.

OSErr PBWriteAsync (
   ParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to a basic File Manager parameter block. 
Return Value

A result code. See “Device Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ioCompletion On input, a pointer to a completion routine. 
ioResult On output, the result code of the function. 
ioRefNum On input, a file reference number for the open file to which to write. 
ioBuffer On input, a pointer to a data buffer containing the bytes to write. 
ioReqCount On input, the number of bytes requested. 
ioActCount On output, the number of bytes actually written. 
ioPosMode On input, the positioning mode. 
ioPosOffset On input, the positioning offset. On output, the new position of the mark. 

The PBWriteAsync function takes ioReqCount bytes from the buffer pointed to by ioBuffer and attempts to write them to the open file whose access path is specified by ioRefNum. The position of the mark is specified by ioPosMode and ioPosOffset. If the write operation completes successfully, PBWriteAsync moves the file mark to the byte following the last byte written and returns noErr.

If you try to write past the logical end-of-file, PBWriteAsync moves the logical end-of-file. If you try to write past the physical end-of-file, PBWriteAsync adds one or more clumps to the file and moves the physical end-of-file accordingly. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes

This function is only supported for writing to open files.
Declared In
Devices.h*/
OSErr PBWriteAsync (
   ParmBlkPtr paramBlock
);


/*PBReadAsync

Reads any number of bytes from an open file.

OSErr PBReadAsync (
   ParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to a basic File Manager parameter block. 
Return Value

A result code. See “Device Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ioCompletion On input, a pointer to a completion routine. 
ioResult On output, the result code of the function. 
ioRefNum On input, a file reference number for an open file to be read. 
ioBuffer On input, a pointer to a data buffer into which the bytes are read. 
ioReqCount On input, the number of bytes requested. The value that you pass in this field should be greater than zero. 
ioActCount On output, the number of bytes actually read. 
ioPosMode On input, the positioning mode. 
ioPosOffset On input, the positioning offset. On output, the new position of the mark. 

This function attempts to read ioReqCount bytes from the open file whose access path is specified in the ioRefNum field and transfer them to the data buffer pointed to by the ioBuffer field. The position of the mark is specified by ioPosMode and ioPosOffset. If your application tries to read past the logical end-of-file, PBReadAsync reads the data, moves the mark to the end-of-file, and returns eofErr as its function result. Otherwise, PBReadAsync moves the file mark to the byte following the last byte read and returns noErr.

You can specify that PBReadAsync read the file data 1 byte at a time until the requested number of bytes have been read or until the end-of-file is reached. To do so, set bit 7 of the ioPosMode field. Similarly, you can specify that PBReadAsync should stop reading data when it reaches an application-defined newline character. To do so, place the ASCII code of that character into the high-order byte of the ioPosMode field; you must also set bit 7 of that field to enable newline mode.

When reading data in newline mode, PBReadAsync returns the newline character as part of the data read and sets ioActCount to the actual number of bytes placed into the buffer (which includes the newline character). 
Version Notes

Note that on Mac OS 8 and 9, it is possible to call PBReadAsync with a value of 0 in the ioReqCount field; however, this behavior is not supported on Mac OS X. On OS X, PBReadAsync returns a paramErr error if the value in the ioReqCount field is 0.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Devices.h*/

OSErr PBReadAsync (
   ParmBlkPtr paramBlock
);

/*PBReadSync

Reads any number of bytes from an open file.

OSErr PBReadSync (
   ParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to a basic File Manager parameter block. 
Return Value

A result code. See “Device Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ioCompletion On input, a pointer to a completion routine. 
ioResult On output, the result code of the function. 
ioRefNum On input, a file reference number for an open file to be read. 
ioBuffer On input, a pointer to a data buffer into which the bytes are read. 
ioReqCount On input, the number of bytes requested. The value that you pass in this field should be greater than zero. 
ioActCount On output, the number of bytes actually read. 
ioPosMode On input, the positioning mode. 
ioPosOffset On input, the positioning offset. On output, the new position of the mark. 

This function attempts to read ioReqCount bytes from the open file whose access path is specified in the ioRefNum field and transfer them to the data buffer pointed to by the ioBuffer field. The position of the mark is specified by ioPosMode and ioPosOffset. If your application tries to read past the logical end-of-file, PBReadSync reads the data, moves the mark to the end-of-file, and returns eofErr as its function result. Otherwise, PBReadSync moves the file mark to the byte following the last byte read and returns noErr.

You can specify that PBReadSync read the file data 1 byte at a time until the requested number of bytes have been read or until the end-of-file is reached. To do so, set bit 7 of the ioPosMode field. Similarly, you can specify that PBReadSync should stop reading data when it reaches an application-defined newline character. To do so, place the ASCII code of that character into the high-order byte of the ioPosMode field; you must also set bit 7 of that field to enable newline mode.

When reading data in newline mode, PBReadSync returns the newline character as part of the data read and sets ioActCount to the actual number of bytes placed into the buffer (which includes the newline character). 
Version Notes

Note that on Mac OS 8 and 9, it is possible to call PBReadSync with a value of 0 in the ioReqCount field; however, this behavior is not supported on Mac OS X. On OS X, PBReadSync returns a paramErr error if the value in the ioReqCount field is 0.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes

This function is only supported for reading from open files.
Declared In
Devices.h*/

OSErr PBReadSync (
   ParmBlkPtr paramBlock
);


#ifdef __cplusplus
}
#endif

#endif