#ifndef  COLORSYNC_H
#include <ColorSync/ColorSync.h>
#endif

/*CMMakeProfile

Makes a display or abstract profile by modifying an existing one.

CMError CMMakeProfile(
CMProfileRef      prof,
CFDictionaryRef   spec
);
Parameters
prof

The profile to modify.
spec

A dictionary that specifies the modifications to make to the profile supplied in the prof parameter.
Return Value

A CMError value. See “ColorSync Manager Result Codes”.
Discussion

The function CMMakeProfile adds appropriate tags to a profile to make a display or abstract profile based on a specification dictionary you supply. 

One key in the specification dictionary must be "profileType" with a CFString value of either "abstractLab", "displayRGB" or "displayID". 

The dictionary can optionally contain these keys-value pairs:
"description", with an associated CFString value
"copyright", with an associated CFString value

For a profileType key whose value is "abstractLab", the dictionary can also contain the keys-value pairs listed in Table 1.
Table 1  Key-value pairs for “abstractLab”
Key	
Value	
Comment

"gridPoints"	
A CFNumber (SInt32) that is an odd	
Required

"proc"	
A CFNumber (SInt64) coerced from a LabToLabProcPtr data type	
Required

"refcon"	
A CFNumber (SInt64) value coerced from a void* data type	
Optional


For a profileType key whose value is "displayRGB", the dictionary can also contain the keys-value pairs listed in Table 2.
Table 2  Key-value pairs for “displayRGB”
Key	
Value	
Comment

"targetGamma"	
A CFNumber (Float), for example, 1.8 	
Optional

"targetWhite"	
A CFNumber (SInt32), for example, 6500	
Optional

"gammaR	
A CFNumber (Float), for example, 2.5	
Required

"gammaG"	
A CFNumber (Float), for example, 2.5	
Required

"gammaB"	
A CFNumber (Float), for example, 2.5	
Required

"tableChans"	
A CFNumber (SInt32), for example, 1 or 3	
Optional

"tableEntries"	
A CFNumber (SInt32), for example, 16 or 255	
Optional

"tableEntrySize"	
A CFNumber (SInt32), for example,1 or 2	
Optional

"tableData"	
A CFData (lut in RRRGGGBBB order)	
Optional

"phosphorRx"	
A CFNumber (Float)	
Only if not supplying the phospherSet key.

phosphorRy"	
A CFNumber (Float)	
Only if not supplying the phospherSet key.

phosphorGx"	
A CFNumber (Float)	
Only if not supplying the phospherSet key.

"phosphorGy"	
A CFNumber (Float)	
Only if not supplying the phospherSet key.

"phosphorBx"	
A CFNumber (Float)	
Only if not supplying the phospherSet key.

"phosphorBy"	
A CFNumber (Float)	
Only if not supplying the phospherSet key.

"phosphorSet" 	
A CFString: "WideRGB", "700/525/450nm", "P22-EBU", "HDTV", "CCIR709", "sRGB", "AdobeRGB98" or "Trinitron" 	
Only if not supplying the phospher R, G, B keys

"whitePointx"	
A CFNumber (Float) 	
Only if not supplying a whiteTemp key

"whitePointy"	
A CFNumber (Float)	
Only if not supplying a whiteTemp key

"whiteTemp"	
A CFNumber (SInt32), for example, 5000, 6500, or 9300 	
Only if not supplying whitePointx and whitePointy keys


For a profileType key whose value is "displayID", the dictionary can also contain the keys-value pairs in Table 3
Table 3  Key-value pairs for “displayID”
Key	
Value	
Comment

"targetGamma"	
A CFNumber (Float), for example, 1.8	
Optional

"targetWhite"	
A CFNumber (SInt32), for example, 6500 	
Optional

"displayID”	
A CFNumber (SInt32)	
Required


Optionally, the keys-value pairs s for a profileType key whose value is "displayRGB" can be provided to override the values from the display.
Availability
Available in Mac OS X v. 10.3 and later. 
Declared In
CMApplication.h*/

CMError CMMakeProfile(
CMProfileRef      prof,
CFDictionaryRef   spec){
//TODO
};



/*CMNewProfile

Creates a new profile and associated backing copy.

CMError CMNewProfile (
   CMProfileRef * prof,
   const CMProfileLocation * theProfile
);
Parameters
prof

A pointer to a profile reference of type CMProfileRef. On return, a reference to the new profile. 
theProfile

A pointer of type CMProfileLocation to the profile location where the new profile should be created. A profile is commonly disk-file based—the disk file type for a profile is 'prof'. However, to accommodate special requirements, you can create a handle- or pointer-based profile, you can create a temporary profile that is not saved after you call the CMCloseProfile function, or you can create a profile that is accessed through a procedure provided by your application. To create a temporary profile, you either specify cmNoProfileBase as the kind of profile in the profile location structure or specify NULL for this parameter. 
Return Value

A CMError value. See “ColorSync Manager Result Codes”.
Discussion

The CMNewProfile function creates a new profile and backing copy in the location you specify. After you create the profile, you must fill in the profile header fields and populate the profile with tags and their element data, and then call the function CMUpdateProfile to save the element data to the profile file. The default ColorSync profile contents include a profile header of type CM2Header and an element table.

To set profile elements outside the header, you use the function CMSetProfileElement, the function CMSetProfileElementSize, and the function CMSetPartialProfileElement. You set these elements individually, identifying them by their tag names.

When you create a new profile, all fields of the CM2Header profile header are set to 0 except the size and profileVersion fields. To set the header elements, you call the function CMGetProfileHeader to get a copy of the header, assign values to the header fields, then call the function CMSetProfileHeader to write the new header to the profile.

For each profile class, such as a device profile, there is a specific set of elements and associated tags, defined by the ICC, that a profile must contain to meet the baseline requirements. The ICC also defines optional tags that a particular CMM might use to optimize or improve its processing. You can also define private tags, whose tag signatures you register with the ICC, to provide a CMM with greater capability to refine its processing.

After you fill in the profile with tags and their element data, you must call the CMUpdateProfile function to write the new profile elements to the profile file.

This function is most commonly used by profile developers who create profiles for device manufacturers and by calibration applications. In most cases, application developers use existing profiles. 
Availability
Available in CarbonLib 1.0 and later when ColorSync 2.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
CMApplication.h*/
CMError CMNewProfile (
   CMProfileRef * prof,
   const CMProfileLocation * theProfile){
//TODO
};


/*CMCloseProfile

Decrements the reference count for the specified profile reference and, if the reference count reaches 0, frees all private memory and other resources associated with the profile.

CMError CMCloseProfile (
   CMProfileRef prof
);
Parameters
prof

A profile reference of type CMProfileRef that identifies the profile that may need to be closed. 
Return Value

A CMError value. See “ColorSync Manager Result Codes”.
Discussion

The ColorSync Manager keeps an internal reference count for each profile reference returned from a call to the CMOpenProfile, CMNewProfile, CMCopyProfile, or CWNewLinkProfile functions. Calling the function CMCloneProfileRef increments the count; calling the CMCloseProfile function decrements it. The profile remains open as long as the reference count is greater than 0, indicating there is at least one remaining reference to the profile. When the count reaches 0, the ColorSync Manager releases all private memory, files, or resources allocated in association with that profile.

When the ColorSync Manager releases all private memory and resources associated with a profile, any temporary changes your application made to the profile are not saved unless you first call the CMUpdateProfile function to update the profile.

When your application passes a copy of a profile reference to an independent task, whether synchronous or asynchronous, it should call the function CMCloneProfileRef to increment the reference count. Both the called task and the caller should call CMCloseProfile when finished with the profile reference.

You call CMCloneProfileRef after copying a profile reference, but not after duplicating an entire profile (as with the CMCopyProfile function).

When your application passes a copy of a profile reference internally, it may not need to call CMCloneProfileRef, as long as the application calls CMCloseProfile once for the profile.

In your application, make sure that CMCloseProfile is called once for each time a profile reference is created or cloned. Otherwise, the private memory and resources associated with the profile reference may not be properly freed, or an application may attempt to use a profile reference that is no longer valid.

If you create a new profile by calling the CMNewProfile function, the profile is saved to disk when you call the CMCloseProfile function unless you specified NULL as the profile location when you created the profile.

To save changes to a profile before closing it, use the function CMUpdateProfile. 
Availability
Available in CarbonLib 1.0 and later when ColorSync 2.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
CMApplication.h*/
CMError CMCloseProfile (
   CMProfileRef prof){
//TODO
};


/*CMGetProfileByAVID

Gets the current profile for a monitor.

CMError CMGetProfileByAVID (
   CMDisplayIDType theID,
   CMProfileRef * prof
);
Parameters
theAVID

A Display Manager ID value. You pass the ID value for the monitor for which to get the profile. 
prof

A pointer to a profile reference. On return, a reference to the current profile for the monitor specified by theAVID. 
Return Value

A CMError value. See “ColorSync Manager Result Codes”.
Discussion

If the Display Manager supports ColorSync, the CMGetProfileByAVID function calls on the Display Manager to get the profile for the specified display. This is the case if the version of the Display Manager is 2.2.5 or higher (if gestaltDisplayMgrAttr has the gestaltDisplayMgrColorSyncAware bit set). 
Availability
Available in CarbonLib 1.0 and later when ColorSync 2.5 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
CMApplication.h*/
CMError CMGetProfileByAVID (
   CMDisplayIDType theID,
   CMProfileRef * prof){
//TODO
};

