#include <CFNetwork/CFNetwork.h>

/*CFReadStreamCreateWithFTPURL

Creates an FTP read stream.

CFReadStreamRef CFReadStreamCreateWithFTPURL (
    CFAllocatorRef alloc,
    CFURLRef ftpURL
);
Parameters
alloc

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator.
ftpURL

A pointer to a CFURL structure for the URL to be downloaded that can be created by calling any of the CFURLCreate functions, such as CFURLCreateWithString.
Return Value

A new read stream, or NULL if the call failed. Ownership follows the Create Rule.
Discussion

This function creates an FTP read stream for downloading data from an FTP URL. If the ftpURL parameter is created with the user name and password as part of the URL (such as ftp://username:password@ftp.example.com) then the user name and password will automatically be set in the CFReadStream. Otherwise, call CFReadStreamSetProperty to set the steam’s properties, such as kCFStreamPropertyFTPUserName and kCFStreamPropertyFTPPassword to associate a user name and password with the stream that are used to log in when the stream is opened. See "Constants" for a description of all FTP stream properties.

To initiate a connection with the FTP server, call CFReadStreamOpen. To read the FTP stream, call CFReadStreamRead. If the URL refers to a directory, the stream provides the listing results sent by the server. If the URL refers to a file, the stream provides the data in that file.

To close a connection with the FTP server, call CFReadStreamClose.
Availability
Available in Mac OS X version 10.3 and later.
Declared In
CFNetwork/CFFTPStream.h*/

CFReadStreamRef CFReadStreamCreateWithFTPURL (
    CFAllocatorRef alloc,
    CFURLRef ftpURL
){};


/*CFFTPCreateParsedResourceListing

Parses an FTP listing to a dictionary.

CFIndex CFFTPCreateParsedResourceListing (
    CFAllocatorRef alloc,
    const UInt8 *buffer,
    CFIndex bufferLength,
    CFDictionaryRef *parsed
);
Parameters
alloc

The allocator to use to allocate memory for the dictionary. Pass NULL or kCFAllocatorDefault to use the current default allocator.
buffer

A pointer to a buffer holding zero or more lines of resource listing.
bufferLength

The length in bytes of the buffer pointed to by buffer.
parsed

Upon return, contains a dictionary containing the parsed resource information. If parsing fails, a NULL pointer is returned.
Return Value

The number of bytes parsed, 0 if no bytes were available for parsing, or -1 if parsing failed.
Discussion

This function examines the contents of buffer as an FTP directory listing and parses into a CFDictionary the information for a single file or folder. The CFDictionary is returned in the parsed parameter, and the number of bytes used from buffer is returned.
Availability
Available in Mac OS X version 10.3 and later.
Declared In
CFNetwork/CFFTPStream.h*/
CFIndex CFFTPCreateParsedResourceListing (
    CFAllocatorRef alloc,
    const UInt8 *buffer,
    CFIndex bufferLength,
    CFDictionaryRef *parsed
){};

/*CFWriteStreamCreateWithFTPURL

Creates an FTP write stream.

CFWriteStreamRef CFReadStreamCreateWithFTPURL (
    CFAllocatorRef alloc,
    CFURLRef ftpURL
);
Parameters
alloc

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator.
ftpURL

A pointer to a CFURL structure for the URL to be uploaded created by calling any of the CFURLCreate functions, such as CFURLCreateWithString.
Return Value

A new write stream, or NULL if the call failed. Ownership follows the Create Rule.
Discussion

This function creates an FTP write stream for uploading data to an FTP URL. If the ftpURL parameter is created with the user name and password as part of the URL (such as ftp://username:password@ftp.example.com) then the user name and password will automatically be set in the CFWriteStream. Call CFWriteStreamSetProperty to set the steam’s properties, such as kCFStreamPropertyFTPUserName and kCFStreamPropertyFTPPassword to associate a user name and password with the stream that are used to log in when the stream is opened. See "Constants" for a description of all FTP stream properties.

After creating the write stream, you can call CFWriteStreamGetStatus at any time to check the status of the stream.

To initiate a connection with the FTP server, call CFWriteStreamOpen. If the URL specifies a directory, the open is immediately followed by the event kCFStreamEventEndEncountered (and the stream passes to the state kCFStreamStatusAtEnd). Once the stream reaches this state, the directory has been created. Intermediary directories are not created.

To write to the FTP stream, call CFWriteStreamWrite.

To close a connection with the FTP server, call CFWriteStreamClose.
Availability
Available in Mac OS X version 10.3 and later.
Declared In
CFNetwork/CFFTPStream.h*/
CFWriteStreamRef CFWriteStreamCreateWithFTPURL (
    CFAllocatorRef alloc,
    CFURLRef ftpURL
){};


/*CFHTTPMessageCreateRequest

Creates and returns a CFHTTPMessage object for an HTTP request.

CFHTTPMessageRef CFHTTPMessageCreateRequest (
    CFAllocatorRef allocator,
    CFStringRef requestMethod,
    CFURLRef url,
    CFStringRef httpVersion
);
Parameters
allocator

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator.
requestMethod

The request method for the request. Use any of the request methods allowed by the HTTP version specified by httpVersion.
url

The URL to which the request will be sent.
httpVersion

The HTTP version for this message. Pass kCFHTTPVersion1_0 or kCFHTTPVersion1_1.
Return Value

A new CFHTTPMessage object, or NULL if there was a problem creating the object. Ownership follows the Create Rule.
Discussion

This function returns a CFHTTPMessage object that you can use to build an HTTP request. Continue building the request by callingCFHTTPMessageSetBody to set the message’s body. Call CFHTTPMessageCopyHeaderFieldValue to set the message’s headers.

If you are using a CFReadStream object to send the message, call CFReadStreamCreateForHTTPRequest to create a read stream for the request. If you are not using CFReadStream, call CFHTTPMessageCopySerializedMessage to make the message ready for transmission by serializing it.
Availability
Available in Mac OS X version 10.1 and later.
Declared In
CFNetwork/CFHTTPMessage.h*/
CFHTTPMessageRef CFHTTPMessageCreateRequest (
    CFAllocatorRef allocator,
    CFStringRef requestMethod,
    CFURLRef url,
    CFStringRef httpVersion
){};



/*CFReadStreamCreateForHTTPRequest

Creates a read stream for a CFHTTP request message.

CFReadStreamRef CFReadStreamCreateForHTTPRequest (
    CFAllocatorRef alloc,
    CFHTTPMessageRef request
);
Parameters
alloc

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator.
request

A CFHTTP request message whose body and headers have been set.
Return Value

A new read stream, or NULL if there was a problem creating the object. Ownership follows the Create Rule.
Discussion

This function creates a read stream and associates it with the specified request. Automatic redirection is disabled by default. After creating the read stream, you can call CFReadStreamGetError at any time to check the status of the stream. You may want to call CFHTTPReadStreamSetRedirectsAutomatically to enable automatic redirection, or CFHTTPReadStreamSetProxy to set the name and port number for a proxy. To serialize the request and send it, call CFReadStreamOpen.

If the body of the request is too long to keep in memory, call CFReadStreamCreateForStreamedHTTPRequest instead of this function.
Availability
Available in Mac OS X version 10.1 and later.
Declared In
CFNetwork/CFHTTPStream.h*/
CFReadStreamRef CFReadStreamCreateForHTTPRequest (
    CFAllocatorRef alloc,
    CFHTTPMessageRef request
){};



/*CFNetServiceRef

An opaque reference representing a CFNetService.

typedef struct __CFNetService* CFNetServiceRef;
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CFNetwork/CFNetServices.h*/
typedef struct __CFNetService* CFNetServiceRef;

/*CFNetServiceBrowserCreate

Creates an instance of a Network Service browser object.

CFNetServiceBrowserRef CFNetServiceBrowserCreate (
CFAllocatorRef alloc,
CFNetServiceBrowserClientCallBack clientCB,
CFNetServiceClientContext* clientContext);
Parameters
alloc

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator.
clientCB

Callback function that is to be called when domains and services are found; cannot be NULL. For details, see CFNetServiceBrowserClientCallBack.
clientContext

Context information to be used when clientCB is called; cannot be NULL. For details, see CFNetServiceClientContext.
Return Value

A new browser object, or NULL if the instance could not be created. Ownership follows the Create Rule.
Discussion

This function creates an instance of a Network Service browser object, called a CFNetServiceBrowser, that can be used to search for domains and for services.

To use the resulting CFNetServiceBrowser in asynchronous mode, call CFNetServiceBrowserScheduleWithRunLoop. Then call CFNetServiceBrowserSearchForDomains and CFNetServiceBrowserSearchForServices to use the CFNetServiceBrowser to search for services and domains, respectively. The callback function specified by clientCB is called from a run loop to pass search results to your application. The search continues until you stop the search by calling CFNetServiceBrowserStopSearch.

If you do not call CFNetServiceBrowserScheduleWithRunLoop, searches with the resulting CFNetServiceBrowser are made in synchronous mode. Calls made to CFNetServiceBrowserSearchForDomains and CFNetServiceBrowserSearchForServices block until there are search results, in which case the callback function specified by clientCB is called, until the search is are stopped by calling CFNetServiceBrowserStopSearch from another thread, or an error occurs.

To shut down a CFNetServiceBrowser that is running in asynchronous mode, call CFNetServiceBrowserUnscheduleFromRunLoop, followed by CFNetServiceBrowserInvalidate, and then CFNetServiceBrowserStopSearch.
Special Considerations

This function is thread safe.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CFNetwork/CFNetServices.h*/
CFNetServiceBrowserRef CFNetServiceBrowserCreate (
CFAllocatorRef alloc,
CFNetServiceBrowserClientCallBack clientCB,
CFNetServiceClientContext* clientContext){};


/*CFNetServiceBrowserScheduleWithRunLoop

Schedules a CFNetServiceBrowser on a run loop.

void CFNetServiceBrowserScheduleWithRunLoop (
CFNetServiceBrowserRef browser,
CFRunLoopRef runLoop,
CFStringRef runLoopMode);
Parameters
browser

The CFNetServiceBrowser that is to be scheduled on a run loop; cannot be NULL.
runLoop

The run loop on which the browser is to be scheduled; cannot be NULL.
runLoopMode

The mode on which to schedule the browser; cannot be NULL.
Discussion

This function schedules the specified CFNetServiceBrowser on the run loop, thereby placing the browser in asynchronous mode. The run loop will call the browser’s callback function to deliver the results of domain and service searches. The caller is responsible for ensuring that at least one of the run loops on which the browser is scheduled is being run.
Special Considerations

This function is thread safe.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CFNetwork/CFNetServices.h*/

void CFNetServiceBrowserScheduleWithRunLoop (
CFNetServiceBrowserRef browser,
CFRunLoopRef runLoop,
CFStringRef runLoopMode){};


/*CFNetServiceBrowserSearchForServices

Searches a domain for services of a specified type.

Boolean CFNetServiceBrowserSearchForServices (
CFNetServiceBrowserRef browser,
CFStringRef domain,
CFStringRef type,
CFStreamError* error);
Parameters
browser

The CFNetServiceBrowser, obtained by previously calling CFNetServiceBrowserCreate, that is to perform the search; cannot be NULL.
domain

The domain to search for the service type; cannot be NULL. To get the domains that are available for searching, call CFNetServiceBrowserSearchForDomains.
type

The service type to search for; cannot be NULL. For a list of valid service types, see http://www.iana.org/assignments/port-numbers.
error

A pointer to a CFStreamError structure, that, if an error occurs, will be set to the error and the error’s domain and passed to your callback function. Pass NULL if you don’t want to receive the error that may occur as a result of this particular call.
Return Value

TRUE if the search was started (asynchronous mode); FALSE if another search is already in progress for this CFNetServiceBrowser or if an error occurred.
Discussion

This function searches the specified domain for services that match the specified service type. The search continues until the search is canceled by calling CFNetServiceBrowserStopSearch. When a match is found, the callback function specified when the CFNetServiceBrowser was created is called and passed an instance of a CFNetService representing the service that was found.

In asynchronous mode, this function returns TRUE if the search was started. Otherwise, it returns FALSE. 

In synchronous mode, this function blocks until the search is stopped by calling CFNetServiceBrowserStopSearch from another thread, in which case this function returns FALSE, or until an error occurs.
Special Considerations

This function is thread safe.

For any one CFNetServiceBrowser, only one domain search or one service search can be in progress at the same time.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CFNetwork/CFNetServices.h*/

Boolean CFNetServiceBrowserSearchForServices (
CFNetServiceBrowserRef browser,
CFStringRef domain,
CFStringRef type,
CFStreamError* error){};

/*CFNetServiceBrowserUnscheduleFromRunLoop

Unschedules a CFNetServiceBrowser from a run loop and mode.

void CFNetServiceBrowserUnscheduleFromRunLoop (
CFNetServiceBrowserRef browser,
CFRunLoopRef runLoop,
CFStringRef runLoopMode);
Parameters
browser

The CFNetServiceBrowser that is to be unscheduled; cannot be NULL.
runLoop

The run loop; cannot be NULL.
runLoopMode

The mode from which the browser is to be unscheduled; cannot be NULL.
Discussion

Call this function to shut down a browser that is running asynchronously. To complete the shutdown, call CFNetServiceBrowserInvalidate followed by CFNetServiceBrowserStopSearch.
Special Considerations

This function is thread safe.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CFNetwork/CFNetServices.h*/

void CFNetServiceBrowserUnscheduleFromRunLoop (
CFNetServiceBrowserRef browser,
CFRunLoopRef runLoop,
CFStringRef runLoopMode){};



/*CFNetServiceGetDomain

Gets the domain from a CFNetService.

CFStringRef CFNetServiceGetDomain (CFNetServiceRef theService);
Parameters
theService

The CFNetService whose domain is to be obtained; cannot be NULL.
Return Value

A CFString object containing the domain of the CFNetService.
Discussion

This function gets the domain from a CFNetService.
Special Considerations

This function is thread safe. The function gets the data in a thread-safe way, but the data is not safe if the service is altered from another thread.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CFNetwork/CFNetServices.h*/
CFStringRef CFNetServiceGetDomain (CFNetServiceRef theService){};


/*CFNetServiceGetName

Gets the name from a CFNetService.

CFStringRef CFNetServiceGetName (CFNetServiceRef theService);
Parameters
theService

The CFNetService whose name is to be obtained; cannot be NULL.
Return Value

A CFString object containing the name of the service represented by the CFNetService.
Discussion

This function gets the name from a CFNetService.
Special Considerations

This function is thread safe. The function gets the data in a thread-safe way, but the data is not safe if the service is altered from another thread.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CFNetwork/CFNetServices.h*/
CFStringRef CFNetServiceGetName (CFNetServiceRef theService){};

/*CFNetServiceCreate

Creates an instance of a Network Service object.

CFNetServiceRef CFNetServiceCreate (
    CFAllocateRef alloc,
    CFStringRef domain,
    CFStringRef type,
    CFStringRef name,
    UInt32 port
);
Parameters
alloc

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator.
domain

The domain in which the CFNetService is to be registered; cannot be NULL. Call CFNetServiceBrowserCreate and CFNetServiceBrowserSearchForDomains to get the registration domain.
type

The type of service being registered; cannot be NULL. For a list of valid service types, see http://www.iana.org/assignments/port-numbers.
name

A unique name if the instance will be used to register a service. The name will become part of the instance name in the DNS records that will be created when the service is registered. If the instance will be used to resolve a service, the name should be the name of the machine or service that will be resolved.
port

Local IP port, in host byte order, on which this service accepts connections. Pass zero to get placeholder service. With a placeholder service, the service will not be discovered by browsing, but a name conflict will occur if another client tries to register the same name. Most applications do not need to use placeholder service. 
Return Value

A new net service object, or NULL if the instance could not be created. Ownership follows the Create Rule.
Discussion

If the service depends on information in DNS TXT records, call CFNetServiceSetProtocolSpecificInformation.

If the CFNetService is to run in asynchronous mode, call CFNetServiceSetClient to prepare the service for running in asynchronous mode. Then call CFNetServiceScheduleWithRunLoop to schedule the service on a run loop. Then call CFNetServiceRegister to make the service available.

If the CFNetService is to run in synchronous mode, call CFNetServiceRegister.

To terminate a service that is running in asynchronous mode, call CFNetServiceCancel and CFNetServiceUnscheduleFromRunLoop.

To terminate a service that is running in synchronous mode, call CFNetServiceCancel.
Special Considerations

This function is thread safe.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CFNetwork/CFNetServices.h*/
CFNetServiceRef CFNetServiceCreate (
    CFAllocateRef alloc,
    CFStringRef domain,
    CFStringRef type,
    CFStringRef name,
    UInt32 port
){};


/*CFNetServiceRegister

Makes a CFNetService available on the network. (Deprecated. Use CFNetServiceRegisterWithOptions instead.)

Boolean CFNetServiceRegister (
    CFNetServiceRef theService,
    CFStreamError* error
);
Parameters
theService

The CFNetService to register; cannot be NULL. The registration will fail if the service doesn’t have a domain, a type, a name, and an IP address.
error

A pointer to a CFStreamError structure that will be set to an error code and the error code’s domain if an error occurs; or NULL if you don’t want to receive the error code and its domain.
Return Value

TRUE if an asynchronous service registration was started; FALSE if an asynchronous or synchronous registration failed or if a synchronous registration was canceled. 
Discussion

If the service is to run in asynchronous mode, you must call CFNetServiceSetClient to associate a callback function with this CFNetService before calling this function.

When registering a service that runs in asynchronous mode, this function returns TRUE if the service contains all of the required attributes and the registration process can start. If the registration process completes successfully, the service is available on the network until you shut down the service by calling CFNetServiceUnscheduleFromRunLoop, CFNetServiceSetClient, and CFNetServiceCancel. If the service does not contain all of the required attributes or if the registration process does not complete successfully, this function returns FALSE.

When registering a service that runs in synchronous mode, this function blocks until an error occurs, in which case this function returns FALSE. Until this function returns FALSE, the service is available on the network. To force this function to return FALSE, thereby shutting down the service, call CFNetServiceCancel from another thread.
Special Considerations

This function is thread safe.
Availability
Available in Mac OS X version 10.2 and later.
Deprecated in Mac OS X version 10.4.
Declared In
CFNetwork/CFNetServices.h*/
Boolean CFNetServiceRegister (
    CFNetServiceRef theService,
    CFStreamError* error
){};





/*CFNetServiceSetClient

Associates a callback function with a CFNetService or disassociates a callback function from a CFNetService.

Boolean CFNetServiceSetClient (
    CFNetServiceRef theService,
    CFNetServiceClientCallback clientCB,
    CFNetServiceClientContext* clientContext
);
Parameters
theService

The CFNetService; cannot be NULL.
clientCB

The callback function that is to be associated with this CFNetService. If you are shutting down the service, set clientCB to NULL to disassociate from this CFNetService the callback function that was previously associated.
clientContext

Context information to be used when clientCB is called; cannot be NULL.
Return Value

TRUE if the client was set; otherwise, FALSE.
Discussion

The callback function specified by clientCB will be called to report IP addresses (in the case of CFNetServiceResolve) or to report registration errors (in the case of CFNetServiceRegister).
Special Considerations

This function is thread safe.

For a CFNetService that will operate asynchronously, call this function and then call CFNetServiceScheduleWithRunLoop to schedule the service on a run loop. Then call CFNetServiceRegister or CFNetServiceResolve.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CFNetwork/CFNetServices.h*/
Boolean CFNetServiceSetClient (
    CFNetServiceRef theService,
    CFNetServiceClientCallback clientCB,
    CFNetServiceClientContext* clientContext
){};


/*CFNetServiceScheduleWithRunLoop

Schedules a CFNetService on a run loop.

void CFNetServiceScheduleWithRunLoop (
    CFNetServiceRef theService,
    CFRunLoopRef runLoop,
    CFStringRef runLoopMode
);
Parameters
theService

The CFNetService that is to be scheduled on a run loop; cannot be NULL.
runLoop

The run loop on which the service is to be scheduled; cannot be NULL.
runLoopMode

The mode on which to schedule the service; cannot be NULL.
Discussion

Schedules the specified service on a run loop, which places the service in asynchronous mode. The caller is responsible for ensuring that at least one of the run loops on which the service is scheduled is being run.
Special Considerations

This function is thread safe.

Before calling this function, call CFNetServiceSetClient to prepare a CFNetService for use in asynchronous mode.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CFNetwork/CFNetServices.h*/
void CFNetServiceScheduleWithRunLoop (
    CFNetServiceRef theService,
    CFRunLoopRef runLoop,
    CFStringRef runLoopMode
){};


/*CFNetServiceRegisterWithOptions

Makes a CFNetService available on the network.

Boolean CFNetServiceRegister (
CFNetServiceRef theService,
CFOptionFlags options,
CFStreamError* error);
Parameters
theService

Network service to register; cannot be NULL. The registration will fail if the service doesn’t have a domain, a type, a name, and an IP address.
options

Bit flags for specifying registration options. Currently, the only registration option is kCFNetServiceFlagNoAutoRename. For details, see CFNetService Registration Options.
error

Pointer to a CFStreamError structure that will be set to an error code and the error code’s domain if an error occurs; or NULL if you don’t want to receive the error code and its domain.
Return Value

TRUE if an asynchronous service registration was started; FALSE if an asynchronous or synchronous registration failed or if a synchronous registration was canceled. 
Discussion

If the service is to run in asynchronous mode, you must call CFNetServiceSetClient to associate a callback function with this CFNetService before calling this function.

When registering a service that runs in asynchronous mode, this function returns TRUE if the service contains all of the required attributes and the registration process can start. If the registration process completes successfully, the service is available on the network until you shut down the service by calling CFNetServiceUnscheduleFromRunLoop, CFNetServiceSetClient, and CFNetServiceCancel. If the service does not contain all of the required attributes or if the registration process does not complete successfully, this function returns FALSE.

When registering a service that runs in synchronous mode, this function blocks until an error occurs, in which case this function returns FALSE. Until this function returns FALSE, the service is available on the network. To force this function to return FALSE, thereby shutting down the service, call CFNetServiceCancel from another thread.

The options parameter is a bit flag for specifying service registration options. Currently, kCFNetServiceFlagNoAutoRename is the only supported registration option. If this bit is set and a service of the same name is running, the registration will fail. If this bit is not set and a service of the same name is running, the service that is being registered will be renamed automatically by appending (n) to the service name, where n is a number that is incremented until the service can be registered with a unique name.
Special Considerations

This function is thread safe.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CFNetwork/CFNetServices.h*/

Boolean CFNetServiceRegisterWithOptions (
CFNetServiceRef theService,
CFOptionFlags options,
CFStreamError* error){};

/*CFNetServiceUnscheduleFromRunLoop

Unschedules a CFNetService from a run loop.

void CFNetServiceUnscheduleFromRunLoop (
CFNetServiceRef theService,
CFRunLoopRef runLoop,
CFStringRef runLoopMode);
Parameters
theService

The CFNetService that is to be unscheduled; cannot be NULL.
runLoop

The run loop; cannot be NULL.
runLoopMode

The mode from which the service is to be unscheduled; cannot be NULL.
Discussion

Unschedules the specified service from the specified run loop and mode. Call this function to shut down a service that is running asynchronously. To complete the shutdown, call CFNetServiceSetClient and set clientCB to NULL. Then call CFNetServiceCancel.
Special Considerations

This function is thread safe.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CFNetwork/CFNetServices.h*/
void CFNetServiceUnscheduleFromRunLoop (
CFNetServiceRef theService,
CFRunLoopRef runLoop,
CFStringRef runLoopMode){};



/*CFNetServiceGetType

Gets the type from a CFNetService.

CFStringRef CFNetServiceGetType (CFNetServiceRef theService);
Parameters
theService

The CFNetService whose type is to be obtained; cannot be NULL.
Return Value

A CFString object containing the type from a CFNetService.
Discussion

This function gets the type of a CFNetService.
Special Considerations

This function is thread safe. The function gets the data in a thread-safe way, but the data is not safe if the service is altered from another thread.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CFNetwork/CFNetServices.h*/
CFStringRef CFNetServiceGetType (CFNetServiceRef theService){};


/*CFNetServiceCancel

Cancels a service registration or a service resolution.

void CFNetServiceCancel (CFNetServiceRef theService);
Parameters
theService

The CFNetService, obtained by previously calling CFNetServiceCreate, for which a registration or a resolution is to be canceled.
Discussion

This function cancels service registrations, started by CFNetServiceRegister, thereby making the service unavailable. It also cancels service resolutions, started by CFNetServiceResolve.

If you are shutting down an asynchronous service, you should first call CFNetServiceUnscheduleFromRunLoop and CFNetServiceSetClient with clientCB set to NULL. Then call this function.

If you are shutting down a synchronous service, call this function from another thread.

This function also cancels service resolutions. You would want to cancel a service resolution if your callback function has received an IP address that you’ve successfully used to connect to the service. In addition, you might want to cancel a service resolution if the resolution is taking longer than a user would want to wait or if the user canceled the operation.
Special Considerations

This function is thread safe.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CFNetwork/CFNetServices.h*/
void CFNetServiceCancel (CFNetServiceRef theService){};


/*CFNetServiceResolveWithTimeout

Gets the IP address or addresses for a CFNetService.

Boolean CFNetServiceResolve (
    CFNetServiceRef theService,
    CFTimeInterval timeout,
    CFStreamError* error
);
Parameters
theService

The CFNetService to resolve; cannot be NULL. The resolution will fail if the service doesn’t have a domain, a type, and a name.
timeout

Value of type CFTimeInterval specifying the maximum amount of time allowed to perform the resolution. If the resolution is not performed within the specified amount of time, a timeout error will be returned. If timeout is less than or equal to zero, an infinite amount of time is allowed.
error

Pointer to a CFStreamError structure that will be set to an error code and the error code’s domain if an error occurs; or NULL if you don’t want to receive the error code and its domain.
Return Value

TRUE if an asynchronous service resolution was started or if a synchronous service resolution updated the CFNetService; FALSE if an asynchronous or synchronous resolution failed or timed out, or if a synchronous resolution was canceled.
Discussion

This function updates the specified CFNetService with the IP address or addresses associated with the service. Call CFNetServiceGetAddressing to get the addresses.

When resolving a service that runs in asynchronous mode, this function returns TRUE if the CFNetService has a domain, type, and name, and the underlying resolution process was started. Otherwise, this function returns FALSE. Once started, the resolution continues until it is canceled by calling CFNetServiceCancel.

When resolving a service that runs in synchronous mode, this function blocks until the CFNetService is updated with at least one IP address, until an error occurs, or until CFNetServiceCancel is called.
Special Considerations

This function is thread safe.

If the service will be used in asynchronous mode, you must call CFNetServiceSetClient before calling this function.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CFNetwork/CFNetServices.h*/
Boolean CFNetServiceResolveWithTimeout (
    CFNetServiceRef theService,
    CFTimeInterval timeout,
    CFStreamError* error
){};

/*CFNetServiceGetAddressing

Gets the IP addressing from a CFNetService.

CFArray CFNetServiceGetAddressing (CFNetServiceRef theService);
Parameters
theService

The CFNetService whose IP addressing is to be obtained; cannot be NULL.
Return Value

A CFArray containing a CFDataRef for each IP address returned, or NULL. Each CFDataRef consists of a sockaddr structure containing the IP address of the service. This function returns NULL if the service’s addressing is unknown because CFNetServiceResolve has not been called for theService.
Discussion

This function gets the IP addressing from a CFNetService. Typically, the CFNetService was obtained by calling CFNetServiceBrowserSearchForServices. Before calling this function, call CFNetServiceResolve to update the CFNetService with its IP addressing.
Special Considerations

This function gets the data in a thread-safe way, but the data itself is not safe if the service is altered from another thread.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CFNetwork/CFNetServices.h*/
CFArrayRef  CFNetServiceGetAddressing (CFNetServiceRef theService){};



/*CFNetServiceResolve

This function updates the specified CFNetService with the IP address or addresses associated with the service. Call CFNetServiceGetAddressing to get the addresses. (Deprecated. Use CFNetServiceResolveWithTimeout instead.)

Boolean CFNetServiceResolve (
    CFNetServiceRef theService,
    CFStreamError* error
);
Parameters
theService

The CFNetService to resolve; cannot be NULL. The resolution will fail if the service doesn’t have a domain, a type, and a name.
error

A pointer to a CFStreamError structure that will be set to an error code and the error code’s domain if an error occurs; or NULL if you don’t want to receive the error code and its domain.
Return Value

TRUE if an asynchronous service resolution was started or if a synchronous service resolution updated the CFNetService; FALSE if an asynchronous or synchronous resolution failed or if a synchronous resolution was canceled.
Discussion

When resolving a service that runs in asynchronous mode, this function returns TRUE if the CFNetService has a domain, type, and name, and the underlying resolution process was started. Otherwise, this function returns FALSE. Once started, the resolution continues until it is canceled by calling CFNetServiceCancel.

When resolving a service that runs in synchronous mode, this function blocks until the CFNetService is updated with at least one IP address, until an error occurs, or until CFNetServiceCancel is called.
Special Considerations

This function is thread safe.

If the service will be used in asynchronous mode, you must call CFNetServiceSetClient before calling this function.
Availability
Available in Mac OS X version 10.2 and later.
Deprecated in Mac OS X version 10.4.
Declared In
CFNetwork/CFNetServices.h*/

Boolean CFNetServiceResolve (
    CFNetServiceRef theService,
    CFStreamError* error
){};


/*CFNetServiceGetProtocolSpecificInformation

This function gets protocol-specific information from a CFNetService. (Deprecated. Use CFNetServiceGetTXTData instead.)

CFStringRef CFNetServiceGetProtocolSpecificInformation (
CFNetServiceRef theService);
Parameters
theService

The CFNetService whose protocol-specific information is to be obtained; cannot be NULL. Note that in order to get protocol-specific information, you must resolve theService by calling CFNetServiceResolve or CFNetServiceResolveWithTimeout before calling this function.
Return Value

A CFString object containing the protocol-specific information, or NULL if there is no information. 
Special Considerations

This function gets the data in a thread-safe way, but the data itself is not safe if the service is altered from another thread.
Availability
Available in Mac OS X version 10.2 and later.
Deprecated in Mac OS X version 10.4.
Declared In
CFNetwork/CFNetServices.h*/

CFStringRef CFNetServiceGetProtocolSpecificInformation (
CFNetServiceRef theService){};



/*CFNetServiceSetProtocolSpecificInformation

Sets protocol-specific information for a CFNetService. (Deprecated. Use CFNetServiceSetTXTData instead.)

void CFNetServiceSetProtocolSpecificInformation (
CFNetServiceRef theService,
CFStringRef theInfo);
Parameters
theService

The CFNetService whose protocol-specific information is to be set; cannot be NULL.
theInfo

The protocol-specific information to be set. Pass NULL to remove protocol-specific information from the service.
Discussion

The protocol-specific information appears in DNS TXT records for the service. Each TXT record consists of zero or more strings, packed together without any intervening gaps or padding bytes for word alignment. The format of each constituent string is a single length byte, followed by zero to 255 bytes of text data.
Special Considerations

This function is thread safe.
Availability
Available in Mac OS X version 10.2 and later.
Deprecated in Mac OS X version 10.4.
Declared In
CFNetwork/CFNetServices.h*/
void CFNetServiceSetProtocolSpecificInformation (
CFNetServiceRef theService,
CFStringRef theInfo){};


/*CFNetServiceBrowserInvalidate

Invalidates an instance of a Network Service browser object.

void CFNetServiceBrowserInvalidate (CFNetServiceBrowserRef browser);
Parameters
browser

The CFNetServiceBrowser to invalidate, obtained by a previous call to CFNetServiceBrowserCreate.
Discussion

This function invalidates the specified instance of a Network Service browser object. Any searches using the specified instance that are in progress when this function is called are stopped. An invalidated browser cannot be scheduled on a run loop and its callback function is never called.
Special Considerations

This function is thread safe as long as another thread does not alter the same CFNetServiceBrowserRef at the same time.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CFNetwork/CFNetServices.h*/
void CFNetServiceBrowserInvalidate (CFNetServiceBrowserRef browser){};















