#ifndef CGREMOTEOPERATION_H
#define CGREMOTEOPERATION_H


#include <CoreGraphics/CGBase.h>
#include <CoreGraphics/CGGeometry.h>
#include <CoreGraphics/CGError.h>
#include <CoreGraphics/CGDirectDisplay.h>
#include <AvailabilityMacros.h>

/*CGCharCode

Represents a character generated by pressing one or more keys on a keyboard.

typedef uint16_t CGCharCode;
Discussion

This data type represents a 16-bit character code. Values of this type may or may not correspond to UTF-16 character codes. See the function CGPostKeyboardEvent.
Availability
Available in Mac OS X v10.0 and later.*/
typedef uint16_t CGCharCode;

/*CGKeyCode

Represents the virtual key codes used in keyboard events.

typedef uint16_t CGKeyCode;
Discussion

In Mac OS X, the hardware scan codes generated by keyboards are mapped to a set of virtual key codes that are hardware-independent. Pressing a given key always generates the same virtual key code on any supported keyboard.

As keys are pressed, the system uses the virtual key codes to create low-level keyboard events. For information on how to simulate a keyboard event, see the function CGEventCreateKeyboardEvent. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef uint16_t CGKeyCode;

/*CGPostKeyboardEvent

Synthesizes a low-level keyboard event on the local machine.

CGError CGPostKeyboardEvent (
   CGCharCode keyChar,
   CGKeyCode virtualKey,
   boolean_t keyDown
);
Parameters
keyChar

The value of the character to generate, or 0 to specify that the system should guess an appropriate value based on the default key mapping.
virtualKey

The virtual key code for the event. See CGKeyCode.
keyDown

Pass true to specify that the key position is down; otherwise, pass false.
Return Value

A result code. See Quartz Display Services Result Codes. 
Discussion

This function is not recommended for general use because of undocumented special cases and undesirable side effects. The recommended replacement for this function is CGEventCreateKeyboardEvent, which allows you to create a keyboard event and customize the event before posting it to the event system. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CGRemoteOperation.h*/
CGError CGPostKeyboardEvent (
   CGCharCode keyChar,
   CGKeyCode virtualKey,
   boolean_t keyDown
);

#endif