#ifndef CFBASE_H
#define CFBASE_H

#include <stdint.h>
#include <stdbool.h>
#include <AvailabilityMacros.h>

 #include <CarbonCore/MacTypes.h>

 #include <ETC/CoreFoundation/CFBase.h>
 #include <HYS/CoreFoundation/CFBase.h>

#if defined(__cplusplus)
extern "C" {
#endif

/*CFComparatorFunction

Callback function that compares two values. You provide a pointer to this callback in certain Core Foundation sorting functions.

typedef CFComparisonResult (*CFComparatorFunction) (
   const void *val1,
   const void *val2,
   void *context
);

If you name your function MyCallBack, you would declare it like this:

CFComparisonResult MyCallBack (
   const void *val1,
   const void *val2,
   void *context
);
Parameters
val1

The first value to compare.
val2

The second value to compare.
context

An untyped pointer to the context of the evaluation. The meaning of this value and its use are defined by each comparator function. This value is usually passed to a sort function, such as CFArraySortValues, which then passes it, unchanged, to the comparator function.
Return Value

An integer value of type CFComparisonResult that indicates whether the val1 is equal to, less than, or greater than val2. See “Comparison Results” for a list of possible return values.
Discussion

If you need to sort the elements in a collection using special criteria, you can implement a comparator function with the signature defined by this prototype. You pass a pointer to this function in one of the “sort” functions, such as CFArray's CFArraySortValues. 

You can also pass pointers to standard Core Foundation comparator functions such as CFStringCompare and CFDateCompare.*/
typedef CFComparisonResult (*CFComparatorFunction) (
   const void *val1,
   const void *val2,
   void *context
);


/*CFIndex

An integer type used throughout Core Foundation in several programmatic roles: as an array index and for count, size, and length parameters and return values. 

typedef SInt32 CFIndex;
Discussion

Core Foundation types as CFIndex all parameters and return values that might grow over time as the processor's address size changes. On architectures where pointer sizes are a different size (say, 64 bits) CFIndex might be declared to be also 64 bits, independent of the size of int. If you type your own variables that interact with Core Foundation as CFIndex, your code will have a higher degree of source compatibility in the future. 
Availability
Available in Mac OS X v10.0 and later.*/
//typedef SInt32 CFIndex;

/*CFHashCode

A type for hash codes returned by the CFHash function.

typedef UInt32 CFHashCode;
Availability
Available in Mac OS X v10.0 and later.*/
typedef UInt32 CFHashCode;

/*CFPropertyListRef

A reference to a CFPropertyList object.

typedef CFTypeRef CFPropertyListRef;
Discussion

This is an abstract type for property list objects. The return value of the CFPropertyListCreateFromXMLData function depends on the contents of the given XML data. CFPropertyListRef can be a reference to any of the property list objects: CFData, CFString, CFArray, CFDictionary, CFDate, CFBoolean, and CFNumber. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef CFTypeRef CFPropertyListRef;

/*Constants
Predefined Allocators

CFAllocator provides the following predefined allocators. In general, you should use kCFAllocatorDefault unless one of the special circumstances exist below.

const CFAllocatorRef kCFAllocatorDefault;
const CFAllocatorRef kCFAllocatorSystemDefault;
const CFAllocatorRef kCFAllocatorMalloc;
const CFAllocatorRef kCFAllocatorMallocZone;
const CFAllocatorRef kCFAllocatorNull;
const CFAllocatorRef kCFAllocatorUseContext;
Constants
kCFAllocatorDefault

This is a synonym for NULL. 

Available in Mac OS X v10.0 and later.
kCFAllocatorSystemDefault

Default system allocator.

You rarely need to use this.

Available in Mac OS X v10.0 and later.
kCFAllocatorMalloc

This allocator uses malloc(), realloc(), and free(). 

Typically you should not use this allocator, use kCFAllocatorDefault instead. This allocator is useful as the bytesDeallocator in CFData or contentsDeallocator in CFString where the memory was obtained as a result of malloc type functions.

Available in Mac OS X v10.0 and later.
kCFAllocatorMallocZone

This allocator explicitly uses the default malloc zone, returned by malloc_default_zone().

You should only use this when an object is safe to be allocated in non-scanned memory.

Available in Mac OS X v10.4 and later.
kCFAllocatorNull

This allocator does nothing?it allocates no memory. 

This allocator is useful as the bytesDeallocator in CFData or contentsDeallocator in CFString where the memory should not be freed.

Available in Mac OS X v10.0 and later.
kCFAllocatorUseContext

Special allocator argument to CFAllocatorCreate?it uses the functions given in the context to allocate the allocator.

Available in Mac OS X v10.0 and later.
Declared In
CFBase.h*/
//const CFAllocatorRef kCFAllocatorDefault;
//const CFAllocatorRef kCFAllocatorSystemDefault;
//const CFAllocatorRef kCFAllocatorMalloc;
//const CFAllocatorRef kCFAllocatorMallocZone;
//const CFAllocatorRef kCFAllocatorNull;
//const CFAllocatorRef kCFAllocatorUseContext;


/*CFAllocatorRetainCallBack

A prototype for a function callback that retains the given data.

typedef const void *(*CFAllocatorRetainCallBack) (
   const void *info
);

If you name your function MyCallBack, you would declare it like this:

const void *MyCallBack (
   const void *info
);
Parameters
info

The data to be retained.
Discussion

A prototype for a function callback that retains the data pointed to by the info field. In implementing this function, retain the data you have defined for the allocator context in this field. (This might make sense only if the data is a Core Foundation object.)*/
typedef const void *(*CFAllocatorRetainCallBack) (
   const void *info);


/*CFAllocatorReleaseCallBack

A prototype for a function callback that releases the given data.

typedef void (*CFAllocatorReleaseCallBack) (
   const void *info
);

If you name your function MyCallBack, you would declare it like this:

void MyCallBack (
   const void *info
);
Parameters
info

The data to be released.
Discussion

A prototype for a function callback that releases the data pointed to by the info field. In implementing this function, release (or free) the data you have defined for the allocator context.*/
typedef void (*CFAllocatorReleaseCallBack) (
   const void *info
);

/*CFEqual

Determines whether two Core Foundation objects are considered equal.

Boolean CFEqual (
   CFTypeRef cf1,
   CFTypeRef cf2
);
Parameters
cf1

A CFType object to compare to cf2.
cf2

A CFType object to compare to cf1.
Return Value

true if cf1 and cf2 are of the same type and considered equal, otherwise false. 
Discussion

Equality is something specific to each Core Foundation opaque type. For example, two CFNumber objects are equal if the numeric values they represent are equal. Two CFString objects are equal if they represent identical sequences of characters, regardless of encoding. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
Boolean CFEqual (
   CFTypeRef cf1,
   CFTypeRef cf2
);

/*CFGetTypeID

Returns the unique identifier of an opaque type to which a Core Foundation object belongs.

CFTypeID CFGetTypeID (
   CFTypeRef cf
);
Parameters
cf

The CFType object to examine. 
Return Value

A value of type CFTypeID that identifies the opaque type of cf. 
Discussion

This function returns a value that uniquely identifies the opaque type of any Core Foundation object. You can compare this value with the known CFTypeID identifier obtained with a “GetTypeID” function specific to a type, for example CFDateGetTypeID. These values might change from release to release or platform to platform.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFTypeID CFGetTypeID (
   CFTypeRef cf
);

#ifdef __cplusplus
}
#endif
#endif

