//inclou

#ifndef MACTYPES_H
#define  MACTYPES_H

#ifndef OSTYPES_H //hys
 #include <libkern/OSTypes.h>
#endif

#ifndef CONDITIONALMACROS_H
#include <CarbonCore/ConditionalMacros.h>
#endif

#include <HYS/CarbonCore/MacTypes.h>
#include <stdbool.h>
#include <stdint.h> //hys

#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
//linux define

typedef int8_t SInt8; 
typedef __int16_t  SInt16;
typedef __int32_t  SInt32;
typedef __int64_t  SInt64;
typedef uint8_t  UInt8;
typedef uint16_t  UInt16;
typedef uint32_t  UInt32;
typedef uint64_t  UInt64;

/*ByteCount

Abst_ByteCount

typedef UInt32 ByteCount;
Availability
Available in Mac OS X v10.0 and later.*/
typedef UInt32 ByteCount;

/*ProcessSerialNumber

Defines the unique identifier for an open process.

struct ProcessSerialNumber {
   unsigned long highLongOfPSN;
   unsigned long lowLongOfPSN;
};
typedef struct ProcessSerialNumber ProcessSerialNumber;
typedef ProcessSerialNumber * ProcessSerialNumberPtr;
Fields
highLongOfPSN

The high-order long integer of the process serial number.
lowLongOfPSN

The low-order long integer of the process serial number.
Discussion

All applications (defined as things which can appear in the Dock that are not documents and are launched by the Finder or Dock) on Mac OS X have a unique process serial number. This number is created when the application launches, and remains until the application quits. Other system services, like Apple events, use the ProcessSerialNumber structure to specify an application. 

During launch, every application “checks in” with the Process Manager. Before this checkin, the application can not receive events or draw to the screen. Prior to Mac OS 10.2, this check in occurred before the applications's main function was entered. In Mac OS 10.2 and later, this check in does not occur until the first time the application calls a Process Manager function, or until it enters CFRunLoopRun for the main event loop. This allows tools and other executables which do not need to receive events to link against more of the higher level toolbox frameworks, but may cause a problem if the application expects to be able to retrieve events or use CoreGraphics services before this checkin has occurred. An application can force the connection to the Process Manager to be set up by calling any Process Manager routine, but the recommended way to do this is to call GetCurrentProcess to ask for the current application's PSN. Doing so initializes the connection to the Process Manager if it has not already been set up and ”check in“ the application with the system.

You should not make any assumptions about the meaning of the bits in a process serial number. To compare two process serial numbers, you should use the function SameProcess.

You can obtain a process serial number in one of the following ways:
Process serial numbers are returned by the functions LaunchApplication, GetCurrentProcess, and GetFrontProcess.
Some high-level events return process serial numbers.

If you want to specify a process using the “Process Identification Constants”, you must populate a process serial number structure, passing 0 in highLongOfPSN and the appropriate constant (such as kCurrentProcess) in lowLongOfPSN. For example, to bring the current process forward, you can use the following code:  ProcessSerialNumber psn = { 0, kCurrentProcess };
 SetFrontProcess( &psn );

Availability
Available in Mac OS X v10.0 and later.*/
struct ProcessSerialNumber {
   unsigned long highLongOfPSN;
   unsigned long lowLongOfPSN;
};
typedef struct ProcessSerialNumber ProcessSerialNumber;
typedef ProcessSerialNumber * ProcessSerialNumberPtr;


/*Str31

Represents a type used by the Music Architecture API.

typedef unsigned char Str31;
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeMusic.h*/
typedef unsigned char Str31[100];




/*ConstStr255Param

Abst_ConstStr255Param

typedef const unsigned char * ConstStr255Param;
Availability
Available in Mac OS X v10.0 and later.*/
typedef const unsigned char * ConstStr255Param;

/*TimeBaseRecord

Contains a time base.

struct TimeBaseRecord {
   long    data[1];
};
Fields
data
Discussion

Array of data that constitutes a time base.
Programming Info
C interface file: Movies.h*/
struct TimeBaseRecord {
   long    data[1];
};
typedef  struct TimeBaseRecord TimeBaseRecord;
/*TimeBase

Abst_TimeBase

typedef TimeBaseRecord * TimeBase;
Availability
Available in Mac OS X v10.0 and later.*/
typedef TimeBaseRecord * TimeBase;

/*You specify the time value in a time structure in a 64-bit integer value as follows:
typedef Int64 CompTimeValue;


The Movie Toolbox uses this format so that extremely large time values can be represented. The Int64 data type defines the format of these signed 64-bit integers.
struct Int64
{
    long hi;    // high-order 32 bits-value field in time structure 
    long lo;    //low-order 32 bits-value field in time structure 
};
typedef struct Int64 Int64;*/
struct Int64
{
    long hi;    // high-order 32 bits-value field in time structure 
    long lo;    //low-order 32 bits-value field in time structure 
};
typedef struct Int64 Int64;

typedef Int64 CompTimeValue;

/*Style

Represents a type used by the Movie Manager API.

typedef unsigned char Style;
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
typedef unsigned char Style;


/*ByteCount

Abst_ByteCount

typedef UInt32 ByteCount;
Availability
Available in Mac OS X v10.0 and later.*/
typedef UInt32 ByteCount;

/*typedef float 	float32
 	Single precicion floating point value*/
typedef float 	Float32;

/*TimeValue64

Abst_TimeValue64

typedef SInt64 TimeValue64;
Availability
Available in Mac OS X v10.0 and later.*/
typedef SInt64 TimeValue64;

/*Fixed

Defines a data type for fixed-point decimal numbers.

typedef SInt32 Fixed;
Discussion

This data type uses a 16-bit signed integer and a 16-bit fraction to represent fixed-point decimal numbers in the interval:




For example, the number 1.5 would be represented as 0x00018000, and the number -1.3 would be represented as 0xFFFEB334. To convert numbers between Fixed and float, you can use the functions FixedToFloat and FloatToFixed. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef SInt32 Fixed;

/*TimeValue

Abst_TimeValue

typedef long TimeValue;
Availability
Available in Mac OS X v10.0 and later.*/
typedef long TimeValue;

/*meScale

Abst_TimeScale

typedef long TimeScale;
Availability
Available in Mac OS X v10.0 and later.*/
typedef long TimeScale;

/*Result Codes

The most common result codes returned by the Carbon Event Manager are listed below.Result Code	Value	Description
noErr	0	
No error. 
eventAlreadyPostedErr	-9860	
Returned from PostEventToQueue if the event in question is already in the queue you are posting it to (or any other queue).
eventTargetBusyErr	-9861	
The event target you are trying to modify is busy (for example, dispatching an event).
eventClassInvalidErr	-9862	
This is obsolete and will be removed.
eventClassIncorrectErr	-9864	
This is obsolete and will be removed.
eventHandlerAlreadyInstalledErr	-9866	
Returned from InstallEventHandler if the handler callback you pass is already installed for a given event type you are trying to register.
eventInternalErr	-9868	
A generic error.
eventKindIncorrectErr	-9869	
This is obsolete and will be removed.
eventParameterNotFoundErr	-9870	
The piece of data you are requesting from an event is not present.
eventNotHandledErr	-9874	
This is what you should return from an event handler when your handler has received an event it doesn’t currently want to (or isn’t able to) handle. If you handle an event, you should return noErr from your event handler.
eventLoopTimedOutErr	-9875	
The event loop has timed out. This can be returned from calls to ReceiveNextEvent or RunCurrentEventLoop.
eventLoopQuitErr	-9876	
The event loop was quit, probably by a call to QuitEventLoop. This can be returned from ReceiveNextEvent or RunCurrentEventLoop.
eventNotInQueueErr	-9877	
Returned from RemoveEventFromQueue when trying to remove an event that’s not in any queue.
eventHotKeyExistsErr	-9878	
The hot key combination you chose already exists
eventHotKeyInvalidErr	-9879	
This error code is not currently used.*/
enum {
  noErr= 0
};



/*This section introduces some basic data types that are used throughout the Driver Services Library.
typedef unsigned long           ByteCount; 
typedef unsigned long           ItemCount; 
typedef long                    OSStatus; 
typedef unsigned long           OptionBits; 

For a description of OSStatus, see Error Returns.

The constant kNilOptions (= 0) is provided for clarity.

IDs are used whenever you create, manipulate, or destroy a object. All IDs are derived from the type KernelID :
typedef struct OpaqueRef *KernelID; 

You should use the derived ID types whenever possible to make your code more readable.*/

typedef unsigned long           OptionBits; 

/*FourCharCode

Represents a type used by the Movie Toolkit API.

typedef unsigned long FourCharCode;
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h
MacTypes.h*/
typedef unsigned long FourCharCode;

/*
ResType
GetScrap

Reads data from the scrap.

Unsupported

SInt32 GetScrap (
   Handle hDest,
   ResType theType,
   SInt32 *offset
);
Parameters
hDest

A handle to the memory location where the function should place the data from the scrap. The function makes a copy of the data in memory and sets the handle specified by the hDest parameter to refer to this copy, resizing the handle if necessary. If you specify NULL in this parameter, the function does not read in the data but does return the offset of the data in the scrap and the number of bytes of the requested scrap data type if the requested type exists in the scrap.
theType

The scrap format type of the data you wish to read from the scrap.
offset

On return, a pointer to the location of the data in the scrap. This value is expressed as an offset (in bytes) from the beginning of the scrap. The returned value for the offset parameter is valid only if the Translation Manager isn’t available if the Translation Manager is available, then the value of offset is undefined.
Return Value

The length (in bytes) of the data or a negative function result that indicates the error. If the function returns noTypeErr, then the data in the scrap isn’t available in the scrap format type requested by your application. 
Discussion

Your application can use this function multiple times to read different formats of the same data from the scrap. If more than one format of the same scrap format type exists in the scrap, the function returns the first occurrence of that format type that it finds. For example, if data of type 'TEXT', 'PICT', and 'TEXT' exist on the scrap, and your application requests the data in the scrap with scrap format type 'TEXT', the function returns the first data of type 'TEXT' that it finds.

If your application supports more than one scrap format type, your application should attempt to read its preferred scrap format type first. If your application doesn’t prefer one scrap format type over any other type, it should try reading each of the scrap format types that it supports and use the type that returns the lowest offset. The scrap format type with the lowest offset indicates that this format type was written before any of the others and therefore was preferred by the application that wrote it. 

If you request a scrap format type that isn’t in the scrap and the Translation Manager is available, the Scrap Manager uses the Translation Manager to convert the data of a scrap format type that does exist in the scrap into the scrap format type requested by your application. For example, if the SurfWriter application requests data from the scrap in the 'SURF' scrap format type, and the data in the scrap is available in the format types 'TEXT', 'PICT', and 'SDBS' (SurfDB’s private scrap format type), the Scrap Manager uses the Translation Manager to convert any one of the scrap format types 'TEXT', 'PICT', or 'SDBS' into the 'SURF' scrap format type. The Translation Manager looks for a translator that can perform one of these translations. If such a translator is available (for example, a translator that can translate the 'SDBS' scrap format type into the 'SURF' scrap format type), the Translation Manager uses the translator to translate the data in the scrap into the requested scrap format type. If the translation is successful, the Scrap Manager returns to your application the data from the scrap in the requested scrap format type.

The scrap format type is a four-character sequence that defines the type of data.typedef FourCharCode ResType;


The standard scrap format types are
'TEXT': a series of ASCII characters 
'PICT': a QuickDraw picture, which is a saved sequence of QuickDraw commands that can be displayed using the DrawPicture function 

Optional scrap format types include
'styl': a series of bytes that have the same format as a TextEdit 'styl' resource and that describe styled text data 
'snd ': a series of bytes that have the same format as an 'snd ' resource and that define a sound 
'movv': a series of bytes that have the same format as an 'movv' resource and that define a movie 

Your application should support the 'TEXT' and 'PICT' scrap format types and should optionally support any other scrap format types (such as 'snd ') that are appropriate to your application.

In general, when your application writes data to the scrap, the Scrap Manager appends the data to the scrap in the following format: the first 4 bytes are the scrap type format; the next 4 bytes are the length of the following data in bytes; and the remaining n bytes (where n is an even number) are the data.

If your application uses TextEdit to handle text in its documents, use TextEdit functions to implement the paste operation and to copy data from the scrap to the TextEdit scrap. If your application uses the Dialog Manager to handle editable text items in your application’s dialog boxes and a dialog box is the frontmost window, use the Dialog Manager function DialogPaste to copy data from the scrap to the current editable text item. 
Special Considerations

This function may move or purge memory blocks in the application heap. Your application should not call this function at interrupt time.
Availability
Not available in CarbonLib. Not available in Mac OS X.
Carbon Porting Notes

You should instead use the functions GetScrapFlavorSize and GetScrapFlavorData.
Declared In
Scrap.h
MacTypea.h*/

typedef FourCharCode ResType;

/*OSErr

Abst_OSErr

typedef SInt16 OSErr;
Availability
Available in Mac OS X v10.0 and later.
MacTypes.h*/
typedef SInt16 OSErr;

/*Str255

Abst_Str255

typedef unsigned char Str255;
Availability
Available in Mac OS X v10.0 and later.
MacTypes.h*/
typedef unsigned char Str255[100];

/*OSStatus

A numeric code used in Carbon to indicate the return status of a function.

typedef SInt32 OSStatus;
Discussion

The system software sometimes uses error codes to inform an application that a requested service is not possible. Many functions return a result code of type OSStatus that indicates whether the function completed successfully, and if not, what the reason for failure was.

If you want to use OSStatus to define error codes for your application, Apple recommends that you use values in the range 1000 through 9999 inclusive. Values outside of this range are reserved by Apple for internal use.
Availability
Available in Mac OS X v10.0 and later.
MacTypes.h*/

typedef SInt32 OSStatus;

/*StrFileName	Recent Changes
Printable View
Page History
Edit Page


Apple's Documentation 

 typedef Str255 StrFileName;


Pages that refer to StrFileName:
MacTypes.h*/
 typedef Str255 StrFileName;


/*GetScrap

Reads data from the scrap.

Unsupported

SInt32 GetScrap (
   Handle hDest,
   ResType theType,
   SInt32 *offset
);
Parameters
hDest

A handle to the memory location where the function should place the data from the scrap. The function makes a copy of the data in memory and sets the handle specified by the hDest parameter to refer to this copy, resizing the handle if necessary. If you specify NULL in this parameter, the function does not read in the data but does return the offset of the data in the scrap and the number of bytes of the requested scrap data type if the requested type exists in the scrap.
theType

The scrap format type of the data you wish to read from the scrap.
offset

On return, a pointer to the location of the data in the scrap. This value is expressed as an offset (in bytes) from the beginning of the scrap. The returned value for the offset parameter is valid only if the Translation Manager isnt available if the Translation Manager is available, then the value of offset is undefined.
Return Value

The length (in bytes) of the data or a negative function result that indicates the error. If the function returns noTypeErr, then the data in the scrap isnt available in the scrap format type requested by your application. 
Discussion

Your application can use this function multiple times to read different formats of the same data from the scrap. If more than one format of the same scrap format type exists in the scrap, the function returns the first occurrence of that format type that it finds. For example, if data of type 'TEXT', 'PICT', and 'TEXT' exist on the scrap, and your application requests the data in the scrap with scrap format type 'TEXT', the function returns the first data of type 'TEXT' that it finds.

If your application supports more than one scrap format type, your application should attempt to read its preferred scrap format type first. If your application doesnt prefer one scrap format type over any other type, it should try reading each of the scrap format types that it supports and use the type that returns the lowest offset. The scrap format type with the lowest offset indicates that this format type was written before any of the others and therefore was preferred by the application that wrote it. 

If you request a scrap format type that isnt in the scrap and the Translation Manager is available, the Scrap Manager uses the Translation Manager to convert the data of a scrap format type that does exist in the scrap into the scrap format type requested by your application. For example, if the SurfWriter application requests data from the scrap in the 'SURF' scrap format type, and the data in the scrap is available in the format types 'TEXT', 'PICT', and 'SDBS' (SurfDBs private scrap format type), the Scrap Manager uses the Translation Manager to convert any one of the scrap format types 'TEXT', 'PICT', or 'SDBS' into the 'SURF' scrap format type. The Translation Manager looks for a translator that can perform one of these translations. If such a translator is available (for example, a translator that can translate the 'SDBS' scrap format type into the 'SURF' scrap format type), the Translation Manager uses the translator to translate the data in the scrap into the requested scrap format type. If the translation is successful, the Scrap Manager returns to your application the data from the scrap in the requested scrap format type.

The scrap format type is a four-character sequence that defines the type of data.typedef FourCharCode ResType;


The standard scrap format types are
'TEXT': a series of ASCII characters 
'PICT': a QuickDraw picture, which is a saved sequence of QuickDraw commands that can be displayed using the DrawPicture function 

Optional scrap format types include
'styl': a series of bytes that have the same format as a TextEdit 'styl' resource and that describe styled text data 
'snd ': a series of bytes that have the same format as an 'snd ' resource and that define a sound 
'movv': a series of bytes that have the same format as an 'movv' resource and that define a movie 

Your application should support the 'TEXT' and 'PICT' scrap format types and should optionally support any other scrap format types (such as 'snd ') that are appropriate to your application.

In general, when your application writes data to the scrap, the Scrap Manager appends the data to the scrap in the following format: the first 4 bytes are the scrap type format; the next 4 bytes are the length of the following data in bytes; and the remaining n bytes (where n is an even number) are the data.

If your application uses TextEdit to handle text in its documents, use TextEdit functions to implement the paste operation and to copy data from the scrap to the TextEdit scrap. If your application uses the Dialog Manager to handle editable text items in your applications dialog boxes and a dialog box is the frontmost window, use the Dialog Manager function DialogPaste to copy data from the scrap to the current editable text item. 
Special Considerations

This function may move or purge memory blocks in the application heap. Your application should not call this function at interrupt time.
Availability
Not available in CarbonLib. Not available in Mac OS X.
Carbon Porting Notes

You should instead use the functions GetScrapFlavorSize and GetScrapFlavorData.
Declared In
Scrap.h
MacTypes.h*/
typedef FourCharCode ResType;

/*NumVersion ϰ�?ϡMacTypes.h (Universal Interfaces 3.1 �êƪު) �Ϊ誦���ު
struct NumVersion {
               /* 'vers' ꫽?��� */
    //UInt8      majorRev;       /* ���?���� - BCD */
    //UInt8      minorAndBugRev; /* ���?� 2�3 �� - BCD
                                 // ЫȪ���*/
    //UInt8      stage;          /* ӫͭ?�
                                  //dev, alpha, beta, final */
  //  UInt8      nonRelRev;      /* ����?��*/
//};
 //typedef struct NumVersion      NumVersion;
/*MacTypes.h*/

struct NumVersion {
               /* 'vers' ꫽?��� */
    UInt8      majorRev;       /* ���?���� - BCD */
    UInt8      minorAndBugRev; /* ���?� 2�3 �� - BCD
                                  //ЫȪ���*/
    UInt8      stage;          /* ӫͭ?�
                                  //dev, alpha, beta, final */
    UInt8      nonRelRev;      /* ����?��*/
};
typedef struct NumVersion      NumVersion;


 /*        Point

Defines the position of a point.

struct Point {
   short    v;
   short    h;
};
Fields
v
Discussion

The vertical coordinate of the point.
h
Discussion

The horizontal coordinate of the point.
Programming Info
C interface file: MacTypes.h*/
struct Point {
   short    v;
   short    h;
};
typedef struct Point Point;

/*StringPtr

Abst_StringPtr

typedef unsigned char * StringPtr;
Availability
Available in Mac OS X v10.0 and later.
MacTypes.h*/
typedef unsigned char * StringPtr;


/*OSStatus

Abst_OSStatus

typedef SInt32 OSStatus;
Availability
Available in Mac OS X v10.0 and later.
MacTypes.h*/
typedef SInt32 OSStatus;



/*Size

Abst_Size

typedef long Size;
Availability
Available in Mac OS X v10.0 and later
.MacTypes.h*/
typedef long Size;

/*ByteCount

Abst_ByteCount

typedef UInt32 ByteCount;
Availability
Available in Mac OS X v10.0 and later.
MacTypes.h*/
typedef UInt32 ByteCount;

/*ItemCount

Abst_ItemCount

typedef UInt32 ItemCount;
Availability
Available in Mac OS X v10.0 and later
.MacTypes.h*/
typedef UInt32 ItemCount;

/*ScriptCode

Abst_ScriptCode

typedef SInt16 ScriptCode;
Availability
Available in Mac OS X v10.0 and later.
MacTypes.h*/
typedef SInt16 ScriptCode;

typedef double		   Float64;

/*Rect

Defines the size and location of a QuickDraw rectangle.

struct Rect {
   short    top;
   short    left;
   short    bottom;
   short    right;
};
Fields
top
Discussion

The vertical coordinate of the upper-left point of the rectangle.
left
Discussion

The horizontal coordinate of the upper-left point of the rectangle.
bottom
Discussion

The vertical coordinate of the lower-right point of the rectangle.
right
Discussion

The horizontal coordinate of the lower-right point of the rectangle.
Programming Info
C interface file: Quickdraw.h
MacTypes.h*/
struct Rect {
   short    top;
   short    left;
   short    bottom;
   short    right;
};
typedef struct Rect Rect;

#ifdef __cplusplus
}
#endif

#endif
