#ifndef GESTALT_H
#define GESTALT_H



#ifndef MACTYPES_H
#include <CarbonCore/MacTypes.h>
#endif

#ifndef MIXEDMODE_H
#include <CarbonCore/MixedMode.h>
#endif

#ifndef FILES_H
#include <CarbonCore/Files.h>
#endif



#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*QuickTime Version Selectors

Specify version information for QuickTime.

enum {
   gestaltQuickTimeVersion = 'qtim',
   gestaltQuickTime = 'qtim'
};
Constants
gestaltQuickTimeVersion

The selector you pass to the Gestalt function to determine the QuickTime version.

Available in Mac OS X v10.0 and later.
gestaltQuickTime

Available in Mac OS X v10.0 and later.*/
enum {
   gestaltQuickTimeVersion = 'qtim',
   gestaltQuickTime = 'qtim'
};



/*System Version Selectors


Specifies version information for the operating system.

enum {
   gestaltSystemVersion = 'sysv'
   gestaltSystemVersionMajor     = 'sys1',
   gestaltSystemVersionMinor     = 'sys2',
   gestaltSystemVersionBugFix    = 'sys3'
};
Constants
gestaltSystemVersion

The selector you pass to the Gestalt function to determine the version number of the currently active System file. For systems prior to Mac OS X, the version is represented as four hexadecimal digits in the low-order word of the return value. For example, if your application is running in version 7.0.1, then Gestalt returns the value 0x0701. Ignore the high-order word of the returned value. For Mac OS X versions, the representation is as shown in Table 1.
Table 1  The representation of Mac OS X versions by the Gestalt Manager
Mac OS X Version	
Representation 

10.0	
0x1000

10.1	
0x1010

10.2	
0x1020

10.3	
0x1030

10.4	
0x1040


If the values of the minor or bug fix revision are larger than 9, then gestaltSystemVersion will substitute the value 9 for them. For example, Mac OS X 10.3.15 will be returned as 0x1039, and Mac OS X 10.10.5 will return 0x1095.

A better way to obtain version information in Mac OS X is to read the system version information from the following file:

/System/Library/CoreServices/SystemVersion.plist

Never infer the existence of certain hardware or software features from the responses that Gestalt returns when you pass it this selector.

Available in Mac OS X v10.0 and later.
gestaltSystemVersionMajor

The major system version number. For example, in 10.4.7, this would be the decimal value 10. 

Available in Mac OS X v10.4 and later.
gestaltSystemVersionMinor

The minor system version number. For example, in 10.4.7, this would be the decimal value 4. 

Available in Mac OS X v10.4 and later.
gestaltSystemVersionBugFix

The bug fix version number. For example, in 10.4.7, this would be the decimal value 7. 

Available in Mac OS X v10.4 and later.*/
enum {
   gestaltSystemVersion = 'sysv',
   gestaltSystemVersionMajor     = 'sys1',
   gestaltSystemVersionMinor     = 'sys2',
   gestaltSystemVersionBugFix    = 'sys3'
};

/*Gestalt

Obtains information about the operating environment.

OSErr Gestalt (
   OSType selector,
   long * response
);
Parameters
selector

The selector code for the information you need. You can provide any of the four-character sequences defined in Gestalt Manager Constants.
response

On input, Gestalt interprets this parameter as an address at which it is to place the result returned by the selector function. Gestalt ignores any information already at this address. 

On return, a pointer to the requested information whose format depends on the selector code specified in the selector parameter. Note that the Gestalt function returns the response from all selectors in a long word, which occupies 4 bytes. When not all 4 bytes are needed, the significant information appears in the low-order byte or bytes.
Return Value

A result code. See Gestalt Manager Result Codes.
Discussion

The Apple-defined selector codes fall into two categories: environmental selectors, which supply specific environmental information you can use to control the behavior of your application, and informational selectors, which cant supply information you can use to determine what hardware or software features are available. You can use one of the selector codes defined by Apple or a selector code defined by a third-party product.

Selectors with the suffix Attr return a 32-bit response value in which the individual bits represent specific attributes. The constants listed for these response values represent bit numbers. 
Special Considerations

When passed one of the Apple-defined selector codes, the Gestalt function does not move or purge memory and therefore may be called even at interrupt time. However, selector functions associated with non-Apple selector codes might move or purge memory, and third-party software can alter the Apple-defined selector functions. Therefore, it is safest always to assume that Gestalt could move or purge memory.
Version Notes

The ROMVersion and machineType selectors are not supported in Carbon.

In general, the Gestalt function returns a different result when called from a Carbon application running in Mac OS X than it returns when called from a Classic application in Mac OS X, because these are different environments. For example, Carbon does not use a ROM, so calling Gestalt from a Carbon application on a beige G3 Macintosh computer and passing the ROMVersion selector returns a different result than Gestalt returns for a Classic application on the same computer.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Gestalt.h*/
OSErr Gestalt (
   OSType selector,
   long * response
);


#ifdef __cplusplus
}
#endif

#endif