#ifndef ENDIAN_H
#define ENDIAN_H

#ifndef CONDITIONALMACROS_H
#include <CarbonCore/ConditionalMacros.h>
#endif

#ifndef MACTYPES_H
#include <CarbonCore/MacTypes.h>
#endif



#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*wide

Stores a signed 64-bit value as a signed 32-bit integer and an unsigned 32-bit integer.

struct wide {        // big-endian version
   SInt32    hi;
   UInt32    lo;
};
struct wide {        // little-endian version
   UInt32    lo;
   SInt32    hi;
};
Fields
hi
Discussion

The signed high-order 32-bit integer.
lo
Discussion

The unsigned low-order 32-bit integer.
Programming Info
C interface file: Endian.h*/
//struct wide {        // big-endian version
//   SInt32    hi;
//   UInt32    lo;
//};
struct wide {        // little-endian version
   UInt32    lo;
   SInt32    hi;
};
typedef  struct wide wide;

//FUNC
/*EndianU32_NtoB

Converts an unsigned 32-bit value in the computer’s native format to the equivalent big-endian value.

UInt32 EndianU32_NtoB (
   UInt32    value
);
Parameters
value

An unsigned 32-bit value in the computer’s native format.
Return Value

The equivalent big-endian value.
Availability
Available in Mac OS X v10.0 and later.
Available in QuickTime 4 and later for Windows.*/

UInt32 EndianU32_NtoB (
   UInt32    value
);


#ifdef __cplusplus
}
#endif

#endif
