//inclu

#ifndef AEOBJECTS_H
#define AEOBJECTS_H

#ifndef CORESERVICES_H
#include <CoreServices/CoreServices.h>
#endif

#ifndef APPLEEVENTS_H
#include <AE/AppleEvents.h>
#endif

#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Key Form and Descriptor Type Object Specifier Constants

Specify possible values for the keyAEKeyForm field of an object specifier, as well as descriptor types used in resolving object specifiers.

enum {
   formAbsolutePosition = 'indx',
   formRelativePosition = 'rele',
   formTest = 'test',
   formRange = 'rang',
   formPropertyID = 'prop',
   formName = 'name',
   typeObjectSpecifier = 'obj ',
   typeObjectBeingExamined = 'exmn',
   typeCurrentContainer = 'ccnt',
   typeToken = 'toke',
   typeRelativeDescriptor = 'rel ',
   typeAbsoluteOrdinal = 'abso',
   typeIndexDescriptor = 'inde',
   typeRangeDescriptor = 'rang',
   typeLogicalDescriptor = 'logi',
   typeCompDescriptor = 'cmpd',
   typeOSLTokenList = 'ostl'
};
Constants
formAbsolutePosition

An integer or other constant indicating the position of one or more elements in relation to the beginning or end of their container. The key data consists of an integer that specifies either an offset or an ordinal position.

For descriptor type typeAbsoluteOrdinal, the data consists of one of the constants kAEFirst, kAEMiddle, kAELast, kAEAny, or kAEAll, which are described in AEDisposeToken.

For other descriptor types, the data can be coerced to either a positive integer, indicating the offset of the requested element from the beginning of the container, or a negative integer, indicating its offset from the end of the container.

Available in Mac OS X v10.0 and later.
formRelativePosition

Specifies an element position either immediately before or immediately after a container, not inside it. The key data is specified by a descriptor of type typeEnumerated whose data consists of one of the constants kAENext and kAEPrevious, which are described in AEDisposeToken. 

Available in Mac OS X v10.0 and later.
formTest

Specifies a test. The key data is specified by either a comparison descriptor or a logical descriptor.

The Apple Event Manager internally translates object specifiers of key form formTest into object specifiers of key form formWhose to optimize resolution of object specifiers. This involves collapsing the key form and key data from two object specifiers in a container hierarchy into one object specifier with the key form formWhose.

See also AEDisposeToken, “Constants for Object Specifiers, Positions, and Logical and Comparison Operations”, CreateCompDescriptor, and CreateLogicalDescriptor.

Available in Mac OS X v10.0 and later.
formRange

Specifies a group of elements between two other elements. The key data is specified by a range descriptor, which is a coerced Apple event record of type typeRangeDescriptor that identifies two Apple event objects marking the beginning and end of a range of elements.

The data for a range descriptor consists of two keyword-specified descriptors with the keywords keyAERangeStart and keyAERangeStop.

Available in Mac OS X v10.0 and later.
formPropertyID

Specifies the property ID for an element’s property.

Available in Mac OS X v10.0 and later.
formName

Specifies the Apple event object by name.

Available in Mac OS X v10.0 and later.
typeObjectSpecifier

Specifies a descriptor used with the keyAEContainer keyword in a keyword-specified descriptor. The key data for the descriptor is an object specifier.

Available in Mac OS X v10.0 and later.
typeObjectBeingExamined

Specifies a descriptor that acts as a placeholder for each of the successive elements in a container when the Apple Event Manager tests those elements one at a time. The descriptor has a null data storage pointer. This descriptor type is used only with formTest.

Available in Mac OS X v10.0 and later.
typeCurrentContainer

Specifies a container for an element that demarcates one boundary in a range. The descriptor has a null data storage pointer. This descriptor type is used only with formRange.

Available in Mac OS X v10.0 and later.
typeToken

Specifies a descriptor whose data storage pointer refers to a structure of type AEDisposeToken.

Available in Mac OS X v10.0 and later.
typeRelativeDescriptor

Specifies a descriptor whose data consists of one of the constants kAENext or kAEPrevious, which are described in AEDisposeToken. Used with formRelativePosition.

Available in Mac OS X v10.0 and later.
typeAbsoluteOrdinal

Specifies a descriptor whose data consists of one of the constants kAEFirst, kAEMiddle, kAELast, kAEAny, or kAEAll, which are described in AEDisposeToken. Used with formAbsolutePosition.

Available in Mac OS X v10.0 and later.
typeIndexDescriptor

Specifies a descriptor whose data indicates an indexed position within a range of values.

Available in Mac OS X v10.0 and later.
typeRangeDescriptor

Specifies a range descriptor that identifies two Apple event objects marking the beginning and end of a range of elements. The data for a range descriptor consists of two keyword-specified descriptors with the keywords keyAERangeStart and keyAERangeStop, respectively, which specify the first Apple event object in the desired range and the last Apple event object in the desired range.

Available in Mac OS X v10.0 and later.
typeLogicalDescriptor

Specifies a logical descriptor. Data is one of the constants described in AEDisposeToken.

Available in Mac OS X v10.0 and later.
typeCompDescriptor

Specifies a comparison descriptor. Data is one of the constants described in AEDisposeToken.

Available in Mac OS X v10.0 and later.
typeOSLTokenList

Specifies a descriptor whose data consists of a list of tokens. (Token is defined in AEDisposeToken.)

Available in Mac OS X v10.0 and later.
Discussion

The constants in this enum that begin with “form” specify the key form for an object specifier. The key form indicates how key data should be interpreted. Key form is one of the keyword-specified descriptors described in “Constants for Object Specifiers, Positions, and Logical and Comparison Operations”.

The constants in this enum that begin with “type” specify descriptor types used in resolving object specifiers. An object specifier is a coerced Apple event record of descriptor type typeObjectSpecifier whose data consists of the four keyword-specified descriptors described in “Constants for Object Specifiers, Positions, and Logical and Comparison Operations”. One of those four keyword-specified descriptors has the type keyAEKeyData.This descriptor can contain data or nested descriptors specified by any of the descriptor type constants defined here (or by types defined by your application).*/
enum {
   formAbsolutePosition = 'indx',
   formRelativePosition = 'rele',
   formTest = 'test',
   formRange = 'rang',
   formPropertyID = 'prop',
   formName = 'name',
   typeObjectSpecifier = 'obj ',
   typeObjectBeingExamined = 'exmn',
   typeCurrentContainer = 'ccnt',
   typeToken = 'toke',
   typeRelativeDescriptor = 'rel ',
   typeAbsoluteOrdinal = 'abso',
   typeIndexDescriptor = 'inde',
   typeRangeDescriptor = 'rang',
   typeLogicalDescriptor = 'logi',
   typeCompDescriptor = 'cmpd',
   typeOSLTokenList = 'ostl'
};


/*Constants for Object Specifiers, Positions, and Logical and Comparison Operations

Specify the types of the four keyword-specified descriptors that make up the data in an object specifier, as well as constants for position, logical operations, and comparison operations.

enum {
   kAEAND = 'AND ',
   kAEOR = 'OR  ',
   kAENOT = 'NOT ',
   kAEFirst = 'firs',
   kAELast = 'last',
   kAEMiddle = 'midd',
   kAEAny = 'any ',
   kAEAll = 'all ',
   kAENext = 'next',
   kAEPrevious = 'prev',
   keyAECompOperator = 'relo',
   keyAELogicalTerms = 'term',
   keyAELogicalOperator = 'logc',
   keyAEObject1 = 'obj1',
   keyAEObject2 = 'obj2',
   keyAEDesiredClass = 'want',
   keyAEContainer = 'from',
   keyAEKeyForm = 'form',
   keyAEKeyData = 'seld'
};
Constants
kAEAND

Specifies a logical AND operation.

Available in Mac OS X v10.0 and later.
kAEOR

Specifies a logical OR operation.

Available in Mac OS X v10.0 and later.
kAENOT

Specifies a logical NOT operation.

Available in Mac OS X v10.0 and later.
kAEFirst

The first element in the specified container.

Available in Mac OS X v10.0 and later.
kAELast

Specifies the last element in the container.

Available in Mac OS X v10.0 and later.
kAEMiddle

Specifies the middle element in the container. If an object specifier specifies kAEMiddle and the number of elements in the container is even, the Apple Event Manager rounds down. For example, in a range of four words the second word is the “middle” word.

Available in Mac OS X v10.0 and later.
kAEAny

Specifies a single element chosen at random from the container.

Available in Mac OS X v10.0 and later.
kAEAll

Specifies all the elements in the container.

Available in Mac OS X v10.0 and later.
kAENext

Specifies the Apple event object after the container.

Available in Mac OS X v10.0 and later.
kAEPrevious

Specifies the Apple event object before the container.

Available in Mac OS X v10.0 and later.
keyAECompOperator

Specifies a descriptor of typeType, whose data consists of one of the constant values described in “Key Form and Descriptor Type Object Specifier Constants”.

Available in Mac OS X v10.0 and later.
keyAELogicalTerms

Specifies a descriptor of type typeAEList containing one or more comparison or logical descriptors.

Available in Mac OS X v10.0 and later.
keyAELogicalOperator

Specifies a descriptor of type typeEnumerated whose data is one of the logical operators (such as kAEAND) defined in “Key Form and Descriptor Type Object Specifier Constants”.

Available in Mac OS X v10.0 and later.
keyAEObject1

Identifies a descriptor for the element that is currently being compared to the object or data specified by the descriptor for the keyword keyAEObject2. Either object can be described by a descriptor of type typeObjectSpecifier or typeObjectBeingExamined.

A descriptor of typeObjectBeingExamined acts as a placeholder for each of the successive elements in a container when the Apple Event Manager tests those elements one at a time.

Available in Mac OS X v10.0 and later.
keyAEObject2

Identifies a descriptor for the element that is currently being compared to the object or data specified by the descriptor for the keyword keyAEObject1.

The keyword keyAEObject2 can also be used with a descriptor of any other descriptor type whose data is to be compared to each element in a container.

Available in Mac OS X v10.0 and later.
keyAEDesiredClass

A four-character code that identifies the object class of the specified object or objects.

Constants for object class IDs are described in “Key Form and Descriptor Type Object Specifier Constants”.

Available in Mac OS X v10.0 and later.
keyAEContainer

Specifies the container for the requested object or objects. The data is an object specifier (or in some cases a null descriptor).

Available in Mac OS X v10.0 and later.
keyAEKeyForm

A four-character code that identifies the key form for the specified object or objects.

The constants for specifying the key form are described in “Key Form and Descriptor Type Object Specifier Constants”.

Available in Mac OS X v10.0 and later.
keyAEKeyData

Data or nested descriptors that specify a property, name, position, range, or test, depending on the key form.

The descriptor types used in object specifiers are described in “Key Form and Descriptor Type Object Specifier Constants”.

Available in Mac OS X v10.0 and later.
Discussion

When you call the CreateLogicalDescriptor function to create a logical descriptor, you pass one of the logical operators kAEAND, kAEOR, or kAENOT in the theLogicOperator parameter. The CreateLogicalDescriptor function creates a logical descriptor that specifies a logical operation to perform on one or more operands.

The constants kAEFirst, kAELast, kAEMiddle, kAEAny, and kAEAll provide the key data for a keyword-specified descriptor of key form formAbsolutePosition and descriptor type typeAbsoluteOrdinal.

The constants kAENext, and kAEPrevious provide the key data for a keyword-specified descriptor of key form formRelativePosition.

Key form constants and descriptor type constants for object specifiers are defined in “Key Form and Descriptor Type Object Specifier Constants”.

The constants keyAELogicalTerms and keyAELogicalOperator define the keyword descriptors for a logical descriptor. A logical descriptor is a coerced Apple event record of type typeLogicalDescriptor that specifies a logical expression—that is, an expression that the Apple Event Manager evaluates to either TRUE or FALSE. You can create a logical descriptor with the CreateLogicalDescriptor function.

The data for a logical descriptor consists of two keyword-specified descriptors: the first with descriptor type keyAELogicalOperator, descriptor type typeEnumerated, and one of the logical operators defined in “Constants for Object Specifiers, Positions, and Logical and Comparison Operations” for its data; and the second with descriptor type keyAELogicalTerms, descriptor type typeEnumerated, and one or more comparison or logical descriptors for its data. Comparison constants are described in “Comparison Operator Constants”.

The logical expression is constructed from a logical operator (one of the Boolean operators AND, OR, or NOT) and a list of logical terms to which the operator is applied (where NOT can only be used where the list of terms is a single-item list). Each logical term in the list can be either another logical descriptor or a comparison descriptor (described in “Constants for Object Specifiers, Positions, and Logical and Comparison Operations”). 

The Apple Event Manager short-circuits its evaluation of a logical expression as soon as one part of the expression fails a test. For example, if while testing a logical expression such as A AND B AND C the Apple Event Manager discovers that A AND B is not true, it will evaluate the expression to FALSE without testing C.

The constants keyAECompOperator, keyAEObject1, and keyAEObject2 define the keyword descriptors for a comparison descriptor. A comparison descriptor is a coerced Apple event record of type typeCompDescriptor that specifies an Apple event object and either another Apple event object or data for the Apple Event Manager to compare to the first object. You can create a logical descriptor with the CreateCompDescriptor function.

The Apple Event Manager can also use the information in a comparison descriptor to compare elements in a container, one at a time, either to an Apple event object or to data. The data for a comparison descriptor consists of three keyword-specified descriptors:
A descriptor with keyword keyAECompOperator, descriptor type typeType, and one of the logical operators defined in “Comparison Operator Constants” for its data. 
A descriptor with keyword keyAEObject1 and either
descriptor type typeObjectSpecifier and object specifier data to compare, or 
descriptor type typeObjectBeingExamined and a data storage pointer of NULL. 
A descriptor with keyword keyAEObject2 and either
descriptor type typeObjectSpecifier and object specifier data to compare, or 
descriptor type typeObjectBeingExamined and a data storage pointer of NULL, or 
any other descriptor type and the data to be compared for that descriptor type. 

You don’t have to support all the available comparison operators for all Apple event objects for example, the begins with operator probably doesn’t make sense for objects of type cRectangle. It is up to you to decide which comparison operators are appropriate for your application to support, and how to interpret them. If necessary, you can define your own custom comparison operators. If you think you need to do this, check the Apple Events and Scripting header files to see if existing definitions of comparison operators can be adapted to the needs of your application.

An object specifier is a coerced Apple event record of descriptor type typeObjectSpecifier whose data contains consists of four keyword-specified descriptors. The constants keyAEDesiredClass, keyAEContainer, keyAEKeyForm, and keyAEKeyData specify the keywords for the four descriptor types that together identify the specified object or objects.*/
enum {
   kAEAND = 'AND ',
   kAEOR = 'OR  ',
   kAENOT = 'NOT ',
   kAEFirst = 'firs',
   kAELast = 'last',
   kAEMiddle = 'midd',
   kAEAny = 'any ',
   kAEAll = 'all ',
   kAENext = 'next',
   kAEPrevious = 'prev',
   keyAECompOperator = 'relo',
   keyAELogicalTerms = 'term',
   keyAELogicalOperator = 'logc',
   keyAEObject1 = 'obj1',
   keyAEObject2 = 'obj2',
   keyAEDesiredClass = 'want',
   keyAEContainer = 'from',
   keyAEKeyForm = 'form',
   keyAEKeyData = 'seld'
};

#ifdef __cplusplus
}
#endif

#endif