#ifndef QUICKDRAW_H
#include <QD/QD.h>
#endif


/*DisposeGWorld

Disposes of all the memory allocated for an offscreen graphics world. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void DisposeGWorld (
   GWorldPtr offscreenGWorld
);
Parameters
offscreenGWorld

A pointer to an offscreen graphics world. In this parameter, pass the pointer returned to your application by the NewGWorld function when you created the offscreen graphics world. 
Discussion

The DisposeGWorld function disposes of all the memory allocated for the specified offscreen graphics world, including the pixel map, color table, pixel image, and GDevice structure (if one was created).

Call DisposeGWorld only when your application no longer needs the pixel image associated with this offscreen graphics world. If this offscreen graphics world was the current device, the current device is reset to the device stored in the global variable MainDevice. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
QDOffscreen.h*/
void DisposeGWorld (GWorldPtr offscreenGWorld){
//TODO
};


/*SetRect

Assigns coordinates to a rectangle. 

void SetRect (
   Rect * r,
   short left,
   short top,
   short right,
   short bottom
);
Parameters
r

A pointer to the rectangle to set.
left

The horizontal coordinate of the new upper-left corner of the rectangle.
top

The vertical coordinate of the new upper-left corner of the rectangle.
right

The horizontal coordinate of the new lower-right corner of the rectangle.
bottom

The vertical coordinate of the new lower-right corner of the rectangle.
Discussion

The SetRect function assigns the coordinates you specify in the left, top, right, and bottom parameters to the rectangle that you specify in the r parameter. This function is provided to help you shorten your program text. If you want a more readable text, at the expense of source text length, you can instead assign integers (or points) directly into the fields of a Rect structure.

You can use a rectangle to specify locations and sizes for various graphics operations.

If the points or rectangles supplied to this function are defined in a graphics port other than your current graphics port, you must convert them to the local coordinate system of your current graphics port. You can accomplish this by using the SetPort function to change to the graphics port containing the points or rectangles, using the LocalGlobal function to convert their locations to global coordinates, using SetPort to return to your starting graphics port, and then using the GlobalToLocal function to convert the locations of points or rectangles to the local coordinates of your current graphics port. 
Declared In
Quickdraw.h*/
void SetRect (
   Rect * r,
   short left,
   short top,
   short right,
   short bottom){
//TODO
};


/*LockPixels

Prevents the base address for an offscreen pixel image from being moved while you draw into or copy from its pixel map. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

Boolean LockPixels (
   PixMapHandle pm
);
Parameters
pm

A handle to an offscreen pixel map. To get a handle to an offscreen pixel map, use the GetGWorldPixMap function . 
Return Value

If the base address for an offscreen pixel image hasn’t been purged by the Memory Manager or is not purgeable, LockPixels returns TRUE as its function result, and your application can draw into or copy from the offscreen pixel map. However, if the base address for an offscreen pixel image has been purged, LockPixels returns FALSE to indicate that you can perform no drawing to or copying from the pixel map. At that point, your application should either call the UpdateGWorld function to reallocate the offscreen pixel image and then reconstruct it, or draw directly in a window instead of preparing the image in an offscreen graphics world. 
Discussion

You must call LockPixels before drawing to or copying from an offscreen graphics world. 

The baseAddr field of the PixMap structure for an offscreen graphics world contains a handle instead of a pointer (which is what the baseAddr field for an onscreen pixel map contains). The LockPixels function dereferences the PixMap handle into a pointer. When you use the UnlockPixels function the handle is recovered.

As soon as you are finished drawing into and copying from the offscreen pixel image, call the UnlockPixels function. 
Special Considerations

The LockPixels function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
QDOffscreen.h*/
Boolean LockPixels (
   PixMapHandle pm){
//TODO
};


/*GetGWorldPixMap

Obtains the pixel map created for an offscreen graphics world. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

PixMapHandle GetGWorldPixMap (
   GWorldPtr offscreenGWorld
);
Parameters
offscreenGWorld

A pointer to an offscreen graphics world. Pass the pointer returned to your application by the NewGWorld function when you created the offscreen graphics world. 
Return Value

A handle to the pixel map created for an offscreen graphics world. Your application can, in turn, pass the handle returned by GetGWorldPixMap as a parameter to other QuickDraw functions that accept a handle to a pixel map.

On a system running only basic QuickDraw, the GetGWorldPixMap function returns the handle to a 1-bit pixel map that your application can supply as a parameter to the other functions related to offscreen graphics worlds. However, your application should not supply this handle to color QuickDraw functions.

Special Considerations

To ensure compatibility on systems running basic QuickDraw instead of Color QuickDraw, use GetGWorldPixMap whenever you need to gain access to the bitmap created for a graphics world—that is, do not dereference the GWorldPtr structure for that graphics world.
Version Notes

The GetGWorldPixMap function is not available in systems preceding System 7. You can make sure that the GetGWorldPixMap function is available by using the Gestalt function with the gestaltSystemVersion selector. Test the low-order word in the response parameter; if the value is $0700 or greater, then GetGWorldPixMap is available.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
QDOffscreen.h*/
PixMapHandle GetGWorldPixMap (
   GWorldPtr offscreenGWorld){
//TODO
};


/*GetGWorldDevice

Obtains a handle to the GDevice structure associated with an offscreen graphics world. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

GDHandle GetGWorldDevice (
   GWorldPtr offscreenGWorld
);
Parameters
offscreenGWorld

A pointer to an offscreen graphics world. The pointer returned to your application by the NewGWorld function. 
Return Value

A handle to the GDevice structure associated with the offscreen graphics world specified by the offscreenGWorld parameter. 


If you created the offscreen world by specifying the noNewDevice flag, the GDevice structure is for one of the screen devices or is the GDevice structure that you specified to NewGWorld or UpdateGWorld.

If you point to a GrafPort or CGrafPort structure in the offscreenGWorld parameter, GetGWorldDevice returns the current device.

Special Considerations

The GetGWorldDevice function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
QDOffscreen.h*/
GDHandle GetGWorldDevice (
   GWorldPtr offscreenGWorld){
//TODO
};


/*GetGWorld

Saves the current graphics port (basic, color, or offscreen) and the current GDevice structure. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void GetGWorld (
   CGrafPtr * port,
   GDHandle * gdh
);
Parameters
port

On return, a pointer to the current graphics port in the port parameter. This parameter can return values of type GrafPtr, CGrafPtr, or GWorldPtr, depending on whether the current graphics port is a basic graphics port, color graphics port, or offscreen graphics world. 
gdh

On return, a pointer to a handle to the GDevice structure for the current device. 
Discussion

After using GetGWorld to save a graphics port and a GDevice structure, use the SetGWorld function to restore them. 
Special Considerations

The GetGWorld function may move or purge memory blocks in the application heap. Your application should not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
QDOffscreen.h*/
void GetGWorld (
   CGrafPtr * port,
   GDHandle * gdh){
//TODO
};


/*SetGWorld

Changes the current graphics port (basic, color, or offscreen). (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void SetGWorld (
   CGrafPtr port,
   GDHandle gdh
);
Parameters
port

A pointer to an offscreen graphics world, color graphics port, or basic graphics port. Specify values of type GrafPtr, CGrafPtr, or GWorldPtr, depending on whether you want to set the current graphics port to be a basic graphics port, color graphics port, or offscreen graphics world. Any drawing your application performs then occurs in this graphics port. 
gdh

A handle to a GDevice structure. If you pass a pointer to an offscreen graphics world in the port parameter, set this parameter to NULL, because SetGWorld ignores this parameter and sets the current device to the device attached to the offscreen graphics world. 
Discussion

The SetGWorld function sets the current graphics port to the one specified by the port parameter and—unless you set the current graphics port to be an offscreen graphics world—sets the current device to that specified by the gdh parameter. 
Special Considerations

The SetGWorld function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
QDOffscreen.h*/

void SetGWorld (
   CGrafPtr port,
   GDHandle gdh){
//TODO
};


/*GetPortBounds

(Deprecated. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

Rect * GetPortBounds (
   CGrafPtr port,
   Rect * rect
);
Carbon Porting Notes

Use this new accessor function in place of direct access to structs.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Quickdraw.h*/

Rect * GetPortBounds (
   CGrafPtr port,
   Rect * rect){
//TODO
};

/*EraseRect

Erases a rectangle. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void EraseRect (
   const Rect * r
);
Parameters
r

The rectangle to erase.
Discussion

Using the patCopy pattern mode, the EraseRect function draws the interior of the rectangle that you specify in the r parameter with the background pattern for the current graphics port. This effectively erases the rectangle, making the shape blend into the background pattern of the graphics port. For example, use EraseRect to erase the port rectangle for a window before redrawing into the window.

This function leaves the location of the graphics pen unchanged. 
Special Considerations

The EraseRect function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void EraseRect (
   const Rect * r){
//TODO
};

/*CopyBits

Copies a portion of a bitmap or a pixel map from one graphics port or offscreen graphics world into another graphics port. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void CopyBits (
   const BitMap * srcBits,
   const BitMap * dstBits,
   const Rect * srcRect,
   const Rect * dstRect,
   short mode,
   RgnHandle maskRgn
);
Parameters
srcBits

The source BitMap structure. 
dstBits

The destination BitMap structure.
srcRect

The source rectangle.
dstRect

The destination rectangle.
mode

One of the eight source modes in which the copy is to be performed. See Source, Pattern, and Arithmetic Transfer Mode Constants. The CopyBits function always dithers images when shrinking them between pixel maps on direct devices. 

When transferring pixels from a source pixel map to a destination pixel map, color QuickDraw interprets the source mode constants differently than basic QuickDraw does.

When you use CopyBits on a computer running color QuickDraw, you can also specify one of the transfer modes in the mode parameter.
maskRgn

A region to use as a clipping mask. You can pass a region handle to specify a mask region the resulting image is always clipped to this mask region and to the boundary rectangle of the destination bitmap. If the destination bitmap is the current graphics port’s bitmap, it is also clipped to the intersection of the graphics port’s clipping region and visible region. If you do not want to clip to a masking region, just pass NULL for this parameter. 
Discussion

The CopyBits function transfers any portion of a bitmap between two basic graphics ports, or any portion of a pixel map between two color graphics ports. Use CopyBits to move offscreen graphic images into an onscreen window, to blend colors for the image in a pixel map, and to shrink and expand images.

Specify a source bitmap in the srcBits parameter and a destination bitmap in the dstBits parameter. When copying images between color graphics ports, you must coerce each CGrafPort structure to a GrafPort structure, dereference the portBits fields of each, and then pass these “bitmaps” in the srcBits and dstBits parameters. If your application copies a pixel image from a color graphics port called MyColorPort, for example, you could specify (* GrafPtr(MyColorPort)).portBits in the srcBits parameter. In a CGrafPort structure, the high 2 bits of the portVersion field are set. This field, which shares the same position in a CGrafPort structure as the portBits.rowBytes field in a GrafPort structure, indicates to CopyBits that you have passed it a handle to a pixel map rather than a bitmap.

Using the srcRect and dstRect parameters, you can specify identically or differently sized source and destination rectangles; for differently sized rectangles, CopyBits scales the source image to fit the destination. If the bit image is a circle in a square source rectangle, and the destination rectangle is not square, the bit image appears as an oval in the destination. When you specify rectangles in the srcRect and dstRect parameters, use the local coordinate systems of, respectively, the source and destination graphics ports.

The CopyDeepMask function combines the functions of the CopyBits and CopyMask functions. 
Special Considerations

When you use the CopyBits function to transfer an image between pixel maps, the source and destination images may be of different pixel depths, of different sizes, and they may have different color tables. However, CopyBits assumes that the destination pixel map uses the same color table as the color table for the current GDevice structure. (This is because the Color Manager requires an inverse table for translating the color table from the source pixel map to the destination pixel map.) 

The CopyBits function applies the foreground and background colors of the current graphics port to the image in the destination pixel map (or bitmap), even if the source image is a bitmap. This causes the foreground color to replace all black pixels in the destination and the background color to replace all white pixels. To avoid unwanted coloring of the image, use the RGBForeColor function to set the foreground to black and use the RGBBackColor function to set the background to white before calling CopyBits.

The source bitmap or pixel map must not occupy more memory than half the available stack space. The stack space required by CopyBits is roughly five times the value of the rowBytes field of the source pixel map: one rowBytes value for the pixel map (or bitmap), an additional rowBytes value for dithering, another rowBytes value when stretching or shrinking the source pixel map into the destination, another rowBytes value for any color map changing, and a fifth additional rowBytes value for any color aliasing. If there is insufficient memory to complete a CopyBits operation in Color QuickDraw, the QDError function returns the result code –143.

If you use CopyBits to copy between two graphics ports that overlap, you must first use the LocalToGlobal function to convert to global coordinates, and then specify the global variable screenBits for both the srcBits and dstBits parameters.

The CopyBits function may move or purge memory blocks in the application heap; do not call this function at interrupt time.

If you are reading directly from a NuBus video card with a base address of Fs00000 and there is not a card in the slot (s–1) below it, CopyBits reads addresses less than the base address of the pixel map. This causes a bus error. To work around the problem, remap the baseAddr field of the pixel map in your video card to at least 20 bytes above the NuBus boundary; an address link of Fs000020 precludes the problem.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void CopyBits (
   const BitMap * srcBits,
   const BitMap * dstBits,
   const Rect * srcRect,
   const Rect * dstRect,
   short mode,
   RgnHandle maskRgn){
//TODO
};


/*QDFlushPortBuffer

Calls the Quartz compositor to flush all new drawing in a Carbon window to the display. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void QDFlushPortBuffer (
   CGrafPtr port,
   RgnHandle region
);
Parameters
port

A window port. If the port has no back buffer, or if the port is an offscreen or printing port, this function does nothing.
region

An update region. Under normal conditions, you should pass NULL to avoid the overhead of additional region operations.
Discussion

In Mac OS X, drawing in a window port updates a back buffer associated with the window. Updates to this buffer are accumulated in a list called the dirty region. 

The back buffer is automatically flushed to the display each time through the event loop. When the event loop does not get control soon enough—for example, during an animation sequence—you can call this function to flush the port buffer to the device immediately. 

When you call this function, there are several different execution paths:
If the region parameter is NULL, the dirty region is flushed—along with any Quartz 2D drawing operations marked for update by calls to CGContextSynchronize—and the dirty region is set to empty.
If the region parameter specifies an update region, the intersection of the dirty region and the update region is flushed—along with any Quartz 2D drawing operations marked for update by calls to CGContextSynchronize—and the flushed region is subtracted from the dirty region.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void QDFlushPortBuffer (
   CGrafPtr port,
   RgnHandle region){
//TODO
};

/*UnlockPixels

Allows the Memory Manager to move the base address for the offscreen pixel map that you specify in the pm parameter. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void UnlockPixels (
   PixMapHandle pm
);
Parameters
pm

A handle to an offscreen pixel map. Pass the same handle that you passed previously to the LockPixels function. 
Discussion

To ensure the integrity of the data in a pixel image, call LockPixels before drawing into or copying from a pixel map; then, to prevent heap fragmentation, call UnlockPixels as soon as your application finishes drawing to and copying from the offscreen pixel map. 

The baseAddr field of the PixMap structure for an offscreen graphics world contains a handle instead of a pointer (which is what the baseAddr field for an onscreen pixel map contains). The LockPixels function dereferences the PixMap handle into a pointer. When you use the UnlockPixels function, the handle is recovered.

You don’t need to call UnlockPixels if LockPixels returns FALSE, because LockPixels doesn’t lock the memory for a pixel image if that memory has been purged. However, calling UnlockPixels on purged memory does no harm. 
Special Considerations

The UnlockPixels function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
QDOffscreen.h*/
void UnlockPixels (
   PixMapHandle pm){
//TODO
};

/*SetPort

Changes the current graphics port (basic or color). (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void SetPort (
   GrafPtr port
);
Parameters
port

A pointer to a GrafPort structure. Typically, you pass a pointer to a GrafPort structure that you previously saved with the GetPort function. The SetPort function sets this structure to be the current graphics port. 
Discussion

All QuickDraw drawing functions affect the bitmap of, and use the local coordinate system of, the current graphics port. Each graphics port has its own graphics pen and text characteristics, which remain unchanged when the graphics port isn’t selected as the current graphics port.

When your application runs in Color QuickDraw or uses offscreen graphics worlds, it should use the SetGWorld function instead of SetPort. The SetGWorld function restores the current graphics port for basic and color graphics ports as well as offscreen graphics worlds. 
Availability
Deprecated in Mac OS X v10.4.
Available in Mac OS X v10.0 and later.
Declared In
Quickdraw.h*/
void SetPort (
   GrafPtr port){
//TODO
};
