#ifndef HITOOLBOX_H
#include <HIToolbox/HIToolbox.h>
#endif


/*RunStandardAlert

Shows and runs a standard alert using a modal dialog loop.

OSStatus RunStandardAlert (
   DialogRef inAlert,
   ModalFilterUPP filterProc,
   DialogItemIndex * outItemHit
);
Parameters
inAlert

The alert to display. Note that this function automatically disposes of the dialog you pass in this parameter before returning. 
filterProc

An event filter function for handling events that do not apply to the alert. May be NULL. 
outItemHit

On exit, contains the item index of the button that was pressed to close the alert. 
Return Value

A result code. See “Dialog Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Dialogs.h*/
OSStatus RunStandardAlert (
   DialogRef inAlert,
   ModalFilterUPP filterProc,
   DialogItemIndex * outItemHit){
//TODO
};


/*CreateStandardAlert

Creates an alert containing standard elements and using standard formatting rules.

OSStatus CreateStandardAlert (
   AlertType alertType,
   CFStringRef error,
   CFStringRef explanation,
   const AlertStdCFStringAlertParamRec * param,
   DialogRef * outAlert
);
Parameters
alertType

The type of alert to create. 
error

The error string to display. 
explanation

The explanation string to display. May be NULL or empty to display no explanation.
param

The parameter block describing how to create the alert. May be NULL. 
outAlert

On exit, contains the new alert. 
Return Value

A result code. See “Dialog Manager Result Codes”.
Discussion

CreateStandardAlert should be used in conjunction with RunStandardAlert. After CreateStandardAlert returns, the alert is still invisible. RunStandardAlert will show the alert and run a modal dialog loop to process events in the alert.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Dialogs.h*/
OSStatus CreateStandardAlert (
   AlertType alertType,
   CFStringRef error,
   CFStringRef explanation,
   const AlertStdCFStringAlertParamRec * param,
   DialogRef * outAlert){
//TODO
};




/*GetFrontWindowOfClass

Obtains the frontmost window of a given class. 

WindowRef GetFrontWindowOfClass (
   WindowClass inWindowClass,
   Boolean mustBeVisible
);
Parameters
inWindowClass

The class of the window you want to obtain. If you pass kAllWindowClasses, the function returns the frontmost window in the window list. 
mustBeVisible

If set to true, the function returns the frontmost visible window. If set to false, the function returns the frontmost window of the specified class, regardless of whether the window is visible.
Return Value

A reference to the frontmost window of the class specified by inWindowClass.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Carbon Porting Notes
Declared In
MacWindows.h*/
WindowRef GetFrontWindowOfClass (
   WindowClass inWindowClass,
   Boolean mustBeVisible){
//TODO
};


/*ShowWindow

Makes an invisible window visible.

void ShowWindow (
   WindowRef window
);
Parameters
window

The window that is to be made visible.
Discussion

The ShowWindow function makes an invisible window visible. If the specified window is already visible, ShowWindow has no effect. Your application typically creates a new window in an invisible state, performs any necessary setup of the content region, and then calls ShowWindow to make the window visible.

When you call ShowWindow to display a window that is invisible, the Window Manager draws the window frame and sends an event to request the application to draw the content region before the window becomes visible. For compositing windows, the Window Manager sends a kEventControlDraw event to each HIView in the window. For non-compositing windows, the Window Manager sends a kEventWindowDrawContent event. If a non-compositing window does not handle the kEventWindowDrawContent, the Window Manager shows the window and generates an update event to request your application to draw the content region.

If the newly visible window is the frontmost window, ShowWindow highlights it if it’s not already highlighted and generates an activate event to make it active. The ShowWindow function does not activate a window that is not frontmost on the desktop.

Because ShowWindow does not change the front-to-back ordering of windows, it is not the inverse of HideWindow. If you make the frontmost window invisible with HideWindow, andHideWindow has activated another window, you must call both ShowWindow and SelectWindow to bring the original window back to the front.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
void ShowWindow (
   WindowRef window){
//TODO
};


/*SetWindowModified

Sets the modification state of the specified window.

OSStatus SetWindowModified (
   WindowRef window,
   Boolean modified
);
Parameters
window

The window whose modification state is to be set.
modified

Pass true if the content of the window has been modified; otherwise, pass false.
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

Your application can use the functions SetWindowModified and IsWindowModified instead of maintaining its own separate record of the modification state of the content of a window. The modification state of a window is visually represented by a dot in the window’s close box. If the dot is present, the window is modified; if the dot is absent, the window is not modified.

Your application should distinguish between the modification state of the window and the modification state of the window’s contents, typically a document. The modification state of the window contents are what should affect SetWindowModified. For example, in the case of a word processing document, you call SetWindowModified (passing true in the modified parameter) whenever the user types new characters into the document. However, you do not call SetWindowModified when the user moves the window, because that change does not affect the document contents. If you need to track whether the window position has changed, you need to do this with your own flag. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus SetWindowModified (
   WindowRef window,
   Boolean modified){
//TODO
};

/*SetMenuBarFromNib

Unarchives a menu bar from a nib file, then makes the menu bar available in your application.

OSStatus SetMenuBarFromNib (
   IBNibRef inNibRef,
   CFStringRef inName
);
Parameters
inNibRef

A reference to the nib file that contains the menu bar you want to unarchive. You obtain this reference by calling the function CreateNibReference or CreateNibReferenceWithCFBundle.
inName

A CFStringRef that denotes the menu bar you want to unarchive. This is the name you supplied to the menu bar in the Instances pane of Interface Builder. (The default name is “MainMenu”.) See the Base Services documentation for a description of the CFStringRef data type. You can use the Core Foundation function CFSTR to convert a string to a CFString.
Return Value

A result code. See Runtime Errors.
Discussion

The function SetMenuBarFromNib makes the menu bar visible and selectable by the user when your application opens. If you don’t want the menu bar to be visible and selectable when it is unarchived, use the function CreateMenuBarFromNib. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X 10.0 and later.
Declared In
IBCarbonRuntime.h*/
OSStatus SetMenuBarFromNib (
   IBNibRef inNibRef,
   CFStringRef inName){
//TODO
};



/*EnableMenuCommand

Enables the menu item with a specified command ID.

void EnableMenuCommand (
   MenuRef inMenu,
   MenuCommand inCommandID
);
Parameters
inMenu

The menu in which to begin searching for the item. Pass NULL to begin searching with the root menu. The search will descend into all submenus of this menu. 
inCommandID

The command ID of the menu item to be enabled. If more than one item has this command ID, only the first will be enabled. 
Discussion

If you have access to the menu item index, in most cases you should use EnableMenuItem instead, as that function is faster and requires no searching. For example, when receiving a kEventCommandUpdateStatus event, the HICommand structure contains both the menu item’s command ID and index. If you wanted to enable the menu item, you should call EnableMenuItem.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void EnableMenuCommand (
   MenuRef inMenu,
   MenuCommand inCommandID){
//TODO
};

/*DeleteMenuItem

Deletes an item from a menu. 

void DeleteMenuItem (
   MenuRef theMenu,
   short item
);
Parameters
theMenu

The menu from which you want to delete the menu item. 
item

The item number of the menu item to delete. If you specify 0 or a number greater than the last item in the menu, DeleteMenuItem does not delete any item from the menu. 
Discussion

The DeleteMenuItem function deletes a specified menu item from a menu. You should not delete items from an existing menu unless the user expects the menu (such as a menu that lists open documents) to change. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void DeleteMenuItem (
   MenuRef theMenu,
   short item){
//TODO
};


/*AppendMenuItemTextWithCFString

Appends a new menu item with text from a CFString.

OSStatus AppendMenuItemTextWithCFString (
   MenuRef inMenu,
   CFStringRef inString,
   MenuItemAttributes inAttributes,
   MenuCommand inCommandID,
   MenuItemIndex * outNewItem
);
Parameters
menu

The menu to which to append the new item. 
inString

The text of the new item. 
inAttributes

The attributes of the new item. 
inCommandID

The command ID of the new item. 
outNewItem

On exit, the index of the new item. May be NULL if the caller does not need this information. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

The Menu Manager will make its own copy of the CFString before returning from this function. Modifying the string after calling AppendMenuItemTextWithCFString will have no effect on the menu item's actual text. The caller may release the string after the call.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSStatus AppendMenuItemTextWithCFString (
   MenuRef inMenu,
   CFStringRef inString,
   MenuItemAttributes inAttributes,
   MenuCommand inCommandID,
   MenuItemIndex * outNewItem){
//TODO
};

/*CreateNibReference

Creates a reference to a nib file in the current bundle.

OSStatus CreateNibReference (
   CFStringRef inNibName,
   IBNibRef * outNibRef
);
Parameters
inNibName

A CFStringRef that represents the name of a nib file you created for your application, but without the nib extension. See the Base Services documentation for a description of the CFStringRef data type. You can use the Core Foundation function CFSTR to convert a string to a CFString. 
outNibRef

On output, points to a nib reference. You pass the nib reference to Interface Builder Services functions that unarchive objects from a nib file.
Return Value

A result code. See Runtime Errors.
Discussion

Use this function if the nib file is located in the current bundle. Use the function CreateNibReferenceWithCFBundle if the nib file is located in a framework or other bundle that is not the current bundle. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X 10.0 and later.
Declared In
IBCarbonRuntime.h*/

OSStatus CreateNibReference (
   CFStringRef inNibName,
   IBNibRef * outNibRef){
//TODO
};

/*NewEventHandlerUPP

Creates an event handler UPP.

EventHandlerUPP NewEventHandlerUPP (
   EventHandlerProcPtr userRoutine
);
Parameters
userRoutine

A pointer to your event handler. 
Return Value

The UPP for your event handler.
Discussion

When registering your event handler with InstallEventHandler, you must pass a universal procedure pointer (UPP) to your event handler instead of a standard procedure pointer. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
EventHandlerUPP NewEventHandlerUPP (
   EventHandlerProcPtr userRoutine){
//TODO
};

/*TXNRevert

Reverts to the last saved version of a document. 

OSStatus TXNRevert (
   TXNObject iTXNObject
);
Parameters
iTXNObject

The text object for the active document. 
Return Value

A result code. See “MLTE Result Codes”.
Discussion

You can use the TXNRevert function with files that contain only text as well as files that were created using MLTE. If the file was not previously saved, the document reverts to an empty document. To revert to data that is embedded in a private file type, use the TXNSetSelection function to select all of the current data and then use the TXNSetDataFromFile function to read in the old data. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNRevert (TXNObject iTXNObject){
//TODO
};


/*TXNPageSetup

Displays the Page Setup dialog for the current default printer and manages changes, such as reformatting the text, in response to page layout changes.

OSStatus TXNPageSetup (
   TXNObject iTXNObject
);
Parameters
iTXNObject

The text object for the active document. 
Return Value

A result code. See “MLTE Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNPageSetup (
   TXNObject iTXNObject){
//TODO
};


/*TXNPrint

Prints the document so it is formatted to fit the page size selected for the printer. 

OSStatus TXNPrint (
   TXNObject iTXNObject
);
Parameters
iTXNObject

The text object that identifies the document you want to print. 
Return Value

A result code. See “MLTE Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNPrint (
   TXNObject iTXNObject){
//TODO
};



/*GetEventKind

Returns the event kind for the specified event.

UInt32 GetEventKind (
   EventRef inEvent
);
Parameters
inEvent

The event in question. 
Return Value

The kind of the event. 
Discussion

Event kind values overlap in different event classes. For example, kEventMouseDown and kEventAppActivated both have the same value (1). The combination of class and kind determines a unique event signature.
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
UInt32 GetEventKind (
   EventRef inEvent){
//TODO
};

/*GetEventClass

Returns the class of an event (for example, window, mouse, or keyboard).

UInt32 GetEventClass (
   EventRef inEvent
);
Parameters
inEvent

The event in question. 
Return Value

The class ID of the event. See “Event Class Constants” for more details. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
UInt32 GetEventClass (
   EventRef inEvent){
//TODO
};




/*GetControl32BitValue

Obtains the current setting of a control.

SInt32 GetControl32BitValue (
   ControlRef theControl
);
Parameters
theControl

A handle to the control whose current setting you wish to obtain. 
Return Value

The current setting of the control. 
Discussion

Your application may use the GetControl32BitValue function to obtain a 32-bit value previously set with the function SetControl32BitValue.

If your application uses a 32-bit control value, it should not attempt to obtain this value by calling the pre–Mac OS 8.5 function GetControlValue because the 16-bit value that is returned does not accurately reflect the current 32-bit control value.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
SInt32 GetControl32BitValue (
   ControlRef theControl){
//TODO
};


/*GetControlPopupMenuHandle

Gets the menu handle for a pop-up control.

MenuRef GetControlPopupMenuHandle (
   ControlRef control
);
Parameters
control

The pop-up control to query.
Return Value

See the Menu Manager documentation for a description of the MenuRef data type.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
MenuRef GetControlPopupMenuHandle (
   ControlRef control){
//TODO
};




/*RunApplicationEventLoop

Runs the application event loop.

void RunApplicationEventLoop ();
Discussion

This function is used as the main event loop for a Carbon Event-based application. Once entered, this function waits for events to arrive and dispatches them to your event handlers automatically. 

Note that calling RunApplicationEventLoop also installs the standard application handler, which provides standard handler responses for menu and application events. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/
void RunApplicationEventLoop (){
//TODO
};


/*CopyMenuItemTextAsCFString

Returns a CFString containing the text of a menu item.

OSStatus CopyMenuItemTextAsCFString (
   MenuRef inMenu,
   MenuItemIndex inItem,
   CFStringRef * outString
);
Parameters
menu

The menu containing the item. 
item

The item whose text you want to copy. 
outString

On exit, a CFString containing the item's text. The caller must release this string when it is no longer needed. 
Return Value

A result code. See “Menu Manager Result Codes”.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSStatus CopyMenuItemTextAsCFString (MenuRef inMenu,MenuItemIndex inItem,CFStringRef * outString){
//TODO
};


/*SetWindowResizeLimits

Sets the maximum and minimum resize limits for windows. 

OSStatus SetWindowResizeLimits (
   WindowRef inWindow,
   const HISize * inMinLimits,
   const HISize * inMaxLimits
);
Parameters
inWindow

The window whose maximum and minimum resize limits are to be set.
inMinLimits

The minimum limits. Pass NULL if you don’t want to set this limit. For information on the HISize data type, see HIGeometry.h.
inMaxLimits

The maximum limits. Pass NULL if you don’t want to set this limit. For information on the HISize data type, see HIGeometry.h.
Return Value

A result code. See “Window Manager Result Codes”.
Availability
Available in Mac OS X v10.2 and later. 
Declared In
MacWindows.h*/

OSStatus SetWindowResizeLimits (
   WindowRef inWindow,
   const HISize * inMinLimits,
   const HISize * inMaxLimits){
//TODO
};

int HIThemeDrawTextBox( int a, int b, int c, int d, int e ){
//TODO
};

int HIThemeGetTextDimensions( int a, int b, int c, int d, int e,int  f){
//TODO
};

/*NewEventLoopTimerUPP

Creates an event loop timer UPP. 

EventLoopTimerUPP NewEventLoopTimerUPP (
   EventLoopTimerProcPtr userRoutine
);
Parameters
userRoutine

A pointer to your event timer callback function. 
Return Value

The UPP for your event timer callback function. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
EventLoopTimerUPP NewEventLoopTimerUPP (
   EventLoopTimerProcPtr userRoutine){
//TODO
};



/*GetMainEventLoop

Obtains a reference to the main event loop.

EventLoopRef GetMainEventLoop ();
Return Value

An event loop reference. 
Discussion

The main loop is the event loop for the main application thread. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
EventLoopRef GetMainEventLoop ();

/*InstallEventLoopTimer

Installs a timer.

OSStatus InstallEventLoopTimer (
   EventLoopRef inEventLoop,
   EventTimerInterval inFireDelay,
   EventTimerInterval inInterval,
   EventLoopTimerUPP inTimerProc,
   void * inTimerData,
   EventLoopTimerRef * outTimer
);
Parameters
inEventLoop

The event loop to add the timer. 
inFireDelay

The delay before first firing this timer, in seconds. In Mac OS X v10.3 and earlier, the delay must be greater than zero. In Mac OS X v10.4, the delay can be greater than or equal to zero. 

In Mac OS X and CarbonLib 1.5 and later, you may pass kEventDurationForever to stop the timer from firing at all until SetEventLoopTimerNextFireTime is used to start it; in earlier versions of CarbonLib, to achieve the same effect, just pass zero and then immediately call SetEventLoopTimerNextFireTime( timer, (kEventDurationForever ) before returning control to your event loop.
inInterval

The timer interval, in seconds. Pass 0 or (in Mac OS X and CarbonLib 1.5 and later) kEventDurationForever for a one-shot timer. 
inTimerProc

The function to call when the timer fires. 
inTimerData

Data to pass to the timer function when called.
outTimer

A reference to the newly installed timer. 
Return Value

A result code. See “Carbon Event Manager Result Codes”.
Discussion

Installs a timer onto the event loop specified. The timer can either fire once or repeatedly at a specified interval depending on the parameters passed to this function. It executes at task level and should not be confused with Time Manager tasks or any other interrupt-level callback. This means you can call toolbox functions, allocate memory, and draw without worrying about consequences. When a timer fires, it calls the callback you specified when the timer was installed.

Timers in general have two uses: as a timeout mechanism and as a periodic task. An everyday example of using a timer for a timeout might be a light that goes out if no motion is detected in a room for 5 minutes. For this, you might install a timer which will fire in 5 minutes. If motion is detected, you would reset the timer fire time and let the clock start over. If no motion is detected for the full 5 minutes, the timer will fire and you could power off the light. A periodic timer is one that fires at regular intervals (say every second or so). You might use such a timer to blink the insertion point in your editor, and so on.

One advantage of timers is that you can install the timer right from the code that wants the time. For example, the standard editable text control can install a timer to blink the cursor when it’s active, meaning that the Control Manager function IdleControls is a no-op for that control and doesn’t need to be called. When the control is inactive, it removes its timer and doesn’t waste CPU time in that state.

Currently, if you do decide to draw when your timer is called, be sure to save and restore the current port so that calling your timer doesn’t inadvertently change the port out from under someone. 

Be sure to dispose of the timer when you no longer need it by calling RemoveEventLoopTimer. Doing so is especially important if your timer calls code that may no longer exist. For example, if a plugin creates a timer that calls back to it, the timer will attempt to call it even after the plugin is removed. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
OSStatus InstallEventLoopTimer (
   EventLoopRef inEventLoop,
   EventTimerInterval inFireDelay,
   EventTimerInterval inInterval,
   EventLoopTimerUPP inTimerProc,
   void * inTimerData,
   EventLoopTimerRef * outTimer){
//TODO
};


/*GetControlEventTarget

Obtains the event target reference for the specified control.

EventTargetRef GetControlEventTarget (
   ControlRef inControl
);
Parameters
inControl

The control to return the target for. See the Control Manager documentation for a description of the ControlRef data type.
Return Value

An event target reference. 
Discussion

Once you obtain this reference, you can send events to the target and install event handlers on it. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/
EventTargetRef GetControlEventTarget (
   ControlRef inControl){
//TODO
};



/*UnregisterEventHotKey

Unregisters a global hot key. 

OSStatus UnregisterEventHotKey (
   EventHotKeyRef inHotKey
);
Parameters
inHotKey

The event hot key reference of the hot key you want to unregister. 
Return Value

A result code. See “Carbon Event Manager Result Codes”.
Discussion

Unregisters a global hot key that was previously registered with the function RegisterEventHotKey. You do not need to unregister a hot key when your application terminates; the system takes care of that for you. You can use this function if the user changes a hot key for something in your application—you would unregister the previous key and register your new key. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/
OSStatus UnregisterEventHotKey (
   EventHotKeyRef inHotKey){
//TODO
};


/*HIViewSetNeedsDisplay

Marks a view as needing or not needing to be redrawn.

OSStatus HIViewSetNeedsDisplay (
   HIViewRef inView,
   Boolean inNeedsDisplay
);
Parameters
inView

The view to mark as dirty (needing to be redrawn) or clean (not needing to be redrawn).
inNeedsDisplay

A Boolean whose value is true to mark the view as dirty or false to mark it as clean.
Return Value

An operating system result code.
Discussion

If the view is not visible or is obscured completely by other views, no action is taken.
Availability
Available in Mac OS X v10.2 and later.*/

OSStatus HIViewSetNeedsDisplay (
   HIViewRef inView,
   Boolean inNeedsDisplay){
//TODO
};



/*CopyWindowTitleAsCFString

Copies the window title into a Core Foundation string.

OSStatus CopyWindowTitleAsCFString (
   WindowRef inWindow,
   CFStringRef * outString
);
Parameters
inWindow

The window whose title is to be copied.
outString

On output, the window’s title. 
Return Value

A result code. See “Window Manager Result Codes”.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus CopyWindowTitleAsCFString (
   WindowRef inWindow,
   CFStringRef * outString){
//TODO
};


/*CreateNewWindow

Creates a window from parameter data.

OSStatus CreateNewWindow (
   WindowClass windowClass,
   WindowAttributes attributes,
   const Rect * contentBounds,
   WindowRef * outWindow
);
Parameters
windowClass

A constant that categorizes the class of window to be created. For certain classes, the window class can be altered after the window is created by calling HIWindowChangeClass. See “Window Class Constants” for a description of possible values for this parameter.
attributes

Attributes for the window. See “Window Attributes” for a list of possible attributes.
contentBounds

Pointer to a Rect structure in global coordinates indicating the dimensions of the window’s content region.
outWindow

On input, a pointer to a value of type WindowRef. On return, the window pointer points to the newly created window.
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

The CreateNewWindow function creates a window based on the attributes and class you specify in the attributes and windowClass parameters. CreateNewWindow sets the new window’s content region to the size and location specified by the rectangle passed in the bounds parameter, which in turn determines the dimensions of the entire window. The Window Manager creates the window invisibly and places it at the front of the window’s window group. After calling CreateNewWindow, you should set any desired associated data—using Window Manager or Control Manager accessor functions—then call the function TransitionWindow or ShowWindow to display the window. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus CreateNewWindow (
   WindowClass windowClass,
   WindowAttributes attributes,
   const Rect * contentBounds,
   WindowRef * outWindow){
//TODO
};


/*RepositionWindow

Positions a window relative to another window or a display screen.

OSStatus RepositionWindow (
   WindowRef window,
   WindowRef parentWindow,
   WindowPositionMethod method
);
Parameters
window

The window whose position you want to set.
parentWindow

A pointer to the “parent” window, as defined by your application. In cases where the window positioning method does not require a parent window, you should set the parentWindow parameter to NULL.
method

A constant specifying the window positioning method to be used; see “Window Position Constants” for descriptions of possible values. 
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

Your application may call the RepositionWindow function to position any window, relative to another window or to a display screen. After positioning the window, RepositionWindow displays the window in its new position.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/

OSStatus RepositionWindow (
   WindowRef window,
   WindowRef parentWindow,
   WindowPositionMethod method){
//TODO
};

/*CreateTabsControl

Creates a tabs control.

OSStatus CreateTabsControl (
   WindowRef window,
   const Rect * boundsRect,
   ControlTabSize size,
   ControlTabDirection direction,
   UInt16 numTabs,
   const ControlTabEntry * tabArray,
   ControlRef * outControl
);
Parameters
window

The window in which the control is to be placed. This parameter may be NULL in Mac OS X v10.3 and later.
boundsRect

The bounds of the control in the window’s local coordinates.
size

The control tab size. See Control Tab Size Constants for possible values.
direction

The control tab direction. See Control Tab Direction Constants for possible values.
numTabs

The initial number of tabs.
tabArray

Information about each tab. There must be the same number of entries as specified by the numTabs parameter.
outControl

On return, the new control. For a description of this data type, see “ControlRef”.
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

If you want to customize the accessibility information provided for individual tabs of a tabs control, such as by handling various kEventClassAccessibility Carbon Events and by calling HIObjectSetAuxiliaryAccessibilityAttribute, you need to know how to build or interpret AXUIElement reference that represent individual tabs. The AXUIElement representing an individual tab must be constructed using the tab control’s ControlRef and the UInt64 identifier of the one-based index of the tab to which the element refers. A UInt64 identifier of 0 represents the tabs control as a whole. You cannot interpret or create tab control elements whose identifiers are greater than the count of tabs in the tabs control.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus CreateTabsControl (
   WindowRef window,
   const Rect * boundsRect,
   ControlTabSize size,
   ControlTabDirection direction,
   UInt16 numTabs,
   const ControlTabEntry * tabArray,
   ControlRef * outControl){
//TODO
};


/*HIViewAddSubview

Adds a subview to the given parent view.

OSStatus HIViewAddSubview (
   HIViewRef inParent,
   HIViewRef inNewChild
);
Parameters
inParent

The view that will receive the new subview.
inNewChild

The subview being added.
Return Value

An operating system result code. The result code errNeedsCompositedWindow is returned if you try to embed into the content view in a non-compositing window; you can only embed into the content view in a compositing window.
Discussion

The new subview is added to the front of the list of subviews (that is, it is made topmost). The subview being added is not retained by the new parent view. Do not release the view after adding it, or it will cease to exist. All views in a window are released automatically when the window is destroyed.
Availability
Available in Mac OS X v10.2 and later.*/

OSStatus HIViewAddSubview (
   HIViewRef inParent,
   HIViewRef inNewChild){
//TODO
};


/*SetControlCommandID

Sets the command ID for a control. 

OSStatus SetControlCommandID (
   ControlRef inControl,
   UInt32 inCommandID
);
Parameters
inControl

. For a description of this data type, see 
inCommandID

The command ID that is to be set.
Return Value

A result code. See “Control Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
OSStatus SetControlCommandID (
   ControlRef inControl,
   UInt32 inCommandID){
//TODO
};


/*SetControlID

Sets a control’s ID. 

OSStatus SetControlID (
   ControlRef inControl,
   const ControlID * inID
);
Return Value

A result code. See “Control Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/

OSStatus SetControlID (
   ControlRef inControl,
   const ControlID * inID){
//TODO
};


/*HIViewSetLayoutInfo

Sets the layout information of an HIView. 

OSStatus HIViewSetLayoutInfo (
   HIViewRef inView,
   HILayoutInfo * inLayoutInfo
);
Parameters
inView

The view whose layout information is to be set.
inLayoutInfo

A pointer to an HILayoutInfo structure containing the layout values that are to be set.
Return Value

An operating system result code.
Discussion

Layouts are used to automatically change the size and positioning of a view when another view changes size or position. Layout changes only take effect in two cases:
When HIViewApplyLayout is called after the view’s layout has been set by calling HIViewSetLayoutInfo. The HIViewApplyLayout function is most useful when first applying a scaling or positioning layout to a view in order to set up the view’s initial position and size relative to the view referenced in the layout.
When the related view changes its size or position.

A layout allows a view’s size or position to be modified in three ways: side binding, axial scaling, and axial positioning. In the following examples, View A initially has a left side of 100 and a right side of 150, and is placed inside a parent view that has a width of 275.
Bindings — Setting up a binding relationship between two views specifies that one edge of a view is to change by an amount equal to the change in an edge of another view. If View A has a right-side binding to its parent’s maximum (or right) side, when the parent’s right side changes, View A’s right side changes by the same amount. If the parent view resizes to be 325 units wide (50 units wider than before), View A is resized so that its left side changes to 150 units and its right side changes to 200, which is 50 units more to the right than before. You can think of bindings as a way to maintain distance. An edge bound to another view’s edge always maintains its offset from that related edge. In other view systems, this concept is often referred to as “springs and rods.” Note that a binding does not cause one side of the view to exactly align with the side of another view; a binding merely causes one side of the view to change by the same amount as another view changes. To align one edge of a view to another view’s edge, use positioning. Bindings depend on changes in size or position of the related view. As a result, calling HIViewApplyLayout does not activate side bindings, as no changes have occurred. Bindings are implemented using the HIBinding structure and one HISideBinding structure per view edge.
Scaling — Setting up a scaling relationship between two views specifies that the axial size (that is, the width or height) of a view is to be a specified ratio of the size of another view when that other view moves or resizes. If View A has an x-axis scaling for its parent view with a ratio of 0.8, when the parent view’s width changes, View A’s width changes to be the parent’s width multiplied by 0.8. If the parent view resizes to be 325 units wide, View A resizes so that its left side stays at 100 and its right side changes to 360 (100 + 325 * 0.8). Note that when a scaling layout is first set up on a view with HIViewSetLayoutInfo, no scaling is applied to the view because scaling only occurs when the related view resizes. If scaling is required at initial setup, call HIViewSetLayoutInfo and then HIViewApplyLayout. Scaling is implemented using the HIScaling structure and one HIAxisScale structure per view axis.
Positioning — Setting up a positioning relationship between two views specifies that the axial position (i.e., vertical or horizontal) of a view is to change so that the view aligns with the minimum, maximum, or center of another view when that other view resizes. If View A has an x-axis position with its parent view with center positioning specified, when the parent view changes size, View A moves so that it is centered horizontally relative to its parent. If the parent view resizes to be 300 units wide, View A repositions so that its left side is at 125 and its right side is at 175, centered in the parent view. Positioning is implemented using the HIPositioning structure and one HIAxisPosition per view axis.

The HIView layout engine applies transformations to a view sequentially. First, bindings are applied. Then scaling is applied, which could override some of the previously applied bindings. Then positioning is applied, which could also override some of the previously applied bindings. The bindings are applied recursively to a container’s subviews, which requires care on your part to avoid infinite recursion, especially when applying inter-relational bindings. For example, if View A’s x axis is scaled relative to View B and View B’s x-axis is scaled to View A, your application could hang when the layouts are applied because View A would affect View B, which would affect View A, and so on.

For more information on using the layout engine, see HIView Programming Guide.
Availability
Available in Mac OS X v10.3 and later.*/
OSStatus HIViewSetLayoutInfo (
   HIViewRef inView,
   HILayoutInfo * inLayoutInfo){
//TODO
};


/*CreateUserPaneControl

Creates a user pane control.

OSStatus CreateUserPaneControl (
   WindowRef window,
   const Rect * boundsRect,
   UInt32 features,
   ControlRef * outControl
);
Parameters
window

The window in which the control is to be placed. This parameter may be NULL in Mac OS X v10.3 and later.
boundsRect

The bounds of the control in the window’s local coordinates.
features

The user pane features with which the user pane is to be created. For possible constants, see “Control Features Constants”. 
outControl

On return, the new control. For a description of this data type, see “ControlRef”.
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

User panes have two primary purposes: to allow easy implementation of a custom control by the developer, and to provide a generic container for embedding other controls.

In Carbon, with the advent of Carbon-event-based controls, you may find it easier to write a new control from scratch than to customize a user pane control. The set of callbacks provided by the user pane will not be extended to support new Control Manager features; instead, you should just write a real control.User panes do not, by default, support embedding. If you try to embed a control into a user pane, you will get the errControlIsNotEmbedder. You can make a user pane support embedding by passing the kControlSupportsEmbedding flag in the features parameter when you create the control.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus CreateUserPaneControl (
   WindowRef window,
   const Rect * boundsRect,
   UInt32 features,
   ControlRef * outControl){
//TODO
};


/*HIViewSetVisible

Hides or shows a view. 

OSStatus HIViewSetVisible (
   HIViewRef inView,
   Boolean inVisible
);
Parameters
inView

The view to hide or show.
inVisible

A Boolean value that indicates whether you want to hide the view (false) or show the view (true).
Return Value

An operating system result code.
Discussion

Marks the area the view will occupy or previously occupied as needing to be redrawn later. 
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus HIViewSetVisible (
   HIViewRef inView,
   Boolean inVisible){
//TODO
};


/*CreateStaticTextControl

Creates a new static text control.

OSStatus CreateStaticTextControl (
   WindowRef window,
   const Rect * boundsRect,
   CFStringRef text,
   const ControlFontStyleRec * style,
   ControlRef * outControl
);
Parameters
window

The window in which the control is to be placed. This parameter may be NULL in Mac OS X v10.3 and later.
boundsRect

The bounds of the control in the window’s local coordinates.
text

The text of the control. May be NULL.
style

The control’s font style, size, color, and so on. May be NULL.
outControl

On return, the new control. For a description of this data type, see “ControlRef”.
Return Value

A result code. See “Control Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus CreateStaticTextControl (
   WindowRef window,
   const Rect * boundsRect,
   CFStringRef text,
   const ControlFontStyleRec * style,
   ControlRef * outControl){
//TODO
};



/*CreatePushButtonControl

Creates a push button control.

OSStatus CreatePushButtonControl (
   WindowRef window,
   const Rect * boundsRect,
   CFStringRef title,
   ControlRef * outControl
);
Parameters
window

The window in which the control is to be placed. This parameter may be NULL in Mac OS X v10.3 and later.
boundsRect

The bounds of the control in the window’s local coordinates.
title

The control title. May be NULL.
outControl

On return, the new control. For a description of this data type, see “ControlRef”.
Return Value

A result code. See “Control Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/

OSStatus CreatePushButtonControl (
   WindowRef window,
   const Rect * boundsRect,
   CFStringRef title,
   ControlRef * outControl){
//TODO
};


/*GetControl32BitMinimum

Obtains the minimum setting of a control.

SInt32 GetControl32BitMinimum (
   ControlRef theControl
);
Parameters
theControl

A handle to the control whose minimum setting you wish to obtain. For a description of this data type, see “ControlRef”.
Return Value

The minimum setting of the control. 
Discussion

Your application may use the GetControl32BitMinimum function to obtain a 32-bit value previously set with the function SetControl32BitMinimum.

If your application uses a 32-bit control minimum value, it should not attempt to obtain this value by calling the pre–Mac OS 8.5 function GetControlMinimum because the 16-bit value that is returned does not accurately reflect the current 32-bit control value. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
SInt32 GetControl32BitMinimum (
   ControlRef theControl){
//TODO
};



/*HIViewGetLastSubview

Returns the last subview in a parent view.

HIViewRef HIViewGetLastSubview (
   HIViewRef inView
);
Parameters
inView

The view whose subview you are fetching.
Return Value

An HIView reference, or NULL if this view has no subviews or is invalid.
Discussion

Returns the last subview of a container. The last subview is the bottommost subview in z-order.
Availability
Available in Mac OS X v10.2 and later.*/
HIViewRef HIViewGetLastSubview (
   HIViewRef inView){
//TODO
};



/*HIViewGetPreviousView

Returns the view above the specified view.

HIViewRef HIViewGetPreviousView (
   HIViewRef inView
);
Parameters
inView

The view to use as reference.
Return Value

An HIView reference, or NULL if this view has no view in front of it or is invalid.
Discussion

Returns the view before the specified view, in z-order.
Availability
Available in Mac OS X v10.2 and later.*/
HIViewRef HIViewGetPreviousView (
   HIViewRef inView){
//TODO
};


/*DisableMenuItem

Disables a menu item or a menu.

void DisableMenuItem (
   MenuRef theMenu,
   MenuItemIndex item
);
Parameters
theMenu

The menu containing the item to be disabled. 
item

The index of the menu item that you wish to disable. Pass 0 to specify the menu title (disabling the entire menu). 
Discussion

The DisableMenuItem function disables a menu item (and any associated icon) so that the user cannot choose the item from the menu. 

Note that EnableMenuItem calls the InvalMenuBar function to update the menu bar the next time through the event loop.

See also the EnableMenuItem and IsMenuItemEnabled functions. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Carbon Porting Notes

Note that the implementation of Carbon on Mac OS 8.1 only supports disabling menu items less than or equal to 31.
Declared In
Menus.h*/
void DisableMenuItem (
   MenuRef theMenu,
   MenuItemIndex item){
//TODO
};


/*EnableMenuItem

Enables a menu item or a menu.

void EnableMenuItem (
   MenuRef theMenu,
   MenuItemIndex item
);
Parameters
theMenu

The menu containing the item to be enabled. 
item

The item number of the menu item that you wish to enable. If you pass 0, EnableMenuItem enables the menu title and all items in the menu that were not previously individually disabled. 
Discussion

The EnableMenuItem function enables a menu item so that the user can choose the item from the menu. If the menu item has an associated icon, that icon is also enabled, unless the icon was previously individually disabled with the function DisableMenuItemIcon.

Note that EnableMenuItem calls the InvalMenuBar function to update the menu bar the next time through the event loop.

See also the DisableMenuItem and IsMenuItemEnabled functions. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void EnableMenuItem (
   MenuRef theMenu,
   MenuItemIndex item){
//TODO
};

/*GetNextWindowOfClass

Obtains the next window in a given window group. 

WindowRef GetNextWindowOfClass (
   WindowRef inWindow,
   WindowClass inWindowClass,
   Boolean mustBeVisible
);
Parameters
inWindow

The window at which to start.
inWindowClass

The class of window to obtain. If you pass kAllWindowClasses, the function returns the window directly behind the input window. If no windows exist behind the front window, the function returns NULL. 
mustBeVisible

If set to true, this function returns the next visible window of the specified window class. If set to false, this function returns the next window of the specified window class, regardless of whether it is visible.
Return Value

A reference for the next window of the specified class after the window specified by inWindow.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
WindowRef GetNextWindowOfClass (
   WindowRef inWindow,
   WindowClass inWindowClass,
   Boolean mustBeVisible){
//TODO
};

int GetMouse(int a ){
//TODO
};


/*RemoveEventLoopTimer

Removes the specified timer.

OSStatus RemoveEventLoopTimer (
   EventLoopTimerRef inTimer
);
Parameters
inTimer

The timer to remove. 
Return Value

A result code. See “Carbon Event Manager Result Codes”.
Discussion

Removes a timer that was previously installed by a call to InstallEventLoopTimer or InstallEventLoopIdleTimer. You call this function when you are done using a timer. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
OSStatus RemoveEventLoopTimer (
   EventLoopTimerRef inTimer){
//TODO
};


/*DisposeEventLoopTimerUPP

Disposes of an event loop timer. 

void DisposeEventLoopTimerUPP (
   EventLoopTimerUPP userUPP
);
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
void DisposeEventLoopTimerUPP (
   EventLoopTimerUPP userUPP){
//TODO
};

/*SetEventLoopTimerNextFireTime

Sets the next time that the specified timer will fire.

OSStatus SetEventLoopTimerNextFireTime (
   EventLoopTimerRef inTimer,
   EventTimerInterval inNextFire
);
Parameters
inTimer

The timer whose firing time you want to set. 
inNextFire

The interval from the current time to wait until firing the timer again. 
Return Value

A result code. See “Carbon Event Manager Result Codes”.
Discussion

This function is used to “reset” a timer. It controls the next time the timer fires. This will override any interval you might have set. For example, if you have a timer that fires every second, and you call this function setting the next time to 5 seconds from now, the timer will sleep for 5 seconds, then fire. The timer will then resume its one second interval. This function acts as if you removed the timer and reinstalled it with a new first-fire delay.
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
OSStatus SetEventLoopTimerNextFireTime (
   EventLoopTimerRef inTimer,
   EventTimerInterval inNextFire){
//TODO
};


/*GetControlOwner

Returns the window to which a control is bound.

WindowRef GetControlOwner (
   ControlRef control
);
Parameters
control

The control to query. For a description of this data type, see “ControlRef”.
Return Value

The window reference to which the control is bound, or NULL if the control is not bound to a window.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
WindowRef GetControlOwner (
   ControlRef control){
//TODO
};

/*SetControlAction

Sets the action function for a control.

void SetControlAction (
   ControlRef theControl,
   ControlActionUPP actionProc
);
Parameters
theControl

A handle to the control whose action function is to be changed. For a description of this data type, see 
actionProc

A universal procedure pointer to an action function defining what action your application takes while the user holds down the mouse button. See ControlActionProcPtr for a description of an action function. 
Discussion

The SetControlAction function associates the action function specified by actionProc with the control specified by theControl. If the cursor is in the specified control, the HandleControlClick and TrackControl functions call the specified action function when the user holds down the mouse button. You must provide the action function, and it must define some action to perform repeatedly as long as the user holds down the mouse button. HandleControlUnderClick and TrackControl always highlight and drag the control as appropriate.

SetControlAction should be used to set the application-defined action function for providing live feedback for standard system scroll bar controls.

Note that the action function associated with a control is used by TrackControl only if you set the action function to TrackControl to Pointer(–1). Also, an action function can be specified in the actionProc parameter to TrackControl, so you don’t have to call SetControlAction to change it.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/

void SetControlAction (
   ControlRef theControl,
   ControlActionUPP actionProc){
//TODO
};

/*HIViewSetText

Sets the text of a view to the specified string.

OSStatus HIViewSetText (
HIViewRef inView,
CFStringRef inText
);
Parameters
inView

The view whose text is to be set.
inText

The text that is to be set.
Return Value

An operating system result code.
Discussion

This function attempts to set the text that is displayed when drawing the view and is generally successful on views that handle the kControlEditTextCFStringTag SetControlData tag. If this function can’t set that text, it sets the text in the view’s title instead.
Availability
Available in Mac OS X v10.4 and later.*/

OSStatus HIViewSetText (HIViewRef inView,CFStringRef inText){
//TODO
};


/*GetWRefCon

Returns the reference constant from a window.

long GetWRefCon (
   WindowRef window
);
Parameters
window

The window whose reference constant is to be returned.
Return Value

The long integer data stored in the refCon field of the window structure specified in the window parameter. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
long GetWRefCon (WindowRef window){
//TODO
};


/*SetWRefCon

Sets the refCon field of a window.

void SetWRefCon (
   WindowRef window,
   long data
);
Parameters
window

The window whose refCon field is to be set.
data

On input, the data to be placed in the refCon field. 
Discussion

The SetWRefCon function places the specified data in the refCon field of the specified window structure. The refCon field is available to your application for any window-related data it needs to store. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
void SetWRefCon (
   WindowRef window,
   long data){
//TODO
};


/*HIViewSetID

Sets the HIViewID of a view.

OSStatus HIViewSetID (
HIViewRef inView,
HIViewID inID
);
Parameters
inView

The view whose HIViewID is to be set.
inID

The HIViewID to set.
Return Value

An operating system result code.
Availability
Available in Mac OS X v10.4 and later.*/
OSStatus HIViewSetID (
HIViewRef inView,
HIViewID inID){
//TODO
};


/*CreateLittleArrowsControl

Creates a little arrows control.

OSStatus CreateLittleArrowsControl (
   WindowRef window,
   const Rect * boundsRect,
   SInt32 value,
   SInt32 minimum,
   SInt32 maximum,
   SInt32 increment,
   ControlRef * outControl
);
Parameters
window

The window that is to contain the control. This parameter may be NULL in Mac OS X v10.3 and later.
boundsRect

The bounds of the control in the window’s local coordinates.
value

The initial value of the control.
minimum

The minimum value the control can have.
maximum

The maximum value the control can have.
increment

The amount to increment each time an arrow is clicked.
outControl

On return, outControl points to the new control. For a description of this data type, see “ControlRef”. 
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

This control implements the little up and down arrows seen in the Date & Time system preferences panel. To change the value of this control, you need to create a control action proc. The following sample code creates the control and sets the action proc:CreateLittleArrowsControl(&rect, minimum, maximum, increment,  value);
SetControlAction(Arrows, LittleArrowActionProc);


Here is sample code for the action proc:void LittleArrowActionProc(ControlRef cref, ControlPartCode part)  {
    SInt32 val = GetControl32BitValue(cref);
    SInt32 s = 0;
    GetControlData(MWArrows, 0, kControlLittleArrowsIncrementValueTag,  sizeof(SInt32), &s, nil;
    switch (part) {
        case kControlUpButtonPart:
            SetControl32BitValue(cref, val+s);
            break;
        case kControlDownButtonPart:
            SetControl32BitValue(cref, val-s);
            break;
        };
    };

Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus CreateLittleArrowsControl (
   WindowRef window,
   const Rect * boundsRect,
   SInt32 value,
   SInt32 minimum,
   SInt32 maximum,
   SInt32 increment,
   ControlRef * outControl){
//TODO
};

/*GetControlData

Obtains control-specific data.

OSErr GetControlData (
   ControlRef inControl,
   ControlPartCode inPart,
   ResType inTagName,
   Size inBufferSize,
   void * inBuffer,
   Size * outActualSize
);
Parameters
inControl

A handle to the control to be examined. 
inPart

The part code of the control part from which data is to be obtained; see “Control Meta Part Code Constants”, “Control Part Code Constants”, and “Control State Part Code Constants”. Passing kControlEntireControl indicates that either the control has no parts or the data is not tied to any specific part of the control. For a description of this data type, see “ControlPartCode”. 
inTagName

A constant representing the control-specific data you wish to obtain see the data tag constants in the “Control Manager Constants” section. 
inBufferSize

The size (in bytes) of the data pointed to by the inBuffer parameter. For variable-length control data, pass the value returned in the outMaxSize parameter of GetControlDataSize in the inBufferSize parameter. The number of bytes must match the actual data size. 
inBuffer

On input, a pointer to a buffer allocated by your application. On return, the buffer contains a copy of the control-specific data. If you pass NULL on input, it is equivalent to calling GetControlDataSize. The actual size of the control-specific data will be returned in the outActualSize parameter. For variable-length data, the number of bytes must match the actual data size.
outActualSize

On input, a pointer to a Size value. On return, the value is set to the actual size of the data. You can pass NULL if you don’t care about this value. 
Return Value

A result code. See “Control Manager Result Codes”. The result code errDataNotSupported indicates that the inTagName parameter is not valid.
Discussion

The GetControlData function will only copy the amount of data specified in the inBufferSize parameter, but will tell you the actual size of the buffer so you will know if the data was truncated. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
OSErr GetControlData (
   ControlRef inControl,
   ControlPartCode inPart,
   ResType inTagName,
   Size inBufferSize,
   void * inBuffer,
   Size * outActualSize){
//TODO
};

/*SetControl32BitValue

Changes the current setting of a control and redraws it accordingly.

void SetControl32BitValue (
   ControlRef theControl,
   SInt32 newValue
);
Parameters
theControl

A handle to the control whose current setting you wish to change. For a description of this data type, see “ControlRef”.
newValue

A value specifying the new setting of the control. If the specified value is less than the minimum setting for the control, SetControl32BitValue sets the current setting of the control to its minimum setting. If the specified value is greater than the maximum setting, SetControl32BitValue sets the control to its maximum.
Discussion

Your application may use the SetControl32BitValue function to set a 32-bit value as the current setting for a control.

If your application uses a 32-bit control value, it should not attempt to obtain this value by calling the pre–Mac OS 8.5 function GetControlValue because the 16-bit value that is returned does not accurately reflect the current 32-bit control value. Instead, use the function GetControl32BitValue. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/

void SetControl32BitValue (
   ControlRef theControl,
   SInt32 newValue){
//TODO
};

/*SetWindowDefaultButton

Specifies a default button for a window.

OSStatus SetWindowDefaultButton (
   WindowRef inWindow,
   ControlRef inControl
);
Parameters
inWindow

The window whose default button you want to set. See the Window Manager documentation for a description of the WindowRef data type.
inControl

The control to designate as the default. See the Control Manager documentation for a description of the ControlRef data type.
Return Value

A result code. See “Carbon Event Manager Result Codes”.
Discussion

You can use this function to specify a control (normally a button) to be the default for a given window. This button would be considered to have been clicked if the user instead presses the Return or Enter keys on the keyboard. 

The standard window event handler looks for keystrokes that correspond to the default button and generates events of type kEventControlHit when it detects the correct key being pressed. This is similar to the way the Dialog Manager responds to default buttons, except that instead of returning an item index for which button is pressed, the Carbon Event Manager generates a control hit event. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/
OSStatus SetWindowDefaultButton (
   WindowRef inWindow,
   ControlRef inControl){
//TODO
};


/*HIObjectGetEventTarget

Obtains the event target of an HIObjectRef. 

EventTargetRef HIObjectGetEventTarget (
   HIObjectRef inObject
);
Parameters
inObject

The object whose target you want.
Return Value

An EventTargetRef.
Availability
Available in Mac OS X v10.2 and later.*/
EventTargetRef HIObjectGetEventTarget (
   HIObjectRef inObject){
//TODO
};


/*StandardAlert

Displays a standard alert box. 

OSErr StandardAlert (
   AlertType inAlertType,
   ConstStr255Param inError,
   ConstStr255Param inExplanation,
   const AlertStdAlertParamRec * inAlertParam,
   SInt16 * outItemHit
);
Parameters
inAlertType

A constant indicating the type of alert box you wish to create; see “Alert Type Constants”. 
inError

A pointer to a Pascal string containing the primary error text you wish to display. 
inExplanation

A pointer to a Pascal string containing the secondary text you wish to display; secondary text is displayed in the small system font. Pass null to indicate no secondary text.
inAlertParam

A pointer to the standard alert structure; see AlertStdAlertParamRec. Pass null to specify that you do not wish to your alert box to incorporate any of the features that the standard alert structure provides. 
outItemHit

A pointer to a signed 16-bit integer value. On return, the value indicates the alert button pressed; see “Alert Button Constants”. 
Return Value

A result code. See “Dialog Manager Result Codes”.
Discussion

The StandardAlert function displays an alert box based on the values you pass it. You can pass the error text you wish displayed in the error and explanation parameters, and customize the alert button text by filling in the appropriate fields of the standard alert structure passed in the inAlertParam parameter.

StandardAlert automatically resizes the height of a dialog box to fit all static text. It ignores alert stages and therefore provides no corresponding alert sounds. 
Special Considerations

This function is available with Appearance Manager 1.0 and later.
Availability
Available in CarbonLib 1.0 and later when Appearance 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/
OSErr StandardAlert (
   AlertType inAlertType,
   ConstStr255Param inError,
   ConstStr255Param inExplanation,
   const AlertStdAlertParamRec * inAlertParam,
   SInt16 * outItemHit){
//TODO
};

/*Draw1Control

Draws a control and any embedded controls that are currently visible in the specified window. 

void Draw1Control (
   ControlRef theControl
);
Parameters
theControl

A handle to the control to draw. For a description of this data type, see “ControlRef”.
Discussion

Although you should generally use the functionUpdateControls to update controls, you can use the DrawOneControl function to update a single control. If an embedding hierarchy exists and the control passed in has embedded controls, DrawOneControl draws the control and embedded controls. If the root control for a window is passed in, the result is the same as if DrawControls was called.

If you are using compositing mode, you generally do not need to call Draw1Control. If you call Draw1Control in compositing mode, keep in mind that it draws the specified control as well as all other controls that intersect the control.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
void Draw1Control (
   ControlRef theControl){
//TODO
};

/*SetDataBrowserCallbacks

Sets the callback routines to use with a data browser, replacing any previously installed callbacks.

OSStatus SetDataBrowserCallbacks (
   ControlRef browser,
   const DataBrowserCallbacks *callbacks
);
Parameters
browser

A data browser.
callbacks

A pointer to a DataBrowserCallbacks structure that is filled out with universal procedure pointers (UPPs) to the callback routines your application provides. At a minimum, you need to provide a UPP to an item-data callback (DataBrowserItemDataProcPtr).
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

Before calling the function SetDataBrowserCallbacks you must first call InitDataBrowserCallbacks to initialize the data browser callback structure. Calling SetDataBrowserCallbacks replaces any callback routines you installed previously by calling this function.

You can supply the following callbacks. If you don’t supply callbacks in cases for which it’s optional, you get the default behavior provided by the data browser API.
DataBrowserItemDataProcPtr. You must provide this callback because communicates the text, icons, or other data to display in list view. It also communicates the metadata that defines how data is displayed, such as whether or not an item is a container or has a parent. If you set up your data browser to allow the user to edit, this callback informs your application when the user makes a change.
DataBrowserItemCompareProcPtr. You must provide a sorting callback if you want users to be able to sort the items in a column. If you want containers in a hierarchical list to be sorted independently, then you must provide a sorting callback that handles the hierarchical lists appropriately.
DataBrowserItemNotificationProcPtr. You must provide this (or the next) callback if you have hierarchical data in a list, or if you use column view.
DataBrowserItemNotificationWithItemProcPtr (Mac OS X only)
DataBrowserAddDragItemProcPtr. You can provide this callback to allow dragging out of your data browser. 
DataBrowserAcceptDragProcPtr. You can provide this callback to allow dragging into your data browser; use this to accept a drag item.
DataBrowserReceiveDragProcPtr. You can provide this callback to allow dragging into your data browser; use this to receive a drag item.
DataBrowserPostProcessDragProcPtr. If you provide callbacks to allow dragging into your data browser, you can optionally provide a postprocess-drag callback to perform cleanup tasks.
DataBrowserGetContextualMenuProcPtr. You can optionally support a contextual menu. If so, you’ll need to provide the next callback too.
DataBrowserSelectContextualMenuProcPtr
DataBrowserItemHelpContentProcPtr. You can optionally provide help tags.

Note that this function sets a different set of callbacks from those that are set by calling the function SetDataBrowserCustomCallbacks.

To replace a callback, you first need to get the current set of callbacks by calling the function GetDataBrowserCallbacks. Set the appropriate fields in the DataBrowserCallbacks structure to your callback. Then you call the function SetDataBrowserCallbacks. Your application can set as many callbacks as appropriate. 

The following code shows how to assign UPPs to the callbacks structure and then call the function SetDataBrowserCallbacks. The code assumes you have already called the function InitDataBrowserCallbacks to initialize the data browser callback structure.myCallbacks.u.v1.itemNotificationCallback =
        NewDataBrowserItemNotificationUPP (MyItemNotificationCallback);
 
myCallbacks.u.v1.acceptDragCallback =
        NewDataBrowserAcceptDragUPP (MyAcceptDragCallback);
myCallbacks.u.v1.receiveDragCallback =
        NewDataBrowserReceiveDragUPP (MyReceiveDragCallback);
myCallbacks.u.v1.addDragItemCallback =
        NewDataBrowserAddDragItemUPP (MyAddDragItemCallback);
myCallbacks.u.v1.itemHelpContentCallback =
        NewDataBrowserItemHelpContentUPP (MyItemHelpContentCallback);
myCallbacks.u.v1.getContextualMenuCallback =
        NewDataBrowserGetContextualMenuUPP (MyGetContextualMenuCallback);
myCallbacks.u.v1.selectContextualMenuCallback =
        NewDataBrowserSelectContextualMenuUPP (
                    MySelectContextualMenuCallback);
SetDataBrowserCallbacks (browser, &myCallbacks);

Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus SetDataBrowserCallbacks (
   ControlRef browser,
   const DataBrowserCallbacks *callbacks){
//TODO
};

/*NewDataBrowserItemDataUPP

Creates a universal procedure pointer to an item-data callback function.

DataBrowserItemDataUPP NewDataBrowserItemDataUPP (
   DataBrowserItemDataProcPtr userRoutine
);
Parameters
userRoutine

A pointer to your item-data callback function.
Return Value

The universal procedure pointer.
Discussion

See the DataBrowserItemDataProcPtr callback function.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
DataBrowserItemDataUPP NewDataBrowserItemDataUPP (
   DataBrowserItemDataProcPtr userRoutine){
//TODO
};


/*InitDataBrowserCallbacks

Initializes a data browser callback structure in preparation for adding your own callbacks to the structure.

OSStatus InitDataBrowserCallbacks (
   DataBrowserCallbacks *callbacks
);
Parameters
callbacks

A pointer to a DataBrowserCallbacks structure. Before calling the function InitDataBrowserCallbacks, set the version field of this structure to kDataBrowserLatestCallbacks. On return, the fields in this structure are set to NULL.
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

After you call this function, set the appropriate fields in the DataBrowserCallbacks structure to your callbacks. The DataBrowserCallbacks structure contains fields for the following:
DataBrowserItemDataProcPtr
DataBrowserItemCompareProcPtr
DataBrowserItemNotificationProcPtr or DataBrowserItemNotificationWithItemProcPtr (Mac OS X only)
DataBrowserAddDragItemProcPtr
DataBrowserAcceptDragProcPtr
DataBrowserReceiveDragProcPtr
DataBrowserPostProcessDragProcPtr
DataBrowserGetContextualMenuProcPtr
DataBrowserSelectContextualMenuProcPtr
DataBrowserItemHelpContentProcPtr

After you assign your callbacks to the appropriate field, call the function SetDataBrowserCallbacks.

Note that this is a different set of callbacks from those that are assigned to fields in the DataBrowserCustomCallbacks data structure.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus InitDataBrowserCallbacks (
   DataBrowserCallbacks *callbacks){
//TODO
};

/*IsDataBrowserItemSelected

Checks to see if a data item is selected.

Boolean IsDataBrowserItemSelected (
   ControlRef browser,
   DataBrowserItemID item
);
Parameters
browser

A data browser.
item

The item ID of the item to check.
Return Value

A value of true if the item is a member of the current selection. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
Boolean IsDataBrowserItemSelected (
   ControlRef browser,
   DataBrowserItemID item){
//TODO
};

/*GetControlValue

Obtains a control’s current setting. (Deprecated. Use GetControl32BitValue instead.)

Not recommended

SInt16 GetControlValue (
   ControlRef theControl
);
Parameters
theControl

On input, a handle to a control. 
Return Value

The current setting of the control. 
Discussion

When you create a control, you specify an initial setting either in the control resource or in the value parameter of the function NewControl. You can change the setting by calling SetControlValue.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/

SInt16 GetControlValue (
   ControlRef theControl){
//TODO
};

/*SetDataBrowserItemDataText

Specifies the text to draw.

OSStatus SetDataBrowserItemDataText (
   DataBrowserItemDataRef itemData,
   CFStringRef theData
);
Parameters
itemData

The item data reference for the item whose text you want to set. This value is passed to the callback routine from which you are calling the function SetDataBrowserItemDataText. 
theData

The CFString object that contains the text you want to draw. You are responsible for releasing the CFString object.
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

You call the function SetDataBrowserItemDataText from inside a data callback routine when the item being drawn is inside a column that has the kDataBrowserTextType display type or the kDataBrowserIconAndTextType display type. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus SetDataBrowserItemDataText (
   DataBrowserItemDataRef itemData,
   CFStringRef theData){
//TODO
};

/*AddDataBrowserItems

Adds one or more items to a data browser. 

OSStatus AddDataBrowserItems (
   ControlRef browser,
   DataBrowserItemID container,
   UInt32 numItems,
   const DataBrowserItemID *items,
   DataBrowserPropertyID preSortProperty
);
Parameters
browser

A data browser.
container

An item ID or the constant kDataBrowserNoItem. Pass the item ID that uniquely identifies the container to which you want to add items. Adding one or more items to an existing container opens the container. If you a pass kDataBrowserNoItem, the items are added to the root container.
numItems

The number of items in the array pointed to by the items parameter.
items

A pointer to an array of item ID values for the items you want to add to the data browser. You supply item ID values based on your own identification scheme. If you pass NULL, each time you call AddDataBrowserItems the data browser generates item ID values starting at 1. Calling the function in this way clears whatever items are in the container. Because of this clearing behavior, passing NULL is not recommended unless your application uses a data browser to display a simple list that is populated only once with data.
preSortProperty

The property ID of the column whose sorting order matches the sorting order of the items array. A property ID is a four-character sequence that you assign to represent a column in list view. Pass kDataBrowserItemNoProperty if the items array is not sorted or if you don’t know the sorting order of your data. You’ll get the best performance from this function if you provide a sorting order. 
Return Value

A result code. If the item ID specified by the container parameter is not classified as a container, returns errDataBrowserItemNotAdded if you attempt to add subitems to it. See “Data Browser Result Codes”.
Discussion

Hierarchical lists are constructed in a top-down fashion. Your application must install all the top-level, or parent, item IDs in the data browser before it associates a list of item ID values as subitems. You can add items to a parent item only after the parent item is classified as a container. A container is an item for which the property kDataBrowserItemIsContainerProperty is set to true. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus AddDataBrowserItems (
   ControlRef browser,
   DataBrowserItemID container,
   UInt32 numItems,
   const DataBrowserItemID *items,
   DataBrowserPropertyID preSortProperty){
//TODO
};

/*SetMenuBar

Sets the current menu list to a specified menu list.

void SetMenuBar (
   MenuBarHandle mbar
);
Parameters
mbar

A handle to a menu list that specifies the menus for a menu bar. You should specify a handle returned by GetMenuBar or GetNewMBar. 
Discussion

The SetMenuBar function copies the given menu list to the current menu list. As with GetMenuBar , SetMenuBar doesn’t copy the menu structures, just the menu list (which contains handles to the menu structures).

You can use SetMenuBar to restore a menu list that you previously saved using GetMenuBar or to set the current menu list to a menu list created from a nib file or from GetNewMBar. 

The SetMenuBar function sets the current menu list and calls InvalMenuBar so the menu bar can be updated the next time through the event loop; if you want to redraw the menu bar immediately, call the DrawMenuBar function. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/

void SetMenuBar (
   MenuBarHandle mbar){
//TODO
};

/*RemoveDataBrowserItems

Removes one or more items from a data browser.

OSStatus RemoveDataBrowserItems (
   ControlRef browser,
   DataBrowserItemID container,
   UInt32 numItems,
   const DataBrowserItemID *items,
   DataBrowserPropertyID preSortProperty
);
Parameters
browser

A data browser.
container

An item ID or the constant kDataBrowserNoItem. Pass the item ID that uniquely identifies the container from which you want to remove items. Pass kDataBrowserNoItem to remove items from the root container.
numItems

The number of items in the array pointed to by the items parameter. To remove all items pass 0 and also pass NULL in the items parameter.
items

A pointer to an array of item ID values for the items you want to remove from the data browser. You can delete an arbitrary list of items from a container. To remove all items, pass NULL, and also pass 0 in the numItems parameter. 
preSortProperty

The property ID of the column whose sorting order is the same as the sorting order of the items array. A property ID is a value that identifies a column independent of its position in a data browser. Pass kDataBrowserItemNoProperty if the items array is not sorted or if you don’t know the sorting order. You’ll get the best performance from this function if you provide a sorting order.
Return Value

A result code. See “Data Browser Result Codes”.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus RemoveDataBrowserItems (
   ControlRef browser,
   DataBrowserItemID container,
   UInt32 numItems,
   const DataBrowserItemID *items,
   DataBrowserPropertyID preSortProperty){
//TODO
};

/*CreateMenuBarFromNib

Unarchives a menu bar from a nib file.

OSStatus CreateMenuBarFromNib (
   IBNibRef inNibRef,
   CFStringRef inName,
   Handle * outMenuBar
);
Parameters
inNibRef

A reference to the nib file that contains the menu bar you want to unarchive. You obtain this reference by calling the function CreateNibReference or CreateNibReferenceWithCFBundle.
inName

A CFStringRef that denotes the menu bar you want to unarchive. This is the name you supplied to the menu bar in the Instances pane of Interface Builder. See the Base Services documentation for a description of the CFStringRef data type. You can use the Core Foundation function CFSTR to convert a string to a CFString.
outMenuBar

On output, points to a handle to the menu bar. 
Return Value

A result code. See Runtime Errors.
Discussion

You need to call the Menu Manager function SetMenuBarFromNib to make the unarchived menu bar available in your application. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X 10.0 and later.
Declared In
IBCarbonRuntime.h*/
OSStatus CreateMenuBarFromNib (
   IBNibRef inNibRef,
   CFStringRef inName,
   Handle * outMenuBar){
//TODO
};


/*AESend

Sends the specified Apple event.

OSErr AESend (
   const AppleEvent * theAppleEvent,
   AppleEvent * reply,
   AESendMode sendMode,
   AESendPriority sendPriority,
   long timeOutInTicks,
   AEIdleUPP idleProc,
   AEFilterUPP filterProc
);
Parameters
theAppleEvent

A pointer to the Apple event to send. See AppleEvent.
reply

A pointer to a reply Apple event. On return, contains the reply Apple event from the server application, if you specified the kAEWaitReply flag in the sendMode parameter. If you specify the kAEQueueReply flag in the sendMode parameter, you receive the reply Apple event in your event queue. If you specify kAENoReply flag, the reply Apple event is a null descriptor (one with descriptor type typeNull). If you specify kAEWaitReply in the sendMode parameter, and if the function returns successfully (see function result below), your application is responsible for using the AEDisposeDesc function to dispose of the descriptor returned in the reply parameter.
sendMode

Specifies various options for how the server application should handle the Apple event. To obtain a value for this parameter, you add together constants to set bits that specify the reply mode, the interaction level, the application switch mode, the reconnection mode, and the return receipt mode. For more information, see AESendMode.
sendPriority

See the Version Notes section below for important information. A value that specifies the priority for processing the Apple event. You can specify normal or high priority, using the constants described in AESendMode. See AESendPriority.
timeOutInTicks

If the reply mode specified in the sendMode parameter is kAEWaitReply, or if a return receipt is requested, this parameter specifies the length of time (in ticks) that the client application is willing to wait for the reply or return receipt from the server application before timing out. Most applications should use the kAEDefaultTimeout constant, which tells the Apple Event Manager to provide an appropriate timeout duration. If the value of this parameter is kNoTimeOut, the Apple event never times out. These constants are described in “Timeout Constants”.
idleProc

A universal procedure pointer to a function that handles events (such as update, operating-system, activate, and null events) that your application receives while waiting for a reply. Your idle function can also perform other tasks (such as displaying a wristwatch or spinning beach ball cursor) while waiting for a reply or a return receipt.

If your application specifies the kAEWaitReply flag in the sendMode parameter and you wish your application to get periodic time while waiting for the reply to return, you must provide an idle function. Otherwise, you can pass a value of NULL for this parameter. For more information on the idle function, see AEIdleProcPtr.
filterProc

A universal procedure pointer to a function that determines which incoming Apple events should be received while the handler waits for a reply or a return receipt. If your application doesn’t need to filter Apple events, you can pass a value of NULL for this parameter. If you do so, no application-oriented Apple events are processed while waiting. For more information on the filter function, see AEFilterProcPtr.
Return Value

A result code. See “Apple Event Manager Result Codes”. The AESend function returns noErr if the Event Manager successfully sends the Apple event—this value does not indicate that the Apple event was handled successfully. If the handler returns a result code other than noErr, and if the client is waiting for a reply, AESend returns the result code in the keyErrorNumber parameter of the reply Apple event. For a result code other than noErr, you should not call the AEDisposeDesc function to dispose of the descriptor returned in the reply parameter, because the descriptor is invalid.
Discussion

You typically create an Apple event to send with the AECreateAppleEvent function and add information to it with the functions described in “Adding Parameters and Attributes to an Apple Event”.

If the Apple Event Manager cannot find a handler for the Apple event in the server application’s dispatch table or in the system dispatch table, it returns the result code errAEEventNotHandled to the server application (as the result of the AEProcessAppleEvent function). If the client application is waiting for a reply, the Apple Event Manager also returns this result code to the client in the keyErrorNumber parameter of the reply event.

In addition to specifying the wait duration for replies, the timeOutInTicks parameter is used as a wait value when queuing events for other applications. The Apple Event Manager waits for the specified duration as it attempts to queue the event. If you specify kAEWaitReply and the target application quits or crashes after the event is queued but before the reply is returned, the Apple Event Manager returns a sessionClosedErr result code. 

In some situations, there are advantages to sending Apple events with the AESendMessage function. That function requires less overhead than AESend and it allows you to send Apple events while linking with just the Application Services framework, and not the entire Carbon framework (and window server), as required by AESend. For more information on sending Apple events, see “Sending an Apple Event” in Apple Events Programming Guide.
Version Notes

In Mac OS 9 and earlier, you use the sendMode parameter to specify how the server should handle the Apple event. AESendMode provides a complete description of the constants you use with this parameter. The sendPriority parameter is deprecated in Mac OS X and later.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AEInteraction.h*/
OSErr AESend (
   const AppleEvent * theAppleEvent,
   AppleEvent * reply,
   AESendMode sendMode,
   AESendPriority sendPriority,
   long timeOutInTicks,
   AEIdleUPP idleProc,
   AEFilterUPP filterProc){
//TODO
};


/*GetApplicationTextEncoding

Returns the application text encoding for Resource Manager resources.

TextEncoding GetApplicationTextEncoding ();
Return Value

See the Text Encoding Conversion Manager documentation for a description of the TextEncoding data type.
Discussion

Your application needs to use the application text encoding when it creates a CFStringRef from text stored in Resource Manager resources. Typically the text uses a Mac encoding such as MacRoman or MacJapanese. 
Availability
Available in CarbonLib 1.2 and later.
Available in Mac OS X 10.0 and later.
Declared In
MacApplication.h*/
TextEncoding GetApplicationTextEncoding (){
//TODO
};

/*SetControlMaximum

Changes the maximum setting of a control and redraws its indicator or scroll box accordingly. (Deprecated. Use SetControl32BitMaximum instead.)

Not recommended

void SetControlMaximum (
   ControlRef theControl,
   SInt16 newMaximum
);
Parameters
theControl

A handle to the control whose maximum setting you wish to change. 
newMaximum

The new maximum setting. 
Discussion

The SetControlMaximum function changes the maximum value of a control to the value specified by the newMaximum parameter and redraws its indicator or scroll box to reflect its new range.

When you set the maximum setting of a scroll bar equal to its minimum setting, the control definition function makes the scroll bar inactive. When you make the maximum setting exceed the minimum, the control definition function makes the scroll bar active again.

When you create a control, you specify an initial maximum setting either in the control resource or in the max parameter of the function NewControl. To determine a control’s current maximum setting, use the function GetControlMaximum. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
void SetControlMaximum (
   ControlRef theControl,
   SInt16 newMaximum){
//TODO
};


/*SetControlMinimum

Changes the minimum setting of a control and redraws its indicator or scroll box accordingly. (Deprecated. Use SetControl32BitMinimum instead.)

Not recommended

void SetControlMinimum (
   ControlRef theControl,
   SInt16 newMinimum
);
Parameters
theControl

A handle to the control whose minimum setting you wish to change. For a description of this data type, see “ControlRef”.
newMinimum

The new minimum setting.
Discussion

The SetControlMinimum function changes the control’s minimum value to the value specified by the newMinimum parameter and redraws its indicator or scroll box to reflect its new range.

When you create a control, you specify an initial minimum setting either in the control resource or in the min parameter of the NewControl function. To obtain a control’s current minimum setting, use the function GetControlMinimum. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
void SetControlMinimum (
   ControlRef theControl,
   SInt16 newMinimum){
//TODO
};


/*CountMenuItems

Obtains the number of menu items in a menu

UInt16 CountMenuItems (
   MenuRef theMenu
);
Parameters
theMenu

The menu whose items you want to count. 
Return Value

The number of menu items in the menu.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
UInt16 CountMenuItems (
   MenuRef theMenu){
//TODO
};

/*AppendDialogItemList

Adds items to an existing dialog box while your program is running.

OSErr AppendDialogItemList (
   DialogRef dialog,
   SInt16 ditlID,
   DITLMethod method
);
Parameters
dialog

A pointer to the dialog box to which the items in the item list resource specified in the ditlID parameter are to be appended. 
ditlID

The resource ID of the item list resource whose items are to be appended to the dialog box specified in the dialog parameter. 
method

The manner in which the new items are to be displayed in the dialog box.

If you use the overlayDITL constant, AppendDialogItemList superimposes the appended items over the dialog box by interpreting the coordinates of the display rectangles for the appended items (as specified in their item list resource) as local coordinates within the dialog box.

If you use the appendDITLRight constant, AppendDialogItemList appends the items to the right of the dialog box by positioning the display rectangles of the appended items relative to the upper-right coordinate of the dialog box. The AppendDialogItemList function automatically expands the dialog box to accommodate the new dialog items.

If you use the appendDITLBottom constant, AppendDialogItemList appends the items to the bottom of the dialog box by positioning the display rectangles of the appended items relative to the lower-left coordinate of the dialog box. The AppendDialogItemList function automatically expands the dialog box to accommodate the new dialog items.

You can append a list of items relative to an existing item by passing a negative number. The absolute value of this number is interpreted as the item in the dialog box relative to which the new items are to be positioned. For example, if you pass -2, the display rectangles of the appended items are offset relative to the upper-left corner of item number 2 in the dialog box.

Return Value

A result code. See “Dialog Manager Result Codes”.
Discussion

To be Appearance-compliant, your program should use the AppendDialogItemList function rather than the AppendDITL function. Unlike AppendDITL, the AppendDialogItemList function takes a 'DITL' resource ID instead of a handle as the parameter describing the dialog item list to be appended, and it properly appends entries from a dialog font table ( 'dftb') resource, if there is a 'dftb' resource with the same resource ID as the 'DITL' resource.

The AppendDialogItemList function adds the items in the item list resource specified in the parameter ditlID to the items of a dialog box. This is especially useful if several dialog boxes share a single item list resource, because you can use AppendDialogItemList to add items that are appropriate for individual dialog boxes. Your application can use the Resource Manager function GetResource to get a handle to the item list resource whose items you wish to add.

You typically create an invisible dialog box, call the AppendDialogItemList function, then make the dialog box visible by using the Window Manager function ShowWindow. 
Version Notes

This function is available with Appearance Manager 1.0 and later.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/
OSErr AppendDialogItemList (
   DialogRef dialog,
   SInt16 ditlID,
   DITLMethod method){
//TODO
};


/*CreateWindowFromNib

Unarchives a window from a nib file.

OSStatus CreateWindowFromNib (
   IBNibRef inNibRef,
   CFStringRef inName,
   WindowRef *outWindow
);
Parameters
inNibRef

A reference to the nib file that contains the window you want to unarchive. You obtain this reference by calling the function CreateNibReference or CreateNibReferenceWithCFBundle.
inName

A CFStringRef that denotes the window you want to unarchive. This is the name you supplied to the window in the Instances pane of Interface Builder. See the Base Services documentation for a description of the CFStringRef data type. You can use the Core Foundation function CFSTR to convert a string to a CFString. 
outWindow

On output, points to the window unarchived from the nib file.
Return Value

A result code. See Runtime Errors.
Discussion

You need to call the Window Manager function ShowWindow to make the unarchived window visible. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X 10.0 and later.
Declared In
IBCarbonRuntime.h*/
OSStatus CreateWindowFromNib (IBNibRef inNibRef,CFStringRef inName, WindowRef *outWindow){
//TODO
};


/*SetControl32BitMaximum

Changes the maximum setting of a control and, if appropriate, redraws it accordingly.

void SetControl32BitMaximum (
   ControlRef theControl,
   SInt32 newMaximum
);
Parameters
theControl

A handle to the control whose maximum setting you wish to change. For a description of this data type, see “ControlRef”.
newMaximum

The new maximum setting of the control. In general, to avoid unpredictable behavior, do not set the maximum control value lower than the current minimum value. 
Discussion

Your application may use the SetControl32BitMaximum function to set a 32-bit value as the maximum setting for a control.

If your application uses a 32-bit control maximum value, it should not attempt to obtain this value by calling the pre–Mac OS 8.5 function GetControlMaximum because the 16-bit value that is returned does not accurately reflect the current 32-bit control value. Instead, use the function GetControl32BitMaximum.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
void SetControl32BitMaximum (
   ControlRef theControl,
   SInt32 newMaximum){
//TODO
};

/*TXNGetDataEncoded

Copies the text in a specified range, and if necessary, translates the text to match your application’s preferred encoding. 

OSStatus TXNGetDataEncoded (
   TXNObject iTXNObject,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset,
   Handle * oDataHandle,
   TXNDataType iEncoding
);
Parameters
iTXNObject

The text object that contains the data you want to copy.
iStartOffset

The absolute offset from which data copying should begin. You can use the TXNGetSelection function to get the absolute offsets of the current selection. 
iEndOffset

The absolute offset at which data copying should end. You can use the TXNGetSelection function to get the absolute offsets of the current selection.
oDataHandle

A pointer to a handle. On return, a handle to the requested data. TXNGetDataEncoded allocates the handle as necessary. Your application must dispose of the handle. If there is no text in the range specified, the returned handle is NULL, and the function returns noErr.
encoding

The type of data to be encoded. See Supported Data Types for a full description of possible values. You should specify either the kTXNTextData or kTXNUnicodeTextData constant. If the iEncoding parameter specifies an encoding different from that used to store the text data internally, the Conversion Manager translates the data to the specified type (text or Unicode). If the iEncoding parameter is not recognized, the data is returned in the current encoding. On systems that do not use ATSUI version 1.1 or later, the current encoding is the Mac OS encoding. Otherwise, the current encoding is Unicode. 
Return Value

A result code. See “MLTE Result Codes”.
Discussion

Offsets in MLTE are always character offsets. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNGetDataEncoded (
   TXNObject iTXNObject,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset,
   Handle * oDataHandle,
   TXNDataType iEncoding){
//TODO
};

/*InstallEventHandler

Installs an event handler on a specified event target. 

OSStatus InstallEventHandler (
   EventTargetRef inTarget,
   EventHandlerUPP inHandler,
   UInt32 inNumTypes,
   const EventTypeSpec * inList,
   void * inUserData,
   EventHandlerRef * outRef
);
Parameters
inTarget

The event target to register your handler with. 
inHandler

A pointer to your event handler function. 
inNumTypes

The number of events you are registering for. 
inList

A pointer to an array of EventTypeSpec entries representing the events you are interested in. 
inUserData

The value you pass in this parameter is passed to your event handler function when it is called.
outRef

On return, an event handler reference, which you can use later to remove the handler. You can pass NULL if you don’t want the reference—when the target is disposed, the handler is disposed as well. 
Return Value

A result code. See “Carbon Event Manager Result Codes”. 
Discussion

After being installed, your handler will be called when an event you registered for is sent to the specified event target. Note that CarbonEvents.h defines several macros which you can use for particular event classes. These macros simply combine the appropriate GetxxxEventTarget call with InstallEventHandler.
InstallApplicationEventHandler
InstallWindowEventHandler
InstallControlEventHandler
InstallMenuEventHandler
InstallHIObjectEventHandler (in Mac OS X v10.2 and later)
HIViewInstallEventHandler (in Mac OS X v10.2 and later)

Be sure to remove the event handler when you no longer need it by callling RemoveEventHandler. Doing so is especially important if the handler calls code that may disappear. For example, if a plugin installs an event handler and is later removed without removing the handler, the system may attempt to call back to the now nonexistent plugin code.
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
OSStatus InstallEventHandler (
   EventTargetRef inTarget,
   EventHandlerUPP inHandler,
   UInt32 inNumTypes,
   const EventTypeSpec * inList,
   void * inUserData,
   EventHandlerRef * outRef){
//TODO
};



/*GetApplicationEventTarget

Obtains the event target reference for the application.

EventTargetRef GetApplicationEventTarget ();
Return Value

An event target reference. 
Discussion

Once you obtain this reference, you can send events to the target and install event handlers on it. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/
EventTargetRef GetApplicationEventTarget (){
//TODO
};


/*GetEventParameter

Obtains a parameter from the specified event. 

OSStatus GetEventParameter (
   EventRef inEvent,
   EventParamName inName,
   EventParamType inDesiredType,
   EventParamType * outActualType,
   UInt32 inBufferSize,
   UInt32 * outActualSize,
   void * outData
);
Parameters
inEvent

The event to get the parameter from. 
inName

The symbolic name of the parameter (for example, kEventParamDirectObject). The Carbon Event Manager defines a number of constants defining possible parameters. 
inDesiredType

The desired type of the parameter (for example, typeWindowRef). The Carbon Event Manager automatically uses AppleEvent coercion handlers to convert the data in the event into the desired type, if possible. The Carbon Event Manager defines a number of constants to indicate possible parameter types. Pass typeWildCard to request that the data be returned in its original format. 
outActualType

The actual type of the parameter (can be NULL if you are not interested in receiving this information).
inBufferSize

The size of the output buffer. 
outActualSize

The actual size of the data, or NULL if you don’t want this information.
outData

The pointer to the buffer receiving the parameter data.
Return Value

A result code. See “Carbon Event Manager Result Codes”. 
Discussion

Events often contain additional useful pieces of data, such as the location of a mouse-down event or the window in which an event occurred. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
OSStatus GetEventParameter (
   EventRef inEvent,
   EventParamName inName,
   EventParamType inDesiredType,
   EventParamType * outActualType,
   UInt32 inBufferSize,
   UInt32 * outActualSize,
   void * outData){
//TODO
};



/*CreateEvent

Creates an event.

OSStatus CreateEvent (
   CFAllocatorRef inAllocator,
   UInt32 inClassID,
   UInt32 kind,
   EventTime when,
   EventAttributes flags,
   EventRef * outEvent
);
Parameters
inAllocator

A reference to the desired memory allocator to use to allocate memory for the event. Pass NULL to use the default allocator. See the Base Services documentation for a description of the CFAllocatorRef data type.
inClassID

The event class of the event to create.
kind

The event kind of the event to create. 
when

The time the event occurred. Pass 0 to specify the current event time (as returned by the GetCurrentEventTime function). 
flags

The event attributes to set. Currently you can pass kEventAttributeNone or kEventAttributeUserEvent. 
outEvent

On return, a reference to the newly created event. 
Return Value

A result code. See “Carbon Event Manager Result Codes”.
Discussion

You can use this function to create your own custom events or to simulate existing events. If you are creating custom events, you must make sure that the event signature (the combination of event class and event kind) does not conflict with any existing events. 
Declared In
CarbonEventsCore.h*/
OSStatus CreateEvent (
   CFAllocatorRef inAllocator,
   UInt32 inClassID,
   UInt32 kind,
   EventTime when,
   EventAttributes flags,
   EventRef * outEvent){
//TODO
};


/*GetCurrentEventTime

Returns the current time since last system startup, in seconds. 

EventTime GetCurrentEventTime ();
Return Value

EventTime. 
Discussion

Returns the current time since last system startup in seconds. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
EventTime GetCurrentEventTime (){
//TODO
};


/*SetEventParameter

Sets a parameter associated with a particular event. 

OSStatus SetEventParameter (
   EventRef inEvent,
   EventParamName inName,
   EventParamType inType,
   UInt32 inSize,
   const void * inDataPtr
);
Parameters
inEvent

The event to set the data for. 
inName

The symbolic name of the parameter. 
inType

The symbolic type of the parameter. 
inSize

The size of the parameter data. 
inDataPtr

A pointer to the parameter data.
Return Value

A result code. See “Carbon Event Manager Result Codes”.
Discussion

When creating events, you may want to specify additional event-related information, such as the mouse location or the window in which the event occurred. To set these you call SetEventParameter, specifying the type and value for the desired parameter. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
OSStatus SetEventParameter (
   EventRef inEvent,
   EventParamName inName,
   EventParamType inType,
   UInt32 inSize,
   const void * inDataPtr){
//TODO
};


/*ReleaseEvent

Releases, and possibly disposes of, the specified event.

void ReleaseEvent (
   EventRef inEvent
);
Parameters
inEvent

The event to release.
Discussion

This function decrements the reference count of an event. If the reference count reaches 0, the event is disposed. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
void ReleaseEvent (
   EventRef inEvent){
//TODO
};

/*HITextViewGetTXNObject

Obtains the text object associated with an HITextView.

TXNObject HITextViewGetTXNObject(
   HIViewRef inTextView)
);
Parameters
inTextView

The HITextView associated with the text object you want to retrieve.
Return Value

Returns the text object associated with the given view.
Discussion

You can supply the extracted text object as a parameter to many of the MLTE functions that take a text object as a parameter. However, not all MLTE functions that take a text object can operate on an MLTE object that comes from an HITextView. In general, you cannot use MLTE functions that may alter the geometry of the object or explicitly invoke drawing. If you do, the function returns the result code kTXNDisabledFunctionalityErr. See HITextViewCreate for a list of the functions that return an error if you pass a text object that comes from an HITextView.
Availability
Available in Mac OS X v10.3 and later.
Declared In
MacTextEditor.h*/
TXNObject HITextViewGetTXNObject(
   HIViewRef inTextView){
//TODO
};

/*TXNSetData

Replaces a range of data (text, graphics, and so forth).

OSStatus TXNSetData (
   TXNObject iTXNObject,
   TXNDataType iDataType,
   const void * iDataPtr,
   ByteCount iDataSize,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset
);
Parameters
iTXNObject

The text object that identifies the document in which you want to replace data.
iDataType

The type of the replacement data. See Supported Data Types for a description of possible values. 
iDataPtr

A pointer to the data that will replace the data that is in the range specified by the iStartOffset and iEndOffset parameters.
iDataSize

The size of the data (in bytes) to which iDataPtr points.
iStartOffset

The beginning of the range of data to replace. You can use the TXNGetSelection function to get the absolute offsets of the current selection. 
iEndOffset

The end of the range to replace. You can use the TXNGetSelection function to get the absolute offsets of the current selection. If you want to insert text, the ending and starting offsets should be the same value.
Return Value

A result code. See “MLTE Result Codes”.
Discussion

If you have a text object that has word wrap disabled, and you want to avoid horizontal scrolling, you can try the following. After you call the function TXNSetData, call TXNSetSelection with the value of the ending offset set to what it was before you called TXNSetData. Then, call the function TXNShowSelection to scroll the text back into view.

Offsets in MLTE are always character offsets. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNSetData (
   TXNObject iTXNObject,
   TXNDataType iDataType,
   const void * iDataPtr,
   ByteCount iDataSize,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset){
//TODO
};


/*TXNSetDataFromCFURLRef

Replaces a range of data with the contents of a file. (Deprecated in Mac OS X v10.4. Use TXNReadFromCFURL instead.)

Not recommended.

OSStatus TXNSetDataFromCFURLRef (
   TXNObject   iTXNObject,
   CFURLRef    iURL,
   TXNOffset   iStartOffset,
   TXNOffset   iEndOffset
);
Parameters
iTXNObject

The text object that identifies the document in which you want to replace data. You can either call the function TXNCreateObject to allocate a text object or you can call the function HITextViewGetTXNObject to obtain the text object associated with an HITextView. 
iURL

A reference to the Core Foundation URL that specifies the file which contains the data you want to add to the object. 
iStartOffset

The starting position at which to insert the file into the document. If you want to replace the current selection, set the iStartOffset parameter to kTXNCurrentSelection. If you want to replace the entire document, set the iStartOffset parameter to 0. Offsets in MLTE are always character offsets.
iEndOffset

The ending position of the range being replaced by the file. You can use the TXNGetSelection function to get the absolute offsets of the current selection. Offsets in MLTE are always character offsets.
Return Value

A result code. See “MLTE Result Codes”.
Discussion

Your application must open the file and set the iStartOffset parameter to the appropriate value before you call the TXNSetDataFromCFURLRef function. If you want to embed MLTE data within private data or other MLTE data, you must set the file position to the appropriate position.

In the (now deprecated) function TXNNewObject your could pass a file reference and MLTE supported functionality to revert back to the original file reference. When you call the function TXNSetDataFromURLRef, MLTE saves the CFURLRef. If you change the contents of the text object and then call the function TXNRevert, the document reverts to the contents specified by the saved CFURLRef.
Availability
Available in Mac OS X v10.3 and later.
Deprecated in Mac OS X v10.4.
Declared In
MacTextEditor.h*/
OSStatus TXNSetDataFromCFURLRef (
   TXNObject   iTXNObject,
   CFURLRef    iURL,
   TXNOffset   iStartOffset,
   TXNOffset   iEndOffset){
//TODO
};

/*TXNSetSelection

Specifies the selection range or the position of the insertion point. 

OSStatus TXNSetSelection (
   TXNObject iTXNObject,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset
);
Parameters
iTXNObject

The text object that identifies the document for which you want to set the selection range or insertion point position. 
iStartOffset

The new starting offset. Offset values are character offsets. 
iEndOffset

The new ending offset. Offset values are character offsets.
Return Value

A result code. See “MLTE Result Codes”.
Discussion

You can use the TXNSetSelection function to highlight an initial default value in a document, such as a data-entry form, or to position the insertion point at the start of the field where you want the user to enter a value. To position the insertion point, specify the same value for the iStartOffset and iEndOffset parameters. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNSetSelection (
   TXNObject iTXNObject,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset){
//TODO
};

/*TXNShowSelection

Scrolls the current selection into view.

void TXNShowSelection (
   TXNObject iTXNObject,
   Boolean iShowEnd
);
Parameters
iTXNObject

The text object for the current text area. 
iShowEnd

A Boolean value. If you set this to true, the end of the selection is scrolled into view. Otherwise, the beginning of the selection is scrolled into view. 
Discussion

You can use this to scroll text into view after you have called the TXNFind function and the matching text is not in the current view of the text object. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
void TXNShowSelection (
   TXNObject iTXNObject,
   Boolean iShowEnd){
//TODO
};

/*SetWindowTitleWithCFString

Sets the window title to the contents of a Core Foundation string. 

OSStatus SetWindowTitleWithCFString (
   WindowRef inWindow,
   CFStringRef inString
);
Parameters
inWindow

The window whose title is to be set.
inString

The title to set. 
Return Value

A result code. See “Window Manager Result Codes”.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus SetWindowTitleWithCFString (
   WindowRef inWindow,
   CFStringRef inString){
//TODO
};


/*DisposeWindow

Removes a window.

void DisposeWindow (
   WindowRef window
);
Parameters
window

On input, the window to be closed.
Discussion

The DisposeWindow function reduces a window’s reference count by one. If the resulting reference count is zero, then DisposeWindow removes the window from the screen and deletes it from the window list, then releases the memory occupied by all structures associated with the window, including the window structure. 

Note that DisposeWindow assumes that any picture pointed to by the window structure field windowPic is data, not a resource, and it calls the QuickDraw function KillPicture to delete it. If your application uses a picture stored as a resource, you must release the resource or release the memory it occupies with the ReleaseResource function and set the windowPic field to NULL before closing the window.

Any pending update events for the window are discarded. If the window being removed is the frontmost window, the window behind it, if any, becomes the active window. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
void DisposeWindow (WindowRef window){
//TODO
};


/*GetControlByID

Finds a control in a window by its unique ID.

OSStatus GetControlByID (
   WindowRef inWindow,
   const ControlID * inID,
   ControlRef * outControl
);
Parameters
inWindow

The window to query.
inID

The control ID.
outControl

A pointer to a value of type ControlRef that, on output, is filled in with the control reference for the control specified by inID. For a description of this data type, see “ControlRef”.
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

As of Mac OS X v10.3, this function is superseded by the HIViewFindByID function, which is preferred over the GetControlByID function. The first parameter to the HIViewFindByID function is a view and not a window, so you can start the search at any point in the hierarchy.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
OSStatus GetControlByID (
   WindowRef inWindow,
   const ControlID * inID,
   ControlRef * outControl){
//TODO
};


/*GetWindowEventTarget

Obtains the event target reference for a specified window. 

EventTargetRef GetWindowEventTarget (
   WindowRef inWindow
);
Parameters
inWindow

The window to return the event target for. See the QuickDraw Manager documentation for a description of the WindowRef data type.
Return Value

An event target reference. 
Discussion

Once you obtain this reference, you can send events to the target and install an event handler on it. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/
EventTargetRef GetWindowEventTarget (
   WindowRef inWindow){
//TODO
};


/*HIViewFindByID

Obtains a view by its ID. 

OSStatus HIViewFindByID (
   HIViewRef inStartView,
   HIViewID inID,
   HIViewRef * outControl
);
Parameters
inStartView

The view to start searching at. 
inID

The ID of the view you are looking for. 
outControl

Receives the control if found. 
Return Value

An operating system result code.
Discussion

Allows you to find a particular view by its ID. The HIViewID type used by this function is identical to the ControlID type used by the Control Manager.
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus HIViewFindByID (
   HIViewRef inStartView,
   HIViewID inID,
   HIViewRef * outControl){
//TODO
};


/*HIViewGetRoot

Obtains the root view for a window. 

HIViewRef HIViewGetRoot (
   WindowRef inWindow
);
Parameters
inWindow

The window to get the root for.
Return Value

The root view for the window, or NULL if an invalid window is passed.
Discussion

Note that the root view is not the same as the Control Manager root control.
Availability
Available in Mac OS X v10.2 and later.*/

HIViewRef HIViewGetRoot (
   WindowRef inWindow){
//TODO
};


/*SetWindowProxyFSSpec

Associates a file with a window.

Not recommended

OSStatus SetWindowProxyFSSpec (
   WindowRef window,
   const FSSpec * inFile
);
Parameters
window

A pointer to the window with which the specified file is to be associated. 
inFile

Set the file system specification structure to contain the data for the file to associate with the specified window. You can obtain an FSSpec structure by calling the function GetWindowProxyFSSpec. 
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

Your application should call the SetWindowProxyFSSpec function to establish a proxy icon for a given window. The creator code and file type of the file associated with a window determine the proxy icon that is displayed for the window.

Because the SetWindowProxyFSSpec function won’t work without a saved file, you must establish the initial proxy icon for a new, untitled window with the function SetWindowProxyCreatorAndType , which requires that you know the file type and creator code for the file, but does not require that the file have been saved.

See also the function SetWindowProxyAlias. 
Special Considerations

With Mac OS 8.5, you must save and restore the current graphics port—by calling the QuickDraw functions GetPort and SetPort—around each call to the SetWindowProxyFSSpec function.
Version Notes

This function is available with Mac OS 8.5 and later.
Availability
Not recommended. Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes

Use of file specifications is no longer recommended. An alternate API that uses FSRef types is preferred.
Declared In
MacWindows.h*/

OSStatus SetWindowProxyFSSpec (
   WindowRef window,
   const FSSpec * inFile){
//TODO
};




/*SendEventToEventTarget

Sends an event to the specified event target. 

OSStatus SendEventToEventTarget (
   EventRef inEvent,
   EventTargetRef inTarget
);
Parameters
inEvent

The event to send. 
inTarget

The target to send it to. 
Return Value

A result code. See “Carbon Event Manager Result Codes”.
Discussion

If you are creating your own events, you can dispatch them immediately to an event target by calling this function. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/

OSStatus SendEventToEventTarget (
   EventRef inEvent,
   EventTargetRef inTarget){
//TODO
};


/*DisposeNibReference

Disposes of a nib reference.

void DisposeNibReference (
   IBNibRef inNibRef
);
Parameters
inNibRef

A nib reference you created by calling the function CreateNibReference or CreateNibReferenceWithCFBundle.
Return Value
Discussion

You should call the function DisposeNibReference immediately after you have finished unarchiving objects (windows, menus, menu bar, and so forth) from the nib file associated with the nib reference. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X 10.0 and later.
Declared In
IBCarbonRuntime.h*/
void DisposeNibReference (
   IBNibRef inNibRef){
//TODO
};


/*SetControlData

Sets control-specific data.

OSErr SetControlData (
   ControlRef inControl,
   ControlPartCode inPart,
   ResType inTagName,
   Size inSize,
   const void * inData
);
Parameters
inControl

A handle to the control for which data is to be set. 
inPart

The part code of the control part for which data is to be set; see “Control Meta Part Code Constants”, “Control Part Code Constants”, and “Control State Part Code Constants”. Passing kControlEntireControl indicates that either the control has no parts or the data is not tied to any specific part of the control. 
inTagName

A constant representing the control-specific data you wish to set see the data tag constants in the “Control Manager Constants” section. 
inSize

The size (in bytes) of the data pointed to by the inData parameter. For variable-length control data, pass the value returned in the outMaxSize parameter of GetControlDataSize in the inSize parameter. The number of bytes must match the actual data size. 
inData

A pointer to a buffer allocated by your application. This buffer contains the data that you are sending to the control. After calling SetControlData, your application is responsible for disposing of this buffer, if necessary, as information is copied by control.
Return Value

A result code. See “Control Manager Result Codes”. The result code errDataNotSupported indicates that the inTagName parameter is not valid.
Discussion

The SetControlData function sets control-specific data represented by the value in the inTagName parameter to the data pointed to by the inData parameter. SetControlData could be used, for example, to switch a progress indicator from a determinate to indeterminate state. For a list of the control attributes that can be set, see the data tag constants in the “Control Manager Constants” section. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
OSErr SetControlData (
   ControlRef inControl,
   ControlPartCode inPart,
   ResType inTagName,
   Size inSize,
   const void * inData){
//TODO
};


/*SetWindowBounds

Sets a window’s size and position from the bounding rectangle of the specified window region.

OSStatus SetWindowBounds (
   WindowRef window,
   WindowRegionCode regionCode,
   const Rect * globalBounds
);
Parameters
window

The window whose bounds are to be set.
regionCode

A constant specifying the region to be used in determining the window’s size and position. The only region codes allowed for this parameter are kWindowStructureRgn and kWindowContentRgn.
globalBounds

Set the rectangle to specify the dimensions and position, in global coordinates, of the window region specified in the regionCode parameter. 
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

The SetWindowBounds function sets a window’s size and position to that specified by the rectangle that your application passes in the globalBounds parameter. After doing so, SetWindowBounds redraws the window, if the window is visible.

When you call the SetWindowBounds function, your application specifies whether the window’s content region or its structure region is more important in determining the window’s ultimate size and position. This distinction can be important with versions of the Mac OS running the Appearance Manager, since the total dimensions of a window—and, therefore, its spatial relationship to the rest of the screen—may vary from appearance to appearance. In general, you should specify kWindowStructureRgn for the regionCode parameter if how the window as a whole relates to a given monitor is more important than the exact positioning of its content on the screen. On the other hand, if you specify kWindowContentRgn for the regionCode parameter because the positioning of your application’s content is of greatest concern, then it is important to note that with some appearances some part of the window’s structure region or “frame” may extend past the edge of a monitor and not be displayed.

See also the function GetWindowBounds. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus SetWindowBounds (
   WindowRef window,
   WindowRegionCode regionCode,
   const Rect * globalBounds){
//TODO
};



/*GetWindowBounds

Obtains the size and position of the bounding rectangle of the specified window region.

OSStatus GetWindowBounds (
   WindowRef window,
   WindowRegionCode regionCode,
   Rect * globalBounds
);
Parameters
window

The window whose bounds you want to obtain.
regionCode

A constant identifying the window region whose bounds you want to obtain. See “Window Region Constants” for a list of possible values.
globalBounds

A pointer to a structure of type Rect. On return, the rectangle contains the dimensions and position, in global coordinates, of the window region specified in the regionCode parameter. 
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

Use the GetWindowBounds function to obtain the bounding rectangle for the specified window region for the specified window.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus GetWindowBounds (
   WindowRef window,
   WindowRegionCode regionCode,
   Rect * globalBounds){
//TODO
};


/*HideWindow

Makes a window invisible.

void HideWindow (
   WindowRef window
);
Parameters
window

The window that is to be made invisible.
Discussion

The HideWindow function make a visible window invisible. If you hide the frontmost window, HideWindow removes the highlighting, brings the window behind it to the front, highlights the new frontmost window, and generates the appropriate activate events.

To reverse the actions of HideWindow, you must call both ShowWindow, to make the window visible, and SelectWindow, to select it. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
void HideWindow (
   WindowRef window){
//TODO
};

/*HIViewGetBounds

Obtains the local bounds of a view. 

OSStatus HIViewGetBounds (
   HIViewRef inView,
   HIRect* outRect
);
Parameters
inView

The view whose local bounds are to be obtained.
outRect

The local bounds of the view.
Return Value

An operating system result code.
Discussion

The local bounds are the coordinate system that is completely view-relative. A view’s top left coordinate starts out at 0, 0. Most operations use local coordinates. Note, however, that the frame is used to move a view, not local coordinates.
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus HIViewGetBounds (
   HIViewRef inView,
   HIRect* outRect){
//TODO
};

/*RegisterEventHotKey

Registers a global hot key.

OSStatus RegisterEventHotKey (
   UInt32 inHotKeyCode,
   UInt32 inHotKeyModifiers,
   EventHotKeyID inHotKeyID,
   EventTargetRef inTarget,
   OptionBits inOptions,
   EventHotKeyRef * outRef
);
Parameters
inHotKeyCode

The virtual key code of the hot key you want to register. 
inHotKeyModifiers

The keyboard modifiers to look for. In Mac OS X v10.2 and earlier, if you do not specify a modifier key, this function returns paramErr. In Mac OS X v10.3 and later, passing 0 does not cause an error.
inHotKeyID

The application-specified hot key ID. You will receive this ID in the kEventHotKeyPressed event as the direct object parameter. 
inTarget

The target to notify when the hot key is pressed. 
inOptions

Currently unused. You must pass 0.
outRef

On return, a reference to the new hot key. You need this reference if you later wish to unregister it. 
Return Value

A result code. See “Carbon Event Manager Result Codes”.
Discussion

This function registers a global hot key based on the virtual key code and modifiers you pass in. When the user enters the hot-key combination, a kEventHotKeyPressed event is sent to the target you specified. Only one such combination can exist for the current application (that is, multiple entities in the same application cannot register for the same hot key combination). The same hot key can, however, be registered by multiple applications. This means that multiple applications can potentially be notified when a particular hot key is requested. This might not necessarily be desirable, but it is how it works at present. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/
OSStatus RegisterEventHotKey (
   UInt32 inHotKeyCode,
   UInt32 inHotKeyModifiers,
   EventHotKeyID inHotKeyID,
   EventTargetRef inTarget,
   OptionBits inOptions,
   EventHotKeyRef * outRef){
//TODO
};


/*HIWindowSetProxyFSRef

Sets the proxy icon for a window using an FSRef to a file system object.

OSStatus HIWindowSetProxyFSRef (
   WindowRef inWindow,
   const FSRef * inRef
);
Parameters
inWindow

The window whose proxy icon is to be set.
inRef

The file system object the window represents.
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

This function determines the window’s proxy icon by asking Icon Services for the icon for the object specified by inRef.
Availability
Available in Mac OS X v10.4 and later. 
Declared In
MacWindows.h*/
OSStatus HIWindowSetProxyFSRef (
   WindowRef inWindow,
   const FSRef * inRef){
//TODO
};

/*HIViewGetValue

Obtains the value of a view.

SInt32 HIViewGetValue (
HIViewRef inView
);
Parameters
inView

The view whose value is to be obtained.
Return Value

The view’s value.
Availability
Available in Mac OS X v10.4 and later.*/
SInt32 HIViewGetValue (
HIViewRef inView){};

/*HIViewSetHilite

Sets highlighting on a view.

OSStatus HIViewSetHilite (
HIViewRef inView,
HIViewPartCode inHilitePart
);
Parameters
inView

The view for which highlighting is to be set.
inHilitePart

The part of the view whose highlighting is to be set. For possible values, see “HIViewPartCode Constants”.
Return Value

An operating system result code.
Availability
Available in Mac OS X v10.4 and later.*/

OSStatus HIViewSetHilite (
HIViewRef inView,
HIViewPartCode inHilitePart){};

/*HIViewSetValue

Sets the value of a view.

OSStatus HIViewSetValue (
HIViewRef inView,
SInt32 inValue
);
Parameters
inView

The view whose value is to be set.
inValue

The value to set.
Return Value

An operating system result code.
Availability
Available in Mac OS X v10.4 and later.*/
OSStatus HIViewSetValue (
HIViewRef inView,
SInt32 inValue){};


/*HIViewSetMaximum

Sets a view’s maximum value.

OSStatus HIViewSetMaximum (
HIViewRef inView,
SInt32 inMaximum
);
Parameters
inView

The view whose maximum value is to be set.
inView

The maximum value to set.
Return Value

An operating system result code.
Availability
Available in Mac OS X v10.4 and later.*/
OSStatus HIViewSetMaximum (
HIViewRef inView,
SInt32 inMaximum){};



/*HIViewSetViewSize

Sets the view size of a view.

OSStatus HIViewSetViewSize (
HIViewRef inView,
SInt32 inViewSize
);
Parameters
inView

The view whose view size is to be set.
inViewSize

The view size that is to be set.
Return Value

An operating system result code.
Discussion

The view size is the size of the content to which a view’s display is proportioned. The view size is commonly used to set the proportional size of a scroll bar’s thumb indicator.
Availability
Available in Mac OS X v10.4 and later.*/
OSStatus HIViewSetViewSize (
HIViewRef inView,
SInt32 inViewSize){};

/*HIViewGetMaximum

Obtains a view’s maximum value.

SInt32 HIViewSetMinimum (
HIViewRef inView
);
Parameters
inView

The view whose maximum value is to be obtained.
Return Value

The maximum value of the specified view.
Availability
Available in Mac OS X v10.4 and later.*/
SInt32 HIViewSetMinimum (
HIViewRef inView){};

/*HIViewGetMaximum

Obtains a view’s maximum value.

SInt32 HIViewSetMinimum (
HIViewRef inView
);
Parameters
inView

The view whose maximum value is to be obtained.
Return Value

The maximum value of the specified view.
Availability
Available in Mac OS X v10.4 and later.*/

SInt32 HIViewGetMinimum (
HIViewRef inView){};


/*GetControlReference

Obtains a control’s current reference value. 

SInt32 GetControlReference (
   ControlRef theControl
);
Parameters
theControl

A handle to the control whose current reference value you wish to determine. 
Return Value

The current reference value for the specified control. 
Discussion

When you create a control, you specify an initial reference value, either in the control resource or in the refCon parameter of the function NewControl. The reference value is stored in the contrlRfCon field of the control structure. You can use this field for any purpose, and you can use the function SetControlReference to change this value. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
SInt32 GetControlReference (
   ControlRef theControl){};



/*SetControlReference

Changes a control’s current reference value. 

void SetControlReference (
   ControlRef theControl,
   SInt32 data
);
Parameters
theControl

A handle to the control whose reference value you want to change. For a description of this data type, see “ControlRef”.
data

The new reference value for the control.
Discussion

The SetControlReference function sets the control’s reference value to the value you specify in the data parameter.

When you create a control, you specify an initial reference value, either in the control resource or in the refCon parameter of the function NewControl. Call GetControlReference to obtain the current value. You can use this value for any purpose.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
void SetControlReference (
   ControlRef theControl,
   SInt32 data){};


/*HIViewGetMaximum

Obtains a view’s maximum value.

SInt32 HIViewGet Maximum(
HIViewRef inView
);
Parameters
inView

The view whose maximum value is to be obtained.
Return Value

The maximum value of the specified view.
Availability
Available in Mac OS X v10.4 and later.*/
SInt32 HIViewGetMaximum (
HIViewRef inView){};



/*HIViewGetSuperview

Returns a view’s parent view.

HIViewRef HIViewGetSuperview (
   HIViewRef inView
);
Parameters
inView

The view whose parent you are interested in getting.
Return Value

An HIView reference, or NULL if this view has no parent or is invalid.
Availability
Available in Mac OS X v10.2 and later.*/
HIViewRef HIViewGetSuperview (
   HIViewRef inView){};


/*HIViewConvertRect

Converts a rectangle from one view to another. 

OSStatus HIViewConvertRect (
   HIRect* ioRect,
   HIViewRef inSourceView,
   HIViewRef inDestView
);
Parameters
ioRect

The rectangle to convert. 
inSourceView

The view whose coordinate system ioRect is starting out in. You can pass NULL to indicate that ioRect is a window-relative rectangle.
inDestView

The view whose coordinate system ioRect should end up in. You can pass NULL to indicate that ioRect is a window-relative rectangle.
Return Value

An operating system result code.
Discussion

Both views must have a common ancestor, that is, they must both be in the same window. 
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus HIViewConvertRect (
   HIRect* ioRect,
   HIViewRef inSourceView,
   HIViewRef inDestView){};


/*CallNextEventHandler

Calls the next handler in the handler chain.

OSStatus CallNextEventHandler (
   EventHandlerCallRef inCallRef,
   EventRef inEvent
);
Parameters
inCallRef

The event handler call reference passed into your event handler. 
inEvent

The event you want to pass to the next handler. 
Return Value

A result code. See “Carbon Event Manager Result Codes”. 
Discussion

Calls through to the event handlers below you in the event handler stack of the target to which your handler is bound. You might use this to call through to the default toolbox handling in order to post-process the event. You can only call this routine from within an event handler. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
OSStatus CallNextEventHandler (
   EventHandlerCallRef inCallRef,
   EventRef inEvent
){};

/*HIViewDrawCGImage

Draws a Core Graphics image appropriately for a view.

OSStatus HIViewDrawCGImage (
   CGContextRef inContext,
   const HIRect* inBounds,
   CGImageRef inImage
);
Parameters
inContext

The context to draw in.
inBounds

The bounds to draw the image into.
inImage

The image to draw.
Return Value

An operating system status code.
Discussion

This function is similar to CGContextDrawImage, but it flips the context so that the image is drawn correctly. The origin of a view is at the top left corner, so you are really drawing upside-down. This call insulates you from that fact.
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus HIViewDrawCGImage (
   CGContextRef inContext,
   const HIRect* inBounds,
   CGImageRef inImage
){};


/*HIObjectRegisterSubclass

Registers an HIObject subclass.

OSStatus HIObjectRegisterSubclass (
   CFStringRef inClassID,
   CFStringRef inBaseClassID,
   OptionBits inOptions,
   EventHandlerUPP inConstructProc,
   UInt32 inNumEvents,
   const EventTypeSpec* inEventList,
   void * inConstructData,
   HIObjectClassRef* outClassRef
);
Parameters
inClassID

The class ID of your class. It should be unique. We recommend using Java-style com.company.foo naming conventions to avoid collisions.
inBaseClassID

The class ID of the class you derive from. Passing NULL indicates you want to subclass HIObject (the base class) directly.
inOptions

Any special options for your class. Currently you must pass 0 for this parameter.
inConstructProc

A universal procedure pointer to the event handler for this subclass. You pass the address of an event handler into this parameter. This handler is called directly, rather than through the normal event-dispatching mechanism. This means that the EventHandlerCallRef passed in will be NULL, and you cannot use it for calls like CallNextEventHandler. Other than that, you should return a result as usual. After your object is constructed, this procedure is installed as the event handler for the remaining events specified in the inEventList parameter. In Mac OS X v10.4 and later, passing NULL creates an “abstract class” that cannot be instantiated but can still be used as a base class for subclasses. If you pass NULL, HIObjectCreate on the class ID will return hiObjectClassIsAbstractErr.
inNumEvents

The number of events you are installing.
inEventList

The events your handler wants to receive. You must handle the kEventHIObjectConstruct and kEventHIObjectDestruct event. If these events are not specified, an error is returned.
inConstructData

Pass any info you want passed into your event handler here. For a C++ hierarchy based on HIObjects, you might actually pass a static method to construct your object here, and the base class event handler to do construction as your event handler.
outClassRef

The newly created class reference. Pass NULL if you don’t care.
Return Value

A result code. See “HIObject Result Codes”.
Availability
Available in Mac OS X version 10.2 (v10.2) and later.*/
OSStatus HIObjectRegisterSubclass (
   CFStringRef inClassID,
   CFStringRef inBaseClassID,
   OptionBits inOptions,
   EventHandlerUPP inConstructProc,
   UInt32 inNumEvents,
   const EventTypeSpec* inEventList,
   void * inConstructData,
   HIObjectClassRef* outClassRef
){};












