//inc
#ifndef QUICKTIMECOMPONENTS_H
#define  QUICKTIMECOMPONENTS_H

#ifndef CARBON_H
#include <Carbon/Carbon.h>
#endif

#ifndef IMAGECOMPRESSION_H
#include <QuickTime/ImageCompression.h>
#endif

#ifndef  MOVIES_H
#include <QuickTime/Movies.h>
#endif

#ifndef QUICKTIMEMUSIC_H
#include <QuickTime/QuickTimeMusic.h>
#endif



#include <HYS/QuickTime/QuickTimeComponents.h>
#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

#if PRAGMA_ONCE
#pragma once
#endif

/*Pointer Data Handler

The Pointer data handler adds to the complement of other QuickTime data handlers. Like the Handle Data Handler, the Pointer data handler supports references to data in memory; unlike the Handle data handler, the Pointer data handler does not require that data reside within a block allocated by the Macintosh Memory Manager. You just specify the memory address of the data and its length, and the Pointer data handler will do the rest.

The Pointer data handler allows you to submit data for use by QuickTime via direct memory address. However, it does not eliminate the use of handles in QuickTime’s data handler API. Data references themselves are still stored in handles on which QuickTime will call GetHandleSize. The API also requires that ancillary pieces of information about data references, such as their names and MIME types, are passed to QuickTime in handle blocks, not pointer blocks.

A pointer data ref record has the following definition:struct PointerDataRefRecord {
    void        *data;
    Size        dataLength;
};
typedef PointerDataRefRecord *PointerDataRefPtr;
typedef PointerDataRefPtr *PointerDataRef;


The code snippet in Listing 1-8 shows you how you can open media at a specific memory address as a QuickTime movie. The snippet does not include error checking.*/
struct PointerDataRefRecord {
    void        *data;
    Size        dataLength;
};
typedef struct PointerDataRefRecord PointerDataRefRecord  ;
typedef struct PointerDataRefRecord *PointerDataRefPtr;
typedef PointerDataRefPtr *PointerDataRef;


/*Standard Compression Constants

Constants that represent constants for Standard Compression.

enum {
   /*
   * Indicates the client is ready to use the ICM compression session
   * API to perform compression operations. StdCompression disables
   * frame reordering and multi pass encoding if this flag is cleared.
   */
   //scAllowEncodingWithCompressionSession = 1L << 8,
   /*
   * Indicates the client does not want the user to change the frame
   * reordering setting.
   */
   //scDisableFrameReorderingItem  = 1L << 9,
   /*
   * Indicates the client does not want the user to change the multi
   * pass encoding setting
   */
  // scDisableMultiPassEncodingItem = 1L << 10
//};
//enum {
   /*
   * Specifies if frame reordering can occur in encoding.
   */
   //scVideoAllowFrameReorderingType = 'bfra',
   /* pointer to Boolean*/
   /*
   * The settings to control multi pass encoding.
   */
   //scVideoMultiPassEncodingSettingsType = 'mpes' /* pointer to SCVideoMutiPassEncodingSettings struct*/
//};
/*enum {
   scListEveryCodec              = 1L << 1,
   scAllowZeroFrameRate          = 1L << 2,
   scAllowZeroKeyFrameRate       = 1L << 3,
   scShowBestDepth               = 1L << 4,
   scUseMovableModal             = 1L << 5,
   scDisableFrameRateItem        = 1L << 6,
   scShowDataRateAsKilobits      = 1L << 7
};
enum {
   scOKItem                      = 1,
   scCancelItem                  = 2,
   scCustomItem                  = 3
};
enum {
   scPositionRect                = 2,
   scPositionDialog              = 3,
   scSetTestImagePictHandle      = 4,
   scSetTestImagePictFile        = 5,
   scSetTestImagePixMap          = 6,
   scGetBestDeviceRect           = 7,
   scRequestImageSettings        = 10,
   scCompressImage               = 11,
   scCompressPicture             = 12,
   scCompressPictureFile         = 13,
   scRequestSequenceSettings     = 14,
   scCompressSequenceBegin       = 15,
   scCompressSequenceFrame       = 16,
   scCompressSequenceEnd         = 17,
   scDefaultPictHandleSettings   = 18,
   scDefaultPictFileSettings     = 19,
   scDefaultPixMapSettings       = 20,
   scGetInfo                     = 21,
   scSetInfo                     = 22,
   scNewGWorld                   = 23
};
enum {
   scPreferCropping              = 1 << 0,
   scPreferScaling               = 1 << 1,
   scPreferScalingAndCropping    = scPreferScaling | scPreferCropping,
   scDontDetermineSettingsFromTestImage = 1 << 2
};
enum {
   scSpatialSettingsType         = 'sptl',
   /* pointer to SCSpatialSettings struct*/
//   scTemporalSettingsType        = 'tprl',
   /* pointer to SCTemporalSettings struct*/
   //scDataRateSettingsType        = 'drat',
   /* pointer to SCDataRateSettings struct*/
   //scColorTableType              = 'clut',
   /* pointer to CTabHandle*/
   //scProgressProcType            = 'prog',
   /* pointer to ProgressRecord struct*/
   //scExtendedProcsType           = 'xprc',
   /* pointer to SCExtendedProcs struct*/
   //scPreferenceFlagsType         = 'pref',
   /* pointer to long*/
   //scSettingsStateType           = 'ssta',
   /* pointer to Handle*/
   //scSequenceIDType              = 'sequ',
   /* pointer to ImageSequence*/
   //scWindowPositionType          = 'wndw',
   /* pointer to Point*/
   //scCodecFlagsType              = 'cflg',
   /* pointer to CodecFlags*/
   //scCodecSettingsType           = 'cdec',
   /* pointer to Handle*/
   //scForceKeyValueType           = 'ksim',
   /* pointer to long*/
   //scCompressionListType         = 'ctyl',
   /* pointer to OSType Handle*/
   //scCodecManufacturerType       = 'cmfr',
   /* pointer to OSType*/
   //scAvailableCompressionListType = 'avai',
   /* pointer to OSType Handle*/
   //scWindowOptionsType           = 'shee',
   /* pointer to SCWindowSettings struct*/
   //scSoundVBRCompressionOK       = 'cvbr',
   /* pointer to Boolean*/
   //scSoundSampleRateChangeOK     = 'rcok',
   /* pointer to Boolean*/
   //scSoundCompressionType        = 'ssct',
   /* pointer to OSType*/
   //scSoundSampleRateType         = 'ssrt',
   /* pointer to UnsignedFixed*/
   //scSoundInputSampleRateType    = 'ssir',
   /* pointer to UnsignedFixed*/
   //scSoundSampleSizeType         = 'ssss',
   /* pointer to short*/
   //scSoundChannelCountType       = 'sscc' /* pointer to short*/
/*};
enum {
   scTestImageWidth              = 80,
   scTestImageHeight             = 80
};
enum {
   scUserCancelled               = 1
};
enum {
   scWindowRefKindCarbon         = 'carb' /* WindowRef*/
/*};
Constants
scVideoAllowFrameReorderingType

Pointer to Boolean. 

Available in Mac OS X v10.3 and later.
scSpatialSettingsType

A video track's SCSpatialSettings structure. 

Available in Mac OS X v10.0 and later.
scTemporalSettingsType

A video track's SCTemporalSettings structure. 

Available in Mac OS X v10.0 and later.
scDataRateSettingsType

A video track's SCDataRateSettings structure. 

Available in Mac OS X v10.0 and later.
scCodecSettingsType

Pointer to Handle. 

Available in Mac OS X v10.0 and later.
scForceKeyValueType

Pointer to long. 

Available in Mac OS X v10.0 and later.
scCodecManufacturerType

Pointer to OSType. 

Available in Mac OS X v10.0 and later.
scAvailableCompressionListType

Pointer to OSType Handle. 

Available in Mac OS X v10.2 and later.
scWindowOptionsType

Pointer to SCWindowSettings struct. 

Available in Mac OS X v10.3 and later.
scSoundVBRCompressionOK

Pointer to Boolean. 

Available in Mac OS X v10.2 and later.
scSoundSampleRateChangeOK

Pointer to Boolean. 

Available in Mac OS X v10.2 and later.
scSoundCompressionType

A sound track's compression type constant; see Codec Identifiers. 

Available in Mac OS X v10.0 and later.
scSoundSampleRateType

An UnsignedFixed value that represents a sound track's sampling rate. 

Available in Mac OS X v10.0 and later.
scSoundInputSampleRateType

Pointer to UnsignedFixed. 

Available in Mac OS X v10.2 and later.
scSoundSampleSizeType

A short integer that represents a sound track's sample size. 

Available in Mac OS X v10.0 and later.
scSoundChannelCountType

A short integer that represents a sound track's channel count. 

Available in Mac OS X v10.0 and later.*/
enum {
   /*
   * Indicates the client is ready to use the ICM compression session
   * API to perform compression operations. StdCompression disables
   * frame reordering and multi pass encoding if this flag is cleared.
   */
   scAllowEncodingWithCompressionSession = 1L << 8,
   /*
   * Indicates the client does not want the user to change the frame
   * reordering setting.
   */
   scDisableFrameReorderingItem  = 1L << 9,
   /*
   * Indicates the client does not want the user to change the multi
   * pass encoding setting
   */
   scDisableMultiPassEncodingItem = 1L << 10
};
enum {
   /*
   * Specifies if frame reordering can occur in encoding.
   */
   scVideoAllowFrameReorderingType = 'bfra',
   /* pointer to Boolean*/
   /*
   * The settings to control multi pass encoding.
   */
   scVideoMultiPassEncodingSettingsType = 'mpes' /* pointer to SCVideoMutiPassEncodingSettings struct*/
};
enum {
   scListEveryCodec              = 1L << 1,
   scAllowZeroFrameRate          = 1L << 2,
   scAllowZeroKeyFrameRate       = 1L << 3,
   scShowBestDepth               = 1L << 4,
   scUseMovableModal             = 1L << 5,
   scDisableFrameRateItem        = 1L << 6,
   scShowDataRateAsKilobits      = 1L << 7
};
enum {
   scOKItem                      = 1,
   scCancelItem                  = 2,
   scCustomItem                  = 3
};
enum {
   scPositionRect                = 2,
   scPositionDialog              = 3,
   scSetTestImagePictHandle      = 4,
   scSetTestImagePictFile        = 5,
   scSetTestImagePixMap          = 6,
   scGetBestDeviceRect           = 7,
   scRequestImageSettings        = 10,
   scCompressImage               = 11,
   scCompressPicture             = 12,
   scCompressPictureFile         = 13,
   scRequestSequenceSettings     = 14,
   scCompressSequenceBegin       = 15,
   scCompressSequenceFrame       = 16,
   scCompressSequenceEnd         = 17,
   scDefaultPictHandleSettings   = 18,
   scDefaultPictFileSettings     = 19,
   scDefaultPixMapSettings       = 20,
   scGetInfo                     = 21,
   scSetInfo                     = 22,
   scNewGWorld                   = 23
};
enum {
   scPreferCropping              = 1 << 0,
   scPreferScaling               = 1 << 1,
   scPreferScalingAndCropping    = scPreferScaling | scPreferCropping,
   scDontDetermineSettingsFromTestImage = 1 << 2
};
enum {
   scSpatialSettingsType         = 'sptl',
   /* pointer to SCSpatialSettings struct*/
   scTemporalSettingsType        = 'tprl',
   /* pointer to SCTemporalSettings struct*/
   scDataRateSettingsType        = 'drat',
   /* pointer to SCDataRateSettings struct*/
   scColorTableType              = 'clut',
   /* pointer to CTabHandle*/
   scProgressProcType            = 'prog',
   /* pointer to ProgressRecord struct*/
   scExtendedProcsType           = 'xprc',
   /* pointer to SCExtendedProcs struct*/
   scPreferenceFlagsType         = 'pref',
   /* pointer to long*/
   scSettingsStateType           = 'ssta',
   /* pointer to Handle*/
   scSequenceIDType              = 'sequ',
   /* pointer to ImageSequence*/
   scWindowPositionType          = 'wndw',
   /* pointer to Point*/
   scCodecFlagsType              = 'cflg',
   /* pointer to CodecFlags*/
   scCodecSettingsType           = 'cdec',
   /* pointer to Handle*/
   scForceKeyValueType           = 'ksim',
   /* pointer to long*/
   scCompressionListType         = 'ctyl',
   /* pointer to OSType Handle*/
   scCodecManufacturerType       = 'cmfr',
   /* pointer to OSType*/
   scAvailableCompressionListType = 'avai',
   /* pointer to OSType Handle*/
   scWindowOptionsType           = 'shee',
   /* pointer to SCWindowSettings struct*/
   scSoundVBRCompressionOK       = 'cvbr',
   /* pointer to Boolean*/
   scSoundSampleRateChangeOK     = 'rcok',
   /* pointer to Boolean*/
   scSoundCompressionType        = 'ssct',
   /* pointer to OSType*/
   scSoundSampleRateType         = 'ssrt',
   /* pointer to UnsignedFixed*/
   scSoundInputSampleRateType    = 'ssir',
   /* pointer to UnsignedFixed*/
   scSoundSampleSizeType         = 'ssss',
   /* pointer to short*/
   scSoundChannelCountType       = 'sscc' /* pointer to short*/
};
enum {
   scTestImageWidth              = 80,
   scTestImageHeight             = 80
};
enum {
   scUserCancelled               = 1
};
enum {
   scWindowRefKindCarbon         = 'carb' /* WindowRef*/
};

/*Audio Property Selectors

The following values are used as ComponentPropertyID selectors. Use these with the StandardCompressionSubTypeAudio ('scdi'/'audi') component. All property IDs are to be used in conjunction with the kQTPropertyClass_SCAudio property class. 
kQTSCAudioPropertyID_AvailableCompressionFormatList = 'acf#'

A read/listen C-style array of OSType values that specifies the list of available output compression formats. This list includes all the kAudioEncoderComponentType components and kSoundCompressor type components on the user’s system. You can restrict the list by using the kQTSCAudioPropertyID_CompressionFormatList property. Use QTGetComponentPropertyInfo to discover the number of bytes you should allocate for this array.
kQTSCAudioPropertyID_ClientRestrictedCompressionFormatList = 'crf#'

A read/write/listen C-style array of OSType values that specifies a client-restricted set of output compression formats that you should list as available. Use QTGetComponentPropertyInfo to discover the number of bytes you should allocate to hold this array.
kQTSCAudioPropertyID_AvailableCompressionFormatNamesList = 'cnm#'

A read/write CFArrayRef structure of CFStringRef structures that reference the human-readable names of each item in a kQTSCAudioPropertyID_AvailableCompressionFormatList. The caller assumes responsibility for calling CFRelease to dispose of the CFArrayRef structure.
kQTSCAudioPropertyID_HasLegacyCodecOptionsDialog = 'opn?'

Some compression formats have format-specific properties that are accessible only via a compressor-provided dialog. This constant specifies a read/listen Boolean value that lets you know if the current compression format has such a dialog.
kQTSCAudioPropertyID_ConstantBitRateFormatsOnly = '!vbr'

By default, constant as well as variable bit rate compression formats are shown in the available format list. This constant specifies a read/write/listen Boolean value that lets you restrict the available formats to constant bit rate formats by setting this property to TRUE.
kQTSCAudioPropertyID_AvailableSampleRateList = 'avr#'

A read/listen C-style array of AudioValueRange values that specifies a list of available output sample rates. This list is specific to the compression format and takes into account any restrictions imposed by a client using the kQTSCAudioPropertyID_ClientRestrictedSampleRateList property. Use QTGetComponentPropertyInfo to discover the number of bytes you should allocate to hold this array.
kQTSCAudioPropertyID_SampleRateRecommended = 'reco'

Clients not wishing to set an output sample rate manually may set the output rate to the recommended rate. Some compressors can perform rate conversion, and can pick optimal settings for a desired bitrate (AAC is one example). For other formats, the recommended rate is simply the closest output rate to the input rate that's allowed by the output format. kQTSCAudioPropertyID_SampleRateIsRecommended is read-only. To set the sample rate to recommended, a client sets the kQTSCAudioPropertyID_BasicDescription with mSampleRate = 0.0. To unset the sample rate as recommended, the client sets the kQTSCAudioPropertyID_BasicDescription with a non-zero mSampleRate field.
kQTSCAudioPropertyID_ApplicableSampleRateList = 'avr#'

A read/listen C-style array of AudioValueRange values that specifies which of the value ranges in the kQTSCAudioPropertyID_AvailableSampleRateList are currently applicable. The kQTSCAudioPropertyID_AvailableSampleRateList takes into account client restrictions, and a compression format's general sample rate restrictions. kQTSCAudioPropertyID_ApplicableSampleRateList further filters the list to just those sample rates that are legal and valid given the current codec configuration. Use QTGetComponentPropertyInfo to discover the number of bytes you should allocate to hold the array.
kQTSCAudioPropertyID_ClientRestrictedSampleRateList = 'crr#'

A read/write/listen C-style array of AudioValueRange values that specifies a client-restricted set of output sample rate ranges that should be listed as available. Use QTGetComponentPropertyInfo to discover the number of bytes you should allocate to hold this array.
kQTSCAudioPropertyID_InputMagicCookie = 'ikki'

A read/write/listen opaque data structure that contains an untyped codec-specific data structure (a “magic cookie”), which some decompressors use to decode their input. Cookies are variable size, so you must call QTGetComponentPropertyInfo to discover the size of the buffer you should allocate to hold the cookie.
kQTSCAudioPropertyID_MagicCookie = 'kuki'

A read/write/listen opaque data structure that contains an untyped codec-specific data structure (a “magic cookie”), which some decompressors use to configure their output. Cookies are variable size, so you must call QTGetComponentPropertyInfo to discover the size of the buffer you should allocate to hold the cookie.
kQTSCAudioPropertyID_ClientRestrictedLPCMBitsPerChannelList = 'crb#'

Specifies a client-restricted set of output bits per channel that should be listed as available. Use QTGetComponentPropertyInfo to discover the number of bytes you should allocate to hold the array.
kQTSCAudioPropertyID_AvailableLPCMBitsPerChannelList = 'avb#'

A read/listen C-style array of UInt32 values that contains a list of available bits per audio channel. This list is specific to LPCM, and takes into account any restrictions imposed by a client using the kQTSCAudioPropertyID_LPCMBitsPerChannelList property. Use QTGetComponentPropertyInfo to discover the number of bytes you should allocate to hold this array.
kQTSCAudioPropertyID_ApplicableLPCMBitsPerChannelList = 'apb#'

Specifies which of the values in the kQTSCAudioPropertyID_AvailableLPCMBitsPerChannelList are currently applicable. The kQTSCAudioPropertyID_AvailableLPCMBitsPerChannelList takes into account client restrictions, and LPCM’s general bits per channel restrictions. kQTSCAudioPropertyID_ApplicableLPCMBitsPerChannelList further filters the list to just those bits per channel that are legal and valid given the current LPCM configuration. Use QTGetComponentPropertyInfo to discover the number of bytes you should allocate to hold the array.
kQTSCAudioPropertyID_LPCMBitsPerChannelList = 'sbc#'

A read/write/listen C-style array of UInt32 values that contains a client-restricted set of output bits per channel, which you should list as available. Use QTGetComponentPropertyInfo to discover the number of bytes you should allocate to hold this array.
kQTSCAudioPropertyID_AvailableNumChannelsList = 'anc#'

A read/listen C-style array of UInt32 values that contains a list of available numbers of channels. This list is specific to the compression format and takes into account any restrictions imposed by a client using the kQTSCAudioPropertyID_NumChannelsList property. Use QTGetComponentPropertyInfo to discover the number of bytes you should allocate to hold this array.
kQTSCAudioPropertyID_NumChannelsList = 'snc#'

A read/write/listen C-style array of UInt32 values that contains a client-restricted set of numbers of channels that you should list as available. Use QTGetComponentPropertyInfo to discover the number of bytes you should allocate to hold this array.
kQTSCAudioPropertyID_InputChannelLayout = 'icly'

A read/write/listen variable-size AudioChannelLayout structure that specifies the audio channel layout of the input description. AudioChannelLayout is a variable-size structure, so you must use QTGetComponentPropertyInfo to discover the number of bytes you should allocate for it.
kQTSCAudioPropertyID_InputChannelLayoutName = 'icln'

A read-only CFStringRef structure that specifies the human-readable name for a kQTSCAudioPropertyID_InputChannelLayout structure, if one exists. The caller is responsible for calling CFRelease to dispose of the resulting string.
kQTSCAudioPropertyID_ChannelLayout = 'clay'

A read/write/listen variable-size AudioChannelLayout structure that specifies the audio channel layout of the output description. AudioChannelLayout is a variable size structure, so you must use QTGetComponentPropertyInfo to discover the number of bytes you should allocate.
kQTSCAudioPropertyID_ChannelLayoutName = 'clyn'

A read-only CFStringRef structure that specifies the human-readable name for a kQTSCAudioPropertyID_ChannelLayout, if one exists. The caller is responsible for calling CFRelease to dispose of the resulting string.
kQTSCAudioPropertyID_ClientRestrictedChannelLayoutTagList = 'crl#'

Specifies a client-restricted set of channel layout tags that should be listed as available. Use QTGetComponentPropertyInfo to discover the number of bytes you should allocate to hold the array.
kQTSCAudioPropertyID_AvailableChannelLayoutTagList = 'acl#'

A read/listen C-style array of AudioChannelLayoutTag values that specifies a list of available audio channel layout tags. This list is specific to the compression format and takes into account any restrictions imposed by a client using the kQTSCAudioPropertyID_ChannelLayoutTagList property. Use QTGetComponentPropertyInfo to discover the number of bytes you should allocate to hold this array.
kQTSCAudioPropertyID_ChannelLayoutTagList = 'cly#'

A read/write C-style array of AudioChannelLayoutTag values that specifies a client-restricted set of channel layout tags, which you should list as available. Use QTGetComponentPropertyInfo to discover the number of bytes you should allocate to hold this array.
kQTSCAudioPropertyID_AvailableChannelLayoutTagNamesList = 'cln#'

A read-only CFArrayRef array that specifies the human-readable names for the AudioChannelLayoutTag values in a kQTSCAudioPropertyID_AvailableChannelLayoutTagList. Each element in the array is a CFStringRef structure. The caller is responsible for calling CFRelease to dispose of this array.
kQTSCAudioPropertyID_ApplicableChannelLayoutTagNamesList = 'apl#'

Specifies which of the values in the kQTSCAudioPropertyID_AvailableChannelLayoutTagList are currently applicable. The kQTSCAudioPropertyID_AvailableChannelLayoutTagList takes into account client restrictions, and the current output format’s general channel layout restrictions. kQTSCAudioPropertyID_ApplicableChannelLayoutTagList further filters the list to just those channel layouts that are legal and valid given the current codec configuration. Use QTGetComponentPropertyInfo to discover the number of bytes you should allocate to hold the array.
kQTSCAudioPropertyID_ClientRestrictedPCMFlags = 'crip'

Specifies a client-restricted set of flags corresponding to the mFormatFlags fields in an AudioStreamBasicDescription. Data type is a SCAudioFormatFlagsRestrictions struct. For instance, if a client wishes to specify to the StandardAudioCompression component that their file format requires little endian pcm data, the client may set this property, with formatFlagsMask set to kAudioFormatFlagIsBigEndian, and formatFlagsValues set to zero (indicating that the IsBigEndian bit should be interpreted as LittleEndian only).
kQTSCAudioPropertyID_DiscreteChannelsOK = 'dscr'

A read/write/listen Boolean value that lets you tell the StandardCompressionSubTypeAudio dialog to not show “Discrete” as an available option. Each AudioChannelLayout structure assigns specific spatial orientation to specific channels (for example, Channel 1 = Left). “Discrete” is a special channel layout that does not assign spatial characteristics to channels, but instead labels them as distinct outputs. For example, the first channel in the audio source is played through the first channel on the output device, the second channel in the source is played through the second channel, and so on. If this property is set to FALSE, the StandardCompressionSubTypeAudio dialog will not show “Discrete” as an available option.
kQTSCAudioPropertyID_LPCMSpecificFlagsMask = 'sffm'

A read/write/listen UInt32 value that specifies which flag fields in kQTSCAudioPropertyID_FormatSpecificFlags should be made available in the StandardCompressionSubTypeAudio dialog. For instance, a value of 0xFFFFFFFD (all bits except kAudioFormatFlagIsBigEndian set) tells the StandardCompressionSubTypeAudio component to disable any UI that would allow a choice between little and big endian. This selector is valid only for PCM formats and is ignored for others.
kQTSCAudioPropertyID_InputSoundDescription = 'isdh'

A read/write SoundDescriptionHandle value that specifies the current input description as a SoundDescriptionHandle (lowest possible version for the current format). When calling QTGetComponentProperty, the caller passes a pointer to an unallocated Handle and assumes responsibility for calling DisposeHandle when done.
kQTSCAudioPropertyID_SoundDescription = 'osdh'

A read/write SoundDescriptionHandle value that specifies the current output description as a SoundDescriptionHandle (lowest possible version for the current format). When calling QTGetComponentProperty, the caller passes a pointer to an unallocated Handle and assumes responsibility for calling DisposeHandle when done.
kQTSCAudioPropertyID_InputBasicDescription = 'isbd'

A read/write/DataProc/listen AudioStreamBasicDescription value that specifies that the current input description is an AudioStreamBasicDescription value.
kQTSCAudioPropertyID_BasicDescription = 'osbd'

A read/write/DataProc/listen AudioStreamBasicDescription value that specifies that the current output description is an AudioStreamBasicDescription value.
kQTSCAudioPropertyID_CodecSpecificSettingsArray = 'cdst'

A read/write CFArrayRef structure that designates a CFArray of CFDictionary structures, which describe various parameters specific to configuring a codec. This array of dictionaries, which is published by some compressors, can be parsed to generate UI information. When any value in the array changes, a client should call QTSetComponentProperty, passing the entire array.
kQTSCAudioPropertyID_SettingsState = scSettingsStateType

A read/write Handle value that is used to save the current state of the StandardCompressionSubTypeAudio component, so that its state may be restored at a later time with a single call. A StandardCompressionSubTypeAudio component can accept a saved settings state from a legacy StandardCompressionSubTypeSound component as write-only.
kQTSCAudioPropertyID_ExtendedProcs = scExtendedProcsType

A read/write/listen SCExtendedProcs value that is used to get or set an SCExtendedProcs structure.
kQTSCAudioPropertyID_PreferenceFlags = scPreferenceFlagsType

A read/write/listen SInt32 value that is used to specify dialog preferences such as scUseMovableModal.
kQTSCAudioPropertyID_WindowOptions = scWindowOptionsType

A read/write/listen SCWindowSettings structure that is used to set an SCWindowSettings structure, which tells the dialog about its parent window so that it can draw itself as a sheet on top of the parent.*/
/*Audio Property Selectors

The following values are used as ComponentPropertyID selectors. Use these with the StandardCompressionSubTypeAudio ('scdi'/'audi') component. All property IDs are to be used in conjunction with the kQTPropertyClass_SCAudio property class. 
kQTSCAudioPropertyID_AvailableCompressionFormatList = 'acf#'

A read/listen C-style array of OSType values that specifies the list of available output compression formats. This list includes all the kAudioEncoderComponentType components and kSoundCompressor type components on the user’s system. You can restrict the list by using the kQTSCAudioPropertyID_CompressionFormatList property. Use QTGetComponentPropertyInfo to discover the number of bytes you should allocate for this array.
kQTSCAudioPropertyID_ClientRestrictedCompressionFormatList = 'crf#'

A read/write/listen C-style array of OSType values that specifies a client-restricted set of output compression formats that you should list as available. Use QTGetComponentPropertyInfo to discover the number of bytes you should allocate to hold this array.
kQTSCAudioPropertyID_AvailableCompressionFormatNamesList = 'cnm#'

A read/write CFArrayRef structure of CFStringRef structures that reference the human-readable names of each item in a kQTSCAudioPropertyID_AvailableCompressionFormatList. The caller assumes responsibility for calling CFRelease to dispose of the CFArrayRef structure.
kQTSCAudioPropertyID_HasLegacyCodecOptionsDialog = 'opn?'

Some compression formats have format-specific properties that are accessible only via a compressor-provided dialog. This constant specifies a read/listen Boolean value that lets you know if the current compression format has such a dialog.
kQTSCAudioPropertyID_ConstantBitRateFormatsOnly = '!vbr'

By default, constant as well as variable bit rate compression formats are shown in the available format list. This constant specifies a read/write/listen Boolean value that lets you restrict the available formats to constant bit rate formats by setting this property to TRUE.
kQTSCAudioPropertyID_AvailableSampleRateList = 'avr#'

A read/listen C-style array of AudioValueRange values that specifies a list of available output sample rates. This list is specific to the compression format and takes into account any restrictions imposed by a client using the kQTSCAudioPropertyID_ClientRestrictedSampleRateList property. Use QTGetComponentPropertyInfo to discover the number of bytes you should allocate to hold this array.
kQTSCAudioPropertyID_SampleRateRecommended = 'reco'

Clients not wishing to set an output sample rate manually may set the output rate to the recommended rate. Some compressors can perform rate conversion, and can pick optimal settings for a desired bitrate (AAC is one example). For other formats, the recommended rate is simply the closest output rate to the input rate that's allowed by the output format. kQTSCAudioPropertyID_SampleRateIsRecommended is read-only. To set the sample rate to recommended, a client sets the kQTSCAudioPropertyID_BasicDescription with mSampleRate = 0.0. To unset the sample rate as recommended, the client sets the kQTSCAudioPropertyID_BasicDescription with a non-zero mSampleRate field.
kQTSCAudioPropertyID_ApplicableSampleRateList = 'avr#'

A read/listen C-style array of AudioValueRange values that specifies which of the value ranges in the kQTSCAudioPropertyID_AvailableSampleRateList are currently applicable. The kQTSCAudioPropertyID_AvailableSampleRateList takes into account client restrictions, and a compression format's general sample rate restrictions. kQTSCAudioPropertyID_ApplicableSampleRateList further filters the list to just those sample rates that are legal and valid given the current codec configuration. Use QTGetComponentPropertyInfo to discover the number of bytes you should allocate to hold the array.
kQTSCAudioPropertyID_ClientRestrictedSampleRateList = 'crr#'

A read/write/listen C-style array of AudioValueRange values that specifies a client-restricted set of output sample rate ranges that should be listed as available. Use QTGetComponentPropertyInfo to discover the number of bytes you should allocate to hold this array.
kQTSCAudioPropertyID_InputMagicCookie = 'ikki'

A read/write/listen opaque data structure that contains an untyped codec-specific data structure (a “magic cookie”), which some decompressors use to decode their input. Cookies are variable size, so you must call QTGetComponentPropertyInfo to discover the size of the buffer you should allocate to hold the cookie.
kQTSCAudioPropertyID_MagicCookie = 'kuki'

A read/write/listen opaque data structure that contains an untyped codec-specific data structure (a “magic cookie”), which some decompressors use to configure their output. Cookies are variable size, so you must call QTGetComponentPropertyInfo to discover the size of the buffer you should allocate to hold the cookie.
kQTSCAudioPropertyID_ClientRestrictedLPCMBitsPerChannelList = 'crb#'

Specifies a client-restricted set of output bits per channel that should be listed as available. Use QTGetComponentPropertyInfo to discover the number of bytes you should allocate to hold the array.
kQTSCAudioPropertyID_AvailableLPCMBitsPerChannelList = 'avb#'

A read/listen C-style array of UInt32 values that contains a list of available bits per audio channel. This list is specific to LPCM, and takes into account any restrictions imposed by a client using the kQTSCAudioPropertyID_LPCMBitsPerChannelList property. Use QTGetComponentPropertyInfo to discover the number of bytes you should allocate to hold this array.
kQTSCAudioPropertyID_ApplicableLPCMBitsPerChannelList = 'apb#'

Specifies which of the values in the kQTSCAudioPropertyID_AvailableLPCMBitsPerChannelList are currently applicable. The kQTSCAudioPropertyID_AvailableLPCMBitsPerChannelList takes into account client restrictions, and LPCM’s general bits per channel restrictions. kQTSCAudioPropertyID_ApplicableLPCMBitsPerChannelList further filters the list to just those bits per channel that are legal and valid given the current LPCM configuration. Use QTGetComponentPropertyInfo to discover the number of bytes you should allocate to hold the array.
kQTSCAudioPropertyID_LPCMBitsPerChannelList = 'sbc#'

A read/write/listen C-style array of UInt32 values that contains a client-restricted set of output bits per channel, which you should list as available. Use QTGetComponentPropertyInfo to discover the number of bytes you should allocate to hold this array.
kQTSCAudioPropertyID_AvailableNumChannelsList = 'anc#'

A read/listen C-style array of UInt32 values that contains a list of available numbers of channels. This list is specific to the compression format and takes into account any restrictions imposed by a client using the kQTSCAudioPropertyID_NumChannelsList property. Use QTGetComponentPropertyInfo to discover the number of bytes you should allocate to hold this array.
kQTSCAudioPropertyID_NumChannelsList = 'snc#'

A read/write/listen C-style array of UInt32 values that contains a client-restricted set of numbers of channels that you should list as available. Use QTGetComponentPropertyInfo to discover the number of bytes you should allocate to hold this array.
kQTSCAudioPropertyID_InputChannelLayout = 'icly'

A read/write/listen variable-size AudioChannelLayout structure that specifies the audio channel layout of the input description. AudioChannelLayout is a variable-size structure, so you must use QTGetComponentPropertyInfo to discover the number of bytes you should allocate for it.
kQTSCAudioPropertyID_InputChannelLayoutName = 'icln'

A read-only CFStringRef structure that specifies the human-readable name for a kQTSCAudioPropertyID_InputChannelLayout structure, if one exists. The caller is responsible for calling CFRelease to dispose of the resulting string.
kQTSCAudioPropertyID_ChannelLayout = 'clay'

A read/write/listen variable-size AudioChannelLayout structure that specifies the audio channel layout of the output description. AudioChannelLayout is a variable size structure, so you must use QTGetComponentPropertyInfo to discover the number of bytes you should allocate.
kQTSCAudioPropertyID_ChannelLayoutName = 'clyn'

A read-only CFStringRef structure that specifies the human-readable name for a kQTSCAudioPropertyID_ChannelLayout, if one exists. The caller is responsible for calling CFRelease to dispose of the resulting string.
kQTSCAudioPropertyID_ClientRestrictedChannelLayoutTagList = 'crl#'

Specifies a client-restricted set of channel layout tags that should be listed as available. Use QTGetComponentPropertyInfo to discover the number of bytes you should allocate to hold the array.
kQTSCAudioPropertyID_AvailableChannelLayoutTagList = 'acl#'

A read/listen C-style array of AudioChannelLayoutTag values that specifies a list of available audio channel layout tags. This list is specific to the compression format and takes into account any restrictions imposed by a client using the kQTSCAudioPropertyID_ChannelLayoutTagList property. Use QTGetComponentPropertyInfo to discover the number of bytes you should allocate to hold this array.
kQTSCAudioPropertyID_ChannelLayoutTagList = 'cly#'

A read/write C-style array of AudioChannelLayoutTag values that specifies a client-restricted set of channel layout tags, which you should list as available. Use QTGetComponentPropertyInfo to discover the number of bytes you should allocate to hold this array.
kQTSCAudioPropertyID_AvailableChannelLayoutTagNamesList = 'cln#'

A read-only CFArrayRef array that specifies the human-readable names for the AudioChannelLayoutTag values in a kQTSCAudioPropertyID_AvailableChannelLayoutTagList. Each element in the array is a CFStringRef structure. The caller is responsible for calling CFRelease to dispose of this array.
kQTSCAudioPropertyID_ApplicableChannelLayoutTagNamesList = 'apl#'

Specifies which of the values in the kQTSCAudioPropertyID_AvailableChannelLayoutTagList are currently applicable. The kQTSCAudioPropertyID_AvailableChannelLayoutTagList takes into account client restrictions, and the current output format’s general channel layout restrictions. kQTSCAudioPropertyID_ApplicableChannelLayoutTagList further filters the list to just those channel layouts that are legal and valid given the current codec configuration. Use QTGetComponentPropertyInfo to discover the number of bytes you should allocate to hold the array.
kQTSCAudioPropertyID_ClientRestrictedPCMFlags = 'crip'

Specifies a client-restricted set of flags corresponding to the mFormatFlags fields in an AudioStreamBasicDescription. Data type is a SCAudioFormatFlagsRestrictions struct. For instance, if a client wishes to specify to the StandardAudioCompression component that their file format requires little endian pcm data, the client may set this property, with formatFlagsMask set to kAudioFormatFlagIsBigEndian, and formatFlagsValues set to zero (indicating that the IsBigEndian bit should be interpreted as LittleEndian only).
kQTSCAudioPropertyID_DiscreteChannelsOK = 'dscr'

A read/write/listen Boolean value that lets you tell the StandardCompressionSubTypeAudio dialog to not show “Discrete” as an available option. Each AudioChannelLayout structure assigns specific spatial orientation to specific channels (for example, Channel 1 = Left). “Discrete” is a special channel layout that does not assign spatial characteristics to channels, but instead labels them as distinct outputs. For example, the first channel in the audio source is played through the first channel on the output device, the second channel in the source is played through the second channel, and so on. If this property is set to FALSE, the StandardCompressionSubTypeAudio dialog will not show “Discrete” as an available option.
kQTSCAudioPropertyID_LPCMSpecificFlagsMask = 'sffm'

A read/write/listen UInt32 value that specifies which flag fields in kQTSCAudioPropertyID_FormatSpecificFlags should be made available in the StandardCompressionSubTypeAudio dialog. For instance, a value of 0xFFFFFFFD (all bits except kAudioFormatFlagIsBigEndian set) tells the StandardCompressionSubTypeAudio component to disable any UI that would allow a choice between little and big endian. This selector is valid only for PCM formats and is ignored for others.
kQTSCAudioPropertyID_InputSoundDescription = 'isdh'

A read/write SoundDescriptionHandle value that specifies the current input description as a SoundDescriptionHandle (lowest possible version for the current format). When calling QTGetComponentProperty, the caller passes a pointer to an unallocated Handle and assumes responsibility for calling DisposeHandle when done.
kQTSCAudioPropertyID_SoundDescription = 'osdh'

A read/write SoundDescriptionHandle value that specifies the current output description as a SoundDescriptionHandle (lowest possible version for the current format). When calling QTGetComponentProperty, the caller passes a pointer to an unallocated Handle and assumes responsibility for calling DisposeHandle when done.
kQTSCAudioPropertyID_InputBasicDescription = 'isbd'

A read/write/DataProc/listen AudioStreamBasicDescription value that specifies that the current input description is an AudioStreamBasicDescription value.
kQTSCAudioPropertyID_BasicDescription = 'osbd'

A read/write/DataProc/listen AudioStreamBasicDescription value that specifies that the current output description is an AudioStreamBasicDescription value.
kQTSCAudioPropertyID_CodecSpecificSettingsArray = 'cdst'

A read/write CFArrayRef structure that designates a CFArray of CFDictionary structures, which describe various parameters specific to configuring a codec. This array of dictionaries, which is published by some compressors, can be parsed to generate UI information. When any value in the array changes, a client should call QTSetComponentProperty, passing the entire array.
kQTSCAudioPropertyID_SettingsState = scSettingsStateType

A read/write Handle value that is used to save the current state of the StandardCompressionSubTypeAudio component, so that its state may be restored at a later time with a single call. A StandardCompressionSubTypeAudio component can accept a saved settings state from a legacy StandardCompressionSubTypeSound component as write-only.
kQTSCAudioPropertyID_ExtendedProcs = scExtendedProcsType

A read/write/listen SCExtendedProcs value that is used to get or set an SCExtendedProcs structure.
kQTSCAudioPropertyID_PreferenceFlags = scPreferenceFlagsType

A read/write/listen SInt32 value that is used to specify dialog preferences such as scUseMovableModal.
kQTSCAudioPropertyID_WindowOptions = scWindowOptionsType

A read/write/listen SCWindowSettings structure that is used to set an SCWindowSettings structure, which tells the dialog about its parent window so that it can draw itself as a sheet on top of the parent.*/
enum {
kQTSCAudioPropertyID_AvailableCompressionFormatList = 'acf#',
kQTSCAudioPropertyID_ClientRestrictedCompressionFormatList = 'crf#',
kQTSCAudioPropertyID_AvailableCompressionFormatNamesList = 'cnm#',
kQTSCAudioPropertyID_HasLegacyCodecOptionsDialog = 'opn?',
kQTSCAudioPropertyID_ConstantBitRateFormatsOnly = '!vbr',
kQTSCAudioPropertyID_AvailableSampleRateList = 'avr#',
kQTSCAudioPropertyID_SampleRateRecommended = 'reco',
kQTSCAudioPropertyID_ApplicableSampleRateList = 'avr#',
kQTSCAudioPropertyID_ClientRestrictedSampleRateList = 'crr#',
kQTSCAudioPropertyID_InputMagicCookie = 'ikki',
kQTSCAudioPropertyID_MagicCookie = 'kuki',
kQTSCAudioPropertyID_ClientRestrictedLPCMBitsPerChannelList = 'crb#',
kQTSCAudioPropertyID_AvailableLPCMBitsPerChannelList = 'avb#',
kQTSCAudioPropertyID_ApplicableLPCMBitsPerChannelList = 'apb#',
kQTSCAudioPropertyID_LPCMBitsPerChannelList = 'sbc#',
kQTSCAudioPropertyID_AvailableNumChannelsList = 'anc#',
kQTSCAudioPropertyID_NumChannelsList = 'snc#',
kQTSCAudioPropertyID_InputChannelLayout = 'icly',
kQTSCAudioPropertyID_InputChannelLayoutName = 'icln',
kQTSCAudioPropertyID_ChannelLayout = 'clay',
kQTSCAudioPropertyID_ChannelLayoutName = 'clyn',
kQTSCAudioPropertyID_ClientRestrictedChannelLayoutTagList = 'crl#',
kQTSCAudioPropertyID_AvailableChannelLayoutTagList = 'acl#',
kQTSCAudioPropertyID_ChannelLayoutTagList = 'cly#',
kQTSCAudioPropertyID_AvailableChannelLayoutTagNamesList = 'cln#',
kQTSCAudioPropertyID_ApplicableChannelLayoutTagNamesList = 'apl#',
kQTSCAudioPropertyID_ClientRestrictedPCMFlags = 'crip',
kQTSCAudioPropertyID_DiscreteChannelsOK = 'dscr',
kQTSCAudioPropertyID_LPCMSpecificFlagsMask = 'sffm',
kQTSCAudioPropertyID_InputSoundDescription = 'isdh',
kQTSCAudioPropertyID_SoundDescription = 'osdh',
kQTSCAudioPropertyID_InputBasicDescription = 'isbd',
kQTSCAudioPropertyID_BasicDescription = 'osbd',
kQTSCAudioPropertyID_CodecSpecificSettingsArray = 'cdst',
kQTSCAudioPropertyID_SettingsState = scSettingsStateType,
kQTSCAudioPropertyID_ExtendedProcs = scExtendedProcsType,
kQTSCAudioPropertyID_PreferenceFlags = scPreferenceFlagsType,
kQTSCAudioPropertyID_WindowOptions = scWindowOptionsType
};
/*Device Attribute Keys for Inputs and Outputs

The following dictionary keys may be used to parse CF dictionaries returned by kQTSGAudioPropertyID_DeviceListWithAttributes and kQTSGAudioPropertyID_DeviceAttributes IDs for SGAudioMediaType channels.
kQTAudioDeviceAttribute_DeviceInputID = 'inID'

A CFNumberRef that wraps an OSType value.
kQTAudioDeviceAttribute_DeviceInputDescription = 'inds'

A CFStringRef that is suitable for displaying to the user.
kQTAudioDeviceAttribute_DeviceOutputID = 'otID'

A CFNumberRef that wraps an OSType value.
kQTAudioDeviceAttribute_DeviceOutputDescription = 'otds'

A CFStringRef that is suitable for displaying to the user.*/
enum {
kQTAudioDeviceAttribute_DeviceInputID = 'inID',
kQTAudioDeviceAttribute_DeviceInputDescription = 'inds',
kQTAudioDeviceAttribute_DeviceOutputID = 'otID',
kQTAudioDeviceAttribute_DeviceOutputDescription = 'otds'
};
/*SGModalFilterProc

Undocumented

typedef Boolean (*SGModalFilterProcPtr) (DialogPtr theDialog, const EventRecord *theEvent, short *itemHit, long refCon);

If you name your function MySGModalFilterProc, you would declare it this way:

Boolean MySGModalFilterProc (
   DialogPtr            theDialog,
   const EventRecord    *theEvent,
   short                *itemHit,
   long                 refCon );
Parameters
theDialog

A pointer to a dialog box.
theEvent

Undocumented
itemHit

Undocumented
refCon

A reference constant that the client code supplies to your callback. You can use this reference to point to a data structure containing any information your callback needs.
Return Value

Return TRUE if the event was handled, FALSE otherwise.
Declared In
QuickTimeComponents.h*/
typedef Boolean (*SGModalFilterProcPtr) (DialogPtr theDialog, const EventRecord *theEvent, short *itemHit, long refCon);

/*SGModalFilterUPP

Represents a type used by the Sequence Grabber API.

typedef STACK_UPP_TYPE(SGModalFilterProcPtr) SGModalFilterUPP;
Declared In
QuickTimeComponents.h*/
typedef STACK_UPP_TYPE(SGModalFilterProcPtr) SGModalFilterUPP;

/*ConstComponentListPtr

Represents a type used by the Sequence Grabber API.

typedef const Component * ConstComponentListPtr;
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
typedef const Component * ConstComponentListPtr;

/*SGGetPause Values

Constants passed to SGGetPause.

enum {
   seqGrabUnpause                = 0,
   seqGrabPause                  = 1,
   seqGrabPauseForMenu           = 3
};
Declared In
QuickTimeComponents.h*/

enum {
   seqGrabUnpause                = 0,
   seqGrabPause                  = 1,
   seqGrabPauseForMenu           = 3
};


/*Types

The SGDeviceInputName structure is defined as follows:

This section describes each new structure that is available in QuickTime 6. 
struct SGDeviceInputName {
   Str63                           name;
   Handle                          icon;
   long                            flags;
   long                            reserved; // zero
};
typedef struct SGDeviceInputName SGDeviceInputName;
enum {
   sgDeviceInputNameFlagInputUnavailable = (1 << 0)
};
struct SGDeviceInputListRecord {
   short                           count;
   short                           selectedIndex;
   long                            reserved; //zero
   SGDeviceInputName               entry[1];
};
typedef struct SGDeviceInputListRecord  SGDeviceInputListRecord;
typedef SGDeviceInputListRecord *       SGDeviceInputListPtr;
typedef SGDeviceInputListPtr *          SGDeviceInputList;*/
struct SGDeviceInputName {
   Str63                           name;
   Handle                          icon;
   long                            flags;
   long                            reserved; // zero
};
typedef struct SGDeviceInputName SGDeviceInputName;
enum {
   sgDeviceInputNameFlagInputUnavailable = (1 << 0)
};
struct SGDeviceInputListRecord {
   short                           count;
   short                           selectedIndex;
   long                            reserved; //zero
   SGDeviceInputName               entry[1];
};
typedef struct SGDeviceInputListRecord  SGDeviceInputListRecord;
typedef SGDeviceInputListRecord *       SGDeviceInputListPtr;
typedef SGDeviceInputListPtr *          SGDeviceInputList;

/*The SGDeviceName structure is re-defined as follows:
struct SGDeviceName {
   Str63                           name;
   Handle                          icon;
   long                            flags;
   long                            refCon;
   SGDeviceInputList               inputs; // list of inputs; formerly reserved to 0
};
typedef struct SGDeviceName SGDeviceName;
enum {
   sgDeviceNameFlagDeviceUnavailable = (1 << 0),
   sgDeviceNameFlagShowInputsAsDevices = (1 << 1)
};*/
struct SGDeviceName {
   Str63                           name;
   Handle                          icon;
   long                            flags;
   long                            refCon;
   SGDeviceInputList               inputs; // list of inputs; formerly reserved to 0
};
typedef struct SGDeviceName SGDeviceName;
enum {
   sgDeviceNameFlagDeviceUnavailable = (1 << 0),
   sgDeviceNameFlagShowInputsAsDevices = (1 << 1)
};

/*The SGDeviceListRecord structure is defined as follows:
struct SGDeviceListRecord {
   short                           count;
   short                           selectedIndex;
   long                            reserved; //zero
   SGDeviceName                    entry[1];
};
typedef struct SGDeviceListRecord       SGDeviceListRecord;
typedef SGDeviceListRecord *            SGDeviceListPtr;
typedef SGDeviceListPtr *               SGDeviceList;
enum {
   sgDeviceListWithIcons       = (1 << 0),
   sgDeviceListDontCheckAvailability = (1 << 1),
   sgDeviceListIncludeInputs   = (1 << 2)
};


The new flag sgDeviceListIncludeInputs is passed to SGGetChannelDeviceList if the caller desires to get the list of inputs as well as the devices. If this flag is not passed, the old behavior of just listing devices is retained.*/
struct SGDeviceListRecord {
   short                           count;
   short                           selectedIndex;
   long                            reserved; //zero
   SGDeviceName                    entry[1];
};
typedef struct SGDeviceListRecord       SGDeviceListRecord;
typedef SGDeviceListRecord *            SGDeviceListPtr;
typedef SGDeviceListPtr *               SGDeviceList;
enum {
   sgDeviceListWithIcons       = (1 << 0),
   sgDeviceListDontCheckAvailability = (1 << 1),
   sgDeviceListIncludeInputs   = (1 << 2)
};

/*SGDeviceListPtr

Represents a type used by the Sequence Grabber API.

typedef SGDeviceListRecord * SGDeviceListPtr;
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
typedef SGDeviceListRecord * SGDeviceListPtr;

/*SGDeviceList

Represents a type used by the Sequence Grabber API.

typedef SGDeviceListPtr * SGDeviceList;
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
typedef SGDeviceListPtr * SGDeviceList;

/*SGChannel

Represents a type used by the Sequence Grabber API.

typedef ComponentInstance SGChannel;
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
typedef ComponentInstance SGChannel;

/*SGDataProc

Undocumented

typedef OSErr (*SGDataProcPtr) (SGChannel c, Ptr p, long len, long *offset, long chRefCon, TimeValue time, short writeType, long refCon);

If you name your function MySGDataProc, you would declare it this way:

OSErr MySGDataProc (
   SGChannel    c,
   Ptr          p,
   long         len,
   long         *offset,
   long         chRefCon,
   TimeValue    time,
   short        writeType,
   long         refCon );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
p

Undocumented
len

Undocumented
offset

Undocumented
chRefCon

Undocumented
time

Undocumented
writeType

Undocumented
refCon

A reference constant that the client code supplies to your callback. You can use this reference to point to a data structure containing any information your callback needs.
Return Value

See Error Codes. Your callback should return noErr if there is no error.
Declared In
QuickTimeComponents.h*/
typedef OSErr (*SGDataProcPtr) (SGChannel c, Ptr p, long len, long *offset, long chRefCon, TimeValue time, short writeType, long refCon);


/*SGDataUPP

Represents a type used by the Sequence Grabber API.

typedef STACK_UPP_TYPE(SGDataProcPtr) SGDataUPP;
Declared In
QuickTimeComponents.h*/
typedef STACK_UPP_TYPE(SGDataProcPtr) SGDataUPP;

/*SeqGrabComponent

Represents a type used by the Sequence Grabber API.

typedef ComponentInstance SeqGrabComponent;
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
typedef ComponentInstance SeqGrabComponent;

/*SGAudioCallbackStruct

Used to call an SGAudioCallbackProc.

struct SGAudioCallbackStruct {
   SGAudioCallback    inputProc;
   void               *inputProcRefCon;
};
Fields
inputProc

An SGAudioCallbackProc.
inputProcRefCon

A reference constant. Use this parameter to point to a data structure containing any information your callback needs.
Version Notes

Introduced in QuickTime 7.
Availability
Carbon status: Supported; C interface file: Movies.h*/
struct SGAudioCallbackStruct {
   SGAudioCallback    inputProc;
   void               *inputProcRefCon;
};
typedef  struct SGAudioCallbackStruct SGAudioCallbackStruct;


/*Dictionary Keys

The dictionary keys listed in this section are used with c ertain of the property IDs listed in “SGAudio Component Property IDs”. They may be used to parse CF dictionaries returned by kQTSGAudioPropertyID_DeviceListWithAttributes and kQTSGAudioPropertyID_DeviceAttributes IDs for SGAudioMediaType channels.
kQTAudioDeviceAttribute_DeviceUIDKey = 'uid '

A CFStringRef containing a unique identifier for a device.
kQTAudioDeviceAttribute_DeviceNameKey = 'name'

A CFStringRef containing a device’s printable name, suitable for the user interface.
kQTAudioDeviceAttribute_DeviceManufacturerKey = 'manu'

A CFStringRef containing a device manufacturer’s printable name, suitable for the user interface.
kQTAudioDeviceAttribute_DeviceTransportTypeKey = 'tran'

A CFNumberRef that wraps an OSType; for example, '1394' for fw. See the file IOAudioTypes.h.
kQTAudioDeviceAttribute_DeviceAliveKey = 'aliv'

A CFBooleanRef value that is TRUE if the device is present.
kQTAudioDeviceAttribute_DeviceCanRecordKey = 'rec ' [last char = space]

A CFBooleanRef value that is TRUE if the device can be used for recording (some devices can only play back).
kQTAudioDeviceAttribute_DeviceCanPreviewKey = 'prev'

A CFBooleanRef value that is TRUE if the device can be used to preview a grabbed sequence.
kQTAudioDeviceAttribute_DeviceHoggedKey = 'hogg'

A CFNumberRef that wraps the unique process ID that is hogging the device, or –1 if the device is currently not being hogged. The process ID comes from a call to getpid.
kQTAudioDeviceAttribute_DeviceInUseKey = 'used'

A CFBooleanRef value that is TRUE if the device is performing I/O in any process.
kQTAudioDeviceAttribute_DeviceSupportsHardwarePlaythruKey = 'hard'

A CFBooleanRef value that is TRUE if the device supports hardware playthrough of inputs to outputs.
kQTAudioDeviceAttribute_DefaultInputDeviceKey = 'dIn ' [last char = space]

A CFBooleanRef value that’s TRUE if the device is the user-selected default input in an audio MIDI setup.
kQTAudioDeviceAttribute_DefaultOutputDeviceKey = 'dOut'

A CFBooleanRef value that’s TRUE if the device is the user-selected default output in an audio MIDI setup.
kQTAudioDeviceAttribute_DefaultSystemOutputDeviceKey = 'sOut'

A CFBooleanRef value that’s TRUE if the device is the user-selected device where system alerts play.
kQTAudioDeviceAttribute_IsCoreAudioDeviceKey = 'hal!'

A CFBooleanRef value that’s TRUE if the device is a Core Audio device.*/
enum {
kQTAudioDeviceAttribute_DeviceUIDKey = 'uid ' ,
kQTAudioDeviceAttribute_DeviceNameKey = 'name' ,
kQTAudioDeviceAttribute_DeviceManufacturerKey = 'manu' ,
kQTAudioDeviceAttribute_DeviceTransportTypeKey = 'tran',
kQTAudioDeviceAttribute_DeviceAliveKey = 'aliv',
kQTAudioDeviceAttribute_DeviceCanRecordKey = 'rec ' ,
kQTAudioDeviceAttribute_DeviceCanPreviewKey = 'prev',
kQTAudioDeviceAttribute_DeviceHoggedKey = 'hogg',
kQTAudioDeviceAttribute_DeviceInUseKey = 'used',
kQTAudioDeviceAttribute_DeviceSupportsHardwarePlaythruKey = 'hard',
kQTAudioDeviceAttribute_DefaultInputDeviceKey = 'dIn ' ,
kQTAudioDeviceAttribute_DefaultOutputDeviceKey = 'dOut',
kQTAudioDeviceAttribute_DefaultSystemOutputDeviceKey = 'sOut',
kQTAudioDeviceAttribute_IsCoreAudioDeviceKey = 'hal!'
};

/*SGAudio Component Property IDs

This section lists the property IDs for SGAudioMediaType channels. Besides the IDs defined below, SGAudioMediaType channels respond to kComponentPropertyInfoList and kComponentPropertyClassPropertyInfo selectors, which return CFDataRef structures containing arrays of ComponentPropertyInfo structures as defined in the file ImageCompression.h.
kQTSGAudioPropertyID_DeviceListWithAttributes = '#dva'

Used with kQTPropertyClass_SGAudio in read and listen modes to get an array of CFDictionaryRef structures. Each dictionary represents the attributes of one audio device. See Dictionary Keys for a list of supported dictionary keys. If the device list changes (for example, if a device is hotplugged or unplugged), listeners of this property will be notified. The caller is responsible for calling CFRelease to release the resulting CFArray.
kQTSGAudioPropertyID_DeviceAttributes = 'deva'

Used with kQTPropertyClass_SGAudioRecordDevice and kQTPropertyClass_SGAudioPreviewDevice in read only mode to get a CFDictionaryRef structure representing the attributes of a specified audio device (record or preview). See Dictionary Keys for a list of supported dictionary keys. Not all keys are guaranteed to be present for a given device. The caller is responsible for calling CFRelease to release the resulting CFDictionary.
kQTSGAudioPropertyID_DeviceUID = 'uid ' [last character is space]

Used with kQTPropertyClass_SGAudioRecordDevice and kQTPropertyClass_SGAudioPreviewDevice in read and write modes to get a CFString with an audio device’s unique ID for the current recording or preview or set the current recording or preview device to a specified audio device’s unique ID. You can obtain a list of devices on the user’s system with kQTSGAudioPropertyID_DeviceListWithAttributes. The caller is responsible for calling CFRelease to release the resulting CFString.
kQTSGAudioPropertyID_ChannelLayout = 'clay'

Used with kQTPropertyClass_SGAudioRecordDevice, kQTPropertyClass_SGAudio, and kQTPropertyClass_SGAudioPreviewDevice in read and write modes to get or set an AudioChannelLayout structure representing the spatial or discrete channel layout. If used with kQTPropertyClass_SGAudio, the AudioChannelLayout refers to the channels in the resulting QuickTime movie sound track. If used with kQTPropertyClass_SGAudioRecordDevice, the AudioChannelLayout refers to the input channels on the record device. If used with kQTPropertyClass_SGAudioPreviewDevice, the AudioChannelLayout refers to the preview device’s output channels. AudioChannelLayout is a variable size structure, so before calling QTGetComponentProperty you should call QTGetComponentPropertyInfo to discover the size of the block of memory you must allocate to hold the result.
kQTSGAudioPropertyID_MagicCookie = 'kuki'

Used with kQTPropertyClass_SGAudio in read and write modes to access opaque data structures representing get or set compressor-specific out-of-band settings. This property is applicable only to compressed formats that use a cookie, such as AAC and AMR.
kQTSGAudioPropertyID_ChannelMap = 'cmap'

Used with kQTPropertyClass_SGAudioRecordDevice in read and write modes to access a C-style array of SInt32 structures that let a client enable or disable channels on a recording device, as well as reorder them or duplicate them to several output channels. This property need not be set if a client wishes to capture all channels from the record device; this is the default behavior. Each element in the SInt32 array represents one output bus (into the SGAudioChannel) from the record device. The value of each element is the zero-based source channel on the input device that should feed the specified output. Channel-disabling example: if you wish to capture just the 1st, 3rd, and 5th channels from a 6-channel input device, your channel map should be SInt32 map[3] = { 0, 2, 4 }. Channel-reordering example: if you wish to capture both channels from a stereo input device, but you know the left and right channels are reversed in the data source, set your channel map to SInt32 map[2] = { 1, 0 }. Channel-duplication example: if you wish to duplicate the second source channel into 4 outputs, set your channel map to SInt32 map[4] = { 1, 1, 1, 1 }. Empty channel example: if you need to produce a conformant stream of audio (such as a 6-channel stream to send to an external 5.1 AC3 encoder), but you have audio only for the L, R, and C channels (on record device channels 0, 1, and 2), you may set your channel map to SInt32 map[6] = { 0, 1, 2, -1, -1, -1 }. The last 3 channels will be filled with silence.
kQTSGAudioPropertyID_StreamFormat = 'frmt'

Used with kQTPropertyClass_SGAudioRecordDevice, kQTPropertyClass_SGAudio, and kQTPropertyClass_SGAudioPreviewDevice in read and write modes to access AudioStreamBasicDescription structures that let you get or set the format of the audio as it will be written to the destination QuickTime movie track. When used with kQTPropertyClass_SGAudioRecordDevice, this property ID gets and sets the format of audio as it is physically recorded on the device. The format must be one of the formats passed in kQTSGAudioPropertyID_StreamFormatList. The mChannelsPerFrame of the StreamFormat read from the record device will not reflect channels that have been enabled or disabled with the ChannelMap property.
kQTSGAudioPropertyID_StreamFormatList = '#frm'

Used with kQTPropertyClass_SGAudioRecordDevice and kQTPropertyClass_SGAudioPreviewDevice in read-only mode to get an array of AudioStreamBasicDescription structures that describe valid combinations of settings supported by the physical device in its current configuration (sample rate, bit depth, number of channels).
kQTSGAudioPropertyID_InputSelection = 'inpt'

Used with kQTPropertyClass_SGAudioRecordDevice in read and write modes to get an OSType value that lets you change the current input selection in devices that allow switching between data sources, such as analog, adat, sdi, aes/ebu, and spdif. When the input selection changes, the StreamFormat of the device may change as well; in particular, the number of channels may change.
kQTSGAudioPropertyID_InputListWithAttributes = '#inp'

Used with kQTPropertyClass_SGAudioRecordDevice in read-only mode to get a CFArrayRef structure that represents the list of available input sources for a given device. A CFArrayRef of CFDictionaryRef values is returned, where each one represents the attributes of one input. See “Dictionary Keys” for a list of valid keys. The caller is responsible for calling CFRelease to release the returned array.
kQTSGAudioPropertyID_OutputSelection = 'otpt'

Used with kQTPropertyClass_SGAudioPreviewDevice in read and write modes to get an OSType value that lets you change the current output selection in devices that allow switching between output destinations, such as analog, adat, sdi, aes/ebu, and spdif. When the output selection changes, the StreamFormat of the device may change as well; in particular, the number of channels may change.
kQTSGAudioPropertyID_OutputListWithAttributes = '#otp'

Used with kQTPropertyClass_SGAudioPreviewDevice in read-only mode to get a CFArrayRef structure that represents the list of available output destinations for a given device. A CFArrayRef of CFDictionaryRef values is returned, where each one represents the attributes of one output. See “Dictionary Keys” for a list of valid keys. The caller is responsible for calling CFRelease to release the returned array.
kQTSGAudioPropertyID_SoundDescription = 'snds'

Used with kQTPropertyClass_SGAudio in read and write modes to get a SoundDescriptionHandle value for the sound description that describes the data written to a QuickTime movie track. A QTGetComponentProperty call allocates the SoundDescriptionHandle for you. The caller should declare the SoundDescriptionHandle and set it to NULL, then pass its address to QTGetComponentProperty. The caller must call DisposeHandle to dispose of the resulting SoundDescriptionHandle when done with it.
kQTSGAudioPropertyID_LevelMetersEnabled = 'lmet'

Used with kQTPropertyClass_SGAudioRecordDevice, kQTPropertyClass_SGAudio, and kQTPropertyClass_SGAudioPreviewDevice in read and write modes to access a Boolean value that controls metering. When used with kQTPropertyClass_SGAudioRecordDevice or kQTPropertyClass_SGAudioPreviewDevice, this property ID turns device level metering on or off. When used with kQTPropertyClass_SGAudio, it turns output level metering on or off. When level meters are enabled, you can use kQTSGAudioPropertyID_AveragePowerLevels to get instantaneous levels, or kQTSGAudioPropertyID_PeakHoldLevels to get peak-hold style meters, which are better for clipping detection. Level meters should be enabled only if you intend to poll for levels, because they place an added load on the CPU when enabled.
kQTSGAudioPropertyID_PeakHoldLevels = 'phlv'

Used with kQTPropertyClass_SGAudioRecordDevice, kQTPropertyClass_SGAudio, and kQTPropertyClass_SGAudioPreviewDevice in read-only mode to get a C-style array of Float32 values representing in dB the peak hold levels for each channel on a device or output. This property ID may be used only when level meters are enabled (by using kQTSGAudioPropertyID_LevelMetersEnabled). Poll for peak hold levels as often as you would like, to update the user interface or look for clipping. The number of elements in the Float32 array will be equal to the number of input channels on your record device for kQTPropertyClass_SGAudioRecordDevice, or the number of elements in your kQTSGAudioPropertyID_ChannelMap, if you've set one. It will be equal to the number of output channels on your preview device for kQTPropertyClass_SGAudioPreviewDevice and equal to the number of channels in your kQTSGAudioPropertyID_StreamFormat (format.mChannelsPerFrame) for kQTPropertyClass_SGAudio. If no channel mixdown is being performed between record device and output formats, then the kQTSGAudioPropertyID_PeakHoldLevels values for kQTPropertyClass_SGAudioRecordDevice and kQTPropertyClass_SGAudio will be equivalent. If you have requested hardware playthrough, level metering will be unavailable.
kQTSGAudioPropertyID_AveragePowerLevels = 'aplv'

Used with kQTPropertyClass_SGAudioRecordDevice, kQTPropertyClass_SGAudio, and kQTPropertyClass_SGAudioPreviewDevice in read-only mode to get a C-style array of Float32 values representing in dB the average power levels for each channel on a device or output. This property ID may be used only when level meters are enabled (by using kQTSGAudioPropertyID_LevelMetersEnabled). Poll for average power levels as often as you would like, to update the user interface. The number of elements in the Float32 array will be equal to the number of input channels on your record device for kQTPropertyClass_SGAudioRecordDevice, or the number of elements in your kQTSGAudioPropertyID_ChannelMap, if you've set one. It will be equal to the number of output channels on your preview device for kQTPropertyClass_SGAudioPreviewDevice and equal to the number of channels in your kQTSGAudioPropertyID_StreamFormat (format.mChannelsPerFrame) for kQTPropertyClass_SGAudio. If no channel mixdown is being performed between record device and output formats, then the kQTSGAudioPropertyID_AveragePowerLevels values for kQTPropertyClass_SGAudioRecordDevice and kQTPropertyClass_SGAudio will be equivalent. If you have requested hardware playthrough, level metering will be unavailable.
kQTSGAudioPropertyID_Settings = 'setu'

Used with kQTPropertyClass_SGAudio in read and write modes to access UserData values. This property takes supersedes the SGGet/SetChannelSettings calls. An SGAudioMediaType channel accepts old-style 'soun' SGChannel settings in a QTSetComponentProperty call, but always produces new-style settings in a QTGetComponentProperty call.
kQTSGAudioPropertyID_MasterGain = 'mgan'

Used with kQTPropertyClass_SGAudioRecordDevice, kQTPropertyClass_SGAudio, and kQTPropertyClass_SGAudioPreviewDevice in read and write modes to access a Float32 value that represents the master gain on a physical recording device with 0.0 = minimum volume and 1.0 = the maximum volume of the device. With kQTPropertyClass_SGAudioPreviewDevice, this property gets or sets the master gain on the physical previewing device with 0.0 = minimum volume and 1.0 = the maximum volume of the device. With kQTPropertyClass_SGAudio, this property gets or sets the master gain (volume) of the recorded audio data in software (pre-mixdown) with minimum = 0.0, maximum = unbounded. Normally you wouldn't set the volume greater than 1.0, but if the source sound level provided by the device is too low, you may set a gain greater than 1.0 to boost the gain. Some devices cannot respond to this property setting.
kQTSGAudioPropertyID_PerChannelGain = 'cgan'

Used with kQTPropertyClass_SGAudioRecordDevice, kQTPropertyClass_SGAudio, and kQTPropertyClass_SGAudioPreviewDevice in read and write modes to access a C-style array of Float32 value that represents the gain of each channel on a physical recording device. The number of channels in the array for kQTPropertyClass_SGAudioRecordDevice and kQTPropertyClass_SGAudioPreviewDevice is equal to the total number of channels on the device, which can be discovered using kQTSGAudioPropertyID_StreamFormat. The number and order of channels in the array for the kQTPropertyClass_SGAudio class must correspond to the valence of channels on the output (which is affected by a channel map, if you've set one). With kQTPropertyClass_SGAudio, this property gets and sets the gain (volume) of each channel of recorded audio data in software. Levels set on the record device or preview device must be in the range minimum = 0.0, maximum = 1.0. Levels set in software may be set to values greater than 1.0 in order to boost low signals. The caller may specify that a particular channel gain level should be left alone by setting the value to –1.0. For instance, to set the gain of channels 1, 2, and 3 to 0.5 on a 6 channel device, pass the following array values in a SetProperty call: { 0.5, 0.5, 0.5, -1., -1., -1. }.
kQTSGAudioPropertyID_HardwarePlaythruEnabled = 'hard'

Used with kQTPropertyClass_SGAudioRecordDevice in read and write modes to access a Boolean value representing the state of hardware playthrough during seqGrabPreview or seqGrabPlayDuringRecord operations. Setting this value will have no effect if the record device and preview device are not the same. Some devices do not support hardware playthrough; devices report whether or not they support this feature through the kQTSGAudioPropertyID_DeviceListWithAttributes property.
kQTSGAudioPropertyID_ChunkSize = 'chnk'

Used with kQTPropertyClass_SGAudio in read and write modes to access a Float32 value representing the number of seconds of audio that the SGAudioChannel should buffer before writing.
kComponentPropertyInfoList = 'list'

Used with kComponentPropertyClassPropertyInfo in read-only mode as defined in the file ImageCompression.h.
kQTSGAudioPropertyID_DeviceAlive = 'aliv'

Used with kQTPropertyClass_SGAudioRecordDevice and kQTPropertyClass_SGAudioPreviewDevice in read and listen modes to get a Boolean value telling whether or not a device is alive. If the device is hot unplugged, listeners of this property will be notified. If a record or preview operation is in progress it will be stopped, but it is left to the client to select a new device.
kQTSGAudioPropertyID_DeviceHogged = 'hogg'

Used with kQTPropertyClass_SGAudioRecordDevice and kQTPropertyClass_SGAudioPreviewDevice in read, write, and listen modes to get a Boolean value telling whether a device has become hogged or unhogged by another process. If so, listeners of this property will be notified. SGAudioMediaType channel does not hog devices, but a client that has reason to gain exclusive access to a device may set this property to TRUE.
kQTSGAudioPropertyID_DeviceInUse = 'used'

Used with kQTPropertyClass_SGAudioRecordDevice and kQTPropertyClass_SGAudioPreviewDevice in read and listen modes to get a Boolean value that tells whether a device is in use. If the device starts to be used (for instance, when another process starts performing I/O with it), listeners of this property will be notified.
kQTSGAudioPropertyID_MixerCoefficients = 'mixc'

Used with kQTPropertyClass_SGAudio in read and write modes to access a C-style array of Float32 values representing a set of coefficients for mixdown. If you wish to perform a custom mixdown from the incoming record device channel valence (discoverable using a combination of kQTPropertyClass_SGAudioRecordDevice, kQTSGAudioPropertyID_StreamFormat, kQTPropertyClass_SGAudioRecordDevice, and kQTSGAudioPropertyID_ChannelMap) to a different output number of channels (using kQTPropertyClass_SGAudio and kQTSGAudioPropertyID_StreamFormat), you may specify your own set of mixer coefficients which will be set as volume values at each crosspoint in SGAudioMediaType’s internal matrix mixer. The value you pass is a two-dimensional array of Float32 values where the first dimension (rows) is the input channel and the second dimension (columns) is the output channel. Each Float32 value contains one gain level to apply.
kQTSGAudioPropertyID_PreMixCallback = '_mxc'

Used with kQTPropertyClass_SGAudio in read and write modes to access a pre-mix SGAudioCallbackStruct. If you wish to receive a callback when new audio samples become available from a recording device (before they've been mixed down), set this property using an SGAudioCallbackStruct containing a pointer to your SGAudioCallback function and a reference constant (RefCon). If you have previously registered a callback and no longer wish to receive it, call QTSetComponentProperty again, this time passing NULL for your inputProc and 0 for your inputRefCon.
kQTSGAudioPropertyID_PreMixCallbackFormat = '_mcf'

Used with kQTPropertyClass_SGAudio in read-only mode to get an AudioStreamBasicDescription structure representing the format of the audio that will be received by your pre-mix SGAudioCallback function. Note that the format may not be available until you've called SGPrepare.
kQTSGAudioPropertyID_PostMixCallback = 'mx_c'

Used with kQTPropertyClass_SGAudio in read and write modes to access a post-mix SGAudioCallbackStruct. If you wish to receive a callback after audio samples have been mixed (the first step after they are received from a recording device by SGAudioMediaType channel), set this property ID using an SGAudioCallbackStruct containing a pointer to your SGAudioCallback function and a reference constant (RefCon). If you have previously registered a callback and no longer wish to receive it, call QTSetComponentProperty again, this time passing NULL for your inputProc and 0 for your inputRefCon.
kQTSGAudioPropertyID_PostMixCallbackFormat = 'm_cf'

Used with kQTPropertyClass_SGAudio in read-only mode to get an AudioStreamBasicDescription structure representing the format of the audio that will be received by your post-mix SGAudioCallback function. Note that the format may not be available until you've called SGPrepare.
kQTSGAudioPropertyID_PreConversionCallback = '_cvc'

Used with kQTPropertyClass_SGAudio in read and write modes to access a pre-conversion SGAudioCallbackStruct. If you wish to receive a callback just before audio samples are about to be sent through an audio converter (for format conversion or compression), set this property ID using an SGAudioCallbackStruct containing a pointer to your SGAudioCallback function and a reference constant (RefCon). If you have previously registered a callback and no longer wish to receive it, call QTSetComponentProperty again, this time passing NULL for your inputProc and 0 for your inputRefCon.
kQTSGAudioPropertyID_PreConversionCallbackFormat = '_ccf'

Used with kQTPropertyClass_SGAudio in read-only mode to get an AudioStreamBasicDescription structure representing the format of the audio that will be received by your pre-conversion SGAudioCallback function. Note that the format may not be available until you've called SGPrepare.
kQTSGAudioPropertyID_PostConversionCallback = 'cv_c'

Used with kQTPropertyClass_SGAudio in read and write modes to access a post-conversion SGAudioCallbackStruct. If you wish to receive a callback right after audio samples have been sent through an audio converter (for format conversion or compression), set this property ID using an SGAudioCallbackStruct containing a pointer to your SGAudioCallback function and a reference constant (RefCon). If you have previously registered a callback and no longer wish to receive it, call QTSetComponentProperty again, this time passing NULL for your inputProc and 0 for your inputRefCon.
kQTSGAudioPropertyID_PostConversionCallbackFormat = 'c_cf'

Used with kQTPropertyClass_SGAudio in read-only mode to get an AudioStreamBasicDescription structure representing the format of the audio that will be received by your post-conversion SGAudioCallback function. Note that the format may not be available until you've called SGPrepare.*/
enum {
kQTSGAudioPropertyID_DeviceListWithAttributes = '#dva',
kQTSGAudioPropertyID_DeviceAttributes = 'deva',
kQTSGAudioPropertyID_DeviceUID = 'uid ' ,
kQTSGAudioPropertyID_ChannelLayout = 'clay',
kQTSGAudioPropertyID_MagicCookie = 'kuki',
kQTSGAudioPropertyID_ChannelMap = 'cmap',
kQTSGAudioPropertyID_StreamFormat = 'frmt',
kQTSGAudioPropertyID_StreamFormatList = '#frm',
kQTSGAudioPropertyID_InputSelection = 'inpt',
kQTSGAudioPropertyID_InputListWithAttributes = '#inp',
kQTSGAudioPropertyID_OutputSelection = 'otpt',
kQTSGAudioPropertyID_OutputListWithAttributes = '#otp',
kQTSGAudioPropertyID_SoundDescription = 'snds',
kQTSGAudioPropertyID_LevelMetersEnabled = 'lmet',
kQTSGAudioPropertyID_PeakHoldLevels = 'phlv',
kQTSGAudioPropertyID_AveragePowerLevels = 'aplv',
kQTSGAudioPropertyID_Settings = 'setu',
kQTSGAudioPropertyID_MasterGain = 'mgan',
kQTSGAudioPropertyID_PerChannelGain = 'cgan',
kQTSGAudioPropertyID_HardwarePlaythruEnabled = 'hard',
kQTSGAudioPropertyID_ChunkSize = 'chnk',
//kComponentPropertyInfoList = 'list',
kQTSGAudioPropertyID_DeviceAlive = 'aliv',
kQTSGAudioPropertyID_DeviceHogged = 'hogg',
kQTSGAudioPropertyID_DeviceInUse = 'used',
kQTSGAudioPropertyID_MixerCoefficients = 'mixc',
kQTSGAudioPropertyID_PreMixCallback = '_mxc',
kQTSGAudioPropertyID_PreMixCallbackFormat = '_mcf',
kQTSGAudioPropertyID_PostMixCallback = 'mx_c',
kQTSGAudioPropertyID_PostMixCallbackFormat = 'm_cf',
kQTSGAudioPropertyID_PreConversionCallback = '_cvc',
kQTSGAudioPropertyID_PreConversionCallbackFormat = '_ccf',
kQTSGAudioPropertyID_PostConversionCallback = 'cv_c',
kQTSGAudioPropertyID_PostConversionCallbackFormat = 'c_cf'
};

/*SGAudio Component Property Classes

Every SGAudioMediaType channel uses standard QuickTime component property selectors to get, set, and listen to properties. Each component property takes a property class as well as a property ID. SGAudioMediaType channels use the property classes listed in this section.SGAudioMediaType                       = 'audi'
kQTPropertyClass_SGAudio                 = 'audo'
kQTPropertyClass_SGAudioRecordDevice     = 'audr'
kQTPropertyClass_SGAudioPreviewDevice    = 'audp'

'audo'

Used with properties that pertain to the SGChannel as a whole, or to the output of an SGAudioChannel (that is, with the resulting track in a QuickTime movie).
'audr'

Used with properties that pertain specifically to an SGAudioChannel recording device’s physical settings.
'audp'

Used with properties that pertain specifically to an SGAudioChannel preview device’s physical settings.

For the property IDs used with these classes. see “SGAudio Component Property IDs”.*/
enum {
SGAudioMediaType                       = 'audi',
kQTPropertyClass_SGAudio                 = 'audo',
kQTPropertyClass_SGAudioRecordDevice     = 'audr',
kQTPropertyClass_SGAudioPreviewDevice    = 'audp'
};

/*QTComponentPropertyInfo

Stores information for component property functions.

struct ComponentPropertyInfo {
   ComponentPropertyClass    propClass;
   ComponentPropertyID       propID;
   ComponentValueType        propType;
   ByteCount                 propSize;
   UInt32                    propFlags;
};
Fields
propClass

A value of type OSType that specifies a property class:
kComponentPropertyClassPropertyInfo ('pnfo')

A QTComponentPropertyInfo structure that defines a property information class.
kComponentPropertyInfoList ('list')

An array of QTComponentPropertyInfo structures, one for each property.
kComponentPropertyCacheSeed ('seed')

A component property cache seed value.
kComponentPropertyExtendedInfo ('meta')

A CFDictionary with extended property information.
kComponentPropertyCacheFlags ('flgs')

One of the following two flags:
kComponentPropertyCacheFlagNotPersistent

Property metadata should not be saved in persistent cache.
kComponentPropertyCacheFlagIsDynamic

Property metadata should not be cached at all.
propID

A value of type OSType that specifies a property ID.
propType

The type of the property.
propSize

The size of the property in bytes.
propFlags

Component property flags.
Version Notes

Introduced in QuickTime 6.4.
Availability
Carbon status: Supported; C interface file: QuickTimeComponents.h
Platform Considerations

Associated functions: QTAddComponentPropertyListener, QTComponentPropertyListenerCollectionAddListener, QTComponentPropertyListenerCollectionHasListenersForProperty, QTComponentPropertyListenerCollectionNotifyListeners, QTComponentPropertyListenerCollectionRemoveListener, QTGetComponentProperty, QTGetComponentPropertyInfo, QTRemoveComponentPropertyListener, QTSetComponentProperty, QTComponentPropertyListenerFilterProc, QTComponentPropertyListenerProc*/
struct ComponentPropertyInfo {
   ComponentPropertyClass    propClass;
   ComponentPropertyID       propID;
   ComponentValueType        propType;
   ByteCount                 propSize;
   UInt32                    propFlags;
};

typedef  struct ComponentPropertyInfo ComponentPropertyInfo ;

/*SeqGrabComponent

Represents a type used by the Sequence Grabber API.

typedef ComponentInstance SeqGrabComponent;
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
typedef ComponentInstance SeqGrabComponent;

/*seqGrabAppendToFile

Constants grouped with seqGrabAppendToFile.

enum {
   seqGrabToDisk                 = 1,
   seqGrabToMemory               = 2,
   seqGrabDontUseTempMemory      = 4,
   seqGrabAppendToFile           = 8,
   seqGrabDontAddMovieResource   = 16,
   seqGrabDontMakeMovie          = 32,
   seqGrabPreExtendFile          = 64,
   seqGrabDataProcIsInterruptSafe = 128,
   seqGrabDataProcDoesOverlappingReads = 256,
   seqGrabDontPreAllocateFileSize = 512  /* Don't set the size of the file before capture unless the file has been pre-extended */
//};
//Declared In
//QuickTimeComponents.h*/

enum {
   seqGrabToDisk                 = 1,
   seqGrabToMemory               = 2,
   seqGrabDontUseTempMemory      = 4,
   seqGrabAppendToFile           = 8,
   seqGrabDontAddMovieResource   = 16,
   seqGrabDontMakeMovie          = 32,
   seqGrabPreExtendFile          = 64,
   seqGrabDataProcIsInterruptSafe = 128,
   seqGrabDataProcDoesOverlappingReads = 256,
   seqGrabDontPreAllocateFileSize = 512  /* Don't set the size of the file before capture unless the file has been pre-extended */
};
/*Two new usage flags have also been defined so that your application can indicate to the sequence grabber (and thus the VDIG) that it is not being used in a conventional recording mode.
enum {
    seqGrabRecord               = 1,
    seqGrabPreview              = 2,
    seqGrabPlayDuringRecord     = 4,
    seqGrabLowLatencyCapture    = 8, /* return the freshest frame
                                        possible, for live work
                                        (i.e. videoconferencing,  live
                                        broadcast, live image processing)
                                                                     */
 
   // seqGrabAlwaysUseTimeBase    = 16 /* Tell VDIGs to use TimebaseTime
        //                                always, rather than creating
       //                                 uniform frame durations,  for more
       //                                 accurate live sync with  audio */
//};*

enum {
    seqGrabRecord               = 1,
    seqGrabPreview              = 2,
    seqGrabPlayDuringRecord     = 4,
    seqGrabLowLatencyCapture    = 8, /* return the freshest frame
                                        possible, for live work
                                        (i.e. videoconferencing,  live
                                        broadcast, live image processing)
                                                                     */
 
    seqGrabAlwaysUseTimeBase    = 16 /* Tell VDIGs to use TimebaseTime
                                        always, rather than creating
                                        uniform frame durations,  for more
                                        accurate live sync with  audio */
};
typedef unsigned long SeqGrabUsageEnum;

/*SGChannel

Represents a type used by the Sequence Grabber API.

typedef ComponentInstance SGChannel;
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
typedef ComponentInstance SGChannel;

/*SeqGrabComponent

Represents a type used by the Sequence Grabber API.

typedef ComponentInstance SeqGrabComponent;
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
typedef ComponentInstance SeqGrabComponent;

/*Component Identifiers

Identify the types of components.

clockComponentType                 ='clok'
compressorComponentType            ='imco'
CreateFilePreviewComponentType     ='pmak'
DataHandlerType                    ='dhlr'
decompressorComponentType          ='imdc'
MediaHandlerType                   ='mhlr'
MovieControllerComponentType       ='play'
MovieExportType                    ='spit'
MovieImportType                    ='eat '
SeqGrabChannelType                 ='sgch'
SeqGrabComponentType               ='barg'
SeqGrabCompressionPanelType        ='cmpr'
SeqGrabPanelType                   ='sgpn'
SeqGrabSourcePanelType             ='sour'
ShowFilePreviewComponentType       ='pnot'
StandardCompressionSubType         ='imag'
StandardCompressionSubTypeSound    ='soun'
StandardCompressionType            ='scdi'
systemMicrosecondClock             ='micr'
systemMillisecondClock             ='mill'
systemSecondClock                  ='seco'
systemTickClock                    ='tick'
videoDigitizerComponentType        ='vdig'
Discussion

All components of the same type or subtype provide the same kinds of services and support a common application programming interface. Codecs have their own set of types.*/
enum {
clockComponentType                 ='clok',
compressorComponentType            ='imco',
CreateFilePreviewComponentType     ='pmak',
DataHandlerType                    = 'dhlr',
decompressorComponentType          ='imdc',
MediaHandlerType                   ='mhlr',
MovieControllerComponentType       ='play',
MovieExportType                    ='spit',
MovieImportType                    ='eat ',
SeqGrabChannelType                 ='sgch',
SeqGrabComponentType               ='barg',
SeqGrabCompressionPanelType        ='cmpr',
SeqGrabPanelType                   ='sgpn',
SeqGrabSourcePanelType             ='sour',
ShowFilePreviewComponentType       ='pnot',
StandardCompressionSubType         ='imag',
StandardCompressionSubTypeSound    ='soun',
StandardCompressionType            ='scdi',
systemMicrosecondClock             ='micr',
systemMillisecondClock             ='mill',
systemSecondClock                  ='seco',
systemTickClock                    ='tick',
videoDigitizerComponentType        ='vdig'
};

/*SCAudioFillBuffer

Used is used to pull compressed frames from the StdAudio component in kQTSCAudioPropertyID_BasicDescription format.

ComponentResult SCAudioFillBuffer (
   ComponentInstance ci,
   SCAudioInputDataProc inInputDataProc,
   void *inInputDataProcRefCon,
   UInt32 *ioOutputDataPacketSize,
   AudioBufferList *outOutputData,
   AudioStreamPacketDescription *outPacketDescription
);
Parameters
ci

The clients connection to a StdAudio Compression component.
inInputDataProc

The proc address of the function that will be called to supply data in the kQTSCAudioPropertyID_InputBasicDescription format to SCAudio.
inInputDataProcRefCon

The client refcon that will be passed to the user-provided SCAudioInputDataProc function.
ioOutputDataPacketSize

On input, the number of desired packets. On output, the actual number of packets delivered (can be fewer than the input desired packets).
outOutputData

An AudioBufferList providing sufficiently large buffers to hold the requested number of packets.
outPacketDescription

An array of AudioStreamPacketDescriptions. If the requested output format requires external framing information??that is, a VBR format such as AAC?? allocate and pass an array of packet descriptions as large as the number of packets you are requesting.
Discussion

SCAudioFillBuffer preserves the same style API as the Core Audio AudioConverterFillComplexBuffer API, which is part of the AudioToolbox framework and resides in AudioConverter.h. 

This function has the same parameters as AudioConverterFillComplexBuffer, but internally it has an audio converter, a matrix mixer, and another audio converter. It is based on a pull model: You pull on the audio converter for some output, and specify the buffer in which you want to put it. You have already configured the format that it is going to return to you. You also provide it with an input proc and it will call back that input proc and specify however many samples of audio you have. For example, if you want five packets of AAC audio coming out the back end, and at the front end you happen to have PCM de-interleaved, the routine will ask you for the samples. The difference is you can now have different numbers of channels going in or out. For example, at the same time you are doing the compression from PCM to AAC, you can also go from 5.1 to stereo.

SCAudioFillBuffer is used to pull compressed frames from the StdAudio component in kQTSCAudioPropertyID_BasicDescription format. The StdAudio component can perform any combination of decompression/mixing/compression, combining the facilities of Core Audio AudioConverters and Matrix Mixer AudioUnits. The behavior of the SCAudioFillBuffer call (signalling end of data, and so on) is identical to the AudioConverter's AudioConverterFillComplexBuffer API.

One important difference between the AudioConverter and SCAudio component is that the SCAudio compression APIs can do mixing as well as n -> n channels conversion. If you want to compress, decompress, or transcode audio using the SCAudioFillBuffer interface, you configure the StandardCompressionSubTypeAudio component with the desired input and output formats (or use the SCRequestImageSettings API to present a dialog and let a user select an output format), then you call SCAudioFillBuffer, providing an SCAudioInputDataProc callback, which is called for audio in the specified source format.
Version Notes

Introduced in QuickTime 7.1 for Windows and QuickTime 7 for Mac OS X. 
Availability
Carbon status: Supported C interface file: QuickTimeComponents.h
Declared In
QuickTimeComponents.h*/
ComponentResult SCAudioFillBuffer (
   ComponentInstance ci,
   SCAudioInputDataProc inInputDataProc,
   void *inInputDataProcRefCon,
   UInt32 *ioOutputDataPacketSize,
   AudioBufferList *outOutputData,
   AudioStreamPacketDescription *outPacketDescription
);

/*SCRequestImageSettings

Displays the standard image dialog box to the user and shows default settings you have established.

ComponentResult SCRequestImageSettings (
   ComponentInstance    ci );
Parameters
ci

Identifies your application's connection to a standard image-compression dialog component. You obtain this identifier from OpenDefaultComponent.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Use this function to retrieve the user's preferences for compressing a single image; use SCRequestSequenceSettings when you are working with an image sequence. Both functions manipulate the compression settings that the component stores for you.

The component derives the current settings when you may supply an image to the component from which it can derive default settings. If you have not set any defaults, but you do supply a test image for the dialog, the component examines the test image and derives appropriate default values based upon its characteristics. If you have not set any defaults and do not supply a test image, the component uses its own default values.
Special Considerations

You may modify the settings by using SCSetInfo. You may customize the dialog boxes by specifying a modal-dialog hook function or a custom button. You may use the custom button to invoke an ancillary dialog box that is specific to your application.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SCRequestImageSettings (
   ComponentInstance    ci );

/*SGNewChannel

Creates a sequence grabber channel and assigns a channel component to the channel.

ComponentResult SGNewChannel (
   SeqGrabComponent    s,
   OSType              channelType,
   SGChannel           *ref );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
channelType

The type of channel to open (see below). This value corresponds to the component subtype value of the channel component. See these constants: 
VideoMediaType
SoundMediaType
ref

A pointer to the frameChannel field in the SeqGrabFrameInfo structure that is to receive a reference to the channel that is added to the sequence grabber component. If the sequence grabber component successfully locates and connects to an appropriate channel component, the sequence grabber component returns a reference to the channel component into this field.
Return Value

See Error Codes. If the sequence grabber component cannot open a connection, it sets the result code to a nonzero value. It returns noErr if there is no error.
Discussion

The channel component is responsible for providing digitized data to the sequence grabber component. You specify the type of channel component to be added to the sequence grabber component, as shown in the following sample code:// SGNewChannel coding example
// See "Discovering QuickTime," page 263
void MakeMyGrabChannels (SeqGrabComponent    seqGrab,
                            SGChannel        *sgchanVideo,
                            SGChannel        *sgchanSound,
                            const Rect       *rect,
                            Boolean          bWillRecord)
{
    OSErr           nErr;
    long            lUsage;
    // figure out the usage
    lUsage =seqGrabPreview;                // always previewing
    if (bWillRecord)
        lUsage |=seqGrabRecord;            // sometimes recording
    // create a video channel
    nErr =SGNewChannel(seqGrab, VideoMediaType, sgchanVideo);
    if (nErr ==noErr) {
        // set boundaries for new video channel
        nErr =SGSetChannelBounds(*sgchanVideo, rect);
        // set usage for new video channel
        if (nErr ==noErr)
            nErr =SGSetChannelUsage(*sgchanVideo, lUsage |
                                        seqGrabPlayDuringRecord);
        if (nErr !=noErr) {
            // clean up on failure
            SGDisposeChannel(seqGrab, *sgchanVideo);
            *sgchanVideo =NIL;
        }
    }
    // create a sound channel
    nErr =SGNewChannel(seqGrab, SoundMediaType, sgchanSound);
    if (nErr ==noErr) {
        // set usage of new sound channel
        nErr =SGSetChannelUsage(*sgchanSound, lUsage);
        if (nErr !=noErr) {
            // clean up on failure
            SGDisposeChannel(seqGrab, *sgchanSound);
            *sgchanSound =NIL;
        }
    }
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGNewChannel (
   SeqGrabComponent    s,
   OSType              channelType,
   SGChannel           *ref );

/*SGGetChannelRefCon

Returns a reference constant that was previously set by SGSetChannelRefCon.

ComponentResult SGGetChannelRefCon (
   SGChannel    c,
   long         *refCon );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
refCon

A pointer to the reference constant set by SGSetChannelRefCon, normally used to point to a data structure containing information your sequence grabber channel needs.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 6.
Availability
Available in Mac OS X v10.2 and later.
Declared In
QuickTimeComponents.h&*/

ComponentResult SGGetChannelRefCon (
   SGChannel    c,
   long         *refCon );

/*SGSetChannelRefCon

Sets the value of a reference constant that is passed to your callback functions for channel components.

ComponentResult SGSetChannelRefCon (
   SGChannel    c,
   long         refCon );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
refCon

A reference constant value that your component should pass to the callback functions that have been assigned to this channel. Use this parameter to point to a data structure containing any information your callbacks need.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGSetChannelRefCon (
   SGChannel    c,
   long         refCon );


/*SGSetDataProc

Specifies a data function for use by the sequence grabber.

ComponentResult SGSetDataProc (
   SeqGrabComponent    s,
   SGDataUPP           proc,
   long                refCon );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
proc

A pointer to your data function. To remove your data function, set this parameter to NIL.
refCon

A reference constant. The sequence grabber provides this value to your data callback. Use this parameter to point to a data structure containing any information your function needs.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGSetDataProc (
   SeqGrabComponent    s,
   SGDataUPP           proc,
   long                refCon );

/*SGGetChannelDeviceAndInputNames

Returns the sequence grabber's current device and input names.

ComponentResult SGGetChannelDeviceAndInputNames (
   SGChannel    c,
   Str255       outDeviceName,
   Str255       outInputName,
   short        *outInputNumber );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
outDeviceName

The current device names for display to the user.
outInputName

The current input names for display to the user.
outInputNumber

A pointer to the number of currently selected inputs.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This is a utility call that lets you find out the sequence grabber's current device and input names, instead of having to call GetDeviceList and walk it yourself. Pass NIL for parameters you are not interested in.
Version Notes

Introduced in QuickTime 6.
Availability
Available in Mac OS X v10.2 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGGetChannelDeviceAndInputNames (
   SGChannel    c,
   Str255       outDeviceName,
   Str255       outInputName,
   short        *outInputNumber );

/*SGGetChannelDeviceList

Retrieves a list of the devices that are valid for a specified channel.

ComponentResult SGGetChannelDeviceList (
   SGChannel       c,
   long            selectionFlags,
   SGDeviceList    *list );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
selectionFlags

Flags (see below) that control the data you are to return for each device. See these constants: 
sgDeviceListWithIcons
sgDeviceListDontCheckAvailability
sgDeviceListIncludeInputs
list

A pointer to a pointer to an SGDeviceListRecord structure. The channel creates this structure and returns a pointer to it in the field referred to by this parameter. Applications use SGDisposeDeviceList to dispose of the memory used by the list.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function can be useful for retrieving the name of the current device. Retrieve the device list and use the selectedIndex field to determine which device is currently in use.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGGetChannelDeviceList (
   SGChannel       c,
   long            selectionFlags,
   SGDeviceList    *list );

/*SGDisposeDeviceList

Disposes of a device list.

ComponentResult SGDisposeDeviceList (
   SeqGrabComponent    s,
   SGDeviceList        list );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
list

A pointer to a pointer to an SGDeviceListRecord structure. The sequence grabber disposes of the memory used by this structure.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGDisposeDeviceList (
   SeqGrabComponent    s,
   SGDeviceList        list );

/*SGGetSrcVideoBounds

Determines the size of the source video boundary rectangle.

ComponentResult SGGetSrcVideoBounds (
   SGChannel    c,
   Rect         *r );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
r

A pointer to a Rect structure that is to receive information about your channel's source video boundary rectangle.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

For video channel components that work with video digitizer components, the source video boundary rectangle corresponds to the video digitizer's active source rectangle.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SGGetSrcVideoBounds (
   SGChannel    c,
   Rect         *r );

/*SGGetChannelSampleDescription

Retrieves a channel's sample description structure.

ComponentResult SGGetChannelSampleDescription (
   SGChannel    c,
   Handle       sampleDesc );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
sampleDesc

A handle that is to receive the structure.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

The channel returns a structure that is appropriate to the type of data being captured. For video channels, the channel component returns an ImageDescription structure; for sound channels, it receives a SoundDescription structure.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGGetChannelSampleDescription (
   SGChannel    c,
   Handle       sampleDesc );

/*SGGetChannelTimeScale

Lets the sequence grabber retrieve a channel's time scale.

ComponentResult SGGetChannelTimeScale (
   SGChannel    c,
   TimeScale    *scale );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
scale

A pointer to a time scale. Your channel component places information about its time scale into this structure.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

The time scale you return typically corresponds to the time scale of the media that has been created by your channel. Applications may use this time scale in their data functions.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGGetChannelTimeScale (
   SGChannel    c,
   TimeScale    *scale );

/*SGGetChannelBounds

Determines a channel's display boundary rectangle.

ComponentResult SGGetChannelBounds (
   SGChannel    c,
   Rect         *bounds );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
bounds

A pointer to a Rect structure that is to receive information about your channel's display boundary rectangle.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGGetChannelBounds (
   SGChannel    c,
   Rect         *bounds );

/*SGSetGWorld

Establishes the graphics port and device for a sequence grabber component.

ComponentResult SGSetGWorld (
   SeqGrabComponent    s,
   CGrafPtr            gp,
   GDHandle            gd );
Parameters
s

An instance of the sequence grabber component connected to your channel component. The sequence grabber component provides this value through SGInitChannel.
gp

The destination graphics port, which must be a color graphics port. The sequence grabber component always sets this parameter to a valid value. To use the current graphics port, the parameter is set to NIL.
gd

A handle to the destination graphics device. The sequence grabber component always sets this parameter to a valid value.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

You must call this function if you are working with any channels that collect visual data. If you are working only with data that has no visual representation, you do not need to call this function. The sequence grabber component performs this operation implicitly when you call SGInitialize and the component uses your application's current graphics port. To set it to a specified window, use code such as the following:// SGSetGWorld coding example
// See "Discovering QuickTime," page 262
SeqGrabComponent MakeMySequenceGrabber (WindowRef pMacWnd)
{
    SeqGrabComponent    seqGrab =NIL;
    OSErr               nErr =noErr;
    // open the default sequence grabber
    seqGrab =OpenDefaultComponent(SeqGrabComponentType, 0);
    if (seqGrab !=NIL) {
        // initialize the default sequence grabber component
        nErr =SGInitialize(seqGrab);
        if (nErr ==noErr) {
        // set its graphics world to the specified window
            nErr =SGSetGWorld(seqGrab, (CGrafPtr)pMacWnd, NIL);
        }
    }
    if (nErr && (seqGrab !=NIL)) {    // clean up on failure
        CloseComponent(seqGrab);
        seqGrab =NIL;
    }
    return seqGrab;
}

Special Considerations

You cannot call this function during a record or preview operation, or after you have prepared the sequence grabber component for a record or preview operation by calling SGPrepare. The window in which the sequence grabber is to draw video frames as defined by this function must be visible before you call SGPrepare; otherwise, the sequence grabber does not display the frames properly.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGSetGWorld (
   SeqGrabComponent    s,
   CGrafPtr            gp,
   GDHandle            gd );

/*SGSetChannelBounds

Specifies a channel's display boundary rectangle.

ComponentResult SGSetChannelBounds (
   SGChannel     c,
   const Rect    *bounds );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
bounds

A pointer to a Rect structure that defines your channel's display boundary rectangle.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SGSetChannelBounds (
   SGChannel     c,
   const Rect    *bounds);

/*SGInitialize

Initializes the sequence grabber component.

ComponentResult SGInitialize (
   SeqGrabComponent    s );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Before you can call this function you must establish a connection to the sequence grabber component. Use OpenDefaultComponent or OpenComponent to establish a component connection, as shown below:// SGInitialize coding example
// See "Discovering QuickTime," page 262
SeqGrabComponent MakeMySequenceGrabber (WindowRef pMacWnd)
{
    SeqGrabComponent    seqGrab =NIL;
    OSErr               nErr =noErr;
    // open the default sequence grabber
    seqGrab =OpenDefaultComponent(SeqGrabComponentType, 0);
    if (seqGrab !=NIL) {
        // initialize the default sequence grabber component
        nErr =SGInitialize(seqGrab);
        if (nErr ==noErr) {
        // set its graphics world to the specified window
            nErr =SGSetGWorld(seqGrab, (CGrafPtr)pMacWnd, NIL);
        }
    }
    if (nErr && (seqGrab !=NIL)) {    // clean up on failure
        CloseComponent(seqGrab);
        seqGrab =NIL;
    }
    return seqGrab;
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGInitialize (
   SeqGrabComponent    s );

/*(SGSetDataRef

Specifies the destination data reference for a record operation.

ComponentResult SGSetDataRef (
   SeqGrabComponent    s,
   Handle              dataRef,
   OSType              dataRefType,
   long                whereFlags );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
dataRef

A handle to the information that identifies the destination container.
dataRefType

The type of data reference. If the data reference is an alias, you must set the parameter to rAliasType.
whereFlags

Contains flags (see below) that control the record operation. You must set either seqGrabToDisk or seqGrabToMemory to 1. Set unused flags to 0. See these constants: 
seqGrabToDisk
seqGrabToMemory
seqGrabDontUseTempMemory
seqGrabAppendToFile
seqGrabDontAddMovieResource
seqGrabDontMakeMovie
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function allows you to specify the destination for a record operation using a data reference, and to specify other options that govern the operation. This function is similar to SGSetDataOutput, and provides you with an alternative way to specify the destination.
Special Considerations

If you are performing a preview operation, you don't need to use this function.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SGSetDataRef (
   SeqGrabComponent    s,
   Handle              dataRef,
   OSType              dataRefType,
   long                whereFlags );

/*SGGetSettings

Retrieves the current settings of all channels used by the sequence grabber.

ComponentResult SGGetSettings (
   SeqGrabComponent    s,
   UserData            *ud,
   long                flags );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
ud

A pointer to a space where the sequence grabber returns a pointer to a UserDataRecord structure that contains the configuration information. Your application is responsible for disposing of this structure when it is done with it.
flags

Reserved for Apple. Set this parameter to 0.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGGetSettings (
   SeqGrabComponent    s,
   UserData            *ud,
   long                flags );

/*SGGetIndChannel

Collects information about all of the channel components currently in use by a sequence grabber component.

ComponentResult SGGetIndChannel (
   SeqGrabComponent    s,
   short               index,
   SGChannel           *ref,
   OSType              *chanType );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
index

Specifies an index value that identifies the channel to be queried. The first channel has an index value of 1.
ref

A pointer to a field to receive a value identifying your connection to the channel. If you do not want to receive this information, set this parameter to NIL.
chanType

A pointer to a field to receive the channel's subtype value (see below). This value indicates the media type supported by the channel component. See these constants: 
VideoMediaType
SoundMediaType
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGGetIndChannel (
   SeqGrabComponent    s,
   short               index,
   SGChannel           *ref,
   OSType              *chanType );

/*SGSetSettings

Configures a sequence grabber and its channels.

ComponentResult SGSetSettings (
   SeqGrabComponent    s,
   UserData            ud,
   long                flags );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
ud

A UserDataRecord structure that contains the configuration information to be used by the sequence grabber.
flags

Reserved for Apple. Set this parameter to 0.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

The sequence grabber disposes of any of its current channels before applying this configuration information. It then opens connections to new channels as appropriate.
Special Considerations

You can restore saved settings by using NewUserDataFromHandle.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SGSetSettings (
   SeqGrabComponent    s,
   UserData            ud,
   long                flags );

/*SGGetChannelSettings

Retrieves the current settings of a channel used by the sequence grabber.

ComponentResult SGGetChannelSettings (
   SeqGrabComponent    s,
   SGChannel           c,
   UserData            *ud,
   long                flags );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
ud

On return, a pointer to a UserDataRecord structure that contains the configuration information.
flags

Reserved for Apple. Set this parameter to 0.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SGGetChannelSettings (
   SeqGrabComponent    s,
   SGChannel           c,
   UserData            *ud,
   long                flags );

/*SGDisposeChannel

Removes a channel from a sequence grabber component.

ComponentResult SGDisposeChannel (
   SeqGrabComponent    s,
   SGChannel           c );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
c

The reference that identifies the channel you want to close. You obtain this reference from SGNewChannel.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGDisposeChannel (
   SeqGrabComponent    s,
   SGChannel           c );

/*SGSetChannelSettings

Configures a sequence grabber channel.

ComponentResult SGSetChannelSettings (
   SeqGrabComponent    s,
   SGChannel           c,
   UserData            ud,
   long                flags );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
ud

A UserDataRecord structure that contains the configuration information to be used by the channel component.
flags

Reserved for Apple. Set this parameter to 0.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGSetChannelSettings (
   SeqGrabComponent    s,
   SGChannel           c,
   UserData            ud,
   long                flags );

/*SGSetMaximumRecordTime

Limits the duration of a record operation

ComponentResult SGSetMaximumRecordTime (
   SeqGrabComponent    s,
   unsigned long       ticks );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
ticks

The maximum duration for the record operation, in system ticks (sixtieths of a second). Set this parameter to 0 to remove the time limit from the operation.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

By default, there is no time limit on a record operation. If you do not set a limit, a record operation will run until it exhausts the Operating System resources or you call SGStop. Memory and disk space are the two major limiting factors.
Special Considerations

You must call this function before you start a sequence grabber record operation.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGSetMaximumRecordTime (
   SeqGrabComponent    s,
   unsigned long       ticks );

/*SGIdle

Provides processing time for sequence grabber components.

ComponentResult SGIdle (
   SeqGrabComponent    s );
Parameters
s

An instance of the sequence grabber component connected to your channel component. The sequence grabber component provides this value through SGInitChannel.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

After starting a preview or record operation, the application calls this function as often as possible. The sequence grabber component then calls your SGIdle function. This continues until the calling application stops the operation by calling SGStop.Your SGIdle function reports several status and error conditions by means of its result code. If your component returns a nonzero result code during a record operation, the application should call SGStop so that the sequence grabber component can store the data it has collected.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SGIdle (
   SeqGrabComponent    s );

/*SGStartRecord

Instructs the sequence grabber component to begin collecting data from its channels.

ComponentResult SGStartRecord (
   SeqGrabComponent    s );
Parameters
s

An instance of the sequence grabber component connected to your channel component. The sequence grabber component provides this value through SGInitChannel.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGStartRecord (
   SeqGrabComponent    s );

/*SGStop

Stops a preview or record operation.

ComponentResult SGStop (
   SeqGrabComponent    s );
Parameters
s

An instance of the sequence grabber component connected to your channel component. The sequence grabber component provides this value through SGInitChannel.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

It is dangerous to allow an update event to occur during recording. Many digitizers capture directly to the screen, and an update event will result in data loss.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGStop (
   SeqGrabComponent    s );

/*SGPause

Suspends or restarts a sequence grabber record or preview operation.

ComponentResult SGPause (
   SeqGrabComponent    s,
   Byte                pause );
Parameters
s

An instance of the sequence grabber component connected to your channel component. The sequence grabber component provides this value through SGInitChannel.
pause

A constant (see below) that instructs your component to suspend or restart the current operation. See these constants: 
seqGrabUnpause
seqGrabPause
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Your component should not release any system resources or temporary memory associated with the current operation. You should be ready to restart the operation immediately.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGPause (
   SeqGrabComponent    s,
   Byte                pause );

/*SGGetPause

Determines whether the sequence grabber is paused.

ComponentResult SGGetPause (
   SeqGrabComponent    s,
   Byte                *paused );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
paused

A pointer to a field that is to receive a constant (see below) that indicates whether the sequence grabber is currently paused. See these constants: 
seqGrabUnpause
seqGrabPause
seqGrabPauseForMenu
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGGetPause (
   SeqGrabComponent    s,
   Byte                *paused );

/*SGSetChannelUsage

Specifies how a channel is to be used by the sequence grabber component.

ComponentResult SGSetChannelUsage (
   SGChannel    c,
   long         usage );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
usage

Contains flags (see below) specifying how your channel is to be used. The sequence grabber component may set more than one of these flags to 1. It sets unused flags to 0. See these constants: 
seqGrabRecord
seqGrabPreview
seqGrabPlayDuringRecord
seqGrabLowLatencyCapture
seqGrabAlwaysUseTimeBase
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier. Flags added in QuickTime 6.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGSetChannelUsage (
   SGChannel    c,
   long         usage );

/*SGSettingsDialog

Causes a sequence grabber to display its settings dialog box to the user.

ComponentResult SGSettingsDialog (
   SeqGrabComponent         s,
   SGChannel                c,
   short                    numPanels,
   ConstComponentListPtr    panelList,
   long                     flags,
   SGModalFilterUPP         proc,
   long                     procRefNum );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
numPanels

The number of panel components to be listed in the panel component pop-up menu. You specify the panel components with the panelList parameter. You may use these parameters to limit the user's choice of panel components. If you set this parameter to 0 and the panelList parameter to NIL, the sequence grabber lists all available panel components.
panelList

A pointer to an array of component identifiers. The sequence grabber presents only these components in the panel component pop-up menu. You specify the number of identifiers in the array with the numPanels parameter. If you set this parameter to NIL, the sequence grabber lists all available panel components.
flags

Either set this to 0 or to seqGrabSettingsPreviewOnly (see below). See these constants: 
seqGrabSettingsPreviewOnly
proc

Specifies an SGModalFilterProc callback. Because the sequence grabber's settings dialog box is a movable modal dialog box, you must supply an event filter function to process update events in your window.
procRefNum

A reference constant to be passed to your filter callback. Use this parameter to point to a data structure containing any information your function needs.
Return Value

See Error Codes. If the user clicks OK and the settings are acceptable to the panel and channel components, this function returns a result code of noErr.
Discussion

Because the user may change several channel configuration parameters, your application should retrieve new configuration information from the channel so that you can update any values you save, such as the channel's display boundaries or the channel device. In particular, the video rectangle for the channels may have to be adjusted.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGSettingsDialog (
   SeqGrabComponent         s,
   SGChannel                c,
   short                    numPanels,
   ConstComponentListPtr    panelList,
   long                     flags,
   SGModalFilterUPP         proc,
   long                     procRefNum );

/*SGGetChannelPlayFlags

Retrieves the playback control flags that you set with SGSetChannelPlayFlags.

ComponentResult SGGetChannelPlayFlags (
   SGChannel    c,
   long         *playFlags );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
playFlags

A pointer to a long integer that is to receive flags (see below) that influence channel playback. Set unused flags to 0. See these constants: 
channelPlayNormal
channelPlayFast
channelPlayHighQuality
channelPlayAllData
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGGetChannelPlayFlags (
   SGChannel    c,
   long         *playFlags );

/*SGSetChannelPlayFlags

Adjusts the speed and quality with which the sequence grabber displays data from a channel.

ComponentResult SGSetChannelPlayFlags (
   SGChannel    c,
   long         playFlags );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
playFlags

A long integer that contains flags (see below) that influence channel playback. A sequence grabber component must use one of these values. See these constants: 
channelPlayNormal
channelPlayFast
channelPlayHighQuality
channelPlayAllData
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGSetChannelPlayFlags (
   SGChannel    c,
   long         playFlags );

/*SGGetChannelUsage

Determines how the sequence grabber component is using a channel.

ComponentResult SGGetChannelUsage (
   SGChannel    c,
   long         *usage );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
usage

A pointer to a location that is to receive flags (see below) that specify how your channel is to be used. You may set more than one of these flags to 1. Set unused flags to 0. See these constants: 
seqGrabRecord
seqGrabPreview
seqGrabPlayDuringRecord
seqGrabLowLatencyCapture
seqGrabAlwaysUseTimeBase
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier. Flags added in QuickTime 6.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGGetChannelUsage (
   SGChannel    c,
   long         *usage );

/*SGPrepare

Instructs a sequence grabber to get ready to begin a preview or record operation.

ComponentResult SGPrepare (
   SeqGrabComponent    s,
   Boolean             prepareForPreview,
   Boolean             prepareForRecord );
Parameters
s

An instance of the sequence grabber component connected to your channel component. The sequence grabber component provides this value through SGInitChannel.
prepareForPreview

The sequence grabber component sets this parameter to TRUE to prepare for a preview operation. The sequence grabber component may set both the prepareForPreview and prepareForRecord parameters to TRUE.
prepareForRecord

The sequence grabber component sets this parameter to TRUE to prepare for a record operation. The sequence grabber component may set both the prepareForPreview and prepareForRecord parameters to TRUE.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

If you do not call this function before starting a record or preview operation, the sequence grabber component makes these preparations when you start the operation. You cannot call this function after you start a preview or record operation. If you call this function without subsequently starting a record or preview operation, you should call SGRelease. This allows the sequence grabber component to release any system resources it allocated when you called this function.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGPrepare (
   SeqGrabComponent    s,
   Boolean             prepareForPreview,
   Boolean             prepareForRecord );

/*SGStartPreview

Instructs the sequence grabber to begin processing data from its channels.

ComponentResult SGStartPreview (
   SeqGrabComponent    s );
Parameters
s

An instance of the sequence grabber component connected to your channel component. The sequence grabber component provides this value through SGInitChannel.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Your channel component should immediately present the data to the user in the appropriate format, according to your channel's configuration. Display video data in the destination display region; play sound data at the specified volume settings.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGStartPreview (
   SeqGrabComponent    s );

/*SGRelease

Instructs the sequence grabber to release any system resources it allocated when you called SGPrepare.

ComponentResult SGRelease (
   SeqGrabComponent    s );
Parameters
s

An instance of the sequence grabber component connected to your channel component. The sequence grabber component provides this value through SGInitChannel.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

You cannot call this function during a record or preview operation.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SGRelease (
   SeqGrabComponent    s );

#ifdef __cplusplus
}
#endif


#endif