#ifndef QDOFFSCREEN_H
#define QDOFFSCREEN_H

#ifndef CORESERVICES_H
#include <CoreServices/CoreServices.h>
#endif

#ifndef QUICKDRAW_H
#include <QD/Quickdraw.h>
#endif

#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*GWorldFlags

Abst_GWorldFlags

typedef unsigned long GWorldFlags;
Availability
Available in Mac OS X v10.0 and later.*/
typedef unsigned long GWorldFlags;

/*GWorldPtr

typedef CGrafPtr GWorldPtr;
Discussion

An offscreen graphics world in color QuickDraw contains a CGrafPort structure—and its handles to associated PixMap and ColorTable structures—that describes an offscreen graphics port and contains references to a GDevice structure and other state information. The actual data structure for an offscreen graphics world is kept private to allow for future extensions. However, when your application uses the NewGWorld function to create an offscreen world, NewGWorld returns a pointer of type GWorldPtr by which your application refers to the offscreen graphics world. 

On computers lacking color QuickDraw, GWorldPtr points to an extension of the GrafPort structure. 
Availability
Available in Mac OS X v10.0 and later*/

typedef CGrafPtr GWorldPtr;

/*DisposeGWorld

Disposes of all the memory allocated for an offscreen graphics world. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void DisposeGWorld (
   GWorldPtr offscreenGWorld
);
Parameters
offscreenGWorld

A pointer to an offscreen graphics world. In this parameter, pass the pointer returned to your application by the NewGWorld function when you created the offscreen graphics world. 
Discussion

The DisposeGWorld function disposes of all the memory allocated for the specified offscreen graphics world, including the pixel map, color table, pixel image, and GDevice structure (if one was created).

Call DisposeGWorld only when your application no longer needs the pixel image associated with this offscreen graphics world. If this offscreen graphics world was the current device, the current device is reset to the device stored in the global variable MainDevice. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
QDOffscreen.h*/
void DisposeGWorld (
   GWorldPtr offscreenGWorld
);

/*LockPixels

Prevents the base address for an offscreen pixel image from being moved while you draw into or copy from its pixel map. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

Boolean LockPixels (
   PixMapHandle pm
);
Parameters
pm

A handle to an offscreen pixel map. To get a handle to an offscreen pixel map, use the GetGWorldPixMap function . 
Return Value

If the base address for an offscreen pixel image hasn’t been purged by the Memory Manager or is not purgeable, LockPixels returns TRUE as its function result, and your application can draw into or copy from the offscreen pixel map. However, if the base address for an offscreen pixel image has been purged, LockPixels returns FALSE to indicate that you can perform no drawing to or copying from the pixel map. At that point, your application should either call the UpdateGWorld function to reallocate the offscreen pixel image and then reconstruct it, or draw directly in a window instead of preparing the image in an offscreen graphics world. 
Discussion

You must call LockPixels before drawing to or copying from an offscreen graphics world. 

The baseAddr field of the PixMap structure for an offscreen graphics world contains a handle instead of a pointer (which is what the baseAddr field for an onscreen pixel map contains). The LockPixels function dereferences the PixMap handle into a pointer. When you use the UnlockPixels function the handle is recovered.

As soon as you are finished drawing into and copying from the offscreen pixel image, call the UnlockPixels function. 
Special Considerations

The LockPixels function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
QDOffscreen.h*/
Boolean LockPixels (
   PixMapHandle pm
);

/*GetGWorldPixMap

Obtains the pixel map created for an offscreen graphics world. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

PixMapHandle GetGWorldPixMap (
   GWorldPtr offscreenGWorld
);
Parameters
offscreenGWorld

A pointer to an offscreen graphics world. Pass the pointer returned to your application by the NewGWorld function when you created the offscreen graphics world. 
Return Value

A handle to the pixel map created for an offscreen graphics world. Your application can, in turn, pass the handle returned by GetGWorldPixMap as a parameter to other QuickDraw functions that accept a handle to a pixel map.

On a system running only basic QuickDraw, the GetGWorldPixMap function returns the handle to a 1-bit pixel map that your application can supply as a parameter to the other functions related to offscreen graphics worlds. However, your application should not supply this handle to color QuickDraw functions.

Special Considerations

To ensure compatibility on systems running basic QuickDraw instead of Color QuickDraw, use GetGWorldPixMap whenever you need to gain access to the bitmap created for a graphics world—that is, do not dereference the GWorldPtr structure for that graphics world.
Version Notes

The GetGWorldPixMap function is not available in systems preceding System 7. You can make sure that the GetGWorldPixMap function is available by using the Gestalt function with the gestaltSystemVersion selector. Test the low-order word in the response parameter; if the value is $0700 or greater, then GetGWorldPixMap is available.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
QDOffscreen.h*/
PixMapHandle GetGWorldPixMap (
   GWorldPtr offscreenGWorld
);

/*GetGWorldDevice

Obtains a handle to the GDevice structure associated with an offscreen graphics world. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

GDHandle GetGWorldDevice (
   GWorldPtr offscreenGWorld
);
Parameters
offscreenGWorld

A pointer to an offscreen graphics world. The pointer returned to your application by the NewGWorld function. 
Return Value

A handle to the GDevice structure associated with the offscreen graphics world specified by the offscreenGWorld parameter. 


If you created the offscreen world by specifying the noNewDevice flag, the GDevice structure is for one of the screen devices or is the GDevice structure that you specified to NewGWorld or UpdateGWorld.

If you point to a GrafPort or CGrafPort structure in the offscreenGWorld parameter, GetGWorldDevice returns the current device.

Special Considerations

The GetGWorldDevice function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
QDOffscreen.h*/
GDHandle GetGWorldDevice (
   GWorldPtr offscreenGWorld
);

/*GetGWorld

Saves the current graphics port (basic, color, or offscreen) and the current GDevice structure. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void GetGWorld (
   CGrafPtr * port,
   GDHandle * gdh
);
Parameters
port

On return, a pointer to the current graphics port in the port parameter. This parameter can return values of type GrafPtr, CGrafPtr, or GWorldPtr, depending on whether the current graphics port is a basic graphics port, color graphics port, or offscreen graphics world. 
gdh

On return, a pointer to a handle to the GDevice structure for the current device. 
Discussion

After using GetGWorld to save a graphics port and a GDevice structure, use the SetGWorld function to restore them. 
Special Considerations

The GetGWorld function may move or purge memory blocks in the application heap. Your application should not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
QDOffscreen.h*/
void GetGWorld (
   CGrafPtr * port,
   GDHandle * gdh
);

/*SetGWorld

Changes the current graphics port (basic, color, or offscreen). (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void SetGWorld (
   CGrafPtr port,
   GDHandle gdh
);
Parameters
port

A pointer to an offscreen graphics world, color graphics port, or basic graphics port. Specify values of type GrafPtr, CGrafPtr, or GWorldPtr, depending on whether you want to set the current graphics port to be a basic graphics port, color graphics port, or offscreen graphics world. Any drawing your application performs then occurs in this graphics port. 
gdh

A handle to a GDevice structure. If you pass a pointer to an offscreen graphics world in the port parameter, set this parameter to NULL, because SetGWorld ignores this parameter and sets the current device to the device attached to the offscreen graphics world. 
Discussion

The SetGWorld function sets the current graphics port to the one specified by the port parameter and—unless you set the current graphics port to be an offscreen graphics world—sets the current device to that specified by the gdh parameter. 
Special Considerations

The SetGWorld function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
QDOffscreen.h*/

void SetGWorld (
   CGrafPtr port,
   GDHandle gdh
);

/*UnlockPixels

Allows the Memory Manager to move the base address for the offscreen pixel map that you specify in the pm parameter. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void UnlockPixels (
   PixMapHandle pm
);
Parameters
pm

A handle to an offscreen pixel map. Pass the same handle that you passed previously to the LockPixels function. 
Discussion

To ensure the integrity of the data in a pixel image, call LockPixels before drawing into or copying from a pixel map; then, to prevent heap fragmentation, call UnlockPixels as soon as your application finishes drawing to and copying from the offscreen pixel map. 

The baseAddr field of the PixMap structure for an offscreen graphics world contains a handle instead of a pointer (which is what the baseAddr field for an onscreen pixel map contains). The LockPixels function dereferences the PixMap handle into a pointer. When you use the UnlockPixels function, the handle is recovered.

You don’t need to call UnlockPixels if LockPixels returns FALSE, because LockPixels doesn’t lock the memory for a pixel image if that memory has been purged. However, calling UnlockPixels on purged memory does no harm. 
Special Considerations

The UnlockPixels function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
QDOffscreen.h*/
void UnlockPixels (
   PixMapHandle pm
);

#ifdef __cplusplus
}
#endif
#endif