#ifndef LSOPEN_H
#define LSOPEN_H

#ifndef CORESERVICES_H
#include <CoreServices/CoreServices.h>
#endif

#ifndef LSINFO_H
#include <LaunchServices/LSInfo.h>
#endif

#ifndef AE_H
#include <AE/AE.h>
#endif

#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Launch Flags

Specify how to launch an application.

typedef OptionBits LSLaunchFlags;enum {
   kLSLaunchDefaults = 0x00000001,
   kLSLaunchAndPrint = 0x00000002,
   kLSLaunchReserved2 = 0x00000004,
   kLSLaunchReserved3 = 0x00000008,
   kLSLaunchReserved4 = 0x00000010,
   kLSLaunchReserved5 = 0x00000020,
   kLSLaunchAndDisplayErrors = 0x00000040,
   kLSLaunchInhibitBGOnly = 0x00000080,
   kLSLaunchDontAddToRecents = 0x00000100,
   kLSLaunchDontSwitch = 0x00000200,
   kLSLaunchNoParams = 0x00000800,
   kLSLaunchAsync = 0x00010000,
   kLSLaunchStartClassic = 0x00020000,
   kLSLaunchInClassic = 0x00040000,
   kLSLaunchNewInstance = 0x00080000,
   kLSLaunchAndHide = 0x00100000,
   kLSLaunchAndHideOthers = 0x00200000,
   kLSLaunchHasUntrustedContents = 0x00400000
};
Constants
kLSLaunchDefaults

Requests launching in the default manner (as if the only flags set were kLSLaunchNoParams, kLSLaunchAsync, and kLSLaunchStartClassic).

Available in Mac OS X v10.0 and later.
kLSLaunchAndPrint

Requests that documents opened in the application be printed.

Available in Mac OS X v10.0 and later.
kLSLaunchReserved2

Reserved for future use.

Available in Mac OS X v10.0 and later.
kLSLaunchReserved3

Reserved for future use.

Available in Mac OS X v10.0 and later.
kLSLaunchReserved4

Reserved for future use.

Available in Mac OS X v10.0 and later.
kLSLaunchReserved5

Reserved for future use.

Available in Mac OS X v10.0 and later.
kLSLaunchAndDisplayErrors

Requests that launch and open failures be displayed in the UI.

Available in Mac OS X v10.4 and later.
kLSLaunchInhibitBGOnly

Requests that the launch be made to fail if the application is background-only.

Available in Mac OS X v10.0 and later.
kLSLaunchDontAddToRecents

Requests that the application or documents not be added to the Finder’s Recent Items menu.

Available in Mac OS X v10.0 and later.
kLSLaunchDontSwitch

Requests that the application be launched without being brought to the foreground.

Available in Mac OS X v10.0 and later.
kLSLaunchNoParams

Requests that the application’s information property list be used to determine the launch parameters.

Available in Mac OS X v10.0 and later.
kLSLaunchAsync

Requests that the application be launched asynchronously: that is, the Launch Services function launching it return control immediately, without waiting for it to complete its launch sequence (indicated visually to the user when the application’s icon stops “bouncing” in the Dock).

Available in Mac OS X v10.0 and later.
kLSLaunchStartClassic

Requests that the Classic emulation environment be started up if the application requires it. If this flag is not set and the application requires the Classic environment, the launch will fail.

Available in Mac OS X v10.0 and later.
kLSLaunchInClassic

Requests that the application be forced to launch in the Classic emulation environment.

Available in Mac OS X v10.0 and later.
kLSLaunchNewInstance

Requests that a new instance of the application be started, even if one is already running.

Available in Mac OS X v10.0 and later.
kLSLaunchAndHide

Requests that the application be hidden as soon as it completes its launch sequence.

Available in Mac OS X v10.0 and later.
kLSLaunchAndHideOthers

Requests that other applications be hidden as soon as the opened application completes its launch sequence.

Available in Mac OS X v10.0 and later.
kLSLaunchHasUntrustedContents

Requests that the items to be launched should be marked as untrusted. 

Available in Mac OS X v10.4 and later.
Discussion

They are passed in a launch specification structure (LSLaunchFSRefSpec to the LSOpenFromRefSpec function or LSLaunchURLSpec to the LSOpenFromURLSpec function), to control the manner in which applications are launched.*/
typedef OptionBits LSLaunchFlags;enum {
   kLSLaunchDefaults = 0x00000001,
   kLSLaunchAndPrint = 0x00000002,
   kLSLaunchReserved2 = 0x00000004,
   kLSLaunchReserved3 = 0x00000008,
   kLSLaunchReserved4 = 0x00000010,
   kLSLaunchReserved5 = 0x00000020,
   kLSLaunchAndDisplayErrors = 0x00000040,
   kLSLaunchInhibitBGOnly = 0x00000080,
   kLSLaunchDontAddToRecents = 0x00000100,
   kLSLaunchDontSwitch = 0x00000200,
   kLSLaunchNoParams = 0x00000800,
   kLSLaunchAsync = 0x00010000,
   kLSLaunchStartClassic = 0x00020000,
   kLSLaunchInClassic = 0x00040000,
   kLSLaunchNewInstance = 0x00080000,
   kLSLaunchAndHide = 0x00100000,
   kLSLaunchAndHideOthers = 0x00200000,
   kLSLaunchHasUntrustedContents = 0x00400000
};


/*LSApplicationParameters

Specifies the application, launch flags, and additional parameters that control how an application is launched.

struct LSApplicationParameters {
   CFIndex version;
   LSLaunchFlags flags;
   const FSRef * application;
   void * asyncLaunchRefCon;
   CFDictionaryRef environment;
   CFArrayRef argv;
   AppleEvent * initialEvent
};
typedef struct LSApplicationParameters LSApplicationParameters;
Fields
version

The version of the structure. The value of this field must be 0.
flags

Launch flags. For possible values, see “Launch Flags”.
application

The FSRef of the application to open.
asyncLaunchRefCon

The client refCon that is to appear in subsequent launch notifications.
environment

A dictionary of CFStringRef keys and values for environment variables to set in the launched process. The value of this field can be NULL.
argv

An array of values of type CFStringRef that specify the arguments that are to be passed to main() in the launched process. The value of this field can be NULL. This field is ignored in Mac OS X v10.4.
initialEvent

The first Apple Event to send to the launched process. The value of this field can be NULL.
Discussion

This structure is passed as a parameter to LSOpenApplication, LSOpenItemsWithRole, and LSOpenURLsWithRole.
Availability
Available in Mac OS X v10.4 and later*/
struct LSApplicationParameters {
   CFIndex version;
   LSLaunchFlags flags;
   const FSRef * application;
   void * asyncLaunchRefCon;
   CFDictionaryRef environment;
   CFArrayRef argv;
   AppleEvent * initialEvent
};
typedef struct LSApplicationParameters LSApplicationParameters;

/*LSOpenApplication

Launches the specified application.

OSStatus LSOpenApplication (
const LSApplicationParameters * inAppParams,
ProcessSerialNumber * outPSN
);
Parameters
inAppParams

A LSApplicationParameters structure specifying the application to launch and its launch parameters. This parameter cannot be NULL.
outPSN

On input, a pointer to a value of type ProcessSerialNumber that, on return, contains the process serial number (PSN) of the application specified by inAppParams, or NULL if you don’t want to receive the PSN.
Return Value

A result code; see “Launch Services Result Codes”.
Discussion

The LSOpenApplication launches one application. This function is an updated alternative to the Process Manager's LaunchApplication function. Launch arguments are specified in the inAppParams argument, which must be supplied. If the application is already running in the current session, it is made the front process (unless the kLSLaunchNewInstance flag is used, which always causes a new process to be created).

If outPSN is not NULL, on return, the structure it points to contains the PSN of the launched (or activated) process. Note that for asynchronous launches, the application may not have finished launching when this function returns.
Version Notes

Thread-safe since Mac OS X v10.4.
Availability
Available in Mac OS X v10.4 and later.
Declared In
LSOpen.h*/
OSStatus LSOpenApplication (
const LSApplicationParameters * inAppParams,
ProcessSerialNumber * outPSN
);

#ifdef __cplusplus
}
#endif

#endif