#ifndef MENUS_H
#define MENUS_H

#ifndef APPLICATIONSERVICES_H
#include <ApplicationServices/ApplicationServices.h>
#endif

#ifndef PROCESSES_H
#include <HIServices/Processes.h>
#endif

#ifndef CARBONEVENTSCORE_H
#include <HIToolbox/CarbonEventsCore.h>
#endif

#ifndef EVENTS_H
#include <HIToolbox/Events.h>
#endif

#ifndef HIOBJECT_H
#include <HIToolbox/HIObject.h>
#endif

#include <HYS/HIToolbox/Menus.h>
#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*MenuHandle

Abst_MenuHandle

typedef MenuPtr * MenuHandle;
Availability
Available in Mac OS X v10.0 and later.*/
typedef MenuPtr * MenuHandle;

/*MenuBarHandle

A handle to a menu bar header.

typedef Handle MenuBarHandle;
Availability
Available in Mac OS X v10.0 and later.*/
typedef Handle MenuBarHandle;

/*MenuRef

Defines a menu.

typedef struct OpaqueMenuRef * MenuRef;
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaqueMenuRef * MenuRef;

/*MenuID

Defines a menu ID.

typedef SInt16 MenuID;typedef SInt16 MenuID;
Availability
Available in Mac OS X v10.0 and later.*/
typedef SInt16 MenuID;

/*MenuCommand

Specifies a menu item’s command ID.

typedef UInt32 MenuCommand;
Availability
Available in Mac OS X v10.0 and later.*/
typedef UInt32 MenuCommand;

/*Menu Item Data Flags

Indicate which fields of a MenuItemDataRec structure are to be copied or set. 

enum {
   kMenuItemDataText = (1 << 0),
   kMenuItemDataMark = (1 << 1),
   kMenuItemDataCmdKey = (1 << 2),
   kMenuItemDataCmdKeyGlyph = (1 << 3),
   kMenuItemDataCmdKeyModifiers = (1 << 4),
   kMenuItemDataStyle = (1 << 5),
   kMenuItemDataEnabled = (1 << 6),
   kMenuItemDataIconEnabled = (1 << 7),
   kMenuItemDataIconID = (1 << 8),
   kMenuItemDataIconHandle = (1 << 9),
   kMenuItemDataCommandID = (1 << 10),
   kMenuItemDataTextEncoding = (1 << 11),
   kMenuItemDataSubmenuID = (1 << 12),
   kMenuItemDataSubmenuHandle = (1 << 13),
   kMenuItemDataFontID = (1 << 14),
   kMenuItemDataRefcon = (1 << 15),
   kMenuItemDataAttributes = (1 << 16),
   kMenuItemDataCFString = (1 << 17),
   kMenuItemDataProperties = (1 << 18),
   kMenuItemDataIndent = (1 << 19),
   kMenuItemDataCmdVirtualKey = (1 << 20),
   kMenuItemDataAllDataVersionOne = 0x000FFFFF,
   kMenuItemDataAllDataVersionTwo = kMenuItemDataAllDataVersionOne
| kMenuItemDataCmdVirtualKey
};
enum {
   kMenuItemDataAllData = kMenuItemDataAllDataVersionTwo
};
typedef UInt64 MenuItemDataFlags;
Constants
kMenuItemDataText

Set or return the Str255 text of a menu using the MenuItemDataRec.text field. If getting the text, the text field must be initialized with a pointer to a Str255 variable before calling CopyMenuItemData. If both kMenuItemDataText and kMenuItemCFString are set on entry to CopyMenuItemData, the API will determine whether the menu text was most recently set using a Str255 or CFString, and return only that text format; the flags value for the other format will be cleared. Valid for both menu items and the menu title (if item number is 0).

Available in Mac OS X v10.0 and later.
kMenuItemDataMark

Set or return the mark character of a menu item using the MenuItemDataRec.mark field. Valid only for menu items. 

Available in Mac OS X v10.0 and later.
kMenuItemDataCmdKey

Set or return the command key of a menu using the MenuItemDataRec.cmdKey field. Valid only for menu items. 

Available in Mac OS X v10.0 and later.
kMenuItemDataCmdKeyGlyph

Set or return the command key glyph of a menu using the MenuItemDataRec.cmdKeyGlyph field. Valid only for menu items. 

Available in Mac OS X v10.0 and later.
kMenuItemDataCmdKeyModifiers

Set or return the command key modifiers of a menu using the MenuItemDataRec.cmdKeyModifiers field. Valid only for menu items. 

Available in Mac OS X v10.0 and later.
kMenuItemDataStyle

Set or return the QuickDraw text style of a menu item using the MenuItemDataRec.style field. Valid only for menu items. 

Available in Mac OS X v10.0 and later.
kMenuItemDataEnabled

Set or return the enable state of a menu using the MenuItemDataRec.enabled field. Valid for both menu items and the menu itself (if the item number is zero). 

Available in Mac OS X v10.0 and later.
kMenuItemDataIconEnabled

Set or return the enable state of the menu item icon using the MenuItemDataRec.iconEnabled field. Valid only for menu items. 

Available in Mac OS X v10.0 and later.
kMenuItemDataIconID

Set or return the icon resource ID of the menu item icon using the MenuItemDataRec.iconID field. Valid only for menu items. 

Available in Mac OS X v10.0 and later.
kMenuItemDataIconHandle

Set or return the icon handle of a menu item using the MenuItemDataRec.iconType and MenuItemDataRec.iconHandle field. You must initialize both fields if you are setting the handle; both fields are returned when obtaining the handle. 

The iconType field can contain one of the following constants: kMenuIconType, kMenuShrinkIconType, kMenuSmallIconType, kMenuColorIcontype, kMenuIconSuiteType, or kMenuIconRefType. The icon handle may be a handle to an 'ICON' resource, a 'SICN' resource, a 'cicn' resource, an icon suite, or an icon reference. Valid only for menu items. 

In Mac OS X v10.0 and later, the iconType field can also contain kMenuCGImageType, with the icon handle being of type CGImageRef.

In Mac OS X v10.1 and later, the iconType field can also contain kMenuSystemIconSelectorType or kMenuIconResource, which have icon handles of type OSType and CFStringRef respectively.

Available in Mac OS X v10.0 and later.
kMenuItemDataCommandID

Set or return the command ID of a menu using the MenuItemDataRec.cmdID field. Valid only for menu items. 

Available in Mac OS X v10.0 and later.
kMenuItemDataTextEncoding

Set or return the text encoding of a menu item using the MenuItemDataRec.encoding field. Valid only for menu items.

Available in Mac OS X v10.0 and later.
kMenuItemDataSubmenuID

Set or return the menu ID of the submenu associated with this menu item using the MenuItemDataRec.submenuID field. Valid only for menu items.

Available in Mac OS X v10.0 and later.
kMenuItemDataSubmenuHandle

Set or return the menu reference (MenuRef) of the submenu associated with this menu using the MenuItemDataRec.submenuHandle field. Valid only for menu items.

Available in Mac OS X v10.0 and later.
kMenuItemDataFontID

Set or return the font ID associated with this menu item using the MenuItemDataRec.fomtID field. Valid only for menu items.

Available in Mac OS X v10.0 and later.
kMenuItemDataRefcon

Set or return the reference constant associated with this menu item using the MenuItemDataRec.refcon field. If you specified a menu item index of 0, you can set or obtain the menu reference constant. 

Available in Mac OS X v10.0 and later.
kMenuItemDataAttributes

Set or return the attribute bits associated with this menu item using the MenuItemDataRec.attr field. If you specified a menu item index of 0, you can set or obtain a MenuAttributes bit field, not a MenuItemAttributes bit field.

Available in Mac OS X v10.0 and later.
kMenuItemDataCFString

Set or return the title of the menu item (as a Core Foundation string) using the MenuItemDataRec.cFText field. If you specified a menu item index of 0, you can set or obtain the menu title.

Available in Mac OS X v10.0 and later.
kMenuItemDataProperties

Set or return the properties of a menu using the MenuItemDataRec.properties field.

If setting properties, the properties field should contain a collection with the new properties; note that this will overwrite any existing properties with the same collection creator and tag.

If getting properties, you should set the properties field to either a valid collection or NULL. A valid collection is overwritten by the new properties. If you pass NULL, the CopyMenuItemData function allocates a new collection and returns it in the properties field. 

You can set this flag for both menu items and the menu itself (if the item number is zero).

Available in Mac OS X v10.0 and later.
kMenuItemDataIndent

Set or return the indent level of a menu item using the MenuItemDataRec.indent field. Valid only for menu items.

Available in Mac OS X v10.0 and later.
kMenuItemDataCmdVirtualKey

Set or return the virtual key code for this menu item using the MenuItemDataRec.cmdVirtualKey field. Valid only for menu items. 

Available in Mac OS X v10.0 and later.
kMenuItemDataAllDataVersionOne

Sets all flags, except for kMenuItemDataCmdVirtualKey.

Available in Mac OS X v10.0 and later.
kMenuItemDataAllDataVersionTwo

Sets all flags, including kMenuItemDataCmdVirtualKey.

Available in Mac OS X v10.0 and later.
Discussion

A MenuItemDataFlags value indicates which fields of a “MenuItemDataRec” structure should be used by the CopyMenuItemData or SetMenuItemData functions. All menu item data flags may be used when getting or setting the contents of a menu item; some may also be used when getting or setting information about the menu itself, if the item index given to CopyMenuItemData or SetMenuItemData is 0.*/
enum {
   kMenuItemDataText = (1 << 0),
   kMenuItemDataMark = (1 << 1),
   kMenuItemDataCmdKey = (1 << 2),
   kMenuItemDataCmdKeyGlyph = (1 << 3),
   kMenuItemDataCmdKeyModifiers = (1 << 4),
   kMenuItemDataStyle = (1 << 5),
   kMenuItemDataEnabled = (1 << 6),
   kMenuItemDataIconEnabled = (1 << 7),
   kMenuItemDataIconID = (1 << 8),
   kMenuItemDataIconHandle = (1 << 9),
   kMenuItemDataCommandID = (1 << 10),
   kMenuItemDataTextEncoding = (1 << 11),
   kMenuItemDataSubmenuID = (1 << 12),
   kMenuItemDataSubmenuHandle = (1 << 13),
   kMenuItemDataFontID = (1 << 14),
   kMenuItemDataRefcon = (1 << 15),
   kMenuItemDataAttributes = (1 << 16),
   kMenuItemDataCFString = (1 << 17),
   kMenuItemDataProperties = (1 << 18),
   kMenuItemDataIndent = (1 << 19),
   kMenuItemDataCmdVirtualKey = (1 << 20),
   kMenuItemDataAllDataVersionOne = 0x000FFFFF,
   kMenuItemDataAllDataVersionTwo = kMenuItemDataAllDataVersionOne
| kMenuItemDataCmdVirtualKey
};
enum {
   kMenuItemDataAllData = kMenuItemDataAllDataVersionTwo
};
typedef UInt64 MenuItemDataFlags;

/*MenuItemDataRec

Used with the SetMenuItemData and CopyMenuItemData functions to get or change aspects of a menu item.

struct MenuItemDataRec {
   MenuItemDataFlags whichData;
   StringPtr text;
   UniChar mark;
   UniChar cmdKey;
   UInt32 cmdKeyGlyph;
   UInt32 cmdKeyModifiers;
   Style style;
   Boolean enabled;
   Boolean iconEnabled;
   UInt8 filler1;
   SInt32 iconID;
   UInt32 iconType;
   Handle iconHandle;
   MenuCommand cmdID;
   TextEncoding encoding;
   MenuID submenuID;
   MenuRef submenuHandle;
   SInt32 fontID;
   UInt32 refcon;
   OptionBits attr;
   CFStringRef cfText;
   Collection properties;
   UInt32 indent;
   UInt16 cmdVirtualKey;
};
typedef struct MenuItemDataRec MenuItemDataRec;
typedef MenuItemDataRec * MenuItemDataPtr;
Fields
whichData

The fields to be set or obtained. You pass a bit mask as specified by “Menu Item Data Flags” to indicate which values you want to get or set. The values themselves are set or populated in the fields that follow. 
text

The menu item title, as an Str255 string. 
mark 

The menu item’s mark. 
cmdKey

The menu item’s command key. This can be either a character code or a virtual key code. 
cmdKeyGlyph

The menu item’s command key glyph.
cmdKeyModifiers

The menu item’s command key modifiers.
style

The menu item’s QuickDraw text style.
enabled

The menu item’s enable state.
iconEnabled

The enable state of the menu item icon.
filler1 

Reserved.
iconID

The icon resource ID of the menu item. 
iconHandle

The icon handle of the menu item. 
cmdID

The command ID for the menu item. 
encoding

The text encoding of the menu item.
submenuID

The menu ID of the submenu associated with this menu item. 
submenuHandle

The MenuRef of the submenu associated with this menu item. 
fontID

The font ID for the menu item.
refcon

The reference constant associated with this menu item. 
attr

The menu item’s attributes.
cfText

The menu item’s title, as a Core Foundation string. 
properties

A collection holding the menu item’s properties. 
indent

The menu item’s indent level. 
cmdVirtualKey

The menu item’s virtual key. 
Discussion

When using this structure withCopyMenuItemData or SetMenuItemData, the caller must first set the whichData field to a combination of MenuItemDataFlags indicating which specific data should be retrieved or set. Some fields also require initialization before calling CopyMenuItemData; see “Menu Item Data Flags” for details.
Availability
Available in Mac OS X v10.0 and later.*/
struct MenuItemDataRec {
   MenuItemDataFlags whichData;
   StringPtr text;
   UniChar mark;
   UniChar cmdKey;
   UInt32 cmdKeyGlyph;
   UInt32 cmdKeyModifiers;
   Style style;
   Boolean enabled;
   Boolean iconEnabled;
   UInt8 filler1;
   SInt32 iconID;
   UInt32 iconType;
   Handle iconHandle;
   MenuCommand cmdID;
   TextEncoding encoding;
   MenuID submenuID;
   MenuRef submenuHandle;
   SInt32 fontID;
   UInt32 refcon;
   OptionBits attr;
   CFStringRef cfText;
   Collection properties;
   UInt32 indent;
   UInt16 cmdVirtualKey;
};
typedef struct MenuItemDataRec MenuItemDataRec;
typedef MenuItemDataRec * MenuItemDataPtr;

/*MenuItemIndex

Specifies a particular menu item in a menu.

typedef UInt16 MenuItemIndex;
Discussion

The menu item index is one-based, so item 1 is the first menu item, item 2 is the second, and so on. Some functions allow you to pass an index of zero, which specifies the menu itself. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef UInt16 MenuItemIndex;

/*MenuRef

Defines a menu.

typedef struct OpaqueMenuRef * MenuRef;
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaqueMenuRef * MenuRef;

/*MenuCommand

Specifies a menu item’s command ID.

typedef UInt32 MenuCommand;
Availability
Available in Mac OS X v10.0 and later.*/
typedef UInt32 MenuCommand;

/*Menu Item Attribute Constants

Specify attributes for menu items. 

typedef UInt32 MenuItemAttributes;
enum {
   kMenuItemAttrDisabled = (1 << 0),
   kMenuItemAttrIconDisabled = (1 << 1),
   kMenuItemAttrSubmenuParentChoosable = (1 << 2),
   kMenuItemAttrDynamic = (1 << 3),
   kMenuItemAttrNotPreviousAlternate = (1 << 4),
   kMenuItemAttrHidden = (1 << 5),
   kMenuItemAttrSeparator = (1 << 6),
   kMenuItemAttrSectionHeader = (1 << 7),
   kMenuItemAttrIgnoreMeta = (1 << 8),
   kMenuItemAttrAutoRepeat = (1 << 9),
   kMenuItemAttrUseVirtualKey = (1 << 10),
   kMenuItemAttrCustomDraw = (1 << 11),
   kMenuItemAttrIncludeInCmdKeyMatching = (1 << 12)
   kMenuItemAttrAutoDisable = (1 << 13)
   kMenuItemAttrUpdateSingleItem = (1 << 14)
};
Constants
kMenuItemAttrDisabled

This menu item is disabled.

Available in Mac OS X v10.0 and later.
kMenuItemAttrIconDisabled

This menu item’s icon is disabled. 

Available in Mac OS X v10.0 and later.
kMenuItemAttrSubmenuParentChoosable

The user can select the parent item of a submenu. 

Available in Mac OS X v10.0 and later.
kMenuItemAttrDynamic

This menu item changes dynamically based on the state of the modifier keys. For example, holding down the command key might change the menu item from “Select widget” to “Select all widgets.”

When a menu item has alternate dynamic states, you should group them together sequentially in the menu and assign them the same command key. A collection of menu item alternates is called a dynamic group. 

Available in Mac OS X v10.0 and later.
kMenuItemAttrNotPreviousAlternate

This item is not part of the same dynamic group as the previous item. The Menu Manager determines which menu items belong to a dynamic group by examining the command keys of each item; if a menu item has the same command key as the previous item, the Menu Manager considers it to be part of the same dynamic group. 

However, in some cases you may have sequential items with the same command key (or no command key at all) that should not be considered part of the same dynamic group. To distinguish the separation, you should set this flag for the first menu item in the new group. 

Available in Mac OS X v10.0 and later.
kMenuItemAttrHidden

The menu item is not drawn when displaying the menu. The item is also not included in command-key matching unless the kMenuItemAttrDynamic or kMenuItemIncludeInCmdKeyMatching attribute is set. 

Available in Mac OS X v10.0 and later.
kMenuItemAttrSeparator

The menu item is a separator; any text in the item is ignored. 

Available in Mac OS X v10.0 and later.
kMenuItemAttrSectionHeader

The menu item is a menu section header; this item is disabled and not selectable. 

Available in Mac OS X v10.0 and later.
kMenuItemAttrIgnoreMeta

Ignore the dash (-) metacharacter in this menu item. Dashes at the beginning of a menu item title traditionally signify that the menu item is a separator. However, in some cases you might want to display the dash in the title (for example, if you wanted the menu item to read “-40 degrees F.”)

Available in Mac OS X v10.0 and later.
kMenuItemAttrAutoRepeat

The IsMenuKeyEvent event function recognizes this menu item when it receives an autorepeat keyboard event. 

Available in Mac OS X v10.0 and later.
kMenuItemAttrUseVirtualKey

When MenuEvent and IsMenuKeyEvent compare this menu item’s keyboard equivalent against a keyboard event, they use the item’s virtual keycode equivalent rather than its character code equivalent. 

Available in Mac OS X v10.0 and later.
kMenuItemAttrCustomDraw

This is a custom menu item. Setting this attribute causes custom menu item drawing Carbon events to be sent to your application. Available in CarbonLib 1.4 and Mac OS X v10.1 and later. 

Available in Mac OS X v10.1 and later.
kMenuItemAttrIncludeInCmdKeyMatching

If this attribute is set, functions such as MenuKey, MenuEvent and IsMenuKeyEvent examine this menu item during command key matching. Typically, visible items are examined and hidden items (unless they have the kMenuItemAttrDynamic attribute set) are ignored during command key matching. However, by setting this attribute, you can force hidden items to be included in the matching. Available in CarbonLib 1.6 and Mac OS X v10.2 and later. 

Available in Mac OS X v10.2 and later.
kMenuItemAttrAutoDisable

Disables the menu item if it does not respond to the kEventCommandUpdateStatus event . That is, if no kEventCommandUpdateStatus handler is installed on this item, or if all the handlers installed for the update event return eventNotHandledErr, this item is automatically disabled. This attribute is useful if your application uses the kEventCommandUpdateStatus event to enable menu items; for example you no longer have to install an update status handler on the application target to disable menu items when there are no document windows open. 

Available in Mac OS X v10.3 and later.
kMenuItemAttrUpdateSingleItem

Update only the menu item that matches when searching available command keys. Normally when the Menu Manager does command key matching, it sends a kEventMenuEnableItems event to the menu containing the matching item and then sends a kEventCommandUpdateStatus to each item in the menu. Doing so can be inefficient, since in most cases only the item that matches needs to be updated. By setting this attribute, only the matching item receives the update event and kEventMenuEnableItems is not sent to the menu. If your application enables menu items solely through kEventCommandUpdateStatus event handlers, you should set this attribute for your menu items.

Available in Mac OS X v10.3 and later.
Discussion

Menu item attributes control behavior of individual menu items. They are used with the GetMenuItemAttributes and ChangeMenuItemAttributes APIs.*/
typedef UInt32 MenuItemAttributes;
enum {
   kMenuItemAttrDisabled = (1 << 0),
   kMenuItemAttrIconDisabled = (1 << 1),
   kMenuItemAttrSubmenuParentChoosable = (1 << 2),
   kMenuItemAttrDynamic = (1 << 3),
   kMenuItemAttrNotPreviousAlternate = (1 << 4),
   kMenuItemAttrHidden = (1 << 5),
   kMenuItemAttrSeparator = (1 << 6),
   kMenuItemAttrSectionHeader = (1 << 7),
   kMenuItemAttrIgnoreMeta = (1 << 8),
   kMenuItemAttrAutoRepeat = (1 << 9),
   kMenuItemAttrUseVirtualKey = (1 << 10),
   kMenuItemAttrCustomDraw = (1 << 11),
   kMenuItemAttrIncludeInCmdKeyMatching = (1 << 12),
   kMenuItemAttrAutoDisable = (1 << 13),
   kMenuItemAttrUpdateSingleItem = (1 << 14)
};
/*EnableMenuCommand

Enables the menu item with a specified command ID.

void EnableMenuCommand (
   MenuRef inMenu,
   MenuCommand inCommandID
);
Parameters
inMenu

The menu in which to begin searching for the item. Pass NULL to begin searching with the root menu. The search will descend into all submenus of this menu. 
inCommandID

The command ID of the menu item to be enabled. If more than one item has this command ID, only the first will be enabled. 
Discussion

If you have access to the menu item index, in most cases you should use EnableMenuItem instead, as that function is faster and requires no searching. For example, when receiving a kEventCommandUpdateStatus event, the HICommand structure contains both the menu item’s command ID and index. If you wanted to enable the menu item, you should call EnableMenuItem.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void EnableMenuCommand (
   MenuRef inMenu,
   MenuCommand inCommandID
);

/*DeleteMenuItem

Deletes an item from a menu. 

void DeleteMenuItem (
   MenuRef theMenu,
   short item
);
Parameters
theMenu

The menu from which you want to delete the menu item. 
item

The item number of the menu item to delete. If you specify 0 or a number greater than the last item in the menu, DeleteMenuItem does not delete any item from the menu. 
Discussion

The DeleteMenuItem function deletes a specified menu item from a menu. You should not delete items from an existing menu unless the user expects the menu (such as a menu that lists open documents) to change. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void DeleteMenuItem (
   MenuRef theMenu,
   short item
);

/*AppendMenuItemTextWithCFString

Appends a new menu item with text from a CFString.

OSStatus AppendMenuItemTextWithCFString (
   MenuRef inMenu,
   CFStringRef inString,
   MenuItemAttributes inAttributes,
   MenuCommand inCommandID,
   MenuItemIndex * outNewItem
);
Parameters
menu

The menu to which to append the new item. 
inString

The text of the new item. 
inAttributes

The attributes of the new item. 
inCommandID

The command ID of the new item. 
outNewItem

On exit, the index of the new item. May be NULL if the caller does not need this information. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

The Menu Manager will make its own copy of the CFString before returning from this function. Modifying the string after calling AppendMenuItemTextWithCFString will have no effect on the menu item's actual text. The caller may release the string after the call.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSStatus AppendMenuItemTextWithCFString (
   MenuRef inMenu,
   CFStringRef inString,
   MenuItemAttributes inAttributes,
   MenuCommand inCommandID,
   MenuItemIndex * outNewItem
);

/*CopyMenuItemTextAsCFString

Returns a CFString containing the text of a menu item.

OSStatus CopyMenuItemTextAsCFString (
   MenuRef inMenu,
   MenuItemIndex inItem,
   CFStringRef * outString
);
Parameters
menu

The menu containing the item. 
item

The item whose text you want to copy. 
outString

On exit, a CFString containing the item's text. The caller must release this string when it is no longer needed. 
Return Value

A result code. See “Menu Manager Result Codes”.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSStatus CopyMenuItemTextAsCFString (
   MenuRef inMenu,
   MenuItemIndex inItem,
   CFStringRef * outString
);

/*DisableMenuItem

Disables a menu item or a menu.

void DisableMenuItem (
   MenuRef theMenu,
   MenuItemIndex item
);
Parameters
theMenu

The menu containing the item to be disabled. 
item

The index of the menu item that you wish to disable. Pass 0 to specify the menu title (disabling the entire menu). 
Discussion

The DisableMenuItem function disables a menu item (and any associated icon) so that the user cannot choose the item from the menu. 

Note that EnableMenuItem calls the InvalMenuBar function to update the menu bar the next time through the event loop.

See also the EnableMenuItem and IsMenuItemEnabled functions. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Carbon Porting Notes

Note that the implementation of Carbon on Mac OS 8.1 only supports disabling menu items less than or equal to 31.
Declared In
Menus.h*/
void DisableMenuItem (
   MenuRef theMenu,
   MenuItemIndex item
);

/*EnableMenuItem

Enables a menu item or a menu.

void EnableMenuItem (
   MenuRef theMenu,
   MenuItemIndex item
);
Parameters
theMenu

The menu containing the item to be enabled. 
item

The item number of the menu item that you wish to enable. If you pass 0, EnableMenuItem enables the menu title and all items in the menu that were not previously individually disabled. 
Discussion

The EnableMenuItem function enables a menu item so that the user can choose the item from the menu. If the menu item has an associated icon, that icon is also enabled, unless the icon was previously individually disabled with the function DisableMenuItemIcon.

Note that EnableMenuItem calls the InvalMenuBar function to update the menu bar the next time through the event loop.

See also the DisableMenuItem and IsMenuItemEnabled functions. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void EnableMenuItem (
   MenuRef theMenu,
   MenuItemIndex item
);

/*SetMenuBar

Sets the current menu list to a specified menu list.

void SetMenuBar (
   MenuBarHandle mbar
);
Parameters
mbar

A handle to a menu list that specifies the menus for a menu bar. You should specify a handle returned by GetMenuBar or GetNewMBar. 
Discussion

The SetMenuBar function copies the given menu list to the current menu list. As with GetMenuBar , SetMenuBar doesn’t copy the menu structures, just the menu list (which contains handles to the menu structures).

You can use SetMenuBar to restore a menu list that you previously saved using GetMenuBar or to set the current menu list to a menu list created from a nib file or from GetNewMBar. 

The SetMenuBar function sets the current menu list and calls InvalMenuBar so the menu bar can be updated the next time through the event loop; if you want to redraw the menu bar immediately, call the DrawMenuBar function. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/

void SetMenuBar (
   MenuBarHandle mbar
);

/*CountMenuItems

Obtains the number of menu items in a menu

UInt16 CountMenuItems (
   MenuRef theMenu
);
Parameters
theMenu

The menu whose items you want to count. 
Return Value

The number of menu items in the menu.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
UInt16 CountMenuItems (
   MenuRef theMenu
);

#ifdef __cplusplus
}
#endif

#endif