#ifndef DIALOGS_H
#define DIALOGS_H


#ifndef CORESERVICES_H
#include <CoreServices/CoreServices.h>
#endif

#ifndef EVENTS_H
#include <HIToolbox/Events.h>
#endif

#ifndef MACWINDOWS_H
#include <HIToolbox/MacWindows.h>
#endif

#ifndef TEXTEDIT_H
#include <HIToolbox/TextEdit.h>
#endif

#ifndef CONTROLS_H
#include <HIToolbox/Controls.h>
#endif

#ifndef CARBONEVENTS_H
#include <HIToolbox/CarbonEvents.h>
#endif



#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Dialog Item List Display Constants

Specify methods of appending new items to a dialog. 

typedef SInt16 DITLMethod;
enum {
   overlayDITL = 0,
   appendDITLRight = 1,
   appendDITLBottom = 2
};
Constants
overlayDITL

Superimpose the appended items over the dialog box.

Available in Mac OS X v10.0 and later.
appendDITLRight

Position the items to the right of the dialog box and relative to its upper-right coordinate.

Available in Mac OS X v10.0 and later.
appendDITLBottom

Position the items below the dialog box and relative to its lower-left coordinate.

Available in Mac OS X v10.0 and later.
Discussion

You can pass a constant value of type DITLMethod to the function AppendDITL to specify how you want appended dialog items displayed.*/
typedef SInt16 DITLMethod;
enum {
   overlayDITL = 0,
   appendDITLRight = 1,
   appendDITLBottom = 2
};

/*Alert Button Constants

Define standard button types for alerts and sheets. 

enum {
   kAlertStdAlertOKButton = 1,
   kAlertStdAlertCancelButton = 2,
   kAlertStdAlertOtherButton = 3,
   kAlertStdAlertHelpButton = 4
};
Constants
kAlertStdAlertOKButton

The OK button. The default text for this button is “OK”.

Available in Mac OS X v10.0 and later.
kAlertStdAlertCancelButton

The Cancel button (optional). The default text for this button is “Cancel”.

Available in Mac OS X v10.0 and later.
kAlertStdAlertOtherButton

A third button (optional). The default text for this button is “Don’t Save”.

Available in Mac OS X v10.0 and later.
kAlertStdAlertHelpButton

The Help button (optional).

Available in Mac OS X v10.0 and later.
Discussion

You can use these constants in the defaultButton and cancelButton fields in the standard alert structure to specify which buttons act as the default and Cancel buttons in the standard alert structure. These constants are also returned in the itemHit parameter of StandardAlert. Alert button constants are available with Appearance Manager 1.0 and later.*/
enum {
   kAlertStdAlertOKButton = 1,
   kAlertStdAlertCancelButton = 2,
   kAlertStdAlertOtherButton = 3,
   kAlertStdAlertHelpButton = 4
};

/*Alert Default Text Constants

Defines the default text for alerts and sheets. 

enum {
   kAlertDefaultOKText = -1,
   kAlertDefaultCancelText = -1,
   kAlertDefaultOtherText = -1
};
Constants
kAlertDefaultOKText

The default text for the default (right) button is “OK” on an English system. The text will vary depending upon the localization of the user’s system. Use this constant in the defaultText field of the standard alert structure.

Available in Mac OS X v10.0 and later.
kAlertDefaultCancelText

The default text for the Cancel (middle) button is “Cancel” on an English system. The text will vary depending upon the localization of your system. Use this constant in the cancelText field of the standard alert structure.

Available in Mac OS X v10.0 and later.
kAlertDefaultOtherText

The default text for the third (leftmost) button is “Don’t Save” for an English system. The text will vary depending upon the localization of the user’s system. Use this constant in the otherText field of the standard alert structure.

Available in Mac OS X v10.0 and later.
Discussion

You can use these constants in the defaultText, cancelText, and otherText fields of the standard alert structure to specify the default text for the OK, Cancel, and Don’t Save buttons. Alert default text constants are available with Appearance Manager 1.0 and later.*/

enum {
   kAlertDefaultOKText = -1,
   kAlertDefaultCancelText = -1,
   kAlertDefaultOtherText = -1
};

/*Standard Alert Structure Version Constant

Indicates the version of the AlertStdCFStringAlertParamRec structure.

enum {
   kStdCFStringAlertVersionOne = 1
};
Constants
kStdCFStringAlertVersionOne

First version. Pass this into the version field of the AlertStdCFStringAlertParamRec structure. 

Available in Mac OS X v10.0 and later.*/
enum {
   kStdCFStringAlertVersionOne = 1
};


/*DialogItemIndex


typedef SInt16 DialogItemIndex;
Availability
Available in Mac OS X v10.0 and later.*/
typedef SInt16 DialogItemIndex;

/*DialogRef


typedef DialogPtr DialogRef;
Availability
Available in Mac OS X v10.0 and later.*/
typedef DialogPtr DialogRef;

/*ModalFilterProcPtr


typedef Boolean (*ModalFilterProcPtr)
(
   DialogRef theDialog,
   EventRecord * theEvent,
   DialogItemIndex * itemHit
);

If you name your function MyModalFilterProc, you would declare it like this:

Boolean MyModalFilterProc (
   DialogRef theDialog,
   EventRecord * theEvent,
   DialogItemIndex * itemHit
);
Parameters
theDialog

A pointer to a dialog structure for an alert box or a modal dialog box. 
theEvent

A pointer to an event structure returned by an Event Manager function such as WaitNextEvent. 
itemHit

A pointer to a short integer. Your event filter function should return a number corresponding to the position of an item in the item list resource for the alert or modal dialog box. 
Return Value

A Boolean value. After receiving an event that it does not handle, your function should return false. When your function returns false, ModalDialog handles the event, which you pass in the parameter theEvent. (Your function can also change the event to simulate a different event and return false, which passes the event to the Dialog Manager for handling.) If your function does handle the event, your function should return true, and through the itemHit parameter return the number of the item that it handled. 
Discussion

To supplement the Dialog Manager’s ability to handle events in the Mac OS multitasking environment, you should provide an event filter function that the Dialog Manager calls whenever it displays alert boxes and modal dialog boxes. This function can receive all events that are sent to your application.

The ModalDialog function and, in turn, the Alert , NoteAlert , StopAlert , and CautionAlert functions return the item number that your event filter function returns in the itemHit parameter in their own itemHit parameters. 

For alert and modal dialog boxes, the Dialog Manager provides a standard event filter function that checks whether
the user has pressed the Enter or Return key and, if so, returns the item number of the default button 
the user has pressed the Escape key or Command-period and, if so, returns the item number of the Cancel button 
the cursor is over edit text in a dialog box, and optionally changes the cursor to an I-beam whenever this is the case 

If the dialog box is movable modal and the kDialogHandleMovable bit is set, your filter function will receive all events (including apple events and update events) that your application receives. 

Your own filter function should use the standard filter function to accomplish these tasks. To do so, you can call GetStdFilterProc , and dispatch the event to the standard filter function yourself; or you can call StdFilterProc , which obtains a ModalFilterUPP for the standard filter function and then dispatches the function. 

Your event filter function should also perform the following tasks:
update your windows in response to update events and return false. If you do not handle update events for all the windows in your application, other processes won’t get time. 
return false for all events that your event filter function doesn’t handle 

You can also use the event filter function to test for and respond to keyboard equivalents and more complex events—for instance, the user dragging the cursor in an application- defined item. For example, if you provide an application-defined item that requires you to measure how long the user holds down the mouse button or how far the user drags the cursor, use the event filter function to handle events inside that item. 

Movable modal dialog boxes receive all events (not just those masked by the Event message mask). 

In all alert and dialog boxes, any buttons that are activated by key sequences should highlight to indicate which item has been selected. Use the Control Manager function HiliteControl to highlight a button for 8 ticks, long enough to be noticeable but not so long as to be annoying. The Control Manager performs this action whenever users click a button, and your application should do this whenever the user presses the keyboard equivalent of a button click.

For modal dialog boxes that contain edit text items, your application should handle menu bar access to allow use of your Edit menu and its Cut, Copy, Paste, Clear, and Undo commands. Your event filter function should then test for and handle clicks in your Edit menu and keyboard equivalents for the appropriate commands in your Edit menu. Your application should respond by using the functions DialogCut , DialogCopy , DialogPaste , and DialogDelete to support the Cut, Copy, Paste, and Clear commands.

For an alert box, you specify a universal procedure pointer to your event filter function in a parameter that you pass to the Alert , StopAlert , CautionAlert , and NoteAlert functions. For a modal dialog box, specify a pointer to your event filter function in a parameter that you pass to UpdateDialog.

The Dialog Manager defines the data type ModalFilterUPP to identify this application-defined function:

typedef UniversalProcPtr ModalFilterUPP; 

You typically use the NewModalFilterProc macro like this:

ModalFilterUPP myEventFilterProc;

myEventFilterProc = NewModalFilterProc(MyEventFilter);*/

typedef Boolean (*ModalFilterProcPtr)
(
   DialogRef theDialog,
   EventRecord * theEvent,
   DialogItemIndex * itemHit
);

/* ModalFilterUPP


typedef ModalFilterProcPtr ModalFilterUPP;
Discussion

For more information, see the description of the ModalFilterUPP () callback function.*/
typedef ModalFilterProcPtr ModalFilterUPP;

/*AlertStdAlertParamRec


struct AlertStdAlertParamRec {
   Boolean movable;
   Boolean helpButton;
   ModalFilterUPP filterProc;
   ConstStringPtr defaultText;
   ConstStringPtr cancelText;
   ConstStringPtr otherText;
   SInt16 defaultButton;
   SInt16 cancelButton;
   UInt16 position;
};
typedef struct AlertStdAlertParamRec AlertStdAlertParamRec;
typedef AlertStdAlertParamRec * AlertStdAlertParamPtr;
Fields
movable

A Boolean value indicating whether or not the alert box is movable.
helpButton

A Boolean value indicating whether or not the alert includes a Help button.
filterProc

If the value in the movable field is true (alert is movable), then specify in this parameter a universal procedure pointer to an application-defined filter function that responds to events not handled by ModalDialog. If you do, all events will get routed to your application-defined event filter function for handling, even when your alert box window is in the background. If you set this parameter to null, the Dialog Manager uses the standard event filter function. 
defaultText

Text for button in OK position; see “Alert Default Text Constants”. The button automatically sizes and positions itself in the alert box. To specify that the default button names should be used, pass -1. To indicate that no button should be displayed, pass null.
cancelText

Text for button in Cancel position; see “Alert Default Text Constants”. The button automatically sizes and positions itself in the alert box. To specify that the default button names should be used, pass -1. To indicate that no button should be displayed, pass null.
otherText

Text for button in leftmost position; see “Alert Default Text Constants”. The button automatically sizes and positions itself in the alert box. To specify that the default button names should be used, pass -1. To indicate that no button should be displayed, pass null.
defaultButton

Specifies which button acts as the default button; see “Alert Button Constants”.
cancelButton

Specifies which button acts as the Cancel button (can be 0); see “Alert Button Constants”.
position

The alert box position, as defined by a window positioning constant. In this structure, the constant kWindowDefaultPosition is equivalent to the constant kWindowAlertPositionParentWindowScreen.
Discussion

A standard alert structure of type AlertStdAlertParamRec can be used when you call the function StandardAlert to customize the alert box. The AlertStdAlertParamRec type is available with Appearance Manager 1.0 and later. 
Availability
Available in Mac OS X v10.0 and later.*/
struct AlertStdAlertParamRec {
   Boolean movable;
   Boolean helpButton;
   ModalFilterUPP filterProc;
   ConstStringPtr defaultText;
   ConstStringPtr cancelText;
   ConstStringPtr otherText;
   SInt16 defaultButton;
   SInt16 cancelButton;
   UInt16 position;
};
typedef struct AlertStdAlertParamRec AlertStdAlertParamRec;
typedef AlertStdAlertParamRec * AlertStdAlertParamPtr;


/*Alert Type Constants


enum {
   kAlertStopAlert = 0,
   kAlertNoteAlert = 1,
   kAlertCautionAlert = 2,
   kAlertPlainAlert = 3
};
Constants
kAlertStopAlert

Stop alert box. 

Available in Mac OS X v10.0 and later.
kAlertNoteAlert

Note alert box. 

Available in Mac OS X v10.0 and later.
kAlertCautionAlert

Caution alert box. 

Available in Mac OS X v10.0 and later.
kAlertPlainAlert

Alert box with no icon.

Available in Mac OS X v10.0 and later.
Discussion

You can pass constants of type AlertType in the inAlertType parameter of StandardAlert to specify the type of alert box you wish to create. Alert type constants are available with Appearance Manager 1.0 and later.*/
enum {
   kAlertStopAlert = 0,
   kAlertNoteAlert = 1,
   kAlertCautionAlert = 2,
   kAlertPlainAlert = 3
};

/*DialogItemIndex


typedef SInt16 DialogItemIndex;
Availability
Available in Mac OS X v10.0 and later.*/
typedef SInt16 DialogItemIndex;


/*DialogRef

typedef DialogPtr DialogRef;
Availability
Available in Mac OS X v10.0 and later.*/
typedef DialogPtr DialogRef;



/*AlertType


typedef SInt16 AlertType;
Availability
Available in Mac OS X v10.0 and later.*/
typedef SInt16 AlertType;

/*AlertStdCFStringAlertParamRec

Defines an alert or sheet.

struct AlertStdCFStringAlertParamRec {
   UInt32 version;
   Boolean movable;
   Boolean helpButton;
   CFStringRef defaultText;
   CFStringRef cancelText;
   CFStringRef otherText;
   SInt16 defaultButton;
   SInt16 cancelButton;
   UInt16 position;
   OptionBits flags;
};
typedef struct AlertStdCFStringAlertParamRec AlertStdCFStringAlertParamRec;
typedef AlertStdCFStringAlertParamRec * AlertStdCFStringAlertParamPtr;
Fields
version

The version of this parameter record. Set this field to kStdCFStringAlertVersionOne.
movable

A Boolean value indicating whether or not the alert is movable.
helpButton

A Boolean value indicating whether or not the alert contains a Help button. 
defaultText

Text for button in the OK position. The button automatically sizes and positions itself in the alert box. To specify that the default button names should be used, pass -1 (see “Alert Default Text Constants” for values). To indicate that no button should be displayed, pass null
cancelText

Text for button in the Cancel position; see “Alert Default Text Constants”. The button automatically sizes and positions itself in the alert box. To specify that the default button names should be used, pass -1 see “Alert Default Text Constants” for values). To indicate that no button should be displayed, pass null.
otherText

Text for button in the other (leftmost) position; see “Alert Default Text Constants”. The button automatically sizes and positions itself in the alert box. To specify that the default button names should be used, pass -1. To indicate that no button should be displayed, pass null
defaultButton

Specifies which button acts as the default button; see “Alert Button Constants”.
cancelButton

Specifies which button acts as the default button; see “Alert Button Constants”.
position

The alert box position, as defined by a window positioning constant. In this structure, the constant kWindowDefaultPosition is equivalent to the constant kWindowAlertPositionParentWindowScreen. See the Window Manager Reference for other possible positioning constants. 
flags

Options for this alert. See “Standard Alert and Sheet Option Flags” for possible values.
Discussion

You pass this structure when calling CreateStandardAlert or CreateStandardSheet.
Availability
Available in Mac OS X v10.0 and later.*/
struct AlertStdCFStringAlertParamRec {
   UInt32 version;
   Boolean movable;
   Boolean helpButton;
   CFStringRef defaultText;
   CFStringRef cancelText;
   CFStringRef otherText;
   SInt16 defaultButton;
   SInt16 cancelButton;
   UInt16 position;
   OptionBits flags;
};
typedef struct AlertStdCFStringAlertParamRec AlertStdCFStringAlertParamRec;
typedef AlertStdCFStringAlertParamRec * AlertStdCFStringAlertParamPtr;

/*RunStandardAlert

Shows and runs a standard alert using a modal dialog loop.

OSStatus RunStandardAlert (
   DialogRef inAlert,
   ModalFilterUPP filterProc,
   DialogItemIndex * outItemHit
);
Parameters
inAlert

The alert to display. Note that this function automatically disposes of the dialog you pass in this parameter before returning. 
filterProc

An event filter function for handling events that do not apply to the alert. May be NULL. 
outItemHit

On exit, contains the item index of the button that was pressed to close the alert. 
Return Value

A result code. See “Dialog Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Dialogs.h*/
OSStatus RunStandardAlert (
   DialogRef inAlert,
   ModalFilterUPP filterProc,
   DialogItemIndex * outItemHit
);

/*CreateStandardAlert

Creates an alert containing standard elements and using standard formatting rules.

OSStatus CreateStandardAlert (
   AlertType alertType,
   CFStringRef error,
   CFStringRef explanation,
   const AlertStdCFStringAlertParamRec * param,
   DialogRef * outAlert
);
Parameters
alertType

The type of alert to create. 
error

The error string to display. 
explanation

The explanation string to display. May be NULL or empty to display no explanation.
param

The parameter block describing how to create the alert. May be NULL. 
outAlert

On exit, contains the new alert. 
Return Value

A result code. See “Dialog Manager Result Codes”.
Discussion

CreateStandardAlert should be used in conjunction with RunStandardAlert. After CreateStandardAlert returns, the alert is still invisible. RunStandardAlert will show the alert and run a modal dialog loop to process events in the alert.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Dialogs.h*/
OSStatus CreateStandardAlert (
   AlertType alertType,
   CFStringRef error,
   CFStringRef explanation,
   const AlertStdCFStringAlertParamRec * param,
   DialogRef * outAlert
);

/*StandardAlert

Displays a standard alert box. 

OSErr StandardAlert (
   AlertType inAlertType,
   ConstStr255Param inError,
   ConstStr255Param inExplanation,
   const AlertStdAlertParamRec * inAlertParam,
   SInt16 * outItemHit
);
Parameters
inAlertType

A constant indicating the type of alert box you wish to create; see “Alert Type Constants”. 
inError

A pointer to a Pascal string containing the primary error text you wish to display. 
inExplanation

A pointer to a Pascal string containing the secondary text you wish to display; secondary text is displayed in the small system font. Pass null to indicate no secondary text.
inAlertParam

A pointer to the standard alert structure; see AlertStdAlertParamRec. Pass null to specify that you do not wish to your alert box to incorporate any of the features that the standard alert structure provides. 
outItemHit

A pointer to a signed 16-bit integer value. On return, the value indicates the alert button pressed; see “Alert Button Constants”. 
Return Value

A result code. See “Dialog Manager Result Codes”.
Discussion

The StandardAlert function displays an alert box based on the values you pass it. You can pass the error text you wish displayed in the error and explanation parameters, and customize the alert button text by filling in the appropriate fields of the standard alert structure passed in the inAlertParam parameter.

StandardAlert automatically resizes the height of a dialog box to fit all static text. It ignores alert stages and therefore provides no corresponding alert sounds. 
Special Considerations

This function is available with Appearance Manager 1.0 and later.
Availability
Available in CarbonLib 1.0 and later when Appearance 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/
OSErr StandardAlert (
   AlertType inAlertType,
   ConstStr255Param inError,
   ConstStr255Param inExplanation,
   const AlertStdAlertParamRec * inAlertParam,
   SInt16 * outItemHit
);

/*AppendDialogItemList

Adds items to an existing dialog box while your program is running.

OSErr AppendDialogItemList (
   DialogRef dialog,
   SInt16 ditlID,
   DITLMethod method
);
Parameters
dialog

A pointer to the dialog box to which the items in the item list resource specified in the ditlID parameter are to be appended. 
ditlID

The resource ID of the item list resource whose items are to be appended to the dialog box specified in the dialog parameter. 
method

The manner in which the new items are to be displayed in the dialog box.

If you use the overlayDITL constant, AppendDialogItemList superimposes the appended items over the dialog box by interpreting the coordinates of the display rectangles for the appended items (as specified in their item list resource) as local coordinates within the dialog box.

If you use the appendDITLRight constant, AppendDialogItemList appends the items to the right of the dialog box by positioning the display rectangles of the appended items relative to the upper-right coordinate of the dialog box. The AppendDialogItemList function automatically expands the dialog box to accommodate the new dialog items.

If you use the appendDITLBottom constant, AppendDialogItemList appends the items to the bottom of the dialog box by positioning the display rectangles of the appended items relative to the lower-left coordinate of the dialog box. The AppendDialogItemList function automatically expands the dialog box to accommodate the new dialog items.

You can append a list of items relative to an existing item by passing a negative number. The absolute value of this number is interpreted as the item in the dialog box relative to which the new items are to be positioned. For example, if you pass -2, the display rectangles of the appended items are offset relative to the upper-left corner of item number 2 in the dialog box.

Return Value

A result code. See “Dialog Manager Result Codes”.
Discussion

To be Appearance-compliant, your program should use the AppendDialogItemList function rather than the AppendDITL function. Unlike AppendDITL, the AppendDialogItemList function takes a 'DITL' resource ID instead of a handle as the parameter describing the dialog item list to be appended, and it properly appends entries from a dialog font table ( 'dftb') resource, if there is a 'dftb' resource with the same resource ID as the 'DITL' resource.

The AppendDialogItemList function adds the items in the item list resource specified in the parameter ditlID to the items of a dialog box. This is especially useful if several dialog boxes share a single item list resource, because you can use AppendDialogItemList to add items that are appropriate for individual dialog boxes. Your application can use the Resource Manager function GetResource to get a handle to the item list resource whose items you wish to add.

You typically create an invisible dialog box, call the AppendDialogItemList function, then make the dialog box visible by using the Window Manager function ShowWindow. 
Version Notes

This function is available with Appearance Manager 1.0 and later.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/
OSErr AppendDialogItemList (
   DialogRef dialog,
   SInt16 ditlID,
   DITLMethod method
);

#ifdef __cplusplus
}
#endif

#endif