#ifndef CONTROLS_H
#define CONTROLS_H

#ifndef APPLICATIONSERVICES_H
#include <ApplicationServices/ApplicationServices.h>
#endif

#ifndef ICONS_H
#include <HIServices/Icons.h>
#endif

#ifndef APPEARANCE_H
#include <HIToolbox/Appearance.h>
#endif

#ifndef HIOBJECT_H
#include <HIToolbox/HIObject.h>
#endif

#ifndef MENUS_H
#include <HIToolbox/Menus.h>
#endif

#ifndef TEXTEDIT_H
#include <HIToolbox/TextEdit.h>
#endif

#ifndef DRAG_H
#include <HIToolbox/Drag.h>
#endif



#include <HYS/HIToolbox/Controls.h>
#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Control State Part Code Constants

enum {
   kControlNoPart = 0,
   kControlIndicatorPart = 129,
   kControlDisabledPart = 254,
   kControlInactivePart = 255
};
Constants
kControlNoPart

Identifies no specific control part. This value unhighlights any highlighted part of the control when passed to the HiliteControl function. For events in bevel buttons with an attached menu, this part code indicates that either the mouse was released outside the bevel button and menu or that the button was disabled.

Available in Mac OS X v10.0 and later.
kControlIndicatorPart

Identifies the scroll box of a scroll bar control.

Available in Mac OS X v10.0 and later.
kControlDisabledPart

Used with HiliteControlto disable the control.

Available in Mac OS X v10.0 and later.
kControlInactivePart

Used with HiliteControl to make the control inactive.

Available in Mac OS X v10.0 and later.
Discussion

Constants of type ControlPartCode identify specific parts of controls.

Part codes are meaningful only within the scope of a single control definition function. For example, the standard tab control uses part codes 1...N, where N is the number of tabs, even though those numbers do collide with part codes defined for use with other control definition functions. Therefore, when you wish to specify part codes for the tab control for use with the function SetControlData, for example, you should use a part code corresponding to a 1-based index of the tab whose data you wish to set. In other words, the first tab is part code 1, the second tab is part code 2, and so on.

Note that if you wish to create part codes for a custom control definition function, you may assign values anywhere within the ranges 1–128 and 130–253. Note also that the function FindControl does not typically return the kControlDisabledPart or kControlInactivePart part codes and never returns them with standard controls.*/
enum {
   kControlNoPart = 0,
   kControlIndicatorPart = 129,
   kControlDisabledPart = 254,
   kControlInactivePart = 255
};


/*Control Font Style and Key Filter Data Tag Constants

enum {
   kControlFontStyleTag = 'font',
   kControlKeyFilterTag = 'fltr',
   kControlKindTag = 'kind',
   kControlSizeTag = 'size'
};
Constants
kControlFontStyleTag

Sent with a pointer to a ControlKind record to be filled in. Only valid for GetControlData.

Available in Mac OS X v10.0 and later.
kControlKeyFilterTag

Gets or sets the key filter function for controls that handle filtered input (includes editable text and list box).

Data type returned or set: ControlKeyFilterUPP

Available in Mac OS X v10.0 and later.
Discussion

You can use the control data tag constants to set or obtain data that is associated with a control. The control data tag constants are passed in the inTagName parameters of SetControlData and GetControlData to specify the piece of data in a control that you wish to set or get. You can also pass these constants in the inTagName parameter of GetControlDataSize if you wish to determine the size of variable-length control data (e.g., text in an editable text control). These constants can also be used by custom control definition functions that return the feature bit kControlSupportsDataAccess in response to a kControlMsgGetFeatures message.

The data that your application sets or obtains can be of various types, dependent upon the control. Therefore, the descriptions of the control data tag constants list the data types for the information that you can set in the inData parameter to the SetControlData function and that you can get in the inBuffer parameter to the GetControlData function. 
Version Notes

The control data tag constants are available with Appearance Manager 1.0 and later.*/
enum {
   kControlFontStyleTag = 'font',
   kControlKeyFilterTag = 'fltr',
   kControlKindTag = 'kind',
   kControlSizeTag = 'size'
};

/*ControlRef

typedef struct OpaqueControlRef * ControlRef;
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaqueControlRef * ControlRef;

/*Control Entire Control Constant

enum {
   kControlEntireControl = 0
};*/
enum {
   kControlEntireControl = 0
};

/*Control Font Style Flag Constants

enum {
   kControlUseFontMask = 0x0001,
   kControlUseFaceMask = 0x0002,
   kControlUseSizeMask = 0x0004,
   kControlUseForeColorMask = 0x0008,
   kControlUseBackColorMask = 0x0010,
   kControlUseModeMask = 0x0020,
   kControlUseJustMask = 0x0040,
   kControlUseAllMask = 0x00FF,
   kControlAddFontSizeMask = 0x0100
};
Constants
kControlUseFontMask

If the kControlUseFontMask flag is set (bit 0), the font field of the control font style structure is applied to the control.

Available in Mac OS X v10.0 and later.
kControlUseFaceMask

If the kControlUseFaceMask flag is set (bit 1), the style field of the control font style structure is applied to the control. This flag is ignored if you specify a meta font value; see “Meta Font Constants”. 

Available in Mac OS X v10.0 and later.
kControlUseSizeMask

If the kControlUseSizeMask flag is set (bit 2), the size field of the control font style structure is applied to the control. This flag is ignored if you specify a meta font value; see “Meta Font Constants”.

Available in Mac OS X v10.0 and later.
kControlUseForeColorMask

If the kControlUseForeColorMask flag is set (bit 3), the foreColor field of the control font style structure is applied to the control. This flag only applies to static text controls.

Available in Mac OS X v10.0 and later.
kControlUseBackColorMask

If the kControlUseBackColorMask flag is set (bit 4), the backColor field of the control font style structure is applied to the control. This flag only applies to static text controls.

Available in Mac OS X v10.0 and later.
kControlUseModeMask

If the kControlUseModeMask flag is set (bit 5), the text mode specified in the mode field of the control font style structure is applied to the control.

Available in Mac OS X v10.0 and later.
kControlUseJustMask

If the kControlUseJustMask flag is set (bit 6), the just field of the control font style structure is applied to the control.

Available in Mac OS X v10.0 and later.
kControlUseAllMask

If kControlUseAllMask is used, all flags in this mask will be set except kControlUseAddFontSizeMask.

Available in Mac OS X v10.0 and later.
kControlAddFontSizeMask

If the kControlUseAddFontSizeMask flag is set (bit 8), the Dialog Manager will add a specified font size to the size field of the control font style structure. This flag is ignored if you specify a meta font value; see “Meta Font Constants”.

Available in Mac OS X v10.0 and later.
Discussion

You can pass one or more control font style flag constants in the flags field of the control font style structure to specify the field(s) of the structure that should be applied to the control; see “ControlFontStyleRec”. If none of the flags are set, the control uses the system font unless a control variant specifies use of a window font.
Version Notes

These control font style flag constants are available with Appearance Manager 1.0 and later.*/
enum {
   kControlUseFontMask = 0x0001,
   kControlUseFaceMask = 0x0002,
   kControlUseSizeMask = 0x0004,
   kControlUseForeColorMask = 0x0008,
   kControlUseBackColorMask = 0x0010,
   kControlUseModeMask = 0x0020,
   kControlUseJustMask = 0x0040,
   kControlUseAllMask = 0x00FF,
   kControlAddFontSizeMask = 0x0100
};

/*ControlRef

typedef struct OpaqueControlRef * ControlRef;
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaqueControlRef * ControlRef;

/*Control Features Constants

enum {
   kControlSupportsGhosting = 1 << 0,
   kControlSupportsEmbedding = 1 << 1,
   kControlSupportsFocus = 1 << 2,
   kControlWantsIdle = 1 << 3,
   kControlWantsActivate = 1 << 4,
   kControlHandlesTracking = 1 << 5,
   kControlSupportsDataAccess = 1 << 6,
   kControlHasSpecialBackground = 1 << 7,
   kControlGetsFocusOnClick = 1 << 8,
   kControlSupportsCalcBestRect = 1 << 9,
   kControlSupportsLiveFeedback = 1 << 10,
   kControlHasRadioBehavior = 1 << 11,
   kControlSupportsDragAndDrop = 1 << 12,
   kControlAutoToggles = 1 << 14,
   kControlSupportsGetRegion = 1 << 17,
   kControlSupportsFlattening = 1 << 19,
   kControlSupportsSetCursor = 1 << 20,
   kControlSupportsContextualMenus = 1 << 21,
   kControlSupportsClickActivation = 1 << 22,
   kControlIdlesWithTimer = 1 << 23
};
Constants
kControlSupportsGhosting

If this bit (bit 0) is set, the control definition function supports the kControlMsgDrawGhost message.

Available in Mac OS X v10.0 and later.
kControlSupportsEmbedding

If this bit (bit 1) is set, the control definition function supports the kControlMsgSubControlAdded and kControlMsgSubControlRemovedmessages.

Available in Mac OS X v10.0 and later.
kControlSupportsFocus

If this bit (bit 2) is set, the control definition function supports the kControlMsgKeyDown message. If this bit and the kControlGetsFocusOnClick bit are set, the control definition function supports the kControlMsgFocus message.

Available in Mac OS X v10.0 and later.
kControlWantsIdle

If this bit (bit 3) is set, the control definition function supports the kControlMsgIdle message.

Available in Mac OS X v10.0 and later.
kControlWantsActivate

If this bit (bit 4) is set, the control definition function supports the kControlMsgActivate message.

Available in Mac OS X v10.0 and later.
kControlHandlesTracking

If this bit (bit 5) is set, the control definition function supports the kControlMsgHandleTracking message. 

Available in Mac OS X v10.0 and later.
kControlSupportsDataAccess

If this bit (bit 6) is set, the control definition function supports the kControlMsgGetData and kControlMsgSetData messages.

Available in Mac OS X v10.0 and later.
kControlHasSpecialBackground

If this bit (bit 7) is set, the control definition function supports the kControlMsgSetUpBackground message. 

Available in Mac OS X v10.0 and later.
kControlGetsFocusOnClick

If this bit (bit 8) and the kControlSupportsFocus bit are set, the control definition function supports the kControlMsgFocus message.

Available in Mac OS X v10.0 and later.
kControlSupportsCalcBestRect

If this bit (bit 9) is set, the control definition function supports the kControlMsgCalcBestRect message. 

Available in Mac OS X v10.0 and later.
kControlSupportsLiveFeedback

If this bit (bit 10) is set, the control definition function supports the kControlMsgCalcValueFromPos message. 

Available in Mac OS X v10.0 and later.
kControlHasRadioBehavior

If this bit (bit 11) is set, the control definition function supports radio button behavior and can be embedded in a radio group control. This constant is available with Appearance 1.0.1 and later. 

Available in Mac OS X v10.0 and later.
kControlAutoToggles

If the bit specified by this mask is set, the control definition function supports automatically changing among various states (on, off, mixed) in response to user actions.

Available in Mac OS X v10.0 and later.
kControlSupportsGetRegion

If the bit specified by this mask is set, the control definition function supports the kControlMsgGetRegion message, described in “Control Definition Message Constants”.

Available in Mac OS X v10.0 and later.
Discussion

If your control definition function supports Appearance-compliant messages, it should return a bit field of the features it supports, composed of one or more of these bits.*/
enum {
   kControlSupportsGhosting = 1 << 0,
   kControlSupportsEmbedding = 1 << 1,
   kControlSupportsFocus = 1 << 2,
   kControlWantsIdle = 1 << 3,
   kControlWantsActivate = 1 << 4,
   kControlHandlesTracking = 1 << 5,
   kControlSupportsDataAccess = 1 << 6,
   kControlHasSpecialBackground = 1 << 7,
   kControlGetsFocusOnClick = 1 << 8,
   kControlSupportsCalcBestRect = 1 << 9,
   kControlSupportsLiveFeedback = 1 << 10,
   kControlHasRadioBehavior = 1 << 11,
   kControlSupportsDragAndDrop = 1 << 12,
   kControlAutoToggles = 1 << 14,
   kControlSupportsGetRegion = 1 << 17,
   kControlSupportsFlattening = 1 << 19,
   kControlSupportsSetCursor = 1 << 20,
   kControlSupportsContextualMenus = 1 << 21,
   kControlSupportsClickActivation = 1 << 22,
   kControlIdlesWithTimer = 1 << 23
};

/*Control Content Type Constants

enum {
   kControlContentTextOnly = 0,
   kControlNoContent = 0,
   kControlContentIconSuiteRes = 1,
   kControlContentCIconRes = 2,
   kControlContentPictRes = 3,
   kControlContentICONRes = 4,
   kControlContentIconSuiteHandle = 129,
   kControlContentCIconHandle = 130,
   kControlContentPictHandle = 131,
   kControlContentIconRef = 132,
   kControlContentICON = 133
};
Constants
kControlContentTextOnly

Content type is text. This constant is passed in the contentType field of the ControlButtonContentInfo structure if the content is text only. The variation code kControlUsesOwningWindowsFontVariant applies when text content is used. 

Available in Mac OS X v10.0 and later.
kControlContentIconSuiteRes

Content type uses an icon suite resource ID. The resource ID of the icon suite resource you wish to display should be in the resID field of the ControlButtonContentInfo structure. 

Available in Mac OS X v10.0 and later.
kControlContentCIconRes

Content type is a color icon resource ID. The resource ID of the color icon resource you wish to display should be in the resID field of the ControlButtonContentInfo structure.

Available in Mac OS X v10.0 and later.
kControlContentPictRes

Content type is a picture resource ID. The resource ID of the picture resource you wish to display should be in the resID field of the ControlButtonContentInfo structure.

Available in Mac OS X v10.0 and later.
kControlContentIconSuiteHandle

Content type is an icon suite handle. The handle of the icon suite you wish to display should be in the iconSuite field of the ControlButtonContentInfo structure.

Available in Mac OS X v10.0 and later.
kControlContentCIconHandle

Content type uses a color icon handle. The handle of the color icon you wish to display should be in the cIconHandle field of the ControlButtonContentInfo structure.

Available in Mac OS X v10.0 and later.
kControlContentPictHandle

Content type uses a picture handle. The handle of the picture you wish to display should be in the picture field of the ControlButtonContentInfo structure.

Available in Mac OS X v10.0 and later.
kControlContentIconRef

Content type is IconRef. An IconRef value for the icon you wish to display should be provided in the iconRef field of the ControlButtonContentInfo structure. Note that the kControlBevelButtonGraphicOffsetTag control data tag constant should not be used with IconRef based bevel button content, because IconRef based icons may change with a theme switch; see “Bevel Button Control Data Tag Constants”. Supported with Mac OS 8.5 and later.

Available in Mac OS X v10.0 and later.*/
enum {
   kControlContentTextOnly = 0,
   kControlNoContent = 0,
   kControlContentIconSuiteRes = 1,
   kControlContentCIconRes = 2,
   kControlContentPictRes = 3,
   kControlContentICONRes = 4,
   kControlContentIconSuiteHandle = 129,
   kControlContentCIconHandle = 130,
   kControlContentPictHandle = 131,
   kControlContentIconRef = 132,
   kControlContentICON = 133
};


/*ControlFontStyleRec

struct ControlFontStyleRec {
   SInt16 flags;
   SInt16 font;
   SInt16 size;
   SInt16 style;
   SInt16 mode;
   SInt16 just;
   RGBColor foreColor;
   RGBColor backColor;
};
typedef struct ControlFontStyleRec ControlFontStyleRec;
typedef ControlFontStyleRec * ControlFontStylePtr;
Fields
flags

A value specifying which fields of the structure should be applied to the control; see “Mac OS 8.5 Control Font Style Flag Constant” and “Control Font Style Flag Constants”. If none of the flags in the flags field of the structure are set, the control uses the system font unless the control variant kControlUsesOwningWindowsFontVariant has been specified, in which case the control uses the window font. 
font

If the kControlUseFontMask bit is set, then this field contains a value specifying the ID of the font family to use. If this bit is not set, then the system default font is used. A meta font constant can be specified instead; see “Meta Font Constants”.
size

If the kControlUseSizeMask bit is set, then this field contains a value specifying the point size of the text. If the kControlAddSizeMask bit is set, this value will represent the size to add to the current point size of the text. A meta font constant can be specified instead; see “Meta Font Constants”.
style

If the kControlUseFaceMask bit is set, then this field contains a value specifying which styles to apply to the text. If all bits are clear, the plain font style is used. The bit numbers and the styles they represent are bold (0), italic (1), underline (2), outline (3), shadow (4), condensed (5), and extended (6).
mode

If the kControlUseModeMask bit is set, then this field contains a value specifying how characters are drawn in the bit image. See Inside Macintosh: Imaging With QuickDraw for a discussion of transfer modes.
just

If the kControlUseJustMask bit is set, then this field contains a value specifying text justification. Possible values are teFlushDefault (0), teCenter (1), teFlushRight (-1), and teFlushLeft (-2).
foreColor

If the kControlUseForeColorMask bit is set, then this field contains an RGB color value to use when drawing the text. 
backColor

If the kControlUseBackColorMask bit is set, then this field contains an RGB color value to use when drawing the background behind the text. In certain text modes, background color is ignored.
Discussion

You can use the ControlFontStyleRec type to specify a control’s font. You pass a pointer to the control font style structure in the inStyle parameter of SetControlFontStyle to specify a control’s font. If none of the flags in the flags field of the structure are set, the control uses the system font unless the control variant kControlUsesOwningWindowsFontVariant has been specified, in which case the control uses the window font. The ControlFontStyleRec type is available with Appearance Manager 1.0 and later.

Note that if you wish to specify the font for controls in a dialog box, you should use a dialog font table resource, which is automatically read in by the Dialog Manager. 
Availability
Available in Mac OS X v10.0 and later.*/
struct ControlFontStyleRec {
   SInt16 flags;
   SInt16 font;
   SInt16 size;
   SInt16 style;
   SInt16 mode;
   SInt16 just;
   RGBColor foreColor;
   RGBColor backColor;
};
typedef struct ControlFontStyleRec ControlFontStyleRec;
typedef ControlFontStyleRec * ControlFontStylePtr;

/*ControlContentType

typedef SInt16 ControlContentType;
Availability
Available in Mac OS X v10.0 and later.*/
typedef SInt16 ControlContentType;

/*ControlButtonContentInfo

struct ControlButtonContentInfo {
   ControlContentType contentType
   union {
      SInt16 resID;
      CIconHandle cIconHandle;
      Handle iconSuite;
      IconRef iconRef;
      PicHandle picture;
      Handle ICONHandle;
      CGImageRef imageRef;
   } u;
};
typedef struct ControlButtonContentInfo ControlButtonContentInfo;
typedef ControlButtonContentInfo ControlImageContentInfo;
Fields
contentType

Specifies the bevel button or image well content type and whether the content is text-only, resource-based, or handle-based; see “Control Content Type Constants” for possible values. The value specified in the contentType field determines which of the other fields in the structure are used. For a description of this data type, see “ControlContentType”.
u

If the content type specified in the contentType field is kControlContentIconSuiteRes, kControlContentCIconRes, or kControlContentPictRes, this field contains the resource ID of a picture, color icon, or icon suite resource. If the contentType field is kControlContentCGImageRef, this field contains a CGImageRef.
Discussion

You can use the ControlButtonContentInfo structure to specify the content for a bevel button or image well. Values of type ControlButtonContentInfo are set via SetControlData and obtained from GetControlData, in conjunction with the kControlBevelButtonContentTag and kControlImageWellContentTag constants; see “Bevel Button Control Data Tag Constants” and “Image Well Control Data Tag Constants”. 
Version Notes

The ControlButtonContentInfo type is available with Appearance Manager 1.0 and later.
Availability
Available in Mac OS X v10.0 and later.*/
struct ControlButtonContentInfo {
   ControlContentType contentType;
   union {
      SInt16 resID;
      CIconHandle cIconHandle;
      Handle iconSuite;
      IconRef iconRef;
      PicHandle picture;
      Handle ICONHandle;
      CGImageRef imageRef;
   } u;
};
typedef struct ControlButtonContentInfo ControlButtonContentInfo;
typedef ControlButtonContentInfo ControlImageContentInfo;

/*Control Size Constants

enum {
   kControlSizeNormal = 0,
   kControlSizeSmall = 1,
   kControlSizeLarge = 2,
   kControlSizeAuto = 0xFFFF
};*/
enum {
   kControlSizeNormal = 0,
   kControlSizeSmall = 1,
   kControlSizeLarge = 2,
   kControlSizeAuto = 0xFFFF
};

/*ControlPartCode

typedef SInt16 ControlPartCode;
Availability
Available in Mac OS X v10.0 and later.*/
typedef SInt16 ControlPartCode;

/*ControlID

struct ControlID {
   OSType signature;
   SInt32 id;
};
typedef struct ControlID ControlID;
typedef ControlID HIViewID;
Availability
Available in Mac OS X v10.0 and later.*/
struct ControlID {
   OSType signature;
   SInt32 id;
};
typedef struct ControlID ControlID;

/*ControlRef

typedef struct OpaqueControlRef * ControlRef;
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaqueControlRef * ControlRef;

/*GetControl32BitValue

Obtains the current setting of a control.

SInt32 GetControl32BitValue (
   ControlRef theControl
);
Parameters
theControl

A handle to the control whose current setting you wish to obtain. 
Return Value

The current setting of the control. 
Discussion

Your application may use the GetControl32BitValue function to obtain a 32-bit value previously set with the function SetControl32BitValue.

If your application uses a 32-bit control value, it should not attempt to obtain this value by calling the pre–Mac OS 8.5 function GetControlValue because the 16-bit value that is returned does not accurately reflect the current 32-bit control value.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
SInt32 GetControl32BitValue (
   ControlRef theControl
);

/*GetControlPopupMenuHandle

Gets the menu handle for a pop-up control.

MenuRef GetControlPopupMenuHandle (
   ControlRef control
);
Parameters
control

The pop-up control to query.
Return Value

See the Menu Manager documentation for a description of the MenuRef data type.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
MenuRef GetControlPopupMenuHandle (
   ControlRef control
);

/*SetControl32BitMaximum

Changes the maximum setting of a control and, if appropriate, redraws it accordingly.

void SetControl32BitMaximum (
   ControlRef theControl,
   SInt32 newMaximum
);
Parameters
theControl

A handle to the control whose maximum setting you wish to change. For a description of this data type, see “ControlRef”.
newMaximum

The new maximum setting of the control. In general, to avoid unpredictable behavior, do not set the maximum control value lower than the current minimum value. 
Discussion

Your application may use the SetControl32BitMaximum function to set a 32-bit value as the maximum setting for a control.

If your application uses a 32-bit control maximum value, it should not attempt to obtain this value by calling the pre–Mac OS 8.5 function GetControlMaximum because the 16-bit value that is returned does not accurately reflect the current 32-bit control value. Instead, use the function GetControl32BitMaximum.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
void SetControl32BitMaximum (
   ControlRef theControl,
   SInt32 newMaximum
);

/*GetControlByID

Finds a control in a window by its unique ID.

OSStatus GetControlByID (
   WindowRef inWindow,
   const ControlID * inID,
   ControlRef * outControl
);
Parameters
inWindow

The window to query.
inID

The control ID.
outControl

A pointer to a value of type ControlRef that, on output, is filled in with the control reference for the control specified by inID. For a description of this data type, see “ControlRef”.
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

As of Mac OS X v10.3, this function is superseded by the HIViewFindByID function, which is preferred over the GetControlByID function. The first parameter to the HIViewFindByID function is a view and not a window, so you can start the search at any point in the hierarchy.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
OSStatus GetControlByID (
   WindowRef inWindow,
   const ControlID * inID,
   ControlRef * outControl
);

/*SetControlData

Sets control-specific data.

OSErr SetControlData (
   ControlRef inControl,
   ControlPartCode inPart,
   ResType inTagName,
   Size inSize,
   const void * inData
);
Parameters
inControl

A handle to the control for which data is to be set. 
inPart

The part code of the control part for which data is to be set; see “Control Meta Part Code Constants”, “Control Part Code Constants”, and “Control State Part Code Constants”. Passing kControlEntireControl indicates that either the control has no parts or the data is not tied to any specific part of the control. 
inTagName

A constant representing the control-specific data you wish to set see the data tag constants in the “Control Manager Constants” section. 
inSize

The size (in bytes) of the data pointed to by the inData parameter. For variable-length control data, pass the value returned in the outMaxSize parameter of GetControlDataSize in the inSize parameter. The number of bytes must match the actual data size. 
inData

A pointer to a buffer allocated by your application. This buffer contains the data that you are sending to the control. After calling SetControlData, your application is responsible for disposing of this buffer, if necessary, as information is copied by control.
Return Value

A result code. See “Control Manager Result Codes”. The result code errDataNotSupported indicates that the inTagName parameter is not valid.
Discussion

The SetControlData function sets control-specific data represented by the value in the inTagName parameter to the data pointed to by the inData parameter. SetControlData could be used, for example, to switch a progress indicator from a determinate to indeterminate state. For a list of the control attributes that can be set, see the data tag constants in the “Control Manager Constants” section. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
OSErr SetControlData (
   ControlRef inControl,
   ControlPartCode inPart,
   ResType inTagName,
   Size inSize,
   const void * inData
);

/*SetControlCommandID

Sets the command ID for a control. 

OSStatus SetControlCommandID (
   ControlRef inControl,
   UInt32 inCommandID
);
Parameters
inControl

. For a description of this data type, see 
inCommandID

The command ID that is to be set.
Return Value

A result code. See “Control Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
OSStatus SetControlCommandID (
   ControlRef inControl,
   UInt32 inCommandID
);

/*SetControlID

Sets a control’s ID. 

OSStatus SetControlID (
   ControlRef inControl,
   const ControlID * inID
);
Return Value

A result code. See “Control Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/

OSStatus SetControlID (
   ControlRef inControl,
   const ControlID * inID
);

/*GetControl32BitMinimum

Obtains the minimum setting of a control.

SInt32 GetControl32BitMinimum (
   ControlRef theControl
);
Parameters
theControl

A handle to the control whose minimum setting you wish to obtain. For a description of this data type, see “ControlRef”.
Return Value

The minimum setting of the control. 
Discussion

Your application may use the GetControl32BitMinimum function to obtain a 32-bit value previously set with the function SetControl32BitMinimum.

If your application uses a 32-bit control minimum value, it should not attempt to obtain this value by calling the pre–Mac OS 8.5 function GetControlMinimum because the 16-bit value that is returned does not accurately reflect the current 32-bit control value. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
SInt32 GetControl32BitMinimum (
   ControlRef theControl
);


/*GetControlOwner

Returns the window to which a control is bound.

WindowRef GetControlOwner (
   ControlRef control
);
Parameters
control

The control to query. For a description of this data type, see “ControlRef”.
Return Value

The window reference to which the control is bound, or NULL if the control is not bound to a window.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
WindowRef GetControlOwner (
   ControlRef control
);

/*SetControlAction

Sets the action function for a control.

void SetControlAction (
   ControlRef theControl,
   ControlActionUPP actionProc
);
Parameters
theControl

A handle to the control whose action function is to be changed. For a description of this data type, see 
actionProc

A universal procedure pointer to an action function defining what action your application takes while the user holds down the mouse button. See ControlActionProcPtr for a description of an action function. 
Discussion

The SetControlAction function associates the action function specified by actionProc with the control specified by theControl. If the cursor is in the specified control, the HandleControlClick and TrackControl functions call the specified action function when the user holds down the mouse button. You must provide the action function, and it must define some action to perform repeatedly as long as the user holds down the mouse button. HandleControlUnderClick and TrackControl always highlight and drag the control as appropriate.

SetControlAction should be used to set the application-defined action function for providing live feedback for standard system scroll bar controls.

Note that the action function associated with a control is used by TrackControl only if you set the action function to TrackControl to Pointer(–1). Also, an action function can be specified in the actionProc parameter to TrackControl, so you don’t have to call SetControlAction to change it.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/

void SetControlAction (
   ControlRef theControl,
   ControlActionUPP actionProc
);

/*GetControlData

Obtains control-specific data.

OSErr GetControlData (
   ControlRef inControl,
   ControlPartCode inPart,
   ResType inTagName,
   Size inBufferSize,
   void * inBuffer,
   Size * outActualSize
);
Parameters
inControl

A handle to the control to be examined. 
inPart

The part code of the control part from which data is to be obtained; see “Control Meta Part Code Constants”, “Control Part Code Constants”, and “Control State Part Code Constants”. Passing kControlEntireControl indicates that either the control has no parts or the data is not tied to any specific part of the control. For a description of this data type, see “ControlPartCode”. 
inTagName

A constant representing the control-specific data you wish to obtain see the data tag constants in the “Control Manager Constants” section. 
inBufferSize

The size (in bytes) of the data pointed to by the inBuffer parameter. For variable-length control data, pass the value returned in the outMaxSize parameter of GetControlDataSize in the inBufferSize parameter. The number of bytes must match the actual data size. 
inBuffer

On input, a pointer to a buffer allocated by your application. On return, the buffer contains a copy of the control-specific data. If you pass NULL on input, it is equivalent to calling GetControlDataSize. The actual size of the control-specific data will be returned in the outActualSize parameter. For variable-length data, the number of bytes must match the actual data size.
outActualSize

On input, a pointer to a Size value. On return, the value is set to the actual size of the data. You can pass NULL if you don’t care about this value. 
Return Value

A result code. See “Control Manager Result Codes”. The result code errDataNotSupported indicates that the inTagName parameter is not valid.
Discussion

The GetControlData function will only copy the amount of data specified in the inBufferSize parameter, but will tell you the actual size of the buffer so you will know if the data was truncated. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
OSErr GetControlData (
   ControlRef inControl,
   ControlPartCode inPart,
   ResType inTagName,
   Size inBufferSize,
   void * inBuffer,
   Size * outActualSize
);

/*SetControl32BitValue

Changes the current setting of a control and redraws it accordingly.

void SetControl32BitValue (
   ControlRef theControl,
   SInt32 newValue
);
Parameters
theControl

A handle to the control whose current setting you wish to change. For a description of this data type, see “ControlRef”.
newValue

A value specifying the new setting of the control. If the specified value is less than the minimum setting for the control, SetControl32BitValue sets the current setting of the control to its minimum setting. If the specified value is greater than the maximum setting, SetControl32BitValue sets the control to its maximum.
Discussion

Your application may use the SetControl32BitValue function to set a 32-bit value as the current setting for a control.

If your application uses a 32-bit control value, it should not attempt to obtain this value by calling the pre–Mac OS 8.5 function GetControlValue because the 16-bit value that is returned does not accurately reflect the current 32-bit control value. Instead, use the function GetControl32BitValue. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/

void SetControl32BitValue (
   ControlRef theControl,
   SInt32 newValue
);

/*Draw1Control

Draws a control and any embedded controls that are currently visible in the specified window. 

void Draw1Control (
   ControlRef theControl
);
Parameters
theControl

A handle to the control to draw. For a description of this data type, see “ControlRef”.
Discussion

Although you should generally use the functionUpdateControls to update controls, you can use the DrawOneControl function to update a single control. If an embedding hierarchy exists and the control passed in has embedded controls, DrawOneControl draws the control and embedded controls. If the root control for a window is passed in, the result is the same as if DrawControls was called.

If you are using compositing mode, you generally do not need to call Draw1Control. If you call Draw1Control in compositing mode, keep in mind that it draws the specified control as well as all other controls that intersect the control.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
void Draw1Control (
   ControlRef theControl
);

/*GetControlValue

Obtains a control’s current setting. (Deprecated. Use GetControl32BitValue instead.)

Not recommended

SInt16 GetControlValue (
   ControlRef theControl
);
Parameters
theControl

On input, a handle to a control. 
Return Value

The current setting of the control. 
Discussion

When you create a control, you specify an initial setting either in the control resource or in the value parameter of the function NewControl. You can change the setting by calling SetControlValue.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/

SInt16 GetControlValue (
   ControlRef theControl
);

/*SetControlMaximum

Changes the maximum setting of a control and redraws its indicator or scroll box accordingly. (Deprecated. Use SetControl32BitMaximum instead.)

Not recommended

void SetControlMaximum (
   ControlRef theControl,
   SInt16 newMaximum
);
Parameters
theControl

A handle to the control whose maximum setting you wish to change. 
newMaximum

The new maximum setting. 
Discussion

The SetControlMaximum function changes the maximum value of a control to the value specified by the newMaximum parameter and redraws its indicator or scroll box to reflect its new range.

When you set the maximum setting of a scroll bar equal to its minimum setting, the control definition function makes the scroll bar inactive. When you make the maximum setting exceed the minimum, the control definition function makes the scroll bar active again.

When you create a control, you specify an initial maximum setting either in the control resource or in the max parameter of the function NewControl. To determine a control’s current maximum setting, use the function GetControlMaximum. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
void SetControlMaximum (
   ControlRef theControl,
   SInt16 newMaximum
);

/*SetControlMinimum

Changes the minimum setting of a control and redraws its indicator or scroll box accordingly. (Deprecated. Use SetControl32BitMinimum instead.)

Not recommended

void SetControlMinimum (
   ControlRef theControl,
   SInt16 newMinimum
);
Parameters
theControl

A handle to the control whose minimum setting you wish to change. For a description of this data type, see “ControlRef”.
newMinimum

The new minimum setting.
Discussion

The SetControlMinimum function changes the control’s minimum value to the value specified by the newMinimum parameter and redraws its indicator or scroll box to reflect its new range.

When you create a control, you specify an initial minimum setting either in the control resource or in the min parameter of the NewControl function. To obtain a control’s current minimum setting, use the function GetControlMinimum. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
void SetControlMinimum (
   ControlRef theControl,
   SInt16 newMinimum
);

/*GetControlReference

Obtains a control’s current reference value. 

SInt32 GetControlReference (
   ControlRef theControl
);
Parameters
theControl

A handle to the control whose current reference value you wish to determine. 
Return Value

The current reference value for the specified control. 
Discussion

When you create a control, you specify an initial reference value, either in the control resource or in the refCon parameter of the function NewControl. The reference value is stored in the contrlRfCon field of the control structure. You can use this field for any purpose, and you can use the function SetControlReference to change this value. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
SInt32 GetControlReference (
   ControlRef theControl
);

/*SetControlReference

Changes a control’s current reference value. 

void SetControlReference (
   ControlRef theControl,
   SInt32 data
);
Parameters
theControl

A handle to the control whose reference value you want to change. For a description of this data type, see “ControlRef”.
data

The new reference value for the control.
Discussion

The SetControlReference function sets the control’s reference value to the value you specify in the data parameter.

When you create a control, you specify an initial reference value, either in the control resource or in the refCon parameter of the function NewControl. Call GetControlReference to obtain the current value. You can use this value for any purpose.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
void SetControlReference (
   ControlRef theControl,
   SInt32 data
);

#ifdef __cplusplus
}
#endif

#endif