#ifndef FOLDERS_H
#define FOLDERS_H


#ifndef MACTYPES_H
#include <CarbonCore/MacTypes.h>
#endif

#ifndef MIXEDMODE_H
#include <CarbonCore/MixedMode.h>
#endif

#ifndef FILES_H
#include <CarbonCore/Files.h>
#endif



#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif


/*Create Folder Flags

Indicate whether a folder should be created, if it is not found.

enum {
   kCreateFolder = true,
   kDontCreateFolder = false
};
Constants
kCreateFolder

Specifies that the folder should be created, if it is not found. 

Available in Mac OS X v10.0 and later.
kDontCreateFolder

Specifies that the folder should not be created, if it is not found.

Available in Mac OS X v10.0 and later.
Discussion

You can pass these flag constants in the createFolder parameter of the function FSFindFolder.*/

enum {
   kCreateFolder = true,
   kDontCreateFolder = false
};


/*kDomainTopLevelFolderType



enum {
   kDomainTopLevelFolderType = 'dtop',
   kDomainLibraryFolderType = 'dlib',
   kColorSyncFolderType = 'sync',
   kColorSyncCMMFolderType = 'ccmm',
   kColorSyncScriptingFolderType = 'cscr',
   kPrintersFolderType = 'impr',
   kSpeechFolderType = 'spch',
   kCarbonLibraryFolderType = 'carb',
   kDocumentationFolderType = 'info',
   kDeveloperDocsFolderType = 'ddoc',
   kDeveloperHelpFolderType = 'devh',
   kISSDownloadsFolderType = 'issd',
   kUserSpecificTmpFolderType = 'utmp',
   kCachedDataFolderType = 'cach',
   kFrameworksFolderType = 'fram',
   kPrivateFrameworksFolderType = 'pfrm',
   kClassicDesktopFolderType = 'sdsk',
   kDeveloperFolderType = 'devf',
   kSystemSoundsFolderType = 'ssnd',
   kComponentsFolderType = 'cmpd',
   kQuickTimeComponentsFolderType = 'wcmp',
   kCoreServicesFolderType = 'csrv',
   kPictureDocumentsFolderType = 'pdoc',
   kMovieDocumentsFolderType = 'mdoc',
   kMusicDocumentsFolderType = 'doc',
   kInternetSitesFolderType = 'site',
   kPublicFolderType = 'pubb',
   kAudioSupportFolderType = 'adio',
   kAudioSoundsFolderType = 'asnd',
   kAudioSoundBanksFolderType = 'bank',
   kAudioAlertSoundsFolderType = 'alrt',
   kAudioPlugInsFolderType = 'aplg',
   kAudioComponentsFolderType = 'acmp',
   kKernelExtensionsFolderType = 'kext',
   kDirectoryServicesFolderType = 'dsrv',
   kDirectoryServicesPlugInsFolderType = 'dplg',
   kInstallerReceiptsFolderType = 'rcpt',
   kFileSystemSupportFolderType = 'fsys',
   kAppleShareSupportFolderType = 'shar',
   kAppleShareAuthenticationFolderType = 'auth',
   kMIDIDriversFolderType = 'midi',
   kKeyboardLayoutsFolderType = 'klay',
   kIndexFilesFolderType = 'indx',
   kFindByContentIndexesFolderType = 'fbcx',
   kManagedItemsFolderType = 'mang',
   kBootTimeStartupItemsFolderType = 'empz'
};*/
enum {
   kDomainTopLevelFolderType = 'dtop',
   kDomainLibraryFolderType = 'dlib',
   kColorSyncFolderType = 'sync',
   kColorSyncCMMFolderType = 'ccmm',
   kColorSyncScriptingFolderType = 'cscr',
   kPrintersFolderType = 'impr',
   kSpeechFolderType = 'spch',
   kCarbonLibraryFolderType = 'carb',
   kDocumentationFolderType = 'info',
   kDeveloperDocsFolderType = 'ddoc',
   kDeveloperHelpFolderType = 'devh',
   kISSDownloadsFolderType = 'issd',
   kUserSpecificTmpFolderType = 'utmp',
   kCachedDataFolderType = 'cach',
   kFrameworksFolderType = 'fram',
   kPrivateFrameworksFolderType = 'pfrm',
   kClassicDesktopFolderType = 'sdsk',
   kDeveloperFolderType = 'devf',
   kSystemSoundsFolderType = 'ssnd',
   kComponentsFolderType = 'cmpd',
   kQuickTimeComponentsFolderType = 'wcmp',
   kCoreServicesFolderType = 'csrv',
   kPictureDocumentsFolderType = 'pdoc',
   kMovieDocumentsFolderType = 'mdoc',
   kMusicDocumentsFolderType = 'doc',
   kInternetSitesFolderType = 'site',
   kPublicFolderType = 'pubb',
   kAudioSupportFolderType = 'adio',
   kAudioSoundsFolderType = 'asnd',
   kAudioSoundBanksFolderType = 'bank',
   kAudioAlertSoundsFolderType = 'alrt',
   kAudioPlugInsFolderType = 'aplg',
   kAudioComponentsFolderType = 'acmp',
   kKernelExtensionsFolderType = 'kext',
   kDirectoryServicesFolderType = 'dsrv',
   kDirectoryServicesPlugInsFolderType = 'dplg',
   kInstallerReceiptsFolderType = 'rcpt',
   kFileSystemSupportFolderType = 'fsys',
   kAppleShareSupportFolderType = 'shar',
   kAppleShareAuthenticationFolderType = 'auth',
   kMIDIDriversFolderType = 'midi',
   kKeyboardLayoutsFolderType = 'klay',
   kIndexFilesFolderType = 'indx',
   kFindByContentIndexesFolderType = 'fbcx',
   kManagedItemsFolderType = 'mang',
   kBootTimeStartupItemsFolderType = 'empz'
};


/*Disk and Domain Constants

Identify the disk or domain in which to locate a folder.

enum {
   kOnSystemDisk = -32768L,
   kOnAppropriateDisk = -32767,
   kSystemDomain = -32766,
   kLocalDomain = -32765,
   kNetworkDomain = -32764,
   kUserDomain = -32763,
   kClassicDomain = -32762
};
enum {
   kLastDomainConstant = kUserDomain
};
Constants
kOnSystemDisk

Specifies the system disk.

Available in Mac OS X v10.0 and later.
kOnAppropriateDisk

In most cases, the equivalent of kOnSystemDisk. On Mac OS X, use this constant instead of the constant kOnSytemDisk to indicate any disk.

Available in Mac OS X v10.0 and later.
kSystemDomain

Available in Mac OS X v10.0 and later.
kLocalDomain

Available in Mac OS X v10.0 and later.
kNetworkDomain

Available in Mac OS X v10.0 and later.
kUserDomain

Available in Mac OS X v10.0 and later.
kClassicDomain

Available in Mac OS X v10.0 and later.
kLastDomainConstant

Available in Mac OS X v10.0 and later.
Discussion

You can pass this constant in the vRefNum parameter of FSFindFolder to locate a folder on the startup disk.*/
enum {
   kOnSystemDisk = -32768L,
   kOnAppropriateDisk = -32767,
   kSystemDomain = -32766,
   kLocalDomain = -32765,
   kNetworkDomain = -32764,
   kUserDomain = -32763,
   kClassicDomain = -32762
};
enum {
   kLastDomainConstant = kUserDomain
};

/*FSFindFolder

Obtains location information for system-related directories.

OSErr FSFindFolder (
   short vRefNum,
   OSType folderType,
   Boolean createFolder,
   FSRef * foundRef
);
Parameters
vRefNum

Pass the volume reference number of the volume on which you want to locate a directory, or a constant specifying a disk or domain. The constants which you can use in this parameter are described in Disk and Domain Constants.

Note that, on Mac OS X, passing a volume reference number in this parameter does not make sense for most of the folder type selectors which you can specify in the folderType parameter. On Mac OS X, folders are "domain-oriented"; because there may be more than one domain on any given physical volume, asking for these folders on a per-volume basis yields undefined results. For example, if you were to request the Fonts folder (represented by the selector kFontsFolderType)on volume -100, are you requesting the folder /System/Library/Fonts, /Library/Fonts, or ~/Fonts? On Mac OS X you should pass a disk or domain constant in this parameter.
folderType

Pass a four-character folder type, or a constant that represents the type, for the folder you want to find; see Folder Type Constants.
createFolder

A value of type Boolean, as defined in Create Folder Flags. Pass the constant kCreateFolder to create a directory if it does not already exist; otherwise, pass the constant kDontCreateFolder. Passing kCreateFolder will not create a parent folder; if the parent of the target folder does not already exist, attempting to create the target will fail.
foundRef

A pointer to a file system reference. On return, the FSRef refers to the directory specified by the vRefNum and folderType parameters.
Return Value

A result code. See "Folder Manager Result Codes".
Availability
Available in Mac OS X v10.0 and later.
Declared In
Folders.h*/
OSErr FSFindFolder (
   short vRefNum,
   OSType folderType,
   Boolean createFolder,
   FSRef * foundRef
);

#ifdef __cplusplus
}
#endif

#endif