#ifndef QUICKTIME_H
#include <QuickTime/QuickTime.h>
#endif




/*SCAudioFillBuffer

Used is used to pull compressed frames from the StdAudio component in kQTSCAudioPropertyID_BasicDescription format.

ComponentResult SCAudioFillBuffer (
   ComponentInstance ci,
   SCAudioInputDataProc inInputDataProc,
   void *inInputDataProcRefCon,
   UInt32 *ioOutputDataPacketSize,
   AudioBufferList *outOutputData,
   AudioStreamPacketDescription *outPacketDescription
);
Parameters
ci

The client’s connection to a StdAudio Compression component.
inInputDataProc

The proc address of the function that will be called to supply data in the kQTSCAudioPropertyID_InputBasicDescription format to SCAudio.
inInputDataProcRefCon

The client refcon that will be passed to the user-provided SCAudioInputDataProc function.
ioOutputDataPacketSize

On input, the number of desired packets. On output, the actual number of packets delivered (can be fewer than the input desired packets).
outOutputData

An AudioBufferList providing sufficiently large buffers to hold the requested number of packets.
outPacketDescription

An array of AudioStreamPacketDescriptions. If the requested output format requires external framing information––that is, a VBR format such as AAC–– allocate and pass an array of packet descriptions as large as the number of packets you are requesting.
Discussion

SCAudioFillBuffer preserves the same style API as the Core Audio AudioConverterFillComplexBuffer API, which is part of the AudioToolbox framework and resides in AudioConverter.h. 

This function has the same parameters as AudioConverterFillComplexBuffer, but internally it has an audio converter, a matrix mixer, and another audio converter. It is based on a “pull” model: You pull on the audio converter for some output, and specify the buffer in which you want to put it. You have already configured the format that it is going to return to you. You also provide it with an input proc and it will call back that input proc and specify however many samples of audio you have. For example, if you want five packets of AAC audio coming out the back end, and at the front end you happen to have PCM de-interleaved, the routine will ask you for the samples. The difference is you can now have different numbers of channels going in or out. For example, at the same time you are doing the compression from PCM to AAC, you can also go from 5.1 to stereo.

SCAudioFillBuffer is used to pull compressed frames from the StdAudio component in kQTSCAudioPropertyID_BasicDescription format. The StdAudio component can perform any combination of decompression/mixing/compression, combining the facilities of Core Audio AudioConverters and Matrix Mixer AudioUnits. The behavior of the SCAudioFillBuffer call (signalling end of data, and so on) is identical to the AudioConverter's AudioConverterFillComplexBuffer API.

One important difference between the AudioConverter and SCAudio component is that the SCAudio compression APIs can do mixing as well as n -> n channels conversion. If you want to compress, decompress, or transcode audio using the SCAudioFillBuffer interface, you configure the StandardCompressionSubTypeAudio component with the desired input and output formats (or use the SCRequestImageSettings API to present a dialog and let a user select an output format), then you call SCAudioFillBuffer, providing an SCAudioInputDataProc callback, which is called for audio in the specified source format.
Version Notes

Introduced in QuickTime 7.1 for Windows and QuickTime 7 for Mac OS X. 
Availability
Carbon status: Supported C interface file: QuickTimeComponents.h
Declared In
QuickTimeComponents.h*/
ComponentResult SCAudioFillBuffer (
   ComponentInstance ci,
   SCAudioInputDataProc inInputDataProc,
   void *inInputDataProcRefCon,
   UInt32 *ioOutputDataPacketSize,
   AudioBufferList *outOutputData,
   AudioStreamPacketDescription *outPacketDescription
);


/*MovieAudioExtractionFillBuffer

Extracts audio from a movie.

OSStatus MovieAudioExtractionFillBuffer (
   MovieAudioExtractionRef    session,
   UInt32                     *ioNumFrames,
   AudioBufferList            *ioData,
   UInt32                     *outFlags );
Parameters
session

The session object returned by MovieAudioExtractionBegin.
ioNumFrames

A pointer to the number of PCM frames to be extracted.
ioData

A pointer to an AudioBufferList allocated by the caller to hold the extracted audio data.
outFlags

A bit flag that indicates when extraction is complete: kMovieAudioExtractionComplete The extraction process is complete. Value is (1L << 0). See these constants: 
Return Value

An error code. Returns noErr if there is no error.
Discussion

You call this function repeatedly; each call continues extracting audio where the last call left off. The function will extract as many of the requested PCM frames as it can, given the limits of the buffer supplied and the limits of the input movie. ioNumFrames will be updated with the exact number of valid frames being returned. When there is no more audio to extract from the movie, the function will continue to return noErr but will return no further audio data. In this case, the outFlags parameter will have its kMovieAudioExtractionComplete bit set. It is possible that the kMovieAudioExtractionComplete bit will accompany the last buffer of valid data.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/



OSStatus MovieAudioExtractionFillBuffer (
   MovieAudioExtractionRef    session,
   UInt32                     *ioNumFrames,
   AudioBufferList           *ioData,
   UInt32                     *outFlags ){
//TODO
};

/*EnterMovies

Initializes the Movie Toolbox and creates a private storage area for your application.

OSErr EnterMovies ( void );
Return Value

Be sure to check the value returned by this function before using any other facilities of the Movie Toolbox. See Error Codes. Returns noErr if there is no error.
Discussion

Before calling any Movie Toolbox functions, you must use EnterMovies to initialize the toolbox. Your application may call EnterMovies multiple times. The following code sample demonstrates how your application can call the Gestalt Manager to determine whether the Movie Toolbox is installed, using the selector gestaltQuickTime ('qtim'), before calling EnterMovies://Using the Gestalt Manager with the Movie Toolbox
#include <GestaltEqu.h>
#include <Movies.h>
Boolean IsQuickTimeInstalled (void)
{
    short   error;
    long    result;
 
    error =Gestalt (gestaltQuickTime, &result);
    return (error ==noErr);
}
void main (void)
{
    Boolean qtInstalled;
    .
    .
    .
    qtInstalled =IsQuickTimeInstalled ();
}
// EnterMovies coding example
// See "Discovering QuickTime," page 242
void MyInitMovieToolbox (void)
{
    InitGraf(&qd.thePort);
    InitFonts();
    InitWindows();
    InitMenus();
    TEInit();
    InitDialogs(NIL);
    EnterMovies();
}
void main (void)
{
    MyInitMovieToolbox();
    CreateMyCoolMovie();
}

Special Considerations

You should initialize any other Macintosh managers your application uses before calling EnterMovies. You do not need to balance calls to EnterMovies with calls to ExitMovies; you need to call ExitMovies only if you finish with the Movie Toolbox long before your application is ready to quit.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In\
Movies.h*/
OSErr EnterMovies ( void ){
//TODO
};

/*QTGetComponentProperty

Returns the value of a specific component property.

ComponentResult QTGetComponentProperty (
   ComponentInstance         inComponent,
   ComponentPropertyClass    inPropClass,
   ComponentPropertyID       inPropID,
   ByteCount                 inPropValueSize,
   ComponentValuePtr         outPropValueAddress,
   ByteCount                 *outPropValueSizeUsed );
Parameters
inComponent

A component instance, which you can get by calling OpenComponent or OpenDefaultComponent.
inPropClass

A value (see below) of type OSType that specifies a property class: kComponentPropertyClassPropertyInfo ('pnfo') A QTComponentPropertyInfo structure that defines a property information class. kComponentPropertyInfoList ('list') An array of QTComponentPropertyInfo structures, one for each property. kComponentPropertyCacheSeed ('seed') A component property cache seed value. kComponentPropertyExtendedInfo ('meta') A CFDictionary with extended property information. kComponentPropertyCacheFlags ('flgs') One of the following two flags: kComponentPropertyCacheFlagNotPersistent Property metadata should not be saved in persistent cache. kComponentPropertyCacheFlagIsDynamic Property metadata should not be cached at all. See these constants: 
kComponentPropertyClassPropertyInfo
kComponentPropertyInfoList
kComponentPropertyCacheSeed
kComponentPropertyExtendedInfo
kComponentPropertyCacheFlags
kComponentPropertyCacheFlagNotPersistent
kComponentPropertyCacheFlagIsDynamic
inPropID

A value of type OSType that specifies a property ID.
inPropValueSize

The size of the buffer allocated to hold the property value.
outPropValueAddress

A pointer to the buffer allocated to hold the property value.
outPropValueSizeUsed

On return, the actual size of the value written to the buffer.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
ComponentResult QTGetComponentProperty (
   ComponentInstance         inComponent,
   ComponentPropertyClass    inPropClass,
   ComponentPropertyID       inPropID,
   ByteCount                 inPropValueSize,
   ComponentValuePtr         outPropValueAddress,
   ByteCount                 *outPropValueSizeUsed ){
//TODO
};



/*MovieAudioExtractionSetProperty

Sets a property of a movie audio extraction session.

OSStatus MovieAudioExtractionSetProperty (
   MovieAudioExtractionRef    session,
   QTPropertyClass            inPropClass,
   QTPropertyID               inPropID,
   ByteCount                  inPropValueSize,
   ConstQTPropertyValuePtr    inPropValueAddress );
Parameters
session

The session object returned by MovieAudioExtractionBegin.
inPropClass

Pass the following constant to define the property class: Property of an audio presentation; value is 'audi'.
inPropID

Pass one of these constants to define the property ID: kAudioPropertyID_SummaryChannelLayout The summary audio channel layout of a movie, or any other grouping of audio streams. All like-labeled channels are combined, without duplicates. For example, if there is a stereo (L/R) track, 5 single-channel tracks marked Left, Right, Left Surround, Right Surround and Center, and a 4-channel track marked L/R/Ls/Rs, then the summary AudioChannelLayout will be L/R/Ls/Rs/C, not L/R/L/R/Ls/Rs/C/L/R/Ls/Rs. The value of this constant is 'clay'. See these constants: 
inPropValueSize

The size of the property value.
inPropValueAddress

A const void pointer that points to the property value.
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/OSStatus MovieAudioExtractionSetProperty (
   MovieAudioExtractionRef    session,
   QTPropertyClass            inPropClass,
   QTPropertyID               inPropID,
   ByteCount                  inPropValueSize,
   ConstQTPropertyValuePtr    inPropValueAddress ){
//TODO
};


/*MovieAudioExtractionBegin

Begins a movie audio extraction session.

OSStatus MovieAudioExtractionBegin (
   Movie                      m,
   UInt32                     flags,
   MovieAudioExtractionRef    *outSession );
Parameters
m

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromProperties, NewMovieFromFile, and NewMovieFromHandle.
flags

Reserved; must be 0.
outSession

A pointer to an opaque session object.
Return Value

An error code. Returns noErr if there is no error.
Discussion

You must call this function before doing any movie audio extraction, because you will pass the object returned by outSession to the other movie audio extraction functions. The format of the extracted audio defaults to the summary channel layout of the movie (all right channels mixed together, all left surround channels mixed together, and so on.), 32-bit float, de-interleaved, with the sample rate set to the highest sample rate found in the movie. You can set the audio format to be something else, as long as it is uncompressed and you do it before your first call to MovieAudioExtractionFillBuffer.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus MovieAudioExtractionBegin (
   Movie                      m,
   UInt32                     flags,
   MovieAudioExtractionRef    *outSession ){
//TODO
};


/*QTGetComponentPropertyInfo

Returns information about the properties of a component.

ComponentResult QTGetComponentPropertyInfo (
   ComponentInstance         inComponent,
   ComponentPropertyClass    inPropClass,
   ComponentPropertyID       inPropID,
   ComponentValueType        *outPropType,
   ByteCount                 *outPropValueSize,
   UInt32                    *outPropertyFlags );
Parameters
inComponent

A component instance, which you can get by calling OpenComponent or OpenDefaultComponent.
inPropClass

A value (see below) of type OSType that specifies a property class: kComponentPropertyClassPropertyInfo ('pnfo') A QTComponentPropertyInfo structure that defines a property information class. kComponentPropertyInfoList ('list') An array of QTComponentPropertyInfo structures, one for each property. kComponentPropertyCacheSeed ('seed') A component property cache seed value. kComponentPropertyExtendedInfo ('meta') A CFDictionary with extended property information. kComponentPropertyCacheFlags ('flgs') One of the following two flags: kComponentPropertyCacheFlagNotPersistent Property metadata should not be saved in persistent cache. kComponentPropertyCacheFlagIsDynamic Property metadata should not be cached at all. See these constants: 
kComponentPropertyClassPropertyInfo
kComponentPropertyInfoList
kComponentPropertyCacheSeed
kComponentPropertyExtendedInfo
kComponentPropertyCacheFlags
kComponentPropertyCacheFlagNotPersistent
kComponentPropertyCacheFlagIsDynamic
inPropID

A value of type OSType that specifies a property ID.
outPropType

A pointer to memory allocated to hold the property type on return. This pointer may be NULL.
outPropValueSize

A pointer to memory allocated to hold the size of the property value on return. This pointer may be NULL.
outPropertyFlags

A pointer to memory allocated to hold property flags on return.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
ComponentResult QTGetComponentPropertyInfo (
   ComponentInstance         inComponent,
   ComponentPropertyClass    inPropClass,
   ComponentPropertyID       inPropID,
   ComponentValueType        *outPropType,
   ByteCount                 *outPropValueSize,
   UInt32                    *outPropertyFlags ){
//TODO
};


/*BeginMediaEdits

Starts a media-editing session.

OSErr BeginMediaEdits (
   Media    theMedia );
Parameters
theMedia

The media for this operation. Your application obtains this media identifier from such functions as NewTrackMedia and GetTrackMedia. See Media Identifiers.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

Use EndMediaEdits to end a media-editing session. You must call BeginMediaEdits before you add samples to a media with the AddMediaSample function. You must also call BeginMediaEdits before calling InsertTrackSegment if you wish InsertTrackSegment to copy media samples instead of copying the segment by reference.// BeginMediaEdits coding example
// See "Discovering QuickTime," page 89
void CreateMyVideoTrack (Movie movie)
{
    Track   track;
    Media   media;
    Rect    rect ={0, 0, 100, 320};
    track =NewMovieTrack(movie,
                FixRatio(rect.right, 1),
                FixRatio(rect.bottom, 1),
                kNoVolume);
    media =NewTrackMedia(track,
                VideoMediaType,
                600,                            // video time scale
                NIL, NIL);
    BeginMediaEdits(media);
    MyAddVideoSamplesToMedia(media, &rect);     // assemble data
    EndMediaEdits(media);
    InsertMediaIntoTrack(track,
                0,                              // track start time
                0,                              // media start time
                GetMediaDuration(media),
                kFix1);                         // normal speed
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr BeginMediaEdits (
   Media    theMedia ){
//TODO
};


/*NewTrackMedia

Creates a media for a new track.

Media NewTrackMedia (
   Track        theTrack,
   OSType       mediaType,
   TimeScale    timeScale,
   Handle       dataRef,
   OSType       dataRefType );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack.
mediaType

The type of media to create; see Media Identifiers. The Movie Toolbox uses this value to find the correct media handler for the new media. If the Movie Toolbox cannot locate an appropriate media handler, it returns an error.
timeScale

Defines the media's time coordinate system.
dataRef

The data reference. This parameter contains a handle to the information that identifies the file that contains this media's data. The type of information stored in that handle depends upon the value of the dataRefType parameter. If you are creating a new media that refers to existing media data, you can use the GetMediaDataRef function to obtain information about the existing data reference. You can then supply information about that reference to this function. Set this parameter to NIL to use the file that is associated with the movie or if the movie does not have a movie file. For example, if you have created the movie using CreateMovieFile or NewMovieFromFile, the Movie Toolbox assumes that the movie's data resides in the file specified at that time. If you have created the movie using the NewMovieFromScrap or NewMovie functions, the movie does not have a movie file.
dataRefType

The type of data reference; see Data References. If the data reference is an alias, you must set this parameter to rAliasType. See Inside Macintosh: Files for more information about aliases and the Alias Manager.
Return Value

A media identifier, referring to the actual data samples used by the track. If the function cannot create a new media, it sets the returned value to NIL.
Discussion

The following code sample creates a new sprite track and media, then calls BeginMediaEdits to prepare to add samples to the media:// NewTrackMedia coding example
// See "Discovering QuickTime," page 349
#define kSpriteMediaTimeScale           600
track =NewMovieTrack(movie, ((long)lTrackWidth << 16),
                            ((long)lTrackHeight << 16), 0);
media =NewTrackMedia(track, SpriteMediaType,
                            kSpriteMediaTimeScale, NIL, 0);
FailOSErr(BeginMediaEdits(media));

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
Media NewTrackMedia (
   Track        theTrack,
   OSType       mediaType,
   TimeScale    timeScale,
   Handle       dataRef,
   OSType       dataRefType ){
//TODO
};


/*MovieAudioExtractionGetProperty

Gets a property of a movie audio extraction session.

OSStatus MovieAudioExtractionGetProperty (
   MovieAudioExtractionRef    session,
   QTPropertyClass            inPropClass,
   QTPropertyID               inPropID,
   ByteCount                  inPropValueSize,
   QTPropertyValuePtr         outPropValueAddress,
   ByteCount                  *outPropValueSizeUsed);
Parameters
session

The session object returned by MovieAudioExtractionBegin.
inPropClass

Pass the following constant to define the property class: Property of an audio presentation; value is 'audi'.
inPropID

Pass one of these constants to define the property ID: kAudioPropertyID_ChannelLayout The summary audio channel layout of a movie, or any other grouping of audio streams. All like-labeled channels are combined, without duplicates. For example, if there is a stereo (L/R) track, 5 single-channel tracks marked Left, Right, Left Surround, Right Surround and Center, and a 4-channel track marked L/R/Ls/Rs, then the summary AudioChannelLayout will be L/R/Ls/Rs/C, not L/R/L/R/Ls/Rs/C/L/R/Ls/Rs. The value of this constant is 'clay'. See these constants: 
inPropValueSize

The size of the buffer allocated to receive the property value.
outPropValueAddress

A pointer to the buffer allocated to receive the property value.
outPropValueSizeUsed

The actual size of the property value.
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus MovieAudioExtractionGetProperty (
   MovieAudioExtractionRef    session,
   QTPropertyClass            inPropClass,
   QTPropertyID               inPropID,
   ByteCount                  inPropValueSize,
   QTPropertyValuePtr         outPropValueAddress,
   ByteCount                  *outPropValueSizeUsed){
//TODO
};


/*MovieAudioExtractionGetPropertyInfo

Gets information about a property of a movie audio extraction session.

OSStatus MovieAudioExtractionGetPropertyInfo (
   MovieAudioExtractionRef    session,
   QTPropertyClass            inPropClass,
   QTPropertyID               inPropID,
   QTPropertyValueType        *outPropType,
   ByteCount                  *outPropValueSize,
   UInt32                     *outPropertyFlags );
Parameters
session

The session object returned by MovieAudioExtractionBegin.
inPropClass

Pass the following constant to define the property class: Property of an audio presentation; value is 'audi'
inPropID

Pass one of these constants to define the property ID: kAudioPropertyID_ChannelLayout The summary audio channel layout of a movie, or any other grouping of audio streams. All like-labeled channels are combined, without duplicates. For example, if there is a stereo (L/R) track, 5 single-channel tracks marked Left, Right, Left Surround, Right Surround and Center, and a 4-channel track marked L/R/Ls/Rs, then the summary AudioChannelLayout will be L/R/Ls/Rs/C, not L/R/L/R/Ls/Rs/C/L/R/Ls/Rs. The value of this constant is 'clay'. See these constants: 
outPropType

A pointer to the type of the returned property's value.
outPropValueSize

A pointer to the size of the returned property's value.
outPropFlags

On return, a pointer to flags representing the requested information about the item's property.
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus MovieAudioExtractionGetPropertyInfo (
   MovieAudioExtractionRef    session,
   QTPropertyClass            inPropClass,
   QTPropertyID               inPropID,
   QTPropertyValueType        *outPropType,
   ByteCount                  *outPropValueSize,
   UInt32                     *outPropertyFlags ){
//TODO
};


/*sertMediaIntoTrack

Inserts a reference to a media segment into a track.

OSErr InsertMediaIntoTrack (
   Track        theTrack,
   TimeValue    trackStart,
   TimeValue    mediaTime,
   TimeValue    mediaDuration,
   Fixed        mediaRate );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack or GetMovieTrack.
trackStart

A time value specifying where the segment is to be inserted. This time value must be expressed in the movie's time scale. If you set this parameter to -1, the media data is added to the end of the track.
mediaTime

A time value specifying the starting point of the segment in the media. This time value must be expressed in the media's time scale.
mediaDuration

A time value specifying the duration of the media's segment. This time value must be expressed in the media's time scale.
mediaRate

The media's rate. A value of 1.0 indicates the media's natural playback rate. This value should be positive and not 0.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You specify the segment in the media by providing a starting time and duration. You specify the point in the destination track by providing a time in the track. InsertMediaIntoTrack then inserts the media segment into the track at the specified location. The Movie Toolbox determines the duration of the segment in the track based on the media rate and duration information you provide.

Use this function after you have added samples to a media. If you play the track before you call this function, the track does not contain the new media data.

Here's an example of using this function to add atom containers to a track://InsertMediaIntoTrack coding example
long descSize;
QTVRSampleDescriptionHandle qtvrSampleDesc;
 
// Create a QTVR sample description handle
descSize =sizeof(QTVRSampleDescription) + GetHandleSize((Handle) vrWorld)
                            - sizeof(UInt32);
qtvrSampleDesc =(QTVRSampleDescriptionHandle) NewHandleClear (descSize);
(*qtvrSampleDesc)->
size =descSize;
(*qtvrSampleDesc)->
type =kQTVRQTVRType;
 
// Copy the VR world atom container data into the QTVR sample description
BlockMove (*((Handle) vrWorld), &((*qtvrSampleDesc)->
data),
                            GetHandleSize((Handle) vrWorld));
// Now add it to the QTVR track's media
err =BeginMediaEdits (qtvrMedia);
err =AddMediaSample (qtvrMedia, (Handle) nodeInfo, 0,
    GetHandleSize((Handle) nodeInfo), duration,
    (SampleDescriptionHandle) qtvrSampleDesc, 1, 0, &sampleTime);
err =EndMediaEdits (qtvrMedia);
InsertMediaIntoTrack (qtvrTrack, trackTime, sampleTime, duration, 1L<<16);

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr InsertMediaIntoTrack (
   Track        theTrack,
   TimeValue    trackStart,
   TimeValue    mediaTime,
   TimeValue    mediaDuration,
   Fixed        mediaRate ){
//TODO
};


/*GetMediaDuration

Returns the duration of a media.

TimeValue GetMediaDuration (
   Media    theMedia );
Parameters
theMedia

The media for this operation. Your application obtains this media identifier from such functions as NewTrackMedia and GetTrackMedia. See Media Identifiers.
Return Value

The media's duration.
Discussion

The following code sample illustrates the use of GetMediaDuration:// GetMediaDuration coding example
// See "Discovering QuickTime," page 89
void CreateMyVideoTrack (Movie movie)
{
    Track   track;
    Media   media;
    Rect    rect ={0, 0, 100, 320};
    track =NewMovieTrack(movie,
                FixRatio(rect.right, 1),
                FixRatio(rect.bottom, 1),
                kNoVolume);
    media =NewTrackMedia(track,
                VideoMediaType,
                600,                            // video time scale
                NIL, NIL);
    BeginMediaEdits(media);
    MyAddVideoSamplesToMedia(media, &rect);     // assemble data
    EndMediaEdits(media);
    InsertMediaIntoTrack(track,
                0,                              // track start time
                0,                              // media start time
                GetMediaDuration(media),
                kFix1);                         // normal speed
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
TimeValue GetMediaDuration (
   Media    theMedia ){
//TODO
};


/*EndMediaEdits

Ends a media-editing session.

OSErr EndMediaEdits (
   Media    theMedia );
Parameters
theMedia

The media for this operation. Your application obtains this media identifier from such functions as NewTrackMedia and GetTrackMedia. See Media Identifiers.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

The following code sample illustrates the use of EndMediaEdits:// EndMediaEdits coding example
// See "Discovering QuickTime," page 89
void CreateMyVideoTrack (Movie movie)
{
    Track   track;
    Media   media;
    Rect    rect ={0, 0, 100, 320};
    track =NewMovieTrack(movie,
                FixRatio(rect.right, 1),
                FixRatio(rect.bottom, 1),
                kNoVolume);
    media =NewTrackMedia(track,
                VideoMediaType,
                600,                            // video time scale
                NIL, NIL);
    BeginMediaEdits(media);
    MyAddVideoSamplesToMedia(media, &rect);     // assemble data
    EndMediaEdits(media);
    InsertMediaIntoTrack(track,
                0,                              // track start time
                0,                              // media start time
                GetMediaDuration(media),
                kFix1);                         // normal speed
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr EndMediaEdits (
   Media    theMedia ){
//TODO
};


/*GetMediaTrack

Determines the track that uses a specified media.

Track GetMediaTrack (
   Media    theMedia );
Parameters
theMedia

The media for this operation. Your application obtains this media identifier from such functions as NewTrackMedia and GetTrackMedia. See Media Identifiers.
Return Value

The track identifier of the track that uses the specified media.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

Track GetMediaTrack (
   Media    theMedia ){
//TODO
};


/*CloseMovieStorage

Closes an open movie storage container.

OSErr CloseMovieStorage (
   DataHandler    dh );
Parameters
dh

The data handler component that was returned by a previous call to CreateMovieStorage.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 6. Supersedes CloseMovieFile.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Movies.h*/
OSErr CloseMovieStorage (
   DataHandler    dh ){
//TODO
};


/*AddMovieToStorage

Adds a movie to a storage container that was created by CreateMovieStorage.

OSErr AddMovieToStorage (
   Movie          theMovie,
   DataHandler    dh );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
dh

The data handler component that was returned by CreateMovieStorage.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

This function calls PutMovieIntoStorage internally. If you are writing a custom data handler, make sure it implements DataHGetDataRef. Also implement DataHScheduleData64 and DataHGetFileSize64, or DataHScheduleData and DataHGetFileSize if the data handler does not support 64-bit file offsets, plus DataHWrite64, or DataHWrite if it does not support 64-bit offsets.
Version Notes

Introduced in QuickTime 6. Supersedes AddMovieResource.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Movies.h*/
OSErr AddMovieToStorage (
   Movie          theMovie,
   DataHandler    dh ){
//TODO
};

/*MovieAudioExtractionEnd

Ends a movie audio extraction session.

OSStatus MovieAudioExtractionEnd (
   MovieAudioExtractionRef    session );
Parameters
session

The session object returned by MovieAudioExtractionBegin.
Return Value

An error code. Returns noErr if there is no error.
Discussion

You must call this function when movie audio extraction is complete.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus MovieAudioExtractionEnd (
   MovieAudioExtractionRef    session ){
//TODO
};

/*NewMovieFromDataRef

Creates a movie from any device with a corresponding data handler.

OSErr NewMovieFromDataRef (
   Movie     *m,
   short     flags,
   short     *id,
   Handle    dataRef,
   OSType    dataRefType );
Parameters
m

A pointer to a field that is to receive the new movie's identifier. If the function cannot load the movie, the returned identifier is set to NIL.
flags

Flags (see below) that control the operation of this function. Be sure to set unused flags to 0. See these constants: 
newMovieActive
newMovieDontResolveDataRefs
newMovieDontAskUnresolvedDataRefs
id

A pointer to the field that specifies the resource containing the movie data that is to be loaded. If the field referred to by the id parameter is set to 0, the Movie Toolbox loads the first movie resource it finds in the specified file. The toolbox then returns the movie's resource ID number in the field referred to by the id parameter. An enumerated constant (see below) is available. See these constants: 
movieInDataForkResID
dataRef

The default data reference. This parameter contains a handle to the information that identifies the file to be used to resolve any data references and as a starting point for any Alias Manager searches. The type of information stored in the handle depends upon the value of the dataRefType parameter. For example, if your application is loading the movie from a file, you would refer to the file's alias in this parameter and set the dataRefType parameter to rAliasType. If you do not want to identify a default data reference, set the parameter to NIL.
dataRefType

The type of data reference. If the data reference is an alias, you must set the parameter to rAliasType, indicating that the reference is an alias.
Return Value

If the Movie Toolbox cannot completely resolve all data references, it sets the current error value to couldNotResolveDataRef. You can access error returns such as this through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

This function is intended for use by specialized applications that need to instantiate movies from devices not visible to the file system. Most applications should continue to use NewMovieFromFile. You are not restricted to instantiating a movie from a file stored on a Macintosh HFS volume. With this function, you can instantiate a movie from any device.
Special Considerations

The Movie Toolbox automatically sets the movie's graphics world based on the current graphics port. Be sure that your application's graphics port is valid before you call this function, even if the movie is sound-only; you can use GetGWorld to check for a valid port, or you can use NewGWorld to create a port. The graphics port must remain valid for the life of the movie or until you set another valid graphics port for the movie using SetMovieGWorld.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr NewMovieFromDataRef (
   Movie     *m,
   short     flags,
   short     *id,
   Handle    dataRef,
   OSType    dataRefType ){
//TODO
};


/*CreateMovieStorage

Creates an empty storage location to hold a movie and opens a data handler to the stored movie with write permission.

OSErr CreateMovieStorage (
   Handle         dataRef,
   OSType         dataRefType,
   OSType         creator,
   ScriptCode     scriptTag,
   long           createMovieFileFlags,
   DataHandler    *outDataHandler,
   Movie          *newmovie );
Parameters
dataRef

A handle to a QuickTime data reference.
dataRefType

The data reference type. See Data References.
creator

The creator type of the new container (for example, 'TV0D', the creator type for Apple's movie player).
scriptTag

Constants (see below) that specify the script for the new container. See these constants: 
createMovieFileFlags

Constants (see below) that control file creation options. See these constants: 
createMovieFileDeleteCurFile
createMovieFileDontCreateMovie
createMovieFileDontOpenFile
newMovieActive
outDataHandler

A pointer to a field that is to receive the data handler for the opened movie container. Your application must use this value when calling other Movie Toolbox functions. If you pass NIL, the Movie Toolbox creates the movie container but does not open it.
newmovie

A pointer to a field that is to receive the returned identifier of the new movie. If the function could not create a new movie, it sets this returned value to NIL. If you pass NIL, the Movie Toolbox does not create a movie.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

If you are writing a custom data handler, make sure it supports DataHGetDataRef. It must also support DataHWrite64, or DataHWrite if 64-bit offsets are not supported.
Version Notes

Introduced in QuickTime 6. Supersedes CreateMovieFile.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Movies.h*/
OSErr CreateMovieStorage (
   Handle         dataRef,
   OSType         dataRefType,
   OSType         creator,
   ScriptCode     scriptTag,
   long           createMovieFileFlags,
   DataHandler    *outDataHandler,
   Movie          *newmovie ){
//TODO
};


/*AddMediaSample2

Adds sample data and a description to a media.

OSErr AddMediaSample2 (
   Media                      theMedia,
   const UInt8                *dataIn,
   ByteCount                  size,
   TimeValue64                decodeDurationPerSample,
   TimeValue64                displayOffset,
   SampleDescriptionHandle    sampleDescriptionH,
   ItemCount                  numberOfSamples,
   MediaSampleFlags           sampleFlags,
   TimeValue64                *sampleDecodeTimeOut );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
dataIn

A handle to the sample data. The function adds this data to the media specified by theMedia. You specify the number of bytes of sample data with the size parameter.
size

The number of bytes of sample data to be added to the media. This parameter indicates the total number of bytes in the sample data to be added to the media, not the number of bytes per sample. Use the numberOfSamples parameter to indicate the number of samples that are contained in the sample data.
decodeDurationPerSample

The duration of each sample to be added, representing the amount of time that passes while the sample data is being displayed. You must specify this parameter in the media's time scale. For example, if you are adding sound that was sampled at 22 kHz to a media that contains a sound track with the same time scale, you would set durationPerSample to 1. Similarly, if you are adding video that was recorded at 10 frames per second to a video media that has a time scale of 600, you would set this parameter to 60. Note that this is the duration per sample, regardless of the number of samples being added.
displayOffset

A 64-bit time value that specifies the offset between the decode time (the start time of the track plus the duration of all previous samples) and the display time. This value is normally zero unless the sample is frame reordering compressed video.
sampleDescriptionH

A handle to a SampleDescription structure. Some media structures may require sample descriptions. There are different descriptions for different types of samples. For example, a media that contains compressed video requires that you supply an ImageDescription structure. A media that contains sound requires that you supply a SoundDescription structure. If the media does not require a SampleDescription structure, set this parameter to NIL.
numberOfSamples

The number of samples contained in the sample data to be added to the media. The Movie Toolbox considers the value of this parameter as well as the value of the size parameter when it determines the size of each sample that it adds to the media. You should set the value of this parameter so that the resulting sample size represents a reasonable compromise between total data retrieval time and the overhead associated with input and output. You should also consider the speed of the data storage device; CD-ROM devices are much slower than hard disks, for example, and should therefore have a smaller sample size. For a video media, set a sample size that corresponds to the size of a frame. For a sound media, choose a number of samples that corresponds to between 0.5 and 1.0 seconds of sound. In general, you should not create groups of sound samples that are less than 2 KB in size or greater than 15 KB. Typically, a sample size of about 8 KB is reasonable for most storage devices.
sampleFlags

Flags that control the add operation; set unused flags to 0: mediaSampleNotSync Indicates that the sample to be added is not a sync sample. Set this flag to 1 if the sample is not a sync sample; set it to 0 if the sample is a sync sample. See these constants: 
mediaSampleNotSync
sampleDecodeTimeOut

A pointer to a time value that represents the sample decode time. After adding the sample data to the media, the function returns in this parameter the time where the sample was inserted. If you don't want to receive this information, set this parameter to NIL.
Return Value

An error code. Returns noErr if there is no error. You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result.
Discussion

Your application specifies the sample and the media for the operation. This function updates the media so that it contains the sample data. One call to this function can add several samples to a media. This function replaces AddMediaSample; it adds 64-bit support and support for frame reordering video compression (display offset).
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSErr AddMediaSample2 (
   Media                      theMedia,
   const UInt8                *dataIn,
   ByteCount                  size,
   TimeValue64                decodeDurationPerSample,
   TimeValue64                displayOffset,
   SampleDescriptionHandle    sampleDescriptionH,
   ItemCount                  numberOfSamples,
   MediaSampleFlags           sampleFlags,
   TimeValue64                *sampleDecodeTimeOut ){
//TODO
};


/*QTNewDataReferenceFromFullPathCFString

Creates an alias data reference from a CFString that represents the full pathname of a file.

OSErr QTNewDataReferenceFromFullPathCFString (
   CFStringRef    filePath,
   QTPathStyle    pathStyle,
   UInt32         flags,
   Handle         *outDataRef,
   OSType         *outDataRefType );
Parameters
filePath

A CFString that represents the full pathname of a file.
pathStyle

A constant (see below) that identifies the syntax of the pathname. See these constants: 
kQTNativeDefaultPathStyle
kQTPOSIXPathStyle
kQTHFSPathStyle
kQTWindowsPathStyle
flags

Currently not used; pass 0.
outDataRef

A pointer to a handle in which the newly created alias data reference is returned.
outDataRefType

A pointer to memory in which the OSType of the newly created data reference is returned.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error. Returns paramErr if either of the output parameters is NIL
Discussion

You need to specify the syntax of the pathname as one of the QTPathStyle constants. The new alias data reference created can be passed to other Movie Toolbox calls that take a data reference.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSErr QTNewDataReferenceFromFullPathCFString (
   CFStringRef    filePath,
   QTPathStyle    pathStyle,
   UInt32         flags,
   Handle         *outDataRef,
   OSType         *outDataRefType ){
//TODO
};

/*QTSoundDescriptionCreate

Creates a sound description structure of the requested kind from an AudioStreamBasicDescription, optional audio channel layout, and optional magic cookie.

OSStatus QTSoundDescriptionCreate (
AudioStreamBasicDescription    *inASBD,
AudioChannelLayout             *inLayout,
ByteCount                      inLayoutSize,
void                           *inMagicCookie
ByteCount                      inMagicCookieSize
QTSoundDescriptionKind         inRequestedKind
SoundDescriptionHandle         *outSoundDesc );
Parameters
inASBD

A description of the format.
inLayout

The audio channel layout (can be NULL if there isn't one).
inLayoutSize

The size of the audio channel layout (should be 0 if inLayout is NULL).
inMagicCookie

The magic cookie for the decompressor (can be NULL if the decompressor doesn't require one).
inMagicCookieSize

The size of the magic cookie (should be 0 if the inMagicCookie parameter is NULL).
inRequestedKind

The kind of sound description to create. 
outSoundDesc

The resulting sound description. The caller must dispose of it with DisposeHandle.
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus QTSoundDescriptionCreate (
AudioStreamBasicDescription    *inASBD,
AudioChannelLayout             *inLayout,
ByteCount                      inLayoutSize,
void                           *inMagicCookie,
ByteCount                      inMagicCookieSize,
QTSoundDescriptionKind         inRequestedKind,
SoundDescriptionHandle         *outSoundDesc ){
//TODO
};


/*DisposeMovie

Frees any memory being used by a movie, including the memory used by the movie's tracks and media structures.

void DisposeMovie (
   Movie    theMovie );
Parameters
theMovie

Identifies the movie to be freed. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, or NewMovieFromHandle.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Discussion

Your application should call this function when it is done working with a movie, as shown in the following example:// DisposeMovie coding example
// See "Discovering QuickTime," page 85
void CreateMyCoolMovie (void)
{
    StandardFileReply   sfr;
    Movie               movie =NIL;
    FSSpec              fss;
    short               nFileRefNum =0;
    short               nResID =movieInDataForkResID;
    StandardPutFile("\pEnter movie file name:", "\puntitled.mov", &sfr);
    if (!sfr.sfGood)
        return;
    CreateMovieFile(&sfr.sfFile,
                    FOUR_CHAR_CODE('TVOD'),
                    smCurrentScript,
                    createMovieFileDeleteCurFile | createMovieFileDontCreateResFile,
                    &nFileRefNum,
                    &movie);
    CreateMyVideoTrack(movie);      // See "Creating a Track," below
    AddMovieResource(movie, nFileRefNum, &nResID, NIL);
    if (nFileRefNum !=0)
        CloseMovieFile(nFileRefNum);
    DisposeMovie(movie);
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

void DisposeMovie (
   Movie    theMovie ){
//TODO
};


/*QTSetComponentProperty

Sets the value of a specific component property.

ComponentResult QTSetComponentProperty (
   ComponentInstance         inComponent,
   ComponentPropertyClass    inPropClass,
   ComponentPropertyID       inPropID,
   ByteCount                 inPropValueSize,
   ConstComponentValuePtr    inPropValueAddress );
Parameters
inComponent

A component instance, which you can get by calling OpenComponent or OpenDefaultComponent.
inPropClass

A value of type OSType that specifies a property class: kComponentPropertyClassPropertyInfo ('pnfo') A QTComponentPropertyInfo structure that defines a property information class. kComponentPropertyInfoList ('list') An array of QTComponentPropertyInfo structures, one for each property. kComponentPropertyCacheSeed ('seed') A component property cache seed value. kComponentPropertyExtendedInfo ('meta') A CFDictionary with extended property information. kComponentPropertyCacheFlags ('flgs') One of the following two flags: kComponentPropertyCacheFlagNotPersistent Property metadata should not be saved in persistent cache. kComponentPropertyCacheFlagIsDynamic Property metadata should not be cached at all. See these constants: 
kComponentPropertyClassPropertyInfo
kComponentPropertyInfoList
kComponentPropertyCacheSeed
kComponentPropertyExtendedInfo
kComponentPropertyCacheFlags
kComponentPropertyCacheFlagNotPersistent
kComponentPropertyCacheFlagIsDynamic
inPropID

A value of type OSType that specifies a property ID.
inPropValueSize

The size of the buffer allocated to hold the property value.
outPropValueAddress

A pointer to the buffer allocated to hold the property value.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
ComponentResult QTSetComponentProperty (
   ComponentInstance         inComponent,
   ComponentPropertyClass    inPropClass,
   ComponentPropertyID       inPropID,
   ByteCount                 inPropValueSize,
   ConstComponentValuePtr    inPropValueAddress ){
//TODO
};


/*SCRequestImageSettings

Displays the standard image dialog box to the user and shows default settings you have established.

ComponentResult SCRequestImageSettings (
   ComponentInstance    ci );
Parameters
ci

Identifies your application's connection to a standard image-compression dialog component. You obtain this identifier from OpenDefaultComponent.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Use this function to retrieve the user's preferences for compressing a single image; use SCRequestSequenceSettings when you are working with an image sequence. Both functions manipulate the compression settings that the component stores for you.

The component derives the current settings when you may supply an image to the component from which it can derive default settings. If you have not set any defaults, but you do supply a test image for the dialog, the component examines the test image and derives appropriate default values based upon its characteristics. If you have not set any defaults and do not supply a test image, the component uses its own default values.
Special Considerations

You may modify the settings by using SCSetInfo. You may customize the dialog boxes by specifying a modal-dialog hook function or a custom button. You may use the custom button to invoke an ancillary dialog box that is specific to your application.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SCRequestImageSettings (
   ComponentInstance    ci ){
//TODO
};


/*NewMovieTrack

Creates a new movie track, without a media.

Track NewMovieTrack (
   Movie    theMovie,
   Fixed    width,
   Fixed    height,
   short    trackVolume );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
width

A fixed number denoting the display width of the track, in pixels.
height

A fixed number denoting the display height of the track, in pixels. Together, the height and width parameters define the track's display rectangle. The upper-left corner of this rectangle lies at (0,0) in the movie's rectangle. The height and width parameters therefore establish the lower-right corner of the track's display rectangle. If you are creating a track that is not displayed, such as a sound track, set the height and width parameters to 0.
trackVolume

The volume setting of the track as a 16-bit, fixed-point number. The high-order 8 bits specify the integer portion; the low-order 8 bits specify the fractional part. Volume values range from -1.0 to 1.0. Negative values play no sound but preserve the absolute value of the volume setting. Set this parameter to kFullVolume to play the track at its full, natural volume. Set this parameter to kNoVolume to set the volume to 0. See these constants: 
Return Value

The identifier of the new track.
Discussion

Immediately after creating a new track, you should call NewTrackMedia to create a media for the track; a track without a media is of no use. The following code sample creates a new sprite track and media, then calls BeginMediaEdits to prepare to add samples to the media:// NewMovieTrack coding example
// See "Discovering QuickTime," page 349
#define kSpriteMediaTimeScale           600
track =NewMovieTrack(movie, ((long)lTrackWidth << 16),
                            ((long)lTrackHeight << 16), 0);
media =NewTrackMedia(track, SpriteMediaType,
                            kSpriteMediaTimeScale, NIL, 0);
FailOSErr(BeginMediaEdits(media));

Special Considerations

When you add a track to a movie, the Movie Toolbox automatically adjusts the display Rect structure of the movie. You may want to detect these changes by calling GetMovieBox so that you can adjust the size of the movie's display window.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

Track NewMovieTrack (
   Movie    theMovie,
   Fixed    width,
   Fixed    height,
   short    trackVolume ){
//TODO
};


/*GetMoviesError

Returns the contents of the current error value and resets the current error value to 0.

OSErr GetMoviesError ( void );
Return Value

See Error Codes. Returns noErr if there is no error in the current error value.
Discussion

The Movie Toolbox provides two error values to your application: the current error and the sticky error. The current error is the result code from the last Movie Toolbox function; it is updated each time your application calls a Movie Toolbox function. The following code sample shows a typical use:// GetMoviesError coding example
// See "Discovering QuickTime," page 256
OSErr QTUtils_SaveMovie (Movie theMovie)
{
    StandardFileReply   mySFReply;
    StringPtr   myPrompt =QTUtils_ConvertCToPascalString(kSavePrompt);
    StringPtr   myFileName =
                    QTUtils_ConvertCToPascalString(kSaveMovieFileName);
    OSErr       myErr =noErr;
    if (theMovie ==NIL)
        return(invalidMovie);
    StandardPutFile(myPrompt, myFileName, &mySFReply);
    if (mySFReply.sfGood) {
        FlattenMovieData(   theMovie,
                            flattenAddMovieToDataFork,
                            &mySFReply.sfFile,
                            FOUR_CHAR_CODE('TVOD'),
                            smSystemScript,
                            createMovieFileDeleteCurFile);
        myErr =GetMoviesError();
    }
    free(myPrompt);
    free(myFileName);
    return(myErr);
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr GetMoviesError ( void ){
//TODO
};


/*QTSoundDescriptionSetProperty

Sets a particular property of a sound description.

OSStatus QTSoundDescriptionSetProperty (
SoundDescriptionHandle     inDesc,
QTPropertyClass            inPropClass,
QTPropertyID               inPropID,
ByteCount                  inPropValueSize,
ConstQTPropertyValuePtr   inPropValueAddress );
Parameters
inDesc

The sound description being modified.
inPropClass

The class of the property being set. 
inPropID

The ID of the property being set.
inPropValueSize

The size of the property value buffer.
inPropValueAddress

A pointer to the property value buffer. 
Return Value

An error code. Returns noErr if there is no error.
Discussion

The following constants identify sound description properties.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus QTSoundDescriptionSetProperty (
SoundDescriptionHandle     inDesc,
QTPropertyClass            inPropClass,
QTPropertyID               inPropID,
ByteCount                  inPropValueSize,
ConstQTPropertyValuePtr   inPropValueAddress ){
//TODO
};


/*SCAudioFillBuffer

Used is used to pull compressed frames from the StdAudio component in kQTSCAudioPropertyID_BasicDescription format.

ComponentResult SCAudioFillBuffer (
   ComponentInstance ci,
   SCAudioInputDataProc inInputDataProc,
   void *inInputDataProcRefCon,
   UInt32 *ioOutputDataPacketSize,
   AudioBufferList *outOutputData,
   AudioStreamPacketDescription *outPacketDescription
);
Parameters
ci

The clients connection to a StdAudio Compression component.
inInputDataProc

The proc address of the function that will be called to supply data in the kQTSCAudioPropertyID_InputBasicDescription format to SCAudio.
inInputDataProcRefCon

The client refcon that will be passed to the user-provided SCAudioInputDataProc function.
ioOutputDataPacketSize

On input, the number of desired packets. On output, the actual number of packets delivered (can be fewer than the input desired packets).
outOutputData

An AudioBufferList providing sufficiently large buffers to hold the requested number of packets.
outPacketDescription

An array of AudioStreamPacketDescriptions. If the requested output format requires external framing information??that is, a VBR format such as AAC?? allocate and pass an array of packet descriptions as large as the number of packets you are requesting.
Discussion

SCAudioFillBuffer preserves the same style API as the Core Audio AudioConverterFillComplexBuffer API, which is part of the AudioToolbox framework and resides in AudioConverter.h. 

This function has the same parameters as AudioConverterFillComplexBuffer, but internally it has an audio converter, a matrix mixer, and another audio converter. It is based on a pull model: You pull on the audio converter for some output, and specify the buffer in which you want to put it. You have already configured the format that it is going to return to you. You also provide it with an input proc and it will call back that input proc and specify however many samples of audio you have. For example, if you want five packets of AAC audio coming out the back end, and at the front end you happen to have PCM de-interleaved, the routine will ask you for the samples. The difference is you can now have different numbers of channels going in or out. For example, at the same time you are doing the compression from PCM to AAC, you can also go from 5.1 to stereo.

SCAudioFillBuffer is used to pull compressed frames from the StdAudio component in kQTSCAudioPropertyID_BasicDescription format. The StdAudio component can perform any combination of decompression/mixing/compression, combining the facilities of Core Audio AudioConverters and Matrix Mixer AudioUnits. The behavior of the SCAudioFillBuffer call (signalling end of data, and so on) is identical to the AudioConverter's AudioConverterFillComplexBuffer API.

One important difference between the AudioConverter and SCAudio component is that the SCAudio compression APIs can do mixing as well as n -> n channels conversion. If you want to compress, decompress, or transcode audio using the SCAudioFillBuffer interface, you configure the StandardCompressionSubTypeAudio component with the desired input and output formats (or use the SCRequestImageSettings API to present a dialog and let a user select an output format), then you call SCAudioFillBuffer, providing an SCAudioInputDataProc callback, which is called for audio in the specified source format.
Version Notes

Introduced in QuickTime 7.1 for Windows and QuickTime 7 for Mac OS X. 
Availability
Carbon status: Supported C interface file: QuickTimeComponents.h
Declared In
QuickTimeComponents.h*/
ComponentResult SCAudioFillBuffer (
   ComponentInstance ci,
   SCAudioInputDataProc inInputDataProc,
   void *inInputDataProcRefCon,
   UInt32 *ioOutputDataPacketSize,
   AudioBufferList *outOutputData,
   AudioStreamPacketDescription *outPacketDescription){
//TODO
};


/*SetMovieGWorld

Establishes a movie's display coordinate system by setting the graphics world for displaying the movie.

void SetMovieGWorld (
   Movie       theMovie,
   CGrafPtr    port,
   GDHandle    gdh );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
port

Points to the movie's CGrafPort structure or graphics world. Set this parameter to NIL to use the current graphics port.
gdh

A handle to the movie's GDevice structure. Set this parameter to NIL to use the current device. If the port parameter specifies a graphics world, set this parameter to NIL to use that graphics world's graphics device.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Special Considerations

When you use this function, the Movie Toolbox remembers the current background color and background pattern. These are used for erasing in the default movie uncover function; see SetMovieCoverProcs.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void SetMovieGWorld (
   Movie       theMovie,
   CGrafPtr    port,
   GDHandle    gdh ){
//TODO
};


/*SetMovieVisualContext

Targets a movie to render into a visual context.

OSStatus SetMovieVisualContext (
   Movie      movie,
   QTVisualContextRef    visualContext;
Parameters
movie

The movie.
visualContext

The visual context that the movie will render into. May be NULL..
Return Value

An error code. Returns noErr if there is no error. Returns memFullErr if memory cannot be allocated. Returns kQTVisualContextNotAllowed if the movie is not able to render using a visual context. Returns paramErr if the movie is NULL.
Discussion

When SetMovieVisualContext succeeds, it will retain the QTVisualContext object for its own use. If visualContext is NULL, the movie will not render any visual media. SetMovieVisualContext will fail if a different movie is already using the visual context, so you should first disassociate the other movie by calling SetMovieVisualContext with a NULL visualContext. 
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus SetMovieVisualContext (
   Movie      movie,
   QTVisualContextRef    visualContext){
//TODO
};


/*PrerollMovie

Prepares a portion of a movie for playback.

OSErr PrerollMovie (
   Movie        theMovie,
   TimeValue    time,
   Fixed        Rate );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
time

The starting time of the movie segment to play.
Rate

The rate at which you anticipate playing the movie. You specify the movie rate as a 32-bit, fixed-point number. Positive integers indicate forward rates and negative integers indicate reverse rates.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

When your application calls PrerollMovie, the Movie Toolbox tells the appropriate media handlers to prepare to play the movie. The media handlers may then load the movie data and perform any other necessary preparations to play the movie, such as allocating sound channels and starting up image-decompression sequences. In this manner, you can eliminate playback stutter when the movie starts playing.

If your application uses QuickTime's Movie Toolbox to play back movies, there are two choices for how to preroll the movie. Like the movie controller, the Movie Toolbox provides a single function call, StartMovie, which will both preroll the movie and start it playing. Unlike the movie controller, the Movie Toolbox function doesn't allow you to specific the rate to play the movie at, but instead assumes the movie's preferred rate.

Calling StartMovie, just like the movie controller's preroll and play action, first prerolls the movie and then sets it playing. If your application requires more control, the Movie Toolbox provides lower level functions that give you more control:// PrerollMovie coding example
StartMovie(theMovie);
TimeValue timeNow;
Fixed playRate;
timeNow =GetMovieTime(theMovie, NIL);
playRate =GetMoviePreferredRate(theMovie);
PrePrerollMovie(theMovie, timeNow, playRate, NIL, NIL);
PrerollMovie(theMovie, timeNow, playRate);
SetMovieRate(theMovie, playRate);

Special Considerations

You should always call PrePrerollMovie before calling this function.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr PrerollMovie (
   Movie        theMovie,
   TimeValue    time,
   Fixed        Rate ){
//TODO
};


/*GetMovieTime

Returns a movie's current time both as a time value and in a time structure.

TimeValue GetMovieTime (
   Movie         theMovie,
   TimeRecord    *currentTime );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
currentTime

A pointer to a TimeRecord structure. The function updates this time structure to contain the movie's current time. If you don't want this information, set this parameter to NIL.
Return Value

The time value of the current time.
Discussion

This function returns the movie's current time value in two formats: as a time value and in a time structure.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

TimeValue GetMovieTime (
   Movie         theMovie,
   TimeRecord    *currentTime ){
//TODO
};


/*MoviesTask

Services active movies.

void MoviesTask (
   Movie    theMovie,
   long     maxMilliSecToUse );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle. If you set this parameter to NIL, the Movie Toolbox services all of your active movies.
maxMilliSecToUse

Determines the maximum number of milliseconds that MoviesTask can work before returning. If this parameter is 0, MoviesTask services every active movie exactly once and then returns. If the parameter is nonzero, MoviesTask services as many movies as it can in the allotted time before returning. Once the MoviesTask function starts servicing a movie, it cannot stop until it has completely met the requirements of the movie. Consequently, the MoviesTask function may execute for a longer time than that specified in maxMilliSecToUse. However, the function does not start servicing a new movie if the time specified by maxMilliSecToUse has elapsed. The preferred way to use MoviesTask is to set the maxMilliSecToUse parameter to 0; however, if you just want to play one movie, you can call MoviesTask on that one. If your rate is 0, MoviesTask draws that frame and no other.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

You should call MoviesTask as often as possible from your application's main event loop. Note that you should call this function after you have performed your own event processing. MoviesTask services only active movies, and only enabled tracks within those active movies.
Special Considerations

Note that the MoviesTask function services only your movies. Your application must give other applications the opportunity to call MoviesTask for their movies.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void MoviesTask (
   Movie    theMovie,
   long     maxMilliSecToUse ){
//TODO
};


/*UpdateMovie

Ensures that the Movie Toolbox properly displays your movie after it has been uncovered.

OSErr UpdateMovie (
   Movie    theMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

Your application should call this function during window updating. Don't call MoviesTask at this time; you will observe better display behavior if you call it at the end of your update processing.

This function does not actually update the movie's graphics world. Rather, it invalidates the movie's display state so that the Movie Toolbox redraws the movie the next time you call MoviesTask. If you need to force a movie to be redrawn outside of a window update sequence, your application can call this function and then call MoviesTask to service the movie. The Movie Toolbox determines the portion of the screen to update by examining the graphics port's visible region.

The following code snippet uses this function in a Macintosh Window Manager update sequence:// UpdateMovie coding example
#include <Events.h>
#include <ToolUtils.h>
#include "Movies.h"
void DoUpdate (WindowRef theWindow, Movie theMovie)
{
    BeginUpdate (theWindow);
    UpdateMovie (theMovie);
    EndUpdate (theWindow);
} // DoUpdate

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/


OSErr UpdateMovie (
   Movie    theMovie ){
//TODO
};


/*QTOpenGLTextureContextCreate
OSStatus QTOpenGLTextureContextCreate (
   CFAllocatorRef               allocator,
   CGLContextObj                cglContext,
   CGLPixelFormatObj            cglPixelFormat,
   CFDictionaryRef              attributes,
   QTOpenGLTextureContextRef    *newTextureContext );
Creates a new OpenGL texture context for a specified OpenGL context and pixel format.

OSStatus QTOpenGLTextureContextCreate (
   CFAllocatorRef               allocator,
   CGLContextObj                cglContext,
   CGLPixelFormatObj            cglPixelFormat,
   CFDictionaryRef              attributes,
   QTOpenGLTextureContextRef    *newTextureContext );
Parameters
allocator

The allocator used to create the texture context.
cglContext

A pointer to an opaque CGLPContextObj structure representing the OpenGL context used to create textures. You can create this structure using CGLCreateContext.
cglPixelFormat

The pixel format object that specifies buffer types and other attributes of the new context.
attributes

A dictionary of attributes.
newTextureContext

A pointer to a variable to receive the new OpenGL texture context.
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
OSStatus QTOpenGLTextureContextCreate (
   CFAllocatorRef               allocator,
   CGLContextObj                cglContext,
   CGLPixelFormatObj            cglPixelFormat,
   CFDictionaryRef              attributes,
   QTOpenGLTextureContextRef    *newTextureContext ){
//TODO
};

/*QTVisualContextSetAttribute

Sets a visual context attribute.

OSStatus QTVisualContextSetAttribute (
   QTVisualContextRef visualContext,
   CFStringRef attributeKey,
   CFTypeRef attributeValue );
Parameters
visualContext

The visual context.
attributeKey

Identifier of attribute to set
attributeValue

The value of the attribute to set, or NULL to remove a value. 
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
OSStatus QTVisualContextSetAttribute (
   QTVisualContextRef visualContext,
   CFStringRef attributeKey,
   CFTypeRef attributeValue ){
//TODO
};


/*QTVisualContextRelease

Releases a visual context object.

void QTVisualContextRelease (
   QTVisualContextRef visualContext
);
Parameters
visualContext

A reference to a visual context object. If you pass NULL, nothing happens.
Discussion

When the retain count decreases to zero, the visual context is disposed.
Version Notes

Introduced in QuickTime 7 for Mac OS X and in QuickTime 7.1 for Windows.
Availability
Carbon status: Supported C interface file: ImageCompression.h
Declared In
ImageCompression.h*/
void QTVisualContextRelease (
   QTVisualContextRef visualContext){
//TODO
};


/*QTVisualContextCopyImageForTime

Retrieves an image buffer from the visual context, indexed by the provided time.

OSStatus QTVisualContextCopyImageForTime (
   QTVisualContextRef visualContext,
   CFAllocatorRef allocator,
   const CVTimeStamp *timeStamp,
   CVImageBufferRef *newImage
);
Parameters
visualContext

The visual context.
allocator

Allocator used to create new CVImageBufferRef.
timeStamp

Time in question. Pass NULL to request the image at the current time.
newImage

Points to variable to receive the new image.
Return Value

An error code. Returns noErr if there is no error.
Discussion

You should not request image buffers further ahead of the current time than the read-ahead time specified with the kQTVisualContextExpectedReadAheadKey attribute. You may skip images by passing later times, but you may not pass an earlier time than passed to a previous call to this function.
Version Notes

Introduced in QuickTime 7 for Mac OS X and in QuickTime 7.1 for Windows.
Availability
Carbon status: Supported C interface file: ImageCompression.h
Declared In
ImageCompression.h*/
OSStatus QTVisualContextCopyImageForTime (
   QTVisualContextRef visualContext,
   CFAllocatorRef allocator,
   const CVTimeStamp *timeStamp,
   CVImageBufferRef *newImage){
//TODO
};


/*QTVisualContextTask

Enables the visual context to release internally held resources for later use.

void QTVisualContextTask (
   QTVisualContextRef visualContext
);
Parameters
visualContext

The visual context.
Discussion

For optimal resource management, this function should be called in every rendering pass. It should be called after old images have been released, new images have been used and all rendering has been flushed to the screen. The call is not mandatory.
Version Notes

Introduced in QuickTime 7
Availability
Carbon status: Supported C interface file: ImageCompression.h
Declared In
ImageCompression.h*/

void QTVisualContextTask (
   QTVisualContextRef visualContext){
//TODO
};


/*QTVisualContextIsNewImageAvailable

Queries whether a new image is available for a given time.

Boolean QTVisualContextIsNewImageAvailable (
   QTVisualContextRef visualContext,
   const CVTimeStamp *timeStamp
);
Parameters
visualContext

The visual context.
timeStamp

Time in question.
Return Value

A Boolean.
Discussion

This function returns TRUE if there is a image available for the specified time that is different from the last image retrieved from QTVisualContextCopyImageForTime.
Version Notes

Introduced in QuickTime 7 for Mac OS X and in QuickTime 7.1 for Windows.
Availability
Carbon status: Supported C interface file: ImageCompression.h
Declared In
ImageCompression.h*/

Boolean QTVisualContextIsNewImageAvailable (
   QTVisualContextRef visualContext,
   const CVTimeStamp *timeStamp){
//TODO
};

/*SGNewChannel

Creates a sequence grabber channel and assigns a channel component to the channel.

ComponentResult SGNewChannel (
   SeqGrabComponent    s,
   OSType              channelType,
   SGChannel           *ref );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
channelType

The type of channel to open (see below). This value corresponds to the component subtype value of the channel component. See these constants: 
VideoMediaType
SoundMediaType
ref

A pointer to the frameChannel field in the SeqGrabFrameInfo structure that is to receive a reference to the channel that is added to the sequence grabber component. If the sequence grabber component successfully locates and connects to an appropriate channel component, the sequence grabber component returns a reference to the channel component into this field.
Return Value

See Error Codes. If the sequence grabber component cannot open a connection, it sets the result code to a nonzero value. It returns noErr if there is no error.
Discussion

The channel component is responsible for providing digitized data to the sequence grabber component. You specify the type of channel component to be added to the sequence grabber component, as shown in the following sample code:// SGNewChannel coding example
// See "Discovering QuickTime," page 263
void MakeMyGrabChannels (SeqGrabComponent    seqGrab,
                            SGChannel        *sgchanVideo,
                            SGChannel        *sgchanSound,
                            const Rect       *rect,
                            Boolean          bWillRecord)
{
    OSErr           nErr;
    long            lUsage;
    // figure out the usage
    lUsage =seqGrabPreview;                // always previewing
    if (bWillRecord)
        lUsage |=seqGrabRecord;            // sometimes recording
    // create a video channel
    nErr =SGNewChannel(seqGrab, VideoMediaType, sgchanVideo);
    if (nErr ==noErr) {
        // set boundaries for new video channel
        nErr =SGSetChannelBounds(*sgchanVideo, rect);
        // set usage for new video channel
        if (nErr ==noErr)
            nErr =SGSetChannelUsage(*sgchanVideo, lUsage |
                                        seqGrabPlayDuringRecord);
        if (nErr !=noErr) {
            // clean up on failure
            SGDisposeChannel(seqGrab, *sgchanVideo);
            *sgchanVideo =NIL;
        }
    }
    // create a sound channel
    nErr =SGNewChannel(seqGrab, SoundMediaType, sgchanSound);
    if (nErr ==noErr) {
        // set usage of new sound channel
        nErr =SGSetChannelUsage(*sgchanSound, lUsage);
        if (nErr !=noErr) {
            // clean up on failure
            SGDisposeChannel(seqGrab, *sgchanSound);
            *sgchanSound =NIL;
        }
    }
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGNewChannel (
   SeqGrabComponent    s,
   OSType              channelType,
   SGChannel           *ref ){
//TODO
};


/*SGGetChannelRefCon

Returns a reference constant that was previously set by SGSetChannelRefCon.

ComponentResult SGGetChannelRefCon (
   SGChannel    c,
   long         *refCon );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
refCon

A pointer to the reference constant set by SGSetChannelRefCon, normally used to point to a data structure containing information your sequence grabber channel needs.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 6.
Availability
Available in Mac OS X v10.2 and later.
Declared In
QuickTimeComponents.h&*/

ComponentResult SGGetChannelRefCon (
   SGChannel    c,
   long         *refCon ){
//TODO
};


/*SGSetChannelRefCon

Sets the value of a reference constant that is passed to your callback functions for channel components.

ComponentResult SGSetChannelRefCon (
   SGChannel    c,
   long         refCon );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
refCon

A reference constant value that your component should pass to the callback functions that have been assigned to this channel. Use this parameter to point to a data structure containing any information your callbacks need.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGSetChannelRefCon (
   SGChannel    c,
   long         refCon ){
//TODO
};


/*QTAddComponentPropertyListener

Installs a callback to monitor a component property.

ComponentResult QTAddComponentPropertyListener (
   ComponentInstance                 inComponent,
   ComponentPropertyClass            inPropClass,
   ComponentPropertyID               inPropID,
   QTComponentPropertyListenerUPP    inDispatchProc,
   void                              *inUserData );
Parameters
inComponent

A component instance, which you can get by calling OpenComponent or OpenDefaultComponent.
inPropClass

A value (see below) of type OSType that specifies a property class: kComponentPropertyClassPropertyInfo ('pnfo') A QTComponentPropertyInfo structure that defines a property information class. kComponentPropertyInfoList ('list') An array of QTComponentPropertyInfo structures, one for each property. kComponentPropertyCacheSeed ('seed') A component property cache seed value. kComponentPropertyExtendedInfo ('meta') A CFDictionary with extended property information. kComponentPropertyCacheFlags ('flgs') One of the following two flags: kComponentPropertyCacheFlagNotPersistent Property metadata should not be saved in persistent cache. kComponentPropertyCacheFlagIsDynamic Property metadata should not be cached at all. See these constants: 
kComponentPropertyClassPropertyInfo
kComponentPropertyInfoList
kComponentPropertyCacheSeed
kComponentPropertyExtendedInfo
kComponentPropertyCacheFlags
kComponentPropertyCacheFlagNotPersistent
kComponentPropertyCacheFlagIsDynamic
inPropID

A value of type OSType that specifies a property ID.
inDispatchProc

A Universal Procedure Pointer to a QTComponentPropertyListenerProc callback.
inUserData

A pointer to user data that will be passed to the callback. You may pass NULL in this parameter.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
ComponentResult QTAddComponentPropertyListener (
   ComponentInstance                 inComponent,
   ComponentPropertyClass            inPropClass,
   ComponentPropertyID               inPropID,
   QTComponentPropertyListenerUPP    inDispatchProc,
   void                              *inUserData ){
//TODO
};





