#ifndef QUARTZCORE_H
#include <QuartzCore/QuartzCore.h>
#endif



/*CVDisplayLinkRelease

Releases a display link.

void CVDisplayLinkRelease (
   CVDisplayLinkRef displayLink
);
Parameters
displayLink

The display link to release. This function is NULL-safe.
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVDisplayLink.h*/

void CVDisplayLinkRelease (
   CVDisplayLinkRef displayLink
){
//TODO
};


/*CVDisplayLinkCreateWithActiveCGDisplays

Creates a display link capable of being used with all active displays.

CVReturn CVDisplayLinkCreateWithActiveCGDisplays (
   CVDisplayLinkRef *displayLinkOut
);
Parameters
displayLinkOut

On return, displayLinkOut points to the newly created display link.
Return Value

A Core Video result code. See “Result Codes” for possible values. 
Discussion

CVDisplayLinkCreateWithActiveCGDisplays determines the displays actively used by the host computer and creates a display link compatible with all of them. For most applications, calling this function is the most convenient way to create a display link. After creation, you can assign the display link to any active display by calling CVDisplayLinkSetCurrentCGDisplay.
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVDisplayLink.h*/
CVReturn CVDisplayLinkCreateWithActiveCGDisplays (
   CVDisplayLinkRef *displayLinkOut){
//TODO
};

/*CVBufferRelease

Releases a Core Video buffer. 

void CVBufferRelease (CVBufferRef buffer);
Parameters
buffer

The Core Video buffer that you want to release.
Discussion

Like CFRelease CVBufferRelease decrements the retain count of a Core Video buffer. If that count consequently becomes zero the memory allocated to the object is deallocated and the object is destroyed. Unlike CFRelease, you can pass NULL to CVBufferRelease without causing a crash. 
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVBuffer.h*/
void CVBufferRelease (CVBufferRef buffer){
//TODO
};


/*CVDisplayLinkSetOutputCallback

Set the renderer output callback function.

CVReturn CVDisplayLinkSetOutputCallback (
   CVDisplayLinkRef displayLink,
   CVDisplayLinkOutputCallback callback,
   void *userInfo
);
Parameters
displayLink

The display link whose output callback you want to set. 
callback

The callback function to set for this display link. See CVDisplayLinkOutputCallback for more information about implementing this function. 
userInfo

A pointer to user data.
Return Value

A Core Video result code. See “Result Codes” for possible values.
Discussion

The display link invokes this callback whenever it wants you to output a frame. 
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVDisplayLink.h*/
CVReturn CVDisplayLinkSetOutputCallback (
   CVDisplayLinkRef displayLink,
   CVDisplayLinkOutputCallback callback,
   void *userInfo){
//TODO
};


/*CVDisplayLinkSetCurrentCGDisplayFromOpenGLContext

Selects the display link most optimal for the current renderer of an OpenGL context.

CVReturn CVDisplayLinkSetCurrentCGDisplayFromOpenGLContext (
   CVDisplayLinkRef displayLink,
   CGLContextObj cglContext,
   CGLPixelFormatObj cglPixelFormat
);
Parameters
displayLink

The display link for which you want to set the current display.
cglContext

The OpenGL context to retrieve the current renderer from.
cglPixelFormat

The OpenGL pixel format used to create the passed-in OpenGL context.
Return Value

A Core Video result code. See “Result Codes” for possible values. 
Discussion

This function chooses the display with the lowest refresh rate. 
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVDisplayLink.h*/
CVReturn CVDisplayLinkSetCurrentCGDisplayFromOpenGLContext (
   CVDisplayLinkRef displayLink,
   CGLContextObj cglContext,
   CGLPixelFormatObj cglPixelFormat){
//TODO
};



/*CVDisplayLinkStart

Activates a display link.

CVReturn CVDisplayLinkStart (
   CVDisplayLinkRef displayLink
);
Parameters
displayLink

The display link to activate. 
Return Value

A Core Video result code. See “Result Codes” for possible values. 
Discussion

Calling this function starts the display link thread, which then periodically calls back to your application to request that you display frames. If the specified display link is already running, CVDisplayLinkStart returns an error.
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVDisplayLink.h*/
CVReturn CVDisplayLinkStart (
   CVDisplayLinkRef displayLink){
//TODO
};


/*CVOpenGLTextureGetTarget

Returns the texture target (for example, GL_TEXTURE_2D) of an OpenGL texture.

GLenum CVOpenGLTextureGetTarget (
   CVOpenGLTextureRef image
);
Parameters
image

The Core Video OpenGL texture whose target you want to obtain. 
Return Value

The OpenGL texture target.
Discussion

See the OpenGL specification for more information about texture targets.
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVOpenGLTexture.h*/
GLenum CVOpenGLTextureGetTarget (
   CVOpenGLTextureRef image){
//TODO
};


/*CVOpenGLTextureGetCleanTexCoords

Returns the texture coordinates for the part of the image that should be displayed.

void CVOpenGLTextureGetCleanTexCoords (
   CVOpenGLTextureRef image,
   GLfloat lowerLeft[2],
   GLfloat lowerRight[2],
   GLfloat upperRight[2],
   GLfloat upperLeft[2]
);
Parameters
image

The Core Video OpenGL texture whose clean tex coordinates you want to obtain.
lowerLeft

On return, the GLFloat array hold the s and t texture coordinates of the lower-left corner of the image.
lowerRight

On return, the GLFloat array hold the s and t texture coordinates of the lower-right corner of the image.
upperRight

On return, the GLFloat array hold the s and t texture coordinates of the upper-right corner of the image.
upperLeft

On return, the GLFloat array hold the s and t texture coordinates of the upper-left corner of the image.
Discussion

This function automatically takes into account whether or not the texture is flipped. 
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVOpenGLTexture.h*/
void CVOpenGLTextureGetCleanTexCoords (
   CVOpenGLTextureRef image,
   GLfloat lowerLeft[2],
   GLfloat lowerRight[2],
   GLfloat upperRight[2],
   GLfloat upperLeft[2]){
//TODO
};


/*CVOpenGLTextureGetName

Returns the texture target name of a CoreVideo OpenGL texture. 

GLuint CVOpenGLTextureGetName (
   CVOpenGLTextureRef image
);
Parameters
image

The Core Video OpenGL texture whose texture target name you want to obtain.
Return Value

The target name of the texture. 
Discussion

See the OpenGL specification for more information about texture targets.
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVOpenGLTexture.h*/

GLuint CVOpenGLTextureGetName (
   CVOpenGLTextureRef image){
//TODO
};

