#ifndef LAUNCHSERVICES_H
#include <LaunchServices/LaunchServices.h>
#endif

/*LSCopyItemInfoForRef

Obtains requested information about an item designated by file-system reference.

OSStatus LSCopyItemInfoForRef (
   const FSRef *inItemRef,
   LSRequestedInfo inWhichInfo,
  OSStatus LSCopyItemInfoForRef (
   const FSRef *inItemRef,
   LSRequestedInfo inWhichInfo,
   LSItemInfoRecord *outItemInfo
); LSItemInfoRecord *outItemInfo
);
Parameters
inItemRef

A pointer to a file-system reference designating the item about which information is requested; see the File Manager Reference in the Carbon File Management Documentation for a description of the FSRef data type.
inWhichInfo

Flags specifying what information to obtain; see “Requested-Information Flags” for a description of these flags.
outItemInfo

A pointer to an item-information record that, on return, will contain the requested information; see “LSItemInfoRecord” for a description of this structure.

If you request the item’s filename extension (field extension of the item-information record, requested by flag kLSRequestExtension), you are responsible for releasing the Core Foundation string object in which the extension is returned.
Return Value

A result code; see “Launch Services Result Codes”.
Discussion

The information obtained about an item can include its filename extension, file type, creator signature, and various item-information flags (indicating, for example, whether the item is an application, or whether it has a hidden extension); see “Item-Information Flags” for a description of these flags.
Version Notes

Thread-safe since Mac OS version 10.2.
Availability
Available in Mac OS X v10.0 and later.
Declared In
LSInfo.h*/
OSStatus LSCopyItemInfoForRef (
   const FSRef *inItemRef,
   LSRequestedInfo inWhichInfo,
   LSItemInfoRecord *outItemInfo){
//TODO
};

/*LSCopyDisplayNameForRef

Obtains the display name for an item designated by file-system reference.

OSStatus LSCopyDisplayNameForRef (
   const FSRef *inRef,
   CFStringRef *outDisplayName
);
Parameters
inRef

A pointer to a file-system reference designating the item whose display name is requested; see the File Manager Reference in the Carbon File Management Documentation for a description of the FSRef data type.
outDisplayName

A pointer to a Core Foundation string object that, on return, will contain the items display name; see the CFString Reference in the Core Foundation Reference Documentation for a description of the CFStringRef data type. You are responsible for releasing this object.
Return Value

A result code; see Launch Services Result Codes.
Discussion

The items display name is returned in the form in which it will appear on the users screen; it may be localized (for applications and folders), and it excludes the filename extension if the extension is set to be hidden and the Finder preference to always show extensions is not enabled.
Version Notes

Thread-safe since Mac OS version 10.2.
Availability
Available in Mac OS X v10.1 and later.
Declared In
LSInfo.h*/
OSStatus LSCopyDisplayNameForRef (
   const FSRef *inRef,
   CFStringRef *outDisplayName){
//TODO
};



/*LSCanRefAcceptItem

Tests whether an application can accept (open) an item designated by file-system reference.

OSStatus LSCanRefAcceptItem (
   const FSRef *inItemFSRef,
   const FSRef *inTargetFSRef,
   LSRolesMask inRolesMask,
   LSAcceptanceFlags inFlags,
   Boolean *outAcceptsItem
);
Parameters
inItemFSRef

A pointer to a file-system reference designating the source item (the item to test for acceptance by the target application); see the File Manager Reference in the Carbon File Management Documentation for a description of the FSRef data type.
inTargetFSRef

A pointer to a file-system reference designating the target application; see the File Manager Reference in the Carbon File Management Documentation for a description of the FSRef data type.
inRolesMask

A bit mask specifying the target application’s desired role or roles with respect to the source item; see “Roles Mask” for a description of this mask. If the role is unimportant, pass kLSRolesAll.
inFlags

Flags specifying behavior to observe during the acceptance test; see “Acceptance Flags” for a description of these flags.
outAcceptsItem

A pointer to a Boolean value that, on return, will indicate whether the target application can accept the source item with at least one of the specified roles.
Return Value

A result code; see “Launch Services Result Codes”.
Version Notes

Thread-safe since Mac OS version 10.2.
Availability
Available in Mac OS X v10.0 and later.
Declared In
LSInfo.h*/
OSStatus LSCanRefAcceptItem (
   const FSRef *inItemFSRef,
   const FSRef *inTargetFSRef,
   LSRolesMask inRolesMask,
   LSAcceptanceFlags inFlags,
   Boolean *outAcceptsItem){
//TODO
};


