#ifndef AUDIOTOOLBOX_H
#include <AudioToolbox/AudioToolbox.h>
#endif

/*AudioFileReadPackets

Reads in a certain number of packets from the input file.

extern OSStatus AudioFileReadPackets(
AudioFileID inAudioFile,
Boolean inUseCache,
UInt32 *outNumBytes,
AudioStreamPacketDescription *outPacketDescriptions,
SInt64 inStartingPacket,
UInt32 *ioNumPackets,
void *outBuffer
);
Discussion

This function reads in the contents of the file by packet, starting at inStartingPoint. The packets that have been read are described in outPacketDescriptions, while the number of packets is specified in ioNumPackets (with the actual number of packets read being the return value), and the size, in bytes, of the read in packets returned in outNumBytes. If the read should be cached, set inUseCache to true.
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus AudioFileReadPackets(
AudioFileID inAudioFile,
Boolean inUseCache,
UInt32 *outNumBytes,
AudioStreamPacketDescription *outPacketDescriptions,
SInt64 inStartingPacket,
UInt32 *ioNumPackets,
void *outBuffer){
//TODO
};



/*AudioFileGetProperty

Returns the data for the specified property.

extern OSStatus AudioFileGetProperty(
AudioFileID inAudioFile,
AudioFilePropertyID inPropertyID,
UInt32 *ioDataSize,
void *outPropertyData
);
Discussion

The file and property being queried should be specified in inAudioFile and inPropertyID, respectively, with the size retrieved with AudioFileGetPropertyInfo() passed into ioDataSize, and the resulting data being placed in outPropertyData.
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus AudioFileGetProperty(
AudioFileID inAudioFile,
AudioFilePropertyID inPropertyID,
UInt32 *ioDataSize,
void *outPropertyData){
//TODO
};


/*AudioFileGetPropertyInfo

Returns the size of the data that will be returned for the property.

extern OSStatus AudioFileGetPropertyInfo(
AudioFileID inAudioFile,
AudioFilePropertyID inPropertyID,
UInt32 *outDataSize,
UInt32 *isWritable
);
Discussion

The file being queried should be passed in as inAudioFile, while the property being queried is passed in as inPropertyID. The size of the resulting data is returned in outDataSize, and isWritable will reflect if the data is modifiable.
Availability
Available in Mac OS X v10.2 and later.*/
extern OSStatus AudioFileGetPropertyInfo(
AudioFileID inAudioFile,
AudioFilePropertyID inPropertyID,
UInt32 *outDataSize,
UInt32 *isWritable){
//TODO
};


/*AudioFileWritePackets

Writes the buffer to the file, by packets.

extern OSStatus AudioFileWritePackets(
AudioFileID inAudioFile,
Boolean inUseCache,
UInt32 inNumBytes,
AudioStreamPacketDescription *inPacketDescriptions,
SInt64 inStartingPacket,
UInt32 *ioNumPackets,
void *inBuffer
);
Discussion

When writing to inAudioFile, specify the starting index as inStartingPacket, the format of the packet as defined in inPacketDescrptions, the size of the write as inNumBytes, and the number of packets to be written in ioNumPackets. If the write should be cached, set inUseCache to true.
Availability
Available in Mac OS X v10.2 and later.
Property Access*/
OSStatus AudioFileWritePackets(
AudioFileID inAudioFile,
Boolean inUseCache,
UInt32 inNumBytes,
AudioStreamPacketDescription *inPacketDescriptions,
SInt64 inStartingPacket,
UInt32 *ioNumPackets,
void *inBuffer){
//TODO
};



/*AudioFileCreate

Creates a new file using the descriptions provided.

extern OSStatus AudioFileCreate(
const FSRef *inParentRef,
CFStringRef inFileName,
UInt32 inFileType,
const AudioStreamBasicDescription *inFormat,
UInt32 inFlags,
FSRef *outNewFileRef,
AudioFileID *outAudioFile
);
Discussion

The directory that the file to be place into is provided with inParentRef, the name of the file is contained within inFileName, a File Type constant must be provided with inFileType, the format must be specified using inFormat, inFlag contains flags for opening and creating the file (currently undefined; should be set to 0), and outNewFileRef is provided for file system use, while outAudioFile is for use with other audio file functions.
Availability
Available in Mac OS X v10.2 and later.*/

OSStatus AudioFileCreate(
const FSRef *inParentRef,
CFStringRef inFileName,
UInt32 inFileType,
const AudioStreamBasicDescription *inFormat,
UInt32 inFlags,
FSRef *outNewFileRef,
AudioFileID *outAudioFile){
//TODO
};



/*AudioFileSetProperty

Sets the data for the respective property.

extern OSStatus AudioFileSetProperty(
AudioFileID inAudioFile,
AudioFilePropertyID inPropertyID,
UInt32 inDataSize,
const void *inPropertyData
);
Discussion

The file and property being set should be specified in inAudioFile and inPropertyID, respectively, with the size of the data being written passed into ioDataSize, and the data being written coming from inPropertyData.
Availability
Available in Mac OS X v10.2 and later.
Global Info Access*/
extern OSStatus AudioFileSetProperty(
AudioFileID inAudioFile,
AudioFilePropertyID inPropertyID,
UInt32 inDataSize,
const void *inPropertyData){
//TODO
};


/*AudioFileClose

Closes the file.

extern OSStatus AudioFileClose(AudioFileID inAudioFile);
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus AudioFileClose(AudioFileID inAudioFile){
//TODO
};


/*AudioFileOpen

Opens a file while preserving its contents.

extern OSStatus AudioFileOpen (
const FSRef *inFileRef,
SInt8 inPermissions,
UInt32 inFlags,
AudioFileID *outAudioFile
);
Discussion

The inFileRef should be a reference to an existing file, inPermissions being the permissions for the file, as used by FSOpenFork(), and inFlags, currently undefined, should be set to 0; outAudioFile is a file instance that will be returned for use in other audio file functions.
Availability
Available in Mac OS X v10.2 and later.*/

OSStatus AudioFileOpen (
const FSRef *inFileRef,
SInt8 inPermissions,
UInt32 inFlags,
AudioFileID *outAudioFile){
//TODO
};

