#ifndef QUICKDRAW_H
#define QUICKDRAW_H

#ifndef CORESERVICES_H
#include <CoreServices/CoreServices.h>
#endif

#ifndef COREGRAPHICS_H
#include <CoreGraphics/CoreGraphics.h>
#endif

#ifndef QUICKDRAWTEXT_H
#include <QD/QuickdrawText.h>
#endif

#ifndef CMTYPES_H
#include <ColorSync/CMTypes.h>
#endif

#include <HYS/QD/Quickdraw.h>
#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif


/*ITab

struct ITab {
   long iTabSeed;
   short iTabRes;
   Byte iTTable[1];
};
typedef struct ITab ITab;
typedef ITab * ITabPtr;
typedef ITabPtr * ITabHandle;
Fields
iTabSeed

The iTabSeed value, initially set from the corresponding CLUT’s ctSeed field. If at any time these do not match, then the color table was changed, and the inverse table needs to be rebuilt.
iTabRes

The resolution of this inverse table.
iTTable

An array of index values. The size of the iTabTable field in bytes is 23*iTabRes.
Discussion

The ITab data structure contains the inverse table information that the Color Manager uses for fast mapping of RGB color values. 
Availability
Available in Mac OS X v10.0 and later.*/
struct ITab {
   long iTabSeed;
   short iTabRes;
   Byte iTTable[1];
};
typedef struct ITab ITab;
typedef ITab * ITabPtr;
typedef ITabPtr * ITabHandle;



/*RGBColor

struct RGBColor {
   unsigned short red;
   unsigned short green;
   unsigned short blue;
};
typedef struct RGBColor RGBColor;
typedef RGBColor * RGBColorPtr;
Fields
red

An unsigned integer specifying the red value of the color.
green

An unsigned integer specifying the green value of the color.
blue

An unsigned integer specifying the blue value of the color.
Discussion

You usually specify a color to QuickDraw by creating an RGBColor structure in which you assign the red, green, and blue values of the foreground color. For example, when you want to set the foreground color for drawing, you create an RGBColor structure that defines the foreground color you desire; then you pass that structure as a parameter to the RGBForeColor function. 

In an RGBColor structure, three 16-bit unsigned integers give the intensity values for the three additive primary colors. 
Availability
Available in Mac OS X v10.0 and later.*/
struct RGBColor {
   unsigned short red;
   unsigned short green;
   unsigned short blue;
};
typedef struct RGBColor RGBColor;
typedef RGBColor * RGBColorPtr;


/*ColorSpec

struct ColorSpec {
   short value;
   RGBColor rgb;
};
typedef struct ColorSpec ColorSpec;
typedef ColorSpec * ColorSpecPtr;
Fields
value

The pixel value assigned by QuickDraw for the color specified in the rgb field of this structure. QuickDraw assigns a pixel value based on the capabilities of the user’s screen. For indexed devices, the pixel value is an index number assigned by QuickDraw to the closest color available on the indexed device for direct devices, this value expresses the best available red, green, and blue values for the color on the direct device.
rgb

An RGBColor structure that fully specifies the color whose approximation QuickDraw specifies in the value field. 
Discussion

When creating a PixMap structure for an indexed device, QuickDraw creates a ColorTable structure that defines the best colors available for the pixel image on that graphics device. QuickDraw also stores a ColorTable structure for the currently available colors in the graphics device’s CLUT. 

One of the fields in a ColorTable structure requires a value of type cSpecArray, which is defined as an array of ColorSpec structures. Typically, your application never needs to create ColorTable structures or ColorSpec structures. For completeness, the data structure of type ColorSpec is shown here. 
Availability
Available in Mac OS X v10.0 and later.*/
struct ColorSpec {
   short value;
   RGBColor rgb;
};
typedef struct ColorSpec ColorSpec;
typedef ColorSpec * ColorSpecPtr;

/*CSpecArray

typedef ColorSpec CSpecArray[1];
Availability
Available in Mac OS X v10.0 and later.*/
typedef ColorSpec CSpecArray[1];


/*ColorTable

struct ColorTable {
   long ctSeed;
   short ctFlags;
   short ctSize;
   CSpecArray ctTable;
};
typedef struct ColorTable ColorTable;
typedef ColorTable * CTabPtr;
typedef CTabPtr * CTabHandle;
Fields
ctSeed

Identifies a particular instance of a color table. QuickDraw uses the ctSeed value to compare an indexed device’s color table with its associated inverse table (a table it uses for fast color lookup).When the color table for a graphics device has been changed, QuickDraw needs to rebuild the inverse table.
ctFlags

Flags that distinguish pixel map color tables from color tables in GDevice structures.
ctSize

One less than the number of entries in the table.
ctTable

An array of ColorSpec entries, each containing a pixel value and a color specified by an RGBColor structure. 
Discussion

When creating a PixMap structure for a particular graphics device, QuickDraw creates a ColorTable structure that defines the best colors available for the pixel image on that particular graphics device. QuickDraw also creates a ColorTable structure of all available colors for use by the CLUT on indexed devices.

Typically, your application needs to create ColorTable structures only if it uses the Palette Manager. 

Your application should never need to directly change the fields of a ColorTable structure. If you find it absolutely necessary for your application to do so, immediately use the CTabChanged function to notify QuickDraw that your application has changed the ColorTable structure. 
Availability
Available in Mac OS X v10.0 and later.*/
struct ColorTable {
   long ctSeed;
   short ctFlags;
   short ctSize;
   CSpecArray ctTable;
};
typedef struct ColorTable ColorTable;
typedef ColorTable * CTabPtr;
typedef CTabPtr * CTabHandle;



/*CTabPtr

Abst_CTabPtr

typedef ColorTable * CTabPtr;
Availability
Available in Mac OS X v10.0 and later.*/
typedef ColorTable * CTabPtr;

/*CTabHandle

Abst_CTabHandle

typedef CTabPtr * CTabHandle;
Availability
Available in Mac OS X v10.0 and later.*/
typedef CTabPtr * CTabHandle;



/*PixMap

Contains information about the dimensions and contents of a pixel image, as well as its storage format, depth, resolution, and color usage.

struct PixMap {
   Ptr           baseAddr;
   short         rowBytes;
   Rect          bounds;
   short         pmVersion;
   short         packType;
   long          packSize;
   Fixed         hRes;
   Fixed         vRes;
   short         pixelType;
   short         pixelSize;
   short         cmpCount;
   short         cmpSize;
   OSType        pixelFormat;
   CTabHandle    pmTable;
   void *        pmExt;
};
Fields
baseAddr
Discussion

For an onscreen pixel image, a pointer to the first byte of the image. For optimal performance, this should be a multiple of 4. The baseAddr field of the PixMap record for an offscreen graphics world contains a handle instead of a pointer. Your application should never directly access the baseAddr field of the PixMap record for an offscreen graphics world.
rowBytes
Discussion

The offset in bytes from one row of the image to the next. The value must be even, less than 0x4000, and for best performance it should be a multiple of 4. The high 2 bits of rowBytes are used as flags. If bit 15 =1, the data structure pointed to is a PixMap structure; otherwise it is a BitMap structure.
bounds
Discussion

The boundary rectangle, which links the local coordinate system of a graphics port to QuickDraw's global coordinate system and defines the area of the bit image into which QuickDraw can draw. By default, the boundary rectangle is the entire main screen. Do not use the value of this field to determine the size of the screen; instead use the value of the gdRect field of the GDevice structure for the screen.
pmVersion
Discussion

The version number of Color QuickDraw that created this PixMap structure. The value of pmVersion is normally 0. If pmVersion is 4, Color QuickDraw treats the PixMap record's baseAddr field as 32-bit clean. All other flags are private. Most applications never need to set this field
packType
Discussion

The packing algorithm used to compress image data. Color QuickDraw currently supports a packType of 0, which means no packing, and values of 1 to 4 for packing direct pixels.
packSize
Discussion

The size of the packed image in bytes. When the packType field contains the value 0, this field is always set to 0.
hRes
Discussion

The horizontal resolution of the pixel image in pixels per inch. By default, this value is 0x00480000 (for 72 pixels per inch).
vRes
Discussion

The vertical resolution of the pixel image in pixels per inch. By default, this value is 0x00480000 (for 72 pixels per inch).
pixelType
Discussion

The storage format for a pixel image. Indexed pixels are indicated by a value of 0. Direct pixels are specified by a value of RGBDirect, or 16. In the PixMap record of the GDevice structure for a direct device, this field is set to RGBDirect when the screen depth is set.
pixelSize
Discussion

The number of bits used to represent a pixel. Indexed pixels can have sizes of 1, 2, 4, and 8 bits; direct pixel sizes are 16 and 32 bits.
cmpCount
Discussion

The number of components used to represent a color for a pixel. With indexed pixels, each pixel is a single value representing an index in a color table, and therefore this field contains the value 1; the index is the single component. With direct pixels, each pixel contains three components (one integer each for the intensities of red, green, and blue) so this field contains the value 3.
cmpSize
Discussion

The size in bits of each component for a pixel. Color QuickDraw expects that the sizes of all components are the same, and that the value of the cmpCount field multiplied by the value of the cmpSize field is less than or equal to the value in the pixelSize field.

For an indexed pixel value, which has only one component, the value of the cmpSize field is the same as the value of the pixelSize field; that is, 1, 2, 4, or 8. For direct pixels there are two additional possibilities. A 16-bit pixel, which has three components, has a cmpSize value of 5; this leaves an unused high-order bit, which Color QuickDraw sets to 0. A 32-bit pixel, which has three components (red, green, and blue), has a cmpSize value of 8; this leaves an unused high-order byte, which Color QuickDraw sets to 0.

If presented with a 32-bit image (for example, in the CopyBits procedure) Color QuickDraw passes whatever bits are there, and it does not set the high byte to 0. Generally, therefore, your application should clear the memory for the image to 0 before creating a 16-bit or 32-bit image.
planeBytes
Discussion

The offset in bytes from one drawing plane to the next. This field is set to 0.
pmTable
Discussion

A handle to a ColorTable structure for the colors in this pixel map.
pmReserved
Discussion

Reserved. This field must be set to 0 for future compatibility.
pixelFormat
Discussion

The way the pixels are arranged; see Pixel Formats.
pmTable
Discussion

Color map for this structure.
pmExt
Discussion

Handle to a PixMapExtension structure. Set to NIL if there is no extension.
Discussion

The pixel map for a window's color graphics port always consists of the pixel depth, color table, and boundary rectangle of the main screen, even if the window is created on or moved to an entirely different screen.
Version Notes

Earlier versions of this structure were different in the last three fields; see the C interface file for details.
Programming Info
C interface file: Quickdraw.h*/
struct PixMap {
   Ptr           baseAddr;
   short         rowBytes;
   Rect          bounds;
   short         pmVersion;
   short         packType;
   long          packSize;
   Fixed         hRes;
   Fixed         vRes;
   short         pixelType;
   short         pixelSize;
   short         cmpCount;
   short         cmpSize;
   OSType        pixelFormat;
   CTabHandle    pmTable;
   void *        pmExt;
};
typedef  struct PixMap PixMap;



/*PixMapPtr

Abst_PixMapPtr

typedef PixMap * PixMapPtr;
Availability
Available in Mac OS X v10.0 and later.*/
typedef PixMap * PixMapPtr;

/*PixMapHandle

Abst_PixMapHandle

typedef PixMapPtr * PixMapHandle;
Availability
Available in Mac OS X v10.0 and later.*/
typedef PixMapPtr * PixMapHandle;


/*GDevice

struct GDevice {
   short gdRefNum;
   short gdID;
   short gdType;
   ITabHandle gdITable;
   short gdResPref;
   SProcHndl gdSearchProc;
   CProcHndl gdCompProc;
   short gdFlags;
   PixMapHandle gdPMap;
   long gdRefCon;
   GDHandle gdNextGD;
   Rect gdRect;
   long gdMode;
   short gdCCBytes;
   short gdCCDepth;
   Handle gdCCXData;
   Handle gdCCXMask;
   long gdReserved;
};
typedef struct GDevice GDevice;
typedef GDevice * GDPtr;
typedef GDPtr * GDHandle;
Fields
gdRefNum

The reference number of the driver for the screen associated with the video device. For most video devices, this information is set at system startup time.
gdID

Reserved. If you create your own GDevice structure, set this field to 0.
gdType

The general type of graphics device. See Graphics Device Type Constants for a description of the values which you can use in this field.
gdITable

A handle to the inverse table for color mapping. 
gdResPref

The preferred resolution for inverse tables.
gdSearchProc

A handle to the list of search functions. Its value is NULL for the default function. 
gdCompProc

A handle to a list of complement functions. Its value is NULL for the default function. 
gdFlags

The GDevice structure’s attributes. To set the attribute bits in the gdFlags field, use the SetDeviceAttribute function. Do not set gdFlags directly in the GDevice structure.
gdPMap

A handle to a PixMap structure giving the dimension of the image buffer, along with the characteristics of the graphics device (resolution, storage format, color depth, and color table). For GDevice structures, the high bit of the global variable 

(((**TheGDevice).**gdPMap).**pmTable).ctFlags

is always set.

gdRefCon

A value used by system software to pass device-related parameters. Since a graphics device is shared, do not store data here.
gdNextGD

A handle to the next graphics device in the device list. If this is the last graphics device in the device list, the field contains 0. 
gdRect

The boundary rectangle of the graphics device represented by the GDevice structure. The main screen has the upper-left corner of the rectangle set to (0,0). All other graphics devices are relative to this point.
gdMode

The current setting for the graphics device mode. This value is passed to the video driver to set its pixel depth and to specify color or black and white; applications do not need this information.
gdCCBytes

The rowBytes value of the expanded cursor. Your application should not change this field.
gdCCDepth

The depth of the expanded cursor. Your application should not change this field.
gdCCXData

A handle to the cursor’s expanded data. Your application should not change this field.
gdCCXMask

A handle to the cursor’s expanded mask. Your application should not change this field.
gdReserved

Reserved for future expansion; it must be set to 0 for future compatibility.
Discussion

Color QuickDraw stores state information for video devices and offscreen graphics worlds in GDevice structures. When the system starts up, it allocates and initializes one handle to a GDevice structure for each video device it finds. When you use the Offscreen Graphics Devices function, NewGWorld, Color QuickDraw automatically creates a GDevice structure for the new offscreen graphics world. The system links these GDevice structures in a list, called the device list. (You can find a handle to the first element in the device list in the global variable DeviceList.) By default, the GDevice structure corresponding to the first video device found is marked as the current device. All other graphics devices in the list are initially marked as inactive. 

When the user moves a window or creates a window on another screen, and your application draws into that window, Color QuickDraw automatically makes the video device for that screen the current device. Color QuickDraw stores that information in the global variable TheGDevice. 

GDevice structures that correspond to video devices have drivers associated with them. These drivers can be used to change the mode of the video device from black and white to color and to change the pixel depth. Application-created GDevice structures usually don’t require drivers. 

Your application should never need to directly change the fields of a GDevice structure. If you find it absolutely necessary for your application to so, immediately use the GDeviceChanged function to notify QuickDraw that your application has changed the GDevice structure. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct GDevice GDevice;
typedef GDevice * GDPtr;
typedef GDPtr * GDHandle;

struct GDevice {
   short gdRefNum;
   short gdID;
   short gdType;
   ITabHandle gdITable;
   short gdResPref;
   SProcHndl gdSearchProc;
   CProcHndl gdCompProc;
   short gdFlags;
   PixMapHandle gdPMap;
   long gdRefCon;
   GDHandle gdNextGD;
   //int  gdNextGD; //hys
   Rect gdRect;
   long gdMode;
   short gdCCBytes;
   short gdCCDepth;
   Handle gdCCXData;
   Handle gdCCXMask;
   long gdReserved;
};





/*Picture

struct Picture {
   short picSize;
   Rect picFrame;
};
typedef struct Picture Picture;
typedef Picture * PicPtr;
typedef PicPtr * PicHandle;
Fields
picSize

The size of the rest of this structure for a version 1 picture. To maintain compatibility with the version 1 picture format, the picSize field was not changed for the version 2 picture or extended version 2 formats. The information in this field is used only for version 1 pictures, which cannot exceed 32 KB in size. Because version 2 and extended version 2 pictures can be much larger than the 32 KB limit imposed by the 2-byte picSize field, you should use the Memory Manager function GetHandleSize to determine the size of a picture in memory; you should use the File Manager function PBGetFInfo to determine the size of a picture in a 'PICT' file; and you should use the Resource Manager function GetMaxResourceSize to determine the size of a 'PICT' resource.
picFrame

The bounding rectangle for the picture defined in the rest of this structure. The DrawPicture function uses this rectangle to scale the picture if you draw it into a destination rectangle of a different size.
Discussion

When you use the OpenCPicture or OpenPicture function, QuickDraw begins collecting your subsequent drawing commands in a Picture structure. (You use the ClosePicture function to complete a picture definition.) When you use the GetPicture function to retrieve a picture stored in a resource, GetPicture reads the resource into memory as a Picture structure. By using the DrawPicture procedure, you can draw onscreen the picture defined by the commands stored in the Picture structure.

A picture opcode is a number that the DrawPicture function uses to determine what object to draw or what mode to change for subsequent drawing. Generally, donot read or write this picture data directly. Instead, use the OpenCPicture (or OpenPicture), ClosePicture, and DrawPicture functions to process these opcodes.

The Picture structure can also contain picture comments. Created by applications using the PicComment function, picture comments contain data or commands for special processing by output devices, such as PostScript printers. 

You can use File Manager functions to save the picture in a file of type 'PICT', you can use Resource Manager functions to save the picture in a resource of type 'PICT', and you can use the Scrap Manager function PutScrap to store the picture in 'PICT' scrap format. 
Availability
Available in Mac OS X v10.0 and later.*/
struct Picture {
   short picSize;
   Rect picFrame;
};
typedef struct Picture Picture;
typedef Picture * PicPtr;
typedef PicPtr * PicHandle;

/*PicPtr

Abst_PicPtr

typedef Picture * PicPtr;
Availability
Available in Mac OS X v10.0 and later.*/
typedef Picture * PicPtr;

/*PicHandle

Abst_PicHandle

typedef PicPtr * PicHandle;
Availability
Available in Mac OS X v10.0 and later.*/
typedef PicPtr * PicHandle;

/*GrafPtr

typedef struct OpaqueGrafPtr * GrafPtr;
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaqueGrafPtr * GrafPtr;

/*WindowPtr

Defines a window pointer. 

typedef struct OpaqueWindowPtr * WindowPtr;
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaqueWindowPtr * WindowPtr;

/*WindowRef

Represents a window. 

typedef WindowPtr WindowRef;
Availability
Available in Mac OS X v10.0 and later.*/
typedef WindowPtr WindowRef;

/*DialogPtr

typedef struct OpaqueDialogPtr * DialogPtr;
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaqueDialogPtr * DialogPtr;

#ifdef __cplusplus
}
#endif

#endif