#ifndef DIALOGS_H
#define DIALOGS_H


#ifndef CORESERVICES_H
#include <CoreServices/CoreServices.h>
#endif

#ifndef EVENTS_H
#include <HIToolbox/Events.h>
#endif

#ifndef MACWINDOWS_H
#include <HIToolbox/MacWindows.h>
#endif

#ifndef TEXTEDIT_H
#include <HIToolbox/TextEdit.h>
#endif

#ifndef CONTROLS_H
#include <HIToolbox/Controls.h>
#endif

#ifndef CARBONEVENTS_H
#include <HIToolbox/CarbonEvents.h>
#endif



#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Alert Type Constants


enum {
   kAlertStopAlert = 0,
   kAlertNoteAlert = 1,
   kAlertCautionAlert = 2,
   kAlertPlainAlert = 3
};
Constants
kAlertStopAlert

Stop alert box. 

Available in Mac OS X v10.0 and later.
kAlertNoteAlert

Note alert box. 

Available in Mac OS X v10.0 and later.
kAlertCautionAlert

Caution alert box. 

Available in Mac OS X v10.0 and later.
kAlertPlainAlert

Alert box with no icon.

Available in Mac OS X v10.0 and later.
Discussion

You can pass constants of type AlertType in the inAlertType parameter of StandardAlert to specify the type of alert box you wish to create. Alert type constants are available with Appearance Manager 1.0 and later.*/
enum {
   kAlertStopAlert = 0,
   kAlertNoteAlert = 1,
   kAlertCautionAlert = 2,
   kAlertPlainAlert = 3
};

/*DialogItemIndex


typedef SInt16 DialogItemIndex;
Availability
Available in Mac OS X v10.0 and later.*/
typedef SInt16 DialogItemIndex;


/*DialogRef

typedef DialogPtr DialogRef;
Availability
Available in Mac OS X v10.0 and later.*/
typedef DialogPtr DialogRef;

/*ModalFilterProcPtr


typedef Boolean (*ModalFilterProcPtr)
(
   DialogRef theDialog,
   EventRecord * theEvent,
   DialogItemIndex * itemHit
);

If you name your function MyModalFilterProc, you would declare it like this:

Boolean MyModalFilterProc (
   DialogRef theDialog,
   EventRecord * theEvent,
   DialogItemIndex * itemHit
);
Parameters
theDialog

A pointer to a dialog structure for an alert box or a modal dialog box. 
theEvent

A pointer to an event structure returned by an Event Manager function such as WaitNextEvent. 
itemHit

A pointer to a short integer. Your event filter function should return a number corresponding to the position of an item in the item list resource for the alert or modal dialog box. 
Return Value

A Boolean value. After receiving an event that it does not handle, your function should return false. When your function returns false, ModalDialog handles the event, which you pass in the parameter theEvent. (Your function can also change the event to simulate a different event and return false, which passes the event to the Dialog Manager for handling.) If your function does handle the event, your function should return true, and through the itemHit parameter return the number of the item that it handled. 
Discussion

To supplement the Dialog Manager’s ability to handle events in the Mac OS multitasking environment, you should provide an event filter function that the Dialog Manager calls whenever it displays alert boxes and modal dialog boxes. This function can receive all events that are sent to your application.

The ModalDialog function and, in turn, the Alert , NoteAlert , StopAlert , and CautionAlert functions return the item number that your event filter function returns in the itemHit parameter in their own itemHit parameters. 

For alert and modal dialog boxes, the Dialog Manager provides a standard event filter function that checks whether
the user has pressed the Enter or Return key and, if so, returns the item number of the default button 
the user has pressed the Escape key or Command-period and, if so, returns the item number of the Cancel button 
the cursor is over edit text in a dialog box, and optionally changes the cursor to an I-beam whenever this is the case 

If the dialog box is movable modal and the kDialogHandleMovable bit is set, your filter function will receive all events (including apple events and update events) that your application receives. 

Your own filter function should use the standard filter function to accomplish these tasks. To do so, you can call GetStdFilterProc , and dispatch the event to the standard filter function yourself; or you can call StdFilterProc , which obtains a ModalFilterUPP for the standard filter function and then dispatches the function. 

Your event filter function should also perform the following tasks:
update your windows in response to update events and return false. If you do not handle update events for all the windows in your application, other processes won’t get time. 
return false for all events that your event filter function doesn’t handle 

You can also use the event filter function to test for and respond to keyboard equivalents and more complex events—for instance, the user dragging the cursor in an application- defined item. For example, if you provide an application-defined item that requires you to measure how long the user holds down the mouse button or how far the user drags the cursor, use the event filter function to handle events inside that item. 

Movable modal dialog boxes receive all events (not just those masked by the Event message mask). 

In all alert and dialog boxes, any buttons that are activated by key sequences should highlight to indicate which item has been selected. Use the Control Manager function HiliteControl to highlight a button for 8 ticks, long enough to be noticeable but not so long as to be annoying. The Control Manager performs this action whenever users click a button, and your application should do this whenever the user presses the keyboard equivalent of a button click.

For modal dialog boxes that contain edit text items, your application should handle menu bar access to allow use of your Edit menu and its Cut, Copy, Paste, Clear, and Undo commands. Your event filter function should then test for and handle clicks in your Edit menu and keyboard equivalents for the appropriate commands in your Edit menu. Your application should respond by using the functions DialogCut , DialogCopy , DialogPaste , and DialogDelete to support the Cut, Copy, Paste, and Clear commands.

For an alert box, you specify a universal procedure pointer to your event filter function in a parameter that you pass to the Alert , StopAlert , CautionAlert , and NoteAlert functions. For a modal dialog box, specify a pointer to your event filter function in a parameter that you pass to UpdateDialog.

The Dialog Manager defines the data type ModalFilterUPP to identify this application-defined function:

typedef UniversalProcPtr ModalFilterUPP; 

You typically use the NewModalFilterProc macro like this:

ModalFilterUPP myEventFilterProc;

myEventFilterProc = NewModalFilterProc(MyEventFilter);*/

typedef Boolean (*ModalFilterProcPtr)
(
   DialogRef theDialog,
   EventRecord * theEvent,
   DialogItemIndex * itemHit
);

/* ModalFilterUPP


typedef ModalFilterProcPtr ModalFilterUPP;
Discussion

For more information, see the description of the ModalFilterUPP () callback function.*/
typedef ModalFilterProcPtr ModalFilterUPP;

/*AlertType


typedef SInt16 AlertType;
Availability
Available in Mac OS X v10.0 and later.*/
typedef SInt16 AlertType;

/*AlertStdCFStringAlertParamRec

Defines an alert or sheet.

struct AlertStdCFStringAlertParamRec {
   UInt32 version;
   Boolean movable;
   Boolean helpButton;
   CFStringRef defaultText;
   CFStringRef cancelText;
   CFStringRef otherText;
   SInt16 defaultButton;
   SInt16 cancelButton;
   UInt16 position;
   OptionBits flags;
};
typedef struct AlertStdCFStringAlertParamRec AlertStdCFStringAlertParamRec;
typedef AlertStdCFStringAlertParamRec * AlertStdCFStringAlertParamPtr;
Fields
version

The version of this parameter record. Set this field to kStdCFStringAlertVersionOne.
movable

A Boolean value indicating whether or not the alert is movable.
helpButton

A Boolean value indicating whether or not the alert contains a Help button. 
defaultText

Text for button in the OK position. The button automatically sizes and positions itself in the alert box. To specify that the default button names should be used, pass -1 (see “Alert Default Text Constants” for values). To indicate that no button should be displayed, pass null
cancelText

Text for button in the Cancel position; see “Alert Default Text Constants”. The button automatically sizes and positions itself in the alert box. To specify that the default button names should be used, pass -1 see “Alert Default Text Constants” for values). To indicate that no button should be displayed, pass null.
otherText

Text for button in the other (leftmost) position; see “Alert Default Text Constants”. The button automatically sizes and positions itself in the alert box. To specify that the default button names should be used, pass -1. To indicate that no button should be displayed, pass null
defaultButton

Specifies which button acts as the default button; see “Alert Button Constants”.
cancelButton

Specifies which button acts as the default button; see “Alert Button Constants”.
position

The alert box position, as defined by a window positioning constant. In this structure, the constant kWindowDefaultPosition is equivalent to the constant kWindowAlertPositionParentWindowScreen. See the Window Manager Reference for other possible positioning constants. 
flags

Options for this alert. See “Standard Alert and Sheet Option Flags” for possible values.
Discussion

You pass this structure when calling CreateStandardAlert or CreateStandardSheet.
Availability
Available in Mac OS X v10.0 and later.*/
struct AlertStdCFStringAlertParamRec {
   UInt32 version;
   Boolean movable;
   Boolean helpButton;
   CFStringRef defaultText;
   CFStringRef cancelText;
   CFStringRef otherText;
   SInt16 defaultButton;
   SInt16 cancelButton;
   UInt16 position;
   OptionBits flags;
};
typedef struct AlertStdCFStringAlertParamRec AlertStdCFStringAlertParamRec;
typedef AlertStdCFStringAlertParamRec * AlertStdCFStringAlertParamPtr;

/*RunStandardAlert

Shows and runs a standard alert using a modal dialog loop.

OSStatus RunStandardAlert (
   DialogRef inAlert,
   ModalFilterUPP filterProc,
   DialogItemIndex * outItemHit
);
Parameters
inAlert

The alert to display. Note that this function automatically disposes of the dialog you pass in this parameter before returning. 
filterProc

An event filter function for handling events that do not apply to the alert. May be NULL. 
outItemHit

On exit, contains the item index of the button that was pressed to close the alert. 
Return Value

A result code. See “Dialog Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Dialogs.h*/
OSStatus RunStandardAlert (
   DialogRef inAlert,
   ModalFilterUPP filterProc,
   DialogItemIndex * outItemHit
);

/*CreateStandardAlert

Creates an alert containing standard elements and using standard formatting rules.

OSStatus CreateStandardAlert (
   AlertType alertType,
   CFStringRef error,
   CFStringRef explanation,
   const AlertStdCFStringAlertParamRec * param,
   DialogRef * outAlert
);
Parameters
alertType

The type of alert to create. 
error

The error string to display. 
explanation

The explanation string to display. May be NULL or empty to display no explanation.
param

The parameter block describing how to create the alert. May be NULL. 
outAlert

On exit, contains the new alert. 
Return Value

A result code. See “Dialog Manager Result Codes”.
Discussion

CreateStandardAlert should be used in conjunction with RunStandardAlert. After CreateStandardAlert returns, the alert is still invisible. RunStandardAlert will show the alert and run a modal dialog loop to process events in the alert.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Dialogs.h*/
OSStatus CreateStandardAlert (
   AlertType alertType,
   CFStringRef error,
   CFStringRef explanation,
   const AlertStdCFStringAlertParamRec * param,
   DialogRef * outAlert
);


#ifdef __cplusplus
}
#endif

#endif