#ifndef CONTROLDEFINITIONS_H
#define CONTROLDEFINITIONS_H


#ifndef APPLICATIONSERVICES_H
#include <ApplicationServices/ApplicationServices.h>
#endif

#ifndef APPEARANCE_H
#include <HIToolbox/Appearance.h>
#endif

#ifndef CARBONEVENTS_H
#include <HIToolbox/CarbonEvents.h>
#endif

#ifndef CONTROLS_H
#include <HIToolbox/Controls.h>
#endif

#ifndef LISTS_H
#include <HIToolbox/Lists.h>
#endif

#ifndef MACHELP_H
#include <HIToolbox/MacHelp.h>
#endif

#ifndef MENUS_H
#include <HIToolbox/Menus.h>
#endif





#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Tab Control Info Tag Constant

enum {
   kControlTabInfoTag = 'tabi'
};
Constants
kControlTabInfoTag

Gets or sets information for a tab in a tab control; see ControlTabInfoRec.

Data type returned or set: ControlTabInfoRec.

Available in Mac OS X v10.0 and later.
Discussion

You can use this control data tag constant to set or obtain data that is associated with a control. This constant is passed in the inTagName parameters of SetControlData and GetControlData to specify the piece of data in a control that you wish to set or get. You can also pass this constant in the inTagName parameter of GetControlDataSize if you wish to determine the size of variable-length control data. This constant can also be used by custom control definition functions that return the feature bit kControlSupportsDataAccess in response to a kControlMsgGetFeatures message. 

The data that your application sets or obtains can be of various types, dependent upon the control. Therefore, the description of this control data tag constant lists the data type for the information that you can set in the inData parameter to the SetControlData function and that you can get in the inBuffer parameter to the GetControlData function. 
Version Notes

This control data tag constant is available with Appearance Manager 1.0.1 and later.*/
enum {
   kControlTabInfoTag = 'tabi'
};

/*Control Tab Info Version Constants

enum {
   kControlTabInfoVersionZero = 0,
   kControlTabInfoVersionOne = 1
};*/
enum {
   kControlTabInfoVersionZero = 0,
   kControlTabInfoVersionOne = 1
};

/*ControlTabInfoRecV1

struct ControlTabInfoRecV1 {
   SInt16 version;
   SInt16 iconSuiteID;
   CFStringRef name;
};
typedef struct ControlTabInfoRecV1 ControlTabInfoRecV1;
Availability
Available in Mac OS X v10.0 and later.*/
struct ControlTabInfoRecV1 {
   SInt16 version;
   SInt16 iconSuiteID;
   CFStringRef name;
};
typedef struct ControlTabInfoRecV1 ControlTabInfoRecV1;

/*ControlTabEntry

struct ControlTabEntry {
   ControlButtonContentInfo * icon;
   CFStringRef name;
   Boolean enabled;
};
typedef struct ControlTabEntry ControlTabEntry;
Availability
Available in Mac OS X v10.0 and later.*/
struct ControlTabEntry {
   ControlButtonContentInfo * icon;
   CFStringRef name;
   Boolean enabled;
};
typedef struct ControlTabEntry ControlTabEntry;

/*Control Tab Direction Constants

typedef UInt16 ControlTabDirection;
enum {
   kControlTabDirectionNorth = 0,
   kControlTabDirectionSouth = 1,
   kControlTabDirectionEast = 2,
   kControlTabDirectionWest = 3
};*/
typedef UInt16 ControlTabDirection;
enum {
   kControlTabDirectionNorth = 0,
   kControlTabDirectionSouth = 1,
   kControlTabDirectionEast = 2,
   kControlTabDirectionWest = 3
};

/*Control Tab Size Constants

typedef UInt16 ControlTabSize;
enum {
   kControlTabSizeLarge = kControlSizeNormal,
   kControlTabSizeSmall = kControlSizeSmall
};*/
typedef UInt16 ControlTabSize;
enum {
   kControlTabSizeLarge = kControlSizeNormal,
   kControlTabSizeSmall = kControlSizeSmall
};

/*Static Text Control Data Tag Constants

enum {
   kControlStaticTextStyleTag = kControlFontStyleTag,
   kControlStaticTextTextTag = 'text',
   kControlStaticTextTextHeightTag = 'thei',
   kControlStaticTextTruncTag = 'trun',
   kControlStaticTextCFStringTag = 'cfst',
   kControlStaticTextIsMultilineTag = 'stim'
};
Constants
kControlStaticTextTextTag

Gets or sets text in a static text control. 

Data type returned or set: character buffer.

Available with Appearance Manager 1.0 and later.
kControlStaticTextTextHeightTag

Gets the height of text in a static text control. Available with Appearance Manager 1.0 and later.

Data type returned or set:SInt16

Available in Mac OS X v10.0 and later.
kControlStaticTextTruncTag

Gets or sets the control’s text truncation style. Truncation will not occur unless kControlStaticTextIsMultilineTag is set to false. 

Data type returned or set: TruncCode. The value truncEnd indicates that characters are truncated off the end of the string; the value truncMiddle indicates that characters are truncated from the middle of the string. Default is a value of -1, which indicates that no truncation occurs and the text is wrapped instead.

Available with Appearance Manager 1.1 (Mac OS 8.5) and later.

Available in Mac OS X v10.0 and later.
kControlStaticTextCFStringTag

Gets or sets the control’s current text. When setting the text, the control retains the string, so you may release the string after calling SetControlData. If the string you set is mutable, the control will make a copy of the string, so any changes to the string after calling SetControlData will not affect the control. When retrieving the text, the control retains the string before returning it to you, so you must release the string after you are done with it. 

Data type returned or set: CFStringRef

Available in CarbonLib 1.5 and later, and Mac OS X v10.0 and later.

Available in Mac OS X v10.0 and later.
kControlStaticTextIsMultilineTag

Gets or sets a flag specifying whether the control draws its text in multiple lines if the text is too wide for the control bounds. If false, the control always draws the text in a single line. 

Data type returned or set: Boolean

Available in Mac OS X v10.1 and later.
Discussion

You can use the control data tag constants to set or obtain data that is associated with a control. The control data tag constants are passed in the inTagName parameters of SetControlData and GetControlData to specify the piece of data in a control that you wish to set or get. You can also pass these constants in the inTagName parameter of GetControlDataSize if you wish to determine the size of variable-length control data. These constants can also be used by custom control definition functions that return the feature bit kControlSupportsDataAccess in response to a kControlMsgGetFeatures message. 

The data that your application sets or obtains can be of various types, dependent upon the control. Therefore, the descriptions of the control data tag constants list the data types for the information that you can set in the inData parameter to the SetControlData function and that you can get in the inBuffer parameter to the GetControlData function.*/
enum {
   kControlStaticTextStyleTag = 'kControlFontStyleTag',
   kControlStaticTextTextTag = 'text',
   kControlStaticTextTextHeightTag = 'thei',
   kControlStaticTextTruncTag = 'trun',
   kControlStaticTextCFStringTag = 'cfst',
   kControlStaticTextIsMultilineTag = 'stim'
};

/*CreateTabsControl

Creates a tabs control.

OSStatus CreateTabsControl (
   WindowRef window,
   const Rect * boundsRect,
   ControlTabSize size,
   ControlTabDirection direction,
   UInt16 numTabs,
   const ControlTabEntry * tabArray,
   ControlRef * outControl
);
Parameters
window

The window in which the control is to be placed. This parameter may be NULL in Mac OS X v10.3 and later.
boundsRect

The bounds of the control in the window’s local coordinates.
size

The control tab size. See Control Tab Size Constants for possible values.
direction

The control tab direction. See Control Tab Direction Constants for possible values.
numTabs

The initial number of tabs.
tabArray

Information about each tab. There must be the same number of entries as specified by the numTabs parameter.
outControl

On return, the new control. For a description of this data type, see “ControlRef”.
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

If you want to customize the accessibility information provided for individual tabs of a tabs control, such as by handling various kEventClassAccessibility Carbon Events and by calling HIObjectSetAuxiliaryAccessibilityAttribute, you need to know how to build or interpret AXUIElement reference that represent individual tabs. The AXUIElement representing an individual tab must be constructed using the tab control’s ControlRef and the UInt64 identifier of the one-based index of the tab to which the element refers. A UInt64 identifier of 0 represents the tabs control as a whole. You cannot interpret or create tab control elements whose identifiers are greater than the count of tabs in the tabs control.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus CreateTabsControl (
   WindowRef window,
   const Rect * boundsRect,
   ControlTabSize size,
   ControlTabDirection direction,
   UInt16 numTabs,
   const ControlTabEntry * tabArray,
   ControlRef * outControl
);

/*CreateUserPaneControl

Creates a user pane control.

OSStatus CreateUserPaneControl (
   WindowRef window,
   const Rect * boundsRect,
   UInt32 features,
   ControlRef * outControl
);
Parameters
window

The window in which the control is to be placed. This parameter may be NULL in Mac OS X v10.3 and later.
boundsRect

The bounds of the control in the window’s local coordinates.
features

The user pane features with which the user pane is to be created. For possible constants, see “Control Features Constants”. 
outControl

On return, the new control. For a description of this data type, see “ControlRef”.
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

User panes have two primary purposes: to allow easy implementation of a custom control by the developer, and to provide a generic container for embedding other controls.

In Carbon, with the advent of Carbon-event-based controls, you may find it easier to write a new control from scratch than to customize a user pane control. The set of callbacks provided by the user pane will not be extended to support new Control Manager features; instead, you should just write a real control.User panes do not, by default, support embedding. If you try to embed a control into a user pane, you will get the errControlIsNotEmbedder. You can make a user pane support embedding by passing the kControlSupportsEmbedding flag in the features parameter when you create the control.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus CreateUserPaneControl (
   WindowRef window,
   const Rect * boundsRect,
   UInt32 features,
   ControlRef * outControl
);

/*CreateStaticTextControl

Creates a new static text control.

OSStatus CreateStaticTextControl (
   WindowRef window,
   const Rect * boundsRect,
   CFStringRef text,
   const ControlFontStyleRec * style,
   ControlRef * outControl
);
Parameters
window

The window in which the control is to be placed. This parameter may be NULL in Mac OS X v10.3 and later.
boundsRect

The bounds of the control in the window’s local coordinates.
text

The text of the control. May be NULL.
style

The control’s font style, size, color, and so on. May be NULL.
outControl

On return, the new control. For a description of this data type, see “ControlRef”.
Return Value

A result code. See “Control Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus CreateStaticTextControl (
   WindowRef window,
   const Rect * boundsRect,
   CFStringRef text,
   const ControlFontStyleRec * style,
   ControlRef * outControl
);

/*CreatePushButtonControl

Creates a push button control.

OSStatus CreatePushButtonControl (
   WindowRef window,
   const Rect * boundsRect,
   CFStringRef title,
   ControlRef * outControl
);
Parameters
window

The window in which the control is to be placed. This parameter may be NULL in Mac OS X v10.3 and later.
boundsRect

The bounds of the control in the window’s local coordinates.
title

The control title. May be NULL.
outControl

On return, the new control. For a description of this data type, see “ControlRef”.
Return Value

A result code. See “Control Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/

OSStatus CreatePushButtonControl (
   WindowRef window,
   const Rect * boundsRect,
   CFStringRef title,
   ControlRef * outControl
);

#ifdef __cplusplus
}
#endif

#endif