#ifndef CARBONEVENTS_H
#define CARBONEVENTS_H

#ifndef APPLICATIONSERVICES_H
#include <ApplicationServices/ApplicationServices.h>
#endif

#ifndef CARBONEVENTSCORE_H
#include <HIToolbox/CarbonEventsCore.h>
#endif

#ifndef EVENTS_H
#include <HIToolbox/Events.h>
#endif

#ifndef MENUS_H
#include <HIToolbox/Menus.h>
#endif

#ifndef CONTROLS_H
#include <HIToolbox/Controls.h>
#endif

#ifndef MACWINDOWS_H
#include <HIToolbox/MacWindows.h>
#endif

#include <HYS/HIToolbox/CarbonEvents.h>
#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Command Event Source Constants

Define constants for the user interface element that produced an HICommand event.

enum {
   kHICommandFromMenu = (1L << 0),
   kHICommandFromControl = (1L << 1),
   kHICommandFromWindow = (1L << 2)
};
Constants
kHICommandFromMenu

This bit is set for commands generated from menu items in all versions of CarbonLib and Mac OS X.

Available in Mac OS X v10.0 and later.
kHICommandFromControl

The command event originated from a control. This bit was introduced in Mac OS X v10.2 and CarbonLib 1.6; it is never set in earlier versions of Mac OS X or CarbonLib.

Available in Mac OS X v10.2 and later.
kHICommandFromWindow

The command event originated from a window. This bit was introduced in Mac OS X v10.2 and CarbonLib 1.6; it is never set in earlier versions of Mac OS X or CarbonLib.

Available in Mac OS X v10.2 and later.*/
enum {
   kHICommandFromMenu = (1L << 0),
   kHICommandFromControl = (1L << 1),
   kHICommandFromWindow = (1L << 2)
};

/*HICommandExtended

Represents an extended command event.

struct HICommandExtended {
   UInt32 attributes;
   UInt32 commandID;
   union {
      controlRef control;
      windowRef window;
      struct {
         MenuRef menuRef;
         MenuItemIndex menuItemIndex;
      } menu;
   } source;
};
typedef struct HICommandExtended HICommandExtended;
Fields
attributes

Attributes of the command event. The value of this field (indicating whether the source of the command event is a control, window, or menu) determines what reference is stored in the union. See “Command Event Source Constants” for a list of possible values. 
commandID

The command ID of the command event.
controlRef

The control that produced the command event.
windowRef

The window that produced the command event. 
menuRef

A reference to the menu containing the command event.
menuItemIndex

The index number of the menu item containing the command event.
Discussion

The HICommandExtended structure was introduced in Mac OS X v10.2 and CarbonLib 1.6. Because the HICommand and HICommandExtended structures are exactly the same size and have the same fields at the same offsets, you can use an HICommandExtended structure at runtime while running on any version of CarbonLib or Mac OS X. The only difference is that the HICommandExtended structure has a union that allows you to get type-safe access to the source object. The originator of the command determines whether the structure actually contains a ControlRef, WindowRef, MenuRef, or nothing at all. You can determine what is in the command by checking the attributes field.

For example, in Mac OS X v10.2 and later, when a push button is clicked, the Control Manager sends a command event containing the push button’s command ID, sets the kHICommandFromControl bit in the attributes field, and stores the button’s ControlRef in the source.control field. In Mac OS X v10.0 and v10.1, the same command event is sent, but the kHICommandFromControl, kHICommandFromMenu, and kHICommandFromWindow attributes are not set, and the source.controlRef, source.menu.menuRef and source.windowRef fields are not initialized, respectively. Your code can use an HICommandExtended structure when running on Mac OS X v10.0 and v10.1 as long as it first checks the kHICommandFromControl, kHICommandFromMenu, and kHICommandFromWindow attributes before accessing the source.control, menu.control, and window.control fields.
Availability
Available in Mac OS X v10.2 and later.*/
struct HICommandExtended {
   UInt32 attributes;
   UInt32 commandID;
   union {
      ControlRef control;
      WindowRef window;
      struct {
         MenuRef menuRef;
         MenuItemIndex menuItemIndex;
      } menu;
   } source;
};
typedef struct HICommandExtended HICommandExtended;

/*Object Reference Parameters and Types

Define constants for parameters that specify various objects and their types.

enum {
   kEventParamWindowRef = 'wind',
   kEventParamGrafPort = 'graf',
   kEventParamDragRef = 'drag',
   kEventParamMenuRef = 'menu',
   kEventParamEventRef = 'evnt',
   kEventParamControlRef = 'ctrl',
   kEventParamRgnHandle = 'rgnh',
   kEventParamEnabled = 'enab',
   kEventParamDimensions = 'dims',
   kEventParamBounds = 'boun',
   kEventParamAvailableBounds = 'avlb',
   kEventParamAEEventID = keyAEEventID,
   kEventParamAEEventClass = keyAEEventClass,
   kEventParamCGContextRef = 'cntx',
   kEventParamDeviceDepth = 'devd',
   kEventParamDeviceColor = 'devc',
   kEventParamMutableArray = 'marr',
   kEventParamResult = 'ansr',
   kEventParamMinimumSize = 'mnsz',
   kEventParamMaximumSize = 'mxsz',
   kEventParamAttributes = 'attr',
   kEventParamReason = 'why?',
   kEventParamTransactionID = 'trns',
   kEventGDevice = 'gdev',
   kEventParamIndex = 'indx',
   kEventParamUserData = 'usrd',
   kEventParamShape = 'shap',
   typeWindowRef = 'wind',
   typeGrafPtr = 'graf',
   typeGWorldPtr = 'gwld',
   typeDragRef = 'drag',
   typeMenuRef = 'menu',
   typeControlRef = 'ctrl',
   typeCollection = 'cltn',
   typeQDRgnHandle = 'rgnh',
   typeOSStatus = 'osst',
   typeCFIndex = 'cfix',
   typeCFStringRef = 'cfst',
   typeCFMutableStringRef = 'cfms',
   typeCFTypeRef = 'cfty',
   typeCGContextRef = 'cntx',
   typeHIPoint = 'hipt',
   typeHISize = 'hisz',
   typeHIRect = 'hirc',
   typeHIShapeRef = 'shap',
   typeVoidPtr = 'void',
   typeGDHandle = 'gdev'
};
Constants
kEventParamWindowRef

A window reference. (typeWindowRef)

Available in Mac OS X v10.0 and later.
kEventParamGrafPort

typeGrafPtr

Available in Mac OS X v10.0 and later.
kEventParamDragRef

typeDragRef

Available in Mac OS X v10.0 and later.
kEventParamMenuRef

typeMenuRef

Available in Mac OS X v10.0 and later.
kEventParamEventRef

typeEventRef

Available in Mac OS X v10.0 and later.
kEventParamControlRef

typeControlRef

Available in Mac OS X v10.0 and later.
kEventParamRgnHandle

typeQDRgnHandle

Available in Mac OS X v10.0 and later.
kEventParamEnabled

typeBoolean

Available in Mac OS X v10.0 and later.
kEventParamDimensions

typeQDPoint

Available in Mac OS X v10.0 and later.
kEventParamBounds

typeQDRectangle

Available in Mac OS X v10.3 and later.
kEventParamAvailableBounds

typeQDRectangle

Available in Mac OS X v10.0 and later.
kEventParamAEEventID

typeType

Available in Mac OS X v10.0 and later.
kEventParamAEEventClass

typeType

Available in Mac OS X v10.0 and later.
kEventParamCGContextRef

typeCGContextRef

Available in Mac OS X v10.0 and later.
kEventParamDeviceDepth

typeShortInteger

Available in Mac OS X v10.1 and later.
kEventParamDeviceColor

typeBoolean

Available in Mac OS X v10.1 and later.
kEventParamMutableArray

typeCFMutableArrayRef

Available in Mac OS X v10.2 and later.
kEventParamResult

Any type, depending on the event

Available in Mac OS X v10.2 and later.
kEventParamMinimumSize

typeHISize

Available in Mac OS X v10.2 and later.
kEventParamMaximumSize

typeHISize

Available in Mac OS X v10.2 and later.
kEventParamAttributes

typeUInt32

Available in Mac OS X v10.0 and later.
kEventParamReason

typeUInt32

Available in Mac OS X v10.3 and later.
kEventParamTransactionID

typeUInt32

Available in Mac OS X v10.3 and later.
kEventParamGDevice

typeGDHandle

Available in Mac OS X v10.3 and later.
kEventParamIndex

typeCFIndex

Available in Mac OS X v10.3 and later.
kEventParamUserData

typeVoidPtr

Available in Mac OS X v10.3 and later.
kEventParamShape

typeHIShapeRef

Available in Mac OS X v10.4 and later.
typeWindowRef

WindowRef

Available in Mac OS X v10.0 and later.
typeGrafPtr

CGrafPtr

Available in Mac OS X v10.0 and later.
typeGWorldPtr

GWorldPtr

Available in Mac OS X v10.0 and later.
typeDragRef

DragRef

Available in Mac OS X v10.0 and later.
typeMenuRef

MenuRef

Available in Mac OS X v10.0 and later.
typeControlRef

ControlRef

Available in Mac OS X v10.0 and later.
typeCollection

Collection

Available in Mac OS X v10.0 and later.
typeQDRgnHandle

RgnHandle

Available in Mac OS X v10.0 and later.
typeOSStatus

OSStatus

Available in Mac OS X v10.0 and later.
typeCFIndex

CFIndex

Available in Mac OS X v10.2 and later.
typeCFStringRef

CFStringRef

Available in Mac OS X v10.1 and later.
typeCFMutableStringRef

CFMutableStringRef

Available in Mac OS X v10.2 and later.
typeCFTypeRef

CFTypeRef

Available in Mac OS X v10.2 and later.
typeCGContextRef

CGContextRef

Available in Mac OS X v10.0 and later.
typeHIPoint

HIPoint

Available in Mac OS X v10.1 and later.
typeHISize

HISize

Available in Mac OS X v10.2 and later.
typeHIRect

HIRect

Available in Mac OS X v10.2 and later.
typeHIShapeRef

HIShapeRef

Available in Mac OS X v10.4 and later.
typeVoidPtr

Void

Available in Mac OS X v10.2 and later.
typeGDHandle

GDHandle

Available in Mac OS X v10.3 and later.
Discussion

You specify these parameters to obtain references to various objects such as windows, controls, graphics ports, and so on. See the various event kinds to determine the parameters available for each event. For example, Table 8 in “Mouse Events” lists the various parameters used in mouse events.*/
enum {
   kEventParamWindowRef = 'wind',
   kEventParamGrafPort = 'graf',
   kEventParamDragRef = 'drag',
   kEventParamMenuRef = 'menu',
   kEventParamEventRef = 'evnt',
   kEventParamControlRef = 'ctrl',
   kEventParamRgnHandle = 'rgnh',
   kEventParamEnabled = 'enab',
   kEventParamDimensions = 'dims',
   kEventParamBounds = 'boun',
   kEventParamAvailableBounds = 'avlb',
   kEventParamAEEventID = keyAEEventID,
   kEventParamAEEventClass = keyAEEventClass,
   kEventParamCGContextRef = 'cntx',
   kEventParamDeviceDepth = 'devd',
   kEventParamDeviceColor = 'devc',
   kEventParamMutableArray = 'marr',
   kEventParamResult = 'ansr',
   kEventParamMinimumSize = 'mnsz',
   kEventParamMaximumSize = 'mxsz',
   kEventParamAttributes = 'attr',
   kEventParamReason = 'why?',
   kEventParamTransactionID = 'trns',
   kEventGDevice = 'gdev',
   kEventParamIndex = 'indx',
   kEventParamUserData = 'usrd',
   kEventParamShape = 'shap',
   typeWindowRef = 'wind',
   typeGrafPtr = 'graf',
   typeGWorldPtr = 'gwld',
   typeDragRef = 'drag',
   typeMenuRef = 'menu',
   typeControlRef = 'ctrl',
   typeCollection = 'cltn',
   typeQDRgnHandle = 'rgnh',
   typeOSStatus = 'osst',
   typeCFIndex = 'cfix',
   typeCFStringRef = 'cfst',
   typeCFMutableStringRef = 'cfms',
   typeCFTypeRef = 'cfty',
   typeCGContextRef = 'cntx',
   typeHIPoint = 'hipt',
   typeHISize = 'hisz',
   typeHIRect = 'hirc',
   typeHIShapeRef = 'shap',
   typeVoidPtr = 'void',
   typeGDHandle = 'gdev'
};

/*Keyboard Event Parameters and Types

Define constants for parameters to raw keyboard events.

enum {
   kEventParamKeyCode = 'kcod',
   kEventParamKeyMacCharCodes = 'kchr',
   kEventParamKeyModifiers = 'kmod',
   kEventParamKeyUnicodes = 'kuni',
   kEventParamKeyboardType = 'kbdt',
   typeEventHotKeyID = 'hkid'
};
Constants
kEventParamKeyCode

typeUInt32

Available in Mac OS X v10.0 and later.
kEventParamKeyMacCharCodes

typeChar

Available in Mac OS X v10.0 and later.
kEventParamKeyModifiers

typeUInt32

Available in Mac OS X v10.0 and later.
kEventParamKeyUnicodes

typeUnicodeText

Available in Mac OS X v10.0 and later.
typeEventHotKeyID

EventHotKeyID

Available in Mac OS X v10.0 and later.*/
enum {
   kEventParamKeyCode = 'kcod',
   kEventParamKeyMacCharCodes = 'kchr',
   kEventParamKeyModifiers = 'kmod',
   kEventParamKeyUnicodes = 'kuni',
   kEventParamKeyboardType = 'kbdt',
   typeEventHotKeyID = 'hkid'
};


/*Control Event Constants

Define constants related to events from kEventClassControl.

enum {
   kEventControlInitialize = 1000,
   kEventControlDispose = 1001,
   kEventControlGetOptimalBounds = 1003,
   kEventControlDefInitialize = kEventControlInitialize,
   kEventControlDefDispose = kEventControlDispose,
   kEventControlHit = 1,
   kEventControlSimulateHit = 2,
   kEventControlHitTest = 3,
   kEventControlDraw = 4,
   kEventControlApplyBackground = 5,
   kEventControlApplyTextColor = 6,
   kEventControlSetFocusPart = 7,
   kEventControlGetFocusPart = 8,
   kEventControlActivate = 9,
   kEventControlDeactivate = 10,
   kEventControlSetCursor = 11,
   kEventControlContextualMenuClick = 12,
   kEventControlClick = 13,
   kEventControlGetNextFocusCandidate = 14,
   kEventControlGetAutoToggleValue = 15,
   kEventControlInterceptSubviewClick = 16,
   kEventControlGetClickActivation = 17,
   kEventControlDragEnter = 18,
   kEventControlDragWithin = 19,
   kEventControlDragLeave = 20,
   kEventControlDragReceive = 21,
   kEventControlTrack = 51,
   kEventControlGetScrollToHereStartPoint = 52,
   kEventControlGetIndicatorDragConstraint = 53,
   kEventControlIndicatorMoved = 54,
   kEventControlGhostingFinished = 55,
   kEventControlGetActionProcPart = 56,
   kEventControlGetPartRegion = 101,
   kEventControlGetPartBounds = 102,
   kEventControlSetData = 103,
   kEventControlGetData = 104,
   kEventControlGetSizeConstraints = 105,
   kEventControlValueFieldChanged = 151,
   kEventControlAddedSubControl = 152,
   kEventControlRemovingSubControl = 153,
   kEventControlBoundsChanged = 154,
   kEventControlTitleChanged = 158,
   kEventControlOwningWindowChanged = 159,
   kEventControlHiliteChanged = 160,
   kEventControlEnabledStateChanged = 161,
   kEventControlArbitraryMessage = 201
};
Constants
kEventControlInitialize

Sent when a control is created. Allows the control to initialize private data. 

Available in Mac OS X v10.0 and later.
kEventControlDispose

Sent when a control is disposed. Allows the control to dispose of private data. 

Available in Mac OS X v10.0 and later.
kEventControlGetOptimalBounds

Allows the control to report its best size and its text baseline based on its current settings. You should set the kEventParamControlOptimalBounds parameter to an appropriate rectangle. You should also set the kEventParamControlOptimalBaselineOffset parameter to be the offset from the top of your optimal bounds of a text baseline, if any. (Mac OS X only) 

Available in Mac OS X v10.0 and later.
kEventControlDefInitialize

Same as kEventControlInitialize. You can use this event when creating custom control definitions. 

Available in Mac OS X v10.0 and later.
kEventControlDefDispose

Same as kEventControlDispose. You can use this event when creating custom control definitions.

Available in Mac OS X v10.0 and later.
kEventControlHit

Sent by the Control Manager functions TrackControl and HandleControlClick after handling a click in a control. If you do not handle this event, and the control has a command ID associated with it, then the Control Manager sends a kEventCommandProcess event to the control. 

Available in Mac OS X v10.0 and later.
kEventControlSimulateHit

Sent when your control should simulate a click in response to some other action, such as a return key for a default button. The default behavior is to use the Control Manager function HiliteControl to highlight and unhighlight the part specified in the kEventParamControlPart parameter (simulating the hit) and then call the control’s action callback function. (Mac OS X only) 

Available in Mac OS X v10.0 and later.
kEventControlHitTest

Sent when someone wants to find out what part of your control is at a given point in local coordinates. You should set the kEventParamControlPart parameter to the appropriate part. (Mac OS X only) 

Available in Mac OS X v10.0 and later.
kEventControlDraw

Sent when your control should draw itself. The event can optionally contain parameters indicating which port to draw into and which part to constrain drawing to. (Mac OS X only) 

Available in Mac OS X v10.0 and later.
kEventControlApplyBackground

Sent when your control should apply its background color/pattern to the port specified so the subcontrol can properly erase. The port is optional; if it does not exist you should apply the background to the current port. Note that if you don’t handle this event, the event is propagated to the control’s parent. (Mac OS X only) 

Available in Mac OS X v10.0 and later.
kEventControlApplyTextColor

Sent when your control should apply a color/pattern to the specified port and context so a subcontrol can draw text which looks appropriate for your control’s background. The port is optional; if it does not exist, you should apply the text color to the current port. The context is also optional. (Mac OS X only) 

Available in Mac OS X v10.0 and later.
kEventControlSetFocusPart

Sent when your control is gaining, losing, or changing the focus. Set the focus to the part indicated by the kEventParamControlPart parameter. (Mac OS X only) 

Available in Mac OS X v10.0 and later.
kEventControlGetFocusPart

Sent when your the Control Manager wants to know what part of your control is currently focused. Set the kEventParamControlPart parameter to your currently focused part. If you don’t handle this event, the Control Manager sets the part parameter to the last part that was focused (or no part if the control lost focus). (Mac OS X only) 

Available in Mac OS X v10.0 and later.
kEventControlActivate

Sent when your control becomes active as a result of a call to ActivateControl. (Mac OS X only) 

Available in Mac OS X v10.0 and later.
kEventControlDeactivate

Sent when your control becomes inactive as a result of a call to DeactivateControl. (Mac OS X only) 

Available in Mac OS X v10.0 and later.
kEventControlSetCursor

Sent when your control is asked to change the cursor as a result of a call to the Control Manager function HandleControlSetCursor. (Mac OS X only) 

Available in Mac OS X v10.0 and later.
kEventControlContextualMenuClick

Sent when your control is asked to display a contextual menu as a result of a call to the Control Manager function HandleControlContextualMenuClick. (Mac OS X only) 

Available in Mac OS X v10.0 and later.
kEventControlClick

A mouse down occurred in a control. The standard window handler sets the keyboard focus to the control if it takes focus on clicks, and calls the Control Manager function HandleControlClick.

Available in Mac OS X and CarbonLib 1.3.1 and later.
kEventControlGetNextFocusCandidate

Sent to allow a control to customize the focus order of its subcontrols. The current subcontrol with focus is stored in the kEventParamStartControl parameter. The desired focus direction is indicated by the kControlFocusNextPart or kControlFocusPrevPart constants, passed to you in the kEventParamControlPart parameter. The handler should return the next subcontrol in the kEventParamNextControl parameter. If the kEventParamStartControl parameter is NULL, return the first subcontrol in the specified focus direction. If no next subcontrol exists in the desired focus direction, return NULL or omit the kEventParamNextControl parameter. 

The default behavior is to return the “most appropriate” peer control, which currently means the previous control in the ordering scheme. 

(Available in Mac OS X v10.2 and later.)

Available in Mac OS X v10.2 and later.
kEventControlGetAutoToggleValue

Sent when the system wants to auto-toggle a control. You can specify the value to use based on the current value of your control. 

If the control has the kControlAutoToggles feature bit set, then the default behavior is as follows:
If the control does not behave like a radio button (the kControlHasRadioBehavior feature bit is not set), and its value is 1, then the kEventParamControlValue parameter is set to 0. 
If the control’s value is anything other than 1, the kEventParamControlValue parameter is set to 0. 

Otherwise, there is no default behavior. 

(Available in Mac OS X v10.2 and later.)

Available in Mac OS X v10.2 and later.
kEventControlInterceptSubviewClick

Sent when the HIViewGetViewForMouseClick function is called (typically by the Control Manager before it descends into subviews). A view can use this event to intercept mouse clicks that would normally be destined for one of its subviews. For example, the Toolbar control uses this event to intercept command-clicks so that it can handle dragging of its children. If the command key is down, the user wants to drag, so the handler returns noErr to indicate that this view (the Toolbar) should receive the click, not the child that was actually under the mouse. 

(Available in Mac OS X v10.2 and later.)

Available in Mac OS X v10.2 and later.
kEventControlGetClickActivation

Sent when a mouse click occurs in a background (inactive) control. This event is essentially the control version of kEventWindowGetClickActivation. The only differences are that the mouse location is view-relative and no window part parameter is passed to you. 

This event is sent only when the standard window handler is installed. The default behavior is to activate the view and absorb the mouse click (that is, the click is not passed on to the view).

(Available in Mac OS X v10.2 and later.)

Available in Mac OS X v10.2 and later.
kEventControlDragEnter

Sent when a drag item enters a view’s bounds. If you want to respond to the drag, your drag entered handler must return noErr If you return eventNotHandledErr then you will not receive further drag events, nor will you be able to receive the drag item. 

(Available in Mac OS X v10.2 and later.)

Available in Mac OS X v10.2 and later.
kEventControlDragWithin

Sent when a drag item has moved while in the view’s bounds (but not within any of its subviews). If the drag subsequently enters a subview, all additional drag events are directed to that subview. 

(Available in Mac OS X v10.2 and later.)

Available in Mac OS X v10.2 and later.
kEventControlDragLeave

Sent when a drag item leaves your view. You can use this event to unhighlight your view, and so on. (Available in Mac OS X v10.2 and later.)

Available in Mac OS X v10.2 and later.
kEventControlDragReceive

Sent when a drag item is dropped within your view. (Available in Mac OS X v10.2 and later.)

Available in Mac OS X v10.2 and later.
kEventControlTrack

Sent to allow your control to completely replace the normal tracking that is part of a call to the Control Manager functions TrackControl or HandleControlClick. Set the kEventParamControlPart to the part hit during tracking.

This event is sent only to controls that return a non-zero control part code from kEventControlHitTest. If you are implementing a custom HIView and you need to receive this event, you must also handle kEventControlHitTest. The hit-test handler must place a valid control part code into the kEventParamControlPart parameter and return noErr. 

The default behavior is to implement indicator tracking (if the mouse is down in an indicator part, such as for a scroll bar) or one-part tracking (if the mouse is down in a button or similar part). If the tracking is successful, the Control Manager passes back the part that was hit. 

(Available in Mac OS X only)

Available in Mac OS X v10.0 and later.
kEventControlGetScrollToHereStartPoint

Sent so your control can support “Scroll To Here” behavior during tracking. Set the kEventParamMouseLocation parameter to the mouse location in local coordinates which represents where a click would have needed to be to cause your indicator to be dragged to the incoming mouse location. (Mac OS X only) 

Available in Mac OS X v10.0 and later.
kEventControlGetIndicatorDragConstraint

Sent so your control can constrain the movement of its indicator during tracking. Set the kEventParamControlIndicatorDragConstraint parameter to the appropriate constraint. (Mac OS X only) 

Available in Mac OS X v10.0 and later.
kEventControlIndicatorMoved

Sent during live-tracking of the indicator so your control can update its value based on the new indicator position. During non-live tracking, this event lets you redraw the indicator ghost at the appropriate place. (Mac OS X only) 

Available in Mac OS X v10.0 and later.
kEventControlGhostingFinished

Sent at the end of non-live indicator tracking so your control can update its value based on the final ghost location. (Mac OS X only) 

Available in Mac OS X v10.0 and later.
kEventControlGetActionProcPart

Sent during tracking so your control can alter the part that is passed to its action callback based on modifier keys, etc. Set the kEventParamControlPart to the part you want to have sent. (Mac OS X only) 

Available in Mac OS X v10.0 and later.
kEventControlGetPartRegion

Sent when a client wants to get a particular region of your control. See the GetControlRegion function in the Control Manager. The kEventParamControlRegion contains a region for you to modify. 

If the requested part is kControlStructureMetaPart, the default behavior is to pass back a region equal to the control’s bounds. Otherwise, there is no default behavior. 

(Mac OS X only) 

Available in Mac OS X v10.0 and later.
kEventControlGetPartBounds

Sent when a client wants to get a particular rectangle of your control when it may be more efficient than asking for a region. Set the kEventParamControlPartBounds parameter to the appropriate rectangle. (Mac OS X only) 

Available in Mac OS X v10.0 and later.
kEventControlSetData

Sent when a client wants to change an arbitrary setting of your control. See the SetControlData function in the Control Manager. (Mac OS X only) 

Available in Mac OS X v10.0 and later.
kEventControlGetData

Sent when a client wants to get an arbitrary setting of your control. See the Control Manager function GetControlData. (Mac OS X only) 

Available in Mac OS X v10.0 and later.
kEventControlGetSizeConstraints

Sent when the HIViewGetSizeContraints function is called. You use this to let your custom view indicate its maximum and minimum size. A parent view can use this information to help it lay out subviews. (Available in Mac OS X v10.2 and later.)

Available in Mac OS X v10.2 and later.
kEventControlValueFieldChanged

Sent when your control’s value, minimum, maximum, or view size has changed. Useful so other entities can watch for your control’s value to change. If the window does not have compositing enabled, the default behavior is to redraw the control (but not its subcontrols). (Mac OS X only) 

Available in Mac OS X v10.0 and later.
kEventControlAddedSubControl

Sent when a control is embedded within your control. (Mac OS X only) 

Available in Mac OS X v10.0 and later.
kEventControlRemovingSubControl

Sent when one of your child controls will be removed from your control. (Mac OS X only) 

Available in Mac OS X v10.0 and later.
kEventControlBoundsChanged

Sent when your control’s bounding rectangle has changed. Note that the kEventParamOriginalBounds and kEventParamPreviousBounds parameters for this event contain the same value. (Mac OS X only) 

Available in Mac OS X v10.0 and later.
kEventControlTitleChanged

Sent when your control’s title changes. (Available in Mac OS X v10.2 and later.)

Available in Mac OS X v10.2 and later.
kEventControlOwningWindowChanged

Sent when one your control’s owning window has changed. Useful to update any dependencies that your control has on its owning window. (Mac OS X only) 

Available in Mac OS X v10.0 and later.
kEventControlHiliteChanged

Sent when a control’s highlight state changes. (Available in Mac OS X v10.2 and later.)

Available in Mac OS X v10.2 and later.
kEventControlEnabledStateChanged

Sent when a control’s enabled state changes (that is, when a control is enabled or disabled). (Available in Mac OS X v10.2 and later.)

Available in Mac OS X v10.2 and later.
kEventControlArbitraryMessage

Sent when someone tries to send an old-style CDEF message to your control. In most cases, you should implement Carbon event replacements for CDEF messages instead. If you do handle this event, but do not explicitly handle a particular CDEF message, you should propagate this event up the handler chain (either explicitly by calling CallNextEventHandler or implicitly by returning eventNotHandledErr), as some default behavior may be implemented for compatibility purposes. (Mac OS X only)

Available in Mac OS X v10.0 and later.
Discussion

You can specify any of these events when installing an event handler. You can also pass these constants to the CreateControlEvent function to specify the type of control event you want to create. 

Note that many control events are not sent as a request for you to take action; rather they provide a way for the application to override default behavior. Because this is the case, most control events do not have a standard handler associated with them. Their default behavior occurs whether or not you have the standard window handler installed*/
enum {
   kEventControlInitialize = 1000,
   kEventControlDispose = 1001,
   kEventControlGetOptimalBounds = 1003,
   kEventControlDefInitialize = kEventControlInitialize,
   kEventControlDefDispose = kEventControlDispose,
   kEventControlHit = 1,
   kEventControlSimulateHit = 2,
   kEventControlHitTest = 3,
   kEventControlDraw = 4,
   kEventControlApplyBackground = 5,
   kEventControlApplyTextColor = 6,
   kEventControlSetFocusPart = 7,
   kEventControlGetFocusPart = 8,
   kEventControlActivate = 9,
   kEventControlDeactivate = 10,
   kEventControlSetCursor = 11,
   kEventControlContextualMenuClick = 12,
   kEventControlClick = 13,
   kEventControlGetNextFocusCandidate = 14,
   kEventControlGetAutoToggleValue = 15,
   kEventControlInterceptSubviewClick = 16,
   kEventControlGetClickActivation = 17,
   kEventControlDragEnter = 18,
   kEventControlDragWithin = 19,
   kEventControlDragLeave = 20,
   kEventControlDragReceive = 21,
   kEventControlTrack = 51,
   kEventControlGetScrollToHereStartPoint = 52,
   kEventControlGetIndicatorDragConstraint = 53,
   kEventControlIndicatorMoved = 54,
   kEventControlGhostingFinished = 55,
   kEventControlGetActionProcPart = 56,
   kEventControlGetPartRegion = 101,
   kEventControlGetPartBounds = 102,
   kEventControlSetData = 103,
   kEventControlGetData = 104,
   kEventControlGetSizeConstraints = 105,
   kEventControlValueFieldChanged = 151,
   kEventControlAddedSubControl = 152,
   kEventControlRemovingSubControl = 153,
   kEventControlBoundsChanged = 154,
   kEventControlTitleChanged = 158,
   kEventControlOwningWindowChanged = 159,
   kEventControlHiliteChanged = 160,
   kEventControlEnabledStateChanged = 161,
   kEventControlArbitraryMessage = 201
};

/*Keyboard Events
Keyboard Event Constants

Define constants related to events from kEventClassKeyboard.

enum {
   kEventRawKeyDown = 1,
   kEventRawKeyRepeat = 2,
   kEventRawKeyUp = 3,
   kEventRawKeyModifiersChanged = 4,
   kEventHotKeyPressed = 5,
   kEventHotKeyReleased = 6
};
Constants
kEventRawKeyDown

A key was pressed.

Available in Mac OS X v10.0 and later.
kEventRawKeyRepeat

Sent periodically as a key is held down by the user. 

Available in Mac OS X v10.0 and later.
kEventRawKeyUp

A key was released. 

Available in Mac OS X v10.0 and later.
kEventRawKeyModifiersChanged

The keyboard modifiers have changed. 

Available in Mac OS X v10.0 and later.
kEventHotKeyPressed

A registered hot key was pressed. 

Available in Mac OS X v10.0 and later.
kEventHotKeyReleased

A registered hot key was released.

Available in Mac OS X v10.0 and later.
Discussion

These events are the lowest-level keyboard events.*/
enum {
   kEventRawKeyDown = 1,
   kEventRawKeyRepeat = 2,
   kEventRawKeyUp = 3,
   kEventRawKeyModifiersChanged = 4,
   kEventHotKeyPressed = 5,
   kEventHotKeyReleased = 6
};

/*EventHotKeyRef

Represents a registered global hot key. 

typedef struct OpaqueEventHotKeyRef * EventHotKeyRef;
Discussion

You register a hot key using the RegisterEventHotKey function. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaqueEventHotKeyRef * EventHotKeyRef;

/*EventHotKeyID

Represents the ID of a global hot key. 

struct EventHotKeyID {
   OSType signature;
   UInt32 id;
};
typedef struct EventHotKeyID EventHotKeyID;
Discussion

You register a hot key using the RegisterEventHotKey function. 
Availability
Available in Mac OS X v10.0 and later.*/
struct EventHotKeyID {
   OSType signature;
   UInt32 id;
};
typedef struct EventHotKeyID EventHotKeyID;

/*Application Event Constants

Define constants related to events from kEventClassApplication.

enum {
   kEventAppActivated = 1,
   kEventAppDeactivated = 2,
   kEventAppQuit = 3,
   kEventAppLaunchNotification = 4,
   kEventAppLaunched = 5,
   kEventAppTerminated = 6,
   kEventAppFrontSwitched = 7,
   kEventAppFocusMenuBar = 8,
   kEventAppFocusNextDocumentWindow = 9,
   kEventAppFocusNextFloatingWindow = 10,
   kEventAppFocusToolbar = 11,
   kEventAppFocusDrawer = 12,
   kEventAppGetDockTileMenu = 20,
   kEventAppIsEventInInstantMouser = 104,
   kEventAppHidden = 107,
   kEventAppShown = 108,
   kEventAppSystemUIModeChanged = 109,
   kEventAppAvailableWindowBoundsChanged = 110,
   kEventAppActiveWindowChanged = 111
};
Constants
kEventAppActivated

The application was activated (resumed, in old parlance).

Available in Mac OS X v10.0 and later.
kEventAppDeactivated

The application was deactivated (suspended, in old parlance).

Available in Mac OS X v10.0 and later.
kEventAppQuit

The application is quitting.

Available in Mac OS X v10.0 and later.
kEventAppLaunchNotification

Response to asynchronous application launch.

Available in Mac OS X v10.0 and later.
kEventAppLaunched

Some other application was launched. (CarbonLib 1.3 or later) 

Available in Mac OS X v10.0 and later.
kEventAppTerminated

Some other application was terminated. (CarbonLib 1.3 or later) 

Available in Mac OS X v10.0 and later.
kEventAppFrontSwitched

The frontmost application has changed. (CarbonLib 1.3 or later) 

Available in Mac OS X v10.0 and later.
kEventAppFocusMenuBar

Request to switch the keyboard focus to the menu bar. The Carbon Event Manager handles this event by default. 

Available in Mac OS X v10.2 and later.
kEventAppFocusNextDocumentWindow

Request to shift keyboard focus to the next or previous document window (depending on the state of the Shift key). If there are no more document windows in the current process, focus should shift to the document window in the next (or previous) process. 

If something other than a document window currently has keyboard focus, you should shift focus to the frontmost document window without changing the ordering of the windows. 

If the document window does not have a focused area, you should set the focus to the main control within the window. 

The Carbon Event Manager handles this event by default; if you handle this event, you should only check if the user focus is somewhere other than a document window, and if so, set the focus on the active document window. If the focus is already on a document window, your handler should always return eventNotHandledErr so that the default handler can rotate to the next window across all processes.

Available in Mac OS X v10.2 and later.
kEventAppFocusNextFloatingWindow

Request to shift keyboard focus to the next or previous floating window (depending on the state of the Shift key).

If something other than a floating window currently has keyboard focus, you should shift focus to the frontmost floating window without changing the ordering of the windows. 

If the floating window does not have a focused area, you should set the focus to the main control within the window. 

The default behavior for this event is to send a kEventCommandProcess event containing kHICommandRotateFloatingWindowsForward or kHICommandRotateFloatingWindowsBackward.

Available in Mac OS X v10.2 and later.
kEventAppFocusToolbar

Request to shift keyboard focus to the toolbar.

The default behavior for this event is to move the keyboard focus to the first item in the toolbar (assuming you are using the standard toolbar). 

Available in Mac OS X v10.2 and later.
kEventAppFocusDrawer

Request to shift keyboard focus to the drawer in the focused window.

The default behavior for this event is to move the focus to the first control in the drawer in the focused window if a drawer is present. If multiple drawers are present, focus is moved in clockwise order from one drawer to the next, starting with the top drawer, if any. If the modifiers parameter contains the shift key, focus is moved in reverse (counterclockwise) order. 

(Available in Mac OS X v10.4 and later.)

Available in Mac OS X v10.4 and later.
kEventAppGetDockTileMenu

Request to display a pop-up menu by the application’s dock tile. You should return the menu reference of the menu to display in the kEventParamMenuRef parameter. The sender of this event releases this menu after the Dock displays it, so if you supply a permanently allocated menu reference, you should call the Menu Manager function RetainMenu on it before returning from your handler. 

The default behavior for this event is to return the menu (if any) supplied by the SetApplicationDockTileMenu function (described in the Dock Manager Reference). Note that for most functions, it’s easier to set a menu using SetApplicationDockTileMenu rather than installing a handler for this event.

(Available in Mac OS X v10.1 and later.)

Available in Mac OS X v10.1 and later.
kEventAppIsEventInInstantMouser

The given event’s global mouse location is over an “instant mousing” area. An instant mousing area is an area where a mouse down should not generate ink but should be interpreted as a click.

(Available in Mac OS X v10.2 and later.)

Available in Mac OS X v10.3 and later.
kEventAppHidden

The application was hidden. (Available in Mac OS X v10.2 and later.)

Available in Mac OS X v10.2 and later.
kEventAppShown

The application was shown. (Available in Mac OS X v10.2 and later.)

Available in Mac OS X v10.2 and later.
kEventAppSystemUIModeChanged

The system user interface mode of the frontmost application has changed. (Available in Mac OS X v10.2 and later.)

Available in Mac OS X v10.2 and later.
kEventAppAvailableWindowBoundsChanged

The available window positioning bounds have changed. This event is currently sent when the Dock has changed position or size and when the display configuration has changed. A separate copy of this event is sent to each affected GDevice. (Available in Mac OS X v10.3 and later.)

Available in Mac OS X v10.3 and later.
kEventAppActiveWindowChanged

The active window in the current process has changed.The Window Manager uses ActiveNonFloatingWindow to track the active window. When SelectWindow is called on a window, that window is made the new active window. At that time, the Window Manager also posts a kEventAppActiveWindowChanged event to the main event queue.

If more than one window is activated sequentially before the event loop is run, a single kEventAppActiveWindowChanged event is left in the event queue. Its PreviousActiveWindow parameter will be the window that was originally active, and its CurrentActiveWindow parameter will be the window that was finally active.

(Available in Mac OS X v10.3 and later.)

Available in Mac OS X v10.3 and later.
Discussion

You can pass any of these constants when registering an event handler. You can also pass these constants to the CreateEvent function to specify the type of application event you want to create.*/

enum {
   kEventAppActivated = 1,
   kEventAppDeactivated = 2,
   kEventAppQuit = 3,
   kEventAppLaunchNotification = 4,
   kEventAppLaunched = 5,
   kEventAppTerminated = 6,
   kEventAppFrontSwitched = 7,
   kEventAppFocusMenuBar = 8,
   kEventAppFocusNextDocumentWindow = 9,
   kEventAppFocusNextFloatingWindow = 10,
   kEventAppFocusToolbar = 11,
   kEventAppFocusDrawer = 12,
   kEventAppGetDockTileMenu = 20,
   kEventAppIsEventInInstantMouser = 104,
   kEventAppHidden = 107,
   kEventAppShown = 108,
   kEventAppSystemUIModeChanged = 109,
   kEventAppAvailableWindowBoundsChanged = 110,
   kEventAppActiveWindowChanged = 111
};

/*Window Action Event Constants

Define constants related to events from kEventClassWindow.

enum {
   kEventWindowCollapse = 66,
   kEventWindowCollapseAll = 68,
   kEventWindowExpand = 69,
   kEventWindowExpandAll = 71,
   kEventWindowClose = 72,
   kEventWindowCloseAll = 74,
   kEventWindowZoom = 75,
   kEventWindowZoomAll = 77,
   kEventWindowContextualMenuSelect = 78,
   kEventWindowPathSelect = 79,
   kEventWindowGetIdealSize = 80,
   kEventWindowGetMinimumSize = 81,
   kEventWindowGetMaximumSize = 82,
   kEventWindowConstrain = 83,
   kEventWindowHandleContentClick = 85,
   kEventWindowTransitionStarted = 88,
   kEventWindowTransitionCompleted = 89,
   kEventWindowGetDockTileMenu = 90,
   kEventWindowGetDockTileMenu = 90,
   kEventWindowProxyBeginDrag = 128,
   kEventWindowProxyEndDrag = 129,
   kEventWindowToolbarSwitchMode = 150
};
Constants
kEventWindowCollapse

If the window is not collapsed, this event is sent by the standard window handler after it has received kEventWindowClickCollapseRgn and received true from a call to TrackBox. The default behavior is to call CollapseWindow and then send kEventWindowCollapsed if no error is received from CollapseWindow. (Available in Mac OS X and CarbonLib 1.1 and later.)

Available in Mac OS X v10.0 and later.
kEventWindowCollapseAll

Sent by the standard window handler (when the option key is down) after it has received kEventWindowClickCollapseRgn and then received true from a call to TrackBox. The default response is to send each window of the same class as the clicked window a kEventWindowCollapse event. (Available in Mac OS X and CarbonLib 1.1 and later.)

Available in Mac OS X v10.0 and later.
kEventWindowExpand

If the window is collapsed, this event is sent by the standard window handler after it has received kEventWindowClickCollapseRgn and received true from a call to TrackBox. The default response is to call CollapseWindow, then send kEventWindowExpanded. Note that you will not receive this event before a window is expanded from the dock, since minimized windows in the dock don’t uses collapse boxes to unminimize. (Available in Mac OS X and CarbonLib 1.1 and later.)

Available in Mac OS X v10.0 and later.
kEventWindowExpandAll

Sent by the standard window handler (when the option key is down) after it has received kEventWindowClickCollapseRgn and then received true from a call to TrackBox. The default response is to send each window of the same class as the clicked window a kEventWindowExpand event. (Available in Mac OS X and CarbonLib 1.1 and later.)

Available in Mac OS X v10.0 and later.
kEventWindowClose

Sent by the standard window handler after it has received kEventWindowClickCloseRgn and successfully called TrackBox. Your application might intercept this event to check if the document is dirty, and display a Save/Don’tSave/Cancel alert. 

The default response is to call the Window Manager function DisposeWindow. (Available in Mac OS X and CarbonLib 1.1 and later.)

Available in Mac OS X v10.0 and later.
kEventWindowCloseAll

Sent by the standard window handler (when the option key is down) after it has received kEventWindowClickCloseRgn and received true from a call to TrackGoAway. The standard window handler’s response is to send each window with the same class as the clicked window a kEventWindowClose event. (Available in Mac OS X and CarbonLib 1.1 and later.)

Available in Mac OS X v10.0 and later.
kEventWindowZoom

Sent by the standard window handler upon receiving kEventWindowClickZoomRgn and then receiving true from a call to TrackBox. The default behavior is to zoom the window using ZoomWindowIdeal then, if successful, send a kEventWindowZoomed event. (Available in Mac OS X and CarbonLib 1.1 and later.)

Available in Mac OS X v10.0 and later.
kEventWindowZoomAll

Sent by the standard window handler (when the option key is down) after it has received kEventObjectClickZoomRgn and received true from a call to TrackBox. The standard window handler’s response is to send each window with the same class as the clicked window a kEventObjectZoom event and then to reposition all zoomed windows using the kWindowCascadeOnParentWindowScreen positioning method. For more details, see the Window Manager Reference for more details. (Available in Mac OS X and CarbonLib 1.1 and later.)

Available in Mac OS X v10.0 and later.
kEventWindowContextualMenuSelect

Sent when either the right mouse button is pressed, or the control key is held down and the left mouse button is pressed, or the left mouse button is held down for more than 1/4th of a second (and nothing else is handling the generated mouse tracking events). The standard window handler ignores this event. Note that this event supports kEventParamMouseLocation and other parameters associated with the kEventMouseDown event. (Available in Mac OS X and CarbonLib 1.1 and later.)

Available in Mac OS X v10.0 and later.
kEventWindowPathSelect

Sent when the Window Manager function IsWindowPathSelectClick would return true. The standard window handler sends this event while handling kEventWindowClickDragRgn if the click occurs in the proxy icon. Set the menu reference parameter (kEventParamMenuRef) in the event if you wish to customize the menu passed to the Window Manager function WindowPathSelect. (Available in Mac OS X and CarbonLib 1.1 and later.)

Available in Mac OS X v10.0 and later.
kEventWindowGetIdealSize

Sent by the standard window handler to determine the standard state for zooming. The standard window handler ignores this event. (Available in Mac OS X and CarbonLib 1.1 and later.)

Available in Mac OS X v10.0 and later.
kEventWindowGetMinimumSize

Sent by the standard window handler to determine the minimum size of the window (used during window resizing). (Available in Mac OS X and CarbonLib 1.1 and later.)

In Mac OS X v10.2 and later, the default behavior is to call the Window Manager function GetWindowResizeLimits and return the size obtained in the kEventParamDimensions parameter. There is no default behavior before Mac OS X v10.2.

Available in Mac OS X v10.0 and later.
kEventWindowGetMaximumSize

Sent by the standard window handler to determine the maximum size of the window (used during window resizing). (Available in Mac OS X and CarbonLib 1.1 and later.) On CarbonLib 1.6 and Mac OS X v10.2 and later, this event is also sent by the Window Manager functions ResizeWindow and GrowWindow if the sizeContraints parameter was set to NULL. 

In Mac OS X v10.2 and later, the default behavior is to call the Window Manager function GetWindowResizeLimits and return the size obtained in the kEventParamDimensions parameter. There is no default behavior before Mac OS X v10.2.

Available in Mac OS X v10.0 and later.
kEventWindowConstrain

Sent by the standard window handler to warn of a change in the available window positioning bounds on the window (for example, due to a change in screen resolution or Dock size). (Available in Mac OS X and CarbonLib 1.5 and later.)

In Mac OS v10.0.x the default behavior is to call the Window Manager function ConstrainWindowToScreen on the window with the kWindowConstrainMoveRegardlessOfFit attribute set and a window region code of kWindowDragRgn. The window is constrained to the bounds returned by the Window Manager function GetAvailableWindowPositioningBounds for that display device. 

In Mac OS X v10.1 and later the default behavior is to call ConstrainWindowToScreen on the window with the kWindowConstrainMoveRegardlessOfFit and kWindowConstrainAllowPartial attributes set, and a window region code of kWindowDragRgn. Instead of accepting the normal device bounds, you can also modify the kEventParamAvailableBounds for this event, and the default handler constrains the window to those bounds.

In Mac OS X v10.2 and later, you can set the following optional parameters:
kEventParamAttributes: You can set the constraint attributes to pass to ConstrainWindowToScreen by specifying them in this parameter. 
kEventParamWindowRegionCode: If you set this parameter (which must be of type WindowRegionCode), the standard window handler passes this value to ConstrainWindowToScreen instead of kWindowDragRgn.

In addition, the following optional parameters may exist in Mac OS X v10.2 and later:
kEventParamRgnHandle: Contains the gray region before a configuration change in the available graphics devices (screens). This parameter exists only if the constrain event occurred because the user changed the screen configuration. You can call the Window Manager function GetGrayRgn to obtain the current gray region. 
kEventParamCurrentDockRect: Holds the current bounds of the dock. This parameter and kEventParamPreviousDockRect exist only if the constrain event resulted from a change in the Dock size or position. 
kEventParamPreviousDockRect: Holds the previous bounds of the dock.

Available in Mac OS X v10.0 and later.
kEventWindowHandleContentClick

Sent by the standard window handler in response to kEventWindowClickContentRgn when a mouse click is in the content region but is not a contextual menu invocation or a click on a control. Note that this event supports kEventParamMouseLocation and other parameters associated with the kEventMouseDown event.

The standard handler ignores this event. 

(Available in Mac OS X and CarbonLib 1.3.1 and later.)

Available in Mac OS X v10.0 and later.
kEventWindowTransitionStarted

Sent to all handlers registered for it. It is sent by the TransitionWindow, TransitionWindowAndParent, and TransitionWindowWithOptions APIs just before the first frame of the transition animation.

(Available in Mac OS X v10.3 and later.)

Available in Mac OS X v10.3 and later.
kEventWindowTransitionCompleted

Sent to all handlers registered for it. It is sent by the TransitionWindow, TransitionWindowAndParent, and TransitionWindowWithOptions APIs just after the last frame of the transition animation.

(Available in Mac OS X v10.3 and later.) 

Available in Mac OS X v10.3 and later.
kEventWindowGetDockTileMenu

Sent when a dock tile wants to display a menu. The sender of this event releases the menu after the Dock has displayed it, so if you want to keep the menu, you must call RetainMenu on it before returning from the event handler. 

If you do not handle this event, the default behavior is to call the Window Manager function GetWindowDockTileMenu and return the menu obtained in the kEventParamMenuRef parameter. If no menu is specified, the default handler returns eventNotHandledErr. 

Note that in most cases it is simpler to call the SetWindowDockTileMenu function directly rather than register for this event. 

(Available in Mac OS X v10.2 and later.)

Available in Mac OS X v10.2 and later.
kEventWindowProxyBeginDrag

Sent before a proxy icon drag; you can attach data to the DragRef in the event. The standard handler ignores this event. (Available in Mac OS X v10.0 and later, and CarbonLib 1.1 and later.)

Available in Mac OS X v10.0 and later.
kEventWindowProxyEndDrag

Sent after the proxy icon drag is complete, whether successful or not. The standard handler ignores this event. (Available in Mac OS X v10.0 and later, and CarbonLib 1.1 and later.)

Available in Mac OS X v10.0 and later.
kEventWindowToolbarSwitchMode

The toolbar button (that is, the oblong button used to show and hide the toolbar) was successfully clicked. The standard window handler sends this event when receiving a true return value from TrackBox during the handling of the kEventWindowClickToobarButtonRgn event. Note, however, that you do not have to have the standard window handler installed to receive this event; any window that has a toolbar receives this event when its toolbar button is successfully clicked. Note that if you handle this event, your application is responsible for keeping track of the toolbar’s mode (visible or hidden). 

The default response is to toggle the toolbar (that is, show it if it is hidden, and vice-versa) when the toolbar button is clicked. If the option key is held down during the click, all toolbars in the windows of the current process are toggled. If the command key is down during the click, the toolbar mode is cycled between icons and text, icons alone, and text alone. If both the command and option keys are held during the click, the system displays the toolbar configuration sheet. 

(

Available in Mac OS X only.) 
Discussion

These events indicate that certain changes have been made to a window. These events have greater semantic meaning than the low-level window click events and are usually preferred for overriding.*/
enum {
   kEventWindowCollapse = 66,
   kEventWindowCollapseAll = 68,
   kEventWindowExpand = 69,
   kEventWindowExpandAll = 71,
   kEventWindowClose = 72,
   kEventWindowCloseAll = 74,
   kEventWindowZoom = 75,
   kEventWindowZoomAll = 77,
   kEventWindowContextualMenuSelect = 78,
   kEventWindowPathSelect = 79,
   kEventWindowGetIdealSize = 80,
   kEventWindowGetMinimumSize = 81,
   kEventWindowGetMaximumSize = 82,
   kEventWindowConstrain = 83,
   kEventWindowHandleContentClick = 85,
   kEventWindowTransitionStarted = 88,
   kEventWindowTransitionCompleted = 89,
   kEventWindowGetDockTileMenu = 90,
   kEventWindowProxyBeginDrag = 128,
   kEventWindowProxyEndDrag = 129,
   kEventWindowToolbarSwitchMode = 150
};

/*HICommand

Represents a command event; this structure has been superseded by the HICommandExtended structure.

struct HICommand {
   UInt32 attributes
   UInt32 commandID
   struct {
      MenuRef menuRef;
      MenuItemIndex menuItemIndex;
   } menu;
};
typedef struct HICommand HICommand;
Fields
attributes

Attributes of the command event. 
commandID

The command ID of the command event.
menuRef

A reference to the menu containing the HICommand.
menuItemIndex

The index number of the menu item containing the HICommand.
Availability
Available in Mac OS X v10.0 and later.*/
struct HICommand {
   UInt32 attributes;
   UInt32 commandID;
   struct {
      MenuRef menuRef;
      MenuItemIndex menuItemIndex;
   } menu;
};
typedef struct HICommand HICommand;

/*Event Class Constants

Define constants for specifying event classes.

typedef UInt32 EventClass;
enum {
   kEventClassMouse = 'mous',
   kEventClassKeyboard = 'keyb',
   kEventClassTextInput = 'text',
   kEventClassApplication = 'appl',
   kEventClassAppleEvent = 'eppc',
   kEventClassMenu = 'menu',
   kEventClassWindow = 'wind',
   kEventClassControl = 'cntl',
   kEventClassCommand = 'cmds',
   kEventClassTablet = 'tblt',
   kEventClassVolume = 'vol ',
   kEventClassAppearance = 'appm',
   kEventClassService = 'serv',
   kEventClassToolbar = 'tbar',
   kEventClassToolbarItem = 'tbit',
   kEventClassToolbarItemView = 'tbiv',
   kEventClassAccessibility = 'acce'.
   kEventClassSystem = 'macs',
   kEventClassInk = 'ink ',
   kEventClassTSMDocumentAccess = 'tdac'
};
Constants
kEventClassMouse

Events related to the mouse (mouse down/up/moved).

Available in Mac OS X v10.0 and later.
kEventClassKeyboard

Events related to the keyboard. 

Available in Mac OS X v10.0 and later.
kEventClassTextInput

Events related to text input (by keyboard or by input method). 

Available in Mac OS X v10.0 and later.
kEventClassApplication

Application-level events (launch, quit, and so on). 

Available in Mac OS X v10.0 and later.
kEventClassAppleEvent

Apple Events. 

Available in Mac OS X v10.0 and later.
kEventClassMenu

Menu-related events. 

Available in Mac OS X v10.0 and later.
kEventClassWindow

Window-related events. 

Available in Mac OS X v10.0 and later.
kEventClassControl

Control-related events. 

Available in Mac OS X v10.0 and later.
kEventClassCommand

Command events (HICommands). 

Available in Mac OS X v10.0 and later.
kEventClassTablet

Events related to tablet input. 

Available in Mac OS X v10.0 and later.
kEventClassVolume

Events related to File Manager volumes.

Available in Mac OS X v10.0 and later.
kEventClassAppearance

Events related to the Appearance Manager. 

Available in Mac OS X v10.1 and later.
kEventClassService

Events related to the Services Manager.

Available in Mac OS X v10.1 and later.
kEventClassToolbar

Events related to the toolbar (not the toolbar window class).

Available in Mac OS X v10.2 and later.
kEventClassToolbarItem

Events related to toolbar items. 

Available in Mac OS X v10.2 and later.
kEventClassToolbarItemView

Events related to toolbar item views.

Available in Mac OS X v10.3 and later.
kEventClassAccessibility

Events related to application accessibility features. 

Available in Mac OS X v10.2 and later.
kEventClassSystem

Events related to the system. 

Available in Mac OS X v10.3 and later.
kEventClassInk

Events related to ink. 

Available in Mac OS X v10.3 and later.
kEventClassTSMDocumentAccess

Events related to Text Services Manager document access.

Available in Mac OS X v10.3 and later.
Discussion

Event classes specify broad categories of events, grouped according to the object they are associated with. Within an event class are specific event types.*/
typedef UInt32 EventClass;
enum {
   kEventClassMouse = 'mous',
   kEventClassKeyboard = 'keyb',
   kEventClassTextInput = 'text',
   kEventClassApplication = 'appl',
   kEventClassAppleEvent = 'eppc',
   kEventClassMenu = 'menu',
   kEventClassWindow = 'wind',
   kEventClassControl = 'cntl',
   kEventClassCommand = 'cmds',
   kEventClassTablet = 'tblt',
   kEventClassVolume = 'vol ',
   kEventClassAppearance = 'appm',
   kEventClassService = 'serv',
   kEventClassToolbar = 'tbar',
   kEventClassToolbarItem = 'tbit',
   kEventClassToolbarItemView = 'tbiv',
   kEventClassAccessibility = 'acce',
   kEventClassSystem = 'macs',
   kEventClassInk = 'ink ',
   kEventClassTSMDocumentAccess = 'tdac'
};

/*Standard Command ID Constants

Define command IDs for common menu commands and controls.

enum {
   kHICommandOK = 'ok  ',
   kHICommandCancel = 'not!',
   kHICommandQuit = 'quit',
   kHICommandUndo = 'undo',
   kHICommandRedo = 'redo',
   kHICommandCut = 'cut ',
   kHICommandCopy = 'copy',
   kHICommandPaste = 'past',
   kHICommandClear = 'clea',
   kHICommandSelectAll = 'sall',
   kHICommandHide = 'hide',
   kHICommandHideOthers = 'hido',
   kHICommandShowAll = 'shal',
   kHICommandPreferences = 'pref',
   kHICommandZoomWindow = 'zoom',
   kHICommandMinimizeWindow = 'mini',
   kHICommandMinimizeAll = 'mina',
   kHICommandMaximizeWindow = 'maxi',
   kHICommandMaximizeAll = 'maxa',
   kHICommandArrangeInFront = 'frnt',
   kHICommandBringAllToFront = 'bfrt',
   kHICommandWindowListSeparator = 'wldv',
   kHICommandWindowListTerminator = 'wlst',
   kHICommandSelectWindow = 'swin',
   kHICommandRotateWindowsForward = 'rotw',
   kHICommandRotateWindowsBackward = 'rotb',
   kHICommandRotateFloatingWindowsForward = 'rtfw',
   kHICommandRotateFloatingWindowsBackward = 'rtfb',
   kHICommandAbout = 'abou',
   kHICommandNew = 'new ',
   kHICommandOpen = 'open',
   kHICommandClose = 'clos',
   kHICommandSave = 'save',
   kHICommandSaveAs = 'svas',
   kHICommandRevert = 'rvrt',
   kHICommandPrint = 'prnt',
   kHICommandPageSetup = 'page',
   kHICommandAppHelp = 'ahlp',
   kHICommandShowCharacterPalette = 'chrp',
   kHICommandShowSpellingPanel = 'shsp',
   kHICommandCheckSpelling = 'cksp',
   kHICommandChangeSpelling = 'chsp',
   kHICommandCheckSpellingAsYouType = 'chsp',
   kHICommandIgnoreSpelling = 'igsp',
   kHICommandLearnWord = 'lrwd'
};
Constants
kHICommandOK

The OK button in a dialog or alert.

Available in Mac OS X v10.0 and later.
kHICommandCancel

The Cancel button in a dialog or alert. 

Available in Mac OS X v10.0 and later.
kHICommandQuit

The application should quit. 

Available in Mac OS X v10.0 and later.
kHICommandUndo

The last editing operation should be undone. 

Available in Mac OS X v10.0 and later.
kHICommandRedo

The last editing operation should be redone. 

Available in Mac OS X v10.0 and later.
kHICommandCut

The selected items should be cut. 

Available in Mac OS X v10.0 and later.
kHICommandCopy

The selected items should be copied. 

Available in Mac OS X v10.0 and later.
kHICommandPaste

The contents of the clipboard should be pasted. 

Available in Mac OS X v10.0 and later.
kHICommandClear

The selected items should be deleted. 

Available in Mac OS X v10.0 and later.
kHICommandSelectAll

All items in the active window should be selected. 

Available in Mac OS X v10.0 and later.
kHICommandHide

The application should be hidden. The Menu Manager responds to this command automatically; your application does not need to handle it. 

Available in Mac OS X v10.0 and later.
kHICommandHideOthers

Other applications should be hidden. The Menu Manager responds to this command automatically; your application does not need to handle it. 

Available in Mac OS X v10.1 and later.
kHICommandShowAll

All applications should become visible. The Menu Manager responds to this command automatically; your application does not need to handle it. 

Available in Mac OS X v10.1 and later.
kHICommandPreferences

The Preferences menu item has been selected.

Available in Mac OS X v10.0 and later.
kHICommandZoom

The active window should be zoomed in or out. The default application handler responds to this event automatically. Your application does not need to handle this event, but you may want to install a Carbon event handler for kEventWindowGetIdealSize to return the ideal size for your document windows.
kHICommandMinimizeWindow

The active window should be minimized. The default application handler will respond to this event automatically; your application does not need to handle it. 

Available in Mac OS X v10.0 and later.
kHICommandMinimizeAll

All collapsable windows should be minimized. The default application handler responds to this event automatically; your application does not need to handle it.

Available in Mac OS X v10.1 and later.
kHICommandMaximizeWindow

The active window should be maximized. Sent only on Mac OS 9. The default application handler will respond to this event automatically; your application does not need to handle it.

Available in Mac OS X v10.1 and later.
kHICommandMaximizeAll

All collapsible windows should be maximized. This event is not sent or handled on Mac OS X.

Available in Mac OS X v10.1 and later.
kHICommandArrangeInFront

All document-class windows should be arranged in a stack. The default application handler responds to this event automatically; your application does not need to handle it.

Available in Mac OS X v10.0 and later.
kHICommandBringAllToFront

All windows of this application should be brought in front of windows from other applications. Sent only on Mac OS X. The default application handler responds to this event automatically; your application does not need to handle it.

Available in Mac OS X v10.1 and later.
kHICommandWindowListSeparator

A placeholder to mark the separator item dividing the Zoom/Minimize/Maximize/Arrange menu items in the standard Window menu from the menu items listing the visible windows. If you need to add your own menu items to the standard Window menu before the window list section, you can use GetIndMenuItemWithCommandID (described in the Menu Manager Reference in the User Experience section of the Carbon documentation) to look for the menu item with this command ID and insert your menu items before the item with this ID.

Available in Mac OS X v10.1 and later.
kHICommandWindowListTerminator

Used as a placeholder to mark the end of the window list section of the standard Window menu. If you need to add your own menu items to the standard Window menu after the window list section, you can use GetIndMenuItemWithCommandID (described in the Menu Manager Reference in the User Experience section of the Carbon documentation) to look for the menu item with this command ID and insert your items after the item with this ID.

Available in Mac OS X v10.1 and later.
kHICommandSelectWindow

A window in the standard Window menu has been selected and should be activated. In Mac OS X v10.3, this command is also sent by the toolbox whenever it needs to activate a window in your application. For example, it is used when a window is selected from the application’s Dock menu, and when a window that uses the standard window event handler is clicked. The default application handler responds to this event automatically; your application does not need to handle it.

Available in Mac OS X v10.1 and later.
kHICommandRotateWindowsForward

The Rotate Windows hot key (cmd-~ by default) has been pressed. Non-floating windows should be rotated so that the window after the active window is activated. The default application handler responds to this event automatically; your application does not need to handle it.

Available in Mac OS X v10.2 and later.
kHICommandRotateWindowsBackward

The Rotate Windows hot key (cmd-~ by default) has been pressed. Non-floating windows should be rotated so that the window before the active window is activated. The default application handler responds to this event automatically; your application does not need to handle it.

Available in Mac OS X v10.2 and later.
kHICommandRotateFloatingWindowsForward

The floating window focus hot key (ctl-F6 by default) has been pressed, and floating windows should be rotated so that the window after the focused window is activated. The default application handler responds to this event automatically; your application does not need to handle it.

Available in Mac OS X v10.2 and later.
kHICommandRotateFloatingWindowsBackward

The floating window focus hot key (ctl-F6 by default) has been pressed, and floating windows should be rotated so that the window before the focused window is activated. The default application handler responds to this event automatically; your application does not need to handle it.

Available in Mac OS X v10.2 and later.
kHICommandAbout

The About menu item has been selected. In Mac OS X v10.3 and later, RunApplicationEventLoop installs a handler for this command ID on the application target that handles this event automatically by calling HIAboutBox. Your application can install its own handler if you want to display a customized about box.

Available in Mac OS X v10.0 and later.
kHICommandNew

A new document or item should be created.

Available in Mac OS X v10.1 and later.
kHICommandOpen

The user wants to open an existing document.

Available in Mac OS X v10.1 and later.
kHICommandClose

The active window should be closed. This command is typically be generated by a Close menu item. In Mac OS X v10.3 and later, the default application handler responds to this command by sending a kEventWindowClose event; on earlier systems, only the standard window event handler responded to this event.

Available in Mac OS X v10.1 and later.
kHICommandSave

The active document should be saved.

Available in Mac OS X v10.1 and later.
kHICommandSaveAs

The user wants to save the active document under a new name.

Available in Mac OS X v10.1 and later.
kHICommandRevert

The contents of the active document should be reverted to the last saved version.

Available in Mac OS X v10.1 and later.
kHICommandPrint

The active window should be printed.

Available in Mac OS X v10.1 and later.
kHICommandPageSetup

The user wants to configure the current page margins, formatting, and print options.

Available in Mac OS X v10.1 and later.
kHICommandAppHelp

The application’s help book should be displayed. The Help Manager installs a handler for this command ID on the Help menu returned by HMGetHelpMenu and responds to this event automatically. Your application does not need to handle it. In Mac OS X v10.4, the Help Manager installs a handler for this event on the application event target rather than on the Help menu.

Available in Mac OS X v10.1 and later.
kHICommandShowCharacterPalette

The character palette needs to be shown. Events with this command ID are only generated in Mac OS X v10.3 and later. The toolbox will respond to this event automatically; your application does not need to handle it.

Available in Mac OS X v10.3 and later.
kHICommandShowSpellingPanel

Display the spelling panel if it is not already visible. Events with this command ID are only generated in Mac OS X v10.4 and later. If spell checking has been enabled in the Multilingual Text Engine (MLTE) or an HITextView, this command is handled automatically.

Available in Mac OS X v10.4 and later.
kHICommandCheckSpelling

Spell check the document now. Events with this command ID are only generated in Mac OS X v10.4 and later. If spell checking has been enabled in MLTE or an HITextView, this command is handled automatically.

Available in Mac OS X v10.4 and later.
kHICommandChangeSpelling

Change the spelling. Events with this command ID are only generated in Mac OS X v10.4 and later. If spell checking has been enabled in MLTE or an HITextView, this command is handled automatically.

Available in Mac OS X v10.4 and later.
kHICommandCheckSpellingAsYouType

Begin interactive spell checking. Events with this command ID are only generated in Mac OS X v10.4 and later. If spell checking has been enabled in MLTE or an HITextView, this command is handled automatically.

Available in Mac OS X v10.4 and later.
kHICommandIgnoreSpelling

Ignore this word while spell checking this text view. Events with this command ID are only generated in Mac OS X v10.4 and later. If spell checking has been enabled in MLTE or an HITextView, this command is handled automatically.

Available in Mac OS X v10.4 and later.
kHICommandLearnWord

Learn this spelling for all documents. Events with this command ID are generated only in Mac OS X v10.4 and later. If spell checking has been enabled in MLTE or an HITextView, this command is handled automatically.

Available in Mac OS X v10.4 and later.
Discussion

You should use these values for standard menu and control commands rather than defining your own.*/
enum {
   kHICommandOK = 'ok  ',
   kHICommandCancel = 'not!',
   kHICommandQuit = 'quit',
   kHICommandUndo = 'undo',
   kHICommandRedo = 'redo',
   kHICommandCut = 'cut ',
   kHICommandCopy = 'copy',
   kHICommandPaste = 'past',
   kHICommandClear = 'clea',
   kHICommandSelectAll = 'sall',
   kHICommandHide = 'hide',
   kHICommandHideOthers = 'hido',
   kHICommandShowAll = 'shal',
   kHICommandPreferences = 'pref',
   kHICommandZoomWindow = 'zoom',
   kHICommandMinimizeWindow = 'mini',
   kHICommandMinimizeAll = 'mina',
   kHICommandMaximizeWindow = 'maxi',
   kHICommandMaximizeAll = 'maxa',
   kHICommandArrangeInFront = 'frnt',
   kHICommandBringAllToFront = 'bfrt',
   kHICommandWindowListSeparator = 'wldv',
   kHICommandWindowListTerminator = 'wlst',
   kHICommandSelectWindow = 'swin',
   kHICommandRotateWindowsForward = 'rotw',
   kHICommandRotateWindowsBackward = 'rotb',
   kHICommandRotateFloatingWindowsForward = 'rtfw',
   kHICommandRotateFloatingWindowsBackward = 'rtfb',
   kHICommandAbout = 'abou',
   kHICommandNew = 'new ',
   kHICommandOpen = 'open',
   kHICommandClose = 'clos',
   kHICommandSave = 'save',
   kHICommandSaveAs = 'svas',
   kHICommandRevert = 'rvrt',
   kHICommandPrint = 'prnt',
   kHICommandPageSetup = 'page',
   kHICommandAppHelp = 'ahlp',
   kHICommandShowCharacterPalette = 'chrp',
   kHICommandShowSpellingPanel = 'shsp',
   kHICommandCheckSpelling = 'cksp',
   kHICommandChangeSpelling = 'chsp',
   kHICommandCheckSpellingAsYouType = 'chsp',
   kHICommandIgnoreSpelling = 'igsp',
   kHICommandLearnWord = 'lrwd'
};


/*Command Event Constants

Define constants related to events from kEventClassCommand.

enum {
   kEventProcessCommand = 1,
   kEventCommandProcess = 1,
   kEventCommandUpdateStatus = 2
};
Constants
kEventProcessCommand

A command has been invoked and the application should handle it. This event is sent when the user chooses a menu item or when a control with a command is pressed. Some senders of this event will also include the modifier keys that were pressed by the user when the command was invoked, but this parameter is optional. 

Available in Mac OS X v10.0 and later.
kEventCommandProcess

Same as kEventProcessCommand. 

Available in Mac OS X v10.0 and later.
kEventCommandUpdateStatus

Sent when updates related to the command event may be required. When you receive this event, you should update the necessary user interface elements in your application to reflect the current status of the command. For example, if the command has the kHICommandFromMenu bit set, you should update the menu item state, text, and so on, to reflect the current state of your application.

Note that the standard handler for kEventMenuEnableItems automatically sends this event to your menu commands. As this can cause a performance hit if you have many menu items, you can choose to bypass these updates by installing a no-op handler for kEventMenuEnableItems that simply returns noErr. 

Available in Mac OS X v10.0 and later.
Discussion

You pass this constant to the CreateEvent function to indicate the type of command event you want to create. Future releases of the Carbon Event Manager will provide additional command event types.*/
enum {
   kEventProcessCommand = 1,
   kEventCommandProcess = 1,
   kEventCommandUpdateStatus = 2
};


/*RunApplicationEventLoop

Runs the application event loop.

void RunApplicationEventLoop ();
Discussion

This function is used as the main event loop for a Carbon Event-based application. Once entered, this function waits for events to arrive and dispatches them to your event handlers automatically. 

Note that calling RunApplicationEventLoop also installs the standard application handler, which provides standard handler responses for menu and application events. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/
void RunApplicationEventLoop ();

/*GetApplicationEventTarget

Obtains the event target reference for the application.

EventTargetRef GetApplicationEventTarget ();
Return Value

An event target reference. 
Discussion

Once you obtain this reference, you can send events to the target and install event handlers on it. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/
EventTargetRef GetApplicationEventTarget ();

/*GetApplicationEventTarget

Obtains the event target reference for the application.

EventTargetRef GetApplicationEventTarget ();
Return Value

An event target reference. 
Discussion

Once you obtain this reference, you can send events to the target and install event handlers on it. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/
EventTargetRef GetApplicationEventTarget ();

/*GetWindowEventTarget

Obtains the event target reference for a specified window. 

EventTargetRef GetWindowEventTarget (
   WindowRef inWindow
);
Parameters
inWindow

The window to return the event target for. See the QuickDraw Manager documentation for a description of the WindowRef data type.
Return Value

An event target reference. 
Discussion

Once you obtain this reference, you can send events to the target and install an event handler on it. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/
EventTargetRef GetWindowEventTarget (
   WindowRef inWindow
);

/*RegisterEventHotKey

Registers a global hot key.

OSStatus RegisterEventHotKey (
   UInt32 inHotKeyCode,
   UInt32 inHotKeyModifiers,
   EventHotKeyID inHotKeyID,
   EventTargetRef inTarget,
   OptionBits inOptions,
   EventHotKeyRef * outRef
);
Parameters
inHotKeyCode

The virtual key code of the hot key you want to register. 
inHotKeyModifiers

The keyboard modifiers to look for. In Mac OS X v10.2 and earlier, if you do not specify a modifier key, this function returns paramErr. In Mac OS X v10.3 and later, passing 0 does not cause an error.
inHotKeyID

The application-specified hot key ID. You will receive this ID in the kEventHotKeyPressed event as the direct object parameter. 
inTarget

The target to notify when the hot key is pressed. 
inOptions

Currently unused. You must pass 0.
outRef

On return, a reference to the new hot key. You need this reference if you later wish to unregister it. 
Return Value

A result code. See “Carbon Event Manager Result Codes”.
Discussion

This function registers a global hot key based on the virtual key code and modifiers you pass in. When the user enters the hot-key combination, a kEventHotKeyPressed event is sent to the target you specified. Only one such combination can exist for the current application (that is, multiple entities in the same application cannot register for the same hot key combination). The same hot key can, however, be registered by multiple applications. This means that multiple applications can potentially be notified when a particular hot key is requested. This might not necessarily be desirable, but it is how it works at present. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/
OSStatus RegisterEventHotKey (
   UInt32 inHotKeyCode,
   UInt32 inHotKeyModifiers,
   EventHotKeyID inHotKeyID,
   EventTargetRef inTarget,
   OptionBits inOptions,
   EventHotKeyRef * outRef
);

/*GetControlEventTarget

Obtains the event target reference for the specified control.

EventTargetRef GetControlEventTarget (
   ControlRef inControl
);
Parameters
inControl

The control to return the target for. See the Control Manager documentation for a description of the ControlRef data type.
Return Value

An event target reference. 
Discussion

Once you obtain this reference, you can send events to the target and install event handlers on it. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/
EventTargetRef GetControlEventTarget (
   ControlRef inControl
);

/*UnregisterEventHotKey

Unregisters a global hot key. 

OSStatus UnregisterEventHotKey (
   EventHotKeyRef inHotKey
);
Parameters
inHotKey

The event hot key reference of the hot key you want to unregister. 
Return Value

A result code. See “Carbon Event Manager Result Codes”.
Discussion

Unregisters a global hot key that was previously registered with the function RegisterEventHotKey. You do not need to unregister a hot key when your application terminates; the system takes care of that for you. You can use this function if the user changes a hot key for something in your application—you would unregister the previous key and register your new key. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/
OSStatus UnregisterEventHotKey (
   EventHotKeyRef inHotKey
);

#ifdef __cplusplus
}
#endif

#endif
