#ifndef APPERANCE_H
#define APPERANCE_H


#ifndef APPLICATIONSERVICES_H
#include <ApplicationServices/ApplicationServices.h>
#endif

#ifndef COLLECTIONS_H
#include <CarbonCore/Collections.h>
#endif

#ifndef PROCESSES_H
#include <HIServices/Processes.h>
#endif


#include <HYS/HIToolbox/Appearance.h>
#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Theme Drawing States

Specify the state in which human interface elements are drawn.

enum {
   kThemeStateInactive = 0,
   kThemeStateActive = 1,
   kThemeStatePressed = 2,
   kThemeStateRollover = 6,
   kThemeStateUnavailable = 7,
   kThemeStateUnavailableInactive = 8
   kThemeStatePressedUp = 2,
   kThemeStatePressedDown = 3
};
typedef UInt32 ThemeDrawState;
Constants
kThemeStateInactive

The element is drawn in the inactive state. 

Available in Mac OS X v10.0 and later.
kThemeStateActive

The element is drawn in the active state. 

Available in Mac OS X v10.0 and later.
kThemeStatePressed

The element is drawn in the selected state.

Available in Mac OS X v10.0 and later.
kThemeStatePressedUp

For increment/decrement buttons (also known as "little arrows" controls), the increment button is drawn in the selected state.

Available with Appearance Manager 1.1 and later.
kThemeStatePressedDown

For increment/decrement buttons (also known as "little arrows" controls), the decrement button is drawn in the selected state.

Available with Appearance Manager 1.1 and later.*/
enum {
   kThemeStateInactive = 0,
   kThemeStateActive = 1,
   kThemeStatePressed = 2,
   kThemeStateRollover = 6,
   kThemeStateUnavailable = 7,
   kThemeStateUnavailableInactive = 8,
   kThemeStatePressedUp = 2,
   kThemeStatePressedDown = 3
};

/*Theme Font IDs

Identify types of fonts.

enum {
   kThemeSystemFont = 0,
   kThemeSmallSystemFont = 1,
   kThemeSmallEmphasizedSystemFont = 2,
   kThemeViewsFont = 3,
   kThemeEmphasizedSystemFont = 4,
   kThemeApplicationFont = 5,
   kThemeLabelFont = 6,
   kThemeMenuTitleFont = 100,
   kThemeMenuItemFont = 101,
   kThemeMenuItemMarkFont = 102,
   kThemeMenuItemCmdKeyFont = 103,
   kThemeWindowTitleFont = 104,
   kThemePushButtonFont = 105,
   kThemeUtilityWindowTitleFont = 106,
   kThemeAlertHeaderFont = 107,
   kThemeSystemFontDetail = 7,
   kThemeSystemFontDetailEmphasized = 8,
   kThemeCurrentPortFont = 200,
   kThemeToolbarFont = 108
};
typedef UInt16 ThemeFontID;
Constants
kThemeSystemFont

The current (large) system font. This is the font used to draw most interface elements. If you can't find a more appropriate ThemeFontID constant, you should use this one. This font is suitable for drawing titles on most custom widgets and buttons, as well as most static text in dialogs and windows.

Available with Appearance Manager 1.1 and later.
kThemeSmallSystemFont

The current small system font. This is the font used to draw interface elements when space is at a premium.

Available with Appearance Manager 1.1 and later.
kThemeSmallEmphasizedSystemFont

The current small, emphasized system font. This constant is identical to kThemeSmallSystemFont, except it draws bold or otherwise emphasized text, as is appropriate for your application’s language and script.

Available with Appearance Manager 1.1 and later.
kThemeViewsFont

The current views font. This is the font used to draw file and folder names in Finder windows or other browsable lists.

Available with Appearance Manager 1.1 and later.
kThemeEmphasizedSystemFont

The current emphasized system font. This constant is identical to kThemeSystemFont, except it draws bold or otherwise emphasized text, as is appropriate for your application’s language and script. 

Available in Mac OS X or in CarbonLib 1.3 and later.
kThemeApplicationFont

An analog to the Script Manager's notion of the Application Font. This font is a suitable default choice for your application's document-style text editing areas.

Available in Mac OS X or in CarbonLib 1.3 and later.
kThemeLabelFont

Generally smaller than kThemeSmallSystemFont, this font is appropriate for drawing text labels next to image content that reinforces the meaning of the text, such as you may use with a bevel button. 

Available in Mac OS X or in CarbonLib 1.3 and later.
kThemeMenuTitleFont

The font used to draw menu titles in the menu bar. 

Available in Mac OS X or in CarbonLib 1.3 and later.
kThemeMenuItemFont

The font used to draw menu items in menus.

Available in Mac OS X or in CarbonLib 1.3 and later.
kThemeMenuItemMarkFont

The font used to draw menu item marks in menus.

Available in Mac OS X or in CarbonLib 1.3 and later.
kThemeMenuItemCmdKeyFont

The font used to draw menu item command key equivalents in menus.

Available in Mac OS X or in CarbonLib 1.3 and later.
kThemeWindowTitleFont

The font used to draw text in most window title bars.

Available in Mac OS X or in CarbonLib 1.3 and later.
kThemePushButtonFont

The font used to draw text labels on push buttons.

Available in Mac OS X or in CarbonLib 1.3 and later.
kThemeUtilityWindowTitleFont

The font used to draw text in utility window title bars.

Available in Mac OS X or in CarbonLib 1.3 and later.
kThemeAlertHeaderFont

The font used to draw the first and most important message of an alert window.

Available in Mac OS X or in CarbonLib 1.3 and later.
kThemeCurrentPortFont

Unlike the other ThemeFontID constants, kThemeCurrentPortFont doesn't map to a font appropriate to your application's language or script. It maps directly to the font, size, and style of the current QuickDraw port. This allows you to get somewhat customized behavior out of the functions that take ThemeFontID constants. 

Note, however, that kThemeCurrentPortFont does not support all QuickDraw styles on all platforms; in particular, outline and shadow style are not supported on Mac OS X. Additionally, kThemeCurrentPortFont is not completely unicode savvy; use of kThemeCurrentPortFont may result in errors having to do with the current port's font not being appropriate for rendering or measuring all glyphs in a given unicode string.

Because of overhead associated with gathering QuickDraw font information and converting it to the native font format on Mac OS X, using kThemeCurrentPortFont may slow down your text drawing and measuring significantly compared to other ThemeFontID constants. Use kThemeCurrentPortFont only as a last resort.

Available in Mac OS X or in CarbonLib 1.3 and later.
kThemeToolbarFont

The font used to draw the label of a toolbar item. 

Available in Mac OS X 10.2 and later.
Discussion

A ThemeFontID constant is a virtual font ID that you can pass to one of the Appearance Manager’s text-related functions. Within these functions, the ThemeFontID is mapped to the appropriate font or fonts, size, and style based on a number of factors, including:
the system appearance (Platinum on Mac OS 9 and Aqua on Mac OS X)
the string to be rendered, if any
the language or script that the application is running in

The ThemeFontID constants allow you to get the correct text appearance for the platform your application is currently running on.*/
enum {
   kThemeSystemFont = 0,
   kThemeSmallSystemFont = 1,
   kThemeSmallEmphasizedSystemFont = 2,
   kThemeViewsFont = 3,
   kThemeEmphasizedSystemFont = 4,
   kThemeApplicationFont = 5,
   kThemeLabelFont = 6,
   kThemeMenuTitleFont = 100,
   kThemeMenuItemFont = 101,
   kThemeMenuItemMarkFont = 102,
   kThemeMenuItemCmdKeyFont = 103,
   kThemeWindowTitleFont = 104,
   kThemePushButtonFont = 105,
   kThemeUtilityWindowTitleFont = 106,
   kThemeAlertHeaderFont = 107,
   kThemeSystemFontDetail = 7,
   kThemeSystemFontDetailEmphasized = 8,
   kThemeCurrentPortFont = 200,
   kThemeToolbarFont = 108
};

#ifdef __cplusplus
}
#endif

#endif