#ifndef CGCOLORSPACE_H
#define CGCOLORSPACE_H

#include <CoreGraphics/CGBase.h>
#include <CoreGraphics/CGDataProvider.h>
#include <stddef.h>

/*CGColorSpaceRef

An opaque type that encapsulates color space information.

typedef struct CGColorSpace *CGColorSpaceRef;
Discussion

CGColorSpace encapsulates color space information used to specify how Quartz interprets color information. Quartz supports several different kinds of color space: device-dependent, device independent, indexed, and pattern.
Device color spaces are tied to the system of color representation of a particular device. Device color spaces are not recommended when high-fidelity color preservation is important.
Colors in a device-independent color spaces should appear the same when displayed on different devices, the visual appearance of the color is preserved, as far as the capabilities of the device allow. Quartz provides several device-independent color spaces, all of which are derived from the CIE XYZ space standard.
An indexed color space contains a color table with up to 256 entries and a base color space to which the color table entries are mapped. Each entry in the color table specifies one color in the base color space. 
A pattern color space is used when stroking or filling with a pattern. Pattern color spaces are supported in Mac OS X version 10.1 and later.

In Mac OS X version 10.2 and later, CGColorSpaceRef is derived from CFTypeRef and inherits the properties that all Core Foundation types have in common. For more information, see CFType Reference.
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct CGColorSpace *CGColorSpaceRef;

/*CGColorSpaceCreateWithPlatformColorSpace

Creates a platform-specific color space.

CGColorSpaceRef CGColorSpaceCreateWithPlatformColorSpace(
   void *platformColorSpace
);
Parameters
platformColorSpace

A generic pointer to a platform-specific color space. In Mac OS X, pass a CMProfileRef—a ColorSync profile. Quartz uses this pointer (and the underlying information) only during the function call.
Return Value

A new color space. You are responsible for releasing this object by calling CGColorSpaceRelease. If unsuccessful, returns NULL.
Discussion

Colors in a device-dependent color space are not transformed or otherwise modified when displayed on an output device—that is, there is no attempt to maintain the visual appearance of a color. As a consequence, colors in a device color space often appear different when displayed on different output devices. For this reason, device color spaces are not recommended when color preservation is important.
Availability
Available in Mac OS X version 10.1 and later.
Declared In
CGColorSpace.h*/
CGColorSpaceRef CGColorSpaceCreateWithPlatformColorSpace(
   void *platformColorSpace
);

/*CGColorSpaceRelease

Decrements the retain count of a color space.

void CGColorSpaceRelease (
   CGColorSpaceRef cs
);
Parameters
cs

The Quartz color space to release. 
Discussion

This function is equivalent to CFRelease, except that it does not cause an error if the cs parameter is NULL.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGColorSpace.h*/
void CGColorSpaceRelease (
   CGColorSpaceRef cs
);


#endif