#ifndef CFMESSAGEPORT_H
#define  CFMESSAGEPORT_H


#include <CoreFoundation/CFString.h>
#include <CoreFoundation/CFRunLoop.h>
#include <CoreFoundation/CFData.h>

#if defined(__cplusplus)
extern "C" {
#endif

/*CFMessagePortContext

A structure that contains program-defined data and callbacks with which you can configure a CFMessagePort objects behavior.

struct CFMessagePortContext {
   CFIndex version; 
   void *info; 
   CFAllocatorRetainCallBack retain; 
   CFAllocatorReleaseCallBack release; 
   CFAllocatorCopyDescriptionCallBack copyDescription;
};
typedef struct CFMessagePortContext CFMessagePortContext;
Fields
version

Version number of the structure. Must be 0.
info

An arbitrary pointer to program-defined data, which can be associated with the message port at creation time. This pointer is passed to all the callbacks defined in the context.
retain

A retain callback for your program-defined info pointer. Can be NULL. 
release

A release callback for your program-defined info pointer. Can be NULL. 
copyDescription

A copy description callback for your program-defined info pointer. Can be NULL.*/
struct CFMessagePortContext {
   CFIndex version; 
 void *info; 
   CFAllocatorRetainCallBack retain; 
   CFAllocatorReleaseCallBack release; 
   CFAllocatorCopyDescriptionCallBack copyDescription;
};
typedef struct CFMessagePortContext CFMessagePortContext;


/* CFMessagePortRef

A reference to a message port object.

typedef struct __CFMessagePort *CFMessagePortRef;
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct __CFMessagePort *CFMessagePortRef;


/*CFMessagePortCallBack

Callback invoked to process a message received on a CFMessagePort object.

typedef CFDataRef (*CFMessagePortCallBack) (
   CFMessagePortRef local, 
   SInt32 msgid, 
   CFDataRef data, 
   void *info
);

If you name your function MyCallBack, you would declare it like this:

CFDataRef MyCallBack (
   CFMessagePortRef local, 
   SInt32 msgid, 
   CFDataRef data, 
   void *info
);
Parameters
local

The local message port that received the message. 
msgid

An arbitrary integer value assigned to the message by the sender.
data

The message data. 
info

The info member of the CFMessagePortContext structure that was used when creating local.
Return Value

Data to send back to the sender of the message. The system releases the returned CFData object. Return NULL if you want an empty reply returned to the sender. 
Discussion

If you want the message data to persist beyond this callback, you must explicitly create a copy of data rather than merely retain it; the contents of data will be deallocated after the callback exits.*/

typedef CFDataRef (*CFMessagePortCallBack) (
   CFMessagePortRef local, 
   SInt32 msgid, 
   CFDataRef data, 
   void *info
);

#ifdef __cplusplus
}
#endif


#endif