#ifndef TEXTCOMMON_H
#define  TEXTCOMMON_H


#ifndef MACTYPES_H
#include <CarbonCore/MacTypes.h>
#endif



#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*TextEncoding

Defines a data type for a text encoding value.

typedef UInt32 TextEncoding;
Discussion

A TextEncoding value is specified by a text encoding base, a text encoding variant, and a text encoding format. You can obtain a TextEncoding value by calling the function CreateTextEncoding. When you call this function, you can provide the TextEncodingBase, TextEncodingVariant, and TextEncodingFormat data types.

A TextEncoding value is used, for example, to identify the encoding of text passed to a text converter. Two TextEncoding values are needed?for source and destination encoding?when calling the Text Encoding Converter or the Unicode Converter to convert text. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef UInt32 TextEncoding;

/*Special Text Encoding Values

Specify special cases of text encodings.

enum {
   kTextEncodingMultiRun = 0x0FFF,
   kTextEncodingUnknown = 0xFFFF
};
Constants
kTextEncodingMultiRun

This is a special value for multiple encoded text, external run information.

Available in Mac OS X v10.0 and later.
kTextEncodingUnknown

Available in Mac OS X v10.0 and later.*/
enum {
   kTextEncodingMultiRun = 0x0FFF,
   kTextEncodingUnknown = 0xFFFF
};


#ifdef __cplusplus
}
#endif

#endif