#ifndef KPI_SOCKET_H
#define KPI_SOCKET_H
#endif

/*sflt_event_t

Events notify a filter of state changes and other various events related to the socket. These events can not be prevented or intercepted, only observed. 
enum { 
    sock_evt_connecting = 1, 
    sock_evt_connected = 2, 
    sock_evt_disconnecting = 3, 
    sock_evt_disconnected = 4, 
    sock_evt_flush_read = 5, 
    sock_evt_shutdown = 6, //param points to an integer specifying how (read, write, or both) see man 2 shutdown 
    sock_evt_cantrecvmore = 7, 
    sock_evt_cantsendmore = 8, 
    sock_evt_closing = 9 
};  
Constants
sock_evt_connected
Indicates this socket has moved to the connected state.
sock_evt_disconnected
Indicates this socket has moved to the disconnected state.
sock_evt_flush_read
The read socket buffer has been flushed.
sock_evt_shutdown
The read and or write side(s) of the connection have been shutdown. The param will point to an integer that indicates the direction that has been shutdown. See 'man 2 shutdown' for more information.
sock_evt_cantrecvmore
Indicates the socket can not receive more data.
sock_evt_cantsendmore
Indicates the socket can not send more data.
sock_evt_closing
Indicates the socket is closing.*/
enum { 
    sock_evt_connecting = 1, 
    sock_evt_connected = 2, 
    sock_evt_disconnecting = 3, 
    sock_evt_disconnected = 4, 
    sock_evt_flush_read = 5, 
    sock_evt_shutdown = 6, /* param points to an integer specifying how (read, write, or both) see man 2 shutdown */
    sock_evt_cantrecvmore = 7, 
    sock_evt_cantsendmore = 8, 
    sock_evt_closing = 9 
};  