#ifndef OC_CFBASE_H
#define OC_CFBASE_H
#endif
/*CFPropertyListRef

A reference to a CFPropertyList object.

typedef CFTypeRef CFPropertyListRef;
Discussion

This is an abstract type for property list objects. The return value of the CFPropertyListCreateFromXMLData function depends on the contents of the given XML data. CFPropertyListRef can be a reference to any of the property list objects: CFData, CFString, CFArray, CFDictionary, CFDate, CFBoolean, and CFNumber. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef CFTypeRef CFPropertyListRef;

/*Constants
Predefined Allocators

CFAllocator provides the following predefined allocators. In general, you should use kCFAllocatorDefault unless one of the special circumstances exist below.

const CFAllocatorRef kCFAllocatorDefault;
const CFAllocatorRef kCFAllocatorSystemDefault;
const CFAllocatorRef kCFAllocatorMalloc;
const CFAllocatorRef kCFAllocatorMallocZone;
const CFAllocatorRef kCFAllocatorNull;
const CFAllocatorRef kCFAllocatorUseContext;
Constants
kCFAllocatorDefault

This is a synonym for NULL. 

Available in Mac OS X v10.0 and later.
kCFAllocatorSystemDefault

Default system allocator.

You rarely need to use this.

Available in Mac OS X v10.0 and later.
kCFAllocatorMalloc

This allocator uses malloc(), realloc(), and free(). 

Typically you should not use this allocator, use kCFAllocatorDefault instead. This allocator is useful as the bytesDeallocator in CFData or contentsDeallocator in CFString where the memory was obtained as a result of malloc type functions.

Available in Mac OS X v10.0 and later.
kCFAllocatorMallocZone

This allocator explicitly uses the default malloc zone, returned by malloc_default_zone().

You should only use this when an object is safe to be allocated in non-scanned memory.

Available in Mac OS X v10.4 and later.
kCFAllocatorNull

This allocator does nothing?it allocates no memory. 

This allocator is useful as the bytesDeallocator in CFData or contentsDeallocator in CFString where the memory should not be freed.

Available in Mac OS X v10.0 and later.
kCFAllocatorUseContext

Special allocator argument to CFAllocatorCreate?it uses the functions given in the context to allocate the allocator.

Available in Mac OS X v10.0 and later.
Declared In
CFBase.h*/
const CFAllocatorRef kCFAllocatorDefault;
const CFAllocatorRef kCFAllocatorSystemDefault;
const CFAllocatorRef kCFAllocatorMalloc;
const CFAllocatorRef kCFAllocatorMallocZone;
const CFAllocatorRef kCFAllocatorNull;
const CFAllocatorRef kCFAllocatorUseContext;


/*CFAllocatorRetainCallBack

A prototype for a function callback that retains the given data.

typedef const void *(*CFAllocatorRetainCallBack) (
   const void *info
);

If you name your function MyCallBack, you would declare it like this:

const void *MyCallBack (
   const void *info
);
Parameters
info

The data to be retained.
Discussion

A prototype for a function callback that retains the data pointed to by the info field. In implementing this function, retain the data you have defined for the allocator context in this field. (This might make sense only if the data is a Core Foundation object.)*/
typedef const void *(*CFAllocatorRetainCallBack) (
   const void *info);


/*CFAllocatorReleaseCallBack

A prototype for a function callback that releases the given data.

typedef void (*CFAllocatorReleaseCallBack) (
   const void *info
);

If you name your function MyCallBack, you would declare it like this:

void MyCallBack (
   const void *info
);
Parameters
info

The data to be released.
Discussion

A prototype for a function callback that releases the data pointed to by the info field. In implementing this function, release (or free) the data you have defined for the allocator context.*/
typedef void (*CFAllocatorReleaseCallBack) (
   const void *info
);

